import { FeaturedPackages, PackageLinkConfig } from '.';
import { PackageTagConfig } from '../package-tag';
interface WebappConfigProps {
    /**
     * Configuration for custom package page links.
     */
    readonly packageLinks?: PackageLinkConfig[];
    /**
     * Configuration for custom computed tags.
     */
    readonly packageTags?: PackageTagConfig[];
    /**
     * Configuration for packages to feature on the home page.
     * @default - Display the 10 most recently updated packages
     */
    readonly featuredPackages?: FeaturedPackages;
}
export declare class WebappConfig {
    private readonly props;
    readonly path: string;
    readonly dir: string;
    constructor(props: WebappConfigProps);
    private get frontendConfig();
    private get packageLinks();
    private get packageTags();
    private get featuredPackages();
}
export {};
