# pylint: disable=too-many-lines
COMPILED_ACCOUNT_CONTRACT = r"""
{
    "abi": [
        {
            "inputs": [],
            "name": "assert_only_self",
            "outputs": [],
            "stateMutability": "view",
            "type": "function"
        },
        {
            "inputs": [],
            "name": "get_public_key",
            "outputs": [
                {
                    "name": "res",
                    "type": "felt"
                }
            ],
            "stateMutability": "view",
            "type": "function"
        },
        {
            "inputs": [],
            "name": "get_nonce",
            "outputs": [
                {
                    "name": "res",
                    "type": "felt"
                }
            ],
            "stateMutability": "view",
            "type": "function"
        },
        {
            "inputs": [
                {
                    "name": "new_public_key",
                    "type": "felt"
                }
            ],
            "name": "set_public_key",
            "outputs": [],
            "type": "function"
        },
        {
            "inputs": [
                {
                    "name": "_public_key",
                    "type": "felt"
                }
            ],
            "name": "constructor",
            "outputs": [],
            "type": "constructor"
        },
        {
            "inputs": [
                {
                    "name": "hash",
                    "type": "felt"
                },
                {
                    "name": "signature_len",
                    "type": "felt"
                },
                {
                    "name": "signature",
                    "type": "felt*"
                }
            ],
            "name": "is_valid_signature",
            "outputs": [],
            "stateMutability": "view",
            "type": "function"
        },
        {
            "inputs": [
                {
                    "name": "to",
                    "type": "felt"
                },
                {
                    "name": "selector",
                    "type": "felt"
                },
                {
                    "name": "calldata_len",
                    "type": "felt"
                },
                {
                    "name": "calldata",
                    "type": "felt*"
                },
                {
                    "name": "nonce",
                    "type": "felt"
                }
            ],
            "name": "execute",
            "outputs": [
                {
                    "name": "response_len",
                    "type": "felt"
                },
                {
                    "name": "response",
                    "type": "felt*"
                }
            ],
            "type": "function"
        }
    ],
    "entry_points_by_type": {
        "CONSTRUCTOR": [
            {
                "offset": "0x14e",
                "selector": "0x28ffe4ff0f226a9107253e17a904099aa4f63a02a5621de0576e5aa71bc5194"
            }
        ],
        "EXTERNAL": [
            {
                "offset": "0xfc",
                "selector": "0x1a35984e05126dbecb7c3bb9929e7dd9106d460c59b1633739a5c733a5fb13b"
            },
            {
                "offset": "0x11b",
                "selector": "0x1ac47721ee58ba2813c2a816bca188512839a00d3970f67c05eab986b14006d"
            },
            {
                "offset": "0x1de",
                "selector": "0x240060cdb34fcc260f41eac7474ee1d7c80b7e3607daff9ac67c7ea2ebb1c44"
            },
            {
                "offset": "0x172",
                "selector": "0x28420862938116cb3bbdbedee07451ccc54d4e9412dbef71142ad1980a30941"
            },
            {
                "offset": "0xdd",
                "selector": "0x2de154d8a89be65c1724e962dc4c65637c05532a6c2825d0a7b7d774169dbba"
            },
            {
                "offset": "0x134",
                "selector": "0x2e3e21ff5952b2531241e37999d9c4c8b3034cccc89a202a6bf019bdf5294f9"
            }
        ],
        "L1_HANDLER": []
    },
    "program": {
        "builtins": [
            "pedersen",
            "range_check",
            "ecdsa"
        ],
        "data": [
            "0x400380007ffb7ffc",
            "0x400380017ffb7ffd",
            "0x482680017ffb8000",
            "0x3",
            "0x480280027ffb8000",
            "0x208b7fff7fff7ffe",
            "0x20780017fff7ffd",
            "0x3",
            "0x208b7fff7fff7ffe",
            "0x480a7ffb7fff8000",
            "0x480a7ffc7fff8000",
            "0x480080007fff8000",
            "0x400080007ffd7fff",
            "0x482480017ffd8001",
            "0x1",
            "0x482480017ffd8001",
            "0x1",
            "0xa0680017fff7ffe",
            "0x800000000000010fffffffffffffffffffffffffffffffffffffffffffffffb",
            "0x402a7ffc7ffd7fff",
            "0x208b7fff7fff7ffe",
            "0x480680017fff8000",
            "0x43616c6c436f6e7472616374",
            "0x400280007ff97fff",
            "0x400380017ff97ffa",
            "0x400380027ff97ffb",
            "0x400380037ff97ffc",
            "0x400380047ff97ffd",
            "0x482680017ff98000",
            "0x7",
            "0x480280057ff98000",
            "0x480280067ff98000",
            "0x208b7fff7fff7ffe",
            "0x480680017fff8000",
            "0x47657443616c6c657241646472657373",
            "0x400280007ffd7fff",
            "0x482680017ffd8000",
            "0x2",
            "0x480280017ffd8000",
            "0x208b7fff7fff7ffe",
            "0x480680017fff8000",
            "0x476574436f6e747261637441646472657373",
            "0x400280007ffd7fff",
            "0x482680017ffd8000",
            "0x2",
            "0x480280017ffd8000",
            "0x208b7fff7fff7ffe",
            "0x480680017fff8000",
            "0x47657454785369676e6174757265",
            "0x400280007ffd7fff",
            "0x482680017ffd8000",
            "0x3",
            "0x480280017ffd8000",
            "0x480280027ffd8000",
            "0x208b7fff7fff7ffe",
            "0x480680017fff8000",
            "0x53746f7261676552656164",
            "0x400280007ffc7fff",
            "0x400380017ffc7ffd",
            "0x482680017ffc8000",
            "0x3",
            "0x480280027ffc8000",
            "0x208b7fff7fff7ffe",
            "0x480680017fff8000",
            "0x53746f726167655772697465",
            "0x400280007ffb7fff",
            "0x400380017ffb7ffc",
            "0x400380027ffb7ffd",
            "0x482680017ffb8000",
            "0x3",
            "0x208b7fff7fff7ffe",
            "0x208b7fff7fff7ffe",
            "0x400380017ff97ffa",
            "0x400380007ff97ffb",
            "0x482680017ff98000",
            "0x2",
            "0x208b7fff7fff7ffe",
            "0x40780017fff7fff",
            "0x2",
            "0x1104800180018000",
            "0x800000000000010fffffffffffffffffffffffffffffffffffffffffffffff9",
            "0x400780017fff8000",
            "0x0",
            "0x400780017fff8001",
            "0x0",
            "0x48127ffe7fff8000",
            "0x208b7fff7fff7ffe",
            "0x20780017fff7ffc",
            "0x5",
            "0x480a7ffa7fff8000",
            "0x480a7ffd7fff8000",
            "0x208b7fff7fff7ffe",
            "0x40780017fff7fff",
            "0x1",
            "0x482680017ffc8000",
            "0x800000000000011000000000000000000000000000000000000000000000000",
            "0x40337fff7ffb8000",
            "0x480a7ffb7fff8000",
            "0x480a7ffa7fff8000",
            "0x480a7ffd7fff8000",
            "0x48317ffd80008000",
            "0x400080007ffd7ffe",
            "0x480080007ffc8000",
            "0x400080017ffc7fff",
            "0x482480017ffb8000",
            "0x1",
            "0x482480017ffb8000",
            "0x3",
            "0x480080027ffa8000",
            "0x20680017fff7ffb",
            "0x800000000000010fffffffffffffffffffffffffffffffffffffffffffffff8",
            "0x208b7fff7fff7ffe",
            "0x40780017fff7fff",
            "0x2",
            "0x480a7ffa7fff8000",
            "0x480a7ffc7fff8000",
            "0x480a7ffd7fff8000",
            "0x480280007ffb8000",
            "0x1104800180018000",
            "0x800000000000010ffffffffffffffffffffffffffffffffffffffffffffffe2",
            "0x1104800180018000",
            "0x800000000000010ffffffffffffffffffffffffffffffffffffffffffffffd0",
            "0x40137ffd7fff8000",
            "0x480280017ffb8000",
            "0x40297ffd7fff8001",
            "0x48127ffb7fff8000",
            "0x48127ffc7fff8000",
            "0x208b7fff7fff7ffe",
            "0x40780017fff7fff",
            "0x2",
            "0x480a7ffb7fff8000",
            "0x480280007ffc8000",
            "0x480a7ffd7fff8000",
            "0x1104800180018000",
            "0x800000000000010ffffffffffffffffffffffffffffffffffffffffffffff7c",
            "0x1104800180018000",
            "0x800000000000010ffffffffffffffffffffffffffffffffffffffffffffffc1",
            "0x40137ffd7fff8000",
            "0x480280017ffc8000",
            "0x402580017fff8001",
            "0x1",
            "0x48127ffb7fff8000",
            "0x48127ffc7fff8000",
            "0x208b7fff7fff7ffe",
            "0x480a7ffc7fff8000",
            "0x480280007ffd8000",
            "0x480280017ffd8000",
            "0x1104800180018000",
            "0x800000000000010ffffffffffffffffffffffffffffffffffffffffffffff6e",
            "0x208b7fff7fff7ffe",
            "0x480a7ffc7fff8000",
            "0x480a7ffd7fff8000",
            "0x480680017fff8000",
            "0x27ae98c4d8558d514da5e6b3eca8e93ec139ddc1388d4e2e80684a991eb4452",
            "0x208b7fff7fff7ffe",
            "0x480a7ffc7fff8000",
            "0x480a7ffd7fff8000",
            "0x1104800180018000",
            "0x800000000000010fffffffffffffffffffffffffffffffffffffffffffffffa",
            "0x480a7ffb7fff8000",
            "0x48127ffe7fff8000",
            "0x1104800180018000",
            "0x800000000000010ffffffffffffffffffffffffffffffffffffffffffffff97",
            "0x48127ffe7fff8000",
            "0x48127ff57fff8000",
            "0x48127ff57fff8000",
            "0x48127ffc7fff8000",
            "0x208b7fff7fff7ffe",
            "0x480a7ffb7fff8000",
            "0x480a7ffc7fff8000",
            "0x1104800180018000",
            "0x800000000000010ffffffffffffffffffffffffffffffffffffffffffffffed",
            "0x480a7ffa7fff8000",
            "0x48127ffe7fff8000",
            "0x480a7ffd7fff8000",
            "0x1104800180018000",
            "0x800000000000010ffffffffffffffffffffffffffffffffffffffffffffff91",
            "0x48127ff67fff8000",
            "0x48127ff67fff8000",
            "0x208b7fff7fff7ffe",
            "0x480a7ffc7fff8000",
            "0x480a7ffd7fff8000",
            "0x480680017fff8000",
            "0x3b28019ccfdbd30ffc65951d94bb85c9e2b8434111a000b5afd533ce65f57a4",
            "0x208b7fff7fff7ffe",
            "0x480a7ffc7fff8000",
            "0x480a7ffd7fff8000",
            "0x1104800180018000",
            "0x800000000000010fffffffffffffffffffffffffffffffffffffffffffffffa",
            "0x480a7ffb7fff8000",
            "0x48127ffe7fff8000",
            "0x1104800180018000",
            "0x800000000000010ffffffffffffffffffffffffffffffffffffffffffffff79",
            "0x48127ffe7fff8000",
            "0x48127ff57fff8000",
            "0x48127ff57fff8000",
            "0x48127ffc7fff8000",
            "0x208b7fff7fff7ffe",
            "0x480a7ffb7fff8000",
            "0x480a7ffc7fff8000",
            "0x1104800180018000",
            "0x800000000000010ffffffffffffffffffffffffffffffffffffffffffffffed",
            "0x480a7ffa7fff8000",
            "0x48127ffe7fff8000",
            "0x480a7ffd7fff8000",
            "0x1104800180018000",
            "0x800000000000010ffffffffffffffffffffffffffffffffffffffffffffff73",
            "0x48127ff67fff8000",
            "0x48127ff67fff8000",
            "0x208b7fff7fff7ffe",
            "0x480a7ffb7fff8000",
            "0x1104800180018000",
            "0x800000000000010ffffffffffffffffffffffffffffffffffffffffffffff56",
            "0x48127ffe7fff8000",
            "0x1104800180018000",
            "0x800000000000010ffffffffffffffffffffffffffffffffffffffffffffff4c",
            "0x40127fff7fff7ff9",
            "0x48127ffe7fff8000",
            "0x480a7ffc7fff8000",
            "0x480a7ffd7fff8000",
            "0x208b7fff7fff7ffe",
            "0x402b7ffd7ffc7ffd",
            "0x480280007ffb8000",
            "0x480280017ffb8000",
            "0x480280027ffb8000",
            "0x1104800180018000",
            "0x800000000000010fffffffffffffffffffffffffffffffffffffffffffffff2",
            "0x40780017fff7fff",
            "0x1",
            "0x48127ffc7fff8000",
            "0x48127ffc7fff8000",
            "0x48127ffc7fff8000",
            "0x480280037ffb8000",
            "0x480680017fff8000",
            "0x0",
            "0x48127ffa7fff8000",
            "0x208b7fff7fff7ffe",
            "0x480a7ffb7fff8000",
            "0x480a7ffc7fff8000",
            "0x480a7ffd7fff8000",
            "0x1104800180018000",
            "0x800000000000010ffffffffffffffffffffffffffffffffffffffffffffffca",
            "0x208b7fff7fff7ffe",
            "0x40780017fff7fff",
            "0x1",
            "0x4003800080007ffc",
            "0x4826800180008000",
            "0x1",
            "0x480a7ffd7fff8000",
            "0x4828800080007ffe",
            "0x480a80007fff8000",
            "0x208b7fff7fff7ffe",
            "0x402b7ffd7ffc7ffd",
            "0x480280007ffb8000",
            "0x480280017ffb8000",
            "0x480280027ffb8000",
            "0x1104800180018000",
            "0x800000000000010ffffffffffffffffffffffffffffffffffffffffffffffee",
            "0x48127ffe7fff8000",
            "0x1104800180018000",
            "0x800000000000010fffffffffffffffffffffffffffffffffffffffffffffff1",
            "0x48127ff47fff8000",
            "0x48127ff47fff8000",
            "0x48127ffb7fff8000",
            "0x480280037ffb8000",
            "0x48127ffa7fff8000",
            "0x48127ffa7fff8000",
            "0x208b7fff7fff7ffe",
            "0x480a7ffb7fff8000",
            "0x480a7ffc7fff8000",
            "0x480a7ffd7fff8000",
            "0x1104800180018000",
            "0x800000000000010ffffffffffffffffffffffffffffffffffffffffffffff8d",
            "0x208b7fff7fff7ffe",
            "0x40780017fff7fff",
            "0x1",
            "0x4003800080007ffc",
            "0x4826800180008000",
            "0x1",
            "0x480a7ffd7fff8000",
            "0x4828800080007ffe",
            "0x480a80007fff8000",
            "0x208b7fff7fff7ffe",
            "0x402b7ffd7ffc7ffd",
            "0x480280007ffb8000",
            "0x480280017ffb8000",
            "0x480280027ffb8000",
            "0x1104800180018000",
            "0x800000000000010ffffffffffffffffffffffffffffffffffffffffffffffee",
            "0x48127ffe7fff8000",
            "0x1104800180018000",
            "0x800000000000010fffffffffffffffffffffffffffffffffffffffffffffff1",
            "0x48127ff47fff8000",
            "0x48127ff47fff8000",
            "0x48127ffb7fff8000",
            "0x480280037ffb8000",
            "0x48127ffa7fff8000",
            "0x48127ffa7fff8000",
            "0x208b7fff7fff7ffe",
            "0x480a7ffa7fff8000",
            "0x480a7ffb7fff8000",
            "0x480a7ffc7fff8000",
            "0x1104800180018000",
            "0x800000000000010ffffffffffffffffffffffffffffffffffffffffffffffa5",
            "0x480a7ffd7fff8000",
            "0x1104800180018000",
            "0x800000000000010ffffffffffffffffffffffffffffffffffffffffffffff96",
            "0x208b7fff7fff7ffe",
            "0x482680017ffd8000",
            "0x1",
            "0x402a7ffd7ffc7fff",
            "0x480280007ffb8000",
            "0x480280017ffb8000",
            "0x480280027ffb8000",
            "0x480280007ffd8000",
            "0x1104800180018000",
            "0x800000000000010fffffffffffffffffffffffffffffffffffffffffffffff1",
            "0x40780017fff7fff",
            "0x1",
            "0x48127ffc7fff8000",
            "0x48127ffc7fff8000",
            "0x48127ffc7fff8000",
            "0x480280037ffb8000",
            "0x480680017fff8000",
            "0x0",
            "0x48127ffa7fff8000",
            "0x208b7fff7fff7ffe",
            "0x480a7ffa7fff8000",
            "0x480a7ffb7fff8000",
            "0x480a7ffc7fff8000",
            "0x480a7ffd7fff8000",
            "0x1104800180018000",
            "0x800000000000010ffffffffffffffffffffffffffffffffffffffffffffff7c",
            "0x208b7fff7fff7ffe",
            "0x482680017ffd8000",
            "0x1",
            "0x402a7ffd7ffc7fff",
            "0x480280007ffb8000",
            "0x480280017ffb8000",
            "0x480280027ffb8000",
            "0x480280007ffd8000",
            "0x1104800180018000",
            "0x800000000000010fffffffffffffffffffffffffffffffffffffffffffffff3",
            "0x40780017fff7fff",
            "0x1",
            "0x48127ffc7fff8000",
            "0x48127ffc7fff8000",
            "0x48127ffc7fff8000",
            "0x480280037ffb8000",
            "0x480680017fff8000",
            "0x0",
            "0x48127ffa7fff8000",
            "0x208b7fff7fff7ffe",
            "0x480a7ff77fff8000",
            "0x480a7ff87fff8000",
            "0x480a7ff97fff8000",
            "0x1104800180018000",
            "0x800000000000010ffffffffffffffffffffffffffffffffffffffffffffff56",
            "0x480a7ffa7fff8000",
            "0x480a7ffb7fff8000",
            "0x48127ffd7fff8000",
            "0x480280007ffd8000",
            "0x480280017ffd8000",
            "0x1104800180018000",
            "0x800000000000010fffffffffffffffffffffffffffffffffffffffffffffede",
            "0x48127ff47fff8000",
            "0x48127ff47fff8000",
            "0x48127ff47fff8000",
            "0x48127ffc7fff8000",
            "0x208b7fff7fff7ffe",
            "0x480280027ffb8000",
            "0x480280017ffd8000",
            "0x400080007ffe7fff",
            "0x482680017ffd8000",
            "0x2",
            "0x480280017ffd8000",
            "0x48307fff7ffe8000",
            "0x402a7ffd7ffc7fff",
            "0x480280027ffb8000",
            "0x480280007ffb8000",
            "0x480280017ffb8000",
            "0x482480017ffd8000",
            "0x1",
            "0x480280037ffb8000",
            "0x480280007ffd8000",
            "0x480280017ffd8000",
            "0x482680017ffd8000",
            "0x2",
            "0x1104800180018000",
            "0x800000000000010ffffffffffffffffffffffffffffffffffffffffffffffde",
            "0x40780017fff7fff",
            "0x1",
            "0x48127ffb7fff8000",
            "0x48127ffb7fff8000",
            "0x48127ffb7fff8000",
            "0x48127ffb7fff8000",
            "0x480680017fff8000",
            "0x0",
            "0x48127ffa7fff8000",
            "0x208b7fff7fff7ffe",
            "0x40780017fff7fff",
            "0x9",
            "0x1104800180018000",
            "0x800000000000010fffffffffffffffffffffffffffffffffffffffffffffeb6",
            "0x480a7ff57fff8000",
            "0x1104800180018000",
            "0x800000000000010fffffffffffffffffffffffffffffffffffffffffffffe94",
            "0x48127ffe7fff8000",
            "0x480a7ff67fff8000",
            "0x480a7ff77fff8000",
            "0x1104800180018000",
            "0x800000000000010ffffffffffffffffffffffffffffffffffffffffffffff02",
            "0x40137ffc7fff8000",
            "0x40137ffe7fff8001",
            "0x40137fff7fff8002",
            "0x40137fe87fff8003",
            "0x400b7ff97fff8004",
            "0x400b7ffa7fff8005",
            "0x400b7ffc7fff8006",
            "0x400b7ffb7fff8007",
            "0x400b80027fff8008",
            "0x48127ffd7fff8000",
            "0x482480017fe08000",
            "0x3",
            "0x1104800180018000",
            "0x5d",
            "0x480a80007fff8000",
            "0x1104800180018000",
            "0x800000000000010fffffffffffffffffffffffffffffffffffffffffffffe85",
            "0x48127ffd7fff8000",
            "0x48127ff67fff8000",
            "0x480a80017fff8000",
            "0x480a7ff87fff8000",
            "0x48127ff47fff8000",
            "0x48127ff97fff8000",
            "0x48127ff97fff8000",
            "0x1104800180018000",
            "0x800000000000010ffffffffffffffffffffffffffffffffffffffffffffffae",
            "0x48127ffc7fff8000",
            "0x48127ffc7fff8000",
            "0x48127ffc7fff8000",
            "0x4826800180028000",
            "0x1",
            "0x1104800180018000",
            "0x800000000000010fffffffffffffffffffffffffffffffffffffffffffffeee",
            "0x48127ffd7fff8000",
            "0x480a80047fff8000",
            "0x480a80057fff8000",
            "0x480a80077fff8000",
            "0x480a80067fff8000",
            "0x1104800180018000",
            "0x800000000000010fffffffffffffffffffffffffffffffffffffffffffffe54",
            "0x48127ffd7fff8000",
            "0x48127ff27fff8000",
            "0x48127ff27fff8000",
            "0x48127fdb7fff8000",
            "0x48127ffa7fff8000",
            "0x48127ffa7fff8000",
            "0x208b7fff7fff7ffe",
            "0x40780017fff7fff",
            "0x3",
            "0x4003800080007ffb",
            "0x400380007ffd7ffb",
            "0x402780017ffd8001",
            "0x1",
            "0x4826800180008000",
            "0x1",
            "0x40297ffb7fff8002",
            "0x4826800180008000",
            "0x1",
            "0x480a7ffc7fff8000",
            "0x480a7ffb7fff8000",
            "0x1104800180018000",
            "0x800000000000010fffffffffffffffffffffffffffffffffffffffffffffe2f",
            "0x480a80017fff8000",
            "0x4829800080008002",
            "0x480a80007fff8000",
            "0x208b7fff7fff7ffe",
            "0x40780017fff7fff",
            "0x3",
            "0x480280027ffb8000",
            "0x480280027ffd8000",
            "0x400080007ffe7fff",
            "0x482680017ffd8000",
            "0x3",
            "0x480280027ffd8000",
            "0x48307fff7ffe8000",
            "0x482480017fff8000",
            "0x1",
            "0x402a7ffd7ffc7fff",
            "0x480280027ffb8000",
            "0x480280007ffb8000",
            "0x480280017ffb8000",
            "0x482480017ffd8000",
            "0x1",
            "0x480280037ffb8000",
            "0x480280007ffd8000",
            "0x480280017ffd8000",
            "0x480280027ffd8000",
            "0x482680017ffd8000",
            "0x3",
            "0x480080007ff58000",
            "0x1104800180018000",
            "0x800000000000010ffffffffffffffffffffffffffffffffffffffffffffff9b",
            "0x40137ffa7fff8000",
            "0x40137ffb7fff8001",
            "0x40137ffd7fff8002",
            "0x48127ffc7fff8000",
            "0x1104800180018000",
            "0x800000000000010ffffffffffffffffffffffffffffffffffffffffffffffd0",
            "0x480a80007fff8000",
            "0x480a80017fff8000",
            "0x48127ffb7fff8000",
            "0x480a80027fff8000",
            "0x48127ffa7fff8000",
            "0x48127ffa7fff8000",
            "0x208b7fff7fff7ffe",
            "0x40780017fff7fff",
            "0x1",
            "0x480a7ffc7fff8000",
            "0x480280037ffd8000",
            "0x480280047ffd8000",
            "0x1104800180018000",
            "0x15",
            "0x40137fff7fff8000",
            "0x1104800180018000",
            "0x800000000000010fffffffffffffffffffffffffffffffffffffffffffffe41",
            "0x48127ff77fff8000",
            "0x48127ffe7fff8000",
            "0x480a7ffd7fff8000",
            "0x480680017fff8000",
            "0x3",
            "0x1104800180018000",
            "0x800000000000010fffffffffffffffffffffffffffffffffffffffffffffe5d",
            "0x480a80007fff8000",
            "0x1104800180018000",
            "0x800000000000010fffffffffffffffffffffffffffffffffffffffffffffe6a",
            "0x480280057ffd8000",
            "0x1104800180018000",
            "0x800000000000010fffffffffffffffffffffffffffffffffffffffffffffe67",
            "0x1104800180018000",
            "0x800000000000010fffffffffffffffffffffffffffffffffffffffffffffe75",
            "0x208b7fff7fff7ffe",
            "0x1104800180018000",
            "0x800000000000010fffffffffffffffffffffffffffffffffffffffffffffe2f",
            "0x480a7ffb7fff8000",
            "0x48127ffe7fff8000",
            "0x480a7ffc7fff8000",
            "0x480a7ffd7fff8000",
            "0x1104800180018000",
            "0x800000000000010fffffffffffffffffffffffffffffffffffffffffffffe4c",
            "0x1104800180018000",
            "0x800000000000010fffffffffffffffffffffffffffffffffffffffffffffe6a",
            "0x208b7fff7fff7ffe"
        ],
        "debug_info": {
            "file_contents": {
                "autogen/starknet/arg_processor/06313d17544ae0a726cb5f49e1a4e01b179575674de70c8b96f6415eb6af6751.cairo": "# Check that the length is non-negative.\nassert [range_check_ptr] = ret_struct.response_len\n# Store the updated range_check_ptr as a local variable to keep it available after\n# the memcpy.\nlocal range_check_ptr = range_check_ptr + 1\n# Keep a reference to __return_value_ptr.\nlet __return_value_ptr_copy = __return_value_ptr\n# Store the updated __return_value_ptr as a local variable to keep it available after\n# the memcpy.\nlocal __return_value_ptr : felt* = __return_value_ptr + ret_struct.response_len\nmemcpy(\n    dst=__return_value_ptr_copy,\n    src=ret_struct.response,\n    len=ret_struct.response_len)\n",
                "autogen/starknet/arg_processor/16776347bfc3c84718728a7d5c6c2189ac0c5f697db91093bdb9d32707f1b476.cairo": "let __calldata_arg_selector = [__calldata_ptr]\nlet __calldata_ptr = __calldata_ptr + 1\n",
                "autogen/starknet/arg_processor/29637b66643568891912d1ed3f5b810e37fc6dff63d2db9fba473c1883482e6f.cairo": "let __calldata_actual_size =  __calldata_ptr - cast([fp + (-3)], felt*)\n",
                "autogen/starknet/arg_processor/2af83e2ace09380d3be2e1d366c8649a74753b790c9d2b5e425bfdf350d70145.cairo": "let __calldata_arg_nonce = [__calldata_ptr]\nlet __calldata_ptr = __calldata_ptr + 1\n",
                "autogen/starknet/arg_processor/3a5adc2b761210c88af019248ae32895d5e6697c2735e5e269a958dec1e56757.cairo": "# Check that the length is non-negative.\nassert [range_check_ptr] = __calldata_arg_calldata_len\nlet range_check_ptr = range_check_ptr + 1\n# Create the reference.\nlet __calldata_arg_calldata : felt* = __calldata_ptr\n# Use 'tempvar' instead of 'let' to avoid repeating this computation for the\n# following arguments.\ntempvar __calldata_ptr = __calldata_ptr + __calldata_arg_calldata_len\n",
                "autogen/starknet/arg_processor/623ade4063ac6181a8cdf88ec6604929c149e47a08a1b21b110c028785e3e605.cairo": "let __calldata_arg__public_key = [__calldata_ptr]\nlet __calldata_ptr = __calldata_ptr + 1\n",
                "autogen/starknet/arg_processor/7f0b238f4e526821a97d8aaa2f9484df4b5bd00cbad10a761ae4225314096a56.cairo": "assert [fp + (-4)] = __calldata_actual_size\n",
                "autogen/starknet/arg_processor/8799496fe2567340f6719cfd30d7db5f6b8e7aa420ca97e3a3c3ccbdfbb2e674.cairo": "let __calldata_arg_calldata_len = [__calldata_ptr]\nlet __calldata_ptr = __calldata_ptr + 1\n",
                "autogen/starknet/arg_processor/8d4c1dc885709c513ebc771d5ec516bec73bfbebc85f9698bd98584aa2e83c63.cairo": "let __calldata_arg_to = [__calldata_ptr]\nlet __calldata_ptr = __calldata_ptr + 1\n",
                "autogen/starknet/arg_processor/8f57d6d152b155403dcead27a17163e42b24753da9c724f554705dcf260464c0.cairo": "assert [__return_value_ptr] = ret_struct.response_len\nlet __return_value_ptr = __return_value_ptr + 1\n",
                "autogen/starknet/arg_processor/960ed0835c5fa83e7fde73a3a03f5fd9272c9b63199927c6476a8754ae40c556.cairo": "let __calldata_arg_new_public_key = [__calldata_ptr]\nlet __calldata_ptr = __calldata_ptr + 1\n",
                "autogen/starknet/arg_processor/b0c1882c07641aba5f9360ee19386f3c652830833d32f5bd2eb569a388b39448.cairo": "# Check that the length is non-negative.\nassert [range_check_ptr] = __calldata_arg_signature_len\nlet range_check_ptr = range_check_ptr + 1\n# Create the reference.\nlet __calldata_arg_signature : felt* = __calldata_ptr\n# Use 'tempvar' instead of 'let' to avoid repeating this computation for the\n# following arguments.\ntempvar __calldata_ptr = __calldata_ptr + __calldata_arg_signature_len\n",
                "autogen/starknet/arg_processor/e1b7bcaf2f97aa307c8deca2578c63f05cf45d09bb1ecaaf9be0bb828fc5cb40.cairo": "let __calldata_arg_signature_len = [__calldata_ptr]\nlet __calldata_ptr = __calldata_ptr + 1\n",
                "autogen/starknet/arg_processor/f3c2d3942f0f75ba7fab7e0c13e6cee1d1be8a6d9e771412e1ff56c7484dd3f4.cairo": "let __calldata_arg_hash = [__calldata_ptr]\nlet __calldata_ptr = __calldata_ptr + 1\n",
                "autogen/starknet/arg_processor/fee896b6d05b2e98056b5628baa6fbee0adfb8960f3fee9d79fd2f066956cc42.cairo": "assert [__return_value_ptr] = ret_struct.res\nlet __return_value_ptr = __return_value_ptr + 1\n",
                "autogen/starknet/external/assert_only_self/65afca6042dd7c8a6e82d579494fa4fa955e0d1232b8c498dd8d1f04bd61bada.cairo": "let ret_struct = __wrapped_func{syscall_ptr=syscall_ptr, pedersen_ptr=pedersen_ptr, range_check_ptr=range_check_ptr}()\n%{ memory[ap] = segments.add() %}        # Allocate memory for return value.\ntempvar retdata : felt*\nlet retdata_size = 0\n",
                "autogen/starknet/external/assert_only_self/7998f829c4aa5ea19acd9325ec8f13445bd7eb3660e26c1acda6a694c86b221a.cairo": "let ecdsa_ptr = [cast([fp + (-5)] + 3, felt*)]\n",
                "autogen/starknet/external/assert_only_self/aa526043a8db9187624857305b1409f029aec9f9c85f47438b55e65b3afc0639.cairo": "return (syscall_ptr,pedersen_ptr,range_check_ptr,ecdsa_ptr,retdata_size,retdata)\n",
                "autogen/starknet/external/assert_only_self/bf54f65e3c6b81daf1c2b60a8cb4034b53ce30386ebc03b148a9de60d6f5dd57.cairo": "let pedersen_ptr = [cast([fp + (-5)] + 1, starkware.cairo.common.cairo_builtins.HashBuiltin**)]\n",
                "autogen/starknet/external/assert_only_self/d5f67cc7e69abbde284d945f017319bd8e156adfab63895c8d652f5c3e4f6c3a.cairo": "let range_check_ptr = [cast([fp + (-5)] + 2, felt*)]\n",
                "autogen/starknet/external/assert_only_self/f4a8893cfc7cc4f313b0c426fa25c38c6c57664957bc56a170a27945759c5102.cairo": "let syscall_ptr = [cast([fp + (-5)] + 0, felt**)]\n",
                "autogen/starknet/external/constructor/65962fce79fda3ae5aa5ff0f8d357fdb1de976f3ac253367909c1e8ffb6ad335.cairo": "let ret_struct = __wrapped_func{syscall_ptr=syscall_ptr, pedersen_ptr=pedersen_ptr, range_check_ptr=range_check_ptr}(_public_key=__calldata_arg__public_key,)\n%{ memory[ap] = segments.add() %}        # Allocate memory for return value.\ntempvar retdata : felt*\nlet retdata_size = 0\n",
                "autogen/starknet/external/constructor/7998f829c4aa5ea19acd9325ec8f13445bd7eb3660e26c1acda6a694c86b221a.cairo": "let ecdsa_ptr = [cast([fp + (-5)] + 3, felt*)]\n",
                "autogen/starknet/external/constructor/aa526043a8db9187624857305b1409f029aec9f9c85f47438b55e65b3afc0639.cairo": "return (syscall_ptr,pedersen_ptr,range_check_ptr,ecdsa_ptr,retdata_size,retdata)\n",
                "autogen/starknet/external/constructor/bf54f65e3c6b81daf1c2b60a8cb4034b53ce30386ebc03b148a9de60d6f5dd57.cairo": "let pedersen_ptr = [cast([fp + (-5)] + 1, starkware.cairo.common.cairo_builtins.HashBuiltin**)]\n",
                "autogen/starknet/external/constructor/d5f67cc7e69abbde284d945f017319bd8e156adfab63895c8d652f5c3e4f6c3a.cairo": "let range_check_ptr = [cast([fp + (-5)] + 2, felt*)]\n",
                "autogen/starknet/external/constructor/f4a8893cfc7cc4f313b0c426fa25c38c6c57664957bc56a170a27945759c5102.cairo": "let syscall_ptr = [cast([fp + (-5)] + 0, felt**)]\n",
                "autogen/starknet/external/execute/5fc167c3d8ad62579d6fff3348b16b5008843c3afd00129ecab00674256d9e3c.cairo": "let ecdsa_ptr = [cast([fp + (-5)] + 3, starkware.cairo.common.cairo_builtins.SignatureBuiltin**)]\n",
                "autogen/starknet/external/execute/7b6782e02f0a6a1a42e84a4f6f0a498e326f901c2cf55562c269e7172137f4b1.cairo": "let ret_struct = __wrapped_func{syscall_ptr=syscall_ptr, pedersen_ptr=pedersen_ptr, range_check_ptr=range_check_ptr, ecdsa_ptr=ecdsa_ptr}(to=__calldata_arg_to, selector=__calldata_arg_selector, calldata_len=__calldata_arg_calldata_len, calldata=__calldata_arg_calldata, nonce=__calldata_arg_nonce,)\nlet (range_check_ptr, retdata_size, retdata) = execute_encode_return(ret_struct, range_check_ptr)\n",
                "autogen/starknet/external/execute/9c7747fade26cf80efb5a8359f2fcb7685a792f19823051be7230b49471d1855.cairo": "func execute() -> (syscall_ptr : felt*, pedersen_ptr : starkware.cairo.common.cairo_builtins.HashBuiltin*, range_check_ptr : felt, ecdsa_ptr : starkware.cairo.common.cairo_builtins.SignatureBuiltin*, size, retdata : felt*):\n    alloc_locals\nend\n",
                "autogen/starknet/external/execute/aa526043a8db9187624857305b1409f029aec9f9c85f47438b55e65b3afc0639.cairo": "return (syscall_ptr,pedersen_ptr,range_check_ptr,ecdsa_ptr,retdata_size,retdata)\n",
                "autogen/starknet/external/execute/bf54f65e3c6b81daf1c2b60a8cb4034b53ce30386ebc03b148a9de60d6f5dd57.cairo": "let pedersen_ptr = [cast([fp + (-5)] + 1, starkware.cairo.common.cairo_builtins.HashBuiltin**)]\n",
                "autogen/starknet/external/execute/d5f67cc7e69abbde284d945f017319bd8e156adfab63895c8d652f5c3e4f6c3a.cairo": "let range_check_ptr = [cast([fp + (-5)] + 2, felt*)]\n",
                "autogen/starknet/external/execute/f4a8893cfc7cc4f313b0c426fa25c38c6c57664957bc56a170a27945759c5102.cairo": "let syscall_ptr = [cast([fp + (-5)] + 0, felt**)]\n",
                "autogen/starknet/external/get_nonce/7998f829c4aa5ea19acd9325ec8f13445bd7eb3660e26c1acda6a694c86b221a.cairo": "let ecdsa_ptr = [cast([fp + (-5)] + 3, felt*)]\n",
                "autogen/starknet/external/get_nonce/a346d877d422c1aceb29d6c4893476b7e7d7c8e9bd59d8ccc775b8622116dd2a.cairo": "let ret_struct = __wrapped_func{syscall_ptr=syscall_ptr, pedersen_ptr=pedersen_ptr, range_check_ptr=range_check_ptr}()\nlet (range_check_ptr, retdata_size, retdata) = get_nonce_encode_return(ret_struct, range_check_ptr)\n",
                "autogen/starknet/external/get_nonce/aa526043a8db9187624857305b1409f029aec9f9c85f47438b55e65b3afc0639.cairo": "return (syscall_ptr,pedersen_ptr,range_check_ptr,ecdsa_ptr,retdata_size,retdata)\n",
                "autogen/starknet/external/get_nonce/bf54f65e3c6b81daf1c2b60a8cb4034b53ce30386ebc03b148a9de60d6f5dd57.cairo": "let pedersen_ptr = [cast([fp + (-5)] + 1, starkware.cairo.common.cairo_builtins.HashBuiltin**)]\n",
                "autogen/starknet/external/get_nonce/d5f67cc7e69abbde284d945f017319bd8e156adfab63895c8d652f5c3e4f6c3a.cairo": "let range_check_ptr = [cast([fp + (-5)] + 2, felt*)]\n",
                "autogen/starknet/external/get_nonce/f4a8893cfc7cc4f313b0c426fa25c38c6c57664957bc56a170a27945759c5102.cairo": "let syscall_ptr = [cast([fp + (-5)] + 0, felt**)]\n",
                "autogen/starknet/external/get_public_key/7998f829c4aa5ea19acd9325ec8f13445bd7eb3660e26c1acda6a694c86b221a.cairo": "let ecdsa_ptr = [cast([fp + (-5)] + 3, felt*)]\n",
                "autogen/starknet/external/get_public_key/aa526043a8db9187624857305b1409f029aec9f9c85f47438b55e65b3afc0639.cairo": "return (syscall_ptr,pedersen_ptr,range_check_ptr,ecdsa_ptr,retdata_size,retdata)\n",
                "autogen/starknet/external/get_public_key/b2849ba7bb077663e4b038ad05edb036eedd0d3d2d173b73abde9848684cee47.cairo": "let ret_struct = __wrapped_func{syscall_ptr=syscall_ptr, pedersen_ptr=pedersen_ptr, range_check_ptr=range_check_ptr}()\nlet (range_check_ptr, retdata_size, retdata) = get_public_key_encode_return(ret_struct, range_check_ptr)\n",
                "autogen/starknet/external/get_public_key/bf54f65e3c6b81daf1c2b60a8cb4034b53ce30386ebc03b148a9de60d6f5dd57.cairo": "let pedersen_ptr = [cast([fp + (-5)] + 1, starkware.cairo.common.cairo_builtins.HashBuiltin**)]\n",
                "autogen/starknet/external/get_public_key/d5f67cc7e69abbde284d945f017319bd8e156adfab63895c8d652f5c3e4f6c3a.cairo": "let range_check_ptr = [cast([fp + (-5)] + 2, felt*)]\n",
                "autogen/starknet/external/get_public_key/f4a8893cfc7cc4f313b0c426fa25c38c6c57664957bc56a170a27945759c5102.cairo": "let syscall_ptr = [cast([fp + (-5)] + 0, felt**)]\n",
                "autogen/starknet/external/is_valid_signature/5fc167c3d8ad62579d6fff3348b16b5008843c3afd00129ecab00674256d9e3c.cairo": "let ecdsa_ptr = [cast([fp + (-5)] + 3, starkware.cairo.common.cairo_builtins.SignatureBuiltin**)]\n",
                "autogen/starknet/external/is_valid_signature/a4577150f3039c0db885ccde32bb0d5a5b36850e59d8cf7d9c3472ad9a641767.cairo": "let ret_struct = __wrapped_func{syscall_ptr=syscall_ptr, pedersen_ptr=pedersen_ptr, range_check_ptr=range_check_ptr, ecdsa_ptr=ecdsa_ptr}(hash=__calldata_arg_hash, signature_len=__calldata_arg_signature_len, signature=__calldata_arg_signature,)\n%{ memory[ap] = segments.add() %}        # Allocate memory for return value.\ntempvar retdata : felt*\nlet retdata_size = 0\n",
                "autogen/starknet/external/is_valid_signature/aa526043a8db9187624857305b1409f029aec9f9c85f47438b55e65b3afc0639.cairo": "return (syscall_ptr,pedersen_ptr,range_check_ptr,ecdsa_ptr,retdata_size,retdata)\n",
                "autogen/starknet/external/is_valid_signature/bf54f65e3c6b81daf1c2b60a8cb4034b53ce30386ebc03b148a9de60d6f5dd57.cairo": "let pedersen_ptr = [cast([fp + (-5)] + 1, starkware.cairo.common.cairo_builtins.HashBuiltin**)]\n",
                "autogen/starknet/external/is_valid_signature/d5f67cc7e69abbde284d945f017319bd8e156adfab63895c8d652f5c3e4f6c3a.cairo": "let range_check_ptr = [cast([fp + (-5)] + 2, felt*)]\n",
                "autogen/starknet/external/is_valid_signature/f4a8893cfc7cc4f313b0c426fa25c38c6c57664957bc56a170a27945759c5102.cairo": "let syscall_ptr = [cast([fp + (-5)] + 0, felt**)]\n",
                "autogen/starknet/external/return/execute/a4f5dca2b4579e4581f985d9d59e09604642fde51b45dacead712101cac75905.cairo": "func execute_encode_return(ret_struct : __main__.execute.Return, range_check_ptr) -> (\n        range_check_ptr, data_len : felt, data : felt*):\n    %{ memory[ap] = segments.add() %}\n    alloc_locals\n    local __return_value_ptr_start : felt*\n    let __return_value_ptr = __return_value_ptr_start\n    with range_check_ptr:\n    end\n    return (\n        range_check_ptr=range_check_ptr,\n        data_len=__return_value_ptr - __return_value_ptr_start,\n        data=__return_value_ptr_start)\nend\n",
                "autogen/starknet/external/return/get_nonce/b599da7e0616f5b52a9be2e1921aad249a1f0772086f536420e6a3635525f534.cairo": "func get_nonce_encode_return(ret_struct : __main__.get_nonce.Return, range_check_ptr) -> (\n        range_check_ptr, data_len : felt, data : felt*):\n    %{ memory[ap] = segments.add() %}\n    alloc_locals\n    local __return_value_ptr_start : felt*\n    let __return_value_ptr = __return_value_ptr_start\n    with range_check_ptr:\n    end\n    return (\n        range_check_ptr=range_check_ptr,\n        data_len=__return_value_ptr - __return_value_ptr_start,\n        data=__return_value_ptr_start)\nend\n",
                "autogen/starknet/external/return/get_public_key/9605add8cf53f954532130fb37e8434c6f1dc820b83f0220783d7316e2c52b0f.cairo": "func get_public_key_encode_return(ret_struct : __main__.get_public_key.Return, range_check_ptr) -> (\n        range_check_ptr, data_len : felt, data : felt*):\n    %{ memory[ap] = segments.add() %}\n    alloc_locals\n    local __return_value_ptr_start : felt*\n    let __return_value_ptr = __return_value_ptr_start\n    with range_check_ptr:\n    end\n    return (\n        range_check_ptr=range_check_ptr,\n        data_len=__return_value_ptr - __return_value_ptr_start,\n        data=__return_value_ptr_start)\nend\n",
                "autogen/starknet/external/set_public_key/7998f829c4aa5ea19acd9325ec8f13445bd7eb3660e26c1acda6a694c86b221a.cairo": "let ecdsa_ptr = [cast([fp + (-5)] + 3, felt*)]\n",
                "autogen/starknet/external/set_public_key/9d99191ee37b2755f349e9328582aaabeba3fa369cacff177a5b80144e6ec2c7.cairo": "let ret_struct = __wrapped_func{syscall_ptr=syscall_ptr, pedersen_ptr=pedersen_ptr, range_check_ptr=range_check_ptr}(new_public_key=__calldata_arg_new_public_key,)\n%{ memory[ap] = segments.add() %}        # Allocate memory for return value.\ntempvar retdata : felt*\nlet retdata_size = 0\n",
                "autogen/starknet/external/set_public_key/aa526043a8db9187624857305b1409f029aec9f9c85f47438b55e65b3afc0639.cairo": "return (syscall_ptr,pedersen_ptr,range_check_ptr,ecdsa_ptr,retdata_size,retdata)\n",
                "autogen/starknet/external/set_public_key/bf54f65e3c6b81daf1c2b60a8cb4034b53ce30386ebc03b148a9de60d6f5dd57.cairo": "let pedersen_ptr = [cast([fp + (-5)] + 1, starkware.cairo.common.cairo_builtins.HashBuiltin**)]\n",
                "autogen/starknet/external/set_public_key/d5f67cc7e69abbde284d945f017319bd8e156adfab63895c8d652f5c3e4f6c3a.cairo": "let range_check_ptr = [cast([fp + (-5)] + 2, felt*)]\n",
                "autogen/starknet/external/set_public_key/f4a8893cfc7cc4f313b0c426fa25c38c6c57664957bc56a170a27945759c5102.cairo": "let syscall_ptr = [cast([fp + (-5)] + 0, felt**)]\n",
                "autogen/starknet/storage_var/current_nonce/decl.cairo": "namespace current_nonce:\n    from starkware.starknet.common.storage import normalize_address\n    from starkware.starknet.common.syscalls import storage_read, storage_write\n    from starkware.cairo.common.cairo_builtins import HashBuiltin\n    from starkware.cairo.common.hash import hash2\n\n    func addr{pedersen_ptr : HashBuiltin*, range_check_ptr}() -> (res : felt):\n        let res = 0\n        call hash2\n        call normalize_address\n    end\n\n    func read{syscall_ptr : felt*, pedersen_ptr : HashBuiltin*, range_check_ptr}() -> (res : felt):\n        let storage_addr = 0\n        call addr\n        call storage_read\n    end\n\n    func write{syscall_ptr : felt*, pedersen_ptr : HashBuiltin*, range_check_ptr}(value : felt):\n        let storage_addr = 0\n        call addr\n        call storage_write\n    end\nend",
                "autogen/starknet/storage_var/current_nonce/impl.cairo": "namespace current_nonce:\n    from starkware.starknet.common.storage import normalize_address\n    from starkware.starknet.common.syscalls import storage_read, storage_write\n    from starkware.cairo.common.cairo_builtins import HashBuiltin\n    from starkware.cairo.common.hash import hash2\n\n    func addr{pedersen_ptr : HashBuiltin*, range_check_ptr}() -> (res : felt):\n        let res = 1121792928524733500499566223253557009588599140926682212728477813437029368914\n        return (res=res)\n    end\n\n    func read{syscall_ptr : felt*, pedersen_ptr : HashBuiltin*, range_check_ptr}() -> (res : felt):\n        let (storage_addr) = addr()\n        let (__storage_var_temp0) = storage_read(address=storage_addr + 0)\n\n        tempvar syscall_ptr = syscall_ptr\n        tempvar pedersen_ptr = pedersen_ptr\n        tempvar range_check_ptr = range_check_ptr\n        tempvar __storage_var_temp0 : felt = __storage_var_temp0\n        return ([cast(&__storage_var_temp0, felt*)])\n    end\n\n    func write{syscall_ptr : felt*, pedersen_ptr : HashBuiltin*, range_check_ptr}(value : felt):\n        let (storage_addr) = addr()\n        storage_write(address=storage_addr + 0, value=[cast(&value, felt) + 0])\n        return ()\n    end\nend",
                "autogen/starknet/storage_var/public_key/decl.cairo": "namespace public_key:\n    from starkware.starknet.common.storage import normalize_address\n    from starkware.starknet.common.syscalls import storage_read, storage_write\n    from starkware.cairo.common.cairo_builtins import HashBuiltin\n    from starkware.cairo.common.hash import hash2\n\n    func addr{pedersen_ptr : HashBuiltin*, range_check_ptr}() -> (res : felt):\n        let res = 0\n        call hash2\n        call normalize_address\n    end\n\n    func read{syscall_ptr : felt*, pedersen_ptr : HashBuiltin*, range_check_ptr}() -> (res : felt):\n        let storage_addr = 0\n        call addr\n        call storage_read\n    end\n\n    func write{syscall_ptr : felt*, pedersen_ptr : HashBuiltin*, range_check_ptr}(value : felt):\n        let storage_addr = 0\n        call addr\n        call storage_write\n    end\nend",
                "autogen/starknet/storage_var/public_key/impl.cairo": "namespace public_key:\n    from starkware.starknet.common.storage import normalize_address\n    from starkware.starknet.common.syscalls import storage_read, storage_write\n    from starkware.cairo.common.cairo_builtins import HashBuiltin\n    from starkware.cairo.common.hash import hash2\n\n    func addr{pedersen_ptr : HashBuiltin*, range_check_ptr}() -> (res : felt):\n        let res = 1672321442399497129215646424919402195095307045612040218489019266998007191460\n        return (res=res)\n    end\n\n    func read{syscall_ptr : felt*, pedersen_ptr : HashBuiltin*, range_check_ptr}() -> (res : felt):\n        let (storage_addr) = addr()\n        let (__storage_var_temp0) = storage_read(address=storage_addr + 0)\n\n        tempvar syscall_ptr = syscall_ptr\n        tempvar pedersen_ptr = pedersen_ptr\n        tempvar range_check_ptr = range_check_ptr\n        tempvar __storage_var_temp0 : felt = __storage_var_temp0\n        return ([cast(&__storage_var_temp0, felt*)])\n    end\n\n    func write{syscall_ptr : felt*, pedersen_ptr : HashBuiltin*, range_check_ptr}(value : felt):\n        let (storage_addr) = addr()\n        storage_write(address=storage_addr + 0, value=[cast(&value, felt) + 0])\n        return ()\n    end\nend"
            },
            "instruction_locations": {
                "0": {
                    "accessible_scopes": [
                        "starkware.cairo.common.hash",
                        "starkware.cairo.common.hash.hash2"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 0,
                            "offset": 0
                        },
                        "reference_ids": {
                            "starkware.cairo.common.hash.hash2.hash_ptr": 2,
                            "starkware.cairo.common.hash.hash2.x": 0,
                            "starkware.cairo.common.hash.hash2.y": 1
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 19,
                        "end_line": 14,
                        "input_file": {
                            "filename": "/Users/jakubptak/Library/Caches/pypoetry/virtualenvs/starkware-python-sdk-L_CLq0Mm-py3.7/lib/python3.7/site-packages/starkware/cairo/common/hash.cairo"
                        },
                        "start_col": 5,
                        "start_line": 14
                    }
                },
                "1": {
                    "accessible_scopes": [
                        "starkware.cairo.common.hash",
                        "starkware.cairo.common.hash.hash2"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 0,
                            "offset": 0
                        },
                        "reference_ids": {
                            "starkware.cairo.common.hash.hash2.hash_ptr": 2,
                            "starkware.cairo.common.hash.hash2.x": 0,
                            "starkware.cairo.common.hash.hash2.y": 1
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 19,
                        "end_line": 15,
                        "input_file": {
                            "filename": "/Users/jakubptak/Library/Caches/pypoetry/virtualenvs/starkware-python-sdk-L_CLq0Mm-py3.7/lib/python3.7/site-packages/starkware/cairo/common/hash.cairo"
                        },
                        "start_col": 5,
                        "start_line": 15
                    }
                },
                "2": {
                    "accessible_scopes": [
                        "starkware.cairo.common.hash",
                        "starkware.cairo.common.hash.hash2"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 0,
                            "offset": 0
                        },
                        "reference_ids": {
                            "starkware.cairo.common.hash.hash2.hash_ptr": 4,
                            "starkware.cairo.common.hash.hash2.result": 3,
                            "starkware.cairo.common.hash.hash2.x": 0,
                            "starkware.cairo.common.hash.hash2.y": 1
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 47,
                        "end_line": 17,
                        "input_file": {
                            "filename": "/Users/jakubptak/Library/Caches/pypoetry/virtualenvs/starkware-python-sdk-L_CLq0Mm-py3.7/lib/python3.7/site-packages/starkware/cairo/common/hash.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 35,
                                "end_line": 13,
                                "input_file": {
                                    "filename": "/Users/jakubptak/Library/Caches/pypoetry/virtualenvs/starkware-python-sdk-L_CLq0Mm-py3.7/lib/python3.7/site-packages/starkware/cairo/common/hash.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 27,
                                        "end_line": 18,
                                        "input_file": {
                                            "filename": "/Users/jakubptak/Library/Caches/pypoetry/virtualenvs/starkware-python-sdk-L_CLq0Mm-py3.7/lib/python3.7/site-packages/starkware/cairo/common/hash.cairo"
                                        },
                                        "start_col": 5,
                                        "start_line": 18
                                    },
                                    "While trying to retrieve the implicit argument 'hash_ptr' in:"
                                ],
                                "start_col": 12,
                                "start_line": 13
                            },
                            "While expanding the reference 'hash_ptr' in:"
                        ],
                        "start_col": 20,
                        "start_line": 17
                    }
                },
                "4": {
                    "accessible_scopes": [
                        "starkware.cairo.common.hash",
                        "starkware.cairo.common.hash.hash2"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 0,
                            "offset": 1
                        },
                        "reference_ids": {
                            "starkware.cairo.common.hash.hash2.hash_ptr": 4,
                            "starkware.cairo.common.hash.hash2.result": 3,
                            "starkware.cairo.common.hash.hash2.x": 0,
                            "starkware.cairo.common.hash.hash2.y": 1
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 33,
                        "end_line": 16,
                        "input_file": {
                            "filename": "/Users/jakubptak/Library/Caches/pypoetry/virtualenvs/starkware-python-sdk-L_CLq0Mm-py3.7/lib/python3.7/site-packages/starkware/cairo/common/hash.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 26,
                                "end_line": 18,
                                "input_file": {
                                    "filename": "/Users/jakubptak/Library/Caches/pypoetry/virtualenvs/starkware-python-sdk-L_CLq0Mm-py3.7/lib/python3.7/site-packages/starkware/cairo/common/hash.cairo"
                                },
                                "start_col": 20,
                                "start_line": 18
                            },
                            "While expanding the reference 'result' in:"
                        ],
                        "start_col": 18,
                        "start_line": 16
                    }
                },
                "5": {
                    "accessible_scopes": [
                        "starkware.cairo.common.hash",
                        "starkware.cairo.common.hash.hash2"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 0,
                            "offset": 2
                        },
                        "reference_ids": {
                            "starkware.cairo.common.hash.hash2.hash_ptr": 4,
                            "starkware.cairo.common.hash.hash2.result": 3,
                            "starkware.cairo.common.hash.hash2.x": 0,
                            "starkware.cairo.common.hash.hash2.y": 1
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 27,
                        "end_line": 18,
                        "input_file": {
                            "filename": "/Users/jakubptak/Library/Caches/pypoetry/virtualenvs/starkware-python-sdk-L_CLq0Mm-py3.7/lib/python3.7/site-packages/starkware/cairo/common/hash.cairo"
                        },
                        "start_col": 5,
                        "start_line": 18
                    }
                },
                "6": {
                    "accessible_scopes": [
                        "starkware.cairo.common.memcpy",
                        "starkware.cairo.common.memcpy.memcpy"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 1,
                            "offset": 0
                        },
                        "reference_ids": {
                            "starkware.cairo.common.memcpy.memcpy.dst": 5,
                            "starkware.cairo.common.memcpy.memcpy.len": 7,
                            "starkware.cairo.common.memcpy.memcpy.src": 6
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 7,
                        "end_line": 8,
                        "input_file": {
                            "filename": "/Users/jakubptak/Library/Caches/pypoetry/virtualenvs/starkware-python-sdk-L_CLq0Mm-py3.7/lib/python3.7/site-packages/starkware/cairo/common/memcpy.cairo"
                        },
                        "start_col": 5,
                        "start_line": 8
                    }
                },
                "8": {
                    "accessible_scopes": [
                        "starkware.cairo.common.memcpy",
                        "starkware.cairo.common.memcpy.memcpy"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 1,
                            "offset": 0
                        },
                        "reference_ids": {
                            "starkware.cairo.common.memcpy.memcpy.dst": 5,
                            "starkware.cairo.common.memcpy.memcpy.len": 7,
                            "starkware.cairo.common.memcpy.memcpy.src": 6
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 18,
                        "end_line": 9,
                        "input_file": {
                            "filename": "/Users/jakubptak/Library/Caches/pypoetry/virtualenvs/starkware-python-sdk-L_CLq0Mm-py3.7/lib/python3.7/site-packages/starkware/cairo/common/memcpy.cairo"
                        },
                        "start_col": 9,
                        "start_line": 9
                    }
                },
                "9": {
                    "accessible_scopes": [
                        "starkware.cairo.common.memcpy",
                        "starkware.cairo.common.memcpy.memcpy"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 1,
                            "offset": 0
                        },
                        "reference_ids": {
                            "starkware.cairo.common.memcpy.memcpy.dst": 5,
                            "starkware.cairo.common.memcpy.memcpy.len": 7,
                            "starkware.cairo.common.memcpy.memcpy.src": 6
                        }
                    },
                    "hints": [
                        {
                            "location": {
                                "end_col": 41,
                                "end_line": 12,
                                "input_file": {
                                    "filename": "/Users/jakubptak/Library/Caches/pypoetry/virtualenvs/starkware-python-sdk-L_CLq0Mm-py3.7/lib/python3.7/site-packages/starkware/cairo/common/memcpy.cairo"
                                },
                                "start_col": 5,
                                "start_line": 12
                            },
                            "n_prefix_newlines": 0
                        }
                    ],
                    "inst": {
                        "end_col": 24,
                        "end_line": 2,
                        "input_file": {
                            "filename": "/Users/jakubptak/Library/Caches/pypoetry/virtualenvs/starkware-python-sdk-L_CLq0Mm-py3.7/lib/python3.7/site-packages/starkware/cairo/common/memcpy.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 38,
                                "end_line": 13,
                                "input_file": {
                                    "filename": "/Users/jakubptak/Library/Caches/pypoetry/virtualenvs/starkware-python-sdk-L_CLq0Mm-py3.7/lib/python3.7/site-packages/starkware/cairo/common/memcpy.cairo"
                                },
                                "start_col": 35,
                                "start_line": 13
                            },
                            "While expanding the reference 'dst' in:"
                        ],
                        "start_col": 13,
                        "start_line": 2
                    }
                },
                "10": {
                    "accessible_scopes": [
                        "starkware.cairo.common.memcpy",
                        "starkware.cairo.common.memcpy.memcpy"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 1,
                            "offset": 1
                        },
                        "reference_ids": {
                            "starkware.cairo.common.memcpy.memcpy.dst": 5,
                            "starkware.cairo.common.memcpy.memcpy.len": 7,
                            "starkware.cairo.common.memcpy.memcpy.src": 6
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 37,
                        "end_line": 2,
                        "input_file": {
                            "filename": "/Users/jakubptak/Library/Caches/pypoetry/virtualenvs/starkware-python-sdk-L_CLq0Mm-py3.7/lib/python3.7/site-packages/starkware/cairo/common/memcpy.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 47,
                                "end_line": 13,
                                "input_file": {
                                    "filename": "/Users/jakubptak/Library/Caches/pypoetry/virtualenvs/starkware-python-sdk-L_CLq0Mm-py3.7/lib/python3.7/site-packages/starkware/cairo/common/memcpy.cairo"
                                },
                                "start_col": 44,
                                "start_line": 13
                            },
                            "While expanding the reference 'src' in:"
                        ],
                        "start_col": 26,
                        "start_line": 2
                    }
                },
                "11": {
                    "accessible_scopes": [
                        "starkware.cairo.common.memcpy",
                        "starkware.cairo.common.memcpy.memcpy"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 1,
                            "offset": 2
                        },
                        "reference_ids": {
                            "starkware.cairo.common.memcpy.memcpy.dst": 5,
                            "starkware.cairo.common.memcpy.memcpy.frame": 9,
                            "starkware.cairo.common.memcpy.memcpy.len": 7,
                            "starkware.cairo.common.memcpy.memcpy.src": 6
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 37,
                        "end_line": 17,
                        "input_file": {
                            "filename": "/Users/jakubptak/Library/Caches/pypoetry/virtualenvs/starkware-python-sdk-L_CLq0Mm-py3.7/lib/python3.7/site-packages/starkware/cairo/common/memcpy.cairo"
                        },
                        "start_col": 26,
                        "start_line": 17
                    }
                },
                "12": {
                    "accessible_scopes": [
                        "starkware.cairo.common.memcpy",
                        "starkware.cairo.common.memcpy.memcpy"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 1,
                            "offset": 3
                        },
                        "reference_ids": {
                            "starkware.cairo.common.memcpy.memcpy.__temp0": 10,
                            "starkware.cairo.common.memcpy.memcpy.dst": 5,
                            "starkware.cairo.common.memcpy.memcpy.frame": 9,
                            "starkware.cairo.common.memcpy.memcpy.len": 7,
                            "starkware.cairo.common.memcpy.memcpy.src": 6
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 37,
                        "end_line": 17,
                        "input_file": {
                            "filename": "/Users/jakubptak/Library/Caches/pypoetry/virtualenvs/starkware-python-sdk-L_CLq0Mm-py3.7/lib/python3.7/site-packages/starkware/cairo/common/memcpy.cairo"
                        },
                        "start_col": 5,
                        "start_line": 17
                    }
                },
                "13": {
                    "accessible_scopes": [
                        "starkware.cairo.common.memcpy",
                        "starkware.cairo.common.memcpy.memcpy"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 1,
                            "offset": 3
                        },
                        "reference_ids": {
                            "starkware.cairo.common.memcpy.memcpy.__temp0": 10,
                            "starkware.cairo.common.memcpy.memcpy.continue_copying": 11,
                            "starkware.cairo.common.memcpy.memcpy.dst": 5,
                            "starkware.cairo.common.memcpy.memcpy.frame": 9,
                            "starkware.cairo.common.memcpy.memcpy.len": 7,
                            "starkware.cairo.common.memcpy.memcpy.next_frame": 12,
                            "starkware.cairo.common.memcpy.memcpy.src": 6
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 41,
                        "end_line": 22,
                        "input_file": {
                            "filename": "/Users/jakubptak/Library/Caches/pypoetry/virtualenvs/starkware-python-sdk-L_CLq0Mm-py3.7/lib/python3.7/site-packages/starkware/cairo/common/memcpy.cairo"
                        },
                        "start_col": 5,
                        "start_line": 22
                    }
                },
                "15": {
                    "accessible_scopes": [
                        "starkware.cairo.common.memcpy",
                        "starkware.cairo.common.memcpy.memcpy"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 1,
                            "offset": 4
                        },
                        "reference_ids": {
                            "starkware.cairo.common.memcpy.memcpy.__temp0": 10,
                            "starkware.cairo.common.memcpy.memcpy.continue_copying": 11,
                            "starkware.cairo.common.memcpy.memcpy.dst": 5,
                            "starkware.cairo.common.memcpy.memcpy.frame": 9,
                            "starkware.cairo.common.memcpy.memcpy.len": 7,
                            "starkware.cairo.common.memcpy.memcpy.next_frame": 12,
                            "starkware.cairo.common.memcpy.memcpy.src": 6
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 41,
                        "end_line": 23,
                        "input_file": {
                            "filename": "/Users/jakubptak/Library/Caches/pypoetry/virtualenvs/starkware-python-sdk-L_CLq0Mm-py3.7/lib/python3.7/site-packages/starkware/cairo/common/memcpy.cairo"
                        },
                        "start_col": 5,
                        "start_line": 23
                    }
                },
                "17": {
                    "accessible_scopes": [
                        "starkware.cairo.common.memcpy",
                        "starkware.cairo.common.memcpy.memcpy"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 1,
                            "offset": 5
                        },
                        "reference_ids": {
                            "starkware.cairo.common.memcpy.memcpy.__temp0": 10,
                            "starkware.cairo.common.memcpy.memcpy.continue_copying": 11,
                            "starkware.cairo.common.memcpy.memcpy.dst": 5,
                            "starkware.cairo.common.memcpy.memcpy.frame": 9,
                            "starkware.cairo.common.memcpy.memcpy.len": 7,
                            "starkware.cairo.common.memcpy.memcpy.next_frame": 12,
                            "starkware.cairo.common.memcpy.memcpy.src": 6
                        }
                    },
                    "hints": [
                        {
                            "location": {
                                "end_col": 7,
                                "end_line": 27,
                                "input_file": {
                                    "filename": "/Users/jakubptak/Library/Caches/pypoetry/virtualenvs/starkware-python-sdk-L_CLq0Mm-py3.7/lib/python3.7/site-packages/starkware/cairo/common/memcpy.cairo"
                                },
                                "start_col": 5,
                                "start_line": 24
                            },
                            "n_prefix_newlines": 1
                        }
                    ],
                    "inst": {
                        "end_col": 44,
                        "end_line": 29,
                        "input_file": {
                            "filename": "/Users/jakubptak/Library/Caches/pypoetry/virtualenvs/starkware-python-sdk-L_CLq0Mm-py3.7/lib/python3.7/site-packages/starkware/cairo/common/memcpy.cairo"
                        },
                        "start_col": 5,
                        "start_line": 29
                    }
                },
                "19": {
                    "accessible_scopes": [
                        "starkware.cairo.common.memcpy",
                        "starkware.cairo.common.memcpy.memcpy"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 1,
                            "offset": 6
                        },
                        "reference_ids": {
                            "starkware.cairo.common.memcpy.memcpy.__temp0": 10,
                            "starkware.cairo.common.memcpy.memcpy.continue_copying": 11,
                            "starkware.cairo.common.memcpy.memcpy.dst": 5,
                            "starkware.cairo.common.memcpy.memcpy.frame": 9,
                            "starkware.cairo.common.memcpy.memcpy.len": 7,
                            "starkware.cairo.common.memcpy.memcpy.next_frame": 12,
                            "starkware.cairo.common.memcpy.memcpy.src": 6
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 55,
                        "end_line": 31,
                        "input_file": {
                            "filename": "/Users/jakubptak/Library/Caches/pypoetry/virtualenvs/starkware-python-sdk-L_CLq0Mm-py3.7/lib/python3.7/site-packages/starkware/cairo/common/memcpy.cairo"
                        },
                        "start_col": 5,
                        "start_line": 31
                    }
                },
                "20": {
                    "accessible_scopes": [
                        "starkware.cairo.common.memcpy",
                        "starkware.cairo.common.memcpy.memcpy"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 1,
                            "offset": 6
                        },
                        "reference_ids": {
                            "starkware.cairo.common.memcpy.memcpy.__temp0": 10,
                            "starkware.cairo.common.memcpy.memcpy.continue_copying": 11,
                            "starkware.cairo.common.memcpy.memcpy.dst": 5,
                            "starkware.cairo.common.memcpy.memcpy.frame": 9,
                            "starkware.cairo.common.memcpy.memcpy.len": 7,
                            "starkware.cairo.common.memcpy.memcpy.next_frame": 12,
                            "starkware.cairo.common.memcpy.memcpy.src": 6
                        }
                    },
                    "hints": [
                        {
                            "location": {
                                "end_col": 26,
                                "end_line": 33,
                                "input_file": {
                                    "filename": "/Users/jakubptak/Library/Caches/pypoetry/virtualenvs/starkware-python-sdk-L_CLq0Mm-py3.7/lib/python3.7/site-packages/starkware/cairo/common/memcpy.cairo"
                                },
                                "start_col": 5,
                                "start_line": 33
                            },
                            "n_prefix_newlines": 0
                        }
                    ],
                    "inst": {
                        "end_col": 14,
                        "end_line": 34,
                        "input_file": {
                            "filename": "/Users/jakubptak/Library/Caches/pypoetry/virtualenvs/starkware-python-sdk-L_CLq0Mm-py3.7/lib/python3.7/site-packages/starkware/cairo/common/memcpy.cairo"
                        },
                        "start_col": 5,
                        "start_line": 34
                    }
                },
                "21": {
                    "accessible_scopes": [
                        "starkware.starknet.common.syscalls",
                        "starkware.starknet.common.syscalls.call_contract"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 2,
                            "offset": 0
                        },
                        "reference_ids": {
                            "starkware.starknet.common.syscalls.call_contract.calldata": 16,
                            "starkware.starknet.common.syscalls.call_contract.calldata_size": 15,
                            "starkware.starknet.common.syscalls.call_contract.contract_address": 13,
                            "starkware.starknet.common.syscalls.call_contract.function_selector": 14,
                            "starkware.starknet.common.syscalls.call_contract.syscall": 18,
                            "starkware.starknet.common.syscalls.call_contract.syscall_ptr": 17
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 40,
                        "end_line": 45,
                        "input_file": {
                            "filename": "/Users/jakubptak/Library/Caches/pypoetry/virtualenvs/starkware-python-sdk-L_CLq0Mm-py3.7/lib/python3.7/site-packages/starkware/starknet/common/syscalls.cairo"
                        },
                        "start_col": 18,
                        "start_line": 45
                    }
                },
                "23": {
                    "accessible_scopes": [
                        "starkware.starknet.common.syscalls",
                        "starkware.starknet.common.syscalls.call_contract"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 2,
                            "offset": 1
                        },
                        "reference_ids": {
                            "starkware.starknet.common.syscalls.call_contract.__temp1": 19,
                            "starkware.starknet.common.syscalls.call_contract.calldata": 16,
                            "starkware.starknet.common.syscalls.call_contract.calldata_size": 15,
                            "starkware.starknet.common.syscalls.call_contract.contract_address": 13,
                            "starkware.starknet.common.syscalls.call_contract.function_selector": 14,
                            "starkware.starknet.common.syscalls.call_contract.syscall": 18,
                            "starkware.starknet.common.syscalls.call_contract.syscall_ptr": 17
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 27,
                        "end_line": 49,
                        "input_file": {
                            "filename": "/Users/jakubptak/Library/Caches/pypoetry/virtualenvs/starkware-python-sdk-L_CLq0Mm-py3.7/lib/python3.7/site-packages/starkware/starknet/common/syscalls.cairo"
                        },
                        "start_col": 5,
                        "start_line": 44
                    }
                },
                "24": {
                    "accessible_scopes": [
                        "starkware.starknet.common.syscalls",
                        "starkware.starknet.common.syscalls.call_contract"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 2,
                            "offset": 1
                        },
                        "reference_ids": {
                            "starkware.starknet.common.syscalls.call_contract.__temp1": 19,
                            "starkware.starknet.common.syscalls.call_contract.calldata": 16,
                            "starkware.starknet.common.syscalls.call_contract.calldata_size": 15,
                            "starkware.starknet.common.syscalls.call_contract.contract_address": 13,
                            "starkware.starknet.common.syscalls.call_contract.function_selector": 14,
                            "starkware.starknet.common.syscalls.call_contract.syscall": 18,
                            "starkware.starknet.common.syscalls.call_contract.syscall_ptr": 17
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 27,
                        "end_line": 49,
                        "input_file": {
                            "filename": "/Users/jakubptak/Library/Caches/pypoetry/virtualenvs/starkware-python-sdk-L_CLq0Mm-py3.7/lib/python3.7/site-packages/starkware/starknet/common/syscalls.cairo"
                        },
                        "start_col": 5,
                        "start_line": 44
                    }
                },
                "25": {
                    "accessible_scopes": [
                        "starkware.starknet.common.syscalls",
                        "starkware.starknet.common.syscalls.call_contract"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 2,
                            "offset": 1
                        },
                        "reference_ids": {
                            "starkware.starknet.common.syscalls.call_contract.__temp1": 19,
                            "starkware.starknet.common.syscalls.call_contract.calldata": 16,
                            "starkware.starknet.common.syscalls.call_contract.calldata_size": 15,
                            "starkware.starknet.common.syscalls.call_contract.contract_address": 13,
                            "starkware.starknet.common.syscalls.call_contract.function_selector": 14,
                            "starkware.starknet.common.syscalls.call_contract.syscall": 18,
                            "starkware.starknet.common.syscalls.call_contract.syscall_ptr": 17
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 27,
                        "end_line": 49,
                        "input_file": {
                            "filename": "/Users/jakubptak/Library/Caches/pypoetry/virtualenvs/starkware-python-sdk-L_CLq0Mm-py3.7/lib/python3.7/site-packages/starkware/starknet/common/syscalls.cairo"
                        },
                        "start_col": 5,
                        "start_line": 44
                    }
                },
                "26": {
                    "accessible_scopes": [
                        "starkware.starknet.common.syscalls",
                        "starkware.starknet.common.syscalls.call_contract"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 2,
                            "offset": 1
                        },
                        "reference_ids": {
                            "starkware.starknet.common.syscalls.call_contract.__temp1": 19,
                            "starkware.starknet.common.syscalls.call_contract.calldata": 16,
                            "starkware.starknet.common.syscalls.call_contract.calldata_size": 15,
                            "starkware.starknet.common.syscalls.call_contract.contract_address": 13,
                            "starkware.starknet.common.syscalls.call_contract.function_selector": 14,
                            "starkware.starknet.common.syscalls.call_contract.syscall": 18,
                            "starkware.starknet.common.syscalls.call_contract.syscall_ptr": 17
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 27,
                        "end_line": 49,
                        "input_file": {
                            "filename": "/Users/jakubptak/Library/Caches/pypoetry/virtualenvs/starkware-python-sdk-L_CLq0Mm-py3.7/lib/python3.7/site-packages/starkware/starknet/common/syscalls.cairo"
                        },
                        "start_col": 5,
                        "start_line": 44
                    }
                },
                "27": {
                    "accessible_scopes": [
                        "starkware.starknet.common.syscalls",
                        "starkware.starknet.common.syscalls.call_contract"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 2,
                            "offset": 1
                        },
                        "reference_ids": {
                            "starkware.starknet.common.syscalls.call_contract.__temp1": 19,
                            "starkware.starknet.common.syscalls.call_contract.calldata": 16,
                            "starkware.starknet.common.syscalls.call_contract.calldata_size": 15,
                            "starkware.starknet.common.syscalls.call_contract.contract_address": 13,
                            "starkware.starknet.common.syscalls.call_contract.function_selector": 14,
                            "starkware.starknet.common.syscalls.call_contract.syscall": 18,
                            "starkware.starknet.common.syscalls.call_contract.syscall_ptr": 17
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 27,
                        "end_line": 49,
                        "input_file": {
                            "filename": "/Users/jakubptak/Library/Caches/pypoetry/virtualenvs/starkware-python-sdk-L_CLq0Mm-py3.7/lib/python3.7/site-packages/starkware/starknet/common/syscalls.cairo"
                        },
                        "start_col": 5,
                        "start_line": 44
                    }
                },
                "28": {
                    "accessible_scopes": [
                        "starkware.starknet.common.syscalls",
                        "starkware.starknet.common.syscalls.call_contract"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 2,
                            "offset": 1
                        },
                        "reference_ids": {
                            "starkware.starknet.common.syscalls.call_contract.__temp1": 19,
                            "starkware.starknet.common.syscalls.call_contract.calldata": 16,
                            "starkware.starknet.common.syscalls.call_contract.calldata_size": 15,
                            "starkware.starknet.common.syscalls.call_contract.contract_address": 13,
                            "starkware.starknet.common.syscalls.call_contract.function_selector": 14,
                            "starkware.starknet.common.syscalls.call_contract.response": 20,
                            "starkware.starknet.common.syscalls.call_contract.syscall": 18,
                            "starkware.starknet.common.syscalls.call_contract.syscall_ptr": 21
                        }
                    },
                    "hints": [
                        {
                            "location": {
                                "end_col": 88,
                                "end_line": 50,
                                "input_file": {
                                    "filename": "/Users/jakubptak/Library/Caches/pypoetry/virtualenvs/starkware-python-sdk-L_CLq0Mm-py3.7/lib/python3.7/site-packages/starkware/starknet/common/syscalls.cairo"
                                },
                                "start_col": 5,
                                "start_line": 50
                            },
                            "n_prefix_newlines": 0
                        }
                    ],
                    "inst": {
                        "end_col": 54,
                        "end_line": 53,
                        "input_file": {
                            "filename": "/Users/jakubptak/Library/Caches/pypoetry/virtualenvs/starkware-python-sdk-L_CLq0Mm-py3.7/lib/python3.7/site-packages/starkware/starknet/common/syscalls.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 39,
                                "end_line": 40,
                                "input_file": {
                                    "filename": "/Users/jakubptak/Library/Caches/pypoetry/virtualenvs/starkware-python-sdk-L_CLq0Mm-py3.7/lib/python3.7/site-packages/starkware/starknet/common/syscalls.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 74,
                                        "end_line": 54,
                                        "input_file": {
                                            "filename": "/Users/jakubptak/Library/Caches/pypoetry/virtualenvs/starkware-python-sdk-L_CLq0Mm-py3.7/lib/python3.7/site-packages/starkware/starknet/common/syscalls.cairo"
                                        },
                                        "start_col": 5,
                                        "start_line": 54
                                    },
                                    "While trying to retrieve the implicit argument 'syscall_ptr' in:"
                                ],
                                "start_col": 20,
                                "start_line": 40
                            },
                            "While expanding the reference 'syscall_ptr' in:"
                        ],
                        "start_col": 23,
                        "start_line": 53
                    }
                },
                "30": {
                    "accessible_scopes": [
                        "starkware.starknet.common.syscalls",
                        "starkware.starknet.common.syscalls.call_contract"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 2,
                            "offset": 2
                        },
                        "reference_ids": {
                            "starkware.starknet.common.syscalls.call_contract.__temp1": 19,
                            "starkware.starknet.common.syscalls.call_contract.calldata": 16,
                            "starkware.starknet.common.syscalls.call_contract.calldata_size": 15,
                            "starkware.starknet.common.syscalls.call_contract.contract_address": 13,
                            "starkware.starknet.common.syscalls.call_contract.function_selector": 14,
                            "starkware.starknet.common.syscalls.call_contract.response": 20,
                            "starkware.starknet.common.syscalls.call_contract.syscall": 18,
                            "starkware.starknet.common.syscalls.call_contract.syscall_ptr": 21
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 47,
                        "end_line": 54,
                        "input_file": {
                            "filename": "/Users/jakubptak/Library/Caches/pypoetry/virtualenvs/starkware-python-sdk-L_CLq0Mm-py3.7/lib/python3.7/site-packages/starkware/starknet/common/syscalls.cairo"
                        },
                        "start_col": 26,
                        "start_line": 54
                    }
                },
                "31": {
                    "accessible_scopes": [
                        "starkware.starknet.common.syscalls",
                        "starkware.starknet.common.syscalls.call_contract"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 2,
                            "offset": 3
                        },
                        "reference_ids": {
                            "starkware.starknet.common.syscalls.call_contract.__temp1": 19,
                            "starkware.starknet.common.syscalls.call_contract.calldata": 16,
                            "starkware.starknet.common.syscalls.call_contract.calldata_size": 15,
                            "starkware.starknet.common.syscalls.call_contract.contract_address": 13,
                            "starkware.starknet.common.syscalls.call_contract.function_selector": 14,
                            "starkware.starknet.common.syscalls.call_contract.response": 20,
                            "starkware.starknet.common.syscalls.call_contract.syscall": 18,
                            "starkware.starknet.common.syscalls.call_contract.syscall_ptr": 21
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 73,
                        "end_line": 54,
                        "input_file": {
                            "filename": "/Users/jakubptak/Library/Caches/pypoetry/virtualenvs/starkware-python-sdk-L_CLq0Mm-py3.7/lib/python3.7/site-packages/starkware/starknet/common/syscalls.cairo"
                        },
                        "start_col": 57,
                        "start_line": 54
                    }
                },
                "32": {
                    "accessible_scopes": [
                        "starkware.starknet.common.syscalls",
                        "starkware.starknet.common.syscalls.call_contract"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 2,
                            "offset": 4
                        },
                        "reference_ids": {
                            "starkware.starknet.common.syscalls.call_contract.__temp1": 19,
                            "starkware.starknet.common.syscalls.call_contract.calldata": 16,
                            "starkware.starknet.common.syscalls.call_contract.calldata_size": 15,
                            "starkware.starknet.common.syscalls.call_contract.contract_address": 13,
                            "starkware.starknet.common.syscalls.call_contract.function_selector": 14,
                            "starkware.starknet.common.syscalls.call_contract.response": 20,
                            "starkware.starknet.common.syscalls.call_contract.syscall": 18,
                            "starkware.starknet.common.syscalls.call_contract.syscall_ptr": 21
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 74,
                        "end_line": 54,
                        "input_file": {
                            "filename": "/Users/jakubptak/Library/Caches/pypoetry/virtualenvs/starkware-python-sdk-L_CLq0Mm-py3.7/lib/python3.7/site-packages/starkware/starknet/common/syscalls.cairo"
                        },
                        "start_col": 5,
                        "start_line": 54
                    }
                },
                "33": {
                    "accessible_scopes": [
                        "starkware.starknet.common.syscalls",
                        "starkware.starknet.common.syscalls.get_caller_address"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 3,
                            "offset": 0
                        },
                        "reference_ids": {
                            "starkware.starknet.common.syscalls.get_caller_address.syscall": 23,
                            "starkware.starknet.common.syscalls.get_caller_address.syscall_ptr": 22
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 90,
                        "end_line": 95,
                        "input_file": {
                            "filename": "/Users/jakubptak/Library/Caches/pypoetry/virtualenvs/starkware-python-sdk-L_CLq0Mm-py3.7/lib/python3.7/site-packages/starkware/starknet/common/syscalls.cairo"
                        },
                        "start_col": 63,
                        "start_line": 95
                    }
                },
                "35": {
                    "accessible_scopes": [
                        "starkware.starknet.common.syscalls",
                        "starkware.starknet.common.syscalls.get_caller_address"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 3,
                            "offset": 1
                        },
                        "reference_ids": {
                            "starkware.starknet.common.syscalls.get_caller_address.__temp2": 24,
                            "starkware.starknet.common.syscalls.get_caller_address.syscall": 23,
                            "starkware.starknet.common.syscalls.get_caller_address.syscall_ptr": 22
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 91,
                        "end_line": 95,
                        "input_file": {
                            "filename": "/Users/jakubptak/Library/Caches/pypoetry/virtualenvs/starkware-python-sdk-L_CLq0Mm-py3.7/lib/python3.7/site-packages/starkware/starknet/common/syscalls.cairo"
                        },
                        "start_col": 5,
                        "start_line": 95
                    }
                },
                "36": {
                    "accessible_scopes": [
                        "starkware.starknet.common.syscalls",
                        "starkware.starknet.common.syscalls.get_caller_address"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 3,
                            "offset": 1
                        },
                        "reference_ids": {
                            "starkware.starknet.common.syscalls.get_caller_address.__temp2": 24,
                            "starkware.starknet.common.syscalls.get_caller_address.syscall": 23,
                            "starkware.starknet.common.syscalls.get_caller_address.syscall_ptr": 25
                        }
                    },
                    "hints": [
                        {
                            "location": {
                                "end_col": 93,
                                "end_line": 96,
                                "input_file": {
                                    "filename": "/Users/jakubptak/Library/Caches/pypoetry/virtualenvs/starkware-python-sdk-L_CLq0Mm-py3.7/lib/python3.7/site-packages/starkware/starknet/common/syscalls.cairo"
                                },
                                "start_col": 5,
                                "start_line": 96
                            },
                            "n_prefix_newlines": 0
                        }
                    ],
                    "inst": {
                        "end_col": 58,
                        "end_line": 97,
                        "input_file": {
                            "filename": "/Users/jakubptak/Library/Caches/pypoetry/virtualenvs/starkware-python-sdk-L_CLq0Mm-py3.7/lib/python3.7/site-packages/starkware/starknet/common/syscalls.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 44,
                                "end_line": 93,
                                "input_file": {
                                    "filename": "/Users/jakubptak/Library/Caches/pypoetry/virtualenvs/starkware-python-sdk-L_CLq0Mm-py3.7/lib/python3.7/site-packages/starkware/starknet/common/syscalls.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 60,
                                        "end_line": 98,
                                        "input_file": {
                                            "filename": "/Users/jakubptak/Library/Caches/pypoetry/virtualenvs/starkware-python-sdk-L_CLq0Mm-py3.7/lib/python3.7/site-packages/starkware/starknet/common/syscalls.cairo"
                                        },
                                        "start_col": 5,
                                        "start_line": 98
                                    },
                                    "While trying to retrieve the implicit argument 'syscall_ptr' in:"
                                ],
                                "start_col": 25,
                                "start_line": 93
                            },
                            "While expanding the reference 'syscall_ptr' in:"
                        ],
                        "start_col": 23,
                        "start_line": 97
                    }
                },
                "38": {
                    "accessible_scopes": [
                        "starkware.starknet.common.syscalls",
                        "starkware.starknet.common.syscalls.get_caller_address"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 3,
                            "offset": 2
                        },
                        "reference_ids": {
                            "starkware.starknet.common.syscalls.get_caller_address.__temp2": 24,
                            "starkware.starknet.common.syscalls.get_caller_address.syscall": 23,
                            "starkware.starknet.common.syscalls.get_caller_address.syscall_ptr": 25
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 59,
                        "end_line": 98,
                        "input_file": {
                            "filename": "/Users/jakubptak/Library/Caches/pypoetry/virtualenvs/starkware-python-sdk-L_CLq0Mm-py3.7/lib/python3.7/site-packages/starkware/starknet/common/syscalls.cairo"
                        },
                        "start_col": 28,
                        "start_line": 98
                    }
                },
                "39": {
                    "accessible_scopes": [
                        "starkware.starknet.common.syscalls",
                        "starkware.starknet.common.syscalls.get_caller_address"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 3,
                            "offset": 3
                        },
                        "reference_ids": {
                            "starkware.starknet.common.syscalls.get_caller_address.__temp2": 24,
                            "starkware.starknet.common.syscalls.get_caller_address.syscall": 23,
                            "starkware.starknet.common.syscalls.get_caller_address.syscall_ptr": 25
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 60,
                        "end_line": 98,
                        "input_file": {
                            "filename": "/Users/jakubptak/Library/Caches/pypoetry/virtualenvs/starkware-python-sdk-L_CLq0Mm-py3.7/lib/python3.7/site-packages/starkware/starknet/common/syscalls.cairo"
                        },
                        "start_col": 5,
                        "start_line": 98
                    }
                },
                "40": {
                    "accessible_scopes": [
                        "starkware.starknet.common.syscalls",
                        "starkware.starknet.common.syscalls.get_contract_address"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 4,
                            "offset": 0
                        },
                        "reference_ids": {
                            "starkware.starknet.common.syscalls.get_contract_address.syscall": 27,
                            "starkware.starknet.common.syscalls.get_contract_address.syscall_ptr": 26
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 94,
                        "end_line": 146,
                        "input_file": {
                            "filename": "/Users/jakubptak/Library/Caches/pypoetry/virtualenvs/starkware-python-sdk-L_CLq0Mm-py3.7/lib/python3.7/site-packages/starkware/starknet/common/syscalls.cairo"
                        },
                        "start_col": 65,
                        "start_line": 146
                    }
                },
                "42": {
                    "accessible_scopes": [
                        "starkware.starknet.common.syscalls",
                        "starkware.starknet.common.syscalls.get_contract_address"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 4,
                            "offset": 1
                        },
                        "reference_ids": {
                            "starkware.starknet.common.syscalls.get_contract_address.__temp3": 28,
                            "starkware.starknet.common.syscalls.get_contract_address.syscall": 27,
                            "starkware.starknet.common.syscalls.get_contract_address.syscall_ptr": 26
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 95,
                        "end_line": 146,
                        "input_file": {
                            "filename": "/Users/jakubptak/Library/Caches/pypoetry/virtualenvs/starkware-python-sdk-L_CLq0Mm-py3.7/lib/python3.7/site-packages/starkware/starknet/common/syscalls.cairo"
                        },
                        "start_col": 5,
                        "start_line": 146
                    }
                },
                "43": {
                    "accessible_scopes": [
                        "starkware.starknet.common.syscalls",
                        "starkware.starknet.common.syscalls.get_contract_address"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 4,
                            "offset": 1
                        },
                        "reference_ids": {
                            "starkware.starknet.common.syscalls.get_contract_address.__temp3": 28,
                            "starkware.starknet.common.syscalls.get_contract_address.syscall": 27,
                            "starkware.starknet.common.syscalls.get_contract_address.syscall_ptr": 29
                        }
                    },
                    "hints": [
                        {
                            "location": {
                                "end_col": 95,
                                "end_line": 147,
                                "input_file": {
                                    "filename": "/Users/jakubptak/Library/Caches/pypoetry/virtualenvs/starkware-python-sdk-L_CLq0Mm-py3.7/lib/python3.7/site-packages/starkware/starknet/common/syscalls.cairo"
                                },
                                "start_col": 5,
                                "start_line": 147
                            },
                            "n_prefix_newlines": 0
                        }
                    ],
                    "inst": {
                        "end_col": 60,
                        "end_line": 148,
                        "input_file": {
                            "filename": "/Users/jakubptak/Library/Caches/pypoetry/virtualenvs/starkware-python-sdk-L_CLq0Mm-py3.7/lib/python3.7/site-packages/starkware/starknet/common/syscalls.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 46,
                                "end_line": 144,
                                "input_file": {
                                    "filename": "/Users/jakubptak/Library/Caches/pypoetry/virtualenvs/starkware-python-sdk-L_CLq0Mm-py3.7/lib/python3.7/site-packages/starkware/starknet/common/syscalls.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 64,
                                        "end_line": 149,
                                        "input_file": {
                                            "filename": "/Users/jakubptak/Library/Caches/pypoetry/virtualenvs/starkware-python-sdk-L_CLq0Mm-py3.7/lib/python3.7/site-packages/starkware/starknet/common/syscalls.cairo"
                                        },
                                        "start_col": 5,
                                        "start_line": 149
                                    },
                                    "While trying to retrieve the implicit argument 'syscall_ptr' in:"
                                ],
                                "start_col": 27,
                                "start_line": 144
                            },
                            "While expanding the reference 'syscall_ptr' in:"
                        ],
                        "start_col": 23,
                        "start_line": 148
                    }
                },
                "45": {
                    "accessible_scopes": [
                        "starkware.starknet.common.syscalls",
                        "starkware.starknet.common.syscalls.get_contract_address"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 4,
                            "offset": 2
                        },
                        "reference_ids": {
                            "starkware.starknet.common.syscalls.get_contract_address.__temp3": 28,
                            "starkware.starknet.common.syscalls.get_contract_address.syscall": 27,
                            "starkware.starknet.common.syscalls.get_contract_address.syscall_ptr": 29
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 63,
                        "end_line": 149,
                        "input_file": {
                            "filename": "/Users/jakubptak/Library/Caches/pypoetry/virtualenvs/starkware-python-sdk-L_CLq0Mm-py3.7/lib/python3.7/site-packages/starkware/starknet/common/syscalls.cairo"
                        },
                        "start_col": 30,
                        "start_line": 149
                    }
                },
                "46": {
                    "accessible_scopes": [
                        "starkware.starknet.common.syscalls",
                        "starkware.starknet.common.syscalls.get_contract_address"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 4,
                            "offset": 3
                        },
                        "reference_ids": {
                            "starkware.starknet.common.syscalls.get_contract_address.__temp3": 28,
                            "starkware.starknet.common.syscalls.get_contract_address.syscall": 27,
                            "starkware.starknet.common.syscalls.get_contract_address.syscall_ptr": 29
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 64,
                        "end_line": 149,
                        "input_file": {
                            "filename": "/Users/jakubptak/Library/Caches/pypoetry/virtualenvs/starkware-python-sdk-L_CLq0Mm-py3.7/lib/python3.7/site-packages/starkware/starknet/common/syscalls.cairo"
                        },
                        "start_col": 5,
                        "start_line": 149
                    }
                },
                "47": {
                    "accessible_scopes": [
                        "starkware.starknet.common.syscalls",
                        "starkware.starknet.common.syscalls.get_tx_signature"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 5,
                            "offset": 0
                        },
                        "reference_ids": {
                            "starkware.starknet.common.syscalls.get_tx_signature.syscall": 31,
                            "starkware.starknet.common.syscalls.get_tx_signature.syscall_ptr": 30
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 86,
                        "end_line": 175,
                        "input_file": {
                            "filename": "/Users/jakubptak/Library/Caches/pypoetry/virtualenvs/starkware-python-sdk-L_CLq0Mm-py3.7/lib/python3.7/site-packages/starkware/starknet/common/syscalls.cairo"
                        },
                        "start_col": 61,
                        "start_line": 175
                    }
                },
                "49": {
                    "accessible_scopes": [
                        "starkware.starknet.common.syscalls",
                        "starkware.starknet.common.syscalls.get_tx_signature"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 5,
                            "offset": 1
                        },
                        "reference_ids": {
                            "starkware.starknet.common.syscalls.get_tx_signature.__temp4": 32,
                            "starkware.starknet.common.syscalls.get_tx_signature.syscall": 31,
                            "starkware.starknet.common.syscalls.get_tx_signature.syscall_ptr": 30
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 87,
                        "end_line": 175,
                        "input_file": {
                            "filename": "/Users/jakubptak/Library/Caches/pypoetry/virtualenvs/starkware-python-sdk-L_CLq0Mm-py3.7/lib/python3.7/site-packages/starkware/starknet/common/syscalls.cairo"
                        },
                        "start_col": 5,
                        "start_line": 175
                    }
                },
                "50": {
                    "accessible_scopes": [
                        "starkware.starknet.common.syscalls",
                        "starkware.starknet.common.syscalls.get_tx_signature"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 5,
                            "offset": 1
                        },
                        "reference_ids": {
                            "starkware.starknet.common.syscalls.get_tx_signature.__temp4": 32,
                            "starkware.starknet.common.syscalls.get_tx_signature.syscall": 31,
                            "starkware.starknet.common.syscalls.get_tx_signature.syscall_ptr": 33
                        }
                    },
                    "hints": [
                        {
                            "location": {
                                "end_col": 91,
                                "end_line": 176,
                                "input_file": {
                                    "filename": "/Users/jakubptak/Library/Caches/pypoetry/virtualenvs/starkware-python-sdk-L_CLq0Mm-py3.7/lib/python3.7/site-packages/starkware/starknet/common/syscalls.cairo"
                                },
                                "start_col": 5,
                                "start_line": 176
                            },
                            "n_prefix_newlines": 0
                        }
                    ],
                    "inst": {
                        "end_col": 56,
                        "end_line": 177,
                        "input_file": {
                            "filename": "/Users/jakubptak/Library/Caches/pypoetry/virtualenvs/starkware-python-sdk-L_CLq0Mm-py3.7/lib/python3.7/site-packages/starkware/starknet/common/syscalls.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 42,
                                "end_line": 173,
                                "input_file": {
                                    "filename": "/Users/jakubptak/Library/Caches/pypoetry/virtualenvs/starkware-python-sdk-L_CLq0Mm-py3.7/lib/python3.7/site-packages/starkware/starknet/common/syscalls.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 96,
                                        "end_line": 178,
                                        "input_file": {
                                            "filename": "/Users/jakubptak/Library/Caches/pypoetry/virtualenvs/starkware-python-sdk-L_CLq0Mm-py3.7/lib/python3.7/site-packages/starkware/starknet/common/syscalls.cairo"
                                        },
                                        "start_col": 5,
                                        "start_line": 178
                                    },
                                    "While trying to retrieve the implicit argument 'syscall_ptr' in:"
                                ],
                                "start_col": 23,
                                "start_line": 173
                            },
                            "While expanding the reference 'syscall_ptr' in:"
                        ],
                        "start_col": 23,
                        "start_line": 177
                    }
                },
                "52": {
                    "accessible_scopes": [
                        "starkware.starknet.common.syscalls",
                        "starkware.starknet.common.syscalls.get_tx_signature"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 5,
                            "offset": 2
                        },
                        "reference_ids": {
                            "starkware.starknet.common.syscalls.get_tx_signature.__temp4": 32,
                            "starkware.starknet.common.syscalls.get_tx_signature.syscall": 31,
                            "starkware.starknet.common.syscalls.get_tx_signature.syscall_ptr": 33
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 57,
                        "end_line": 178,
                        "input_file": {
                            "filename": "/Users/jakubptak/Library/Caches/pypoetry/virtualenvs/starkware-python-sdk-L_CLq0Mm-py3.7/lib/python3.7/site-packages/starkware/starknet/common/syscalls.cairo"
                        },
                        "start_col": 27,
                        "start_line": 178
                    }
                },
                "53": {
                    "accessible_scopes": [
                        "starkware.starknet.common.syscalls",
                        "starkware.starknet.common.syscalls.get_tx_signature"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 5,
                            "offset": 3
                        },
                        "reference_ids": {
                            "starkware.starknet.common.syscalls.get_tx_signature.__temp4": 32,
                            "starkware.starknet.common.syscalls.get_tx_signature.syscall": 31,
                            "starkware.starknet.common.syscalls.get_tx_signature.syscall_ptr": 33
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 95,
                        "end_line": 178,
                        "input_file": {
                            "filename": "/Users/jakubptak/Library/Caches/pypoetry/virtualenvs/starkware-python-sdk-L_CLq0Mm-py3.7/lib/python3.7/site-packages/starkware/starknet/common/syscalls.cairo"
                        },
                        "start_col": 69,
                        "start_line": 178
                    }
                },
                "54": {
                    "accessible_scopes": [
                        "starkware.starknet.common.syscalls",
                        "starkware.starknet.common.syscalls.get_tx_signature"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 5,
                            "offset": 4
                        },
                        "reference_ids": {
                            "starkware.starknet.common.syscalls.get_tx_signature.__temp4": 32,
                            "starkware.starknet.common.syscalls.get_tx_signature.syscall": 31,
                            "starkware.starknet.common.syscalls.get_tx_signature.syscall_ptr": 33
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 96,
                        "end_line": 178,
                        "input_file": {
                            "filename": "/Users/jakubptak/Library/Caches/pypoetry/virtualenvs/starkware-python-sdk-L_CLq0Mm-py3.7/lib/python3.7/site-packages/starkware/starknet/common/syscalls.cairo"
                        },
                        "start_col": 5,
                        "start_line": 178
                    }
                },
                "55": {
                    "accessible_scopes": [
                        "starkware.starknet.common.syscalls",
                        "starkware.starknet.common.syscalls.storage_read"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 6,
                            "offset": 0
                        },
                        "reference_ids": {
                            "starkware.starknet.common.syscalls.storage_read.address": 34,
                            "starkware.starknet.common.syscalls.storage_read.syscall": 36,
                            "starkware.starknet.common.syscalls.storage_read.syscall_ptr": 35
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 79,
                        "end_line": 201,
                        "input_file": {
                            "filename": "/Users/jakubptak/Library/Caches/pypoetry/virtualenvs/starkware-python-sdk-L_CLq0Mm-py3.7/lib/python3.7/site-packages/starkware/starknet/common/syscalls.cairo"
                        },
                        "start_col": 58,
                        "start_line": 201
                    }
                },
                "57": {
                    "accessible_scopes": [
                        "starkware.starknet.common.syscalls",
                        "starkware.starknet.common.syscalls.storage_read"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 6,
                            "offset": 1
                        },
                        "reference_ids": {
                            "starkware.starknet.common.syscalls.storage_read.__temp5": 37,
                            "starkware.starknet.common.syscalls.storage_read.address": 34,
                            "starkware.starknet.common.syscalls.storage_read.syscall": 36,
                            "starkware.starknet.common.syscalls.storage_read.syscall_ptr": 35
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 97,
                        "end_line": 201,
                        "input_file": {
                            "filename": "/Users/jakubptak/Library/Caches/pypoetry/virtualenvs/starkware-python-sdk-L_CLq0Mm-py3.7/lib/python3.7/site-packages/starkware/starknet/common/syscalls.cairo"
                        },
                        "start_col": 5,
                        "start_line": 201
                    }
                },
                "58": {
                    "accessible_scopes": [
                        "starkware.starknet.common.syscalls",
                        "starkware.starknet.common.syscalls.storage_read"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 6,
                            "offset": 1
                        },
                        "reference_ids": {
                            "starkware.starknet.common.syscalls.storage_read.__temp5": 37,
                            "starkware.starknet.common.syscalls.storage_read.address": 34,
                            "starkware.starknet.common.syscalls.storage_read.syscall": 36,
                            "starkware.starknet.common.syscalls.storage_read.syscall_ptr": 35
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 97,
                        "end_line": 201,
                        "input_file": {
                            "filename": "/Users/jakubptak/Library/Caches/pypoetry/virtualenvs/starkware-python-sdk-L_CLq0Mm-py3.7/lib/python3.7/site-packages/starkware/starknet/common/syscalls.cairo"
                        },
                        "start_col": 5,
                        "start_line": 201
                    }
                },
                "59": {
                    "accessible_scopes": [
                        "starkware.starknet.common.syscalls",
                        "starkware.starknet.common.syscalls.storage_read"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 6,
                            "offset": 1
                        },
                        "reference_ids": {
                            "starkware.starknet.common.syscalls.storage_read.__temp5": 37,
                            "starkware.starknet.common.syscalls.storage_read.address": 34,
                            "starkware.starknet.common.syscalls.storage_read.response": 38,
                            "starkware.starknet.common.syscalls.storage_read.syscall": 36,
                            "starkware.starknet.common.syscalls.storage_read.syscall_ptr": 39
                        }
                    },
                    "hints": [
                        {
                            "location": {
                                "end_col": 87,
                                "end_line": 202,
                                "input_file": {
                                    "filename": "/Users/jakubptak/Library/Caches/pypoetry/virtualenvs/starkware-python-sdk-L_CLq0Mm-py3.7/lib/python3.7/site-packages/starkware/starknet/common/syscalls.cairo"
                                },
                                "start_col": 5,
                                "start_line": 202
                            },
                            "n_prefix_newlines": 0
                        }
                    ],
                    "inst": {
                        "end_col": 53,
                        "end_line": 204,
                        "input_file": {
                            "filename": "/Users/jakubptak/Library/Caches/pypoetry/virtualenvs/starkware-python-sdk-L_CLq0Mm-py3.7/lib/python3.7/site-packages/starkware/starknet/common/syscalls.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 38,
                                "end_line": 199,
                                "input_file": {
                                    "filename": "/Users/jakubptak/Library/Caches/pypoetry/virtualenvs/starkware-python-sdk-L_CLq0Mm-py3.7/lib/python3.7/site-packages/starkware/starknet/common/syscalls.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 34,
                                        "end_line": 205,
                                        "input_file": {
                                            "filename": "/Users/jakubptak/Library/Caches/pypoetry/virtualenvs/starkware-python-sdk-L_CLq0Mm-py3.7/lib/python3.7/site-packages/starkware/starknet/common/syscalls.cairo"
                                        },
                                        "start_col": 5,
                                        "start_line": 205
                                    },
                                    "While trying to retrieve the implicit argument 'syscall_ptr' in:"
                                ],
                                "start_col": 19,
                                "start_line": 199
                            },
                            "While expanding the reference 'syscall_ptr' in:"
                        ],
                        "start_col": 23,
                        "start_line": 204
                    }
                },
                "61": {
                    "accessible_scopes": [
                        "starkware.starknet.common.syscalls",
                        "starkware.starknet.common.syscalls.storage_read"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 6,
                            "offset": 2
                        },
                        "reference_ids": {
                            "starkware.starknet.common.syscalls.storage_read.__temp5": 37,
                            "starkware.starknet.common.syscalls.storage_read.address": 34,
                            "starkware.starknet.common.syscalls.storage_read.response": 38,
                            "starkware.starknet.common.syscalls.storage_read.syscall": 36,
                            "starkware.starknet.common.syscalls.storage_read.syscall_ptr": 39
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 33,
                        "end_line": 205,
                        "input_file": {
                            "filename": "/Users/jakubptak/Library/Caches/pypoetry/virtualenvs/starkware-python-sdk-L_CLq0Mm-py3.7/lib/python3.7/site-packages/starkware/starknet/common/syscalls.cairo"
                        },
                        "start_col": 19,
                        "start_line": 205
                    }
                },
                "62": {
                    "accessible_scopes": [
                        "starkware.starknet.common.syscalls",
                        "starkware.starknet.common.syscalls.storage_read"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 6,
                            "offset": 3
                        },
                        "reference_ids": {
                            "starkware.starknet.common.syscalls.storage_read.__temp5": 37,
                            "starkware.starknet.common.syscalls.storage_read.address": 34,
                            "starkware.starknet.common.syscalls.storage_read.response": 38,
                            "starkware.starknet.common.syscalls.storage_read.syscall": 36,
                            "starkware.starknet.common.syscalls.storage_read.syscall_ptr": 39
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 34,
                        "end_line": 205,
                        "input_file": {
                            "filename": "/Users/jakubptak/Library/Caches/pypoetry/virtualenvs/starkware-python-sdk-L_CLq0Mm-py3.7/lib/python3.7/site-packages/starkware/starknet/common/syscalls.cairo"
                        },
                        "start_col": 5,
                        "start_line": 205
                    }
                },
                "63": {
                    "accessible_scopes": [
                        "starkware.starknet.common.syscalls",
                        "starkware.starknet.common.syscalls.storage_write"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 7,
                            "offset": 0
                        },
                        "reference_ids": {
                            "starkware.starknet.common.syscalls.storage_write.address": 40,
                            "starkware.starknet.common.syscalls.storage_write.syscall_ptr": 42,
                            "starkware.starknet.common.syscalls.storage_write.value": 41
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 40,
                        "end_line": 219,
                        "input_file": {
                            "filename": "/Users/jakubptak/Library/Caches/pypoetry/virtualenvs/starkware-python-sdk-L_CLq0Mm-py3.7/lib/python3.7/site-packages/starkware/starknet/common/syscalls.cairo"
                        },
                        "start_col": 18,
                        "start_line": 219
                    }
                },
                "65": {
                    "accessible_scopes": [
                        "starkware.starknet.common.syscalls",
                        "starkware.starknet.common.syscalls.storage_write"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 7,
                            "offset": 1
                        },
                        "reference_ids": {
                            "starkware.starknet.common.syscalls.storage_write.__temp6": 43,
                            "starkware.starknet.common.syscalls.storage_write.address": 40,
                            "starkware.starknet.common.syscalls.storage_write.syscall_ptr": 42,
                            "starkware.starknet.common.syscalls.storage_write.value": 41
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 71,
                        "end_line": 219,
                        "input_file": {
                            "filename": "/Users/jakubptak/Library/Caches/pypoetry/virtualenvs/starkware-python-sdk-L_CLq0Mm-py3.7/lib/python3.7/site-packages/starkware/starknet/common/syscalls.cairo"
                        },
                        "start_col": 5,
                        "start_line": 218
                    }
                },
                "66": {
                    "accessible_scopes": [
                        "starkware.starknet.common.syscalls",
                        "starkware.starknet.common.syscalls.storage_write"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 7,
                            "offset": 1
                        },
                        "reference_ids": {
                            "starkware.starknet.common.syscalls.storage_write.__temp6": 43,
                            "starkware.starknet.common.syscalls.storage_write.address": 40,
                            "starkware.starknet.common.syscalls.storage_write.syscall_ptr": 42,
                            "starkware.starknet.common.syscalls.storage_write.value": 41
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 71,
                        "end_line": 219,
                        "input_file": {
                            "filename": "/Users/jakubptak/Library/Caches/pypoetry/virtualenvs/starkware-python-sdk-L_CLq0Mm-py3.7/lib/python3.7/site-packages/starkware/starknet/common/syscalls.cairo"
                        },
                        "start_col": 5,
                        "start_line": 218
                    }
                },
                "67": {
                    "accessible_scopes": [
                        "starkware.starknet.common.syscalls",
                        "starkware.starknet.common.syscalls.storage_write"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 7,
                            "offset": 1
                        },
                        "reference_ids": {
                            "starkware.starknet.common.syscalls.storage_write.__temp6": 43,
                            "starkware.starknet.common.syscalls.storage_write.address": 40,
                            "starkware.starknet.common.syscalls.storage_write.syscall_ptr": 42,
                            "starkware.starknet.common.syscalls.storage_write.value": 41
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 71,
                        "end_line": 219,
                        "input_file": {
                            "filename": "/Users/jakubptak/Library/Caches/pypoetry/virtualenvs/starkware-python-sdk-L_CLq0Mm-py3.7/lib/python3.7/site-packages/starkware/starknet/common/syscalls.cairo"
                        },
                        "start_col": 5,
                        "start_line": 218
                    }
                },
                "68": {
                    "accessible_scopes": [
                        "starkware.starknet.common.syscalls",
                        "starkware.starknet.common.syscalls.storage_write"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 7,
                            "offset": 1
                        },
                        "reference_ids": {
                            "starkware.starknet.common.syscalls.storage_write.__temp6": 43,
                            "starkware.starknet.common.syscalls.storage_write.address": 40,
                            "starkware.starknet.common.syscalls.storage_write.syscall_ptr": 44,
                            "starkware.starknet.common.syscalls.storage_write.value": 41
                        }
                    },
                    "hints": [
                        {
                            "location": {
                                "end_col": 88,
                                "end_line": 220,
                                "input_file": {
                                    "filename": "/Users/jakubptak/Library/Caches/pypoetry/virtualenvs/starkware-python-sdk-L_CLq0Mm-py3.7/lib/python3.7/site-packages/starkware/starknet/common/syscalls.cairo"
                                },
                                "start_col": 5,
                                "start_line": 220
                            },
                            "n_prefix_newlines": 0
                        }
                    ],
                    "inst": {
                        "end_col": 54,
                        "end_line": 221,
                        "input_file": {
                            "filename": "/Users/jakubptak/Library/Caches/pypoetry/virtualenvs/starkware-python-sdk-L_CLq0Mm-py3.7/lib/python3.7/site-packages/starkware/starknet/common/syscalls.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 39,
                                "end_line": 217,
                                "input_file": {
                                    "filename": "/Users/jakubptak/Library/Caches/pypoetry/virtualenvs/starkware-python-sdk-L_CLq0Mm-py3.7/lib/python3.7/site-packages/starkware/starknet/common/syscalls.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 14,
                                        "end_line": 222,
                                        "input_file": {
                                            "filename": "/Users/jakubptak/Library/Caches/pypoetry/virtualenvs/starkware-python-sdk-L_CLq0Mm-py3.7/lib/python3.7/site-packages/starkware/starknet/common/syscalls.cairo"
                                        },
                                        "start_col": 5,
                                        "start_line": 222
                                    },
                                    "While trying to retrieve the implicit argument 'syscall_ptr' in:"
                                ],
                                "start_col": 20,
                                "start_line": 217
                            },
                            "While expanding the reference 'syscall_ptr' in:"
                        ],
                        "start_col": 23,
                        "start_line": 221
                    }
                },
                "70": {
                    "accessible_scopes": [
                        "starkware.starknet.common.syscalls",
                        "starkware.starknet.common.syscalls.storage_write"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 7,
                            "offset": 2
                        },
                        "reference_ids": {
                            "starkware.starknet.common.syscalls.storage_write.__temp6": 43,
                            "starkware.starknet.common.syscalls.storage_write.address": 40,
                            "starkware.starknet.common.syscalls.storage_write.syscall_ptr": 44,
                            "starkware.starknet.common.syscalls.storage_write.value": 41
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 14,
                        "end_line": 222,
                        "input_file": {
                            "filename": "/Users/jakubptak/Library/Caches/pypoetry/virtualenvs/starkware-python-sdk-L_CLq0Mm-py3.7/lib/python3.7/site-packages/starkware/starknet/common/syscalls.cairo"
                        },
                        "start_col": 5,
                        "start_line": 222
                    }
                },
                "71": {
                    "accessible_scopes": [
                        "starkware.cairo.common.registers",
                        "starkware.cairo.common.registers.get_fp_and_pc"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 8,
                            "offset": 0
                        },
                        "reference_ids": {}
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 46,
                        "end_line": 6,
                        "input_file": {
                            "filename": "/Users/jakubptak/Library/Caches/pypoetry/virtualenvs/starkware-python-sdk-L_CLq0Mm-py3.7/lib/python3.7/site-packages/starkware/cairo/common/registers.cairo"
                        },
                        "start_col": 5,
                        "start_line": 6
                    }
                },
                "72": {
                    "accessible_scopes": [
                        "starkware.cairo.common.signature",
                        "starkware.cairo.common.signature.verify_ecdsa_signature"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 9,
                            "offset": 0
                        },
                        "reference_ids": {
                            "starkware.cairo.common.signature.verify_ecdsa_signature.ecdsa_ptr": 49,
                            "starkware.cairo.common.signature.verify_ecdsa_signature.message": 45,
                            "starkware.cairo.common.signature.verify_ecdsa_signature.public_key": 46,
                            "starkware.cairo.common.signature.verify_ecdsa_signature.signature_r": 47,
                            "starkware.cairo.common.signature.verify_ecdsa_signature.signature_s": 48
                        }
                    },
                    "hints": [
                        {
                            "location": {
                                "end_col": 98,
                                "end_line": 9,
                                "input_file": {
                                    "filename": "/Users/jakubptak/Library/Caches/pypoetry/virtualenvs/starkware-python-sdk-L_CLq0Mm-py3.7/lib/python3.7/site-packages/starkware/cairo/common/signature.cairo"
                                },
                                "start_col": 5,
                                "start_line": 9
                            },
                            "n_prefix_newlines": 0
                        }
                    ],
                    "inst": {
                        "end_col": 39,
                        "end_line": 10,
                        "input_file": {
                            "filename": "/Users/jakubptak/Library/Caches/pypoetry/virtualenvs/starkware-python-sdk-L_CLq0Mm-py3.7/lib/python3.7/site-packages/starkware/cairo/common/signature.cairo"
                        },
                        "start_col": 5,
                        "start_line": 10
                    }
                },
                "73": {
                    "accessible_scopes": [
                        "starkware.cairo.common.signature",
                        "starkware.cairo.common.signature.verify_ecdsa_signature"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 9,
                            "offset": 0
                        },
                        "reference_ids": {
                            "starkware.cairo.common.signature.verify_ecdsa_signature.ecdsa_ptr": 49,
                            "starkware.cairo.common.signature.verify_ecdsa_signature.message": 45,
                            "starkware.cairo.common.signature.verify_ecdsa_signature.public_key": 46,
                            "starkware.cairo.common.signature.verify_ecdsa_signature.signature_r": 47,
                            "starkware.cairo.common.signature.verify_ecdsa_signature.signature_s": 48
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 42,
                        "end_line": 11,
                        "input_file": {
                            "filename": "/Users/jakubptak/Library/Caches/pypoetry/virtualenvs/starkware-python-sdk-L_CLq0Mm-py3.7/lib/python3.7/site-packages/starkware/cairo/common/signature.cairo"
                        },
                        "start_col": 5,
                        "start_line": 11
                    }
                },
                "74": {
                    "accessible_scopes": [
                        "starkware.cairo.common.signature",
                        "starkware.cairo.common.signature.verify_ecdsa_signature"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 9,
                            "offset": 0
                        },
                        "reference_ids": {
                            "starkware.cairo.common.signature.verify_ecdsa_signature.ecdsa_ptr": 50,
                            "starkware.cairo.common.signature.verify_ecdsa_signature.message": 45,
                            "starkware.cairo.common.signature.verify_ecdsa_signature.public_key": 46,
                            "starkware.cairo.common.signature.verify_ecdsa_signature.signature_r": 47,
                            "starkware.cairo.common.signature.verify_ecdsa_signature.signature_s": 48
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 54,
                        "end_line": 13,
                        "input_file": {
                            "filename": "/Users/jakubptak/Library/Caches/pypoetry/virtualenvs/starkware-python-sdk-L_CLq0Mm-py3.7/lib/python3.7/site-packages/starkware/cairo/common/signature.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 58,
                                "end_line": 7,
                                "input_file": {
                                    "filename": "/Users/jakubptak/Library/Caches/pypoetry/virtualenvs/starkware-python-sdk-L_CLq0Mm-py3.7/lib/python3.7/site-packages/starkware/cairo/common/signature.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 14,
                                        "end_line": 14,
                                        "input_file": {
                                            "filename": "/Users/jakubptak/Library/Caches/pypoetry/virtualenvs/starkware-python-sdk-L_CLq0Mm-py3.7/lib/python3.7/site-packages/starkware/cairo/common/signature.cairo"
                                        },
                                        "start_col": 5,
                                        "start_line": 14
                                    },
                                    "While trying to retrieve the implicit argument 'ecdsa_ptr' in:"
                                ],
                                "start_col": 29,
                                "start_line": 7
                            },
                            "While expanding the reference 'ecdsa_ptr' in:"
                        ],
                        "start_col": 21,
                        "start_line": 13
                    }
                },
                "76": {
                    "accessible_scopes": [
                        "starkware.cairo.common.signature",
                        "starkware.cairo.common.signature.verify_ecdsa_signature"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 9,
                            "offset": 1
                        },
                        "reference_ids": {
                            "starkware.cairo.common.signature.verify_ecdsa_signature.ecdsa_ptr": 50,
                            "starkware.cairo.common.signature.verify_ecdsa_signature.message": 45,
                            "starkware.cairo.common.signature.verify_ecdsa_signature.public_key": 46,
                            "starkware.cairo.common.signature.verify_ecdsa_signature.signature_r": 47,
                            "starkware.cairo.common.signature.verify_ecdsa_signature.signature_s": 48
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 14,
                        "end_line": 14,
                        "input_file": {
                            "filename": "/Users/jakubptak/Library/Caches/pypoetry/virtualenvs/starkware-python-sdk-L_CLq0Mm-py3.7/lib/python3.7/site-packages/starkware/cairo/common/signature.cairo"
                        },
                        "start_col": 5,
                        "start_line": 14
                    }
                },
                "77": {
                    "accessible_scopes": [
                        "starkware.cairo.common.hash_state",
                        "starkware.cairo.common.hash_state.hash_init"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 10,
                            "offset": 0
                        },
                        "reference_ids": {}
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 17,
                        "end_line": 17,
                        "input_file": {
                            "filename": "/Users/jakubptak/Library/Caches/pypoetry/virtualenvs/starkware-python-sdk-L_CLq0Mm-py3.7/lib/python3.7/site-packages/starkware/cairo/common/hash_state.cairo"
                        },
                        "start_col": 5,
                        "start_line": 17
                    }
                },
                "79": {
                    "accessible_scopes": [
                        "starkware.cairo.common.hash_state",
                        "starkware.cairo.common.hash_state.hash_init"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 10,
                            "offset": 2
                        },
                        "reference_ids": {}
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 38,
                        "end_line": 18,
                        "input_file": {
                            "filename": "/Users/jakubptak/Library/Caches/pypoetry/virtualenvs/starkware-python-sdk-L_CLq0Mm-py3.7/lib/python3.7/site-packages/starkware/cairo/common/hash_state.cairo"
                        },
                        "start_col": 23,
                        "start_line": 18
                    }
                },
                "81": {
                    "accessible_scopes": [
                        "starkware.cairo.common.hash_state",
                        "starkware.cairo.common.hash_state.hash_init"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 10,
                            "offset": 4
                        },
                        "reference_ids": {
                            "starkware.cairo.common.hash_state.hash_init.__fp__": 51,
                            "starkware.cairo.common.hash_state.hash_init.hash_state": 52
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 32,
                        "end_line": 20,
                        "input_file": {
                            "filename": "/Users/jakubptak/Library/Caches/pypoetry/virtualenvs/starkware-python-sdk-L_CLq0Mm-py3.7/lib/python3.7/site-packages/starkware/cairo/common/hash_state.cairo"
                        },
                        "start_col": 5,
                        "start_line": 20
                    }
                },
                "83": {
                    "accessible_scopes": [
                        "starkware.cairo.common.hash_state",
                        "starkware.cairo.common.hash_state.hash_init"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 10,
                            "offset": 4
                        },
                        "reference_ids": {
                            "starkware.cairo.common.hash_state.hash_init.__fp__": 51,
                            "starkware.cairo.common.hash_state.hash_init.hash_state": 52
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 27,
                        "end_line": 21,
                        "input_file": {
                            "filename": "/Users/jakubptak/Library/Caches/pypoetry/virtualenvs/starkware-python-sdk-L_CLq0Mm-py3.7/lib/python3.7/site-packages/starkware/cairo/common/hash_state.cairo"
                        },
                        "start_col": 5,
                        "start_line": 21
                    }
                },
                "85": {
                    "accessible_scopes": [
                        "starkware.cairo.common.hash_state",
                        "starkware.cairo.common.hash_state.hash_init"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 10,
                            "offset": 4
                        },
                        "reference_ids": {
                            "starkware.cairo.common.hash_state.hash_init.__fp__": 51,
                            "starkware.cairo.common.hash_state.hash_init.hash_state": 52
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 21,
                        "end_line": 19,
                        "input_file": {
                            "filename": "/Users/jakubptak/Library/Caches/pypoetry/virtualenvs/starkware-python-sdk-L_CLq0Mm-py3.7/lib/python3.7/site-packages/starkware/cairo/common/hash_state.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 39,
                                "end_line": 22,
                                "input_file": {
                                    "filename": "/Users/jakubptak/Library/Caches/pypoetry/virtualenvs/starkware-python-sdk-L_CLq0Mm-py3.7/lib/python3.7/site-packages/starkware/cairo/common/hash_state.cairo"
                                },
                                "start_col": 29,
                                "start_line": 22
                            },
                            "While expanding the reference 'hash_state' in:"
                        ],
                        "start_col": 11,
                        "start_line": 19
                    }
                },
                "86": {
                    "accessible_scopes": [
                        "starkware.cairo.common.hash_state",
                        "starkware.cairo.common.hash_state.hash_init"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 10,
                            "offset": 5
                        },
                        "reference_ids": {
                            "starkware.cairo.common.hash_state.hash_init.__fp__": 51,
                            "starkware.cairo.common.hash_state.hash_init.hash_state": 52
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 40,
                        "end_line": 22,
                        "input_file": {
                            "filename": "/Users/jakubptak/Library/Caches/pypoetry/virtualenvs/starkware-python-sdk-L_CLq0Mm-py3.7/lib/python3.7/site-packages/starkware/cairo/common/hash_state.cairo"
                        },
                        "start_col": 5,
                        "start_line": 22
                    }
                },
                "87": {
                    "accessible_scopes": [
                        "starkware.cairo.common.hash_state",
                        "starkware.cairo.common.hash_state.hash_update_inner"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 11,
                            "offset": 0
                        },
                        "reference_ids": {
                            "starkware.cairo.common.hash_state.hash_update_inner.data_length": 54,
                            "starkware.cairo.common.hash_state.hash_update_inner.data_ptr": 53,
                            "starkware.cairo.common.hash_state.hash_update_inner.hash": 55,
                            "starkware.cairo.common.hash_state.hash_update_inner.hash_ptr": 56
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 7,
                        "end_line": 29,
                        "input_file": {
                            "filename": "/Users/jakubptak/Library/Caches/pypoetry/virtualenvs/starkware-python-sdk-L_CLq0Mm-py3.7/lib/python3.7/site-packages/starkware/cairo/common/hash_state.cairo"
                        },
                        "start_col": 5,
                        "start_line": 29
                    }
                },
                "89": {
                    "accessible_scopes": [
                        "starkware.cairo.common.hash_state",
                        "starkware.cairo.common.hash_state.hash_update_inner"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 11,
                            "offset": 0
                        },
                        "reference_ids": {
                            "starkware.cairo.common.hash_state.hash_update_inner.data_length": 54,
                            "starkware.cairo.common.hash_state.hash_update_inner.data_ptr": 53,
                            "starkware.cairo.common.hash_state.hash_update_inner.hash": 55,
                            "starkware.cairo.common.hash_state.hash_update_inner.hash_ptr": 56
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 47,
                        "end_line": 27,
                        "input_file": {
                            "filename": "/Users/jakubptak/Library/Caches/pypoetry/virtualenvs/starkware-python-sdk-L_CLq0Mm-py3.7/lib/python3.7/site-packages/starkware/cairo/common/hash_state.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 47,
                                "end_line": 27,
                                "input_file": {
                                    "filename": "/Users/jakubptak/Library/Caches/pypoetry/virtualenvs/starkware-python-sdk-L_CLq0Mm-py3.7/lib/python3.7/site-packages/starkware/cairo/common/hash_state.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 27,
                                        "end_line": 30,
                                        "input_file": {
                                            "filename": "/Users/jakubptak/Library/Caches/pypoetry/virtualenvs/starkware-python-sdk-L_CLq0Mm-py3.7/lib/python3.7/site-packages/starkware/cairo/common/hash_state.cairo"
                                        },
                                        "start_col": 9,
                                        "start_line": 30
                                    },
                                    "While trying to retrieve the implicit argument 'hash_ptr' in:"
                                ],
                                "start_col": 24,
                                "start_line": 27
                            },
                            "While expanding the reference 'hash_ptr' in:"
                        ],
                        "start_col": 24,
                        "start_line": 27
                    }
                },
                "90": {
                    "accessible_scopes": [
                        "starkware.cairo.common.hash_state",
                        "starkware.cairo.common.hash_state.hash_update_inner"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 11,
                            "offset": 1
                        },
                        "reference_ids": {
                            "starkware.cairo.common.hash_state.hash_update_inner.data_length": 54,
                            "starkware.cairo.common.hash_state.hash_update_inner.data_ptr": 53,
                            "starkware.cairo.common.hash_state.hash_update_inner.hash": 55,
                            "starkware.cairo.common.hash_state.hash_update_inner.hash_ptr": 56
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 58,
                        "end_line": 28,
                        "input_file": {
                            "filename": "/Users/jakubptak/Library/Caches/pypoetry/virtualenvs/starkware-python-sdk-L_CLq0Mm-py3.7/lib/python3.7/site-packages/starkware/cairo/common/hash_state.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 26,
                                "end_line": 30,
                                "input_file": {
                                    "filename": "/Users/jakubptak/Library/Caches/pypoetry/virtualenvs/starkware-python-sdk-L_CLq0Mm-py3.7/lib/python3.7/site-packages/starkware/cairo/common/hash_state.cairo"
                                },
                                "start_col": 22,
                                "start_line": 30
                            },
                            "While expanding the reference 'hash' in:"
                        ],
                        "start_col": 47,
                        "start_line": 28
                    }
                },
                "91": {
                    "accessible_scopes": [
                        "starkware.cairo.common.hash_state",
                        "starkware.cairo.common.hash_state.hash_update_inner"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 11,
                            "offset": 2
                        },
                        "reference_ids": {
                            "starkware.cairo.common.hash_state.hash_update_inner.data_length": 54,
                            "starkware.cairo.common.hash_state.hash_update_inner.data_ptr": 53,
                            "starkware.cairo.common.hash_state.hash_update_inner.hash": 55,
                            "starkware.cairo.common.hash_state.hash_update_inner.hash_ptr": 56
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 27,
                        "end_line": 30,
                        "input_file": {
                            "filename": "/Users/jakubptak/Library/Caches/pypoetry/virtualenvs/starkware-python-sdk-L_CLq0Mm-py3.7/lib/python3.7/site-packages/starkware/cairo/common/hash_state.cairo"
                        },
                        "start_col": 9,
                        "start_line": 30
                    }
                },
                "92": {
                    "accessible_scopes": [
                        "starkware.cairo.common.hash_state",
                        "starkware.cairo.common.hash_state.hash_update_inner"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 11,
                            "offset": 0
                        },
                        "reference_ids": {
                            "starkware.cairo.common.hash_state.hash_update_inner.data_length": 54,
                            "starkware.cairo.common.hash_state.hash_update_inner.data_ptr": 53,
                            "starkware.cairo.common.hash_state.hash_update_inner.hash": 55,
                            "starkware.cairo.common.hash_state.hash_update_inner.hash_ptr": 56
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 17,
                        "end_line": 33,
                        "input_file": {
                            "filename": "/Users/jakubptak/Library/Caches/pypoetry/virtualenvs/starkware-python-sdk-L_CLq0Mm-py3.7/lib/python3.7/site-packages/starkware/cairo/common/hash_state.cairo"
                        },
                        "start_col": 5,
                        "start_line": 33
                    }
                },
                "94": {
                    "accessible_scopes": [
                        "starkware.cairo.common.hash_state",
                        "starkware.cairo.common.hash_state.hash_update_inner"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 11,
                            "offset": 1
                        },
                        "reference_ids": {
                            "starkware.cairo.common.hash_state.hash_update_inner.data_length": 54,
                            "starkware.cairo.common.hash_state.hash_update_inner.data_ptr": 53,
                            "starkware.cairo.common.hash_state.hash_update_inner.hash": 55,
                            "starkware.cairo.common.hash_state.hash_update_inner.hash_ptr": 56
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 61,
                        "end_line": 34,
                        "input_file": {
                            "filename": "/Users/jakubptak/Library/Caches/pypoetry/virtualenvs/starkware-python-sdk-L_CLq0Mm-py3.7/lib/python3.7/site-packages/starkware/cairo/common/hash_state.cairo"
                        },
                        "start_col": 35,
                        "start_line": 34
                    }
                },
                "96": {
                    "accessible_scopes": [
                        "starkware.cairo.common.hash_state",
                        "starkware.cairo.common.hash_state.hash_update_inner"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 11,
                            "offset": 2
                        },
                        "reference_ids": {
                            "starkware.cairo.common.hash_state.hash_update_inner.__temp7": 57,
                            "starkware.cairo.common.hash_state.hash_update_inner.data_length": 54,
                            "starkware.cairo.common.hash_state.hash_update_inner.data_ptr": 53,
                            "starkware.cairo.common.hash_state.hash_update_inner.hash": 55,
                            "starkware.cairo.common.hash_state.hash_update_inner.hash_ptr": 56
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 61,
                        "end_line": 34,
                        "input_file": {
                            "filename": "/Users/jakubptak/Library/Caches/pypoetry/virtualenvs/starkware-python-sdk-L_CLq0Mm-py3.7/lib/python3.7/site-packages/starkware/cairo/common/hash_state.cairo"
                        },
                        "start_col": 5,
                        "start_line": 34
                    }
                },
                "97": {
                    "accessible_scopes": [
                        "starkware.cairo.common.hash_state",
                        "starkware.cairo.common.hash_state.hash_update_inner"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 11,
                            "offset": 2
                        },
                        "reference_ids": {
                            "starkware.cairo.common.hash_state.hash_update_inner.__temp7": 57,
                            "starkware.cairo.common.hash_state.hash_update_inner.data_last_ptr": 58,
                            "starkware.cairo.common.hash_state.hash_update_inner.data_length": 54,
                            "starkware.cairo.common.hash_state.hash_update_inner.data_ptr": 53,
                            "starkware.cairo.common.hash_state.hash_update_inner.first_locals": 59,
                            "starkware.cairo.common.hash_state.hash_update_inner.hash": 55,
                            "starkware.cairo.common.hash_state.hash_update_inner.hash_ptr": 56
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 43,
                        "end_line": 43,
                        "input_file": {
                            "filename": "/Users/jakubptak/Library/Caches/pypoetry/virtualenvs/starkware-python-sdk-L_CLq0Mm-py3.7/lib/python3.7/site-packages/starkware/cairo/common/hash_state.cairo"
                        },
                        "start_col": 5,
                        "start_line": 43
                    }
                },
                "98": {
                    "accessible_scopes": [
                        "starkware.cairo.common.hash_state",
                        "starkware.cairo.common.hash_state.hash_update_inner"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 11,
                            "offset": 3
                        },
                        "reference_ids": {
                            "starkware.cairo.common.hash_state.hash_update_inner.__temp7": 57,
                            "starkware.cairo.common.hash_state.hash_update_inner.data_last_ptr": 58,
                            "starkware.cairo.common.hash_state.hash_update_inner.data_length": 54,
                            "starkware.cairo.common.hash_state.hash_update_inner.data_ptr": 53,
                            "starkware.cairo.common.hash_state.hash_update_inner.first_locals": 59,
                            "starkware.cairo.common.hash_state.hash_update_inner.hash": 55,
                            "starkware.cairo.common.hash_state.hash_update_inner.hash_ptr": 56
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 43,
                        "end_line": 44,
                        "input_file": {
                            "filename": "/Users/jakubptak/Library/Caches/pypoetry/virtualenvs/starkware-python-sdk-L_CLq0Mm-py3.7/lib/python3.7/site-packages/starkware/cairo/common/hash_state.cairo"
                        },
                        "start_col": 5,
                        "start_line": 44
                    }
                },
                "99": {
                    "accessible_scopes": [
                        "starkware.cairo.common.hash_state",
                        "starkware.cairo.common.hash_state.hash_update_inner"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 11,
                            "offset": 4
                        },
                        "reference_ids": {
                            "starkware.cairo.common.hash_state.hash_update_inner.__temp7": 57,
                            "starkware.cairo.common.hash_state.hash_update_inner.data_last_ptr": 58,
                            "starkware.cairo.common.hash_state.hash_update_inner.data_length": 54,
                            "starkware.cairo.common.hash_state.hash_update_inner.data_ptr": 53,
                            "starkware.cairo.common.hash_state.hash_update_inner.first_locals": 59,
                            "starkware.cairo.common.hash_state.hash_update_inner.hash": 55,
                            "starkware.cairo.common.hash_state.hash_update_inner.hash_ptr": 56
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 39,
                        "end_line": 45,
                        "input_file": {
                            "filename": "/Users/jakubptak/Library/Caches/pypoetry/virtualenvs/starkware-python-sdk-L_CLq0Mm-py3.7/lib/python3.7/site-packages/starkware/cairo/common/hash_state.cairo"
                        },
                        "start_col": 5,
                        "start_line": 45
                    }
                },
                "100": {
                    "accessible_scopes": [
                        "starkware.cairo.common.hash_state",
                        "starkware.cairo.common.hash_state.hash_update_inner"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 11,
                            "offset": 5
                        },
                        "reference_ids": {
                            "starkware.cairo.common.hash_state.hash_update_inner.__temp7": 57,
                            "starkware.cairo.common.hash_state.hash_update_inner.data_last_ptr": 58,
                            "starkware.cairo.common.hash_state.hash_update_inner.data_length": 54,
                            "starkware.cairo.common.hash_state.hash_update_inner.data_ptr": 53,
                            "starkware.cairo.common.hash_state.hash_update_inner.first_locals": 59,
                            "starkware.cairo.common.hash_state.hash_update_inner.hash": 55,
                            "starkware.cairo.common.hash_state.hash_update_inner.hash_ptr": 56,
                            "starkware.cairo.common.hash_state.hash_update_inner.prev_locals": 60
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 72,
                        "end_line": 50,
                        "input_file": {
                            "filename": "/Users/jakubptak/Library/Caches/pypoetry/virtualenvs/starkware-python-sdk-L_CLq0Mm-py3.7/lib/python3.7/site-packages/starkware/cairo/common/hash_state.cairo"
                        },
                        "start_col": 36,
                        "start_line": 50
                    }
                },
                "101": {
                    "accessible_scopes": [
                        "starkware.cairo.common.hash_state",
                        "starkware.cairo.common.hash_state.hash_update_inner"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 11,
                            "offset": 6
                        },
                        "reference_ids": {
                            "starkware.cairo.common.hash_state.hash_update_inner.__temp7": 57,
                            "starkware.cairo.common.hash_state.hash_update_inner.data_last_ptr": 58,
                            "starkware.cairo.common.hash_state.hash_update_inner.data_length": 54,
                            "starkware.cairo.common.hash_state.hash_update_inner.data_ptr": 53,
                            "starkware.cairo.common.hash_state.hash_update_inner.first_locals": 59,
                            "starkware.cairo.common.hash_state.hash_update_inner.hash": 55,
                            "starkware.cairo.common.hash_state.hash_update_inner.hash_ptr": 56,
                            "starkware.cairo.common.hash_state.hash_update_inner.n_remaining_elements": 61,
                            "starkware.cairo.common.hash_state.hash_update_inner.prev_locals": 60
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 50,
                        "end_line": 53,
                        "input_file": {
                            "filename": "/Users/jakubptak/Library/Caches/pypoetry/virtualenvs/starkware-python-sdk-L_CLq0Mm-py3.7/lib/python3.7/site-packages/starkware/cairo/common/hash_state.cairo"
                        },
                        "start_col": 5,
                        "start_line": 53
                    }
                },
                "102": {
                    "accessible_scopes": [
                        "starkware.cairo.common.hash_state",
                        "starkware.cairo.common.hash_state.hash_update_inner"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 11,
                            "offset": 6
                        },
                        "reference_ids": {
                            "starkware.cairo.common.hash_state.hash_update_inner.__temp7": 57,
                            "starkware.cairo.common.hash_state.hash_update_inner.data_last_ptr": 58,
                            "starkware.cairo.common.hash_state.hash_update_inner.data_length": 54,
                            "starkware.cairo.common.hash_state.hash_update_inner.data_ptr": 53,
                            "starkware.cairo.common.hash_state.hash_update_inner.first_locals": 59,
                            "starkware.cairo.common.hash_state.hash_update_inner.hash": 55,
                            "starkware.cairo.common.hash_state.hash_update_inner.hash_ptr": 56,
                            "starkware.cairo.common.hash_state.hash_update_inner.n_remaining_elements": 61,
                            "starkware.cairo.common.hash_state.hash_update_inner.prev_locals": 60
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 59,
                        "end_line": 54,
                        "input_file": {
                            "filename": "/Users/jakubptak/Library/Caches/pypoetry/virtualenvs/starkware-python-sdk-L_CLq0Mm-py3.7/lib/python3.7/site-packages/starkware/cairo/common/hash_state.cairo"
                        },
                        "start_col": 37,
                        "start_line": 54
                    }
                },
                "103": {
                    "accessible_scopes": [
                        "starkware.cairo.common.hash_state",
                        "starkware.cairo.common.hash_state.hash_update_inner"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 11,
                            "offset": 7
                        },
                        "reference_ids": {
                            "starkware.cairo.common.hash_state.hash_update_inner.__temp7": 57,
                            "starkware.cairo.common.hash_state.hash_update_inner.__temp8": 62,
                            "starkware.cairo.common.hash_state.hash_update_inner.data_last_ptr": 58,
                            "starkware.cairo.common.hash_state.hash_update_inner.data_length": 54,
                            "starkware.cairo.common.hash_state.hash_update_inner.data_ptr": 53,
                            "starkware.cairo.common.hash_state.hash_update_inner.first_locals": 59,
                            "starkware.cairo.common.hash_state.hash_update_inner.hash": 55,
                            "starkware.cairo.common.hash_state.hash_update_inner.hash_ptr": 56,
                            "starkware.cairo.common.hash_state.hash_update_inner.n_remaining_elements": 61,
                            "starkware.cairo.common.hash_state.hash_update_inner.prev_locals": 60
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 59,
                        "end_line": 54,
                        "input_file": {
                            "filename": "/Users/jakubptak/Library/Caches/pypoetry/virtualenvs/starkware-python-sdk-L_CLq0Mm-py3.7/lib/python3.7/site-packages/starkware/cairo/common/hash_state.cairo"
                        },
                        "start_col": 5,
                        "start_line": 54
                    }
                },
                "104": {
                    "accessible_scopes": [
                        "starkware.cairo.common.hash_state",
                        "starkware.cairo.common.hash_state.hash_update_inner"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 11,
                            "offset": 7
                        },
                        "reference_ids": {
                            "starkware.cairo.common.hash_state.hash_update_inner.__temp7": 57,
                            "starkware.cairo.common.hash_state.hash_update_inner.__temp8": 62,
                            "starkware.cairo.common.hash_state.hash_update_inner.data_last_ptr": 58,
                            "starkware.cairo.common.hash_state.hash_update_inner.data_length": 54,
                            "starkware.cairo.common.hash_state.hash_update_inner.data_ptr": 53,
                            "starkware.cairo.common.hash_state.hash_update_inner.first_locals": 59,
                            "starkware.cairo.common.hash_state.hash_update_inner.hash": 55,
                            "starkware.cairo.common.hash_state.hash_update_inner.hash_ptr": 56,
                            "starkware.cairo.common.hash_state.hash_update_inner.n_remaining_elements": 61,
                            "starkware.cairo.common.hash_state.hash_update_inner.next_locals": 63,
                            "starkware.cairo.common.hash_state.hash_update_inner.prev_locals": 60
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 58,
                        "end_line": 58,
                        "input_file": {
                            "filename": "/Users/jakubptak/Library/Caches/pypoetry/virtualenvs/starkware-python-sdk-L_CLq0Mm-py3.7/lib/python3.7/site-packages/starkware/cairo/common/hash_state.cairo"
                        },
                        "start_col": 5,
                        "start_line": 58
                    }
                },
                "106": {
                    "accessible_scopes": [
                        "starkware.cairo.common.hash_state",
                        "starkware.cairo.common.hash_state.hash_update_inner"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 11,
                            "offset": 8
                        },
                        "reference_ids": {
                            "starkware.cairo.common.hash_state.hash_update_inner.__temp7": 57,
                            "starkware.cairo.common.hash_state.hash_update_inner.__temp8": 62,
                            "starkware.cairo.common.hash_state.hash_update_inner.data_last_ptr": 58,
                            "starkware.cairo.common.hash_state.hash_update_inner.data_length": 54,
                            "starkware.cairo.common.hash_state.hash_update_inner.data_ptr": 53,
                            "starkware.cairo.common.hash_state.hash_update_inner.first_locals": 59,
                            "starkware.cairo.common.hash_state.hash_update_inner.hash": 55,
                            "starkware.cairo.common.hash_state.hash_update_inner.hash_ptr": 56,
                            "starkware.cairo.common.hash_state.hash_update_inner.n_remaining_elements": 61,
                            "starkware.cairo.common.hash_state.hash_update_inner.next_locals": 63,
                            "starkware.cairo.common.hash_state.hash_update_inner.prev_locals": 60
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 73,
                        "end_line": 59,
                        "input_file": {
                            "filename": "/Users/jakubptak/Library/Caches/pypoetry/virtualenvs/starkware-python-sdk-L_CLq0Mm-py3.7/lib/python3.7/site-packages/starkware/cairo/common/hash_state.cairo"
                        },
                        "start_col": 5,
                        "start_line": 59
                    }
                },
                "108": {
                    "accessible_scopes": [
                        "starkware.cairo.common.hash_state",
                        "starkware.cairo.common.hash_state.hash_update_inner"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 11,
                            "offset": 9
                        },
                        "reference_ids": {
                            "starkware.cairo.common.hash_state.hash_update_inner.__temp7": 57,
                            "starkware.cairo.common.hash_state.hash_update_inner.__temp8": 62,
                            "starkware.cairo.common.hash_state.hash_update_inner.data_last_ptr": 58,
                            "starkware.cairo.common.hash_state.hash_update_inner.data_length": 54,
                            "starkware.cairo.common.hash_state.hash_update_inner.data_ptr": 53,
                            "starkware.cairo.common.hash_state.hash_update_inner.first_locals": 59,
                            "starkware.cairo.common.hash_state.hash_update_inner.hash": 55,
                            "starkware.cairo.common.hash_state.hash_update_inner.hash_ptr": 56,
                            "starkware.cairo.common.hash_state.hash_update_inner.n_remaining_elements": 61,
                            "starkware.cairo.common.hash_state.hash_update_inner.next_locals": 63,
                            "starkware.cairo.common.hash_state.hash_update_inner.prev_locals": 60
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 61,
                        "end_line": 60,
                        "input_file": {
                            "filename": "/Users/jakubptak/Library/Caches/pypoetry/virtualenvs/starkware-python-sdk-L_CLq0Mm-py3.7/lib/python3.7/site-packages/starkware/cairo/common/hash_state.cairo"
                        },
                        "start_col": 5,
                        "start_line": 60
                    }
                },
                "109": {
                    "accessible_scopes": [
                        "starkware.cairo.common.hash_state",
                        "starkware.cairo.common.hash_state.hash_update_inner"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 11,
                            "offset": 10
                        },
                        "reference_ids": {
                            "starkware.cairo.common.hash_state.hash_update_inner.__temp7": 57,
                            "starkware.cairo.common.hash_state.hash_update_inner.__temp8": 62,
                            "starkware.cairo.common.hash_state.hash_update_inner.data_last_ptr": 58,
                            "starkware.cairo.common.hash_state.hash_update_inner.data_length": 54,
                            "starkware.cairo.common.hash_state.hash_update_inner.data_ptr": 53,
                            "starkware.cairo.common.hash_state.hash_update_inner.first_locals": 59,
                            "starkware.cairo.common.hash_state.hash_update_inner.hash": 55,
                            "starkware.cairo.common.hash_state.hash_update_inner.hash_ptr": 56,
                            "starkware.cairo.common.hash_state.hash_update_inner.n_remaining_elements": 61,
                            "starkware.cairo.common.hash_state.hash_update_inner.next_locals": 63,
                            "starkware.cairo.common.hash_state.hash_update_inner.prev_locals": 60
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 47,
                        "end_line": 63,
                        "input_file": {
                            "filename": "/Users/jakubptak/Library/Caches/pypoetry/virtualenvs/starkware-python-sdk-L_CLq0Mm-py3.7/lib/python3.7/site-packages/starkware/cairo/common/hash_state.cairo"
                        },
                        "start_col": 5,
                        "start_line": 63
                    }
                },
                "111": {
                    "accessible_scopes": [
                        "starkware.cairo.common.hash_state",
                        "starkware.cairo.common.hash_state.hash_update_inner"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 11,
                            "offset": 10
                        },
                        "reference_ids": {
                            "starkware.cairo.common.hash_state.hash_update_inner.__temp7": 57,
                            "starkware.cairo.common.hash_state.hash_update_inner.__temp8": 62,
                            "starkware.cairo.common.hash_state.hash_update_inner.data_last_ptr": 58,
                            "starkware.cairo.common.hash_state.hash_update_inner.data_length": 54,
                            "starkware.cairo.common.hash_state.hash_update_inner.data_ptr": 53,
                            "starkware.cairo.common.hash_state.hash_update_inner.final_locals": 64,
                            "starkware.cairo.common.hash_state.hash_update_inner.first_locals": 59,
                            "starkware.cairo.common.hash_state.hash_update_inner.hash": 55,
                            "starkware.cairo.common.hash_state.hash_update_inner.hash_ptr": 65,
                            "starkware.cairo.common.hash_state.hash_update_inner.n_remaining_elements": 61,
                            "starkware.cairo.common.hash_state.hash_update_inner.next_locals": 63,
                            "starkware.cairo.common.hash_state.hash_update_inner.prev_locals": 60
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 40,
                        "end_line": 68,
                        "input_file": {
                            "filename": "/Users/jakubptak/Library/Caches/pypoetry/virtualenvs/starkware-python-sdk-L_CLq0Mm-py3.7/lib/python3.7/site-packages/starkware/cairo/common/hash_state.cairo"
                        },
                        "start_col": 5,
                        "start_line": 68
                    }
                },
                "112": {
                    "accessible_scopes": [
                        "starkware.cairo.common.hash_state",
                        "starkware.cairo.common.hash_state.hash_update"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 12,
                            "offset": 0
                        },
                        "reference_ids": {
                            "starkware.cairo.common.hash_state.hash_update.data_length": 68,
                            "starkware.cairo.common.hash_state.hash_update.data_ptr": 67,
                            "starkware.cairo.common.hash_state.hash_update.hash_ptr": 69,
                            "starkware.cairo.common.hash_state.hash_update.hash_state_ptr": 66
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 17,
                        "end_line": 76,
                        "input_file": {
                            "filename": "/Users/jakubptak/Library/Caches/pypoetry/virtualenvs/starkware-python-sdk-L_CLq0Mm-py3.7/lib/python3.7/site-packages/starkware/cairo/common/hash_state.cairo"
                        },
                        "start_col": 5,
                        "start_line": 76
                    }
                },
                "114": {
                    "accessible_scopes": [
                        "starkware.cairo.common.hash_state",
                        "starkware.cairo.common.hash_state.hash_update"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 12,
                            "offset": 2
                        },
                        "reference_ids": {
                            "starkware.cairo.common.hash_state.hash_update.data_length": 68,
                            "starkware.cairo.common.hash_state.hash_update.data_ptr": 67,
                            "starkware.cairo.common.hash_state.hash_update.hash_ptr": 69,
                            "starkware.cairo.common.hash_state.hash_update.hash_state_ptr": 66
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 41,
                        "end_line": 73,
                        "input_file": {
                            "filename": "/Users/jakubptak/Library/Caches/pypoetry/virtualenvs/starkware-python-sdk-L_CLq0Mm-py3.7/lib/python3.7/site-packages/starkware/cairo/common/hash_state.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 47,
                                "end_line": 27,
                                "input_file": {
                                    "filename": "/Users/jakubptak/Library/Caches/pypoetry/virtualenvs/starkware-python-sdk-L_CLq0Mm-py3.7/lib/python3.7/site-packages/starkware/cairo/common/hash_state.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 86,
                                        "end_line": 78,
                                        "input_file": {
                                            "filename": "/Users/jakubptak/Library/Caches/pypoetry/virtualenvs/starkware-python-sdk-L_CLq0Mm-py3.7/lib/python3.7/site-packages/starkware/cairo/common/hash_state.cairo"
                                        },
                                        "start_col": 18,
                                        "start_line": 77
                                    },
                                    "While trying to retrieve the implicit argument 'hash_ptr' in:"
                                ],
                                "start_col": 24,
                                "start_line": 27
                            },
                            "While expanding the reference 'hash_ptr' in:"
                        ],
                        "start_col": 18,
                        "start_line": 73
                    }
                },
                "115": {
                    "accessible_scopes": [
                        "starkware.cairo.common.hash_state",
                        "starkware.cairo.common.hash_state.hash_update"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 12,
                            "offset": 3
                        },
                        "reference_ids": {
                            "starkware.cairo.common.hash_state.hash_update.data_length": 68,
                            "starkware.cairo.common.hash_state.hash_update.data_ptr": 67,
                            "starkware.cairo.common.hash_state.hash_update.hash_ptr": 69,
                            "starkware.cairo.common.hash_state.hash_update.hash_state_ptr": 66
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 54,
                        "end_line": 74,
                        "input_file": {
                            "filename": "/Users/jakubptak/Library/Caches/pypoetry/virtualenvs/starkware-python-sdk-L_CLq0Mm-py3.7/lib/python3.7/site-packages/starkware/cairo/common/hash_state.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 26,
                                "end_line": 78,
                                "input_file": {
                                    "filename": "/Users/jakubptak/Library/Caches/pypoetry/virtualenvs/starkware-python-sdk-L_CLq0Mm-py3.7/lib/python3.7/site-packages/starkware/cairo/common/hash_state.cairo"
                                },
                                "start_col": 18,
                                "start_line": 78
                            },
                            "While expanding the reference 'data_ptr' in:"
                        ],
                        "start_col": 38,
                        "start_line": 74
                    }
                },
                "116": {
                    "accessible_scopes": [
                        "starkware.cairo.common.hash_state",
                        "starkware.cairo.common.hash_state.hash_update"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 12,
                            "offset": 4
                        },
                        "reference_ids": {
                            "starkware.cairo.common.hash_state.hash_update.data_length": 68,
                            "starkware.cairo.common.hash_state.hash_update.data_ptr": 67,
                            "starkware.cairo.common.hash_state.hash_update.hash_ptr": 69,
                            "starkware.cairo.common.hash_state.hash_update.hash_state_ptr": 66
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 67,
                        "end_line": 74,
                        "input_file": {
                            "filename": "/Users/jakubptak/Library/Caches/pypoetry/virtualenvs/starkware-python-sdk-L_CLq0Mm-py3.7/lib/python3.7/site-packages/starkware/cairo/common/hash_state.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 51,
                                "end_line": 78,
                                "input_file": {
                                    "filename": "/Users/jakubptak/Library/Caches/pypoetry/virtualenvs/starkware-python-sdk-L_CLq0Mm-py3.7/lib/python3.7/site-packages/starkware/cairo/common/hash_state.cairo"
                                },
                                "start_col": 40,
                                "start_line": 78
                            },
                            "While expanding the reference 'data_length' in:"
                        ],
                        "start_col": 56,
                        "start_line": 74
                    }
                },
                "117": {
                    "accessible_scopes": [
                        "starkware.cairo.common.hash_state",
                        "starkware.cairo.common.hash_state.hash_update"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 12,
                            "offset": 5
                        },
                        "reference_ids": {
                            "starkware.cairo.common.hash_state.hash_update.data_length": 68,
                            "starkware.cairo.common.hash_state.hash_update.data_ptr": 67,
                            "starkware.cairo.common.hash_state.hash_update.hash_ptr": 69,
                            "starkware.cairo.common.hash_state.hash_update.hash_state_ptr": 66
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 85,
                        "end_line": 78,
                        "input_file": {
                            "filename": "/Users/jakubptak/Library/Caches/pypoetry/virtualenvs/starkware-python-sdk-L_CLq0Mm-py3.7/lib/python3.7/site-packages/starkware/cairo/common/hash_state.cairo"
                        },
                        "start_col": 58,
                        "start_line": 78
                    }
                },
                "118": {
                    "accessible_scopes": [
                        "starkware.cairo.common.hash_state",
                        "starkware.cairo.common.hash_state.hash_update"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 12,
                            "offset": 6
                        },
                        "reference_ids": {
                            "starkware.cairo.common.hash_state.hash_update.data_length": 68,
                            "starkware.cairo.common.hash_state.hash_update.data_ptr": 67,
                            "starkware.cairo.common.hash_state.hash_update.hash_ptr": 69,
                            "starkware.cairo.common.hash_state.hash_update.hash_state_ptr": 66
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 86,
                        "end_line": 78,
                        "input_file": {
                            "filename": "/Users/jakubptak/Library/Caches/pypoetry/virtualenvs/starkware-python-sdk-L_CLq0Mm-py3.7/lib/python3.7/site-packages/starkware/cairo/common/hash_state.cairo"
                        },
                        "start_col": 18,
                        "start_line": 77
                    }
                },
                "120": {
                    "accessible_scopes": [
                        "starkware.cairo.common.hash_state",
                        "starkware.cairo.common.hash_state.hash_update"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 13,
                            "offset": 0
                        },
                        "reference_ids": {
                            "starkware.cairo.common.hash_state.hash_update.data_length": 68,
                            "starkware.cairo.common.hash_state.hash_update.data_ptr": 67,
                            "starkware.cairo.common.hash_state.hash_update.hash": 71,
                            "starkware.cairo.common.hash_state.hash_update.hash_ptr": 70,
                            "starkware.cairo.common.hash_state.hash_update.hash_state_ptr": 66
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 38,
                        "end_line": 79,
                        "input_file": {
                            "filename": "/Users/jakubptak/Library/Caches/pypoetry/virtualenvs/starkware-python-sdk-L_CLq0Mm-py3.7/lib/python3.7/site-packages/starkware/cairo/common/hash_state.cairo"
                        },
                        "start_col": 23,
                        "start_line": 79
                    }
                },
                "122": {
                    "accessible_scopes": [
                        "starkware.cairo.common.hash_state",
                        "starkware.cairo.common.hash_state.hash_update"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 13,
                            "offset": 2
                        },
                        "reference_ids": {
                            "starkware.cairo.common.hash_state.hash_update.__fp__": 72,
                            "starkware.cairo.common.hash_state.hash_update.data_length": 68,
                            "starkware.cairo.common.hash_state.hash_update.data_ptr": 67,
                            "starkware.cairo.common.hash_state.hash_update.hash": 71,
                            "starkware.cairo.common.hash_state.hash_update.hash_ptr": 70,
                            "starkware.cairo.common.hash_state.hash_update.hash_state_ptr": 66,
                            "starkware.cairo.common.hash_state.hash_update.new_hash_state": 73
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 39,
                        "end_line": 81,
                        "input_file": {
                            "filename": "/Users/jakubptak/Library/Caches/pypoetry/virtualenvs/starkware-python-sdk-L_CLq0Mm-py3.7/lib/python3.7/site-packages/starkware/cairo/common/hash_state.cairo"
                        },
                        "start_col": 5,
                        "start_line": 81
                    }
                },
                "123": {
                    "accessible_scopes": [
                        "starkware.cairo.common.hash_state",
                        "starkware.cairo.common.hash_state.hash_update"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 13,
                            "offset": 2
                        },
                        "reference_ids": {
                            "starkware.cairo.common.hash_state.hash_update.__fp__": 72,
                            "starkware.cairo.common.hash_state.hash_update.data_length": 68,
                            "starkware.cairo.common.hash_state.hash_update.data_ptr": 67,
                            "starkware.cairo.common.hash_state.hash_update.hash": 71,
                            "starkware.cairo.common.hash_state.hash_update.hash_ptr": 70,
                            "starkware.cairo.common.hash_state.hash_update.hash_state_ptr": 66,
                            "starkware.cairo.common.hash_state.hash_update.new_hash_state": 73
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 59,
                        "end_line": 82,
                        "input_file": {
                            "filename": "/Users/jakubptak/Library/Caches/pypoetry/virtualenvs/starkware-python-sdk-L_CLq0Mm-py3.7/lib/python3.7/site-packages/starkware/cairo/common/hash_state.cairo"
                        },
                        "start_col": 37,
                        "start_line": 82
                    }
                },
                "124": {
                    "accessible_scopes": [
                        "starkware.cairo.common.hash_state",
                        "starkware.cairo.common.hash_state.hash_update"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 13,
                            "offset": 3
                        },
                        "reference_ids": {
                            "starkware.cairo.common.hash_state.hash_update.__fp__": 72,
                            "starkware.cairo.common.hash_state.hash_update.__temp9": 74,
                            "starkware.cairo.common.hash_state.hash_update.data_length": 68,
                            "starkware.cairo.common.hash_state.hash_update.data_ptr": 67,
                            "starkware.cairo.common.hash_state.hash_update.hash": 71,
                            "starkware.cairo.common.hash_state.hash_update.hash_ptr": 70,
                            "starkware.cairo.common.hash_state.hash_update.hash_state_ptr": 66,
                            "starkware.cairo.common.hash_state.hash_update.new_hash_state": 73
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 73,
                        "end_line": 82,
                        "input_file": {
                            "filename": "/Users/jakubptak/Library/Caches/pypoetry/virtualenvs/starkware-python-sdk-L_CLq0Mm-py3.7/lib/python3.7/site-packages/starkware/cairo/common/hash_state.cairo"
                        },
                        "start_col": 5,
                        "start_line": 82
                    }
                },
                "125": {
                    "accessible_scopes": [
                        "starkware.cairo.common.hash_state",
                        "starkware.cairo.common.hash_state.hash_update"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 13,
                            "offset": 3
                        },
                        "reference_ids": {
                            "starkware.cairo.common.hash_state.hash_update.__fp__": 72,
                            "starkware.cairo.common.hash_state.hash_update.__temp9": 74,
                            "starkware.cairo.common.hash_state.hash_update.data_length": 68,
                            "starkware.cairo.common.hash_state.hash_update.data_ptr": 67,
                            "starkware.cairo.common.hash_state.hash_update.hash": 71,
                            "starkware.cairo.common.hash_state.hash_update.hash_ptr": 70,
                            "starkware.cairo.common.hash_state.hash_update.hash_state_ptr": 66,
                            "starkware.cairo.common.hash_state.hash_update.new_hash_state": 73
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 47,
                        "end_line": 27,
                        "input_file": {
                            "filename": "/Users/jakubptak/Library/Caches/pypoetry/virtualenvs/starkware-python-sdk-L_CLq0Mm-py3.7/lib/python3.7/site-packages/starkware/cairo/common/hash_state.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 86,
                                "end_line": 78,
                                "input_file": {
                                    "filename": "/Users/jakubptak/Library/Caches/pypoetry/virtualenvs/starkware-python-sdk-L_CLq0Mm-py3.7/lib/python3.7/site-packages/starkware/cairo/common/hash_state.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 41,
                                        "end_line": 73,
                                        "input_file": {
                                            "filename": "/Users/jakubptak/Library/Caches/pypoetry/virtualenvs/starkware-python-sdk-L_CLq0Mm-py3.7/lib/python3.7/site-packages/starkware/cairo/common/hash_state.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 48,
                                                "end_line": 83,
                                                "input_file": {
                                                    "filename": "/Users/jakubptak/Library/Caches/pypoetry/virtualenvs/starkware-python-sdk-L_CLq0Mm-py3.7/lib/python3.7/site-packages/starkware/cairo/common/hash_state.cairo"
                                                },
                                                "start_col": 5,
                                                "start_line": 83
                                            },
                                            "While trying to retrieve the implicit argument 'hash_ptr' in:"
                                        ],
                                        "start_col": 18,
                                        "start_line": 73
                                    },
                                    "While expanding the reference 'hash_ptr' in:"
                                ],
                                "start_col": 18,
                                "start_line": 77
                            },
                            "While trying to update the implicit return value 'hash_ptr' in:"
                        ],
                        "start_col": 24,
                        "start_line": 27
                    }
                },
                "126": {
                    "accessible_scopes": [
                        "starkware.cairo.common.hash_state",
                        "starkware.cairo.common.hash_state.hash_update"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 13,
                            "offset": 4
                        },
                        "reference_ids": {
                            "starkware.cairo.common.hash_state.hash_update.__fp__": 72,
                            "starkware.cairo.common.hash_state.hash_update.__temp9": 74,
                            "starkware.cairo.common.hash_state.hash_update.data_length": 68,
                            "starkware.cairo.common.hash_state.hash_update.data_ptr": 67,
                            "starkware.cairo.common.hash_state.hash_update.hash": 71,
                            "starkware.cairo.common.hash_state.hash_update.hash_ptr": 70,
                            "starkware.cairo.common.hash_state.hash_update.hash_state_ptr": 66,
                            "starkware.cairo.common.hash_state.hash_update.new_hash_state": 73
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 25,
                        "end_line": 80,
                        "input_file": {
                            "filename": "/Users/jakubptak/Library/Caches/pypoetry/virtualenvs/starkware-python-sdk-L_CLq0Mm-py3.7/lib/python3.7/site-packages/starkware/cairo/common/hash_state.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 47,
                                "end_line": 83,
                                "input_file": {
                                    "filename": "/Users/jakubptak/Library/Caches/pypoetry/virtualenvs/starkware-python-sdk-L_CLq0Mm-py3.7/lib/python3.7/site-packages/starkware/cairo/common/hash_state.cairo"
                                },
                                "start_col": 33,
                                "start_line": 83
                            },
                            "While expanding the reference 'new_hash_state' in:"
                        ],
                        "start_col": 11,
                        "start_line": 80
                    }
                },
                "127": {
                    "accessible_scopes": [
                        "starkware.cairo.common.hash_state",
                        "starkware.cairo.common.hash_state.hash_update"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 13,
                            "offset": 5
                        },
                        "reference_ids": {
                            "starkware.cairo.common.hash_state.hash_update.__fp__": 72,
                            "starkware.cairo.common.hash_state.hash_update.__temp9": 74,
                            "starkware.cairo.common.hash_state.hash_update.data_length": 68,
                            "starkware.cairo.common.hash_state.hash_update.data_ptr": 67,
                            "starkware.cairo.common.hash_state.hash_update.hash": 71,
                            "starkware.cairo.common.hash_state.hash_update.hash_ptr": 70,
                            "starkware.cairo.common.hash_state.hash_update.hash_state_ptr": 66,
                            "starkware.cairo.common.hash_state.hash_update.new_hash_state": 73
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 48,
                        "end_line": 83,
                        "input_file": {
                            "filename": "/Users/jakubptak/Library/Caches/pypoetry/virtualenvs/starkware-python-sdk-L_CLq0Mm-py3.7/lib/python3.7/site-packages/starkware/cairo/common/hash_state.cairo"
                        },
                        "start_col": 5,
                        "start_line": 83
                    }
                },
                "128": {
                    "accessible_scopes": [
                        "starkware.cairo.common.hash_state",
                        "starkware.cairo.common.hash_state.hash_update_single"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 14,
                            "offset": 0
                        },
                        "reference_ids": {
                            "starkware.cairo.common.hash_state.hash_update_single.hash_ptr": 77,
                            "starkware.cairo.common.hash_state.hash_update_single.hash_state_ptr": 75,
                            "starkware.cairo.common.hash_state.hash_update_single.item": 76
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 17,
                        "end_line": 89,
                        "input_file": {
                            "filename": "/Users/jakubptak/Library/Caches/pypoetry/virtualenvs/starkware-python-sdk-L_CLq0Mm-py3.7/lib/python3.7/site-packages/starkware/cairo/common/hash_state.cairo"
                        },
                        "start_col": 5,
                        "start_line": 89
                    }
                },
                "130": {
                    "accessible_scopes": [
                        "starkware.cairo.common.hash_state",
                        "starkware.cairo.common.hash_state.hash_update_single"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 14,
                            "offset": 2
                        },
                        "reference_ids": {
                            "starkware.cairo.common.hash_state.hash_update_single.hash_ptr": 77,
                            "starkware.cairo.common.hash_state.hash_update_single.hash_state_ptr": 75,
                            "starkware.cairo.common.hash_state.hash_update_single.item": 76
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 48,
                        "end_line": 87,
                        "input_file": {
                            "filename": "/Users/jakubptak/Library/Caches/pypoetry/virtualenvs/starkware-python-sdk-L_CLq0Mm-py3.7/lib/python3.7/site-packages/starkware/cairo/common/hash_state.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 35,
                                "end_line": 13,
                                "input_file": {
                                    "filename": "/Users/jakubptak/Library/Caches/pypoetry/virtualenvs/starkware-python-sdk-L_CLq0Mm-py3.7/lib/python3.7/site-packages/starkware/cairo/common/hash.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 62,
                                        "end_line": 90,
                                        "input_file": {
                                            "filename": "/Users/jakubptak/Library/Caches/pypoetry/virtualenvs/starkware-python-sdk-L_CLq0Mm-py3.7/lib/python3.7/site-packages/starkware/cairo/common/hash_state.cairo"
                                        },
                                        "start_col": 18,
                                        "start_line": 90
                                    },
                                    "While trying to retrieve the implicit argument 'hash_ptr' in:"
                                ],
                                "start_col": 12,
                                "start_line": 13
                            },
                            "While expanding the reference 'hash_ptr' in:"
                        ],
                        "start_col": 25,
                        "start_line": 87
                    }
                },
                "131": {
                    "accessible_scopes": [
                        "starkware.cairo.common.hash_state",
                        "starkware.cairo.common.hash_state.hash_update_single"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 14,
                            "offset": 3
                        },
                        "reference_ids": {
                            "starkware.cairo.common.hash_state.hash_update_single.hash_ptr": 77,
                            "starkware.cairo.common.hash_state.hash_update_single.hash_state_ptr": 75,
                            "starkware.cairo.common.hash_state.hash_update_single.item": 76
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 53,
                        "end_line": 90,
                        "input_file": {
                            "filename": "/Users/jakubptak/Library/Caches/pypoetry/virtualenvs/starkware-python-sdk-L_CLq0Mm-py3.7/lib/python3.7/site-packages/starkware/cairo/common/hash_state.cairo"
                        },
                        "start_col": 26,
                        "start_line": 90
                    }
                },
                "132": {
                    "accessible_scopes": [
                        "starkware.cairo.common.hash_state",
                        "starkware.cairo.common.hash_state.hash_update_single"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 14,
                            "offset": 4
                        },
                        "reference_ids": {
                            "starkware.cairo.common.hash_state.hash_update_single.hash_ptr": 77,
                            "starkware.cairo.common.hash_state.hash_update_single.hash_state_ptr": 75,
                            "starkware.cairo.common.hash_state.hash_update_single.item": 76
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 83,
                        "end_line": 87,
                        "input_file": {
                            "filename": "/Users/jakubptak/Library/Caches/pypoetry/virtualenvs/starkware-python-sdk-L_CLq0Mm-py3.7/lib/python3.7/site-packages/starkware/cairo/common/hash_state.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 61,
                                "end_line": 90,
                                "input_file": {
                                    "filename": "/Users/jakubptak/Library/Caches/pypoetry/virtualenvs/starkware-python-sdk-L_CLq0Mm-py3.7/lib/python3.7/site-packages/starkware/cairo/common/hash_state.cairo"
                                },
                                "start_col": 57,
                                "start_line": 90
                            },
                            "While expanding the reference 'item' in:"
                        ],
                        "start_col": 79,
                        "start_line": 87
                    }
                },
                "133": {
                    "accessible_scopes": [
                        "starkware.cairo.common.hash_state",
                        "starkware.cairo.common.hash_state.hash_update_single"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 14,
                            "offset": 5
                        },
                        "reference_ids": {
                            "starkware.cairo.common.hash_state.hash_update_single.hash_ptr": 77,
                            "starkware.cairo.common.hash_state.hash_update_single.hash_state_ptr": 75,
                            "starkware.cairo.common.hash_state.hash_update_single.item": 76
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 62,
                        "end_line": 90,
                        "input_file": {
                            "filename": "/Users/jakubptak/Library/Caches/pypoetry/virtualenvs/starkware-python-sdk-L_CLq0Mm-py3.7/lib/python3.7/site-packages/starkware/cairo/common/hash_state.cairo"
                        },
                        "start_col": 18,
                        "start_line": 90
                    }
                },
                "135": {
                    "accessible_scopes": [
                        "starkware.cairo.common.hash_state",
                        "starkware.cairo.common.hash_state.hash_update_single"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 14,
                            "offset": 9
                        },
                        "reference_ids": {
                            "starkware.cairo.common.hash_state.hash_update_single.hash": 79,
                            "starkware.cairo.common.hash_state.hash_update_single.hash_ptr": 78,
                            "starkware.cairo.common.hash_state.hash_update_single.hash_state_ptr": 75,
                            "starkware.cairo.common.hash_state.hash_update_single.item": 76
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 38,
                        "end_line": 91,
                        "input_file": {
                            "filename": "/Users/jakubptak/Library/Caches/pypoetry/virtualenvs/starkware-python-sdk-L_CLq0Mm-py3.7/lib/python3.7/site-packages/starkware/cairo/common/hash_state.cairo"
                        },
                        "start_col": 23,
                        "start_line": 91
                    }
                },
                "137": {
                    "accessible_scopes": [
                        "starkware.cairo.common.hash_state",
                        "starkware.cairo.common.hash_state.hash_update_single"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 14,
                            "offset": 11
                        },
                        "reference_ids": {
                            "starkware.cairo.common.hash_state.hash_update_single.__fp__": 80,
                            "starkware.cairo.common.hash_state.hash_update_single.hash": 79,
                            "starkware.cairo.common.hash_state.hash_update_single.hash_ptr": 78,
                            "starkware.cairo.common.hash_state.hash_update_single.hash_state_ptr": 75,
                            "starkware.cairo.common.hash_state.hash_update_single.item": 76,
                            "starkware.cairo.common.hash_state.hash_update_single.new_hash_state": 81
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 39,
                        "end_line": 93,
                        "input_file": {
                            "filename": "/Users/jakubptak/Library/Caches/pypoetry/virtualenvs/starkware-python-sdk-L_CLq0Mm-py3.7/lib/python3.7/site-packages/starkware/cairo/common/hash_state.cairo"
                        },
                        "start_col": 5,
                        "start_line": 93
                    }
                },
                "138": {
                    "accessible_scopes": [
                        "starkware.cairo.common.hash_state",
                        "starkware.cairo.common.hash_state.hash_update_single"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 14,
                            "offset": 11
                        },
                        "reference_ids": {
                            "starkware.cairo.common.hash_state.hash_update_single.__fp__": 80,
                            "starkware.cairo.common.hash_state.hash_update_single.hash": 79,
                            "starkware.cairo.common.hash_state.hash_update_single.hash_ptr": 78,
                            "starkware.cairo.common.hash_state.hash_update_single.hash_state_ptr": 75,
                            "starkware.cairo.common.hash_state.hash_update_single.item": 76,
                            "starkware.cairo.common.hash_state.hash_update_single.new_hash_state": 81
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 59,
                        "end_line": 94,
                        "input_file": {
                            "filename": "/Users/jakubptak/Library/Caches/pypoetry/virtualenvs/starkware-python-sdk-L_CLq0Mm-py3.7/lib/python3.7/site-packages/starkware/cairo/common/hash_state.cairo"
                        },
                        "start_col": 37,
                        "start_line": 94
                    }
                },
                "139": {
                    "accessible_scopes": [
                        "starkware.cairo.common.hash_state",
                        "starkware.cairo.common.hash_state.hash_update_single"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 14,
                            "offset": 12
                        },
                        "reference_ids": {
                            "starkware.cairo.common.hash_state.hash_update_single.__fp__": 80,
                            "starkware.cairo.common.hash_state.hash_update_single.__temp10": 82,
                            "starkware.cairo.common.hash_state.hash_update_single.hash": 79,
                            "starkware.cairo.common.hash_state.hash_update_single.hash_ptr": 78,
                            "starkware.cairo.common.hash_state.hash_update_single.hash_state_ptr": 75,
                            "starkware.cairo.common.hash_state.hash_update_single.item": 76,
                            "starkware.cairo.common.hash_state.hash_update_single.new_hash_state": 81
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 63,
                        "end_line": 94,
                        "input_file": {
                            "filename": "/Users/jakubptak/Library/Caches/pypoetry/virtualenvs/starkware-python-sdk-L_CLq0Mm-py3.7/lib/python3.7/site-packages/starkware/cairo/common/hash_state.cairo"
                        },
                        "start_col": 5,
                        "start_line": 94
                    }
                },
                "141": {
                    "accessible_scopes": [
                        "starkware.cairo.common.hash_state",
                        "starkware.cairo.common.hash_state.hash_update_single"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 14,
                            "offset": 12
                        },
                        "reference_ids": {
                            "starkware.cairo.common.hash_state.hash_update_single.__fp__": 80,
                            "starkware.cairo.common.hash_state.hash_update_single.__temp10": 82,
                            "starkware.cairo.common.hash_state.hash_update_single.hash": 79,
                            "starkware.cairo.common.hash_state.hash_update_single.hash_ptr": 78,
                            "starkware.cairo.common.hash_state.hash_update_single.hash_state_ptr": 75,
                            "starkware.cairo.common.hash_state.hash_update_single.item": 76,
                            "starkware.cairo.common.hash_state.hash_update_single.new_hash_state": 81
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 35,
                        "end_line": 13,
                        "input_file": {
                            "filename": "/Users/jakubptak/Library/Caches/pypoetry/virtualenvs/starkware-python-sdk-L_CLq0Mm-py3.7/lib/python3.7/site-packages/starkware/cairo/common/hash.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 62,
                                "end_line": 90,
                                "input_file": {
                                    "filename": "/Users/jakubptak/Library/Caches/pypoetry/virtualenvs/starkware-python-sdk-L_CLq0Mm-py3.7/lib/python3.7/site-packages/starkware/cairo/common/hash_state.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 48,
                                        "end_line": 87,
                                        "input_file": {
                                            "filename": "/Users/jakubptak/Library/Caches/pypoetry/virtualenvs/starkware-python-sdk-L_CLq0Mm-py3.7/lib/python3.7/site-packages/starkware/cairo/common/hash_state.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 48,
                                                "end_line": 95,
                                                "input_file": {
                                                    "filename": "/Users/jakubptak/Library/Caches/pypoetry/virtualenvs/starkware-python-sdk-L_CLq0Mm-py3.7/lib/python3.7/site-packages/starkware/cairo/common/hash_state.cairo"
                                                },
                                                "start_col": 5,
                                                "start_line": 95
                                            },
                                            "While trying to retrieve the implicit argument 'hash_ptr' in:"
                                        ],
                                        "start_col": 25,
                                        "start_line": 87
                                    },
                                    "While expanding the reference 'hash_ptr' in:"
                                ],
                                "start_col": 18,
                                "start_line": 90
                            },
                            "While trying to update the implicit return value 'hash_ptr' in:"
                        ],
                        "start_col": 12,
                        "start_line": 13
                    }
                },
                "142": {
                    "accessible_scopes": [
                        "starkware.cairo.common.hash_state",
                        "starkware.cairo.common.hash_state.hash_update_single"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 14,
                            "offset": 13
                        },
                        "reference_ids": {
                            "starkware.cairo.common.hash_state.hash_update_single.__fp__": 80,
                            "starkware.cairo.common.hash_state.hash_update_single.__temp10": 82,
                            "starkware.cairo.common.hash_state.hash_update_single.hash": 79,
                            "starkware.cairo.common.hash_state.hash_update_single.hash_ptr": 78,
                            "starkware.cairo.common.hash_state.hash_update_single.hash_state_ptr": 75,
                            "starkware.cairo.common.hash_state.hash_update_single.item": 76,
                            "starkware.cairo.common.hash_state.hash_update_single.new_hash_state": 81
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 25,
                        "end_line": 92,
                        "input_file": {
                            "filename": "/Users/jakubptak/Library/Caches/pypoetry/virtualenvs/starkware-python-sdk-L_CLq0Mm-py3.7/lib/python3.7/site-packages/starkware/cairo/common/hash_state.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 47,
                                "end_line": 95,
                                "input_file": {
                                    "filename": "/Users/jakubptak/Library/Caches/pypoetry/virtualenvs/starkware-python-sdk-L_CLq0Mm-py3.7/lib/python3.7/site-packages/starkware/cairo/common/hash_state.cairo"
                                },
                                "start_col": 33,
                                "start_line": 95
                            },
                            "While expanding the reference 'new_hash_state' in:"
                        ],
                        "start_col": 11,
                        "start_line": 92
                    }
                },
                "143": {
                    "accessible_scopes": [
                        "starkware.cairo.common.hash_state",
                        "starkware.cairo.common.hash_state.hash_update_single"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 14,
                            "offset": 14
                        },
                        "reference_ids": {
                            "starkware.cairo.common.hash_state.hash_update_single.__fp__": 80,
                            "starkware.cairo.common.hash_state.hash_update_single.__temp10": 82,
                            "starkware.cairo.common.hash_state.hash_update_single.hash": 79,
                            "starkware.cairo.common.hash_state.hash_update_single.hash_ptr": 78,
                            "starkware.cairo.common.hash_state.hash_update_single.hash_state_ptr": 75,
                            "starkware.cairo.common.hash_state.hash_update_single.item": 76,
                            "starkware.cairo.common.hash_state.hash_update_single.new_hash_state": 81
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 48,
                        "end_line": 95,
                        "input_file": {
                            "filename": "/Users/jakubptak/Library/Caches/pypoetry/virtualenvs/starkware-python-sdk-L_CLq0Mm-py3.7/lib/python3.7/site-packages/starkware/cairo/common/hash_state.cairo"
                        },
                        "start_col": 5,
                        "start_line": 95
                    }
                },
                "144": {
                    "accessible_scopes": [
                        "starkware.cairo.common.hash_state",
                        "starkware.cairo.common.hash_state.hash_finalize"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 15,
                            "offset": 0
                        },
                        "reference_ids": {
                            "starkware.cairo.common.hash_state.hash_finalize.hash_ptr": 84,
                            "starkware.cairo.common.hash_state.hash_finalize.hash_state_ptr": 83
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 43,
                        "end_line": 99,
                        "input_file": {
                            "filename": "/Users/jakubptak/Library/Caches/pypoetry/virtualenvs/starkware-python-sdk-L_CLq0Mm-py3.7/lib/python3.7/site-packages/starkware/cairo/common/hash_state.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 35,
                                "end_line": 13,
                                "input_file": {
                                    "filename": "/Users/jakubptak/Library/Caches/pypoetry/virtualenvs/starkware-python-sdk-L_CLq0Mm-py3.7/lib/python3.7/site-packages/starkware/cairo/common/hash.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 74,
                                        "end_line": 100,
                                        "input_file": {
                                            "filename": "/Users/jakubptak/Library/Caches/pypoetry/virtualenvs/starkware-python-sdk-L_CLq0Mm-py3.7/lib/python3.7/site-packages/starkware/cairo/common/hash_state.cairo"
                                        },
                                        "start_col": 12,
                                        "start_line": 100
                                    },
                                    "While trying to retrieve the implicit argument 'hash_ptr' in:"
                                ],
                                "start_col": 12,
                                "start_line": 13
                            },
                            "While expanding the reference 'hash_ptr' in:"
                        ],
                        "start_col": 20,
                        "start_line": 99
                    }
                },
                "145": {
                    "accessible_scopes": [
                        "starkware.cairo.common.hash_state",
                        "starkware.cairo.common.hash_state.hash_finalize"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 15,
                            "offset": 1
                        },
                        "reference_ids": {
                            "starkware.cairo.common.hash_state.hash_finalize.hash_ptr": 84,
                            "starkware.cairo.common.hash_state.hash_finalize.hash_state_ptr": 83
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 47,
                        "end_line": 100,
                        "input_file": {
                            "filename": "/Users/jakubptak/Library/Caches/pypoetry/virtualenvs/starkware-python-sdk-L_CLq0Mm-py3.7/lib/python3.7/site-packages/starkware/cairo/common/hash_state.cairo"
                        },
                        "start_col": 20,
                        "start_line": 100
                    }
                },
                "146": {
                    "accessible_scopes": [
                        "starkware.cairo.common.hash_state",
                        "starkware.cairo.common.hash_state.hash_finalize"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 15,
                            "offset": 2
                        },
                        "reference_ids": {
                            "starkware.cairo.common.hash_state.hash_finalize.hash_ptr": 84,
                            "starkware.cairo.common.hash_state.hash_finalize.hash_state_ptr": 83
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 73,
                        "end_line": 100,
                        "input_file": {
                            "filename": "/Users/jakubptak/Library/Caches/pypoetry/virtualenvs/starkware-python-sdk-L_CLq0Mm-py3.7/lib/python3.7/site-packages/starkware/cairo/common/hash_state.cairo"
                        },
                        "start_col": 51,
                        "start_line": 100
                    }
                },
                "147": {
                    "accessible_scopes": [
                        "starkware.cairo.common.hash_state",
                        "starkware.cairo.common.hash_state.hash_finalize"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 15,
                            "offset": 3
                        },
                        "reference_ids": {
                            "starkware.cairo.common.hash_state.hash_finalize.hash_ptr": 84,
                            "starkware.cairo.common.hash_state.hash_finalize.hash_state_ptr": 83
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 74,
                        "end_line": 100,
                        "input_file": {
                            "filename": "/Users/jakubptak/Library/Caches/pypoetry/virtualenvs/starkware-python-sdk-L_CLq0Mm-py3.7/lib/python3.7/site-packages/starkware/cairo/common/hash_state.cairo"
                        },
                        "start_col": 12,
                        "start_line": 100
                    }
                },
                "149": {
                    "accessible_scopes": [
                        "starkware.cairo.common.hash_state",
                        "starkware.cairo.common.hash_state.hash_finalize"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 15,
                            "offset": 7
                        },
                        "reference_ids": {
                            "starkware.cairo.common.hash_state.hash_finalize.hash_ptr": 85,
                            "starkware.cairo.common.hash_state.hash_finalize.hash_state_ptr": 83
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 74,
                        "end_line": 100,
                        "input_file": {
                            "filename": "/Users/jakubptak/Library/Caches/pypoetry/virtualenvs/starkware-python-sdk-L_CLq0Mm-py3.7/lib/python3.7/site-packages/starkware/cairo/common/hash_state.cairo"
                        },
                        "start_col": 5,
                        "start_line": 100
                    }
                },
                "150": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__.current_nonce",
                        "__main__.current_nonce.addr"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 16,
                            "offset": 0
                        },
                        "reference_ids": {
                            "__main__.current_nonce.addr.pedersen_ptr": 86,
                            "__main__.current_nonce.addr.range_check_ptr": 87,
                            "__main__.current_nonce.addr.res": 88
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 42,
                        "end_line": 7,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/current_nonce/impl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 42,
                                "end_line": 7,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/current_nonce/decl.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 25,
                                        "end_line": 9,
                                        "input_file": {
                                            "filename": "autogen/starknet/storage_var/current_nonce/impl.cairo"
                                        },
                                        "start_col": 9,
                                        "start_line": 9
                                    },
                                    "While trying to retrieve the implicit argument 'pedersen_ptr' in:"
                                ],
                                "start_col": 15,
                                "start_line": 7
                            },
                            "While expanding the reference 'pedersen_ptr' in:"
                        ],
                        "start_col": 15,
                        "start_line": 7
                    }
                },
                "151": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__.current_nonce",
                        "__main__.current_nonce.addr"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 16,
                            "offset": 1
                        },
                        "reference_ids": {
                            "__main__.current_nonce.addr.pedersen_ptr": 86,
                            "__main__.current_nonce.addr.range_check_ptr": 87,
                            "__main__.current_nonce.addr.res": 88
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 59,
                        "end_line": 7,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/current_nonce/impl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 59,
                                "end_line": 7,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/current_nonce/decl.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 25,
                                        "end_line": 9,
                                        "input_file": {
                                            "filename": "autogen/starknet/storage_var/current_nonce/impl.cairo"
                                        },
                                        "start_col": 9,
                                        "start_line": 9
                                    },
                                    "While trying to retrieve the implicit argument 'range_check_ptr' in:"
                                ],
                                "start_col": 44,
                                "start_line": 7
                            },
                            "While expanding the reference 'range_check_ptr' in:"
                        ],
                        "start_col": 44,
                        "start_line": 7
                    }
                },
                "152": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__.current_nonce",
                        "__main__.current_nonce.addr"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 16,
                            "offset": 2
                        },
                        "reference_ids": {
                            "__main__.current_nonce.addr.pedersen_ptr": 86,
                            "__main__.current_nonce.addr.range_check_ptr": 87,
                            "__main__.current_nonce.addr.res": 88
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 95,
                        "end_line": 8,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/current_nonce/impl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 24,
                                "end_line": 9,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/current_nonce/impl.cairo"
                                },
                                "start_col": 21,
                                "start_line": 9
                            },
                            "While expanding the reference 'res' in:"
                        ],
                        "start_col": 19,
                        "start_line": 8
                    }
                },
                "154": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__.current_nonce",
                        "__main__.current_nonce.addr"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 16,
                            "offset": 3
                        },
                        "reference_ids": {
                            "__main__.current_nonce.addr.pedersen_ptr": 86,
                            "__main__.current_nonce.addr.range_check_ptr": 87,
                            "__main__.current_nonce.addr.res": 88
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 25,
                        "end_line": 9,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/current_nonce/impl.cairo"
                        },
                        "start_col": 9,
                        "start_line": 9
                    }
                },
                "155": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__.current_nonce",
                        "__main__.current_nonce.read"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 17,
                            "offset": 0
                        },
                        "reference_ids": {
                            "__main__.current_nonce.read.pedersen_ptr": 90,
                            "__main__.current_nonce.read.range_check_ptr": 91,
                            "__main__.current_nonce.read.syscall_ptr": 89
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 63,
                        "end_line": 12,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/current_nonce/impl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 42,
                                "end_line": 7,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/current_nonce/decl.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 36,
                                        "end_line": 13,
                                        "input_file": {
                                            "filename": "autogen/starknet/storage_var/current_nonce/impl.cairo"
                                        },
                                        "start_col": 30,
                                        "start_line": 13
                                    },
                                    "While trying to retrieve the implicit argument 'pedersen_ptr' in:"
                                ],
                                "start_col": 15,
                                "start_line": 7
                            },
                            "While expanding the reference 'pedersen_ptr' in:"
                        ],
                        "start_col": 36,
                        "start_line": 12
                    }
                },
                "156": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__.current_nonce",
                        "__main__.current_nonce.read"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 17,
                            "offset": 1
                        },
                        "reference_ids": {
                            "__main__.current_nonce.read.pedersen_ptr": 90,
                            "__main__.current_nonce.read.range_check_ptr": 91,
                            "__main__.current_nonce.read.syscall_ptr": 89
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 80,
                        "end_line": 12,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/current_nonce/impl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 59,
                                "end_line": 7,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/current_nonce/decl.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 36,
                                        "end_line": 13,
                                        "input_file": {
                                            "filename": "autogen/starknet/storage_var/current_nonce/impl.cairo"
                                        },
                                        "start_col": 30,
                                        "start_line": 13
                                    },
                                    "While trying to retrieve the implicit argument 'range_check_ptr' in:"
                                ],
                                "start_col": 44,
                                "start_line": 7
                            },
                            "While expanding the reference 'range_check_ptr' in:"
                        ],
                        "start_col": 65,
                        "start_line": 12
                    }
                },
                "157": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__.current_nonce",
                        "__main__.current_nonce.read"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 17,
                            "offset": 2
                        },
                        "reference_ids": {
                            "__main__.current_nonce.read.pedersen_ptr": 90,
                            "__main__.current_nonce.read.range_check_ptr": 91,
                            "__main__.current_nonce.read.syscall_ptr": 89
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 36,
                        "end_line": 13,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/current_nonce/impl.cairo"
                        },
                        "start_col": 30,
                        "start_line": 13
                    }
                },
                "159": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__.current_nonce",
                        "__main__.current_nonce.read"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 17,
                            "offset": 7
                        },
                        "reference_ids": {
                            "__main__.current_nonce.read.pedersen_ptr": 92,
                            "__main__.current_nonce.read.range_check_ptr": 93,
                            "__main__.current_nonce.read.storage_addr": 94,
                            "__main__.current_nonce.read.syscall_ptr": 89
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 34,
                        "end_line": 12,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/current_nonce/impl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 38,
                                "end_line": 199,
                                "input_file": {
                                    "filename": "/Users/jakubptak/Library/Caches/pypoetry/virtualenvs/starkware-python-sdk-L_CLq0Mm-py3.7/lib/python3.7/site-packages/starkware/starknet/common/syscalls.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 75,
                                        "end_line": 14,
                                        "input_file": {
                                            "filename": "autogen/starknet/storage_var/current_nonce/impl.cairo"
                                        },
                                        "start_col": 37,
                                        "start_line": 14
                                    },
                                    "While trying to retrieve the implicit argument 'syscall_ptr' in:"
                                ],
                                "start_col": 19,
                                "start_line": 199
                            },
                            "While expanding the reference 'syscall_ptr' in:"
                        ],
                        "start_col": 15,
                        "start_line": 12
                    }
                },
                "160": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__.current_nonce",
                        "__main__.current_nonce.read"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 17,
                            "offset": 8
                        },
                        "reference_ids": {
                            "__main__.current_nonce.read.pedersen_ptr": 92,
                            "__main__.current_nonce.read.range_check_ptr": 93,
                            "__main__.current_nonce.read.storage_addr": 94,
                            "__main__.current_nonce.read.syscall_ptr": 89
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 26,
                        "end_line": 13,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/current_nonce/impl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 70,
                                "end_line": 14,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/current_nonce/impl.cairo"
                                },
                                "start_col": 58,
                                "start_line": 14
                            },
                            "While expanding the reference 'storage_addr' in:"
                        ],
                        "start_col": 14,
                        "start_line": 13
                    }
                },
                "161": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__.current_nonce",
                        "__main__.current_nonce.read"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 17,
                            "offset": 9
                        },
                        "reference_ids": {
                            "__main__.current_nonce.read.pedersen_ptr": 92,
                            "__main__.current_nonce.read.range_check_ptr": 93,
                            "__main__.current_nonce.read.storage_addr": 94,
                            "__main__.current_nonce.read.syscall_ptr": 89
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 75,
                        "end_line": 14,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/current_nonce/impl.cairo"
                        },
                        "start_col": 37,
                        "start_line": 14
                    }
                },
                "163": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__.current_nonce",
                        "__main__.current_nonce.read"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 17,
                            "offset": 14
                        },
                        "reference_ids": {
                            "__main__.current_nonce.read.__storage_var_temp0": 96,
                            "__main__.current_nonce.read.pedersen_ptr": 92,
                            "__main__.current_nonce.read.range_check_ptr": 93,
                            "__main__.current_nonce.read.storage_addr": 94,
                            "__main__.current_nonce.read.syscall_ptr": 95
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 38,
                        "end_line": 199,
                        "input_file": {
                            "filename": "/Users/jakubptak/Library/Caches/pypoetry/virtualenvs/starkware-python-sdk-L_CLq0Mm-py3.7/lib/python3.7/site-packages/starkware/starknet/common/syscalls.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 75,
                                "end_line": 14,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/current_nonce/impl.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 42,
                                        "end_line": 16,
                                        "input_file": {
                                            "filename": "autogen/starknet/storage_var/current_nonce/impl.cairo"
                                        },
                                        "start_col": 31,
                                        "start_line": 16
                                    },
                                    "While expanding the reference 'syscall_ptr' in:"
                                ],
                                "start_col": 37,
                                "start_line": 14
                            },
                            "While trying to update the implicit return value 'syscall_ptr' in:"
                        ],
                        "start_col": 19,
                        "start_line": 199
                    }
                },
                "164": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__.current_nonce",
                        "__main__.current_nonce.read"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 17,
                            "offset": 15
                        },
                        "reference_ids": {
                            "__main__.current_nonce.read.__storage_var_temp0": 96,
                            "__main__.current_nonce.read.pedersen_ptr": 92,
                            "__main__.current_nonce.read.range_check_ptr": 93,
                            "__main__.current_nonce.read.storage_addr": 94,
                            "__main__.current_nonce.read.syscall_ptr": 97
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 42,
                        "end_line": 7,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/current_nonce/decl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 36,
                                "end_line": 13,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/current_nonce/impl.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 44,
                                        "end_line": 17,
                                        "input_file": {
                                            "filename": "autogen/starknet/storage_var/current_nonce/impl.cairo"
                                        },
                                        "start_col": 32,
                                        "start_line": 17
                                    },
                                    "While expanding the reference 'pedersen_ptr' in:"
                                ],
                                "start_col": 30,
                                "start_line": 13
                            },
                            "While trying to update the implicit return value 'pedersen_ptr' in:"
                        ],
                        "start_col": 15,
                        "start_line": 7
                    }
                },
                "165": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__.current_nonce",
                        "__main__.current_nonce.read"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 17,
                            "offset": 16
                        },
                        "reference_ids": {
                            "__main__.current_nonce.read.__storage_var_temp0": 96,
                            "__main__.current_nonce.read.pedersen_ptr": 98,
                            "__main__.current_nonce.read.range_check_ptr": 93,
                            "__main__.current_nonce.read.storage_addr": 94,
                            "__main__.current_nonce.read.syscall_ptr": 97
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 59,
                        "end_line": 7,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/current_nonce/decl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 36,
                                "end_line": 13,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/current_nonce/impl.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 50,
                                        "end_line": 18,
                                        "input_file": {
                                            "filename": "autogen/starknet/storage_var/current_nonce/impl.cairo"
                                        },
                                        "start_col": 35,
                                        "start_line": 18
                                    },
                                    "While expanding the reference 'range_check_ptr' in:"
                                ],
                                "start_col": 30,
                                "start_line": 13
                            },
                            "While trying to update the implicit return value 'range_check_ptr' in:"
                        ],
                        "start_col": 44,
                        "start_line": 7
                    }
                },
                "166": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__.current_nonce",
                        "__main__.current_nonce.read"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 17,
                            "offset": 17
                        },
                        "reference_ids": {
                            "__main__.current_nonce.read.__storage_var_temp0": 96,
                            "__main__.current_nonce.read.pedersen_ptr": 98,
                            "__main__.current_nonce.read.range_check_ptr": 99,
                            "__main__.current_nonce.read.storage_addr": 94,
                            "__main__.current_nonce.read.syscall_ptr": 97
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 33,
                        "end_line": 14,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/current_nonce/impl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 65,
                                "end_line": 19,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/current_nonce/impl.cairo"
                                },
                                "start_col": 46,
                                "start_line": 19
                            },
                            "While expanding the reference '__storage_var_temp0' in:"
                        ],
                        "start_col": 14,
                        "start_line": 14
                    }
                },
                "167": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__.current_nonce",
                        "__main__.current_nonce.read"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 17,
                            "offset": 18
                        },
                        "reference_ids": {
                            "__main__.current_nonce.read.__storage_var_temp0": 100,
                            "__main__.current_nonce.read.pedersen_ptr": 98,
                            "__main__.current_nonce.read.range_check_ptr": 99,
                            "__main__.current_nonce.read.storage_addr": 94,
                            "__main__.current_nonce.read.syscall_ptr": 97
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 53,
                        "end_line": 20,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/current_nonce/impl.cairo"
                        },
                        "start_col": 9,
                        "start_line": 20
                    }
                },
                "168": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__.current_nonce",
                        "__main__.current_nonce.write"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 18,
                            "offset": 0
                        },
                        "reference_ids": {
                            "__main__.current_nonce.write.pedersen_ptr": 103,
                            "__main__.current_nonce.write.range_check_ptr": 104,
                            "__main__.current_nonce.write.syscall_ptr": 102,
                            "__main__.current_nonce.write.value": 101
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 64,
                        "end_line": 23,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/current_nonce/impl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 42,
                                "end_line": 7,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/current_nonce/decl.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 36,
                                        "end_line": 24,
                                        "input_file": {
                                            "filename": "autogen/starknet/storage_var/current_nonce/impl.cairo"
                                        },
                                        "start_col": 30,
                                        "start_line": 24
                                    },
                                    "While trying to retrieve the implicit argument 'pedersen_ptr' in:"
                                ],
                                "start_col": 15,
                                "start_line": 7
                            },
                            "While expanding the reference 'pedersen_ptr' in:"
                        ],
                        "start_col": 37,
                        "start_line": 23
                    }
                },
                "169": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__.current_nonce",
                        "__main__.current_nonce.write"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 18,
                            "offset": 1
                        },
                        "reference_ids": {
                            "__main__.current_nonce.write.pedersen_ptr": 103,
                            "__main__.current_nonce.write.range_check_ptr": 104,
                            "__main__.current_nonce.write.syscall_ptr": 102,
                            "__main__.current_nonce.write.value": 101
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 81,
                        "end_line": 23,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/current_nonce/impl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 59,
                                "end_line": 7,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/current_nonce/decl.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 36,
                                        "end_line": 24,
                                        "input_file": {
                                            "filename": "autogen/starknet/storage_var/current_nonce/impl.cairo"
                                        },
                                        "start_col": 30,
                                        "start_line": 24
                                    },
                                    "While trying to retrieve the implicit argument 'range_check_ptr' in:"
                                ],
                                "start_col": 44,
                                "start_line": 7
                            },
                            "While expanding the reference 'range_check_ptr' in:"
                        ],
                        "start_col": 66,
                        "start_line": 23
                    }
                },
                "170": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__.current_nonce",
                        "__main__.current_nonce.write"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 18,
                            "offset": 2
                        },
                        "reference_ids": {
                            "__main__.current_nonce.write.pedersen_ptr": 103,
                            "__main__.current_nonce.write.range_check_ptr": 104,
                            "__main__.current_nonce.write.syscall_ptr": 102,
                            "__main__.current_nonce.write.value": 101
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 36,
                        "end_line": 24,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/current_nonce/impl.cairo"
                        },
                        "start_col": 30,
                        "start_line": 24
                    }
                },
                "172": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__.current_nonce",
                        "__main__.current_nonce.write"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 18,
                            "offset": 7
                        },
                        "reference_ids": {
                            "__main__.current_nonce.write.pedersen_ptr": 105,
                            "__main__.current_nonce.write.range_check_ptr": 106,
                            "__main__.current_nonce.write.storage_addr": 107,
                            "__main__.current_nonce.write.syscall_ptr": 102,
                            "__main__.current_nonce.write.value": 101
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 35,
                        "end_line": 23,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/current_nonce/impl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 39,
                                "end_line": 217,
                                "input_file": {
                                    "filename": "/Users/jakubptak/Library/Caches/pypoetry/virtualenvs/starkware-python-sdk-L_CLq0Mm-py3.7/lib/python3.7/site-packages/starkware/starknet/common/syscalls.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 80,
                                        "end_line": 25,
                                        "input_file": {
                                            "filename": "autogen/starknet/storage_var/current_nonce/impl.cairo"
                                        },
                                        "start_col": 9,
                                        "start_line": 25
                                    },
                                    "While trying to retrieve the implicit argument 'syscall_ptr' in:"
                                ],
                                "start_col": 20,
                                "start_line": 217
                            },
                            "While expanding the reference 'syscall_ptr' in:"
                        ],
                        "start_col": 16,
                        "start_line": 23
                    }
                },
                "173": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__.current_nonce",
                        "__main__.current_nonce.write"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 18,
                            "offset": 8
                        },
                        "reference_ids": {
                            "__main__.current_nonce.write.pedersen_ptr": 105,
                            "__main__.current_nonce.write.range_check_ptr": 106,
                            "__main__.current_nonce.write.storage_addr": 107,
                            "__main__.current_nonce.write.syscall_ptr": 102,
                            "__main__.current_nonce.write.value": 101
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 26,
                        "end_line": 24,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/current_nonce/impl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 43,
                                "end_line": 25,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/current_nonce/impl.cairo"
                                },
                                "start_col": 31,
                                "start_line": 25
                            },
                            "While expanding the reference 'storage_addr' in:"
                        ],
                        "start_col": 14,
                        "start_line": 24
                    }
                },
                "174": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__.current_nonce",
                        "__main__.current_nonce.write"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 18,
                            "offset": 9
                        },
                        "reference_ids": {
                            "__main__.current_nonce.write.pedersen_ptr": 105,
                            "__main__.current_nonce.write.range_check_ptr": 106,
                            "__main__.current_nonce.write.storage_addr": 107,
                            "__main__.current_nonce.write.syscall_ptr": 102,
                            "__main__.current_nonce.write.value": 101
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 79,
                        "end_line": 25,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/current_nonce/impl.cairo"
                        },
                        "start_col": 55,
                        "start_line": 25
                    }
                },
                "175": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__.current_nonce",
                        "__main__.current_nonce.write"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 18,
                            "offset": 10
                        },
                        "reference_ids": {
                            "__main__.current_nonce.write.pedersen_ptr": 105,
                            "__main__.current_nonce.write.range_check_ptr": 106,
                            "__main__.current_nonce.write.storage_addr": 107,
                            "__main__.current_nonce.write.syscall_ptr": 102,
                            "__main__.current_nonce.write.value": 101
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 80,
                        "end_line": 25,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/current_nonce/impl.cairo"
                        },
                        "start_col": 9,
                        "start_line": 25
                    }
                },
                "177": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__.current_nonce",
                        "__main__.current_nonce.write"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 18,
                            "offset": 14
                        },
                        "reference_ids": {
                            "__main__.current_nonce.write.pedersen_ptr": 105,
                            "__main__.current_nonce.write.range_check_ptr": 106,
                            "__main__.current_nonce.write.storage_addr": 107,
                            "__main__.current_nonce.write.syscall_ptr": 108,
                            "__main__.current_nonce.write.value": 101
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 42,
                        "end_line": 7,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/current_nonce/decl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 36,
                                "end_line": 24,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/current_nonce/impl.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 64,
                                        "end_line": 19,
                                        "input_file": {
                                            "filename": "autogen/starknet/storage_var/current_nonce/decl.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 18,
                                                "end_line": 26,
                                                "input_file": {
                                                    "filename": "autogen/starknet/storage_var/current_nonce/impl.cairo"
                                                },
                                                "start_col": 9,
                                                "start_line": 26
                                            },
                                            "While trying to retrieve the implicit argument 'pedersen_ptr' in:"
                                        ],
                                        "start_col": 37,
                                        "start_line": 19
                                    },
                                    "While expanding the reference 'pedersen_ptr' in:"
                                ],
                                "start_col": 30,
                                "start_line": 24
                            },
                            "While trying to update the implicit return value 'pedersen_ptr' in:"
                        ],
                        "start_col": 15,
                        "start_line": 7
                    }
                },
                "178": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__.current_nonce",
                        "__main__.current_nonce.write"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 18,
                            "offset": 15
                        },
                        "reference_ids": {
                            "__main__.current_nonce.write.pedersen_ptr": 105,
                            "__main__.current_nonce.write.range_check_ptr": 106,
                            "__main__.current_nonce.write.storage_addr": 107,
                            "__main__.current_nonce.write.syscall_ptr": 108,
                            "__main__.current_nonce.write.value": 101
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 59,
                        "end_line": 7,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/current_nonce/decl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 36,
                                "end_line": 24,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/current_nonce/impl.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 81,
                                        "end_line": 19,
                                        "input_file": {
                                            "filename": "autogen/starknet/storage_var/current_nonce/decl.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 18,
                                                "end_line": 26,
                                                "input_file": {
                                                    "filename": "autogen/starknet/storage_var/current_nonce/impl.cairo"
                                                },
                                                "start_col": 9,
                                                "start_line": 26
                                            },
                                            "While trying to retrieve the implicit argument 'range_check_ptr' in:"
                                        ],
                                        "start_col": 66,
                                        "start_line": 19
                                    },
                                    "While expanding the reference 'range_check_ptr' in:"
                                ],
                                "start_col": 30,
                                "start_line": 24
                            },
                            "While trying to update the implicit return value 'range_check_ptr' in:"
                        ],
                        "start_col": 44,
                        "start_line": 7
                    }
                },
                "179": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__.current_nonce",
                        "__main__.current_nonce.write"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 18,
                            "offset": 16
                        },
                        "reference_ids": {
                            "__main__.current_nonce.write.pedersen_ptr": 105,
                            "__main__.current_nonce.write.range_check_ptr": 106,
                            "__main__.current_nonce.write.storage_addr": 107,
                            "__main__.current_nonce.write.syscall_ptr": 108,
                            "__main__.current_nonce.write.value": 101
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 18,
                        "end_line": 26,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/current_nonce/impl.cairo"
                        },
                        "start_col": 9,
                        "start_line": 26
                    }
                },
                "180": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__.public_key",
                        "__main__.public_key.addr"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 19,
                            "offset": 0
                        },
                        "reference_ids": {
                            "__main__.public_key.addr.pedersen_ptr": 109,
                            "__main__.public_key.addr.range_check_ptr": 110,
                            "__main__.public_key.addr.res": 111
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 42,
                        "end_line": 7,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/public_key/impl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 42,
                                "end_line": 7,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/public_key/decl.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 25,
                                        "end_line": 9,
                                        "input_file": {
                                            "filename": "autogen/starknet/storage_var/public_key/impl.cairo"
                                        },
                                        "start_col": 9,
                                        "start_line": 9
                                    },
                                    "While trying to retrieve the implicit argument 'pedersen_ptr' in:"
                                ],
                                "start_col": 15,
                                "start_line": 7
                            },
                            "While expanding the reference 'pedersen_ptr' in:"
                        ],
                        "start_col": 15,
                        "start_line": 7
                    }
                },
                "181": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__.public_key",
                        "__main__.public_key.addr"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 19,
                            "offset": 1
                        },
                        "reference_ids": {
                            "__main__.public_key.addr.pedersen_ptr": 109,
                            "__main__.public_key.addr.range_check_ptr": 110,
                            "__main__.public_key.addr.res": 111
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 59,
                        "end_line": 7,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/public_key/impl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 59,
                                "end_line": 7,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/public_key/decl.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 25,
                                        "end_line": 9,
                                        "input_file": {
                                            "filename": "autogen/starknet/storage_var/public_key/impl.cairo"
                                        },
                                        "start_col": 9,
                                        "start_line": 9
                                    },
                                    "While trying to retrieve the implicit argument 'range_check_ptr' in:"
                                ],
                                "start_col": 44,
                                "start_line": 7
                            },
                            "While expanding the reference 'range_check_ptr' in:"
                        ],
                        "start_col": 44,
                        "start_line": 7
                    }
                },
                "182": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__.public_key",
                        "__main__.public_key.addr"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 19,
                            "offset": 2
                        },
                        "reference_ids": {
                            "__main__.public_key.addr.pedersen_ptr": 109,
                            "__main__.public_key.addr.range_check_ptr": 110,
                            "__main__.public_key.addr.res": 111
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 95,
                        "end_line": 8,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/public_key/impl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 24,
                                "end_line": 9,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/public_key/impl.cairo"
                                },
                                "start_col": 21,
                                "start_line": 9
                            },
                            "While expanding the reference 'res' in:"
                        ],
                        "start_col": 19,
                        "start_line": 8
                    }
                },
                "184": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__.public_key",
                        "__main__.public_key.addr"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 19,
                            "offset": 3
                        },
                        "reference_ids": {
                            "__main__.public_key.addr.pedersen_ptr": 109,
                            "__main__.public_key.addr.range_check_ptr": 110,
                            "__main__.public_key.addr.res": 111
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 25,
                        "end_line": 9,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/public_key/impl.cairo"
                        },
                        "start_col": 9,
                        "start_line": 9
                    }
                },
                "185": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__.public_key",
                        "__main__.public_key.read"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 20,
                            "offset": 0
                        },
                        "reference_ids": {
                            "__main__.public_key.read.pedersen_ptr": 113,
                            "__main__.public_key.read.range_check_ptr": 114,
                            "__main__.public_key.read.syscall_ptr": 112
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 63,
                        "end_line": 12,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/public_key/impl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 42,
                                "end_line": 7,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/public_key/decl.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 36,
                                        "end_line": 13,
                                        "input_file": {
                                            "filename": "autogen/starknet/storage_var/public_key/impl.cairo"
                                        },
                                        "start_col": 30,
                                        "start_line": 13
                                    },
                                    "While trying to retrieve the implicit argument 'pedersen_ptr' in:"
                                ],
                                "start_col": 15,
                                "start_line": 7
                            },
                            "While expanding the reference 'pedersen_ptr' in:"
                        ],
                        "start_col": 36,
                        "start_line": 12
                    }
                },
                "186": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__.public_key",
                        "__main__.public_key.read"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 20,
                            "offset": 1
                        },
                        "reference_ids": {
                            "__main__.public_key.read.pedersen_ptr": 113,
                            "__main__.public_key.read.range_check_ptr": 114,
                            "__main__.public_key.read.syscall_ptr": 112
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 80,
                        "end_line": 12,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/public_key/impl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 59,
                                "end_line": 7,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/public_key/decl.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 36,
                                        "end_line": 13,
                                        "input_file": {
                                            "filename": "autogen/starknet/storage_var/public_key/impl.cairo"
                                        },
                                        "start_col": 30,
                                        "start_line": 13
                                    },
                                    "While trying to retrieve the implicit argument 'range_check_ptr' in:"
                                ],
                                "start_col": 44,
                                "start_line": 7
                            },
                            "While expanding the reference 'range_check_ptr' in:"
                        ],
                        "start_col": 65,
                        "start_line": 12
                    }
                },
                "187": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__.public_key",
                        "__main__.public_key.read"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 20,
                            "offset": 2
                        },
                        "reference_ids": {
                            "__main__.public_key.read.pedersen_ptr": 113,
                            "__main__.public_key.read.range_check_ptr": 114,
                            "__main__.public_key.read.syscall_ptr": 112
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 36,
                        "end_line": 13,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/public_key/impl.cairo"
                        },
                        "start_col": 30,
                        "start_line": 13
                    }
                },
                "189": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__.public_key",
                        "__main__.public_key.read"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 20,
                            "offset": 7
                        },
                        "reference_ids": {
                            "__main__.public_key.read.pedersen_ptr": 115,
                            "__main__.public_key.read.range_check_ptr": 116,
                            "__main__.public_key.read.storage_addr": 117,
                            "__main__.public_key.read.syscall_ptr": 112
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 34,
                        "end_line": 12,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/public_key/impl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 38,
                                "end_line": 199,
                                "input_file": {
                                    "filename": "/Users/jakubptak/Library/Caches/pypoetry/virtualenvs/starkware-python-sdk-L_CLq0Mm-py3.7/lib/python3.7/site-packages/starkware/starknet/common/syscalls.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 75,
                                        "end_line": 14,
                                        "input_file": {
                                            "filename": "autogen/starknet/storage_var/public_key/impl.cairo"
                                        },
                                        "start_col": 37,
                                        "start_line": 14
                                    },
                                    "While trying to retrieve the implicit argument 'syscall_ptr' in:"
                                ],
                                "start_col": 19,
                                "start_line": 199
                            },
                            "While expanding the reference 'syscall_ptr' in:"
                        ],
                        "start_col": 15,
                        "start_line": 12
                    }
                },
                "190": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__.public_key",
                        "__main__.public_key.read"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 20,
                            "offset": 8
                        },
                        "reference_ids": {
                            "__main__.public_key.read.pedersen_ptr": 115,
                            "__main__.public_key.read.range_check_ptr": 116,
                            "__main__.public_key.read.storage_addr": 117,
                            "__main__.public_key.read.syscall_ptr": 112
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 26,
                        "end_line": 13,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/public_key/impl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 70,
                                "end_line": 14,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/public_key/impl.cairo"
                                },
                                "start_col": 58,
                                "start_line": 14
                            },
                            "While expanding the reference 'storage_addr' in:"
                        ],
                        "start_col": 14,
                        "start_line": 13
                    }
                },
                "191": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__.public_key",
                        "__main__.public_key.read"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 20,
                            "offset": 9
                        },
                        "reference_ids": {
                            "__main__.public_key.read.pedersen_ptr": 115,
                            "__main__.public_key.read.range_check_ptr": 116,
                            "__main__.public_key.read.storage_addr": 117,
                            "__main__.public_key.read.syscall_ptr": 112
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 75,
                        "end_line": 14,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/public_key/impl.cairo"
                        },
                        "start_col": 37,
                        "start_line": 14
                    }
                },
                "193": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__.public_key",
                        "__main__.public_key.read"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 20,
                            "offset": 14
                        },
                        "reference_ids": {
                            "__main__.public_key.read.__storage_var_temp0": 119,
                            "__main__.public_key.read.pedersen_ptr": 115,
                            "__main__.public_key.read.range_check_ptr": 116,
                            "__main__.public_key.read.storage_addr": 117,
                            "__main__.public_key.read.syscall_ptr": 118
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 38,
                        "end_line": 199,
                        "input_file": {
                            "filename": "/Users/jakubptak/Library/Caches/pypoetry/virtualenvs/starkware-python-sdk-L_CLq0Mm-py3.7/lib/python3.7/site-packages/starkware/starknet/common/syscalls.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 75,
                                "end_line": 14,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/public_key/impl.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 42,
                                        "end_line": 16,
                                        "input_file": {
                                            "filename": "autogen/starknet/storage_var/public_key/impl.cairo"
                                        },
                                        "start_col": 31,
                                        "start_line": 16
                                    },
                                    "While expanding the reference 'syscall_ptr' in:"
                                ],
                                "start_col": 37,
                                "start_line": 14
                            },
                            "While trying to update the implicit return value 'syscall_ptr' in:"
                        ],
                        "start_col": 19,
                        "start_line": 199
                    }
                },
                "194": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__.public_key",
                        "__main__.public_key.read"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 20,
                            "offset": 15
                        },
                        "reference_ids": {
                            "__main__.public_key.read.__storage_var_temp0": 119,
                            "__main__.public_key.read.pedersen_ptr": 115,
                            "__main__.public_key.read.range_check_ptr": 116,
                            "__main__.public_key.read.storage_addr": 117,
                            "__main__.public_key.read.syscall_ptr": 120
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 42,
                        "end_line": 7,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/public_key/decl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 36,
                                "end_line": 13,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/public_key/impl.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 44,
                                        "end_line": 17,
                                        "input_file": {
                                            "filename": "autogen/starknet/storage_var/public_key/impl.cairo"
                                        },
                                        "start_col": 32,
                                        "start_line": 17
                                    },
                                    "While expanding the reference 'pedersen_ptr' in:"
                                ],
                                "start_col": 30,
                                "start_line": 13
                            },
                            "While trying to update the implicit return value 'pedersen_ptr' in:"
                        ],
                        "start_col": 15,
                        "start_line": 7
                    }
                },
                "195": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__.public_key",
                        "__main__.public_key.read"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 20,
                            "offset": 16
                        },
                        "reference_ids": {
                            "__main__.public_key.read.__storage_var_temp0": 119,
                            "__main__.public_key.read.pedersen_ptr": 121,
                            "__main__.public_key.read.range_check_ptr": 116,
                            "__main__.public_key.read.storage_addr": 117,
                            "__main__.public_key.read.syscall_ptr": 120
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 59,
                        "end_line": 7,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/public_key/decl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 36,
                                "end_line": 13,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/public_key/impl.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 50,
                                        "end_line": 18,
                                        "input_file": {
                                            "filename": "autogen/starknet/storage_var/public_key/impl.cairo"
                                        },
                                        "start_col": 35,
                                        "start_line": 18
                                    },
                                    "While expanding the reference 'range_check_ptr' in:"
                                ],
                                "start_col": 30,
                                "start_line": 13
                            },
                            "While trying to update the implicit return value 'range_check_ptr' in:"
                        ],
                        "start_col": 44,
                        "start_line": 7
                    }
                },
                "196": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__.public_key",
                        "__main__.public_key.read"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 20,
                            "offset": 17
                        },
                        "reference_ids": {
                            "__main__.public_key.read.__storage_var_temp0": 119,
                            "__main__.public_key.read.pedersen_ptr": 121,
                            "__main__.public_key.read.range_check_ptr": 122,
                            "__main__.public_key.read.storage_addr": 117,
                            "__main__.public_key.read.syscall_ptr": 120
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 33,
                        "end_line": 14,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/public_key/impl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 65,
                                "end_line": 19,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/public_key/impl.cairo"
                                },
                                "start_col": 46,
                                "start_line": 19
                            },
                            "While expanding the reference '__storage_var_temp0' in:"
                        ],
                        "start_col": 14,
                        "start_line": 14
                    }
                },
                "197": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__.public_key",
                        "__main__.public_key.read"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 20,
                            "offset": 18
                        },
                        "reference_ids": {
                            "__main__.public_key.read.__storage_var_temp0": 123,
                            "__main__.public_key.read.pedersen_ptr": 121,
                            "__main__.public_key.read.range_check_ptr": 122,
                            "__main__.public_key.read.storage_addr": 117,
                            "__main__.public_key.read.syscall_ptr": 120
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 53,
                        "end_line": 20,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/public_key/impl.cairo"
                        },
                        "start_col": 9,
                        "start_line": 20
                    }
                },
                "198": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__.public_key",
                        "__main__.public_key.write"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 21,
                            "offset": 0
                        },
                        "reference_ids": {
                            "__main__.public_key.write.pedersen_ptr": 126,
                            "__main__.public_key.write.range_check_ptr": 127,
                            "__main__.public_key.write.syscall_ptr": 125,
                            "__main__.public_key.write.value": 124
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 64,
                        "end_line": 23,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/public_key/impl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 42,
                                "end_line": 7,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/public_key/decl.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 36,
                                        "end_line": 24,
                                        "input_file": {
                                            "filename": "autogen/starknet/storage_var/public_key/impl.cairo"
                                        },
                                        "start_col": 30,
                                        "start_line": 24
                                    },
                                    "While trying to retrieve the implicit argument 'pedersen_ptr' in:"
                                ],
                                "start_col": 15,
                                "start_line": 7
                            },
                            "While expanding the reference 'pedersen_ptr' in:"
                        ],
                        "start_col": 37,
                        "start_line": 23
                    }
                },
                "199": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__.public_key",
                        "__main__.public_key.write"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 21,
                            "offset": 1
                        },
                        "reference_ids": {
                            "__main__.public_key.write.pedersen_ptr": 126,
                            "__main__.public_key.write.range_check_ptr": 127,
                            "__main__.public_key.write.syscall_ptr": 125,
                            "__main__.public_key.write.value": 124
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 81,
                        "end_line": 23,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/public_key/impl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 59,
                                "end_line": 7,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/public_key/decl.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 36,
                                        "end_line": 24,
                                        "input_file": {
                                            "filename": "autogen/starknet/storage_var/public_key/impl.cairo"
                                        },
                                        "start_col": 30,
                                        "start_line": 24
                                    },
                                    "While trying to retrieve the implicit argument 'range_check_ptr' in:"
                                ],
                                "start_col": 44,
                                "start_line": 7
                            },
                            "While expanding the reference 'range_check_ptr' in:"
                        ],
                        "start_col": 66,
                        "start_line": 23
                    }
                },
                "200": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__.public_key",
                        "__main__.public_key.write"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 21,
                            "offset": 2
                        },
                        "reference_ids": {
                            "__main__.public_key.write.pedersen_ptr": 126,
                            "__main__.public_key.write.range_check_ptr": 127,
                            "__main__.public_key.write.syscall_ptr": 125,
                            "__main__.public_key.write.value": 124
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 36,
                        "end_line": 24,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/public_key/impl.cairo"
                        },
                        "start_col": 30,
                        "start_line": 24
                    }
                },
                "202": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__.public_key",
                        "__main__.public_key.write"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 21,
                            "offset": 7
                        },
                        "reference_ids": {
                            "__main__.public_key.write.pedersen_ptr": 128,
                            "__main__.public_key.write.range_check_ptr": 129,
                            "__main__.public_key.write.storage_addr": 130,
                            "__main__.public_key.write.syscall_ptr": 125,
                            "__main__.public_key.write.value": 124
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 35,
                        "end_line": 23,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/public_key/impl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 39,
                                "end_line": 217,
                                "input_file": {
                                    "filename": "/Users/jakubptak/Library/Caches/pypoetry/virtualenvs/starkware-python-sdk-L_CLq0Mm-py3.7/lib/python3.7/site-packages/starkware/starknet/common/syscalls.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 80,
                                        "end_line": 25,
                                        "input_file": {
                                            "filename": "autogen/starknet/storage_var/public_key/impl.cairo"
                                        },
                                        "start_col": 9,
                                        "start_line": 25
                                    },
                                    "While trying to retrieve the implicit argument 'syscall_ptr' in:"
                                ],
                                "start_col": 20,
                                "start_line": 217
                            },
                            "While expanding the reference 'syscall_ptr' in:"
                        ],
                        "start_col": 16,
                        "start_line": 23
                    }
                },
                "203": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__.public_key",
                        "__main__.public_key.write"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 21,
                            "offset": 8
                        },
                        "reference_ids": {
                            "__main__.public_key.write.pedersen_ptr": 128,
                            "__main__.public_key.write.range_check_ptr": 129,
                            "__main__.public_key.write.storage_addr": 130,
                            "__main__.public_key.write.syscall_ptr": 125,
                            "__main__.public_key.write.value": 124
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 26,
                        "end_line": 24,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/public_key/impl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 43,
                                "end_line": 25,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/public_key/impl.cairo"
                                },
                                "start_col": 31,
                                "start_line": 25
                            },
                            "While expanding the reference 'storage_addr' in:"
                        ],
                        "start_col": 14,
                        "start_line": 24
                    }
                },
                "204": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__.public_key",
                        "__main__.public_key.write"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 21,
                            "offset": 9
                        },
                        "reference_ids": {
                            "__main__.public_key.write.pedersen_ptr": 128,
                            "__main__.public_key.write.range_check_ptr": 129,
                            "__main__.public_key.write.storage_addr": 130,
                            "__main__.public_key.write.syscall_ptr": 125,
                            "__main__.public_key.write.value": 124
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 79,
                        "end_line": 25,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/public_key/impl.cairo"
                        },
                        "start_col": 55,
                        "start_line": 25
                    }
                },
                "205": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__.public_key",
                        "__main__.public_key.write"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 21,
                            "offset": 10
                        },
                        "reference_ids": {
                            "__main__.public_key.write.pedersen_ptr": 128,
                            "__main__.public_key.write.range_check_ptr": 129,
                            "__main__.public_key.write.storage_addr": 130,
                            "__main__.public_key.write.syscall_ptr": 125,
                            "__main__.public_key.write.value": 124
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 80,
                        "end_line": 25,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/public_key/impl.cairo"
                        },
                        "start_col": 9,
                        "start_line": 25
                    }
                },
                "207": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__.public_key",
                        "__main__.public_key.write"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 21,
                            "offset": 14
                        },
                        "reference_ids": {
                            "__main__.public_key.write.pedersen_ptr": 128,
                            "__main__.public_key.write.range_check_ptr": 129,
                            "__main__.public_key.write.storage_addr": 130,
                            "__main__.public_key.write.syscall_ptr": 131,
                            "__main__.public_key.write.value": 124
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 42,
                        "end_line": 7,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/public_key/decl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 36,
                                "end_line": 24,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/public_key/impl.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 64,
                                        "end_line": 19,
                                        "input_file": {
                                            "filename": "autogen/starknet/storage_var/public_key/decl.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 18,
                                                "end_line": 26,
                                                "input_file": {
                                                    "filename": "autogen/starknet/storage_var/public_key/impl.cairo"
                                                },
                                                "start_col": 9,
                                                "start_line": 26
                                            },
                                            "While trying to retrieve the implicit argument 'pedersen_ptr' in:"
                                        ],
                                        "start_col": 37,
                                        "start_line": 19
                                    },
                                    "While expanding the reference 'pedersen_ptr' in:"
                                ],
                                "start_col": 30,
                                "start_line": 24
                            },
                            "While trying to update the implicit return value 'pedersen_ptr' in:"
                        ],
                        "start_col": 15,
                        "start_line": 7
                    }
                },
                "208": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__.public_key",
                        "__main__.public_key.write"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 21,
                            "offset": 15
                        },
                        "reference_ids": {
                            "__main__.public_key.write.pedersen_ptr": 128,
                            "__main__.public_key.write.range_check_ptr": 129,
                            "__main__.public_key.write.storage_addr": 130,
                            "__main__.public_key.write.syscall_ptr": 131,
                            "__main__.public_key.write.value": 124
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 59,
                        "end_line": 7,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/public_key/decl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 36,
                                "end_line": 24,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/public_key/impl.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 81,
                                        "end_line": 19,
                                        "input_file": {
                                            "filename": "autogen/starknet/storage_var/public_key/decl.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 18,
                                                "end_line": 26,
                                                "input_file": {
                                                    "filename": "autogen/starknet/storage_var/public_key/impl.cairo"
                                                },
                                                "start_col": 9,
                                                "start_line": 26
                                            },
                                            "While trying to retrieve the implicit argument 'range_check_ptr' in:"
                                        ],
                                        "start_col": 66,
                                        "start_line": 19
                                    },
                                    "While expanding the reference 'range_check_ptr' in:"
                                ],
                                "start_col": 30,
                                "start_line": 24
                            },
                            "While trying to update the implicit return value 'range_check_ptr' in:"
                        ],
                        "start_col": 44,
                        "start_line": 7
                    }
                },
                "209": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__.public_key",
                        "__main__.public_key.write"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 21,
                            "offset": 16
                        },
                        "reference_ids": {
                            "__main__.public_key.write.pedersen_ptr": 128,
                            "__main__.public_key.write.range_check_ptr": 129,
                            "__main__.public_key.write.storage_addr": 130,
                            "__main__.public_key.write.syscall_ptr": 131,
                            "__main__.public_key.write.value": 124
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 18,
                        "end_line": 26,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/public_key/impl.cairo"
                        },
                        "start_col": 9,
                        "start_line": 26
                    }
                },
                "210": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.assert_only_self"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 22,
                            "offset": 0
                        },
                        "reference_ids": {
                            "__main__.assert_only_self.pedersen_ptr": 133,
                            "__main__.assert_only_self.range_check_ptr": 134,
                            "__main__.assert_only_self.syscall_ptr": 132
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 28,
                        "end_line": 44,
                        "input_file": {
                            "filename": "contract.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 46,
                                "end_line": 144,
                                "input_file": {
                                    "filename": "/Users/jakubptak/Library/Caches/pypoetry/virtualenvs/starkware-python-sdk-L_CLq0Mm-py3.7/lib/python3.7/site-packages/starkware/starknet/common/syscalls.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 40,
                                        "end_line": 48,
                                        "input_file": {
                                            "filename": "contract.cairo"
                                        },
                                        "start_col": 18,
                                        "start_line": 48
                                    },
                                    "While trying to retrieve the implicit argument 'syscall_ptr' in:"
                                ],
                                "start_col": 27,
                                "start_line": 144
                            },
                            "While expanding the reference 'syscall_ptr' in:"
                        ],
                        "start_col": 9,
                        "start_line": 44
                    }
                },
                "211": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.assert_only_self"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 22,
                            "offset": 1
                        },
                        "reference_ids": {
                            "__main__.assert_only_self.pedersen_ptr": 133,
                            "__main__.assert_only_self.range_check_ptr": 134,
                            "__main__.assert_only_self.syscall_ptr": 132
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 40,
                        "end_line": 48,
                        "input_file": {
                            "filename": "contract.cairo"
                        },
                        "start_col": 18,
                        "start_line": 48
                    }
                },
                "213": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.assert_only_self"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 22,
                            "offset": 6
                        },
                        "reference_ids": {
                            "__main__.assert_only_self.pedersen_ptr": 133,
                            "__main__.assert_only_self.range_check_ptr": 134,
                            "__main__.assert_only_self.self": 136,
                            "__main__.assert_only_self.syscall_ptr": 135
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 46,
                        "end_line": 144,
                        "input_file": {
                            "filename": "/Users/jakubptak/Library/Caches/pypoetry/virtualenvs/starkware-python-sdk-L_CLq0Mm-py3.7/lib/python3.7/site-packages/starkware/starknet/common/syscalls.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 40,
                                "end_line": 48,
                                "input_file": {
                                    "filename": "contract.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 44,
                                        "end_line": 93,
                                        "input_file": {
                                            "filename": "/Users/jakubptak/Library/Caches/pypoetry/virtualenvs/starkware-python-sdk-L_CLq0Mm-py3.7/lib/python3.7/site-packages/starkware/starknet/common/syscalls.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 40,
                                                "end_line": 49,
                                                "input_file": {
                                                    "filename": "contract.cairo"
                                                },
                                                "start_col": 20,
                                                "start_line": 49
                                            },
                                            "While trying to retrieve the implicit argument 'syscall_ptr' in:"
                                        ],
                                        "start_col": 25,
                                        "start_line": 93
                                    },
                                    "While expanding the reference 'syscall_ptr' in:"
                                ],
                                "start_col": 18,
                                "start_line": 48
                            },
                            "While trying to update the implicit return value 'syscall_ptr' in:"
                        ],
                        "start_col": 27,
                        "start_line": 144
                    }
                },
                "214": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.assert_only_self"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 22,
                            "offset": 7
                        },
                        "reference_ids": {
                            "__main__.assert_only_self.pedersen_ptr": 133,
                            "__main__.assert_only_self.range_check_ptr": 134,
                            "__main__.assert_only_self.self": 136,
                            "__main__.assert_only_self.syscall_ptr": 135
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 40,
                        "end_line": 49,
                        "input_file": {
                            "filename": "contract.cairo"
                        },
                        "start_col": 20,
                        "start_line": 49
                    }
                },
                "216": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.assert_only_self"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 22,
                            "offset": 12
                        },
                        "reference_ids": {
                            "__main__.assert_only_self.caller": 138,
                            "__main__.assert_only_self.pedersen_ptr": 133,
                            "__main__.assert_only_self.range_check_ptr": 134,
                            "__main__.assert_only_self.self": 136,
                            "__main__.assert_only_self.syscall_ptr": 137
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 25,
                        "end_line": 50,
                        "input_file": {
                            "filename": "contract.cairo"
                        },
                        "start_col": 5,
                        "start_line": 50
                    }
                },
                "217": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.assert_only_self"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 22,
                            "offset": 12
                        },
                        "reference_ids": {
                            "__main__.assert_only_self.caller": 138,
                            "__main__.assert_only_self.pedersen_ptr": 133,
                            "__main__.assert_only_self.range_check_ptr": 134,
                            "__main__.assert_only_self.self": 136,
                            "__main__.assert_only_self.syscall_ptr": 137
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 44,
                        "end_line": 93,
                        "input_file": {
                            "filename": "/Users/jakubptak/Library/Caches/pypoetry/virtualenvs/starkware-python-sdk-L_CLq0Mm-py3.7/lib/python3.7/site-packages/starkware/starknet/common/syscalls.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 40,
                                "end_line": 49,
                                "input_file": {
                                    "filename": "contract.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 28,
                                        "end_line": 44,
                                        "input_file": {
                                            "filename": "contract.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 14,
                                                "end_line": 51,
                                                "input_file": {
                                                    "filename": "contract.cairo"
                                                },
                                                "start_col": 5,
                                                "start_line": 51
                                            },
                                            "While trying to retrieve the implicit argument 'syscall_ptr' in:"
                                        ],
                                        "start_col": 9,
                                        "start_line": 44
                                    },
                                    "While expanding the reference 'syscall_ptr' in:"
                                ],
                                "start_col": 20,
                                "start_line": 49
                            },
                            "While trying to update the implicit return value 'syscall_ptr' in:"
                        ],
                        "start_col": 25,
                        "start_line": 93
                    }
                },
                "218": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.assert_only_self"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 22,
                            "offset": 13
                        },
                        "reference_ids": {
                            "__main__.assert_only_self.caller": 138,
                            "__main__.assert_only_self.pedersen_ptr": 133,
                            "__main__.assert_only_self.range_check_ptr": 134,
                            "__main__.assert_only_self.self": 136,
                            "__main__.assert_only_self.syscall_ptr": 137
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 36,
                        "end_line": 45,
                        "input_file": {
                            "filename": "contract.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 36,
                                "end_line": 45,
                                "input_file": {
                                    "filename": "contract.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 14,
                                        "end_line": 51,
                                        "input_file": {
                                            "filename": "contract.cairo"
                                        },
                                        "start_col": 5,
                                        "start_line": 51
                                    },
                                    "While trying to retrieve the implicit argument 'pedersen_ptr' in:"
                                ],
                                "start_col": 9,
                                "start_line": 45
                            },
                            "While expanding the reference 'pedersen_ptr' in:"
                        ],
                        "start_col": 9,
                        "start_line": 45
                    }
                },
                "219": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.assert_only_self"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 22,
                            "offset": 14
                        },
                        "reference_ids": {
                            "__main__.assert_only_self.caller": 138,
                            "__main__.assert_only_self.pedersen_ptr": 133,
                            "__main__.assert_only_self.range_check_ptr": 134,
                            "__main__.assert_only_self.self": 136,
                            "__main__.assert_only_self.syscall_ptr": 137
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 24,
                        "end_line": 46,
                        "input_file": {
                            "filename": "contract.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 24,
                                "end_line": 46,
                                "input_file": {
                                    "filename": "contract.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 14,
                                        "end_line": 51,
                                        "input_file": {
                                            "filename": "contract.cairo"
                                        },
                                        "start_col": 5,
                                        "start_line": 51
                                    },
                                    "While trying to retrieve the implicit argument 'range_check_ptr' in:"
                                ],
                                "start_col": 9,
                                "start_line": 46
                            },
                            "While expanding the reference 'range_check_ptr' in:"
                        ],
                        "start_col": 9,
                        "start_line": 46
                    }
                },
                "220": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.assert_only_self"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 22,
                            "offset": 15
                        },
                        "reference_ids": {
                            "__main__.assert_only_self.caller": 138,
                            "__main__.assert_only_self.pedersen_ptr": 133,
                            "__main__.assert_only_self.range_check_ptr": 134,
                            "__main__.assert_only_self.self": 136,
                            "__main__.assert_only_self.syscall_ptr": 137
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 14,
                        "end_line": 51,
                        "input_file": {
                            "filename": "contract.cairo"
                        },
                        "start_col": 5,
                        "start_line": 51
                    }
                },
                "221": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.assert_only_self"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 23,
                            "offset": 0
                        },
                        "reference_ids": {
                            "__wrappers__.assert_only_self.__calldata_actual_size": 144,
                            "__wrappers__.assert_only_self.__calldata_ptr": 143,
                            "__wrappers__.assert_only_self.ecdsa_ptr": 142,
                            "__wrappers__.assert_only_self.pedersen_ptr": 140,
                            "__wrappers__.assert_only_self.range_check_ptr": 141,
                            "__wrappers__.assert_only_self.syscall_ptr": 139
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 44,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/arg_processor/7f0b238f4e526821a97d8aaa2f9484df4b5bd00cbad10a761ae4225314096a56.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 22,
                                "end_line": 43,
                                "input_file": {
                                    "filename": "contract.cairo"
                                },
                                "start_col": 6,
                                "start_line": 43
                            },
                            "While handling calldata of"
                        ],
                        "start_col": 1,
                        "start_line": 1
                    }
                },
                "222": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.assert_only_self"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 23,
                            "offset": 0
                        },
                        "reference_ids": {
                            "__wrappers__.assert_only_self.__calldata_actual_size": 144,
                            "__wrappers__.assert_only_self.__calldata_ptr": 143,
                            "__wrappers__.assert_only_self.ecdsa_ptr": 142,
                            "__wrappers__.assert_only_self.pedersen_ptr": 140,
                            "__wrappers__.assert_only_self.range_check_ptr": 141,
                            "__wrappers__.assert_only_self.syscall_ptr": 139
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 50,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/external/assert_only_self/f4a8893cfc7cc4f313b0c426fa25c38c6c57664957bc56a170a27945759c5102.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 28,
                                "end_line": 44,
                                "input_file": {
                                    "filename": "contract.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 56,
                                        "end_line": 1,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/assert_only_self/65afca6042dd7c8a6e82d579494fa4fa955e0d1232b8c498dd8d1f04bd61bada.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 22,
                                                "end_line": 43,
                                                "input_file": {
                                                    "filename": "contract.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 43
                                            },
                                            "While constructing the external wrapper for:"
                                        ],
                                        "start_col": 45,
                                        "start_line": 1
                                    },
                                    "While expanding the reference 'syscall_ptr' in:"
                                ],
                                "start_col": 9,
                                "start_line": 44
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 19,
                        "start_line": 1
                    }
                },
                "223": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.assert_only_self"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 23,
                            "offset": 1
                        },
                        "reference_ids": {
                            "__wrappers__.assert_only_self.__calldata_actual_size": 144,
                            "__wrappers__.assert_only_self.__calldata_ptr": 143,
                            "__wrappers__.assert_only_self.ecdsa_ptr": 142,
                            "__wrappers__.assert_only_self.pedersen_ptr": 140,
                            "__wrappers__.assert_only_self.range_check_ptr": 141,
                            "__wrappers__.assert_only_self.syscall_ptr": 139
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 96,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/external/assert_only_self/bf54f65e3c6b81daf1c2b60a8cb4034b53ce30386ebc03b148a9de60d6f5dd57.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 36,
                                "end_line": 45,
                                "input_file": {
                                    "filename": "contract.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 83,
                                        "end_line": 1,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/assert_only_self/65afca6042dd7c8a6e82d579494fa4fa955e0d1232b8c498dd8d1f04bd61bada.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 22,
                                                "end_line": 43,
                                                "input_file": {
                                                    "filename": "contract.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 43
                                            },
                                            "While constructing the external wrapper for:"
                                        ],
                                        "start_col": 71,
                                        "start_line": 1
                                    },
                                    "While expanding the reference 'pedersen_ptr' in:"
                                ],
                                "start_col": 9,
                                "start_line": 45
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 20,
                        "start_line": 1
                    }
                },
                "224": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.assert_only_self"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 23,
                            "offset": 2
                        },
                        "reference_ids": {
                            "__wrappers__.assert_only_self.__calldata_actual_size": 144,
                            "__wrappers__.assert_only_self.__calldata_ptr": 143,
                            "__wrappers__.assert_only_self.ecdsa_ptr": 142,
                            "__wrappers__.assert_only_self.pedersen_ptr": 140,
                            "__wrappers__.assert_only_self.range_check_ptr": 141,
                            "__wrappers__.assert_only_self.syscall_ptr": 139
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 53,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/external/assert_only_self/d5f67cc7e69abbde284d945f017319bd8e156adfab63895c8d652f5c3e4f6c3a.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 24,
                                "end_line": 46,
                                "input_file": {
                                    "filename": "contract.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 116,
                                        "end_line": 1,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/assert_only_self/65afca6042dd7c8a6e82d579494fa4fa955e0d1232b8c498dd8d1f04bd61bada.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 22,
                                                "end_line": 43,
                                                "input_file": {
                                                    "filename": "contract.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 43
                                            },
                                            "While constructing the external wrapper for:"
                                        ],
                                        "start_col": 101,
                                        "start_line": 1
                                    },
                                    "While expanding the reference 'range_check_ptr' in:"
                                ],
                                "start_col": 9,
                                "start_line": 46
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 23,
                        "start_line": 1
                    }
                },
                "225": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.assert_only_self"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 23,
                            "offset": 3
                        },
                        "reference_ids": {
                            "__wrappers__.assert_only_self.__calldata_actual_size": 144,
                            "__wrappers__.assert_only_self.__calldata_ptr": 143,
                            "__wrappers__.assert_only_self.ecdsa_ptr": 142,
                            "__wrappers__.assert_only_self.pedersen_ptr": 140,
                            "__wrappers__.assert_only_self.range_check_ptr": 141,
                            "__wrappers__.assert_only_self.syscall_ptr": 139
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 22,
                        "end_line": 43,
                        "input_file": {
                            "filename": "contract.cairo"
                        },
                        "start_col": 6,
                        "start_line": 43
                    }
                },
                "227": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.assert_only_self"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 23,
                            "offset": 20
                        },
                        "reference_ids": {
                            "__wrappers__.assert_only_self.__calldata_actual_size": 144,
                            "__wrappers__.assert_only_self.__calldata_ptr": 143,
                            "__wrappers__.assert_only_self.ecdsa_ptr": 142,
                            "__wrappers__.assert_only_self.pedersen_ptr": 146,
                            "__wrappers__.assert_only_self.range_check_ptr": 147,
                            "__wrappers__.assert_only_self.ret_struct": 148,
                            "__wrappers__.assert_only_self.syscall_ptr": 145
                        }
                    },
                    "hints": [
                        {
                            "location": {
                                "end_col": 34,
                                "end_line": 2,
                                "input_file": {
                                    "filename": "autogen/starknet/external/assert_only_self/65afca6042dd7c8a6e82d579494fa4fa955e0d1232b8c498dd8d1f04bd61bada.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 22,
                                        "end_line": 43,
                                        "input_file": {
                                            "filename": "contract.cairo"
                                        },
                                        "start_col": 6,
                                        "start_line": 43
                                    },
                                    "While constructing the external wrapper for:"
                                ],
                                "start_col": 1,
                                "start_line": 2
                            },
                            "n_prefix_newlines": 0
                        }
                    ],
                    "inst": {
                        "end_col": 24,
                        "end_line": 3,
                        "input_file": {
                            "filename": "autogen/starknet/external/assert_only_self/65afca6042dd7c8a6e82d579494fa4fa955e0d1232b8c498dd8d1f04bd61bada.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 22,
                                "end_line": 43,
                                "input_file": {
                                    "filename": "contract.cairo"
                                },
                                "start_col": 6,
                                "start_line": 43
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 1,
                        "start_line": 3
                    }
                },
                "229": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.assert_only_self"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 23,
                            "offset": 21
                        },
                        "reference_ids": {
                            "__wrappers__.assert_only_self.__calldata_actual_size": 144,
                            "__wrappers__.assert_only_self.__calldata_ptr": 143,
                            "__wrappers__.assert_only_self.ecdsa_ptr": 142,
                            "__wrappers__.assert_only_self.pedersen_ptr": 146,
                            "__wrappers__.assert_only_self.range_check_ptr": 147,
                            "__wrappers__.assert_only_self.ret_struct": 148,
                            "__wrappers__.assert_only_self.retdata": 149,
                            "__wrappers__.assert_only_self.retdata_size": 150,
                            "__wrappers__.assert_only_self.syscall_ptr": 145
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 56,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/external/assert_only_self/65afca6042dd7c8a6e82d579494fa4fa955e0d1232b8c498dd8d1f04bd61bada.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 22,
                                "end_line": 43,
                                "input_file": {
                                    "filename": "contract.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 20,
                                        "end_line": 1,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/assert_only_self/aa526043a8db9187624857305b1409f029aec9f9c85f47438b55e65b3afc0639.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 22,
                                                "end_line": 43,
                                                "input_file": {
                                                    "filename": "contract.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 43
                                            },
                                            "While constructing the external wrapper for:"
                                        ],
                                        "start_col": 9,
                                        "start_line": 1
                                    },
                                    "While expanding the reference 'syscall_ptr' in:"
                                ],
                                "start_col": 6,
                                "start_line": 43
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 45,
                        "start_line": 1
                    }
                },
                "230": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.assert_only_self"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 23,
                            "offset": 22
                        },
                        "reference_ids": {
                            "__wrappers__.assert_only_self.__calldata_actual_size": 144,
                            "__wrappers__.assert_only_self.__calldata_ptr": 143,
                            "__wrappers__.assert_only_self.ecdsa_ptr": 142,
                            "__wrappers__.assert_only_self.pedersen_ptr": 146,
                            "__wrappers__.assert_only_self.range_check_ptr": 147,
                            "__wrappers__.assert_only_self.ret_struct": 148,
                            "__wrappers__.assert_only_self.retdata": 149,
                            "__wrappers__.assert_only_self.retdata_size": 150,
                            "__wrappers__.assert_only_self.syscall_ptr": 145
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 83,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/external/assert_only_self/65afca6042dd7c8a6e82d579494fa4fa955e0d1232b8c498dd8d1f04bd61bada.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 22,
                                "end_line": 43,
                                "input_file": {
                                    "filename": "contract.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 33,
                                        "end_line": 1,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/assert_only_self/aa526043a8db9187624857305b1409f029aec9f9c85f47438b55e65b3afc0639.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 22,
                                                "end_line": 43,
                                                "input_file": {
                                                    "filename": "contract.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 43
                                            },
                                            "While constructing the external wrapper for:"
                                        ],
                                        "start_col": 21,
                                        "start_line": 1
                                    },
                                    "While expanding the reference 'pedersen_ptr' in:"
                                ],
                                "start_col": 6,
                                "start_line": 43
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 71,
                        "start_line": 1
                    }
                },
                "231": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.assert_only_self"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 23,
                            "offset": 23
                        },
                        "reference_ids": {
                            "__wrappers__.assert_only_self.__calldata_actual_size": 144,
                            "__wrappers__.assert_only_self.__calldata_ptr": 143,
                            "__wrappers__.assert_only_self.ecdsa_ptr": 142,
                            "__wrappers__.assert_only_self.pedersen_ptr": 146,
                            "__wrappers__.assert_only_self.range_check_ptr": 147,
                            "__wrappers__.assert_only_self.ret_struct": 148,
                            "__wrappers__.assert_only_self.retdata": 149,
                            "__wrappers__.assert_only_self.retdata_size": 150,
                            "__wrappers__.assert_only_self.syscall_ptr": 145
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 116,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/external/assert_only_self/65afca6042dd7c8a6e82d579494fa4fa955e0d1232b8c498dd8d1f04bd61bada.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 22,
                                "end_line": 43,
                                "input_file": {
                                    "filename": "contract.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 49,
                                        "end_line": 1,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/assert_only_self/aa526043a8db9187624857305b1409f029aec9f9c85f47438b55e65b3afc0639.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 22,
                                                "end_line": 43,
                                                "input_file": {
                                                    "filename": "contract.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 43
                                            },
                                            "While constructing the external wrapper for:"
                                        ],
                                        "start_col": 34,
                                        "start_line": 1
                                    },
                                    "While expanding the reference 'range_check_ptr' in:"
                                ],
                                "start_col": 6,
                                "start_line": 43
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 101,
                        "start_line": 1
                    }
                },
                "232": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.assert_only_self"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 23,
                            "offset": 24
                        },
                        "reference_ids": {
                            "__wrappers__.assert_only_self.__calldata_actual_size": 144,
                            "__wrappers__.assert_only_self.__calldata_ptr": 143,
                            "__wrappers__.assert_only_self.ecdsa_ptr": 142,
                            "__wrappers__.assert_only_self.pedersen_ptr": 146,
                            "__wrappers__.assert_only_self.range_check_ptr": 147,
                            "__wrappers__.assert_only_self.ret_struct": 148,
                            "__wrappers__.assert_only_self.retdata": 149,
                            "__wrappers__.assert_only_self.retdata_size": 150,
                            "__wrappers__.assert_only_self.syscall_ptr": 145
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 47,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/external/assert_only_self/7998f829c4aa5ea19acd9325ec8f13445bd7eb3660e26c1acda6a694c86b221a.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 22,
                                "end_line": 43,
                                "input_file": {
                                    "filename": "contract.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 59,
                                        "end_line": 1,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/assert_only_self/aa526043a8db9187624857305b1409f029aec9f9c85f47438b55e65b3afc0639.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 22,
                                                "end_line": 43,
                                                "input_file": {
                                                    "filename": "contract.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 43
                                            },
                                            "While constructing the external wrapper for:"
                                        ],
                                        "start_col": 50,
                                        "start_line": 1
                                    },
                                    "While expanding the reference 'ecdsa_ptr' in:"
                                ],
                                "start_col": 6,
                                "start_line": 43
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 17,
                        "start_line": 1
                    }
                },
                "233": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.assert_only_self"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 23,
                            "offset": 25
                        },
                        "reference_ids": {
                            "__wrappers__.assert_only_self.__calldata_actual_size": 144,
                            "__wrappers__.assert_only_self.__calldata_ptr": 143,
                            "__wrappers__.assert_only_self.ecdsa_ptr": 142,
                            "__wrappers__.assert_only_self.pedersen_ptr": 146,
                            "__wrappers__.assert_only_self.range_check_ptr": 147,
                            "__wrappers__.assert_only_self.ret_struct": 148,
                            "__wrappers__.assert_only_self.retdata": 149,
                            "__wrappers__.assert_only_self.retdata_size": 150,
                            "__wrappers__.assert_only_self.syscall_ptr": 145
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 21,
                        "end_line": 4,
                        "input_file": {
                            "filename": "autogen/starknet/external/assert_only_self/65afca6042dd7c8a6e82d579494fa4fa955e0d1232b8c498dd8d1f04bd61bada.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 22,
                                "end_line": 43,
                                "input_file": {
                                    "filename": "contract.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 72,
                                        "end_line": 1,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/assert_only_self/aa526043a8db9187624857305b1409f029aec9f9c85f47438b55e65b3afc0639.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 22,
                                                "end_line": 43,
                                                "input_file": {
                                                    "filename": "contract.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 43
                                            },
                                            "While constructing the external wrapper for:"
                                        ],
                                        "start_col": 60,
                                        "start_line": 1
                                    },
                                    "While expanding the reference 'retdata_size' in:"
                                ],
                                "start_col": 6,
                                "start_line": 43
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 20,
                        "start_line": 4
                    }
                },
                "235": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.assert_only_self"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 23,
                            "offset": 26
                        },
                        "reference_ids": {
                            "__wrappers__.assert_only_self.__calldata_actual_size": 144,
                            "__wrappers__.assert_only_self.__calldata_ptr": 143,
                            "__wrappers__.assert_only_self.ecdsa_ptr": 142,
                            "__wrappers__.assert_only_self.pedersen_ptr": 146,
                            "__wrappers__.assert_only_self.range_check_ptr": 147,
                            "__wrappers__.assert_only_self.ret_struct": 148,
                            "__wrappers__.assert_only_self.retdata": 149,
                            "__wrappers__.assert_only_self.retdata_size": 150,
                            "__wrappers__.assert_only_self.syscall_ptr": 145
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 16,
                        "end_line": 3,
                        "input_file": {
                            "filename": "autogen/starknet/external/assert_only_self/65afca6042dd7c8a6e82d579494fa4fa955e0d1232b8c498dd8d1f04bd61bada.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 22,
                                "end_line": 43,
                                "input_file": {
                                    "filename": "contract.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 80,
                                        "end_line": 1,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/assert_only_self/aa526043a8db9187624857305b1409f029aec9f9c85f47438b55e65b3afc0639.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 22,
                                                "end_line": 43,
                                                "input_file": {
                                                    "filename": "contract.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 43
                                            },
                                            "While constructing the external wrapper for:"
                                        ],
                                        "start_col": 73,
                                        "start_line": 1
                                    },
                                    "While expanding the reference 'retdata' in:"
                                ],
                                "start_col": 6,
                                "start_line": 43
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 9,
                        "start_line": 3
                    }
                },
                "236": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.assert_only_self"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 23,
                            "offset": 27
                        },
                        "reference_ids": {
                            "__wrappers__.assert_only_self.__calldata_actual_size": 144,
                            "__wrappers__.assert_only_self.__calldata_ptr": 143,
                            "__wrappers__.assert_only_self.ecdsa_ptr": 142,
                            "__wrappers__.assert_only_self.pedersen_ptr": 146,
                            "__wrappers__.assert_only_self.range_check_ptr": 147,
                            "__wrappers__.assert_only_self.ret_struct": 148,
                            "__wrappers__.assert_only_self.retdata": 149,
                            "__wrappers__.assert_only_self.retdata_size": 150,
                            "__wrappers__.assert_only_self.syscall_ptr": 145
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 81,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/external/assert_only_self/aa526043a8db9187624857305b1409f029aec9f9c85f47438b55e65b3afc0639.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 22,
                                "end_line": 43,
                                "input_file": {
                                    "filename": "contract.cairo"
                                },
                                "start_col": 6,
                                "start_line": 43
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 1,
                        "start_line": 1
                    }
                },
                "237": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.get_public_key"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 24,
                            "offset": 0
                        },
                        "reference_ids": {
                            "__main__.get_public_key.pedersen_ptr": 152,
                            "__main__.get_public_key.range_check_ptr": 153,
                            "__main__.get_public_key.syscall_ptr": 151
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 28,
                        "end_line": 60,
                        "input_file": {
                            "filename": "contract.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 34,
                                "end_line": 13,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/public_key/decl.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 34,
                                        "end_line": 64,
                                        "input_file": {
                                            "filename": "contract.cairo"
                                        },
                                        "start_col": 17,
                                        "start_line": 64
                                    },
                                    "While trying to retrieve the implicit argument 'syscall_ptr' in:"
                                ],
                                "start_col": 15,
                                "start_line": 13
                            },
                            "While expanding the reference 'syscall_ptr' in:"
                        ],
                        "start_col": 9,
                        "start_line": 60
                    }
                },
                "238": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.get_public_key"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 24,
                            "offset": 1
                        },
                        "reference_ids": {
                            "__main__.get_public_key.pedersen_ptr": 152,
                            "__main__.get_public_key.range_check_ptr": 153,
                            "__main__.get_public_key.syscall_ptr": 151
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 36,
                        "end_line": 61,
                        "input_file": {
                            "filename": "contract.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 63,
                                "end_line": 13,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/public_key/decl.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 34,
                                        "end_line": 64,
                                        "input_file": {
                                            "filename": "contract.cairo"
                                        },
                                        "start_col": 17,
                                        "start_line": 64
                                    },
                                    "While trying to retrieve the implicit argument 'pedersen_ptr' in:"
                                ],
                                "start_col": 36,
                                "start_line": 13
                            },
                            "While expanding the reference 'pedersen_ptr' in:"
                        ],
                        "start_col": 9,
                        "start_line": 61
                    }
                },
                "239": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.get_public_key"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 24,
                            "offset": 2
                        },
                        "reference_ids": {
                            "__main__.get_public_key.pedersen_ptr": 152,
                            "__main__.get_public_key.range_check_ptr": 153,
                            "__main__.get_public_key.syscall_ptr": 151
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 24,
                        "end_line": 62,
                        "input_file": {
                            "filename": "contract.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 80,
                                "end_line": 13,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/public_key/decl.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 34,
                                        "end_line": 64,
                                        "input_file": {
                                            "filename": "contract.cairo"
                                        },
                                        "start_col": 17,
                                        "start_line": 64
                                    },
                                    "While trying to retrieve the implicit argument 'range_check_ptr' in:"
                                ],
                                "start_col": 65,
                                "start_line": 13
                            },
                            "While expanding the reference 'range_check_ptr' in:"
                        ],
                        "start_col": 9,
                        "start_line": 62
                    }
                },
                "240": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.get_public_key"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 24,
                            "offset": 3
                        },
                        "reference_ids": {
                            "__main__.get_public_key.pedersen_ptr": 152,
                            "__main__.get_public_key.range_check_ptr": 153,
                            "__main__.get_public_key.syscall_ptr": 151
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 34,
                        "end_line": 64,
                        "input_file": {
                            "filename": "contract.cairo"
                        },
                        "start_col": 17,
                        "start_line": 64
                    }
                },
                "242": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.get_public_key"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 24,
                            "offset": 23
                        },
                        "reference_ids": {
                            "__main__.get_public_key.pedersen_ptr": 155,
                            "__main__.get_public_key.range_check_ptr": 156,
                            "__main__.get_public_key.res": 157,
                            "__main__.get_public_key.syscall_ptr": 154
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 21,
                        "end_line": 65,
                        "input_file": {
                            "filename": "contract.cairo"
                        },
                        "start_col": 5,
                        "start_line": 65
                    }
                },
                "243": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.get_public_key_encode_return"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 25,
                            "offset": 0
                        },
                        "reference_ids": {
                            "__wrappers__.get_public_key_encode_return.range_check_ptr": 159,
                            "__wrappers__.get_public_key_encode_return.ret_struct": 158
                        }
                    },
                    "hints": [
                        {
                            "location": {
                                "end_col": 38,
                                "end_line": 3,
                                "input_file": {
                                    "filename": "autogen/starknet/external/return/get_public_key/9605add8cf53f954532130fb37e8434c6f1dc820b83f0220783d7316e2c52b0f.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 20,
                                        "end_line": 59,
                                        "input_file": {
                                            "filename": "contract.cairo"
                                        },
                                        "start_col": 6,
                                        "start_line": 59
                                    },
                                    "While handling return value of"
                                ],
                                "start_col": 5,
                                "start_line": 3
                            },
                            "n_prefix_newlines": 0
                        }
                    ],
                    "inst": {
                        "end_col": 17,
                        "end_line": 4,
                        "input_file": {
                            "filename": "autogen/starknet/external/return/get_public_key/9605add8cf53f954532130fb37e8434c6f1dc820b83f0220783d7316e2c52b0f.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 20,
                                "end_line": 59,
                                "input_file": {
                                    "filename": "contract.cairo"
                                },
                                "start_col": 6,
                                "start_line": 59
                            },
                            "While handling return value of"
                        ],
                        "start_col": 5,
                        "start_line": 4
                    }
                },
                "245": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.get_public_key_encode_return"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 25,
                            "offset": 1
                        },
                        "reference_ids": {
                            "__wrappers__.get_public_key_encode_return.__return_value_ptr": 161,
                            "__wrappers__.get_public_key_encode_return.__return_value_ptr_start": 160,
                            "__wrappers__.get_public_key_encode_return.range_check_ptr": 159,
                            "__wrappers__.get_public_key_encode_return.ret_struct": 158
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 45,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/arg_processor/fee896b6d05b2e98056b5628baa6fbee0adfb8960f3fee9d79fd2f066956cc42.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 22,
                                "end_line": 63,
                                "input_file": {
                                    "filename": "contract.cairo"
                                },
                                "start_col": 13,
                                "start_line": 63
                            },
                            "While handling return value 'res'"
                        ],
                        "start_col": 1,
                        "start_line": 1
                    }
                },
                "246": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.get_public_key_encode_return"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 25,
                            "offset": 1
                        },
                        "reference_ids": {
                            "__wrappers__.get_public_key_encode_return.__return_value_ptr": 162,
                            "__wrappers__.get_public_key_encode_return.__return_value_ptr_start": 160,
                            "__wrappers__.get_public_key_encode_return.range_check_ptr": 159,
                            "__wrappers__.get_public_key_encode_return.ret_struct": 158
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 48,
                        "end_line": 2,
                        "input_file": {
                            "filename": "autogen/starknet/arg_processor/fee896b6d05b2e98056b5628baa6fbee0adfb8960f3fee9d79fd2f066956cc42.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 22,
                                "end_line": 63,
                                "input_file": {
                                    "filename": "contract.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 36,
                                        "end_line": 11,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/return/get_public_key/9605add8cf53f954532130fb37e8434c6f1dc820b83f0220783d7316e2c52b0f.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 20,
                                                "end_line": 59,
                                                "input_file": {
                                                    "filename": "contract.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 59
                                            },
                                            "While handling return value of"
                                        ],
                                        "start_col": 18,
                                        "start_line": 11
                                    },
                                    "While expanding the reference '__return_value_ptr' in:"
                                ],
                                "start_col": 13,
                                "start_line": 63
                            },
                            "While handling return value 'res'"
                        ],
                        "start_col": 26,
                        "start_line": 2
                    }
                },
                "248": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.get_public_key_encode_return"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 25,
                            "offset": 2
                        },
                        "reference_ids": {
                            "__wrappers__.get_public_key_encode_return.__return_value_ptr": 162,
                            "__wrappers__.get_public_key_encode_return.__return_value_ptr_start": 160,
                            "__wrappers__.get_public_key_encode_return.__temp11": 163,
                            "__wrappers__.get_public_key_encode_return.range_check_ptr": 159,
                            "__wrappers__.get_public_key_encode_return.ret_struct": 158
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 95,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/external/return/get_public_key/9605add8cf53f954532130fb37e8434c6f1dc820b83f0220783d7316e2c52b0f.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 20,
                                "end_line": 59,
                                "input_file": {
                                    "filename": "contract.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 40,
                                        "end_line": 10,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/return/get_public_key/9605add8cf53f954532130fb37e8434c6f1dc820b83f0220783d7316e2c52b0f.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 20,
                                                "end_line": 59,
                                                "input_file": {
                                                    "filename": "contract.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 59
                                            },
                                            "While handling return value of"
                                        ],
                                        "start_col": 25,
                                        "start_line": 10
                                    },
                                    "While expanding the reference 'range_check_ptr' in:"
                                ],
                                "start_col": 6,
                                "start_line": 59
                            },
                            "While handling return value of"
                        ],
                        "start_col": 80,
                        "start_line": 1
                    }
                },
                "249": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.get_public_key_encode_return"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 25,
                            "offset": 3
                        },
                        "reference_ids": {
                            "__wrappers__.get_public_key_encode_return.__return_value_ptr": 162,
                            "__wrappers__.get_public_key_encode_return.__return_value_ptr_start": 160,
                            "__wrappers__.get_public_key_encode_return.__temp11": 163,
                            "__wrappers__.get_public_key_encode_return.range_check_ptr": 159,
                            "__wrappers__.get_public_key_encode_return.ret_struct": 158
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 63,
                        "end_line": 11,
                        "input_file": {
                            "filename": "autogen/starknet/external/return/get_public_key/9605add8cf53f954532130fb37e8434c6f1dc820b83f0220783d7316e2c52b0f.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 20,
                                "end_line": 59,
                                "input_file": {
                                    "filename": "contract.cairo"
                                },
                                "start_col": 6,
                                "start_line": 59
                            },
                            "While handling return value of"
                        ],
                        "start_col": 18,
                        "start_line": 11
                    }
                },
                "250": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.get_public_key_encode_return"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 25,
                            "offset": 4
                        },
                        "reference_ids": {
                            "__wrappers__.get_public_key_encode_return.__return_value_ptr": 162,
                            "__wrappers__.get_public_key_encode_return.__return_value_ptr_start": 160,
                            "__wrappers__.get_public_key_encode_return.__temp11": 163,
                            "__wrappers__.get_public_key_encode_return.range_check_ptr": 159,
                            "__wrappers__.get_public_key_encode_return.ret_struct": 158
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 35,
                        "end_line": 5,
                        "input_file": {
                            "filename": "autogen/starknet/external/return/get_public_key/9605add8cf53f954532130fb37e8434c6f1dc820b83f0220783d7316e2c52b0f.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 20,
                                "end_line": 59,
                                "input_file": {
                                    "filename": "contract.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 38,
                                        "end_line": 12,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/return/get_public_key/9605add8cf53f954532130fb37e8434c6f1dc820b83f0220783d7316e2c52b0f.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 20,
                                                "end_line": 59,
                                                "input_file": {
                                                    "filename": "contract.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 59
                                            },
                                            "While handling return value of"
                                        ],
                                        "start_col": 14,
                                        "start_line": 12
                                    },
                                    "While expanding the reference '__return_value_ptr_start' in:"
                                ],
                                "start_col": 6,
                                "start_line": 59
                            },
                            "While handling return value of"
                        ],
                        "start_col": 11,
                        "start_line": 5
                    }
                },
                "251": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.get_public_key_encode_return"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 25,
                            "offset": 5
                        },
                        "reference_ids": {
                            "__wrappers__.get_public_key_encode_return.__return_value_ptr": 162,
                            "__wrappers__.get_public_key_encode_return.__return_value_ptr_start": 160,
                            "__wrappers__.get_public_key_encode_return.__temp11": 163,
                            "__wrappers__.get_public_key_encode_return.range_check_ptr": 159,
                            "__wrappers__.get_public_key_encode_return.ret_struct": 158
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 39,
                        "end_line": 12,
                        "input_file": {
                            "filename": "autogen/starknet/external/return/get_public_key/9605add8cf53f954532130fb37e8434c6f1dc820b83f0220783d7316e2c52b0f.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 20,
                                "end_line": 59,
                                "input_file": {
                                    "filename": "contract.cairo"
                                },
                                "start_col": 6,
                                "start_line": 59
                            },
                            "While handling return value of"
                        ],
                        "start_col": 5,
                        "start_line": 9
                    }
                },
                "252": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.get_public_key"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 26,
                            "offset": 0
                        },
                        "reference_ids": {
                            "__wrappers__.get_public_key.__calldata_actual_size": 169,
                            "__wrappers__.get_public_key.__calldata_ptr": 168,
                            "__wrappers__.get_public_key.ecdsa_ptr": 167,
                            "__wrappers__.get_public_key.pedersen_ptr": 165,
                            "__wrappers__.get_public_key.range_check_ptr": 166,
                            "__wrappers__.get_public_key.syscall_ptr": 164
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 44,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/arg_processor/7f0b238f4e526821a97d8aaa2f9484df4b5bd00cbad10a761ae4225314096a56.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 20,
                                "end_line": 59,
                                "input_file": {
                                    "filename": "contract.cairo"
                                },
                                "start_col": 6,
                                "start_line": 59
                            },
                            "While handling calldata of"
                        ],
                        "start_col": 1,
                        "start_line": 1
                    }
                },
                "253": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.get_public_key"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 26,
                            "offset": 0
                        },
                        "reference_ids": {
                            "__wrappers__.get_public_key.__calldata_actual_size": 169,
                            "__wrappers__.get_public_key.__calldata_ptr": 168,
                            "__wrappers__.get_public_key.ecdsa_ptr": 167,
                            "__wrappers__.get_public_key.pedersen_ptr": 165,
                            "__wrappers__.get_public_key.range_check_ptr": 166,
                            "__wrappers__.get_public_key.syscall_ptr": 164
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 50,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/external/get_public_key/f4a8893cfc7cc4f313b0c426fa25c38c6c57664957bc56a170a27945759c5102.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 28,
                                "end_line": 60,
                                "input_file": {
                                    "filename": "contract.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 56,
                                        "end_line": 1,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/get_public_key/b2849ba7bb077663e4b038ad05edb036eedd0d3d2d173b73abde9848684cee47.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 20,
                                                "end_line": 59,
                                                "input_file": {
                                                    "filename": "contract.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 59
                                            },
                                            "While constructing the external wrapper for:"
                                        ],
                                        "start_col": 45,
                                        "start_line": 1
                                    },
                                    "While expanding the reference 'syscall_ptr' in:"
                                ],
                                "start_col": 9,
                                "start_line": 60
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 19,
                        "start_line": 1
                    }
                },
                "254": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.get_public_key"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 26,
                            "offset": 1
                        },
                        "reference_ids": {
                            "__wrappers__.get_public_key.__calldata_actual_size": 169,
                            "__wrappers__.get_public_key.__calldata_ptr": 168,
                            "__wrappers__.get_public_key.ecdsa_ptr": 167,
                            "__wrappers__.get_public_key.pedersen_ptr": 165,
                            "__wrappers__.get_public_key.range_check_ptr": 166,
                            "__wrappers__.get_public_key.syscall_ptr": 164
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 96,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/external/get_public_key/bf54f65e3c6b81daf1c2b60a8cb4034b53ce30386ebc03b148a9de60d6f5dd57.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 36,
                                "end_line": 61,
                                "input_file": {
                                    "filename": "contract.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 83,
                                        "end_line": 1,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/get_public_key/b2849ba7bb077663e4b038ad05edb036eedd0d3d2d173b73abde9848684cee47.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 20,
                                                "end_line": 59,
                                                "input_file": {
                                                    "filename": "contract.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 59
                                            },
                                            "While constructing the external wrapper for:"
                                        ],
                                        "start_col": 71,
                                        "start_line": 1
                                    },
                                    "While expanding the reference 'pedersen_ptr' in:"
                                ],
                                "start_col": 9,
                                "start_line": 61
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 20,
                        "start_line": 1
                    }
                },
                "255": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.get_public_key"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 26,
                            "offset": 2
                        },
                        "reference_ids": {
                            "__wrappers__.get_public_key.__calldata_actual_size": 169,
                            "__wrappers__.get_public_key.__calldata_ptr": 168,
                            "__wrappers__.get_public_key.ecdsa_ptr": 167,
                            "__wrappers__.get_public_key.pedersen_ptr": 165,
                            "__wrappers__.get_public_key.range_check_ptr": 166,
                            "__wrappers__.get_public_key.syscall_ptr": 164
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 53,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/external/get_public_key/d5f67cc7e69abbde284d945f017319bd8e156adfab63895c8d652f5c3e4f6c3a.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 24,
                                "end_line": 62,
                                "input_file": {
                                    "filename": "contract.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 116,
                                        "end_line": 1,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/get_public_key/b2849ba7bb077663e4b038ad05edb036eedd0d3d2d173b73abde9848684cee47.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 20,
                                                "end_line": 59,
                                                "input_file": {
                                                    "filename": "contract.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 59
                                            },
                                            "While constructing the external wrapper for:"
                                        ],
                                        "start_col": 101,
                                        "start_line": 1
                                    },
                                    "While expanding the reference 'range_check_ptr' in:"
                                ],
                                "start_col": 9,
                                "start_line": 62
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 23,
                        "start_line": 1
                    }
                },
                "256": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.get_public_key"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 26,
                            "offset": 3
                        },
                        "reference_ids": {
                            "__wrappers__.get_public_key.__calldata_actual_size": 169,
                            "__wrappers__.get_public_key.__calldata_ptr": 168,
                            "__wrappers__.get_public_key.ecdsa_ptr": 167,
                            "__wrappers__.get_public_key.pedersen_ptr": 165,
                            "__wrappers__.get_public_key.range_check_ptr": 166,
                            "__wrappers__.get_public_key.syscall_ptr": 164
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 20,
                        "end_line": 59,
                        "input_file": {
                            "filename": "contract.cairo"
                        },
                        "start_col": 6,
                        "start_line": 59
                    }
                },
                "258": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.get_public_key"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 26,
                            "offset": 28
                        },
                        "reference_ids": {
                            "__wrappers__.get_public_key.__calldata_actual_size": 169,
                            "__wrappers__.get_public_key.__calldata_ptr": 168,
                            "__wrappers__.get_public_key.ecdsa_ptr": 167,
                            "__wrappers__.get_public_key.pedersen_ptr": 171,
                            "__wrappers__.get_public_key.range_check_ptr": 172,
                            "__wrappers__.get_public_key.ret_struct": 173,
                            "__wrappers__.get_public_key.syscall_ptr": 170
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 116,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/external/get_public_key/b2849ba7bb077663e4b038ad05edb036eedd0d3d2d173b73abde9848684cee47.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 20,
                                "end_line": 59,
                                "input_file": {
                                    "filename": "contract.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 104,
                                        "end_line": 2,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/get_public_key/b2849ba7bb077663e4b038ad05edb036eedd0d3d2d173b73abde9848684cee47.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 20,
                                                "end_line": 59,
                                                "input_file": {
                                                    "filename": "contract.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 59
                                            },
                                            "While constructing the external wrapper for:"
                                        ],
                                        "start_col": 89,
                                        "start_line": 2
                                    },
                                    "While expanding the reference 'range_check_ptr' in:"
                                ],
                                "start_col": 6,
                                "start_line": 59
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 101,
                        "start_line": 1
                    }
                },
                "259": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.get_public_key"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 26,
                            "offset": 29
                        },
                        "reference_ids": {
                            "__wrappers__.get_public_key.__calldata_actual_size": 169,
                            "__wrappers__.get_public_key.__calldata_ptr": 168,
                            "__wrappers__.get_public_key.ecdsa_ptr": 167,
                            "__wrappers__.get_public_key.pedersen_ptr": 171,
                            "__wrappers__.get_public_key.range_check_ptr": 172,
                            "__wrappers__.get_public_key.ret_struct": 173,
                            "__wrappers__.get_public_key.syscall_ptr": 170
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 105,
                        "end_line": 2,
                        "input_file": {
                            "filename": "autogen/starknet/external/get_public_key/b2849ba7bb077663e4b038ad05edb036eedd0d3d2d173b73abde9848684cee47.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 20,
                                "end_line": 59,
                                "input_file": {
                                    "filename": "contract.cairo"
                                },
                                "start_col": 6,
                                "start_line": 59
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 48,
                        "start_line": 2
                    }
                },
                "261": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.get_public_key"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 26,
                            "offset": 36
                        },
                        "reference_ids": {
                            "__wrappers__.get_public_key.__calldata_actual_size": 169,
                            "__wrappers__.get_public_key.__calldata_ptr": 168,
                            "__wrappers__.get_public_key.ecdsa_ptr": 167,
                            "__wrappers__.get_public_key.pedersen_ptr": 171,
                            "__wrappers__.get_public_key.range_check_ptr": 174,
                            "__wrappers__.get_public_key.ret_struct": 173,
                            "__wrappers__.get_public_key.retdata": 176,
                            "__wrappers__.get_public_key.retdata_size": 175,
                            "__wrappers__.get_public_key.syscall_ptr": 170
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 56,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/external/get_public_key/b2849ba7bb077663e4b038ad05edb036eedd0d3d2d173b73abde9848684cee47.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 20,
                                "end_line": 59,
                                "input_file": {
                                    "filename": "contract.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 20,
                                        "end_line": 1,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/get_public_key/aa526043a8db9187624857305b1409f029aec9f9c85f47438b55e65b3afc0639.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 20,
                                                "end_line": 59,
                                                "input_file": {
                                                    "filename": "contract.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 59
                                            },
                                            "While constructing the external wrapper for:"
                                        ],
                                        "start_col": 9,
                                        "start_line": 1
                                    },
                                    "While expanding the reference 'syscall_ptr' in:"
                                ],
                                "start_col": 6,
                                "start_line": 59
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 45,
                        "start_line": 1
                    }
                },
                "262": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.get_public_key"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 26,
                            "offset": 37
                        },
                        "reference_ids": {
                            "__wrappers__.get_public_key.__calldata_actual_size": 169,
                            "__wrappers__.get_public_key.__calldata_ptr": 168,
                            "__wrappers__.get_public_key.ecdsa_ptr": 167,
                            "__wrappers__.get_public_key.pedersen_ptr": 171,
                            "__wrappers__.get_public_key.range_check_ptr": 174,
                            "__wrappers__.get_public_key.ret_struct": 173,
                            "__wrappers__.get_public_key.retdata": 176,
                            "__wrappers__.get_public_key.retdata_size": 175,
                            "__wrappers__.get_public_key.syscall_ptr": 170
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 83,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/external/get_public_key/b2849ba7bb077663e4b038ad05edb036eedd0d3d2d173b73abde9848684cee47.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 20,
                                "end_line": 59,
                                "input_file": {
                                    "filename": "contract.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 33,
                                        "end_line": 1,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/get_public_key/aa526043a8db9187624857305b1409f029aec9f9c85f47438b55e65b3afc0639.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 20,
                                                "end_line": 59,
                                                "input_file": {
                                                    "filename": "contract.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 59
                                            },
                                            "While constructing the external wrapper for:"
                                        ],
                                        "start_col": 21,
                                        "start_line": 1
                                    },
                                    "While expanding the reference 'pedersen_ptr' in:"
                                ],
                                "start_col": 6,
                                "start_line": 59
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 71,
                        "start_line": 1
                    }
                },
                "263": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.get_public_key"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 26,
                            "offset": 38
                        },
                        "reference_ids": {
                            "__wrappers__.get_public_key.__calldata_actual_size": 169,
                            "__wrappers__.get_public_key.__calldata_ptr": 168,
                            "__wrappers__.get_public_key.ecdsa_ptr": 167,
                            "__wrappers__.get_public_key.pedersen_ptr": 171,
                            "__wrappers__.get_public_key.range_check_ptr": 174,
                            "__wrappers__.get_public_key.ret_struct": 173,
                            "__wrappers__.get_public_key.retdata": 176,
                            "__wrappers__.get_public_key.retdata_size": 175,
                            "__wrappers__.get_public_key.syscall_ptr": 170
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 21,
                        "end_line": 2,
                        "input_file": {
                            "filename": "autogen/starknet/external/get_public_key/b2849ba7bb077663e4b038ad05edb036eedd0d3d2d173b73abde9848684cee47.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 20,
                                "end_line": 59,
                                "input_file": {
                                    "filename": "contract.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 49,
                                        "end_line": 1,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/get_public_key/aa526043a8db9187624857305b1409f029aec9f9c85f47438b55e65b3afc0639.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 20,
                                                "end_line": 59,
                                                "input_file": {
                                                    "filename": "contract.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 59
                                            },
                                            "While constructing the external wrapper for:"
                                        ],
                                        "start_col": 34,
                                        "start_line": 1
                                    },
                                    "While expanding the reference 'range_check_ptr' in:"
                                ],
                                "start_col": 6,
                                "start_line": 59
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 6,
                        "start_line": 2
                    }
                },
                "264": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.get_public_key"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 26,
                            "offset": 39
                        },
                        "reference_ids": {
                            "__wrappers__.get_public_key.__calldata_actual_size": 169,
                            "__wrappers__.get_public_key.__calldata_ptr": 168,
                            "__wrappers__.get_public_key.ecdsa_ptr": 167,
                            "__wrappers__.get_public_key.pedersen_ptr": 171,
                            "__wrappers__.get_public_key.range_check_ptr": 174,
                            "__wrappers__.get_public_key.ret_struct": 173,
                            "__wrappers__.get_public_key.retdata": 176,
                            "__wrappers__.get_public_key.retdata_size": 175,
                            "__wrappers__.get_public_key.syscall_ptr": 170
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 47,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/external/get_public_key/7998f829c4aa5ea19acd9325ec8f13445bd7eb3660e26c1acda6a694c86b221a.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 20,
                                "end_line": 59,
                                "input_file": {
                                    "filename": "contract.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 59,
                                        "end_line": 1,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/get_public_key/aa526043a8db9187624857305b1409f029aec9f9c85f47438b55e65b3afc0639.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 20,
                                                "end_line": 59,
                                                "input_file": {
                                                    "filename": "contract.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 59
                                            },
                                            "While constructing the external wrapper for:"
                                        ],
                                        "start_col": 50,
                                        "start_line": 1
                                    },
                                    "While expanding the reference 'ecdsa_ptr' in:"
                                ],
                                "start_col": 6,
                                "start_line": 59
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 17,
                        "start_line": 1
                    }
                },
                "265": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.get_public_key"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 26,
                            "offset": 40
                        },
                        "reference_ids": {
                            "__wrappers__.get_public_key.__calldata_actual_size": 169,
                            "__wrappers__.get_public_key.__calldata_ptr": 168,
                            "__wrappers__.get_public_key.ecdsa_ptr": 167,
                            "__wrappers__.get_public_key.pedersen_ptr": 171,
                            "__wrappers__.get_public_key.range_check_ptr": 174,
                            "__wrappers__.get_public_key.ret_struct": 173,
                            "__wrappers__.get_public_key.retdata": 176,
                            "__wrappers__.get_public_key.retdata_size": 175,
                            "__wrappers__.get_public_key.syscall_ptr": 170
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 35,
                        "end_line": 2,
                        "input_file": {
                            "filename": "autogen/starknet/external/get_public_key/b2849ba7bb077663e4b038ad05edb036eedd0d3d2d173b73abde9848684cee47.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 20,
                                "end_line": 59,
                                "input_file": {
                                    "filename": "contract.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 72,
                                        "end_line": 1,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/get_public_key/aa526043a8db9187624857305b1409f029aec9f9c85f47438b55e65b3afc0639.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 20,
                                                "end_line": 59,
                                                "input_file": {
                                                    "filename": "contract.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 59
                                            },
                                            "While constructing the external wrapper for:"
                                        ],
                                        "start_col": 60,
                                        "start_line": 1
                                    },
                                    "While expanding the reference 'retdata_size' in:"
                                ],
                                "start_col": 6,
                                "start_line": 59
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 23,
                        "start_line": 2
                    }
                },
                "266": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.get_public_key"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 26,
                            "offset": 41
                        },
                        "reference_ids": {
                            "__wrappers__.get_public_key.__calldata_actual_size": 169,
                            "__wrappers__.get_public_key.__calldata_ptr": 168,
                            "__wrappers__.get_public_key.ecdsa_ptr": 167,
                            "__wrappers__.get_public_key.pedersen_ptr": 171,
                            "__wrappers__.get_public_key.range_check_ptr": 174,
                            "__wrappers__.get_public_key.ret_struct": 173,
                            "__wrappers__.get_public_key.retdata": 176,
                            "__wrappers__.get_public_key.retdata_size": 175,
                            "__wrappers__.get_public_key.syscall_ptr": 170
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 44,
                        "end_line": 2,
                        "input_file": {
                            "filename": "autogen/starknet/external/get_public_key/b2849ba7bb077663e4b038ad05edb036eedd0d3d2d173b73abde9848684cee47.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 20,
                                "end_line": 59,
                                "input_file": {
                                    "filename": "contract.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 80,
                                        "end_line": 1,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/get_public_key/aa526043a8db9187624857305b1409f029aec9f9c85f47438b55e65b3afc0639.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 20,
                                                "end_line": 59,
                                                "input_file": {
                                                    "filename": "contract.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 59
                                            },
                                            "While constructing the external wrapper for:"
                                        ],
                                        "start_col": 73,
                                        "start_line": 1
                                    },
                                    "While expanding the reference 'retdata' in:"
                                ],
                                "start_col": 6,
                                "start_line": 59
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 37,
                        "start_line": 2
                    }
                },
                "267": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.get_public_key"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 26,
                            "offset": 42
                        },
                        "reference_ids": {
                            "__wrappers__.get_public_key.__calldata_actual_size": 169,
                            "__wrappers__.get_public_key.__calldata_ptr": 168,
                            "__wrappers__.get_public_key.ecdsa_ptr": 167,
                            "__wrappers__.get_public_key.pedersen_ptr": 171,
                            "__wrappers__.get_public_key.range_check_ptr": 174,
                            "__wrappers__.get_public_key.ret_struct": 173,
                            "__wrappers__.get_public_key.retdata": 176,
                            "__wrappers__.get_public_key.retdata_size": 175,
                            "__wrappers__.get_public_key.syscall_ptr": 170
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 81,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/external/get_public_key/aa526043a8db9187624857305b1409f029aec9f9c85f47438b55e65b3afc0639.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 20,
                                "end_line": 59,
                                "input_file": {
                                    "filename": "contract.cairo"
                                },
                                "start_col": 6,
                                "start_line": 59
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 1,
                        "start_line": 1
                    }
                },
                "268": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.get_nonce"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 27,
                            "offset": 0
                        },
                        "reference_ids": {
                            "__main__.get_nonce.pedersen_ptr": 178,
                            "__main__.get_nonce.range_check_ptr": 179,
                            "__main__.get_nonce.syscall_ptr": 177
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 28,
                        "end_line": 70,
                        "input_file": {
                            "filename": "contract.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 34,
                                "end_line": 13,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/current_nonce/decl.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 37,
                                        "end_line": 74,
                                        "input_file": {
                                            "filename": "contract.cairo"
                                        },
                                        "start_col": 17,
                                        "start_line": 74
                                    },
                                    "While trying to retrieve the implicit argument 'syscall_ptr' in:"
                                ],
                                "start_col": 15,
                                "start_line": 13
                            },
                            "While expanding the reference 'syscall_ptr' in:"
                        ],
                        "start_col": 9,
                        "start_line": 70
                    }
                },
                "269": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.get_nonce"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 27,
                            "offset": 1
                        },
                        "reference_ids": {
                            "__main__.get_nonce.pedersen_ptr": 178,
                            "__main__.get_nonce.range_check_ptr": 179,
                            "__main__.get_nonce.syscall_ptr": 177
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 36,
                        "end_line": 71,
                        "input_file": {
                            "filename": "contract.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 63,
                                "end_line": 13,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/current_nonce/decl.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 37,
                                        "end_line": 74,
                                        "input_file": {
                                            "filename": "contract.cairo"
                                        },
                                        "start_col": 17,
                                        "start_line": 74
                                    },
                                    "While trying to retrieve the implicit argument 'pedersen_ptr' in:"
                                ],
                                "start_col": 36,
                                "start_line": 13
                            },
                            "While expanding the reference 'pedersen_ptr' in:"
                        ],
                        "start_col": 9,
                        "start_line": 71
                    }
                },
                "270": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.get_nonce"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 27,
                            "offset": 2
                        },
                        "reference_ids": {
                            "__main__.get_nonce.pedersen_ptr": 178,
                            "__main__.get_nonce.range_check_ptr": 179,
                            "__main__.get_nonce.syscall_ptr": 177
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 24,
                        "end_line": 72,
                        "input_file": {
                            "filename": "contract.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 80,
                                "end_line": 13,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/current_nonce/decl.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 37,
                                        "end_line": 74,
                                        "input_file": {
                                            "filename": "contract.cairo"
                                        },
                                        "start_col": 17,
                                        "start_line": 74
                                    },
                                    "While trying to retrieve the implicit argument 'range_check_ptr' in:"
                                ],
                                "start_col": 65,
                                "start_line": 13
                            },
                            "While expanding the reference 'range_check_ptr' in:"
                        ],
                        "start_col": 9,
                        "start_line": 72
                    }
                },
                "271": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.get_nonce"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 27,
                            "offset": 3
                        },
                        "reference_ids": {
                            "__main__.get_nonce.pedersen_ptr": 178,
                            "__main__.get_nonce.range_check_ptr": 179,
                            "__main__.get_nonce.syscall_ptr": 177
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 37,
                        "end_line": 74,
                        "input_file": {
                            "filename": "contract.cairo"
                        },
                        "start_col": 17,
                        "start_line": 74
                    }
                },
                "273": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.get_nonce"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 27,
                            "offset": 23
                        },
                        "reference_ids": {
                            "__main__.get_nonce.pedersen_ptr": 181,
                            "__main__.get_nonce.range_check_ptr": 182,
                            "__main__.get_nonce.res": 183,
                            "__main__.get_nonce.syscall_ptr": 180
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 21,
                        "end_line": 75,
                        "input_file": {
                            "filename": "contract.cairo"
                        },
                        "start_col": 5,
                        "start_line": 75
                    }
                },
                "274": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.get_nonce_encode_return"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 28,
                            "offset": 0
                        },
                        "reference_ids": {
                            "__wrappers__.get_nonce_encode_return.range_check_ptr": 185,
                            "__wrappers__.get_nonce_encode_return.ret_struct": 184
                        }
                    },
                    "hints": [
                        {
                            "location": {
                                "end_col": 38,
                                "end_line": 3,
                                "input_file": {
                                    "filename": "autogen/starknet/external/return/get_nonce/b599da7e0616f5b52a9be2e1921aad249a1f0772086f536420e6a3635525f534.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 15,
                                        "end_line": 69,
                                        "input_file": {
                                            "filename": "contract.cairo"
                                        },
                                        "start_col": 6,
                                        "start_line": 69
                                    },
                                    "While handling return value of"
                                ],
                                "start_col": 5,
                                "start_line": 3
                            },
                            "n_prefix_newlines": 0
                        }
                    ],
                    "inst": {
                        "end_col": 17,
                        "end_line": 4,
                        "input_file": {
                            "filename": "autogen/starknet/external/return/get_nonce/b599da7e0616f5b52a9be2e1921aad249a1f0772086f536420e6a3635525f534.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 15,
                                "end_line": 69,
                                "input_file": {
                                    "filename": "contract.cairo"
                                },
                                "start_col": 6,
                                "start_line": 69
                            },
                            "While handling return value of"
                        ],
                        "start_col": 5,
                        "start_line": 4
                    }
                },
                "276": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.get_nonce_encode_return"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 28,
                            "offset": 1
                        },
                        "reference_ids": {
                            "__wrappers__.get_nonce_encode_return.__return_value_ptr": 187,
                            "__wrappers__.get_nonce_encode_return.__return_value_ptr_start": 186,
                            "__wrappers__.get_nonce_encode_return.range_check_ptr": 185,
                            "__wrappers__.get_nonce_encode_return.ret_struct": 184
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 45,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/arg_processor/fee896b6d05b2e98056b5628baa6fbee0adfb8960f3fee9d79fd2f066956cc42.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 22,
                                "end_line": 73,
                                "input_file": {
                                    "filename": "contract.cairo"
                                },
                                "start_col": 13,
                                "start_line": 73
                            },
                            "While handling return value 'res'"
                        ],
                        "start_col": 1,
                        "start_line": 1
                    }
                },
                "277": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.get_nonce_encode_return"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 28,
                            "offset": 1
                        },
                        "reference_ids": {
                            "__wrappers__.get_nonce_encode_return.__return_value_ptr": 188,
                            "__wrappers__.get_nonce_encode_return.__return_value_ptr_start": 186,
                            "__wrappers__.get_nonce_encode_return.range_check_ptr": 185,
                            "__wrappers__.get_nonce_encode_return.ret_struct": 184
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 48,
                        "end_line": 2,
                        "input_file": {
                            "filename": "autogen/starknet/arg_processor/fee896b6d05b2e98056b5628baa6fbee0adfb8960f3fee9d79fd2f066956cc42.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 22,
                                "end_line": 73,
                                "input_file": {
                                    "filename": "contract.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 36,
                                        "end_line": 11,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/return/get_nonce/b599da7e0616f5b52a9be2e1921aad249a1f0772086f536420e6a3635525f534.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 15,
                                                "end_line": 69,
                                                "input_file": {
                                                    "filename": "contract.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 69
                                            },
                                            "While handling return value of"
                                        ],
                                        "start_col": 18,
                                        "start_line": 11
                                    },
                                    "While expanding the reference '__return_value_ptr' in:"
                                ],
                                "start_col": 13,
                                "start_line": 73
                            },
                            "While handling return value 'res'"
                        ],
                        "start_col": 26,
                        "start_line": 2
                    }
                },
                "279": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.get_nonce_encode_return"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 28,
                            "offset": 2
                        },
                        "reference_ids": {
                            "__wrappers__.get_nonce_encode_return.__return_value_ptr": 188,
                            "__wrappers__.get_nonce_encode_return.__return_value_ptr_start": 186,
                            "__wrappers__.get_nonce_encode_return.__temp12": 189,
                            "__wrappers__.get_nonce_encode_return.range_check_ptr": 185,
                            "__wrappers__.get_nonce_encode_return.ret_struct": 184
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 85,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/external/return/get_nonce/b599da7e0616f5b52a9be2e1921aad249a1f0772086f536420e6a3635525f534.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 15,
                                "end_line": 69,
                                "input_file": {
                                    "filename": "contract.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 40,
                                        "end_line": 10,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/return/get_nonce/b599da7e0616f5b52a9be2e1921aad249a1f0772086f536420e6a3635525f534.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 15,
                                                "end_line": 69,
                                                "input_file": {
                                                    "filename": "contract.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 69
                                            },
                                            "While handling return value of"
                                        ],
                                        "start_col": 25,
                                        "start_line": 10
                                    },
                                    "While expanding the reference 'range_check_ptr' in:"
                                ],
                                "start_col": 6,
                                "start_line": 69
                            },
                            "While handling return value of"
                        ],
                        "start_col": 70,
                        "start_line": 1
                    }
                },
                "280": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.get_nonce_encode_return"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 28,
                            "offset": 3
                        },
                        "reference_ids": {
                            "__wrappers__.get_nonce_encode_return.__return_value_ptr": 188,
                            "__wrappers__.get_nonce_encode_return.__return_value_ptr_start": 186,
                            "__wrappers__.get_nonce_encode_return.__temp12": 189,
                            "__wrappers__.get_nonce_encode_return.range_check_ptr": 185,
                            "__wrappers__.get_nonce_encode_return.ret_struct": 184
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 63,
                        "end_line": 11,
                        "input_file": {
                            "filename": "autogen/starknet/external/return/get_nonce/b599da7e0616f5b52a9be2e1921aad249a1f0772086f536420e6a3635525f534.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 15,
                                "end_line": 69,
                                "input_file": {
                                    "filename": "contract.cairo"
                                },
                                "start_col": 6,
                                "start_line": 69
                            },
                            "While handling return value of"
                        ],
                        "start_col": 18,
                        "start_line": 11
                    }
                },
                "281": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.get_nonce_encode_return"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 28,
                            "offset": 4
                        },
                        "reference_ids": {
                            "__wrappers__.get_nonce_encode_return.__return_value_ptr": 188,
                            "__wrappers__.get_nonce_encode_return.__return_value_ptr_start": 186,
                            "__wrappers__.get_nonce_encode_return.__temp12": 189,
                            "__wrappers__.get_nonce_encode_return.range_check_ptr": 185,
                            "__wrappers__.get_nonce_encode_return.ret_struct": 184
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 35,
                        "end_line": 5,
                        "input_file": {
                            "filename": "autogen/starknet/external/return/get_nonce/b599da7e0616f5b52a9be2e1921aad249a1f0772086f536420e6a3635525f534.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 15,
                                "end_line": 69,
                                "input_file": {
                                    "filename": "contract.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 38,
                                        "end_line": 12,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/return/get_nonce/b599da7e0616f5b52a9be2e1921aad249a1f0772086f536420e6a3635525f534.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 15,
                                                "end_line": 69,
                                                "input_file": {
                                                    "filename": "contract.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 69
                                            },
                                            "While handling return value of"
                                        ],
                                        "start_col": 14,
                                        "start_line": 12
                                    },
                                    "While expanding the reference '__return_value_ptr_start' in:"
                                ],
                                "start_col": 6,
                                "start_line": 69
                            },
                            "While handling return value of"
                        ],
                        "start_col": 11,
                        "start_line": 5
                    }
                },
                "282": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.get_nonce_encode_return"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 28,
                            "offset": 5
                        },
                        "reference_ids": {
                            "__wrappers__.get_nonce_encode_return.__return_value_ptr": 188,
                            "__wrappers__.get_nonce_encode_return.__return_value_ptr_start": 186,
                            "__wrappers__.get_nonce_encode_return.__temp12": 189,
                            "__wrappers__.get_nonce_encode_return.range_check_ptr": 185,
                            "__wrappers__.get_nonce_encode_return.ret_struct": 184
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 39,
                        "end_line": 12,
                        "input_file": {
                            "filename": "autogen/starknet/external/return/get_nonce/b599da7e0616f5b52a9be2e1921aad249a1f0772086f536420e6a3635525f534.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 15,
                                "end_line": 69,
                                "input_file": {
                                    "filename": "contract.cairo"
                                },
                                "start_col": 6,
                                "start_line": 69
                            },
                            "While handling return value of"
                        ],
                        "start_col": 5,
                        "start_line": 9
                    }
                },
                "283": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.get_nonce"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 29,
                            "offset": 0
                        },
                        "reference_ids": {
                            "__wrappers__.get_nonce.__calldata_actual_size": 195,
                            "__wrappers__.get_nonce.__calldata_ptr": 194,
                            "__wrappers__.get_nonce.ecdsa_ptr": 193,
                            "__wrappers__.get_nonce.pedersen_ptr": 191,
                            "__wrappers__.get_nonce.range_check_ptr": 192,
                            "__wrappers__.get_nonce.syscall_ptr": 190
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 44,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/arg_processor/7f0b238f4e526821a97d8aaa2f9484df4b5bd00cbad10a761ae4225314096a56.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 15,
                                "end_line": 69,
                                "input_file": {
                                    "filename": "contract.cairo"
                                },
                                "start_col": 6,
                                "start_line": 69
                            },
                            "While handling calldata of"
                        ],
                        "start_col": 1,
                        "start_line": 1
                    }
                },
                "284": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.get_nonce"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 29,
                            "offset": 0
                        },
                        "reference_ids": {
                            "__wrappers__.get_nonce.__calldata_actual_size": 195,
                            "__wrappers__.get_nonce.__calldata_ptr": 194,
                            "__wrappers__.get_nonce.ecdsa_ptr": 193,
                            "__wrappers__.get_nonce.pedersen_ptr": 191,
                            "__wrappers__.get_nonce.range_check_ptr": 192,
                            "__wrappers__.get_nonce.syscall_ptr": 190
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 50,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/external/get_nonce/f4a8893cfc7cc4f313b0c426fa25c38c6c57664957bc56a170a27945759c5102.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 28,
                                "end_line": 70,
                                "input_file": {
                                    "filename": "contract.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 56,
                                        "end_line": 1,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/get_nonce/a346d877d422c1aceb29d6c4893476b7e7d7c8e9bd59d8ccc775b8622116dd2a.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 15,
                                                "end_line": 69,
                                                "input_file": {
                                                    "filename": "contract.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 69
                                            },
                                            "While constructing the external wrapper for:"
                                        ],
                                        "start_col": 45,
                                        "start_line": 1
                                    },
                                    "While expanding the reference 'syscall_ptr' in:"
                                ],
                                "start_col": 9,
                                "start_line": 70
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 19,
                        "start_line": 1
                    }
                },
                "285": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.get_nonce"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 29,
                            "offset": 1
                        },
                        "reference_ids": {
                            "__wrappers__.get_nonce.__calldata_actual_size": 195,
                            "__wrappers__.get_nonce.__calldata_ptr": 194,
                            "__wrappers__.get_nonce.ecdsa_ptr": 193,
                            "__wrappers__.get_nonce.pedersen_ptr": 191,
                            "__wrappers__.get_nonce.range_check_ptr": 192,
                            "__wrappers__.get_nonce.syscall_ptr": 190
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 96,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/external/get_nonce/bf54f65e3c6b81daf1c2b60a8cb4034b53ce30386ebc03b148a9de60d6f5dd57.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 36,
                                "end_line": 71,
                                "input_file": {
                                    "filename": "contract.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 83,
                                        "end_line": 1,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/get_nonce/a346d877d422c1aceb29d6c4893476b7e7d7c8e9bd59d8ccc775b8622116dd2a.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 15,
                                                "end_line": 69,
                                                "input_file": {
                                                    "filename": "contract.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 69
                                            },
                                            "While constructing the external wrapper for:"
                                        ],
                                        "start_col": 71,
                                        "start_line": 1
                                    },
                                    "While expanding the reference 'pedersen_ptr' in:"
                                ],
                                "start_col": 9,
                                "start_line": 71
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 20,
                        "start_line": 1
                    }
                },
                "286": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.get_nonce"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 29,
                            "offset": 2
                        },
                        "reference_ids": {
                            "__wrappers__.get_nonce.__calldata_actual_size": 195,
                            "__wrappers__.get_nonce.__calldata_ptr": 194,
                            "__wrappers__.get_nonce.ecdsa_ptr": 193,
                            "__wrappers__.get_nonce.pedersen_ptr": 191,
                            "__wrappers__.get_nonce.range_check_ptr": 192,
                            "__wrappers__.get_nonce.syscall_ptr": 190
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 53,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/external/get_nonce/d5f67cc7e69abbde284d945f017319bd8e156adfab63895c8d652f5c3e4f6c3a.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 24,
                                "end_line": 72,
                                "input_file": {
                                    "filename": "contract.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 116,
                                        "end_line": 1,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/get_nonce/a346d877d422c1aceb29d6c4893476b7e7d7c8e9bd59d8ccc775b8622116dd2a.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 15,
                                                "end_line": 69,
                                                "input_file": {
                                                    "filename": "contract.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 69
                                            },
                                            "While constructing the external wrapper for:"
                                        ],
                                        "start_col": 101,
                                        "start_line": 1
                                    },
                                    "While expanding the reference 'range_check_ptr' in:"
                                ],
                                "start_col": 9,
                                "start_line": 72
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 23,
                        "start_line": 1
                    }
                },
                "287": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.get_nonce"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 29,
                            "offset": 3
                        },
                        "reference_ids": {
                            "__wrappers__.get_nonce.__calldata_actual_size": 195,
                            "__wrappers__.get_nonce.__calldata_ptr": 194,
                            "__wrappers__.get_nonce.ecdsa_ptr": 193,
                            "__wrappers__.get_nonce.pedersen_ptr": 191,
                            "__wrappers__.get_nonce.range_check_ptr": 192,
                            "__wrappers__.get_nonce.syscall_ptr": 190
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 15,
                        "end_line": 69,
                        "input_file": {
                            "filename": "contract.cairo"
                        },
                        "start_col": 6,
                        "start_line": 69
                    }
                },
                "289": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.get_nonce"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 29,
                            "offset": 28
                        },
                        "reference_ids": {
                            "__wrappers__.get_nonce.__calldata_actual_size": 195,
                            "__wrappers__.get_nonce.__calldata_ptr": 194,
                            "__wrappers__.get_nonce.ecdsa_ptr": 193,
                            "__wrappers__.get_nonce.pedersen_ptr": 197,
                            "__wrappers__.get_nonce.range_check_ptr": 198,
                            "__wrappers__.get_nonce.ret_struct": 199,
                            "__wrappers__.get_nonce.syscall_ptr": 196
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 116,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/external/get_nonce/a346d877d422c1aceb29d6c4893476b7e7d7c8e9bd59d8ccc775b8622116dd2a.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 15,
                                "end_line": 69,
                                "input_file": {
                                    "filename": "contract.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 99,
                                        "end_line": 2,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/get_nonce/a346d877d422c1aceb29d6c4893476b7e7d7c8e9bd59d8ccc775b8622116dd2a.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 15,
                                                "end_line": 69,
                                                "input_file": {
                                                    "filename": "contract.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 69
                                            },
                                            "While constructing the external wrapper for:"
                                        ],
                                        "start_col": 84,
                                        "start_line": 2
                                    },
                                    "While expanding the reference 'range_check_ptr' in:"
                                ],
                                "start_col": 6,
                                "start_line": 69
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 101,
                        "start_line": 1
                    }
                },
                "290": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.get_nonce"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 29,
                            "offset": 29
                        },
                        "reference_ids": {
                            "__wrappers__.get_nonce.__calldata_actual_size": 195,
                            "__wrappers__.get_nonce.__calldata_ptr": 194,
                            "__wrappers__.get_nonce.ecdsa_ptr": 193,
                            "__wrappers__.get_nonce.pedersen_ptr": 197,
                            "__wrappers__.get_nonce.range_check_ptr": 198,
                            "__wrappers__.get_nonce.ret_struct": 199,
                            "__wrappers__.get_nonce.syscall_ptr": 196
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 100,
                        "end_line": 2,
                        "input_file": {
                            "filename": "autogen/starknet/external/get_nonce/a346d877d422c1aceb29d6c4893476b7e7d7c8e9bd59d8ccc775b8622116dd2a.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 15,
                                "end_line": 69,
                                "input_file": {
                                    "filename": "contract.cairo"
                                },
                                "start_col": 6,
                                "start_line": 69
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 48,
                        "start_line": 2
                    }
                },
                "292": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.get_nonce"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 29,
                            "offset": 36
                        },
                        "reference_ids": {
                            "__wrappers__.get_nonce.__calldata_actual_size": 195,
                            "__wrappers__.get_nonce.__calldata_ptr": 194,
                            "__wrappers__.get_nonce.ecdsa_ptr": 193,
                            "__wrappers__.get_nonce.pedersen_ptr": 197,
                            "__wrappers__.get_nonce.range_check_ptr": 200,
                            "__wrappers__.get_nonce.ret_struct": 199,
                            "__wrappers__.get_nonce.retdata": 202,
                            "__wrappers__.get_nonce.retdata_size": 201,
                            "__wrappers__.get_nonce.syscall_ptr": 196
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 56,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/external/get_nonce/a346d877d422c1aceb29d6c4893476b7e7d7c8e9bd59d8ccc775b8622116dd2a.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 15,
                                "end_line": 69,
                                "input_file": {
                                    "filename": "contract.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 20,
                                        "end_line": 1,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/get_nonce/aa526043a8db9187624857305b1409f029aec9f9c85f47438b55e65b3afc0639.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 15,
                                                "end_line": 69,
                                                "input_file": {
                                                    "filename": "contract.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 69
                                            },
                                            "While constructing the external wrapper for:"
                                        ],
                                        "start_col": 9,
                                        "start_line": 1
                                    },
                                    "While expanding the reference 'syscall_ptr' in:"
                                ],
                                "start_col": 6,
                                "start_line": 69
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 45,
                        "start_line": 1
                    }
                },
                "293": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.get_nonce"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 29,
                            "offset": 37
                        },
                        "reference_ids": {
                            "__wrappers__.get_nonce.__calldata_actual_size": 195,
                            "__wrappers__.get_nonce.__calldata_ptr": 194,
                            "__wrappers__.get_nonce.ecdsa_ptr": 193,
                            "__wrappers__.get_nonce.pedersen_ptr": 197,
                            "__wrappers__.get_nonce.range_check_ptr": 200,
                            "__wrappers__.get_nonce.ret_struct": 199,
                            "__wrappers__.get_nonce.retdata": 202,
                            "__wrappers__.get_nonce.retdata_size": 201,
                            "__wrappers__.get_nonce.syscall_ptr": 196
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 83,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/external/get_nonce/a346d877d422c1aceb29d6c4893476b7e7d7c8e9bd59d8ccc775b8622116dd2a.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 15,
                                "end_line": 69,
                                "input_file": {
                                    "filename": "contract.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 33,
                                        "end_line": 1,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/get_nonce/aa526043a8db9187624857305b1409f029aec9f9c85f47438b55e65b3afc0639.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 15,
                                                "end_line": 69,
                                                "input_file": {
                                                    "filename": "contract.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 69
                                            },
                                            "While constructing the external wrapper for:"
                                        ],
                                        "start_col": 21,
                                        "start_line": 1
                                    },
                                    "While expanding the reference 'pedersen_ptr' in:"
                                ],
                                "start_col": 6,
                                "start_line": 69
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 71,
                        "start_line": 1
                    }
                },
                "294": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.get_nonce"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 29,
                            "offset": 38
                        },
                        "reference_ids": {
                            "__wrappers__.get_nonce.__calldata_actual_size": 195,
                            "__wrappers__.get_nonce.__calldata_ptr": 194,
                            "__wrappers__.get_nonce.ecdsa_ptr": 193,
                            "__wrappers__.get_nonce.pedersen_ptr": 197,
                            "__wrappers__.get_nonce.range_check_ptr": 200,
                            "__wrappers__.get_nonce.ret_struct": 199,
                            "__wrappers__.get_nonce.retdata": 202,
                            "__wrappers__.get_nonce.retdata_size": 201,
                            "__wrappers__.get_nonce.syscall_ptr": 196
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 21,
                        "end_line": 2,
                        "input_file": {
                            "filename": "autogen/starknet/external/get_nonce/a346d877d422c1aceb29d6c4893476b7e7d7c8e9bd59d8ccc775b8622116dd2a.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 15,
                                "end_line": 69,
                                "input_file": {
                                    "filename": "contract.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 49,
                                        "end_line": 1,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/get_nonce/aa526043a8db9187624857305b1409f029aec9f9c85f47438b55e65b3afc0639.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 15,
                                                "end_line": 69,
                                                "input_file": {
                                                    "filename": "contract.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 69
                                            },
                                            "While constructing the external wrapper for:"
                                        ],
                                        "start_col": 34,
                                        "start_line": 1
                                    },
                                    "While expanding the reference 'range_check_ptr' in:"
                                ],
                                "start_col": 6,
                                "start_line": 69
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 6,
                        "start_line": 2
                    }
                },
                "295": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.get_nonce"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 29,
                            "offset": 39
                        },
                        "reference_ids": {
                            "__wrappers__.get_nonce.__calldata_actual_size": 195,
                            "__wrappers__.get_nonce.__calldata_ptr": 194,
                            "__wrappers__.get_nonce.ecdsa_ptr": 193,
                            "__wrappers__.get_nonce.pedersen_ptr": 197,
                            "__wrappers__.get_nonce.range_check_ptr": 200,
                            "__wrappers__.get_nonce.ret_struct": 199,
                            "__wrappers__.get_nonce.retdata": 202,
                            "__wrappers__.get_nonce.retdata_size": 201,
                            "__wrappers__.get_nonce.syscall_ptr": 196
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 47,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/external/get_nonce/7998f829c4aa5ea19acd9325ec8f13445bd7eb3660e26c1acda6a694c86b221a.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 15,
                                "end_line": 69,
                                "input_file": {
                                    "filename": "contract.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 59,
                                        "end_line": 1,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/get_nonce/aa526043a8db9187624857305b1409f029aec9f9c85f47438b55e65b3afc0639.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 15,
                                                "end_line": 69,
                                                "input_file": {
                                                    "filename": "contract.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 69
                                            },
                                            "While constructing the external wrapper for:"
                                        ],
                                        "start_col": 50,
                                        "start_line": 1
                                    },
                                    "While expanding the reference 'ecdsa_ptr' in:"
                                ],
                                "start_col": 6,
                                "start_line": 69
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 17,
                        "start_line": 1
                    }
                },
                "296": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.get_nonce"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 29,
                            "offset": 40
                        },
                        "reference_ids": {
                            "__wrappers__.get_nonce.__calldata_actual_size": 195,
                            "__wrappers__.get_nonce.__calldata_ptr": 194,
                            "__wrappers__.get_nonce.ecdsa_ptr": 193,
                            "__wrappers__.get_nonce.pedersen_ptr": 197,
                            "__wrappers__.get_nonce.range_check_ptr": 200,
                            "__wrappers__.get_nonce.ret_struct": 199,
                            "__wrappers__.get_nonce.retdata": 202,
                            "__wrappers__.get_nonce.retdata_size": 201,
                            "__wrappers__.get_nonce.syscall_ptr": 196
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 35,
                        "end_line": 2,
                        "input_file": {
                            "filename": "autogen/starknet/external/get_nonce/a346d877d422c1aceb29d6c4893476b7e7d7c8e9bd59d8ccc775b8622116dd2a.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 15,
                                "end_line": 69,
                                "input_file": {
                                    "filename": "contract.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 72,
                                        "end_line": 1,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/get_nonce/aa526043a8db9187624857305b1409f029aec9f9c85f47438b55e65b3afc0639.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 15,
                                                "end_line": 69,
                                                "input_file": {
                                                    "filename": "contract.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 69
                                            },
                                            "While constructing the external wrapper for:"
                                        ],
                                        "start_col": 60,
                                        "start_line": 1
                                    },
                                    "While expanding the reference 'retdata_size' in:"
                                ],
                                "start_col": 6,
                                "start_line": 69
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 23,
                        "start_line": 2
                    }
                },
                "297": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.get_nonce"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 29,
                            "offset": 41
                        },
                        "reference_ids": {
                            "__wrappers__.get_nonce.__calldata_actual_size": 195,
                            "__wrappers__.get_nonce.__calldata_ptr": 194,
                            "__wrappers__.get_nonce.ecdsa_ptr": 193,
                            "__wrappers__.get_nonce.pedersen_ptr": 197,
                            "__wrappers__.get_nonce.range_check_ptr": 200,
                            "__wrappers__.get_nonce.ret_struct": 199,
                            "__wrappers__.get_nonce.retdata": 202,
                            "__wrappers__.get_nonce.retdata_size": 201,
                            "__wrappers__.get_nonce.syscall_ptr": 196
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 44,
                        "end_line": 2,
                        "input_file": {
                            "filename": "autogen/starknet/external/get_nonce/a346d877d422c1aceb29d6c4893476b7e7d7c8e9bd59d8ccc775b8622116dd2a.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 15,
                                "end_line": 69,
                                "input_file": {
                                    "filename": "contract.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 80,
                                        "end_line": 1,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/get_nonce/aa526043a8db9187624857305b1409f029aec9f9c85f47438b55e65b3afc0639.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 15,
                                                "end_line": 69,
                                                "input_file": {
                                                    "filename": "contract.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 69
                                            },
                                            "While constructing the external wrapper for:"
                                        ],
                                        "start_col": 73,
                                        "start_line": 1
                                    },
                                    "While expanding the reference 'retdata' in:"
                                ],
                                "start_col": 6,
                                "start_line": 69
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 37,
                        "start_line": 2
                    }
                },
                "298": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.get_nonce"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 29,
                            "offset": 42
                        },
                        "reference_ids": {
                            "__wrappers__.get_nonce.__calldata_actual_size": 195,
                            "__wrappers__.get_nonce.__calldata_ptr": 194,
                            "__wrappers__.get_nonce.ecdsa_ptr": 193,
                            "__wrappers__.get_nonce.pedersen_ptr": 197,
                            "__wrappers__.get_nonce.range_check_ptr": 200,
                            "__wrappers__.get_nonce.ret_struct": 199,
                            "__wrappers__.get_nonce.retdata": 202,
                            "__wrappers__.get_nonce.retdata_size": 201,
                            "__wrappers__.get_nonce.syscall_ptr": 196
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 81,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/external/get_nonce/aa526043a8db9187624857305b1409f029aec9f9c85f47438b55e65b3afc0639.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 15,
                                "end_line": 69,
                                "input_file": {
                                    "filename": "contract.cairo"
                                },
                                "start_col": 6,
                                "start_line": 69
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 1,
                        "start_line": 1
                    }
                },
                "299": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.set_public_key"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 30,
                            "offset": 0
                        },
                        "reference_ids": {
                            "__main__.set_public_key.new_public_key": 203,
                            "__main__.set_public_key.pedersen_ptr": 205,
                            "__main__.set_public_key.range_check_ptr": 206,
                            "__main__.set_public_key.syscall_ptr": 204
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 28,
                        "end_line": 84,
                        "input_file": {
                            "filename": "contract.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 28,
                                "end_line": 44,
                                "input_file": {
                                    "filename": "contract.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 23,
                                        "end_line": 88,
                                        "input_file": {
                                            "filename": "contract.cairo"
                                        },
                                        "start_col": 5,
                                        "start_line": 88
                                    },
                                    "While trying to retrieve the implicit argument 'syscall_ptr' in:"
                                ],
                                "start_col": 9,
                                "start_line": 44
                            },
                            "While expanding the reference 'syscall_ptr' in:"
                        ],
                        "start_col": 9,
                        "start_line": 84
                    }
                },
                "300": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.set_public_key"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 30,
                            "offset": 1
                        },
                        "reference_ids": {
                            "__main__.set_public_key.new_public_key": 203,
                            "__main__.set_public_key.pedersen_ptr": 205,
                            "__main__.set_public_key.range_check_ptr": 206,
                            "__main__.set_public_key.syscall_ptr": 204
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 36,
                        "end_line": 85,
                        "input_file": {
                            "filename": "contract.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 36,
                                "end_line": 45,
                                "input_file": {
                                    "filename": "contract.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 23,
                                        "end_line": 88,
                                        "input_file": {
                                            "filename": "contract.cairo"
                                        },
                                        "start_col": 5,
                                        "start_line": 88
                                    },
                                    "While trying to retrieve the implicit argument 'pedersen_ptr' in:"
                                ],
                                "start_col": 9,
                                "start_line": 45
                            },
                            "While expanding the reference 'pedersen_ptr' in:"
                        ],
                        "start_col": 9,
                        "start_line": 85
                    }
                },
                "301": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.set_public_key"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 30,
                            "offset": 2
                        },
                        "reference_ids": {
                            "__main__.set_public_key.new_public_key": 203,
                            "__main__.set_public_key.pedersen_ptr": 205,
                            "__main__.set_public_key.range_check_ptr": 206,
                            "__main__.set_public_key.syscall_ptr": 204
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 24,
                        "end_line": 86,
                        "input_file": {
                            "filename": "contract.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 24,
                                "end_line": 46,
                                "input_file": {
                                    "filename": "contract.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 23,
                                        "end_line": 88,
                                        "input_file": {
                                            "filename": "contract.cairo"
                                        },
                                        "start_col": 5,
                                        "start_line": 88
                                    },
                                    "While trying to retrieve the implicit argument 'range_check_ptr' in:"
                                ],
                                "start_col": 9,
                                "start_line": 46
                            },
                            "While expanding the reference 'range_check_ptr' in:"
                        ],
                        "start_col": 9,
                        "start_line": 86
                    }
                },
                "302": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.set_public_key"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 30,
                            "offset": 3
                        },
                        "reference_ids": {
                            "__main__.set_public_key.new_public_key": 203,
                            "__main__.set_public_key.pedersen_ptr": 205,
                            "__main__.set_public_key.range_check_ptr": 206,
                            "__main__.set_public_key.syscall_ptr": 204
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 23,
                        "end_line": 88,
                        "input_file": {
                            "filename": "contract.cairo"
                        },
                        "start_col": 5,
                        "start_line": 88
                    }
                },
                "304": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.set_public_key"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 30,
                            "offset": 20
                        },
                        "reference_ids": {
                            "__main__.set_public_key.new_public_key": 203,
                            "__main__.set_public_key.pedersen_ptr": 208,
                            "__main__.set_public_key.range_check_ptr": 209,
                            "__main__.set_public_key.syscall_ptr": 207
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 27,
                        "end_line": 87,
                        "input_file": {
                            "filename": "contract.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 36,
                                "end_line": 89,
                                "input_file": {
                                    "filename": "contract.cairo"
                                },
                                "start_col": 22,
                                "start_line": 89
                            },
                            "While expanding the reference 'new_public_key' in:"
                        ],
                        "start_col": 7,
                        "start_line": 87
                    }
                },
                "305": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.set_public_key"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 30,
                            "offset": 21
                        },
                        "reference_ids": {
                            "__main__.set_public_key.new_public_key": 203,
                            "__main__.set_public_key.pedersen_ptr": 208,
                            "__main__.set_public_key.range_check_ptr": 209,
                            "__main__.set_public_key.syscall_ptr": 207
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 37,
                        "end_line": 89,
                        "input_file": {
                            "filename": "contract.cairo"
                        },
                        "start_col": 5,
                        "start_line": 89
                    }
                },
                "307": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.set_public_key"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 30,
                            "offset": 39
                        },
                        "reference_ids": {
                            "__main__.set_public_key.new_public_key": 203,
                            "__main__.set_public_key.pedersen_ptr": 211,
                            "__main__.set_public_key.range_check_ptr": 212,
                            "__main__.set_public_key.syscall_ptr": 210
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 14,
                        "end_line": 90,
                        "input_file": {
                            "filename": "contract.cairo"
                        },
                        "start_col": 5,
                        "start_line": 90
                    }
                },
                "308": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.set_public_key"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 31,
                            "offset": 0
                        },
                        "reference_ids": {
                            "__wrappers__.set_public_key.__calldata_actual_size": 220,
                            "__wrappers__.set_public_key.__calldata_arg_new_public_key": 218,
                            "__wrappers__.set_public_key.__calldata_ptr": 219,
                            "__wrappers__.set_public_key.ecdsa_ptr": 216,
                            "__wrappers__.set_public_key.pedersen_ptr": 214,
                            "__wrappers__.set_public_key.range_check_ptr": 215,
                            "__wrappers__.set_public_key.syscall_ptr": 213
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 40,
                        "end_line": 2,
                        "input_file": {
                            "filename": "autogen/starknet/arg_processor/960ed0835c5fa83e7fde73a3a03f5fd9272c9b63199927c6476a8754ae40c556.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 27,
                                "end_line": 87,
                                "input_file": {
                                    "filename": "contract.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 45,
                                        "end_line": 1,
                                        "input_file": {
                                            "filename": "autogen/starknet/arg_processor/29637b66643568891912d1ed3f5b810e37fc6dff63d2db9fba473c1883482e6f.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 20,
                                                "end_line": 83,
                                                "input_file": {
                                                    "filename": "contract.cairo"
                                                },
                                                "parent_location": [
                                                    {
                                                        "end_col": 44,
                                                        "end_line": 1,
                                                        "input_file": {
                                                            "filename": "autogen/starknet/arg_processor/7f0b238f4e526821a97d8aaa2f9484df4b5bd00cbad10a761ae4225314096a56.cairo"
                                                        },
                                                        "parent_location": [
                                                            {
                                                                "end_col": 20,
                                                                "end_line": 83,
                                                                "input_file": {
                                                                    "filename": "contract.cairo"
                                                                },
                                                                "start_col": 6,
                                                                "start_line": 83
                                                            },
                                                            "While handling calldata of"
                                                        ],
                                                        "start_col": 22,
                                                        "start_line": 1
                                                    },
                                                    "While expanding the reference '__calldata_actual_size' in:"
                                                ],
                                                "start_col": 6,
                                                "start_line": 83
                                            },
                                            "While handling calldata of"
                                        ],
                                        "start_col": 31,
                                        "start_line": 1
                                    },
                                    "While expanding the reference '__calldata_ptr' in:"
                                ],
                                "start_col": 7,
                                "start_line": 87
                            },
                            "While handling calldata argument 'new_public_key'"
                        ],
                        "start_col": 22,
                        "start_line": 2
                    }
                },
                "310": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.set_public_key"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 31,
                            "offset": 1
                        },
                        "reference_ids": {
                            "__wrappers__.set_public_key.__calldata_actual_size": 220,
                            "__wrappers__.set_public_key.__calldata_arg_new_public_key": 218,
                            "__wrappers__.set_public_key.__calldata_ptr": 219,
                            "__wrappers__.set_public_key.__temp13": 221,
                            "__wrappers__.set_public_key.ecdsa_ptr": 216,
                            "__wrappers__.set_public_key.pedersen_ptr": 214,
                            "__wrappers__.set_public_key.range_check_ptr": 215,
                            "__wrappers__.set_public_key.syscall_ptr": 213
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 44,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/arg_processor/7f0b238f4e526821a97d8aaa2f9484df4b5bd00cbad10a761ae4225314096a56.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 20,
                                "end_line": 83,
                                "input_file": {
                                    "filename": "contract.cairo"
                                },
                                "start_col": 6,
                                "start_line": 83
                            },
                            "While handling calldata of"
                        ],
                        "start_col": 1,
                        "start_line": 1
                    }
                },
                "311": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.set_public_key"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 31,
                            "offset": 1
                        },
                        "reference_ids": {
                            "__wrappers__.set_public_key.__calldata_actual_size": 220,
                            "__wrappers__.set_public_key.__calldata_arg_new_public_key": 218,
                            "__wrappers__.set_public_key.__calldata_ptr": 219,
                            "__wrappers__.set_public_key.__temp13": 221,
                            "__wrappers__.set_public_key.ecdsa_ptr": 216,
                            "__wrappers__.set_public_key.pedersen_ptr": 214,
                            "__wrappers__.set_public_key.range_check_ptr": 215,
                            "__wrappers__.set_public_key.syscall_ptr": 213
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 50,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/external/set_public_key/f4a8893cfc7cc4f313b0c426fa25c38c6c57664957bc56a170a27945759c5102.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 28,
                                "end_line": 84,
                                "input_file": {
                                    "filename": "contract.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 56,
                                        "end_line": 1,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/set_public_key/9d99191ee37b2755f349e9328582aaabeba3fa369cacff177a5b80144e6ec2c7.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 20,
                                                "end_line": 83,
                                                "input_file": {
                                                    "filename": "contract.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 83
                                            },
                                            "While constructing the external wrapper for:"
                                        ],
                                        "start_col": 45,
                                        "start_line": 1
                                    },
                                    "While expanding the reference 'syscall_ptr' in:"
                                ],
                                "start_col": 9,
                                "start_line": 84
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 19,
                        "start_line": 1
                    }
                },
                "312": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.set_public_key"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 31,
                            "offset": 2
                        },
                        "reference_ids": {
                            "__wrappers__.set_public_key.__calldata_actual_size": 220,
                            "__wrappers__.set_public_key.__calldata_arg_new_public_key": 218,
                            "__wrappers__.set_public_key.__calldata_ptr": 219,
                            "__wrappers__.set_public_key.__temp13": 221,
                            "__wrappers__.set_public_key.ecdsa_ptr": 216,
                            "__wrappers__.set_public_key.pedersen_ptr": 214,
                            "__wrappers__.set_public_key.range_check_ptr": 215,
                            "__wrappers__.set_public_key.syscall_ptr": 213
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 96,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/external/set_public_key/bf54f65e3c6b81daf1c2b60a8cb4034b53ce30386ebc03b148a9de60d6f5dd57.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 36,
                                "end_line": 85,
                                "input_file": {
                                    "filename": "contract.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 83,
                                        "end_line": 1,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/set_public_key/9d99191ee37b2755f349e9328582aaabeba3fa369cacff177a5b80144e6ec2c7.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 20,
                                                "end_line": 83,
                                                "input_file": {
                                                    "filename": "contract.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 83
                                            },
                                            "While constructing the external wrapper for:"
                                        ],
                                        "start_col": 71,
                                        "start_line": 1
                                    },
                                    "While expanding the reference 'pedersen_ptr' in:"
                                ],
                                "start_col": 9,
                                "start_line": 85
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 20,
                        "start_line": 1
                    }
                },
                "313": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.set_public_key"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 31,
                            "offset": 3
                        },
                        "reference_ids": {
                            "__wrappers__.set_public_key.__calldata_actual_size": 220,
                            "__wrappers__.set_public_key.__calldata_arg_new_public_key": 218,
                            "__wrappers__.set_public_key.__calldata_ptr": 219,
                            "__wrappers__.set_public_key.__temp13": 221,
                            "__wrappers__.set_public_key.ecdsa_ptr": 216,
                            "__wrappers__.set_public_key.pedersen_ptr": 214,
                            "__wrappers__.set_public_key.range_check_ptr": 215,
                            "__wrappers__.set_public_key.syscall_ptr": 213
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 53,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/external/set_public_key/d5f67cc7e69abbde284d945f017319bd8e156adfab63895c8d652f5c3e4f6c3a.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 24,
                                "end_line": 86,
                                "input_file": {
                                    "filename": "contract.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 116,
                                        "end_line": 1,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/set_public_key/9d99191ee37b2755f349e9328582aaabeba3fa369cacff177a5b80144e6ec2c7.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 20,
                                                "end_line": 83,
                                                "input_file": {
                                                    "filename": "contract.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 83
                                            },
                                            "While constructing the external wrapper for:"
                                        ],
                                        "start_col": 101,
                                        "start_line": 1
                                    },
                                    "While expanding the reference 'range_check_ptr' in:"
                                ],
                                "start_col": 9,
                                "start_line": 86
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 23,
                        "start_line": 1
                    }
                },
                "314": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.set_public_key"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 31,
                            "offset": 4
                        },
                        "reference_ids": {
                            "__wrappers__.set_public_key.__calldata_actual_size": 220,
                            "__wrappers__.set_public_key.__calldata_arg_new_public_key": 218,
                            "__wrappers__.set_public_key.__calldata_ptr": 219,
                            "__wrappers__.set_public_key.__temp13": 221,
                            "__wrappers__.set_public_key.ecdsa_ptr": 216,
                            "__wrappers__.set_public_key.pedersen_ptr": 214,
                            "__wrappers__.set_public_key.range_check_ptr": 215,
                            "__wrappers__.set_public_key.syscall_ptr": 213
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 53,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/arg_processor/960ed0835c5fa83e7fde73a3a03f5fd9272c9b63199927c6476a8754ae40c556.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 27,
                                "end_line": 87,
                                "input_file": {
                                    "filename": "contract.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 162,
                                        "end_line": 1,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/set_public_key/9d99191ee37b2755f349e9328582aaabeba3fa369cacff177a5b80144e6ec2c7.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 20,
                                                "end_line": 83,
                                                "input_file": {
                                                    "filename": "contract.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 83
                                            },
                                            "While constructing the external wrapper for:"
                                        ],
                                        "start_col": 133,
                                        "start_line": 1
                                    },
                                    "While expanding the reference '__calldata_arg_new_public_key' in:"
                                ],
                                "start_col": 7,
                                "start_line": 87
                            },
                            "While handling calldata argument 'new_public_key'"
                        ],
                        "start_col": 37,
                        "start_line": 1
                    }
                },
                "315": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.set_public_key"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 31,
                            "offset": 5
                        },
                        "reference_ids": {
                            "__wrappers__.set_public_key.__calldata_actual_size": 220,
                            "__wrappers__.set_public_key.__calldata_arg_new_public_key": 218,
                            "__wrappers__.set_public_key.__calldata_ptr": 219,
                            "__wrappers__.set_public_key.__temp13": 221,
                            "__wrappers__.set_public_key.ecdsa_ptr": 216,
                            "__wrappers__.set_public_key.pedersen_ptr": 214,
                            "__wrappers__.set_public_key.range_check_ptr": 215,
                            "__wrappers__.set_public_key.syscall_ptr": 213
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 20,
                        "end_line": 83,
                        "input_file": {
                            "filename": "contract.cairo"
                        },
                        "start_col": 6,
                        "start_line": 83
                    }
                },
                "317": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.set_public_key"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 31,
                            "offset": 46
                        },
                        "reference_ids": {
                            "__wrappers__.set_public_key.__calldata_actual_size": 220,
                            "__wrappers__.set_public_key.__calldata_arg_new_public_key": 218,
                            "__wrappers__.set_public_key.__calldata_ptr": 219,
                            "__wrappers__.set_public_key.__temp13": 221,
                            "__wrappers__.set_public_key.ecdsa_ptr": 216,
                            "__wrappers__.set_public_key.pedersen_ptr": 223,
                            "__wrappers__.set_public_key.range_check_ptr": 224,
                            "__wrappers__.set_public_key.ret_struct": 225,
                            "__wrappers__.set_public_key.syscall_ptr": 222
                        }
                    },
                    "hints": [
                        {
                            "location": {
                                "end_col": 34,
                                "end_line": 2,
                                "input_file": {
                                    "filename": "autogen/starknet/external/set_public_key/9d99191ee37b2755f349e9328582aaabeba3fa369cacff177a5b80144e6ec2c7.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 20,
                                        "end_line": 83,
                                        "input_file": {
                                            "filename": "contract.cairo"
                                        },
                                        "start_col": 6,
                                        "start_line": 83
                                    },
                                    "While constructing the external wrapper for:"
                                ],
                                "start_col": 1,
                                "start_line": 2
                            },
                            "n_prefix_newlines": 0
                        }
                    ],
                    "inst": {
                        "end_col": 24,
                        "end_line": 3,
                        "input_file": {
                            "filename": "autogen/starknet/external/set_public_key/9d99191ee37b2755f349e9328582aaabeba3fa369cacff177a5b80144e6ec2c7.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 20,
                                "end_line": 83,
                                "input_file": {
                                    "filename": "contract.cairo"
                                },
                                "start_col": 6,
                                "start_line": 83
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 1,
                        "start_line": 3
                    }
                },
                "319": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.set_public_key"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 31,
                            "offset": 47
                        },
                        "reference_ids": {
                            "__wrappers__.set_public_key.__calldata_actual_size": 220,
                            "__wrappers__.set_public_key.__calldata_arg_new_public_key": 218,
                            "__wrappers__.set_public_key.__calldata_ptr": 219,
                            "__wrappers__.set_public_key.__temp13": 221,
                            "__wrappers__.set_public_key.ecdsa_ptr": 216,
                            "__wrappers__.set_public_key.pedersen_ptr": 223,
                            "__wrappers__.set_public_key.range_check_ptr": 224,
                            "__wrappers__.set_public_key.ret_struct": 225,
                            "__wrappers__.set_public_key.retdata": 226,
                            "__wrappers__.set_public_key.retdata_size": 227,
                            "__wrappers__.set_public_key.syscall_ptr": 222
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 56,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/external/set_public_key/9d99191ee37b2755f349e9328582aaabeba3fa369cacff177a5b80144e6ec2c7.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 20,
                                "end_line": 83,
                                "input_file": {
                                    "filename": "contract.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 20,
                                        "end_line": 1,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/set_public_key/aa526043a8db9187624857305b1409f029aec9f9c85f47438b55e65b3afc0639.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 20,
                                                "end_line": 83,
                                                "input_file": {
                                                    "filename": "contract.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 83
                                            },
                                            "While constructing the external wrapper for:"
                                        ],
                                        "start_col": 9,
                                        "start_line": 1
                                    },
                                    "While expanding the reference 'syscall_ptr' in:"
                                ],
                                "start_col": 6,
                                "start_line": 83
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 45,
                        "start_line": 1
                    }
                },
                "320": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.set_public_key"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 31,
                            "offset": 48
                        },
                        "reference_ids": {
                            "__wrappers__.set_public_key.__calldata_actual_size": 220,
                            "__wrappers__.set_public_key.__calldata_arg_new_public_key": 218,
                            "__wrappers__.set_public_key.__calldata_ptr": 219,
                            "__wrappers__.set_public_key.__temp13": 221,
                            "__wrappers__.set_public_key.ecdsa_ptr": 216,
                            "__wrappers__.set_public_key.pedersen_ptr": 223,
                            "__wrappers__.set_public_key.range_check_ptr": 224,
                            "__wrappers__.set_public_key.ret_struct": 225,
                            "__wrappers__.set_public_key.retdata": 226,
                            "__wrappers__.set_public_key.retdata_size": 227,
                            "__wrappers__.set_public_key.syscall_ptr": 222
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 83,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/external/set_public_key/9d99191ee37b2755f349e9328582aaabeba3fa369cacff177a5b80144e6ec2c7.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 20,
                                "end_line": 83,
                                "input_file": {
                                    "filename": "contract.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 33,
                                        "end_line": 1,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/set_public_key/aa526043a8db9187624857305b1409f029aec9f9c85f47438b55e65b3afc0639.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 20,
                                                "end_line": 83,
                                                "input_file": {
                                                    "filename": "contract.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 83
                                            },
                                            "While constructing the external wrapper for:"
                                        ],
                                        "start_col": 21,
                                        "start_line": 1
                                    },
                                    "While expanding the reference 'pedersen_ptr' in:"
                                ],
                                "start_col": 6,
                                "start_line": 83
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 71,
                        "start_line": 1
                    }
                },
                "321": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.set_public_key"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 31,
                            "offset": 49
                        },
                        "reference_ids": {
                            "__wrappers__.set_public_key.__calldata_actual_size": 220,
                            "__wrappers__.set_public_key.__calldata_arg_new_public_key": 218,
                            "__wrappers__.set_public_key.__calldata_ptr": 219,
                            "__wrappers__.set_public_key.__temp13": 221,
                            "__wrappers__.set_public_key.ecdsa_ptr": 216,
                            "__wrappers__.set_public_key.pedersen_ptr": 223,
                            "__wrappers__.set_public_key.range_check_ptr": 224,
                            "__wrappers__.set_public_key.ret_struct": 225,
                            "__wrappers__.set_public_key.retdata": 226,
                            "__wrappers__.set_public_key.retdata_size": 227,
                            "__wrappers__.set_public_key.syscall_ptr": 222
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 116,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/external/set_public_key/9d99191ee37b2755f349e9328582aaabeba3fa369cacff177a5b80144e6ec2c7.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 20,
                                "end_line": 83,
                                "input_file": {
                                    "filename": "contract.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 49,
                                        "end_line": 1,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/set_public_key/aa526043a8db9187624857305b1409f029aec9f9c85f47438b55e65b3afc0639.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 20,
                                                "end_line": 83,
                                                "input_file": {
                                                    "filename": "contract.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 83
                                            },
                                            "While constructing the external wrapper for:"
                                        ],
                                        "start_col": 34,
                                        "start_line": 1
                                    },
                                    "While expanding the reference 'range_check_ptr' in:"
                                ],
                                "start_col": 6,
                                "start_line": 83
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 101,
                        "start_line": 1
                    }
                },
                "322": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.set_public_key"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 31,
                            "offset": 50
                        },
                        "reference_ids": {
                            "__wrappers__.set_public_key.__calldata_actual_size": 220,
                            "__wrappers__.set_public_key.__calldata_arg_new_public_key": 218,
                            "__wrappers__.set_public_key.__calldata_ptr": 219,
                            "__wrappers__.set_public_key.__temp13": 221,
                            "__wrappers__.set_public_key.ecdsa_ptr": 216,
                            "__wrappers__.set_public_key.pedersen_ptr": 223,
                            "__wrappers__.set_public_key.range_check_ptr": 224,
                            "__wrappers__.set_public_key.ret_struct": 225,
                            "__wrappers__.set_public_key.retdata": 226,
                            "__wrappers__.set_public_key.retdata_size": 227,
                            "__wrappers__.set_public_key.syscall_ptr": 222
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 47,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/external/set_public_key/7998f829c4aa5ea19acd9325ec8f13445bd7eb3660e26c1acda6a694c86b221a.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 20,
                                "end_line": 83,
                                "input_file": {
                                    "filename": "contract.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 59,
                                        "end_line": 1,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/set_public_key/aa526043a8db9187624857305b1409f029aec9f9c85f47438b55e65b3afc0639.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 20,
                                                "end_line": 83,
                                                "input_file": {
                                                    "filename": "contract.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 83
                                            },
                                            "While constructing the external wrapper for:"
                                        ],
                                        "start_col": 50,
                                        "start_line": 1
                                    },
                                    "While expanding the reference 'ecdsa_ptr' in:"
                                ],
                                "start_col": 6,
                                "start_line": 83
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 17,
                        "start_line": 1
                    }
                },
                "323": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.set_public_key"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 31,
                            "offset": 51
                        },
                        "reference_ids": {
                            "__wrappers__.set_public_key.__calldata_actual_size": 220,
                            "__wrappers__.set_public_key.__calldata_arg_new_public_key": 218,
                            "__wrappers__.set_public_key.__calldata_ptr": 219,
                            "__wrappers__.set_public_key.__temp13": 221,
                            "__wrappers__.set_public_key.ecdsa_ptr": 216,
                            "__wrappers__.set_public_key.pedersen_ptr": 223,
                            "__wrappers__.set_public_key.range_check_ptr": 224,
                            "__wrappers__.set_public_key.ret_struct": 225,
                            "__wrappers__.set_public_key.retdata": 226,
                            "__wrappers__.set_public_key.retdata_size": 227,
                            "__wrappers__.set_public_key.syscall_ptr": 222
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 21,
                        "end_line": 4,
                        "input_file": {
                            "filename": "autogen/starknet/external/set_public_key/9d99191ee37b2755f349e9328582aaabeba3fa369cacff177a5b80144e6ec2c7.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 20,
                                "end_line": 83,
                                "input_file": {
                                    "filename": "contract.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 72,
                                        "end_line": 1,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/set_public_key/aa526043a8db9187624857305b1409f029aec9f9c85f47438b55e65b3afc0639.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 20,
                                                "end_line": 83,
                                                "input_file": {
                                                    "filename": "contract.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 83
                                            },
                                            "While constructing the external wrapper for:"
                                        ],
                                        "start_col": 60,
                                        "start_line": 1
                                    },
                                    "While expanding the reference 'retdata_size' in:"
                                ],
                                "start_col": 6,
                                "start_line": 83
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 20,
                        "start_line": 4
                    }
                },
                "325": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.set_public_key"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 31,
                            "offset": 52
                        },
                        "reference_ids": {
                            "__wrappers__.set_public_key.__calldata_actual_size": 220,
                            "__wrappers__.set_public_key.__calldata_arg_new_public_key": 218,
                            "__wrappers__.set_public_key.__calldata_ptr": 219,
                            "__wrappers__.set_public_key.__temp13": 221,
                            "__wrappers__.set_public_key.ecdsa_ptr": 216,
                            "__wrappers__.set_public_key.pedersen_ptr": 223,
                            "__wrappers__.set_public_key.range_check_ptr": 224,
                            "__wrappers__.set_public_key.ret_struct": 225,
                            "__wrappers__.set_public_key.retdata": 226,
                            "__wrappers__.set_public_key.retdata_size": 227,
                            "__wrappers__.set_public_key.syscall_ptr": 222
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 16,
                        "end_line": 3,
                        "input_file": {
                            "filename": "autogen/starknet/external/set_public_key/9d99191ee37b2755f349e9328582aaabeba3fa369cacff177a5b80144e6ec2c7.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 20,
                                "end_line": 83,
                                "input_file": {
                                    "filename": "contract.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 80,
                                        "end_line": 1,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/set_public_key/aa526043a8db9187624857305b1409f029aec9f9c85f47438b55e65b3afc0639.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 20,
                                                "end_line": 83,
                                                "input_file": {
                                                    "filename": "contract.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 83
                                            },
                                            "While constructing the external wrapper for:"
                                        ],
                                        "start_col": 73,
                                        "start_line": 1
                                    },
                                    "While expanding the reference 'retdata' in:"
                                ],
                                "start_col": 6,
                                "start_line": 83
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 9,
                        "start_line": 3
                    }
                },
                "326": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.set_public_key"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 31,
                            "offset": 53
                        },
                        "reference_ids": {
                            "__wrappers__.set_public_key.__calldata_actual_size": 220,
                            "__wrappers__.set_public_key.__calldata_arg_new_public_key": 218,
                            "__wrappers__.set_public_key.__calldata_ptr": 219,
                            "__wrappers__.set_public_key.__temp13": 221,
                            "__wrappers__.set_public_key.ecdsa_ptr": 216,
                            "__wrappers__.set_public_key.pedersen_ptr": 223,
                            "__wrappers__.set_public_key.range_check_ptr": 224,
                            "__wrappers__.set_public_key.ret_struct": 225,
                            "__wrappers__.set_public_key.retdata": 226,
                            "__wrappers__.set_public_key.retdata_size": 227,
                            "__wrappers__.set_public_key.syscall_ptr": 222
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 81,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/external/set_public_key/aa526043a8db9187624857305b1409f029aec9f9c85f47438b55e65b3afc0639.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 20,
                                "end_line": 83,
                                "input_file": {
                                    "filename": "contract.cairo"
                                },
                                "start_col": 6,
                                "start_line": 83
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 1,
                        "start_line": 1
                    }
                },
                "327": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.constructor"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 32,
                            "offset": 0
                        },
                        "reference_ids": {
                            "__main__.constructor._public_key": 228,
                            "__main__.constructor.pedersen_ptr": 230,
                            "__main__.constructor.range_check_ptr": 231,
                            "__main__.constructor.syscall_ptr": 229
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 28,
                        "end_line": 99,
                        "input_file": {
                            "filename": "contract.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 35,
                                "end_line": 19,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/public_key/decl.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 34,
                                        "end_line": 103,
                                        "input_file": {
                                            "filename": "contract.cairo"
                                        },
                                        "start_col": 5,
                                        "start_line": 103
                                    },
                                    "While trying to retrieve the implicit argument 'syscall_ptr' in:"
                                ],
                                "start_col": 16,
                                "start_line": 19
                            },
                            "While expanding the reference 'syscall_ptr' in:"
                        ],
                        "start_col": 9,
                        "start_line": 99
                    }
                },
                "328": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.constructor"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 32,
                            "offset": 1
                        },
                        "reference_ids": {
                            "__main__.constructor._public_key": 228,
                            "__main__.constructor.pedersen_ptr": 230,
                            "__main__.constructor.range_check_ptr": 231,
                            "__main__.constructor.syscall_ptr": 229
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 36,
                        "end_line": 100,
                        "input_file": {
                            "filename": "contract.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 64,
                                "end_line": 19,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/public_key/decl.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 34,
                                        "end_line": 103,
                                        "input_file": {
                                            "filename": "contract.cairo"
                                        },
                                        "start_col": 5,
                                        "start_line": 103
                                    },
                                    "While trying to retrieve the implicit argument 'pedersen_ptr' in:"
                                ],
                                "start_col": 37,
                                "start_line": 19
                            },
                            "While expanding the reference 'pedersen_ptr' in:"
                        ],
                        "start_col": 9,
                        "start_line": 100
                    }
                },
                "329": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.constructor"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 32,
                            "offset": 2
                        },
                        "reference_ids": {
                            "__main__.constructor._public_key": 228,
                            "__main__.constructor.pedersen_ptr": 230,
                            "__main__.constructor.range_check_ptr": 231,
                            "__main__.constructor.syscall_ptr": 229
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 24,
                        "end_line": 101,
                        "input_file": {
                            "filename": "contract.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 81,
                                "end_line": 19,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/public_key/decl.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 34,
                                        "end_line": 103,
                                        "input_file": {
                                            "filename": "contract.cairo"
                                        },
                                        "start_col": 5,
                                        "start_line": 103
                                    },
                                    "While trying to retrieve the implicit argument 'range_check_ptr' in:"
                                ],
                                "start_col": 66,
                                "start_line": 19
                            },
                            "While expanding the reference 'range_check_ptr' in:"
                        ],
                        "start_col": 9,
                        "start_line": 101
                    }
                },
                "330": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.constructor"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 32,
                            "offset": 3
                        },
                        "reference_ids": {
                            "__main__.constructor._public_key": 228,
                            "__main__.constructor.pedersen_ptr": 230,
                            "__main__.constructor.range_check_ptr": 231,
                            "__main__.constructor.syscall_ptr": 229
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 24,
                        "end_line": 102,
                        "input_file": {
                            "filename": "contract.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 33,
                                "end_line": 103,
                                "input_file": {
                                    "filename": "contract.cairo"
                                },
                                "start_col": 22,
                                "start_line": 103
                            },
                            "While expanding the reference '_public_key' in:"
                        ],
                        "start_col": 7,
                        "start_line": 102
                    }
                },
                "331": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.constructor"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 32,
                            "offset": 4
                        },
                        "reference_ids": {
                            "__main__.constructor._public_key": 228,
                            "__main__.constructor.pedersen_ptr": 230,
                            "__main__.constructor.range_check_ptr": 231,
                            "__main__.constructor.syscall_ptr": 229
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 34,
                        "end_line": 103,
                        "input_file": {
                            "filename": "contract.cairo"
                        },
                        "start_col": 5,
                        "start_line": 103
                    }
                },
                "333": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.constructor"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 32,
                            "offset": 22
                        },
                        "reference_ids": {
                            "__main__.constructor._public_key": 228,
                            "__main__.constructor.pedersen_ptr": 233,
                            "__main__.constructor.range_check_ptr": 234,
                            "__main__.constructor.syscall_ptr": 232
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 13,
                        "end_line": 104,
                        "input_file": {
                            "filename": "contract.cairo"
                        },
                        "start_col": 5,
                        "start_line": 104
                    }
                },
                "334": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.constructor"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 33,
                            "offset": 0
                        },
                        "reference_ids": {
                            "__wrappers__.constructor.__calldata_actual_size": 242,
                            "__wrappers__.constructor.__calldata_arg__public_key": 240,
                            "__wrappers__.constructor.__calldata_ptr": 241,
                            "__wrappers__.constructor.ecdsa_ptr": 238,
                            "__wrappers__.constructor.pedersen_ptr": 236,
                            "__wrappers__.constructor.range_check_ptr": 237,
                            "__wrappers__.constructor.syscall_ptr": 235
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 40,
                        "end_line": 2,
                        "input_file": {
                            "filename": "autogen/starknet/arg_processor/623ade4063ac6181a8cdf88ec6604929c149e47a08a1b21b110c028785e3e605.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 24,
                                "end_line": 102,
                                "input_file": {
                                    "filename": "contract.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 45,
                                        "end_line": 1,
                                        "input_file": {
                                            "filename": "autogen/starknet/arg_processor/29637b66643568891912d1ed3f5b810e37fc6dff63d2db9fba473c1883482e6f.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 17,
                                                "end_line": 98,
                                                "input_file": {
                                                    "filename": "contract.cairo"
                                                },
                                                "parent_location": [
                                                    {
                                                        "end_col": 44,
                                                        "end_line": 1,
                                                        "input_file": {
                                                            "filename": "autogen/starknet/arg_processor/7f0b238f4e526821a97d8aaa2f9484df4b5bd00cbad10a761ae4225314096a56.cairo"
                                                        },
                                                        "parent_location": [
                                                            {
                                                                "end_col": 17,
                                                                "end_line": 98,
                                                                "input_file": {
                                                                    "filename": "contract.cairo"
                                                                },
                                                                "start_col": 6,
                                                                "start_line": 98
                                                            },
                                                            "While handling calldata of"
                                                        ],
                                                        "start_col": 22,
                                                        "start_line": 1
                                                    },
                                                    "While expanding the reference '__calldata_actual_size' in:"
                                                ],
                                                "start_col": 6,
                                                "start_line": 98
                                            },
                                            "While handling calldata of"
                                        ],
                                        "start_col": 31,
                                        "start_line": 1
                                    },
                                    "While expanding the reference '__calldata_ptr' in:"
                                ],
                                "start_col": 7,
                                "start_line": 102
                            },
                            "While handling calldata argument '_public_key'"
                        ],
                        "start_col": 22,
                        "start_line": 2
                    }
                },
                "336": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.constructor"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 33,
                            "offset": 1
                        },
                        "reference_ids": {
                            "__wrappers__.constructor.__calldata_actual_size": 242,
                            "__wrappers__.constructor.__calldata_arg__public_key": 240,
                            "__wrappers__.constructor.__calldata_ptr": 241,
                            "__wrappers__.constructor.__temp14": 243,
                            "__wrappers__.constructor.ecdsa_ptr": 238,
                            "__wrappers__.constructor.pedersen_ptr": 236,
                            "__wrappers__.constructor.range_check_ptr": 237,
                            "__wrappers__.constructor.syscall_ptr": 235
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 44,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/arg_processor/7f0b238f4e526821a97d8aaa2f9484df4b5bd00cbad10a761ae4225314096a56.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 17,
                                "end_line": 98,
                                "input_file": {
                                    "filename": "contract.cairo"
                                },
                                "start_col": 6,
                                "start_line": 98
                            },
                            "While handling calldata of"
                        ],
                        "start_col": 1,
                        "start_line": 1
                    }
                },
                "337": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.constructor"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 33,
                            "offset": 1
                        },
                        "reference_ids": {
                            "__wrappers__.constructor.__calldata_actual_size": 242,
                            "__wrappers__.constructor.__calldata_arg__public_key": 240,
                            "__wrappers__.constructor.__calldata_ptr": 241,
                            "__wrappers__.constructor.__temp14": 243,
                            "__wrappers__.constructor.ecdsa_ptr": 238,
                            "__wrappers__.constructor.pedersen_ptr": 236,
                            "__wrappers__.constructor.range_check_ptr": 237,
                            "__wrappers__.constructor.syscall_ptr": 235
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 50,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/external/constructor/f4a8893cfc7cc4f313b0c426fa25c38c6c57664957bc56a170a27945759c5102.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 28,
                                "end_line": 99,
                                "input_file": {
                                    "filename": "contract.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 56,
                                        "end_line": 1,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/constructor/65962fce79fda3ae5aa5ff0f8d357fdb1de976f3ac253367909c1e8ffb6ad335.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 17,
                                                "end_line": 98,
                                                "input_file": {
                                                    "filename": "contract.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 98
                                            },
                                            "While constructing the external wrapper for:"
                                        ],
                                        "start_col": 45,
                                        "start_line": 1
                                    },
                                    "While expanding the reference 'syscall_ptr' in:"
                                ],
                                "start_col": 9,
                                "start_line": 99
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 19,
                        "start_line": 1
                    }
                },
                "338": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.constructor"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 33,
                            "offset": 2
                        },
                        "reference_ids": {
                            "__wrappers__.constructor.__calldata_actual_size": 242,
                            "__wrappers__.constructor.__calldata_arg__public_key": 240,
                            "__wrappers__.constructor.__calldata_ptr": 241,
                            "__wrappers__.constructor.__temp14": 243,
                            "__wrappers__.constructor.ecdsa_ptr": 238,
                            "__wrappers__.constructor.pedersen_ptr": 236,
                            "__wrappers__.constructor.range_check_ptr": 237,
                            "__wrappers__.constructor.syscall_ptr": 235
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 96,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/external/constructor/bf54f65e3c6b81daf1c2b60a8cb4034b53ce30386ebc03b148a9de60d6f5dd57.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 36,
                                "end_line": 100,
                                "input_file": {
                                    "filename": "contract.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 83,
                                        "end_line": 1,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/constructor/65962fce79fda3ae5aa5ff0f8d357fdb1de976f3ac253367909c1e8ffb6ad335.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 17,
                                                "end_line": 98,
                                                "input_file": {
                                                    "filename": "contract.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 98
                                            },
                                            "While constructing the external wrapper for:"
                                        ],
                                        "start_col": 71,
                                        "start_line": 1
                                    },
                                    "While expanding the reference 'pedersen_ptr' in:"
                                ],
                                "start_col": 9,
                                "start_line": 100
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 20,
                        "start_line": 1
                    }
                },
                "339": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.constructor"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 33,
                            "offset": 3
                        },
                        "reference_ids": {
                            "__wrappers__.constructor.__calldata_actual_size": 242,
                            "__wrappers__.constructor.__calldata_arg__public_key": 240,
                            "__wrappers__.constructor.__calldata_ptr": 241,
                            "__wrappers__.constructor.__temp14": 243,
                            "__wrappers__.constructor.ecdsa_ptr": 238,
                            "__wrappers__.constructor.pedersen_ptr": 236,
                            "__wrappers__.constructor.range_check_ptr": 237,
                            "__wrappers__.constructor.syscall_ptr": 235
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 53,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/external/constructor/d5f67cc7e69abbde284d945f017319bd8e156adfab63895c8d652f5c3e4f6c3a.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 24,
                                "end_line": 101,
                                "input_file": {
                                    "filename": "contract.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 116,
                                        "end_line": 1,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/constructor/65962fce79fda3ae5aa5ff0f8d357fdb1de976f3ac253367909c1e8ffb6ad335.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 17,
                                                "end_line": 98,
                                                "input_file": {
                                                    "filename": "contract.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 98
                                            },
                                            "While constructing the external wrapper for:"
                                        ],
                                        "start_col": 101,
                                        "start_line": 1
                                    },
                                    "While expanding the reference 'range_check_ptr' in:"
                                ],
                                "start_col": 9,
                                "start_line": 101
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 23,
                        "start_line": 1
                    }
                },
                "340": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.constructor"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 33,
                            "offset": 4
                        },
                        "reference_ids": {
                            "__wrappers__.constructor.__calldata_actual_size": 242,
                            "__wrappers__.constructor.__calldata_arg__public_key": 240,
                            "__wrappers__.constructor.__calldata_ptr": 241,
                            "__wrappers__.constructor.__temp14": 243,
                            "__wrappers__.constructor.ecdsa_ptr": 238,
                            "__wrappers__.constructor.pedersen_ptr": 236,
                            "__wrappers__.constructor.range_check_ptr": 237,
                            "__wrappers__.constructor.syscall_ptr": 235
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 50,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/arg_processor/623ade4063ac6181a8cdf88ec6604929c149e47a08a1b21b110c028785e3e605.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 24,
                                "end_line": 102,
                                "input_file": {
                                    "filename": "contract.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 156,
                                        "end_line": 1,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/constructor/65962fce79fda3ae5aa5ff0f8d357fdb1de976f3ac253367909c1e8ffb6ad335.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 17,
                                                "end_line": 98,
                                                "input_file": {
                                                    "filename": "contract.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 98
                                            },
                                            "While constructing the external wrapper for:"
                                        ],
                                        "start_col": 130,
                                        "start_line": 1
                                    },
                                    "While expanding the reference '__calldata_arg__public_key' in:"
                                ],
                                "start_col": 7,
                                "start_line": 102
                            },
                            "While handling calldata argument '_public_key'"
                        ],
                        "start_col": 34,
                        "start_line": 1
                    }
                },
                "341": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.constructor"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 33,
                            "offset": 5
                        },
                        "reference_ids": {
                            "__wrappers__.constructor.__calldata_actual_size": 242,
                            "__wrappers__.constructor.__calldata_arg__public_key": 240,
                            "__wrappers__.constructor.__calldata_ptr": 241,
                            "__wrappers__.constructor.__temp14": 243,
                            "__wrappers__.constructor.ecdsa_ptr": 238,
                            "__wrappers__.constructor.pedersen_ptr": 236,
                            "__wrappers__.constructor.range_check_ptr": 237,
                            "__wrappers__.constructor.syscall_ptr": 235
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 17,
                        "end_line": 98,
                        "input_file": {
                            "filename": "contract.cairo"
                        },
                        "start_col": 6,
                        "start_line": 98
                    }
                },
                "343": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.constructor"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 33,
                            "offset": 29
                        },
                        "reference_ids": {
                            "__wrappers__.constructor.__calldata_actual_size": 242,
                            "__wrappers__.constructor.__calldata_arg__public_key": 240,
                            "__wrappers__.constructor.__calldata_ptr": 241,
                            "__wrappers__.constructor.__temp14": 243,
                            "__wrappers__.constructor.ecdsa_ptr": 238,
                            "__wrappers__.constructor.pedersen_ptr": 245,
                            "__wrappers__.constructor.range_check_ptr": 246,
                            "__wrappers__.constructor.ret_struct": 247,
                            "__wrappers__.constructor.syscall_ptr": 244
                        }
                    },
                    "hints": [
                        {
                            "location": {
                                "end_col": 34,
                                "end_line": 2,
                                "input_file": {
                                    "filename": "autogen/starknet/external/constructor/65962fce79fda3ae5aa5ff0f8d357fdb1de976f3ac253367909c1e8ffb6ad335.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 17,
                                        "end_line": 98,
                                        "input_file": {
                                            "filename": "contract.cairo"
                                        },
                                        "start_col": 6,
                                        "start_line": 98
                                    },
                                    "While constructing the external wrapper for:"
                                ],
                                "start_col": 1,
                                "start_line": 2
                            },
                            "n_prefix_newlines": 0
                        }
                    ],
                    "inst": {
                        "end_col": 24,
                        "end_line": 3,
                        "input_file": {
                            "filename": "autogen/starknet/external/constructor/65962fce79fda3ae5aa5ff0f8d357fdb1de976f3ac253367909c1e8ffb6ad335.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 17,
                                "end_line": 98,
                                "input_file": {
                                    "filename": "contract.cairo"
                                },
                                "start_col": 6,
                                "start_line": 98
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 1,
                        "start_line": 3
                    }
                },
                "345": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.constructor"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 33,
                            "offset": 30
                        },
                        "reference_ids": {
                            "__wrappers__.constructor.__calldata_actual_size": 242,
                            "__wrappers__.constructor.__calldata_arg__public_key": 240,
                            "__wrappers__.constructor.__calldata_ptr": 241,
                            "__wrappers__.constructor.__temp14": 243,
                            "__wrappers__.constructor.ecdsa_ptr": 238,
                            "__wrappers__.constructor.pedersen_ptr": 245,
                            "__wrappers__.constructor.range_check_ptr": 246,
                            "__wrappers__.constructor.ret_struct": 247,
                            "__wrappers__.constructor.retdata": 248,
                            "__wrappers__.constructor.retdata_size": 249,
                            "__wrappers__.constructor.syscall_ptr": 244
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 56,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/external/constructor/65962fce79fda3ae5aa5ff0f8d357fdb1de976f3ac253367909c1e8ffb6ad335.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 17,
                                "end_line": 98,
                                "input_file": {
                                    "filename": "contract.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 20,
                                        "end_line": 1,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/constructor/aa526043a8db9187624857305b1409f029aec9f9c85f47438b55e65b3afc0639.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 17,
                                                "end_line": 98,
                                                "input_file": {
                                                    "filename": "contract.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 98
                                            },
                                            "While constructing the external wrapper for:"
                                        ],
                                        "start_col": 9,
                                        "start_line": 1
                                    },
                                    "While expanding the reference 'syscall_ptr' in:"
                                ],
                                "start_col": 6,
                                "start_line": 98
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 45,
                        "start_line": 1
                    }
                },
                "346": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.constructor"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 33,
                            "offset": 31
                        },
                        "reference_ids": {
                            "__wrappers__.constructor.__calldata_actual_size": 242,
                            "__wrappers__.constructor.__calldata_arg__public_key": 240,
                            "__wrappers__.constructor.__calldata_ptr": 241,
                            "__wrappers__.constructor.__temp14": 243,
                            "__wrappers__.constructor.ecdsa_ptr": 238,
                            "__wrappers__.constructor.pedersen_ptr": 245,
                            "__wrappers__.constructor.range_check_ptr": 246,
                            "__wrappers__.constructor.ret_struct": 247,
                            "__wrappers__.constructor.retdata": 248,
                            "__wrappers__.constructor.retdata_size": 249,
                            "__wrappers__.constructor.syscall_ptr": 244
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 83,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/external/constructor/65962fce79fda3ae5aa5ff0f8d357fdb1de976f3ac253367909c1e8ffb6ad335.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 17,
                                "end_line": 98,
                                "input_file": {
                                    "filename": "contract.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 33,
                                        "end_line": 1,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/constructor/aa526043a8db9187624857305b1409f029aec9f9c85f47438b55e65b3afc0639.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 17,
                                                "end_line": 98,
                                                "input_file": {
                                                    "filename": "contract.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 98
                                            },
                                            "While constructing the external wrapper for:"
                                        ],
                                        "start_col": 21,
                                        "start_line": 1
                                    },
                                    "While expanding the reference 'pedersen_ptr' in:"
                                ],
                                "start_col": 6,
                                "start_line": 98
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 71,
                        "start_line": 1
                    }
                },
                "347": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.constructor"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 33,
                            "offset": 32
                        },
                        "reference_ids": {
                            "__wrappers__.constructor.__calldata_actual_size": 242,
                            "__wrappers__.constructor.__calldata_arg__public_key": 240,
                            "__wrappers__.constructor.__calldata_ptr": 241,
                            "__wrappers__.constructor.__temp14": 243,
                            "__wrappers__.constructor.ecdsa_ptr": 238,
                            "__wrappers__.constructor.pedersen_ptr": 245,
                            "__wrappers__.constructor.range_check_ptr": 246,
                            "__wrappers__.constructor.ret_struct": 247,
                            "__wrappers__.constructor.retdata": 248,
                            "__wrappers__.constructor.retdata_size": 249,
                            "__wrappers__.constructor.syscall_ptr": 244
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 116,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/external/constructor/65962fce79fda3ae5aa5ff0f8d357fdb1de976f3ac253367909c1e8ffb6ad335.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 17,
                                "end_line": 98,
                                "input_file": {
                                    "filename": "contract.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 49,
                                        "end_line": 1,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/constructor/aa526043a8db9187624857305b1409f029aec9f9c85f47438b55e65b3afc0639.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 17,
                                                "end_line": 98,
                                                "input_file": {
                                                    "filename": "contract.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 98
                                            },
                                            "While constructing the external wrapper for:"
                                        ],
                                        "start_col": 34,
                                        "start_line": 1
                                    },
                                    "While expanding the reference 'range_check_ptr' in:"
                                ],
                                "start_col": 6,
                                "start_line": 98
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 101,
                        "start_line": 1
                    }
                },
                "348": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.constructor"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 33,
                            "offset": 33
                        },
                        "reference_ids": {
                            "__wrappers__.constructor.__calldata_actual_size": 242,
                            "__wrappers__.constructor.__calldata_arg__public_key": 240,
                            "__wrappers__.constructor.__calldata_ptr": 241,
                            "__wrappers__.constructor.__temp14": 243,
                            "__wrappers__.constructor.ecdsa_ptr": 238,
                            "__wrappers__.constructor.pedersen_ptr": 245,
                            "__wrappers__.constructor.range_check_ptr": 246,
                            "__wrappers__.constructor.ret_struct": 247,
                            "__wrappers__.constructor.retdata": 248,
                            "__wrappers__.constructor.retdata_size": 249,
                            "__wrappers__.constructor.syscall_ptr": 244
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 47,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/external/constructor/7998f829c4aa5ea19acd9325ec8f13445bd7eb3660e26c1acda6a694c86b221a.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 17,
                                "end_line": 98,
                                "input_file": {
                                    "filename": "contract.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 59,
                                        "end_line": 1,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/constructor/aa526043a8db9187624857305b1409f029aec9f9c85f47438b55e65b3afc0639.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 17,
                                                "end_line": 98,
                                                "input_file": {
                                                    "filename": "contract.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 98
                                            },
                                            "While constructing the external wrapper for:"
                                        ],
                                        "start_col": 50,
                                        "start_line": 1
                                    },
                                    "While expanding the reference 'ecdsa_ptr' in:"
                                ],
                                "start_col": 6,
                                "start_line": 98
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 17,
                        "start_line": 1
                    }
                },
                "349": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.constructor"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 33,
                            "offset": 34
                        },
                        "reference_ids": {
                            "__wrappers__.constructor.__calldata_actual_size": 242,
                            "__wrappers__.constructor.__calldata_arg__public_key": 240,
                            "__wrappers__.constructor.__calldata_ptr": 241,
                            "__wrappers__.constructor.__temp14": 243,
                            "__wrappers__.constructor.ecdsa_ptr": 238,
                            "__wrappers__.constructor.pedersen_ptr": 245,
                            "__wrappers__.constructor.range_check_ptr": 246,
                            "__wrappers__.constructor.ret_struct": 247,
                            "__wrappers__.constructor.retdata": 248,
                            "__wrappers__.constructor.retdata_size": 249,
                            "__wrappers__.constructor.syscall_ptr": 244
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 21,
                        "end_line": 4,
                        "input_file": {
                            "filename": "autogen/starknet/external/constructor/65962fce79fda3ae5aa5ff0f8d357fdb1de976f3ac253367909c1e8ffb6ad335.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 17,
                                "end_line": 98,
                                "input_file": {
                                    "filename": "contract.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 72,
                                        "end_line": 1,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/constructor/aa526043a8db9187624857305b1409f029aec9f9c85f47438b55e65b3afc0639.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 17,
                                                "end_line": 98,
                                                "input_file": {
                                                    "filename": "contract.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 98
                                            },
                                            "While constructing the external wrapper for:"
                                        ],
                                        "start_col": 60,
                                        "start_line": 1
                                    },
                                    "While expanding the reference 'retdata_size' in:"
                                ],
                                "start_col": 6,
                                "start_line": 98
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 20,
                        "start_line": 4
                    }
                },
                "351": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.constructor"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 33,
                            "offset": 35
                        },
                        "reference_ids": {
                            "__wrappers__.constructor.__calldata_actual_size": 242,
                            "__wrappers__.constructor.__calldata_arg__public_key": 240,
                            "__wrappers__.constructor.__calldata_ptr": 241,
                            "__wrappers__.constructor.__temp14": 243,
                            "__wrappers__.constructor.ecdsa_ptr": 238,
                            "__wrappers__.constructor.pedersen_ptr": 245,
                            "__wrappers__.constructor.range_check_ptr": 246,
                            "__wrappers__.constructor.ret_struct": 247,
                            "__wrappers__.constructor.retdata": 248,
                            "__wrappers__.constructor.retdata_size": 249,
                            "__wrappers__.constructor.syscall_ptr": 244
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 16,
                        "end_line": 3,
                        "input_file": {
                            "filename": "autogen/starknet/external/constructor/65962fce79fda3ae5aa5ff0f8d357fdb1de976f3ac253367909c1e8ffb6ad335.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 17,
                                "end_line": 98,
                                "input_file": {
                                    "filename": "contract.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 80,
                                        "end_line": 1,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/constructor/aa526043a8db9187624857305b1409f029aec9f9c85f47438b55e65b3afc0639.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 17,
                                                "end_line": 98,
                                                "input_file": {
                                                    "filename": "contract.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 98
                                            },
                                            "While constructing the external wrapper for:"
                                        ],
                                        "start_col": 73,
                                        "start_line": 1
                                    },
                                    "While expanding the reference 'retdata' in:"
                                ],
                                "start_col": 6,
                                "start_line": 98
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 9,
                        "start_line": 3
                    }
                },
                "352": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.constructor"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 33,
                            "offset": 36
                        },
                        "reference_ids": {
                            "__wrappers__.constructor.__calldata_actual_size": 242,
                            "__wrappers__.constructor.__calldata_arg__public_key": 240,
                            "__wrappers__.constructor.__calldata_ptr": 241,
                            "__wrappers__.constructor.__temp14": 243,
                            "__wrappers__.constructor.ecdsa_ptr": 238,
                            "__wrappers__.constructor.pedersen_ptr": 245,
                            "__wrappers__.constructor.range_check_ptr": 246,
                            "__wrappers__.constructor.ret_struct": 247,
                            "__wrappers__.constructor.retdata": 248,
                            "__wrappers__.constructor.retdata_size": 249,
                            "__wrappers__.constructor.syscall_ptr": 244
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 81,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/external/constructor/aa526043a8db9187624857305b1409f029aec9f9c85f47438b55e65b3afc0639.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 17,
                                "end_line": 98,
                                "input_file": {
                                    "filename": "contract.cairo"
                                },
                                "start_col": 6,
                                "start_line": 98
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 1,
                        "start_line": 1
                    }
                },
                "353": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.is_valid_signature"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 34,
                            "offset": 0
                        },
                        "reference_ids": {
                            "__main__.is_valid_signature.ecdsa_ptr": 256,
                            "__main__.is_valid_signature.hash": 250,
                            "__main__.is_valid_signature.pedersen_ptr": 254,
                            "__main__.is_valid_signature.range_check_ptr": 255,
                            "__main__.is_valid_signature.signature": 252,
                            "__main__.is_valid_signature.signature_len": 251,
                            "__main__.is_valid_signature.syscall_ptr": 253
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 28,
                        "end_line": 113,
                        "input_file": {
                            "filename": "contract.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 34,
                                "end_line": 13,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/public_key/decl.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 42,
                                        "end_line": 122,
                                        "input_file": {
                                            "filename": "contract.cairo"
                                        },
                                        "start_col": 25,
                                        "start_line": 122
                                    },
                                    "While trying to retrieve the implicit argument 'syscall_ptr' in:"
                                ],
                                "start_col": 15,
                                "start_line": 13
                            },
                            "While expanding the reference 'syscall_ptr' in:"
                        ],
                        "start_col": 9,
                        "start_line": 113
                    }
                },
                "354": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.is_valid_signature"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 34,
                            "offset": 1
                        },
                        "reference_ids": {
                            "__main__.is_valid_signature.ecdsa_ptr": 256,
                            "__main__.is_valid_signature.hash": 250,
                            "__main__.is_valid_signature.pedersen_ptr": 254,
                            "__main__.is_valid_signature.range_check_ptr": 255,
                            "__main__.is_valid_signature.signature": 252,
                            "__main__.is_valid_signature.signature_len": 251,
                            "__main__.is_valid_signature.syscall_ptr": 253
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 36,
                        "end_line": 114,
                        "input_file": {
                            "filename": "contract.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 63,
                                "end_line": 13,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/public_key/decl.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 42,
                                        "end_line": 122,
                                        "input_file": {
                                            "filename": "contract.cairo"
                                        },
                                        "start_col": 25,
                                        "start_line": 122
                                    },
                                    "While trying to retrieve the implicit argument 'pedersen_ptr' in:"
                                ],
                                "start_col": 36,
                                "start_line": 13
                            },
                            "While expanding the reference 'pedersen_ptr' in:"
                        ],
                        "start_col": 9,
                        "start_line": 114
                    }
                },
                "355": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.is_valid_signature"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 34,
                            "offset": 2
                        },
                        "reference_ids": {
                            "__main__.is_valid_signature.ecdsa_ptr": 256,
                            "__main__.is_valid_signature.hash": 250,
                            "__main__.is_valid_signature.pedersen_ptr": 254,
                            "__main__.is_valid_signature.range_check_ptr": 255,
                            "__main__.is_valid_signature.signature": 252,
                            "__main__.is_valid_signature.signature_len": 251,
                            "__main__.is_valid_signature.syscall_ptr": 253
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 24,
                        "end_line": 115,
                        "input_file": {
                            "filename": "contract.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 80,
                                "end_line": 13,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/public_key/decl.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 42,
                                        "end_line": 122,
                                        "input_file": {
                                            "filename": "contract.cairo"
                                        },
                                        "start_col": 25,
                                        "start_line": 122
                                    },
                                    "While trying to retrieve the implicit argument 'range_check_ptr' in:"
                                ],
                                "start_col": 65,
                                "start_line": 13
                            },
                            "While expanding the reference 'range_check_ptr' in:"
                        ],
                        "start_col": 9,
                        "start_line": 115
                    }
                },
                "356": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.is_valid_signature"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 34,
                            "offset": 3
                        },
                        "reference_ids": {
                            "__main__.is_valid_signature.ecdsa_ptr": 256,
                            "__main__.is_valid_signature.hash": 250,
                            "__main__.is_valid_signature.pedersen_ptr": 254,
                            "__main__.is_valid_signature.range_check_ptr": 255,
                            "__main__.is_valid_signature.signature": 252,
                            "__main__.is_valid_signature.signature_len": 251,
                            "__main__.is_valid_signature.syscall_ptr": 253
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 42,
                        "end_line": 122,
                        "input_file": {
                            "filename": "contract.cairo"
                        },
                        "start_col": 25,
                        "start_line": 122
                    }
                },
                "358": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.is_valid_signature"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 34,
                            "offset": 23
                        },
                        "reference_ids": {
                            "__main__.is_valid_signature._public_key": 260,
                            "__main__.is_valid_signature.ecdsa_ptr": 256,
                            "__main__.is_valid_signature.hash": 250,
                            "__main__.is_valid_signature.pedersen_ptr": 258,
                            "__main__.is_valid_signature.range_check_ptr": 259,
                            "__main__.is_valid_signature.sig_r": 261,
                            "__main__.is_valid_signature.sig_s": 262,
                            "__main__.is_valid_signature.signature": 252,
                            "__main__.is_valid_signature.signature_len": 251,
                            "__main__.is_valid_signature.syscall_ptr": 257
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 37,
                        "end_line": 116,
                        "input_file": {
                            "filename": "contract.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 58,
                                "end_line": 7,
                                "input_file": {
                                    "filename": "/Users/jakubptak/Library/Caches/pypoetry/virtualenvs/starkware-python-sdk-L_CLq0Mm-py3.7/lib/python3.7/site-packages/starkware/cairo/common/signature.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 27,
                                        "end_line": 134,
                                        "input_file": {
                                            "filename": "contract.cairo"
                                        },
                                        "start_col": 5,
                                        "start_line": 130
                                    },
                                    "While trying to retrieve the implicit argument 'ecdsa_ptr' in:"
                                ],
                                "start_col": 29,
                                "start_line": 7
                            },
                            "While expanding the reference 'ecdsa_ptr' in:"
                        ],
                        "start_col": 9,
                        "start_line": 116
                    }
                },
                "359": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.is_valid_signature"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 34,
                            "offset": 24
                        },
                        "reference_ids": {
                            "__main__.is_valid_signature._public_key": 260,
                            "__main__.is_valid_signature.ecdsa_ptr": 256,
                            "__main__.is_valid_signature.hash": 250,
                            "__main__.is_valid_signature.pedersen_ptr": 258,
                            "__main__.is_valid_signature.range_check_ptr": 259,
                            "__main__.is_valid_signature.sig_r": 261,
                            "__main__.is_valid_signature.sig_s": 262,
                            "__main__.is_valid_signature.signature": 252,
                            "__main__.is_valid_signature.signature_len": 251,
                            "__main__.is_valid_signature.syscall_ptr": 257
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 19,
                        "end_line": 118,
                        "input_file": {
                            "filename": "contract.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 21,
                                "end_line": 131,
                                "input_file": {
                                    "filename": "contract.cairo"
                                },
                                "start_col": 17,
                                "start_line": 131
                            },
                            "While expanding the reference 'hash' in:"
                        ],
                        "start_col": 9,
                        "start_line": 118
                    }
                },
                "360": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.is_valid_signature"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 34,
                            "offset": 25
                        },
                        "reference_ids": {
                            "__main__.is_valid_signature._public_key": 260,
                            "__main__.is_valid_signature.ecdsa_ptr": 256,
                            "__main__.is_valid_signature.hash": 250,
                            "__main__.is_valid_signature.pedersen_ptr": 258,
                            "__main__.is_valid_signature.range_check_ptr": 259,
                            "__main__.is_valid_signature.sig_r": 261,
                            "__main__.is_valid_signature.sig_s": 262,
                            "__main__.is_valid_signature.signature": 252,
                            "__main__.is_valid_signature.signature_len": 251,
                            "__main__.is_valid_signature.syscall_ptr": 257
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 21,
                        "end_line": 122,
                        "input_file": {
                            "filename": "contract.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 31,
                                "end_line": 132,
                                "input_file": {
                                    "filename": "contract.cairo"
                                },
                                "start_col": 20,
                                "start_line": 132
                            },
                            "While expanding the reference '_public_key' in:"
                        ],
                        "start_col": 10,
                        "start_line": 122
                    }
                },
                "361": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.is_valid_signature"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 34,
                            "offset": 26
                        },
                        "reference_ids": {
                            "__main__.is_valid_signature._public_key": 260,
                            "__main__.is_valid_signature.ecdsa_ptr": 256,
                            "__main__.is_valid_signature.hash": 250,
                            "__main__.is_valid_signature.pedersen_ptr": 258,
                            "__main__.is_valid_signature.range_check_ptr": 259,
                            "__main__.is_valid_signature.sig_r": 261,
                            "__main__.is_valid_signature.sig_s": 262,
                            "__main__.is_valid_signature.signature": 252,
                            "__main__.is_valid_signature.signature_len": 251,
                            "__main__.is_valid_signature.syscall_ptr": 257
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 29,
                        "end_line": 127,
                        "input_file": {
                            "filename": "contract.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 26,
                                "end_line": 133,
                                "input_file": {
                                    "filename": "contract.cairo"
                                },
                                "start_col": 21,
                                "start_line": 133
                            },
                            "While expanding the reference 'sig_r' in:"
                        ],
                        "start_col": 17,
                        "start_line": 127
                    }
                },
                "362": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.is_valid_signature"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 34,
                            "offset": 27
                        },
                        "reference_ids": {
                            "__main__.is_valid_signature._public_key": 260,
                            "__main__.is_valid_signature.ecdsa_ptr": 256,
                            "__main__.is_valid_signature.hash": 250,
                            "__main__.is_valid_signature.pedersen_ptr": 258,
                            "__main__.is_valid_signature.range_check_ptr": 259,
                            "__main__.is_valid_signature.sig_r": 261,
                            "__main__.is_valid_signature.sig_s": 262,
                            "__main__.is_valid_signature.signature": 252,
                            "__main__.is_valid_signature.signature_len": 251,
                            "__main__.is_valid_signature.syscall_ptr": 257
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 29,
                        "end_line": 128,
                        "input_file": {
                            "filename": "contract.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 26,
                                "end_line": 134,
                                "input_file": {
                                    "filename": "contract.cairo"
                                },
                                "start_col": 21,
                                "start_line": 134
                            },
                            "While expanding the reference 'sig_s' in:"
                        ],
                        "start_col": 17,
                        "start_line": 128
                    }
                },
                "363": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.is_valid_signature"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 34,
                            "offset": 28
                        },
                        "reference_ids": {
                            "__main__.is_valid_signature._public_key": 260,
                            "__main__.is_valid_signature.ecdsa_ptr": 256,
                            "__main__.is_valid_signature.hash": 250,
                            "__main__.is_valid_signature.pedersen_ptr": 258,
                            "__main__.is_valid_signature.range_check_ptr": 259,
                            "__main__.is_valid_signature.sig_r": 261,
                            "__main__.is_valid_signature.sig_s": 262,
                            "__main__.is_valid_signature.signature": 252,
                            "__main__.is_valid_signature.signature_len": 251,
                            "__main__.is_valid_signature.syscall_ptr": 257
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 27,
                        "end_line": 134,
                        "input_file": {
                            "filename": "contract.cairo"
                        },
                        "start_col": 5,
                        "start_line": 130
                    }
                },
                "365": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.is_valid_signature"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 34,
                            "offset": 31
                        },
                        "reference_ids": {
                            "__main__.is_valid_signature._public_key": 260,
                            "__main__.is_valid_signature.ecdsa_ptr": 263,
                            "__main__.is_valid_signature.hash": 250,
                            "__main__.is_valid_signature.pedersen_ptr": 258,
                            "__main__.is_valid_signature.range_check_ptr": 259,
                            "__main__.is_valid_signature.sig_r": 261,
                            "__main__.is_valid_signature.sig_s": 262,
                            "__main__.is_valid_signature.signature": 252,
                            "__main__.is_valid_signature.signature_len": 251,
                            "__main__.is_valid_signature.syscall_ptr": 257
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 34,
                        "end_line": 13,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/public_key/decl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 42,
                                "end_line": 122,
                                "input_file": {
                                    "filename": "contract.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 28,
                                        "end_line": 113,
                                        "input_file": {
                                            "filename": "contract.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 14,
                                                "end_line": 136,
                                                "input_file": {
                                                    "filename": "contract.cairo"
                                                },
                                                "start_col": 5,
                                                "start_line": 136
                                            },
                                            "While trying to retrieve the implicit argument 'syscall_ptr' in:"
                                        ],
                                        "start_col": 9,
                                        "start_line": 113
                                    },
                                    "While expanding the reference 'syscall_ptr' in:"
                                ],
                                "start_col": 25,
                                "start_line": 122
                            },
                            "While trying to update the implicit return value 'syscall_ptr' in:"
                        ],
                        "start_col": 15,
                        "start_line": 13
                    }
                },
                "366": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.is_valid_signature"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 34,
                            "offset": 32
                        },
                        "reference_ids": {
                            "__main__.is_valid_signature._public_key": 260,
                            "__main__.is_valid_signature.ecdsa_ptr": 263,
                            "__main__.is_valid_signature.hash": 250,
                            "__main__.is_valid_signature.pedersen_ptr": 258,
                            "__main__.is_valid_signature.range_check_ptr": 259,
                            "__main__.is_valid_signature.sig_r": 261,
                            "__main__.is_valid_signature.sig_s": 262,
                            "__main__.is_valid_signature.signature": 252,
                            "__main__.is_valid_signature.signature_len": 251,
                            "__main__.is_valid_signature.syscall_ptr": 257
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 63,
                        "end_line": 13,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/public_key/decl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 42,
                                "end_line": 122,
                                "input_file": {
                                    "filename": "contract.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 36,
                                        "end_line": 114,
                                        "input_file": {
                                            "filename": "contract.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 14,
                                                "end_line": 136,
                                                "input_file": {
                                                    "filename": "contract.cairo"
                                                },
                                                "start_col": 5,
                                                "start_line": 136
                                            },
                                            "While trying to retrieve the implicit argument 'pedersen_ptr' in:"
                                        ],
                                        "start_col": 9,
                                        "start_line": 114
                                    },
                                    "While expanding the reference 'pedersen_ptr' in:"
                                ],
                                "start_col": 25,
                                "start_line": 122
                            },
                            "While trying to update the implicit return value 'pedersen_ptr' in:"
                        ],
                        "start_col": 36,
                        "start_line": 13
                    }
                },
                "367": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.is_valid_signature"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 34,
                            "offset": 33
                        },
                        "reference_ids": {
                            "__main__.is_valid_signature._public_key": 260,
                            "__main__.is_valid_signature.ecdsa_ptr": 263,
                            "__main__.is_valid_signature.hash": 250,
                            "__main__.is_valid_signature.pedersen_ptr": 258,
                            "__main__.is_valid_signature.range_check_ptr": 259,
                            "__main__.is_valid_signature.sig_r": 261,
                            "__main__.is_valid_signature.sig_s": 262,
                            "__main__.is_valid_signature.signature": 252,
                            "__main__.is_valid_signature.signature_len": 251,
                            "__main__.is_valid_signature.syscall_ptr": 257
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 80,
                        "end_line": 13,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/public_key/decl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 42,
                                "end_line": 122,
                                "input_file": {
                                    "filename": "contract.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 24,
                                        "end_line": 115,
                                        "input_file": {
                                            "filename": "contract.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 14,
                                                "end_line": 136,
                                                "input_file": {
                                                    "filename": "contract.cairo"
                                                },
                                                "start_col": 5,
                                                "start_line": 136
                                            },
                                            "While trying to retrieve the implicit argument 'range_check_ptr' in:"
                                        ],
                                        "start_col": 9,
                                        "start_line": 115
                                    },
                                    "While expanding the reference 'range_check_ptr' in:"
                                ],
                                "start_col": 25,
                                "start_line": 122
                            },
                            "While trying to update the implicit return value 'range_check_ptr' in:"
                        ],
                        "start_col": 65,
                        "start_line": 13
                    }
                },
                "368": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.is_valid_signature"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 34,
                            "offset": 34
                        },
                        "reference_ids": {
                            "__main__.is_valid_signature._public_key": 260,
                            "__main__.is_valid_signature.ecdsa_ptr": 263,
                            "__main__.is_valid_signature.hash": 250,
                            "__main__.is_valid_signature.pedersen_ptr": 258,
                            "__main__.is_valid_signature.range_check_ptr": 259,
                            "__main__.is_valid_signature.sig_r": 261,
                            "__main__.is_valid_signature.sig_s": 262,
                            "__main__.is_valid_signature.signature": 252,
                            "__main__.is_valid_signature.signature_len": 251,
                            "__main__.is_valid_signature.syscall_ptr": 257
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 58,
                        "end_line": 7,
                        "input_file": {
                            "filename": "/Users/jakubptak/Library/Caches/pypoetry/virtualenvs/starkware-python-sdk-L_CLq0Mm-py3.7/lib/python3.7/site-packages/starkware/cairo/common/signature.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 27,
                                "end_line": 134,
                                "input_file": {
                                    "filename": "contract.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 37,
                                        "end_line": 116,
                                        "input_file": {
                                            "filename": "contract.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 14,
                                                "end_line": 136,
                                                "input_file": {
                                                    "filename": "contract.cairo"
                                                },
                                                "start_col": 5,
                                                "start_line": 136
                                            },
                                            "While trying to retrieve the implicit argument 'ecdsa_ptr' in:"
                                        ],
                                        "start_col": 9,
                                        "start_line": 116
                                    },
                                    "While expanding the reference 'ecdsa_ptr' in:"
                                ],
                                "start_col": 5,
                                "start_line": 130
                            },
                            "While trying to update the implicit return value 'ecdsa_ptr' in:"
                        ],
                        "start_col": 29,
                        "start_line": 7
                    }
                },
                "369": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.is_valid_signature"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 34,
                            "offset": 35
                        },
                        "reference_ids": {
                            "__main__.is_valid_signature._public_key": 260,
                            "__main__.is_valid_signature.ecdsa_ptr": 263,
                            "__main__.is_valid_signature.hash": 250,
                            "__main__.is_valid_signature.pedersen_ptr": 258,
                            "__main__.is_valid_signature.range_check_ptr": 259,
                            "__main__.is_valid_signature.sig_r": 261,
                            "__main__.is_valid_signature.sig_s": 262,
                            "__main__.is_valid_signature.signature": 252,
                            "__main__.is_valid_signature.signature_len": 251,
                            "__main__.is_valid_signature.syscall_ptr": 257
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 14,
                        "end_line": 136,
                        "input_file": {
                            "filename": "contract.cairo"
                        },
                        "start_col": 5,
                        "start_line": 136
                    }
                },
                "370": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.is_valid_signature"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 35,
                            "offset": 0
                        },
                        "reference_ids": {
                            "__wrappers__.is_valid_signature.__calldata_arg_hash": 269,
                            "__wrappers__.is_valid_signature.__calldata_arg_signature_len": 271,
                            "__wrappers__.is_valid_signature.__calldata_ptr": 272,
                            "__wrappers__.is_valid_signature.ecdsa_ptr": 267,
                            "__wrappers__.is_valid_signature.pedersen_ptr": 265,
                            "__wrappers__.is_valid_signature.range_check_ptr": 266,
                            "__wrappers__.is_valid_signature.syscall_ptr": 264
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 53,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/external/is_valid_signature/d5f67cc7e69abbde284d945f017319bd8e156adfab63895c8d652f5c3e4f6c3a.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 24,
                                "end_line": 115,
                                "input_file": {
                                    "filename": "contract.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 24,
                                        "end_line": 2,
                                        "input_file": {
                                            "filename": "autogen/starknet/arg_processor/b0c1882c07641aba5f9360ee19386f3c652830833d32f5bd2eb569a388b39448.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 25,
                                                "end_line": 120,
                                                "input_file": {
                                                    "filename": "contract.cairo"
                                                },
                                                "start_col": 9,
                                                "start_line": 120
                                            },
                                            "While handling calldata argument 'signature'"
                                        ],
                                        "start_col": 9,
                                        "start_line": 2
                                    },
                                    "While expanding the reference 'range_check_ptr' in:"
                                ],
                                "start_col": 9,
                                "start_line": 115
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 23,
                        "start_line": 1
                    }
                },
                "371": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.is_valid_signature"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 35,
                            "offset": 1
                        },
                        "reference_ids": {
                            "__wrappers__.is_valid_signature.__calldata_arg_hash": 269,
                            "__wrappers__.is_valid_signature.__calldata_arg_signature_len": 271,
                            "__wrappers__.is_valid_signature.__calldata_ptr": 272,
                            "__wrappers__.is_valid_signature.__temp15": 273,
                            "__wrappers__.is_valid_signature.ecdsa_ptr": 267,
                            "__wrappers__.is_valid_signature.pedersen_ptr": 265,
                            "__wrappers__.is_valid_signature.range_check_ptr": 266,
                            "__wrappers__.is_valid_signature.syscall_ptr": 264
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 52,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/arg_processor/e1b7bcaf2f97aa307c8deca2578c63f05cf45d09bb1ecaaf9be0bb828fc5cb40.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 28,
                                "end_line": 119,
                                "input_file": {
                                    "filename": "contract.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 56,
                                        "end_line": 2,
                                        "input_file": {
                                            "filename": "autogen/starknet/arg_processor/b0c1882c07641aba5f9360ee19386f3c652830833d32f5bd2eb569a388b39448.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 25,
                                                "end_line": 120,
                                                "input_file": {
                                                    "filename": "contract.cairo"
                                                },
                                                "start_col": 9,
                                                "start_line": 120
                                            },
                                            "While handling calldata argument 'signature'"
                                        ],
                                        "start_col": 28,
                                        "start_line": 2
                                    },
                                    "While expanding the reference '__calldata_arg_signature_len' in:"
                                ],
                                "start_col": 9,
                                "start_line": 119
                            },
                            "While handling calldata argument 'signature_len'"
                        ],
                        "start_col": 36,
                        "start_line": 1
                    }
                },
                "372": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.is_valid_signature"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 35,
                            "offset": 2
                        },
                        "reference_ids": {
                            "__wrappers__.is_valid_signature.__calldata_arg_hash": 269,
                            "__wrappers__.is_valid_signature.__calldata_arg_signature_len": 271,
                            "__wrappers__.is_valid_signature.__calldata_ptr": 272,
                            "__wrappers__.is_valid_signature.__temp15": 273,
                            "__wrappers__.is_valid_signature.__temp16": 274,
                            "__wrappers__.is_valid_signature.ecdsa_ptr": 267,
                            "__wrappers__.is_valid_signature.pedersen_ptr": 265,
                            "__wrappers__.is_valid_signature.range_check_ptr": 266,
                            "__wrappers__.is_valid_signature.syscall_ptr": 264
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 56,
                        "end_line": 2,
                        "input_file": {
                            "filename": "autogen/starknet/arg_processor/b0c1882c07641aba5f9360ee19386f3c652830833d32f5bd2eb569a388b39448.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 25,
                                "end_line": 120,
                                "input_file": {
                                    "filename": "contract.cairo"
                                },
                                "start_col": 9,
                                "start_line": 120
                            },
                            "While handling calldata argument 'signature'"
                        ],
                        "start_col": 1,
                        "start_line": 2
                    }
                },
                "373": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.is_valid_signature"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 35,
                            "offset": 2
                        },
                        "reference_ids": {
                            "__wrappers__.is_valid_signature.__calldata_arg_hash": 269,
                            "__wrappers__.is_valid_signature.__calldata_arg_signature": 276,
                            "__wrappers__.is_valid_signature.__calldata_arg_signature_len": 271,
                            "__wrappers__.is_valid_signature.__calldata_ptr": 272,
                            "__wrappers__.is_valid_signature.__temp15": 273,
                            "__wrappers__.is_valid_signature.__temp16": 274,
                            "__wrappers__.is_valid_signature.ecdsa_ptr": 267,
                            "__wrappers__.is_valid_signature.pedersen_ptr": 265,
                            "__wrappers__.is_valid_signature.range_check_ptr": 275,
                            "__wrappers__.is_valid_signature.syscall_ptr": 264
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 40,
                        "end_line": 2,
                        "input_file": {
                            "filename": "autogen/starknet/arg_processor/e1b7bcaf2f97aa307c8deca2578c63f05cf45d09bb1ecaaf9be0bb828fc5cb40.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 28,
                                "end_line": 119,
                                "input_file": {
                                    "filename": "contract.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 40,
                                        "end_line": 8,
                                        "input_file": {
                                            "filename": "autogen/starknet/arg_processor/b0c1882c07641aba5f9360ee19386f3c652830833d32f5bd2eb569a388b39448.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 25,
                                                "end_line": 120,
                                                "input_file": {
                                                    "filename": "contract.cairo"
                                                },
                                                "start_col": 9,
                                                "start_line": 120
                                            },
                                            "While handling calldata argument 'signature'"
                                        ],
                                        "start_col": 26,
                                        "start_line": 8
                                    },
                                    "While expanding the reference '__calldata_ptr' in:"
                                ],
                                "start_col": 9,
                                "start_line": 119
                            },
                            "While handling calldata argument 'signature_len'"
                        ],
                        "start_col": 22,
                        "start_line": 2
                    }
                },
                "375": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.is_valid_signature"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 35,
                            "offset": 3
                        },
                        "reference_ids": {
                            "__wrappers__.is_valid_signature.__calldata_arg_hash": 269,
                            "__wrappers__.is_valid_signature.__calldata_arg_signature": 276,
                            "__wrappers__.is_valid_signature.__calldata_arg_signature_len": 271,
                            "__wrappers__.is_valid_signature.__calldata_ptr": 272,
                            "__wrappers__.is_valid_signature.__temp15": 273,
                            "__wrappers__.is_valid_signature.__temp16": 274,
                            "__wrappers__.is_valid_signature.__temp17": 277,
                            "__wrappers__.is_valid_signature.ecdsa_ptr": 267,
                            "__wrappers__.is_valid_signature.pedersen_ptr": 265,
                            "__wrappers__.is_valid_signature.range_check_ptr": 275,
                            "__wrappers__.is_valid_signature.syscall_ptr": 264
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 52,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/arg_processor/e1b7bcaf2f97aa307c8deca2578c63f05cf45d09bb1ecaaf9be0bb828fc5cb40.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 28,
                                "end_line": 119,
                                "input_file": {
                                    "filename": "contract.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 71,
                                        "end_line": 8,
                                        "input_file": {
                                            "filename": "autogen/starknet/arg_processor/b0c1882c07641aba5f9360ee19386f3c652830833d32f5bd2eb569a388b39448.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 25,
                                                "end_line": 120,
                                                "input_file": {
                                                    "filename": "contract.cairo"
                                                },
                                                "start_col": 9,
                                                "start_line": 120
                                            },
                                            "While handling calldata argument 'signature'"
                                        ],
                                        "start_col": 43,
                                        "start_line": 8
                                    },
                                    "While expanding the reference '__calldata_arg_signature_len' in:"
                                ],
                                "start_col": 9,
                                "start_line": 119
                            },
                            "While handling calldata argument 'signature_len'"
                        ],
                        "start_col": 36,
                        "start_line": 1
                    }
                },
                "376": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.is_valid_signature"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 35,
                            "offset": 4
                        },
                        "reference_ids": {
                            "__wrappers__.is_valid_signature.__calldata_arg_hash": 269,
                            "__wrappers__.is_valid_signature.__calldata_arg_signature": 276,
                            "__wrappers__.is_valid_signature.__calldata_arg_signature_len": 271,
                            "__wrappers__.is_valid_signature.__calldata_ptr": 272,
                            "__wrappers__.is_valid_signature.__temp15": 273,
                            "__wrappers__.is_valid_signature.__temp16": 274,
                            "__wrappers__.is_valid_signature.__temp17": 277,
                            "__wrappers__.is_valid_signature.__temp18": 278,
                            "__wrappers__.is_valid_signature.ecdsa_ptr": 267,
                            "__wrappers__.is_valid_signature.pedersen_ptr": 265,
                            "__wrappers__.is_valid_signature.range_check_ptr": 275,
                            "__wrappers__.is_valid_signature.syscall_ptr": 264
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 71,
                        "end_line": 8,
                        "input_file": {
                            "filename": "autogen/starknet/arg_processor/b0c1882c07641aba5f9360ee19386f3c652830833d32f5bd2eb569a388b39448.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 25,
                                "end_line": 120,
                                "input_file": {
                                    "filename": "contract.cairo"
                                },
                                "start_col": 9,
                                "start_line": 120
                            },
                            "While handling calldata argument 'signature'"
                        ],
                        "start_col": 26,
                        "start_line": 8
                    }
                },
                "377": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.is_valid_signature"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 35,
                            "offset": 5
                        },
                        "reference_ids": {
                            "__wrappers__.is_valid_signature.__calldata_actual_size": 280,
                            "__wrappers__.is_valid_signature.__calldata_arg_hash": 269,
                            "__wrappers__.is_valid_signature.__calldata_arg_signature": 276,
                            "__wrappers__.is_valid_signature.__calldata_arg_signature_len": 271,
                            "__wrappers__.is_valid_signature.__calldata_ptr": 279,
                            "__wrappers__.is_valid_signature.__temp15": 273,
                            "__wrappers__.is_valid_signature.__temp16": 274,
                            "__wrappers__.is_valid_signature.__temp17": 277,
                            "__wrappers__.is_valid_signature.__temp18": 278,
                            "__wrappers__.is_valid_signature.ecdsa_ptr": 267,
                            "__wrappers__.is_valid_signature.pedersen_ptr": 265,
                            "__wrappers__.is_valid_signature.range_check_ptr": 275,
                            "__wrappers__.is_valid_signature.syscall_ptr": 264
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 44,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/arg_processor/7f0b238f4e526821a97d8aaa2f9484df4b5bd00cbad10a761ae4225314096a56.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 24,
                                "end_line": 112,
                                "input_file": {
                                    "filename": "contract.cairo"
                                },
                                "start_col": 6,
                                "start_line": 112
                            },
                            "While handling calldata of"
                        ],
                        "start_col": 1,
                        "start_line": 1
                    }
                },
                "378": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.is_valid_signature"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 35,
                            "offset": 5
                        },
                        "reference_ids": {
                            "__wrappers__.is_valid_signature.__calldata_actual_size": 280,
                            "__wrappers__.is_valid_signature.__calldata_arg_hash": 269,
                            "__wrappers__.is_valid_signature.__calldata_arg_signature": 276,
                            "__wrappers__.is_valid_signature.__calldata_arg_signature_len": 271,
                            "__wrappers__.is_valid_signature.__calldata_ptr": 279,
                            "__wrappers__.is_valid_signature.__temp15": 273,
                            "__wrappers__.is_valid_signature.__temp16": 274,
                            "__wrappers__.is_valid_signature.__temp17": 277,
                            "__wrappers__.is_valid_signature.__temp18": 278,
                            "__wrappers__.is_valid_signature.ecdsa_ptr": 267,
                            "__wrappers__.is_valid_signature.pedersen_ptr": 265,
                            "__wrappers__.is_valid_signature.range_check_ptr": 275,
                            "__wrappers__.is_valid_signature.syscall_ptr": 264
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 53,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/external/is_valid_signature/d5f67cc7e69abbde284d945f017319bd8e156adfab63895c8d652f5c3e4f6c3a.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 24,
                                "end_line": 115,
                                "input_file": {
                                    "filename": "contract.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 38,
                                        "end_line": 3,
                                        "input_file": {
                                            "filename": "autogen/starknet/arg_processor/b0c1882c07641aba5f9360ee19386f3c652830833d32f5bd2eb569a388b39448.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 25,
                                                "end_line": 120,
                                                "input_file": {
                                                    "filename": "contract.cairo"
                                                },
                                                "parent_location": [
                                                    {
                                                        "end_col": 116,
                                                        "end_line": 1,
                                                        "input_file": {
                                                            "filename": "autogen/starknet/external/is_valid_signature/a4577150f3039c0db885ccde32bb0d5a5b36850e59d8cf7d9c3472ad9a641767.cairo"
                                                        },
                                                        "parent_location": [
                                                            {
                                                                "end_col": 24,
                                                                "end_line": 112,
                                                                "input_file": {
                                                                    "filename": "contract.cairo"
                                                                },
                                                                "start_col": 6,
                                                                "start_line": 112
                                                            },
                                                            "While constructing the external wrapper for:"
                                                        ],
                                                        "start_col": 101,
                                                        "start_line": 1
                                                    },
                                                    "While expanding the reference 'range_check_ptr' in:"
                                                ],
                                                "start_col": 9,
                                                "start_line": 120
                                            },
                                            "While handling calldata argument 'signature'"
                                        ],
                                        "start_col": 23,
                                        "start_line": 3
                                    },
                                    "While expanding the reference 'range_check_ptr' in:"
                                ],
                                "start_col": 9,
                                "start_line": 115
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 23,
                        "start_line": 1
                    }
                },
                "379": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.is_valid_signature"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 35,
                            "offset": 6
                        },
                        "reference_ids": {
                            "__wrappers__.is_valid_signature.__calldata_actual_size": 280,
                            "__wrappers__.is_valid_signature.__calldata_arg_hash": 269,
                            "__wrappers__.is_valid_signature.__calldata_arg_signature": 276,
                            "__wrappers__.is_valid_signature.__calldata_arg_signature_len": 271,
                            "__wrappers__.is_valid_signature.__calldata_ptr": 279,
                            "__wrappers__.is_valid_signature.__temp15": 273,
                            "__wrappers__.is_valid_signature.__temp16": 274,
                            "__wrappers__.is_valid_signature.__temp17": 277,
                            "__wrappers__.is_valid_signature.__temp18": 278,
                            "__wrappers__.is_valid_signature.__temp19": 281,
                            "__wrappers__.is_valid_signature.ecdsa_ptr": 267,
                            "__wrappers__.is_valid_signature.pedersen_ptr": 265,
                            "__wrappers__.is_valid_signature.range_check_ptr": 275,
                            "__wrappers__.is_valid_signature.syscall_ptr": 264
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 50,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/external/is_valid_signature/f4a8893cfc7cc4f313b0c426fa25c38c6c57664957bc56a170a27945759c5102.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 28,
                                "end_line": 113,
                                "input_file": {
                                    "filename": "contract.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 56,
                                        "end_line": 1,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/is_valid_signature/a4577150f3039c0db885ccde32bb0d5a5b36850e59d8cf7d9c3472ad9a641767.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 24,
                                                "end_line": 112,
                                                "input_file": {
                                                    "filename": "contract.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 112
                                            },
                                            "While constructing the external wrapper for:"
                                        ],
                                        "start_col": 45,
                                        "start_line": 1
                                    },
                                    "While expanding the reference 'syscall_ptr' in:"
                                ],
                                "start_col": 9,
                                "start_line": 113
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 19,
                        "start_line": 1
                    }
                },
                "380": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.is_valid_signature"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 35,
                            "offset": 7
                        },
                        "reference_ids": {
                            "__wrappers__.is_valid_signature.__calldata_actual_size": 280,
                            "__wrappers__.is_valid_signature.__calldata_arg_hash": 269,
                            "__wrappers__.is_valid_signature.__calldata_arg_signature": 276,
                            "__wrappers__.is_valid_signature.__calldata_arg_signature_len": 271,
                            "__wrappers__.is_valid_signature.__calldata_ptr": 279,
                            "__wrappers__.is_valid_signature.__temp15": 273,
                            "__wrappers__.is_valid_signature.__temp16": 274,
                            "__wrappers__.is_valid_signature.__temp17": 277,
                            "__wrappers__.is_valid_signature.__temp18": 278,
                            "__wrappers__.is_valid_signature.__temp19": 281,
                            "__wrappers__.is_valid_signature.ecdsa_ptr": 267,
                            "__wrappers__.is_valid_signature.pedersen_ptr": 265,
                            "__wrappers__.is_valid_signature.range_check_ptr": 275,
                            "__wrappers__.is_valid_signature.syscall_ptr": 264
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 96,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/external/is_valid_signature/bf54f65e3c6b81daf1c2b60a8cb4034b53ce30386ebc03b148a9de60d6f5dd57.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 36,
                                "end_line": 114,
                                "input_file": {
                                    "filename": "contract.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 83,
                                        "end_line": 1,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/is_valid_signature/a4577150f3039c0db885ccde32bb0d5a5b36850e59d8cf7d9c3472ad9a641767.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 24,
                                                "end_line": 112,
                                                "input_file": {
                                                    "filename": "contract.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 112
                                            },
                                            "While constructing the external wrapper for:"
                                        ],
                                        "start_col": 71,
                                        "start_line": 1
                                    },
                                    "While expanding the reference 'pedersen_ptr' in:"
                                ],
                                "start_col": 9,
                                "start_line": 114
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 20,
                        "start_line": 1
                    }
                },
                "381": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.is_valid_signature"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 35,
                            "offset": 8
                        },
                        "reference_ids": {
                            "__wrappers__.is_valid_signature.__calldata_actual_size": 280,
                            "__wrappers__.is_valid_signature.__calldata_arg_hash": 269,
                            "__wrappers__.is_valid_signature.__calldata_arg_signature": 276,
                            "__wrappers__.is_valid_signature.__calldata_arg_signature_len": 271,
                            "__wrappers__.is_valid_signature.__calldata_ptr": 279,
                            "__wrappers__.is_valid_signature.__temp15": 273,
                            "__wrappers__.is_valid_signature.__temp16": 274,
                            "__wrappers__.is_valid_signature.__temp17": 277,
                            "__wrappers__.is_valid_signature.__temp18": 278,
                            "__wrappers__.is_valid_signature.__temp19": 281,
                            "__wrappers__.is_valid_signature.ecdsa_ptr": 267,
                            "__wrappers__.is_valid_signature.pedersen_ptr": 265,
                            "__wrappers__.is_valid_signature.range_check_ptr": 275,
                            "__wrappers__.is_valid_signature.syscall_ptr": 264
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 42,
                        "end_line": 3,
                        "input_file": {
                            "filename": "autogen/starknet/arg_processor/b0c1882c07641aba5f9360ee19386f3c652830833d32f5bd2eb569a388b39448.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 25,
                                "end_line": 120,
                                "input_file": {
                                    "filename": "contract.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 116,
                                        "end_line": 1,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/is_valid_signature/a4577150f3039c0db885ccde32bb0d5a5b36850e59d8cf7d9c3472ad9a641767.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 24,
                                                "end_line": 112,
                                                "input_file": {
                                                    "filename": "contract.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 112
                                            },
                                            "While constructing the external wrapper for:"
                                        ],
                                        "start_col": 101,
                                        "start_line": 1
                                    },
                                    "While expanding the reference 'range_check_ptr' in:"
                                ],
                                "start_col": 9,
                                "start_line": 120
                            },
                            "While handling calldata argument 'signature'"
                        ],
                        "start_col": 23,
                        "start_line": 3
                    }
                },
                "383": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.is_valid_signature"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 35,
                            "offset": 9
                        },
                        "reference_ids": {
                            "__wrappers__.is_valid_signature.__calldata_actual_size": 280,
                            "__wrappers__.is_valid_signature.__calldata_arg_hash": 269,
                            "__wrappers__.is_valid_signature.__calldata_arg_signature": 276,
                            "__wrappers__.is_valid_signature.__calldata_arg_signature_len": 271,
                            "__wrappers__.is_valid_signature.__calldata_ptr": 279,
                            "__wrappers__.is_valid_signature.__temp15": 273,
                            "__wrappers__.is_valid_signature.__temp16": 274,
                            "__wrappers__.is_valid_signature.__temp17": 277,
                            "__wrappers__.is_valid_signature.__temp18": 278,
                            "__wrappers__.is_valid_signature.__temp19": 281,
                            "__wrappers__.is_valid_signature.ecdsa_ptr": 267,
                            "__wrappers__.is_valid_signature.pedersen_ptr": 265,
                            "__wrappers__.is_valid_signature.range_check_ptr": 275,
                            "__wrappers__.is_valid_signature.syscall_ptr": 264
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 98,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/external/is_valid_signature/5fc167c3d8ad62579d6fff3348b16b5008843c3afd00129ecab00674256d9e3c.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 37,
                                "end_line": 116,
                                "input_file": {
                                    "filename": "contract.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 137,
                                        "end_line": 1,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/is_valid_signature/a4577150f3039c0db885ccde32bb0d5a5b36850e59d8cf7d9c3472ad9a641767.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 24,
                                                "end_line": 112,
                                                "input_file": {
                                                    "filename": "contract.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 112
                                            },
                                            "While constructing the external wrapper for:"
                                        ],
                                        "start_col": 128,
                                        "start_line": 1
                                    },
                                    "While expanding the reference 'ecdsa_ptr' in:"
                                ],
                                "start_col": 9,
                                "start_line": 116
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 17,
                        "start_line": 1
                    }
                },
                "384": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.is_valid_signature"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 35,
                            "offset": 10
                        },
                        "reference_ids": {
                            "__wrappers__.is_valid_signature.__calldata_actual_size": 280,
                            "__wrappers__.is_valid_signature.__calldata_arg_hash": 269,
                            "__wrappers__.is_valid_signature.__calldata_arg_signature": 276,
                            "__wrappers__.is_valid_signature.__calldata_arg_signature_len": 271,
                            "__wrappers__.is_valid_signature.__calldata_ptr": 279,
                            "__wrappers__.is_valid_signature.__temp15": 273,
                            "__wrappers__.is_valid_signature.__temp16": 274,
                            "__wrappers__.is_valid_signature.__temp17": 277,
                            "__wrappers__.is_valid_signature.__temp18": 278,
                            "__wrappers__.is_valid_signature.__temp19": 281,
                            "__wrappers__.is_valid_signature.ecdsa_ptr": 267,
                            "__wrappers__.is_valid_signature.pedersen_ptr": 265,
                            "__wrappers__.is_valid_signature.range_check_ptr": 275,
                            "__wrappers__.is_valid_signature.syscall_ptr": 264
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 43,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/arg_processor/f3c2d3942f0f75ba7fab7e0c13e6cee1d1be8a6d9e771412e1ff56c7484dd3f4.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 19,
                                "end_line": 118,
                                "input_file": {
                                    "filename": "contract.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 163,
                                        "end_line": 1,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/is_valid_signature/a4577150f3039c0db885ccde32bb0d5a5b36850e59d8cf7d9c3472ad9a641767.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 24,
                                                "end_line": 112,
                                                "input_file": {
                                                    "filename": "contract.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 112
                                            },
                                            "While constructing the external wrapper for:"
                                        ],
                                        "start_col": 144,
                                        "start_line": 1
                                    },
                                    "While expanding the reference '__calldata_arg_hash' in:"
                                ],
                                "start_col": 9,
                                "start_line": 118
                            },
                            "While handling calldata argument 'hash'"
                        ],
                        "start_col": 27,
                        "start_line": 1
                    }
                },
                "385": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.is_valid_signature"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 35,
                            "offset": 11
                        },
                        "reference_ids": {
                            "__wrappers__.is_valid_signature.__calldata_actual_size": 280,
                            "__wrappers__.is_valid_signature.__calldata_arg_hash": 269,
                            "__wrappers__.is_valid_signature.__calldata_arg_signature": 276,
                            "__wrappers__.is_valid_signature.__calldata_arg_signature_len": 271,
                            "__wrappers__.is_valid_signature.__calldata_ptr": 279,
                            "__wrappers__.is_valid_signature.__temp15": 273,
                            "__wrappers__.is_valid_signature.__temp16": 274,
                            "__wrappers__.is_valid_signature.__temp17": 277,
                            "__wrappers__.is_valid_signature.__temp18": 278,
                            "__wrappers__.is_valid_signature.__temp19": 281,
                            "__wrappers__.is_valid_signature.ecdsa_ptr": 267,
                            "__wrappers__.is_valid_signature.pedersen_ptr": 265,
                            "__wrappers__.is_valid_signature.range_check_ptr": 275,
                            "__wrappers__.is_valid_signature.syscall_ptr": 264
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 52,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/arg_processor/e1b7bcaf2f97aa307c8deca2578c63f05cf45d09bb1ecaaf9be0bb828fc5cb40.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 28,
                                "end_line": 119,
                                "input_file": {
                                    "filename": "contract.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 207,
                                        "end_line": 1,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/is_valid_signature/a4577150f3039c0db885ccde32bb0d5a5b36850e59d8cf7d9c3472ad9a641767.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 24,
                                                "end_line": 112,
                                                "input_file": {
                                                    "filename": "contract.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 112
                                            },
                                            "While constructing the external wrapper for:"
                                        ],
                                        "start_col": 179,
                                        "start_line": 1
                                    },
                                    "While expanding the reference '__calldata_arg_signature_len' in:"
                                ],
                                "start_col": 9,
                                "start_line": 119
                            },
                            "While handling calldata argument 'signature_len'"
                        ],
                        "start_col": 36,
                        "start_line": 1
                    }
                },
                "386": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.is_valid_signature"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 35,
                            "offset": 12
                        },
                        "reference_ids": {
                            "__wrappers__.is_valid_signature.__calldata_actual_size": 280,
                            "__wrappers__.is_valid_signature.__calldata_arg_hash": 269,
                            "__wrappers__.is_valid_signature.__calldata_arg_signature": 276,
                            "__wrappers__.is_valid_signature.__calldata_arg_signature_len": 271,
                            "__wrappers__.is_valid_signature.__calldata_ptr": 279,
                            "__wrappers__.is_valid_signature.__temp15": 273,
                            "__wrappers__.is_valid_signature.__temp16": 274,
                            "__wrappers__.is_valid_signature.__temp17": 277,
                            "__wrappers__.is_valid_signature.__temp18": 278,
                            "__wrappers__.is_valid_signature.__temp19": 281,
                            "__wrappers__.is_valid_signature.ecdsa_ptr": 267,
                            "__wrappers__.is_valid_signature.pedersen_ptr": 265,
                            "__wrappers__.is_valid_signature.range_check_ptr": 275,
                            "__wrappers__.is_valid_signature.syscall_ptr": 264
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 40,
                        "end_line": 2,
                        "input_file": {
                            "filename": "autogen/starknet/arg_processor/e1b7bcaf2f97aa307c8deca2578c63f05cf45d09bb1ecaaf9be0bb828fc5cb40.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 28,
                                "end_line": 119,
                                "input_file": {
                                    "filename": "contract.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 54,
                                        "end_line": 5,
                                        "input_file": {
                                            "filename": "autogen/starknet/arg_processor/b0c1882c07641aba5f9360ee19386f3c652830833d32f5bd2eb569a388b39448.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 25,
                                                "end_line": 120,
                                                "input_file": {
                                                    "filename": "contract.cairo"
                                                },
                                                "parent_location": [
                                                    {
                                                        "end_col": 243,
                                                        "end_line": 1,
                                                        "input_file": {
                                                            "filename": "autogen/starknet/external/is_valid_signature/a4577150f3039c0db885ccde32bb0d5a5b36850e59d8cf7d9c3472ad9a641767.cairo"
                                                        },
                                                        "parent_location": [
                                                            {
                                                                "end_col": 24,
                                                                "end_line": 112,
                                                                "input_file": {
                                                                    "filename": "contract.cairo"
                                                                },
                                                                "start_col": 6,
                                                                "start_line": 112
                                                            },
                                                            "While constructing the external wrapper for:"
                                                        ],
                                                        "start_col": 219,
                                                        "start_line": 1
                                                    },
                                                    "While expanding the reference '__calldata_arg_signature' in:"
                                                ],
                                                "start_col": 9,
                                                "start_line": 120
                                            },
                                            "While handling calldata argument 'signature'"
                                        ],
                                        "start_col": 40,
                                        "start_line": 5
                                    },
                                    "While expanding the reference '__calldata_ptr' in:"
                                ],
                                "start_col": 9,
                                "start_line": 119
                            },
                            "While handling calldata argument 'signature_len'"
                        ],
                        "start_col": 22,
                        "start_line": 2
                    }
                },
                "388": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.is_valid_signature"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 35,
                            "offset": 13
                        },
                        "reference_ids": {
                            "__wrappers__.is_valid_signature.__calldata_actual_size": 280,
                            "__wrappers__.is_valid_signature.__calldata_arg_hash": 269,
                            "__wrappers__.is_valid_signature.__calldata_arg_signature": 276,
                            "__wrappers__.is_valid_signature.__calldata_arg_signature_len": 271,
                            "__wrappers__.is_valid_signature.__calldata_ptr": 279,
                            "__wrappers__.is_valid_signature.__temp15": 273,
                            "__wrappers__.is_valid_signature.__temp16": 274,
                            "__wrappers__.is_valid_signature.__temp17": 277,
                            "__wrappers__.is_valid_signature.__temp18": 278,
                            "__wrappers__.is_valid_signature.__temp19": 281,
                            "__wrappers__.is_valid_signature.ecdsa_ptr": 267,
                            "__wrappers__.is_valid_signature.pedersen_ptr": 265,
                            "__wrappers__.is_valid_signature.range_check_ptr": 275,
                            "__wrappers__.is_valid_signature.syscall_ptr": 264
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 24,
                        "end_line": 112,
                        "input_file": {
                            "filename": "contract.cairo"
                        },
                        "start_col": 6,
                        "start_line": 112
                    }
                },
                "390": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.is_valid_signature"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 35,
                            "offset": 50
                        },
                        "reference_ids": {
                            "__wrappers__.is_valid_signature.__calldata_actual_size": 280,
                            "__wrappers__.is_valid_signature.__calldata_arg_hash": 269,
                            "__wrappers__.is_valid_signature.__calldata_arg_signature": 276,
                            "__wrappers__.is_valid_signature.__calldata_arg_signature_len": 271,
                            "__wrappers__.is_valid_signature.__calldata_ptr": 279,
                            "__wrappers__.is_valid_signature.__temp15": 273,
                            "__wrappers__.is_valid_signature.__temp16": 274,
                            "__wrappers__.is_valid_signature.__temp17": 277,
                            "__wrappers__.is_valid_signature.__temp18": 278,
                            "__wrappers__.is_valid_signature.__temp19": 281,
                            "__wrappers__.is_valid_signature.ecdsa_ptr": 285,
                            "__wrappers__.is_valid_signature.pedersen_ptr": 283,
                            "__wrappers__.is_valid_signature.range_check_ptr": 284,
                            "__wrappers__.is_valid_signature.ret_struct": 286,
                            "__wrappers__.is_valid_signature.syscall_ptr": 282
                        }
                    },
                    "hints": [
                        {
                            "location": {
                                "end_col": 34,
                                "end_line": 2,
                                "input_file": {
                                    "filename": "autogen/starknet/external/is_valid_signature/a4577150f3039c0db885ccde32bb0d5a5b36850e59d8cf7d9c3472ad9a641767.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 24,
                                        "end_line": 112,
                                        "input_file": {
                                            "filename": "contract.cairo"
                                        },
                                        "start_col": 6,
                                        "start_line": 112
                                    },
                                    "While constructing the external wrapper for:"
                                ],
                                "start_col": 1,
                                "start_line": 2
                            },
                            "n_prefix_newlines": 0
                        }
                    ],
                    "inst": {
                        "end_col": 24,
                        "end_line": 3,
                        "input_file": {
                            "filename": "autogen/starknet/external/is_valid_signature/a4577150f3039c0db885ccde32bb0d5a5b36850e59d8cf7d9c3472ad9a641767.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 24,
                                "end_line": 112,
                                "input_file": {
                                    "filename": "contract.cairo"
                                },
                                "start_col": 6,
                                "start_line": 112
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 1,
                        "start_line": 3
                    }
                },
                "392": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.is_valid_signature"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 35,
                            "offset": 51
                        },
                        "reference_ids": {
                            "__wrappers__.is_valid_signature.__calldata_actual_size": 280,
                            "__wrappers__.is_valid_signature.__calldata_arg_hash": 269,
                            "__wrappers__.is_valid_signature.__calldata_arg_signature": 276,
                            "__wrappers__.is_valid_signature.__calldata_arg_signature_len": 271,
                            "__wrappers__.is_valid_signature.__calldata_ptr": 279,
                            "__wrappers__.is_valid_signature.__temp15": 273,
                            "__wrappers__.is_valid_signature.__temp16": 274,
                            "__wrappers__.is_valid_signature.__temp17": 277,
                            "__wrappers__.is_valid_signature.__temp18": 278,
                            "__wrappers__.is_valid_signature.__temp19": 281,
                            "__wrappers__.is_valid_signature.ecdsa_ptr": 285,
                            "__wrappers__.is_valid_signature.pedersen_ptr": 283,
                            "__wrappers__.is_valid_signature.range_check_ptr": 284,
                            "__wrappers__.is_valid_signature.ret_struct": 286,
                            "__wrappers__.is_valid_signature.retdata": 287,
                            "__wrappers__.is_valid_signature.retdata_size": 288,
                            "__wrappers__.is_valid_signature.syscall_ptr": 282
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 56,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/external/is_valid_signature/a4577150f3039c0db885ccde32bb0d5a5b36850e59d8cf7d9c3472ad9a641767.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 24,
                                "end_line": 112,
                                "input_file": {
                                    "filename": "contract.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 20,
                                        "end_line": 1,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/is_valid_signature/aa526043a8db9187624857305b1409f029aec9f9c85f47438b55e65b3afc0639.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 24,
                                                "end_line": 112,
                                                "input_file": {
                                                    "filename": "contract.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 112
                                            },
                                            "While constructing the external wrapper for:"
                                        ],
                                        "start_col": 9,
                                        "start_line": 1
                                    },
                                    "While expanding the reference 'syscall_ptr' in:"
                                ],
                                "start_col": 6,
                                "start_line": 112
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 45,
                        "start_line": 1
                    }
                },
                "393": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.is_valid_signature"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 35,
                            "offset": 52
                        },
                        "reference_ids": {
                            "__wrappers__.is_valid_signature.__calldata_actual_size": 280,
                            "__wrappers__.is_valid_signature.__calldata_arg_hash": 269,
                            "__wrappers__.is_valid_signature.__calldata_arg_signature": 276,
                            "__wrappers__.is_valid_signature.__calldata_arg_signature_len": 271,
                            "__wrappers__.is_valid_signature.__calldata_ptr": 279,
                            "__wrappers__.is_valid_signature.__temp15": 273,
                            "__wrappers__.is_valid_signature.__temp16": 274,
                            "__wrappers__.is_valid_signature.__temp17": 277,
                            "__wrappers__.is_valid_signature.__temp18": 278,
                            "__wrappers__.is_valid_signature.__temp19": 281,
                            "__wrappers__.is_valid_signature.ecdsa_ptr": 285,
                            "__wrappers__.is_valid_signature.pedersen_ptr": 283,
                            "__wrappers__.is_valid_signature.range_check_ptr": 284,
                            "__wrappers__.is_valid_signature.ret_struct": 286,
                            "__wrappers__.is_valid_signature.retdata": 287,
                            "__wrappers__.is_valid_signature.retdata_size": 288,
                            "__wrappers__.is_valid_signature.syscall_ptr": 282
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 83,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/external/is_valid_signature/a4577150f3039c0db885ccde32bb0d5a5b36850e59d8cf7d9c3472ad9a641767.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 24,
                                "end_line": 112,
                                "input_file": {
                                    "filename": "contract.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 33,
                                        "end_line": 1,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/is_valid_signature/aa526043a8db9187624857305b1409f029aec9f9c85f47438b55e65b3afc0639.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 24,
                                                "end_line": 112,
                                                "input_file": {
                                                    "filename": "contract.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 112
                                            },
                                            "While constructing the external wrapper for:"
                                        ],
                                        "start_col": 21,
                                        "start_line": 1
                                    },
                                    "While expanding the reference 'pedersen_ptr' in:"
                                ],
                                "start_col": 6,
                                "start_line": 112
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 71,
                        "start_line": 1
                    }
                },
                "394": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.is_valid_signature"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 35,
                            "offset": 53
                        },
                        "reference_ids": {
                            "__wrappers__.is_valid_signature.__calldata_actual_size": 280,
                            "__wrappers__.is_valid_signature.__calldata_arg_hash": 269,
                            "__wrappers__.is_valid_signature.__calldata_arg_signature": 276,
                            "__wrappers__.is_valid_signature.__calldata_arg_signature_len": 271,
                            "__wrappers__.is_valid_signature.__calldata_ptr": 279,
                            "__wrappers__.is_valid_signature.__temp15": 273,
                            "__wrappers__.is_valid_signature.__temp16": 274,
                            "__wrappers__.is_valid_signature.__temp17": 277,
                            "__wrappers__.is_valid_signature.__temp18": 278,
                            "__wrappers__.is_valid_signature.__temp19": 281,
                            "__wrappers__.is_valid_signature.ecdsa_ptr": 285,
                            "__wrappers__.is_valid_signature.pedersen_ptr": 283,
                            "__wrappers__.is_valid_signature.range_check_ptr": 284,
                            "__wrappers__.is_valid_signature.ret_struct": 286,
                            "__wrappers__.is_valid_signature.retdata": 287,
                            "__wrappers__.is_valid_signature.retdata_size": 288,
                            "__wrappers__.is_valid_signature.syscall_ptr": 282
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 116,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/external/is_valid_signature/a4577150f3039c0db885ccde32bb0d5a5b36850e59d8cf7d9c3472ad9a641767.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 24,
                                "end_line": 112,
                                "input_file": {
                                    "filename": "contract.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 49,
                                        "end_line": 1,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/is_valid_signature/aa526043a8db9187624857305b1409f029aec9f9c85f47438b55e65b3afc0639.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 24,
                                                "end_line": 112,
                                                "input_file": {
                                                    "filename": "contract.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 112
                                            },
                                            "While constructing the external wrapper for:"
                                        ],
                                        "start_col": 34,
                                        "start_line": 1
                                    },
                                    "While expanding the reference 'range_check_ptr' in:"
                                ],
                                "start_col": 6,
                                "start_line": 112
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 101,
                        "start_line": 1
                    }
                },
                "395": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.is_valid_signature"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 35,
                            "offset": 54
                        },
                        "reference_ids": {
                            "__wrappers__.is_valid_signature.__calldata_actual_size": 280,
                            "__wrappers__.is_valid_signature.__calldata_arg_hash": 269,
                            "__wrappers__.is_valid_signature.__calldata_arg_signature": 276,
                            "__wrappers__.is_valid_signature.__calldata_arg_signature_len": 271,
                            "__wrappers__.is_valid_signature.__calldata_ptr": 279,
                            "__wrappers__.is_valid_signature.__temp15": 273,
                            "__wrappers__.is_valid_signature.__temp16": 274,
                            "__wrappers__.is_valid_signature.__temp17": 277,
                            "__wrappers__.is_valid_signature.__temp18": 278,
                            "__wrappers__.is_valid_signature.__temp19": 281,
                            "__wrappers__.is_valid_signature.ecdsa_ptr": 285,
                            "__wrappers__.is_valid_signature.pedersen_ptr": 283,
                            "__wrappers__.is_valid_signature.range_check_ptr": 284,
                            "__wrappers__.is_valid_signature.ret_struct": 286,
                            "__wrappers__.is_valid_signature.retdata": 287,
                            "__wrappers__.is_valid_signature.retdata_size": 288,
                            "__wrappers__.is_valid_signature.syscall_ptr": 282
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 137,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/external/is_valid_signature/a4577150f3039c0db885ccde32bb0d5a5b36850e59d8cf7d9c3472ad9a641767.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 24,
                                "end_line": 112,
                                "input_file": {
                                    "filename": "contract.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 59,
                                        "end_line": 1,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/is_valid_signature/aa526043a8db9187624857305b1409f029aec9f9c85f47438b55e65b3afc0639.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 24,
                                                "end_line": 112,
                                                "input_file": {
                                                    "filename": "contract.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 112
                                            },
                                            "While constructing the external wrapper for:"
                                        ],
                                        "start_col": 50,
                                        "start_line": 1
                                    },
                                    "While expanding the reference 'ecdsa_ptr' in:"
                                ],
                                "start_col": 6,
                                "start_line": 112
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 128,
                        "start_line": 1
                    }
                },
                "396": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.is_valid_signature"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 35,
                            "offset": 55
                        },
                        "reference_ids": {
                            "__wrappers__.is_valid_signature.__calldata_actual_size": 280,
                            "__wrappers__.is_valid_signature.__calldata_arg_hash": 269,
                            "__wrappers__.is_valid_signature.__calldata_arg_signature": 276,
                            "__wrappers__.is_valid_signature.__calldata_arg_signature_len": 271,
                            "__wrappers__.is_valid_signature.__calldata_ptr": 279,
                            "__wrappers__.is_valid_signature.__temp15": 273,
                            "__wrappers__.is_valid_signature.__temp16": 274,
                            "__wrappers__.is_valid_signature.__temp17": 277,
                            "__wrappers__.is_valid_signature.__temp18": 278,
                            "__wrappers__.is_valid_signature.__temp19": 281,
                            "__wrappers__.is_valid_signature.ecdsa_ptr": 285,
                            "__wrappers__.is_valid_signature.pedersen_ptr": 283,
                            "__wrappers__.is_valid_signature.range_check_ptr": 284,
                            "__wrappers__.is_valid_signature.ret_struct": 286,
                            "__wrappers__.is_valid_signature.retdata": 287,
                            "__wrappers__.is_valid_signature.retdata_size": 288,
                            "__wrappers__.is_valid_signature.syscall_ptr": 282
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 21,
                        "end_line": 4,
                        "input_file": {
                            "filename": "autogen/starknet/external/is_valid_signature/a4577150f3039c0db885ccde32bb0d5a5b36850e59d8cf7d9c3472ad9a641767.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 24,
                                "end_line": 112,
                                "input_file": {
                                    "filename": "contract.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 72,
                                        "end_line": 1,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/is_valid_signature/aa526043a8db9187624857305b1409f029aec9f9c85f47438b55e65b3afc0639.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 24,
                                                "end_line": 112,
                                                "input_file": {
                                                    "filename": "contract.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 112
                                            },
                                            "While constructing the external wrapper for:"
                                        ],
                                        "start_col": 60,
                                        "start_line": 1
                                    },
                                    "While expanding the reference 'retdata_size' in:"
                                ],
                                "start_col": 6,
                                "start_line": 112
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 20,
                        "start_line": 4
                    }
                },
                "398": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.is_valid_signature"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 35,
                            "offset": 56
                        },
                        "reference_ids": {
                            "__wrappers__.is_valid_signature.__calldata_actual_size": 280,
                            "__wrappers__.is_valid_signature.__calldata_arg_hash": 269,
                            "__wrappers__.is_valid_signature.__calldata_arg_signature": 276,
                            "__wrappers__.is_valid_signature.__calldata_arg_signature_len": 271,
                            "__wrappers__.is_valid_signature.__calldata_ptr": 279,
                            "__wrappers__.is_valid_signature.__temp15": 273,
                            "__wrappers__.is_valid_signature.__temp16": 274,
                            "__wrappers__.is_valid_signature.__temp17": 277,
                            "__wrappers__.is_valid_signature.__temp18": 278,
                            "__wrappers__.is_valid_signature.__temp19": 281,
                            "__wrappers__.is_valid_signature.ecdsa_ptr": 285,
                            "__wrappers__.is_valid_signature.pedersen_ptr": 283,
                            "__wrappers__.is_valid_signature.range_check_ptr": 284,
                            "__wrappers__.is_valid_signature.ret_struct": 286,
                            "__wrappers__.is_valid_signature.retdata": 287,
                            "__wrappers__.is_valid_signature.retdata_size": 288,
                            "__wrappers__.is_valid_signature.syscall_ptr": 282
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 16,
                        "end_line": 3,
                        "input_file": {
                            "filename": "autogen/starknet/external/is_valid_signature/a4577150f3039c0db885ccde32bb0d5a5b36850e59d8cf7d9c3472ad9a641767.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 24,
                                "end_line": 112,
                                "input_file": {
                                    "filename": "contract.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 80,
                                        "end_line": 1,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/is_valid_signature/aa526043a8db9187624857305b1409f029aec9f9c85f47438b55e65b3afc0639.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 24,
                                                "end_line": 112,
                                                "input_file": {
                                                    "filename": "contract.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 112
                                            },
                                            "While constructing the external wrapper for:"
                                        ],
                                        "start_col": 73,
                                        "start_line": 1
                                    },
                                    "While expanding the reference 'retdata' in:"
                                ],
                                "start_col": 6,
                                "start_line": 112
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 9,
                        "start_line": 3
                    }
                },
                "399": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.is_valid_signature"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 35,
                            "offset": 57
                        },
                        "reference_ids": {
                            "__wrappers__.is_valid_signature.__calldata_actual_size": 280,
                            "__wrappers__.is_valid_signature.__calldata_arg_hash": 269,
                            "__wrappers__.is_valid_signature.__calldata_arg_signature": 276,
                            "__wrappers__.is_valid_signature.__calldata_arg_signature_len": 271,
                            "__wrappers__.is_valid_signature.__calldata_ptr": 279,
                            "__wrappers__.is_valid_signature.__temp15": 273,
                            "__wrappers__.is_valid_signature.__temp16": 274,
                            "__wrappers__.is_valid_signature.__temp17": 277,
                            "__wrappers__.is_valid_signature.__temp18": 278,
                            "__wrappers__.is_valid_signature.__temp19": 281,
                            "__wrappers__.is_valid_signature.ecdsa_ptr": 285,
                            "__wrappers__.is_valid_signature.pedersen_ptr": 283,
                            "__wrappers__.is_valid_signature.range_check_ptr": 284,
                            "__wrappers__.is_valid_signature.ret_struct": 286,
                            "__wrappers__.is_valid_signature.retdata": 287,
                            "__wrappers__.is_valid_signature.retdata_size": 288,
                            "__wrappers__.is_valid_signature.syscall_ptr": 282
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 81,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/external/is_valid_signature/aa526043a8db9187624857305b1409f029aec9f9c85f47438b55e65b3afc0639.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 24,
                                "end_line": 112,
                                "input_file": {
                                    "filename": "contract.cairo"
                                },
                                "start_col": 6,
                                "start_line": 112
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 1,
                        "start_line": 1
                    }
                },
                "400": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.execute"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 36,
                            "offset": 0
                        },
                        "reference_ids": {
                            "__main__.execute.calldata": 292,
                            "__main__.execute.calldata_len": 291,
                            "__main__.execute.ecdsa_ptr": 297,
                            "__main__.execute.nonce": 293,
                            "__main__.execute.pedersen_ptr": 295,
                            "__main__.execute.range_check_ptr": 296,
                            "__main__.execute.selector": 290,
                            "__main__.execute.syscall_ptr": 294,
                            "__main__.execute.to": 289
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 17,
                        "end_line": 152,
                        "input_file": {
                            "filename": "contract.cairo"
                        },
                        "start_col": 5,
                        "start_line": 152
                    }
                },
                "402": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.execute"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 36,
                            "offset": 9
                        },
                        "reference_ids": {
                            "__main__.execute.calldata": 292,
                            "__main__.execute.calldata_len": 291,
                            "__main__.execute.ecdsa_ptr": 297,
                            "__main__.execute.nonce": 293,
                            "__main__.execute.pedersen_ptr": 295,
                            "__main__.execute.range_check_ptr": 296,
                            "__main__.execute.selector": 290,
                            "__main__.execute.syscall_ptr": 294,
                            "__main__.execute.to": 289
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 38,
                        "end_line": 154,
                        "input_file": {
                            "filename": "contract.cairo"
                        },
                        "start_col": 23,
                        "start_line": 154
                    }
                },
                "404": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.execute"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 36,
                            "offset": 11
                        },
                        "reference_ids": {
                            "__main__.execute.__fp__": 298,
                            "__main__.execute.calldata": 292,
                            "__main__.execute.calldata_len": 291,
                            "__main__.execute.ecdsa_ptr": 297,
                            "__main__.execute.nonce": 293,
                            "__main__.execute.pedersen_ptr": 295,
                            "__main__.execute.range_check_ptr": 296,
                            "__main__.execute.selector": 290,
                            "__main__.execute.syscall_ptr": 294,
                            "__main__.execute.to": 289
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 28,
                        "end_line": 141,
                        "input_file": {
                            "filename": "contract.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 46,
                                "end_line": 144,
                                "input_file": {
                                    "filename": "/Users/jakubptak/Library/Caches/pypoetry/virtualenvs/starkware-python-sdk-L_CLq0Mm-py3.7/lib/python3.7/site-packages/starkware/starknet/common/syscalls.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 44,
                                        "end_line": 155,
                                        "input_file": {
                                            "filename": "contract.cairo"
                                        },
                                        "start_col": 22,
                                        "start_line": 155
                                    },
                                    "While trying to retrieve the implicit argument 'syscall_ptr' in:"
                                ],
                                "start_col": 27,
                                "start_line": 144
                            },
                            "While expanding the reference 'syscall_ptr' in:"
                        ],
                        "start_col": 9,
                        "start_line": 141
                    }
                },
                "405": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.execute"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 36,
                            "offset": 12
                        },
                        "reference_ids": {
                            "__main__.execute.__fp__": 298,
                            "__main__.execute.calldata": 292,
                            "__main__.execute.calldata_len": 291,
                            "__main__.execute.ecdsa_ptr": 297,
                            "__main__.execute.nonce": 293,
                            "__main__.execute.pedersen_ptr": 295,
                            "__main__.execute.range_check_ptr": 296,
                            "__main__.execute.selector": 290,
                            "__main__.execute.syscall_ptr": 294,
                            "__main__.execute.to": 289
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 44,
                        "end_line": 155,
                        "input_file": {
                            "filename": "contract.cairo"
                        },
                        "start_col": 22,
                        "start_line": 155
                    }
                },
                "407": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.execute"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 36,
                            "offset": 17
                        },
                        "reference_ids": {
                            "__main__.execute.__fp__": 298,
                            "__main__.execute._address": 300,
                            "__main__.execute.calldata": 292,
                            "__main__.execute.calldata_len": 291,
                            "__main__.execute.ecdsa_ptr": 297,
                            "__main__.execute.nonce": 293,
                            "__main__.execute.pedersen_ptr": 295,
                            "__main__.execute.range_check_ptr": 296,
                            "__main__.execute.selector": 290,
                            "__main__.execute.syscall_ptr": 299,
                            "__main__.execute.to": 289
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 46,
                        "end_line": 144,
                        "input_file": {
                            "filename": "/Users/jakubptak/Library/Caches/pypoetry/virtualenvs/starkware-python-sdk-L_CLq0Mm-py3.7/lib/python3.7/site-packages/starkware/starknet/common/syscalls.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 44,
                                "end_line": 155,
                                "input_file": {
                                    "filename": "contract.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 34,
                                        "end_line": 13,
                                        "input_file": {
                                            "filename": "autogen/starknet/storage_var/current_nonce/decl.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 48,
                                                "end_line": 156,
                                                "input_file": {
                                                    "filename": "contract.cairo"
                                                },
                                                "start_col": 28,
                                                "start_line": 156
                                            },
                                            "While trying to retrieve the implicit argument 'syscall_ptr' in:"
                                        ],
                                        "start_col": 15,
                                        "start_line": 13
                                    },
                                    "While expanding the reference 'syscall_ptr' in:"
                                ],
                                "start_col": 22,
                                "start_line": 155
                            },
                            "While trying to update the implicit return value 'syscall_ptr' in:"
                        ],
                        "start_col": 27,
                        "start_line": 144
                    }
                },
                "408": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.execute"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 36,
                            "offset": 18
                        },
                        "reference_ids": {
                            "__main__.execute.__fp__": 298,
                            "__main__.execute._address": 300,
                            "__main__.execute.calldata": 292,
                            "__main__.execute.calldata_len": 291,
                            "__main__.execute.ecdsa_ptr": 297,
                            "__main__.execute.nonce": 293,
                            "__main__.execute.pedersen_ptr": 295,
                            "__main__.execute.range_check_ptr": 296,
                            "__main__.execute.selector": 290,
                            "__main__.execute.syscall_ptr": 299,
                            "__main__.execute.to": 289
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 36,
                        "end_line": 142,
                        "input_file": {
                            "filename": "contract.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 63,
                                "end_line": 13,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/current_nonce/decl.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 48,
                                        "end_line": 156,
                                        "input_file": {
                                            "filename": "contract.cairo"
                                        },
                                        "start_col": 28,
                                        "start_line": 156
                                    },
                                    "While trying to retrieve the implicit argument 'pedersen_ptr' in:"
                                ],
                                "start_col": 36,
                                "start_line": 13
                            },
                            "While expanding the reference 'pedersen_ptr' in:"
                        ],
                        "start_col": 9,
                        "start_line": 142
                    }
                },
                "409": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.execute"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 36,
                            "offset": 19
                        },
                        "reference_ids": {
                            "__main__.execute.__fp__": 298,
                            "__main__.execute._address": 300,
                            "__main__.execute.calldata": 292,
                            "__main__.execute.calldata_len": 291,
                            "__main__.execute.ecdsa_ptr": 297,
                            "__main__.execute.nonce": 293,
                            "__main__.execute.pedersen_ptr": 295,
                            "__main__.execute.range_check_ptr": 296,
                            "__main__.execute.selector": 290,
                            "__main__.execute.syscall_ptr": 299,
                            "__main__.execute.to": 289
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 24,
                        "end_line": 143,
                        "input_file": {
                            "filename": "contract.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 80,
                                "end_line": 13,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/current_nonce/decl.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 48,
                                        "end_line": 156,
                                        "input_file": {
                                            "filename": "contract.cairo"
                                        },
                                        "start_col": 28,
                                        "start_line": 156
                                    },
                                    "While trying to retrieve the implicit argument 'range_check_ptr' in:"
                                ],
                                "start_col": 65,
                                "start_line": 13
                            },
                            "While expanding the reference 'range_check_ptr' in:"
                        ],
                        "start_col": 9,
                        "start_line": 143
                    }
                },
                "410": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.execute"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 36,
                            "offset": 20
                        },
                        "reference_ids": {
                            "__main__.execute.__fp__": 298,
                            "__main__.execute._address": 300,
                            "__main__.execute.calldata": 292,
                            "__main__.execute.calldata_len": 291,
                            "__main__.execute.ecdsa_ptr": 297,
                            "__main__.execute.nonce": 293,
                            "__main__.execute.pedersen_ptr": 295,
                            "__main__.execute.range_check_ptr": 296,
                            "__main__.execute.selector": 290,
                            "__main__.execute.syscall_ptr": 299,
                            "__main__.execute.to": 289
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 48,
                        "end_line": 156,
                        "input_file": {
                            "filename": "contract.cairo"
                        },
                        "start_col": 28,
                        "start_line": 156
                    }
                },
                "412": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.execute"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 36,
                            "offset": 40
                        },
                        "reference_ids": {
                            "__main__.execute.__fp__": 298,
                            "__main__.execute._address": 300,
                            "__main__.execute._current_nonce": 304,
                            "__main__.execute.calldata": 292,
                            "__main__.execute.calldata_len": 291,
                            "__main__.execute.ecdsa_ptr": 297,
                            "__main__.execute.nonce": 293,
                            "__main__.execute.pedersen_ptr": 302,
                            "__main__.execute.range_check_ptr": 303,
                            "__main__.execute.selector": 290,
                            "__main__.execute.syscall_ptr": 301,
                            "__main__.execute.to": 289
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 34,
                        "end_line": 13,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/current_nonce/decl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 48,
                                "end_line": 156,
                                "input_file": {
                                    "filename": "contract.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 34,
                                        "end_line": 13,
                                        "input_file": {
                                            "filename": "autogen/starknet/storage_var/current_nonce/decl.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 48,
                                                "end_line": 156,
                                                "input_file": {
                                                    "filename": "contract.cairo"
                                                },
                                                "start_col": 28,
                                                "start_line": 156
                                            },
                                            "While trying to update the implicit return value 'syscall_ptr' in:"
                                        ],
                                        "start_col": 15,
                                        "start_line": 13
                                    },
                                    "While auto generating local variable for 'syscall_ptr'."
                                ],
                                "start_col": 28,
                                "start_line": 156
                            },
                            "While trying to update the implicit return value 'syscall_ptr' in:"
                        ],
                        "start_col": 15,
                        "start_line": 13
                    }
                },
                "413": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.execute"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 36,
                            "offset": 40
                        },
                        "reference_ids": {
                            "__main__.execute.__fp__": 298,
                            "__main__.execute._address": 300,
                            "__main__.execute._current_nonce": 304,
                            "__main__.execute.calldata": 292,
                            "__main__.execute.calldata_len": 291,
                            "__main__.execute.ecdsa_ptr": 297,
                            "__main__.execute.nonce": 293,
                            "__main__.execute.pedersen_ptr": 302,
                            "__main__.execute.range_check_ptr": 303,
                            "__main__.execute.selector": 290,
                            "__main__.execute.syscall_ptr": 305,
                            "__main__.execute.to": 289
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 80,
                        "end_line": 13,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/current_nonce/decl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 48,
                                "end_line": 156,
                                "input_file": {
                                    "filename": "contract.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 80,
                                        "end_line": 13,
                                        "input_file": {
                                            "filename": "autogen/starknet/storage_var/current_nonce/decl.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 48,
                                                "end_line": 156,
                                                "input_file": {
                                                    "filename": "contract.cairo"
                                                },
                                                "start_col": 28,
                                                "start_line": 156
                                            },
                                            "While trying to update the implicit return value 'range_check_ptr' in:"
                                        ],
                                        "start_col": 65,
                                        "start_line": 13
                                    },
                                    "While auto generating local variable for 'range_check_ptr'."
                                ],
                                "start_col": 28,
                                "start_line": 156
                            },
                            "While trying to update the implicit return value 'range_check_ptr' in:"
                        ],
                        "start_col": 65,
                        "start_line": 13
                    }
                },
                "414": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.execute"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 36,
                            "offset": 40
                        },
                        "reference_ids": {
                            "__main__.execute.__fp__": 298,
                            "__main__.execute._address": 300,
                            "__main__.execute._current_nonce": 304,
                            "__main__.execute.calldata": 292,
                            "__main__.execute.calldata_len": 291,
                            "__main__.execute.ecdsa_ptr": 297,
                            "__main__.execute.nonce": 293,
                            "__main__.execute.pedersen_ptr": 302,
                            "__main__.execute.range_check_ptr": 306,
                            "__main__.execute.selector": 290,
                            "__main__.execute.syscall_ptr": 305,
                            "__main__.execute.to": 289
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 24,
                        "end_line": 156,
                        "input_file": {
                            "filename": "contract.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 24,
                                "end_line": 156,
                                "input_file": {
                                    "filename": "contract.cairo"
                                },
                                "start_col": 10,
                                "start_line": 156
                            },
                            "While auto generating local variable for '_current_nonce'."
                        ],
                        "start_col": 10,
                        "start_line": 156
                    }
                },
                "415": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.execute"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 36,
                            "offset": 40
                        },
                        "reference_ids": {
                            "__main__.execute.__fp__": 298,
                            "__main__.execute._address": 300,
                            "__main__.execute._current_nonce": 307,
                            "__main__.execute.calldata": 292,
                            "__main__.execute.calldata_len": 291,
                            "__main__.execute.ecdsa_ptr": 297,
                            "__main__.execute.nonce": 293,
                            "__main__.execute.pedersen_ptr": 302,
                            "__main__.execute.range_check_ptr": 306,
                            "__main__.execute.selector": 290,
                            "__main__.execute.syscall_ptr": 305,
                            "__main__.execute.to": 289
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 6,
                        "end_line": 165,
                        "input_file": {
                            "filename": "contract.cairo"
                        },
                        "start_col": 5,
                        "start_line": 158
                    }
                },
                "416": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.execute"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 36,
                            "offset": 40
                        },
                        "reference_ids": {
                            "__main__.execute.__fp__": 298,
                            "__main__.execute._address": 300,
                            "__main__.execute._current_nonce": 307,
                            "__main__.execute.calldata": 292,
                            "__main__.execute.calldata_len": 291,
                            "__main__.execute.ecdsa_ptr": 297,
                            "__main__.execute.nonce": 293,
                            "__main__.execute.pedersen_ptr": 302,
                            "__main__.execute.range_check_ptr": 306,
                            "__main__.execute.selector": 290,
                            "__main__.execute.syscall_ptr": 305,
                            "__main__.execute.to": 289
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 6,
                        "end_line": 165,
                        "input_file": {
                            "filename": "contract.cairo"
                        },
                        "start_col": 5,
                        "start_line": 158
                    }
                },
                "417": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.execute"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 36,
                            "offset": 40
                        },
                        "reference_ids": {
                            "__main__.execute.__fp__": 298,
                            "__main__.execute._address": 300,
                            "__main__.execute._current_nonce": 307,
                            "__main__.execute.calldata": 292,
                            "__main__.execute.calldata_len": 291,
                            "__main__.execute.ecdsa_ptr": 297,
                            "__main__.execute.nonce": 293,
                            "__main__.execute.pedersen_ptr": 302,
                            "__main__.execute.range_check_ptr": 306,
                            "__main__.execute.selector": 290,
                            "__main__.execute.syscall_ptr": 305,
                            "__main__.execute.to": 289
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 6,
                        "end_line": 165,
                        "input_file": {
                            "filename": "contract.cairo"
                        },
                        "start_col": 5,
                        "start_line": 158
                    }
                },
                "418": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.execute"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 36,
                            "offset": 40
                        },
                        "reference_ids": {
                            "__main__.execute.__fp__": 298,
                            "__main__.execute._address": 300,
                            "__main__.execute._current_nonce": 307,
                            "__main__.execute.calldata": 292,
                            "__main__.execute.calldata_len": 291,
                            "__main__.execute.ecdsa_ptr": 297,
                            "__main__.execute.nonce": 293,
                            "__main__.execute.pedersen_ptr": 302,
                            "__main__.execute.range_check_ptr": 306,
                            "__main__.execute.selector": 290,
                            "__main__.execute.syscall_ptr": 305,
                            "__main__.execute.to": 289
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 6,
                        "end_line": 165,
                        "input_file": {
                            "filename": "contract.cairo"
                        },
                        "start_col": 5,
                        "start_line": 158
                    }
                },
                "419": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.execute"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 36,
                            "offset": 40
                        },
                        "reference_ids": {
                            "__main__.execute.__fp__": 298,
                            "__main__.execute._address": 300,
                            "__main__.execute._current_nonce": 307,
                            "__main__.execute.calldata": 292,
                            "__main__.execute.calldata_len": 291,
                            "__main__.execute.ecdsa_ptr": 297,
                            "__main__.execute.nonce": 293,
                            "__main__.execute.pedersen_ptr": 302,
                            "__main__.execute.range_check_ptr": 306,
                            "__main__.execute.selector": 290,
                            "__main__.execute.syscall_ptr": 305,
                            "__main__.execute.to": 289
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 6,
                        "end_line": 165,
                        "input_file": {
                            "filename": "contract.cairo"
                        },
                        "start_col": 5,
                        "start_line": 158
                    }
                },
                "420": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.execute"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 36,
                            "offset": 40
                        },
                        "reference_ids": {
                            "__main__.execute.__fp__": 298,
                            "__main__.execute._address": 300,
                            "__main__.execute._current_nonce": 307,
                            "__main__.execute.calldata": 292,
                            "__main__.execute.calldata_len": 291,
                            "__main__.execute.ecdsa_ptr": 297,
                            "__main__.execute.nonce": 293,
                            "__main__.execute.pedersen_ptr": 302,
                            "__main__.execute.range_check_ptr": 306,
                            "__main__.execute.selector": 290,
                            "__main__.execute.syscall_ptr": 305,
                            "__main__.execute.to": 289
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 6,
                        "end_line": 165,
                        "input_file": {
                            "filename": "contract.cairo"
                        },
                        "start_col": 5,
                        "start_line": 158
                    }
                },
                "421": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.execute"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 36,
                            "offset": 40
                        },
                        "reference_ids": {
                            "__main__.execute.__fp__": 298,
                            "__main__.execute._address": 300,
                            "__main__.execute._current_nonce": 307,
                            "__main__.execute.calldata": 292,
                            "__main__.execute.calldata_len": 291,
                            "__main__.execute.ecdsa_ptr": 297,
                            "__main__.execute.message": 308,
                            "__main__.execute.nonce": 293,
                            "__main__.execute.pedersen_ptr": 302,
                            "__main__.execute.range_check_ptr": 306,
                            "__main__.execute.selector": 290,
                            "__main__.execute.syscall_ptr": 305,
                            "__main__.execute.to": 289
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 63,
                        "end_line": 13,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/current_nonce/decl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 48,
                                "end_line": 156,
                                "input_file": {
                                    "filename": "contract.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 46,
                                        "end_line": 186,
                                        "input_file": {
                                            "filename": "contract.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 40,
                                                "end_line": 168,
                                                "input_file": {
                                                    "filename": "contract.cairo"
                                                },
                                                "start_col": 18,
                                                "start_line": 168
                                            },
                                            "While trying to retrieve the implicit argument 'pedersen_ptr' in:"
                                        ],
                                        "start_col": 19,
                                        "start_line": 186
                                    },
                                    "While expanding the reference 'pedersen_ptr' in:"
                                ],
                                "start_col": 28,
                                "start_line": 156
                            },
                            "While trying to update the implicit return value 'pedersen_ptr' in:"
                        ],
                        "start_col": 36,
                        "start_line": 13
                    }
                },
                "422": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.execute"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 36,
                            "offset": 41
                        },
                        "reference_ids": {
                            "__main__.execute.__fp__": 298,
                            "__main__.execute._address": 300,
                            "__main__.execute._current_nonce": 307,
                            "__main__.execute.calldata": 292,
                            "__main__.execute.calldata_len": 291,
                            "__main__.execute.ecdsa_ptr": 297,
                            "__main__.execute.message": 308,
                            "__main__.execute.nonce": 293,
                            "__main__.execute.pedersen_ptr": 302,
                            "__main__.execute.range_check_ptr": 306,
                            "__main__.execute.selector": 290,
                            "__main__.execute.syscall_ptr": 305,
                            "__main__.execute.to": 289
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 18,
                        "end_line": 158,
                        "input_file": {
                            "filename": "contract.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 39,
                                "end_line": 168,
                                "input_file": {
                                    "filename": "contract.cairo"
                                },
                                "start_col": 32,
                                "start_line": 168
                            },
                            "While expanding the reference 'message' in:"
                        ],
                        "start_col": 11,
                        "start_line": 158
                    }
                },
                "424": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.execute"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 36,
                            "offset": 42
                        },
                        "reference_ids": {
                            "__main__.execute.__fp__": 298,
                            "__main__.execute._address": 300,
                            "__main__.execute._current_nonce": 307,
                            "__main__.execute.calldata": 292,
                            "__main__.execute.calldata_len": 291,
                            "__main__.execute.ecdsa_ptr": 297,
                            "__main__.execute.message": 308,
                            "__main__.execute.nonce": 293,
                            "__main__.execute.pedersen_ptr": 302,
                            "__main__.execute.range_check_ptr": 306,
                            "__main__.execute.selector": 290,
                            "__main__.execute.syscall_ptr": 305,
                            "__main__.execute.to": 289
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 40,
                        "end_line": 168,
                        "input_file": {
                            "filename": "contract.cairo"
                        },
                        "start_col": 18,
                        "start_line": 168
                    }
                },
                "426": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.execute"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 37,
                            "offset": 0
                        },
                        "reference_ids": {
                            "__main__.execute.__fp__": 298,
                            "__main__.execute._address": 300,
                            "__main__.execute._current_nonce": 307,
                            "__main__.execute.calldata": 292,
                            "__main__.execute.calldata_len": 291,
                            "__main__.execute.ecdsa_ptr": 297,
                            "__main__.execute.hash": 310,
                            "__main__.execute.message": 308,
                            "__main__.execute.nonce": 293,
                            "__main__.execute.pedersen_ptr": 309,
                            "__main__.execute.range_check_ptr": 306,
                            "__main__.execute.selector": 290,
                            "__main__.execute.syscall_ptr": 305,
                            "__main__.execute.to": 289
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 34,
                        "end_line": 13,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/current_nonce/decl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 48,
                                "end_line": 156,
                                "input_file": {
                                    "filename": "contract.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 34,
                                        "end_line": 13,
                                        "input_file": {
                                            "filename": "autogen/starknet/storage_var/current_nonce/decl.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 48,
                                                "end_line": 156,
                                                "input_file": {
                                                    "filename": "contract.cairo"
                                                },
                                                "parent_location": [
                                                    {
                                                        "end_col": 42,
                                                        "end_line": 173,
                                                        "input_file": {
                                                            "filename": "/Users/jakubptak/Library/Caches/pypoetry/virtualenvs/starkware-python-sdk-L_CLq0Mm-py3.7/lib/python3.7/site-packages/starkware/starknet/common/syscalls.cairo"
                                                        },
                                                        "parent_location": [
                                                            {
                                                                "end_col": 56,
                                                                "end_line": 169,
                                                                "input_file": {
                                                                    "filename": "contract.cairo"
                                                                },
                                                                "start_col": 38,
                                                                "start_line": 169
                                                            },
                                                            "While trying to retrieve the implicit argument 'syscall_ptr' in:"
                                                        ],
                                                        "start_col": 23,
                                                        "start_line": 173
                                                    },
                                                    "While expanding the reference 'syscall_ptr' in:"
                                                ],
                                                "start_col": 28,
                                                "start_line": 156
                                            },
                                            "While trying to update the implicit return value 'syscall_ptr' in:"
                                        ],
                                        "start_col": 15,
                                        "start_line": 13
                                    },
                                    "While auto generating local variable for 'syscall_ptr'."
                                ],
                                "start_col": 28,
                                "start_line": 156
                            },
                            "While trying to update the implicit return value 'syscall_ptr' in:"
                        ],
                        "start_col": 15,
                        "start_line": 13
                    }
                },
                "427": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.execute"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 37,
                            "offset": 1
                        },
                        "reference_ids": {
                            "__main__.execute.__fp__": 298,
                            "__main__.execute._address": 300,
                            "__main__.execute._current_nonce": 307,
                            "__main__.execute.calldata": 292,
                            "__main__.execute.calldata_len": 291,
                            "__main__.execute.ecdsa_ptr": 297,
                            "__main__.execute.hash": 310,
                            "__main__.execute.message": 308,
                            "__main__.execute.nonce": 293,
                            "__main__.execute.pedersen_ptr": 309,
                            "__main__.execute.range_check_ptr": 306,
                            "__main__.execute.selector": 290,
                            "__main__.execute.syscall_ptr": 305,
                            "__main__.execute.to": 289
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 56,
                        "end_line": 169,
                        "input_file": {
                            "filename": "contract.cairo"
                        },
                        "start_col": 38,
                        "start_line": 169
                    }
                },
                "429": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.execute"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 37,
                            "offset": 7
                        },
                        "reference_ids": {
                            "__main__.execute.__fp__": 298,
                            "__main__.execute._address": 300,
                            "__main__.execute._current_nonce": 307,
                            "__main__.execute.calldata": 292,
                            "__main__.execute.calldata_len": 291,
                            "__main__.execute.ecdsa_ptr": 297,
                            "__main__.execute.hash": 310,
                            "__main__.execute.message": 308,
                            "__main__.execute.nonce": 293,
                            "__main__.execute.pedersen_ptr": 309,
                            "__main__.execute.range_check_ptr": 306,
                            "__main__.execute.selector": 290,
                            "__main__.execute.signature": 313,
                            "__main__.execute.signature_len": 312,
                            "__main__.execute.syscall_ptr": 311,
                            "__main__.execute.to": 289
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 42,
                        "end_line": 173,
                        "input_file": {
                            "filename": "/Users/jakubptak/Library/Caches/pypoetry/virtualenvs/starkware-python-sdk-L_CLq0Mm-py3.7/lib/python3.7/site-packages/starkware/starknet/common/syscalls.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 56,
                                "end_line": 169,
                                "input_file": {
                                    "filename": "contract.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 28,
                                        "end_line": 113,
                                        "input_file": {
                                            "filename": "contract.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 55,
                                                "end_line": 170,
                                                "input_file": {
                                                    "filename": "contract.cairo"
                                                },
                                                "start_col": 5,
                                                "start_line": 170
                                            },
                                            "While trying to retrieve the implicit argument 'syscall_ptr' in:"
                                        ],
                                        "start_col": 9,
                                        "start_line": 113
                                    },
                                    "While expanding the reference 'syscall_ptr' in:"
                                ],
                                "start_col": 38,
                                "start_line": 169
                            },
                            "While trying to update the implicit return value 'syscall_ptr' in:"
                        ],
                        "start_col": 23,
                        "start_line": 173
                    }
                },
                "430": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.execute"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 37,
                            "offset": 8
                        },
                        "reference_ids": {
                            "__main__.execute.__fp__": 298,
                            "__main__.execute._address": 300,
                            "__main__.execute._current_nonce": 307,
                            "__main__.execute.calldata": 292,
                            "__main__.execute.calldata_len": 291,
                            "__main__.execute.ecdsa_ptr": 297,
                            "__main__.execute.hash": 310,
                            "__main__.execute.message": 308,
                            "__main__.execute.nonce": 293,
                            "__main__.execute.pedersen_ptr": 309,
                            "__main__.execute.range_check_ptr": 306,
                            "__main__.execute.selector": 290,
                            "__main__.execute.signature": 313,
                            "__main__.execute.signature_len": 312,
                            "__main__.execute.syscall_ptr": 311,
                            "__main__.execute.to": 289
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 46,
                        "end_line": 186,
                        "input_file": {
                            "filename": "contract.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 40,
                                "end_line": 168,
                                "input_file": {
                                    "filename": "contract.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 36,
                                        "end_line": 114,
                                        "input_file": {
                                            "filename": "contract.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 55,
                                                "end_line": 170,
                                                "input_file": {
                                                    "filename": "contract.cairo"
                                                },
                                                "start_col": 5,
                                                "start_line": 170
                                            },
                                            "While trying to retrieve the implicit argument 'pedersen_ptr' in:"
                                        ],
                                        "start_col": 9,
                                        "start_line": 114
                                    },
                                    "While expanding the reference 'pedersen_ptr' in:"
                                ],
                                "start_col": 18,
                                "start_line": 168
                            },
                            "While trying to update the implicit return value 'pedersen_ptr' in:"
                        ],
                        "start_col": 19,
                        "start_line": 186
                    }
                },
                "431": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.execute"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 37,
                            "offset": 9
                        },
                        "reference_ids": {
                            "__main__.execute.__fp__": 298,
                            "__main__.execute._address": 300,
                            "__main__.execute._current_nonce": 307,
                            "__main__.execute.calldata": 292,
                            "__main__.execute.calldata_len": 291,
                            "__main__.execute.ecdsa_ptr": 297,
                            "__main__.execute.hash": 310,
                            "__main__.execute.message": 308,
                            "__main__.execute.nonce": 293,
                            "__main__.execute.pedersen_ptr": 309,
                            "__main__.execute.range_check_ptr": 306,
                            "__main__.execute.selector": 290,
                            "__main__.execute.signature": 313,
                            "__main__.execute.signature_len": 312,
                            "__main__.execute.syscall_ptr": 311,
                            "__main__.execute.to": 289
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 80,
                        "end_line": 13,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/current_nonce/decl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 48,
                                "end_line": 156,
                                "input_file": {
                                    "filename": "contract.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 80,
                                        "end_line": 13,
                                        "input_file": {
                                            "filename": "autogen/starknet/storage_var/current_nonce/decl.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 48,
                                                "end_line": 156,
                                                "input_file": {
                                                    "filename": "contract.cairo"
                                                },
                                                "parent_location": [
                                                    {
                                                        "end_col": 24,
                                                        "end_line": 115,
                                                        "input_file": {
                                                            "filename": "contract.cairo"
                                                        },
                                                        "parent_location": [
                                                            {
                                                                "end_col": 55,
                                                                "end_line": 170,
                                                                "input_file": {
                                                                    "filename": "contract.cairo"
                                                                },
                                                                "start_col": 5,
                                                                "start_line": 170
                                                            },
                                                            "While trying to retrieve the implicit argument 'range_check_ptr' in:"
                                                        ],
                                                        "start_col": 9,
                                                        "start_line": 115
                                                    },
                                                    "While expanding the reference 'range_check_ptr' in:"
                                                ],
                                                "start_col": 28,
                                                "start_line": 156
                                            },
                                            "While trying to update the implicit return value 'range_check_ptr' in:"
                                        ],
                                        "start_col": 65,
                                        "start_line": 13
                                    },
                                    "While auto generating local variable for 'range_check_ptr'."
                                ],
                                "start_col": 28,
                                "start_line": 156
                            },
                            "While trying to update the implicit return value 'range_check_ptr' in:"
                        ],
                        "start_col": 65,
                        "start_line": 13
                    }
                },
                "432": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.execute"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 37,
                            "offset": 10
                        },
                        "reference_ids": {
                            "__main__.execute.__fp__": 298,
                            "__main__.execute._address": 300,
                            "__main__.execute._current_nonce": 307,
                            "__main__.execute.calldata": 292,
                            "__main__.execute.calldata_len": 291,
                            "__main__.execute.ecdsa_ptr": 297,
                            "__main__.execute.hash": 310,
                            "__main__.execute.message": 308,
                            "__main__.execute.nonce": 293,
                            "__main__.execute.pedersen_ptr": 309,
                            "__main__.execute.range_check_ptr": 306,
                            "__main__.execute.selector": 290,
                            "__main__.execute.signature": 313,
                            "__main__.execute.signature_len": 312,
                            "__main__.execute.syscall_ptr": 311,
                            "__main__.execute.to": 289
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 37,
                        "end_line": 144,
                        "input_file": {
                            "filename": "contract.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 37,
                                "end_line": 116,
                                "input_file": {
                                    "filename": "contract.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 55,
                                        "end_line": 170,
                                        "input_file": {
                                            "filename": "contract.cairo"
                                        },
                                        "start_col": 5,
                                        "start_line": 170
                                    },
                                    "While trying to retrieve the implicit argument 'ecdsa_ptr' in:"
                                ],
                                "start_col": 9,
                                "start_line": 116
                            },
                            "While expanding the reference 'ecdsa_ptr' in:"
                        ],
                        "start_col": 9,
                        "start_line": 144
                    }
                },
                "433": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.execute"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 37,
                            "offset": 11
                        },
                        "reference_ids": {
                            "__main__.execute.__fp__": 298,
                            "__main__.execute._address": 300,
                            "__main__.execute._current_nonce": 307,
                            "__main__.execute.calldata": 292,
                            "__main__.execute.calldata_len": 291,
                            "__main__.execute.ecdsa_ptr": 297,
                            "__main__.execute.hash": 310,
                            "__main__.execute.message": 308,
                            "__main__.execute.nonce": 293,
                            "__main__.execute.pedersen_ptr": 309,
                            "__main__.execute.range_check_ptr": 306,
                            "__main__.execute.selector": 290,
                            "__main__.execute.signature": 313,
                            "__main__.execute.signature_len": 312,
                            "__main__.execute.syscall_ptr": 311,
                            "__main__.execute.to": 289
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 14,
                        "end_line": 168,
                        "input_file": {
                            "filename": "contract.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 28,
                                "end_line": 170,
                                "input_file": {
                                    "filename": "contract.cairo"
                                },
                                "start_col": 24,
                                "start_line": 170
                            },
                            "While expanding the reference 'hash' in:"
                        ],
                        "start_col": 10,
                        "start_line": 168
                    }
                },
                "434": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.execute"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 37,
                            "offset": 12
                        },
                        "reference_ids": {
                            "__main__.execute.__fp__": 298,
                            "__main__.execute._address": 300,
                            "__main__.execute._current_nonce": 307,
                            "__main__.execute.calldata": 292,
                            "__main__.execute.calldata_len": 291,
                            "__main__.execute.ecdsa_ptr": 297,
                            "__main__.execute.hash": 310,
                            "__main__.execute.message": 308,
                            "__main__.execute.nonce": 293,
                            "__main__.execute.pedersen_ptr": 309,
                            "__main__.execute.range_check_ptr": 306,
                            "__main__.execute.selector": 290,
                            "__main__.execute.signature": 313,
                            "__main__.execute.signature_len": 312,
                            "__main__.execute.syscall_ptr": 311,
                            "__main__.execute.to": 289
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 23,
                        "end_line": 169,
                        "input_file": {
                            "filename": "contract.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 43,
                                "end_line": 170,
                                "input_file": {
                                    "filename": "contract.cairo"
                                },
                                "start_col": 30,
                                "start_line": 170
                            },
                            "While expanding the reference 'signature_len' in:"
                        ],
                        "start_col": 10,
                        "start_line": 169
                    }
                },
                "435": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.execute"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 37,
                            "offset": 13
                        },
                        "reference_ids": {
                            "__main__.execute.__fp__": 298,
                            "__main__.execute._address": 300,
                            "__main__.execute._current_nonce": 307,
                            "__main__.execute.calldata": 292,
                            "__main__.execute.calldata_len": 291,
                            "__main__.execute.ecdsa_ptr": 297,
                            "__main__.execute.hash": 310,
                            "__main__.execute.message": 308,
                            "__main__.execute.nonce": 293,
                            "__main__.execute.pedersen_ptr": 309,
                            "__main__.execute.range_check_ptr": 306,
                            "__main__.execute.selector": 290,
                            "__main__.execute.signature": 313,
                            "__main__.execute.signature_len": 312,
                            "__main__.execute.syscall_ptr": 311,
                            "__main__.execute.to": 289
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 34,
                        "end_line": 169,
                        "input_file": {
                            "filename": "contract.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 54,
                                "end_line": 170,
                                "input_file": {
                                    "filename": "contract.cairo"
                                },
                                "start_col": 45,
                                "start_line": 170
                            },
                            "While expanding the reference 'signature' in:"
                        ],
                        "start_col": 25,
                        "start_line": 169
                    }
                },
                "436": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.execute"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 37,
                            "offset": 14
                        },
                        "reference_ids": {
                            "__main__.execute.__fp__": 298,
                            "__main__.execute._address": 300,
                            "__main__.execute._current_nonce": 307,
                            "__main__.execute.calldata": 292,
                            "__main__.execute.calldata_len": 291,
                            "__main__.execute.ecdsa_ptr": 297,
                            "__main__.execute.hash": 310,
                            "__main__.execute.message": 308,
                            "__main__.execute.nonce": 293,
                            "__main__.execute.pedersen_ptr": 309,
                            "__main__.execute.range_check_ptr": 306,
                            "__main__.execute.selector": 290,
                            "__main__.execute.signature": 313,
                            "__main__.execute.signature_len": 312,
                            "__main__.execute.syscall_ptr": 311,
                            "__main__.execute.to": 289
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 55,
                        "end_line": 170,
                        "input_file": {
                            "filename": "contract.cairo"
                        },
                        "start_col": 5,
                        "start_line": 170
                    }
                },
                "438": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.execute"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 37,
                            "offset": 51
                        },
                        "reference_ids": {
                            "__main__.execute.__fp__": 298,
                            "__main__.execute._address": 300,
                            "__main__.execute._current_nonce": 307,
                            "__main__.execute.calldata": 292,
                            "__main__.execute.calldata_len": 291,
                            "__main__.execute.ecdsa_ptr": 317,
                            "__main__.execute.hash": 310,
                            "__main__.execute.message": 308,
                            "__main__.execute.nonce": 293,
                            "__main__.execute.pedersen_ptr": 315,
                            "__main__.execute.range_check_ptr": 316,
                            "__main__.execute.selector": 290,
                            "__main__.execute.signature": 313,
                            "__main__.execute.signature_len": 312,
                            "__main__.execute.syscall_ptr": 314,
                            "__main__.execute.to": 289
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 28,
                        "end_line": 113,
                        "input_file": {
                            "filename": "contract.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 55,
                                "end_line": 170,
                                "input_file": {
                                    "filename": "contract.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 35,
                                        "end_line": 19,
                                        "input_file": {
                                            "filename": "autogen/starknet/storage_var/current_nonce/decl.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 44,
                                                "end_line": 173,
                                                "input_file": {
                                                    "filename": "contract.cairo"
                                                },
                                                "start_col": 5,
                                                "start_line": 173
                                            },
                                            "While trying to retrieve the implicit argument 'syscall_ptr' in:"
                                        ],
                                        "start_col": 16,
                                        "start_line": 19
                                    },
                                    "While expanding the reference 'syscall_ptr' in:"
                                ],
                                "start_col": 5,
                                "start_line": 170
                            },
                            "While trying to update the implicit return value 'syscall_ptr' in:"
                        ],
                        "start_col": 9,
                        "start_line": 113
                    }
                },
                "439": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.execute"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 37,
                            "offset": 52
                        },
                        "reference_ids": {
                            "__main__.execute.__fp__": 298,
                            "__main__.execute._address": 300,
                            "__main__.execute._current_nonce": 307,
                            "__main__.execute.calldata": 292,
                            "__main__.execute.calldata_len": 291,
                            "__main__.execute.ecdsa_ptr": 317,
                            "__main__.execute.hash": 310,
                            "__main__.execute.message": 308,
                            "__main__.execute.nonce": 293,
                            "__main__.execute.pedersen_ptr": 315,
                            "__main__.execute.range_check_ptr": 316,
                            "__main__.execute.selector": 290,
                            "__main__.execute.signature": 313,
                            "__main__.execute.signature_len": 312,
                            "__main__.execute.syscall_ptr": 314,
                            "__main__.execute.to": 289
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 36,
                        "end_line": 114,
                        "input_file": {
                            "filename": "contract.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 55,
                                "end_line": 170,
                                "input_file": {
                                    "filename": "contract.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 64,
                                        "end_line": 19,
                                        "input_file": {
                                            "filename": "autogen/starknet/storage_var/current_nonce/decl.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 44,
                                                "end_line": 173,
                                                "input_file": {
                                                    "filename": "contract.cairo"
                                                },
                                                "start_col": 5,
                                                "start_line": 173
                                            },
                                            "While trying to retrieve the implicit argument 'pedersen_ptr' in:"
                                        ],
                                        "start_col": 37,
                                        "start_line": 19
                                    },
                                    "While expanding the reference 'pedersen_ptr' in:"
                                ],
                                "start_col": 5,
                                "start_line": 170
                            },
                            "While trying to update the implicit return value 'pedersen_ptr' in:"
                        ],
                        "start_col": 9,
                        "start_line": 114
                    }
                },
                "440": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.execute"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 37,
                            "offset": 53
                        },
                        "reference_ids": {
                            "__main__.execute.__fp__": 298,
                            "__main__.execute._address": 300,
                            "__main__.execute._current_nonce": 307,
                            "__main__.execute.calldata": 292,
                            "__main__.execute.calldata_len": 291,
                            "__main__.execute.ecdsa_ptr": 317,
                            "__main__.execute.hash": 310,
                            "__main__.execute.message": 308,
                            "__main__.execute.nonce": 293,
                            "__main__.execute.pedersen_ptr": 315,
                            "__main__.execute.range_check_ptr": 316,
                            "__main__.execute.selector": 290,
                            "__main__.execute.signature": 313,
                            "__main__.execute.signature_len": 312,
                            "__main__.execute.syscall_ptr": 314,
                            "__main__.execute.to": 289
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 24,
                        "end_line": 115,
                        "input_file": {
                            "filename": "contract.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 55,
                                "end_line": 170,
                                "input_file": {
                                    "filename": "contract.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 81,
                                        "end_line": 19,
                                        "input_file": {
                                            "filename": "autogen/starknet/storage_var/current_nonce/decl.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 44,
                                                "end_line": 173,
                                                "input_file": {
                                                    "filename": "contract.cairo"
                                                },
                                                "start_col": 5,
                                                "start_line": 173
                                            },
                                            "While trying to retrieve the implicit argument 'range_check_ptr' in:"
                                        ],
                                        "start_col": 66,
                                        "start_line": 19
                                    },
                                    "While expanding the reference 'range_check_ptr' in:"
                                ],
                                "start_col": 5,
                                "start_line": 170
                            },
                            "While trying to update the implicit return value 'range_check_ptr' in:"
                        ],
                        "start_col": 9,
                        "start_line": 115
                    }
                },
                "441": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.execute"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 37,
                            "offset": 54
                        },
                        "reference_ids": {
                            "__main__.execute.__fp__": 298,
                            "__main__.execute._address": 300,
                            "__main__.execute._current_nonce": 307,
                            "__main__.execute.calldata": 292,
                            "__main__.execute.calldata_len": 291,
                            "__main__.execute.ecdsa_ptr": 317,
                            "__main__.execute.hash": 310,
                            "__main__.execute.message": 308,
                            "__main__.execute.nonce": 293,
                            "__main__.execute.pedersen_ptr": 315,
                            "__main__.execute.range_check_ptr": 316,
                            "__main__.execute.selector": 290,
                            "__main__.execute.signature": 313,
                            "__main__.execute.signature_len": 312,
                            "__main__.execute.syscall_ptr": 314,
                            "__main__.execute.to": 289
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 43,
                        "end_line": 173,
                        "input_file": {
                            "filename": "contract.cairo"
                        },
                        "start_col": 25,
                        "start_line": 173
                    }
                },
                "443": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.execute"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 37,
                            "offset": 55
                        },
                        "reference_ids": {
                            "__main__.execute.__fp__": 298,
                            "__main__.execute._address": 300,
                            "__main__.execute._current_nonce": 307,
                            "__main__.execute.calldata": 292,
                            "__main__.execute.calldata_len": 291,
                            "__main__.execute.ecdsa_ptr": 317,
                            "__main__.execute.hash": 310,
                            "__main__.execute.message": 308,
                            "__main__.execute.nonce": 293,
                            "__main__.execute.pedersen_ptr": 315,
                            "__main__.execute.range_check_ptr": 316,
                            "__main__.execute.selector": 290,
                            "__main__.execute.signature": 313,
                            "__main__.execute.signature_len": 312,
                            "__main__.execute.syscall_ptr": 314,
                            "__main__.execute.to": 289
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 44,
                        "end_line": 173,
                        "input_file": {
                            "filename": "contract.cairo"
                        },
                        "start_col": 5,
                        "start_line": 173
                    }
                },
                "445": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.execute"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 37,
                            "offset": 73
                        },
                        "reference_ids": {
                            "__main__.execute.__fp__": 298,
                            "__main__.execute._address": 300,
                            "__main__.execute._current_nonce": 307,
                            "__main__.execute.calldata": 292,
                            "__main__.execute.calldata_len": 291,
                            "__main__.execute.ecdsa_ptr": 317,
                            "__main__.execute.hash": 310,
                            "__main__.execute.message": 308,
                            "__main__.execute.nonce": 293,
                            "__main__.execute.pedersen_ptr": 319,
                            "__main__.execute.range_check_ptr": 320,
                            "__main__.execute.selector": 290,
                            "__main__.execute.signature": 313,
                            "__main__.execute.signature_len": 312,
                            "__main__.execute.syscall_ptr": 318,
                            "__main__.execute.to": 289
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 35,
                        "end_line": 19,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/current_nonce/decl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 44,
                                "end_line": 173,
                                "input_file": {
                                    "filename": "contract.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 39,
                                        "end_line": 40,
                                        "input_file": {
                                            "filename": "/Users/jakubptak/Library/Caches/pypoetry/virtualenvs/starkware-python-sdk-L_CLq0Mm-py3.7/lib/python3.7/site-packages/starkware/starknet/common/syscalls.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 6,
                                                "end_line": 181,
                                                "input_file": {
                                                    "filename": "contract.cairo"
                                                },
                                                "start_col": 20,
                                                "start_line": 176
                                            },
                                            "While trying to retrieve the implicit argument 'syscall_ptr' in:"
                                        ],
                                        "start_col": 20,
                                        "start_line": 40
                                    },
                                    "While expanding the reference 'syscall_ptr' in:"
                                ],
                                "start_col": 5,
                                "start_line": 173
                            },
                            "While trying to update the implicit return value 'syscall_ptr' in:"
                        ],
                        "start_col": 16,
                        "start_line": 19
                    }
                },
                "446": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.execute"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 37,
                            "offset": 74
                        },
                        "reference_ids": {
                            "__main__.execute.__fp__": 298,
                            "__main__.execute._address": 300,
                            "__main__.execute._current_nonce": 307,
                            "__main__.execute.calldata": 292,
                            "__main__.execute.calldata_len": 291,
                            "__main__.execute.ecdsa_ptr": 317,
                            "__main__.execute.hash": 310,
                            "__main__.execute.message": 308,
                            "__main__.execute.nonce": 293,
                            "__main__.execute.pedersen_ptr": 319,
                            "__main__.execute.range_check_ptr": 320,
                            "__main__.execute.selector": 290,
                            "__main__.execute.signature": 313,
                            "__main__.execute.signature_len": 312,
                            "__main__.execute.syscall_ptr": 318,
                            "__main__.execute.to": 289
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 36,
                        "end_line": 177,
                        "input_file": {
                            "filename": "contract.cairo"
                        },
                        "start_col": 26,
                        "start_line": 177
                    }
                },
                "447": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.execute"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 37,
                            "offset": 75
                        },
                        "reference_ids": {
                            "__main__.execute.__fp__": 298,
                            "__main__.execute._address": 300,
                            "__main__.execute._current_nonce": 307,
                            "__main__.execute.calldata": 292,
                            "__main__.execute.calldata_len": 291,
                            "__main__.execute.ecdsa_ptr": 317,
                            "__main__.execute.hash": 310,
                            "__main__.execute.message": 308,
                            "__main__.execute.nonce": 293,
                            "__main__.execute.pedersen_ptr": 319,
                            "__main__.execute.range_check_ptr": 320,
                            "__main__.execute.selector": 290,
                            "__main__.execute.signature": 313,
                            "__main__.execute.signature_len": 312,
                            "__main__.execute.syscall_ptr": 318,
                            "__main__.execute.to": 289
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 43,
                        "end_line": 178,
                        "input_file": {
                            "filename": "contract.cairo"
                        },
                        "start_col": 27,
                        "start_line": 178
                    }
                },
                "448": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.execute"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 37,
                            "offset": 76
                        },
                        "reference_ids": {
                            "__main__.execute.__fp__": 298,
                            "__main__.execute._address": 300,
                            "__main__.execute._current_nonce": 307,
                            "__main__.execute.calldata": 292,
                            "__main__.execute.calldata_len": 291,
                            "__main__.execute.ecdsa_ptr": 317,
                            "__main__.execute.hash": 310,
                            "__main__.execute.message": 308,
                            "__main__.execute.nonce": 293,
                            "__main__.execute.pedersen_ptr": 319,
                            "__main__.execute.range_check_ptr": 320,
                            "__main__.execute.selector": 290,
                            "__main__.execute.signature": 313,
                            "__main__.execute.signature_len": 312,
                            "__main__.execute.syscall_ptr": 318,
                            "__main__.execute.to": 289
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 44,
                        "end_line": 179,
                        "input_file": {
                            "filename": "contract.cairo"
                        },
                        "start_col": 23,
                        "start_line": 179
                    }
                },
                "449": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.execute"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 37,
                            "offset": 77
                        },
                        "reference_ids": {
                            "__main__.execute.__fp__": 298,
                            "__main__.execute._address": 300,
                            "__main__.execute._current_nonce": 307,
                            "__main__.execute.calldata": 292,
                            "__main__.execute.calldata_len": 291,
                            "__main__.execute.ecdsa_ptr": 317,
                            "__main__.execute.hash": 310,
                            "__main__.execute.message": 308,
                            "__main__.execute.nonce": 293,
                            "__main__.execute.pedersen_ptr": 319,
                            "__main__.execute.range_check_ptr": 320,
                            "__main__.execute.selector": 290,
                            "__main__.execute.signature": 313,
                            "__main__.execute.signature_len": 312,
                            "__main__.execute.syscall_ptr": 318,
                            "__main__.execute.to": 289
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 34,
                        "end_line": 180,
                        "input_file": {
                            "filename": "contract.cairo"
                        },
                        "start_col": 18,
                        "start_line": 180
                    }
                },
                "450": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.execute"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 37,
                            "offset": 78
                        },
                        "reference_ids": {
                            "__main__.execute.__fp__": 298,
                            "__main__.execute._address": 300,
                            "__main__.execute._current_nonce": 307,
                            "__main__.execute.calldata": 292,
                            "__main__.execute.calldata_len": 291,
                            "__main__.execute.ecdsa_ptr": 317,
                            "__main__.execute.hash": 310,
                            "__main__.execute.message": 308,
                            "__main__.execute.nonce": 293,
                            "__main__.execute.pedersen_ptr": 319,
                            "__main__.execute.range_check_ptr": 320,
                            "__main__.execute.selector": 290,
                            "__main__.execute.signature": 313,
                            "__main__.execute.signature_len": 312,
                            "__main__.execute.syscall_ptr": 318,
                            "__main__.execute.to": 289
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 6,
                        "end_line": 181,
                        "input_file": {
                            "filename": "contract.cairo"
                        },
                        "start_col": 20,
                        "start_line": 176
                    }
                },
                "452": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.execute"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 37,
                            "offset": 84
                        },
                        "reference_ids": {
                            "__main__.execute.__fp__": 298,
                            "__main__.execute._address": 300,
                            "__main__.execute._current_nonce": 307,
                            "__main__.execute.calldata": 292,
                            "__main__.execute.calldata_len": 291,
                            "__main__.execute.ecdsa_ptr": 317,
                            "__main__.execute.hash": 310,
                            "__main__.execute.message": 308,
                            "__main__.execute.nonce": 293,
                            "__main__.execute.pedersen_ptr": 319,
                            "__main__.execute.range_check_ptr": 320,
                            "__main__.execute.response": 322,
                            "__main__.execute.selector": 290,
                            "__main__.execute.signature": 313,
                            "__main__.execute.signature_len": 312,
                            "__main__.execute.syscall_ptr": 321,
                            "__main__.execute.to": 289
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 39,
                        "end_line": 40,
                        "input_file": {
                            "filename": "/Users/jakubptak/Library/Caches/pypoetry/virtualenvs/starkware-python-sdk-L_CLq0Mm-py3.7/lib/python3.7/site-packages/starkware/starknet/common/syscalls.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 6,
                                "end_line": 181,
                                "input_file": {
                                    "filename": "contract.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 28,
                                        "end_line": 141,
                                        "input_file": {
                                            "filename": "contract.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 75,
                                                "end_line": 183,
                                                "input_file": {
                                                    "filename": "contract.cairo"
                                                },
                                                "start_col": 5,
                                                "start_line": 183
                                            },
                                            "While trying to retrieve the implicit argument 'syscall_ptr' in:"
                                        ],
                                        "start_col": 9,
                                        "start_line": 141
                                    },
                                    "While expanding the reference 'syscall_ptr' in:"
                                ],
                                "start_col": 20,
                                "start_line": 176
                            },
                            "While trying to update the implicit return value 'syscall_ptr' in:"
                        ],
                        "start_col": 20,
                        "start_line": 40
                    }
                },
                "453": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.execute"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 37,
                            "offset": 85
                        },
                        "reference_ids": {
                            "__main__.execute.__fp__": 298,
                            "__main__.execute._address": 300,
                            "__main__.execute._current_nonce": 307,
                            "__main__.execute.calldata": 292,
                            "__main__.execute.calldata_len": 291,
                            "__main__.execute.ecdsa_ptr": 317,
                            "__main__.execute.hash": 310,
                            "__main__.execute.message": 308,
                            "__main__.execute.nonce": 293,
                            "__main__.execute.pedersen_ptr": 319,
                            "__main__.execute.range_check_ptr": 320,
                            "__main__.execute.response": 322,
                            "__main__.execute.selector": 290,
                            "__main__.execute.signature": 313,
                            "__main__.execute.signature_len": 312,
                            "__main__.execute.syscall_ptr": 321,
                            "__main__.execute.to": 289
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 64,
                        "end_line": 19,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/current_nonce/decl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 44,
                                "end_line": 173,
                                "input_file": {
                                    "filename": "contract.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 36,
                                        "end_line": 142,
                                        "input_file": {
                                            "filename": "contract.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 75,
                                                "end_line": 183,
                                                "input_file": {
                                                    "filename": "contract.cairo"
                                                },
                                                "start_col": 5,
                                                "start_line": 183
                                            },
                                            "While trying to retrieve the implicit argument 'pedersen_ptr' in:"
                                        ],
                                        "start_col": 9,
                                        "start_line": 142
                                    },
                                    "While expanding the reference 'pedersen_ptr' in:"
                                ],
                                "start_col": 5,
                                "start_line": 173
                            },
                            "While trying to update the implicit return value 'pedersen_ptr' in:"
                        ],
                        "start_col": 37,
                        "start_line": 19
                    }
                },
                "454": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.execute"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 37,
                            "offset": 86
                        },
                        "reference_ids": {
                            "__main__.execute.__fp__": 298,
                            "__main__.execute._address": 300,
                            "__main__.execute._current_nonce": 307,
                            "__main__.execute.calldata": 292,
                            "__main__.execute.calldata_len": 291,
                            "__main__.execute.ecdsa_ptr": 317,
                            "__main__.execute.hash": 310,
                            "__main__.execute.message": 308,
                            "__main__.execute.nonce": 293,
                            "__main__.execute.pedersen_ptr": 319,
                            "__main__.execute.range_check_ptr": 320,
                            "__main__.execute.response": 322,
                            "__main__.execute.selector": 290,
                            "__main__.execute.signature": 313,
                            "__main__.execute.signature_len": 312,
                            "__main__.execute.syscall_ptr": 321,
                            "__main__.execute.to": 289
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 81,
                        "end_line": 19,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/current_nonce/decl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 44,
                                "end_line": 173,
                                "input_file": {
                                    "filename": "contract.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 24,
                                        "end_line": 143,
                                        "input_file": {
                                            "filename": "contract.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 75,
                                                "end_line": 183,
                                                "input_file": {
                                                    "filename": "contract.cairo"
                                                },
                                                "start_col": 5,
                                                "start_line": 183
                                            },
                                            "While trying to retrieve the implicit argument 'range_check_ptr' in:"
                                        ],
                                        "start_col": 9,
                                        "start_line": 143
                                    },
                                    "While expanding the reference 'range_check_ptr' in:"
                                ],
                                "start_col": 5,
                                "start_line": 173
                            },
                            "While trying to update the implicit return value 'range_check_ptr' in:"
                        ],
                        "start_col": 66,
                        "start_line": 19
                    }
                },
                "455": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.execute"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 37,
                            "offset": 87
                        },
                        "reference_ids": {
                            "__main__.execute.__fp__": 298,
                            "__main__.execute._address": 300,
                            "__main__.execute._current_nonce": 307,
                            "__main__.execute.calldata": 292,
                            "__main__.execute.calldata_len": 291,
                            "__main__.execute.ecdsa_ptr": 317,
                            "__main__.execute.hash": 310,
                            "__main__.execute.message": 308,
                            "__main__.execute.nonce": 293,
                            "__main__.execute.pedersen_ptr": 319,
                            "__main__.execute.range_check_ptr": 320,
                            "__main__.execute.response": 322,
                            "__main__.execute.selector": 290,
                            "__main__.execute.signature": 313,
                            "__main__.execute.signature_len": 312,
                            "__main__.execute.syscall_ptr": 321,
                            "__main__.execute.to": 289
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 37,
                        "end_line": 116,
                        "input_file": {
                            "filename": "contract.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 55,
                                "end_line": 170,
                                "input_file": {
                                    "filename": "contract.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 37,
                                        "end_line": 144,
                                        "input_file": {
                                            "filename": "contract.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 75,
                                                "end_line": 183,
                                                "input_file": {
                                                    "filename": "contract.cairo"
                                                },
                                                "start_col": 5,
                                                "start_line": 183
                                            },
                                            "While trying to retrieve the implicit argument 'ecdsa_ptr' in:"
                                        ],
                                        "start_col": 9,
                                        "start_line": 144
                                    },
                                    "While expanding the reference 'ecdsa_ptr' in:"
                                ],
                                "start_col": 5,
                                "start_line": 170
                            },
                            "While trying to update the implicit return value 'ecdsa_ptr' in:"
                        ],
                        "start_col": 9,
                        "start_line": 116
                    }
                },
                "456": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.execute"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 37,
                            "offset": 88
                        },
                        "reference_ids": {
                            "__main__.execute.__fp__": 298,
                            "__main__.execute._address": 300,
                            "__main__.execute._current_nonce": 307,
                            "__main__.execute.calldata": 292,
                            "__main__.execute.calldata_len": 291,
                            "__main__.execute.ecdsa_ptr": 317,
                            "__main__.execute.hash": 310,
                            "__main__.execute.message": 308,
                            "__main__.execute.nonce": 293,
                            "__main__.execute.pedersen_ptr": 319,
                            "__main__.execute.range_check_ptr": 320,
                            "__main__.execute.response": 322,
                            "__main__.execute.selector": 290,
                            "__main__.execute.signature": 313,
                            "__main__.execute.signature_len": 312,
                            "__main__.execute.syscall_ptr": 321,
                            "__main__.execute.to": 289
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 47,
                        "end_line": 183,
                        "input_file": {
                            "filename": "contract.cairo"
                        },
                        "start_col": 26,
                        "start_line": 183
                    }
                },
                "457": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.execute"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 37,
                            "offset": 89
                        },
                        "reference_ids": {
                            "__main__.execute.__fp__": 298,
                            "__main__.execute._address": 300,
                            "__main__.execute._current_nonce": 307,
                            "__main__.execute.calldata": 292,
                            "__main__.execute.calldata_len": 291,
                            "__main__.execute.ecdsa_ptr": 317,
                            "__main__.execute.hash": 310,
                            "__main__.execute.message": 308,
                            "__main__.execute.nonce": 293,
                            "__main__.execute.pedersen_ptr": 319,
                            "__main__.execute.range_check_ptr": 320,
                            "__main__.execute.response": 322,
                            "__main__.execute.selector": 290,
                            "__main__.execute.signature": 313,
                            "__main__.execute.signature_len": 312,
                            "__main__.execute.syscall_ptr": 321,
                            "__main__.execute.to": 289
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 74,
                        "end_line": 183,
                        "input_file": {
                            "filename": "contract.cairo"
                        },
                        "start_col": 58,
                        "start_line": 183
                    }
                },
                "458": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.execute"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 37,
                            "offset": 90
                        },
                        "reference_ids": {
                            "__main__.execute.__fp__": 298,
                            "__main__.execute._address": 300,
                            "__main__.execute._current_nonce": 307,
                            "__main__.execute.calldata": 292,
                            "__main__.execute.calldata_len": 291,
                            "__main__.execute.ecdsa_ptr": 317,
                            "__main__.execute.hash": 310,
                            "__main__.execute.message": 308,
                            "__main__.execute.nonce": 293,
                            "__main__.execute.pedersen_ptr": 319,
                            "__main__.execute.range_check_ptr": 320,
                            "__main__.execute.response": 322,
                            "__main__.execute.selector": 290,
                            "__main__.execute.signature": 313,
                            "__main__.execute.signature_len": 312,
                            "__main__.execute.syscall_ptr": 321,
                            "__main__.execute.to": 289
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 75,
                        "end_line": 183,
                        "input_file": {
                            "filename": "contract.cairo"
                        },
                        "start_col": 5,
                        "start_line": 183
                    }
                },
                "459": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.execute_encode_return"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 38,
                            "offset": 0
                        },
                        "reference_ids": {
                            "__wrappers__.execute_encode_return.range_check_ptr": 324,
                            "__wrappers__.execute_encode_return.ret_struct": 323
                        }
                    },
                    "hints": [
                        {
                            "location": {
                                "end_col": 38,
                                "end_line": 3,
                                "input_file": {
                                    "filename": "autogen/starknet/external/return/execute/a4f5dca2b4579e4581f985d9d59e09604642fde51b45dacead712101cac75905.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 13,
                                        "end_line": 140,
                                        "input_file": {
                                            "filename": "contract.cairo"
                                        },
                                        "start_col": 6,
                                        "start_line": 140
                                    },
                                    "While handling return value of"
                                ],
                                "start_col": 5,
                                "start_line": 3
                            },
                            "n_prefix_newlines": 0
                        }
                    ],
                    "inst": {
                        "end_col": 17,
                        "end_line": 4,
                        "input_file": {
                            "filename": "autogen/starknet/external/return/execute/a4f5dca2b4579e4581f985d9d59e09604642fde51b45dacead712101cac75905.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 13,
                                "end_line": 140,
                                "input_file": {
                                    "filename": "contract.cairo"
                                },
                                "start_col": 6,
                                "start_line": 140
                            },
                            "While handling return value of"
                        ],
                        "start_col": 5,
                        "start_line": 4
                    }
                },
                "461": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.execute_encode_return"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 38,
                            "offset": 3
                        },
                        "reference_ids": {
                            "__wrappers__.execute_encode_return.__return_value_ptr": 326,
                            "__wrappers__.execute_encode_return.__return_value_ptr_start": 325,
                            "__wrappers__.execute_encode_return.range_check_ptr": 324,
                            "__wrappers__.execute_encode_return.ret_struct": 323
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 54,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/arg_processor/8f57d6d152b155403dcead27a17163e42b24753da9c724f554705dcf260464c0.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 29,
                                "end_line": 151,
                                "input_file": {
                                    "filename": "contract.cairo"
                                },
                                "start_col": 11,
                                "start_line": 151
                            },
                            "While handling return value 'response_len'"
                        ],
                        "start_col": 1,
                        "start_line": 1
                    }
                },
                "462": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.execute_encode_return"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 38,
                            "offset": 3
                        },
                        "reference_ids": {
                            "__wrappers__.execute_encode_return.__return_value_ptr": 327,
                            "__wrappers__.execute_encode_return.__return_value_ptr_start": 325,
                            "__wrappers__.execute_encode_return.range_check_ptr": 324,
                            "__wrappers__.execute_encode_return.ret_struct": 323
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 51,
                        "end_line": 2,
                        "input_file": {
                            "filename": "autogen/starknet/arg_processor/06313d17544ae0a726cb5f49e1a4e01b179575674de70c8b96f6415eb6af6751.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 46,
                                "end_line": 151,
                                "input_file": {
                                    "filename": "contract.cairo"
                                },
                                "start_col": 31,
                                "start_line": 151
                            },
                            "While handling return value 'response'"
                        ],
                        "start_col": 1,
                        "start_line": 2
                    }
                },
                "463": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.execute_encode_return"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 38,
                            "offset": 3
                        },
                        "reference_ids": {
                            "__wrappers__.execute_encode_return.__return_value_ptr": 327,
                            "__wrappers__.execute_encode_return.__return_value_ptr_start": 325,
                            "__wrappers__.execute_encode_return.range_check_ptr": 324,
                            "__wrappers__.execute_encode_return.ret_struct": 323
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 44,
                        "end_line": 5,
                        "input_file": {
                            "filename": "autogen/starknet/arg_processor/06313d17544ae0a726cb5f49e1a4e01b179575674de70c8b96f6415eb6af6751.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 46,
                                "end_line": 151,
                                "input_file": {
                                    "filename": "contract.cairo"
                                },
                                "start_col": 31,
                                "start_line": 151
                            },
                            "While handling return value 'response'"
                        ],
                        "start_col": 1,
                        "start_line": 5
                    }
                },
                "465": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.execute_encode_return"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 38,
                            "offset": 3
                        },
                        "reference_ids": {
                            "__wrappers__.execute_encode_return.__return_value_ptr": 327,
                            "__wrappers__.execute_encode_return.__return_value_ptr_copy": 329,
                            "__wrappers__.execute_encode_return.__return_value_ptr_start": 325,
                            "__wrappers__.execute_encode_return.range_check_ptr": 328,
                            "__wrappers__.execute_encode_return.ret_struct": 323
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 48,
                        "end_line": 2,
                        "input_file": {
                            "filename": "autogen/starknet/arg_processor/8f57d6d152b155403dcead27a17163e42b24753da9c724f554705dcf260464c0.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 29,
                                "end_line": 151,
                                "input_file": {
                                    "filename": "contract.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 54,
                                        "end_line": 10,
                                        "input_file": {
                                            "filename": "autogen/starknet/arg_processor/06313d17544ae0a726cb5f49e1a4e01b179575674de70c8b96f6415eb6af6751.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 46,
                                                "end_line": 151,
                                                "input_file": {
                                                    "filename": "contract.cairo"
                                                },
                                                "start_col": 31,
                                                "start_line": 151
                                            },
                                            "While handling return value 'response'"
                                        ],
                                        "start_col": 36,
                                        "start_line": 10
                                    },
                                    "While expanding the reference '__return_value_ptr' in:"
                                ],
                                "start_col": 11,
                                "start_line": 151
                            },
                            "While handling return value 'response_len'"
                        ],
                        "start_col": 26,
                        "start_line": 2
                    }
                },
                "467": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.execute_encode_return"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 38,
                            "offset": 4
                        },
                        "reference_ids": {
                            "__wrappers__.execute_encode_return.__return_value_ptr": 327,
                            "__wrappers__.execute_encode_return.__return_value_ptr_copy": 329,
                            "__wrappers__.execute_encode_return.__return_value_ptr_start": 325,
                            "__wrappers__.execute_encode_return.__temp20": 330,
                            "__wrappers__.execute_encode_return.range_check_ptr": 328,
                            "__wrappers__.execute_encode_return.ret_struct": 323
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 80,
                        "end_line": 10,
                        "input_file": {
                            "filename": "autogen/starknet/arg_processor/06313d17544ae0a726cb5f49e1a4e01b179575674de70c8b96f6415eb6af6751.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 46,
                                "end_line": 151,
                                "input_file": {
                                    "filename": "contract.cairo"
                                },
                                "start_col": 31,
                                "start_line": 151
                            },
                            "While handling return value 'response'"
                        ],
                        "start_col": 1,
                        "start_line": 10
                    }
                },
                "468": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.execute_encode_return"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 38,
                            "offset": 4
                        },
                        "reference_ids": {
                            "__wrappers__.execute_encode_return.__return_value_ptr": 331,
                            "__wrappers__.execute_encode_return.__return_value_ptr_copy": 329,
                            "__wrappers__.execute_encode_return.__return_value_ptr_start": 325,
                            "__wrappers__.execute_encode_return.__temp20": 330,
                            "__wrappers__.execute_encode_return.range_check_ptr": 328,
                            "__wrappers__.execute_encode_return.ret_struct": 323
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 48,
                        "end_line": 2,
                        "input_file": {
                            "filename": "autogen/starknet/arg_processor/8f57d6d152b155403dcead27a17163e42b24753da9c724f554705dcf260464c0.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 29,
                                "end_line": 151,
                                "input_file": {
                                    "filename": "contract.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 49,
                                        "end_line": 7,
                                        "input_file": {
                                            "filename": "autogen/starknet/arg_processor/06313d17544ae0a726cb5f49e1a4e01b179575674de70c8b96f6415eb6af6751.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 46,
                                                "end_line": 151,
                                                "input_file": {
                                                    "filename": "contract.cairo"
                                                },
                                                "parent_location": [
                                                    {
                                                        "end_col": 32,
                                                        "end_line": 12,
                                                        "input_file": {
                                                            "filename": "autogen/starknet/arg_processor/06313d17544ae0a726cb5f49e1a4e01b179575674de70c8b96f6415eb6af6751.cairo"
                                                        },
                                                        "parent_location": [
                                                            {
                                                                "end_col": 46,
                                                                "end_line": 151,
                                                                "input_file": {
                                                                    "filename": "contract.cairo"
                                                                },
                                                                "start_col": 31,
                                                                "start_line": 151
                                                            },
                                                            "While handling return value 'response'"
                                                        ],
                                                        "start_col": 9,
                                                        "start_line": 12
                                                    },
                                                    "While expanding the reference '__return_value_ptr_copy' in:"
                                                ],
                                                "start_col": 31,
                                                "start_line": 151
                                            },
                                            "While handling return value 'response'"
                                        ],
                                        "start_col": 31,
                                        "start_line": 7
                                    },
                                    "While expanding the reference '__return_value_ptr' in:"
                                ],
                                "start_col": 11,
                                "start_line": 151
                            },
                            "While handling return value 'response_len'"
                        ],
                        "start_col": 26,
                        "start_line": 2
                    }
                },
                "470": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.execute_encode_return"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 38,
                            "offset": 5
                        },
                        "reference_ids": {
                            "__wrappers__.execute_encode_return.__return_value_ptr": 331,
                            "__wrappers__.execute_encode_return.__return_value_ptr_copy": 329,
                            "__wrappers__.execute_encode_return.__return_value_ptr_start": 325,
                            "__wrappers__.execute_encode_return.__temp20": 330,
                            "__wrappers__.execute_encode_return.range_check_ptr": 328,
                            "__wrappers__.execute_encode_return.ret_struct": 323
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 28,
                        "end_line": 13,
                        "input_file": {
                            "filename": "autogen/starknet/arg_processor/06313d17544ae0a726cb5f49e1a4e01b179575674de70c8b96f6415eb6af6751.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 46,
                                "end_line": 151,
                                "input_file": {
                                    "filename": "contract.cairo"
                                },
                                "start_col": 31,
                                "start_line": 151
                            },
                            "While handling return value 'response'"
                        ],
                        "start_col": 9,
                        "start_line": 13
                    }
                },
                "471": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.execute_encode_return"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 38,
                            "offset": 6
                        },
                        "reference_ids": {
                            "__wrappers__.execute_encode_return.__return_value_ptr": 331,
                            "__wrappers__.execute_encode_return.__return_value_ptr_copy": 329,
                            "__wrappers__.execute_encode_return.__return_value_ptr_start": 325,
                            "__wrappers__.execute_encode_return.__temp20": 330,
                            "__wrappers__.execute_encode_return.range_check_ptr": 328,
                            "__wrappers__.execute_encode_return.ret_struct": 323
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 32,
                        "end_line": 14,
                        "input_file": {
                            "filename": "autogen/starknet/arg_processor/06313d17544ae0a726cb5f49e1a4e01b179575674de70c8b96f6415eb6af6751.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 46,
                                "end_line": 151,
                                "input_file": {
                                    "filename": "contract.cairo"
                                },
                                "start_col": 31,
                                "start_line": 151
                            },
                            "While handling return value 'response'"
                        ],
                        "start_col": 9,
                        "start_line": 14
                    }
                },
                "472": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.execute_encode_return"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 38,
                            "offset": 7
                        },
                        "reference_ids": {
                            "__wrappers__.execute_encode_return.__return_value_ptr": 331,
                            "__wrappers__.execute_encode_return.__return_value_ptr_copy": 329,
                            "__wrappers__.execute_encode_return.__return_value_ptr_start": 325,
                            "__wrappers__.execute_encode_return.__temp20": 330,
                            "__wrappers__.execute_encode_return.range_check_ptr": 328,
                            "__wrappers__.execute_encode_return.ret_struct": 323
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 33,
                        "end_line": 14,
                        "input_file": {
                            "filename": "autogen/starknet/arg_processor/06313d17544ae0a726cb5f49e1a4e01b179575674de70c8b96f6415eb6af6751.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 46,
                                "end_line": 151,
                                "input_file": {
                                    "filename": "contract.cairo"
                                },
                                "start_col": 31,
                                "start_line": 151
                            },
                            "While handling return value 'response'"
                        ],
                        "start_col": 1,
                        "start_line": 11
                    }
                },
                "474": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.execute_encode_return"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 39,
                            "offset": 0
                        },
                        "reference_ids": {
                            "__wrappers__.execute_encode_return.__return_value_ptr": 331,
                            "__wrappers__.execute_encode_return.__return_value_ptr_copy": 329,
                            "__wrappers__.execute_encode_return.__return_value_ptr_start": 325,
                            "__wrappers__.execute_encode_return.__temp20": 330,
                            "__wrappers__.execute_encode_return.range_check_ptr": 328,
                            "__wrappers__.execute_encode_return.ret_struct": 323
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 22,
                        "end_line": 5,
                        "input_file": {
                            "filename": "autogen/starknet/arg_processor/06313d17544ae0a726cb5f49e1a4e01b179575674de70c8b96f6415eb6af6751.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 46,
                                "end_line": 151,
                                "input_file": {
                                    "filename": "contract.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 40,
                                        "end_line": 10,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/return/execute/a4f5dca2b4579e4581f985d9d59e09604642fde51b45dacead712101cac75905.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 13,
                                                "end_line": 140,
                                                "input_file": {
                                                    "filename": "contract.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 140
                                            },
                                            "While handling return value of"
                                        ],
                                        "start_col": 25,
                                        "start_line": 10
                                    },
                                    "While expanding the reference 'range_check_ptr' in:"
                                ],
                                "start_col": 31,
                                "start_line": 151
                            },
                            "While handling return value 'response'"
                        ],
                        "start_col": 7,
                        "start_line": 5
                    }
                },
                "475": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.execute_encode_return"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 39,
                            "offset": 1
                        },
                        "reference_ids": {
                            "__wrappers__.execute_encode_return.__return_value_ptr": 331,
                            "__wrappers__.execute_encode_return.__return_value_ptr_copy": 329,
                            "__wrappers__.execute_encode_return.__return_value_ptr_start": 325,
                            "__wrappers__.execute_encode_return.__temp20": 330,
                            "__wrappers__.execute_encode_return.range_check_ptr": 328,
                            "__wrappers__.execute_encode_return.ret_struct": 323
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 63,
                        "end_line": 11,
                        "input_file": {
                            "filename": "autogen/starknet/external/return/execute/a4f5dca2b4579e4581f985d9d59e09604642fde51b45dacead712101cac75905.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 13,
                                "end_line": 140,
                                "input_file": {
                                    "filename": "contract.cairo"
                                },
                                "start_col": 6,
                                "start_line": 140
                            },
                            "While handling return value of"
                        ],
                        "start_col": 18,
                        "start_line": 11
                    }
                },
                "476": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.execute_encode_return"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 39,
                            "offset": 2
                        },
                        "reference_ids": {
                            "__wrappers__.execute_encode_return.__return_value_ptr": 331,
                            "__wrappers__.execute_encode_return.__return_value_ptr_copy": 329,
                            "__wrappers__.execute_encode_return.__return_value_ptr_start": 325,
                            "__wrappers__.execute_encode_return.__temp20": 330,
                            "__wrappers__.execute_encode_return.range_check_ptr": 328,
                            "__wrappers__.execute_encode_return.ret_struct": 323
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 35,
                        "end_line": 5,
                        "input_file": {
                            "filename": "autogen/starknet/external/return/execute/a4f5dca2b4579e4581f985d9d59e09604642fde51b45dacead712101cac75905.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 13,
                                "end_line": 140,
                                "input_file": {
                                    "filename": "contract.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 38,
                                        "end_line": 12,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/return/execute/a4f5dca2b4579e4581f985d9d59e09604642fde51b45dacead712101cac75905.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 13,
                                                "end_line": 140,
                                                "input_file": {
                                                    "filename": "contract.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 140
                                            },
                                            "While handling return value of"
                                        ],
                                        "start_col": 14,
                                        "start_line": 12
                                    },
                                    "While expanding the reference '__return_value_ptr_start' in:"
                                ],
                                "start_col": 6,
                                "start_line": 140
                            },
                            "While handling return value of"
                        ],
                        "start_col": 11,
                        "start_line": 5
                    }
                },
                "477": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.execute_encode_return"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 39,
                            "offset": 3
                        },
                        "reference_ids": {
                            "__wrappers__.execute_encode_return.__return_value_ptr": 331,
                            "__wrappers__.execute_encode_return.__return_value_ptr_copy": 329,
                            "__wrappers__.execute_encode_return.__return_value_ptr_start": 325,
                            "__wrappers__.execute_encode_return.__temp20": 330,
                            "__wrappers__.execute_encode_return.range_check_ptr": 328,
                            "__wrappers__.execute_encode_return.ret_struct": 323
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 39,
                        "end_line": 12,
                        "input_file": {
                            "filename": "autogen/starknet/external/return/execute/a4f5dca2b4579e4581f985d9d59e09604642fde51b45dacead712101cac75905.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 13,
                                "end_line": 140,
                                "input_file": {
                                    "filename": "contract.cairo"
                                },
                                "start_col": 6,
                                "start_line": 140
                            },
                            "While handling return value of"
                        ],
                        "start_col": 5,
                        "start_line": 9
                    }
                },
                "478": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.execute"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 40,
                            "offset": 0
                        },
                        "reference_ids": {}
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 17,
                        "end_line": 2,
                        "input_file": {
                            "filename": "autogen/starknet/external/execute/9c7747fade26cf80efb5a8359f2fcb7685a792f19823051be7230b49471d1855.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 13,
                                "end_line": 140,
                                "input_file": {
                                    "filename": "contract.cairo"
                                },
                                "start_col": 6,
                                "start_line": 140
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 5,
                        "start_line": 2
                    }
                },
                "480": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.execute"
                    ],
                    "flow_tracking_data": {