"""A setuptools based setup module.

See:
https://packaging.python.org/en/latest/distributing.html
https://github.com/pypa/sampleproject
"""

# Always prefer setuptools over distutils
from setuptools import setup, find_packages
# To use a consistent encoding
from codecs import open
from os import path
import sys
import python_agent

here = path.abspath(path.dirname(__file__))

# Get the long description from the README file
with open(path.join(here, 'README.rst'), encoding='utf-8') as f:
    readme = f.read()

with open(path.join(here, 'CHANGES.rst'), encoding='utf-8') as f:
    changes = f.read()

with open(path.join(here, 'requirements.txt')) as f:
    requirements = f.read().splitlines()
    # python 3.3 use case where dependencies are read as bytes of the form b'APScheduler==3.0.6'
    requirements = [requirement.decode() if isinstance(requirement, bytes) else requirement for requirement in requirements]


setup(
    name=python_agent.__package_name__,

    # Versions should comply with PEP440.  For a discussion on single-sourcing
    # the version across setup.py and the project code, see
    # https://packaging.python.org/en/latest/single_source_version.html
    version=python_agent.__version__,

    description='Python Agent',
    long_description="\n\n".join([readme, changes]),

    # The project's main homepage.
    url='https://github.com/Sealights/SL.OnPremise.Agents.Python',

    # Author details
    author='Shai Cantor',
    author_email='shai@sealights.io',

    license="Other/Proprietary License",
    classifiers=[
        'Development Status :: 5 - Production/Stable',
        'Intended Audience :: Developers',
        'Topic :: Software Development :: Build Tools',
        "License :: Other/Proprietary License",
        'Programming Language :: Python :: 3.6',
        'Programming Language :: Python :: 3.7',
        'Programming Language :: Python :: 3.8',
        'Programming Language :: Python :: 3.9',
        'Programming Language :: Python :: 3.10',
    ],

    python_requires='>=3.6, <4',

    # What does your project relate to?
    keywords='sealights python agent setuptools development',

    # You can just specify the packages manually here if your project is
    # simple. Or you can use find_packages().
    packages=find_packages(exclude=['contrib', 'docs', '*tests*']),

    # Alternatively, if you want to distribute just a my_module.py, uncomment
    # this:
    #   py_modules=["my_module"],

    # List run-time dependencies here.  These will be installed by pip when
    # your project is installed. For an analysis of "install_requires" vs pip's
    # requirements files see:
    # https://packaging.python.org/en/latest/requirements.html
    install_requires=requirements,

    # List additional groups of dependencies here (e.g. development
    # dependencies). You can install these using the following syntax,
    # for example:
    # $ pip install -e .[dev,test]
    extras_require={
        'dev': ['check-manifest'],
        'test': ['coverage'],
    },

    # If there are data files included in your packages that need to be
    # installed, specify them here.  If using Python 2.6 or less, then these
    # have to be included in MANIFEST.in as well.
    # package_data={
    #     '': ['README.rst', 'requirements.txt', 'LICENSE.txt', 'python_agent/requests/LICENSE'],
    # },
    include_package_data=True,
    # To provide executable scripts, use entry points in preference to the
    # "scripts" keyword. Entry points provide cross-platform support and allow
    # pip to create the appropriate form of executable for the target platform.
    entry_points={
        'console_scripts': [
            'sealights-admin=python_agent.admin:cli',
            'sl-python=python_agent.admin:cli',
        ],
    },
)
