# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['visual_graph_datasets',
 'visual_graph_datasets.experiments',
 'visual_graph_datasets.experiments.generate_mock.debug',
 'visual_graph_datasets.generation',
 'visual_graph_datasets.visualization']

package_data = \
{'': ['*'],
 'visual_graph_datasets': ['templates/*'],
 'visual_graph_datasets.experiments.generate_mock.debug': ['mock/*']}

install_requires = \
['click>=7.1.2',
 'imageio>=2.22.4',
 'jinja2>=3.0.3',
 'matplotlib>=3.5.3',
 'networkx>=2.8.8',
 'numpy>=1.23.2',
 'orjson>=3.8.1',
 'poetry-bumpversion>=0.3.0',
 'psutil>=5.7.2',
 'pycomex>=0.6.1',
 'pytest>=7.2.0',
 'pyyaml>=0.6.0']

setup_kwargs = {
    'name': 'visual-graph-datasets',
    'version': '0.6.2',
    'description': 'Datasets for the training of graph neural networks (GNNs) and subsequent visualization of attributional explanations of XAI methods',
    'long_description': '|made-with-python| |python-version| |os-linux|\n\n.. |os-linux| image:: https://img.shields.io/badge/os-linux-orange.svg\n   :target: https://www.python.org/\n\n.. |python-version| image:: https://img.shields.io/badge/Python-3.8.0-green.svg\n   :target: https://www.python.org/\n\n.. |made-with-kgcnn| image:: https://img.shields.io/badge/Made%20with-KGCNN-blue.svg\n   :target: https://github.com/aimat-lab/gcnn_keras\n\n.. |made-with-python| image:: https://img.shields.io/badge/Made%20with-Python-1f425f.svg\n   :target: https://www.python.org/\n\n=====================\nVisual Graph Datasets\n=====================\n\nThis package provides the possibility to manage\na collection of datasets primarily for the training of graph neural networks.\nEach dataset is represented by one *folder*. Inside these folders each element of the dataset is\nrepresented by *two* files: (1) A metadata JSON file which contains the full graph representation as\nwell as additional metadata such as the canonical index, the target value to be predicted etc...\n(2) A PNG image file which shows a domain specific illustration of the graph\n(molecular graphs for chemical datasets as an example). These additional visualizations of each graph\ncan be used to easily visualize attributional graph XAI methods which assign importance values to each\nnode and edge of the original input graph.\n\nMotivation\n==========\n\nUsually datasets are packaged as compact as possible.\nAn example would be that chemical graph datasets are usually packaged as CSV files which only contain the\nindex a SMILES representation of the molecule and the target value, looking something like this:\n\n.. code-block:: csv\n\n    index, smiles, value\n    0, ccc, 0.24\n    1, ccc, 0.52\n    2, ccc, 1.77\n\n\nThis has the major advantage that even large datasets will have file sizes of only a few MB. These files are\neasy to download online and easy to store. The disadvantage however is that these files need to be processed\nto be usable to train graph neural networks (GNNs): The encoded SMILES representation first has to be\ntransformed into a graph representation where node and edge features have to be generated by some kind of\nchemical pre-processor. Instead of putting the major storage and bandwidth requirements on the user, this\nputs the major processing requirements on the user. Additionally, this method places a greater burden on the\nvisualization step of generated explanations.\n\nUltimately we decided to rather put the burden of downloading larger amounts of data on the user a\nsingle time in exchange of simplifying and reducing the burden of pre-processing and\ndata visualization for *each* training process.\n\nAdditionally, by distributing both canonical indexing and canonical visualizations we aim to make\nexplanation results more comparable in the future.\n\nInstallation\n============\n\nFirst clone this repository:\n\n.. code-block:: console\n\n    git clone https://github/username/visual_graph_datasets.git\n\nThen install it like this:\n\n.. code-block:: console\n\n    cd visual_graph_datasets\n    pip3 install -e .\n\n\nDownload datasets\n-----------------\n\n    **NOTE**: We *strongly* encourage to store datasets on an SSD instead of an HDD, as this can make a\n    difference of multiple hours(!) when loading especially large datasets.\n\nDatasets can simply be downloaded by name by using the ``download`` command:\n\n.. code-block:: console\n\n    // Example for the dataset \'rb_dual_motifs\'\n    python3 -m visual_graph_datasets.cli download "rb_dual_motifs"\n\nBy default this dataset will be downloaded into the folder ``$HOME/.visual_graph_datasets/datasets``\nwhere HOME is the current users home directory.\n\nThe dataset download destination can be changed in a config file by using the ``config`` command:\n\n.. code-block:: console\n\n    python3 -m visual_graph_datasets.cli config\n\nThis command will open the config file at ``$HOME/.visual_graph_datasets/config.yaml`` using the systems\ndefault text editor.\n\nList available datasets\n-----------------------\n\nYou can display a list of all the currently available datasets of the current remote file share provider\nand some metadata information about them by using the command ``list``:\n\n.. code-block:: console\n\n    python3 -m visual_graph_datasets.cli list\n\nRunning the unittests\n---------------------\n\nAfter installation you can optionally run the unitests to confirm that all datasets have been correctly\ndownloaded and that everything works properly:\n\n.. code-block:: console\n\n    cd visual_graph_datasets\n    pytest ./tests/*\n\nUsage\n=====\n\nThe datasets are mainly intended to be used in combination with other packages, but this package provides\nsome basic utilities to load and explore the datasets themselves within python programs.\n\n.. code-block:: python\n\n    from visual_graph_datasets.config import Config\n    from visual_graph_datasets.data import load_visual_graph_dataset\n\n    # The function only needs the absolute path to the dataset folder and will load all the entire datasets\n    # from all the files within that folder.\n    # The function returns two dictionaries. The first maps the string names of the elements to the content\n    # dictionaries and the second dict maps the integer indices of the elements to the very same content\n    # dictionaries. Two separate dictionaries are returned to provide different ways of accessing the data\n    # of the elements which are needed in different situations.\n    dataset_path = os.path.join(Config().get_datasets_path(), \'rb_dual_motifs\')\n    data_name_map, data_index_map = load_visual_graph_dataset(dataset_path)\n\nOne such content dictionary which are the values of the two dicts returned by the function have the\nfollowing nested dictionary structure:\n\n- ``image_path``: The absolute path to the image file that visualizes this element\n- ``metadata_path``: the absolute path to the metadata file\n- ``metadata``: A dict which contains all the metadata for that element\n    - ``value``: The target value for the element, which can be a single value (usually with regression) or\n      a one-hot vector for classification.\n    - ``index``: The canonical index of this element within the dataset\n    - (``split``): If defined, either "train" or "test" - assignment for the canonical train test split\n    - ``graph``: A dictionary which contains the entire graph representation of this element.\n        - ``node_attributes``: tensor of shape (V, N)\n        - ``edge_attributes``: tensor of shape (E, M)\n        - ``edge_indices``: tensor of shape (E, 2) which are the tuples of integer node indices that\n          determine edges\n        - ``node_coordinates`` tensor of shape (V, 2) which are the xy positions of each node in pixel\n          values within the corresponding image visualization of the element. This is the crucial\n          information which is required to use the existing image representations to visualize attributional\n          explanations!\n\nWith the following variable definitions:\n\n- V - the number of nodes in a graph\n- E - the number of edges in a graph\n- N - the number of node attributes / features associated with each node\n- M - the number of edge attributes / features associated with each edge\n\n\nDatasets\n========\n\nHere is a list of the datasets currently included.\n\nFor more information about the individual datasets use the ``list`` command in the CLI (see above).\n\n* rb_dual_motifs\n* tadf\n\n',
    'author': 'awa59kst120df',
    'author_email': 'awa59kst120df@gmail.com',
    'maintainer': 'awa59kst120df',
    'maintainer_email': 'awa59kst120df@gmail.com',
    'url': 'None',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.8',
}


setup(**setup_kwargs)
