"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.WafwebaclToAppsync = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 *  Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
// Imports
const waf = require("aws-cdk-lib/aws-wafv2");
const defaults = require("@aws-solutions-constructs/core");
// Note: To ensure CDKv2 compatibility, keep the import statement for Construct separate
const constructs_1 = require("constructs");
/**
 * @summary The WafwebaclToAppsync class.
 */
class WafwebaclToAppsync extends constructs_1.Construct {
    /**
     * @summary Constructs a new instance of the WafwebaclToAppsync class.
     * @param {cdk.App} scope - represents the scope for all the resources.
     * @param {string} id - this is a a scope-unique id.
     * @param {WafwebaclToAppsyncProps} props - user provided props for the construct.
     * @access public
     */
    constructor(scope, id, props) {
        super(scope, id);
        defaults.CheckProps(props);
        // Build the Web ACL
        this.webacl = defaults.buildWebacl(this, "REGIONAL", {
            existingWebaclObj: props.existingWebaclObj,
            webaclProps: props.webaclProps,
        });
        // Setup the Web ACL Association
        new waf.CfnWebACLAssociation(scope, `${id}-WebACLAssociation`, {
            webAclArn: this.webacl.attrArn,
            resourceArn: props.existingAppsyncApi.attrArn,
        });
        this.appsyncApi = props.existingAppsyncApi;
    }
}
exports.WafwebaclToAppsync = WafwebaclToAppsync;
_a = JSII_RTTI_SYMBOL_1;
WafwebaclToAppsync[_a] = { fqn: "@aws-solutions-constructs/aws-wafwebacl-appsync.WafwebaclToAppsync", version: "2.35.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW5kZXguanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJpbmRleC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7OztBQUFBOzs7Ozs7Ozs7OztHQVdHO0FBRUgsVUFBVTtBQUNWLDZDQUE2QztBQUU3QywyREFBMkQ7QUFDM0Qsd0ZBQXdGO0FBQ3hGLDJDQUF1QztBQXNCdkM7O0dBRUc7QUFDSCxNQUFhLGtCQUFtQixTQUFRLHNCQUFTO0lBRy9DOzs7Ozs7T0FNRztJQUNILFlBQVksS0FBZ0IsRUFBRSxFQUFVLEVBQUUsS0FBOEI7UUFDdEUsS0FBSyxDQUFDLEtBQUssRUFBRSxFQUFFLENBQUMsQ0FBQztRQUNqQixRQUFRLENBQUMsVUFBVSxDQUFDLEtBQUssQ0FBQyxDQUFDO1FBRTNCLG9CQUFvQjtRQUNwQixJQUFJLENBQUMsTUFBTSxHQUFHLFFBQVEsQ0FBQyxXQUFXLENBQUMsSUFBSSxFQUFFLFVBQVUsRUFBRTtZQUNuRCxpQkFBaUIsRUFBRSxLQUFLLENBQUMsaUJBQWlCO1lBQzFDLFdBQVcsRUFBRSxLQUFLLENBQUMsV0FBVztTQUMvQixDQUFDLENBQUM7UUFFSCxnQ0FBZ0M7UUFDaEMsSUFBSSxHQUFHLENBQUMsb0JBQW9CLENBQUMsS0FBSyxFQUFFLEdBQUcsRUFBRSxvQkFBb0IsRUFBRTtZQUM3RCxTQUFTLEVBQUUsSUFBSSxDQUFDLE1BQU0sQ0FBQyxPQUFPO1lBQzlCLFdBQVcsRUFBRSxLQUFLLENBQUMsa0JBQWtCLENBQUMsT0FBTztTQUM5QyxDQUFDLENBQUM7UUFFSCxJQUFJLENBQUMsVUFBVSxHQUFHLEtBQUssQ0FBQyxrQkFBa0IsQ0FBQztJQUM3QyxDQUFDOztBQTNCSCxnREE0QkMiLCJzb3VyY2VzQ29udGVudCI6WyIvKipcbiAqICBDb3B5cmlnaHQgQW1hem9uLmNvbSwgSW5jLiBvciBpdHMgYWZmaWxpYXRlcy4gQWxsIFJpZ2h0cyBSZXNlcnZlZC5cbiAqXG4gKiAgTGljZW5zZWQgdW5kZXIgdGhlIEFwYWNoZSBMaWNlbnNlLCBWZXJzaW9uIDIuMCAodGhlIFwiTGljZW5zZVwiKS4gWW91IG1heSBub3QgdXNlIHRoaXMgZmlsZSBleGNlcHQgaW4gY29tcGxpYW5jZVxuICogIHdpdGggdGhlIExpY2Vuc2UuIEEgY29weSBvZiB0aGUgTGljZW5zZSBpcyBsb2NhdGVkIGF0XG4gKlxuICogICAgICBodHRwOi8vd3d3LmFwYWNoZS5vcmcvbGljZW5zZXMvTElDRU5TRS0yLjBcbiAqXG4gKiAgb3IgaW4gdGhlICdsaWNlbnNlJyBmaWxlIGFjY29tcGFueWluZyB0aGlzIGZpbGUuIFRoaXMgZmlsZSBpcyBkaXN0cmlidXRlZCBvbiBhbiAnQVMgSVMnIEJBU0lTLCBXSVRIT1VUIFdBUlJBTlRJRVNcbiAqICBPUiBDT05ESVRJT05TIE9GIEFOWSBLSU5ELCBleHByZXNzIG9yIGltcGxpZWQuIFNlZSB0aGUgTGljZW5zZSBmb3IgdGhlIHNwZWNpZmljIGxhbmd1YWdlIGdvdmVybmluZyBwZXJtaXNzaW9uc1xuICogIGFuZCBsaW1pdGF0aW9ucyB1bmRlciB0aGUgTGljZW5zZS5cbiAqL1xuXG4vLyBJbXBvcnRzXG5pbXBvcnQgKiBhcyB3YWYgZnJvbSBcImF3cy1jZGstbGliL2F3cy13YWZ2MlwiO1xuaW1wb3J0ICogYXMgYXBwc3luYyBmcm9tIFwiYXdzLWNkay1saWIvYXdzLWFwcHN5bmNcIjtcbmltcG9ydCAqIGFzIGRlZmF1bHRzIGZyb20gXCJAYXdzLXNvbHV0aW9ucy1jb25zdHJ1Y3RzL2NvcmVcIjtcbi8vIE5vdGU6IFRvIGVuc3VyZSBDREt2MiBjb21wYXRpYmlsaXR5LCBrZWVwIHRoZSBpbXBvcnQgc3RhdGVtZW50IGZvciBDb25zdHJ1Y3Qgc2VwYXJhdGVcbmltcG9ydCB7IENvbnN0cnVjdCB9IGZyb20gXCJjb25zdHJ1Y3RzXCI7XG5cbi8qKlxuICogQHN1bW1hcnkgVGhlIHByb3BlcnRpZXMgZm9yIHRoZSBXYWZ3ZWJhY2xUb0FwcHN5bmMgY2xhc3MuXG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgV2Fmd2ViYWNsVG9BcHBzeW5jUHJvcHMge1xuICAvKipcbiAgICogVGhlIGV4aXN0aW5nIEFwcHN5bmMgQVBJIHRoYXQgd2lsbCBiZSBwcm90ZWN0ZWQgd2l0aCB0aGUgV0FGIHdlYiBBQ0wuXG4gICAqL1xuICByZWFkb25seSBleGlzdGluZ0FwcHN5bmNBcGk6IGFwcHN5bmMuQ2ZuR3JhcGhRTEFwaTtcbiAgLyoqXG4gICAqIEV4aXN0aW5nIGluc3RhbmNlIG9mIGEgV0FGIHdlYiBBQ0wsIGFuIGVycm9yIHdpbGwgb2NjdXIgaWYgdGhpcyBhbmQgcHJvcHMgaXMgc2V0XG4gICAqL1xuICByZWFkb25seSBleGlzdGluZ1dlYmFjbE9iaj86IHdhZi5DZm5XZWJBQ0w7XG4gIC8qKlxuICAgKiBPcHRpb25hbCB1c2VyLXByb3ZpZGVkIHByb3BzIHRvIG92ZXJyaWRlIHRoZSBkZWZhdWx0IHByb3BzIGZvciB0aGUgQVdTIFdBRiB3ZWIgQUNMLlxuICAgKlxuICAgKiBAZGVmYXVsdCAtIERlZmF1bHQgcHJvcGVydGllcyBhcmUgdXNlZC5cbiAgICovXG4gIHJlYWRvbmx5IHdlYmFjbFByb3BzPzogd2FmLkNmbldlYkFDTFByb3BzO1xufVxuXG4vKipcbiAqIEBzdW1tYXJ5IFRoZSBXYWZ3ZWJhY2xUb0FwcHN5bmMgY2xhc3MuXG4gKi9cbmV4cG9ydCBjbGFzcyBXYWZ3ZWJhY2xUb0FwcHN5bmMgZXh0ZW5kcyBDb25zdHJ1Y3Qge1xuICBwdWJsaWMgcmVhZG9ubHkgd2ViYWNsOiB3YWYuQ2ZuV2ViQUNMO1xuICBwdWJsaWMgcmVhZG9ubHkgYXBwc3luY0FwaTogYXBwc3luYy5DZm5HcmFwaFFMQXBpO1xuICAvKipcbiAgICogQHN1bW1hcnkgQ29uc3RydWN0cyBhIG5ldyBpbnN0YW5jZSBvZiB0aGUgV2Fmd2ViYWNsVG9BcHBzeW5jIGNsYXNzLlxuICAgKiBAcGFyYW0ge2Nkay5BcHB9IHNjb3BlIC0gcmVwcmVzZW50cyB0aGUgc2NvcGUgZm9yIGFsbCB0aGUgcmVzb3VyY2VzLlxuICAgKiBAcGFyYW0ge3N0cmluZ30gaWQgLSB0aGlzIGlzIGEgYSBzY29wZS11bmlxdWUgaWQuXG4gICAqIEBwYXJhbSB7V2Fmd2ViYWNsVG9BcHBzeW5jUHJvcHN9IHByb3BzIC0gdXNlciBwcm92aWRlZCBwcm9wcyBmb3IgdGhlIGNvbnN0cnVjdC5cbiAgICogQGFjY2VzcyBwdWJsaWNcbiAgICovXG4gIGNvbnN0cnVjdG9yKHNjb3BlOiBDb25zdHJ1Y3QsIGlkOiBzdHJpbmcsIHByb3BzOiBXYWZ3ZWJhY2xUb0FwcHN5bmNQcm9wcykge1xuICAgIHN1cGVyKHNjb3BlLCBpZCk7XG4gICAgZGVmYXVsdHMuQ2hlY2tQcm9wcyhwcm9wcyk7XG5cbiAgICAvLyBCdWlsZCB0aGUgV2ViIEFDTFxuICAgIHRoaXMud2ViYWNsID0gZGVmYXVsdHMuYnVpbGRXZWJhY2wodGhpcywgXCJSRUdJT05BTFwiLCB7XG4gICAgICBleGlzdGluZ1dlYmFjbE9iajogcHJvcHMuZXhpc3RpbmdXZWJhY2xPYmosXG4gICAgICB3ZWJhY2xQcm9wczogcHJvcHMud2ViYWNsUHJvcHMsXG4gICAgfSk7XG5cbiAgICAvLyBTZXR1cCB0aGUgV2ViIEFDTCBBc3NvY2lhdGlvblxuICAgIG5ldyB3YWYuQ2ZuV2ViQUNMQXNzb2NpYXRpb24oc2NvcGUsIGAke2lkfS1XZWJBQ0xBc3NvY2lhdGlvbmAsIHtcbiAgICAgIHdlYkFjbEFybjogdGhpcy53ZWJhY2wuYXR0ckFybixcbiAgICAgIHJlc291cmNlQXJuOiBwcm9wcy5leGlzdGluZ0FwcHN5bmNBcGkuYXR0ckFybixcbiAgICB9KTtcblxuICAgIHRoaXMuYXBwc3luY0FwaSA9IHByb3BzLmV4aXN0aW5nQXBwc3luY0FwaTtcbiAgfVxufVxuIl19