"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.PDKPipelineTsProject = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0
const path = require("path");
const projen_1 = require("projen");
const awscdk_1 = require("projen/lib/awscdk");
/**
 * Synthesizes a Typescript Project with a CI/CD pipeline.
 *
 * @pjid pdk-pipeline-ts
 */
class PDKPipelineTsProject extends awscdk_1.AwsCdkTypeScriptApp {
    constructor(options) {
        super({
            github: false,
            package: false,
            prettier: true,
            projenrcTs: true,
            release: false,
            sampleCode: false,
            ...options,
        });
        new projen_1.SampleDir(this, this.srcdir, {
            sourceDir: path.join(__dirname, "..", "..", "..", "samples", "sample-pdk-pipeline-ts", "src"),
        });
        new projen_1.SampleDir(this, this.testdir, {
            sourceDir: path.join(__dirname, "..", "..", "..", "samples", "sample-pdk-pipeline-ts", "test"),
        });
    }
}
exports.PDKPipelineTsProject = PDKPipelineTsProject;
_a = JSII_RTTI_SYMBOL_1;
PDKPipelineTsProject[_a] = { fqn: "aws-prototyping-sdk.pdk_projen.PDKPipelineTsProject", version: "0.0.51" };
//# sourceMappingURL=data:application/json;base64,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