from ml.ml40.features.properties.values.value import Value


class TreeType(Value):
    def __init__(self, name="", identifier=""):
        super().__init__(
            name=name,
            identifier=identifier)
        self.__conifer = None
        self.__json_out = dict()

    @property
    def conifer(self):
        return self.__conifer

    @conifer.setter
    def conifer(self, value):
        self.__conifer = value

    def to_json(self):
        self.__json_out = super().to_json()
        if self.conifer is not None:
            self.__json_out["conifer"] = self.conifer
        return self.__json_out
