from typing import Any

from .. import log
from .interfaces import Connectable as Connectable, ExceptionContext
from .util import TransactionalContext

class Connection(Connectable):
    engine: Any
    dialect: Any
    should_close_with_result: bool
    dispatch: Any
    def __init__(
        self,
        engine,
        connection: Any | None = ...,
        close_with_result: bool = ...,
        _branch_from: Any | None = ...,
        _execution_options: Any | None = ...,
        _dispatch: Any | None = ...,
        _has_events: Any | None = ...,
        _allow_revalidate: bool = ...,
    ) -> None: ...
    def schema_for_object(self, obj): ...
    def __enter__(self): ...
    def __exit__(self, type_, value, traceback) -> None: ...
    def execution_options(self, **opt): ...
    def get_execution_options(self): ...
    @property
    def closed(self): ...
    @property
    def invalidated(self): ...
    @property
    def connection(self): ...
    def get_isolation_level(self): ...
    @property
    def default_isolation_level(self): ...
    @property
    def info(self): ...
    def connect(self, close_with_result: bool = ...): ...  # type: ignore[override]
    def invalidate(self, exception: Any | None = ...): ...
    def detach(self) -> None: ...
    def begin(self): ...
    def begin_nested(self): ...
    def begin_twophase(self, xid: Any | None = ...): ...
    def recover_twophase(self): ...
    def rollback_prepared(self, xid, recover: bool = ...) -> None: ...
    def commit_prepared(self, xid, recover: bool = ...) -> None: ...
    def in_transaction(self): ...
    def in_nested_transaction(self): ...
    def get_transaction(self): ...
    def get_nested_transaction(self): ...
    def close(self) -> None: ...
    def scalar(self, object_, *multiparams, **params): ...
    def scalars(self, object_, *multiparams, **params): ...
    def execute(self, statement, *multiparams, **params): ...
    def exec_driver_sql(self, statement, parameters: Any | None = ..., execution_options: Any | None = ...): ...
    def transaction(self, callable_, *args, **kwargs): ...
    def run_callable(self, callable_, *args, **kwargs): ...

class ExceptionContextImpl(ExceptionContext):
    engine: Any
    connection: Any
    sqlalchemy_exception: Any
    original_exception: Any
    execution_context: Any
    statement: Any
    parameters: Any
    is_disconnect: Any
    invalidate_pool_on_disconnect: Any
    def __init__(
        self,
        exception,
        sqlalchemy_exception,
        engine,
        connection,
        cursor,
        statement,
        parameters,
        context,
        is_disconnect,
        invalidate_pool_on_disconnect,
    ) -> None: ...

class Transaction(TransactionalContext):
    def __init__(self, connection) -> None: ...
    @property
    def is_valid(self): ...
    def close(self) -> None: ...
    def rollback(self) -> None: ...
    def commit(self) -> None: ...

class MarkerTransaction(Transaction):
    connection: Any
    def __init__(self, connection) -> None: ...
    @property
    def is_active(self): ...

class RootTransaction(Transaction):
    connection: Any
    is_active: bool
    def __init__(self, connection) -> None: ...

class NestedTransaction(Transaction):
    connection: Any
    is_active: bool
    def __init__(self, connection) -> None: ...

class TwoPhaseTransaction(RootTransaction):
    xid: Any
    def __init__(self, connection, xid) -> None: ...
    def prepare(self) -> None: ...

class Engine(Connectable, log.Identified):
    pool: Any
    url: Any
    dialect: Any
    logging_name: Any
    echo: Any
    hide_parameters: Any
    def __init__(
        self,
        pool,
        dialect,
        url,
        logging_name: Any | None = ...,
        echo: Any | None = ...,
        query_cache_size: int = ...,
        execution_options: Any | None = ...,
        hide_parameters: bool = ...,
    ) -> None: ...
    @property
    def engine(self): ...
    def clear_compiled_cache(self) -> None: ...
    def update_execution_options(self, **opt) -> None: ...
    def execution_options(self, **opt): ...
    def get_execution_options(self): ...
    @property
    def name(self): ...
    @property
    def driver(self): ...
    def dispose(self) -> None: ...
    class _trans_ctx:
        conn: Any
        transaction: Any
        close_with_result: Any
        def __init__(self, conn, transaction, close_with_result) -> None: ...
        def __enter__(self): ...
        def __exit__(self, type_, value, traceback) -> None: ...
    def begin(self, close_with_result: bool = ...): ...
    def transaction(self, callable_, *args, **kwargs): ...
    def run_callable(self, callable_, *args, **kwargs): ...
    def execute(self, statement, *multiparams, **params): ...
    def scalar(self, statement, *multiparams, **params): ...
    def connect(self, close_with_result: bool = ...): ...  # type: ignore[override]
    def table_names(self, schema: Any | None = ..., connection: Any | None = ...): ...
    def has_table(self, table_name, schema: Any | None = ...): ...
    def raw_connection(self, _connection: Any | None = ...): ...

class OptionEngineMixin:
    url: Any
    dialect: Any
    logging_name: Any
    echo: Any
    hide_parameters: Any
    dispatch: Any
    def __init__(self, proxied, execution_options) -> None: ...
    pool: Any

class OptionEngine(OptionEngineMixin, Engine): ...
