import pathlib
from setuptools import setup, find_packages
from distutils.core import setup

HERE = pathlib.Path(__file__).parent

README = (HERE / "README.md").read_text()

setup(
    name='django_save_deep',
    version='0.0.2',
    author='Thomas Deniffel',
    url='https://github.com/tom-010/django-save-deep',
    author_email='tdeniffel@gmail.com',
    packages=['save_deep'], # find_packages(),
    license='Apache2',
    install_requires=[
        'Django>=3.0.0'
    ],
    classifiers=[
        'Development Status :: 4 - Beta',
        'Intended Audience :: Developers',
        'Programming Language :: Python',
        'Programming Language :: Python :: 3 :: Only',
        'Programming Language :: Python :: 3.6',
        'Programming Language :: Python :: 3.7'
    ],
    description='Safes a complete tree of django models - from bottom to top.',
    long_description=README,
    long_description_content_type="text/markdown",
    python_requires='>=3',
    include_package_data=True,
    entry_points={
    }
)