"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Isolation = exports.ConstructHub = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const ec2 = require("@aws-cdk/aws-ec2");
const aws_iam_1 = require("@aws-cdk/aws-iam");
const s3 = require("@aws-cdk/aws-s3");
const aws_s3_1 = require("@aws-cdk/aws-s3");
const core_1 = require("@aws-cdk/core");
const _limited_internet_access_1 = require("./_limited-internet-access");
const backend_1 = require("./backend");
const backend_dashboard_1 = require("./backend-dashboard");
const inventory_1 = require("./backend/inventory");
const license_list_1 = require("./backend/license-list");
const orchestration_1 = require("./backend/orchestration");
const package_stats_1 = require("./backend/package-stats");
const constants_1 = require("./backend/shared/constants");
const version_tracker_1 = require("./backend/version-tracker");
const repository_1 = require("./codeartifact/repository");
const domain_redirect_1 = require("./domain-redirect");
const monitoring_1 = require("./monitoring");
const package_sources_1 = require("./package-sources");
const storage_1 = require("./s3/storage");
const spdx_license_1 = require("./spdx-license");
const webapp_1 = require("./webapp");
/**
 * (experimental) Construct Hub.
 *
 * @experimental
 */
class ConstructHub extends core_1.Construct {
    /**
     * @experimental
     */
    constructor(scope, id, props = {}) {
        var _b, _c, _d, _e, _f, _g, _h, _j, _k, _l, _m;
        super(scope, id);
        if (props.isolateSensitiveTasks != null && props.sensitiveTaskIsolation != null) {
            throw new Error('Supplying both isolateSensitiveTasks and sensitiveTaskIsolation is not supported. Remove usage of isolateSensitiveTasks.');
        }
        const storageFactory = storage_1.S3StorageFactory.getOrCreate(this, {
            failover: props.failoverStorage,
        });
        const monitoring = new monitoring_1.Monitoring(this, 'Monitoring', {
            alarmActions: props.alarmActions,
        });
        const packageData = storageFactory.newBucket(this, 'PackageData', {
            blockPublicAccess: aws_s3_1.BlockPublicAccess.BLOCK_ALL,
            enforceSSL: true,
            encryption: s3.BucketEncryption.S3_MANAGED,
            lifecycleRules: [
                // Abort multi-part uploads after 1 day
                { abortIncompleteMultipartUploadAfter: core_1.Duration.days(1) },
                // Transition non-current object versions to IA after 1 month
                {
                    noncurrentVersionTransitions: [
                        {
                            storageClass: s3.StorageClass.INFREQUENT_ACCESS,
                            transitionAfter: core_1.Duration.days(31),
                        },
                    ],
                },
                // Permanently delete non-current object versions after 3 months
                {
                    noncurrentVersionExpiration: core_1.Duration.days(90),
                    expiredObjectDeleteMarker: true,
                },
                // Permanently delete non-current versions of catalog.json earlier
                { noncurrentVersionExpiration: core_1.Duration.days(7), prefix: constants_1.CATALOG_KEY },
            ],
            versioned: true,
        });
        const isolation = (_b = props.sensitiveTaskIsolation) !== null && _b !== void 0 ? _b : (props.isolateSensitiveTasks ? Isolation.NO_INTERNET_ACCESS : Isolation.UNLIMITED_INTERNET_ACCESS);
        // Create an internal CodeArtifact repository if we run in network-controlled mode, or if a domain is provided.
        const codeArtifact = isolation === Isolation.NO_INTERNET_ACCESS || props.codeArtifactDomain != null
            ? new repository_1.Repository(this, 'CodeArtifact', {
                description: 'Proxy to npmjs.com for ConstructHub',
                domainName: (_c = props.codeArtifactDomain) === null || _c === void 0 ? void 0 : _c.name,
                domainExists: props.codeArtifactDomain != null,
                upstreams: (_d = props.codeArtifactDomain) === null || _d === void 0 ? void 0 : _d.upstreams,
            })
            : undefined;
        const { vpc, vpcEndpoints, vpcSubnets, vpcSecurityGroups } = this.createVpc(isolation, codeArtifact);
        const denyList = new backend_1.DenyList(this, 'DenyList', {
            rules: (_e = props.denyList) !== null && _e !== void 0 ? _e : [],
            packageDataBucket: packageData,
            packageDataKeyPrefix: constants_1.STORAGE_KEY_PREFIX,
            monitoring: monitoring,
        });
        // disable fetching package stats by default if a different package
        // source is configured
        const fetchPackageStats = (_f = props.fetchPackageStats) !== null && _f !== void 0 ? _f : (props.packageSources ? false : true);
        let packageStats;
        const statsKey = 'stats.json';
        if (fetchPackageStats) {
            packageStats = new package_stats_1.PackageStats(this, 'Stats', {
                bucket: packageData,
                monitoring,
                logRetention: props.logRetention,
                objectKey: statsKey,
            });
        }
        const versionTracker = new version_tracker_1.VersionTracker(this, 'VersionTracker', {
            bucket: packageData,
            monitoring,
            logRetention: props.logRetention,
        });
        const orchestration = new orchestration_1.Orchestration(this, 'Orchestration', {
            bucket: packageData,
            codeArtifact,
            denyList,
            logRetention: props.logRetention,
            monitoring,
            vpc,
            vpcEndpoints,
            vpcSubnets,
            vpcSecurityGroups,
        });
        // rebuild the catalog when the deny list changes.
        denyList.prune.onChangeInvoke(orchestration.catalogBuilder.function);
        const packageTagsSerialized = (_h = (_g = props.packageTags) === null || _g === void 0 ? void 0 : _g.map((config) => {
            return {
                ...config,
                condition: config.condition.bind(),
            };
        })) !== null && _h !== void 0 ? _h : [];
        this.ingestion = new backend_1.Ingestion(this, 'Ingestion', {
            bucket: packageData,
            codeArtifact,
            orchestration,
            logRetention: props.logRetention,
            monitoring,
            packageLinks: props.packageLinks,
            packageTags: packageTagsSerialized,
        });
        const licenseList = new license_list_1.LicenseList(this, 'LicenseList', {
            licenses: (_j = props.allowedLicenses) !== null && _j !== void 0 ? _j : [
                ...spdx_license_1.SpdxLicense.apache(),
                ...spdx_license_1.SpdxLicense.bsd(),
                ...spdx_license_1.SpdxLicense.cddl(),
                ...spdx_license_1.SpdxLicense.epl(),
                spdx_license_1.SpdxLicense.ISC,
                ...spdx_license_1.SpdxLicense.mit(),
                spdx_license_1.SpdxLicense.MPL_2_0,
            ],
        });
        const webApp = new webapp_1.WebApp(this, 'WebApp', {
            domain: props.domain,
            monitoring,
            packageData,
            packageLinks: props.packageLinks,
            packageTags: packageTagsSerialized,
            featuredPackages: props.featuredPackages,
            packageStats,
            featureFlags: props.featureFlags,
            categories: props.categories,
        });
        const sources = new core_1.Construct(this, 'Sources');
        const packageSources = ((_k = props.packageSources) !== null && _k !== void 0 ? _k : [new package_sources_1.NpmJs()]).map((source) => source.bind(sources, {
            baseUrl: webApp.baseUrl,
            denyList,
            ingestion: this.ingestion,
            licenseList,
            monitoring,
            queue: this.ingestion.queue,
            repository: codeArtifact,
        }));
        const inventory = new inventory_1.Inventory(this, 'InventoryCanary', { bucket: packageData, logRetention: props.logRetention, monitoring });
        new backend_dashboard_1.BackendDashboard(this, 'BackendDashboard', {
            packageData,
            dashboardName: props.backendDashboardName,
            packageSources,
            ingestion: this.ingestion,
            inventory,
            orchestration,
            denyList,
            packageStats,
            versionTracker,
        });
        // add domain redirects
        if (props.domain) {
            for (const redirctSource of (_l = props.additionalDomains) !== null && _l !== void 0 ? _l : []) {
                new domain_redirect_1.DomainRedirect(this, `Redirect-${redirctSource.hostedZone.zoneName}`, {
                    source: redirctSource,
                    targetDomainName: (_m = props.domain) === null || _m === void 0 ? void 0 : _m.zone.zoneName,
                });
            }
        }
        else {
            if (props.additionalDomains && props.additionalDomains.length > 0) {
                throw new Error('Cannot specify "domainRedirects" if a domain is not specified');
            }
        }
    }
    /**
     * (experimental) The principal to grant permissions to.
     *
     * @experimental
     */
    get grantPrincipal() {
        return this.ingestion.grantPrincipal;
    }
    /**
     * @experimental
     */
    get ingestionQueue() {
        return this.ingestion.queue;
    }
    createVpc(isolation, codeArtifact) {
        if (isolation === Isolation.UNLIMITED_INTERNET_ACCESS) {
            return { vpc: undefined, vpcEndpoints: undefined, vpcSubnets: undefined };
        }
        const subnetType = isolation === Isolation.NO_INTERNET_ACCESS
            ? ec2.SubnetType.ISOLATED
            : ec2.SubnetType.PRIVATE_WITH_NAT;
        const vpcSubnets = { subnetType };
        const vpc = new ec2.Vpc(this, 'VPC', {
            enableDnsHostnames: true,
            enableDnsSupport: true,
            // Provision no NAT gateways if we are running ISOLATED (we wouldn't have a public subnet)
            natGateways: subnetType === ec2.SubnetType.ISOLATED ? 0 : undefined,
            // Pre-allocating PUBLIC / PRIVATE / INTERNAL subnets, regardless of use, so we don't create
            // a whole new VPC if we ever need to introduce subnets of these types.
            subnetConfiguration: [
                // If there is a PRIVATE subnet, there must also have a PUBLIC subnet (for NAT gateways).
                { name: 'Public', subnetType: ec2.SubnetType.PUBLIC, reserved: subnetType === ec2.SubnetType.ISOLATED },
                { name: 'Private', subnetType: ec2.SubnetType.PRIVATE_WITH_NAT, reserved: subnetType === ec2.SubnetType.ISOLATED },
                { name: 'Isolated', subnetType: ec2.SubnetType.ISOLATED, reserved: subnetType !== ec2.SubnetType.ISOLATED },
            ],
        });
        core_1.Tags.of(vpc.node.defaultChild).add('Name', vpc.node.path);
        const securityGroups = subnetType === ec2.SubnetType.PRIVATE_WITH_NAT
            ? _limited_internet_access_1.createRestrictedSecurityGroups(this, vpc)
            : undefined;
        // Creating the CodeArtifact endpoints only if a repository is present.
        const codeArtifactEndpoints = codeArtifact && {
            codeArtifactApi: vpc.addInterfaceEndpoint('CodeArtifact.API', {
                privateDnsEnabled: false,
                service: new ec2.InterfaceVpcEndpointAwsService('codeartifact.api'),
                subnets: vpcSubnets,
                securityGroups,
            }),
            codeArtifact: vpc.addInterfaceEndpoint('CodeArtifact', {
                privateDnsEnabled: true,
                service: new ec2.InterfaceVpcEndpointAwsService('codeartifact.repositories'),
                subnets: vpcSubnets,
                securityGroups,
            }),
        };
        // We'll only use VPC endpoints if we are configured to run in an ISOLATED subnet.
        const vpcEndpoints = {
            ...codeArtifactEndpoints,
            // This is needed so that ECS workloads can use the awslogs driver
            cloudWatchLogs: vpc.addInterfaceEndpoint('CloudWatch.Logs', {
                privateDnsEnabled: true,
                service: ec2.InterfaceVpcEndpointAwsService.CLOUDWATCH_LOGS,
                subnets: vpcSubnets,
                securityGroups,
            }),
            // These are needed for ECS workloads to be able to pull images
            ecrApi: vpc.addInterfaceEndpoint('ECR.API', {
                privateDnsEnabled: true,
                service: ec2.InterfaceVpcEndpointAwsService.ECR,
                subnets: vpcSubnets,
                securityGroups,
            }),
            ecr: vpc.addInterfaceEndpoint('ECR.Docker', {
                privateDnsEnabled: true,
                service: ec2.InterfaceVpcEndpointAwsService.ECR_DOCKER,
                subnets: vpcSubnets,
                securityGroups,
            }),
            // This is needed (among others) for CodeArtifact registry usage
            s3: vpc.addGatewayEndpoint('S3', {
                service: ec2.GatewayVpcEndpointAwsService.S3,
                subnets: [vpcSubnets],
            }),
            // This is useful for getting results from ECS tasks within workflows
            stepFunctions: vpc.addInterfaceEndpoint('StepFunctions', {
                privateDnsEnabled: true,
                service: ec2.InterfaceVpcEndpointAwsService.STEP_FUNCTIONS,
                subnets: vpcSubnets,
                securityGroups,
            }),
        };
        // The S3 access is necessary for the CodeArtifact Repository and ECR Docker
        // endpoints to be used (they serve objects from S3).
        vpcEndpoints.s3.addToPolicy(new aws_iam_1.PolicyStatement({
            effect: aws_iam_1.Effect.ALLOW,
            actions: ['s3:GetObject'],
            resources: [
                // The in-region CodeArtifact S3 Bucket
                ...codeArtifact ? [`${codeArtifact.s3BucketArn}/*`] : [],
                // The in-region ECR layer bucket
                `arn:aws:s3:::prod-${core_1.Stack.of(this).region}-starport-layer-bucket/*`,
            ],
            // It doesn't seem we can constrain principals for these grants (unclear
            // which principal those calls are made from, or if that is something we
            // could name here).
            principals: [new aws_iam_1.AnyPrincipal()],
            sid: 'Allow-CodeArtifact-and-ECR',
        }));
        return { vpc, vpcEndpoints, vpcSubnets, vpcSecurityGroups: securityGroups };
    }
}
exports.ConstructHub = ConstructHub;
_a = JSII_RTTI_SYMBOL_1;
ConstructHub[_a] = { fqn: "construct-hub.ConstructHub", version: "0.3.155" };
/**
 * (experimental) How possibly risky operations (such as doc-generation, which requires installing the indexed packages in order to trans-literate sample code) are isolated to mitigate possible arbitrary code execution vulnerabilities in and around `npm install` or the transliterator's use of the TypeScript compiler.
 *
 * @experimental
 */
var Isolation;
(function (Isolation) {
    Isolation[Isolation["UNLIMITED_INTERNET_ACCESS"] = 0] = "UNLIMITED_INTERNET_ACCESS";
    Isolation[Isolation["LIMITED_INTERNET_ACCESS"] = 1] = "LIMITED_INTERNET_ACCESS";
    Isolation[Isolation["NO_INTERNET_ACCESS"] = 2] = "NO_INTERNET_ACCESS";
})(Isolation = exports.Isolation || (exports.Isolation = {}));
//# sourceMappingURL=data:application/json;base64,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