import * as s3 from '@aws-cdk/aws-s3';
import { Construct } from '@aws-cdk/core';
/**
 * (experimental) Properties for `S3StorageFactory`.
 *
 * @experimental
 */
export interface S3StorageFactoryProps {
    /**
     * (experimental) When enabled, the factory will return the failover buckets instead of the primary.
     *
     * @default false
     * @experimental
     */
    readonly failover?: boolean;
}
/**
 * (experimental) Create s3 storage resources.
 *
 * @experimental
 */
export declare class S3StorageFactory extends Construct {
    /**
     * (experimental) Retrieve or create the storage factory for the current scope.
     *
     * This is stack singleton.
     *
     * @experimental
     */
    static getOrCreate(scope: Construct, props?: S3StorageFactoryProps): S3StorageFactory;
    private static readonly UID;
    private failoverActive;
    private constructor();
    /**
     * (experimental) Create a new bucket in a storage config aware manner.
     *
     * @returns s3.Bucket
     * @experimental
     */
    newBucket(scope: Construct, id: string, props?: s3.BucketProps): s3.Bucket;
}
