# -*- coding: utf-8 -*-
# This file is auto-generated, don't edit it. Thanks.
from Tea.model import TeaModel


class AiotDevice(TeaModel):
    def __init__(self, ipaddr=None, latitude=None, longitude=None, name=None, place=None, port=None):
        # ip地址
        self.ipaddr = ipaddr  # type: str
        # 纬度
        self.latitude = latitude  # type: float
        # 经度
        self.longitude = longitude  # type: float
        # 名称
        self.name = name  # type: str
        # 安装位置
        self.place = place  # type: str
        # 端口
        self.port = port  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(AiotDevice, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ipaddr is not None:
            result['IPAddr'] = self.ipaddr
        if self.latitude is not None:
            result['Latitude'] = self.latitude
        if self.longitude is not None:
            result['Longitude'] = self.longitude
        if self.name is not None:
            result['Name'] = self.name
        if self.place is not None:
            result['Place'] = self.place
        if self.port is not None:
            result['Port'] = self.port
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IPAddr') is not None:
            self.ipaddr = m.get('IPAddr')
        if m.get('Latitude') is not None:
            self.latitude = m.get('Latitude')
        if m.get('Longitude') is not None:
            self.longitude = m.get('Longitude')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Place') is not None:
            self.place = m.get('Place')
        if m.get('Port') is not None:
            self.port = m.get('Port')
        return self


class AddAiotDevicesRequestAiotDeviceList(TeaModel):
    def __init__(self, corp_id=None, device_id=None, ipaddr=None, latitude=None, longitude=None, name=None,
                 place=None, port=None):
        self.corp_id = corp_id  # type: str
        self.device_id = device_id  # type: str
        self.ipaddr = ipaddr  # type: str
        self.latitude = latitude  # type: float
        self.longitude = longitude  # type: float
        self.name = name  # type: str
        self.place = place  # type: str
        self.port = port  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddAiotDevicesRequestAiotDeviceList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.corp_id is not None:
            result['CorpId'] = self.corp_id
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.ipaddr is not None:
            result['IPAddr'] = self.ipaddr
        if self.latitude is not None:
            result['Latitude'] = self.latitude
        if self.longitude is not None:
            result['Longitude'] = self.longitude
        if self.name is not None:
            result['Name'] = self.name
        if self.place is not None:
            result['Place'] = self.place
        if self.port is not None:
            result['Port'] = self.port
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CorpId') is not None:
            self.corp_id = m.get('CorpId')
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('IPAddr') is not None:
            self.ipaddr = m.get('IPAddr')
        if m.get('Latitude') is not None:
            self.latitude = m.get('Latitude')
        if m.get('Longitude') is not None:
            self.longitude = m.get('Longitude')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Place') is not None:
            self.place = m.get('Place')
        if m.get('Port') is not None:
            self.port = m.get('Port')
        return self


class AddAiotDevicesRequest(TeaModel):
    def __init__(self, aiot_device_list=None):
        self.aiot_device_list = aiot_device_list  # type: list[AddAiotDevicesRequestAiotDeviceList]

    def validate(self):
        if self.aiot_device_list:
            for k in self.aiot_device_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(AddAiotDevicesRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AiotDeviceList'] = []
        if self.aiot_device_list is not None:
            for k in self.aiot_device_list:
                result['AiotDeviceList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.aiot_device_list = []
        if m.get('AiotDeviceList') is not None:
            for k in m.get('AiotDeviceList'):
                temp_model = AddAiotDevicesRequestAiotDeviceList()
                self.aiot_device_list.append(temp_model.from_map(k))
        return self


class AddAiotDevicesShrinkRequest(TeaModel):
    def __init__(self, aiot_device_list_shrink=None):
        self.aiot_device_list_shrink = aiot_device_list_shrink  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddAiotDevicesShrinkRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.aiot_device_list_shrink is not None:
            result['AiotDeviceList'] = self.aiot_device_list_shrink
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AiotDeviceList') is not None:
            self.aiot_device_list_shrink = m.get('AiotDeviceList')
        return self


class AddAiotDevicesResponseBodyResultList(TeaModel):
    def __init__(self, code=None, device_id=None, id=None, message=None, password=None, server_host=None,
                 server_host_internal=None, server_id=None, server_ip=None, server_ip_internal=None, server_port=None,
                 server_wss_port=None, user_id=None):
        self.code = code  # type: str
        self.device_id = device_id  # type: str
        self.id = id  # type: str
        self.message = message  # type: str
        self.password = password  # type: str
        self.server_host = server_host  # type: str
        self.server_host_internal = server_host_internal  # type: str
        self.server_id = server_id  # type: str
        self.server_ip = server_ip  # type: str
        self.server_ip_internal = server_ip_internal  # type: str
        self.server_port = server_port  # type: str
        self.server_wss_port = server_wss_port  # type: str
        self.user_id = user_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddAiotDevicesResponseBodyResultList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.id is not None:
            result['Id'] = self.id
        if self.message is not None:
            result['Message'] = self.message
        if self.password is not None:
            result['Password'] = self.password
        if self.server_host is not None:
            result['ServerHost'] = self.server_host
        if self.server_host_internal is not None:
            result['ServerHostInternal'] = self.server_host_internal
        if self.server_id is not None:
            result['ServerId'] = self.server_id
        if self.server_ip is not None:
            result['ServerIp'] = self.server_ip
        if self.server_ip_internal is not None:
            result['ServerIpInternal'] = self.server_ip_internal
        if self.server_port is not None:
            result['ServerPort'] = self.server_port
        if self.server_wss_port is not None:
            result['ServerWssPort'] = self.server_wss_port
        if self.user_id is not None:
            result['UserId'] = self.user_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('Password') is not None:
            self.password = m.get('Password')
        if m.get('ServerHost') is not None:
            self.server_host = m.get('ServerHost')
        if m.get('ServerHostInternal') is not None:
            self.server_host_internal = m.get('ServerHostInternal')
        if m.get('ServerId') is not None:
            self.server_id = m.get('ServerId')
        if m.get('ServerIp') is not None:
            self.server_ip = m.get('ServerIp')
        if m.get('ServerIpInternal') is not None:
            self.server_ip_internal = m.get('ServerIpInternal')
        if m.get('ServerPort') is not None:
            self.server_port = m.get('ServerPort')
        if m.get('ServerWssPort') is not None:
            self.server_wss_port = m.get('ServerWssPort')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        return self


class AddAiotDevicesResponseBody(TeaModel):
    def __init__(self, code=None, message=None, request_id=None, result_list=None):
        self.code = code  # type: str
        self.message = message  # type: str
        # Id of the request
        self.request_id = request_id  # type: str
        self.result_list = result_list  # type: list[AddAiotDevicesResponseBodyResultList]

    def validate(self):
        if self.result_list:
            for k in self.result_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(AddAiotDevicesResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['ResultList'] = []
        if self.result_list is not None:
            for k in self.result_list:
                result['ResultList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.result_list = []
        if m.get('ResultList') is not None:
            for k in m.get('ResultList'):
                temp_model = AddAiotDevicesResponseBodyResultList()
                self.result_list.append(temp_model.from_map(k))
        return self


class AddAiotDevicesResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: AddAiotDevicesResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(AddAiotDevicesResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddAiotDevicesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddAiotPersonTableRequestPersonTable(TeaModel):
    def __init__(self, name=None, person_table_id=None, type=None, verification_model_list=None):
        self.name = name  # type: str
        self.person_table_id = person_table_id  # type: str
        self.type = type  # type: long
        self.verification_model_list = verification_model_list  # type: list[long]

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddAiotPersonTableRequestPersonTable, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.person_table_id is not None:
            result['PersonTableId'] = self.person_table_id
        if self.type is not None:
            result['Type'] = self.type
        if self.verification_model_list is not None:
            result['VerificationModelList'] = self.verification_model_list
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('PersonTableId') is not None:
            self.person_table_id = m.get('PersonTableId')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('VerificationModelList') is not None:
            self.verification_model_list = m.get('VerificationModelList')
        return self


class AddAiotPersonTableRequest(TeaModel):
    def __init__(self, id=None, person_table=None):
        self.id = id  # type: str
        self.person_table = person_table  # type: AddAiotPersonTableRequestPersonTable

    def validate(self):
        if self.person_table:
            self.person_table.validate()

    def to_map(self):
        _map = super(AddAiotPersonTableRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['Id'] = self.id
        if self.person_table is not None:
            result['PersonTable'] = self.person_table.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('PersonTable') is not None:
            temp_model = AddAiotPersonTableRequestPersonTable()
            self.person_table = temp_model.from_map(m['PersonTable'])
        return self


class AddAiotPersonTableResponseBody(TeaModel):
    def __init__(self, code=None, message=None, person_table_id=None, request_id=None):
        self.code = code  # type: str
        self.message = message  # type: str
        self.person_table_id = person_table_id  # type: str
        # Id of the request
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddAiotPersonTableResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.person_table_id is not None:
            result['PersonTableId'] = self.person_table_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('PersonTableId') is not None:
            self.person_table_id = m.get('PersonTableId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddAiotPersonTableResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: AddAiotPersonTableResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(AddAiotPersonTableResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddAiotPersonTableResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddAiotPersonTableItemsRequestPersonTableItemListIdentificationList(TeaModel):
    def __init__(self, number=None, type=None):
        self.number = number  # type: str
        self.type = type  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddAiotPersonTableItemsRequestPersonTableItemListIdentificationList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.number is not None:
            result['Number'] = self.number
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Number') is not None:
            self.number = m.get('Number')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class AddAiotPersonTableItemsRequestPersonTableItemListImageListFeatureInfo(TeaModel):
    def __init__(self, algorithm_type=None, algorithm_version=None, feature_data=None, image_id=None,
                 object_id=None, tab_ied=None, vendor=None):
        self.algorithm_type = algorithm_type  # type: str
        self.algorithm_version = algorithm_version  # type: str
        self.feature_data = feature_data  # type: str
        self.image_id = image_id  # type: str
        self.object_id = object_id  # type: str
        self.tab_ied = tab_ied  # type: str
        self.vendor = vendor  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddAiotPersonTableItemsRequestPersonTableItemListImageListFeatureInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.algorithm_type is not None:
            result['AlgorithmType'] = self.algorithm_type
        if self.algorithm_version is not None:
            result['AlgorithmVersion'] = self.algorithm_version
        if self.feature_data is not None:
            result['FeatureData'] = self.feature_data
        if self.image_id is not None:
            result['ImageId'] = self.image_id
        if self.object_id is not None:
            result['ObjectId'] = self.object_id
        if self.tab_ied is not None:
            result['TabIed'] = self.tab_ied
        if self.vendor is not None:
            result['Vendor'] = self.vendor
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AlgorithmType') is not None:
            self.algorithm_type = m.get('AlgorithmType')
        if m.get('AlgorithmVersion') is not None:
            self.algorithm_version = m.get('AlgorithmVersion')
        if m.get('FeatureData') is not None:
            self.feature_data = m.get('FeatureData')
        if m.get('ImageId') is not None:
            self.image_id = m.get('ImageId')
        if m.get('ObjectId') is not None:
            self.object_id = m.get('ObjectId')
        if m.get('TabIed') is not None:
            self.tab_ied = m.get('TabIed')
        if m.get('Vendor') is not None:
            self.vendor = m.get('Vendor')
        return self


class AddAiotPersonTableItemsRequestPersonTableItemListImageList(TeaModel):
    def __init__(self, data=None, device_id=None, event_sort=None, feature_info=None, file_format=None, height=None,
                 image_id=None, shot_time=None, size=None, storage_path=None, type=None, width=None):
        self.data = data  # type: str
        self.device_id = device_id  # type: str
        self.event_sort = event_sort  # type: str
        self.feature_info = feature_info  # type: AddAiotPersonTableItemsRequestPersonTableItemListImageListFeatureInfo
        self.file_format = file_format  # type: str
        self.height = height  # type: long
        self.image_id = image_id  # type: str
        self.shot_time = shot_time  # type: str
        self.size = size  # type: long
        self.storage_path = storage_path  # type: str
        self.type = type  # type: str
        self.width = width  # type: long

    def validate(self):
        if self.feature_info:
            self.feature_info.validate()

    def to_map(self):
        _map = super(AddAiotPersonTableItemsRequestPersonTableItemListImageList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.event_sort is not None:
            result['EventSort'] = self.event_sort
        if self.feature_info is not None:
            result['FeatureInfo'] = self.feature_info.to_map()
        if self.file_format is not None:
            result['FileFormat'] = self.file_format
        if self.height is not None:
            result['Height'] = self.height
        if self.image_id is not None:
            result['ImageId'] = self.image_id
        if self.shot_time is not None:
            result['ShotTime'] = self.shot_time
        if self.size is not None:
            result['Size'] = self.size
        if self.storage_path is not None:
            result['StoragePath'] = self.storage_path
        if self.type is not None:
            result['Type'] = self.type
        if self.width is not None:
            result['Width'] = self.width
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('EventSort') is not None:
            self.event_sort = m.get('EventSort')
        if m.get('FeatureInfo') is not None:
            temp_model = AddAiotPersonTableItemsRequestPersonTableItemListImageListFeatureInfo()
            self.feature_info = temp_model.from_map(m['FeatureInfo'])
        if m.get('FileFormat') is not None:
            self.file_format = m.get('FileFormat')
        if m.get('Height') is not None:
            self.height = m.get('Height')
        if m.get('ImageId') is not None:
            self.image_id = m.get('ImageId')
        if m.get('ShotTime') is not None:
            self.shot_time = m.get('ShotTime')
        if m.get('Size') is not None:
            self.size = m.get('Size')
        if m.get('StoragePath') is not None:
            self.storage_path = m.get('StoragePath')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Width') is not None:
            self.width = m.get('Width')
        return self


class AddAiotPersonTableItemsRequestPersonTableItemList(TeaModel):
    def __init__(self, identification_list=None, identification_num=None, image_list=None, image_num=None,
                 person_code=None, person_id=None, person_name=None, remarks=None):
        self.identification_list = identification_list  # type: list[AddAiotPersonTableItemsRequestPersonTableItemListIdentificationList]
        self.identification_num = identification_num  # type: long
        self.image_list = image_list  # type: list[AddAiotPersonTableItemsRequestPersonTableItemListImageList]
        self.image_num = image_num  # type: long
        self.person_code = person_code  # type: str
        self.person_id = person_id  # type: str
        self.person_name = person_name  # type: str
        self.remarks = remarks  # type: str

    def validate(self):
        if self.identification_list:
            for k in self.identification_list:
                if k:
                    k.validate()
        if self.image_list:
            for k in self.image_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(AddAiotPersonTableItemsRequestPersonTableItemList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['IdentificationList'] = []
        if self.identification_list is not None:
            for k in self.identification_list:
                result['IdentificationList'].append(k.to_map() if k else None)
        if self.identification_num is not None:
            result['IdentificationNum'] = self.identification_num
        result['ImageList'] = []
        if self.image_list is not None:
            for k in self.image_list:
                result['ImageList'].append(k.to_map() if k else None)
        if self.image_num is not None:
            result['ImageNum'] = self.image_num
        if self.person_code is not None:
            result['PersonCode'] = self.person_code
        if self.person_id is not None:
            result['PersonId'] = self.person_id
        if self.person_name is not None:
            result['PersonName'] = self.person_name
        if self.remarks is not None:
            result['Remarks'] = self.remarks
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.identification_list = []
        if m.get('IdentificationList') is not None:
            for k in m.get('IdentificationList'):
                temp_model = AddAiotPersonTableItemsRequestPersonTableItemListIdentificationList()
                self.identification_list.append(temp_model.from_map(k))
        if m.get('IdentificationNum') is not None:
            self.identification_num = m.get('IdentificationNum')
        self.image_list = []
        if m.get('ImageList') is not None:
            for k in m.get('ImageList'):
                temp_model = AddAiotPersonTableItemsRequestPersonTableItemListImageList()
                self.image_list.append(temp_model.from_map(k))
        if m.get('ImageNum') is not None:
            self.image_num = m.get('ImageNum')
        if m.get('PersonCode') is not None:
            self.person_code = m.get('PersonCode')
        if m.get('PersonId') is not None:
            self.person_id = m.get('PersonId')
        if m.get('PersonName') is not None:
            self.person_name = m.get('PersonName')
        if m.get('Remarks') is not None:
            self.remarks = m.get('Remarks')
        return self


class AddAiotPersonTableItemsRequest(TeaModel):
    def __init__(self, id=None, person_table_id=None, person_table_item_list=None):
        self.id = id  # type: str
        self.person_table_id = person_table_id  # type: str
        self.person_table_item_list = person_table_item_list  # type: list[AddAiotPersonTableItemsRequestPersonTableItemList]

    def validate(self):
        if self.person_table_item_list:
            for k in self.person_table_item_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(AddAiotPersonTableItemsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['Id'] = self.id
        if self.person_table_id is not None:
            result['PersonTableId'] = self.person_table_id
        result['PersonTableItemList'] = []
        if self.person_table_item_list is not None:
            for k in self.person_table_item_list:
                result['PersonTableItemList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('PersonTableId') is not None:
            self.person_table_id = m.get('PersonTableId')
        self.person_table_item_list = []
        if m.get('PersonTableItemList') is not None:
            for k in m.get('PersonTableItemList'):
                temp_model = AddAiotPersonTableItemsRequestPersonTableItemList()
                self.person_table_item_list.append(temp_model.from_map(k))
        return self


class AddAiotPersonTableItemsResponseBodyResultList(TeaModel):
    def __init__(self, code=None, message=None, person_table_item_id=None):
        self.code = code  # type: str
        self.message = message  # type: str
        self.person_table_item_id = person_table_item_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddAiotPersonTableItemsResponseBodyResultList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.person_table_item_id is not None:
            result['PersonTableItemId'] = self.person_table_item_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('PersonTableItemId') is not None:
            self.person_table_item_id = m.get('PersonTableItemId')
        return self


class AddAiotPersonTableItemsResponseBody(TeaModel):
    def __init__(self, code=None, message=None, request_id=None, result_list=None):
        self.code = code  # type: str
        self.message = message  # type: str
        # Id of the request
        self.request_id = request_id  # type: str
        self.result_list = result_list  # type: list[AddAiotPersonTableItemsResponseBodyResultList]

    def validate(self):
        if self.result_list:
            for k in self.result_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(AddAiotPersonTableItemsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['ResultList'] = []
        if self.result_list is not None:
            for k in self.result_list:
                result['ResultList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.result_list = []
        if m.get('ResultList') is not None:
            for k in m.get('ResultList'):
                temp_model = AddAiotPersonTableItemsResponseBodyResultList()
                self.result_list.append(temp_model.from_map(k))
        return self


class AddAiotPersonTableItemsResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: AddAiotPersonTableItemsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(AddAiotPersonTableItemsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddAiotPersonTableItemsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddAiotPersonTableItemsForTablesRequestPersonTableItemListIdentificationList(TeaModel):
    def __init__(self, number=None, type=None):
        self.number = number  # type: str
        self.type = type  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddAiotPersonTableItemsForTablesRequestPersonTableItemListIdentificationList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.number is not None:
            result['Number'] = self.number
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Number') is not None:
            self.number = m.get('Number')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class AddAiotPersonTableItemsForTablesRequestPersonTableItemListImageListFeatureInfo(TeaModel):
    def __init__(self, algorithm_type=None, algorithm_version=None, feature_data=None, image_id=None,
                 object_id=None, tab_ied=None, vendor=None):
        self.algorithm_type = algorithm_type  # type: str
        self.algorithm_version = algorithm_version  # type: str
        self.feature_data = feature_data  # type: str
        self.image_id = image_id  # type: str
        self.object_id = object_id  # type: str
        self.tab_ied = tab_ied  # type: str
        self.vendor = vendor  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddAiotPersonTableItemsForTablesRequestPersonTableItemListImageListFeatureInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.algorithm_type is not None:
            result['AlgorithmType'] = self.algorithm_type
        if self.algorithm_version is not None:
            result['AlgorithmVersion'] = self.algorithm_version
        if self.feature_data is not None:
            result['FeatureData'] = self.feature_data
        if self.image_id is not None:
            result['ImageId'] = self.image_id
        if self.object_id is not None:
            result['ObjectId'] = self.object_id
        if self.tab_ied is not None:
            result['TabIed'] = self.tab_ied
        if self.vendor is not None:
            result['Vendor'] = self.vendor
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AlgorithmType') is not None:
            self.algorithm_type = m.get('AlgorithmType')
        if m.get('AlgorithmVersion') is not None:
            self.algorithm_version = m.get('AlgorithmVersion')
        if m.get('FeatureData') is not None:
            self.feature_data = m.get('FeatureData')
        if m.get('ImageId') is not None:
            self.image_id = m.get('ImageId')
        if m.get('ObjectId') is not None:
            self.object_id = m.get('ObjectId')
        if m.get('TabIed') is not None:
            self.tab_ied = m.get('TabIed')
        if m.get('Vendor') is not None:
            self.vendor = m.get('Vendor')
        return self


class AddAiotPersonTableItemsForTablesRequestPersonTableItemListImageList(TeaModel):
    def __init__(self, data=None, device_id=None, event_sort=None, feature_info=None, file_format=None, height=None,
                 image_id=None, shot_time=None, size=None, storage_path=None, type=None, width=None):
        self.data = data  # type: str
        self.device_id = device_id  # type: str
        self.event_sort = event_sort  # type: str
        self.feature_info = feature_info  # type: AddAiotPersonTableItemsForTablesRequestPersonTableItemListImageListFeatureInfo
        self.file_format = file_format  # type: str
        self.height = height  # type: long
        self.image_id = image_id  # type: str
        self.shot_time = shot_time  # type: str
        self.size = size  # type: long
        self.storage_path = storage_path  # type: str
        self.type = type  # type: str
        self.width = width  # type: long

    def validate(self):
        if self.feature_info:
            self.feature_info.validate()

    def to_map(self):
        _map = super(AddAiotPersonTableItemsForTablesRequestPersonTableItemListImageList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.event_sort is not None:
            result['EventSort'] = self.event_sort
        if self.feature_info is not None:
            result['FeatureInfo'] = self.feature_info.to_map()
        if self.file_format is not None:
            result['FileFormat'] = self.file_format
        if self.height is not None:
            result['Height'] = self.height
        if self.image_id is not None:
            result['ImageId'] = self.image_id
        if self.shot_time is not None:
            result['ShotTime'] = self.shot_time
        if self.size is not None:
            result['Size'] = self.size
        if self.storage_path is not None:
            result['StoragePath'] = self.storage_path
        if self.type is not None:
            result['Type'] = self.type
        if self.width is not None:
            result['Width'] = self.width
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('EventSort') is not None:
            self.event_sort = m.get('EventSort')
        if m.get('FeatureInfo') is not None:
            temp_model = AddAiotPersonTableItemsForTablesRequestPersonTableItemListImageListFeatureInfo()
            self.feature_info = temp_model.from_map(m['FeatureInfo'])
        if m.get('FileFormat') is not None:
            self.file_format = m.get('FileFormat')
        if m.get('Height') is not None:
            self.height = m.get('Height')
        if m.get('ImageId') is not None:
            self.image_id = m.get('ImageId')
        if m.get('ShotTime') is not None:
            self.shot_time = m.get('ShotTime')
        if m.get('Size') is not None:
            self.size = m.get('Size')
        if m.get('StoragePath') is not None:
            self.storage_path = m.get('StoragePath')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Width') is not None:
            self.width = m.get('Width')
        return self


class AddAiotPersonTableItemsForTablesRequestPersonTableItemList(TeaModel):
    def __init__(self, identification_list=None, identification_num=None, image_list=None, image_num=None,
                 person_code=None, person_id=None, person_name=None, remarks=None):
        self.identification_list = identification_list  # type: list[AddAiotPersonTableItemsForTablesRequestPersonTableItemListIdentificationList]
        self.identification_num = identification_num  # type: long
        self.image_list = image_list  # type: list[AddAiotPersonTableItemsForTablesRequestPersonTableItemListImageList]
        self.image_num = image_num  # type: long
        self.person_code = person_code  # type: str
        self.person_id = person_id  # type: str
        self.person_name = person_name  # type: str
        self.remarks = remarks  # type: str

    def validate(self):
        if self.identification_list:
            for k in self.identification_list:
                if k:
                    k.validate()
        if self.image_list:
            for k in self.image_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(AddAiotPersonTableItemsForTablesRequestPersonTableItemList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['IdentificationList'] = []
        if self.identification_list is not None:
            for k in self.identification_list:
                result['IdentificationList'].append(k.to_map() if k else None)
        if self.identification_num is not None:
            result['IdentificationNum'] = self.identification_num
        result['ImageList'] = []
        if self.image_list is not None:
            for k in self.image_list:
                result['ImageList'].append(k.to_map() if k else None)
        if self.image_num is not None:
            result['ImageNum'] = self.image_num
        if self.person_code is not None:
            result['PersonCode'] = self.person_code
        if self.person_id is not None:
            result['PersonId'] = self.person_id
        if self.person_name is not None:
            result['PersonName'] = self.person_name
        if self.remarks is not None:
            result['Remarks'] = self.remarks
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.identification_list = []
        if m.get('IdentificationList') is not None:
            for k in m.get('IdentificationList'):
                temp_model = AddAiotPersonTableItemsForTablesRequestPersonTableItemListIdentificationList()
                self.identification_list.append(temp_model.from_map(k))
        if m.get('IdentificationNum') is not None:
            self.identification_num = m.get('IdentificationNum')
        self.image_list = []
        if m.get('ImageList') is not None:
            for k in m.get('ImageList'):
                temp_model = AddAiotPersonTableItemsForTablesRequestPersonTableItemListImageList()
                self.image_list.append(temp_model.from_map(k))
        if m.get('ImageNum') is not None:
            self.image_num = m.get('ImageNum')
        if m.get('PersonCode') is not None:
            self.person_code = m.get('PersonCode')
        if m.get('PersonId') is not None:
            self.person_id = m.get('PersonId')
        if m.get('PersonName') is not None:
            self.person_name = m.get('PersonName')
        if m.get('Remarks') is not None:
            self.remarks = m.get('Remarks')
        return self


class AddAiotPersonTableItemsForTablesRequestPersonTableList(TeaModel):
    def __init__(self, id=None, person_table_id=None):
        self.id = id  # type: str
        self.person_table_id = person_table_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddAiotPersonTableItemsForTablesRequestPersonTableList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['Id'] = self.id
        if self.person_table_id is not None:
            result['PersonTableId'] = self.person_table_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('PersonTableId') is not None:
            self.person_table_id = m.get('PersonTableId')
        return self


class AddAiotPersonTableItemsForTablesRequest(TeaModel):
    def __init__(self, person_table_item_list=None, person_table_list=None):
        self.person_table_item_list = person_table_item_list  # type: list[AddAiotPersonTableItemsForTablesRequestPersonTableItemList]
        self.person_table_list = person_table_list  # type: list[AddAiotPersonTableItemsForTablesRequestPersonTableList]

    def validate(self):
        if self.person_table_item_list:
            for k in self.person_table_item_list:
                if k:
                    k.validate()
        if self.person_table_list:
            for k in self.person_table_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(AddAiotPersonTableItemsForTablesRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['PersonTableItemList'] = []
        if self.person_table_item_list is not None:
            for k in self.person_table_item_list:
                result['PersonTableItemList'].append(k.to_map() if k else None)
        result['PersonTableList'] = []
        if self.person_table_list is not None:
            for k in self.person_table_list:
                result['PersonTableList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.person_table_item_list = []
        if m.get('PersonTableItemList') is not None:
            for k in m.get('PersonTableItemList'):
                temp_model = AddAiotPersonTableItemsForTablesRequestPersonTableItemList()
                self.person_table_item_list.append(temp_model.from_map(k))
        self.person_table_list = []
        if m.get('PersonTableList') is not None:
            for k in m.get('PersonTableList'):
                temp_model = AddAiotPersonTableItemsForTablesRequestPersonTableList()
                self.person_table_list.append(temp_model.from_map(k))
        return self


class AddAiotPersonTableItemsForTablesResponseBody(TeaModel):
    def __init__(self, code=None, message=None, request_id=None):
        self.code = code  # type: str
        self.message = message  # type: str
        # Id of the request
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddAiotPersonTableItemsForTablesResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddAiotPersonTableItemsForTablesResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: AddAiotPersonTableItemsForTablesResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(AddAiotPersonTableItemsForTablesResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddAiotPersonTableItemsForTablesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddAiotVehicleTableItemsRequestVehicleTableItem(TeaModel):
    def __init__(self, begin_time=None, end_time=None, owner_name=None, phone_no=None, plate_no=None, remarks=None,
                 vehicle_table_item_id=None):
        self.begin_time = begin_time  # type: str
        self.end_time = end_time  # type: str
        self.owner_name = owner_name  # type: str
        self.phone_no = phone_no  # type: str
        self.plate_no = plate_no  # type: str
        self.remarks = remarks  # type: str
        self.vehicle_table_item_id = vehicle_table_item_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddAiotVehicleTableItemsRequestVehicleTableItem, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.begin_time is not None:
            result['BeginTime'] = self.begin_time
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.owner_name is not None:
            result['OwnerName'] = self.owner_name
        if self.phone_no is not None:
            result['PhoneNo'] = self.phone_no
        if self.plate_no is not None:
            result['PlateNo'] = self.plate_no
        if self.remarks is not None:
            result['Remarks'] = self.remarks
        if self.vehicle_table_item_id is not None:
            result['VehicleTableItemId'] = self.vehicle_table_item_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BeginTime') is not None:
            self.begin_time = m.get('BeginTime')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('OwnerName') is not None:
            self.owner_name = m.get('OwnerName')
        if m.get('PhoneNo') is not None:
            self.phone_no = m.get('PhoneNo')
        if m.get('PlateNo') is not None:
            self.plate_no = m.get('PlateNo')
        if m.get('Remarks') is not None:
            self.remarks = m.get('Remarks')
        if m.get('VehicleTableItemId') is not None:
            self.vehicle_table_item_id = m.get('VehicleTableItemId')
        return self


class AddAiotVehicleTableItemsRequest(TeaModel):
    def __init__(self, id=None, vehicle_table_id=None, vehicle_table_item=None):
        self.id = id  # type: str
        self.vehicle_table_id = vehicle_table_id  # type: str
        self.vehicle_table_item = vehicle_table_item  # type: AddAiotVehicleTableItemsRequestVehicleTableItem

    def validate(self):
        if self.vehicle_table_item:
            self.vehicle_table_item.validate()

    def to_map(self):
        _map = super(AddAiotVehicleTableItemsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['Id'] = self.id
        if self.vehicle_table_id is not None:
            result['VehicleTableId'] = self.vehicle_table_id
        if self.vehicle_table_item is not None:
            result['VehicleTableItem'] = self.vehicle_table_item.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('VehicleTableId') is not None:
            self.vehicle_table_id = m.get('VehicleTableId')
        if m.get('VehicleTableItem') is not None:
            temp_model = AddAiotVehicleTableItemsRequestVehicleTableItem()
            self.vehicle_table_item = temp_model.from_map(m['VehicleTableItem'])
        return self


class AddAiotVehicleTableItemsShrinkRequest(TeaModel):
    def __init__(self, id=None, vehicle_table_id=None, vehicle_table_item_shrink=None):
        self.id = id  # type: str
        self.vehicle_table_id = vehicle_table_id  # type: str
        self.vehicle_table_item_shrink = vehicle_table_item_shrink  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddAiotVehicleTableItemsShrinkRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['Id'] = self.id
        if self.vehicle_table_id is not None:
            result['VehicleTableId'] = self.vehicle_table_id
        if self.vehicle_table_item_shrink is not None:
            result['VehicleTableItem'] = self.vehicle_table_item_shrink
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('VehicleTableId') is not None:
            self.vehicle_table_id = m.get('VehicleTableId')
        if m.get('VehicleTableItem') is not None:
            self.vehicle_table_item_shrink = m.get('VehicleTableItem')
        return self


class AddAiotVehicleTableItemsResponseBody(TeaModel):
    def __init__(self, code=None, message=None, request_id=None):
        self.code = code  # type: str
        self.message = message  # type: str
        # Id of the request
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddAiotVehicleTableItemsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddAiotVehicleTableItemsResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: AddAiotVehicleTableItemsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(AddAiotVehicleTableItemsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddAiotVehicleTableItemsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddCameraForInstanceRequest(TeaModel):
    def __init__(self, camera_ids=None, instance_id=None):
        # 设备Id
        self.camera_ids = camera_ids  # type: list[str]
        # 实例Id
        self.instance_id = instance_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddCameraForInstanceRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.camera_ids is not None:
            result['CameraIds'] = self.camera_ids
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CameraIds') is not None:
            self.camera_ids = m.get('CameraIds')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class AddCameraForInstanceShrinkRequest(TeaModel):
    def __init__(self, camera_ids_shrink=None, instance_id=None):
        # 设备Id
        self.camera_ids_shrink = camera_ids_shrink  # type: str
        # 实例Id
        self.instance_id = instance_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddCameraForInstanceShrinkRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.camera_ids_shrink is not None:
            result['CameraIds'] = self.camera_ids_shrink
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CameraIds') is not None:
            self.camera_ids_shrink = m.get('CameraIds')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class AddCameraForInstanceResponseBody(TeaModel):
    def __init__(self, code=None, message=None, request_id=None):
        # code码
        self.code = code  # type: str
        # 返回结果消息
        self.message = message  # type: str
        # Id of the request
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddCameraForInstanceResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddCameraForInstanceResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: AddCameraForInstanceResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(AddCameraForInstanceResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddCameraForInstanceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddChannelRequest(TeaModel):
    def __init__(self, parent_device_gb_id=None):
        self.parent_device_gb_id = parent_device_gb_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddChannelRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.parent_device_gb_id is not None:
            result['ParentDeviceGbId'] = self.parent_device_gb_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ParentDeviceGbId') is not None:
            self.parent_device_gb_id = m.get('ParentDeviceGbId')
        return self


class AddChannelResponseBody(TeaModel):
    def __init__(self, code=None, data=None, message=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: str
        self.message = message  # type: str
        # Id of the request
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddChannelResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddChannelResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: AddChannelResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(AddChannelResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddChannelResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddDataSourceRequest(TeaModel):
    def __init__(self, corp_id=None, data_source_name=None, data_source_type=None, description=None, url=None):
        self.corp_id = corp_id  # type: str
        self.data_source_name = data_source_name  # type: str
        self.data_source_type = data_source_type  # type: str
        self.description = description  # type: str
        self.url = url  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddDataSourceRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.corp_id is not None:
            result['CorpId'] = self.corp_id
        if self.data_source_name is not None:
            result['DataSourceName'] = self.data_source_name
        if self.data_source_type is not None:
            result['DataSourceType'] = self.data_source_type
        if self.description is not None:
            result['Description'] = self.description
        if self.url is not None:
            result['Url'] = self.url
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CorpId') is not None:
            self.corp_id = m.get('CorpId')
        if m.get('DataSourceName') is not None:
            self.data_source_name = m.get('DataSourceName')
        if m.get('DataSourceType') is not None:
            self.data_source_type = m.get('DataSourceType')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Url') is not None:
            self.url = m.get('Url')
        return self


class AddDataSourceResponseBodyData(TeaModel):
    def __init__(self, data_source_id=None, kafka_topic=None, oss_path=None):
        self.data_source_id = data_source_id  # type: str
        self.kafka_topic = kafka_topic  # type: str
        self.oss_path = oss_path  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddDataSourceResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data_source_id is not None:
            result['DataSourceId'] = self.data_source_id
        if self.kafka_topic is not None:
            result['KafkaTopic'] = self.kafka_topic
        if self.oss_path is not None:
            result['OssPath'] = self.oss_path
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DataSourceId') is not None:
            self.data_source_id = m.get('DataSourceId')
        if m.get('KafkaTopic') is not None:
            self.kafka_topic = m.get('KafkaTopic')
        if m.get('OssPath') is not None:
            self.oss_path = m.get('OssPath')
        return self


class AddDataSourceResponseBody(TeaModel):
    def __init__(self, code=None, data=None, message=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: AddDataSourceResponseBodyData
        self.message = message  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(AddDataSourceResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = AddDataSourceResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddDataSourceResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: AddDataSourceResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(AddDataSourceResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddDataSourceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddDeviceRequest(TeaModel):
    def __init__(self, bit_rate=None, corp_id=None, device_address=None, device_direction=None, device_name=None,
                 device_resolution=None, device_site=None, device_type=None, gb_id=None, vendor=None):
        self.bit_rate = bit_rate  # type: str
        self.corp_id = corp_id  # type: str
        self.device_address = device_address  # type: str
        self.device_direction = device_direction  # type: str
        self.device_name = device_name  # type: str
        self.device_resolution = device_resolution  # type: str
        self.device_site = device_site  # type: str
        self.device_type = device_type  # type: str
        self.gb_id = gb_id  # type: str
        self.vendor = vendor  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddDeviceRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bit_rate is not None:
            result['BitRate'] = self.bit_rate
        if self.corp_id is not None:
            result['CorpId'] = self.corp_id
        if self.device_address is not None:
            result['DeviceAddress'] = self.device_address
        if self.device_direction is not None:
            result['DeviceDirection'] = self.device_direction
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.device_resolution is not None:
            result['DeviceResolution'] = self.device_resolution
        if self.device_site is not None:
            result['DeviceSite'] = self.device_site
        if self.device_type is not None:
            result['DeviceType'] = self.device_type
        if self.gb_id is not None:
            result['GbId'] = self.gb_id
        if self.vendor is not None:
            result['Vendor'] = self.vendor
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BitRate') is not None:
            self.bit_rate = m.get('BitRate')
        if m.get('CorpId') is not None:
            self.corp_id = m.get('CorpId')
        if m.get('DeviceAddress') is not None:
            self.device_address = m.get('DeviceAddress')
        if m.get('DeviceDirection') is not None:
            self.device_direction = m.get('DeviceDirection')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('DeviceResolution') is not None:
            self.device_resolution = m.get('DeviceResolution')
        if m.get('DeviceSite') is not None:
            self.device_site = m.get('DeviceSite')
        if m.get('DeviceType') is not None:
            self.device_type = m.get('DeviceType')
        if m.get('GbId') is not None:
            self.gb_id = m.get('GbId')
        if m.get('Vendor') is not None:
            self.vendor = m.get('Vendor')
        return self


class AddDeviceResponseBody(TeaModel):
    def __init__(self, code=None, data=None, message=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: str
        self.message = message  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddDeviceResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddDeviceResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: AddDeviceResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(AddDeviceResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddDeviceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddDoubleVerificationGroupsRequestDoubleVerificationGroupListPersonIdList(TeaModel):
    def __init__(self, person_id=None, person_table_id=None):
        self.person_id = person_id  # type: str
        self.person_table_id = person_table_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddDoubleVerificationGroupsRequestDoubleVerificationGroupListPersonIdList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.person_id is not None:
            result['PersonId'] = self.person_id
        if self.person_table_id is not None:
            result['PersonTableId'] = self.person_table_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PersonId') is not None:
            self.person_id = m.get('PersonId')
        if m.get('PersonTableId') is not None:
            self.person_table_id = m.get('PersonTableId')
        return self


class AddDoubleVerificationGroupsRequestDoubleVerificationGroupList(TeaModel):
    def __init__(self, group_id=None, interval=None, member_number=None, person_id_list=None):
        self.group_id = group_id  # type: str
        self.interval = interval  # type: long
        self.member_number = member_number  # type: long
        self.person_id_list = person_id_list  # type: list[AddDoubleVerificationGroupsRequestDoubleVerificationGroupListPersonIdList]

    def validate(self):
        if self.person_id_list:
            for k in self.person_id_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(AddDoubleVerificationGroupsRequestDoubleVerificationGroupList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.interval is not None:
            result['Interval'] = self.interval
        if self.member_number is not None:
            result['MemberNumber'] = self.member_number
        result['PersonIdList'] = []
        if self.person_id_list is not None:
            for k in self.person_id_list:
                result['PersonIdList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('Interval') is not None:
            self.interval = m.get('Interval')
        if m.get('MemberNumber') is not None:
            self.member_number = m.get('MemberNumber')
        self.person_id_list = []
        if m.get('PersonIdList') is not None:
            for k in m.get('PersonIdList'):
                temp_model = AddDoubleVerificationGroupsRequestDoubleVerificationGroupListPersonIdList()
                self.person_id_list.append(temp_model.from_map(k))
        return self


class AddDoubleVerificationGroupsRequest(TeaModel):
    def __init__(self, double_verification_group_list=None, id=None):
        self.double_verification_group_list = double_verification_group_list  # type: list[AddDoubleVerificationGroupsRequestDoubleVerificationGroupList]
        self.id = id  # type: str

    def validate(self):
        if self.double_verification_group_list:
            for k in self.double_verification_group_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(AddDoubleVerificationGroupsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DoubleVerificationGroupList'] = []
        if self.double_verification_group_list is not None:
            for k in self.double_verification_group_list:
                result['DoubleVerificationGroupList'].append(k.to_map() if k else None)
        if self.id is not None:
            result['Id'] = self.id
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.double_verification_group_list = []
        if m.get('DoubleVerificationGroupList') is not None:
            for k in m.get('DoubleVerificationGroupList'):
                temp_model = AddDoubleVerificationGroupsRequestDoubleVerificationGroupList()
                self.double_verification_group_list.append(temp_model.from_map(k))
        if m.get('Id') is not None:
            self.id = m.get('Id')
        return self


class AddDoubleVerificationGroupsResponseBodyResultList(TeaModel):
    def __init__(self, code=None, group_id=None, message=None):
        self.code = code  # type: str
        self.group_id = group_id  # type: str
        self.message = message  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddDoubleVerificationGroupsResponseBodyResultList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.message is not None:
            result['Message'] = self.message
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        return self


class AddDoubleVerificationGroupsResponseBody(TeaModel):
    def __init__(self, code=None, message=None, request_id=None, result_list=None):
        self.code = code  # type: str
        self.message = message  # type: str
        # Id of the request
        self.request_id = request_id  # type: str
        self.result_list = result_list  # type: list[AddDoubleVerificationGroupsResponseBodyResultList]

    def validate(self):
        if self.result_list:
            for k in self.result_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(AddDoubleVerificationGroupsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['ResultList'] = []
        if self.result_list is not None:
            for k in self.result_list:
                result['ResultList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.result_list = []
        if m.get('ResultList') is not None:
            for k in m.get('ResultList'):
                temp_model = AddDoubleVerificationGroupsResponseBodyResultList()
                self.result_list.append(temp_model.from_map(k))
        return self


class AddDoubleVerificationGroupsResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: AddDoubleVerificationGroupsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(AddDoubleVerificationGroupsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddDoubleVerificationGroupsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddMonitorRequest(TeaModel):
    def __init__(self, algorithm_vendor=None, batch_indicator=None, corp_id=None, description=None,
                 monitor_type=None, notifier_app_secret=None, notifier_extend_values=None, notifier_time_out=None,
                 notifier_type=None, notifier_url=None):
        self.algorithm_vendor = algorithm_vendor  # type: str
        self.batch_indicator = batch_indicator  # type: int
        self.corp_id = corp_id  # type: str
        self.description = description  # type: str
        self.monitor_type = monitor_type  # type: str
        self.notifier_app_secret = notifier_app_secret  # type: str
        self.notifier_extend_values = notifier_extend_values  # type: str
        self.notifier_time_out = notifier_time_out  # type: int
        self.notifier_type = notifier_type  # type: str
        self.notifier_url = notifier_url  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddMonitorRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.algorithm_vendor is not None:
            result['AlgorithmVendor'] = self.algorithm_vendor
        if self.batch_indicator is not None:
            result['BatchIndicator'] = self.batch_indicator
        if self.corp_id is not None:
            result['CorpId'] = self.corp_id
        if self.description is not None:
            result['Description'] = self.description
        if self.monitor_type is not None:
            result['MonitorType'] = self.monitor_type
        if self.notifier_app_secret is not None:
            result['NotifierAppSecret'] = self.notifier_app_secret
        if self.notifier_extend_values is not None:
            result['NotifierExtendValues'] = self.notifier_extend_values
        if self.notifier_time_out is not None:
            result['NotifierTimeOut'] = self.notifier_time_out
        if self.notifier_type is not None:
            result['NotifierType'] = self.notifier_type
        if self.notifier_url is not None:
            result['NotifierUrl'] = self.notifier_url
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AlgorithmVendor') is not None:
            self.algorithm_vendor = m.get('AlgorithmVendor')
        if m.get('BatchIndicator') is not None:
            self.batch_indicator = m.get('BatchIndicator')
        if m.get('CorpId') is not None:
            self.corp_id = m.get('CorpId')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('MonitorType') is not None:
            self.monitor_type = m.get('MonitorType')
        if m.get('NotifierAppSecret') is not None:
            self.notifier_app_secret = m.get('NotifierAppSecret')
        if m.get('NotifierExtendValues') is not None:
            self.notifier_extend_values = m.get('NotifierExtendValues')
        if m.get('NotifierTimeOut') is not None:
            self.notifier_time_out = m.get('NotifierTimeOut')
        if m.get('NotifierType') is not None:
            self.notifier_type = m.get('NotifierType')
        if m.get('NotifierUrl') is not None:
            self.notifier_url = m.get('NotifierUrl')
        return self


class AddMonitorResponseBodyData(TeaModel):
    def __init__(self, task_id=None):
        self.task_id = task_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddMonitorResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class AddMonitorResponseBody(TeaModel):
    def __init__(self, code=None, data=None, message=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: AddMonitorResponseBodyData
        self.message = message  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(AddMonitorResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = AddMonitorResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddMonitorResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: AddMonitorResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(AddMonitorResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddMonitorResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddProfileRequest(TeaModel):
    def __init__(self, biz_id=None, catalog_id=None, corp_id=None, face_url=None, gender=None, id_number=None,
                 isv_sub_id=None, live_address=None, name=None, phone_no=None, plate_no=None, scene_type=None):
        self.biz_id = biz_id  # type: str
        self.catalog_id = catalog_id  # type: long
        self.corp_id = corp_id  # type: str
        self.face_url = face_url  # type: str
        self.gender = gender  # type: int
        self.id_number = id_number  # type: str
        self.isv_sub_id = isv_sub_id  # type: str
        self.live_address = live_address  # type: str
        self.name = name  # type: str
        self.phone_no = phone_no  # type: str
        self.plate_no = plate_no  # type: str
        self.scene_type = scene_type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddProfileRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.biz_id is not None:
            result['BizId'] = self.biz_id
        if self.catalog_id is not None:
            result['CatalogId'] = self.catalog_id
        if self.corp_id is not None:
            result['CorpId'] = self.corp_id
        if self.face_url is not None:
            result['FaceUrl'] = self.face_url
        if self.gender is not None:
            result['Gender'] = self.gender
        if self.id_number is not None:
            result['IdNumber'] = self.id_number
        if self.isv_sub_id is not None:
            result['IsvSubId'] = self.isv_sub_id
        if self.live_address is not None:
            result['LiveAddress'] = self.live_address
        if self.name is not None:
            result['Name'] = self.name
        if self.phone_no is not None:
            result['PhoneNo'] = self.phone_no
        if self.plate_no is not None:
            result['PlateNo'] = self.plate_no
        if self.scene_type is not None:
            result['SceneType'] = self.scene_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BizId') is not None:
            self.biz_id = m.get('BizId')
        if m.get('CatalogId') is not None:
            self.catalog_id = m.get('CatalogId')
        if m.get('CorpId') is not None:
            self.corp_id = m.get('CorpId')
        if m.get('FaceUrl') is not None:
            self.face_url = m.get('FaceUrl')
        if m.get('Gender') is not None:
            self.gender = m.get('Gender')
        if m.get('IdNumber') is not None:
            self.id_number = m.get('IdNumber')
        if m.get('IsvSubId') is not None:
            self.isv_sub_id = m.get('IsvSubId')
        if m.get('LiveAddress') is not None:
            self.live_address = m.get('LiveAddress')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('PhoneNo') is not None:
            self.phone_no = m.get('PhoneNo')
        if m.get('PlateNo') is not None:
            self.plate_no = m.get('PlateNo')
        if m.get('SceneType') is not None:
            self.scene_type = m.get('SceneType')
        return self


class AddProfileResponseBodyData(TeaModel):
    def __init__(self, biz_id=None, catalog_id=None, face_url=None, gender=None, id_number=None, isv_sub_id=None,
                 live_address=None, name=None, phone_no=None, plate_no=None, profile_id=None, scene_type=None):
        self.biz_id = biz_id  # type: str
        self.catalog_id = catalog_id  # type: int
        self.face_url = face_url  # type: str
        self.gender = gender  # type: str
        self.id_number = id_number  # type: str
        self.isv_sub_id = isv_sub_id  # type: str
        self.live_address = live_address  # type: str
        self.name = name  # type: str
        self.phone_no = phone_no  # type: str
        self.plate_no = plate_no  # type: str
        self.profile_id = profile_id  # type: int
        self.scene_type = scene_type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddProfileResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.biz_id is not None:
            result['BizId'] = self.biz_id
        if self.catalog_id is not None:
            result['CatalogId'] = self.catalog_id
        if self.face_url is not None:
            result['FaceUrl'] = self.face_url
        if self.gender is not None:
            result['Gender'] = self.gender
        if self.id_number is not None:
            result['IdNumber'] = self.id_number
        if self.isv_sub_id is not None:
            result['IsvSubId'] = self.isv_sub_id
        if self.live_address is not None:
            result['LiveAddress'] = self.live_address
        if self.name is not None:
            result['Name'] = self.name
        if self.phone_no is not None:
            result['PhoneNo'] = self.phone_no
        if self.plate_no is not None:
            result['PlateNo'] = self.plate_no
        if self.profile_id is not None:
            result['ProfileId'] = self.profile_id
        if self.scene_type is not None:
            result['SceneType'] = self.scene_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BizId') is not None:
            self.biz_id = m.get('BizId')
        if m.get('CatalogId') is not None:
            self.catalog_id = m.get('CatalogId')
        if m.get('FaceUrl') is not None:
            self.face_url = m.get('FaceUrl')
        if m.get('Gender') is not None:
            self.gender = m.get('Gender')
        if m.get('IdNumber') is not None:
            self.id_number = m.get('IdNumber')
        if m.get('IsvSubId') is not None:
            self.isv_sub_id = m.get('IsvSubId')
        if m.get('LiveAddress') is not None:
            self.live_address = m.get('LiveAddress')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('PhoneNo') is not None:
            self.phone_no = m.get('PhoneNo')
        if m.get('PlateNo') is not None:
            self.plate_no = m.get('PlateNo')
        if m.get('ProfileId') is not None:
            self.profile_id = m.get('ProfileId')
        if m.get('SceneType') is not None:
            self.scene_type = m.get('SceneType')
        return self


class AddProfileResponseBody(TeaModel):
    def __init__(self, code=None, data=None, message=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: AddProfileResponseBodyData
        self.message = message  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(AddProfileResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = AddProfileResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddProfileResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: AddProfileResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(AddProfileResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddProfileResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddProfileCatalogRequest(TeaModel):
    def __init__(self, catalog_name=None, corp_id=None, isv_sub_id=None, parent_catalog_id=None):
        self.catalog_name = catalog_name  # type: str
        self.corp_id = corp_id  # type: str
        self.isv_sub_id = isv_sub_id  # type: str
        self.parent_catalog_id = parent_catalog_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddProfileCatalogRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.catalog_name is not None:
            result['CatalogName'] = self.catalog_name
        if self.corp_id is not None:
            result['CorpId'] = self.corp_id
        if self.isv_sub_id is not None:
            result['IsvSubId'] = self.isv_sub_id
        if self.parent_catalog_id is not None:
            result['ParentCatalogId'] = self.parent_catalog_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CatalogName') is not None:
            self.catalog_name = m.get('CatalogName')
        if m.get('CorpId') is not None:
            self.corp_id = m.get('CorpId')
        if m.get('IsvSubId') is not None:
            self.isv_sub_id = m.get('IsvSubId')
        if m.get('ParentCatalogId') is not None:
            self.parent_catalog_id = m.get('ParentCatalogId')
        return self


class AddProfileCatalogResponseBodyData(TeaModel):
    def __init__(self, catalog_id=None, catalog_name=None, isv_sub_id=None):
        self.catalog_id = catalog_id  # type: long
        self.catalog_name = catalog_name  # type: str
        self.isv_sub_id = isv_sub_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddProfileCatalogResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.catalog_id is not None:
            result['CatalogId'] = self.catalog_id
        if self.catalog_name is not None:
            result['CatalogName'] = self.catalog_name
        if self.isv_sub_id is not None:
            result['IsvSubId'] = self.isv_sub_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CatalogId') is not None:
            self.catalog_id = m.get('CatalogId')
        if m.get('CatalogName') is not None:
            self.catalog_name = m.get('CatalogName')
        if m.get('IsvSubId') is not None:
            self.isv_sub_id = m.get('IsvSubId')
        return self


class AddProfileCatalogResponseBody(TeaModel):
    def __init__(self, code=None, data=None, message=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: AddProfileCatalogResponseBodyData
        self.message = message  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(AddProfileCatalogResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = AddProfileCatalogResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddProfileCatalogResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: AddProfileCatalogResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(AddProfileCatalogResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddProfileCatalogResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddSearchItemsRequestSearchItemList(TeaModel):
    def __init__(self, item_image_url=None, search_item_id=None, search_item_name=None):
        self.item_image_url = item_image_url  # type: str
        self.search_item_id = search_item_id  # type: str
        self.search_item_name = search_item_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddSearchItemsRequestSearchItemList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.item_image_url is not None:
            result['ItemImageUrl'] = self.item_image_url
        if self.search_item_id is not None:
            result['SearchItemId'] = self.search_item_id
        if self.search_item_name is not None:
            result['SearchItemName'] = self.search_item_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ItemImageUrl') is not None:
            self.item_image_url = m.get('ItemImageUrl')
        if m.get('SearchItemId') is not None:
            self.search_item_id = m.get('SearchItemId')
        if m.get('SearchItemName') is not None:
            self.search_item_name = m.get('SearchItemName')
        return self


class AddSearchItemsRequest(TeaModel):
    def __init__(self, search_item_list=None, search_table_id=None):
        self.search_item_list = search_item_list  # type: list[AddSearchItemsRequestSearchItemList]
        self.search_table_id = search_table_id  # type: str

    def validate(self):
        if self.search_item_list:
            for k in self.search_item_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(AddSearchItemsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['SearchItemList'] = []
        if self.search_item_list is not None:
            for k in self.search_item_list:
                result['SearchItemList'].append(k.to_map() if k else None)
        if self.search_table_id is not None:
            result['SearchTableId'] = self.search_table_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.search_item_list = []
        if m.get('SearchItemList') is not None:
            for k in m.get('SearchItemList'):
                temp_model = AddSearchItemsRequestSearchItemList()
                self.search_item_list.append(temp_model.from_map(k))
        if m.get('SearchTableId') is not None:
            self.search_table_id = m.get('SearchTableId')
        return self


class AddSearchItemsShrinkRequest(TeaModel):
    def __init__(self, search_item_list_shrink=None, search_table_id=None):
        self.search_item_list_shrink = search_item_list_shrink  # type: str
        self.search_table_id = search_table_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddSearchItemsShrinkRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.search_item_list_shrink is not None:
            result['SearchItemList'] = self.search_item_list_shrink
        if self.search_table_id is not None:
            result['SearchTableId'] = self.search_table_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('SearchItemList') is not None:
            self.search_item_list_shrink = m.get('SearchItemList')
        if m.get('SearchTableId') is not None:
            self.search_table_id = m.get('SearchTableId')
        return self


class AddSearchItemsResponseBodyData(TeaModel):
    def __init__(self, added_item_ids=None, failed_item_ids=None):
        self.added_item_ids = added_item_ids  # type: str
        self.failed_item_ids = failed_item_ids  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddSearchItemsResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.added_item_ids is not None:
            result['AddedItemIds'] = self.added_item_ids
        if self.failed_item_ids is not None:
            result['FailedItemIds'] = self.failed_item_ids
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AddedItemIds') is not None:
            self.added_item_ids = m.get('AddedItemIds')
        if m.get('FailedItemIds') is not None:
            self.failed_item_ids = m.get('FailedItemIds')
        return self


class AddSearchItemsResponseBody(TeaModel):
    def __init__(self, code=None, data=None, message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data = data  # type: AddSearchItemsResponseBodyData
        self.message = message  # type: str
        # Id of the request
        self.request_id = request_id  # type: str
        self.success = success  # type: str

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(AddSearchItemsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = AddSearchItemsResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class AddSearchItemsResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: AddSearchItemsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(AddSearchItemsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddSearchItemsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddWatchItemsRequestWatchItemList(TeaModel):
    def __init__(self, item_attributes=None, item_image_url=None, watch_item_id=None, watch_item_name=None):
        self.item_attributes = item_attributes  # type: str
        self.item_image_url = item_image_url  # type: str
        self.watch_item_id = watch_item_id  # type: str
        self.watch_item_name = watch_item_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddWatchItemsRequestWatchItemList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.item_attributes is not None:
            result['ItemAttributes'] = self.item_attributes
        if self.item_image_url is not None:
            result['ItemImageUrl'] = self.item_image_url
        if self.watch_item_id is not None:
            result['WatchItemId'] = self.watch_item_id
        if self.watch_item_name is not None:
            result['WatchItemName'] = self.watch_item_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ItemAttributes') is not None:
            self.item_attributes = m.get('ItemAttributes')
        if m.get('ItemImageUrl') is not None:
            self.item_image_url = m.get('ItemImageUrl')
        if m.get('WatchItemId') is not None:
            self.watch_item_id = m.get('WatchItemId')
        if m.get('WatchItemName') is not None:
            self.watch_item_name = m.get('WatchItemName')
        return self


class AddWatchItemsRequest(TeaModel):
    def __init__(self, watch_item_list=None, watch_policy_id=None):
        self.watch_item_list = watch_item_list  # type: list[AddWatchItemsRequestWatchItemList]
        self.watch_policy_id = watch_policy_id  # type: str

    def validate(self):
        if self.watch_item_list:
            for k in self.watch_item_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(AddWatchItemsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['WatchItemList'] = []
        if self.watch_item_list is not None:
            for k in self.watch_item_list:
                result['WatchItemList'].append(k.to_map() if k else None)
        if self.watch_policy_id is not None:
            result['WatchPolicyId'] = self.watch_policy_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.watch_item_list = []
        if m.get('WatchItemList') is not None:
            for k in m.get('WatchItemList'):
                temp_model = AddWatchItemsRequestWatchItemList()
                self.watch_item_list.append(temp_model.from_map(k))
        if m.get('WatchPolicyId') is not None:
            self.watch_policy_id = m.get('WatchPolicyId')
        return self


class AddWatchItemsResponseBodyData(TeaModel):
    def __init__(self, added_item_ids=None, failed_item_ids=None):
        self.added_item_ids = added_item_ids  # type: str
        self.failed_item_ids = failed_item_ids  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddWatchItemsResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.added_item_ids is not None:
            result['AddedItemIds'] = self.added_item_ids
        if self.failed_item_ids is not None:
            result['FailedItemIds'] = self.failed_item_ids
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AddedItemIds') is not None:
            self.added_item_ids = m.get('AddedItemIds')
        if m.get('FailedItemIds') is not None:
            self.failed_item_ids = m.get('FailedItemIds')
        return self


class AddWatchItemsResponseBody(TeaModel):
    def __init__(self, code=None, data=None, message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data = data  # type: AddWatchItemsResponseBodyData
        self.message = message  # type: str
        # Id of the request
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(AddWatchItemsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = AddWatchItemsResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class AddWatchItemsResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: AddWatchItemsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(AddWatchItemsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddWatchItemsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BatchDeleteInstanceRequest(TeaModel):
    def __init__(self, instance_ids=None, project_id=None):
        self.instance_ids = instance_ids  # type: list[str]
        self.project_id = project_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(BatchDeleteInstanceRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_ids is not None:
            result['InstanceIds'] = self.instance_ids
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceIds') is not None:
            self.instance_ids = m.get('InstanceIds')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        return self


class BatchDeleteInstanceShrinkRequest(TeaModel):
    def __init__(self, instance_ids_shrink=None, project_id=None):
        self.instance_ids_shrink = instance_ids_shrink  # type: str
        self.project_id = project_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(BatchDeleteInstanceShrinkRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_ids_shrink is not None:
            result['InstanceIds'] = self.instance_ids_shrink
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceIds') is not None:
            self.instance_ids_shrink = m.get('InstanceIds')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        return self


class BatchDeleteInstanceResponseBody(TeaModel):
    def __init__(self, code=None, message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(BatchDeleteInstanceResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class BatchDeleteInstanceResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: BatchDeleteInstanceResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(BatchDeleteInstanceResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = BatchDeleteInstanceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BindCorpGroupRequest(TeaModel):
    def __init__(self, corp_group_id=None, corp_id=None):
        self.corp_group_id = corp_group_id  # type: str
        self.corp_id = corp_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(BindCorpGroupRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.corp_group_id is not None:
            result['CorpGroupId'] = self.corp_group_id
        if self.corp_id is not None:
            result['CorpId'] = self.corp_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CorpGroupId') is not None:
            self.corp_group_id = m.get('CorpGroupId')
        if m.get('CorpId') is not None:
            self.corp_id = m.get('CorpId')
        return self


class BindCorpGroupResponseBody(TeaModel):
    def __init__(self, code=None, message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(BindCorpGroupResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class BindCorpGroupResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: BindCorpGroupResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(BindCorpGroupResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = BindCorpGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BindDevicesRequestSubDeviceList(TeaModel):
    def __init__(self, access_protocol=None, login_name=None, pin=None, sub_device_ip=None, sub_device_name=None,
                 sub_device_port=None):
        self.access_protocol = access_protocol  # type: str
        self.login_name = login_name  # type: str
        self.pin = pin  # type: str
        self.sub_device_ip = sub_device_ip  # type: str
        self.sub_device_name = sub_device_name  # type: str
        self.sub_device_port = sub_device_port  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(BindDevicesRequestSubDeviceList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.access_protocol is not None:
            result['AccessProtocol'] = self.access_protocol
        if self.login_name is not None:
            result['LoginName'] = self.login_name
        if self.pin is not None:
            result['PIN'] = self.pin
        if self.sub_device_ip is not None:
            result['SubDeviceIp'] = self.sub_device_ip
        if self.sub_device_name is not None:
            result['SubDeviceName'] = self.sub_device_name
        if self.sub_device_port is not None:
            result['SubDevicePort'] = self.sub_device_port
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AccessProtocol') is not None:
            self.access_protocol = m.get('AccessProtocol')
        if m.get('LoginName') is not None:
            self.login_name = m.get('LoginName')
        if m.get('PIN') is not None:
            self.pin = m.get('PIN')
        if m.get('SubDeviceIp') is not None:
            self.sub_device_ip = m.get('SubDeviceIp')
        if m.get('SubDeviceName') is not None:
            self.sub_device_name = m.get('SubDeviceName')
        if m.get('SubDevicePort') is not None:
            self.sub_device_port = m.get('SubDevicePort')
        return self


class BindDevicesRequest(TeaModel):
    def __init__(self, corp_id=None, device_id=None, sub_device_list=None):
        self.corp_id = corp_id  # type: str
        self.device_id = device_id  # type: str
        self.sub_device_list = sub_device_list  # type: list[BindDevicesRequestSubDeviceList]

    def validate(self):
        if self.sub_device_list:
            for k in self.sub_device_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(BindDevicesRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.corp_id is not None:
            result['CorpId'] = self.corp_id
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        result['SubDeviceList'] = []
        if self.sub_device_list is not None:
            for k in self.sub_device_list:
                result['SubDeviceList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CorpId') is not None:
            self.corp_id = m.get('CorpId')
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        self.sub_device_list = []
        if m.get('SubDeviceList') is not None:
            for k in m.get('SubDeviceList'):
                temp_model = BindDevicesRequestSubDeviceList()
                self.sub_device_list.append(temp_model.from_map(k))
        return self


class BindDevicesShrinkRequest(TeaModel):
    def __init__(self, corp_id=None, device_id=None, sub_device_list_shrink=None):
        self.corp_id = corp_id  # type: str
        self.device_id = device_id  # type: str
        self.sub_device_list_shrink = sub_device_list_shrink  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(BindDevicesShrinkRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.corp_id is not None:
            result['CorpId'] = self.corp_id
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.sub_device_list_shrink is not None:
            result['SubDeviceList'] = self.sub_device_list_shrink
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CorpId') is not None:
            self.corp_id = m.get('CorpId')
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('SubDeviceList') is not None:
            self.sub_device_list_shrink = m.get('SubDeviceList')
        return self


class BindDevicesResponseBodyDataSubDeviceList(TeaModel):
    def __init__(self, code=None, message=None, sub_device_id=None, sub_device_ip=None, sub_device_name=None,
                 sub_device_num=None, sub_device_port=None):
        self.code = code  # type: str
        self.message = message  # type: str
        self.sub_device_id = sub_device_id  # type: str
        self.sub_device_ip = sub_device_ip  # type: str
        self.sub_device_name = sub_device_name  # type: str
        self.sub_device_num = sub_device_num  # type: str
        self.sub_device_port = sub_device_port  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(BindDevicesResponseBodyDataSubDeviceList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.sub_device_id is not None:
            result['SubDeviceId'] = self.sub_device_id
        if self.sub_device_ip is not None:
            result['SubDeviceIp'] = self.sub_device_ip
        if self.sub_device_name is not None:
            result['SubDeviceName'] = self.sub_device_name
        if self.sub_device_num is not None:
            result['SubDeviceNum'] = self.sub_device_num
        if self.sub_device_port is not None:
            result['SubDevicePort'] = self.sub_device_port
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('SubDeviceId') is not None:
            self.sub_device_id = m.get('SubDeviceId')
        if m.get('SubDeviceIp') is not None:
            self.sub_device_ip = m.get('SubDeviceIp')
        if m.get('SubDeviceName') is not None:
            self.sub_device_name = m.get('SubDeviceName')
        if m.get('SubDeviceNum') is not None:
            self.sub_device_num = m.get('SubDeviceNum')
        if m.get('SubDevicePort') is not None:
            self.sub_device_port = m.get('SubDevicePort')
        return self


class BindDevicesResponseBodyData(TeaModel):
    def __init__(self, sub_device_list=None):
        self.sub_device_list = sub_device_list  # type: list[BindDevicesResponseBodyDataSubDeviceList]

    def validate(self):
        if self.sub_device_list:
            for k in self.sub_device_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(BindDevicesResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['SubDeviceList'] = []
        if self.sub_device_list is not None:
            for k in self.sub_device_list:
                result['SubDeviceList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.sub_device_list = []
        if m.get('SubDeviceList') is not None:
            for k in m.get('SubDeviceList'):
                temp_model = BindDevicesResponseBodyDataSubDeviceList()
                self.sub_device_list.append(temp_model.from_map(k))
        return self


class BindDevicesResponseBody(TeaModel):
    def __init__(self, code=None, data=None, message=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: BindDevicesResponseBodyData
        self.message = message  # type: str
        # Id of the request
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(BindDevicesResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = BindDevicesResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class BindDevicesResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: BindDevicesResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(BindDevicesResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = BindDevicesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BindPersonRequest(TeaModel):
    def __init__(self, corp_id=None, isv_sub_id=None, person_id=None, person_matching_rate=None, profile_id=None):
        self.corp_id = corp_id  # type: str
        self.isv_sub_id = isv_sub_id  # type: str
        self.person_id = person_id  # type: str
        self.person_matching_rate = person_matching_rate  # type: str
        self.profile_id = profile_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(BindPersonRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.corp_id is not None:
            result['CorpId'] = self.corp_id
        if self.isv_sub_id is not None:
            result['IsvSubId'] = self.isv_sub_id
        if self.person_id is not None:
            result['PersonId'] = self.person_id
        if self.person_matching_rate is not None:
            result['PersonMatchingRate'] = self.person_matching_rate
        if self.profile_id is not None:
            result['ProfileId'] = self.profile_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CorpId') is not None:
            self.corp_id = m.get('CorpId')
        if m.get('IsvSubId') is not None:
            self.isv_sub_id = m.get('IsvSubId')
        if m.get('PersonId') is not None:
            self.person_id = m.get('PersonId')
        if m.get('PersonMatchingRate') is not None:
            self.person_matching_rate = m.get('PersonMatchingRate')
        if m.get('ProfileId') is not None:
            self.profile_id = m.get('ProfileId')
        return self


class BindPersonResponseBody(TeaModel):
    def __init__(self, code=None, data=None, message=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: bool
        self.message = message  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(BindPersonResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class BindPersonResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: BindPersonResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(BindPersonResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = BindPersonResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BindUserRequest(TeaModel):
    def __init__(self, corp_id=None, isv_sub_id=None, matching_rate=None, person_id=None, user_id=None):
        self.corp_id = corp_id  # type: str
        self.isv_sub_id = isv_sub_id  # type: str
        self.matching_rate = matching_rate  # type: str
        self.person_id = person_id  # type: str
        self.user_id = user_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(BindUserRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.corp_id is not None:
            result['CorpId'] = self.corp_id
        if self.isv_sub_id is not None:
            result['IsvSubId'] = self.isv_sub_id
        if self.matching_rate is not None:
            result['MatchingRate'] = self.matching_rate
        if self.person_id is not None:
            result['PersonId'] = self.person_id
        if self.user_id is not None:
            result['UserId'] = self.user_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CorpId') is not None:
            self.corp_id = m.get('CorpId')
        if m.get('IsvSubId') is not None:
            self.isv_sub_id = m.get('IsvSubId')
        if m.get('MatchingRate') is not None:
            self.matching_rate = m.get('MatchingRate')
        if m.get('PersonId') is not None:
            self.person_id = m.get('PersonId')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        return self


class BindUserResponseBody(TeaModel):
    def __init__(self, code=None, data=None, message=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: bool
        self.message = message  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(BindUserResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class BindUserResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: BindUserResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(BindUserResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = BindUserResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CheckAIInstanceNameRequest(TeaModel):
    def __init__(self, instance_name=None, instance_type=None, project_id=None):
        # 实例名称
        self.instance_name = instance_name  # type: str
        # 实例类型
        self.instance_type = instance_type  # type: str
        # 所属项目Id
        self.project_id = project_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CheckAIInstanceNameRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_name is not None:
            result['InstanceName'] = self.instance_name
        if self.instance_type is not None:
            result['InstanceType'] = self.instance_type
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceName') is not None:
            self.instance_name = m.get('InstanceName')
        if m.get('InstanceType') is not None:
            self.instance_type = m.get('InstanceType')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        return self


class CheckAIInstanceNameResponseBodyData(TeaModel):
    def __init__(self, available=None):
        self.available = available  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(CheckAIInstanceNameResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.available is not None:
            result['Available'] = self.available
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Available') is not None:
            self.available = m.get('Available')
        return self


class CheckAIInstanceNameResponseBody(TeaModel):
    def __init__(self, code=None, data=None, message=None, request_id=None):
        # 返回code码
        self.code = code  # type: str
        # 返回数据
        self.data = data  # type: CheckAIInstanceNameResponseBodyData
        # 错误信息
        self.message = message  # type: str
        # 请求id
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(CheckAIInstanceNameResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = CheckAIInstanceNameResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CheckAIInstanceNameResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CheckAIInstanceNameResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CheckAIInstanceNameResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CheckAIInstanceNameResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CheckSLRRequest(TeaModel):
    def __init__(self, service_name=None):
        self.service_name = service_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CheckSLRRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.service_name is not None:
            result['ServiceName'] = self.service_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ServiceName') is not None:
            self.service_name = m.get('ServiceName')
        return self


class CheckSLRResponseBody(TeaModel):
    def __init__(self, code=None, data=None, message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data = data  # type: str
        self.message = message  # type: str
        # Id of the request
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(CheckSLRResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CheckSLRResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CheckSLRResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CheckSLRResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CheckSLRResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ControlAiotDeviceRequestMiFareCard(TeaModel):
    def __init__(self, area_code=None, area_deviate=None, area_len=None, enabled=None, key_type=None,
                 last_change=None, secret_key=None):
        self.area_code = area_code  # type: long
        self.area_deviate = area_deviate  # type: long
        self.area_len = area_len  # type: long
        self.enabled = enabled  # type: str
        self.key_type = key_type  # type: long
        self.last_change = last_change  # type: str
        self.secret_key = secret_key  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ControlAiotDeviceRequestMiFareCard, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.area_code is not None:
            result['AreaCode'] = self.area_code
        if self.area_deviate is not None:
            result['AreaDeviate'] = self.area_deviate
        if self.area_len is not None:
            result['AreaLen'] = self.area_len
        if self.enabled is not None:
            result['Enabled'] = self.enabled
        if self.key_type is not None:
            result['KeyType'] = self.key_type
        if self.last_change is not None:
            result['LastChange'] = self.last_change
        if self.secret_key is not None:
            result['SecretKey'] = self.secret_key
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AreaCode') is not None:
            self.area_code = m.get('AreaCode')
        if m.get('AreaDeviate') is not None:
            self.area_deviate = m.get('AreaDeviate')
        if m.get('AreaLen') is not None:
            self.area_len = m.get('AreaLen')
        if m.get('Enabled') is not None:
            self.enabled = m.get('Enabled')
        if m.get('KeyType') is not None:
            self.key_type = m.get('KeyType')
        if m.get('LastChange') is not None:
            self.last_change = m.get('LastChange')
        if m.get('SecretKey') is not None:
            self.secret_key = m.get('SecretKey')
        return self


class ControlAiotDeviceRequest(TeaModel):
    def __init__(self, associated_device_id=None, associated_ipaddr=None, associated_port=None,
                 associated_verification_enable=None, barrier_command=None, check_enabled=None, command_type=None,
                 double_verification_group_enabled=None, gate_ctl_status=None, id=None, identity_number=None, is_proxy=None, mi_fare_card=None,
                 name=None, reboot_device=None, single_interval=None, super_password=None, upgrade_file_url=None):
        self.associated_device_id = associated_device_id  # type: str
        self.associated_ipaddr = associated_ipaddr  # type: str
        self.associated_port = associated_port  # type: long
        self.associated_verification_enable = associated_verification_enable  # type: str
        self.barrier_command = barrier_command  # type: long
        self.check_enabled = check_enabled  # type: str
        self.command_type = command_type  # type: long
        self.double_verification_group_enabled = double_verification_group_enabled  # type: str
        self.gate_ctl_status = gate_ctl_status  # type: long
        self.id = id  # type: str
        self.identity_number = identity_number  # type: str
        self.is_proxy = is_proxy  # type: bool
        self.mi_fare_card = mi_fare_card  # type: ControlAiotDeviceRequestMiFareCard
        self.name = name  # type: str
        self.reboot_device = reboot_device  # type: str
        self.single_interval = single_interval  # type: long
        self.super_password = super_password  # type: str
        self.upgrade_file_url = upgrade_file_url  # type: str

    def validate(self):
        if self.mi_fare_card:
            self.mi_fare_card.validate()

    def to_map(self):
        _map = super(ControlAiotDeviceRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.associated_device_id is not None:
            result['AssociatedDeviceId'] = self.associated_device_id
        if self.associated_ipaddr is not None:
            result['AssociatedIPAddr'] = self.associated_ipaddr
        if self.associated_port is not None:
            result['AssociatedPort'] = self.associated_port
        if self.associated_verification_enable is not None:
            result['AssociatedVerificationEnable'] = self.associated_verification_enable
        if self.barrier_command is not None:
            result['BarrierCommand'] = self.barrier_command
        if self.check_enabled is not None:
            result['CheckEnabled'] = self.check_enabled
        if self.command_type is not None:
            result['CommandType'] = self.command_type
        if self.double_verification_group_enabled is not None:
            result['DoubleVerificationGroupEnabled'] = self.double_verification_group_enabled
        if self.gate_ctl_status is not None:
            result['GateCtlStatus'] = self.gate_ctl_status
        if self.id is not None:
            result['Id'] = self.id
        if self.identity_number is not None:
            result['IdentityNumber'] = self.identity_number
        if self.is_proxy is not None:
            result['IsProxy'] = self.is_proxy
        if self.mi_fare_card is not None:
            result['MiFareCard'] = self.mi_fare_card.to_map()
        if self.name is not None:
            result['Name'] = self.name
        if self.reboot_device is not None:
            result['RebootDevice'] = self.reboot_device
        if self.single_interval is not None:
            result['SingleInterval'] = self.single_interval
        if self.super_password is not None:
            result['SuperPassword'] = self.super_password
        if self.upgrade_file_url is not None:
            result['UpgradeFileURL'] = self.upgrade_file_url
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AssociatedDeviceId') is not None:
            self.associated_device_id = m.get('AssociatedDeviceId')
        if m.get('AssociatedIPAddr') is not None:
            self.associated_ipaddr = m.get('AssociatedIPAddr')
        if m.get('AssociatedPort') is not None:
            self.associated_port = m.get('AssociatedPort')
        if m.get('AssociatedVerificationEnable') is not None:
            self.associated_verification_enable = m.get('AssociatedVerificationEnable')
        if m.get('BarrierCommand') is not None:
            self.barrier_command = m.get('BarrierCommand')
        if m.get('CheckEnabled') is not None:
            self.check_enabled = m.get('CheckEnabled')
        if m.get('CommandType') is not None:
            self.command_type = m.get('CommandType')
        if m.get('DoubleVerificationGroupEnabled') is not None:
            self.double_verification_group_enabled = m.get('DoubleVerificationGroupEnabled')
        if m.get('GateCtlStatus') is not None:
            self.gate_ctl_status = m.get('GateCtlStatus')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('IdentityNumber') is not None:
            self.identity_number = m.get('IdentityNumber')
        if m.get('IsProxy') is not None:
            self.is_proxy = m.get('IsProxy')
        if m.get('MiFareCard') is not None:
            temp_model = ControlAiotDeviceRequestMiFareCard()
            self.mi_fare_card = temp_model.from_map(m['MiFareCard'])
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('RebootDevice') is not None:
            self.reboot_device = m.get('RebootDevice')
        if m.get('SingleInterval') is not None:
            self.single_interval = m.get('SingleInterval')
        if m.get('SuperPassword') is not None:
            self.super_password = m.get('SuperPassword')
        if m.get('UpgradeFileURL') is not None:
            self.upgrade_file_url = m.get('UpgradeFileURL')
        return self


class ControlAiotDeviceResponseBody(TeaModel):
    def __init__(self, code=None, message=None, request_id=None):
        self.code = code  # type: str
        self.message = message  # type: str
        # Id of the request
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ControlAiotDeviceResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ControlAiotDeviceResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: ControlAiotDeviceResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ControlAiotDeviceResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ControlAiotDeviceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateAIInstanceRequestDataSourceTimes(TeaModel):
    def __init__(self, end_time=None, start_time=None):
        # 视频结束时间
        self.end_time = end_time  # type: str
        # 视频开始时间
        self.start_time = start_time  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateAIInstanceRequestDataSourceTimes, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class CreateAIInstanceRequestScheduleTimes(TeaModel):
    def __init__(self, end_time=None, start_time=None):
        # 结束执行时间
        self.end_time = end_time  # type: str
        # 开始执行时间
        self.start_time = start_time  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateAIInstanceRequestScheduleTimes, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class CreateAIInstanceRequest(TeaModel):
    def __init__(self, algorithm_id=None, algorithm_name=None, compute_type=None, container_type=None,
                 data_source=None, data_source_times=None, data_type=None, fps=None, instance_name=None, instance_type=None,
                 project_id=None, schedule_cycle_dates=None, schedule_times=None, schedule_type=None, spf=None):
        # 算子Id
        self.algorithm_id = algorithm_id  # type: str
        # 算法名称
        self.algorithm_name = algorithm_name  # type: str
        # 计算类型
        self.compute_type = compute_type  # type: str
        # 实例类型
        self.container_type = container_type  # type: str
        # 数据来源
        self.data_source = data_source  # type: str
        # 数据源时间段
        self.data_source_times = data_source_times  # type: list[CreateAIInstanceRequestDataSourceTimes]
        # 数据类型
        self.data_type = data_type  # type: str
        # 多少秒抽取1帧，取值范围[0, 3600]。 0表示不抽帧。
        self.fps = fps  # type: long
        # 实例名称
        self.instance_name = instance_name  # type: str
        # 实例类型
        self.instance_type = instance_type  # type: str
        # 所属项目Id
        self.project_id = project_id  # type: str
        # ScheduleType为EVERY_WEEK、EVERY_MONTH时必填
        self.schedule_cycle_dates = schedule_cycle_dates  # type: list[long]
        # 执行时间段，支持多段，指定多段时不能重合交错。
        self.schedule_times = schedule_times  # type: list[CreateAIInstanceRequestScheduleTimes]
        # 调度类型
        self.schedule_type = schedule_type  # type: str
        # 多少秒抽取1帧，取值范围[0, 3600]。 0表示不抽帧。
        self.spf = spf  # type: long

    def validate(self):
        if self.data_source_times:
            for k in self.data_source_times:
                if k:
                    k.validate()
        if self.schedule_times:
            for k in self.schedule_times:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(CreateAIInstanceRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.algorithm_id is not None:
            result['AlgorithmId'] = self.algorithm_id
        if self.algorithm_name is not None:
            result['AlgorithmName'] = self.algorithm_name
        if self.compute_type is not None:
            result['ComputeType'] = self.compute_type
        if self.container_type is not None:
            result['ContainerType'] = self.container_type
        if self.data_source is not None:
            result['DataSource'] = self.data_source
        result['DataSourceTimes'] = []
        if self.data_source_times is not None:
            for k in self.data_source_times:
                result['DataSourceTimes'].append(k.to_map() if k else None)
        if self.data_type is not None:
            result['DataType'] = self.data_type
        if self.fps is not None:
            result['Fps'] = self.fps
        if self.instance_name is not None:
            result['InstanceName'] = self.instance_name
        if self.instance_type is not None:
            result['InstanceType'] = self.instance_type
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.schedule_cycle_dates is not None:
            result['ScheduleCycleDates'] = self.schedule_cycle_dates
        result['ScheduleTimes'] = []
        if self.schedule_times is not None:
            for k in self.schedule_times:
                result['ScheduleTimes'].append(k.to_map() if k else None)
        if self.schedule_type is not None:
            result['ScheduleType'] = self.schedule_type
        if self.spf is not None:
            result['Spf'] = self.spf
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AlgorithmId') is not None:
            self.algorithm_id = m.get('AlgorithmId')
        if m.get('AlgorithmName') is not None:
            self.algorithm_name = m.get('AlgorithmName')
        if m.get('ComputeType') is not None:
            self.compute_type = m.get('ComputeType')
        if m.get('ContainerType') is not None:
            self.container_type = m.get('ContainerType')
        if m.get('DataSource') is not None:
            self.data_source = m.get('DataSource')
        self.data_source_times = []
        if m.get('DataSourceTimes') is not None:
            for k in m.get('DataSourceTimes'):
                temp_model = CreateAIInstanceRequestDataSourceTimes()
                self.data_source_times.append(temp_model.from_map(k))
        if m.get('DataType') is not None:
            self.data_type = m.get('DataType')
        if m.get('Fps') is not None:
            self.fps = m.get('Fps')
        if m.get('InstanceName') is not None:
            self.instance_name = m.get('InstanceName')
        if m.get('InstanceType') is not None:
            self.instance_type = m.get('InstanceType')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('ScheduleCycleDates') is not None:
            self.schedule_cycle_dates = m.get('ScheduleCycleDates')
        self.schedule_times = []
        if m.get('ScheduleTimes') is not None:
            for k in m.get('ScheduleTimes'):
                temp_model = CreateAIInstanceRequestScheduleTimes()
                self.schedule_times.append(temp_model.from_map(k))
        if m.get('ScheduleType') is not None:
            self.schedule_type = m.get('ScheduleType')
        if m.get('Spf') is not None:
            self.spf = m.get('Spf')
        return self


class CreateAIInstanceShrinkRequest(TeaModel):
    def __init__(self, algorithm_id=None, algorithm_name=None, compute_type=None, container_type=None,
                 data_source=None, data_source_times_shrink=None, data_type=None, fps=None, instance_name=None,
                 instance_type=None, project_id=None, schedule_cycle_dates_shrink=None, schedule_times_shrink=None,
                 schedule_type=None, spf=None):
        # 算子Id
        self.algorithm_id = algorithm_id  # type: str
        # 算法名称
        self.algorithm_name = algorithm_name  # type: str
        # 计算类型
        self.compute_type = compute_type  # type: str
        # 实例类型
        self.container_type = container_type  # type: str
        # 数据来源
        self.data_source = data_source  # type: str
        # 数据源时间段
        self.data_source_times_shrink = data_source_times_shrink  # type: str
        # 数据类型
        self.data_type = data_type  # type: str
        # 多少秒抽取1帧，取值范围[0, 3600]。 0表示不抽帧。
        self.fps = fps  # type: long
        # 实例名称
        self.instance_name = instance_name  # type: str
        # 实例类型
        self.instance_type = instance_type  # type: str
        # 所属项目Id
        self.project_id = project_id  # type: str
        # ScheduleType为EVERY_WEEK、EVERY_MONTH时必填
        self.schedule_cycle_dates_shrink = schedule_cycle_dates_shrink  # type: str
        # 执行时间段，支持多段，指定多段时不能重合交错。
        self.schedule_times_shrink = schedule_times_shrink  # type: str
        # 调度类型
        self.schedule_type = schedule_type  # type: str
        # 多少秒抽取1帧，取值范围[0, 3600]。 0表示不抽帧。
        self.spf = spf  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateAIInstanceShrinkRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.algorithm_id is not None:
            result['AlgorithmId'] = self.algorithm_id
        if self.algorithm_name is not None:
            result['AlgorithmName'] = self.algorithm_name
        if self.compute_type is not None:
            result['ComputeType'] = self.compute_type
        if self.container_type is not None:
            result['ContainerType'] = self.container_type
        if self.data_source is not None:
            result['DataSource'] = self.data_source
        if self.data_source_times_shrink is not None:
            result['DataSourceTimes'] = self.data_source_times_shrink
        if self.data_type is not None:
            result['DataType'] = self.data_type
        if self.fps is not None:
            result['Fps'] = self.fps
        if self.instance_name is not None:
            result['InstanceName'] = self.instance_name
        if self.instance_type is not None:
            result['InstanceType'] = self.instance_type
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.schedule_cycle_dates_shrink is not None:
            result['ScheduleCycleDates'] = self.schedule_cycle_dates_shrink
        if self.schedule_times_shrink is not None:
            result['ScheduleTimes'] = self.schedule_times_shrink
        if self.schedule_type is not None:
            result['ScheduleType'] = self.schedule_type
        if self.spf is not None:
            result['Spf'] = self.spf
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AlgorithmId') is not None:
            self.algorithm_id = m.get('AlgorithmId')
        if m.get('AlgorithmName') is not None:
            self.algorithm_name = m.get('AlgorithmName')
        if m.get('ComputeType') is not None:
            self.compute_type = m.get('ComputeType')
        if m.get('ContainerType') is not None:
            self.container_type = m.get('ContainerType')
        if m.get('DataSource') is not None:
            self.data_source = m.get('DataSource')
        if m.get('DataSourceTimes') is not None:
            self.data_source_times_shrink = m.get('DataSourceTimes')
        if m.get('DataType') is not None:
            self.data_type = m.get('DataType')
        if m.get('Fps') is not None:
            self.fps = m.get('Fps')
        if m.get('InstanceName') is not None:
            self.instance_name = m.get('InstanceName')
        if m.get('InstanceType') is not None:
            self.instance_type = m.get('InstanceType')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('ScheduleCycleDates') is not None:
            self.schedule_cycle_dates_shrink = m.get('ScheduleCycleDates')
        if m.get('ScheduleTimes') is not None:
            self.schedule_times_shrink = m.get('ScheduleTimes')
        if m.get('ScheduleType') is not None:
            self.schedule_type = m.get('ScheduleType')
        if m.get('Spf') is not None:
            self.spf = m.get('Spf')
        return self


class CreateAIInstanceResponseBodyData(TeaModel):
    def __init__(self, acu_used=None, instance_id=None, storage=None):
        # 当前实例ACU使用量
        self.acu_used = acu_used  # type: long
        self.instance_id = instance_id  # type: float
        self.storage = storage  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateAIInstanceResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.acu_used is not None:
            result['AcuUsed'] = self.acu_used
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.storage is not None:
            result['Storage'] = self.storage
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AcuUsed') is not None:
            self.acu_used = m.get('AcuUsed')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Storage') is not None:
            self.storage = m.get('Storage')
        return self


class CreateAIInstanceResponseBody(TeaModel):
    def __init__(self, code=None, data=None, message=None, request_id=None):
        # 返回code码
        self.code = code  # type: str
        # 返回数据
        self.data = data  # type: CreateAIInstanceResponseBodyData
        # 错误信息
        self.message = message  # type: str
        # 请求id
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(CreateAIInstanceResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = CreateAIInstanceResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateAIInstanceResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateAIInstanceResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateAIInstanceResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateAIInstanceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateComputeInstanceRequestAlgorithms(TeaModel):
    def __init__(self, algorithm_id=None, algorithm_name=None):
        self.algorithm_id = algorithm_id  # type: str
        self.algorithm_name = algorithm_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateComputeInstanceRequestAlgorithms, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.algorithm_id is not None:
            result['AlgorithmId'] = self.algorithm_id
        if self.algorithm_name is not None:
            result['AlgorithmName'] = self.algorithm_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AlgorithmId') is not None:
            self.algorithm_id = m.get('AlgorithmId')
        if m.get('AlgorithmName') is not None:
            self.algorithm_name = m.get('AlgorithmName')
        return self


class CreateComputeInstanceRequestDevices(TeaModel):
    def __init__(self, bit_rate=None, coding_format=None, device_id=None, region_id=None, resolving_power=None,
                 start_stream=None):
        self.bit_rate = bit_rate  # type: str
        self.coding_format = coding_format  # type: str
        self.device_id = device_id  # type: str
        self.region_id = region_id  # type: str
        self.resolving_power = resolving_power  # type: str
        self.start_stream = start_stream  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateComputeInstanceRequestDevices, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bit_rate is not None:
            result['BitRate'] = self.bit_rate
        if self.coding_format is not None:
            result['CodingFormat'] = self.coding_format
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resolving_power is not None:
            result['ResolvingPower'] = self.resolving_power
        if self.start_stream is not None:
            result['StartStream'] = self.start_stream
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BitRate') is not None:
            self.bit_rate = m.get('BitRate')
        if m.get('CodingFormat') is not None:
            self.coding_format = m.get('CodingFormat')
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResolvingPower') is not None:
            self.resolving_power = m.get('ResolvingPower')
        if m.get('StartStream') is not None:
            self.start_stream = m.get('StartStream')
        return self


class CreateComputeInstanceRequest(TeaModel):
    def __init__(self, acu_used=None, algorithm_type=None, algorithms=None, compute_picture_type=None,
                 compute_picture_value=None, datasource_type=None, devices=None, instance_name=None, is_frame_extraction=None,
                 is_polling=None, overall_execution_time=None, pic_topic=None, pic_type=None, polling_configs=None,
                 project_id=None, schedule_cycle_date=None, schedule_day=None, schedule_day_size=None, schedule_times=None,
                 schedule_type=None, slice_execution_time=None, storage_used=None):
        self.acu_used = acu_used  # type: long
        self.algorithm_type = algorithm_type  # type: str
        self.algorithms = algorithms  # type: list[CreateComputeInstanceRequestAlgorithms]
        self.compute_picture_type = compute_picture_type  # type: str
        self.compute_picture_value = compute_picture_value  # type: str
        self.datasource_type = datasource_type  # type: str
        self.devices = devices  # type: list[CreateComputeInstanceRequestDevices]
        self.instance_name = instance_name  # type: str
        self.is_frame_extraction = is_frame_extraction  # type: str
        self.is_polling = is_polling  # type: bool
        self.overall_execution_time = overall_execution_time  # type: str
        self.pic_topic = pic_topic  # type: str
        self.pic_type = pic_type  # type: str
        self.polling_configs = polling_configs  # type: str
        self.project_id = project_id  # type: str
        self.schedule_cycle_date = schedule_cycle_date  # type: str
        self.schedule_day = schedule_day  # type: str
        self.schedule_day_size = schedule_day_size  # type: str
        self.schedule_times = schedule_times  # type: str
        self.schedule_type = schedule_type  # type: str
        self.slice_execution_time = slice_execution_time  # type: str
        self.storage_used = storage_used  # type: str

    def validate(self):
        if self.algorithms:
            for k in self.algorithms:
                if k:
                    k.validate()
        if self.devices:
            for k in self.devices:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(CreateComputeInstanceRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.acu_used is not None:
            result['AcuUsed'] = self.acu_used
        if self.algorithm_type is not None:
            result['AlgorithmType'] = self.algorithm_type
        result['Algorithms'] = []
        if self.algorithms is not None:
            for k in self.algorithms:
                result['Algorithms'].append(k.to_map() if k else None)
        if self.compute_picture_type is not None:
            result['ComputePictureType'] = self.compute_picture_type
        if self.compute_picture_value is not None:
            result['ComputePictureValue'] = self.compute_picture_value
        if self.datasource_type is not None:
            result['DatasourceType'] = self.datasource_type
        result['Devices'] = []
        if self.devices is not None:
            for k in self.devices:
                result['Devices'].append(k.to_map() if k else None)
        if self.instance_name is not None:
            result['InstanceName'] = self.instance_name
        if self.is_frame_extraction is not None:
            result['IsFrameExtraction'] = self.is_frame_extraction
        if self.is_polling is not None:
            result['IsPolling'] = self.is_polling
        if self.overall_execution_time is not None:
            result['OverallExecutionTime'] = self.overall_execution_time
        if self.pic_topic is not None:
            result['PicTopic'] = self.pic_topic
        if self.pic_type is not None:
            result['PicType'] = self.pic_type
        if self.polling_configs is not None:
            result['PollingConfigs'] = self.polling_configs
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.schedule_cycle_date is not None:
            result['ScheduleCycleDate'] = self.schedule_cycle_date
        if self.schedule_day is not None:
            result['ScheduleDay'] = self.schedule_day
        if self.schedule_day_size is not None:
            result['ScheduleDaySize'] = self.schedule_day_size
        if self.schedule_times is not None:
            result['ScheduleTimes'] = self.schedule_times
        if self.schedule_type is not None:
            result['ScheduleType'] = self.schedule_type
        if self.slice_execution_time is not None:
            result['SliceExecutionTime'] = self.slice_execution_time
        if self.storage_used is not None:
            result['StorageUsed'] = self.storage_used
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AcuUsed') is not None:
            self.acu_used = m.get('AcuUsed')
        if m.get('AlgorithmType') is not None:
            self.algorithm_type = m.get('AlgorithmType')
        self.algorithms = []
        if m.get('Algorithms') is not None:
            for k in m.get('Algorithms'):
                temp_model = CreateComputeInstanceRequestAlgorithms()
                self.algorithms.append(temp_model.from_map(k))
        if m.get('ComputePictureType') is not None:
            self.compute_picture_type = m.get('ComputePictureType')
        if m.get('ComputePictureValue') is not None:
            self.compute_picture_value = m.get('ComputePictureValue')
        if m.get('DatasourceType') is not None:
            self.datasource_type = m.get('DatasourceType')
        self.devices = []
        if m.get('Devices') is not None:
            for k in m.get('Devices'):
                temp_model = CreateComputeInstanceRequestDevices()
                self.devices.append(temp_model.from_map(k))
        if m.get('InstanceName') is not None:
            self.instance_name = m.get('InstanceName')
        if m.get('IsFrameExtraction') is not None:
            self.is_frame_extraction = m.get('IsFrameExtraction')
        if m.get('IsPolling') is not None:
            self.is_polling = m.get('IsPolling')
        if m.get('OverallExecutionTime') is not None:
            self.overall_execution_time = m.get('OverallExecutionTime')
        if m.get('PicTopic') is not None:
            self.pic_topic = m.get('PicTopic')
        if m.get('PicType') is not None:
            self.pic_type = m.get('PicType')
        if m.get('PollingConfigs') is not None:
            self.polling_configs = m.get('PollingConfigs')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('ScheduleCycleDate') is not None:
            self.schedule_cycle_date = m.get('ScheduleCycleDate')
        if m.get('ScheduleDay') is not None:
            self.schedule_day = m.get('ScheduleDay')
        if m.get('ScheduleDaySize') is not None:
            self.schedule_day_size = m.get('ScheduleDaySize')
        if m.get('ScheduleTimes') is not None:
            self.schedule_times = m.get('ScheduleTimes')
        if m.get('ScheduleType') is not None:
            self.schedule_type = m.get('ScheduleType')
        if m.get('SliceExecutionTime') is not None:
            self.slice_execution_time = m.get('SliceExecutionTime')
        if m.get('StorageUsed') is not None:
            self.storage_used = m.get('StorageUsed')
        return self


class CreateComputeInstanceShrinkRequest(TeaModel):
    def __init__(self, acu_used=None, algorithm_type=None, algorithms_shrink=None, compute_picture_type=None,
                 compute_picture_value=None, datasource_type=None, devices_shrink=None, instance_name=None, is_frame_extraction=None,
                 is_polling=None, overall_execution_time=None, pic_topic=None, pic_type=None, polling_configs=None,
                 project_id=None, schedule_cycle_date=None, schedule_day=None, schedule_day_size=None, schedule_times=None,
                 schedule_type=None, slice_execution_time=None, storage_used=None):
        self.acu_used = acu_used  # type: long
        self.algorithm_type = algorithm_type  # type: str
        self.algorithms_shrink = algorithms_shrink  # type: str
        self.compute_picture_type = compute_picture_type  # type: str
        self.compute_picture_value = compute_picture_value  # type: str
        self.datasource_type = datasource_type  # type: str
        self.devices_shrink = devices_shrink  # type: str
        self.instance_name = instance_name  # type: str
        self.is_frame_extraction = is_frame_extraction  # type: str
        self.is_polling = is_polling  # type: bool
        self.overall_execution_time = overall_execution_time  # type: str
        self.pic_topic = pic_topic  # type: str
        self.pic_type = pic_type  # type: str
        self.polling_configs = polling_configs  # type: str
        self.project_id = project_id  # type: str
        self.schedule_cycle_date = schedule_cycle_date  # type: str
        self.schedule_day = schedule_day  # type: str
        self.schedule_day_size = schedule_day_size  # type: str
        self.schedule_times = schedule_times  # type: str
        self.schedule_type = schedule_type  # type: str
        self.slice_execution_time = slice_execution_time  # type: str
        self.storage_used = storage_used  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateComputeInstanceShrinkRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.acu_used is not None:
            result['AcuUsed'] = self.acu_used
        if self.algorithm_type is not None:
            result['AlgorithmType'] = self.algorithm_type
        if self.algorithms_shrink is not None:
            result['Algorithms'] = self.algorithms_shrink
        if self.compute_picture_type is not None:
            result['ComputePictureType'] = self.compute_picture_type
        if self.compute_picture_value is not None:
            result['ComputePictureValue'] = self.compute_picture_value
        if self.datasource_type is not None:
            result['DatasourceType'] = self.datasource_type
        if self.devices_shrink is not None:
            result['Devices'] = self.devices_shrink
        if self.instance_name is not None:
            result['InstanceName'] = self.instance_name
        if self.is_frame_extraction is not None:
            result['IsFrameExtraction'] = self.is_frame_extraction
        if self.is_polling is not None:
            result['IsPolling'] = self.is_polling
        if self.overall_execution_time is not None:
            result['OverallExecutionTime'] = self.overall_execution_time
        if self.pic_topic is not None:
            result['PicTopic'] = self.pic_topic
        if self.pic_type is not None:
            result['PicType'] = self.pic_type
        if self.polling_configs is not None:
            result['PollingConfigs'] = self.polling_configs
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.schedule_cycle_date is not None:
            result['ScheduleCycleDate'] = self.schedule_cycle_date
        if self.schedule_day is not None:
            result['ScheduleDay'] = self.schedule_day
        if self.schedule_day_size is not None:
            result['ScheduleDaySize'] = self.schedule_day_size
        if self.schedule_times is not None:
            result['ScheduleTimes'] = self.schedule_times
        if self.schedule_type is not None:
            result['ScheduleType'] = self.schedule_type
        if self.slice_execution_time is not None:
            result['SliceExecutionTime'] = self.slice_execution_time
        if self.storage_used is not None:
            result['StorageUsed'] = self.storage_used
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AcuUsed') is not None:
            self.acu_used = m.get('AcuUsed')
        if m.get('AlgorithmType') is not None:
            self.algorithm_type = m.get('AlgorithmType')
        if m.get('Algorithms') is not None:
            self.algorithms_shrink = m.get('Algorithms')
        if m.get('ComputePictureType') is not None:
            self.compute_picture_type = m.get('ComputePictureType')
        if m.get('ComputePictureValue') is not None:
            self.compute_picture_value = m.get('ComputePictureValue')
        if m.get('DatasourceType') is not None:
            self.datasource_type = m.get('DatasourceType')
        if m.get('Devices') is not None:
            self.devices_shrink = m.get('Devices')
        if m.get('InstanceName') is not None:
            self.instance_name = m.get('InstanceName')
        if m.get('IsFrameExtraction') is not None:
            self.is_frame_extraction = m.get('IsFrameExtraction')
        if m.get('IsPolling') is not None:
            self.is_polling = m.get('IsPolling')
        if m.get('OverallExecutionTime') is not None:
            self.overall_execution_time = m.get('OverallExecutionTime')
        if m.get('PicTopic') is not None:
            self.pic_topic = m.get('PicTopic')
        if m.get('PicType') is not None:
            self.pic_type = m.get('PicType')
        if m.get('PollingConfigs') is not None:
            self.polling_configs = m.get('PollingConfigs')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('ScheduleCycleDate') is not None:
            self.schedule_cycle_date = m.get('ScheduleCycleDate')
        if m.get('ScheduleDay') is not None:
            self.schedule_day = m.get('ScheduleDay')
        if m.get('ScheduleDaySize') is not None:
            self.schedule_day_size = m.get('ScheduleDaySize')
        if m.get('ScheduleTimes') is not None:
            self.schedule_times = m.get('ScheduleTimes')
        if m.get('ScheduleType') is not None:
            self.schedule_type = m.get('ScheduleType')
        if m.get('SliceExecutionTime') is not None:
            self.slice_execution_time = m.get('SliceExecutionTime')
        if m.get('StorageUsed') is not None:
            self.storage_used = m.get('StorageUsed')
        return self


class CreateComputeInstanceResponseBodyData(TeaModel):
    def __init__(self, acu_used=None, instance_id=None):
        self.acu_used = acu_used  # type: long
        self.instance_id = instance_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateComputeInstanceResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.acu_used is not None:
            result['AcuUsed'] = self.acu_used
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AcuUsed') is not None:
            self.acu_used = m.get('AcuUsed')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class CreateComputeInstanceResponseBody(TeaModel):
    def __init__(self, code=None, data=None, message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data = data  # type: CreateComputeInstanceResponseBodyData
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(CreateComputeInstanceResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = CreateComputeInstanceResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateComputeInstanceResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateComputeInstanceResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateComputeInstanceResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateComputeInstanceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateCorpRequest(TeaModel):
    def __init__(self, algorithm_type=None, app_name=None, corp_name=None, description=None, icon_path=None,
                 isv_sub_id=None, parent_corp_id=None):
        self.algorithm_type = algorithm_type  # type: str
        self.app_name = app_name  # type: str
        self.corp_name = corp_name  # type: str
        self.description = description  # type: str
        self.icon_path = icon_path  # type: str
        self.isv_sub_id = isv_sub_id  # type: str
        self.parent_corp_id = parent_corp_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateCorpRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.algorithm_type is not None:
            result['AlgorithmType'] = self.algorithm_type
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.corp_name is not None:
            result['CorpName'] = self.corp_name
        if self.description is not None:
            result['Description'] = self.description
        if self.icon_path is not None:
            result['IconPath'] = self.icon_path
        if self.isv_sub_id is not None:
            result['IsvSubId'] = self.isv_sub_id
        if self.parent_corp_id is not None:
            result['ParentCorpId'] = self.parent_corp_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AlgorithmType') is not None:
            self.algorithm_type = m.get('AlgorithmType')
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('CorpName') is not None:
            self.corp_name = m.get('CorpName')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('IconPath') is not None:
            self.icon_path = m.get('IconPath')
        if m.get('IsvSubId') is not None:
            self.isv_sub_id = m.get('IsvSubId')
        if m.get('ParentCorpId') is not None:
            self.parent_corp_id = m.get('ParentCorpId')
        return self


class CreateCorpResponseBody(TeaModel):
    def __init__(self, code=None, corp_id=None, message=None, request_id=None):
        self.code = code  # type: str
        self.corp_id = corp_id  # type: str
        self.message = message  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateCorpResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.corp_id is not None:
            result['CorpId'] = self.corp_id
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('CorpId') is not None:
            self.corp_id = m.get('CorpId')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateCorpResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateCorpResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateCorpResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateCorpResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateCorpGroupRequest(TeaModel):
    def __init__(self, client_token=None, corp_id=None, group_id=None):
        self.client_token = client_token  # type: str
        self.corp_id = corp_id  # type: str
        self.group_id = group_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateCorpGroupRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.corp_id is not None:
            result['CorpId'] = self.corp_id
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('CorpId') is not None:
            self.corp_id = m.get('CorpId')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        return self


class CreateCorpGroupResponseBody(TeaModel):
    def __init__(self, code=None, message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateCorpGroupResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateCorpGroupResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateCorpGroupResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateCorpGroupResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateCorpGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateDeviceRequest(TeaModel):
    def __init__(self, activate_code=None, audio_enable=None, city_code=None, corp_id=None, data_source_type=None,
                 device_address=None, device_direction=None, device_id=None, device_model=None, device_name=None, device_rate=None,
                 device_resolution=None, device_site=None, device_sn=None, device_type=None, encode_format=None, frame_rate=None,
                 gov_length=None, in_protocol=None, latitude=None, longitude=None, osdtime_enable=None, osdtime_type=None,
                 osdtime_x=None, osdtime_y=None, parent_device_id=None, sub_device_count=None, sub_device_id_list=None,
                 up_stream_mode=None, vendor=None):
        self.activate_code = activate_code  # type: str
        self.audio_enable = audio_enable  # type: str
        self.city_code = city_code  # type: str
        self.corp_id = corp_id  # type: str
        self.data_source_type = data_source_type  # type: str
        self.device_address = device_address  # type: str
        self.device_direction = device_direction  # type: str
        self.device_id = device_id  # type: str
        self.device_model = device_model  # type: str
        self.device_name = device_name  # type: str
        self.device_rate = device_rate  # type: str
        self.device_resolution = device_resolution  # type: str
        self.device_site = device_site  # type: str
        self.device_sn = device_sn  # type: str
        self.device_type = device_type  # type: str
        self.encode_format = encode_format  # type: str
        self.frame_rate = frame_rate  # type: str
        self.gov_length = gov_length  # type: str
        self.in_protocol = in_protocol  # type: str
        self.latitude = latitude  # type: str
        self.longitude = longitude  # type: str
        self.osdtime_enable = osdtime_enable  # type: str
        self.osdtime_type = osdtime_type  # type: str
        self.osdtime_x = osdtime_x  # type: str
        self.osdtime_y = osdtime_y  # type: str
        self.parent_device_id = parent_device_id  # type: str
        self.sub_device_count = sub_device_count  # type: long
        self.sub_device_id_list = sub_device_id_list  # type: str
        self.up_stream_mode = up_stream_mode  # type: str
        self.vendor = vendor  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateDeviceRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.activate_code is not None:
            result['ActivateCode'] = self.activate_code
        if self.audio_enable is not None:
            result['AudioEnable'] = self.audio_enable
        if self.city_code is not None:
            result['CityCode'] = self.city_code
        if self.corp_id is not None:
            result['CorpId'] = self.corp_id
        if self.data_source_type is not None:
            result['DataSourceType'] = self.data_source_type
        if self.device_address is not None:
            result['DeviceAddress'] = self.device_address
        if self.device_direction is not None:
            result['DeviceDirection'] = self.device_direction
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.device_model is not None:
            result['DeviceModel'] = self.device_model
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.device_rate is not None:
            result['DeviceRate'] = self.device_rate
        if self.device_resolution is not None:
            result['DeviceResolution'] = self.device_resolution
        if self.device_site is not None:
            result['DeviceSite'] = self.device_site
        if self.device_sn is not None:
            result['DeviceSn'] = self.device_sn
        if self.device_type is not None:
            result['DeviceType'] = self.device_type
        if self.encode_format is not None:
            result['EncodeFormat'] = self.encode_format
        if self.frame_rate is not None:
            result['FrameRate'] = self.frame_rate
        if self.gov_length is not None:
            result['GovLength'] = self.gov_length
        if self.in_protocol is not None:
            result['InProtocol'] = self.in_protocol
        if self.latitude is not None:
            result['Latitude'] = self.latitude
        if self.longitude is not None:
            result['Longitude'] = self.longitude
        if self.osdtime_enable is not None:
            result['OSDTimeEnable'] = self.osdtime_enable
        if self.osdtime_type is not None:
            result['OSDTimeType'] = self.osdtime_type
        if self.osdtime_x is not None:
            result['OSDTimeX'] = self.osdtime_x
        if self.osdtime_y is not None:
            result['OSDTimeY'] = self.osdtime_y
        if self.parent_device_id is not None:
            result['ParentDeviceId'] = self.parent_device_id
        if self.sub_device_count is not None:
            result['SubDeviceCount'] = self.sub_device_count
        if self.sub_device_id_list is not None:
            result['SubDeviceIdList'] = self.sub_device_id_list
        if self.up_stream_mode is not None:
            result['UpStreamMode'] = self.up_stream_mode
        if self.vendor is not None:
            result['Vendor'] = self.vendor
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ActivateCode') is not None:
            self.activate_code = m.get('ActivateCode')
        if m.get('AudioEnable') is not None:
            self.audio_enable = m.get('AudioEnable')
        if m.get('CityCode') is not None:
            self.city_code = m.get('CityCode')
        if m.get('CorpId') is not None:
            self.corp_id = m.get('CorpId')
        if m.get('DataSourceType') is not None:
            self.data_source_type = m.get('DataSourceType')
        if m.get('DeviceAddress') is not None:
            self.device_address = m.get('DeviceAddress')
        if m.get('DeviceDirection') is not None:
            self.device_direction = m.get('DeviceDirection')
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('DeviceModel') is not None:
            self.device_model = m.get('DeviceModel')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('DeviceRate') is not None:
            self.device_rate = m.get('DeviceRate')
        if m.get('DeviceResolution') is not None:
            self.device_resolution = m.get('DeviceResolution')
        if m.get('DeviceSite') is not None:
            self.device_site = m.get('DeviceSite')
        if m.get('DeviceSn') is not None:
            self.device_sn = m.get('DeviceSn')
        if m.get('DeviceType') is not None:
            self.device_type = m.get('DeviceType')
        if m.get('EncodeFormat') is not None:
            self.encode_format = m.get('EncodeFormat')
        if m.get('FrameRate') is not None:
            self.frame_rate = m.get('FrameRate')
        if m.get('GovLength') is not None:
            self.gov_length = m.get('GovLength')
        if m.get('InProtocol') is not None:
            self.in_protocol = m.get('InProtocol')
        if m.get('Latitude') is not None:
            self.latitude = m.get('Latitude')
        if m.get('Longitude') is not None:
            self.longitude = m.get('Longitude')
        if m.get('OSDTimeEnable') is not None:
            self.osdtime_enable = m.get('OSDTimeEnable')
        if m.get('OSDTimeType') is not None:
            self.osdtime_type = m.get('OSDTimeType')
        if m.get('OSDTimeX') is not None:
            self.osdtime_x = m.get('OSDTimeX')
        if m.get('OSDTimeY') is not None:
            self.osdtime_y = m.get('OSDTimeY')
        if m.get('ParentDeviceId') is not None:
            self.parent_device_id = m.get('ParentDeviceId')
        if m.get('SubDeviceCount') is not None:
            self.sub_device_count = m.get('SubDeviceCount')
        if m.get('SubDeviceIdList') is not None:
            self.sub_device_id_list = m.get('SubDeviceIdList')
        if m.get('UpStreamMode') is not None:
            self.up_stream_mode = m.get('UpStreamMode')
        if m.get('Vendor') is not None:
            self.vendor = m.get('Vendor')
        return self


class CreateDeviceResponseBodyDataSubDeviceInfo(TeaModel):
    def __init__(self, sub_device_id=None):
        self.sub_device_id = sub_device_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateDeviceResponseBodyDataSubDeviceInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.sub_device_id is not None:
            result['SubDeviceId'] = self.sub_device_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('SubDeviceId') is not None:
            self.sub_device_id = m.get('SubDeviceId')
        return self


class CreateDeviceResponseBodyData(TeaModel):
    def __init__(self, device_id=None, password=None, server_id=None, server_ip=None, server_port=None,
                 server_realm=None, sub_device_info=None):
        self.device_id = device_id  # type: str
        self.password = password  # type: str
        self.server_id = server_id  # type: str
        self.server_ip = server_ip  # type: str
        self.server_port = server_port  # type: str
        self.server_realm = server_realm  # type: str
        self.sub_device_info = sub_device_info  # type: list[CreateDeviceResponseBodyDataSubDeviceInfo]

    def validate(self):
        if self.sub_device_info:
            for k in self.sub_device_info:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(CreateDeviceResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.password is not None:
            result['Password'] = self.password
        if self.server_id is not None:
            result['ServerId'] = self.server_id
        if self.server_ip is not None:
            result['ServerIp'] = self.server_ip
        if self.server_port is not None:
            result['ServerPort'] = self.server_port
        if self.server_realm is not None:
            result['ServerRealm'] = self.server_realm
        result['SubDeviceInfo'] = []
        if self.sub_device_info is not None:
            for k in self.sub_device_info:
                result['SubDeviceInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('Password') is not None:
            self.password = m.get('Password')
        if m.get('ServerId') is not None:
            self.server_id = m.get('ServerId')
        if m.get('ServerIp') is not None:
            self.server_ip = m.get('ServerIp')
        if m.get('ServerPort') is not None:
            self.server_port = m.get('ServerPort')
        if m.get('ServerRealm') is not None:
            self.server_realm = m.get('ServerRealm')
        self.sub_device_info = []
        if m.get('SubDeviceInfo') is not None:
            for k in m.get('SubDeviceInfo'):
                temp_model = CreateDeviceResponseBodyDataSubDeviceInfo()
                self.sub_device_info.append(temp_model.from_map(k))
        return self


class CreateDeviceResponseBody(TeaModel):
    def __init__(self, code=None, data=None, message=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: CreateDeviceResponseBodyData
        self.message = message  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(CreateDeviceResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = CreateDeviceResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateDeviceResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateDeviceResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateDeviceResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateDeviceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateModelServiceRequest(TeaModel):
    def __init__(self, algorithm_code=None, client_token=None, instance_name=None, qpsrequired=None):
        self.algorithm_code = algorithm_code  # type: str
        self.client_token = client_token  # type: str
        self.instance_name = instance_name  # type: str
        self.qpsrequired = qpsrequired  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateModelServiceRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.algorithm_code is not None:
            result['AlgorithmCode'] = self.algorithm_code
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.instance_name is not None:
            result['InstanceName'] = self.instance_name
        if self.qpsrequired is not None:
            result['QPSRequired'] = self.qpsrequired
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AlgorithmCode') is not None:
            self.algorithm_code = m.get('AlgorithmCode')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('InstanceName') is not None:
            self.instance_name = m.get('InstanceName')
        if m.get('QPSRequired') is not None:
            self.qpsrequired = m.get('QPSRequired')
        return self


class CreateModelServiceResponseBodyDataModelApiList(TeaModel):
    def __init__(self, algorithm_api_code=None, api_id=None, api_name=None, api_path=None, create_time=None):
        self.algorithm_api_code = algorithm_api_code  # type: str
        self.api_id = api_id  # type: str
        self.api_name = api_name  # type: str
        self.api_path = api_path  # type: str
        self.create_time = create_time  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateModelServiceResponseBodyDataModelApiList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.algorithm_api_code is not None:
            result['AlgorithmApiCode'] = self.algorithm_api_code
        if self.api_id is not None:
            result['ApiId'] = self.api_id
        if self.api_name is not None:
            result['ApiName'] = self.api_name
        if self.api_path is not None:
            result['ApiPath'] = self.api_path
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AlgorithmApiCode') is not None:
            self.algorithm_api_code = m.get('AlgorithmApiCode')
        if m.get('ApiId') is not None:
            self.api_id = m.get('ApiId')
        if m.get('ApiName') is not None:
            self.api_name = m.get('ApiName')
        if m.get('ApiPath') is not None:
            self.api_path = m.get('ApiPath')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        return self


class CreateModelServiceResponseBodyData(TeaModel):
    def __init__(self, app_code=None, model_api_list=None, model_service_instance_id=None,
                 model_service_status=None, qps_required=None):
        self.app_code = app_code  # type: str
        self.model_api_list = model_api_list  # type: list[CreateModelServiceResponseBodyDataModelApiList]
        self.model_service_instance_id = model_service_instance_id  # type: str
        self.model_service_status = model_service_status  # type: str
        self.qps_required = qps_required  # type: int

    def validate(self):
        if self.model_api_list:
            for k in self.model_api_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(CreateModelServiceResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_code is not None:
            result['AppCode'] = self.app_code
        result['ModelApiList'] = []
        if self.model_api_list is not None:
            for k in self.model_api_list:
                result['ModelApiList'].append(k.to_map() if k else None)
        if self.model_service_instance_id is not None:
            result['ModelServiceInstanceId'] = self.model_service_instance_id
        if self.model_service_status is not None:
            result['ModelServiceStatus'] = self.model_service_status
        if self.qps_required is not None:
            result['QpsRequired'] = self.qps_required
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AppCode') is not None:
            self.app_code = m.get('AppCode')
        self.model_api_list = []
        if m.get('ModelApiList') is not None:
            for k in m.get('ModelApiList'):
                temp_model = CreateModelServiceResponseBodyDataModelApiList()
                self.model_api_list.append(temp_model.from_map(k))
        if m.get('ModelServiceInstanceId') is not None:
            self.model_service_instance_id = m.get('ModelServiceInstanceId')
        if m.get('ModelServiceStatus') is not None:
            self.model_service_status = m.get('ModelServiceStatus')
        if m.get('QpsRequired') is not None:
            self.qps_required = m.get('QpsRequired')
        return self


class CreateModelServiceResponseBody(TeaModel):
    def __init__(self, code=None, data=None, message=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: CreateModelServiceResponseBodyData
        self.message = message  # type: str
        # Id of the request
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(CreateModelServiceResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = CreateModelServiceResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateModelServiceResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateModelServiceResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateModelServiceResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateModelServiceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateNewDeviceRequest(TeaModel):
    def __init__(self, city_code=None, corp_id=None, data_source_type=None, device_address=None, device_id=None,
                 device_model=None, device_name=None, device_type=None, file_path=None, in_protocol=None, latitude=None,
                 longitude=None, sub_device_count=None, vendor=None):
        self.city_code = city_code  # type: str
        self.corp_id = corp_id  # type: str
        self.data_source_type = data_source_type  # type: str
        self.device_address = device_address  # type: str
        self.device_id = device_id  # type: str
        self.device_model = device_model  # type: str
        self.device_name = device_name  # type: str
        self.device_type = device_type  # type: str
        self.file_path = file_path  # type: str
        self.in_protocol = in_protocol  # type: str
        self.latitude = latitude  # type: str
        self.longitude = longitude  # type: str
        self.sub_device_count = sub_device_count  # type: long
        self.vendor = vendor  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateNewDeviceRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.city_code is not None:
            result['CityCode'] = self.city_code
        if self.corp_id is not None:
            result['CorpId'] = self.corp_id
        if self.data_source_type is not None:
            result['DataSourceType'] = self.data_source_type
        if self.device_address is not None:
            result['DeviceAddress'] = self.device_address
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.device_model is not None:
            result['DeviceModel'] = self.device_model
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.device_type is not None:
            result['DeviceType'] = self.device_type
        if self.file_path is not None:
            result['FilePath'] = self.file_path
        if self.in_protocol is not None:
            result['InProtocol'] = self.in_protocol
        if self.latitude is not None:
            result['Latitude'] = self.latitude
        if self.longitude is not None:
            result['Longitude'] = self.longitude
        if self.sub_device_count is not None:
            result['SubDeviceCount'] = self.sub_device_count
        if self.vendor is not None:
            result['Vendor'] = self.vendor
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CityCode') is not None:
            self.city_code = m.get('CityCode')
        if m.get('CorpId') is not None:
            self.corp_id = m.get('CorpId')
        if m.get('DataSourceType') is not None:
            self.data_source_type = m.get('DataSourceType')
        if m.get('DeviceAddress') is not None:
            self.device_address = m.get('DeviceAddress')
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('DeviceModel') is not None:
            self.device_model = m.get('DeviceModel')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('DeviceType') is not None:
            self.device_type = m.get('DeviceType')
        if m.get('FilePath') is not None:
            self.file_path = m.get('FilePath')
        if m.get('InProtocol') is not None:
            self.in_protocol = m.get('InProtocol')
        if m.get('Latitude') is not None:
            self.latitude = m.get('Latitude')
        if m.get('Longitude') is not None:
            self.longitude = m.get('Longitude')
        if m.get('SubDeviceCount') is not None:
            self.sub_device_count = m.get('SubDeviceCount')
        if m.get('Vendor') is not None:
            self.vendor = m.get('Vendor')
        return self


class CreateNewDeviceResponseBodyDataSubDeviceInfo(TeaModel):
    def __init__(self, channel_device_id=None):
        self.channel_device_id = channel_device_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateNewDeviceResponseBodyDataSubDeviceInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.channel_device_id is not None:
            result['ChannelDeviceId'] = self.channel_device_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ChannelDeviceId') is not None:
            self.channel_device_id = m.get('ChannelDeviceId')
        return self


class CreateNewDeviceResponseBodyData(TeaModel):
    def __init__(self, device_id=None, password=None, server_id=None, server_ip=None, server_port=None,
                 sip_realm=None, sub_device_info=None):
        self.device_id = device_id  # type: str
        self.password = password  # type: str
        self.server_id = server_id  # type: str
        self.server_ip = server_ip  # type: str
        self.server_port = server_port  # type: str
        self.sip_realm = sip_realm  # type: str
        self.sub_device_info = sub_device_info  # type: list[CreateNewDeviceResponseBodyDataSubDeviceInfo]

    def validate(self):
        if self.sub_device_info:
            for k in self.sub_device_info:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(CreateNewDeviceResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.password is not None:
            result['Password'] = self.password
        if self.server_id is not None:
            result['ServerId'] = self.server_id
        if self.server_ip is not None:
            result['ServerIp'] = self.server_ip
        if self.server_port is not None:
            result['ServerPort'] = self.server_port
        if self.sip_realm is not None:
            result['SipRealm'] = self.sip_realm
        result['SubDeviceInfo'] = []
        if self.sub_device_info is not None:
            for k in self.sub_device_info:
                result['SubDeviceInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('Password') is not None:
            self.password = m.get('Password')
        if m.get('ServerId') is not None:
            self.server_id = m.get('ServerId')
        if m.get('ServerIp') is not None:
            self.server_ip = m.get('ServerIp')
        if m.get('ServerPort') is not None:
            self.server_port = m.get('ServerPort')
        if m.get('SipRealm') is not None:
            self.sip_realm = m.get('SipRealm')
        self.sub_device_info = []
        if m.get('SubDeviceInfo') is not None:
            for k in m.get('SubDeviceInfo'):
                temp_model = CreateNewDeviceResponseBodyDataSubDeviceInfo()
                self.sub_device_info.append(temp_model.from_map(k))
        return self


class CreateNewDeviceResponseBody(TeaModel):
    def __init__(self, code=None, data=None, message=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: CreateNewDeviceResponseBodyData
        self.message = message  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(CreateNewDeviceResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = CreateNewDeviceResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateNewDeviceResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateNewDeviceResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateNewDeviceResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateNewDeviceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateScanDeviceRequest(TeaModel):
    def __init__(self, audio_enable=None, city_code=None, corp_id=None, data_source_type=None, device_address=None,
                 device_direction=None, device_id=None, device_model=None, device_name=None, device_rate=None,
                 device_resolution=None, device_site=None, device_sn=None, device_type=None, encode_format=None, frame_rate=None,
                 gov_length=None, in_protocol=None, latitude=None, longitude=None, osdtime_enable=None, osdtime_type=None,
                 osdtime_x=None, osdtime_y=None, sub_device_count=None, vendor=None):
        self.audio_enable = audio_enable  # type: str
        self.city_code = city_code  # type: str
        self.corp_id = corp_id  # type: str
        self.data_source_type = data_source_type  # type: str
        self.device_address = device_address  # type: str
        self.device_direction = device_direction  # type: str
        self.device_id = device_id  # type: str
        self.device_model = device_model  # type: str
        self.device_name = device_name  # type: str
        self.device_rate = device_rate  # type: str
        self.device_resolution = device_resolution  # type: str
        self.device_site = device_site  # type: str
        self.device_sn = device_sn  # type: str
        self.device_type = device_type  # type: str
        self.encode_format = encode_format  # type: str
        self.frame_rate = frame_rate  # type: str
        self.gov_length = gov_length  # type: str
        self.in_protocol = in_protocol  # type: str
        self.latitude = latitude  # type: str
        self.longitude = longitude  # type: str
        self.osdtime_enable = osdtime_enable  # type: str
        self.osdtime_type = osdtime_type  # type: str
        self.osdtime_x = osdtime_x  # type: str
        self.osdtime_y = osdtime_y  # type: str
        self.sub_device_count = sub_device_count  # type: long
        self.vendor = vendor  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateScanDeviceRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.audio_enable is not None:
            result['AudioEnable'] = self.audio_enable
        if self.city_code is not None:
            result['CityCode'] = self.city_code
        if self.corp_id is not None:
            result['CorpId'] = self.corp_id
        if self.data_source_type is not None:
            result['DataSourceType'] = self.data_source_type
        if self.device_address is not None:
            result['DeviceAddress'] = self.device_address
        if self.device_direction is not None:
            result['DeviceDirection'] = self.device_direction
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.device_model is not None:
            result['DeviceModel'] = self.device_model
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.device_rate is not None:
            result['DeviceRate'] = self.device_rate
        if self.device_resolution is not None:
            result['DeviceResolution'] = self.device_resolution
        if self.device_site is not None:
            result['DeviceSite'] = self.device_site
        if self.device_sn is not None:
            result['DeviceSn'] = self.device_sn
        if self.device_type is not None:
            result['DeviceType'] = self.device_type
        if self.encode_format is not None:
            result['EncodeFormat'] = self.encode_format
        if self.frame_rate is not None:
            result['FrameRate'] = self.frame_rate
        if self.gov_length is not None:
            result['GovLength'] = self.gov_length
        if self.in_protocol is not None:
            result['InProtocol'] = self.in_protocol
        if self.latitude is not None:
            result['Latitude'] = self.latitude
        if self.longitude is not None:
            result['Longitude'] = self.longitude
        if self.osdtime_enable is not None:
            result['OSDTimeEnable'] = self.osdtime_enable
        if self.osdtime_type is not None:
            result['OSDTimeType'] = self.osdtime_type
        if self.osdtime_x is not None:
            result['OSDTimeX'] = self.osdtime_x
        if self.osdtime_y is not None:
            result['OSDTimeY'] = self.osdtime_y
        if self.sub_device_count is not None:
            result['SubDeviceCount'] = self.sub_device_count
        if self.vendor is not None:
            result['Vendor'] = self.vendor
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AudioEnable') is not None:
            self.audio_enable = m.get('AudioEnable')
        if m.get('CityCode') is not None:
            self.city_code = m.get('CityCode')
        if m.get('CorpId') is not None:
            self.corp_id = m.get('CorpId')
        if m.get('DataSourceType') is not None:
            self.data_source_type = m.get('DataSourceType')
        if m.get('DeviceAddress') is not None:
            self.device_address = m.get('DeviceAddress')
        if m.get('DeviceDirection') is not None:
            self.device_direction = m.get('DeviceDirection')
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('DeviceModel') is not None:
            self.device_model = m.get('DeviceModel')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('DeviceRate') is not None:
            self.device_rate = m.get('DeviceRate')
        if m.get('DeviceResolution') is not None:
            self.device_resolution = m.get('DeviceResolution')
        if m.get('DeviceSite') is not None:
            self.device_site = m.get('DeviceSite')
        if m.get('DeviceSn') is not None:
            self.device_sn = m.get('DeviceSn')
        if m.get('DeviceType') is not None:
            self.device_type = m.get('DeviceType')
        if m.get('EncodeFormat') is not None:
            self.encode_format = m.get('EncodeFormat')
        if m.get('FrameRate') is not None:
            self.frame_rate = m.get('FrameRate')
        if m.get('GovLength') is not None:
            self.gov_length = m.get('GovLength')
        if m.get('InProtocol') is not None:
            self.in_protocol = m.get('InProtocol')
        if m.get('Latitude') is not None:
            self.latitude = m.get('Latitude')
        if m.get('Longitude') is not None:
            self.longitude = m.get('Longitude')
        if m.get('OSDTimeEnable') is not None:
            self.osdtime_enable = m.get('OSDTimeEnable')
        if m.get('OSDTimeType') is not None:
            self.osdtime_type = m.get('OSDTimeType')
        if m.get('OSDTimeX') is not None:
            self.osdtime_x = m.get('OSDTimeX')
        if m.get('OSDTimeY') is not None:
            self.osdtime_y = m.get('OSDTimeY')
        if m.get('SubDeviceCount') is not None:
            self.sub_device_count = m.get('SubDeviceCount')
        if m.get('Vendor') is not None:
            self.vendor = m.get('Vendor')
        return self


class CreateScanDeviceResponseBodyDataSubDeviceInfo(TeaModel):
    def __init__(self, channel_device_id=None):
        self.channel_device_id = channel_device_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateScanDeviceResponseBodyDataSubDeviceInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.channel_device_id is not None:
            result['ChannelDeviceId'] = self.channel_device_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ChannelDeviceId') is not None:
            self.channel_device_id = m.get('ChannelDeviceId')
        return self


class CreateScanDeviceResponseBodyData(TeaModel):
    def __init__(self, corp_id=None, device_id=None, device_sn=None, password=None, server_id=None, server_ip=None,
                 server_port=None, server_realm=None, sip_device_gb_id=None, sub_device_info=None):
        self.corp_id = corp_id  # type: str
        self.device_id = device_id  # type: str
        self.device_sn = device_sn  # type: str
        self.password = password  # type: str
        self.server_id = server_id  # type: str
        self.server_ip = server_ip  # type: str
        self.server_port = server_port  # type: str
        self.server_realm = server_realm  # type: str
        self.sip_device_gb_id = sip_device_gb_id  # type: str
        self.sub_device_info = sub_device_info  # type: list[CreateScanDeviceResponseBodyDataSubDeviceInfo]

    def validate(self):
        if self.sub_device_info:
            for k in self.sub_device_info:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(CreateScanDeviceResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.corp_id is not None:
            result['CorpId'] = self.corp_id
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.device_sn is not None:
            result['DeviceSn'] = self.device_sn
        if self.password is not None:
            result['Password'] = self.password
        if self.server_id is not None:
            result['ServerId'] = self.server_id
        if self.server_ip is not None:
            result['ServerIp'] = self.server_ip
        if self.server_port is not None:
            result['ServerPort'] = self.server_port
        if self.server_realm is not None:
            result['ServerRealm'] = self.server_realm
        if self.sip_device_gb_id is not None:
            result['SipDeviceGbId'] = self.sip_device_gb_id
        result['SubDeviceInfo'] = []
        if self.sub_device_info is not None:
            for k in self.sub_device_info:
                result['SubDeviceInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CorpId') is not None:
            self.corp_id = m.get('CorpId')
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('DeviceSn') is not None:
            self.device_sn = m.get('DeviceSn')
        if m.get('Password') is not None:
            self.password = m.get('Password')
        if m.get('ServerId') is not None:
            self.server_id = m.get('ServerId')
        if m.get('ServerIp') is not None:
            self.server_ip = m.get('ServerIp')
        if m.get('ServerPort') is not None:
            self.server_port = m.get('ServerPort')
        if m.get('ServerRealm') is not None:
            self.server_realm = m.get('ServerRealm')
        if m.get('SipDeviceGbId') is not None:
            self.sip_device_gb_id = m.get('SipDeviceGbId')
        self.sub_device_info = []
        if m.get('SubDeviceInfo') is not None:
            for k in m.get('SubDeviceInfo'):
                temp_model = CreateScanDeviceResponseBodyDataSubDeviceInfo()
                self.sub_device_info.append(temp_model.from_map(k))
        return self


class CreateScanDeviceResponseBody(TeaModel):
    def __init__(self, code=None, data=None, message=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: CreateScanDeviceResponseBodyData
        self.message = message  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(CreateScanDeviceResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = CreateScanDeviceResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateScanDeviceResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateScanDeviceResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateScanDeviceResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateScanDeviceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateSearchTableRequest(TeaModel):
    def __init__(self, algorithm_id=None, search_table_name=None, target_type=None):
        self.algorithm_id = algorithm_id  # type: str
        self.search_table_name = search_table_name  # type: str
        self.target_type = target_type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateSearchTableRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.algorithm_id is not None:
            result['AlgorithmId'] = self.algorithm_id
        if self.search_table_name is not None:
            result['SearchTableName'] = self.search_table_name
        if self.target_type is not None:
            result['TargetType'] = self.target_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AlgorithmId') is not None:
            self.algorithm_id = m.get('AlgorithmId')
        if m.get('SearchTableName') is not None:
            self.search_table_name = m.get('SearchTableName')
        if m.get('TargetType') is not None:
            self.target_type = m.get('TargetType')
        return self


class CreateSearchTableResponseBodyData(TeaModel):
    def __init__(self, search_table_id=None):
        self.search_table_id = search_table_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateSearchTableResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.search_table_id is not None:
            result['SearchTableId'] = self.search_table_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('SearchTableId') is not None:
            self.search_table_id = m.get('SearchTableId')
        return self


class CreateSearchTableResponseBody(TeaModel):
    def __init__(self, code=None, data=None, message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data = data  # type: CreateSearchTableResponseBodyData
        self.message = message  # type: str
        # Id of the request
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(CreateSearchTableResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = CreateSearchTableResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateSearchTableResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateSearchTableResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateSearchTableResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateSearchTableResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateSubscribeRequest(TeaModel):
    def __init__(self, device_id=None, push_config=None):
        self.device_id = device_id  # type: str
        self.push_config = push_config  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateSubscribeRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.push_config is not None:
            result['PushConfig'] = self.push_config
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('PushConfig') is not None:
            self.push_config = m.get('PushConfig')
        return self


class CreateSubscribeResponseBody(TeaModel):
    def __init__(self, code=None, message=None, request_id=None):
        self.code = code  # type: str
        self.message = message  # type: str
        # Id of the request
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateSubscribeResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateSubscribeResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateSubscribeResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateSubscribeResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateSubscribeResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateUserRequest(TeaModel):
    def __init__(self, address=None, age=None, attachment=None, biz_id=None, corp_id=None, face_image_url=None,
                 gender=None, id_number=None, isv_sub_id=None, phone_no=None, plate_no=None, user_group_id=None,
                 user_name=None):
        self.address = address  # type: str
        self.age = age  # type: int
        self.attachment = attachment  # type: str
        self.biz_id = biz_id  # type: str
        self.corp_id = corp_id  # type: str
        self.face_image_url = face_image_url  # type: str
        self.gender = gender  # type: int
        self.id_number = id_number  # type: str
        self.isv_sub_id = isv_sub_id  # type: str
        self.phone_no = phone_no  # type: str
        self.plate_no = plate_no  # type: str
        self.user_group_id = user_group_id  # type: long
        self.user_name = user_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateUserRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.address is not None:
            result['Address'] = self.address
        if self.age is not None:
            result['Age'] = self.age
        if self.attachment is not None:
            result['Attachment'] = self.attachment
        if self.biz_id is not None:
            result['BizId'] = self.biz_id
        if self.corp_id is not None:
            result['CorpId'] = self.corp_id
        if self.face_image_url is not None:
            result['FaceImageUrl'] = self.face_image_url
        if self.gender is not None:
            result['Gender'] = self.gender
        if self.id_number is not None:
            result['IdNumber'] = self.id_number
        if self.isv_sub_id is not None:
            result['IsvSubId'] = self.isv_sub_id
        if self.phone_no is not None:
            result['PhoneNo'] = self.phone_no
        if self.plate_no is not None:
            result['PlateNo'] = self.plate_no
        if self.user_group_id is not None:
            result['UserGroupId'] = self.user_group_id
        if self.user_name is not None:
            result['UserName'] = self.user_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Address') is not None:
            self.address = m.get('Address')
        if m.get('Age') is not None:
            self.age = m.get('Age')
        if m.get('Attachment') is not None:
            self.attachment = m.get('Attachment')
        if m.get('BizId') is not None:
            self.biz_id = m.get('BizId')
        if m.get('CorpId') is not None:
            self.corp_id = m.get('CorpId')
        if m.get('FaceImageUrl') is not None:
            self.face_image_url = m.get('FaceImageUrl')
        if m.get('Gender') is not None:
            self.gender = m.get('Gender')
        if m.get('IdNumber') is not None:
            self.id_number = m.get('IdNumber')
        if m.get('IsvSubId') is not None:
            self.isv_sub_id = m.get('IsvSubId')
        if m.get('PhoneNo') is not None:
            self.phone_no = m.get('PhoneNo')
        if m.get('PlateNo') is not None:
            self.plate_no = m.get('PlateNo')
        if m.get('UserGroupId') is not None:
            self.user_group_id = m.get('UserGroupId')
        if m.get('UserName') is not None:
            self.user_name = m.get('UserName')
        return self


class CreateUserResponseBodyData(TeaModel):
    def __init__(self, address=None, age=None, attachment=None, biz_id=None, face_image_url=None, gender=None,
                 id_number=None, isv_sub_id=None, phone_no=None, plate_no=None, user_group_id=None, user_id=None,
                 user_name=None):
        self.address = address  # type: str
        self.age = age  # type: str
        self.attachment = attachment  # type: str
        self.biz_id = biz_id  # type: str
        self.face_image_url = face_image_url  # type: str
        self.gender = gender  # type: str
        self.id_number = id_number  # type: str
        self.isv_sub_id = isv_sub_id  # type: str
        self.phone_no = phone_no  # type: str
        self.plate_no = plate_no  # type: str
        self.user_group_id = user_group_id  # type: int
        self.user_id = user_id  # type: int
        self.user_name = user_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateUserResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.address is not None:
            result['Address'] = self.address
        if self.age is not None:
            result['Age'] = self.age
        if self.attachment is not None:
            result['Attachment'] = self.attachment
        if self.biz_id is not None:
            result['BizId'] = self.biz_id
        if self.face_image_url is not None:
            result['FaceImageUrl'] = self.face_image_url
        if self.gender is not None:
            result['Gender'] = self.gender
        if self.id_number is not None:
            result['IdNumber'] = self.id_number
        if self.isv_sub_id is not None:
            result['IsvSubId'] = self.isv_sub_id
        if self.phone_no is not None:
            result['PhoneNo'] = self.phone_no
        if self.plate_no is not None:
            result['PlateNo'] = self.plate_no
        if self.user_group_id is not None:
            result['UserGroupId'] = self.user_group_id
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.user_name is not None:
            result['UserName'] = self.user_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Address') is not None:
            self.address = m.get('Address')
        if m.get('Age') is not None:
            self.age = m.get('Age')
        if m.get('Attachment') is not None:
            self.attachment = m.get('Attachment')
        if m.get('BizId') is not None:
            self.biz_id = m.get('BizId')
        if m.get('FaceImageUrl') is not None:
            self.face_image_url = m.get('FaceImageUrl')
        if m.get('Gender') is not None:
            self.gender = m.get('Gender')
        if m.get('IdNumber') is not None:
            self.id_number = m.get('IdNumber')
        if m.get('IsvSubId') is not None:
            self.isv_sub_id = m.get('IsvSubId')
        if m.get('PhoneNo') is not None:
            self.phone_no = m.get('PhoneNo')
        if m.get('PlateNo') is not None:
            self.plate_no = m.get('PlateNo')
        if m.get('UserGroupId') is not None:
            self.user_group_id = m.get('UserGroupId')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('UserName') is not None:
            self.user_name = m.get('UserName')
        return self


class CreateUserResponseBody(TeaModel):
    def __init__(self, code=None, data=None, message=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: CreateUserResponseBodyData
        self.message = message  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(CreateUserResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = CreateUserResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateUserResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateUserResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateUserResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateUserResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateUserGroupRequest(TeaModel):
    def __init__(self, corp_id=None, isv_sub_id=None, parent_user_group_id=None, user_group_name=None):
        self.corp_id = corp_id  # type: str
        self.isv_sub_id = isv_sub_id  # type: str
        self.parent_user_group_id = parent_user_group_id  # type: long
        self.user_group_name = user_group_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateUserGroupRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.corp_id is not None:
            result['CorpId'] = self.corp_id
        if self.isv_sub_id is not None:
            result['IsvSubId'] = self.isv_sub_id
        if self.parent_user_group_id is not None:
            result['ParentUserGroupId'] = self.parent_user_group_id
        if self.user_group_name is not None:
            result['UserGroupName'] = self.user_group_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CorpId') is not None:
            self.corp_id = m.get('CorpId')
        if m.get('IsvSubId') is not None:
            self.isv_sub_id = m.get('IsvSubId')
        if m.get('ParentUserGroupId') is not None:
            self.parent_user_group_id = m.get('ParentUserGroupId')
        if m.get('UserGroupName') is not None:
            self.user_group_name = m.get('UserGroupName')
        return self


class CreateUserGroupResponseBodyData(TeaModel):
    def __init__(self, isv_sub_id=None, user_group_id=None, user_group_name=None):
        self.isv_sub_id = isv_sub_id  # type: str
        self.user_group_id = user_group_id  # type: long
        self.user_group_name = user_group_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateUserGroupResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.isv_sub_id is not None:
            result['IsvSubId'] = self.isv_sub_id
        if self.user_group_id is not None:
            result['UserGroupId'] = self.user_group_id
        if self.user_group_name is not None:
            result['UserGroupName'] = self.user_group_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IsvSubId') is not None:
            self.isv_sub_id = m.get('IsvSubId')
        if m.get('UserGroupId') is not None:
            self.user_group_id = m.get('UserGroupId')
        if m.get('UserGroupName') is not None:
            self.user_group_name = m.get('UserGroupName')
        return self


class CreateUserGroupResponseBody(TeaModel):
    def __init__(self, code=None, data=None, message=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: CreateUserGroupResponseBodyData
        self.message = message  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(CreateUserGroupResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = CreateUserGroupResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateUserGroupResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateUserGroupResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateUserGroupResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateUserGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateVideoComposeTaskRequest(TeaModel):
    def __init__(self, audio_file_name=None, bucket_name=None, corp_id=None, domain_name=None,
                 image_file_names=None, image_parameters=None, video_format=None, video_frame_rate=None):
        self.audio_file_name = audio_file_name  # type: str
        self.bucket_name = bucket_name  # type: str
        self.corp_id = corp_id  # type: str
        self.domain_name = domain_name  # type: str
        self.image_file_names = image_file_names  # type: str
        self.image_parameters = image_parameters  # type: str
        self.video_format = video_format  # type: str
        self.video_frame_rate = video_frame_rate  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateVideoComposeTaskRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.audio_file_name is not None:
            result['AudioFileName'] = self.audio_file_name
        if self.bucket_name is not None:
            result['BucketName'] = self.bucket_name
        if self.corp_id is not None:
            result['CorpId'] = self.corp_id
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.image_file_names is not None:
            result['ImageFileNames'] = self.image_file_names
        if self.image_parameters is not None:
            result['ImageParameters'] = self.image_parameters
        if self.video_format is not None:
            result['VideoFormat'] = self.video_format
        if self.video_frame_rate is not None:
            result['VideoFrameRate'] = self.video_frame_rate
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AudioFileName') is not None:
            self.audio_file_name = m.get('AudioFileName')
        if m.get('BucketName') is not None:
            self.bucket_name = m.get('BucketName')
        if m.get('CorpId') is not None:
            self.corp_id = m.get('CorpId')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('ImageFileNames') is not None:
            self.image_file_names = m.get('ImageFileNames')
        if m.get('ImageParameters') is not None:
            self.image_parameters = m.get('ImageParameters')
        if m.get('VideoFormat') is not None:
            self.video_format = m.get('VideoFormat')
        if m.get('VideoFrameRate') is not None:
            self.video_frame_rate = m.get('VideoFrameRate')
        return self


class CreateVideoComposeTaskResponseBody(TeaModel):
    def __init__(self, bucket_name=None, code=None, domain_name=None, message=None, request_id=None):
        self.bucket_name = bucket_name  # type: str
        self.code = code  # type: str
        self.domain_name = domain_name  # type: str
        self.message = message  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateVideoComposeTaskResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bucket_name is not None:
            result['BucketName'] = self.bucket_name
        if self.code is not None:
            result['Code'] = self.code
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BucketName') is not None:
            self.bucket_name = m.get('BucketName')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateVideoComposeTaskResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateVideoComposeTaskResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateVideoComposeTaskResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateVideoComposeTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateVideoSummaryTaskRequest(TeaModel):
    def __init__(self, corp_id=None, device_id=None, end_time_stamp=None, live_video_summary=None, option_list=None,
                 start_time_stamp=None):
        self.corp_id = corp_id  # type: str
        self.device_id = device_id  # type: str
        self.end_time_stamp = end_time_stamp  # type: long
        self.live_video_summary = live_video_summary  # type: str
        self.option_list = option_list  # type: str
        self.start_time_stamp = start_time_stamp  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateVideoSummaryTaskRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.corp_id is not None:
            result['CorpId'] = self.corp_id
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.end_time_stamp is not None:
            result['EndTimeStamp'] = self.end_time_stamp
        if self.live_video_summary is not None:
            result['LiveVideoSummary'] = self.live_video_summary
        if self.option_list is not None:
            result['OptionList'] = self.option_list
        if self.start_time_stamp is not None:
            result['StartTimeStamp'] = self.start_time_stamp
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CorpId') is not None:
            self.corp_id = m.get('CorpId')
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('EndTimeStamp') is not None:
            self.end_time_stamp = m.get('EndTimeStamp')
        if m.get('LiveVideoSummary') is not None:
            self.live_video_summary = m.get('LiveVideoSummary')
        if m.get('OptionList') is not None:
            self.option_list = m.get('OptionList')
        if m.get('StartTimeStamp') is not None:
            self.start_time_stamp = m.get('StartTimeStamp')
        return self


class CreateVideoSummaryTaskResponseBody(TeaModel):
    def __init__(self, code=None, data=None, message=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: str
        self.message = message  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateVideoSummaryTaskResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateVideoSummaryTaskResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateVideoSummaryTaskResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateVideoSummaryTaskResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateVideoSummaryTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateWatchPolicyRequest(TeaModel):
    def __init__(self, item_match_type=None, similarity_threshold=None, target_type=None, watch_mode=None,
                 watch_policy_name=None):
        self.item_match_type = item_match_type  # type: str
        self.similarity_threshold = similarity_threshold  # type: float
        self.target_type = target_type  # type: str
        self.watch_mode = watch_mode  # type: str
        self.watch_policy_name = watch_policy_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateWatchPolicyRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.item_match_type is not None:
            result['ItemMatchType'] = self.item_match_type
        if self.similarity_threshold is not None:
            result['SimilarityThreshold'] = self.similarity_threshold
        if self.target_type is not None:
            result['TargetType'] = self.target_type
        if self.watch_mode is not None:
            result['WatchMode'] = self.watch_mode
        if self.watch_policy_name is not None:
            result['WatchPolicyName'] = self.watch_policy_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ItemMatchType') is not None:
            self.item_match_type = m.get('ItemMatchType')
        if m.get('SimilarityThreshold') is not None:
            self.similarity_threshold = m.get('SimilarityThreshold')
        if m.get('TargetType') is not None:
            self.target_type = m.get('TargetType')
        if m.get('WatchMode') is not None:
            self.watch_mode = m.get('WatchMode')
        if m.get('WatchPolicyName') is not None:
            self.watch_policy_name = m.get('WatchPolicyName')
        return self


class CreateWatchPolicyResponseBodyData(TeaModel):
    def __init__(self, watch_policy_id=None):
        self.watch_policy_id = watch_policy_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateWatchPolicyResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.watch_policy_id is not None:
            result['WatchPolicyId'] = self.watch_policy_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('WatchPolicyId') is not None:
            self.watch_policy_id = m.get('WatchPolicyId')
        return self


class CreateWatchPolicyResponseBody(TeaModel):
    def __init__(self, code=None, data=None, message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data = data  # type: CreateWatchPolicyResponseBodyData
        self.message = message  # type: str
        # Id of the request
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(CreateWatchPolicyResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = CreateWatchPolicyResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateWatchPolicyResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateWatchPolicyResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateWatchPolicyResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateWatchPolicyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateWatchTaskRequest(TeaModel):
    def __init__(self, corp_id=None, description=None, device_list=None, message_receiver=None,
                 schedule_cycle_dates=None, schedule_times=None, schedule_type=None, task_name=None, watch_policy_ids=None):
        self.corp_id = corp_id  # type: str
        self.description = description  # type: str
        self.device_list = device_list  # type: str
        self.message_receiver = message_receiver  # type: str
        self.schedule_cycle_dates = schedule_cycle_dates  # type: str
        self.schedule_times = schedule_times  # type: str
        self.schedule_type = schedule_type  # type: str
        self.task_name = task_name  # type: str
        self.watch_policy_ids = watch_policy_ids  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateWatchTaskRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.corp_id is not None:
            result['CorpId'] = self.corp_id
        if self.description is not None:
            result['Description'] = self.description
        if self.device_list is not None:
            result['DeviceList'] = self.device_list
        if self.message_receiver is not None:
            result['MessageReceiver'] = self.message_receiver
        if self.schedule_cycle_dates is not None:
            result['ScheduleCycleDates'] = self.schedule_cycle_dates
        if self.schedule_times is not None:
            result['ScheduleTimes'] = self.schedule_times
        if self.schedule_type is not None:
            result['ScheduleType'] = self.schedule_type
        if self.task_name is not None:
            result['TaskName'] = self.task_name
        if self.watch_policy_ids is not None:
            result['WatchPolicyIds'] = self.watch_policy_ids
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CorpId') is not None:
            self.corp_id = m.get('CorpId')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('DeviceList') is not None:
            self.device_list = m.get('DeviceList')
        if m.get('MessageReceiver') is not None:
            self.message_receiver = m.get('MessageReceiver')
        if m.get('ScheduleCycleDates') is not None:
            self.schedule_cycle_dates = m.get('ScheduleCycleDates')
        if m.get('ScheduleTimes') is not None:
            self.schedule_times = m.get('ScheduleTimes')
        if m.get('ScheduleType') is not None:
            self.schedule_type = m.get('ScheduleType')
        if m.get('TaskName') is not None:
            self.task_name = m.get('TaskName')
        if m.get('WatchPolicyIds') is not None:
            self.watch_policy_ids = m.get('WatchPolicyIds')
        return self


class CreateWatchTaskResponseBodyData(TeaModel):
    def __init__(self, watch_task_id=None):
        self.watch_task_id = watch_task_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateWatchTaskResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.watch_task_id is not None:
            result['WatchTaskId'] = self.watch_task_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('WatchTaskId') is not None:
            self.watch_task_id = m.get('WatchTaskId')
        return self


class CreateWatchTaskResponseBody(TeaModel):
    def __init__(self, code=None, data=None, message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data = data  # type: CreateWatchTaskResponseBodyData
        self.message = message  # type: str
        # Id of the request
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(CreateWatchTaskResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = CreateWatchTaskResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateWatchTaskResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateWatchTaskResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateWatchTaskResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateWatchTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteAIInstanceRequest(TeaModel):
    def __init__(self, instance_ids=None):
        # 需要删除的计算实例id
        self.instance_ids = instance_ids  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteAIInstanceRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_ids is not None:
            result['InstanceIds'] = self.instance_ids
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceIds') is not None:
            self.instance_ids = m.get('InstanceIds')
        return self


class DeleteAIInstanceShrinkRequest(TeaModel):
    def __init__(self, instance_ids_shrink=None):
        # 需要删除的计算实例id
        self.instance_ids_shrink = instance_ids_shrink  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteAIInstanceShrinkRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_ids_shrink is not None:
            result['InstanceIds'] = self.instance_ids_shrink
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceIds') is not None:
            self.instance_ids_shrink = m.get('InstanceIds')
        return self


class DeleteAIInstanceResponseBody(TeaModel):
    def __init__(self, code=None, message=None, request_id=None):
        # 返回code码
        self.code = code  # type: str
        # 错误信息
        self.message = message  # type: str
        # Id of the request
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteAIInstanceResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteAIInstanceResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteAIInstanceResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteAIInstanceResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteAIInstanceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteAiotDeviceRequest(TeaModel):
    def __init__(self, id=None):
        self.id = id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteAiotDeviceRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['Id'] = self.id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Id') is not None:
            self.id = m.get('Id')
        return self


class DeleteAiotDeviceResponseBody(TeaModel):
    def __init__(self, code=None, message=None, request_id=None):
        self.code = code  # type: str
        self.message = message  # type: str
        # Id of the request
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteAiotDeviceResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteAiotDeviceResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteAiotDeviceResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteAiotDeviceResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteAiotDeviceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteAiotPersonTableRequest(TeaModel):
    def __init__(self, id=None, person_table_id=None):
        self.id = id  # type: str
        self.person_table_id = person_table_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteAiotPersonTableRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['Id'] = self.id
        if self.person_table_id is not None:
            result['PersonTableId'] = self.person_table_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('PersonTableId') is not None:
            self.person_table_id = m.get('PersonTableId')
        return self


class DeleteAiotPersonTableResponseBody(TeaModel):
    def __init__(self, code=None, message=None, request_id=None):
        self.code = code  # type: str
        self.message = message  # type: str
        # Id of the request
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteAiotPersonTableResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteAiotPersonTableResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteAiotPersonTableResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteAiotPersonTableResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteAiotPersonTableResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteAiotPersonTableItemRequest(TeaModel):
    def __init__(self, id=None, person_table_id=None, person_table_item_id=None):
        self.id = id  # type: str
        self.person_table_id = person_table_id  # type: str
        self.person_table_item_id = person_table_item_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteAiotPersonTableItemRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['Id'] = self.id
        if self.person_table_id is not None:
            result['PersonTableId'] = self.person_table_id
        if self.person_table_item_id is not None:
            result['PersonTableItemId'] = self.person_table_item_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('PersonTableId') is not None:
            self.person_table_id = m.get('PersonTableId')
        if m.get('PersonTableItemId') is not None:
            self.person_table_item_id = m.get('PersonTableItemId')
        return self


class DeleteAiotPersonTableItemResponseBody(TeaModel):
    def __init__(self, code=None, message=None, request_id=None):
        self.code = code  # type: str
        self.message = message  # type: str
        # Id of the request
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteAiotPersonTableItemResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteAiotPersonTableItemResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteAiotPersonTableItemResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteAiotPersonTableItemResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteAiotPersonTableItemResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteAiotVehicleTableItemRequest(TeaModel):
    def __init__(self, id=None, vehicle_table_id=None, vehicle_table_item_id=None):
        self.id = id  # type: str
        self.vehicle_table_id = vehicle_table_id  # type: str
        self.vehicle_table_item_id = vehicle_table_item_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteAiotVehicleTableItemRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['Id'] = self.id
        if self.vehicle_table_id is not None:
            result['VehicleTableId'] = self.vehicle_table_id
        if self.vehicle_table_item_id is not None:
            result['VehicleTableItemId'] = self.vehicle_table_item_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('VehicleTableId') is not None:
            self.vehicle_table_id = m.get('VehicleTableId')
        if m.get('VehicleTableItemId') is not None:
            self.vehicle_table_item_id = m.get('VehicleTableItemId')
        return self


class DeleteAiotVehicleTableItemResponseBody(TeaModel):
    def __init__(self, code=None, message=None, request_id=None):
        self.code = code  # type: str
        self.message = message  # type: str
        # Id of the request
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteAiotVehicleTableItemResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteAiotVehicleTableItemResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteAiotVehicleTableItemResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteAiotVehicleTableItemResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteAiotVehicleTableItemResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteChannelRequest(TeaModel):
    def __init__(self, device_codes=None):
        self.device_codes = device_codes  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteChannelRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_codes is not None:
            result['DeviceCodes'] = self.device_codes
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DeviceCodes') is not None:
            self.device_codes = m.get('DeviceCodes')
        return self


class DeleteChannelResponseBody(TeaModel):
    def __init__(self, code=None, data=None, message=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: str
        self.message = message  # type: str
        # Id of the request
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteChannelResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteChannelResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteChannelResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteChannelResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteChannelResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteCorpGroupRequest(TeaModel):
    def __init__(self, corp_id=None, group_id=None):
        self.corp_id = corp_id  # type: str
        self.group_id = group_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteCorpGroupRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.corp_id is not None:
            result['CorpId'] = self.corp_id
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CorpId') is not None:
            self.corp_id = m.get('CorpId')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        return self


class DeleteCorpGroupResponseBody(TeaModel):
    def __init__(self, code=None, message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteCorpGroupResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteCorpGroupResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteCorpGroupResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteCorpGroupResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteCorpGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteDataSourceRequest(TeaModel):
    def __init__(self, corp_id=None, data_source_id=None):
        self.corp_id = corp_id  # type: str
        self.data_source_id = data_source_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteDataSourceRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.corp_id is not None:
            result['CorpId'] = self.corp_id
        if self.data_source_id is not None:
            result['DataSourceId'] = self.data_source_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CorpId') is not None:
            self.corp_id = m.get('CorpId')
        if m.get('DataSourceId') is not None:
            self.data_source_id = m.get('DataSourceId')
        return self


class DeleteDataSourceResponseBody(TeaModel):
    def __init__(self, code=None, data=None, message=None):
        self.code = code  # type: str
        self.data = data  # type: str
        self.message = message  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteDataSourceResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.message is not None:
            result['Message'] = self.message
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        return self


class DeleteDataSourceResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteDataSourceResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteDataSourceResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteDataSourceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteDataSourcesRequest(TeaModel):
    def __init__(self, data_source_id_list=None):
        self.data_source_id_list = data_source_id_list  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteDataSourcesRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data_source_id_list is not None:
            result['DataSourceIdList'] = self.data_source_id_list
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DataSourceIdList') is not None:
            self.data_source_id_list = m.get('DataSourceIdList')
        return self


class DeleteDataSourcesResponseBodyData(TeaModel):
    def __init__(self, code=None, data_source_id=None, message=None):
        self.code = code  # type: str
        self.data_source_id = data_source_id  # type: str
        self.message = message  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteDataSourcesResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data_source_id is not None:
            result['DataSourceId'] = self.data_source_id
        if self.message is not None:
            result['Message'] = self.message
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('DataSourceId') is not None:
            self.data_source_id = m.get('DataSourceId')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        return self


class DeleteDataSourcesResponseBody(TeaModel):
    def __init__(self, code=None, data=None, message=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: list[DeleteDataSourcesResponseBodyData]
        self.message = message  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DeleteDataSourcesResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = DeleteDataSourcesResponseBodyData()
                self.data.append(temp_model.from_map(k))
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteDataSourcesResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteDataSourcesResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteDataSourcesResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteDataSourcesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteDeviceRequest(TeaModel):
    def __init__(self, corp_id=None, gb_id=None):
        self.corp_id = corp_id  # type: str
        self.gb_id = gb_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteDeviceRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.corp_id is not None:
            result['CorpId'] = self.corp_id
        if self.gb_id is not None:
            result['GbId'] = self.gb_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CorpId') is not None:
            self.corp_id = m.get('CorpId')
        if m.get('GbId') is not None:
            self.gb_id = m.get('GbId')
        return self


class DeleteDeviceResponseBody(TeaModel):
    def __init__(self, code=None, data=None, message=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: str
        self.message = message  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteDeviceResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteDeviceResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteDeviceResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteDeviceResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteDeviceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteDeviceForInstanceRequestDevices(TeaModel):
    def __init__(self, device_id=None, region_id=None):
        self.device_id = device_id  # type: str
        self.region_id = region_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteDeviceForInstanceRequestDevices, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DeleteDeviceForInstanceRequest(TeaModel):
    def __init__(self, algorithm_id=None, delete_instance_flag=None, device_count=None, devices=None,
                 instance_id=None, project_id=None):
        self.algorithm_id = algorithm_id  # type: str
        self.delete_instance_flag = delete_instance_flag  # type: bool
        self.device_count = device_count  # type: str
        self.devices = devices  # type: list[DeleteDeviceForInstanceRequestDevices]
        self.instance_id = instance_id  # type: str
        self.project_id = project_id  # type: str

    def validate(self):
        if self.devices:
            for k in self.devices:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DeleteDeviceForInstanceRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.algorithm_id is not None:
            result['AlgorithmId'] = self.algorithm_id
        if self.delete_instance_flag is not None:
            result['DeleteInstanceFlag'] = self.delete_instance_flag
        if self.device_count is not None:
            result['DeviceCount'] = self.device_count
        result['Devices'] = []
        if self.devices is not None:
            for k in self.devices:
                result['Devices'].append(k.to_map() if k else None)
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AlgorithmId') is not None:
            self.algorithm_id = m.get('AlgorithmId')
        if m.get('DeleteInstanceFlag') is not None:
            self.delete_instance_flag = m.get('DeleteInstanceFlag')
        if m.get('DeviceCount') is not None:
            self.device_count = m.get('DeviceCount')
        self.devices = []
        if m.get('Devices') is not None:
            for k in m.get('Devices'):
                temp_model = DeleteDeviceForInstanceRequestDevices()
                self.devices.append(temp_model.from_map(k))
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        return self


class DeleteDeviceForInstanceShrinkRequest(TeaModel):
    def __init__(self, algorithm_id=None, delete_instance_flag=None, device_count=None, devices_shrink=None,
                 instance_id=None, project_id=None):
        self.algorithm_id = algorithm_id  # type: str
        self.delete_instance_flag = delete_instance_flag  # type: bool
        self.device_count = device_count  # type: str
        self.devices_shrink = devices_shrink  # type: str
        self.instance_id = instance_id  # type: str
        self.project_id = project_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteDeviceForInstanceShrinkRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.algorithm_id is not None:
            result['AlgorithmId'] = self.algorithm_id
        if self.delete_instance_flag is not None:
            result['DeleteInstanceFlag'] = self.delete_instance_flag
        if self.device_count is not None:
            result['DeviceCount'] = self.device_count
        if self.devices_shrink is not None:
            result['Devices'] = self.devices_shrink
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AlgorithmId') is not None:
            self.algorithm_id = m.get('AlgorithmId')
        if m.get('DeleteInstanceFlag') is not None:
            self.delete_instance_flag = m.get('DeleteInstanceFlag')
        if m.get('DeviceCount') is not None:
            self.device_count = m.get('DeviceCount')
        if m.get('Devices') is not None:
            self.devices_shrink = m.get('Devices')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        return self


class DeleteDeviceForInstanceResponseBody(TeaModel):
    def __init__(self, code=None, message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteDeviceForInstanceResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteDeviceForInstanceResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteDeviceForInstanceResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteDeviceForInstanceResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteDeviceForInstanceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteDevicesRequest(TeaModel):
    def __init__(self, device_id_list=None):
        self.device_id_list = device_id_list  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteDevicesRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_id_list is not None:
            result['DeviceIdList'] = self.device_id_list
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DeviceIdList') is not None:
            self.device_id_list = m.get('DeviceIdList')
        return self


class DeleteDevicesResponseBodyData(TeaModel):
    def __init__(self, code=None, description=None, device_id=None):
        self.code = code  # type: str
        self.description = description  # type: str
        self.device_id = device_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteDevicesResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.description is not None:
            result['Description'] = self.description
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        return self


class DeleteDevicesResponseBody(TeaModel):
    def __init__(self, code=None, data=None, message=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: list[DeleteDevicesResponseBodyData]
        self.message = message  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DeleteDevicesResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = DeleteDevicesResponseBodyData()
                self.data.append(temp_model.from_map(k))
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteDevicesResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteDevicesResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteDevicesResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteDevicesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteDoubleVerificationGroupRequest(TeaModel):
    def __init__(self, double_verification_group_id=None, id=None):
        self.double_verification_group_id = double_verification_group_id  # type: str
        self.id = id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteDoubleVerificationGroupRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.double_verification_group_id is not None:
            result['DoubleVerificationGroupId'] = self.double_verification_group_id
        if self.id is not None:
            result['Id'] = self.id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DoubleVerificationGroupId') is not None:
            self.double_verification_group_id = m.get('DoubleVerificationGroupId')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        return self


class DeleteDoubleVerificationGroupResponseBody(TeaModel):
    def __init__(self, code=None, message=None, request_id=None):
        self.code = code  # type: str
        self.message = message  # type: str
        # Id of the request
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteDoubleVerificationGroupResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteDoubleVerificationGroupResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteDoubleVerificationGroupResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteDoubleVerificationGroupResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteDoubleVerificationGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteIPCDeviceRequest(TeaModel):
    def __init__(self, device_codes=None):
        self.device_codes = device_codes  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteIPCDeviceRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_codes is not None:
            result['DeviceCodes'] = self.device_codes
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DeviceCodes') is not None:
            self.device_codes = m.get('DeviceCodes')
        return self


class DeleteIPCDeviceResponseBody(TeaModel):
    def __init__(self, code=None, data=None, message=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: str
        self.message = message  # type: str
        # Id of the request
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteIPCDeviceResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteIPCDeviceResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteIPCDeviceResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteIPCDeviceResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteIPCDeviceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteModelServiceRequest(TeaModel):
    def __init__(self, model_service_id=None):
        self.model_service_id = model_service_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteModelServiceRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.model_service_id is not None:
            result['ModelServiceId'] = self.model_service_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ModelServiceId') is not None:
            self.model_service_id = m.get('ModelServiceId')
        return self


class DeleteModelServiceResponseBodyData(TeaModel):
    def __init__(self, model_service_instance_id=None, model_service_instance_name=None,
                 model_service_status=None):
        self.model_service_instance_id = model_service_instance_id  # type: str
        self.model_service_instance_name = model_service_instance_name  # type: int
        self.model_service_status = model_service_status  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteModelServiceResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.model_service_instance_id is not None:
            result['ModelServiceInstanceId'] = self.model_service_instance_id
        if self.model_service_instance_name is not None:
            result['ModelServiceInstanceName'] = self.model_service_instance_name
        if self.model_service_status is not None:
            result['ModelServiceStatus'] = self.model_service_status
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ModelServiceInstanceId') is not None:
            self.model_service_instance_id = m.get('ModelServiceInstanceId')
        if m.get('ModelServiceInstanceName') is not None:
            self.model_service_instance_name = m.get('ModelServiceInstanceName')
        if m.get('ModelServiceStatus') is not None:
            self.model_service_status = m.get('ModelServiceStatus')
        return self


class DeleteModelServiceResponseBody(TeaModel):
    def __init__(self, code=None, data=None, message=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: DeleteModelServiceResponseBodyData
        self.message = message  # type: str
        # Id of the request
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(DeleteModelServiceResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = DeleteModelServiceResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteModelServiceResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteModelServiceResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteModelServiceResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteModelServiceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteNVRDeviceRequest(TeaModel):
    def __init__(self, device_codes=None):
        self.device_codes = device_codes  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteNVRDeviceRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_codes is not None:
            result['DeviceCodes'] = self.device_codes
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DeviceCodes') is not None:
            self.device_codes = m.get('DeviceCodes')
        return self


class DeleteNVRDeviceResponseBody(TeaModel):
    def __init__(self, code=None, data=None, message=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: str
        self.message = message  # type: str
        # Id of the request
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteNVRDeviceResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteNVRDeviceResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteNVRDeviceResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteNVRDeviceResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteNVRDeviceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteProfileRequest(TeaModel):
    def __init__(self, corp_id=None, isv_sub_id=None, profile_id=None):
        self.corp_id = corp_id  # type: str
        self.isv_sub_id = isv_sub_id  # type: str
        self.profile_id = profile_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteProfileRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.corp_id is not None:
            result['CorpId'] = self.corp_id
        if self.isv_sub_id is not None:
            result['IsvSubId'] = self.isv_sub_id
        if self.profile_id is not None:
            result['ProfileId'] = self.profile_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CorpId') is not None:
            self.corp_id = m.get('CorpId')
        if m.get('IsvSubId') is not None:
            self.isv_sub_id = m.get('IsvSubId')
        if m.get('ProfileId') is not None:
            self.profile_id = m.get('ProfileId')
        return self


class DeleteProfileResponseBody(TeaModel):
    def __init__(self, code=None, data=None, message=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: bool
        self.message = message  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteProfileResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteProfileResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteProfileResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteProfileResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteProfileResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteProfileCatalogRequest(TeaModel):
    def __init__(self, catalog_id=None, corp_id=None, isv_sub_id=None):
        self.catalog_id = catalog_id  # type: str
        self.corp_id = corp_id  # type: str
        self.isv_sub_id = isv_sub_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteProfileCatalogRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.catalog_id is not None:
            result['CatalogId'] = self.catalog_id
        if self.corp_id is not None:
            result['CorpId'] = self.corp_id
        if self.isv_sub_id is not None:
            result['IsvSubId'] = self.isv_sub_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CatalogId') is not None:
            self.catalog_id = m.get('CatalogId')
        if m.get('CorpId') is not None:
            self.corp_id = m.get('CorpId')
        if m.get('IsvSubId') is not None:
            self.isv_sub_id = m.get('IsvSubId')
        return self


class DeleteProfileCatalogResponseBody(TeaModel):
    def __init__(self, code=None, data=None, message=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: bool
        self.message = message  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteProfileCatalogResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteProfileCatalogResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteProfileCatalogResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteProfileCatalogResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteProfileCatalogResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteProjectRequest(TeaModel):
    def __init__(self, project_ids=None):
        # 项目id,多个以”,“隔开
        self.project_ids = project_ids  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteProjectRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_ids is not None:
            result['ProjectIds'] = self.project_ids
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ProjectIds') is not None:
            self.project_ids = m.get('ProjectIds')
        return self


class DeleteProjectResponseBody(TeaModel):
    def __init__(self, code=None, message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteProjectResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteProjectResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteProjectResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteProjectResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteProjectResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteRecordsRequest(TeaModel):
    def __init__(self, algorithm_type=None, attribute_name=None, corp_id=None, operator_type=None, value=None):
        self.algorithm_type = algorithm_type  # type: str
        self.attribute_name = attribute_name  # type: str
        self.corp_id = corp_id  # type: str
        self.operator_type = operator_type  # type: str
        self.value = value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteRecordsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.algorithm_type is not None:
            result['AlgorithmType'] = self.algorithm_type
        if self.attribute_name is not None:
            result['AttributeName'] = self.attribute_name
        if self.corp_id is not None:
            result['CorpId'] = self.corp_id
        if self.operator_type is not None:
            result['OperatorType'] = self.operator_type
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AlgorithmType') is not None:
            self.algorithm_type = m.get('AlgorithmType')
        if m.get('AttributeName') is not None:
            self.attribute_name = m.get('AttributeName')
        if m.get('CorpId') is not None:
            self.corp_id = m.get('CorpId')
        if m.get('OperatorType') is not None:
            self.operator_type = m.get('OperatorType')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DeleteRecordsResponseBody(TeaModel):
    def __init__(self, code=None, data=None, message=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: str
        self.message = message  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteRecordsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteRecordsResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteRecordsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteRecordsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteRecordsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteSearchTablesRequest(TeaModel):
    def __init__(self, search_table_ids=None):
        self.search_table_ids = search_table_ids  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteSearchTablesRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.search_table_ids is not None:
            result['SearchTableIds'] = self.search_table_ids
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('SearchTableIds') is not None:
            self.search_table_ids = m.get('SearchTableIds')
        return self


class DeleteSearchTablesResponseBody(TeaModel):
    def __init__(self, code=None, message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.message = message  # type: str
        # Id of the request
        self.request_id = request_id  # type: str
        self.success = success  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteSearchTablesResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteSearchTablesResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteSearchTablesResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteSearchTablesResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteSearchTablesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteSubscribeRequest(TeaModel):
    def __init__(self, device_id=None):
        self.device_id = device_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteSubscribeRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        return self


class DeleteSubscribeResponseBody(TeaModel):
    def __init__(self, code=None, message=None, request_id=None):
        self.code = code  # type: str
        self.message = message  # type: str
        # Id of the request
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteSubscribeResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteSubscribeResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteSubscribeResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteSubscribeResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteSubscribeResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteUserRequest(TeaModel):
    def __init__(self, corp_id=None, isv_sub_id=None, user_id=None):
        self.corp_id = corp_id  # type: str
        self.isv_sub_id = isv_sub_id  # type: str
        self.user_id = user_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteUserRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.corp_id is not None:
            result['CorpId'] = self.corp_id
        if self.isv_sub_id is not None:
            result['IsvSubId'] = self.isv_sub_id
        if self.user_id is not None:
            result['UserId'] = self.user_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CorpId') is not None:
            self.corp_id = m.get('CorpId')
        if m.get('IsvSubId') is not None:
            self.isv_sub_id = m.get('IsvSubId')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        return self


class DeleteUserResponseBody(TeaModel):
    def __init__(self, code=None, data=None, message=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: bool
        self.message = message  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteUserResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteUserResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteUserResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteUserResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteUserResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteUserGroupRequest(TeaModel):
    def __init__(self, corp_id=None, isv_sub_id=None, user_group_id=None):
        self.corp_id = corp_id  # type: str
        self.isv_sub_id = isv_sub_id  # type: str
        self.user_group_id = user_group_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteUserGroupRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.corp_id is not None:
            result['CorpId'] = self.corp_id
        if self.isv_sub_id is not None:
            result['IsvSubId'] = self.isv_sub_id
        if self.user_group_id is not None:
            result['UserGroupId'] = self.user_group_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CorpId') is not None:
            self.corp_id = m.get('CorpId')
        if m.get('IsvSubId') is not None:
            self.isv_sub_id = m.get('IsvSubId')
        if m.get('UserGroupId') is not None:
            self.user_group_id = m.get('UserGroupId')
        return self


class DeleteUserGroupResponseBody(TeaModel):
    def __init__(self, code=None, data=None, message=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: bool
        self.message = message  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteUserGroupResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteUserGroupResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteUserGroupResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteUserGroupResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteUserGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteVideoSummaryTaskRequest(TeaModel):
    def __init__(self, corp_id=None, task_id=None):
        self.corp_id = corp_id  # type: str
        self.task_id = task_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteVideoSummaryTaskRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.corp_id is not None:
            result['CorpId'] = self.corp_id
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CorpId') is not None:
            self.corp_id = m.get('CorpId')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class DeleteVideoSummaryTaskResponseBody(TeaModel):
    def __init__(self, code=None, data=None, message=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: str
        self.message = message  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteVideoSummaryTaskResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteVideoSummaryTaskResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteVideoSummaryTaskResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteVideoSummaryTaskResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteVideoSummaryTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteWatchPoliciesRequest(TeaModel):
    def __init__(self, watch_policy_ids=None):
        self.watch_policy_ids = watch_policy_ids  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteWatchPoliciesRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.watch_policy_ids is not None:
            result['WatchPolicyIds'] = self.watch_policy_ids
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('WatchPolicyIds') is not None:
            self.watch_policy_ids = m.get('WatchPolicyIds')
        return self


class DeleteWatchPoliciesResponseBody(TeaModel):
    def __init__(self, code=None, message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.message = message  # type: str
        # Id of the request
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteWatchPoliciesResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteWatchPoliciesResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteWatchPoliciesResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteWatchPoliciesResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteWatchPoliciesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteWatchTasksRequest(TeaModel):
    def __init__(self, watch_task_ids=None):
        self.watch_task_ids = watch_task_ids  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteWatchTasksRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.watch_task_ids is not None:
            result['WatchTaskIds'] = self.watch_task_ids
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('WatchTaskIds') is not None:
            self.watch_task_ids = m.get('WatchTaskIds')
        return self


class DeleteWatchTasksResponseBody(TeaModel):
    def __init__(self, code=None, message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.message = message  # type: str
        # Id of the request
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteWatchTasksResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteWatchTasksResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteWatchTasksResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteWatchTasksResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteWatchTasksResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeAIInstanceRequest(TeaModel):
    def __init__(self, instance_id=None, instance_name=None, instance_type=None, page_number=None, page_size=None,
                 project_id=None):
        # 实例id
        self.instance_id = instance_id  # type: str
        # 实例名称
        self.instance_name = instance_name  # type: str
        # 实例类型
        self.instance_type = instance_type  # type: str
        # 当前页序号
        self.page_number = page_number  # type: long
        # 每页显示多少条数据
        self.page_size = page_size  # type: long
        # 项目id
        self.project_id = project_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeAIInstanceRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.instance_name is not None:
            result['InstanceName'] = self.instance_name
        if self.instance_type is not None:
            result['InstanceType'] = self.instance_type
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('InstanceName') is not None:
            self.instance_name = m.get('InstanceName')
        if m.get('InstanceType') is not None:
            self.instance_type = m.get('InstanceType')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        return self


class DescribeAIInstanceResponseBodyDataRecords(TeaModel):
    def __init__(self, acu_used=None, algorithm_id=None, algorithm_name=None, camera_number=None, compute_type=None,
                 container_type=None, create_date_time=None, data_source=None, data_source_times=None, data_type=None, fps=None,
                 instance_id=None, instance_name=None, instance_type=None, schedule_cycle_dates=None, schedule_times=None,
                 schedule_type=None, spf=None, status=None, storage=None):
        # ACU使用数量
        self.acu_used = acu_used  # type: long
        # 算子ID
        self.algorithm_id = algorithm_id  # type: str
        # 算子名称
        self.algorithm_name = algorithm_name  # type: str
        # 实例中计算的摄像机数量。 仅当DataSource是Camera时返回。
        self.camera_number = camera_number  # type: long
        # 计算类型
        self.compute_type = compute_type  # type: str
        self.container_type = container_type  # type: str
        # 实例创建时间
        self.create_date_time = create_date_time  # type: str
        # 数据来源
        self.data_source = data_source  # type: str
        # 数据源时间段
        self.data_source_times = data_source_times  # type: str
        # 数据类型
        self.data_type = data_type  # type: str
        # 多少秒抽取1帧，取值范围[0, 3600]。 0表示不抽帧。
        self.fps = fps  # type: long
        # 实例ID
        self.instance_id = instance_id  # type: str
        # 实例名称
        self.instance_name = instance_name  # type: str
        self.instance_type = instance_type  # type: str
        # 含义随ScheduleType取值不同
        self.schedule_cycle_dates = schedule_cycle_dates  # type: str
        # 执行时间段
        self.schedule_times = schedule_times  # type: str
        # 调度类型
        self.schedule_type = schedule_type  # type: str
        # 多少秒抽取1帧，取值范围[0, 3600]。 0表示不抽帧。
        self.spf = spf  # type: long
        # 实力状态
        self.status = status  # type: str
        # 预计存储量
        self.storage = storage  # type: float

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeAIInstanceResponseBodyDataRecords, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.acu_used is not None:
            result['AcuUsed'] = self.acu_used
        if self.algorithm_id is not None:
            result['AlgorithmId'] = self.algorithm_id
        if self.algorithm_name is not None:
            result['AlgorithmName'] = self.algorithm_name
        if self.camera_number is not None:
            result['CameraNumber'] = self.camera_number
        if self.compute_type is not None:
            result['ComputeType'] = self.compute_type
        if self.container_type is not None:
            result['ContainerType'] = self.container_type
        if self.create_date_time is not None:
            result['CreateDateTime'] = self.create_date_time
        if self.data_source is not None:
            result['DataSource'] = self.data_source
        if self.data_source_times is not None:
            result['DataSourceTimes'] = self.data_source_times
        if self.data_type is not None:
            result['DataType'] = self.data_type
        if self.fps is not None:
            result['Fps'] = self.fps
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.instance_name is not None:
            result['InstanceName'] = self.instance_name
        if self.instance_type is not None:
            result['InstanceType'] = self.instance_type
        if self.schedule_cycle_dates is not None:
            result['ScheduleCycleDates'] = self.schedule_cycle_dates
        if self.schedule_times is not None:
            result['ScheduleTimes'] = self.schedule_times
        if self.schedule_type is not None:
            result['ScheduleType'] = self.schedule_type
        if self.spf is not None:
            result['Spf'] = self.spf
        if self.status is not None:
            result['Status'] = self.status
        if self.storage is not None:
            result['Storage'] = self.storage
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AcuUsed') is not None:
            self.acu_used = m.get('AcuUsed')
        if m.get('AlgorithmId') is not None:
            self.algorithm_id = m.get('AlgorithmId')
        if m.get('AlgorithmName') is not None:
            self.algorithm_name = m.get('AlgorithmName')
        if m.get('CameraNumber') is not None:
            self.camera_number = m.get('CameraNumber')
        if m.get('ComputeType') is not None:
            self.compute_type = m.get('ComputeType')
        if m.get('ContainerType') is not None:
            self.container_type = m.get('ContainerType')
        if m.get('CreateDateTime') is not None:
            self.create_date_time = m.get('CreateDateTime')
        if m.get('DataSource') is not None:
            self.data_source = m.get('DataSource')
        if m.get('DataSourceTimes') is not None:
            self.data_source_times = m.get('DataSourceTimes')
        if m.get('DataType') is not None:
            self.data_type = m.get('DataType')
        if m.get('Fps') is not None:
            self.fps = m.get('Fps')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('InstanceName') is not None:
            self.instance_name = m.get('InstanceName')
        if m.get('InstanceType') is not None:
            self.instance_type = m.get('InstanceType')
        if m.get('ScheduleCycleDates') is not None:
            self.schedule_cycle_dates = m.get('ScheduleCycleDates')
        if m.get('ScheduleTimes') is not None:
            self.schedule_times = m.get('ScheduleTimes')
        if m.get('ScheduleType') is not None:
            self.schedule_type = m.get('ScheduleType')
        if m.get('Spf') is not None:
            self.spf = m.get('Spf')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Storage') is not None:
            self.storage = m.get('Storage')
        return self


class DescribeAIInstanceResponseBodyData(TeaModel):
    def __init__(self, page_number=None, page_size=None, records=None, total_count=None):
        # 当前页序号
        self.page_number = page_number  # type: long
        # 每页显示多少条
        self.page_size = page_size  # type: long
        # 返回数据条目
        self.records = records  # type: list[DescribeAIInstanceResponseBodyDataRecords]
        # 总数据数
        self.total_count = total_count  # type: long

    def validate(self):
        if self.records:
            for k in self.records:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeAIInstanceResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        result['Records'] = []
        if self.records is not None:
            for k in self.records:
                result['Records'].append(k.to_map() if k else None)
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        self.records = []
        if m.get('Records') is not None:
            for k in m.get('Records'):
                temp_model = DescribeAIInstanceResponseBodyDataRecords()
                self.records.append(temp_model.from_map(k))
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeAIInstanceResponseBody(TeaModel):
    def __init__(self, code=None, data=None, message=None, request_id=None):
        # 返回错误码
        self.code = code  # type: str
        # 返回数据
        self.data = data  # type: DescribeAIInstanceResponseBodyData
        # 错误信息
        self.message = message  # type: str
        # Id of the request
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(DescribeAIInstanceResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = DescribeAIInstanceResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeAIInstanceResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeAIInstanceResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeAIInstanceResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeAIInstanceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeAiotDevicesRequest(TeaModel):
    def __init__(self, corp_id_list=None, id_list=None, page_num=None, page_size=None):
        self.corp_id_list = corp_id_list  # type: str
        self.id_list = id_list  # type: str
        self.page_num = page_num  # type: long
        self.page_size = page_size  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeAiotDevicesRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.corp_id_list is not None:
            result['CorpIdList'] = self.corp_id_list
        if self.id_list is not None:
            result['IdList'] = self.id_list
        if self.page_num is not None:
            result['PageNum'] = self.page_num
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CorpIdList') is not None:
            self.corp_id_list = m.get('CorpIdList')
        if m.get('IdList') is not None:
            self.id_list = m.get('IdList')
        if m.get('PageNum') is not None:
            self.page_num = m.get('PageNum')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class DescribeAiotDevicesResponseBodyAiotDevicesAiotDeviceList(TeaModel):
    def __init__(self, cap_direction=None, corp_id=None, device_id=None, device_type=None, firmware_version=None,
                 ipaddr=None, ipv6addr=None, ipv_4gateway=None, ipv_4netmask=None, id=None, is_online=None, latitude=None,
                 longitude=None, mac=None, manufacturer=None, model=None, monitor_area_desc=None, monitor_direction=None,
                 name=None, org_code=None, owner_aps_id=None, password=None, place=None, place_code=None, port=None,
                 serial_nuber=None, user_id=None):
        self.cap_direction = cap_direction  # type: str
        self.corp_id = corp_id  # type: str
        self.device_id = device_id  # type: str
        self.device_type = device_type  # type: str
        self.firmware_version = firmware_version  # type: str
        self.ipaddr = ipaddr  # type: str
        self.ipv6addr = ipv6addr  # type: str
        self.ipv_4gateway = ipv_4gateway  # type: str
        self.ipv_4netmask = ipv_4netmask  # type: str
        self.id = id  # type: str
        self.is_online = is_online  # type: str
        self.latitude = latitude  # type: float
        self.longitude = longitude  # type: float
        self.mac = mac  # type: str
        self.manufacturer = manufacturer  # type: str
        self.model = model  # type: str
        self.monitor_area_desc = monitor_area_desc  # type: str
        self.monitor_direction = monitor_direction  # type: str
        self.name = name  # type: str
        self.org_code = org_code  # type: str
        self.owner_aps_id = owner_aps_id  # type: str
        self.password = password  # type: str
        self.place = place  # type: str
        self.place_code = place_code  # type: str
        self.port = port  # type: long
        self.serial_nuber = serial_nuber  # type: str
        self.user_id = user_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeAiotDevicesResponseBodyAiotDevicesAiotDeviceList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cap_direction is not None:
            result['CapDirection'] = self.cap_direction
        if self.corp_id is not None:
            result['CorpId'] = self.corp_id
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.device_type is not None:
            result['DeviceType'] = self.device_type
        if self.firmware_version is not None:
            result['FirmwareVersion'] = self.firmware_version
        if self.ipaddr is not None:
            result['IPAddr'] = self.ipaddr
        if self.ipv6addr is not None:
            result['IPV6Addr'] = self.ipv6addr
        if self.ipv_4gateway is not None:
            result['IPv4Gateway'] = self.ipv_4gateway
        if self.ipv_4netmask is not None:
            result['IPv4Netmask'] = self.ipv_4netmask
        if self.id is not None:
            result['Id'] = self.id
        if self.is_online is not None:
            result['IsOnline'] = self.is_online
        if self.latitude is not None:
            result['Latitude'] = self.latitude
        if self.longitude is not None:
            result['Longitude'] = self.longitude
        if self.mac is not None:
            result['MAC'] = self.mac
        if self.manufacturer is not None:
            result['Manufacturer'] = self.manufacturer
        if self.model is not None:
            result['Model'] = self.model
        if self.monitor_area_desc is not None:
            result['MonitorAreaDesc'] = self.monitor_area_desc
        if self.monitor_direction is not None:
            result['MonitorDirection'] = self.monitor_direction
        if self.name is not None:
            result['Name'] = self.name
        if self.org_code is not None:
            result['OrgCode'] = self.org_code
        if self.owner_aps_id is not None:
            result['OwnerApsID'] = self.owner_aps_id
        if self.password is not None:
            result['Password'] = self.password
        if self.place is not None:
            result['Place'] = self.place
        if self.place_code is not None:
            result['PlaceCode'] = self.place_code
        if self.port is not None:
            result['Port'] = self.port
        if self.serial_nuber is not None:
            result['SerialNuber'] = self.serial_nuber
        if self.user_id is not None:
            result['UserId'] = self.user_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CapDirection') is not None:
            self.cap_direction = m.get('CapDirection')
        if m.get('CorpId') is not None:
            self.corp_id = m.get('CorpId')
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('DeviceType') is not None:
            self.device_type = m.get('DeviceType')
        if m.get('FirmwareVersion') is not None:
            self.firmware_version = m.get('FirmwareVersion')
        if m.get('IPAddr') is not None:
            self.ipaddr = m.get('IPAddr')
        if m.get('IPV6Addr') is not None:
            self.ipv6addr = m.get('IPV6Addr')
        if m.get('IPv4Gateway') is not None:
            self.ipv_4gateway = m.get('IPv4Gateway')
        if m.get('IPv4Netmask') is not None:
            self.ipv_4netmask = m.get('IPv4Netmask')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('IsOnline') is not None:
            self.is_online = m.get('IsOnline')
        if m.get('Latitude') is not None:
            self.latitude = m.get('Latitude')
        if m.get('Longitude') is not None:
            self.longitude = m.get('Longitude')
        if m.get('MAC') is not None:
            self.mac = m.get('MAC')
        if m.get('Manufacturer') is not None:
            self.manufacturer = m.get('Manufacturer')
        if m.get('Model') is not None:
            self.model = m.get('Model')
        if m.get('MonitorAreaDesc') is not None:
            self.monitor_area_desc = m.get('MonitorAreaDesc')
        if m.get('MonitorDirection') is not None:
            self.monitor_direction = m.get('MonitorDirection')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('OrgCode') is not None:
            self.org_code = m.get('OrgCode')
        if m.get('OwnerApsID') is not None:
            self.owner_aps_id = m.get('OwnerApsID')
        if m.get('Password') is not None:
            self.password = m.get('Password')
        if m.get('Place') is not None:
            self.place = m.get('Place')
        if m.get('PlaceCode') is not None:
            self.place_code = m.get('PlaceCode')
        if m.get('Port') is not None:
            self.port = m.get('Port')
        if m.get('SerialNuber') is not None:
            self.serial_nuber = m.get('SerialNuber')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        return self


class DescribeAiotDevicesResponseBodyAiotDevices(TeaModel):
    def __init__(self, aiot_device_list=None, page_num=None, page_size=None, total_num=None):
        self.aiot_device_list = aiot_device_list  # type: list[DescribeAiotDevicesResponseBodyAiotDevicesAiotDeviceList]
        self.page_num = page_num  # type: long
        self.page_size = page_size  # type: long
        self.total_num = total_num  # type: long

    def validate(self):
        if self.aiot_device_list:
            for k in self.aiot_device_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeAiotDevicesResponseBodyAiotDevices, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AiotDeviceList'] = []
        if self.aiot_device_list is not None:
            for k in self.aiot_device_list:
                result['AiotDeviceList'].append(k.to_map() if k else None)
        if self.page_num is not None:
            result['PageNum'] = self.page_num
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_num is not None:
            result['TotalNum'] = self.total_num
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.aiot_device_list = []
        if m.get('AiotDeviceList') is not None:
            for k in m.get('AiotDeviceList'):
                temp_model = DescribeAiotDevicesResponseBodyAiotDevicesAiotDeviceList()
                self.aiot_device_list.append(temp_model.from_map(k))
        if m.get('PageNum') is not None:
            self.page_num = m.get('PageNum')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalNum') is not None:
            self.total_num = m.get('TotalNum')
        return self


class DescribeAiotDevicesResponseBody(TeaModel):
    def __init__(self, aiot_devices=None, code=None, message=None, request_id=None):
        self.aiot_devices = aiot_devices  # type: DescribeAiotDevicesResponseBodyAiotDevices
        self.code = code  # type: str
        self.message = message  # type: str
        # Id of the request
        self.request_id = request_id  # type: str

    def validate(self):
        if self.aiot_devices:
            self.aiot_devices.validate()

    def to_map(self):
        _map = super(DescribeAiotDevicesResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.aiot_devices is not None:
            result['AiotDevices'] = self.aiot_devices.to_map()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AiotDevices') is not None:
            temp_model = DescribeAiotDevicesResponseBodyAiotDevices()
            self.aiot_devices = temp_model.from_map(m['AiotDevices'])
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeAiotDevicesResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeAiotDevicesResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeAiotDevicesResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeAiotDevicesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeAiotPersonTableItemsRequest(TeaModel):
    def __init__(self, id=None, page_num=None, page_size=None, person_table_id=None, person_table_item_id=None):
        self.id = id  # type: str
        self.page_num = page_num  # type: long
        self.page_size = page_size  # type: long
        self.person_table_id = person_table_id  # type: str
        self.person_table_item_id = person_table_item_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeAiotPersonTableItemsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['Id'] = self.id
        if self.page_num is not None:
            result['PageNum'] = self.page_num
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.person_table_id is not None:
            result['PersonTableId'] = self.person_table_id
        if self.person_table_item_id is not None:
            result['PersonTableItemId'] = self.person_table_item_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('PageNum') is not None:
            self.page_num = m.get('PageNum')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('PersonTableId') is not None:
            self.person_table_id = m.get('PersonTableId')
        if m.get('PersonTableItemId') is not None:
            self.person_table_item_id = m.get('PersonTableItemId')
        return self


class DescribeAiotPersonTableItemsResponseBodyPersonTableItemsPersonTableItemListIdentificationList(TeaModel):
    def __init__(self, number=None, type=None):
        self.number = number  # type: str
        self.type = type  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeAiotPersonTableItemsResponseBodyPersonTableItemsPersonTableItemListIdentificationList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.number is not None:
            result['Number'] = self.number
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Number') is not None:
            self.number = m.get('Number')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class DescribeAiotPersonTableItemsResponseBodyPersonTableItemsPersonTableItemListImageListFeatureInfo(TeaModel):
    def __init__(self, algorithm_type=None, algorithm_version=None, feature_data=None, image_id=None,
                 object_id=None, table_id=None, vendor=None):
        self.algorithm_type = algorithm_type  # type: str
        self.algorithm_version = algorithm_version  # type: str
        self.feature_data = feature_data  # type: str
        self.image_id = image_id  # type: str
        self.object_id = object_id  # type: str
        self.table_id = table_id  # type: str
        self.vendor = vendor  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeAiotPersonTableItemsResponseBodyPersonTableItemsPersonTableItemListImageListFeatureInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.algorithm_type is not None:
            result['AlgorithmType'] = self.algorithm_type
        if self.algorithm_version is not None:
            result['AlgorithmVersion'] = self.algorithm_version
        if self.feature_data is not None:
            result['FeatureData'] = self.feature_data
        if self.image_id is not None:
            result['ImageId'] = self.image_id
        if self.object_id is not None:
            result['ObjectId'] = self.object_id
        if self.table_id is not None:
            result['TableId'] = self.table_id
        if self.vendor is not None:
            result['Vendor'] = self.vendor
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AlgorithmType') is not None:
            self.algorithm_type = m.get('AlgorithmType')
        if m.get('AlgorithmVersion') is not None:
            self.algorithm_version = m.get('AlgorithmVersion')
        if m.get('FeatureData') is not None:
            self.feature_data = m.get('FeatureData')
        if m.get('ImageId') is not None:
            self.image_id = m.get('ImageId')
        if m.get('ObjectId') is not None:
            self.object_id = m.get('ObjectId')
        if m.get('TableId') is not None:
            self.table_id = m.get('TableId')
        if m.get('Vendor') is not None:
            self.vendor = m.get('Vendor')
        return self


class DescribeAiotPersonTableItemsResponseBodyPersonTableItemsPersonTableItemListImageList(TeaModel):
    def __init__(self, data=None, device_id=None, event_sort=None, feature_info=None, file_format=None, height=None,
                 image_id=None, shot_time=None, size=None, storage_path=None, type=None, width=None):
        self.data = data  # type: str
        self.device_id = device_id  # type: str
        self.event_sort = event_sort  # type: str
        self.feature_info = feature_info  # type: DescribeAiotPersonTableItemsResponseBodyPersonTableItemsPersonTableItemListImageListFeatureInfo
        self.file_format = file_format  # type: str
        self.height = height  # type: long
        self.image_id = image_id  # type: str
        self.shot_time = shot_time  # type: str
        self.size = size  # type: long
        self.storage_path = storage_path  # type: str
        self.type = type  # type: str
        self.width = width  # type: long

    def validate(self):
        if self.feature_info:
            self.feature_info.validate()

    def to_map(self):
        _map = super(DescribeAiotPersonTableItemsResponseBodyPersonTableItemsPersonTableItemListImageList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.event_sort is not None:
            result['EventSort'] = self.event_sort
        if self.feature_info is not None:
            result['FeatureInfo'] = self.feature_info.to_map()
        if self.file_format is not None:
            result['FileFormat'] = self.file_format
        if self.height is not None:
            result['Height'] = self.height
        if self.image_id is not None:
            result['ImageId'] = self.image_id
        if self.shot_time is not None:
            result['ShotTime'] = self.shot_time
        if self.size is not None:
            result['Size'] = self.size
        if self.storage_path is not None:
            result['StoragePath'] = self.storage_path
        if self.type is not None:
            result['Type'] = self.type
        if self.width is not None:
            result['Width'] = self.width
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('EventSort') is not None:
            self.event_sort = m.get('EventSort')
        if m.get('FeatureInfo') is not None:
            temp_model = DescribeAiotPersonTableItemsResponseBodyPersonTableItemsPersonTableItemListImageListFeatureInfo()
            self.feature_info = temp_model.from_map(m['FeatureInfo'])
        if m.get('FileFormat') is not None:
            self.file_format = m.get('FileFormat')
        if m.get('Height') is not None:
            self.height = m.get('Height')
        if m.get('ImageId') is not None:
            self.image_id = m.get('ImageId')
        if m.get('ShotTime') is not None:
            self.shot_time = m.get('ShotTime')
        if m.get('Size') is not None:
            self.size = m.get('Size')
        if m.get('StoragePath') is not None:
            self.storage_path = m.get('StoragePath')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Width') is not None:
            self.width = m.get('Width')
        return self


class DescribeAiotPersonTableItemsResponseBodyPersonTableItemsPersonTableItemList(TeaModel):
    def __init__(self, identification_list=None, identification_num=None, image_list=None, image_num=None,
                 last_change=None, person_code=None, person_id=None, person_name=None, person_table_id=None, remarks=None):
        self.identification_list = identification_list  # type: list[DescribeAiotPersonTableItemsResponseBodyPersonTableItemsPersonTableItemListIdentificationList]
        self.identification_num = identification_num  # type: long
        self.image_list = image_list  # type: list[DescribeAiotPersonTableItemsResponseBodyPersonTableItemsPersonTableItemListImageList]
        self.image_num = image_num  # type: long
        self.last_change = last_change  # type: str
        self.person_code = person_code  # type: str
        self.person_id = person_id  # type: str
        self.person_name = person_name  # type: str
        self.person_table_id = person_table_id  # type: str
        self.remarks = remarks  # type: str

    def validate(self):
        if self.identification_list:
            for k in self.identification_list:
                if k:
                    k.validate()
        if self.image_list:
            for k in self.image_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeAiotPersonTableItemsResponseBodyPersonTableItemsPersonTableItemList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['IdentificationList'] = []
        if self.identification_list is not None:
            for k in self.identification_list:
                result['IdentificationList'].append(k.to_map() if k else None)
        if self.identification_num is not None:
            result['IdentificationNum'] = self.identification_num
        result['ImageList'] = []
        if self.image_list is not None:
            for k in self.image_list:
                result['ImageList'].append(k.to_map() if k else None)
        if self.image_num is not None:
            result['ImageNum'] = self.image_num
        if self.last_change is not None:
            result['LastChange'] = self.last_change
        if self.person_code is not None:
            result['PersonCode'] = self.person_code
        if self.person_id is not None:
            result['PersonId'] = self.person_id
        if self.person_name is not None:
            result['PersonName'] = self.person_name
        if self.person_table_id is not None:
            result['PersonTableId'] = self.person_table_id
        if self.remarks is not None:
            result['Remarks'] = self.remarks
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.identification_list = []
        if m.get('IdentificationList') is not None:
            for k in m.get('IdentificationList'):
                temp_model = DescribeAiotPersonTableItemsResponseBodyPersonTableItemsPersonTableItemListIdentificationList()
                self.identification_list.append(temp_model.from_map(k))
        if m.get('IdentificationNum') is not None:
            self.identification_num = m.get('IdentificationNum')
        self.image_list = []
        if m.get('ImageList') is not None:
            for k in m.get('ImageList'):
                temp_model = DescribeAiotPersonTableItemsResponseBodyPersonTableItemsPersonTableItemListImageList()
                self.image_list.append(temp_model.from_map(k))
        if m.get('ImageNum') is not None:
            self.image_num = m.get('ImageNum')
        if m.get('LastChange') is not None:
            self.last_change = m.get('LastChange')
        if m.get('PersonCode') is not None:
            self.person_code = m.get('PersonCode')
        if m.get('PersonId') is not None:
            self.person_id = m.get('PersonId')
        if m.get('PersonName') is not None:
            self.person_name = m.get('PersonName')
        if m.get('PersonTableId') is not None:
            self.person_table_id = m.get('PersonTableId')
        if m.get('Remarks') is not None:
            self.remarks = m.get('Remarks')
        return self


class DescribeAiotPersonTableItemsResponseBodyPersonTableItems(TeaModel):
    def __init__(self, page_num=None, page_size=None, person_table_item_list=None, total_num=None):
        self.page_num = page_num  # type: long
        self.page_size = page_size  # type: long
        self.person_table_item_list = person_table_item_list  # type: list[DescribeAiotPersonTableItemsResponseBodyPersonTableItemsPersonTableItemList]
        self.total_num = total_num  # type: long

    def validate(self):
        if self.person_table_item_list:
            for k in self.person_table_item_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeAiotPersonTableItemsResponseBodyPersonTableItems, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_num is not None:
            result['PageNum'] = self.page_num
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        result['PersonTableItemList'] = []
        if self.person_table_item_list is not None:
            for k in self.person_table_item_list:
                result['PersonTableItemList'].append(k.to_map() if k else None)
        if self.total_num is not None:
            result['TotalNum'] = self.total_num
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PageNum') is not None:
            self.page_num = m.get('PageNum')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        self.person_table_item_list = []
        if m.get('PersonTableItemList') is not None:
            for k in m.get('PersonTableItemList'):
                temp_model = DescribeAiotPersonTableItemsResponseBodyPersonTableItemsPersonTableItemList()
                self.person_table_item_list.append(temp_model.from_map(k))
        if m.get('TotalNum') is not None:
            self.total_num = m.get('TotalNum')
        return self


class DescribeAiotPersonTableItemsResponseBody(TeaModel):
    def __init__(self, code=None, message=None, person_table_items=None, request_id=None):
        self.code = code  # type: str
        self.message = message  # type: str
        self.person_table_items = person_table_items  # type: DescribeAiotPersonTableItemsResponseBodyPersonTableItems
        # Id of the request
        self.request_id = request_id  # type: str

    def validate(self):
        if self.person_table_items:
            self.person_table_items.validate()

    def to_map(self):
        _map = super(DescribeAiotPersonTableItemsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.person_table_items is not None:
            result['PersonTableItems'] = self.person_table_items.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('PersonTableItems') is not None:
            temp_model = DescribeAiotPersonTableItemsResponseBodyPersonTableItems()
            self.person_table_items = temp_model.from_map(m['PersonTableItems'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeAiotPersonTableItemsResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeAiotPersonTableItemsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeAiotPersonTableItemsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeAiotPersonTableItemsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeAiotPersonTablesRequest(TeaModel):
    def __init__(self, id=None, person_table_id_list=None):
        self.id = id  # type: str
        self.person_table_id_list = person_table_id_list  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeAiotPersonTablesRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['Id'] = self.id
        if self.person_table_id_list is not None:
            result['PersonTableIdList'] = self.person_table_id_list
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('PersonTableIdList') is not None:
            self.person_table_id_list = m.get('PersonTableIdList')
        return self


class DescribeAiotPersonTablesResponseBodyPersonTableList(TeaModel):
    def __init__(self, device_id=None, face_num=None, last_change=None, name=None, person_num=None,
                 person_table_id=None, total_person_num=None, type=None, verification_model_list=None):
        self.device_id = device_id  # type: str
        self.face_num = face_num  # type: long
        self.last_change = last_change  # type: str
        self.name = name  # type: str
        self.person_num = person_num  # type: long
        self.person_table_id = person_table_id  # type: str
        self.total_person_num = total_person_num  # type: long
        self.type = type  # type: long
        self.verification_model_list = verification_model_list  # type: list[long]

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeAiotPersonTablesResponseBodyPersonTableList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.face_num is not None:
            result['FaceNum'] = self.face_num
        if self.last_change is not None:
            result['LastChange'] = self.last_change
        if self.name is not None:
            result['Name'] = self.name
        if self.person_num is not None:
            result['PersonNum'] = self.person_num
        if self.person_table_id is not None:
            result['PersonTableId'] = self.person_table_id
        if self.total_person_num is not None:
            result['TotalPersonNum'] = self.total_person_num
        if self.type is not None:
            result['Type'] = self.type
        if self.verification_model_list is not None:
            result['VerificationModelList'] = self.verification_model_list
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('FaceNum') is not None:
            self.face_num = m.get('FaceNum')
        if m.get('LastChange') is not None:
            self.last_change = m.get('LastChange')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('PersonNum') is not None:
            self.person_num = m.get('PersonNum')
        if m.get('PersonTableId') is not None:
            self.person_table_id = m.get('PersonTableId')
        if m.get('TotalPersonNum') is not None:
            self.total_person_num = m.get('TotalPersonNum')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('VerificationModelList') is not None:
            self.verification_model_list = m.get('VerificationModelList')
        return self


class DescribeAiotPersonTablesResponseBody(TeaModel):
    def __init__(self, code=None, message=None, person_table_list=None, request_id=None):
        self.code = code  # type: str
        self.message = message  # type: str
        self.person_table_list = person_table_list  # type: list[DescribeAiotPersonTablesResponseBodyPersonTableList]
        # Id of the request
        self.request_id = request_id  # type: str

    def validate(self):
        if self.person_table_list:
            for k in self.person_table_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeAiotPersonTablesResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        result['PersonTableList'] = []
        if self.person_table_list is not None:
            for k in self.person_table_list:
                result['PersonTableList'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        self.person_table_list = []
        if m.get('PersonTableList') is not None:
            for k in m.get('PersonTableList'):
                temp_model = DescribeAiotPersonTablesResponseBodyPersonTableList()
                self.person_table_list.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeAiotPersonTablesResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeAiotPersonTablesResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeAiotPersonTablesResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeAiotPersonTablesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeAiotVehicleTableItemsRequest(TeaModel):
    def __init__(self, id=None, page_num=None, page_size=None, vehicle_table_id=None, vehicle_table_item_id=None):
        self.id = id  # type: str
        self.page_num = page_num  # type: long
        self.page_size = page_size  # type: long
        self.vehicle_table_id = vehicle_table_id  # type: str
        self.vehicle_table_item_id = vehicle_table_item_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeAiotVehicleTableItemsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['Id'] = self.id
        if self.page_num is not None:
            result['PageNum'] = self.page_num
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.vehicle_table_id is not None:
            result['VehicleTableId'] = self.vehicle_table_id
        if self.vehicle_table_item_id is not None:
            result['VehicleTableItemId'] = self.vehicle_table_item_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('PageNum') is not None:
            self.page_num = m.get('PageNum')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('VehicleTableId') is not None:
            self.vehicle_table_id = m.get('VehicleTableId')
        if m.get('VehicleTableItemId') is not None:
            self.vehicle_table_item_id = m.get('VehicleTableItemId')
        return self


class DescribeAiotVehicleTableItemsResponseBodyVehicleTableItemsVehicleTableItemList(TeaModel):
    def __init__(self, begin_time=None, end_time=None, owner_name=None, phone_no=None, plate_no=None, remarks=None,
                 vehicle_table_id=None, vehicle_table_item_id=None):
        self.begin_time = begin_time  # type: str
        self.end_time = end_time  # type: str
        self.owner_name = owner_name  # type: str
        self.phone_no = phone_no  # type: str
        self.plate_no = plate_no  # type: str
        self.remarks = remarks  # type: str
        self.vehicle_table_id = vehicle_table_id  # type: str
        self.vehicle_table_item_id = vehicle_table_item_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeAiotVehicleTableItemsResponseBodyVehicleTableItemsVehicleTableItemList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.begin_time is not None:
            result['BeginTime'] = self.begin_time
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.owner_name is not None:
            result['OwnerName'] = self.owner_name
        if self.phone_no is not None:
            result['PhoneNo'] = self.phone_no
        if self.plate_no is not None:
            result['PlateNo'] = self.plate_no
        if self.remarks is not None:
            result['Remarks'] = self.remarks
        if self.vehicle_table_id is not None:
            result['VehicleTableId'] = self.vehicle_table_id
        if self.vehicle_table_item_id is not None:
            result['VehicleTableItemId'] = self.vehicle_table_item_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BeginTime') is not None:
            self.begin_time = m.get('BeginTime')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('OwnerName') is not None:
            self.owner_name = m.get('OwnerName')
        if m.get('PhoneNo') is not None:
            self.phone_no = m.get('PhoneNo')
        if m.get('PlateNo') is not None:
            self.plate_no = m.get('PlateNo')
        if m.get('Remarks') is not None:
            self.remarks = m.get('Remarks')
        if m.get('VehicleTableId') is not None:
            self.vehicle_table_id = m.get('VehicleTableId')
        if m.get('VehicleTableItemId') is not None:
            self.vehicle_table_item_id = m.get('VehicleTableItemId')
        return self


class DescribeAiotVehicleTableItemsResponseBodyVehicleTableItems(TeaModel):
    def __init__(self, page_num=None, page_size=None, total_num=None, vehicle_table_item_list=None):
        self.page_num = page_num  # type: long
        self.page_size = page_size  # type: long
        self.total_num = total_num  # type: long
        self.vehicle_table_item_list = vehicle_table_item_list  # type: list[DescribeAiotVehicleTableItemsResponseBodyVehicleTableItemsVehicleTableItemList]

    def validate(self):
        if self.vehicle_table_item_list:
            for k in self.vehicle_table_item_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeAiotVehicleTableItemsResponseBodyVehicleTableItems, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_num is not None:
            result['PageNum'] = self.page_num
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_num is not None:
            result['TotalNum'] = self.total_num
        result['VehicleTableItemList'] = []
        if self.vehicle_table_item_list is not None:
            for k in self.vehicle_table_item_list:
                result['VehicleTableItemList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PageNum') is not None:
            self.page_num = m.get('PageNum')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalNum') is not None:
            self.total_num = m.get('TotalNum')
        self.vehicle_table_item_list = []
        if m.get('VehicleTableItemList') is not None:
            for k in m.get('VehicleTableItemList'):
                temp_model = DescribeAiotVehicleTableItemsResponseBodyVehicleTableItemsVehicleTableItemList()
                self.vehicle_table_item_list.append(temp_model.from_map(k))
        return self


class DescribeAiotVehicleTableItemsResponseBody(TeaModel):
    def __init__(self, code=None, message=None, request_id=None, vehicle_table_items=None):
        self.code = code  # type: str
        self.message = message  # type: str
        # Id of the request
        self.request_id = request_id  # type: str
        self.vehicle_table_items = vehicle_table_items  # type: DescribeAiotVehicleTableItemsResponseBodyVehicleTableItems

    def validate(self):
        if self.vehicle_table_items:
            self.vehicle_table_items.validate()

    def to_map(self):
        _map = super(DescribeAiotVehicleTableItemsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.vehicle_table_items is not None:
            result['VehicleTableItems'] = self.vehicle_table_items.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('VehicleTableItems') is not None:
            temp_model = DescribeAiotVehicleTableItemsResponseBodyVehicleTableItems()
            self.vehicle_table_items = temp_model.from_map(m['VehicleTableItems'])
        return self


class DescribeAiotVehicleTableItemsResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeAiotVehicleTableItemsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeAiotVehicleTableItemsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeAiotVehicleTableItemsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeAiotVehicleTablesRequest(TeaModel):
    def __init__(self, id=None, vehicle_table_id_list=None):
        self.id = id  # type: str
        self.vehicle_table_id_list = vehicle_table_id_list  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeAiotVehicleTablesRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['Id'] = self.id
        if self.vehicle_table_id_list is not None:
            result['VehicleTableIdList'] = self.vehicle_table_id_list
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('VehicleTableIdList') is not None:
            self.vehicle_table_id_list = m.get('VehicleTableIdList')
        return self


class DescribeAiotVehicleTablesResponseBodyVehicleTableList(TeaModel):
    def __init__(self, vehicle_table_id=None, vehicle_table_name=None):
        self.vehicle_table_id = vehicle_table_id  # type: str
        self.vehicle_table_name = vehicle_table_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeAiotVehicleTablesResponseBodyVehicleTableList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.vehicle_table_id is not None:
            result['VehicleTableId'] = self.vehicle_table_id
        if self.vehicle_table_name is not None:
            result['VehicleTableName'] = self.vehicle_table_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('VehicleTableId') is not None:
            self.vehicle_table_id = m.get('VehicleTableId')
        if m.get('VehicleTableName') is not None:
            self.vehicle_table_name = m.get('VehicleTableName')
        return self


class DescribeAiotVehicleTablesResponseBody(TeaModel):
    def __init__(self, code=None, message=None, request_id=None, vehicle_table_list=None):
        self.code = code  # type: str
        self.message = message  # type: str
        # Id of the request
        self.request_id = request_id  # type: str
        self.vehicle_table_list = vehicle_table_list  # type: list[DescribeAiotVehicleTablesResponseBodyVehicleTableList]

    def validate(self):
        if self.vehicle_table_list:
            for k in self.vehicle_table_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeAiotVehicleTablesResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['VehicleTableList'] = []
        if self.vehicle_table_list is not None:
            for k in self.vehicle_table_list:
                result['VehicleTableList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.vehicle_table_list = []
        if m.get('VehicleTableList') is not None:
            for k in m.get('VehicleTableList'):
                temp_model = DescribeAiotVehicleTablesResponseBodyVehicleTableList()
                self.vehicle_table_list.append(temp_model.from_map(k))
        return self


class DescribeAiotVehicleTablesResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeAiotVehicleTablesResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeAiotVehicleTablesResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeAiotVehicleTablesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeCameraForInstanceRequest(TeaModel):
    def __init__(self, instance_id=None, page_number=None, page_size=None):
        # 实例id
        self.instance_id = instance_id  # type: str
        # 当前页序号
        self.page_number = page_number  # type: long
        # 每页显示多少条数据
        self.page_size = page_size  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeCameraForInstanceRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class DescribeCameraForInstanceResponseBodyDataRecords(TeaModel):
    def __init__(self, camera_address=None, camera_id=None, camera_name=None, camera_status=None):
        # 设备地址
        self.camera_address = camera_address  # type: str
        # 设备编号
        self.camera_id = camera_id  # type: str
        # 设备名称
        self.camera_name = camera_name  # type: str
        # 设备在线状态。 1表示在线，0表示离线, 2表示待注册
        self.camera_status = camera_status  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeCameraForInstanceResponseBodyDataRecords, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.camera_address is not None:
            result['CameraAddress'] = self.camera_address
        if self.camera_id is not None:
            result['CameraId'] = self.camera_id
        if self.camera_name is not None:
            result['CameraName'] = self.camera_name
        if self.camera_status is not None:
            result['CameraStatus'] = self.camera_status
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CameraAddress') is not None:
            self.camera_address = m.get('CameraAddress')
        if m.get('CameraId') is not None:
            self.camera_id = m.get('CameraId')
        if m.get('CameraName') is not None:
            self.camera_name = m.get('CameraName')
        if m.get('CameraStatus') is not None:
            self.camera_status = m.get('CameraStatus')
        return self


class DescribeCameraForInstanceResponseBodyData(TeaModel):
    def __init__(self, page_number=None, page_size=None, records=None, total_count=None):
        # 当前页序号
        self.page_number = page_number  # type: long
        # 每页显示多少条
        self.page_size = page_size  # type: long
        # 返回数据条目
        self.records = records  # type: list[DescribeCameraForInstanceResponseBodyDataRecords]
        # 总数据数
        self.total_count = total_count  # type: long

    def validate(self):
        if self.records:
            for k in self.records:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeCameraForInstanceResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        result['Records'] = []
        if self.records is not None:
            for k in self.records:
                result['Records'].append(k.to_map() if k else None)
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        self.records = []
        if m.get('Records') is not None:
            for k in m.get('Records'):
                temp_model = DescribeCameraForInstanceResponseBodyDataRecords()
                self.records.append(temp_model.from_map(k))
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeCameraForInstanceResponseBody(TeaModel):
    def __init__(self, code=None, data=None, message=None, request_id=None):
        # 返回错误码
        self.code = code  # type: str
        # 返回数据
        self.data = data  # type: DescribeCameraForInstanceResponseBodyData
        # 错误信息
        self.message = message  # type: str
        # Id of the request
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(DescribeCameraForInstanceResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = DescribeCameraForInstanceResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeCameraForInstanceResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeCameraForInstanceResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeCameraForInstanceResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeCameraForInstanceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeChannelsRequest(TeaModel):
    def __init__(self, device_filter=None, device_status=None, nvr_id=None, page_num=None, page_size=None,
                 show_un_config=None):
        self.device_filter = device_filter  # type: str
        self.device_status = device_status  # type: str
        self.nvr_id = nvr_id  # type: str
        self.page_num = page_num  # type: long
        self.page_size = page_size  # type: long
        self.show_un_config = show_un_config  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeChannelsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_filter is not None:
            result['DeviceFilter'] = self.device_filter
        if self.device_status is not None:
            result['DeviceStatus'] = self.device_status
        if self.nvr_id is not None:
            result['NvrId'] = self.nvr_id
        if self.page_num is not None:
            result['PageNum'] = self.page_num
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.show_un_config is not None:
            result['ShowUnConfig'] = self.show_un_config
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DeviceFilter') is not None:
            self.device_filter = m.get('DeviceFilter')
        if m.get('DeviceStatus') is not None:
            self.device_status = m.get('DeviceStatus')
        if m.get('NvrId') is not None:
            self.nvr_id = m.get('NvrId')
        if m.get('PageNum') is not None:
            self.page_num = m.get('PageNum')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('ShowUnConfig') is not None:
            self.show_un_config = m.get('ShowUnConfig')
        return self


class DescribeChannelsResponseBodyDataRecords(TeaModel):
    def __init__(self, audio_enable=None, corp_id=None, create_time=None, datasource_type=None, device_address=None,
                 device_direction=None, device_id=None, device_ip=None, device_model=None, device_name=None, device_rate=None,
                 device_resolution=None, device_site=None, device_sn=None, device_status=None, device_sub_type=None, device_type=None,
                 encode_format=None, frame_rate=None, gov_length=None, in_protocol=None, latitude=None, longitude=None,
                 modify_time=None, osdtime_enable=None, osdtime_type=None, osdtime_x=None, osdtime_y=None,
                 parent_device_id=None, password=None, server_id=None, server_ip=None, server_port=None, server_realm=None,
                 stream_action=None, stream_status=None, vap=None, vendor=None):
        self.audio_enable = audio_enable  # type: str
        self.corp_id = corp_id  # type: str
        self.create_time = create_time  # type: str
        self.datasource_type = datasource_type  # type: str
        self.device_address = device_address  # type: str
        self.device_direction = device_direction  # type: str
        self.device_id = device_id  # type: str
        self.device_ip = device_ip  # type: str
        self.device_model = device_model  # type: str
        self.device_name = device_name  # type: str
        self.device_rate = device_rate  # type: str
        self.device_resolution = device_resolution  # type: str
        self.device_site = device_site  # type: str
        self.device_sn = device_sn  # type: str
        self.device_status = device_status  # type: str
        self.device_sub_type = device_sub_type  # type: str
        self.device_type = device_type  # type: str
        self.encode_format = encode_format  # type: str
        self.frame_rate = frame_rate  # type: str
        self.gov_length = gov_length  # type: str
        self.in_protocol = in_protocol  # type: str
        self.latitude = latitude  # type: str
        self.longitude = longitude  # type: str
        self.modify_time = modify_time  # type: str
        self.osdtime_enable = osdtime_enable  # type: str
        self.osdtime_type = osdtime_type  # type: str
        self.osdtime_x = osdtime_x  # type: str
        self.osdtime_y = osdtime_y  # type: str
        self.parent_device_id = parent_device_id  # type: str
        self.password = password  # type: str
        self.server_id = server_id  # type: str
        self.server_ip = server_ip  # type: str
        self.server_port = server_port  # type: str
        self.server_realm = server_realm  # type: str
        self.stream_action = stream_action  # type: str
        self.stream_status = stream_status  # type: str
        self.vap = vap  # type: str
        self.vendor = vendor  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeChannelsResponseBodyDataRecords, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.audio_enable is not None:
            result['AudioEnable'] = self.audio_enable
        if self.corp_id is not None:
            result['CorpId'] = self.corp_id
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.datasource_type is not None:
            result['DatasourceType'] = self.datasource_type
        if self.device_address is not None:
            result['DeviceAddress'] = self.device_address
        if self.device_direction is not None:
            result['DeviceDirection'] = self.device_direction
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.device_ip is not None:
            result['DeviceIp'] = self.device_ip
        if self.device_model is not None:
            result['DeviceModel'] = self.device_model
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.device_rate is not None:
            result['DeviceRate'] = self.device_rate
        if self.device_resolution is not None:
            result['DeviceResolution'] = self.device_resolution
        if self.device_site is not None:
            result['DeviceSite'] = self.device_site
        if self.device_sn is not None:
            result['DeviceSn'] = self.device_sn
        if self.device_status is not None:
            result['DeviceStatus'] = self.device_status
        if self.device_sub_type is not None:
            result['DeviceSubType'] = self.device_sub_type
        if self.device_type is not None:
            result['DeviceType'] = self.device_type
        if self.encode_format is not None:
            result['EncodeFormat'] = self.encode_format
        if self.frame_rate is not None:
            result['FrameRate'] = self.frame_rate
        if self.gov_length is not None:
            result['GovLength'] = self.gov_length
        if self.in_protocol is not None:
            result['InProtocol'] = self.in_protocol
        if self.latitude is not None:
            result['Latitude'] = self.latitude
        if self.longitude is not None:
            result['Longitude'] = self.longitude
        if self.modify_time is not None:
            result['ModifyTime'] = self.modify_time
        if self.osdtime_enable is not None:
            result['OSDTimeEnable'] = self.osdtime_enable
        if self.osdtime_type is not None:
            result['OSDTimeType'] = self.osdtime_type
        if self.osdtime_x is not None:
            result['OSDTimeX'] = self.osdtime_x
        if self.osdtime_y is not None:
            result['OSDTimeY'] = self.osdtime_y
        if self.parent_device_id is not None:
            result['ParentDeviceId'] = self.parent_device_id
        if self.password is not None:
            result['Password'] = self.password
        if self.server_id is not None:
            result['ServerId'] = self.server_id
        if self.server_ip is not None:
            result['ServerIp'] = self.server_ip
        if self.server_port is not None:
            result['ServerPort'] = self.server_port
        if self.server_realm is not None:
            result['ServerRealm'] = self.server_realm
        if self.stream_action is not None:
            result['StreamAction'] = self.stream_action
        if self.stream_status is not None:
            result['StreamStatus'] = self.stream_status
        if self.vap is not None:
            result['Vap'] = self.vap
        if self.vendor is not None:
            result['Vendor'] = self.vendor
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AudioEnable') is not None:
            self.audio_enable = m.get('AudioEnable')
        if m.get('CorpId') is not None:
            self.corp_id = m.get('CorpId')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('DatasourceType') is not None:
            self.datasource_type = m.get('DatasourceType')
        if m.get('DeviceAddress') is not None:
            self.device_address = m.get('DeviceAddress')
        if m.get('DeviceDirection') is not None:
            self.device_direction = m.get('DeviceDirection')
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('DeviceIp') is not None:
            self.device_ip = m.get('DeviceIp')
        if m.get('DeviceModel') is not None:
            self.device_model = m.get('DeviceModel')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('DeviceRate') is not None:
            self.device_rate = m.get('DeviceRate')
        if m.get('DeviceResolution') is not None:
            self.device_resolution = m.get('DeviceResolution')
        if m.get('DeviceSite') is not None:
            self.device_site = m.get('DeviceSite')
        if m.get('DeviceSn') is not None:
            self.device_sn = m.get('DeviceSn')
        if m.get('DeviceStatus') is not None:
            self.device_status = m.get('DeviceStatus')
        if m.get('DeviceSubType') is not None:
            self.device_sub_type = m.get('DeviceSubType')
        if m.get('DeviceType') is not None:
            self.device_type = m.get('DeviceType')
        if m.get('EncodeFormat') is not None:
            self.encode_format = m.get('EncodeFormat')
        if m.get('FrameRate') is not None:
            self.frame_rate = m.get('FrameRate')
        if m.get('GovLength') is not None:
            self.gov_length = m.get('GovLength')
        if m.get('InProtocol') is not None:
            self.in_protocol = m.get('InProtocol')
        if m.get('Latitude') is not None:
            self.latitude = m.get('Latitude')
        if m.get('Longitude') is not None:
            self.longitude = m.get('Longitude')
        if m.get('ModifyTime') is not None:
            self.modify_time = m.get('ModifyTime')
        if m.get('OSDTimeEnable') is not None:
            self.osdtime_enable = m.get('OSDTimeEnable')
        if m.get('OSDTimeType') is not None:
            self.osdtime_type = m.get('OSDTimeType')
        if m.get('OSDTimeX') is not None:
            self.osdtime_x = m.get('OSDTimeX')
        if m.get('OSDTimeY') is not None:
            self.osdtime_y = m.get('OSDTimeY')
        if m.get('ParentDeviceId') is not None:
            self.parent_device_id = m.get('ParentDeviceId')
        if m.get('Password') is not None:
            self.password = m.get('Password')
        if m.get('ServerId') is not None:
            self.server_id = m.get('ServerId')
        if m.get('ServerIp') is not None:
            self.server_ip = m.get('ServerIp')
        if m.get('ServerPort') is not None:
            self.server_port = m.get('ServerPort')
        if m.get('ServerRealm') is not None:
            self.server_realm = m.get('ServerRealm')
        if m.get('StreamAction') is not None:
            self.stream_action = m.get('StreamAction')
        if m.get('StreamStatus') is not None:
            self.stream_status = m.get('StreamStatus')
        if m.get('Vap') is not None:
            self.vap = m.get('Vap')
        if m.get('Vendor') is not None:
            self.vendor = m.get('Vendor')
        return self


class DescribeChannelsResponseBodyData(TeaModel):
    def __init__(self, page_num=None, page_size=None, records=None, total_count=None, total_page=None,
                 un_config_list=None):
        self.page_num = page_num  # type: long
        self.page_size = page_size  # type: long
        self.records = records  # type: list[DescribeChannelsResponseBodyDataRecords]
        self.total_count = total_count  # type: long
        self.total_page = total_page  # type: long
        self.un_config_list = un_config_list  # type: list[str]

    def validate(self):
        if self.records:
            for k in self.records:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeChannelsResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_num is not None:
            result['PageNum'] = self.page_num
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        result['Records'] = []
        if self.records is not None:
            for k in self.records:
                result['Records'].append(k.to_map() if k else None)
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.total_page is not None:
            result['TotalPage'] = self.total_page
        if self.un_config_list is not None:
            result['UnConfigList'] = self.un_config_list
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PageNum') is not None:
            self.page_num = m.get('PageNum')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        self.records = []
        if m.get('Records') is not None:
            for k in m.get('Records'):
                temp_model = DescribeChannelsResponseBodyDataRecords()
                self.records.append(temp_model.from_map(k))
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('TotalPage') is not None:
            self.total_page = m.get('TotalPage')
        if m.get('UnConfigList') is not None:
            self.un_config_list = m.get('UnConfigList')
        return self


class DescribeChannelsResponseBody(TeaModel):
    def __init__(self, code=None, data=None, message=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: DescribeChannelsResponseBodyData
        self.message = message  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(DescribeChannelsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = DescribeChannelsResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeChannelsResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeChannelsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeChannelsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeChannelsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDataSourcesRequest(TeaModel):
    def __init__(self, corp_id_list=None, data_source_category=None, data_source_filter=None,
                 data_source_id_list=None, data_source_type=None, page_num=None, page_size=None, stream_status=None):
        self.corp_id_list = corp_id_list  # type: str
        self.data_source_category = data_source_category  # type: str
        self.data_source_filter = data_source_filter  # type: str
        self.data_source_id_list = data_source_id_list  # type: str
        self.data_source_type = data_source_type  # type: str
        self.page_num = page_num  # type: long
        self.page_size = page_size  # type: long
        self.stream_status = stream_status  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDataSourcesRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.corp_id_list is not None:
            result['CorpIdList'] = self.corp_id_list
        if self.data_source_category is not None:
            result['DataSourceCategory'] = self.data_source_category
        if self.data_source_filter is not None:
            result['DataSourceFilter'] = self.data_source_filter
        if self.data_source_id_list is not None:
            result['DataSourceIdList'] = self.data_source_id_list
        if self.data_source_type is not None:
            result['DataSourceType'] = self.data_source_type
        if self.page_num is not None:
            result['PageNum'] = self.page_num
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.stream_status is not None:
            result['StreamStatus'] = self.stream_status
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CorpIdList') is not None:
            self.corp_id_list = m.get('CorpIdList')
        if m.get('DataSourceCategory') is not None:
            self.data_source_category = m.get('DataSourceCategory')
        if m.get('DataSourceFilter') is not None:
            self.data_source_filter = m.get('DataSourceFilter')
        if m.get('DataSourceIdList') is not None:
            self.data_source_id_list = m.get('DataSourceIdList')
        if m.get('DataSourceType') is not None:
            self.data_source_type = m.get('DataSourceType')
        if m.get('PageNum') is not None:
            self.page_num = m.get('PageNum')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('StreamStatus') is not None:
            self.stream_status = m.get('StreamStatus')
        return self


class DescribeDataSourcesResponseBodyDataRecords(TeaModel):
    def __init__(self, action=None, corp_id=None, create_time=None, data_source_id=None, data_source_name=None,
                 data_source_type=None, description=None, kafka_topic=None, oss_path=None, stream_status=None, url=None):
        self.action = action  # type: str
        self.corp_id = corp_id  # type: str
        self.create_time = create_time  # type: str
        self.data_source_id = data_source_id  # type: str
        self.data_source_name = data_source_name  # type: str
        self.data_source_type = data_source_type  # type: str
        self.description = description  # type: str
        self.kafka_topic = kafka_topic  # type: str
        self.oss_path = oss_path  # type: str
        self.stream_status = stream_status  # type: str
        self.url = url  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDataSourcesResponseBodyDataRecords, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.action is not None:
            result['Action'] = self.action
        if self.corp_id is not None:
            result['CorpId'] = self.corp_id
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.data_source_id is not None:
            result['DataSourceId'] = self.data_source_id
        if self.data_source_name is not None:
            result['DataSourceName'] = self.data_source_name
        if self.data_source_type is not None:
            result['DataSourceType'] = self.data_source_type
        if self.description is not None:
            result['Description'] = self.description
        if self.kafka_topic is not None:
            result['KafkaTopic'] = self.kafka_topic
        if self.oss_path is not None:
            result['OssPath'] = self.oss_path
        if self.stream_status is not None:
            result['StreamStatus'] = self.stream_status
        if self.url is not None:
            result['Url'] = self.url
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Action') is not None:
            self.action = m.get('Action')
        if m.get('CorpId') is not None:
            self.corp_id = m.get('CorpId')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('DataSourceId') is not None:
            self.data_source_id = m.get('DataSourceId')
        if m.get('DataSourceName') is not None:
            self.data_source_name = m.get('DataSourceName')
        if m.get('DataSourceType') is not None:
            self.data_source_type = m.get('DataSourceType')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('KafkaTopic') is not None:
            self.kafka_topic = m.get('KafkaTopic')
        if m.get('OssPath') is not None:
            self.oss_path = m.get('OssPath')
        if m.get('StreamStatus') is not None:
            self.stream_status = m.get('StreamStatus')
        if m.get('Url') is not None:
            self.url = m.get('Url')
        return self


class DescribeDataSourcesResponseBodyData(TeaModel):
    def __init__(self, page_num=None, page_size=None, records=None, total_count=None, total_page=None):
        self.page_num = page_num  # type: long
        self.page_size = page_size  # type: long
        self.records = records  # type: list[DescribeDataSourcesResponseBodyDataRecords]
        self.total_count = total_count  # type: long
        self.total_page = total_page  # type: long

    def validate(self):
        if self.records:
            for k in self.records:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeDataSourcesResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_num is not None:
            result['PageNum'] = self.page_num
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        result['Records'] = []
        if self.records is not None:
            for k in self.records:
                result['Records'].append(k.to_map() if k else None)
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.total_page is not None:
            result['TotalPage'] = self.total_page
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PageNum') is not None:
            self.page_num = m.get('PageNum')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        self.records = []
        if m.get('Records') is not None:
            for k in m.get('Records'):
                temp_model = DescribeDataSourcesResponseBodyDataRecords()
                self.records.append(temp_model.from_map(k))
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('TotalPage') is not None:
            self.total_page = m.get('TotalPage')
        return self


class DescribeDataSourcesResponseBody(TeaModel):
    def __init__(self, code=None, data=None, message=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: DescribeDataSourcesResponseBodyData
        self.message = message  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(DescribeDataSourcesResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = DescribeDataSourcesResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeDataSourcesResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeDataSourcesResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeDataSourcesResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDataSourcesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDevicesRequest(TeaModel):
    def __init__(self, corp_id_list=None, device_id_list=None, page_num=None, page_size=None):
        self.corp_id_list = corp_id_list  # type: str
        self.device_id_list = device_id_list  # type: str
        self.page_num = page_num  # type: int
        self.page_size = page_size  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDevicesRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.corp_id_list is not None:
            result['CorpIdList'] = self.corp_id_list
        if self.device_id_list is not None:
            result['DeviceIdList'] = self.device_id_list
        if self.page_num is not None:
            result['PageNum'] = self.page_num
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CorpIdList') is not None:
            self.corp_id_list = m.get('CorpIdList')
        if m.get('DeviceIdList') is not None:
            self.device_id_list = m.get('DeviceIdList')
        if m.get('PageNum') is not None:
            self.page_num = m.get('PageNum')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class DescribeDevicesResponseBodyDataRecords(TeaModel):
    def __init__(self, captured_picture_id=None, corp_id=None, create_time=None, device_address=None,
                 device_id=None, device_name=None, device_type=None, in_protocol=None, latitude=None, longitude=None,
                 password=None, status=None, vendor=None):
        self.captured_picture_id = captured_picture_id  # type: str
        self.corp_id = corp_id  # type: str
        self.create_time = create_time  # type: str
        self.device_address = device_address  # type: str
        self.device_id = device_id  # type: str
        self.device_name = device_name  # type: str
        self.device_type = device_type  # type: str
        self.in_protocol = in_protocol  # type: str
        self.latitude = latitude  # type: str
        self.longitude = longitude  # type: str
        self.password = password  # type: str
        self.status = status  # type: str
        self.vendor = vendor  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDevicesResponseBodyDataRecords, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.captured_picture_id is not None:
            result['CapturedPictureId'] = self.captured_picture_id
        if self.corp_id is not None:
            result['CorpId'] = self.corp_id
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.device_address is not None:
            result['DeviceAddress'] = self.device_address
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.device_type is not None:
            result['DeviceType'] = self.device_type
        if self.in_protocol is not None:
            result['InProtocol'] = self.in_protocol
        if self.latitude is not None:
            result['Latitude'] = self.latitude
        if self.longitude is not None:
            result['Longitude'] = self.longitude
        if self.password is not None:
            result['Password'] = self.password
        if self.status is not None:
            result['Status'] = self.status
        if self.vendor is not None:
            result['Vendor'] = self.vendor
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CapturedPictureId') is not None:
            self.captured_picture_id = m.get('CapturedPictureId')
        if m.get('CorpId') is not None:
            self.corp_id = m.get('CorpId')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('DeviceAddress') is not None:
            self.device_address = m.get('DeviceAddress')
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('DeviceType') is not None:
            self.device_type = m.get('DeviceType')
        if m.get('InProtocol') is not None:
            self.in_protocol = m.get('InProtocol')
        if m.get('Latitude') is not None:
            self.latitude = m.get('Latitude')
        if m.get('Longitude') is not None:
            self.longitude = m.get('Longitude')
        if m.get('Password') is not None:
            self.password = m.get('Password')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Vendor') is not None:
            self.vendor = m.get('Vendor')
        return self


class DescribeDevicesResponseBodyData(TeaModel):
    def __init__(self, page_num=None, page_size=None, records=None, total_count=None, total_page=None):
        self.page_num = page_num  # type: int
        self.page_size = page_size  # type: int
        self.records = records  # type: list[DescribeDevicesResponseBodyDataRecords]
        self.total_count = total_count  # type: int
        self.total_page = total_page  # type: int

    def validate(self):
        if self.records:
            for k in self.records:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeDevicesResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_num is not None:
            result['PageNum'] = self.page_num
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        result['Records'] = []
        if self.records is not None:
            for k in self.records:
                result['Records'].append(k.to_map() if k else None)
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.total_page is not None:
            result['TotalPage'] = self.total_page
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PageNum') is not None:
            self.page_num = m.get('PageNum')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        self.records = []
        if m.get('Records') is not None:
            for k in m.get('Records'):
                temp_model = DescribeDevicesResponseBodyDataRecords()
                self.records.append(temp_model.from_map(k))
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('TotalPage') is not None:
            self.total_page = m.get('TotalPage')
        return self


class DescribeDevicesResponseBody(TeaModel):
    def __init__(self, code=None, data=None, message=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: DescribeDevicesResponseBodyData
        self.message = message  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(DescribeDevicesResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = DescribeDevicesResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeDevicesResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeDevicesResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeDevicesResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDevicesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeIpcsRequest(TeaModel):
    def __init__(self, corp_id_list=None, device_filter=None, device_id_list=None, device_status=None,
                 nvr_id_list=None, page_num=None, page_size=None, parent_device_type=None):
        self.corp_id_list = corp_id_list  # type: str
        self.device_filter = device_filter  # type: str
        self.device_id_list = device_id_list  # type: str
        self.device_status = device_status  # type: str
        self.nvr_id_list = nvr_id_list  # type: str
        self.page_num = page_num  # type: long
        self.page_size = page_size  # type: long
        self.parent_device_type = parent_device_type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeIpcsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.corp_id_list is not None:
            result['CorpIdList'] = self.corp_id_list
        if self.device_filter is not None:
            result['DeviceFilter'] = self.device_filter
        if self.device_id_list is not None:
            result['DeviceIdList'] = self.device_id_list
        if self.device_status is not None:
            result['DeviceStatus'] = self.device_status
        if self.nvr_id_list is not None:
            result['NvrIdList'] = self.nvr_id_list
        if self.page_num is not None:
            result['PageNum'] = self.page_num
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.parent_device_type is not None:
            result['ParentDeviceType'] = self.parent_device_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CorpIdList') is not None:
            self.corp_id_list = m.get('CorpIdList')
        if m.get('DeviceFilter') is not None:
            self.device_filter = m.get('DeviceFilter')
        if m.get('DeviceIdList') is not None:
            self.device_id_list = m.get('DeviceIdList')
        if m.get('DeviceStatus') is not None:
            self.device_status = m.get('DeviceStatus')
        if m.get('NvrIdList') is not None:
            self.nvr_id_list = m.get('NvrIdList')
        if m.get('PageNum') is not None:
            self.page_num = m.get('PageNum')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('ParentDeviceType') is not None:
            self.parent_device_type = m.get('ParentDeviceType')
        return self


class DescribeIpcsResponseBodyDataRecords(TeaModel):
    def __init__(self, audio_enable=None, corp_id=None, create_time=None, datasource_type=None, device_address=None,
                 device_direction=None, device_id=None, device_ip=None, device_model=None, device_name=None, device_rate=None,
                 device_resolution=None, device_site=None, device_sn=None, device_status=None, device_sub_type=None, device_type=None,
                 encode_format=None, frame_rate=None, gov_length=None, in_protocol=None, latitude=None, longitude=None,
                 modify_time=None, osdtime_enable=None, osdtime_type=None, osdtime_x=None, osdtime_y=None,
                 parent_device_id=None, password=None, server_id=None, server_ip=None, server_port=None, server_realm=None,
                 stream_action=None, stream_status=None, vap=None, vendor=None):
        self.audio_enable = audio_enable  # type: str
        self.corp_id = corp_id  # type: str
        self.create_time = create_time  # type: str
        self.datasource_type = datasource_type  # type: str
        self.device_address = device_address  # type: str
        self.device_direction = device_direction  # type: str
        self.device_id = device_id  # type: str
        self.device_ip = device_ip  # type: str
        self.device_model = device_model  # type: str
        self.device_name = device_name  # type: str
        self.device_rate = device_rate  # type: str
        self.device_resolution = device_resolution  # type: str
        self.device_site = device_site  # type: str
        self.device_sn = device_sn  # type: str
        self.device_status = device_status  # type: str
        self.device_sub_type = device_sub_type  # type: str
        self.device_type = device_type  # type: str
        self.encode_format = encode_format  # type: str
        self.frame_rate = frame_rate  # type: str
        self.gov_length = gov_length  # type: str
        self.in_protocol = in_protocol  # type: str
        self.latitude = latitude  # type: str
        self.longitude = longitude  # type: str
        self.modify_time = modify_time  # type: str
        self.osdtime_enable = osdtime_enable  # type: str
        self.osdtime_type = osdtime_type  # type: str
        self.osdtime_x = osdtime_x  # type: str
        self.osdtime_y = osdtime_y  # type: str
        self.parent_device_id = parent_device_id  # type: str
        self.password = password  # type: str
        self.server_id = server_id  # type: str
        self.server_ip = server_ip  # type: str
        self.server_port = server_port  # type: str
        self.server_realm = server_realm  # type: str
        self.stream_action = stream_action  # type: str
        self.stream_status = stream_status  # type: str
        self.vap = vap  # type: str
        self.vendor = vendor  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeIpcsResponseBodyDataRecords, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.audio_enable is not None:
            result['AudioEnable'] = self.audio_enable
        if self.corp_id is not None:
            result['CorpId'] = self.corp_id
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.datasource_type is not None:
            result['DatasourceType'] = self.datasource_type
        if self.device_address is not None:
            result['DeviceAddress'] = self.device_address
        if self.device_direction is not None:
            result['DeviceDirection'] = self.device_direction
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.device_ip is not None:
            result['DeviceIp'] = self.device_ip
        if self.device_model is not None:
            result['DeviceModel'] = self.device_model
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.device_rate is not None:
            result['DeviceRate'] = self.device_rate
        if self.device_resolution is not None:
            result['DeviceResolution'] = self.device_resolution
        if self.device_site is not None:
            result['DeviceSite'] = self.device_site
        if self.device_sn is not None:
            result['DeviceSn'] = self.device_sn
        if self.device_status is not None:
            result['DeviceStatus'] = self.device_status
        if self.device_sub_type is not None:
            result['DeviceSubType'] = self.device_sub_type
        if self.device_type is not None:
            result['DeviceType'] = self.device_type
        if self.encode_format is not None:
            result['EncodeFormat'] = self.encode_format
        if self.frame_rate is not None:
            result['FrameRate'] = self.frame_rate
        if self.gov_length is not None:
            result['GovLength'] = self.gov_length
        if self.in_protocol is not None:
            result['InProtocol'] = self.in_protocol
        if self.latitude is not None:
            result['Latitude'] = self.latitude
        if self.longitude is not None:
            result['Longitude'] = self.longitude
        if self.modify_time is not None:
            result['ModifyTime'] = self.modify_time
        if self.osdtime_enable is not None:
            result['OSDTimeEnable'] = self.osdtime_enable
        if self.osdtime_type is not None:
            result['OSDTimeType'] = self.osdtime_type
        if self.osdtime_x is not None:
            result['OSDTimeX'] = self.osdtime_x
        if self.osdtime_y is not None:
            result['OSDTimeY'] = self.osdtime_y
        if self.parent_device_id is not None:
            result['ParentDeviceId'] = self.parent_device_id
        if self.password is not None:
            result['Password'] = self.password
        if self.server_id is not None:
            result['ServerId'] = self.server_id
        if self.server_ip is not None:
            result['ServerIp'] = self.server_ip
        if self.server_port is not None:
            result['ServerPort'] = self.server_port
        if self.server_realm is not None:
            result['ServerRealm'] = self.server_realm
        if self.stream_action is not None:
            result['StreamAction'] = self.stream_action
        if self.stream_status is not None:
            result['StreamStatus'] = self.stream_status
        if self.vap is not None:
            result['Vap'] = self.vap
        if self.vendor is not None:
            result['Vendor'] = self.vendor
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AudioEnable') is not None:
            self.audio_enable = m.get('AudioEnable')
        if m.get('CorpId') is not None:
            self.corp_id = m.get('CorpId')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('DatasourceType') is not None:
            self.datasource_type = m.get('DatasourceType')
        if m.get('DeviceAddress') is not None:
            self.device_address = m.get('DeviceAddress')
        if m.get('DeviceDirection') is not None:
            self.device_direction = m.get('DeviceDirection')
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('DeviceIp') is not None:
            self.device_ip = m.get('DeviceIp')
        if m.get('DeviceModel') is not None:
            self.device_model = m.get('DeviceModel')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('DeviceRate') is not None:
            self.device_rate = m.get('DeviceRate')
        if m.get('DeviceResolution') is not None:
            self.device_resolution = m.get('DeviceResolution')
        if m.get('DeviceSite') is not None:
            self.device_site = m.get('DeviceSite')
        if m.get('DeviceSn') is not None:
            self.device_sn = m.get('DeviceSn')
        if m.get('DeviceStatus') is not None:
            self.device_status = m.get('DeviceStatus')
        if m.get('DeviceSubType') is not None:
            self.device_sub_type = m.get('DeviceSubType')
        if m.get('DeviceType') is not None:
            self.device_type = m.get('DeviceType')
        if m.get('EncodeFormat') is not None:
            self.encode_format = m.get('EncodeFormat')
        if m.get('FrameRate') is not None:
            self.frame_rate = m.get('FrameRate')
        if m.get('GovLength') is not None:
            self.gov_length = m.get('GovLength')
        if m.get('InProtocol') is not None:
            self.in_protocol = m.get('InProtocol')
        if m.get('Latitude') is not None:
            self.latitude = m.get('Latitude')
        if m.get('Longitude') is not None:
            self.longitude = m.get('Longitude')
        if m.get('ModifyTime') is not None:
            self.modify_time = m.get('ModifyTime')
        if m.get('OSDTimeEnable') is not None:
            self.osdtime_enable = m.get('OSDTimeEnable')
        if m.get('OSDTimeType') is not None:
            self.osdtime_type = m.get('OSDTimeType')
        if m.get('OSDTimeX') is not None:
            self.osdtime_x = m.get('OSDTimeX')
        if m.get('OSDTimeY') is not None:
            self.osdtime_y = m.get('OSDTimeY')
        if m.get('ParentDeviceId') is not None:
            self.parent_device_id = m.get('ParentDeviceId')
        if m.get('Password') is not None:
            self.password = m.get('Password')
        if m.get('ServerId') is not None:
            self.server_id = m.get('ServerId')
        if m.get('ServerIp') is not None:
            self.server_ip = m.get('ServerIp')
        if m.get('ServerPort') is not None:
            self.server_port = m.get('ServerPort')
        if m.get('ServerRealm') is not None:
            self.server_realm = m.get('ServerRealm')
        if m.get('StreamAction') is not None:
            self.stream_action = m.get('StreamAction')
        if m.get('StreamStatus') is not None:
            self.stream_status = m.get('StreamStatus')
        if m.get('Vap') is not None:
            self.vap = m.get('Vap')
        if m.get('Vendor') is not None:
            self.vendor = m.get('Vendor')
        return self


class DescribeIpcsResponseBodyData(TeaModel):
    def __init__(self, page_num=None, page_size=None, records=None, total_count=None, total_page=None):
        self.page_num = page_num  # type: long
        self.page_size = page_size  # type: long
        self.records = records  # type: list[DescribeIpcsResponseBodyDataRecords]
        self.total_count = total_count  # type: long
        self.total_page = total_page  # type: long

    def validate(self):
        if self.records:
            for k in self.records:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeIpcsResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_num is not None:
            result['PageNum'] = self.page_num
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        result['Records'] = []
        if self.records is not None:
            for k in self.records:
                result['Records'].append(k.to_map() if k else None)
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.total_page is not None:
            result['TotalPage'] = self.total_page
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PageNum') is not None:
            self.page_num = m.get('PageNum')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        self.records = []
        if m.get('Records') is not None:
            for k in m.get('Records'):
                temp_model = DescribeIpcsResponseBodyDataRecords()
                self.records.append(temp_model.from_map(k))
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('TotalPage') is not None:
            self.total_page = m.get('TotalPage')
        return self


class DescribeIpcsResponseBody(TeaModel):
    def __init__(self, code=None, data=None, message=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: DescribeIpcsResponseBodyData
        self.message = message  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(DescribeIpcsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = DescribeIpcsResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeIpcsResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeIpcsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeIpcsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeIpcsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeModelServiceRequest(TeaModel):
    def __init__(self, model_service_id=None):
        self.model_service_id = model_service_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeModelServiceRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.model_service_id is not None:
            result['ModelServiceId'] = self.model_service_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ModelServiceId') is not None:
            self.model_service_id = m.get('ModelServiceId')
        return self


class DescribeModelServiceResponseBodyDataModelApiList(TeaModel):
    def __init__(self, algorithm_api_code=None, api_id=None, api_name=None, api_path=None, create_time=None):
        self.algorithm_api_code = algorithm_api_code  # type: str
        self.api_id = api_id  # type: str
        self.api_name = api_name  # type: str
        self.api_path = api_path  # type: str
        self.create_time = create_time  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeModelServiceResponseBodyDataModelApiList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.algorithm_api_code is not None:
            result['AlgorithmApiCode'] = self.algorithm_api_code
        if self.api_id is not None:
            result['ApiId'] = self.api_id
        if self.api_name is not None:
            result['ApiName'] = self.api_name
        if self.api_path is not None:
            result['ApiPath'] = self.api_path
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AlgorithmApiCode') is not None:
            self.algorithm_api_code = m.get('AlgorithmApiCode')
        if m.get('ApiId') is not None:
            self.api_id = m.get('ApiId')
        if m.get('ApiName') is not None:
            self.api_name = m.get('ApiName')
        if m.get('ApiPath') is not None:
            self.api_path = m.get('ApiPath')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        return self


class DescribeModelServiceResponseBodyData(TeaModel):
    def __init__(self, algorithm_code=None, app_code=None, create_time=None, model_api_list=None,
                 model_service_instance_id=None, model_service_instance_name=None, model_service_status=None, qps=None):
        self.algorithm_code = algorithm_code  # type: str
        self.app_code = app_code  # type: str
        self.create_time = create_time  # type: str
        self.model_api_list = model_api_list  # type: list[DescribeModelServiceResponseBodyDataModelApiList]
        self.model_service_instance_id = model_service_instance_id  # type: str
        self.model_service_instance_name = model_service_instance_name  # type: str
        self.model_service_status = model_service_status  # type: str
        self.qps = qps  # type: long

    def validate(self):
        if self.model_api_list:
            for k in self.model_api_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeModelServiceResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.algorithm_code is not None:
            result['AlgorithmCode'] = self.algorithm_code
        if self.app_code is not None:
            result['AppCode'] = self.app_code
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        result['ModelApiList'] = []
        if self.model_api_list is not None:
            for k in self.model_api_list:
                result['ModelApiList'].append(k.to_map() if k else None)
        if self.model_service_instance_id is not None:
            result['ModelServiceInstanceId'] = self.model_service_instance_id
        if self.model_service_instance_name is not None:
            result['ModelServiceInstanceName'] = self.model_service_instance_name
        if self.model_service_status is not None:
            result['ModelServiceStatus'] = self.model_service_status
        if self.qps is not None:
            result['Qps'] = self.qps
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AlgorithmCode') is not None:
            self.algorithm_code = m.get('AlgorithmCode')
        if m.get('AppCode') is not None:
            self.app_code = m.get('AppCode')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        self.model_api_list = []
        if m.get('ModelApiList') is not None:
            for k in m.get('ModelApiList'):
                temp_model = DescribeModelServiceResponseBodyDataModelApiList()
                self.model_api_list.append(temp_model.from_map(k))
        if m.get('ModelServiceInstanceId') is not None:
            self.model_service_instance_id = m.get('ModelServiceInstanceId')
        if m.get('ModelServiceInstanceName') is not None:
            self.model_service_instance_name = m.get('ModelServiceInstanceName')
        if m.get('ModelServiceStatus') is not None:
            self.model_service_status = m.get('ModelServiceStatus')
        if m.get('Qps') is not None:
            self.qps = m.get('Qps')
        return self


class DescribeModelServiceResponseBody(TeaModel):
    def __init__(self, code=None, data=None, message=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: DescribeModelServiceResponseBodyData
        self.message = message  # type: str
        # Id of the request
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(DescribeModelServiceResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = DescribeModelServiceResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeModelServiceResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeModelServiceResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeModelServiceResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeModelServiceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeModelServiceListRequest(TeaModel):
    def __init__(self, algorithm_code=None, include_deleted=None, model_service_name=None, page_num=None,
                 page_size=None):
        self.algorithm_code = algorithm_code  # type: str
        self.include_deleted = include_deleted  # type: bool
        self.model_service_name = model_service_name  # type: str
        self.page_num = page_num  # type: int
        self.page_size = page_size  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeModelServiceListRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.algorithm_code is not None:
            result['AlgorithmCode'] = self.algorithm_code
        if self.include_deleted is not None:
            result['IncludeDeleted'] = self.include_deleted
        if self.model_service_name is not None:
            result['ModelServiceName'] = self.model_service_name
        if self.page_num is not None:
            result['PageNum'] = self.page_num
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AlgorithmCode') is not None:
            self.algorithm_code = m.get('AlgorithmCode')
        if m.get('IncludeDeleted') is not None:
            self.include_deleted = m.get('IncludeDeleted')
        if m.get('ModelServiceName') is not None:
            self.model_service_name = m.get('ModelServiceName')
        if m.get('PageNum') is not None:
            self.page_num = m.get('PageNum')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class DescribeModelServiceListResponseBodyDataModelList(TeaModel):
    def __init__(self, algorithm_code=None, app_code=None, create_time=None, model_service_instance_id=None,
                 model_service_name=None, model_service_status=None, qps_required=None):
        self.algorithm_code = algorithm_code  # type: str
        self.app_code = app_code  # type: str
        self.create_time = create_time  # type: str
        self.model_service_instance_id = model_service_instance_id  # type: str
        self.model_service_name = model_service_name  # type: str
        self.model_service_status = model_service_status  # type: str
        self.qps_required = qps_required  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeModelServiceListResponseBodyDataModelList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.algorithm_code is not None:
            result['AlgorithmCode'] = self.algorithm_code
        if self.app_code is not None:
            result['AppCode'] = self.app_code
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.model_service_instance_id is not None:
            result['ModelServiceInstanceId'] = self.model_service_instance_id
        if self.model_service_name is not None:
            result['ModelServiceName'] = self.model_service_name
        if self.model_service_status is not None:
            result['ModelServiceStatus'] = self.model_service_status
        if self.qps_required is not None:
            result['QpsRequired'] = self.qps_required
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AlgorithmCode') is not None:
            self.algorithm_code = m.get('AlgorithmCode')
        if m.get('AppCode') is not None:
            self.app_code = m.get('AppCode')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('ModelServiceInstanceId') is not None:
            self.model_service_instance_id = m.get('ModelServiceInstanceId')
        if m.get('ModelServiceName') is not None:
            self.model_service_name = m.get('ModelServiceName')
        if m.get('ModelServiceStatus') is not None:
            self.model_service_status = m.get('ModelServiceStatus')
        if m.get('QpsRequired') is not None:
            self.qps_required = m.get('QpsRequired')
        return self


class DescribeModelServiceListResponseBodyData(TeaModel):
    def __init__(self, model_list=None, total=None):
        self.model_list = model_list  # type: list[DescribeModelServiceListResponseBodyDataModelList]
        self.total = total  # type: str

    def validate(self):
        if self.model_list:
            for k in self.model_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeModelServiceListResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ModelList'] = []
        if self.model_list is not None:
            for k in self.model_list:
                result['ModelList'].append(k.to_map() if k else None)
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.model_list = []
        if m.get('ModelList') is not None:
            for k in m.get('ModelList'):
                temp_model = DescribeModelServiceListResponseBodyDataModelList()
                self.model_list.append(temp_model.from_map(k))
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class DescribeModelServiceListResponseBody(TeaModel):
    def __init__(self, code=None, data=None, message=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: DescribeModelServiceListResponseBodyData
        self.message = message  # type: str
        # Id of the request
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(DescribeModelServiceListResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = DescribeModelServiceListResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeModelServiceListResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeModelServiceListResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeModelServiceListResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeModelServiceListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeNvrDevicesRequest(TeaModel):
    def __init__(self, corp_id_list=None, device_filter=None, nvr_device_id_list=None, page_num=None,
                 page_size=None):
        self.corp_id_list = corp_id_list  # type: str
        self.device_filter = device_filter  # type: str
        self.nvr_device_id_list = nvr_device_id_list  # type: str
        self.page_num = page_num  # type: long
        self.page_size = page_size  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeNvrDevicesRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.corp_id_list is not None:
            result['CorpIdList'] = self.corp_id_list
        if self.device_filter is not None:
            result['DeviceFilter'] = self.device_filter
        if self.nvr_device_id_list is not None:
            result['NvrDeviceIdList'] = self.nvr_device_id_list
        if self.page_num is not None:
            result['PageNum'] = self.page_num
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CorpIdList') is not None:
            self.corp_id_list = m.get('CorpIdList')
        if m.get('DeviceFilter') is not None:
            self.device_filter = m.get('DeviceFilter')
        if m.get('NvrDeviceIdList') is not None:
            self.nvr_device_id_list = m.get('NvrDeviceIdList')
        if m.get('PageNum') is not None:
            self.page_num = m.get('PageNum')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class DescribeNvrDevicesResponseBodyDataRecords(TeaModel):
    def __init__(self, channel=None, corp_id=None, create_time=None, datasource_type=None, device_id=None,
                 device_model=None, device_name=None, device_sn=None, device_status=None, device_type=None, modify_time=None,
                 project_name=None, region_name=None):
        self.channel = channel  # type: str
        self.corp_id = corp_id  # type: str
        self.create_time = create_time  # type: str
        self.datasource_type = datasource_type  # type: str
        self.device_id = device_id  # type: str
        self.device_model = device_model  # type: str
        self.device_name = device_name  # type: str
        self.device_sn = device_sn  # type: str
        self.device_status = device_status  # type: str
        self.device_type = device_type  # type: str
        self.modify_time = modify_time  # type: str
        self.project_name = project_name  # type: str
        self.region_name = region_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeNvrDevicesResponseBodyDataRecords, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.channel is not None:
            result['Channel'] = self.channel
        if self.corp_id is not None:
            result['CorpId'] = self.corp_id
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.datasource_type is not None:
            result['DatasourceType'] = self.datasource_type
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.device_model is not None:
            result['DeviceModel'] = self.device_model
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.device_sn is not None:
            result['DeviceSn'] = self.device_sn
        if self.device_status is not None:
            result['DeviceStatus'] = self.device_status
        if self.device_type is not None:
            result['DeviceType'] = self.device_type
        if self.modify_time is not None:
            result['ModifyTime'] = self.modify_time
        if self.project_name is not None:
            result['ProjectName'] = self.project_name
        if self.region_name is not None:
            result['RegionName'] = self.region_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Channel') is not None:
            self.channel = m.get('Channel')
        if m.get('CorpId') is not None:
            self.corp_id = m.get('CorpId')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('DatasourceType') is not None:
            self.datasource_type = m.get('DatasourceType')
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('DeviceModel') is not None:
            self.device_model = m.get('DeviceModel')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('DeviceSn') is not None:
            self.device_sn = m.get('DeviceSn')
        if m.get('DeviceStatus') is not None:
            self.device_status = m.get('DeviceStatus')
        if m.get('DeviceType') is not None:
            self.device_type = m.get('DeviceType')
        if m.get('ModifyTime') is not None:
            self.modify_time = m.get('ModifyTime')
        if m.get('ProjectName') is not None:
            self.project_name = m.get('ProjectName')
        if m.get('RegionName') is not None:
            self.region_name = m.get('RegionName')
        return self


class DescribeNvrDevicesResponseBodyData(TeaModel):
    def __init__(self, page_num=None, page_size=None, records=None, total_count=None, total_page=None):
        self.page_num = page_num  # type: long
        self.page_size = page_size  # type: long
        self.records = records  # type: list[DescribeNvrDevicesResponseBodyDataRecords]
        self.total_count = total_count  # type: long
        self.total_page = total_page  # type: long

    def validate(self):
        if self.records:
            for k in self.records:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeNvrDevicesResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_num is not None:
            result['PageNum'] = self.page_num
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        result['Records'] = []
        if self.records is not None:
            for k in self.records:
                result['Records'].append(k.to_map() if k else None)
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.total_page is not None:
            result['TotalPage'] = self.total_page
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PageNum') is not None:
            self.page_num = m.get('PageNum')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        self.records = []
        if m.get('Records') is not None:
            for k in m.get('Records'):
                temp_model = DescribeNvrDevicesResponseBodyDataRecords()
                self.records.append(temp_model.from_map(k))
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('TotalPage') is not None:
            self.total_page = m.get('TotalPage')
        return self


class DescribeNvrDevicesResponseBody(TeaModel):
    def __init__(self, code=None, data=None, message=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: DescribeNvrDevicesResponseBodyData
        self.message = message  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(DescribeNvrDevicesResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = DescribeNvrDevicesResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeNvrDevicesResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeNvrDevicesResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeNvrDevicesResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeNvrDevicesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeNvrsRequest(TeaModel):
    def __init__(self, corp_id_list=None, device_filter=None, nvr_device_id_list=None, page_num=None,
                 page_size=None):
        self.corp_id_list = corp_id_list  # type: str
        self.device_filter = device_filter  # type: str
        self.nvr_device_id_list = nvr_device_id_list  # type: str
        self.page_num = page_num  # type: long
        self.page_size = page_size  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeNvrsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.corp_id_list is not None:
            result['CorpIdList'] = self.corp_id_list
        if self.device_filter is not None:
            result['DeviceFilter'] = self.device_filter
        if self.nvr_device_id_list is not None:
            result['NvrDeviceIdList'] = self.nvr_device_id_list
        if self.page_num is not None:
            result['PageNum'] = self.page_num
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CorpIdList') is not None:
            self.corp_id_list = m.get('CorpIdList')
        if m.get('DeviceFilter') is not None:
            self.device_filter = m.get('DeviceFilter')
        if m.get('NvrDeviceIdList') is not None:
            self.nvr_device_id_list = m.get('NvrDeviceIdList')
        if m.get('PageNum') is not None:
            self.page_num = m.get('PageNum')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class DescribeNvrsResponseBodyDataRecordsSubDeviceInfo(TeaModel):
    def __init__(self, sub_device_id=None):
        self.sub_device_id = sub_device_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeNvrsResponseBodyDataRecordsSubDeviceInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.sub_device_id is not None:
            result['SubDeviceId'] = self.sub_device_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('SubDeviceId') is not None:
            self.sub_device_id = m.get('SubDeviceId')
        return self


class DescribeNvrsResponseBodyDataRecords(TeaModel):
    def __init__(self, corp_id=None, create_time=None, datasource_type=None, device_address=None, device_id=None,
                 device_model=None, device_name=None, device_sn=None, device_status=None, device_type=None, in_protocol=None,
                 latitude=None, longitude=None, modify_time=None, password=None, server_id=None, server_ip=None,
                 server_port=None, server_realm=None, sub_device_count=None, sub_device_info=None, vendor=None):
        self.corp_id = corp_id  # type: str
        self.create_time = create_time  # type: str
        self.datasource_type = datasource_type  # type: str
        self.device_address = device_address  # type: str
        self.device_id = device_id  # type: str
        self.device_model = device_model  # type: str
        self.device_name = device_name  # type: str
        self.device_sn = device_sn  # type: str
        self.device_status = device_status  # type: str
        self.device_type = device_type  # type: str
        self.in_protocol = in_protocol  # type: str
        self.latitude = latitude  # type: str
        self.longitude = longitude  # type: str
        self.modify_time = modify_time  # type: str
        self.password = password  # type: str
        self.server_id = server_id  # type: str
        self.server_ip = server_ip  # type: str
        self.server_port = server_port  # type: str
        self.server_realm = server_realm  # type: str
        self.sub_device_count = sub_device_count  # type: str
        self.sub_device_info = sub_device_info  # type: list[DescribeNvrsResponseBodyDataRecordsSubDeviceInfo]
        self.vendor = vendor  # type: str

    def validate(self):
        if self.sub_device_info:
            for k in self.sub_device_info:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeNvrsResponseBodyDataRecords, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.corp_id is not None:
            result['CorpId'] = self.corp_id
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.datasource_type is not None:
            result['DatasourceType'] = self.datasource_type
        if self.device_address is not None:
            result['DeviceAddress'] = self.device_address
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.device_model is not None:
            result['DeviceModel'] = self.device_model
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.device_sn is not None:
            result['DeviceSn'] = self.device_sn
        if self.device_status is not None:
            result['DeviceStatus'] = self.device_status
        if self.device_type is not None:
            result['DeviceType'] = self.device_type
        if self.in_protocol is not None:
            result['InProtocol'] = self.in_protocol
        if self.latitude is not None:
            result['Latitude'] = self.latitude
        if self.longitude is not None:
            result['Longitude'] = self.longitude
        if self.modify_time is not None:
            result['ModifyTime'] = self.modify_time
        if self.password is not None:
            result['Password'] = self.password
        if self.server_id is not None:
            result['ServerId'] = self.server_id
        if self.server_ip is not None:
            result['ServerIp'] = self.server_ip
        if self.server_port is not None:
            result['ServerPort'] = self.server_port
        if self.server_realm is not None:
            result['ServerRealm'] = self.server_realm
        if self.sub_device_count is not None:
            result['SubDeviceCount'] = self.sub_device_count
        result['SubDeviceInfo'] = []
        if self.sub_device_info is not None:
            for k in self.sub_device_info:
                result['SubDeviceInfo'].append(k.to_map() if k else None)
        if self.vendor is not None:
            result['Vendor'] = self.vendor
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CorpId') is not None:
            self.corp_id = m.get('CorpId')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('DatasourceType') is not None:
            self.datasource_type = m.get('DatasourceType')
        if m.get('DeviceAddress') is not None:
            self.device_address = m.get('DeviceAddress')
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('DeviceModel') is not None:
            self.device_model = m.get('DeviceModel')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('DeviceSn') is not None:
            self.device_sn = m.get('DeviceSn')
        if m.get('DeviceStatus') is not None:
            self.device_status = m.get('DeviceStatus')
        if m.get('DeviceType') is not None:
            self.device_type = m.get('DeviceType')
        if m.get('InProtocol') is not None:
            self.in_protocol = m.get('InProtocol')
        if m.get('Latitude') is not None:
            self.latitude = m.get('Latitude')
        if m.get('Longitude') is not None:
            self.longitude = m.get('Longitude')
        if m.get('ModifyTime') is not None:
            self.modify_time = m.get('ModifyTime')
        if m.get('Password') is not None:
            self.password = m.get('Password')
        if m.get('ServerId') is not None:
            self.server_id = m.get('ServerId')
        if m.get('ServerIp') is not None:
            self.server_ip = m.get('ServerIp')
        if m.get('ServerPort') is not None:
            self.server_port = m.get('ServerPort')
        if m.get('ServerRealm') is not None:
            self.server_realm = m.get('ServerRealm')
        if m.get('SubDeviceCount') is not None:
            self.sub_device_count = m.get('SubDeviceCount')
        self.sub_device_info = []
        if m.get('SubDeviceInfo') is not None:
            for k in m.get('SubDeviceInfo'):
                temp_model = DescribeNvrsResponseBodyDataRecordsSubDeviceInfo()
                self.sub_device_info.append(temp_model.from_map(k))
        if m.get('Vendor') is not None:
            self.vendor = m.get('Vendor')
        return self


class DescribeNvrsResponseBodyData(TeaModel):
    def __init__(self, page_num=None, page_size=None, records=None, total_count=None, total_page=None):
        self.page_num = page_num  # type: long
        self.page_size = page_size  # type: long
        self.records = records  # type: list[DescribeNvrsResponseBodyDataRecords]
        self.total_count = total_count  # type: long
        self.total_page = total_page  # type: long

    def validate(self):
        if self.records:
            for k in self.records:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeNvrsResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_num is not None:
            result['PageNum'] = self.page_num
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        result['Records'] = []
        if self.records is not None:
            for k in self.records:
                result['Records'].append(k.to_map() if k else None)
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.total_page is not None:
            result['TotalPage'] = self.total_page
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PageNum') is not None:
            self.page_num = m.get('PageNum')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        self.records = []
        if m.get('Records') is not None:
            for k in m.get('Records'):
                temp_model = DescribeNvrsResponseBodyDataRecords()
                self.records.append(temp_model.from_map(k))
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('TotalPage') is not None:
            self.total_page = m.get('TotalPage')
        return self


class DescribeNvrsResponseBody(TeaModel):
    def __init__(self, code=None, data=None, message=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: DescribeNvrsResponseBodyData
        self.message = message  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(DescribeNvrsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = DescribeNvrsResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeNvrsResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeNvrsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeNvrsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeNvrsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeSearchItemsRequest(TeaModel):
    def __init__(self, page_number=None, page_size=None, search_item_ids=None, search_table_id=None):
        self.page_number = page_number  # type: str
        self.page_size = page_size  # type: str
        self.search_item_ids = search_item_ids  # type: str
        self.search_table_id = search_table_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeSearchItemsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.search_item_ids is not None:
            result['SearchItemIds'] = self.search_item_ids
        if self.search_table_id is not None:
            result['SearchTableId'] = self.search_table_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('SearchItemIds') is not None:
            self.search_item_ids = m.get('SearchItemIds')
        if m.get('SearchTableId') is not None:
            self.search_table_id = m.get('SearchTableId')
        return self


class DescribeSearchItemsResponseBodyDataRecords(TeaModel):
    def __init__(self, item_image_url=None, search_item_id=None, search_item_name=None):
        self.item_image_url = item_image_url  # type: str
        self.search_item_id = search_item_id  # type: str
        self.search_item_name = search_item_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeSearchItemsResponseBodyDataRecords, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.item_image_url is not None:
            result['ItemImageUrl'] = self.item_image_url
        if self.search_item_id is not None:
            result['SearchItemId'] = self.search_item_id
        if self.search_item_name is not None:
            result['SearchItemName'] = self.search_item_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ItemImageUrl') is not None:
            self.item_image_url = m.get('ItemImageUrl')
        if m.get('SearchItemId') is not None:
            self.search_item_id = m.get('SearchItemId')
        if m.get('SearchItemName') is not None:
            self.search_item_name = m.get('SearchItemName')
        return self


class DescribeSearchItemsResponseBodyData(TeaModel):
    def __init__(self, page_number=None, page_size=None, records=None, total_count=None):
        self.page_number = page_number  # type: str
        self.page_size = page_size  # type: str
        self.records = records  # type: list[DescribeSearchItemsResponseBodyDataRecords]
        self.total_count = total_count  # type: str

    def validate(self):
        if self.records:
            for k in self.records:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeSearchItemsResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        result['Records'] = []
        if self.records is not None:
            for k in self.records:
                result['Records'].append(k.to_map() if k else None)
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        self.records = []
        if m.get('Records') is not None:
            for k in m.get('Records'):
                temp_model = DescribeSearchItemsResponseBodyDataRecords()
                self.records.append(temp_model.from_map(k))
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeSearchItemsResponseBody(TeaModel):
    def __init__(self, code=None, data=None, message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data = data  # type: DescribeSearchItemsResponseBodyData
        self.message = message  # type: str
        # Id of the request
        self.request_id = request_id  # type: str
        self.success = success  # type: str

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(DescribeSearchItemsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = DescribeSearchItemsResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DescribeSearchItemsResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeSearchItemsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeSearchItemsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeSearchItemsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeSearchTablesRequest(TeaModel):
    def __init__(self, page_number=None, page_size=None, search_table_ids=None):
        self.page_number = page_number  # type: long
        self.page_size = page_size  # type: long
        self.search_table_ids = search_table_ids  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeSearchTablesRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.search_table_ids is not None:
            result['SearchTableIds'] = self.search_table_ids
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('SearchTableIds') is not None:
            self.search_table_ids = m.get('SearchTableIds')
        return self


class DescribeSearchTablesResponseBodyDataRecords(TeaModel):
    def __init__(self, algorithm_id=None, search_table_id=None, search_table_name=None, target_type=None):
        self.algorithm_id = algorithm_id  # type: str
        self.search_table_id = search_table_id  # type: str
        self.search_table_name = search_table_name  # type: str
        self.target_type = target_type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeSearchTablesResponseBodyDataRecords, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.algorithm_id is not None:
            result['AlgorithmId'] = self.algorithm_id
        if self.search_table_id is not None:
            result['SearchTableId'] = self.search_table_id
        if self.search_table_name is not None:
            result['SearchTableName'] = self.search_table_name
        if self.target_type is not None:
            result['TargetType'] = self.target_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AlgorithmId') is not None:
            self.algorithm_id = m.get('AlgorithmId')
        if m.get('SearchTableId') is not None:
            self.search_table_id = m.get('SearchTableId')
        if m.get('SearchTableName') is not None:
            self.search_table_name = m.get('SearchTableName')
        if m.get('TargetType') is not None:
            self.target_type = m.get('TargetType')
        return self


class DescribeSearchTablesResponseBodyData(TeaModel):
    def __init__(self, page_numbei=None, page_size=None, records=None, total_count=None):
        self.page_numbei = page_numbei  # type: long
        self.page_size = page_size  # type: long
        self.records = records  # type: list[DescribeSearchTablesResponseBodyDataRecords]
        self.total_count = total_count  # type: long

    def validate(self):
        if self.records:
            for k in self.records:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeSearchTablesResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_numbei is not None:
            result['PageNumbei'] = self.page_numbei
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        result['Records'] = []
        if self.records is not None:
            for k in self.records:
                result['Records'].append(k.to_map() if k else None)
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PageNumbei') is not None:
            self.page_numbei = m.get('PageNumbei')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        self.records = []
        if m.get('Records') is not None:
            for k in m.get('Records'):
                temp_model = DescribeSearchTablesResponseBodyDataRecords()
                self.records.append(temp_model.from_map(k))
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeSearchTablesResponseBody(TeaModel):
    def __init__(self, code=None, data=None, message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data = data  # type: DescribeSearchTablesResponseBodyData
        self.message = message  # type: str
        # Id of the request
        self.request_id = request_id  # type: str
        self.success = success  # type: str

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(DescribeSearchTablesResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = DescribeSearchTablesResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DescribeSearchTablesResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeSearchTablesResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeSearchTablesResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeSearchTablesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeWatchItemsRequest(TeaModel):
    def __init__(self, page_number=None, page_size=None, watch_item_ids=None, watch_policy_id=None):
        self.page_number = page_number  # type: long
        self.page_size = page_size  # type: long
        self.watch_item_ids = watch_item_ids  # type: str
        self.watch_policy_id = watch_policy_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeWatchItemsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.watch_item_ids is not None:
            result['WatchItemIds'] = self.watch_item_ids
        if self.watch_policy_id is not None:
            result['WatchPolicyId'] = self.watch_policy_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('WatchItemIds') is not None:
            self.watch_item_ids = m.get('WatchItemIds')
        if m.get('WatchPolicyId') is not None:
            self.watch_policy_id = m.get('WatchPolicyId')
        return self


class DescribeWatchItemsResponseBodyDataRecords(TeaModel):
    def __init__(self, item_attributes=None, item_image_url=None, watch_item_id=None, watch_item_name=None):
        self.item_attributes = item_attributes  # type: str
        self.item_image_url = item_image_url  # type: str
        self.watch_item_id = watch_item_id  # type: str
        self.watch_item_name = watch_item_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeWatchItemsResponseBodyDataRecords, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.item_attributes is not None:
            result['ItemAttributes'] = self.item_attributes
        if self.item_image_url is not None:
            result['ItemImageUrl'] = self.item_image_url
        if self.watch_item_id is not None:
            result['WatchItemId'] = self.watch_item_id
        if self.watch_item_name is not None:
            result['WatchItemName'] = self.watch_item_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ItemAttributes') is not None:
            self.item_attributes = m.get('ItemAttributes')
        if m.get('ItemImageUrl') is not None:
            self.item_image_url = m.get('ItemImageUrl')
        if m.get('WatchItemId') is not None:
            self.watch_item_id = m.get('WatchItemId')
        if m.get('WatchItemName') is not None:
            self.watch_item_name = m.get('WatchItemName')
        return self


class DescribeWatchItemsResponseBodyData(TeaModel):
    def __init__(self, page_number=None, page_size=None, records=None, total_count=None):
        self.page_number = page_number  # type: long
        self.page_size = page_size  # type: long
        self.records = records  # type: list[DescribeWatchItemsResponseBodyDataRecords]
        self.total_count = total_count  # type: long

    def validate(self):
        if self.records:
            for k in self.records:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeWatchItemsResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        result['Records'] = []
        if self.records is not None:
            for k in self.records:
                result['Records'].append(k.to_map() if k else None)
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        self.records = []
        if m.get('Records') is not None:
            for k in m.get('Records'):
                temp_model = DescribeWatchItemsResponseBodyDataRecords()
                self.records.append(temp_model.from_map(k))
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeWatchItemsResponseBody(TeaModel):
    def __init__(self, code=None, data=None, message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data = data  # type: DescribeWatchItemsResponseBodyData
        self.message = message  # type: str
        # Id of the request
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(DescribeWatchItemsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = DescribeWatchItemsResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DescribeWatchItemsResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeWatchItemsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeWatchItemsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeWatchItemsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeWatchPoliciesRequest(TeaModel):
    def __init__(self, page_number=None, page_size=None, watch_policy_ids=None):
        self.page_number = page_number  # type: long
        self.page_size = page_size  # type: long
        self.watch_policy_ids = watch_policy_ids  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeWatchPoliciesRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.watch_policy_ids is not None:
            result['WatchPolicyIds'] = self.watch_policy_ids
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('WatchPolicyIds') is not None:
            self.watch_policy_ids = m.get('WatchPolicyIds')
        return self


class DescribeWatchPoliciesResponseBodyDataRecords(TeaModel):
    def __init__(self, item_match_type=None, similarity_threshold=None, target_type=None, watch_mode=None,
                 watch_policy_id=None, watch_policy_name=None):
        self.item_match_type = item_match_type  # type: str
        self.similarity_threshold = similarity_threshold  # type: float
        self.target_type = target_type  # type: str
        self.watch_mode = watch_mode  # type: str
        self.watch_policy_id = watch_policy_id  # type: str
        self.watch_policy_name = watch_policy_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeWatchPoliciesResponseBodyDataRecords, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.item_match_type is not None:
            result['ItemMatchType'] = self.item_match_type
        if self.similarity_threshold is not None:
            result['SimilarityThreshold'] = self.similarity_threshold
        if self.target_type is not None:
            result['TargetType'] = self.target_type
        if self.watch_mode is not None:
            result['WatchMode'] = self.watch_mode
        if self.watch_policy_id is not None:
            result['WatchPolicyId'] = self.watch_policy_id
        if self.watch_policy_name is not None:
            result['WatchPolicyName'] = self.watch_policy_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ItemMatchType') is not None:
            self.item_match_type = m.get('ItemMatchType')
        if m.get('SimilarityThreshold') is not None:
            self.similarity_threshold = m.get('SimilarityThreshold')
        if m.get('TargetType') is not None:
            self.target_type = m.get('TargetType')
        if m.get('WatchMode') is not None:
            self.watch_mode = m.get('WatchMode')
        if m.get('WatchPolicyId') is not None:
            self.watch_policy_id = m.get('WatchPolicyId')
        if m.get('WatchPolicyName') is not None:
            self.watch_policy_name = m.get('WatchPolicyName')
        return self


class DescribeWatchPoliciesResponseBodyData(TeaModel):
    def __init__(self, page_number=None, page_size=None, records=None, total_count=None):
        self.page_number = page_number  # type: long
        self.page_size = page_size  # type: long
        self.records = records  # type: list[DescribeWatchPoliciesResponseBodyDataRecords]
        self.total_count = total_count  # type: long

    def validate(self):
        if self.records:
            for k in self.records:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeWatchPoliciesResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        result['Records'] = []
        if self.records is not None:
            for k in self.records:
                result['Records'].append(k.to_map() if k else None)
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        self.records = []
        if m.get('Records') is not None:
            for k in m.get('Records'):
                temp_model = DescribeWatchPoliciesResponseBodyDataRecords()
                self.records.append(temp_model.from_map(k))
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeWatchPoliciesResponseBody(TeaModel):
    def __init__(self, code=None, data=None, message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data = data  # type: DescribeWatchPoliciesResponseBodyData
        self.message = message  # type: str
        # Id of the request
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(DescribeWatchPoliciesResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = DescribeWatchPoliciesResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DescribeWatchPoliciesResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeWatchPoliciesResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeWatchPoliciesResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeWatchPoliciesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeWatchTasksRequest(TeaModel):
    def __init__(self, page_number=None, page_size=None, watch_task_ids=None):
        self.page_number = page_number  # type: long
        self.page_size = page_size  # type: long
        self.watch_task_ids = watch_task_ids  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeWatchTasksRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.watch_task_ids is not None:
            result['WatchTaskIds'] = self.watch_task_ids
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('WatchTaskIds') is not None:
            self.watch_task_ids = m.get('WatchTaskIds')
        return self


class DescribeWatchTasksResponseBodyDataRecords(TeaModel):
    def __init__(self, corp_id=None, description=None, device_list=None, message_receiver=None,
                 schedule_cycle_dates=None, schedule_times=None, schedule_type=None, task_name=None, watch_policy_ids=None,
                 watch_task_id=None):
        self.corp_id = corp_id  # type: str
        self.description = description  # type: str
        self.device_list = device_list  # type: str
        self.message_receiver = message_receiver  # type: str
        self.schedule_cycle_dates = schedule_cycle_dates  # type: str
        self.schedule_times = schedule_times  # type: str
        self.schedule_type = schedule_type  # type: str
        self.task_name = task_name  # type: str
        self.watch_policy_ids = watch_policy_ids  # type: str
        self.watch_task_id = watch_task_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeWatchTasksResponseBodyDataRecords, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.corp_id is not None:
            result['CorpId'] = self.corp_id
        if self.description is not None:
            result['Description'] = self.description
        if self.device_list is not None:
            result['DeviceList'] = self.device_list
        if self.message_receiver is not None:
            result['MessageReceiver'] = self.message_receiver
        if self.schedule_cycle_dates is not None:
            result['ScheduleCycleDates'] = self.schedule_cycle_dates
        if self.schedule_times is not None:
            result['ScheduleTimes'] = self.schedule_times
        if self.schedule_type is not None:
            result['ScheduleType'] = self.schedule_type
        if self.task_name is not None:
            result['TaskName'] = self.task_name
        if self.watch_policy_ids is not None:
            result['WatchPolicyIds'] = self.watch_policy_ids
        if self.watch_task_id is not None:
            result['WatchTaskId'] = self.watch_task_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CorpId') is not None:
            self.corp_id = m.get('CorpId')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('DeviceList') is not None:
            self.device_list = m.get('DeviceList')
        if m.get('MessageReceiver') is not None:
            self.message_receiver = m.get('MessageReceiver')
        if m.get('ScheduleCycleDates') is not None:
            self.schedule_cycle_dates = m.get('ScheduleCycleDates')
        if m.get('ScheduleTimes') is not None:
            self.schedule_times = m.get('ScheduleTimes')
        if m.get('ScheduleType') is not None:
            self.schedule_type = m.get('ScheduleType')
        if m.get('TaskName') is not None:
            self.task_name = m.get('TaskName')
        if m.get('WatchPolicyIds') is not None:
            self.watch_policy_ids = m.get('WatchPolicyIds')
        if m.get('WatchTaskId') is not None:
            self.watch_task_id = m.get('WatchTaskId')
        return self


class DescribeWatchTasksResponseBodyData(TeaModel):
    def __init__(self, page_number=None, page_size=None, records=None, total_count=None):
        self.page_number = page_number  # type: long
        self.page_size = page_size  # type: long
        self.records = records  # type: list[DescribeWatchTasksResponseBodyDataRecords]
        self.total_count = total_count  # type: long

    def validate(self):
        if self.records:
            for k in self.records:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeWatchTasksResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        result['Records'] = []
        if self.records is not None:
            for k in self.records:
                result['Records'].append(k.to_map() if k else None)
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        self.records = []
        if m.get('Records') is not None:
            for k in m.get('Records'):
                temp_model = DescribeWatchTasksResponseBodyDataRecords()
                self.records.append(temp_model.from_map(k))
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeWatchTasksResponseBody(TeaModel):
    def __init__(self, code=None, data=None, message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data = data  # type: DescribeWatchTasksResponseBodyData
        self.message = message  # type: str
        # Id of the request
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(DescribeWatchTasksResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = DescribeWatchTasksResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DescribeWatchTasksResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeWatchTasksResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeWatchTasksResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeWatchTasksResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribesDoubleVerificationGroupsRequest(TeaModel):
    def __init__(self, double_verification_group_ids=None, id=None, page_num=None, page_size=None):
        self.double_verification_group_ids = double_verification_group_ids  # type: str
        self.id = id  # type: str
        self.page_num = page_num  # type: long
        self.page_size = page_size  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribesDoubleVerificationGroupsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.double_verification_group_ids is not None:
            result['DoubleVerificationGroupIds'] = self.double_verification_group_ids
        if self.id is not None:
            result['Id'] = self.id
        if self.page_num is not None:
            result['PageNum'] = self.page_num
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DoubleVerificationGroupIds') is not None:
            self.double_verification_group_ids = m.get('DoubleVerificationGroupIds')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('PageNum') is not None:
            self.page_num = m.get('PageNum')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class DescribesDoubleVerificationGroupsResponseBodyDoubleVerificationGroupsDoubleVerificationGroupListPersonIdList(TeaModel):
    def __init__(self, person_id=None, person_table_id=None):
        self.person_id = person_id  # type: str
        self.person_table_id = person_table_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribesDoubleVerificationGroupsResponseBodyDoubleVerificationGroupsDoubleVerificationGroupListPersonIdList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.person_id is not None:
            result['PersonId'] = self.person_id
        if self.person_table_id is not None:
            result['PersonTableId'] = self.person_table_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PersonId') is not None:
            self.person_id = m.get('PersonId')
        if m.get('PersonTableId') is not None:
            self.person_table_id = m.get('PersonTableId')
        return self


class DescribesDoubleVerificationGroupsResponseBodyDoubleVerificationGroupsDoubleVerificationGroupList(TeaModel):
    def __init__(self, device_id=None, enabled=None, group_id=None, interval=None, last_change=None,
                 member_number=None, person_id_list=None):
        self.device_id = device_id  # type: str
        self.enabled = enabled  # type: str
        self.group_id = group_id  # type: str
        self.interval = interval  # type: long
        self.last_change = last_change  # type: str
        self.member_number = member_number  # type: long
        self.person_id_list = person_id_list  # type: list[DescribesDoubleVerificationGroupsResponseBodyDoubleVerificationGroupsDoubleVerificationGroupListPersonIdList]

    def validate(self):
        if self.person_id_list:
            for k in self.person_id_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribesDoubleVerificationGroupsResponseBodyDoubleVerificationGroupsDoubleVerificationGroupList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.enabled is not None:
            result['Enabled'] = self.enabled
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.interval is not None:
            result['Interval'] = self.interval
        if self.last_change is not None:
            result['LastChange'] = self.last_change
        if self.member_number is not None:
            result['MemberNumber'] = self.member_number
        result['PersonIdList'] = []
        if self.person_id_list is not None:
            for k in self.person_id_list:
                result['PersonIdList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('Enabled') is not None:
            self.enabled = m.get('Enabled')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('Interval') is not None:
            self.interval = m.get('Interval')
        if m.get('LastChange') is not None:
            self.last_change = m.get('LastChange')
        if m.get('MemberNumber') is not None:
            self.member_number = m.get('MemberNumber')
        self.person_id_list = []
        if m.get('PersonIdList') is not None:
            for k in m.get('PersonIdList'):
                temp_model = DescribesDoubleVerificationGroupsResponseBodyDoubleVerificationGroupsDoubleVerificationGroupListPersonIdList()
                self.person_id_list.append(temp_model.from_map(k))
        return self


class DescribesDoubleVerificationGroupsResponseBodyDoubleVerificationGroups(TeaModel):
    def __init__(self, double_verification_group_list=None, page_num=None, page_size=None, total_num=None):
        self.double_verification_group_list = double_verification_group_list  # type: list[DescribesDoubleVerificationGroupsResponseBodyDoubleVerificationGroupsDoubleVerificationGroupList]
        self.page_num = page_num  # type: long
        self.page_size = page_size  # type: long
        self.total_num = total_num  # type: long

    def validate(self):
        if self.double_verification_group_list:
            for k in self.double_verification_group_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribesDoubleVerificationGroupsResponseBodyDoubleVerificationGroups, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DoubleVerificationGroupList'] = []
        if self.double_verification_group_list is not None:
            for k in self.double_verification_group_list:
                result['DoubleVerificationGroupList'].append(k.to_map() if k else None)
        if self.page_num is not None:
            result['PageNum'] = self.page_num
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_num is not None:
            result['TotalNum'] = self.total_num
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.double_verification_group_list = []
        if m.get('DoubleVerificationGroupList') is not None:
            for k in m.get('DoubleVerificationGroupList'):
                temp_model = DescribesDoubleVerificationGroupsResponseBodyDoubleVerificationGroupsDoubleVerificationGroupList()
                self.double_verification_group_list.append(temp_model.from_map(k))
        if m.get('PageNum') is not None:
            self.page_num = m.get('PageNum')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalNum') is not None:
            self.total_num = m.get('TotalNum')
        return self


class DescribesDoubleVerificationGroupsResponseBody(TeaModel):
    def __init__(self, code=None, double_verification_groups=None, message=None, request_id=None):
        self.code = code  # type: str
        self.double_verification_groups = double_verification_groups  # type: DescribesDoubleVerificationGroupsResponseBodyDoubleVerificationGroups
        self.message = message  # type: str
        # Id of the request
        self.request_id = request_id  # type: str

    def validate(self):
        if self.double_verification_groups:
            self.double_verification_groups.validate()

    def to_map(self):
        _map = super(DescribesDoubleVerificationGroupsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.double_verification_groups is not None:
            result['DoubleVerificationGroups'] = self.double_verification_groups.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('DoubleVerificationGroups') is not None:
            temp_model = DescribesDoubleVerificationGroupsResponseBodyDoubleVerificationGroups()
            self.double_verification_groups = temp_model.from_map(m['DoubleVerificationGroups'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribesDoubleVerificationGroupsResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribesDoubleVerificationGroupsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribesDoubleVerificationGroupsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribesDoubleVerificationGroupsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class EchoStatusResponseBody(TeaModel):
    def __init__(self, request_id=None):
        # Id of the request
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(EchoStatusResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class EchoStatusResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: EchoStatusResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(EchoStatusResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = EchoStatusResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetAiotStorageInfoResponseBodyAiotStorageInfoEventAlarmMq(TeaModel):
    def __init__(self, alarm_topic=None, event_topic=None, instance_id=None, mq_type=None, ram_arn_role=None,
                 region_id=None):
        self.alarm_topic = alarm_topic  # type: str
        self.event_topic = event_topic  # type: str
        self.instance_id = instance_id  # type: str
        self.mq_type = mq_type  # type: str
        self.ram_arn_role = ram_arn_role  # type: str
        self.region_id = region_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetAiotStorageInfoResponseBodyAiotStorageInfoEventAlarmMq, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alarm_topic is not None:
            result['AlarmTopic'] = self.alarm_topic
        if self.event_topic is not None:
            result['EventTopic'] = self.event_topic
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.mq_type is not None:
            result['MqType'] = self.mq_type
        if self.ram_arn_role is not None:
            result['RamArnRole'] = self.ram_arn_role
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AlarmTopic') is not None:
            self.alarm_topic = m.get('AlarmTopic')
        if m.get('EventTopic') is not None:
            self.event_topic = m.get('EventTopic')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('MqType') is not None:
            self.mq_type = m.get('MqType')
        if m.get('RamArnRole') is not None:
            self.ram_arn_role = m.get('RamArnRole')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class GetAiotStorageInfoResponseBodyAiotStorageInfoEventAlarmPictureStorage(TeaModel):
    def __init__(self, bucket=None, endpoint=None, path=None, proxy=None, ram_arn_role=None, storage_type=None):
        self.bucket = bucket  # type: str
        self.endpoint = endpoint  # type: str
        self.path = path  # type: str
        self.proxy = proxy  # type: str
        self.ram_arn_role = ram_arn_role  # type: str
        self.storage_type = storage_type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetAiotStorageInfoResponseBodyAiotStorageInfoEventAlarmPictureStorage, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bucket is not None:
            result['Bucket'] = self.bucket
        if self.endpoint is not None:
            result['Endpoint'] = self.endpoint
        if self.path is not None:
            result['Path'] = self.path
        if self.proxy is not None:
            result['Proxy'] = self.proxy
        if self.ram_arn_role is not None:
            result['RamArnRole'] = self.ram_arn_role
        if self.storage_type is not None:
            result['StorageType'] = self.storage_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Bucket') is not None:
            self.bucket = m.get('Bucket')
        if m.get('Endpoint') is not None:
            self.endpoint = m.get('Endpoint')
        if m.get('Path') is not None:
            self.path = m.get('Path')
        if m.get('Proxy') is not None:
            self.proxy = m.get('Proxy')
        if m.get('RamArnRole') is not None:
            self.ram_arn_role = m.get('RamArnRole')
        if m.get('StorageType') is not None:
            self.storage_type = m.get('StorageType')
        return self


class GetAiotStorageInfoResponseBodyAiotStorageInfo(TeaModel):
    def __init__(self, event_alarm_mq=None, event_alarm_picture_storage=None):
        self.event_alarm_mq = event_alarm_mq  # type: GetAiotStorageInfoResponseBodyAiotStorageInfoEventAlarmMq
        self.event_alarm_picture_storage = event_alarm_picture_storage  # type: GetAiotStorageInfoResponseBodyAiotStorageInfoEventAlarmPictureStorage

    def validate(self):
        if self.event_alarm_mq:
            self.event_alarm_mq.validate()
        if self.event_alarm_picture_storage:
            self.event_alarm_picture_storage.validate()

    def to_map(self):
        _map = super(GetAiotStorageInfoResponseBodyAiotStorageInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.event_alarm_mq is not None:
            result['EventAlarmMq'] = self.event_alarm_mq.to_map()
        if self.event_alarm_picture_storage is not None:
            result['EventAlarmPictureStorage'] = self.event_alarm_picture_storage.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('EventAlarmMq') is not None:
            temp_model = GetAiotStorageInfoResponseBodyAiotStorageInfoEventAlarmMq()
            self.event_alarm_mq = temp_model.from_map(m['EventAlarmMq'])
        if m.get('EventAlarmPictureStorage') is not None:
            temp_model = GetAiotStorageInfoResponseBodyAiotStorageInfoEventAlarmPictureStorage()
            self.event_alarm_picture_storage = temp_model.from_map(m['EventAlarmPictureStorage'])
        return self


class GetAiotStorageInfoResponseBody(TeaModel):
    def __init__(self, aiot_storage_info=None, code=None, message=None, request_id=None):
        self.aiot_storage_info = aiot_storage_info  # type: GetAiotStorageInfoResponseBodyAiotStorageInfo
        self.code = code  # type: str
        self.message = message  # type: str
        # Id of the request
        self.request_id = request_id  # type: str

    def validate(self):
        if self.aiot_storage_info:
            self.aiot_storage_info.validate()

    def to_map(self):
        _map = super(GetAiotStorageInfoResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.aiot_storage_info is not None:
            result['AiotStorageInfo'] = self.aiot_storage_info.to_map()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AiotStorageInfo') is not None:
            temp_model = GetAiotStorageInfoResponseBodyAiotStorageInfo()
            self.aiot_storage_info = temp_model.from_map(m['AiotStorageInfo'])
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetAiotStorageInfoResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetAiotStorageInfoResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetAiotStorageInfoResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetAiotStorageInfoResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetBodyOptionsRequest(TeaModel):
    def __init__(self, corp_id=None):
        self.corp_id = corp_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetBodyOptionsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.corp_id is not None:
            result['CorpId'] = self.corp_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CorpId') is not None:
            self.corp_id = m.get('CorpId')
        return self


class GetBodyOptionsResponseBodyDataOptionList(TeaModel):
    def __init__(self, key=None, name=None):
        self.key = key  # type: str
        self.name = name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetBodyOptionsResponseBodyDataOptionList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.name is not None:
            result['Name'] = self.name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        return self


class GetBodyOptionsResponseBodyData(TeaModel):
    def __init__(self, key=None, name=None, option_list=None):
        self.key = key  # type: str
        self.name = name  # type: str
        self.option_list = option_list  # type: list[GetBodyOptionsResponseBodyDataOptionList]

    def validate(self):
        if self.option_list:
            for k in self.option_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(GetBodyOptionsResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.name is not None:
            result['Name'] = self.name
        result['OptionList'] = []
        if self.option_list is not None:
            for k in self.option_list:
                result['OptionList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        self.option_list = []
        if m.get('OptionList') is not None:
            for k in m.get('OptionList'):
                temp_model = GetBodyOptionsResponseBodyDataOptionList()
                self.option_list.append(temp_model.from_map(k))
        return self


class GetBodyOptionsResponseBody(TeaModel):
    def __init__(self, code=None, data=None, message=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: list[GetBodyOptionsResponseBodyData]
        self.message = message  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(GetBodyOptionsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = GetBodyOptionsResponseBodyData()
                self.data.append(temp_model.from_map(k))
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetBodyOptionsResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetBodyOptionsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetBodyOptionsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetBodyOptionsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetCatalogListRequest(TeaModel):
    def __init__(self, corp_id=None, isv_sub_id=None):
        self.corp_id = corp_id  # type: str
        self.isv_sub_id = isv_sub_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetCatalogListRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.corp_id is not None:
            result['CorpId'] = self.corp_id
        if self.isv_sub_id is not None:
            result['IsvSubId'] = self.isv_sub_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CorpId') is not None:
            self.corp_id = m.get('CorpId')
        if m.get('IsvSubId') is not None:
            self.isv_sub_id = m.get('IsvSubId')
        return self


class GetCatalogListResponseBodyData(TeaModel):
    def __init__(self, catalog_id=None, catalog_name=None, isv_sub_id=None, parent_catalog_id=None,
                 profile_count=None):
        self.catalog_id = catalog_id  # type: long
        self.catalog_name = catalog_name  # type: str
        self.isv_sub_id = isv_sub_id  # type: str
        self.parent_catalog_id = parent_catalog_id  # type: long
        self.profile_count = profile_count  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetCatalogListResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.catalog_id is not None:
            result['CatalogId'] = self.catalog_id
        if self.catalog_name is not None:
            result['CatalogName'] = self.catalog_name
        if self.isv_sub_id is not None:
            result['IsvSubId'] = self.isv_sub_id
        if self.parent_catalog_id is not None:
            result['ParentCatalogId'] = self.parent_catalog_id
        if self.profile_count is not None:
            result['ProfileCount'] = self.profile_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CatalogId') is not None:
            self.catalog_id = m.get('CatalogId')
        if m.get('CatalogName') is not None:
            self.catalog_name = m.get('CatalogName')
        if m.get('IsvSubId') is not None:
            self.isv_sub_id = m.get('IsvSubId')
        if m.get('ParentCatalogId') is not None:
            self.parent_catalog_id = m.get('ParentCatalogId')
        if m.get('ProfileCount') is not None:
            self.profile_count = m.get('ProfileCount')
        return self


class GetCatalogListResponseBody(TeaModel):
    def __init__(self, code=None, data=None, message=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: list[GetCatalogListResponseBodyData]
        self.message = message  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(GetCatalogListResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = GetCatalogListResponseBodyData()
                self.data.append(temp_model.from_map(k))
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetCatalogListResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetCatalogListResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetCatalogListResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetCatalogListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetCityCodeResponseBodyData(TeaModel):
    def __init__(self, city_address=None, city_code=None):
        self.city_address = city_address  # type: str
        self.city_code = city_code  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetCityCodeResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.city_address is not None:
            result['CityAddress'] = self.city_address
        if self.city_code is not None:
            result['CityCode'] = self.city_code
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CityAddress') is not None:
            self.city_address = m.get('CityAddress')
        if m.get('CityCode') is not None:
            self.city_code = m.get('CityCode')
        return self


class GetCityCodeResponseBody(TeaModel):
    def __init__(self, code=None, data=None, message=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: list[GetCityCodeResponseBodyData]
        self.message = message  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(GetCityCodeResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = GetCityCodeResponseBodyData()
                self.data.append(temp_model.from_map(k))
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetCityCodeResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetCityCodeResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetCityCodeResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetCityCodeResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetDataSourceStatsRequest(TeaModel):
    def __init__(self, corp_id_list=None, data_source_type=None):
        self.corp_id_list = corp_id_list  # type: str
        self.data_source_type = data_source_type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetDataSourceStatsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.corp_id_list is not None:
            result['CorpIdList'] = self.corp_id_list
        if self.data_source_type is not None:
            result['DataSourceType'] = self.data_source_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CorpIdList') is not None:
            self.corp_id_list = m.get('CorpIdList')
        if m.get('DataSourceType') is not None:
            self.data_source_type = m.get('DataSourceType')
        return self


class GetDataSourceStatsResponseBodyData(TeaModel):
    def __init__(self, data_source_type=None, items=None, total=None):
        self.data_source_type = data_source_type  # type: str
        self.items = items  # type: dict[str, any]
        self.total = total  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetDataSourceStatsResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data_source_type is not None:
            result['DataSourceType'] = self.data_source_type
        if self.items is not None:
            result['Items'] = self.items
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DataSourceType') is not None:
            self.data_source_type = m.get('DataSourceType')
        if m.get('Items') is not None:
            self.items = m.get('Items')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class GetDataSourceStatsResponseBody(TeaModel):
    def __init__(self, code=None, data=None, message=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: list[GetDataSourceStatsResponseBodyData]
        self.message = message  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(GetDataSourceStatsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = GetDataSourceStatsResponseBodyData()
                self.data.append(temp_model.from_map(k))
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetDataSourceStatsResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetDataSourceStatsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetDataSourceStatsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetDataSourceStatsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetDeviceCaptureStrategyRequest(TeaModel):
    def __init__(self, device_code=None, device_type=None):
        # 设备通道号
        self.device_code = device_code  # type: str
        # 设备类型
        self.device_type = device_type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetDeviceCaptureStrategyRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_code is not None:
            result['DeviceCode'] = self.device_code
        if self.device_type is not None:
            result['DeviceType'] = self.device_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DeviceCode') is not None:
            self.device_code = m.get('DeviceCode')
        if m.get('DeviceType') is not None:
            self.device_type = m.get('DeviceType')
        return self


class GetDeviceCaptureStrategyResponseBodyData(TeaModel):
    def __init__(self, device_code=None, device_type=None, friday_capture_strategy=None,
                 monday_capture_strategy=None, saturday_capture_strategy=None, sunday_capture_strategy=None,
                 thursday_capture_strategy=None, tuesday_capture_strategy=None, wednesday_capture_strategy=None):
        # 设备通道
        self.device_code = device_code  # type: str
        # 设备类型
        self.device_type = device_type  # type: str
        # 星期五抓取策略
        self.friday_capture_strategy = friday_capture_strategy  # type: str
        # 星期一抓取策略
        self.monday_capture_strategy = monday_capture_strategy  # type: str
        # 星期六抓取策略
        self.saturday_capture_strategy = saturday_capture_strategy  # type: str
        # 星期日抓取策略
        self.sunday_capture_strategy = sunday_capture_strategy  # type: str
        # 星期四抓取策略
        self.thursday_capture_strategy = thursday_capture_strategy  # type: str
        # 星期二抓取策略
        self.tuesday_capture_strategy = tuesday_capture_strategy  # type: str
        # 星期三抓取策略
        self.wednesday_capture_strategy = wednesday_capture_strategy  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetDeviceCaptureStrategyResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_code is not None:
            result['DeviceCode'] = self.device_code
        if self.device_type is not None:
            result['DeviceType'] = self.device_type
        if self.friday_capture_strategy is not None:
            result['FridayCaptureStrategy'] = self.friday_capture_strategy
        if self.monday_capture_strategy is not None:
            result['MondayCaptureStrategy'] = self.monday_capture_strategy
        if self.saturday_capture_strategy is not None:
            result['SaturdayCaptureStrategy'] = self.saturday_capture_strategy
        if self.sunday_capture_strategy is not None:
            result['SundayCaptureStrategy'] = self.sunday_capture_strategy
        if self.thursday_capture_strategy is not None:
            result['ThursdayCaptureStrategy'] = self.thursday_capture_strategy
        if self.tuesday_capture_strategy is not None:
            result['TuesdayCaptureStrategy'] = self.tuesday_capture_strategy
        if self.wednesday_capture_strategy is not None:
            result['WednesdayCaptureStrategy'] = self.wednesday_capture_strategy
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DeviceCode') is not None:
            self.device_code = m.get('DeviceCode')
        if m.get('DeviceType') is not None:
            self.device_type = m.get('DeviceType')
        if m.get('FridayCaptureStrategy') is not None:
            self.friday_capture_strategy = m.get('FridayCaptureStrategy')
        if m.get('MondayCaptureStrategy') is not None:
            self.monday_capture_strategy = m.get('MondayCaptureStrategy')
        if m.get('SaturdayCaptureStrategy') is not None:
            self.saturday_capture_strategy = m.get('SaturdayCaptureStrategy')
        if m.get('SundayCaptureStrategy') is not None:
            self.sunday_capture_strategy = m.get('SundayCaptureStrategy')
        if m.get('ThursdayCaptureStrategy') is not None:
            self.thursday_capture_strategy = m.get('ThursdayCaptureStrategy')
        if m.get('TuesdayCaptureStrategy') is not None:
            self.tuesday_capture_strategy = m.get('TuesdayCaptureStrategy')
        if m.get('WednesdayCaptureStrategy') is not None:
            self.wednesday_capture_strategy = m.get('WednesdayCaptureStrategy')
        return self


class GetDeviceCaptureStrategyResponseBody(TeaModel):
    def __init__(self, code=None, data=None, message=None, request_id=None):
        # 错误码
        self.code = code  # type: str
        # 响应数据内容
        self.data = data  # type: GetDeviceCaptureStrategyResponseBodyData
        # 错误信息
        self.message = message  # type: str
        # RequestId
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(GetDeviceCaptureStrategyResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetDeviceCaptureStrategyResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetDeviceCaptureStrategyResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetDeviceCaptureStrategyResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetDeviceCaptureStrategyResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetDeviceCaptureStrategyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetDeviceConfigRequest(TeaModel):
    def __init__(self, device_sn=None, device_time_stamp=None):
        self.device_sn = device_sn  # type: str
        self.device_time_stamp = device_time_stamp  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetDeviceConfigRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_sn is not None:
            result['DeviceSn'] = self.device_sn
        if self.device_time_stamp is not None:
            result['DeviceTimeStamp'] = self.device_time_stamp
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DeviceSn') is not None:
            self.device_sn = m.get('DeviceSn')
        if m.get('DeviceTimeStamp') is not None:
            self.device_time_stamp = m.get('DeviceTimeStamp')
        return self


class GetDeviceConfigResponseBodyChannelList(TeaModel):
    def __init__(self, channel_gb_id=None, friday_capture_strategy=None, monday_capture_strategy=None,
                 saturday_capture_strategy=None, sunday_capture_strategy=None, thursday_capture_strategy=None,
                 tuesday_capture_strategy=None, wednesday_capture_strategy=None):
        self.channel_gb_id = channel_gb_id  # type: str
        self.friday_capture_strategy = friday_capture_strategy  # type: str
        self.monday_capture_strategy = monday_capture_strategy  # type: str
        self.saturday_capture_strategy = saturday_capture_strategy  # type: str
        self.sunday_capture_strategy = sunday_capture_strategy  # type: str
        self.thursday_capture_strategy = thursday_capture_strategy  # type: str
        self.tuesday_capture_strategy = tuesday_capture_strategy  # type: str
        self.wednesday_capture_strategy = wednesday_capture_strategy  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetDeviceConfigResponseBodyChannelList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.channel_gb_id is not None:
            result['ChannelGbId'] = self.channel_gb_id
        if self.friday_capture_strategy is not None:
            result['FridayCaptureStrategy'] = self.friday_capture_strategy
        if self.monday_capture_strategy is not None:
            result['MondayCaptureStrategy'] = self.monday_capture_strategy
        if self.saturday_capture_strategy is not None:
            result['SaturdayCaptureStrategy'] = self.saturday_capture_strategy
        if self.sunday_capture_strategy is not None:
            result['SundayCaptureStrategy'] = self.sunday_capture_strategy
        if self.thursday_capture_strategy is not None:
            result['ThursdayCaptureStrategy'] = self.thursday_capture_strategy
        if self.tuesday_capture_strategy is not None:
            result['TuesdayCaptureStrategy'] = self.tuesday_capture_strategy
        if self.wednesday_capture_strategy is not None:
            result['WednesdayCaptureStrategy'] = self.wednesday_capture_strategy
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ChannelGbId') is not None:
            self.channel_gb_id = m.get('ChannelGbId')
        if m.get('FridayCaptureStrategy') is not None:
            self.friday_capture_strategy = m.get('FridayCaptureStrategy')
        if m.get('MondayCaptureStrategy') is not None:
            self.monday_capture_strategy = m.get('MondayCaptureStrategy')
        if m.get('SaturdayCaptureStrategy') is not None:
            self.saturday_capture_strategy = m.get('SaturdayCaptureStrategy')
        if m.get('SundayCaptureStrategy') is not None:
            self.sunday_capture_strategy = m.get('SundayCaptureStrategy')
        if m.get('ThursdayCaptureStrategy') is not None:
            self.thursday_capture_strategy = m.get('ThursdayCaptureStrategy')
        if m.get('TuesdayCaptureStrategy') is not None:
            self.tuesday_capture_strategy = m.get('TuesdayCaptureStrategy')
        if m.get('WednesdayCaptureStrategy') is not None:
            self.wednesday_capture_strategy = m.get('WednesdayCaptureStrategy')
        return self


class GetDeviceConfigResponseBodyOSDList(TeaModel):
    def __init__(self, left_top_x=None, left_top_y=None, text=None):
        self.left_top_x = left_top_x  # type: str
        self.left_top_y = left_top_y  # type: str
        self.text = text  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetDeviceConfigResponseBodyOSDList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.left_top_x is not None:
            result['LeftTopX'] = self.left_top_x
        if self.left_top_y is not None:
            result['LeftTopY'] = self.left_top_y
        if self.text is not None:
            result['Text'] = self.text
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('LeftTopX') is not None:
            self.left_top_x = m.get('LeftTopX')
        if m.get('LeftTopY') is not None:
            self.left_top_y = m.get('LeftTopY')
        if m.get('Text') is not None:
            self.text = m.get('Text')
        return self


class GetDeviceConfigResponseBody(TeaModel):
    def __init__(self, audio_enable=None, audio_format=None, bit_rate=None, channel_list=None, code=None,
                 device_address=None, device_id=None, device_name=None, encode_format=None, frame_rate=None, gov_length=None,
                 latitude=None, longitude=None, message=None, osdlist=None, osdtime_enable=None, osdtime_type=None,
                 osdtime_x=None, osdtime_y=None, pass_word=None, protocol=None, request_id=None, resolution=None,
                 retry_interval=None, server_id=None, server_ip=None, server_port=None, user_name=None):
        self.audio_enable = audio_enable  # type: str
        self.audio_format = audio_format  # type: str
        self.bit_rate = bit_rate  # type: str
        self.channel_list = channel_list  # type: list[GetDeviceConfigResponseBodyChannelList]
        self.code = code  # type: str
        self.device_address = device_address  # type: str
        self.device_id = device_id  # type: str
        self.device_name = device_name  # type: str
        self.encode_format = encode_format  # type: str
        self.frame_rate = frame_rate  # type: str
        self.gov_length = gov_length  # type: long
        self.latitude = latitude  # type: str
        self.longitude = longitude  # type: str
        self.message = message  # type: str
        self.osdlist = osdlist  # type: list[GetDeviceConfigResponseBodyOSDList]
        self.osdtime_enable = osdtime_enable  # type: str
        self.osdtime_type = osdtime_type  # type: str
        self.osdtime_x = osdtime_x  # type: str
        self.osdtime_y = osdtime_y  # type: str
        self.pass_word = pass_word  # type: str
        self.protocol = protocol  # type: str
        # Id of the request
        self.request_id = request_id  # type: str
        self.resolution = resolution  # type: str
        self.retry_interval = retry_interval  # type: str
        self.server_id = server_id  # type: str
        self.server_ip = server_ip  # type: str
        self.server_port = server_port  # type: str
        self.user_name = user_name  # type: str

    def validate(self):
        if self.channel_list:
            for k in self.channel_list:
                if k:
                    k.validate()
        if self.osdlist:
            for k in self.osdlist:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(GetDeviceConfigResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.audio_enable is not None:
            result['AudioEnable'] = self.audio_enable
        if self.audio_format is not None:
            result['AudioFormat'] = self.audio_format
        if self.bit_rate is not None:
            result['BitRate'] = self.bit_rate
        result['ChannelList'] = []
        if self.channel_list is not None:
            for k in self.channel_list:
                result['ChannelList'].append(k.to_map() if k else None)
        if self.code is not None:
            result['Code'] = self.code
        if self.device_address is not None:
            result['DeviceAddress'] = self.device_address
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.encode_format is not None:
            result['EncodeFormat'] = self.encode_format
        if self.frame_rate is not None:
            result['FrameRate'] = self.frame_rate
        if self.gov_length is not None:
            result['GovLength'] = self.gov_length
        if self.latitude is not None:
            result['Latitude'] = self.latitude
        if self.longitude is not None:
            result['Longitude'] = self.longitude
        if self.message is not None:
            result['Message'] = self.message
        result['OSDList'] = []
        if self.osdlist is not None:
            for k in self.osdlist:
                result['OSDList'].append(k.to_map() if k else None)
        if self.osdtime_enable is not None:
            result['OSDTimeEnable'] = self.osdtime_enable
        if self.osdtime_type is not None:
            result['OSDTimeType'] = self.osdtime_type
        if self.osdtime_x is not None:
            result['OSDTimeX'] = self.osdtime_x
        if self.osdtime_y is not None:
            result['OSDTimeY'] = self.osdtime_y
        if self.pass_word is not None:
            result['PassWord'] = self.pass_word
        if self.protocol is not None:
            result['Protocol'] = self.protocol
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.resolution is not None:
            result['Resolution'] = self.resolution
        if self.retry_interval is not None:
            result['RetryInterval'] = self.retry_interval
        if self.server_id is not None:
            result['ServerId'] = self.server_id
        if self.server_ip is not None:
            result['ServerIp'] = self.server_ip
        if self.server_port is not None:
            result['ServerPort'] = self.server_port
        if self.user_name is not None:
            result['UserName'] = self.user_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AudioEnable') is not None:
            self.audio_enable = m.get('AudioEnable')
        if m.get('AudioFormat') is not None:
            self.audio_format = m.get('AudioFormat')
        if m.get('BitRate') is not None:
            self.bit_rate = m.get('BitRate')
        self.channel_list = []
        if m.get('ChannelList') is not None:
            for k in m.get('ChannelList'):
                temp_model = GetDeviceConfigResponseBodyChannelList()
                self.channel_list.append(temp_model.from_map(k))
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('DeviceAddress') is not None:
            self.device_address = m.get('DeviceAddress')
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('EncodeFormat') is not None:
            self.encode_format = m.get('EncodeFormat')
        if m.get('FrameRate') is not None:
            self.frame_rate = m.get('FrameRate')
        if m.get('GovLength') is not None:
            self.gov_length = m.get('GovLength')
        if m.get('Latitude') is not None:
            self.latitude = m.get('Latitude')
        if m.get('Longitude') is not None:
            self.longitude = m.get('Longitude')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        self.osdlist = []
        if m.get('OSDList') is not None:
            for k in m.get('OSDList'):
                temp_model = GetDeviceConfigResponseBodyOSDList()
                self.osdlist.append(temp_model.from_map(k))
        if m.get('OSDTimeEnable') is not None:
            self.osdtime_enable = m.get('OSDTimeEnable')
        if m.get('OSDTimeType') is not None:
            self.osdtime_type = m.get('OSDTimeType')
        if m.get('OSDTimeX') is not None:
            self.osdtime_x = m.get('OSDTimeX')
        if m.get('OSDTimeY') is not None:
            self.osdtime_y = m.get('OSDTimeY')
        if m.get('PassWord') is not None:
            self.pass_word = m.get('PassWord')
        if m.get('Protocol') is not None:
            self.protocol = m.get('Protocol')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Resolution') is not None:
            self.resolution = m.get('Resolution')
        if m.get('RetryInterval') is not None:
            self.retry_interval = m.get('RetryInterval')
        if m.get('ServerId') is not None:
            self.server_id = m.get('ServerId')
        if m.get('ServerIp') is not None:
            self.server_ip = m.get('ServerIp')
        if m.get('ServerPort') is not None:
            self.server_port = m.get('ServerPort')
        if m.get('UserName') is not None:
            self.user_name = m.get('UserName')
        return self


class GetDeviceConfigResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetDeviceConfigResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetDeviceConfigResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetDeviceConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetDeviceCountRequest(TeaModel):
    def __init__(self, up_stream_mode=None):
        self.up_stream_mode = up_stream_mode  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetDeviceCountRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.up_stream_mode is not None:
            result['UpStreamMode'] = self.up_stream_mode
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('UpStreamMode') is not None:
            self.up_stream_mode = m.get('UpStreamMode')
        return self


class GetDeviceCountResponseBodyData(TeaModel):
    def __init__(self, device_count=None):
        self.device_count = device_count  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetDeviceCountResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_count is not None:
            result['DeviceCount'] = self.device_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DeviceCount') is not None:
            self.device_count = m.get('DeviceCount')
        return self


class GetDeviceCountResponseBody(TeaModel):
    def __init__(self, code=None, data=None, message=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: GetDeviceCountResponseBodyData
        self.message = message  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(GetDeviceCountResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetDeviceCountResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetDeviceCountResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetDeviceCountResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetDeviceCountResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetDeviceCountResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetDeviceLiveUrlRequest(TeaModel):
    def __init__(self, corp_id=None, device_id=None, gb_id=None, out_protocol=None, stream_type=None):
        self.corp_id = corp_id  # type: str
        self.device_id = device_id  # type: str
        self.gb_id = gb_id  # type: str
        self.out_protocol = out_protocol  # type: str
        self.stream_type = stream_type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetDeviceLiveUrlRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.corp_id is not None:
            result['CorpId'] = self.corp_id
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.gb_id is not None:
            result['GbId'] = self.gb_id
        if self.out_protocol is not None:
            result['OutProtocol'] = self.out_protocol
        if self.stream_type is not None:
            result['StreamType'] = self.stream_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CorpId') is not None:
            self.corp_id = m.get('CorpId')
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('GbId') is not None:
            self.gb_id = m.get('GbId')
        if m.get('OutProtocol') is not None:
            self.out_protocol = m.get('OutProtocol')
        if m.get('StreamType') is not None:
            self.stream_type = m.get('StreamType')
        return self


class GetDeviceLiveUrlResponseBody(TeaModel):
    def __init__(self, code=None, message=None, out_protocol=None, request_id=None, stream_type=None, url=None):
        self.code = code  # type: str
        self.message = message  # type: str
        self.out_protocol = out_protocol  # type: str
        self.request_id = request_id  # type: str
        self.stream_type = stream_type  # type: long
        self.url = url  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetDeviceLiveUrlResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.out_protocol is not None:
            result['OutProtocol'] = self.out_protocol
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.stream_type is not None:
            result['StreamType'] = self.stream_type
        if self.url is not None:
            result['Url'] = self.url
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('OutProtocol') is not None:
            self.out_protocol = m.get('OutProtocol')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('StreamType') is not None:
            self.stream_type = m.get('StreamType')
        if m.get('Url') is not None:
            self.url = m.get('Url')
        return self


class GetDeviceLiveUrlResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetDeviceLiveUrlResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetDeviceLiveUrlResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetDeviceLiveUrlResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetDevicePictureRequest(TeaModel):
    def __init__(self, device_id=None):
        self.device_id = device_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetDevicePictureRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        return self


class GetDevicePictureResponseBody(TeaModel):
    def __init__(self, code=None, data=None, message=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: str
        self.message = message  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetDevicePictureResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetDevicePictureResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetDevicePictureResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetDevicePictureResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetDevicePictureResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetDeviceStatsRequest(TeaModel):
    def __init__(self, corp_id_list=None, device_status=None, device_type=None):
        self.corp_id_list = corp_id_list  # type: str
        self.device_status = device_status  # type: str
        self.device_type = device_type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetDeviceStatsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.corp_id_list is not None:
            result['CorpIdList'] = self.corp_id_list
        if self.device_status is not None:
            result['DeviceStatus'] = self.device_status
        if self.device_type is not None:
            result['DeviceType'] = self.device_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CorpIdList') is not None:
            self.corp_id_list = m.get('CorpIdList')
        if m.get('DeviceStatus') is not None:
            self.device_status = m.get('DeviceStatus')
        if m.get('DeviceType') is not None:
            self.device_type = m.get('DeviceType')
        return self


class GetDeviceStatsResponseBodyData(TeaModel):
    def __init__(self, count=None, device_status=None, device_type=None):
        self.count = count  # type: long
        self.device_status = device_status  # type: str
        self.device_type = device_type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetDeviceStatsResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.device_status is not None:
            result['DeviceStatus'] = self.device_status
        if self.device_type is not None:
            result['DeviceType'] = self.device_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('DeviceStatus') is not None:
            self.device_status = m.get('DeviceStatus')
        if m.get('DeviceType') is not None:
            self.device_type = m.get('DeviceType')
        return self


class GetDeviceStatsResponseBody(TeaModel):
    def __init__(self, code=None, data=None, message=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: list[GetDeviceStatsResponseBodyData]
        self.message = message  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(GetDeviceStatsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = GetDeviceStatsResponseBodyData()
                self.data.append(temp_model.from_map(k))
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetDeviceStatsResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetDeviceStatsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetDeviceStatsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetDeviceStatsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetDeviceVideoUrlRequest(TeaModel):
    def __init__(self, corp_id=None, device_id=None, end_time=None, gb_id=None, out_protocol=None, start_time=None,
                 storage_type=None):
        self.corp_id = corp_id  # type: str
        self.device_id = device_id  # type: str
        self.end_time = end_time  # type: long
        self.gb_id = gb_id  # type: str
        self.out_protocol = out_protocol  # type: str
        self.start_time = start_time  # type: long
        self.storage_type = storage_type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetDeviceVideoUrlRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.corp_id is not None:
            result['CorpId'] = self.corp_id
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.gb_id is not None:
            result['GbId'] = self.gb_id
        if self.out_protocol is not None:
            result['OutProtocol'] = self.out_protocol
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.storage_type is not None:
            result['StorageType'] = self.storage_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CorpId') is not None:
            self.corp_id = m.get('CorpId')
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('GbId') is not None:
            self.gb_id = m.get('GbId')
        if m.get('OutProtocol') is not None:
            self.out_protocol = m.get('OutProtocol')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('StorageType') is not None:
            self.storage_type = m.get('StorageType')
        return self


class GetDeviceVideoUrlResponseBody(TeaModel):
    def __init__(self, code=None, message=None, out_protocol=None, request_id=None, url=None):
        self.code = code  # type: str
        self.message = message  # type: str
        self.out_protocol = out_protocol  # type: str
        self.request_id = request_id  # type: str
        self.url = url  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetDeviceVideoUrlResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.out_protocol is not None:
            result['OutProtocol'] = self.out_protocol
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.url is not None:
            result['Url'] = self.url
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('OutProtocol') is not None:
            self.out_protocol = m.get('OutProtocol')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Url') is not None:
            self.url = m.get('Url')
        return self


class GetDeviceVideoUrlResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetDeviceVideoUrlResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetDeviceVideoUrlResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetDeviceVideoUrlResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetFaceModelResultRequest(TeaModel):
    def __init__(self, picture_content=None, picture_id=None, picture_url=None):
        self.picture_content = picture_content  # type: str
        self.picture_id = picture_id  # type: str
        self.picture_url = picture_url  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetFaceModelResultRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.picture_content is not None:
            result['PictureContent'] = self.picture_content
        if self.picture_id is not None:
            result['PictureId'] = self.picture_id
        if self.picture_url is not None:
            result['PictureUrl'] = self.picture_url
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PictureContent') is not None:
            self.picture_content = m.get('PictureContent')
        if m.get('PictureId') is not None:
            self.picture_id = m.get('PictureId')
        if m.get('PictureUrl') is not None:
            self.picture_url = m.get('PictureUrl')
        return self


class GetFaceModelResultResponseBodyDataRecords(TeaModel):
    def __init__(self, age_lower_limit=None, age_lower_limit_reliability=None, age_up_limit=None,
                 age_up_limit_reliability=None, cap_color=None, cap_color_reliability=None, cap_style=None, cap_style_reliability=None,
                 ethic_code=None, ethic_code_reliability=None, face_style=None, face_style_reliability=None,
                 feature_data=None, gender_code=None, gender_code_reliability=None, glass_color=None,
                 glass_color_reliability=None, glass_style=None, glass_style_reliability=None, hair_color=None,
                 hair_color_reliability=None, hair_style=None, hair_style_reliability=None, left_top_x=None, left_top_y=None,
                 mustache_style=None, mustache_style_reliability=None, respirator_color=None, respirator_color_reliability=None,
                 right_bottom_x=None, right_bottom_y=None, skin_color=None, skin_color_reliability=None):
        self.age_lower_limit = age_lower_limit  # type: int
        self.age_lower_limit_reliability = age_lower_limit_reliability  # type: str
        self.age_up_limit = age_up_limit  # type: int
        self.age_up_limit_reliability = age_up_limit_reliability  # type: str
        self.cap_color = cap_color  # type: int
        self.cap_color_reliability = cap_color_reliability  # type: str
        self.cap_style = cap_style  # type: int
        self.cap_style_reliability = cap_style_reliability  # type: str
        self.ethic_code = ethic_code  # type: int
        self.ethic_code_reliability = ethic_code_reliability  # type: str
        self.face_style = face_style  # type: str
        self.face_style_reliability = face_style_reliability  # type: str
        self.feature_data = feature_data  # type: list[float]
        self.gender_code = gender_code  # type: int
        self.gender_code_reliability = gender_code_reliability  # type: str
        self.glass_color = glass_color  # type: int
        self.glass_color_reliability = glass_color_reliability  # type: str
        self.glass_style = glass_style  # type: int
        self.glass_style_reliability = glass_style_reliability  # type: str
        self.hair_color = hair_color  # type: int
        self.hair_color_reliability = hair_color_reliability  # type: str
        self.hair_style = hair_style  # type: int
        self.hair_style_reliability = hair_style_reliability  # type: str
        self.left_top_x = left_top_x  # type: float
        self.left_top_y = left_top_y  # type: float
        self.mustache_style = mustache_style  # type: str
        self.mustache_style_reliability = mustache_style_reliability  # type: str
        self.respirator_color = respirator_color  # type: int
        self.respirator_color_reliability = respirator_color_reliability  # type: str
        self.right_bottom_x = right_bottom_x  # type: float
        self.right_bottom_y = right_bottom_y  # type: float
        self.skin_color = skin_color  # type: int
        self.skin_color_reliability = skin_color_reliability  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetFaceModelResultResponseBodyDataRecords, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.age_lower_limit is not None:
            result['AgeLowerLimit'] = self.age_lower_limit
        if self.age_lower_limit_reliability is not None:
            result['AgeLowerLimitReliability'] = self.age_lower_limit_reliability
        if self.age_up_limit is not None:
            result['AgeUpLimit'] = self.age_up_limit
        if self.age_up_limit_reliability is not None:
            result['AgeUpLimitReliability'] = self.age_up_limit_reliability
        if self.cap_color is not None:
            result['CapColor'] = self.cap_color
        if self.cap_color_reliability is not None:
            result['CapColorReliability'] = self.cap_color_reliability
        if self.cap_style is not None:
            result['CapStyle'] = self.cap_style
        if self.cap_style_reliability is not None:
            result['CapStyleReliability'] = self.cap_style_reliability
        if self.ethic_code is not None:
            result['EthicCode'] = self.ethic_code
        if self.ethic_code_reliability is not None:
            result['EthicCodeReliability'] = self.ethic_code_reliability
        if self.face_style is not None:
            result['FaceStyle'] = self.face_style
        if self.face_style_reliability is not None:
            result['FaceStyleReliability'] = self.face_style_reliability
        if self.feature_data is not None:
            result['FeatureData'] = self.feature_data
        if self.gender_code is not None:
            result['GenderCode'] = self.gender_code
        if self.gender_code_reliability is not None:
            result['GenderCodeReliability'] = self.gender_code_reliability
        if self.glass_color is not None:
            result['GlassColor'] = self.glass_color
        if self.glass_color_reliability is not None:
            result['GlassColorReliability'] = self.glass_color_reliability
        if self.glass_style is not None:
            result['GlassStyle'] = self.glass_style
        if self.glass_style_reliability is not None:
            result['GlassStyleReliability'] = self.glass_style_reliability
        if self.hair_color is not None:
            result['HairColor'] = self.hair_color
        if self.hair_color_reliability is not None:
            result['HairColorReliability'] = self.hair_color_reliability
        if self.hair_style is not None:
            result['HairStyle'] = self.hair_style
        if self.hair_style_reliability is not None:
            result['HairStyleReliability'] = self.hair_style_reliability
        if self.left_top_x is not None:
            result['LeftTopX'] = self.left_top_x
        if self.left_top_y is not None:
            result['LeftTopY'] = self.left_top_y
        if self.mustache_style is not None:
            result['MustacheStyle'] = self.mustache_style
        if self.mustache_style_reliability is not None:
            result['MustacheStyleReliability'] = self.mustache_style_reliability
        if self.respirator_color is not None:
            result['RespiratorColor'] = self.respirator_color
        if self.respirator_color_reliability is not None:
            result['RespiratorColorReliability'] = self.respirator_color_reliability
        if self.right_bottom_x is not None:
            result['RightBottomX'] = self.right_bottom_x
        if self.right_bottom_y is not None:
            result['RightBottomY'] = self.right_bottom_y
        if self.skin_color is not None:
            result['SkinColor'] = self.skin_color
        if self.skin_color_reliability is not None:
            result['SkinColorReliability'] = self.skin_color_reliability
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AgeLowerLimit') is not None:
            self.age_lower_limit = m.get('AgeLowerLimit')
        if m.get('AgeLowerLimitReliability') is not None:
            self.age_lower_limit_reliability = m.get('AgeLowerLimitReliability')
        if m.get('AgeUpLimit') is not None:
            self.age_up_limit = m.get('AgeUpLimit')
        if m.get('AgeUpLimitReliability') is not None:
            self.age_up_limit_reliability = m.get('AgeUpLimitReliability')
        if m.get('CapColor') is not None:
            self.cap_color = m.get('CapColor')
        if m.get('CapColorReliability') is not None:
            self.cap_color_reliability = m.get('CapColorReliability')
        if m.get('CapStyle') is not None:
            self.cap_style = m.get('CapStyle')
        if m.get('CapStyleReliability') is not None:
            self.cap_style_reliability = m.get('CapStyleReliability')
        if m.get('EthicCode') is not None:
            self.ethic_code = m.get('EthicCode')
        if m.get('EthicCodeReliability') is not None:
            self.ethic_code_reliability = m.get('EthicCodeReliability')
        if m.get('FaceStyle') is not None:
            self.face_style = m.get('FaceStyle')
        if m.get('FaceStyleReliability') is not None:
            self.face_style_reliability = m.get('FaceStyleReliability')
        if m.get('FeatureData') is not None:
            self.feature_data = m.get('FeatureData')
        if m.get('GenderCode') is not None:
            self.gender_code = m.get('GenderCode')
        if m.get('GenderCodeReliability') is not None:
            self.gender_code_reliability = m.get('GenderCodeReliability')
        if m.get('GlassColor') is not None:
            self.glass_color = m.get('GlassColor')
        if m.get('GlassColorReliability') is not None:
            self.glass_color_reliability = m.get('GlassColorReliability')
        if m.get('GlassStyle') is not None:
            self.glass_style = m.get('GlassStyle')
        if m.get('GlassStyleReliability') is not None:
            self.glass_style_reliability = m.get('GlassStyleReliability')
        if m.get('HairColor') is not None:
            self.hair_color = m.get('HairColor')
        if m.get('HairColorReliability') is not None:
            self.hair_color_reliability = m.get('HairColorReliability')
        if m.get('HairStyle') is not None:
            self.hair_style = m.get('HairStyle')
        if m.get('HairStyleReliability') is not None:
            self.hair_style_reliability = m.get('HairStyleReliability')
        if m.get('LeftTopX') is not None:
            self.left_top_x = m.get('LeftTopX')
        if m.get('LeftTopY') is not None:
            self.left_top_y = m.get('LeftTopY')
        if m.get('MustacheStyle') is not None:
            self.mustache_style = m.get('MustacheStyle')
        if m.get('MustacheStyleReliability') is not None:
            self.mustache_style_reliability = m.get('MustacheStyleReliability')
        if m.get('RespiratorColor') is not None:
            self.respirator_color = m.get('RespiratorColor')
        if m.get('RespiratorColorReliability') is not None:
            self.respirator_color_reliability = m.get('RespiratorColorReliability')
        if m.get('RightBottomX') is not None:
            self.right_bottom_x = m.get('RightBottomX')
        if m.get('RightBottomY') is not None:
            self.right_bottom_y = m.get('RightBottomY')
        if m.get('SkinColor') is not None:
            self.skin_color = m.get('SkinColor')
        if m.get('SkinColorReliability') is not None:
            self.skin_color_reliability = m.get('SkinColorReliability')
        return self


class GetFaceModelResultResponseBodyData(TeaModel):
    def __init__(self, records=None):
        self.records = records  # type: list[GetFaceModelResultResponseBodyDataRecords]

    def validate(self):
        if self.records:
            for k in self.records:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(GetFaceModelResultResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Records'] = []
        if self.records is not None:
            for k in self.records:
                result['Records'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.records = []
        if m.get('Records') is not None:
            for k in m.get('Records'):
                temp_model = GetFaceModelResultResponseBodyDataRecords()
                self.records.append(temp_model.from_map(k))
        return self


class GetFaceModelResultResponseBody(TeaModel):
    def __init__(self, code=None, data=None, message=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: GetFaceModelResultResponseBodyData
        self.message = message  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(GetFaceModelResultResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetFaceModelResultResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetFaceModelResultResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetFaceModelResultResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetFaceModelResultResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetFaceModelResultResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetFaceOptionsRequest(TeaModel):
    def __init__(self, corp_id=None):
        self.corp_id = corp_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetFaceOptionsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.corp_id is not None:
            result['CorpId'] = self.corp_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CorpId') is not None:
            self.corp_id = m.get('CorpId')
        return self


class GetFaceOptionsResponseBodyDataOptionList(TeaModel):
    def __init__(self, key=None, name=None):
        self.key = key  # type: str
        self.name = name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetFaceOptionsResponseBodyDataOptionList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.name is not None:
            result['Name'] = self.name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        return self


class GetFaceOptionsResponseBodyData(TeaModel):
    def __init__(self, key=None, name=None, option_list=None):
        self.key = key  # type: str
        self.name = name  # type: str
        self.option_list = option_list  # type: list[GetFaceOptionsResponseBodyDataOptionList]

    def validate(self):
        if self.option_list:
            for k in self.option_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(GetFaceOptionsResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.name is not None:
            result['Name'] = self.name
        result['OptionList'] = []
        if self.option_list is not None:
            for k in self.option_list:
                result['OptionList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        self.option_list = []
        if m.get('OptionList') is not None:
            for k in m.get('OptionList'):
                temp_model = GetFaceOptionsResponseBodyDataOptionList()
                self.option_list.append(temp_model.from_map(k))
        return self


class GetFaceOptionsResponseBody(TeaModel):
    def __init__(self, code=None, data=None, message=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: list[GetFaceOptionsResponseBodyData]
        self.message = message  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(GetFaceOptionsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = GetFaceOptionsResponseBodyData()
                self.data.append(temp_model.from_map(k))
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetFaceOptionsResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetFaceOptionsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetFaceOptionsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetFaceOptionsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetInventoryRequest(TeaModel):
    def __init__(self, commodity_code=None):
        self.commodity_code = commodity_code  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetInventoryRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.commodity_code is not None:
            result['CommodityCode'] = self.commodity_code
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CommodityCode') is not None:
            self.commodity_code = m.get('CommodityCode')
        return self


class GetInventoryResponseBodyDataResultObject(TeaModel):
    def __init__(self, buyer_id=None, commodity_code=None, current_inventory=None, instance_id=None,
                 inventory_id=None, valid_end_time=None, valid_start_time=None):
        self.buyer_id = buyer_id  # type: str
        self.commodity_code = commodity_code  # type: str
        self.current_inventory = current_inventory  # type: str
        self.instance_id = instance_id  # type: str
        self.inventory_id = inventory_id  # type: str
        self.valid_end_time = valid_end_time  # type: str
        self.valid_start_time = valid_start_time  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetInventoryResponseBodyDataResultObject, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.buyer_id is not None:
            result['BuyerId'] = self.buyer_id
        if self.commodity_code is not None:
            result['CommodityCode'] = self.commodity_code
        if self.current_inventory is not None:
            result['CurrentInventory'] = self.current_inventory
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.inventory_id is not None:
            result['InventoryId'] = self.inventory_id
        if self.valid_end_time is not None:
            result['ValidEndTime'] = self.valid_end_time
        if self.valid_start_time is not None:
            result['ValidStartTime'] = self.valid_start_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BuyerId') is not None:
            self.buyer_id = m.get('BuyerId')
        if m.get('CommodityCode') is not None:
            self.commodity_code = m.get('CommodityCode')
        if m.get('CurrentInventory') is not None:
            self.current_inventory = m.get('CurrentInventory')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('InventoryId') is not None:
            self.inventory_id = m.get('InventoryId')
        if m.get('ValidEndTime') is not None:
            self.valid_end_time = m.get('ValidEndTime')
        if m.get('ValidStartTime') is not None:
            self.valid_start_time = m.get('ValidStartTime')
        return self


class GetInventoryResponseBodyData(TeaModel):
    def __init__(self, result_object=None):
        self.result_object = result_object  # type: list[GetInventoryResponseBodyDataResultObject]

    def validate(self):
        if self.result_object:
            for k in self.result_object:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(GetInventoryResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ResultObject'] = []
        if self.result_object is not None:
            for k in self.result_object:
                result['ResultObject'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.result_object = []
        if m.get('ResultObject') is not None:
            for k in m.get('ResultObject'):
                temp_model = GetInventoryResponseBodyDataResultObject()
                self.result_object.append(temp_model.from_map(k))
        return self


class GetInventoryResponseBody(TeaModel):
    def __init__(self, data=None, success=None):
        self.data = data  # type: GetInventoryResponseBodyData
        self.success = success  # type: bool

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(GetInventoryResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Data') is not None:
            temp_model = GetInventoryResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetInventoryResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetInventoryResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetInventoryResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetInventoryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetMonitorListRequest(TeaModel):
    def __init__(self, corp_id=None, page_number=None, page_size=None):
        self.corp_id = corp_id  # type: str
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetMonitorListRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.corp_id is not None:
            result['CorpId'] = self.corp_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CorpId') is not None:
            self.corp_id = m.get('CorpId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class GetMonitorListResponseBodyDataRecords(TeaModel):
    def __init__(self, algorithm_vendor=None, attributes=None, create_date=None, description=None, device_list=None,
                 expression=None, image_match=None, modified_date=None, monitor_type=None, notifier_extend_values=None,
                 notifier_type=None, rule_expression=None, rule_name=None, status=None, task_id=None):
        self.algorithm_vendor = algorithm_vendor  # type: str
        self.attributes = attributes  # type: str
        self.create_date = create_date  # type: str
        self.description = description  # type: str
        self.device_list = device_list  # type: str
        self.expression = expression  # type: str
        self.image_match = image_match  # type: str
        self.modified_date = modified_date  # type: str
        self.monitor_type = monitor_type  # type: str
        self.notifier_extend_values = notifier_extend_values  # type: str
        self.notifier_type = notifier_type  # type: str
        self.rule_expression = rule_expression  # type: str
        self.rule_name = rule_name  # type: str
        self.status = status  # type: str
        self.task_id = task_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetMonitorListResponseBodyDataRecords, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.algorithm_vendor is not None:
            result['AlgorithmVendor'] = self.algorithm_vendor
        if self.attributes is not None:
            result['Attributes'] = self.attributes
        if self.create_date is not None:
            result['CreateDate'] = self.create_date
        if self.description is not None:
            result['Description'] = self.description
        if self.device_list is not None:
            result['DeviceList'] = self.device_list
        if self.expression is not None:
            result['Expression'] = self.expression
        if self.image_match is not None:
            result['ImageMatch'] = self.image_match
        if self.modified_date is not None:
            result['ModifiedDate'] = self.modified_date
        if self.monitor_type is not None:
            result['MonitorType'] = self.monitor_type
        if self.notifier_extend_values is not None:
            result['NotifierExtendValues'] = self.notifier_extend_values
        if self.notifier_type is not None:
            result['NotifierType'] = self.notifier_type
        if self.rule_expression is not None:
            result['RuleExpression'] = self.rule_expression
        if self.rule_name is not None:
            result['RuleName'] = self.rule_name
        if self.status is not None:
            result['Status'] = self.status
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AlgorithmVendor') is not None:
            self.algorithm_vendor = m.get('AlgorithmVendor')
        if m.get('Attributes') is not None:
            self.attributes = m.get('Attributes')
        if m.get('CreateDate') is not None:
            self.create_date = m.get('CreateDate')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('DeviceList') is not None:
            self.device_list = m.get('DeviceList')
        if m.get('Expression') is not None:
            self.expression = m.get('Expression')
        if m.get('ImageMatch') is not None:
            self.image_match = m.get('ImageMatch')
        if m.get('ModifiedDate') is not None:
            self.modified_date = m.get('ModifiedDate')
        if m.get('MonitorType') is not None:
            self.monitor_type = m.get('MonitorType')
        if m.get('NotifierExtendValues') is not None:
            self.notifier_extend_values = m.get('NotifierExtendValues')
        if m.get('NotifierType') is not None:
            self.notifier_type = m.get('NotifierType')
        if m.get('RuleExpression') is not None:
            self.rule_expression = m.get('RuleExpression')
        if m.get('RuleName') is not None:
            self.rule_name = m.get('RuleName')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class GetMonitorListResponseBodyData(TeaModel):
    def __init__(self, page_number=None, page_size=None, records=None, total_count=None, total_page=None):
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.records = records  # type: list[GetMonitorListResponseBodyDataRecords]
        self.total_count = total_count  # type: int
        self.total_page = total_page  # type: int

    def validate(self):
        if self.records:
            for k in self.records:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(GetMonitorListResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        result['Records'] = []
        if self.records is not None:
            for k in self.records:
                result['Records'].append(k.to_map() if k else None)
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.total_page is not None:
            result['TotalPage'] = self.total_page
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        self.records = []
        if m.get('Records') is not None:
            for k in m.get('Records'):
                temp_model = GetMonitorListResponseBodyDataRecords()
                self.records.append(temp_model.from_map(k))
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('TotalPage') is not None:
            self.total_page = m.get('TotalPage')
        return self


class GetMonitorListResponseBody(TeaModel):
    def __init__(self, code=None, data=None, message=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: GetMonitorListResponseBodyData
        self.message = message  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(GetMonitorListResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetMonitorListResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetMonitorListResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetMonitorListResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetMonitorListResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetMonitorListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetMonitorResultRequest(TeaModel):
    def __init__(self, algorithm_vendor=None, corp_id=None, end_time=None, min_record_id=None, start_time=None,
                 task_id=None):
        self.algorithm_vendor = algorithm_vendor  # type: str
        self.corp_id = corp_id  # type: str
        self.end_time = end_time  # type: long
        self.min_record_id = min_record_id  # type: str
        self.start_time = start_time  # type: long
        self.task_id = task_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetMonitorResultRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.algorithm_vendor is not None:
            result['AlgorithmVendor'] = self.algorithm_vendor
        if self.corp_id is not None:
            result['CorpId'] = self.corp_id
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.min_record_id is not None:
            result['MinRecordId'] = self.min_record_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AlgorithmVendor') is not None:
            self.algorithm_vendor = m.get('AlgorithmVendor')
        if m.get('CorpId') is not None:
            self.corp_id = m.get('CorpId')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('MinRecordId') is not None:
            self.min_record_id = m.get('MinRecordId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class GetMonitorResultResponseBodyDataRecordsExtendInfo(TeaModel):
    def __init__(self, plate_no=None):
        self.plate_no = plate_no  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetMonitorResultResponseBodyDataRecordsExtendInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.plate_no is not None:
            result['PlateNo'] = self.plate_no
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PlateNo') is not None:
            self.plate_no = m.get('PlateNo')
        return self


class GetMonitorResultResponseBodyDataRecords(TeaModel):
    def __init__(self, extend_info=None, gb_id=None, left_up_x=None, left_up_y=None, monitor_pic_url=None,
                 pic_url=None, right_bottom_x=None, right_bottom_y=None, score=None, shot_time=None, target_pic_url=None,
                 task_id=None):
        self.extend_info = extend_info  # type: GetMonitorResultResponseBodyDataRecordsExtendInfo
        self.gb_id = gb_id  # type: str
        self.left_up_x = left_up_x  # type: str
        self.left_up_y = left_up_y  # type: str
        self.monitor_pic_url = monitor_pic_url  # type: str
        self.pic_url = pic_url  # type: str
        self.right_bottom_x = right_bottom_x  # type: str
        self.right_bottom_y = right_bottom_y  # type: str
        self.score = score  # type: str
        self.shot_time = shot_time  # type: str
        self.target_pic_url = target_pic_url  # type: str
        self.task_id = task_id  # type: str

    def validate(self):
        if self.extend_info:
            self.extend_info.validate()

    def to_map(self):
        _map = super(GetMonitorResultResponseBodyDataRecords, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.extend_info is not None:
            result['ExtendInfo'] = self.extend_info.to_map()
        if self.gb_id is not None:
            result['GbId'] = self.gb_id
        if self.left_up_x is not None:
            result['LeftUpX'] = self.left_up_x
        if self.left_up_y is not None:
            result['LeftUpY'] = self.left_up_y
        if self.monitor_pic_url is not None:
            result['MonitorPicUrl'] = self.monitor_pic_url
        if self.pic_url is not None:
            result['PicUrl'] = self.pic_url
        if self.right_bottom_x is not None:
            result['RightBottomX'] = self.right_bottom_x
        if self.right_bottom_y is not None:
            result['RightBottomY'] = self.right_bottom_y
        if self.score is not None:
            result['Score'] = self.score
        if self.shot_time is not None:
            result['ShotTime'] = self.shot_time
        if self.target_pic_url is not None:
            result['TargetPicUrl'] = self.target_pic_url
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ExtendInfo') is not None:
            temp_model = GetMonitorResultResponseBodyDataRecordsExtendInfo()
            self.extend_info = temp_model.from_map(m['ExtendInfo'])
        if m.get('GbId') is not None:
            self.gb_id = m.get('GbId')
        if m.get('LeftUpX') is not None:
            self.left_up_x = m.get('LeftUpX')
        if m.get('LeftUpY') is not None:
            self.left_up_y = m.get('LeftUpY')
        if m.get('MonitorPicUrl') is not None:
            self.monitor_pic_url = m.get('MonitorPicUrl')
        if m.get('PicUrl') is not None:
            self.pic_url = m.get('PicUrl')
        if m.get('RightBottomX') is not None:
            self.right_bottom_x = m.get('RightBottomX')
        if m.get('RightBottomY') is not None:
            self.right_bottom_y = m.get('RightBottomY')
        if m.get('Score') is not None:
            self.score = m.get('Score')
        if m.get('ShotTime') is not None:
            self.shot_time = m.get('ShotTime')
        if m.get('TargetPicUrl') is not None:
            self.target_pic_url = m.get('TargetPicUrl')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class GetMonitorResultResponseBodyData(TeaModel):
    def __init__(self, max_id=None, records=None):
        self.max_id = max_id  # type: str
        self.records = records  # type: list[GetMonitorResultResponseBodyDataRecords]

    def validate(self):
        if self.records:
            for k in self.records:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(GetMonitorResultResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.max_id is not None:
            result['MaxId'] = self.max_id
        result['Records'] = []
        if self.records is not None:
            for k in self.records:
                result['Records'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('MaxId') is not None:
            self.max_id = m.get('MaxId')
        self.records = []
        if m.get('Records') is not None:
            for k in m.get('Records'):
                temp_model = GetMonitorResultResponseBodyDataRecords()
                self.records.append(temp_model.from_map(k))
        return self


class GetMonitorResultResponseBody(TeaModel):
    def __init__(self, code=None, data=None, message=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: GetMonitorResultResponseBodyData
        self.message = message  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(GetMonitorResultResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetMonitorResultResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetMonitorResultResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetMonitorResultResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetMonitorResultResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetMonitorResultResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetOdpsResultResponseBody(TeaModel):
    def __init__(self, data=None, success=None):
        # Id of the request
        self.data = data  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetOdpsResultResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetOdpsResultResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetOdpsResultResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetOdpsResultResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetOdpsResultResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetPersonDetailRequest(TeaModel):
    def __init__(self, algorithm_type=None, corp_id=None, person_id=None):
        self.algorithm_type = algorithm_type  # type: str
        self.corp_id = corp_id  # type: str
        self.person_id = person_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetPersonDetailRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.algorithm_type is not None:
            result['AlgorithmType'] = self.algorithm_type
        if self.corp_id is not None:
            result['CorpId'] = self.corp_id
        if self.person_id is not None:
            result['PersonID'] = self.person_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AlgorithmType') is not None:
            self.algorithm_type = m.get('AlgorithmType')
        if m.get('CorpId') is not None:
            self.corp_id = m.get('CorpId')
        if m.get('PersonID') is not None:
            self.person_id = m.get('PersonID')
        return self


class GetPersonDetailResponseBodyDataTagList(TeaModel):
    def __init__(self, tag_code=None, tag_name=None, tag_value=None, tag_value_id=None):
        self.tag_code = tag_code  # type: str
        self.tag_name = tag_name  # type: str
        self.tag_value = tag_value  # type: str
        self.tag_value_id = tag_value_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetPersonDetailResponseBodyDataTagList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tag_code is not None:
            result['TagCode'] = self.tag_code
        if self.tag_name is not None:
            result['TagName'] = self.tag_name
        if self.tag_value is not None:
            result['TagValue'] = self.tag_value
        if self.tag_value_id is not None:
            result['TagValueId'] = self.tag_value_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TagCode') is not None:
            self.tag_code = m.get('TagCode')
        if m.get('TagName') is not None:
            self.tag_name = m.get('TagName')
        if m.get('TagValue') is not None:
            self.tag_value = m.get('TagValue')
        if m.get('TagValueId') is not None:
            self.tag_value_id = m.get('TagValueId')
        return self


class GetPersonDetailResponseBodyData(TeaModel):
    def __init__(self, person_id=None, pic_url=None, tag_list=None):
        self.person_id = person_id  # type: str
        self.pic_url = pic_url  # type: str
        self.tag_list = tag_list  # type: list[GetPersonDetailResponseBodyDataTagList]

    def validate(self):
        if self.tag_list:
            for k in self.tag_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(GetPersonDetailResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.person_id is not None:
            result['PersonId'] = self.person_id
        if self.pic_url is not None:
            result['PicUrl'] = self.pic_url
        result['TagList'] = []
        if self.tag_list is not None:
            for k in self.tag_list:
                result['TagList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PersonId') is not None:
            self.person_id = m.get('PersonId')
        if m.get('PicUrl') is not None:
            self.pic_url = m.get('PicUrl')
        self.tag_list = []
        if m.get('TagList') is not None:
            for k in m.get('TagList'):
                temp_model = GetPersonDetailResponseBodyDataTagList()
                self.tag_list.append(temp_model.from_map(k))
        return self


class GetPersonDetailResponseBody(TeaModel):
    def __init__(self, code=None, data=None, message=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: GetPersonDetailResponseBodyData
        self.message = message  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(GetPersonDetailResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetPersonDetailResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetPersonDetailResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetPersonDetailResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetPersonDetailResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetPersonDetailResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetPersonListRequest(TeaModel):
    def __init__(self, corp_id=None, corp_id_list=None, face_matching_rate_threshold=None, face_url=None,
                 page_number=None, page_size=None, person_id_list=None):
        self.corp_id = corp_id  # type: str
        self.corp_id_list = corp_id_list  # type: dict[str, any]
        self.face_matching_rate_threshold = face_matching_rate_threshold  # type: str
        self.face_url = face_url  # type: str
        self.page_number = page_number  # type: long
        self.page_size = page_size  # type: long
        self.person_id_list = person_id_list  # type: dict[str, any]

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetPersonListRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.corp_id is not None:
            result['CorpId'] = self.corp_id
        if self.corp_id_list is not None:
            result['CorpIdList'] = self.corp_id_list
        if self.face_matching_rate_threshold is not None:
            result['FaceMatchingRateThreshold'] = self.face_matching_rate_threshold
        if self.face_url is not None:
            result['FaceUrl'] = self.face_url
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.person_id_list is not None:
            result['PersonIdList'] = self.person_id_list
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CorpId') is not None:
            self.corp_id = m.get('CorpId')
        if m.get('CorpIdList') is not None:
            self.corp_id_list = m.get('CorpIdList')
        if m.get('FaceMatchingRateThreshold') is not None:
            self.face_matching_rate_threshold = m.get('FaceMatchingRateThreshold')
        if m.get('FaceUrl') is not None:
            self.face_url = m.get('FaceUrl')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('PersonIdList') is not None:
            self.person_id_list = m.get('PersonIdList')
        return self


class GetPersonListShrinkRequest(TeaModel):
    def __init__(self, corp_id=None, corp_id_list_shrink=None, face_matching_rate_threshold=None, face_url=None,
                 page_number=None, page_size=None, person_id_list_shrink=None):
        self.corp_id = corp_id  # type: str
        self.corp_id_list_shrink = corp_id_list_shrink  # type: str
        self.face_matching_rate_threshold = face_matching_rate_threshold  # type: str
        self.face_url = face_url  # type: str
        self.page_number = page_number  # type: long
        self.page_size = page_size  # type: long
        self.person_id_list_shrink = person_id_list_shrink  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetPersonListShrinkRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.corp_id is not None:
            result['CorpId'] = self.corp_id
        if self.corp_id_list_shrink is not None:
            result['CorpIdList'] = self.corp_id_list_shrink
        if self.face_matching_rate_threshold is not None:
            result['FaceMatchingRateThreshold'] = self.face_matching_rate_threshold
        if self.face_url is not None:
            result['FaceUrl'] = self.face_url
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.person_id_list_shrink is not None:
            result['PersonIdList'] = self.person_id_list_shrink
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CorpId') is not None:
            self.corp_id = m.get('CorpId')
        if m.get('CorpIdList') is not None:
            self.corp_id_list_shrink = m.get('CorpIdList')
        if m.get('FaceMatchingRateThreshold') is not None:
            self.face_matching_rate_threshold = m.get('FaceMatchingRateThreshold')
        if m.get('FaceUrl') is not None:
            self.face_url = m.get('FaceUrl')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('PersonIdList') is not None:
            self.person_id_list_shrink = m.get('PersonIdList')
        return self


class GetPersonListResponseBodyDataRecordsPropertyTagList(TeaModel):
    def __init__(self, code=None, tag_code_name=None, tag_name=None, value=None):
        self.code = code  # type: str
        self.tag_code_name = tag_code_name  # type: str
        self.tag_name = tag_name  # type: str
        self.value = value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetPersonListResponseBodyDataRecordsPropertyTagList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.tag_code_name is not None:
            result['TagCodeName'] = self.tag_code_name
        if self.tag_name is not None:
            result['TagName'] = self.tag_name
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('TagCodeName') is not None:
            self.tag_code_name = m.get('TagCodeName')
        if m.get('TagName') is not None:
            self.tag_name = m.get('TagName')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class GetPersonListResponseBodyDataRecords(TeaModel):
    def __init__(self, face_url=None, first_shot_time=None, last_shot_time=None, person_id=None,
                 property_tag_list=None, search_matching_rate=None):
        self.face_url = face_url  # type: str
        self.first_shot_time = first_shot_time  # type: long
        self.last_shot_time = last_shot_time  # type: long
        self.person_id = person_id  # type: str
        self.property_tag_list = property_tag_list  # type: list[GetPersonListResponseBodyDataRecordsPropertyTagList]
        self.search_matching_rate = search_matching_rate  # type: str

    def validate(self):
        if self.property_tag_list:
            for k in self.property_tag_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(GetPersonListResponseBodyDataRecords, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.face_url is not None:
            result['FaceUrl'] = self.face_url
        if self.first_shot_time is not None:
            result['FirstShotTime'] = self.first_shot_time
        if self.last_shot_time is not None:
            result['LastShotTime'] = self.last_shot_time
        if self.person_id is not None:
            result['PersonId'] = self.person_id
        result['PropertyTagList'] = []
        if self.property_tag_list is not None:
            for k in self.property_tag_list:
                result['PropertyTagList'].append(k.to_map() if k else None)
        if self.search_matching_rate is not None:
            result['SearchMatchingRate'] = self.search_matching_rate
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('FaceUrl') is not None:
            self.face_url = m.get('FaceUrl')
        if m.get('FirstShotTime') is not None:
            self.first_shot_time = m.get('FirstShotTime')
        if m.get('LastShotTime') is not None:
            self.last_shot_time = m.get('LastShotTime')
        if m.get('PersonId') is not None:
            self.person_id = m.get('PersonId')
        self.property_tag_list = []
        if m.get('PropertyTagList') is not None:
            for k in m.get('PropertyTagList'):
                temp_model = GetPersonListResponseBodyDataRecordsPropertyTagList()
                self.property_tag_list.append(temp_model.from_map(k))
        if m.get('SearchMatchingRate') is not None:
            self.search_matching_rate = m.get('SearchMatchingRate')
        return self


class GetPersonListResponseBodyData(TeaModel):
    def __init__(self, page_number=None, page_size=None, records=None, total_count=None):
        self.page_number = page_number  # type: long
        self.page_size = page_size  # type: long
        self.records = records  # type: list[GetPersonListResponseBodyDataRecords]
        self.total_count = total_count  # type: long

    def validate(self):
        if self.records:
            for k in self.records:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(GetPersonListResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        result['Records'] = []
        if self.records is not None:
            for k in self.records:
                result['Records'].append(k.to_map() if k else None)
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        self.records = []
        if m.get('Records') is not None:
            for k in m.get('Records'):
                temp_model = GetPersonListResponseBodyDataRecords()
                self.records.append(temp_model.from_map(k))
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class GetPersonListResponseBody(TeaModel):
    def __init__(self, code=None, data=None, message=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: GetPersonListResponseBodyData
        self.message = message  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(GetPersonListResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetPersonListResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetPersonListResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetPersonListResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetPersonListResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetPersonListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetPictureUrlRequest(TeaModel):
    def __init__(self, expire_time=None, origin_url=None, protocol=None):
        self.expire_time = expire_time  # type: str
        self.origin_url = origin_url  # type: str
        self.protocol = protocol  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetPictureUrlRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.expire_time is not None:
            result['ExpireTime'] = self.expire_time
        if self.origin_url is not None:
            result['OriginUrl'] = self.origin_url
        if self.protocol is not None:
            result['Protocol'] = self.protocol
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ExpireTime') is not None:
            self.expire_time = m.get('ExpireTime')
        if m.get('OriginUrl') is not None:
            self.origin_url = m.get('OriginUrl')
        if m.get('Protocol') is not None:
            self.protocol = m.get('Protocol')
        return self


class GetPictureUrlResponseBody(TeaModel):
    def __init__(self, code=None, message=None, request_id=None, url=None):
        self.code = code  # type: str
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.url = url  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetPictureUrlResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.url is not None:
            result['Url'] = self.url
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Url') is not None:
            self.url = m.get('Url')
        return self


class GetPictureUrlResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetPictureUrlResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetPictureUrlResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetPictureUrlResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetProfileDetailRequest(TeaModel):
    def __init__(self, corp_id=None, isv_sub_id=None, profile_id=None):
        self.corp_id = corp_id  # type: str
        self.isv_sub_id = isv_sub_id  # type: str
        self.profile_id = profile_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetProfileDetailRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.corp_id is not None:
            result['CorpId'] = self.corp_id
        if self.isv_sub_id is not None:
            result['IsvSubId'] = self.isv_sub_id
        if self.profile_id is not None:
            result['ProfileId'] = self.profile_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CorpId') is not None:
            self.corp_id = m.get('CorpId')
        if m.get('IsvSubId') is not None:
            self.isv_sub_id = m.get('IsvSubId')
        if m.get('ProfileId') is not None:
            self.profile_id = m.get('ProfileId')
        return self


class GetProfileDetailResponseBodyData(TeaModel):
    def __init__(self, biz_id=None, catalog_id=None, face_url=None, gender=None, id_number=None, isv_sub_id=None,
                 live_address=None, name=None, person_id=None, phone_no=None, plate_no=None, profile_id=None, scene_type=None):
        self.biz_id = biz_id  # type: str
        self.catalog_id = catalog_id  # type: int
        self.face_url = face_url  # type: str
        self.gender = gender  # type: str
        self.id_number = id_number  # type: str
        self.isv_sub_id = isv_sub_id  # type: str
        self.live_address = live_address  # type: str
        self.name = name  # type: str
        self.person_id = person_id  # type: str
        self.phone_no = phone_no  # type: str
        self.plate_no = plate_no  # type: str
        self.profile_id = profile_id  # type: int
        self.scene_type = scene_type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetProfileDetailResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.biz_id is not None:
            result['BizId'] = self.biz_id
        if self.catalog_id is not None:
            result['CatalogId'] = self.catalog_id
        if self.face_url is not None:
            result['FaceUrl'] = self.face_url
        if self.gender is not None:
            result['Gender'] = self.gender
        if self.id_number is not None:
            result['IdNumber'] = self.id_number
        if self.isv_sub_id is not None:
            result['IsvSubId'] = self.isv_sub_id
        if self.live_address is not None:
            result['LiveAddress'] = self.live_address
        if self.name is not None:
            result['Name'] = self.name
        if self.person_id is not None:
            result['PersonId'] = self.person_id
        if self.phone_no is not None:
            result['PhoneNo'] = self.phone_no
        if self.plate_no is not None:
            result['PlateNo'] = self.plate_no
        if self.profile_id is not None:
            result['ProfileId'] = self.profile_id
        if self.scene_type is not None:
            result['SceneType'] = self.scene_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BizId') is not None:
            self.biz_id = m.get('BizId')
        if m.get('CatalogId') is not None:
            self.catalog_id = m.get('CatalogId')
        if m.get('FaceUrl') is not None:
            self.face_url = m.get('FaceUrl')
        if m.get('Gender') is not None:
            self.gender = m.get('Gender')
        if m.get('IdNumber') is not None:
            self.id_number = m.get('IdNumber')
        if m.get('IsvSubId') is not None:
            self.isv_sub_id = m.get('IsvSubId')
        if m.get('LiveAddress') is not None:
            self.live_address = m.get('LiveAddress')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('PersonId') is not None:
            self.person_id = m.get('PersonId')
        if m.get('PhoneNo') is not None:
            self.phone_no = m.get('PhoneNo')
        if m.get('PlateNo') is not None:
            self.plate_no = m.get('PlateNo')
        if m.get('ProfileId') is not None:
            self.profile_id = m.get('ProfileId')
        if m.get('SceneType') is not None:
            self.scene_type = m.get('SceneType')
        return self


class GetProfileDetailResponseBody(TeaModel):
    def __init__(self, code=None, data=None, message=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: GetProfileDetailResponseBodyData
        self.message = message  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(GetProfileDetailResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetProfileDetailResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetProfileDetailResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetProfileDetailResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetProfileDetailResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetProfileDetailResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetProfileListRequest(TeaModel):
    def __init__(self, biz_id=None, catalog_id=None, corp_id=None, face_image_id=None, face_url=None, gender=None,
                 id_number=None, isv_sub_id=None, live_address=None, matching_rate_threshold=None, name=None,
                 page_number=None, page_size=None, person_id_list=None, phone_no=None, plate_no=None, profile_id_list=None,
                 scene_type=None):
        self.biz_id = biz_id  # type: str
        self.catalog_id = catalog_id  # type: long
        self.corp_id = corp_id  # type: str
        self.face_image_id = face_image_id  # type: str
        self.face_url = face_url  # type: str
        self.gender = gender  # type: int
        self.id_number = id_number  # type: str
        self.isv_sub_id = isv_sub_id  # type: str
        self.live_address = live_address  # type: str
        self.matching_rate_threshold = matching_rate_threshold  # type: str
        self.name = name  # type: str
        self.page_number = page_number  # type: long
        self.page_size = page_size  # type: long
        self.person_id_list = person_id_list  # type: dict[str, any]
        self.phone_no = phone_no  # type: str
        self.plate_no = plate_no  # type: str
        self.profile_id_list = profile_id_list  # type: dict[str, any]
        self.scene_type = scene_type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetProfileListRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.biz_id is not None:
            result['BizId'] = self.biz_id
        if self.catalog_id is not None:
            result['CatalogId'] = self.catalog_id
        if self.corp_id is not None:
            result['CorpId'] = self.corp_id
        if self.face_image_id is not None:
            result['FaceImageId'] = self.face_image_id
        if self.face_url is not None:
            result['FaceUrl'] = self.face_url
        if self.gender is not None:
            result['Gender'] = self.gender
        if self.id_number is not None:
            result['IdNumber'] = self.id_number
        if self.isv_sub_id is not None:
            result['IsvSubId'] = self.isv_sub_id
        if self.live_address is not None:
            result['LiveAddress'] = self.live_address
        if self.matching_rate_threshold is not None:
            result['MatchingRateThreshold'] = self.matching_rate_threshold
        if self.name is not None:
            result['Name'] = self.name
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.person_id_list is not None:
            result['PersonIdList'] = self.person_id_list
        if self.phone_no is not None:
            result['PhoneNo'] = self.phone_no
        if self.plate_no is not None:
            result['PlateNo'] = self.plate_no
        if self.profile_id_list is not None:
            result['ProfileIdList'] = self.profile_id_list
        if self.scene_type is not None:
            result['SceneType'] = self.scene_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BizId') is not None:
            self.biz_id = m.get('BizId')
        if m.get('CatalogId') is not None:
            self.catalog_id = m.get('CatalogId')
        if m.get('CorpId') is not None:
            self.corp_id = m.get('CorpId')
        if m.get('FaceImageId') is not None:
            self.face_image_id = m.get('FaceImageId')
        if m.get('FaceUrl') is not None:
            self.face_url = m.get('FaceUrl')
        if m.get('Gender') is not None:
            self.gender = m.get('Gender')
        if m.get('IdNumber') is not None:
            self.id_number = m.get('IdNumber')
        if m.get('IsvSubId') is not None:
            self.isv_sub_id = m.get('IsvSubId')
        if m.get('LiveAddress') is not None:
            self.live_address = m.get('LiveAddress')
        if m.get('MatchingRateThreshold') is not None:
            self.matching_rate_threshold = m.get('MatchingRateThreshold')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('PersonIdList') is not None:
            self.person_id_list = m.get('PersonIdList')
        if m.get('PhoneNo') is not None:
            self.phone_no = m.get('PhoneNo')
        if m.get('PlateNo') is not None:
            self.plate_no = m.get('PlateNo')
        if m.get('ProfileIdList') is not None:
            self.profile_id_list = m.get('ProfileIdList')
        if m.get('SceneType') is not None:
            self.scene_type = m.get('SceneType')
        return self


class GetProfileListShrinkRequest(TeaModel):
    def __init__(self, biz_id=None, catalog_id=None, corp_id=None, face_image_id=None, face_url=None, gender=None,
                 id_number=None, isv_sub_id=None, live_address=None, matching_rate_threshold=None, name=None,
                 page_number=None, page_size=None, person_id_list_shrink=None, phone_no=None, plate_no=None,
                 profile_id_list_shrink=None, scene_type=None):
        self.biz_id = biz_id  # type: str
        self.catalog_id = catalog_id  # type: long
        self.corp_id = corp_id  # type: str
        self.face_image_id = face_image_id  # type: str
        self.face_url = face_url  # type: str
        self.gender = gender  # type: int
        self.id_number = id_number  # type: str
        self.isv_sub_id = isv_sub_id  # type: str
        self.live_address = live_address  # type: str
        self.matching_rate_threshold = matching_rate_threshold  # type: str
        self.name = name  # type: str
        self.page_number = page_number  # type: long
        self.page_size = page_size  # type: long
        self.person_id_list_shrink = person_id_list_shrink  # type: str
        self.phone_no = phone_no  # type: str
        self.plate_no = plate_no  # type: str
        self.profile_id_list_shrink = profile_id_list_shrink  # type: str
        self.scene_type = scene_type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetProfileListShrinkRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.biz_id is not None:
            result['BizId'] = self.biz_id
        if self.catalog_id is not None:
            result['CatalogId'] = self.catalog_id
        if self.corp_id is not None:
            result['CorpId'] = self.corp_id
        if self.face_image_id is not None:
            result['FaceImageId'] = self.face_image_id
        if self.face_url is not None:
            result['FaceUrl'] = self.face_url
        if self.gender is not None:
            result['Gender'] = self.gender
        if self.id_number is not None:
            result['IdNumber'] = self.id_number
        if self.isv_sub_id is not None:
            result['IsvSubId'] = self.isv_sub_id
        if self.live_address is not None:
            result['LiveAddress'] = self.live_address
        if self.matching_rate_threshold is not None:
            result['MatchingRateThreshold'] = self.matching_rate_threshold
        if self.name is not None:
            result['Name'] = self.name
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.person_id_list_shrink is not None:
            result['PersonIdList'] = self.person_id_list_shrink
        if self.phone_no is not None:
            result['PhoneNo'] = self.phone_no
        if self.plate_no is not None:
            result['PlateNo'] = self.plate_no
        if self.profile_id_list_shrink is not None:
            result['ProfileIdList'] = self.profile_id_list_shrink
        if self.scene_type is not None:
            result['SceneType'] = self.scene_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BizId') is not None:
            self.biz_id = m.get('BizId')
        if m.get('CatalogId') is not None:
            self.catalog_id = m.get('CatalogId')
        if m.get('CorpId') is not None:
            self.corp_id = m.get('CorpId')
        if m.get('FaceImageId') is not None:
            self.face_image_id = m.get('FaceImageId')
        if m.get('FaceUrl') is not None:
            self.face_url = m.get('FaceUrl')
        if m.get('Gender') is not None:
            self.gender = m.get('Gender')
        if m.get('IdNumber') is not None:
            self.id_number = m.get('IdNumber')
        if m.get('IsvSubId') is not None:
            self.isv_sub_id = m.get('IsvSubId')
        if m.get('LiveAddress') is not None:
            self.live_address = m.get('LiveAddress')
        if m.get('MatchingRateThreshold') is not None:
            self.matching_rate_threshold = m.get('MatchingRateThreshold')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('PersonIdList') is not None:
            self.person_id_list_shrink = m.get('PersonIdList')
        if m.get('PhoneNo') is not None:
            self.phone_no = m.get('PhoneNo')
        if m.get('PlateNo') is not None:
            self.plate_no = m.get('PlateNo')
        if m.get('ProfileIdList') is not None:
            self.profile_id_list_shrink = m.get('ProfileIdList')
        if m.get('SceneType') is not None:
            self.scene_type = m.get('SceneType')
        return self


class GetProfileListResponseBodyDataRecords(TeaModel):
    def __init__(self, biz_id=None, catalog_id=None, face_url=None, gender=None, id_number=None, isv_sub_id=None,
                 name=None, person_id=None, profile_id=None, scene_type=None, search_matching_rate=None):
        self.biz_id = biz_id  # type: str
        self.catalog_id = catalog_id  # type: int
        self.face_url = face_url  # type: str
        self.gender = gender  # type: str
        self.id_number = id_number  # type: str
        self.isv_sub_id = isv_sub_id  # type: str
        self.name = name  # type: str
        self.person_id = person_id  # type: str
        self.profile_id = profile_id  # type: int
        self.scene_type = scene_type  # type: str
        self.search_matching_rate = search_matching_rate  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetProfileListResponseBodyDataRecords, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.biz_id is not None:
            result['BizId'] = self.biz_id
        if self.catalog_id is not None:
            result['CatalogId'] = self.catalog_id
        if self.face_url is not None:
            result['FaceUrl'] = self.face_url
        if self.gender is not None:
            result['Gender'] = self.gender
        if self.id_number is not None:
            result['IdNumber'] = self.id_number
        if self.isv_sub_id is not None:
            result['IsvSubId'] = self.isv_sub_id
        if self.name is not None:
            result['Name'] = self.name
        if self.person_id is not None:
            result['PersonId'] = self.person_id
        if self.profile_id is not None:
            result['ProfileId'] = self.profile_id
        if self.scene_type is not None:
            result['SceneType'] = self.scene_type
        if self.search_matching_rate is not None:
            result['SearchMatchingRate'] = self.search_matching_rate
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BizId') is not None:
            self.biz_id = m.get('BizId')
        if m.get('CatalogId') is not None:
            self.catalog_id = m.get('CatalogId')
        if m.get('FaceUrl') is not None:
            self.face_url = m.get('FaceUrl')
        if m.get('Gender') is not None:
            self.gender = m.get('Gender')
        if m.get('IdNumber') is not None:
            self.id_number = m.get('IdNumber')
        if m.get('IsvSubId') is not None:
            self.isv_sub_id = m.get('IsvSubId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('PersonId') is not None:
            self.person_id = m.get('PersonId')
        if m.get('ProfileId') is not None:
            self.profile_id = m.get('ProfileId')
        if m.get('SceneType') is not None:
            self.scene_type = m.get('SceneType')
        if m.get('SearchMatchingRate') is not None:
            self.search_matching_rate = m.get('SearchMatchingRate')
        return self


class GetProfileListResponseBodyData(TeaModel):
    def __init__(self, page_number=None, page_size=None, records=None, success=None, total=None):
        self.page_number = page_number  # type: long
        self.page_size = page_size  # type: long
        self.records = records  # type: list[GetProfileListResponseBodyDataRecords]
        self.success = success  # type: bool
        self.total = total  # type: long

    def validate(self):
        if self.records:
            for k in self.records:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(GetProfileListResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        result['Records'] = []
        if self.records is not None:
            for k in self.records:
                result['Records'].append(k.to_map() if k else None)
        if self.success is not None:
            result['Success'] = self.success
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        self.records = []
        if m.get('Records') is not None:
            for k in m.get('Records'):
                temp_model = GetProfileListResponseBodyDataRecords()
                self.records.append(temp_model.from_map(k))
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class GetProfileListResponseBody(TeaModel):
    def __init__(self, code=None, data=None, message=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: GetProfileListResponseBodyData
        self.message = message  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(GetProfileListResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetProfileListResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetProfileListResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetProfileListResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetProfileListResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetProfileListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetScanSubDevicesRequest(TeaModel):
    def __init__(self, corp_id=None, device_id=None):
        self.corp_id = corp_id  # type: str
        self.device_id = device_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetScanSubDevicesRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.corp_id is not None:
            result['CorpId'] = self.corp_id
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CorpId') is not None:
            self.corp_id = m.get('CorpId')
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        return self


class GetScanSubDevicesResponseBodyDataSubDeviceList(TeaModel):
    def __init__(self, associated_nvr=None, device_mac=None, device_model=None, device_sn=None,
                 firmware_version=None, manufacturer=None, sub_device_ip=None, sub_device_port=None):
        self.associated_nvr = associated_nvr  # type: str
        self.device_mac = device_mac  # type: str
        self.device_model = device_model  # type: str
        self.device_sn = device_sn  # type: str
        self.firmware_version = firmware_version  # type: str
        self.manufacturer = manufacturer  # type: str
        self.sub_device_ip = sub_device_ip  # type: str
        self.sub_device_port = sub_device_port  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetScanSubDevicesResponseBodyDataSubDeviceList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.associated_nvr is not None:
            result['AssociatedNvr'] = self.associated_nvr
        if self.device_mac is not None:
            result['DeviceMac'] = self.device_mac
        if self.device_model is not None:
            result['DeviceModel'] = self.device_model
        if self.device_sn is not None:
            result['DeviceSn'] = self.device_sn
        if self.firmware_version is not None:
            result['FirmwareVersion'] = self.firmware_version
        if self.manufacturer is not None:
            result['Manufacturer'] = self.manufacturer
        if self.sub_device_ip is not None:
            result['SubDeviceIp'] = self.sub_device_ip
        if self.sub_device_port is not None:
            result['SubDevicePort'] = self.sub_device_port
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AssociatedNvr') is not None:
            self.associated_nvr = m.get('AssociatedNvr')
        if m.get('DeviceMac') is not None:
            self.device_mac = m.get('DeviceMac')
        if m.get('DeviceModel') is not None:
            self.device_model = m.get('DeviceModel')
        if m.get('DeviceSn') is not None:
            self.device_sn = m.get('DeviceSn')
        if m.get('FirmwareVersion') is not None:
            self.firmware_version = m.get('FirmwareVersion')
        if m.get('Manufacturer') is not None:
            self.manufacturer = m.get('Manufacturer')
        if m.get('SubDeviceIp') is not None:
            self.sub_device_ip = m.get('SubDeviceIp')
        if m.get('SubDevicePort') is not None:
            self.sub_device_port = m.get('SubDevicePort')
        return self


class GetScanSubDevicesResponseBodyData(TeaModel):
    def __init__(self, sub_device_list=None):
        self.sub_device_list = sub_device_list  # type: list[GetScanSubDevicesResponseBodyDataSubDeviceList]

    def validate(self):
        if self.sub_device_list:
            for k in self.sub_device_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(GetScanSubDevicesResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['SubDeviceList'] = []
        if self.sub_device_list is not None:
            for k in self.sub_device_list:
                result['SubDeviceList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.sub_device_list = []
        if m.get('SubDeviceList') is not None:
            for k in m.get('SubDeviceList'):
                temp_model = GetScanSubDevicesResponseBodyDataSubDeviceList()
                self.sub_device_list.append(temp_model.from_map(k))
        return self


class GetScanSubDevicesResponseBody(TeaModel):
    def __init__(self, code=None, data=None, message=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: GetScanSubDevicesResponseBodyData
        self.message = message  # type: str
        # Id of the request
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(GetScanSubDevicesResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetScanSubDevicesResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetScanSubDevicesResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetScanSubDevicesResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetScanSubDevicesResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetScanSubDevicesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetUserDetailRequest(TeaModel):
    def __init__(self, corp_id=None, isv_sub_id=None, need_face_detail=None, user_id=None):
        self.corp_id = corp_id  # type: str
        self.isv_sub_id = isv_sub_id  # type: str
        self.need_face_detail = need_face_detail  # type: bool
        self.user_id = user_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetUserDetailRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.corp_id is not None:
            result['CorpId'] = self.corp_id
        if self.isv_sub_id is not None:
            result['IsvSubId'] = self.isv_sub_id
        if self.need_face_detail is not None:
            result['NeedFaceDetail'] = self.need_face_detail
        if self.user_id is not None:
            result['UserId'] = self.user_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CorpId') is not None:
            self.corp_id = m.get('CorpId')
        if m.get('IsvSubId') is not None:
            self.isv_sub_id = m.get('IsvSubId')
        if m.get('NeedFaceDetail') is not None:
            self.need_face_detail = m.get('NeedFaceDetail')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        return self


class GetUserDetailResponseBodyData(TeaModel):
    def __init__(self, address=None, age=None, attachment=None, biz_id=None, face_image_url=None, gender=None,
                 id_number=None, isv_sub_id=None, phone_no=None, plate_no=None, user_group_id=None, user_id=None,
                 user_name=None):
        self.address = address  # type: str
        self.age = age  # type: str
        self.attachment = attachment  # type: str
        self.biz_id = biz_id  # type: str
        self.face_image_url = face_image_url  # type: str
        self.gender = gender  # type: str
        self.id_number = id_number  # type: str
        self.isv_sub_id = isv_sub_id  # type: str
        self.phone_no = phone_no  # type: str
        self.plate_no = plate_no  # type: str
        self.user_group_id = user_group_id  # type: int
        self.user_id = user_id  # type: int
        self.user_name = user_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetUserDetailResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.address is not None:
            result['Address'] = self.address
        if self.age is not None:
            result['Age'] = self.age
        if self.attachment is not None:
            result['Attachment'] = self.attachment
        if self.biz_id is not None:
            result['BizId'] = self.biz_id
        if self.face_image_url is not None:
            result['FaceImageUrl'] = self.face_image_url
        if self.gender is not None:
            result['Gender'] = self.gender
        if self.id_number is not None:
            result['IdNumber'] = self.id_number
        if self.isv_sub_id is not None:
            result['IsvSubId'] = self.isv_sub_id
        if self.phone_no is not None:
            result['PhoneNo'] = self.phone_no
        if self.plate_no is not None:
            result['PlateNo'] = self.plate_no
        if self.user_group_id is not None:
            result['UserGroupId'] = self.user_group_id
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.user_name is not None:
            result['UserName'] = self.user_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Address') is not None:
            self.address = m.get('Address')
        if m.get('Age') is not None:
            self.age = m.get('Age')
        if m.get('Attachment') is not None:
            self.attachment = m.get('Attachment')
        if m.get('BizId') is not None:
            self.biz_id = m.get('BizId')
        if m.get('FaceImageUrl') is not None:
            self.face_image_url = m.get('FaceImageUrl')
        if m.get('Gender') is not None:
            self.gender = m.get('Gender')
        if m.get('IdNumber') is not None:
            self.id_number = m.get('IdNumber')
        if m.get('IsvSubId') is not None:
            self.isv_sub_id = m.get('IsvSubId')
        if m.get('PhoneNo') is not None:
            self.phone_no = m.get('PhoneNo')
        if m.get('PlateNo') is not None:
            self.plate_no = m.get('PlateNo')
        if m.get('UserGroupId') is not None:
            self.user_group_id = m.get('UserGroupId')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('UserName') is not None:
            self.user_name = m.get('UserName')
        return self


class GetUserDetailResponseBody(TeaModel):
    def __init__(self, code=None, data=None, message=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: GetUserDetailResponseBodyData
        self.message = message  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(GetUserDetailResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetUserDetailResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetUserDetailResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetUserDetailResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetUserDetailResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetUserDetailResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetVideoComposeResultRequest(TeaModel):
    def __init__(self, corp_id=None, task_request_id=None):
        self.corp_id = corp_id  # type: str
        self.task_request_id = task_request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetVideoComposeResultRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.corp_id is not None:
            result['CorpId'] = self.corp_id
        if self.task_request_id is not None:
            result['TaskRequestId'] = self.task_request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CorpId') is not None:
            self.corp_id = m.get('CorpId')
        if m.get('TaskRequestId') is not None:
            self.task_request_id = m.get('TaskRequestId')
        return self


class GetVideoComposeResultResponseBody(TeaModel):
    def __init__(self, code=None, message=None, request_id=None, status=None, video_url=None):
        self.code = code  # type: str
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.status = status  # type: str
        self.video_url = video_url  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetVideoComposeResultResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.status is not None:
            result['Status'] = self.status
        if self.video_url is not None:
            result['VideoUrl'] = self.video_url
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('VideoUrl') is not None:
            self.video_url = m.get('VideoUrl')
        return self


class GetVideoComposeResultResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetVideoComposeResultResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetVideoComposeResultResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetVideoComposeResultResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetVideoSummaryTaskResultRequest(TeaModel):
    def __init__(self, corp_id=None, task_id=None):
        self.corp_id = corp_id  # type: str
        self.task_id = task_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetVideoSummaryTaskResultRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.corp_id is not None:
            result['CorpId'] = self.corp_id
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CorpId') is not None:
            self.corp_id = m.get('CorpId')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class GetVideoSummaryTaskResultResponseBody(TeaModel):
    def __init__(self, code=None, data=None, message=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: str
        self.message = message  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetVideoSummaryTaskResultResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetVideoSummaryTaskResultResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetVideoSummaryTaskResultResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetVideoSummaryTaskResultResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetVideoSummaryTaskResultResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class InvokeMotorModelRequest(TeaModel):
    def __init__(self, corp_id=None, pic_id=None, pic_path=None, pic_url=None):
        self.corp_id = corp_id  # type: str
        self.pic_id = pic_id  # type: str
        self.pic_path = pic_path  # type: str
        self.pic_url = pic_url  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(InvokeMotorModelRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.corp_id is not None:
            result['CorpId'] = self.corp_id
        if self.pic_id is not None:
            result['PicId'] = self.pic_id
        if self.pic_path is not None:
            result['PicPath'] = self.pic_path
        if self.pic_url is not None:
            result['PicUrl'] = self.pic_url
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CorpId') is not None:
            self.corp_id = m.get('CorpId')
        if m.get('PicId') is not None:
            self.pic_id = m.get('PicId')
        if m.get('PicPath') is not None:
            self.pic_path = m.get('PicPath')
        if m.get('PicUrl') is not None:
            self.pic_url = m.get('PicUrl')
        return self


class InvokeMotorModelResponseBodyData(TeaModel):
    def __init__(self, struct_list=None):
        self.struct_list = struct_list  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(InvokeMotorModelResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.struct_list is not None:
            result['StructList'] = self.struct_list
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('StructList') is not None:
            self.struct_list = m.get('StructList')
        return self


class InvokeMotorModelResponseBody(TeaModel):
    def __init__(self, code=None, data=None, message=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: InvokeMotorModelResponseBodyData
        self.message = message  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(InvokeMotorModelResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = InvokeMotorModelResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class InvokeMotorModelResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: InvokeMotorModelResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(InvokeMotorModelResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = InvokeMotorModelResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListAccessNumberRequest(TeaModel):
    def __init__(self, corp_id_list=None):
        self.corp_id_list = corp_id_list  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListAccessNumberRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.corp_id_list is not None:
            result['CorpIdList'] = self.corp_id_list
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CorpIdList') is not None:
            self.corp_id_list = m.get('CorpIdList')
        return self


class ListAccessNumberResponseBodyData(TeaModel):
    def __init__(self, count=None, item=None, percent=None):
        self.count = count  # type: str
        self.item = item  # type: str
        self.percent = percent  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListAccessNumberResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.item is not None:
            result['Item'] = self.item
        if self.percent is not None:
            result['Percent'] = self.percent
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('Item') is not None:
            self.item = m.get('Item')
        if m.get('Percent') is not None:
            self.percent = m.get('Percent')
        return self


class ListAccessNumberResponseBody(TeaModel):
    def __init__(self, code=None, data=None, message=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: list[ListAccessNumberResponseBodyData]
        self.message = message  # type: str
        # Id of the request
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListAccessNumberResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = ListAccessNumberResponseBodyData()
                self.data.append(temp_model.from_map(k))
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ListAccessNumberResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: ListAccessNumberResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListAccessNumberResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListAccessNumberResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListAlgorithmNamesByDeviceIdsRequest(TeaModel):
    def __init__(self, gb_ids=None):
        # 设备ID集合，多个的话以逗号分隔，最大支持200个
        self.gb_ids = gb_ids  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListAlgorithmNamesByDeviceIdsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.gb_ids is not None:
            result['GbIds'] = self.gb_ids
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('GbIds') is not None:
            self.gb_ids = m.get('GbIds')
        return self


class ListAlgorithmNamesByDeviceIdsResponseBodyData(TeaModel):
    def __init__(self, algorithm_names=None, gb_id=None):
        # 设备ID对应呗计算的算法名称集合
        self.algorithm_names = algorithm_names  # type: list[str]
        # 设备ID
        self.gb_id = gb_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListAlgorithmNamesByDeviceIdsResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.algorithm_names is not None:
            result['AlgorithmNames'] = self.algorithm_names
        if self.gb_id is not None:
            result['GbId'] = self.gb_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AlgorithmNames') is not None:
            self.algorithm_names = m.get('AlgorithmNames')
        if m.get('GbId') is not None:
            self.gb_id = m.get('GbId')
        return self


class ListAlgorithmNamesByDeviceIdsResponseBody(TeaModel):
    def __init__(self, code=None, data=None, message=None, request_id=None, success=None):
        # 返回结果编码  200：获取成功  Failed：获取失败  Retry：按需拉流模式，正在建立取流连接，请稍后重试
        self.code = code  # type: str
        self.data = data  # type: list[ListAlgorithmNamesByDeviceIdsResponseBodyData]
        # 返回结果消息
        self.message = message  # type: str
        # 请求ID
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListAlgorithmNamesByDeviceIdsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = ListAlgorithmNamesByDeviceIdsResponseBodyData()
                self.data.append(temp_model.from_map(k))
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class ListAlgorithmNamesByDeviceIdsResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: ListAlgorithmNamesByDeviceIdsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListAlgorithmNamesByDeviceIdsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListAlgorithmNamesByDeviceIdsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListBodyAlgorithmResultsRequest(TeaModel):
    def __init__(self, algorithm_type=None, cap_style=None, corp_id=None, data_source_id=None, end_time=None,
                 page_number=None, page_size=None, start_time=None):
        self.algorithm_type = algorithm_type  # type: str
        self.cap_style = cap_style  # type: str
        self.corp_id = corp_id  # type: str
        self.data_source_id = data_source_id  # type: str
        self.end_time = end_time  # type: str
        self.page_number = page_number  # type: str
        self.page_size = page_size  # type: str
        self.start_time = start_time  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListBodyAlgorithmResultsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.algorithm_type is not None:
            result['AlgorithmType'] = self.algorithm_type
        if self.cap_style is not None:
            result['CapStyle'] = self.cap_style
        if self.corp_id is not None:
            result['CorpId'] = self.corp_id
        if self.data_source_id is not None:
            result['DataSourceId'] = self.data_source_id
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AlgorithmType') is not None:
            self.algorithm_type = m.get('AlgorithmType')
        if m.get('CapStyle') is not None:
            self.cap_style = m.get('CapStyle')
        if m.get('CorpId') is not None:
            self.corp_id = m.get('CorpId')
        if m.get('DataSourceId') is not None:
            self.data_source_id = m.get('DataSourceId')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class ListBodyAlgorithmResultsResponseBodyDataRecords(TeaModel):
    def __init__(self, cap_style=None, coat_color=None, coat_length=None, coat_style=None, corp_id=None,
                 data_source_id=None, gender_code=None, hair_style=None, left_top_x=None, left_top_y=None, max_age=None,
                 min_age=None, person_id=None, pic_url_path=None, right_bottom_x=None, right_bottom_y=None, shot_time=None,
                 source_id=None, target_pic_url_path=None, trousers_color=None, trousers_length=None, trousers_style=None):
        self.cap_style = cap_style  # type: str
        self.coat_color = coat_color  # type: str
        self.coat_length = coat_length  # type: str
        self.coat_style = coat_style  # type: str
        self.corp_id = corp_id  # type: str
        self.data_source_id = data_source_id  # type: str
        self.gender_code = gender_code  # type: str
        self.hair_style = hair_style  # type: str
        self.left_top_x = left_top_x  # type: float
        self.left_top_y = left_top_y  # type: float
        self.max_age = max_age  # type: str
        self.min_age = min_age  # type: str
        self.person_id = person_id  # type: str
        self.pic_url_path = pic_url_path  # type: str
        self.right_bottom_x = right_bottom_x  # type: float
        self.right_bottom_y = right_bottom_y  # type: float
        self.shot_time = shot_time  # type: str
        self.source_id = source_id  # type: str
        self.target_pic_url_path = target_pic_url_path  # type: str
        self.trousers_color = trousers_color  # type: str
        self.trousers_length = trousers_length  # type: str
        self.trousers_style = trousers_style  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListBodyAlgorithmResultsResponseBodyDataRecords, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cap_style is not None:
            result['CapStyle'] = self.cap_style
        if self.coat_color is not None:
            result['CoatColor'] = self.coat_color
        if self.coat_length is not None:
            result['CoatLength'] = self.coat_length
        if self.coat_style is not None:
            result['CoatStyle'] = self.coat_style
        if self.corp_id is not None:
            result['CorpId'] = self.corp_id
        if self.data_source_id is not None:
            result['DataSourceId'] = self.data_source_id
        if self.gender_code is not None:
            result['GenderCode'] = self.gender_code
        if self.hair_style is not None:
            result['HairStyle'] = self.hair_style
        if self.left_top_x is not None:
            result['LeftTopX'] = self.left_top_x
        if self.left_top_y is not None:
            result['LeftTopY'] = self.left_top_y
        if self.max_age is not None:
            result['MaxAge'] = self.max_age
        if self.min_age is not None:
            result['MinAge'] = self.min_age
        if self.person_id is not None:
            result['PersonId'] = self.person_id
        if self.pic_url_path is not None:
            result['PicUrlPath'] = self.pic_url_path
        if self.right_bottom_x is not None:
            result['RightBottomX'] = self.right_bottom_x
        if self.right_bottom_y is not None:
            result['RightBottomY'] = self.right_bottom_y
        if self.shot_time is not None:
            result['ShotTime'] = self.shot_time
        if self.source_id is not None:
            result['SourceId'] = self.source_id
        if self.target_pic_url_path is not None:
            result['TargetPicUrlPath'] = self.target_pic_url_path
        if self.trousers_color is not None:
            result['TrousersColor'] = self.trousers_color
        if self.trousers_length is not None:
            result['TrousersLength'] = self.trousers_length
        if self.trousers_style is not None:
            result['TrousersStyle'] = self.trousers_style
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CapStyle') is not None:
            self.cap_style = m.get('CapStyle')
        if m.get('CoatColor') is not None:
            self.coat_color = m.get('CoatColor')
        if m.get('CoatLength') is not None:
            self.coat_length = m.get('CoatLength')
        if m.get('CoatStyle') is not None:
            self.coat_style = m.get('CoatStyle')
        if m.get('CorpId') is not None:
            self.corp_id = m.get('CorpId')
        if m.get('DataSourceId') is not None:
            self.data_source_id = m.get('DataSourceId')
        if m.get('GenderCode') is not None:
            self.gender_code = m.get('GenderCode')
        if m.get('HairStyle') is not None:
            self.hair_style = m.get('HairStyle')
        if m.get('LeftTopX') is not None:
            self.left_top_x = m.get('LeftTopX')
        if m.get('LeftTopY') is not None:
            self.left_top_y = m.get('LeftTopY')
        if m.get('MaxAge') is not None:
            self.max_age = m.get('MaxAge')
        if m.get('MinAge') is not None:
            self.min_age = m.get('MinAge')
        if m.get('PersonId') is not None:
            self.person_id = m.get('PersonId')
        if m.get('PicUrlPath') is not None:
            self.pic_url_path = m.get('PicUrlPath')
        if m.get('RightBottomX') is not None:
            self.right_bottom_x = m.get('RightBottomX')
        if m.get('RightBottomY') is not None:
            self.right_bottom_y = m.get('RightBottomY')
        if m.get('ShotTime') is not None:
            self.shot_time = m.get('ShotTime')
        if m.get('SourceId') is not None:
            self.source_id = m.get('SourceId')
        if m.get('TargetPicUrlPath') is not None:
            self.target_pic_url_path = m.get('TargetPicUrlPath')
        if m.get('TrousersColor') is not None:
            self.trousers_color = m.get('TrousersColor')
        if m.get('TrousersLength') is not None:
            self.trousers_length = m.get('TrousersLength')
        if m.get('TrousersStyle') is not None:
            self.trousers_style = m.get('TrousersStyle')
        return self


class ListBodyAlgorithmResultsResponseBodyData(TeaModel):
    def __init__(self, page_number=None, page_size=None, records=None, total_count=None, total_page=None):
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.records = records  # type: list[ListBodyAlgorithmResultsResponseBodyDataRecords]
        self.total_count = total_count  # type: int
        self.total_page = total_page  # type: int

    def validate(self):
        if self.records:
            for k in self.records:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListBodyAlgorithmResultsResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        result['Records'] = []
        if self.records is not None:
            for k in self.records:
                result['Records'].append(k.to_map() if k else None)
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.total_page is not None:
            result['TotalPage'] = self.total_page
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        self.records = []
        if m.get('Records') is not None:
            for k in m.get('Records'):
                temp_model = ListBodyAlgorithmResultsResponseBodyDataRecords()
                self.records.append(temp_model.from_map(k))
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('TotalPage') is not None:
            self.total_page = m.get('TotalPage')
        return self


class ListBodyAlgorithmResultsResponseBody(TeaModel):
    def __init__(self, code=None, data=None, message=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: ListBodyAlgorithmResultsResponseBodyData
        self.message = message  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(ListBodyAlgorithmResultsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = ListBodyAlgorithmResultsResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ListBodyAlgorithmResultsResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: ListBodyAlgorithmResultsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListBodyAlgorithmResultsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListBodyAlgorithmResultsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListCorpGroupMetricsRequest(TeaModel):
    def __init__(self, corp_id=None, device_group=None, device_id=None, end_time=None, group_id=None,
                 page_number=None, page_size=None, start_time=None, tag_code=None, user_group=None):
        self.corp_id = corp_id  # type: str
        self.device_group = device_group  # type: str
        self.device_id = device_id  # type: str
        self.end_time = end_time  # type: str
        self.group_id = group_id  # type: str
        self.page_number = page_number  # type: str
        self.page_size = page_size  # type: str
        self.start_time = start_time  # type: str
        self.tag_code = tag_code  # type: str
        self.user_group = user_group  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListCorpGroupMetricsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.corp_id is not None:
            result['CorpId'] = self.corp_id
        if self.device_group is not None:
            result['DeviceGroup'] = self.device_group
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.tag_code is not None:
            result['TagCode'] = self.tag_code
        if self.user_group is not None:
            result['UserGroup'] = self.user_group
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CorpId') is not None:
            self.corp_id = m.get('CorpId')
        if m.get('DeviceGroup') is not None:
            self.device_group = m.get('DeviceGroup')
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('TagCode') is not None:
            self.tag_code = m.get('TagCode')
        if m.get('UserGroup') is not None:
            self.user_group = m.get('UserGroup')
        return self


class ListCorpGroupMetricsResponseBodyData(TeaModel):
    def __init__(self, corp_group_id=None, corp_id=None, date_id=None, device_group_id=None, device_id=None,
                 person_id=None, tag_code=None, tag_metrics=None, tag_value=None, user_group_id=None):
        self.corp_group_id = corp_group_id  # type: str
        self.corp_id = corp_id  # type: str
        self.date_id = date_id  # type: str
        self.device_group_id = device_group_id  # type: str
        self.device_id = device_id  # type: str
        self.person_id = person_id  # type: str
        self.tag_code = tag_code  # type: str
        self.tag_metrics = tag_metrics  # type: str
        self.tag_value = tag_value  # type: str
        self.user_group_id = user_group_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListCorpGroupMetricsResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.corp_group_id is not None:
            result['CorpGroupId'] = self.corp_group_id
        if self.corp_id is not None:
            result['CorpId'] = self.corp_id
        if self.date_id is not None:
            result['DateId'] = self.date_id
        if self.device_group_id is not None:
            result['DeviceGroupId'] = self.device_group_id
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.person_id is not None:
            result['PersonID'] = self.person_id
        if self.tag_code is not None:
            result['TagCode'] = self.tag_code
        if self.tag_metrics is not None:
            result['TagMetrics'] = self.tag_metrics
        if self.tag_value is not None:
            result['TagValue'] = self.tag_value
        if self.user_group_id is not None:
            result['UserGroupId'] = self.user_group_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CorpGroupId') is not None:
            self.corp_group_id = m.get('CorpGroupId')
        if m.get('CorpId') is not None:
            self.corp_id = m.get('CorpId')
        if m.get('DateId') is not None:
            self.date_id = m.get('DateId')
        if m.get('DeviceGroupId') is not None:
            self.device_group_id = m.get('DeviceGroupId')
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('PersonID') is not None:
            self.person_id = m.get('PersonID')
        if m.get('TagCode') is not None:
            self.tag_code = m.get('TagCode')
        if m.get('TagMetrics') is not None:
            self.tag_metrics = m.get('TagMetrics')
        if m.get('TagValue') is not None:
            self.tag_value = m.get('TagValue')
        if m.get('UserGroupId') is not None:
            self.user_group_id = m.get('UserGroupId')
        return self


class ListCorpGroupMetricsResponseBody(TeaModel):
    def __init__(self, code=None, data=None, message=None, page_number=None, page_size=None, request_id=None,
                 success=None, total_count=None):
        self.code = code  # type: str
        self.data = data  # type: list[ListCorpGroupMetricsResponseBodyData]
        self.message = message  # type: str
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.request_id = request_id  # type: str
        self.success = success  # type: str
        self.total_count = total_count  # type: int

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListCorpGroupMetricsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        if self.message is not None:
            result['Message'] = self.message
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = ListCorpGroupMetricsResponseBodyData()
                self.data.append(temp_model.from_map(k))
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class ListCorpGroupMetricsResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: ListCorpGroupMetricsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListCorpGroupMetricsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListCorpGroupMetricsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListCorpGroupsRequest(TeaModel):
    def __init__(self, corp_id=None, page_number=None, page_size=None):
        self.corp_id = corp_id  # type: str
        self.page_number = page_number  # type: long
        self.page_size = page_size  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListCorpGroupsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.corp_id is not None:
            result['CorpId'] = self.corp_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CorpId') is not None:
            self.corp_id = m.get('CorpId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class ListCorpGroupsResponseBodyData(TeaModel):
    def __init__(self, page_number=None, page_size=None, records=None, total_count=None, total_page=None):
        self.page_number = page_number  # type: long
        self.page_size = page_size  # type: long
        self.records = records  # type: list[str]
        self.total_count = total_count  # type: long
        self.total_page = total_page  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListCorpGroupsResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.records is not None:
            result['Records'] = self.records
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.total_page is not None:
            result['TotalPage'] = self.total_page
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Records') is not None:
            self.records = m.get('Records')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('TotalPage') is not None:
            self.total_page = m.get('TotalPage')
        return self


class ListCorpGroupsResponseBody(TeaModel):
    def __init__(self, code=None, data=None, message=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: ListCorpGroupsResponseBodyData
        self.message = message  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(ListCorpGroupsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = ListCorpGroupsResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ListCorpGroupsResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: ListCorpGroupsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListCorpGroupsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListCorpGroupsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListCorpMetricsRequest(TeaModel):
    def __init__(self, corp_id=None, device_group_list=None, device_id_list=None, end_time=None, page_number=None,
                 page_size=None, start_time=None, tag_code=None, user_group_list=None):
        self.corp_id = corp_id  # type: str
        self.device_group_list = device_group_list  # type: str
        self.device_id_list = device_id_list  # type: str
        self.end_time = end_time  # type: str
        self.page_number = page_number  # type: str
        self.page_size = page_size  # type: str
        self.start_time = start_time  # type: str
        self.tag_code = tag_code  # type: str
        self.user_group_list = user_group_list  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListCorpMetricsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.corp_id is not None:
            result['CorpId'] = self.corp_id
        if self.device_group_list is not None:
            result['DeviceGroupList'] = self.device_group_list
        if self.device_id_list is not None:
            result['DeviceIdList'] = self.device_id_list
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.tag_code is not None:
            result['TagCode'] = self.tag_code
        if self.user_group_list is not None:
            result['UserGroupList'] = self.user_group_list
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CorpId') is not None:
            self.corp_id = m.get('CorpId')
        if m.get('DeviceGroupList') is not None:
            self.device_group_list = m.get('DeviceGroupList')
        if m.get('DeviceIdList') is not None:
            self.device_id_list = m.get('DeviceIdList')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('TagCode') is not None:
            self.tag_code = m.get('TagCode')
        if m.get('UserGroupList') is not None:
            self.user_group_list = m.get('UserGroupList')
        return self


class ListCorpMetricsResponseBodyData(TeaModel):
    def __init__(self, corp_id=None, date_id=None, device_group_id=None, device_id=None, person_id=None,
                 tag_code=None, tag_metrics=None, tag_value=None, user_group_id=None):
        self.corp_id = corp_id  # type: str
        self.date_id = date_id  # type: str
        self.device_group_id = device_group_id  # type: str
        self.device_id = device_id  # type: str
        self.person_id = person_id  # type: str
        self.tag_code = tag_code  # type: str
        self.tag_metrics = tag_metrics  # type: str
        self.tag_value = tag_value  # type: str
        self.user_group_id = user_group_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListCorpMetricsResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.corp_id is not None:
            result['CorpId'] = self.corp_id
        if self.date_id is not None:
            result['DateId'] = self.date_id
        if self.device_group_id is not None:
            result['DeviceGroupId'] = self.device_group_id
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.person_id is not None:
            result['PersonId'] = self.person_id
        if self.tag_code is not None:
            result['TagCode'] = self.tag_code
        if self.tag_metrics is not None:
            result['TagMetrics'] = self.tag_metrics
        if self.tag_value is not None:
            result['TagValue'] = self.tag_value
        if self.user_group_id is not None:
            result['UserGroupId'] = self.user_group_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CorpId') is not None:
            self.corp_id = m.get('CorpId')
        if m.get('DateId') is not None:
            self.date_id = m.get('DateId')
        if m.get('DeviceGroupId') is not None:
            self.device_group_id = m.get('DeviceGroupId')
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('PersonId') is not None:
            self.person_id = m.get('PersonId')
        if m.get('TagCode') is not None:
            self.tag_code = m.get('TagCode')
        if m.get('TagMetrics') is not None:
            self.tag_metrics = m.get('TagMetrics')
        if m.get('TagValue') is not None:
            self.tag_value = m.get('TagValue')
        if m.get('UserGroupId') is not None:
            self.user_group_id = m.get('UserGroupId')
        return self


class ListCorpMetricsResponseBody(TeaModel):
    def __init__(self, code=None, data=None, message=None, page_number=None, page_size=None, request_id=None,
                 success=None, total_count=None):
        self.code = code  # type: str
        self.data = data  # type: list[ListCorpMetricsResponseBodyData]
        self.message = message  # type: str
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.request_id = request_id  # type: str
        self.success = success  # type: str
        self.total_count = total_count  # type: int

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListCorpMetricsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        if self.message is not None:
            result['Message'] = self.message
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = ListCorpMetricsResponseBodyData()
                self.data.append(temp_model.from_map(k))
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class ListCorpMetricsResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: ListCorpMetricsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListCorpMetricsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListCorpMetricsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListCorpsRequest(TeaModel):
    def __init__(self, corp_name=None, page_number=None, page_size=None):
        self.corp_name = corp_name  # type: str
        # 页码
        self.page_number = page_number  # type: int
        # 分页大小
        self.page_size = page_size  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListCorpsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.corp_name is not None:
            result['CorpName'] = self.corp_name
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CorpName') is not None:
            self.corp_name = m.get('CorpName')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class ListCorpsResponseBodyDataRecords(TeaModel):
    def __init__(self, acu_used=None, app_name=None, corp_id=None, corp_name=None, create_date=None,
                 description=None, device_count=None, icon_path=None, isv_sub_id=None, parent_corp_id=None,
                 yoffline_acu_used=None):
        self.acu_used = acu_used  # type: int
        self.app_name = app_name  # type: str
        self.corp_id = corp_id  # type: str
        self.corp_name = corp_name  # type: str
        self.create_date = create_date  # type: str
        self.description = description  # type: str
        self.device_count = device_count  # type: int
        self.icon_path = icon_path  # type: str
        self.isv_sub_id = isv_sub_id  # type: str
        self.parent_corp_id = parent_corp_id  # type: str
        self.yoffline_acu_used = yoffline_acu_used  # type: float

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListCorpsResponseBodyDataRecords, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.acu_used is not None:
            result['AcuUsed'] = self.acu_used
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.corp_id is not None:
            result['CorpId'] = self.corp_id
        if self.corp_name is not None:
            result['CorpName'] = self.corp_name
        if self.create_date is not None:
            result['CreateDate'] = self.create_date
        if self.description is not None:
            result['Description'] = self.description
        if self.device_count is not None:
            result['DeviceCount'] = self.device_count
        if self.icon_path is not None:
            result['IconPath'] = self.icon_path
        if self.isv_sub_id is not None:
            result['IsvSubId'] = self.isv_sub_id
        if self.parent_corp_id is not None:
            result['ParentCorpId'] = self.parent_corp_id
        if self.yoffline_acu_used is not None:
            result['YOfflineAcuUsed'] = self.yoffline_acu_used
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AcuUsed') is not None:
            self.acu_used = m.get('AcuUsed')
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('CorpId') is not None:
            self.corp_id = m.get('CorpId')
        if m.get('CorpName') is not None:
            self.corp_name = m.get('CorpName')
        if m.get('CreateDate') is not None:
            self.create_date = m.get('CreateDate')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('DeviceCount') is not None:
            self.device_count = m.get('DeviceCount')
        if m.get('IconPath') is not None:
            self.icon_path = m.get('IconPath')
        if m.get('IsvSubId') is not None:
            self.isv_sub_id = m.get('IsvSubId')
        if m.get('ParentCorpId') is not None:
            self.parent_corp_id = m.get('ParentCorpId')
        if m.get('YOfflineAcuUsed') is not None:
            self.yoffline_acu_used = m.get('YOfflineAcuUsed')
        return self


class ListCorpsResponseBodyData(TeaModel):
    def __init__(self, page_number=None, page_size=None, records=None, total_count=None, total_page=None):
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.records = records  # type: list[ListCorpsResponseBodyDataRecords]
        self.total_count = total_count  # type: int
        self.total_page = total_page  # type: int

    def validate(self):
        if self.records:
            for k in self.records:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListCorpsResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        result['Records'] = []
        if self.records is not None:
            for k in self.records:
                result['Records'].append(k.to_map() if k else None)
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.total_page is not None:
            result['TotalPage'] = self.total_page
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        self.records = []
        if m.get('Records') is not None:
            for k in m.get('Records'):
                temp_model = ListCorpsResponseBodyDataRecords()
                self.records.append(temp_model.from_map(k))
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('TotalPage') is not None:
            self.total_page = m.get('TotalPage')
        return self


class ListCorpsResponseBody(TeaModel):
    def __init__(self, code=None, data=None, message=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: ListCorpsResponseBodyData
        self.message = message  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(ListCorpsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = ListCorpsResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ListCorpsResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: ListCorpsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListCorpsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListCorpsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListDeviceGroupsRequest(TeaModel):
    def __init__(self, corp_id_list=None, data_source_type=None, device_code_list=None, group=None, is_page=None,
                 name=None, page_num=None, page_size=None):
        self.corp_id_list = corp_id_list  # type: str
        self.data_source_type = data_source_type  # type: str
        self.device_code_list = device_code_list  # type: str
        self.group = group  # type: str
        self.is_page = is_page  # type: int
        self.name = name  # type: str
        self.page_num = page_num  # type: int
        self.page_size = page_size  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListDeviceGroupsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.corp_id_list is not None:
            result['CorpIdList'] = self.corp_id_list
        if self.data_source_type is not None:
            result['DataSourceType'] = self.data_source_type
        if self.device_code_list is not None:
            result['DeviceCodeList'] = self.device_code_list
        if self.group is not None:
            result['Group'] = self.group
        if self.is_page is not None:
            result['IsPage'] = self.is_page
        if self.name is not None:
            result['Name'] = self.name
        if self.page_num is not None:
            result['PageNum'] = self.page_num
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CorpIdList') is not None:
            self.corp_id_list = m.get('CorpIdList')
        if m.get('DataSourceType') is not None:
            self.data_source_type = m.get('DataSourceType')
        if m.get('DeviceCodeList') is not None:
            self.device_code_list = m.get('DeviceCodeList')
        if m.get('Group') is not None:
            self.group = m.get('Group')
        if m.get('IsPage') is not None:
            self.is_page = m.get('IsPage')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('PageNum') is not None:
            self.page_num = m.get('PageNum')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class ListDeviceGroupsResponseBodyDataList(TeaModel):
    def __init__(self, bit_rate=None, coding_format=None, data_source_type=None, device_code=None,
                 device_compute_status=None, device_group=None, device_name=None, device_sn=None, device_status=None,
                 device_stream_status=None, install_address=None, region_id=None, region_name=None, resolving_power=None, type=None):
        self.bit_rate = bit_rate  # type: str
        self.coding_format = coding_format  # type: str
        self.data_source_type = data_source_type  # type: str
        self.device_code = device_code  # type: str
        self.device_compute_status = device_compute_status  # type: str
        self.device_group = device_group  # type: str
        self.device_name = device_name  # type: str
        self.device_sn = device_sn  # type: str
        self.device_status = device_status  # type: str
        self.device_stream_status = device_stream_status  # type: str
        self.install_address = install_address  # type: str
        self.region_id = region_id  # type: str
        self.region_name = region_name  # type: str
        self.resolving_power = resolving_power  # type: str
        self.type = type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListDeviceGroupsResponseBodyDataList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bit_rate is not None:
            result['BitRate'] = self.bit_rate
        if self.coding_format is not None:
            result['CodingFormat'] = self.coding_format
        if self.data_source_type is not None:
            result['DataSourceType'] = self.data_source_type
        if self.device_code is not None:
            result['DeviceCode'] = self.device_code
        if self.device_compute_status is not None:
            result['DeviceComputeStatus'] = self.device_compute_status
        if self.device_group is not None:
            result['DeviceGroup'] = self.device_group
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.device_sn is not None:
            result['DeviceSn'] = self.device_sn
        if self.device_status is not None:
            result['DeviceStatus'] = self.device_status
        if self.device_stream_status is not None:
            result['DeviceStreamStatus'] = self.device_stream_status
        if self.install_address is not None:
            result['InstallAddress'] = self.install_address
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.region_name is not None:
            result['RegionName'] = self.region_name
        if self.resolving_power is not None:
            result['ResolvingPower'] = self.resolving_power
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BitRate') is not None:
            self.bit_rate = m.get('BitRate')
        if m.get('CodingFormat') is not None:
            self.coding_format = m.get('CodingFormat')
        if m.get('DataSourceType') is not None:
            self.data_source_type = m.get('DataSourceType')
        if m.get('DeviceCode') is not None:
            self.device_code = m.get('DeviceCode')
        if m.get('DeviceComputeStatus') is not None:
            self.device_compute_status = m.get('DeviceComputeStatus')
        if m.get('DeviceGroup') is not None:
            self.device_group = m.get('DeviceGroup')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('DeviceSn') is not None:
            self.device_sn = m.get('DeviceSn')
        if m.get('DeviceStatus') is not None:
            self.device_status = m.get('DeviceStatus')
        if m.get('DeviceStreamStatus') is not None:
            self.device_stream_status = m.get('DeviceStreamStatus')
        if m.get('InstallAddress') is not None:
            self.install_address = m.get('InstallAddress')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('RegionName') is not None:
            self.region_name = m.get('RegionName')
        if m.get('ResolvingPower') is not None:
            self.resolving_power = m.get('ResolvingPower')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class ListDeviceGroupsResponseBodyData(TeaModel):
    def __init__(self, list=None, total_count=None):
        self.list = list  # type: list[ListDeviceGroupsResponseBodyDataList]
        self.total_count = total_count  # type: str

    def validate(self):
        if self.list:
            for k in self.list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListDeviceGroupsResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['List'] = []
        if self.list is not None:
            for k in self.list:
                result['List'].append(k.to_map() if k else None)
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.list = []
        if m.get('List') is not None:
            for k in m.get('List'):
                temp_model = ListDeviceGroupsResponseBodyDataList()
                self.list.append(temp_model.from_map(k))
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class ListDeviceGroupsResponseBody(TeaModel):
    def __init__(self, code=None, data=None, message=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: list[ListDeviceGroupsResponseBodyData]
        self.message = message  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListDeviceGroupsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = ListDeviceGroupsResponseBodyData()
                self.data.append(temp_model.from_map(k))
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ListDeviceGroupsResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: ListDeviceGroupsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListDeviceGroupsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListDeviceGroupsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListDevicesRequest(TeaModel):
    def __init__(self, corp_id=None, device_name=None, gb_id=None, page_number=None, page_size=None):
        self.corp_id = corp_id  # type: str
        self.device_name = device_name  # type: str
        self.gb_id = gb_id  # type: str
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListDevicesRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.corp_id is not None:
            result['CorpId'] = self.corp_id
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.gb_id is not None:
            result['GbId'] = self.gb_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CorpId') is not None:
            self.corp_id = m.get('CorpId')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('GbId') is not None:
            self.gb_id = m.get('GbId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class ListDevicesResponseBodyDataRecords(TeaModel):
    def __init__(self, access_protocol_type=None, bit_rate=None, cover_image_url=None, create_time=None,
                 device_address=None, device_direction=None, device_name=None, device_site=None, device_type=None, gb_id=None,
                 latitude=None, longitude=None, resolution=None, sip_gbid=None, sip_password=None, sip_server_ip=None,
                 sip_server_port=None, status=None, vendor=None):
        self.access_protocol_type = access_protocol_type  # type: str
        self.bit_rate = bit_rate  # type: str
        self.cover_image_url = cover_image_url  # type: str
        self.create_time = create_time  # type: str
        self.device_address = device_address  # type: str
        self.device_direction = device_direction  # type: str
        self.device_name = device_name  # type: str
        self.device_site = device_site  # type: str
        self.device_type = device_type  # type: str
        self.gb_id = gb_id  # type: str
        self.latitude = latitude  # type: str
        self.longitude = longitude  # type: str
        self.resolution = resolution  # type: str
        self.sip_gbid = sip_gbid  # type: str
        self.sip_password = sip_password  # type: str
        self.sip_server_ip = sip_server_ip  # type: str
        self.sip_server_port = sip_server_port  # type: str
        self.status = status  # type: int
        self.vendor = vendor  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListDevicesResponseBodyDataRecords, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.access_protocol_type is not None:
            result['AccessProtocolType'] = self.access_protocol_type
        if self.bit_rate is not None:
            result['BitRate'] = self.bit_rate
        if self.cover_image_url is not None:
            result['CoverImageUrl'] = self.cover_image_url
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.device_address is not None:
            result['DeviceAddress'] = self.device_address
        if self.device_direction is not None:
            result['DeviceDirection'] = self.device_direction
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.device_site is not None:
            result['DeviceSite'] = self.device_site
        if self.device_type is not None:
            result['DeviceType'] = self.device_type
        if self.gb_id is not None:
            result['GbId'] = self.gb_id
        if self.latitude is not None:
            result['Latitude'] = self.latitude
        if self.longitude is not None:
            result['Longitude'] = self.longitude
        if self.resolution is not None:
            result['Resolution'] = self.resolution
        if self.sip_gbid is not None:
            result['SipGBId'] = self.sip_gbid
        if self.sip_password is not None:
            result['SipPassword'] = self.sip_password
        if self.sip_server_ip is not None:
            result['SipServerIp'] = self.sip_server_ip
        if self.sip_server_port is not None:
            result['SipServerPort'] = self.sip_server_port
        if self.status is not None:
            result['Status'] = self.status
        if self.vendor is not None:
            result['Vendor'] = self.vendor
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AccessProtocolType') is not None:
            self.access_protocol_type = m.get('AccessProtocolType')
        if m.get('BitRate') is not None:
            self.bit_rate = m.get('BitRate')
        if m.get('CoverImageUrl') is not None:
            self.cover_image_url = m.get('CoverImageUrl')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('DeviceAddress') is not None:
            self.device_address = m.get('DeviceAddress')
        if m.get('DeviceDirection') is not None:
            self.device_direction = m.get('DeviceDirection')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('DeviceSite') is not None:
            self.device_site = m.get('DeviceSite')
        if m.get('DeviceType') is not None:
            self.device_type = m.get('DeviceType')
        if m.get('GbId') is not None:
            self.gb_id = m.get('GbId')
        if m.get('Latitude') is not None:
            self.latitude = m.get('Latitude')
        if m.get('Longitude') is not None:
            self.longitude = m.get('Longitude')
        if m.get('Resolution') is not None:
            self.resolution = m.get('Resolution')
        if m.get('SipGBId') is not None:
            self.sip_gbid = m.get('SipGBId')
        if m.get('SipPassword') is not None:
            self.sip_password = m.get('SipPassword')
        if m.get('SipServerIp') is not None:
            self.sip_server_ip = m.get('SipServerIp')
        if m.get('SipServerPort') is not None:
            self.sip_server_port = m.get('SipServerPort')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Vendor') is not None:
            self.vendor = m.get('Vendor')
        return self


class ListDevicesResponseBodyData(TeaModel):
    def __init__(self, page_number=None, page_size=None, records=None, total_count=None, total_page=None):
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.records = records  # type: list[ListDevicesResponseBodyDataRecords]
        self.total_count = total_count  # type: int
        self.total_page = total_page  # type: int

    def validate(self):
        if self.records:
            for k in self.records:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListDevicesResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        result['Records'] = []
        if self.records is not None:
            for k in self.records:
                result['Records'].append(k.to_map() if k else None)
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.total_page is not None:
            result['TotalPage'] = self.total_page
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        self.records = []
        if m.get('Records') is not None:
            for k in m.get('Records'):
                temp_model = ListDevicesResponseBodyDataRecords()
                self.records.append(temp_model.from_map(k))
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('TotalPage') is not None:
            self.total_page = m.get('TotalPage')
        return self


class ListDevicesResponseBody(TeaModel):
    def __init__(self, code=None, data=None, message=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: ListDevicesResponseBodyData
        self.message = message  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(ListDevicesResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = ListDevicesResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ListDevicesResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: ListDevicesResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListDevicesResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListDevicesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListEventAlgorithmDetailsRequest(TeaModel):
    def __init__(self, corp_id=None, data_source_id=None, end_time=None, event_type=None, event_value=None,
                 extend_value=None, page_number=None, page_size=None, record_id=None, source_id=None, start_time=None):
        self.corp_id = corp_id  # type: str
        self.data_source_id = data_source_id  # type: str
        self.end_time = end_time  # type: str
        self.event_type = event_type  # type: str
        self.event_value = event_value  # type: str
        self.extend_value = extend_value  # type: str
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.record_id = record_id  # type: str
        self.source_id = source_id  # type: str
        self.start_time = start_time  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListEventAlgorithmDetailsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.corp_id is not None:
            result['CorpId'] = self.corp_id
        if self.data_source_id is not None:
            result['DataSourceId'] = self.data_source_id
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.event_type is not None:
            result['EventType'] = self.event_type
        if self.event_value is not None:
            result['EventValue'] = self.event_value
        if self.extend_value is not None:
            result['ExtendValue'] = self.extend_value
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.record_id is not None:
            result['RecordId'] = self.record_id
        if self.source_id is not None:
            result['SourceId'] = self.source_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CorpId') is not None:
            self.corp_id = m.get('CorpId')
        if m.get('DataSourceId') is not None:
            self.data_source_id = m.get('DataSourceId')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('EventType') is not None:
            self.event_type = m.get('EventType')
        if m.get('EventValue') is not None:
            self.event_value = m.get('EventValue')
        if m.get('ExtendValue') is not None:
            self.extend_value = m.get('ExtendValue')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RecordId') is not None:
            self.record_id = m.get('RecordId')
        if m.get('SourceId') is not None:
            self.source_id = m.get('SourceId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class ListEventAlgorithmDetailsResponseBodyData(TeaModel):
    def __init__(self, corp_id=None, data_source_id=None, event_type=None, event_value=None, extend_value=None,
                 extra_extend_value=None, face_count=None, left_top_x=None, left_top_y=None, pic_url_path=None, point_x=None,
                 point_y=None, record_id=None, right_bottom_x=None, right_bottom_y=None, shot_time=None, source_id=None,
                 tag_code=None, tag_code_reliability=None, target_pic_url_path=None, uuid_code=None):
        self.corp_id = corp_id  # type: str
        self.data_source_id = data_source_id  # type: str
        self.event_type = event_type  # type: str
        self.event_value = event_value  # type: str
        self.extend_value = extend_value  # type: str
        self.extra_extend_value = extra_extend_value  # type: str
        self.face_count = face_count  # type: str
        self.left_top_x = left_top_x  # type: str
        self.left_top_y = left_top_y  # type: str
        self.pic_url_path = pic_url_path  # type: str
        self.point_x = point_x  # type: str
        self.point_y = point_y  # type: str
        self.record_id = record_id  # type: str
        self.right_bottom_x = right_bottom_x  # type: str
        self.right_bottom_y = right_bottom_y  # type: str
        self.shot_time = shot_time  # type: str
        self.source_id = source_id  # type: str
        self.tag_code = tag_code  # type: str
        self.tag_code_reliability = tag_code_reliability  # type: str
        self.target_pic_url_path = target_pic_url_path  # type: str
        self.uuid_code = uuid_code  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListEventAlgorithmDetailsResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.corp_id is not None:
            result['CorpId'] = self.corp_id
        if self.data_source_id is not None:
            result['DataSourceId'] = self.data_source_id
        if self.event_type is not None:
            result['EventType'] = self.event_type
        if self.event_value is not None:
            result['EventValue'] = self.event_value
        if self.extend_value is not None:
            result['ExtendValue'] = self.extend_value
        if self.extra_extend_value is not None:
            result['ExtraExtendValue'] = self.extra_extend_value
        if self.face_count is not None:
            result['FaceCount'] = self.face_count
        if self.left_top_x is not None:
            result['LeftTopX'] = self.left_top_x
        if self.left_top_y is not None:
            result['LeftTopY'] = self.left_top_y
        if self.pic_url_path is not None:
            result['PicUrlPath'] = self.pic_url_path
        if self.point_x is not None:
            result['PointX'] = self.point_x
        if self.point_y is not None:
            result['PointY'] = self.point_y
        if self.record_id is not None:
            result['RecordId'] = self.record_id
        if self.right_bottom_x is not None:
            result['RightBottomX'] = self.right_bottom_x
        if self.right_bottom_y is not None:
            result['RightBottomY'] = self.right_bottom_y
        if self.shot_time is not None:
            result['ShotTime'] = self.shot_time
        if self.source_id is not None:
            result['SourceId'] = self.source_id
        if self.tag_code is not None:
            result['TagCode'] = self.tag_code
        if self.tag_code_reliability is not None:
            result['TagCodeReliability'] = self.tag_code_reliability
        if self.target_pic_url_path is not None:
            result['TargetPicUrlPath'] = self.target_pic_url_path
        if self.uuid_code is not None:
            result['UuidCode'] = self.uuid_code
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CorpId') is not None:
            self.corp_id = m.get('CorpId')
        if m.get('DataSourceId') is not None:
            self.data_source_id = m.get('DataSourceId')
        if m.get('EventType') is not None:
            self.event_type = m.get('EventType')
        if m.get('EventValue') is not None:
            self.event_value = m.get('EventValue')
        if m.get('ExtendValue') is not None:
            self.extend_value = m.get('ExtendValue')
        if m.get('ExtraExtendValue') is not None:
            self.extra_extend_value = m.get('ExtraExtendValue')
        if m.get('FaceCount') is not None:
            self.face_count = m.get('FaceCount')
        if m.get('LeftTopX') is not None:
            self.left_top_x = m.get('LeftTopX')
        if m.get('LeftTopY') is not None:
            self.left_top_y = m.get('LeftTopY')
        if m.get('PicUrlPath') is not None:
            self.pic_url_path = m.get('PicUrlPath')
        if m.get('PointX') is not None:
            self.point_x = m.get('PointX')
        if m.get('PointY') is not None:
            self.point_y = m.get('PointY')
        if m.get('RecordId') is not None:
            self.record_id = m.get('RecordId')
        if m.get('RightBottomX') is not None:
            self.right_bottom_x = m.get('RightBottomX')
        if m.get('RightBottomY') is not None:
            self.right_bottom_y = m.get('RightBottomY')
        if m.get('ShotTime') is not None:
            self.shot_time = m.get('ShotTime')
        if m.get('SourceId') is not None:
            self.source_id = m.get('SourceId')
        if m.get('TagCode') is not None:
            self.tag_code = m.get('TagCode')
        if m.get('TagCodeReliability') is not None:
            self.tag_code_reliability = m.get('TagCodeReliability')
        if m.get('TargetPicUrlPath') is not None:
            self.target_pic_url_path = m.get('TargetPicUrlPath')
        if m.get('UuidCode') is not None:
            self.uuid_code = m.get('UuidCode')
        return self


class ListEventAlgorithmDetailsResponseBody(TeaModel):
    def __init__(self, code=None, data=None, message=None, page_number=None, page_size=None, request_id=None,
                 success=None, total_count=None):
        self.code = code  # type: str
        self.data = data  # type: list[ListEventAlgorithmDetailsResponseBodyData]
        self.message = message  # type: str
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.request_id = request_id  # type: str
        self.success = success  # type: str
        self.total_count = total_count  # type: int

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListEventAlgorithmDetailsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        if self.message is not None:
            result['Message'] = self.message
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = ListEventAlgorithmDetailsResponseBodyData()
                self.data.append(temp_model.from_map(k))
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class ListEventAlgorithmDetailsResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: ListEventAlgorithmDetailsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListEventAlgorithmDetailsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListEventAlgorithmDetailsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListEventAlgorithmResultsRequest(TeaModel):
    def __init__(self, corp_id=None, data_source_id=None, end_time=None, event_type=None, extend_value=None,
                 page_number=None, page_size=None, start_time=None):
        self.corp_id = corp_id  # type: str
        self.data_source_id = data_source_id  # type: str
        self.end_time = end_time  # type: str
        self.event_type = event_type  # type: str
        self.extend_value = extend_value  # type: str
        self.page_number = page_number  # type: str
        self.page_size = page_size  # type: str
        self.start_time = start_time  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListEventAlgorithmResultsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.corp_id is not None:
            result['CorpId'] = self.corp_id
        if self.data_source_id is not None:
            result['DataSourceId'] = self.data_source_id
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.event_type is not None:
            result['EventType'] = self.event_type
        if self.extend_value is not None:
            result['ExtendValue'] = self.extend_value
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CorpId') is not None:
            self.corp_id = m.get('CorpId')
        if m.get('DataSourceId') is not None:
            self.data_source_id = m.get('DataSourceId')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('EventType') is not None:
            self.event_type = m.get('EventType')
        if m.get('ExtendValue') is not None:
            self.extend_value = m.get('ExtendValue')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class ListEventAlgorithmResultsResponseBodyDataRecords(TeaModel):
    def __init__(self, cap_style=None, corp_id=None, data_source_id=None, event_type=None, extend_value=None,
                 extend_value_three=None, extend_value_two=None, face_count=None, pic_url_path=None, record_id=None, shot_time=None,
                 tag_code=None, tag_code_reliability=None, target_pic_url_path=None, uuid_code=None):
        self.cap_style = cap_style  # type: str
        self.corp_id = corp_id  # type: str
        self.data_source_id = data_source_id  # type: str
        self.event_type = event_type  # type: str
        self.extend_value = extend_value  # type: str
        self.extend_value_three = extend_value_three  # type: str
        self.extend_value_two = extend_value_two  # type: str
        self.face_count = face_count  # type: str
        self.pic_url_path = pic_url_path  # type: str
        self.record_id = record_id  # type: str
        self.shot_time = shot_time  # type: str
        self.tag_code = tag_code  # type: str
        self.tag_code_reliability = tag_code_reliability  # type: str
        self.target_pic_url_path = target_pic_url_path  # type: str
        self.uuid_code = uuid_code  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListEventAlgorithmResultsResponseBodyDataRecords, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cap_style is not None:
            result['CapStyle'] = self.cap_style
        if self.corp_id is not None:
            result['CorpId'] = self.corp_id
        if self.data_source_id is not None:
            result['DataSourceId'] = self.data_source_id
        if self.event_type is not None:
            result['EventType'] = self.event_type
        if self.extend_value is not None:
            result['ExtendValue'] = self.extend_value
        if self.extend_value_three is not None:
            result['ExtendValueThree'] = self.extend_value_three
        if self.extend_value_two is not None:
            result['ExtendValueTwo'] = self.extend_value_two
        if self.face_count is not None:
            result['FaceCount'] = self.face_count
        if self.pic_url_path is not None:
            result['PicUrlPath'] = self.pic_url_path
        if self.record_id is not None:
            result['RecordId'] = self.record_id
        if self.shot_time is not None:
            result['ShotTime'] = self.shot_time
        if self.tag_code is not None:
            result['TagCode'] = self.tag_code
        if self.tag_code_reliability is not None:
            result['TagCodeReliability'] = self.tag_code_reliability
        if self.target_pic_url_path is not None:
            result['TargetPicUrlPath'] = self.target_pic_url_path
        if self.uuid_code is not None:
            result['UuidCode'] = self.uuid_code
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CapStyle') is not None:
            self.cap_style = m.get('CapStyle')
        if m.get('CorpId') is not None:
            self.corp_id = m.get('CorpId')
        if m.get('DataSourceId') is not None:
            self.data_source_id = m.get('DataSourceId')
        if m.get('EventType') is not None:
            self.event_type = m.get('EventType')
        if m.get('ExtendValue') is not None:
            self.extend_value = m.get('ExtendValue')
        if m.get('ExtendValueThree') is not None:
            self.extend_value_three = m.get('ExtendValueThree')
        if m.get('ExtendValueTwo') is not None:
            self.extend_value_two = m.get('ExtendValueTwo')
        if m.get('FaceCount') is not None:
            self.face_count = m.get('FaceCount')
        if m.get('PicUrlPath') is not None:
            self.pic_url_path = m.get('PicUrlPath')
        if m.get('RecordId') is not None:
            self.record_id = m.get('RecordId')
        if m.get('ShotTime') is not None:
            self.shot_time = m.get('ShotTime')
        if m.get('TagCode') is not None:
            self.tag_code = m.get('TagCode')
        if m.get('TagCodeReliability') is not None:
            self.tag_code_reliability = m.get('TagCodeReliability')
        if m.get('TargetPicUrlPath') is not None:
            self.target_pic_url_path = m.get('TargetPicUrlPath')
        if m.get('UuidCode') is not None:
            self.uuid_code = m.get('UuidCode')
        return self


class ListEventAlgorithmResultsResponseBodyData(TeaModel):
    def __init__(self, page_number=None, page_size=None, records=None, total_count=None, total_page=None):
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.records = records  # type: list[ListEventAlgorithmResultsResponseBodyDataRecords]
        self.total_count = total_count  # type: int
        self.total_page = total_page  # type: int

    def validate(self):
        if self.records:
            for k in self.records:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListEventAlgorithmResultsResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        result['Records'] = []
        if self.records is not None:
            for k in self.records:
                result['Records'].append(k.to_map() if k else None)
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.total_page is not None:
            result['TotalPage'] = self.total_page
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        self.records = []
        if m.get('Records') is not None:
            for k in m.get('Records'):
                temp_model = ListEventAlgorithmResultsResponseBodyDataRecords()
                self.records.append(temp_model.from_map(k))
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('TotalPage') is not None:
            self.total_page = m.get('TotalPage')
        return self


class ListEventAlgorithmResultsResponseBody(TeaModel):
    def __init__(self, code=None, data=None, extend_value=None, message=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: ListEventAlgorithmResultsResponseBodyData
        self.extend_value = extend_value  # type: str
        self.message = message  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(ListEventAlgorithmResultsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.extend_value is not None:
            result['ExtendValue'] = self.extend_value
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = ListEventAlgorithmResultsResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('ExtendValue') is not None:
            self.extend_value = m.get('ExtendValue')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ListEventAlgorithmResultsResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: ListEventAlgorithmResultsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListEventAlgorithmResultsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListEventAlgorithmResultsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListFaceAlgorithmResultsRequest(TeaModel):
    def __init__(self, algorithm_type=None, corp_id=None, data_source_id=None, end_time=None, page_number=None,
                 page_size=None, start_time=None):
        self.algorithm_type = algorithm_type  # type: str
        self.corp_id = corp_id  # type: str
        self.data_source_id = data_source_id  # type: str
        self.end_time = end_time  # type: str
        self.page_number = page_number  # type: str
        self.page_size = page_size  # type: str
        self.start_time = start_time  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListFaceAlgorithmResultsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.algorithm_type is not None:
            result['AlgorithmType'] = self.algorithm_type
        if self.corp_id is not None:
            result['CorpId'] = self.corp_id
        if self.data_source_id is not None:
            result['DataSourceId'] = self.data_source_id
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AlgorithmType') is not None:
            self.algorithm_type = m.get('AlgorithmType')
        if m.get('CorpId') is not None:
            self.corp_id = m.get('CorpId')
        if m.get('DataSourceId') is not None:
            self.data_source_id = m.get('DataSourceId')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class ListFaceAlgorithmResultsResponseBodyDataRecords(TeaModel):
    def __init__(self, cap_style=None, corp_id=None, data_source_id=None, face_id=None, gender_code=None,
                 hair_style=None, left_top_x=None, left_top_y=None, max_age=None, min_age=None, pic_url_path=None,
                 right_bottom_x=None, right_bottom_y=None, shot_time=None, source_id=None, target_pic_url_path=None):
        self.cap_style = cap_style  # type: str
        self.corp_id = corp_id  # type: str
        self.data_source_id = data_source_id  # type: str
        self.face_id = face_id  # type: str
        self.gender_code = gender_code  # type: str
        self.hair_style = hair_style  # type: str
        self.left_top_x = left_top_x  # type: float
        self.left_top_y = left_top_y  # type: float
        self.max_age = max_age  # type: str
        self.min_age = min_age  # type: str
        self.pic_url_path = pic_url_path  # type: str
        self.right_bottom_x = right_bottom_x  # type: float
        self.right_bottom_y = right_bottom_y  # type: float
        self.shot_time = shot_time  # type: str
        self.source_id = source_id  # type: str
        self.target_pic_url_path = target_pic_url_path  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListFaceAlgorithmResultsResponseBodyDataRecords, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cap_style is not None:
            result['CapStyle'] = self.cap_style
        if self.corp_id is not None:
            result['CorpId'] = self.corp_id
        if self.data_source_id is not None:
            result['DataSourceId'] = self.data_source_id
        if self.face_id is not None:
            result['FaceId'] = self.face_id
        if self.gender_code is not None:
            result['GenderCode'] = self.gender_code
        if self.hair_style is not None:
            result['HairStyle'] = self.hair_style
        if self.left_top_x is not None:
            result['LeftTopX'] = self.left_top_x
        if self.left_top_y is not None:
            result['LeftTopY'] = self.left_top_y
        if self.max_age is not None:
            result['MaxAge'] = self.max_age
        if self.min_age is not None:
            result['MinAge'] = self.min_age
        if self.pic_url_path is not None:
            result['PicUrlPath'] = self.pic_url_path
        if self.right_bottom_x is not None:
            result['RightBottomX'] = self.right_bottom_x
        if self.right_bottom_y is not None:
            result['RightBottomY'] = self.right_bottom_y
        if self.shot_time is not None:
            result['ShotTime'] = self.shot_time
        if self.source_id is not None:
            result['SourceId'] = self.source_id
        if self.target_pic_url_path is not None:
            result['TargetPicUrlPath'] = self.target_pic_url_path
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CapStyle') is not None:
            self.cap_style = m.get('CapStyle')
        if m.get('CorpId') is not None:
            self.corp_id = m.get('CorpId')
        if m.get('DataSourceId') is not None:
            self.data_source_id = m.get('DataSourceId')
        if m.get('FaceId') is not None:
            self.face_id = m.get('FaceId')
        if m.get('GenderCode') is not None:
            self.gender_code = m.get('GenderCode')
        if m.get('HairStyle') is not None:
            self.hair_style = m.get('HairStyle')
        if m.get('LeftTopX') is not None:
            self.left_top_x = m.get('LeftTopX')
        if m.get('LeftTopY') is not None:
            self.left_top_y = m.get('LeftTopY')
        if m.get('MaxAge') is not None:
            self.max_age = m.get('MaxAge')
        if m.get('MinAge') is not None:
            self.min_age = m.get('MinAge')
        if m.get('PicUrlPath') is not None:
            self.pic_url_path = m.get('PicUrlPath')
        if m.get('RightBottomX') is not None:
            self.right_bottom_x = m.get('RightBottomX')
        if m.get('RightBottomY') is not None:
            self.right_bottom_y = m.get('RightBottomY')
        if m.get('ShotTime') is not None:
            self.shot_time = m.get('ShotTime')
        if m.get('SourceId') is not None:
            self.source_id = m.get('SourceId')
        if m.get('TargetPicUrlPath') is not None:
            self.target_pic_url_path = m.get('TargetPicUrlPath')
        return self


class ListFaceAlgorithmResultsResponseBodyData(TeaModel):
    def __init__(self, page_number=None, page_size=None, records=None, total_count=None, total_page=None):
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.records = records  # type: list[ListFaceAlgorithmResultsResponseBodyDataRecords]
        self.total_count = total_count  # type: int
        self.total_page = total_page  # type: int

    def validate(self):
        if self.records:
            for k in self.records:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListFaceAlgorithmResultsResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        result['Records'] = []
        if self.records is not None:
            for k in self.records:
                result['Records'].append(k.to_map() if k else None)
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.total_page is not None:
            result['TotalPage'] = self.total_page
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        self.records = []
        if m.get('Records') is not None:
            for k in m.get('Records'):
                temp_model = ListFaceAlgorithmResultsResponseBodyDataRecords()
                self.records.append(temp_model.from_map(k))
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('TotalPage') is not None:
            self.total_page = m.get('TotalPage')
        return self


class ListFaceAlgorithmResultsResponseBody(TeaModel):
    def __init__(self, code=None, data=None, message=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: ListFaceAlgorithmResultsResponseBodyData
        self.message = message  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(ListFaceAlgorithmResultsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = ListFaceAlgorithmResultsResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ListFaceAlgorithmResultsResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: ListFaceAlgorithmResultsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListFaceAlgorithmResultsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListFaceAlgorithmResultsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListInstancesRequest(TeaModel):
    def __init__(self, current_page=None, instance_name=None, page_size=None, project_id=None):
        self.current_page = current_page  # type: int
        self.instance_name = instance_name  # type: str
        self.page_size = page_size  # type: int
        self.project_id = project_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListInstancesRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.instance_name is not None:
            result['InstanceName'] = self.instance_name
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('InstanceName') is not None:
            self.instance_name = m.get('InstanceName')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        return self


class ListInstancesResponseBodyDataItemsAlgorithms(TeaModel):
    def __init__(self, algorithm_id=None, algorithm_name=None):
        self.algorithm_id = algorithm_id  # type: str
        self.algorithm_name = algorithm_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListInstancesResponseBodyDataItemsAlgorithms, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.algorithm_id is not None:
            result['AlgorithmId'] = self.algorithm_id
        if self.algorithm_name is not None:
            result['AlgorithmName'] = self.algorithm_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AlgorithmId') is not None:
            self.algorithm_id = m.get('AlgorithmId')
        if m.get('AlgorithmName') is not None:
            self.algorithm_name = m.get('AlgorithmName')
        return self


class ListInstancesResponseBodyDataItems(TeaModel):
    def __init__(self, acu_used=None, algorithms=None, create_time=None, device_number=None, instance_id=None,
                 instance_name=None, status=None):
        self.acu_used = acu_used  # type: int
        self.algorithms = algorithms  # type: list[ListInstancesResponseBodyDataItemsAlgorithms]
        self.create_time = create_time  # type: long
        self.device_number = device_number  # type: int
        self.instance_id = instance_id  # type: str
        self.instance_name = instance_name  # type: str
        self.status = status  # type: str

    def validate(self):
        if self.algorithms:
            for k in self.algorithms:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListInstancesResponseBodyDataItems, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.acu_used is not None:
            result['AcuUsed'] = self.acu_used
        result['Algorithms'] = []
        if self.algorithms is not None:
            for k in self.algorithms:
                result['Algorithms'].append(k.to_map() if k else None)
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.device_number is not None:
            result['DeviceNumber'] = self.device_number
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.instance_name is not None:
            result['InstanceName'] = self.instance_name
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AcuUsed') is not None:
            self.acu_used = m.get('AcuUsed')
        self.algorithms = []
        if m.get('Algorithms') is not None:
            for k in m.get('Algorithms'):
                temp_model = ListInstancesResponseBodyDataItemsAlgorithms()
                self.algorithms.append(temp_model.from_map(k))
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('DeviceNumber') is not None:
            self.device_number = m.get('DeviceNumber')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('InstanceName') is not None:
            self.instance_name = m.get('InstanceName')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class ListInstancesResponseBodyData(TeaModel):
    def __init__(self, current_page=None, items=None, page_size=None, total_count=None):
        self.current_page = current_page  # type: int
        self.items = items  # type: list[ListInstancesResponseBodyDataItems]
        self.page_size = page_size  # type: int
        self.total_count = total_count  # type: int

    def validate(self):
        if self.items:
            for k in self.items:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListInstancesResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        result['Items'] = []
        if self.items is not None:
            for k in self.items:
                result['Items'].append(k.to_map() if k else None)
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        self.items = []
        if m.get('Items') is not None:
            for k in m.get('Items'):
                temp_model = ListInstancesResponseBodyDataItems()
                self.items.append(temp_model.from_map(k))
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class ListInstancesResponseBody(TeaModel):
    def __init__(self, code=None, data=None, message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data = data  # type: ListInstancesResponseBodyData
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(ListInstancesResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = ListInstancesResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class ListInstancesResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: ListInstancesResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListInstancesResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListInstancesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListMetricsRequest(TeaModel):
    def __init__(self, aggregate_type=None, corp_id=None, end_time=None, page_number=None, page_size=None,
                 start_time=None, tag_code=None):
        self.aggregate_type = aggregate_type  # type: str
        self.corp_id = corp_id  # type: str
        self.end_time = end_time  # type: str
        self.page_number = page_number  # type: str
        self.page_size = page_size  # type: str
        self.start_time = start_time  # type: str
        self.tag_code = tag_code  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListMetricsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.aggregate_type is not None:
            result['AggregateType'] = self.aggregate_type
        if self.corp_id is not None:
            result['CorpId'] = self.corp_id
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.tag_code is not None:
            result['TagCode'] = self.tag_code
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AggregateType') is not None:
            self.aggregate_type = m.get('AggregateType')
        if m.get('CorpId') is not None:
            self.corp_id = m.get('CorpId')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('TagCode') is not None:
            self.tag_code = m.get('TagCode')
        return self


class ListMetricsResponseBodyDataRecords(TeaModel):
    def __init__(self, date_time=None, tag_code=None, tag_metric=None, tag_value=None):
        self.date_time = date_time  # type: str
        self.tag_code = tag_code  # type: str
        self.tag_metric = tag_metric  # type: str
        self.tag_value = tag_value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListMetricsResponseBodyDataRecords, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.date_time is not None:
            result['DateTime'] = self.date_time
        if self.tag_code is not None:
            result['TagCode'] = self.tag_code
        if self.tag_metric is not None:
            result['TagMetric'] = self.tag_metric
        if self.tag_value is not None:
            result['TagValue'] = self.tag_value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DateTime') is not None:
            self.date_time = m.get('DateTime')
        if m.get('TagCode') is not None:
            self.tag_code = m.get('TagCode')
        if m.get('TagMetric') is not None:
            self.tag_metric = m.get('TagMetric')
        if m.get('TagValue') is not None:
            self.tag_value = m.get('TagValue')
        return self


class ListMetricsResponseBodyData(TeaModel):
    def __init__(self, page_number=None, page_size=None, records=None, total_count=None, total_page=None):
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.records = records  # type: list[ListMetricsResponseBodyDataRecords]
        self.total_count = total_count  # type: int
        self.total_page = total_page  # type: int

    def validate(self):
        if self.records:
            for k in self.records:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListMetricsResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        result['Records'] = []
        if self.records is not None:
            for k in self.records:
                result['Records'].append(k.to_map() if k else None)
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.total_page is not None:
            result['TotalPage'] = self.total_page
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        self.records = []
        if m.get('Records') is not None:
            for k in m.get('Records'):
                temp_model = ListMetricsResponseBodyDataRecords()
                self.records.append(temp_model.from_map(k))
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('TotalPage') is not None:
            self.total_page = m.get('TotalPage')
        return self


class ListMetricsResponseBody(TeaModel):
    def __init__(self, code=None, data=None, message=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: ListMetricsResponseBodyData
        self.message = message  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(ListMetricsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = ListMetricsResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ListMetricsResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: ListMetricsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListMetricsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListMetricsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListMotorAlgorithmResultsRequest(TeaModel):
    def __init__(self, algorithm_type=None, corp_id=None, data_source_id=None, end_time=None, page_number=None,
                 page_size=None, plate_number=None, start_time=None):
        self.algorithm_type = algorithm_type  # type: str
        self.corp_id = corp_id  # type: str
        self.data_source_id = data_source_id  # type: str
        self.end_time = end_time  # type: str
        self.page_number = page_number  # type: str
        self.page_size = page_size  # type: str
        self.plate_number = plate_number  # type: str
        self.start_time = start_time  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListMotorAlgorithmResultsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.algorithm_type is not None:
            result['AlgorithmType'] = self.algorithm_type
        if self.corp_id is not None:
            result['CorpId'] = self.corp_id
        if self.data_source_id is not None:
            result['DataSourceId'] = self.data_source_id
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.plate_number is not None:
            result['PlateNumber'] = self.plate_number
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AlgorithmType') is not None:
            self.algorithm_type = m.get('AlgorithmType')
        if m.get('CorpId') is not None:
            self.corp_id = m.get('CorpId')
        if m.get('DataSourceId') is not None:
            self.data_source_id = m.get('DataSourceId')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('PlateNumber') is not None:
            self.plate_number = m.get('PlateNumber')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class ListMotorAlgorithmResultsResponseBodyDataRecords(TeaModel):
    def __init__(self, calling=None, corp_id=None, data_source_id=None, left_top_x=None, left_top_y=None,
                 motor_brand=None, motor_class=None, motor_color=None, motor_id=None, motor_model=None, motor_style=None,
                 pic_url_path=None, plate_class=None, plate_color=None, plate_number=None, right_bottom_x=None,
                 right_bottom_y=None, safety_belt=None, shot_time=None, source_id=None, target_pic_url_path=None):
        self.calling = calling  # type: str
        self.corp_id = corp_id  # type: str
        self.data_source_id = data_source_id  # type: str
        self.left_top_x = left_top_x  # type: float
        self.left_top_y = left_top_y  # type: float
        self.motor_brand = motor_brand  # type: str
        self.motor_class = motor_class  # type: str
        self.motor_color = motor_color  # type: str
        self.motor_id = motor_id  # type: str
        self.motor_model = motor_model  # type: str
        self.motor_style = motor_style  # type: str
        self.pic_url_path = pic_url_path  # type: str
        self.plate_class = plate_class  # type: str
        self.plate_color = plate_color  # type: str
        self.plate_number = plate_number  # type: str
        self.right_bottom_x = right_bottom_x  # type: float
        self.right_bottom_y = right_bottom_y  # type: float
        self.safety_belt = safety_belt  # type: str
        self.shot_time = shot_time  # type: str
        self.source_id = source_id  # type: str
        self.target_pic_url_path = target_pic_url_path  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListMotorAlgorithmResultsResponseBodyDataRecords, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.calling is not None:
            result['Calling'] = self.calling
        if self.corp_id is not None:
            result['CorpId'] = self.corp_id
        if self.data_source_id is not None:
            result['DataSourceId'] = self.data_source_id
        if self.left_top_x is not None:
            result['LeftTopX'] = self.left_top_x
        if self.left_top_y is not None:
            result['LeftTopY'] = self.left_top_y
        if self.motor_brand is not None:
            result['MotorBrand'] = self.motor_brand
        if self.motor_class is not None:
            result['MotorClass'] = self.motor_class
        if self.motor_color is not None:
            result['MotorColor'] = self.motor_color
        if self.motor_id is not None:
            result['MotorId'] = self.motor_id
        if self.motor_model is not None:
            result['MotorModel'] = self.motor_model
        if self.motor_style is not None:
            result['MotorStyle'] = self.motor_style
        if self.pic_url_path is not None:
            result['PicUrlPath'] = self.pic_url_path
        if self.plate_class is not None:
            result['PlateClass'] = self.plate_class
        if self.plate_color is not None:
            result['PlateColor'] = self.plate_color
        if self.plate_number is not None:
            result['PlateNumber'] = self.plate_number
        if self.right_bottom_x is not None:
            result['RightBottomX'] = self.right_bottom_x
        if self.right_bottom_y is not None:
            result['RightBottomY'] = self.right_bottom_y
        if self.safety_belt is not None:
            result['SafetyBelt'] = self.safety_belt
        if self.shot_time is not None:
            result['ShotTime'] = self.shot_time
        if self.source_id is not None:
            result['SourceId'] = self.source_id
        if self.target_pic_url_path is not None:
            result['TargetPicUrlPath'] = self.target_pic_url_path
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Calling') is not None:
            self.calling = m.get('Calling')
        if m.get('CorpId') is not None:
            self.corp_id = m.get('CorpId')
        if m.get('DataSourceId') is not None:
            self.data_source_id = m.get('DataSourceId')
        if m.get('LeftTopX') is not None:
            self.left_top_x = m.get('LeftTopX')
        if m.get('LeftTopY') is not None:
            self.left_top_y = m.get('LeftTopY')
        if m.get('MotorBrand') is not None:
            self.motor_brand = m.get('MotorBrand')
        if m.get('MotorClass') is not None:
            self.motor_class = m.get('MotorClass')
        if m.get('MotorColor') is not None:
            self.motor_color = m.get('MotorColor')
        if m.get('MotorId') is not None:
            self.motor_id = m.get('MotorId')
        if m.get('MotorModel') is not None:
            self.motor_model = m.get('MotorModel')
        if m.get('MotorStyle') is not None:
            self.motor_style = m.get('MotorStyle')
        if m.get('PicUrlPath') is not None:
            self.pic_url_path = m.get('PicUrlPath')
        if m.get('PlateClass') is not None:
            self.plate_class = m.get('PlateClass')
        if m.get('PlateColor') is not None:
            self.plate_color = m.get('PlateColor')
        if m.get('PlateNumber') is not None:
            self.plate_number = m.get('PlateNumber')
        if m.get('RightBottomX') is not None:
            self.right_bottom_x = m.get('RightBottomX')
        if m.get('RightBottomY') is not None:
            self.right_bottom_y = m.get('RightBottomY')
        if m.get('SafetyBelt') is not None:
            self.safety_belt = m.get('SafetyBelt')
        if m.get('ShotTime') is not None:
            self.shot_time = m.get('ShotTime')
        if m.get('SourceId') is not None:
            self.source_id = m.get('SourceId')
        if m.get('TargetPicUrlPath') is not None:
            self.target_pic_url_path = m.get('TargetPicUrlPath')
        return self


class ListMotorAlgorithmResultsResponseBodyData(TeaModel):
    def __init__(self, page_number=None, page_size=None, records=None, total_count=None, total_page=None):
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.records = records  # type: list[ListMotorAlgorithmResultsResponseBodyDataRecords]
        self.total_count = total_count  # type: int
        self.total_page = total_page  # type: int

    def validate(self):
        if self.records:
            for k in self.records:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListMotorAlgorithmResultsResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        result['Records'] = []
        if self.records is not None:
            for k in self.records:
                result['Records'].append(k.to_map() if k else None)
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.total_page is not None:
            result['TotalPage'] = self.total_page
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        self.records = []
        if m.get('Records') is not None:
            for k in m.get('Records'):
                temp_model = ListMotorAlgorithmResultsResponseBodyDataRecords()
                self.records.append(temp_model.from_map(k))
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('TotalPage') is not None:
            self.total_page = m.get('TotalPage')
        return self


class ListMotorAlgorithmResultsResponseBody(TeaModel):
    def __init__(self, code=None, data=None, message=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: ListMotorAlgorithmResultsResponseBodyData
        self.message = message  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(ListMotorAlgorithmResultsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = ListMotorAlgorithmResultsResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ListMotorAlgorithmResultsResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: ListMotorAlgorithmResultsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListMotorAlgorithmResultsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListMotorAlgorithmResultsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListNVRChannelDeviceRequest(TeaModel):
    def __init__(self, device_code=None, is_page=None, page_num=None, page_size=None):
        self.device_code = device_code  # type: str
        self.is_page = is_page  # type: str
        self.page_num = page_num  # type: str
        self.page_size = page_size  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListNVRChannelDeviceRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_code is not None:
            result['DeviceCode'] = self.device_code
        if self.is_page is not None:
            result['IsPage'] = self.is_page
        if self.page_num is not None:
            result['PageNum'] = self.page_num
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DeviceCode') is not None:
            self.device_code = m.get('DeviceCode')
        if m.get('IsPage') is not None:
            self.is_page = m.get('IsPage')
        if m.get('PageNum') is not None:
            self.page_num = m.get('PageNum')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class ListNVRChannelDeviceResponseBodyData(TeaModel):
    def __init__(self, compture_status=None, corp_id=None, datasource_type=None, device_code=None, device_name=None,
                 device_sn=None, device_status=None, device_type=None, project_name=None, region_name=None, sample_name=None,
                 stream_status=None, vap=None):
        self.compture_status = compture_status  # type: str
        self.corp_id = corp_id  # type: str
        self.datasource_type = datasource_type  # type: str
        self.device_code = device_code  # type: str
        self.device_name = device_name  # type: str
        self.device_sn = device_sn  # type: str
        self.device_status = device_status  # type: str
        self.device_type = device_type  # type: str
        self.project_name = project_name  # type: str
        self.region_name = region_name  # type: str
        self.sample_name = sample_name  # type: str
        self.stream_status = stream_status  # type: str
        self.vap = vap  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListNVRChannelDeviceResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.compture_status is not None:
            result['ComptureStatus'] = self.compture_status
        if self.corp_id is not None:
            result['CorpId'] = self.corp_id
        if self.datasource_type is not None:
            result['DatasourceType'] = self.datasource_type
        if self.device_code is not None:
            result['DeviceCode'] = self.device_code
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.device_sn is not None:
            result['DeviceSn'] = self.device_sn
        if self.device_status is not None:
            result['DeviceStatus'] = self.device_status
        if self.device_type is not None:
            result['DeviceType'] = self.device_type
        if self.project_name is not None:
            result['ProjectName'] = self.project_name
        if self.region_name is not None:
            result['RegionName'] = self.region_name
        if self.sample_name is not None:
            result['SampleName'] = self.sample_name
        if self.stream_status is not None:
            result['StreamStatus'] = self.stream_status
        if self.vap is not None:
            result['Vap'] = self.vap
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ComptureStatus') is not None:
            self.compture_status = m.get('ComptureStatus')
        if m.get('CorpId') is not None:
            self.corp_id = m.get('CorpId')
        if m.get('DatasourceType') is not None:
            self.datasource_type = m.get('DatasourceType')
        if m.get('DeviceCode') is not None:
            self.device_code = m.get('DeviceCode')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('DeviceSn') is not None:
            self.device_sn = m.get('DeviceSn')
        if m.get('DeviceStatus') is not None:
            self.device_status = m.get('DeviceStatus')
        if m.get('DeviceType') is not None:
            self.device_type = m.get('DeviceType')
        if m.get('ProjectName') is not None:
            self.project_name = m.get('ProjectName')
        if m.get('RegionName') is not None:
            self.region_name = m.get('RegionName')
        if m.get('SampleName') is not None:
            self.sample_name = m.get('SampleName')
        if m.get('StreamStatus') is not None:
            self.stream_status = m.get('StreamStatus')
        if m.get('Vap') is not None:
            self.vap = m.get('Vap')
        return self


class ListNVRChannelDeviceResponseBody(TeaModel):
    def __init__(self, data=None, message=None, request_id=None, success=None, total=None):
        self.data = data  # type: list[ListNVRChannelDeviceResponseBodyData]
        self.message = message  # type: str
        # Id of the request
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.total = total  # type: str

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListNVRChannelDeviceResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = ListNVRChannelDeviceResponseBodyData()
                self.data.append(temp_model.from_map(k))
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class ListNVRChannelDeviceResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: ListNVRChannelDeviceResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListNVRChannelDeviceResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListNVRChannelDeviceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListNVRDeviceRequest(TeaModel):
    def __init__(self, corp_id_list=None, device_code=None, is_page=None, page_num=None, page_size=None):
        self.corp_id_list = corp_id_list  # type: str
        self.device_code = device_code  # type: str
        self.is_page = is_page  # type: long
        self.page_num = page_num  # type: long
        self.page_size = page_size  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListNVRDeviceRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.corp_id_list is not None:
            result['CorpIdList'] = self.corp_id_list
        if self.device_code is not None:
            result['DeviceCode'] = self.device_code
        if self.is_page is not None:
            result['IsPage'] = self.is_page
        if self.page_num is not None:
            result['PageNum'] = self.page_num
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CorpIdList') is not None:
            self.corp_id_list = m.get('CorpIdList')
        if m.get('DeviceCode') is not None:
            self.device_code = m.get('DeviceCode')
        if m.get('IsPage') is not None:
            self.is_page = m.get('IsPage')
        if m.get('PageNum') is not None:
            self.page_num = m.get('PageNum')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class ListNVRDeviceResponseBodyData(TeaModel):
    def __init__(self, access_quota=None, channel=None, compture_status=None, corp_id=None, datasource_type=None,
                 device_code=None, device_name=None, device_sn=None, device_status=None, device_type=None, project_name=None,
                 region_name=None, registration_time=None, stream_status=None, type=None):
        self.access_quota = access_quota  # type: str
        self.channel = channel  # type: str
        self.compture_status = compture_status  # type: str
        self.corp_id = corp_id  # type: str
        self.datasource_type = datasource_type  # type: str
        self.device_code = device_code  # type: str
        self.device_name = device_name  # type: str
        self.device_sn = device_sn  # type: str
        self.device_status = device_status  # type: str
        self.device_type = device_type  # type: str
        self.project_name = project_name  # type: str
        self.region_name = region_name  # type: str
        self.registration_time = registration_time  # type: str
        self.stream_status = stream_status  # type: str
        self.type = type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListNVRDeviceResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.access_quota is not None:
            result['AccessQuota'] = self.access_quota
        if self.channel is not None:
            result['Channel'] = self.channel
        if self.compture_status is not None:
            result['ComptureStatus'] = self.compture_status
        if self.corp_id is not None:
            result['CorpId'] = self.corp_id
        if self.datasource_type is not None:
            result['DatasourceType'] = self.datasource_type
        if self.device_code is not None:
            result['DeviceCode'] = self.device_code
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.device_sn is not None:
            result['DeviceSn'] = self.device_sn
        if self.device_status is not None:
            result['DeviceStatus'] = self.device_status
        if self.device_type is not None:
            result['DeviceType'] = self.device_type
        if self.project_name is not None:
            result['ProjectName'] = self.project_name
        if self.region_name is not None:
            result['RegionName'] = self.region_name
        if self.registration_time is not None:
            result['RegistrationTime'] = self.registration_time
        if self.stream_status is not None:
            result['StreamStatus'] = self.stream_status
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AccessQuota') is not None:
            self.access_quota = m.get('AccessQuota')
        if m.get('Channel') is not None:
            self.channel = m.get('Channel')
        if m.get('ComptureStatus') is not None:
            self.compture_status = m.get('ComptureStatus')
        if m.get('CorpId') is not None:
            self.corp_id = m.get('CorpId')
        if m.get('DatasourceType') is not None:
            self.datasource_type = m.get('DatasourceType')
        if m.get('DeviceCode') is not None:
            self.device_code = m.get('DeviceCode')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('DeviceSn') is not None:
            self.device_sn = m.get('DeviceSn')
        if m.get('DeviceStatus') is not None:
            self.device_status = m.get('DeviceStatus')
        if m.get('DeviceType') is not None:
            self.device_type = m.get('DeviceType')
        if m.get('ProjectName') is not None:
            self.project_name = m.get('ProjectName')
        if m.get('RegionName') is not None:
            self.region_name = m.get('RegionName')
        if m.get('RegistrationTime') is not None:
            self.registration_time = m.get('RegistrationTime')
        if m.get('StreamStatus') is not None:
            self.stream_status = m.get('StreamStatus')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class ListNVRDeviceResponseBody(TeaModel):
    def __init__(self, data=None, request_id=None, success=None, total=None):
        self.data = data  # type: list[ListNVRDeviceResponseBodyData]
        # Id of the request
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.total = total  # type: str

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListNVRDeviceResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = ListNVRDeviceResponseBodyData()
                self.data.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class ListNVRDeviceResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: ListNVRDeviceResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListNVRDeviceResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListNVRDeviceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListPersonTraceRequest(TeaModel):
    def __init__(self, corp_id=None, data_source_id=None, end_time=None, group_id=None, page_number=None,
                 page_size=None, person_id=None, start_time=None):
        self.corp_id = corp_id  # type: str
        self.data_source_id = data_source_id  # type: str
        self.end_time = end_time  # type: str
        self.group_id = group_id  # type: str
        self.page_number = page_number  # type: str
        self.page_size = page_size  # type: str
        self.person_id = person_id  # type: str
        self.start_time = start_time  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListPersonTraceRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.corp_id is not None:
            result['CorpId'] = self.corp_id
        if self.data_source_id is not None:
            result['DataSourceId'] = self.data_source_id
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.person_id is not None:
            result['PersonId'] = self.person_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CorpId') is not None:
            self.corp_id = m.get('CorpId')
        if m.get('DataSourceId') is not None:
            self.data_source_id = m.get('DataSourceId')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('PersonId') is not None:
            self.person_id = m.get('PersonId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class ListPersonTraceResponseBodyData(TeaModel):
    def __init__(self, corp_id=None, date=None, device_id=None, end_source_image=None, end_target_image=None,
                 group_id=None, last_time=None, person_id=None, start_source_image=None, start_target_image=None,
                 start_time=None):
        self.corp_id = corp_id  # type: str
        self.date = date  # type: str
        self.device_id = device_id  # type: str
        self.end_source_image = end_source_image  # type: str
        self.end_target_image = end_target_image  # type: str
        self.group_id = group_id  # type: str
        self.last_time = last_time  # type: str
        self.person_id = person_id  # type: str
        self.start_source_image = start_source_image  # type: str
        self.start_target_image = start_target_image  # type: str
        self.start_time = start_time  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListPersonTraceResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.corp_id is not None:
            result['CorpId'] = self.corp_id
        if self.date is not None:
            result['Date'] = self.date
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.end_source_image is not None:
            result['EndSourceImage'] = self.end_source_image
        if self.end_target_image is not None:
            result['EndTargetImage'] = self.end_target_image
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.last_time is not None:
            result['LastTime'] = self.last_time
        if self.person_id is not None:
            result['PersonId'] = self.person_id
        if self.start_source_image is not None:
            result['StartSourceImage'] = self.start_source_image
        if self.start_target_image is not None:
            result['StartTargetImage'] = self.start_target_image
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CorpId') is not None:
            self.corp_id = m.get('CorpId')
        if m.get('Date') is not None:
            self.date = m.get('Date')
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('EndSourceImage') is not None:
            self.end_source_image = m.get('EndSourceImage')
        if m.get('EndTargetImage') is not None:
            self.end_target_image = m.get('EndTargetImage')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('LastTime') is not None:
            self.last_time = m.get('LastTime')
        if m.get('PersonId') is not None:
            self.person_id = m.get('PersonId')
        if m.get('StartSourceImage') is not None:
            self.start_source_image = m.get('StartSourceImage')
        if m.get('StartTargetImage') is not None:
            self.start_target_image = m.get('StartTargetImage')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class ListPersonTraceResponseBody(TeaModel):
    def __init__(self, code=None, data=None, message=None, page_number=None, page_size=None, request_id=None,
                 success=None, total_count=None):
        self.code = code  # type: str
        self.data = data  # type: list[ListPersonTraceResponseBodyData]
        self.message = message  # type: str
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.request_id = request_id  # type: str
        self.success = success  # type: str
        self.total_count = total_count  # type: int

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListPersonTraceResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        if self.message is not None:
            result['Message'] = self.message
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = ListPersonTraceResponseBodyData()
                self.data.append(temp_model.from_map(k))
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class ListPersonTraceResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: ListPersonTraceResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListPersonTraceResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is 