# Apache Custos Python SDK
The Apache Custos Python SDK for  third party clients to  integrate with Custos middleware


### Folder Structure

 - custos
      
    Includes gRPC stubs generated by a protoc compiler. Mainly contains data model and functions. You may 
              need to import data model packages to integrate with clients. 
              
 - clients
      
     Includes integration clients, which you want to import and integrate with your code to access Custos middleware.
              
 - samples
      
   Includes set of sample implementation of  integration clients to demo the integration with  Custos middleware
              
 - transport
 
   Includes connection handling classes 
              

### Before  Integration

  -  Create a virtual environment
                
       ```
       python3 -m venv venv
        ```    
  -  Activate the virtual environment
        
       ```
       source venv/bin/activate
       ```
  -  Install dependencies
            
       ```
       pip install -r requirements.txt
       ```
  -  Create a INI file containing server configuration details. For more information refer to default settings file
            
       [settings.ini](custos/transport/settings.ini)
       
### Generating Distribution Archives (Optional)

   You can generate *.tar.gz or .whl distribution and install to any external project. 
   
   -  Create a virtual environment
                
       ```
       python3 -m venv venv
        ```    
   -  Activate the virtual environment
        
       ```
       source venv/bin/activate
       ```
   - Make sure you have the latest versions of setuptools and wheel installed
    
       ```
       pip install  wheel
       ``` 
     
   - Now run this command from the same directory where setup.py is located
   
        ```
        python3 setup.py sdist bdist_wheel
        ```
   - This command should output a lot of text and once completed should generate two files in the dist directory
   
        ```
        dist/
            custos_python_sdk-1.0.0-py3-none-any.whl
            custos-python-sdk-1.0.0.tar.gz
        ```     

You should be able to install those packages into your project.



### Integrate With Your Clients

There are three types of tokens used for access custos APIs.
   
   - Client Token (Base64 encoded Custos_Client_Id +":"+ Custos_Client_Sec)
   - Admin Token (Access Token of Admin User)
   - User Token (Access Token of Generic User)
      
   -  [tenant_management_client](custos/clients/tenant_management_client.py)
   
      - create_admin_tenant (<sub><sup>client_name, requester_email, admin_frist_name,
                            admin_last_name, admin_email, admin_username, admin_password,
                            contacts, redirect_uris, client_uri, scope, domain, logo_uri, comment</sup></sub>)
      - create_tenant (<sub><sup>client_token, client_name, requester_email, admin_frist_name,
                            admin_last_name, admin_email, admin_username, admin_password,
                            contacts, redirect_uris, client_uri, scope, domain, logo_uri, comment</sup></sub>)
      - get_credentials (<sub><sup>client_token</sup></sub>)
      - get_tenant (<sub><sup>client_token, client_id</sup></sub>)
      - update_tenant (<sub><sup>client_token, client_id, client_name, requester_email, admin_frist_name,
                      admin_last_name, admin_email, admin_username, admin_password,
                      contacts, redirect_uris, client_uri, scope, domain, logo_uri, comment</sup></sub>)
      - delete_tenant (<sub><sup>client_token, client_id</sup></sub>)
      - add_tenant_roles (<sub><sup>client_token, roles, is_client_level</sup></sub>)
      - add_protocol_mapper (<sub><sup>client_token, roles, is_client_level</sup></sub>)
      - get_child_tenants (<sub><sup> client_token, offset, limit, status</sup></sub>)
      - get_all_tenants (<sub><sup> client_token, email</sup></sub>)
      
    
      
   Sample implementations can be found at [tenant_management_samples](custos/samples/tenant_management_samples.py)
      
   -   [identity_management_client](custos/clients/identity_management_client.py)
      
       - authenticate(<sub><sup>client_token, username, password</sup></sub>)
       - is_authenticated(<sub><sup> client_token, user_access_token, username</sup></sub>)
       - get_service_account_access_token(<sub><sup> client_token</sup></sub>)
       - authorize(<sub><sup> client_id, redirect_uri, response_type, scope, state</sup></sub>)
       - token(<sub><sup>  client_token, redirect_uri, code</sup></sub>)
       - get_credentials(<sub><sup>  client_token, client_id</sup></sub>)
       - get_oidc_configuration(<sub><sup> client_token, client_id</sup></sub>)
       
   Sample implementations can be found at [identity_management_sample](custos/samples/identity_management_samples.py)
    
    
   - [user_management_client](custos/clients/user_management_client.py)   
       
       - register_user(<sub><sup>client_token, username, first_name, last_name, password, email, is_temp_password</sup></sub>) 
       - register_and_enable_users(<sub><sup> admin_token, users</sup></sub>)
       - add_user_attributes(<sub><sup> user_token, attributes, users</sup></sub>)
       - delete_user_attributes(<sub><sup> user_token, attributes, users</sup></sub>)
       - enable_user(<sub><sup> client_token, username</sup></sub>)
       - add_roles_to_users(<sub><sup> admin_token, usernames, roles, is_client_level</sup></sub>)
       - is_user_enabled(<sub><sup>  client_token, username</sup></sub>)
       - is_username_available(<sub><sup> client_token, username</sup></sub>)
       - get_user(<sub><sup> client_token, username</sup></sub>)
       - find_users(<sub><sup> client_token, offset, limit, username=None, firstname=None, lastname=None, email=None</sup></sub>)
       - reset_password(<sub><sup> client_token, username, password</sup></sub>)
       - delete_user(<sub><sup>  admin_token, username</sup></sub>)
       - delete_user_roles(<sub><sup> admin_token, username, client_roles, realm_roles</sup></sub>)
       - update_user_profile(<sub><sup> user_token, username, email, first_name, last_name</sup></sub>)
       
       
   Sample implementations can be found at [user_management_samples](custos/samples/user_management_sample.py)
       
       
       
   - [super_tenant_management_client](custos/clients/super_tenant_management_client.py)
   
       - get_all_tenants(<sub><sup> super_admin_token, offset, limit, status</sup></sub>)
       - update_tenant_status(<sub><sup>  super_admin_token, client_id, status</sup></sub>)
 
  