/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.convert;

import java.util.Locale;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.calcite.plan.Convention;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelRule;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitDef;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.tools.RelBuilderFactory;
import org.apache.calcite.util.ImmutableBeans;

public abstract class ConverterRule
extends RelRule<Config> {
    private final RelTrait inTrait;
    private final RelTrait outTrait;
    protected final Convention out;

    protected ConverterRule(Config config) {
        super(config);
        this.inTrait = Objects.requireNonNull(config.inTrait());
        this.outTrait = Objects.requireNonNull(config.outTrait());
        assert (this.inTrait.getTraitDef() == this.outTrait.getTraitDef());
        this.out = this.outTrait instanceof Convention ? (Convention)this.outTrait : null;
    }

    @Deprecated
    public ConverterRule(Class<? extends RelNode> clazz, RelTrait in, RelTrait out, String descriptionPrefix) {
        this(Config.INSTANCE.withConversion(clazz, in, out, descriptionPrefix));
    }

    @Deprecated
    public <R extends RelNode> ConverterRule(Class<R> clazz, com.google.common.base.Predicate<? super R> predicate, RelTrait in, RelTrait out, String descriptionPrefix) {
        this(Config.INSTANCE.withConversion(clazz, predicate::apply, in, out, descriptionPrefix));
    }

    @Deprecated
    public <R extends RelNode> ConverterRule(Class<R> clazz, Predicate<? super R> predicate, RelTrait in, RelTrait out, RelBuilderFactory relBuilderFactory, String descriptionPrefix) {
        this(Config.EMPTY.withRelBuilderFactory(relBuilderFactory).as(Config.class).withConversion(clazz, predicate, in, out, descriptionPrefix));
    }

    @Deprecated
    public <R extends RelNode> ConverterRule(Class<R> clazz, com.google.common.base.Predicate<? super R> predicate, RelTrait in, RelTrait out, RelBuilderFactory relBuilderFactory, String description) {
        this(clazz, predicate::apply, in, out, relBuilderFactory, description);
    }

    @Override
    public Convention getOutConvention() {
        return (Convention)this.outTrait;
    }

    @Override
    public RelTrait getOutTrait() {
        return this.outTrait;
    }

    public RelTrait getInTrait() {
        return this.inTrait;
    }

    public RelTraitDef getTraitDef() {
        return this.inTrait.getTraitDef();
    }

    private static String createDescription(String descriptionPrefix, RelTrait in, RelTrait out) {
        return String.format(Locale.ROOT, "%s(in:%s,out:%s)", Objects.toString(descriptionPrefix, "ConverterRule"), in, out);
    }

    public abstract RelNode convert(RelNode var1);

    public boolean isGuaranteed() {
        return false;
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        RelNode converted;
        Object rel = call.rel(0);
        if (rel.getTraitSet().contains(this.inTrait) && (converted = this.convert((RelNode)rel)) != null) {
            call.transformTo(converted);
        }
    }

    public static interface Config
    extends RelRule.Config {
        public static final Config INSTANCE = EMPTY.as(Config.class);

        @ImmutableBeans.Property
        public RelTrait inTrait();

        public Config withInTrait(RelTrait var1);

        @ImmutableBeans.Property
        public RelTrait outTrait();

        public Config withOutTrait(RelTrait var1);

        @ImmutableBeans.Property
        public Function<Config, ConverterRule> ruleFactory();

        public Config withRuleFactory(Function<Config, ConverterRule> var1);

        default public <R extends RelNode> Config withConversion(Class<R> clazz, Predicate<? super R> predicate, RelTrait in, RelTrait out, String descriptionPrefix) {
            return this.withInTrait(in).withOutTrait(out).withOperandSupplier(b -> b.operand(clazz).predicate(predicate).convert(in)).withDescription(ConverterRule.createDescription(descriptionPrefix, in, out)).as(Config.class);
        }

        default public Config withConversion(Class<? extends RelNode> clazz, RelTrait in, RelTrait out, String descriptionPrefix) {
            return this.withConversion(clazz, r -> true, in, out, descriptionPrefix);
        }

        @Override
        default public RelOptRule toRule() {
            return this.toRule(ConverterRule.class);
        }

        default public <R extends ConverterRule> R toRule(Class<R> ruleClass) {
            return (R)((ConverterRule)ruleClass.cast(this.ruleFactory().apply(this)));
        }
    }
}

