/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.type;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeComparability;
import org.apache.calcite.rel.type.RelDataTypeFamily;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rel.type.RelDataTypeFieldImpl;
import org.apache.calcite.rel.type.RelDataTypePrecedenceList;
import org.apache.calcite.rel.type.RelProtoDataType;
import org.apache.calcite.rel.type.StructKind;
import org.apache.calcite.sql.SqlCollation;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlIntervalQualifier;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.Util;

public abstract class RelDataTypeImpl
implements RelDataType,
RelDataTypeFamily {
    protected final List<RelDataTypeField> fieldList;
    protected String digest;

    protected RelDataTypeImpl(List<? extends RelDataTypeField> fieldList) {
        this.fieldList = fieldList != null ? ImmutableList.copyOf(fieldList) : null;
    }

    protected RelDataTypeImpl() {
        this(null);
    }

    @Override
    public RelDataTypeField getField(String fieldName, boolean caseSensitive, boolean elideRecord) {
        RelDataTypeField lastField;
        for (RelDataTypeField relDataTypeField : this.fieldList) {
            if (!Util.matches(caseSensitive, relDataTypeField.getName(), fieldName)) continue;
            return relDataTypeField;
        }
        if (elideRecord) {
            ArrayList<Slot> slots = new ArrayList<Slot>();
            RelDataTypeImpl.getFieldRecurse(slots, this, 0, fieldName, caseSensitive);
            block5: for (Slot slot : slots) {
                switch (slot.count) {
                    case 0: {
                        continue block5;
                    }
                    case 1: {
                        return slot.field;
                    }
                }
                break;
            }
        }
        if (this.fieldList.size() > 0 && (lastField = Iterables.getLast(this.fieldList)).getName().equals("_extra")) {
            return new RelDataTypeFieldImpl(fieldName, -1, lastField.getType());
        }
        for (RelDataTypeField relDataTypeField : this.fieldList) {
            if (!relDataTypeField.isDynamicStar()) continue;
            return relDataTypeField;
        }
        return null;
    }

    private static void getFieldRecurse(List<Slot> slots, RelDataType type, int depth, String fieldName, boolean caseSensitive) {
        while (slots.size() <= depth) {
            slots.add(new Slot());
        }
        Slot slot = slots.get(depth);
        for (RelDataTypeField field : type.getFieldList()) {
            if (!Util.matches(caseSensitive, field.getName(), fieldName)) continue;
            ++slot.count;
            slot.field = field;
        }
        if (slot.count == 0) {
            for (RelDataTypeField field : type.getFieldList()) {
                if (!field.getType().isStruct()) continue;
                RelDataTypeImpl.getFieldRecurse(slots, field.getType(), depth + 1, fieldName, caseSensitive);
            }
        }
    }

    @Override
    public List<RelDataTypeField> getFieldList() {
        assert (this.fieldList != null) : "fieldList must not be null, type = " + this;
        return this.fieldList;
    }

    @Override
    public List<String> getFieldNames() {
        assert (this.fieldList != null) : "fieldList must not be null, type = " + this;
        return Pair.left(this.fieldList);
    }

    @Override
    public int getFieldCount() {
        assert (this.fieldList != null) : "fieldList must not be null, type = " + this;
        return this.fieldList.size();
    }

    @Override
    public StructKind getStructKind() {
        return this.isStruct() ? StructKind.FULLY_QUALIFIED : StructKind.NONE;
    }

    @Override
    public RelDataType getComponentType() {
        return null;
    }

    @Override
    public RelDataType getKeyType() {
        return null;
    }

    @Override
    public RelDataType getValueType() {
        return null;
    }

    @Override
    public boolean isStruct() {
        return this.fieldList != null;
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof RelDataTypeImpl && this.digest.equals(((RelDataTypeImpl)obj).digest);
    }

    public int hashCode() {
        return this.digest.hashCode();
    }

    @Override
    public String getFullTypeString() {
        return this.digest;
    }

    @Override
    public boolean isNullable() {
        return false;
    }

    @Override
    public Charset getCharset() {
        return null;
    }

    @Override
    public SqlCollation getCollation() {
        return null;
    }

    @Override
    public SqlIntervalQualifier getIntervalQualifier() {
        return null;
    }

    @Override
    public int getPrecision() {
        return -1;
    }

    @Override
    public int getScale() {
        return Integer.MIN_VALUE;
    }

    @Override
    public SqlTypeName getSqlTypeName() {
        return null;
    }

    @Override
    public SqlIdentifier getSqlIdentifier() {
        SqlTypeName typeName = this.getSqlTypeName();
        if (typeName == null) {
            return null;
        }
        return new SqlIdentifier(typeName.name(), SqlParserPos.ZERO);
    }

    @Override
    public RelDataTypeFamily getFamily() {
        return this;
    }

    protected abstract void generateTypeString(StringBuilder var1, boolean var2);

    protected void computeDigest() {
        StringBuilder sb = new StringBuilder();
        this.generateTypeString(sb, true);
        if (!this.isNullable()) {
            sb.append(" NOT NULL");
        }
        this.digest = sb.toString();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.generateTypeString(sb, false);
        return sb.toString();
    }

    @Override
    public RelDataTypePrecedenceList getPrecedenceList() {
        return new RelDataTypePrecedenceList(){

            @Override
            public boolean containsType(RelDataType type) {
                return RelDataTypeImpl.this.getFamily() == type.getFamily();
            }

            @Override
            public int compareTypePrecedence(RelDataType type1, RelDataType type2) {
                assert (this.containsType(type1));
                assert (this.containsType(type2));
                return 0;
            }
        };
    }

    @Override
    public RelDataTypeComparability getComparability() {
        return RelDataTypeComparability.ALL;
    }

    public static RelProtoDataType proto(RelDataType protoType) {
        assert (protoType != null);
        return typeFactory -> typeFactory.copyType(protoType);
    }

    public static RelProtoDataType proto(SqlTypeName typeName, boolean nullable) {
        assert (typeName != null);
        return typeFactory -> {
            RelDataType type = typeFactory.createSqlType(typeName);
            return typeFactory.createTypeWithNullability(type, nullable);
        };
    }

    public static RelProtoDataType proto(SqlTypeName typeName, int precision, boolean nullable) {
        assert (typeName != null);
        return typeFactory -> {
            RelDataType type = typeFactory.createSqlType(typeName, precision);
            return typeFactory.createTypeWithNullability(type, nullable);
        };
    }

    public static RelProtoDataType proto(SqlTypeName typeName, int precision, int scale, boolean nullable) {
        return typeFactory -> {
            RelDataType type = typeFactory.createSqlType(typeName, precision, scale);
            return typeFactory.createTypeWithNullability(type, nullable);
        };
    }

    public static RelDataTypeField extra(RelDataType rowType) {
        return rowType.getField("_extra", true, false);
    }

    @Override
    public boolean isDynamicStruct() {
        return false;
    }

    private static class Slot {
        int count;
        RelDataTypeField field;

        private Slot() {
        }
    }
}

