/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.fun;

import java.math.BigDecimal;
import org.apache.calcite.sql.SqlBinaryOperator;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperatorBinding;
import org.apache.calcite.sql.type.SqlOperandTypeChecker;
import org.apache.calcite.sql.type.SqlOperandTypeInference;
import org.apache.calcite.sql.type.SqlReturnTypeInference;
import org.apache.calcite.sql.validate.SqlMonotonicity;

public class SqlMonotonicBinaryOperator
extends SqlBinaryOperator {
    public SqlMonotonicBinaryOperator(String name, SqlKind kind, int prec, boolean isLeftAssoc, SqlReturnTypeInference returnTypeInference, SqlOperandTypeInference operandTypeInference, SqlOperandTypeChecker operandTypeChecker) {
        super(name, kind, prec, isLeftAssoc, returnTypeInference, operandTypeInference, operandTypeChecker);
    }

    @Override
    public SqlMonotonicity getMonotonicity(SqlOperatorBinding call) {
        SqlMonotonicity mono0 = call.getOperandMonotonicity(0);
        SqlMonotonicity mono1 = call.getOperandMonotonicity(1);
        if (mono0 == null || mono1 == null) {
            return null;
        }
        if (mono1 == SqlMonotonicity.CONSTANT && mono0 == SqlMonotonicity.CONSTANT) {
            return SqlMonotonicity.CONSTANT;
        }
        if (mono1 == SqlMonotonicity.CONSTANT) {
            if (this.getName().equals("-") || this.getName().equals("+")) {
                return mono0;
            }
            assert (this.getName().equals("*"));
            BigDecimal value = call.getOperandLiteralValue(1, BigDecimal.class);
            switch (value == null ? 1 : value.signum()) {
                case -1: {
                    return mono0.reverse();
                }
                case 0: {
                    return SqlMonotonicity.CONSTANT;
                }
            }
            return mono0;
        }
        if (mono0 == SqlMonotonicity.CONSTANT) {
            if (this.getName().equals("-")) {
                return mono1.reverse();
            }
            if (this.getName().equals("+")) {
                return mono1;
            }
            assert (this.getName().equals("*"));
            if (!call.isOperandNull(0, true)) {
                BigDecimal value = call.getOperandLiteralValue(0, BigDecimal.class);
                switch (value == null ? 1 : value.signum()) {
                    case -1: {
                        return mono1.reverse();
                    }
                    case 0: {
                        return SqlMonotonicity.CONSTANT;
                    }
                }
                return mono1;
            }
        }
        if (this.getName().equals("+")) {
            if (mono0 == mono1) {
                return mono0;
            }
            if (mono0.unstrict() == mono1.unstrict()) {
                return mono0.unstrict();
            }
            return SqlMonotonicity.NOT_MONOTONIC;
        }
        if (this.getName().equals("-")) {
            if (mono0 == mono1.reverse()) {
                return mono0;
            }
            if (mono0.unstrict() == mono1.reverse().unstrict()) {
                return mono0.unstrict();
            }
            return SqlMonotonicity.NOT_MONOTONIC;
        }
        if (this.getName().equals("*")) {
            return SqlMonotonicity.NOT_MONOTONIC;
        }
        return super.getMonotonicity(call);
    }
}

