/**
 * Represents a javascript file to load before the webapp.
 * This can allow operators to add their own client monitors or analytics if they wish
 */
export declare class PreloadFile {
    private readonly data;
    /**
     * Creates a PreloadFile instance from a filepath to load
     */
    static fromFile(path: string): PreloadFile;
    /**
     * Creates a PreloadFile instance directly from source code
     */
    static fromCode(code: string): PreloadFile;
    constructor(data: string);
    bind(): string;
}
