# Generated by Django 4.1.1 on 2022-10-05 13:37

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name="ApiRequest",
            fields=[
                (
                    "id",
                    models.CharField(
                        editable=False,
                        help_text="Unique identifier of this request",
                        max_length=36,
                        primary_key=True,
                        serialize=False,
                        verbose_name="Request ID",
                    ),
                ),
                (
                    "headers",
                    models.JSONField(
                        editable=False,
                        help_text="The headers sent with this request",
                        null=True,
                        verbose_name="Request Headers",
                    ),
                ),
                (
                    "query_parameters",
                    models.JSONField(
                        editable=False,
                        help_text="The query parameters sent with this request",
                        null=True,
                        verbose_name="Request Query Parameters",
                    ),
                ),
                (
                    "query_string",
                    models.CharField(
                        editable=False,
                        help_text="The raw query parameter string sent with this request",
                        max_length=512,
                        null=True,
                        verbose_name="Query string",
                    ),
                ),
                (
                    "method",
                    models.CharField(
                        editable=False, max_length=7, verbose_name="HTTP Method"
                    ),
                ),
                (
                    "path",
                    models.CharField(
                        editable=False,
                        help_text="The request's URI",
                        max_length=256,
                        verbose_name="Path",
                    ),
                ),
                (
                    "requested_at",
                    models.DateTimeField(
                        auto_now_add=True, verbose_name="Requested at"
                    ),
                ),
                (
                    "user",
                    models.ForeignKey(
                        editable=False,
                        help_text="The user associated with this request",
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        to=settings.AUTH_USER_MODEL,
                        verbose_name="User",
                    ),
                ),
            ],
            options={
                "verbose_name": "API Request",
                "verbose_name_plural": "API Requests",
            },
        ),
        migrations.CreateModel(
            name="Integration",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "platform",
                    models.CharField(
                        choices=[("slack", "Slack"), ("discord", "Discord")],
                        help_text="To which platform this integration refers",
                        max_length=50,
                        unique=True,
                        verbose_name="Platform",
                    ),
                ),
                (
                    "oauth_token",
                    models.CharField(
                        max_length=255, null=True, verbose_name="OAuth Token"
                    ),
                ),
                (
                    "created_by_user",
                    models.ForeignKey(
                        editable=False,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="created_integrations",
                        to=settings.AUTH_USER_MODEL,
                        verbose_name="Created by user",
                    ),
                ),
            ],
            options={
                "verbose_name": "Integration",
                "verbose_name_plural": "Integrations",
            },
        ),
        migrations.CreateModel(
            name="ApiResponse",
            fields=[
                (
                    "request",
                    models.OneToOneField(
                        editable=False,
                        on_delete=django.db.models.deletion.CASCADE,
                        primary_key=True,
                        related_name="response",
                        serialize=False,
                        to="apm.apirequest",
                        verbose_name="Request",
                    ),
                ),
                (
                    "status_code",
                    models.SmallIntegerField(
                        editable=False,
                        help_text="The response's status code",
                        verbose_name="Status code",
                    ),
                ),
                (
                    "ellapsed",
                    models.DecimalField(
                        decimal_places=3,
                        editable=False,
                        help_text="How much time the server took to respond",
                        max_digits=6,
                        null=True,
                        verbose_name="Ellapsed",
                    ),
                ),
                (
                    "body",
                    models.JSONField(
                        editable=False,
                        help_text="The response's body",
                        null=True,
                        verbose_name="Body",
                    ),
                ),
                (
                    "created_at",
                    models.DateTimeField(
                        auto_now_add=True, null=True, verbose_name="Created at"
                    ),
                ),
            ],
            options={
                "verbose_name": "API Response",
                "verbose_name_plural": "API Responses",
            },
        ),
        migrations.CreateModel(
            name="ErrorTrace",
            fields=[
                (
                    "request",
                    models.OneToOneField(
                        editable=False,
                        on_delete=django.db.models.deletion.CASCADE,
                        primary_key=True,
                        related_name="error_trace",
                        serialize=False,
                        to="apm.apirequest",
                        verbose_name="Request",
                    ),
                ),
                (
                    "payload",
                    models.JSONField(
                        editable=False,
                        help_text="The payload sent with this request",
                        null=True,
                        verbose_name="Request Payload",
                    ),
                ),
                (
                    "exception_class",
                    models.CharField(
                        editable=False, max_length=255, verbose_name="Exception class"
                    ),
                ),
                (
                    "exception_args",
                    models.CharField(
                        editable=False,
                        max_length=255,
                        verbose_name="Exception arguments",
                    ),
                ),
                (
                    "traceback",
                    models.TextField(editable=False, verbose_name="Traceback"),
                ),
                (
                    "created_at",
                    models.DateTimeField(auto_now_add=True, verbose_name="Created at"),
                ),
                (
                    "dismissed_at",
                    models.DateTimeField(
                        editable=False, null=True, verbose_name="Dismissed at"
                    ),
                ),
                (
                    "dismissed_by_user",
                    models.ForeignKey(
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="dismissed_traces",
                        to=settings.AUTH_USER_MODEL,
                        verbose_name="Dismissed by user",
                    ),
                ),
            ],
            options={
                "verbose_name": "Error Trace",
                "verbose_name_plural": "Error Traces",
            },
        ),
        migrations.CreateModel(
            name="NotificationReceiver",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "receiver_type",
                    models.CharField(
                        choices=[("name", "Name"), ("id", "ID")],
                        max_length=50,
                        verbose_name="Receiver Type",
                    ),
                ),
                (
                    "receiver",
                    models.CharField(
                        help_text="Who should receive this message (Id/Name)",
                        max_length=255,
                        verbose_name="Receiver",
                    ),
                ),
                (
                    "integration",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="receivers",
                        to="apm.integration",
                        verbose_name="Integration",
                    ),
                ),
            ],
            options={
                "verbose_name": "Notification Receiver",
                "verbose_name_plural": "Notification Receivers",
            },
        ),
        migrations.CreateModel(
            name="RequestLog",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "level",
                    models.CharField(
                        editable=False, max_length=10, verbose_name="Level"
                    ),
                ),
                (
                    "file_path",
                    models.CharField(
                        editable=False, max_length=512, verbose_name="File Path"
                    ),
                ),
                (
                    "func_name",
                    models.CharField(
                        editable=False, max_length=255, verbose_name="Function Name"
                    ),
                ),
                (
                    "timestamp",
                    models.DateTimeField(editable=False, verbose_name="Time Stamp"),
                ),
                ("message", models.TextField(editable=False, verbose_name="Message")),
                (
                    "trace",
                    models.ForeignKey(
                        editable=False,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="logs",
                        to="apm.errortrace",
                        verbose_name="Error Trace",
                    ),
                ),
            ],
            options={
                "verbose_name": "Request Log",
                "verbose_name_plural": "Request Logs",
            },
        ),
    ]
