# mypy-boto3-cloudfront

[![PyPI - mypy-boto3-cloudfront](https://img.shields.io/pypi/v/mypy-boto3-cloudfront.svg?color=blue)](https://pypi.org/project/mypy-boto3-cloudfront)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-cloudfront.svg?color=blue)](https://pypi.org/project/mypy-boto3-cloudfront)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)

Type annotations for
[boto3.CloudFront 1.13.8](https://boto3.amazonaws.com/v1/documentation/api/1.13.8/reference/services/cloudfront.html#CloudFront) service
compatible with [mypy](https://github.com/python/mypy), [VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/) and other tools.

Generated by [mypy-boto3-buider 1.0.9](https://github.com/vemel/mypy_boto3_builder).

More information can be found on [boto3-stubs](https://pypi.org/project/boto3-stubs/) page.

- [mypy-boto3-cloudfront](#mypy-boto3-cloudfront)
  - [How to use](#how-to-use)
    - [Type checking](#type-checking)
  - [How it works](#how-it-works)

## How to use

### Type checking

Make sure you have [mypy](https://github.com/python/mypy) installed and activated in your IDE.

Install `boto3-stubs` for `CloudFront` service.

```bash
python -m pip install boto3-stubs[cloudfront]

# update installed packages index
mypy_boto3
```

Use `boto3` with `mypy_boto3` in your project and enjoy type checking and auto-complete.

```python
import boto3

from mypy_boto3 import cloudfront
# alternative import if you do not want to install mypy_boto3 package
# import mypy_boto3_cloudfront as cloudfront

# Use this client as usual, now mypy can check if your code is valid.
# Check if your IDE supports function overloads,
# you probably do not need explicit type annotations
# client = boto3.client("cloudfront")
client: cloudfront.CloudFrontClient = boto3.client("cloudfront")

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: cloudfront.CloudFrontClient = session.client("cloudfront")


# Waiters need type annotation on creation
distribution_deployed_waiter: cloudfront.DistributionDeployedWaiter = client.get_waiter("distribution_deployed")
invalidation_completed_waiter: cloudfront.InvalidationCompletedWaiter = client.get_waiter("invalidation_completed")
streaming_distribution_deployed_waiter: cloudfront.StreamingDistributionDeployedWaiter = client.get_waiter("streaming_distribution_deployed")

# Paginators need type annotation on creation
list_cloud_front_origin_access_identities_paginator: cloudfront.ListCloudFrontOriginAccessIdentitiesPaginator = client.get_paginator("list_cloud_front_origin_access_identities")
list_distributions_paginator: cloudfront.ListDistributionsPaginator = client.get_paginator("list_distributions")
list_invalidations_paginator: cloudfront.ListInvalidationsPaginator = client.get_paginator("list_invalidations")
list_streaming_distributions_paginator: cloudfront.ListStreamingDistributionsPaginator = client.get_paginator("list_streaming_distributions")
```

## How it works

Fully automated [builder](https://github.com/vemel/mypy_boto3_builder) carefully generates
type annotations for each service, patiently waiting for `boto3` updates. It delivers
a drop-in type annotations for you and makes sure that:

- All available `boto3` services are covered.
- Each public class and method of every `boto3` service gets valid type annotations
  extracted from the documentation (blame `botocore` docs if types are incorrect).
- Type annotations include up-to-date documentation.
- Link to documentation is provided for every method.
- Code is processed by [black](https://github.com/psf/black) for readability.