# Generated by ts2python on 2021-11-29 21:17:11.462386


import sys, os
from enum import Enum, IntEnum
from typing import Union, List, Tuple, Optional, Dict, Any, Generic, TypeVar

scriptdir = os.path.dirname(os.path.abspath(__file__))
sys.path.append(os.path.join(scriptdir, '..'))

try:
    from typing import TypedDict, Literal
except ImportError:
    try:
        from ts2python.typing_extensions import TypedDict, Literal
    except ImportError:
        print(f'Please install the "typing_extensions" module via the shell '
              f'command "# pip install typing_extensions" before running '
              f'{__file__} with Python-versions <= 3.7!')        


##### BEGIN OF LSP SPECS


try:
    from typing import NotRequired
except ImportError:
    try:
        from ts2python.typing_extensions import NotRequired
    except ImportError:
        NotRequired = Optional
        try:
            from ts2python.json_validation import TypedDict, GenericTypedDict
        except ImportError:
            print("Module ts2python not found. Only coarse-grained " 
                  "type-validation of TypedDicts possible")
            if sys.version_info >= (3, 7, 0):  GenericMeta = type
            else:
                from typing import GenericMeta
            class _GenericTypedDictMeta(GenericMeta):
                def __new__(cls, name, bases, ns, total=True):
                    return type.__new__(_GenericTypedDictMeta, name, (dict,), ns)
                __call__ = dict
            GenericTypedDict = _GenericTypedDictMeta('TypedDict', (dict,), {})
            GenericTypedDict.__module__ = __name__      


integer = float


uinteger = float


decimal = float


class Message(TypedDict):
    jsonrpc: str


class RequestMessage(Message, TypedDict):
    id: Union[int, str]
    method: str
    params: NotRequired[Union[List, Dict]]


class ResponseMessage(Message, TypedDict):
    id: Union[int, str, None]
    result: NotRequired[Union[str, float, bool, Dict, None]]
    error: NotRequired['ResponseError']


class ResponseError(TypedDict):
    code: int
    message: str
    data: NotRequired[Union[str, float, bool, List, Dict, None]]


class ErrorCodes(IntEnum):
    ParseError = -32700
    InvalidRequest = -32600
    MethodNotFound = -32601
    InvalidParams = -32602
    InternalError = -32603
    jsonrpcReservedErrorRangeStart = -32099
    serverErrorStart = jsonrpcReservedErrorRangeStart
    ServerNotInitialized = -32002
    UnknownErrorCode = -32001
    jsonrpcReservedErrorRangeEnd = -32000
    serverErrorEnd = jsonrpcReservedErrorRangeEnd
    lspReservedErrorRangeStart = -32899
    ServerCancelled = -32802
    ContentModified = -32801
    RequestCancelled = -32800
    lspReservedErrorRangeEnd = -32800


class NotificationMessage(Message, TypedDict):
    method: str
    params: NotRequired[Union[List, Dict]]


class CancelParams(TypedDict):
    id: Union[int, str]


ProgressToken = Union[int, str]


T = TypeVar('T')


class ProgressParams(Generic[T], GenericTypedDict):
    token: ProgressToken
    value: 'T'


DocumentUri = str


URI = str


class RegularExpressionsClientCapabilities(TypedDict):
    engine: str
    version: NotRequired[str]


EOL: List[str] = ['\n', '\r\n', '\r']


class Position(TypedDict):
    line: int
    character: int


class Range(TypedDict):
    start: Position
    end: Position


class Location(TypedDict):
    uri: DocumentUri
    range: Range


class LocationLink(TypedDict):
    originSelectionRange: NotRequired[Range]
    targetUri: DocumentUri
    targetRange: Range
    targetSelectionRange: Range


class Diagnostic(TypedDict):
    range: Range
    severity: NotRequired['DiagnosticSeverity']
    code: NotRequired[Union[int, str]]
    codeDescription: NotRequired['CodeDescription']
    source: NotRequired[str]
    message: str
    tags: NotRequired[List['DiagnosticTag']]
    relatedInformation: NotRequired[List['DiagnosticRelatedInformation']]
    data: NotRequired[Any]


class DiagnosticSeverity(IntEnum):
    Error = 1
    Warning = 2
    Information = 3
    Hint = 4


class DiagnosticTag(IntEnum):
    Unnecessary = 1
    Deprecated = 2


class DiagnosticRelatedInformation(TypedDict):
    location: Location
    message: str


class CodeDescription(TypedDict):
    href: URI


class Command(TypedDict):
    title: str
    command: str
    arguments: NotRequired[List[Any]]


class TextEdit(TypedDict):
    range: Range
    newText: str


class ChangeAnnotation(TypedDict):
    label: str
    needsConfirmation: NotRequired[bool]
    description: NotRequired[str]


ChangeAnnotationIdentifier = str


class AnnotatedTextEdit(TextEdit, TypedDict):
    annotationId: ChangeAnnotationIdentifier


class TextDocumentEdit(TypedDict):
    textDocument: 'OptionalVersionedTextDocumentIdentifier'
    edits: List[Union[TextEdit, AnnotatedTextEdit]]


class CreateFileOptions(TypedDict):
    overwrite: NotRequired[bool]
    ignoreIfExists: NotRequired[bool]


class CreateFile(TypedDict):
    kind: 'create'
    uri: DocumentUri
    options: NotRequired[CreateFileOptions]
    annotationId: NotRequired[ChangeAnnotationIdentifier]


class RenameFileOptions(TypedDict):
    overwrite: NotRequired[bool]
    ignoreIfExists: NotRequired[bool]


class RenameFile(TypedDict):
    kind: 'rename'
    oldUri: DocumentUri
    newUri: DocumentUri
    options: NotRequired[RenameFileOptions]
    annotationId: NotRequired[ChangeAnnotationIdentifier]


class DeleteFileOptions(TypedDict):
    recursive: NotRequired[bool]
    ignoreIfNotExists: NotRequired[bool]


class DeleteFile(TypedDict):
    kind: 'delete'
    uri: DocumentUri
    options: NotRequired[DeleteFileOptions]
    annotationId: NotRequired[ChangeAnnotationIdentifier]


class WorkspaceEdit(TypedDict):
    changes: NotRequired[Dict[DocumentUri, List[TextEdit]]]
    documentChanges: NotRequired[Union[List[TextDocumentEdit], List[Union[TextDocumentEdit, CreateFile, RenameFile, DeleteFile]]]]
    changeAnnotations: NotRequired[Dict[str, ChangeAnnotation]]


class WorkspaceEditClientCapabilities(TypedDict):
    class ChangeAnnotationSupport_(TypedDict):
        groupsOnLabel: NotRequired[bool]
    documentChanges: NotRequired[bool]
    resourceOperations: NotRequired[List['ResourceOperationKind']]
    failureHandling: NotRequired['FailureHandlingKind']
    normalizesLineEndings: NotRequired[bool]
    changeAnnotationSupport: NotRequired[ChangeAnnotationSupport_]


class ResourceOperationKind(Enum):
    Create = 'create'
    Rename = 'rename'
    Delete = 'delete'


class FailureHandlingKind(Enum):
    Abort = 'abort'
    Transactional = 'transactional'
    TextOnlyTransactional = 'textOnlyTransactional'
    Undo = 'undo'


class TextDocumentIdentifier(TypedDict):
    uri: DocumentUri


class TextDocumentItem(TypedDict):
    uri: DocumentUri
    languageId: str
    version: int
    text: str


class VersionedTextDocumentIdentifier(TextDocumentIdentifier, TypedDict):
    version: int


class OptionalVersionedTextDocumentIdentifier(TextDocumentIdentifier, TypedDict):
    version: Union[int, None]


class TextDocumentPositionParams(TypedDict):
    textDocument: TextDocumentIdentifier
    position: Position


class DocumentFilter(TypedDict):
    language: NotRequired[str]
    scheme: NotRequired[str]
    pattern: NotRequired[str]


DocumentSelector = List[DocumentFilter]


class StaticRegistrationOptions(TypedDict):
    id: NotRequired[str]


class TextDocumentRegistrationOptions(TypedDict):
    documentSelector: Union[DocumentSelector, None]


class MarkupKind(Enum):
    PlainText = 'plaintext'
    Markdown = 'markdown'


class MarkupContent(TypedDict):
    kind: MarkupKind
    value: str


class MarkdownClientCapabilities(TypedDict):
    parser: str
    version: NotRequired[str]


class WorkDoneProgressBegin(TypedDict):
    kind: 'begin'
    title: str
    cancellable: NotRequired[bool]
    message: NotRequired[str]
    percentage: NotRequired[int]


class WorkDoneProgressReport(TypedDict):
    kind: 'report'
    cancellable: NotRequired[bool]
    message: NotRequired[str]
    percentage: NotRequired[int]


class WorkDoneProgressEnd(TypedDict):
    kind: 'end'
    message: NotRequired[str]


class WorkDoneProgressParams(TypedDict):
    workDoneToken: NotRequired[ProgressToken]


class WorkDoneProgressOptions(TypedDict):
    workDoneProgress: NotRequired[bool]


class PartialResultParams(TypedDict):
    partialResultToken: NotRequired[ProgressToken]


TraceValue = Literal['off', 'messages', 'verbose']


class InitializeParams(WorkDoneProgressParams, TypedDict):
    class ClientInfo_(TypedDict):
        name: str
        version: NotRequired[str]
    processId: Union[int, None]
    clientInfo: NotRequired[ClientInfo_]
    locale: NotRequired[str]
    rootPath: NotRequired[Union[str, None]]
    rootUri: Union[DocumentUri, None]
    initializationOptions: NotRequired[Any]
    capabilities: 'ClientCapabilities'
    trace: NotRequired[TraceValue]
    workspaceFolders: NotRequired[Union[List['WorkspaceFolder'], None]]


class TextDocumentClientCapabilities(TypedDict):
    synchronization: NotRequired['TextDocumentSyncClientCapabilities']
    completion: NotRequired['CompletionClientCapabilities']
    hover: NotRequired['HoverClientCapabilities']
    signatureHelp: NotRequired['SignatureHelpClientCapabilities']
    declaration: NotRequired['DeclarationClientCapabilities']
    definition: NotRequired['DefinitionClientCapabilities']
    typeDefinition: NotRequired['TypeDefinitionClientCapabilities']
    implementation: NotRequired['ImplementationClientCapabilities']
    references: NotRequired['ReferenceClientCapabilities']
    documentHighlight: NotRequired['DocumentHighlightClientCapabilities']
    documentSymbol: NotRequired['DocumentSymbolClientCapabilities']
    codeAction: NotRequired['CodeActionClientCapabilities']
    codeLens: NotRequired['CodeLensClientCapabilities']
    documentLink: NotRequired['DocumentLinkClientCapabilities']
    colorProvider: NotRequired['DocumentColorClientCapabilities']
    formatting: NotRequired['DocumentFormattingClientCapabilities']
    rangeFormatting: NotRequired['DocumentRangeFormattingClientCapabilities']
    onTypeFormatting: NotRequired['DocumentOnTypeFormattingClientCapabilities']
    rename: NotRequired['RenameClientCapabilities']
    publishDiagnostics: NotRequired['PublishDiagnosticsClientCapabilities']
    foldingRange: NotRequired['FoldingRangeClientCapabilities']
    selectionRange: NotRequired['SelectionRangeClientCapabilities']
    linkedEditingRange: NotRequired['LinkedEditingRangeClientCapabilities']
    callHierarchy: NotRequired['CallHierarchyClientCapabilities']
    semanticTokens: NotRequired['SemanticTokensClientCapabilities']
    moniker: NotRequired['MonikerClientCapabilities']


class ClientCapabilities(TypedDict):
    class Workspace_(TypedDict):
        class FileOperations_(TypedDict):
            dynamicRegistration: NotRequired[bool]
            didCreate: NotRequired[bool]
            willCreate: NotRequired[bool]
            didRename: NotRequired[bool]
            willRename: NotRequired[bool]
            didDelete: NotRequired[bool]
            willDelete: NotRequired[bool]
        applyEdit: NotRequired[bool]
        workspaceEdit: NotRequired[WorkspaceEditClientCapabilities]
        didChangeConfiguration: NotRequired['DidChangeConfigurationClientCapabilities']
        didChangeWatchedFiles: NotRequired['DidChangeWatchedFilesClientCapabilities']
        symbol: NotRequired['WorkspaceSymbolClientCapabilities']
        executeCommand: NotRequired['ExecuteCommandClientCapabilities']
        workspaceFolders: NotRequired[bool]
        configuration: NotRequired[bool]
        semanticTokens: NotRequired['SemanticTokensWorkspaceClientCapabilities']
        codeLens: NotRequired['CodeLensWorkspaceClientCapabilities']
        fileOperations: NotRequired[FileOperations_]
    class Window_(TypedDict):
        workDoneProgress: NotRequired[bool]
        showMessage: NotRequired['ShowMessageRequestClientCapabilities']
        showDocument: NotRequired['ShowDocumentClientCapabilities']
    class General_(TypedDict):
        class StaleRequestSupport_(TypedDict):
            cancel: bool
            retryOnContentModified: List[str]
        staleRequestSupport: NotRequired[StaleRequestSupport_]
        regularExpressions: NotRequired[RegularExpressionsClientCapabilities]
        markdown: NotRequired[MarkdownClientCapabilities]
    workspace: NotRequired[Workspace_]
    textDocument: NotRequired[TextDocumentClientCapabilities]
    window: NotRequired[Window_]
    general: NotRequired[General_]
    experimental: NotRequired[Any]


class InitializeResult(TypedDict):
    class ServerInfo_(TypedDict):
        name: str
        version: NotRequired[str]
    capabilities: 'ServerCapabilities'
    serverInfo: NotRequired[ServerInfo_]


class InitializeError(IntEnum):
    unknownProtocolVersion = 1


class InitializeError(TypedDict):
    retry: bool


class ServerCapabilities(TypedDict):
    class Workspace_(TypedDict):
        class FileOperations_(TypedDict):
            didCreate: NotRequired['FileOperationRegistrationOptions']
            willCreate: NotRequired['FileOperationRegistrationOptions']
            didRename: NotRequired['FileOperationRegistrationOptions']
            willRename: NotRequired['FileOperationRegistrationOptions']
            didDelete: NotRequired['FileOperationRegistrationOptions']
            willDelete: NotRequired['FileOperationRegistrationOptions']
        workspaceFolders: NotRequired['WorkspaceFoldersServerCapabilities']
        fileOperations: NotRequired[FileOperations_]
    textDocumentSync: NotRequired[Union['TextDocumentSyncOptions', 'TextDocumentSyncKind']]
    completionProvider: NotRequired['CompletionOptions']
    hoverProvider: NotRequired[Union[bool, 'HoverOptions']]
    signatureHelpProvider: NotRequired['SignatureHelpOptions']
    declarationProvider: NotRequired[Union[bool, 'DeclarationOptions', 'DeclarationRegistrationOptions']]
    definitionProvider: NotRequired[Union[bool, 'DefinitionOptions']]
    typeDefinitionProvider: NotRequired[Union[bool, 'TypeDefinitionOptions', 'TypeDefinitionRegistrationOptions']]
    implementationProvider: NotRequired[Union[bool, 'ImplementationOptions', 'ImplementationRegistrationOptions']]
    referencesProvider: NotRequired[Union[bool, 'ReferenceOptions']]
    documentHighlightProvider: NotRequired[Union[bool, 'DocumentHighlightOptions']]
    documentSymbolProvider: NotRequired[Union[bool, 'DocumentSymbolOptions']]
    codeActionProvider: NotRequired[Union[bool, 'CodeActionOptions']]
    codeLensProvider: NotRequired['CodeLensOptions']
    documentLinkProvider: NotRequired['DocumentLinkOptions']
    colorProvider: NotRequired[Union[bool, 'DocumentColorOptions', 'DocumentColorRegistrationOptions']]
    documentFormattingProvider: NotRequired[Union[bool, 'DocumentFormattingOptions']]
    documentRangeFormattingProvider: NotRequired[Union[bool, 'DocumentRangeFormattingOptions']]
    documentOnTypeFormattingProvider: NotRequired['DocumentOnTypeFormattingOptions']
    renameProvider: NotRequired[Union[bool, 'RenameOptions']]
    foldingRangeProvider: NotRequired[Union[bool, 'FoldingRangeOptions', 'FoldingRangeRegistrationOptions']]
    executeCommandProvider: NotRequired['ExecuteCommandOptions']
    selectionRangeProvider: NotRequired[Union[bool, 'SelectionRangeOptions', 'SelectionRangeRegistrationOptions']]
    linkedEditingRangeProvider: NotRequired[Union[bool, 'LinkedEditingRangeOptions', 'LinkedEditingRangeRegistrationOptions']]
    callHierarchyProvider: NotRequired[Union[bool, 'CallHierarchyOptions', 'CallHierarchyRegistrationOptions']]
    semanticTokensProvider: NotRequired[Union['SemanticTokensOptions', 'SemanticTokensRegistrationOptions']]
    monikerProvider: NotRequired[Union[bool, 'MonikerOptions', 'MonikerRegistrationOptions']]
    workspaceSymbolProvider: NotRequired[Union[bool, 'WorkspaceSymbolOptions']]
    workspace: NotRequired[Workspace_]
    experimental: NotRequired[Any]


class InitializedParams(TypedDict):
    pass


class LogTraceParams(TypedDict):
    message: str
    verbose: NotRequired[str]


class SetTraceParams(TypedDict):
    value: TraceValue


class ShowMessageParams(TypedDict):
    type: 'MessageType'
    message: str


class MessageType(IntEnum):
    Error = 1
    Warning = 2
    Info = 3
    Log = 4


class ShowMessageRequestClientCapabilities(TypedDict):
    class MessageActionItem_(TypedDict):
        additionalPropertiesSupport: NotRequired[bool]
    messageActionItem: NotRequired[MessageActionItem_]


class ShowMessageRequestParams(TypedDict):
    type: MessageType
    message: str
    actions: NotRequired[List['MessageActionItem']]


class MessageActionItem(TypedDict):
    title: str


class ShowDocumentClientCapabilities(TypedDict):
    support: bool


class ShowDocumentParams(TypedDict):
    uri: URI
    external: NotRequired[bool]
    takeFocus: NotRequired[bool]
    selection: NotRequired[Range]


class ShowDocumentResult(TypedDict):
    success: bool


class LogMessageParams(TypedDict):
    type: MessageType
    message: str


class WorkDoneProgressCreateParams(TypedDict):
    token: ProgressToken


class WorkDoneProgressCancelParams(TypedDict):
    token: ProgressToken


class Registration(TypedDict):
    id: str
    method: str
    registerOptions: NotRequired[Any]


class RegistrationParams(TypedDict):
    registrations: List[Registration]


class Unregistration(TypedDict):
    id: str
    method: str


class UnregistrationParams(TypedDict):
    unregisterations: List[Unregistration]


class WorkspaceFoldersServerCapabilities(TypedDict):
    supported: NotRequired[bool]
    changeNotifications: NotRequired[Union[str, bool]]


class WorkspaceFolder(TypedDict):
    uri: DocumentUri
    name: str


class DidChangeWorkspaceFoldersParams(TypedDict):
    event: 'WorkspaceFoldersChangeEvent'


class WorkspaceFoldersChangeEvent(TypedDict):
    added: List[WorkspaceFolder]
    removed: List[WorkspaceFolder]


class DidChangeConfigurationClientCapabilities(TypedDict):
    dynamicRegistration: NotRequired[bool]


class DidChangeConfigurationParams(TypedDict):
    settings: Any


class ConfigurationParams(TypedDict):
    items: List['ConfigurationItem']


class ConfigurationItem(TypedDict):
    scopeUri: NotRequired[DocumentUri]
    section: NotRequired[str]


class DidChangeWatchedFilesClientCapabilities(TypedDict):
    dynamicRegistration: NotRequired[bool]


class DidChangeWatchedFilesRegistrationOptions(TypedDict):
    watchers: List['FileSystemWatcher']


class FileSystemWatcher(TypedDict):
    globPattern: str
    kind: NotRequired[int]


class WatchKind(IntEnum):
    Create = 1
    Change = 2
    Delete = 4


class DidChangeWatchedFilesParams(TypedDict):
    changes: List['FileEvent']


class FileEvent(TypedDict):
    uri: DocumentUri
    type: int


class FileChangeType(IntEnum):
    Created = 1
    Changed = 2
    Deleted = 3


class WorkspaceSymbolClientCapabilities(TypedDict):
    class SymbolKind_(TypedDict):
        valueSet: NotRequired[List['SymbolKind']]
    class TagSupport_(TypedDict):
        valueSet: List['SymbolTag']
    dynamicRegistration: NotRequired[bool]
    symbolKind: NotRequired[SymbolKind_]
    tagSupport: NotRequired[TagSupport_]


class WorkspaceSymbolOptions(WorkDoneProgressOptions, TypedDict):
    pass


class WorkspaceSymbolRegistrationOptions(WorkspaceSymbolOptions, TypedDict):
    pass


class WorkspaceSymbolParams(WorkDoneProgressParams, PartialResultParams, TypedDict):
    query: str


class ExecuteCommandClientCapabilities(TypedDict):
    dynamicRegistration: NotRequired[bool]


class ExecuteCommandOptions(WorkDoneProgressOptions, TypedDict):
    commands: List[str]


class ExecuteCommandRegistrationOptions(ExecuteCommandOptions, TypedDict):
    pass


class ExecuteCommandParams(WorkDoneProgressParams, TypedDict):
    command: str
    arguments: NotRequired[List[Any]]


class ApplyWorkspaceEditParams(TypedDict):
    label: NotRequired[str]
    edit: WorkspaceEdit


class ApplyWorkspaceEditResult(TypedDict):
    applied: bool
    failureReason: NotRequired[str]
    failedChange: NotRequired[int]


class FileOperationRegistrationOptions(TypedDict):
    filters: List['FileOperationFilter']


class FileOperationPatternKind(Enum):
    file = 'file'
    folder = 'folder'


class FileOperationPatternOptions(TypedDict):
    ignoreCase: NotRequired[bool]


class FileOperationPattern(TypedDict):
    glob: str
    matches: NotRequired[FileOperationPatternKind]
    options: NotRequired[FileOperationPatternOptions]


class FileOperationFilter(TypedDict):
    scheme: NotRequired[str]
    pattern: FileOperationPattern


class CreateFilesParams(TypedDict):
    files: List['FileCreate']


class FileCreate(TypedDict):
    uri: str


class RenameFilesParams(TypedDict):
    files: List['FileRename']


class FileRename(TypedDict):
    oldUri: str
    newUri: str


class DeleteFilesParams(TypedDict):
    files: List['FileDelete']


class FileDelete(TypedDict):
    uri: str


class TextDocumentSyncKind(IntEnum):
    None_ = 0
    Full = 1
    Incremental = 2


class TextDocumentSyncOptions(TypedDict):
    openClose: NotRequired[bool]
    change: NotRequired[TextDocumentSyncKind]


class DidOpenTextDocumentParams(TypedDict):
    textDocument: TextDocumentItem


class TextDocumentChangeRegistrationOptions(TextDocumentRegistrationOptions, TypedDict):
    syncKind: TextDocumentSyncKind


class DidChangeTextDocumentParams(TypedDict):
    textDocument: VersionedTextDocumentIdentifier
    contentChanges: List['TextDocumentContentChangeEvent']


class TextDocumentContentChangeEvent_0(TypedDict):
    range: Range
    rangeLength: NotRequired[int]
    text: str
class TextDocumentContentChangeEvent_1(TypedDict):
    text: str
TextDocumentContentChangeEvent = Union[TextDocumentContentChangeEvent_0, TextDocumentContentChangeEvent_1]


class WillSaveTextDocumentParams(TypedDict):
    textDocument: TextDocumentIdentifier
    reason: 'TextDocumentSaveReason'


class TextDocumentSaveReason(IntEnum):
    Manual = 1
    AfterDelay = 2
    FocusOut = 3


class SaveOptions(TypedDict):
    includeText: NotRequired[bool]


class TextDocumentSaveRegistrationOptions(TextDocumentRegistrationOptions, TypedDict):
    includeText: NotRequired[bool]


class DidSaveTextDocumentParams(TypedDict):
    textDocument: TextDocumentIdentifier
    text: NotRequired[str]


class DidCloseTextDocumentParams(TypedDict):
    textDocument: TextDocumentIdentifier


class TextDocumentSyncClientCapabilities(TypedDict):
    dynamicRegistration: NotRequired[bool]
    willSave: NotRequired[bool]
    willSaveWaitUntil: NotRequired[bool]
    didSave: NotRequired[bool]


class TextDocumentSyncOptions(TypedDict):
    openClose: NotRequired[bool]
    change: NotRequired[TextDocumentSyncKind]
    willSave: NotRequired[bool]
    willSaveWaitUntil: NotRequired[bool]
    save: NotRequired[Union[bool, SaveOptions]]


class PublishDiagnosticsClientCapabilities(TypedDict):
    class TagSupport_(TypedDict):
        valueSet: List[DiagnosticTag]
    relatedInformation: NotRequired[bool]
    tagSupport: NotRequired[TagSupport_]
    versionSupport: NotRequired[bool]
    codeDescriptionSupport: NotRequired[bool]
    dataSupport: NotRequired[bool]


class PublishDiagnosticsParams(TypedDict):
    uri: DocumentUri
    version: NotRequired[int]
    diagnostics: List[Diagnostic]


class CompletionClientCapabilities(TypedDict):
    class CompletionItem_(TypedDict):
        class TagSupport_(TypedDict):
            valueSet: List['CompletionItemTag']
        class ResolveSupport_(TypedDict):
            properties: List[str]
        class InsertTextModeSupport_(TypedDict):
            valueSet: List['InsertTextMode']
        snippetSupport: NotRequired[bool]
        commitCharactersSupport: NotRequired[bool]
        documentationFormat: NotRequired[List[MarkupKind]]
        deprecatedSupport: NotRequired[bool]
        preselectSupport: NotRequired[bool]
        tagSupport: NotRequired[TagSupport_]
        insertReplaceSupport: NotRequired[bool]
        resolveSupport: NotRequired[ResolveSupport_]
        insertTextModeSupport: NotRequired[InsertTextModeSupport_]
        labelDetailsSupport: NotRequired[bool]
    class CompletionItemKind_(TypedDict):
        valueSet: NotRequired[List['CompletionItemKind']]
    dynamicRegistration: NotRequired[bool]
    completionItem: NotRequired[CompletionItem_]
    completionItemKind: NotRequired[CompletionItemKind_]
    contextSupport: NotRequired[bool]
    insertTextMode: NotRequired['InsertTextMode']


class CompletionOptions(WorkDoneProgressOptions, TypedDict):
    class CompletionItem_(TypedDict):
        labelDetailsSupport: NotRequired[bool]
    triggerCharacters: NotRequired[List[str]]
    allCommitCharacters: NotRequired[List[str]]
    resolveProvider: NotRequired[bool]
    completionItem: NotRequired[CompletionItem_]


class CompletionRegistrationOptions(TextDocumentRegistrationOptions, CompletionOptions, TypedDict):
    pass


class CompletionParams(TextDocumentPositionParams, WorkDoneProgressParams, PartialResultParams, TypedDict):
    context: NotRequired['CompletionContext']


class CompletionTriggerKind(IntEnum):
    Invoked = 1
    TriggerCharacter = 2
    TriggerForIncompleteCompletions = 3


class CompletionContext(TypedDict):
    triggerKind: CompletionTriggerKind
    triggerCharacter: NotRequired[str]


class CompletionList(TypedDict):
    isIncomplete: bool
    items: List['CompletionItem']


class InsertTextFormat(IntEnum):
    PlainText = 1
    Snippet = 2


class CompletionItemTag(IntEnum):
    Deprecated = 1


class InsertReplaceEdit(TypedDict):
    newText: str
    insert: Range
    replace: Range


class InsertTextMode(IntEnum):
    asIs = 1
    adjustIndentation = 2


class CompletionItemLabelDetails(TypedDict):
    detail: NotRequired[str]
    description: NotRequired[str]


class CompletionItem(TypedDict):
    label: str
    labelDetails: NotRequired[CompletionItemLabelDetails]
    kind: NotRequired['CompletionItemKind']
    tags: NotRequired[List[CompletionItemTag]]
    detail: NotRequired[str]
    documentation: NotRequired[Union[str, MarkupContent]]
    deprecated: NotRequired[bool]
    preselect: NotRequired[bool]
    sortText: NotRequired[str]
    filterText: NotRequired[str]
    insertText: NotRequired[str]
    insertTextFormat: NotRequired[InsertTextFormat]
    insertTextMode: NotRequired[InsertTextMode]
    textEdit: NotRequired[Union[TextEdit, InsertReplaceEdit]]
    additionalTextEdits: NotRequired[List[TextEdit]]
    commitCharacters: NotRequired[List[str]]
    command: NotRequired[Command]
    data: NotRequired[Any]


class CompletionItemKind(IntEnum):
    Text = 1
    Method = 2
    Function = 3
    Constructor = 4
    Field = 5
    Variable = 6
    Class = 7
    Interface = 8
    Module = 9
    Property = 10
    Unit = 11
    Value = 12
    Enum = 13
    Keyword = 14
    Snippet = 15
    Color = 16
    File = 17
    Reference = 18
    Folder = 19
    EnumMember = 20
    Constant = 21
    Struct = 22
    Event = 23
    Operator = 24
    TypeParameter = 25


class HoverClientCapabilities(TypedDict):
    dynamicRegistration: NotRequired[bool]
    contentFormat: NotRequired[List[MarkupKind]]


class HoverOptions(WorkDoneProgressOptions, TypedDict):
    pass


class HoverRegistrationOptions(TextDocumentRegistrationOptions, HoverOptions, TypedDict):
    pass


class HoverParams(TextDocumentPositionParams, WorkDoneProgressParams, TypedDict):
    pass


class Hover(TypedDict):
    contents: Union['MarkedString', List['MarkedString'], MarkupContent]
    range: NotRequired[Range]


class MarkedString_1(TypedDict):
    language: str
    value: str
MarkedString = Union[str, MarkedString_1]


class SignatureHelpClientCapabilities(TypedDict):
    class SignatureInformation_(TypedDict):
        class ParameterInformation_(TypedDict):
            labelOffsetSupport: NotRequired[bool]
        documentationFormat: NotRequired[List[MarkupKind]]
        parameterInformation: NotRequired[ParameterInformation_]
        activeParameterSupport: NotRequired[bool]
    dynamicRegistration: NotRequired[bool]
    signatureInformation: NotRequired[SignatureInformation_]
    contextSupport: NotRequired[bool]


class SignatureHelpOptions(WorkDoneProgressOptions, TypedDict):
    triggerCharacters: NotRequired[List[str]]
    retriggerCharacters: NotRequired[List[str]]


class SignatureHelpRegistrationOptions(TextDocumentRegistrationOptions, SignatureHelpOptions, TypedDict):
    pass


class SignatureHelpParams(TextDocumentPositionParams, WorkDoneProgressParams, TypedDict):
    context: NotRequired['SignatureHelpContext']


class SignatureHelpTriggerKind(IntEnum):
    Invoked = 1
    TriggerCharacter = 2
    ContentChange = 3


class SignatureHelpContext(TypedDict):
    triggerKind: SignatureHelpTriggerKind
    triggerCharacter: NotRequired[str]
    isRetrigger: bool
    activeSignatureHelp: NotRequired['SignatureHelp']


class SignatureHelp(TypedDict):
    signatures: List['SignatureInformation']
    activeSignature: NotRequired[int]
    activeParameter: NotRequired[int]


class SignatureInformation(TypedDict):
    label: str
    documentation: NotRequired[Union[str, MarkupContent]]
    parameters: NotRequired[List['ParameterInformation']]
    activeParameter: NotRequired[int]


class ParameterInformation(TypedDict):
    label: Union[str, Tuple[int, int]]
    documentation: NotRequired[Union[str, MarkupContent]]


class DeclarationClientCapabilities(TypedDict):
    dynamicRegistration: NotRequired[bool]
    linkSupport: NotRequired[bool]


class DeclarationOptions(WorkDoneProgressOptions, TypedDict):
    pass


class DeclarationRegistrationOptions(DeclarationOptions, TextDocumentRegistrationOptions, StaticRegistrationOptions, TypedDict):
    pass


class DeclarationParams(TextDocumentPositionParams, WorkDoneProgressParams, PartialResultParams, TypedDict):
    pass


class DefinitionClientCapabilities(TypedDict):
    dynamicRegistration: NotRequired[bool]
    linkSupport: NotRequired[bool]


class DefinitionOptions(WorkDoneProgressOptions, TypedDict):
    pass


class DefinitionRegistrationOptions(TextDocumentRegistrationOptions, DefinitionOptions, TypedDict):
    pass


class DefinitionParams(TextDocumentPositionParams, WorkDoneProgressParams, PartialResultParams, TypedDict):
    pass


class TypeDefinitionClientCapabilities(TypedDict):
    dynamicRegistration: NotRequired[bool]
    linkSupport: NotRequired[bool]


class TypeDefinitionOptions(WorkDoneProgressOptions, TypedDict):
    pass


class TypeDefinitionRegistrationOptions(TextDocumentRegistrationOptions, TypeDefinitionOptions, StaticRegistrationOptions, TypedDict):
    pass


class TypeDefinitionParams(TextDocumentPositionParams, WorkDoneProgressParams, PartialResultParams, TypedDict):
    pass


class ImplementationClientCapabilities(TypedDict):
    dynamicRegistration: NotRequired[bool]
    linkSupport: NotRequired[bool]


class ImplementationOptions(WorkDoneProgressOptions, TypedDict):
    pass


class ImplementationRegistrationOptions(TextDocumentRegistrationOptions, ImplementationOptions, StaticRegistrationOptions, TypedDict):
    pass


class ImplementationParams(TextDocumentPositionParams, WorkDoneProgressParams, PartialResultParams, TypedDict):
    pass


class ReferenceClientCapabilities(TypedDict):
    dynamicRegistration: NotRequired[bool]


class ReferenceOptions(WorkDoneProgressOptions, TypedDict):
    pass


class ReferenceRegistrationOptions(TextDocumentRegistrationOptions, ReferenceOptions, TypedDict):
    pass


class ReferenceParams(TextDocumentPositionParams, WorkDoneProgressParams, PartialResultParams, TypedDict):
    context: 'ReferenceContext'


class ReferenceContext(TypedDict):
    includeDeclaration: bool


class DocumentHighlightClientCapabilities(TypedDict):
    dynamicRegistration: NotRequired[bool]


class DocumentHighlightOptions(WorkDoneProgressOptions, TypedDict):
    pass


class DocumentHighlightRegistrationOptions(TextDocumentRegistrationOptions, DocumentHighlightOptions, TypedDict):
    pass


class DocumentHighlightParams(TextDocumentPositionParams, WorkDoneProgressParams, PartialResultParams, TypedDict):
    pass


class DocumentHighlight(TypedDict):
    range: Range
    kind: NotRequired['DocumentHighlightKind']


class DocumentHighlightKind(IntEnum):
    Text = 1
    Read = 2
    Write = 3


class DocumentSymbolClientCapabilities(TypedDict):
    class SymbolKind_(TypedDict):
        valueSet: NotRequired[List['SymbolKind']]
    class TagSupport_(TypedDict):
        valueSet: List['SymbolTag']
    dynamicRegistration: NotRequired[bool]
    symbolKind: NotRequired[SymbolKind_]
    hierarchicalDocumentSymbolSupport: NotRequired[bool]
    tagSupport: NotRequired[TagSupport_]
    labelSupport: NotRequired[bool]


class DocumentSymbolOptions(WorkDoneProgressOptions, TypedDict):
    label: NotRequired[str]


class DocumentSymbolRegistrationOptions(TextDocumentRegistrationOptions, DocumentSymbolOptions, TypedDict):
    pass


class DocumentSymbolParams(WorkDoneProgressParams, PartialResultParams, TypedDict):
    textDocument: TextDocumentIdentifier


class SymbolKind(IntEnum):
    File = 1
    Module = 2
    Namespace = 3
    Package = 4
    Class = 5
    Method = 6
    Property = 7
    Field = 8
    Constructor = 9
    Enum = 10
    Interface = 11
    Function = 12
    Variable = 13
    Constant = 14
    String = 15
    Number = 16
    Boolean = 17
    Array = 18
    Object = 19
    Key = 20
    Null = 21
    EnumMember = 22
    Struct = 23
    Event = 24
    Operator = 25
    TypeParameter = 26


class SymbolTag(IntEnum):
    Deprecated = 1


class DocumentSymbol(TypedDict):
    name: str
    detail: NotRequired[str]
    kind: SymbolKind
    tags: NotRequired[List[SymbolTag]]
    deprecated: NotRequired[bool]
    range: Range
    selectionRange: Range
    children: NotRequired[List['DocumentSymbol']]


class SymbolInformation(TypedDict):
    name: str
    kind: SymbolKind
    tags: NotRequired[List[SymbolTag]]
    deprecated: NotRequired[bool]
    location: Location
    containerName: NotRequired[str]


class CodeActionClientCapabilities(TypedDict):
    class CodeActionLiteralSupport_(TypedDict):
        class CodeActionKind_(TypedDict):
            valueSet: List['CodeActionKind']
        codeActionKind: CodeActionKind_
    class ResolveSupport_(TypedDict):
        properties: List[str]
    dynamicRegistration: NotRequired[bool]
    codeActionLiteralSupport: NotRequired[CodeActionLiteralSupport_]
    isPreferredSupport: NotRequired[bool]
    disabledSupport: NotRequired[bool]
    dataSupport: NotRequired[bool]
    resolveSupport: NotRequired[ResolveSupport_]
    honorsChangeAnnotations: NotRequired[bool]


class CodeActionOptions(WorkDoneProgressOptions, TypedDict):
    codeActionKinds: NotRequired[List['CodeActionKind']]
    resolveProvider: NotRequired[bool]


class CodeActionRegistrationOptions(TextDocumentRegistrationOptions, CodeActionOptions, TypedDict):
    pass


class CodeActionParams(WorkDoneProgressParams, PartialResultParams, TypedDict):
    textDocument: TextDocumentIdentifier
    range: Range
    context: 'CodeActionContext'


class CodeActionKind(Enum):
    Empty = ''
    QuickFix = 'quickfix'
    Refactor = 'refactor'
    RefactorExtract = 'refactor.extract'
    RefactorInline = 'refactor.inline'
    RefactorRewrite = 'refactor.rewrite'
    Source = 'source'
    SourceOrganizeImports = 'source.organizeImports'
    SourceFixAll = 'source.fixAll'


class CodeActionContext(TypedDict):
    diagnostics: List[Diagnostic]
    only: NotRequired[List[CodeActionKind]]


class CodeAction(TypedDict):
    class Disabled_(TypedDict):
        reason: str
    title: str
    kind: NotRequired[CodeActionKind]
    diagnostics: NotRequired[List[Diagnostic]]
    isPreferred: NotRequired[bool]
    disabled: NotRequired[Disabled_]
    edit: NotRequired[WorkspaceEdit]
    command: NotRequired[Command]
    data: NotRequired[Any]


class CodeLensClientCapabilities(TypedDict):
    dynamicRegistration: NotRequired[bool]


class CodeLensOptions(WorkDoneProgressOptions, TypedDict):
    resolveProvider: NotRequired[bool]


class CodeLensRegistrationOptions(TextDocumentRegistrationOptions, CodeLensOptions, TypedDict):
    pass


class CodeLensParams(WorkDoneProgressParams, PartialResultParams, TypedDict):
    textDocument: TextDocumentIdentifier


class CodeLens(TypedDict):
    range: Range
    command: NotRequired[Command]
    data: NotRequired[Any]


class CodeLensWorkspaceClientCapabilities(TypedDict):
    refreshSupport: NotRequired[bool]


class DocumentLinkClientCapabilities(TypedDict):
    dynamicRegistration: NotRequired[bool]
    tooltipSupport: NotRequired[bool]


class DocumentLinkOptions(WorkDoneProgressOptions, TypedDict):
    resolveProvider: NotRequired[bool]


class DocumentLinkRegistrationOptions(TextDocumentRegistrationOptions, DocumentLinkOptions, TypedDict):
    pass


class DocumentLinkParams(WorkDoneProgressParams, PartialResultParams, TypedDict):
    textDocument: TextDocumentIdentifier


class DocumentLink(TypedDict):
    range: Range
    target: NotRequired[DocumentUri]
    tooltip: NotRequired[str]
    data: NotRequired[Any]


class DocumentColorClientCapabilities(TypedDict):
    dynamicRegistration: NotRequired[bool]


class DocumentColorOptions(WorkDoneProgressOptions, TypedDict):
    pass


class DocumentColorRegistrationOptions(TextDocumentRegistrationOptions, StaticRegistrationOptions, DocumentColorOptions, TypedDict):
    pass


class DocumentColorParams(WorkDoneProgressParams, PartialResultParams, TypedDict):
    textDocument: TextDocumentIdentifier


class ColorInformation(TypedDict):
    range: Range
    color: 'Color'


class Color(TypedDict):
    red: float
    green: float
    blue: float
    alpha: float


class ColorPresentationParams(WorkDoneProgressParams, PartialResultParams, TypedDict):
    textDocument: TextDocumentIdentifier
    color: Color
    range: Range


class ColorPresentation(TypedDict):
    label: str
    textEdit: NotRequired[TextEdit]
    additionalTextEdits: NotRequired[List[TextEdit]]


class DocumentFormattingClientCapabilities(TypedDict):
    dynamicRegistration: NotRequired[bool]


class DocumentFormattingOptions(WorkDoneProgressOptions, TypedDict):
    pass


class DocumentFormattingRegistrationOptions(TextDocumentRegistrationOptions, DocumentFormattingOptions, TypedDict):
    pass


class DocumentFormattingParams(WorkDoneProgressParams, TypedDict):
    textDocument: TextDocumentIdentifier
    options: 'FormattingOptions'


class FormattingOptions(TypedDict):
    tabSize: int
    insertSpaces: bool
    trimTrailingWhitespace: NotRequired[bool]
    insertFinalNewline: NotRequired[bool]
    trimFinalNewlines: NotRequired[bool]


class DocumentRangeFormattingClientCapabilities(TypedDict):
    dynamicRegistration: NotRequired[bool]


class DocumentRangeFormattingOptions(WorkDoneProgressOptions, TypedDict):
    pass


class DocumentRangeFormattingRegistrationOptions(TextDocumentRegistrationOptions, DocumentRangeFormattingOptions, TypedDict):
    pass


class DocumentRangeFormattingParams(WorkDoneProgressParams, TypedDict):
    textDocument: TextDocumentIdentifier
    range: Range
    options: FormattingOptions


class DocumentOnTypeFormattingClientCapabilities(TypedDict):
    dynamicRegistration: NotRequired[bool]


class DocumentOnTypeFormattingOptions(TypedDict):
    firstTriggerCharacter: str
    moreTriggerCharacter: NotRequired[List[str]]


class DocumentOnTypeFormattingRegistrationOptions(TextDocumentRegistrationOptions, DocumentOnTypeFormattingOptions, TypedDict):
    pass


class DocumentOnTypeFormattingParams(TextDocumentPositionParams, TypedDict):
    ch: str
    options: FormattingOptions


class PrepareSupportDefaultBehavior(IntEnum):
    Identifier = 1


class RenameClientCapabilities(TypedDict):
    dynamicRegistration: NotRequired[bool]
    prepareSupport: NotRequired[bool]
    prepareSupportDefaultBehavior: NotRequired[PrepareSupportDefaultBehavior]
    honorsChangeAnnotations: NotRequired[bool]


class RenameOptions(WorkDoneProgressOptions, TypedDict):
    prepareProvider: NotRequired[bool]


class RenameRegistrationOptions(TextDocumentRegistrationOptions, RenameOptions, TypedDict):
    pass


class RenameParams(TextDocumentPositionParams, WorkDoneProgressParams, TypedDict):
    newName: str


class PrepareRenameParams(TextDocumentPositionParams, TypedDict):
    pass


class FoldingRangeClientCapabilities(TypedDict):
    dynamicRegistration: NotRequired[bool]
    rangeLimit: NotRequired[int]
    lineFoldingOnly: NotRequired[bool]


class FoldingRangeOptions(WorkDoneProgressOptions, TypedDict):
    pass


class FoldingRangeRegistrationOptions(TextDocumentRegistrationOptions, FoldingRangeOptions, StaticRegistrationOptions, TypedDict):
    pass


class FoldingRangeParams(WorkDoneProgressParams, PartialResultParams, TypedDict):
    textDocument: TextDocumentIdentifier


class FoldingRangeKind(Enum):
    Comment = 'comment'
    Imports = 'imports'
    Region = 'region'


class FoldingRange(TypedDict):
    startLine: int
    startCharacter: NotRequired[int]
    endLine: int
    endCharacter: NotRequired[int]
    kind: NotRequired[str]


class SelectionRangeClientCapabilities(TypedDict):
    dynamicRegistration: NotRequired[bool]


class SelectionRangeOptions(WorkDoneProgressOptions, TypedDict):
    pass


class SelectionRangeRegistrationOptions(SelectionRangeOptions, TextDocumentRegistrationOptions, StaticRegistrationOptions, TypedDict):
    pass


class SelectionRangeParams(WorkDoneProgressParams, PartialResultParams, TypedDict):
    textDocument: TextDocumentIdentifier
    positions: List[Position]


class SelectionRange(TypedDict):
    range: Range
    parent: NotRequired['SelectionRange']


class CallHierarchyClientCapabilities(TypedDict):
    dynamicRegistration: NotRequired[bool]


class CallHierarchyOptions(WorkDoneProgressOptions, TypedDict):
    pass


class CallHierarchyRegistrationOptions(TextDocumentRegistrationOptions, CallHierarchyOptions, StaticRegistrationOptions, TypedDict):
    pass


class CallHierarchyPrepareParams(TextDocumentPositionParams, WorkDoneProgressParams, TypedDict):
    pass


class CallHierarchyItem(TypedDict):
    name: str
    kind: SymbolKind
    tags: NotRequired[List[SymbolTag]]
    detail: NotRequired[str]
    uri: DocumentUri
    range: Range
    selectionRange: Range
    data: NotRequired[Any]


class CallHierarchyIncomingCallsParams(WorkDoneProgressParams, PartialResultParams, TypedDict):
    item: CallHierarchyItem


class CallHierarchyIncomingCall(TypedDict):
    from_: CallHierarchyItem
    fromRanges: List[Range]


class CallHierarchyOutgoingCallsParams(WorkDoneProgressParams, PartialResultParams, TypedDict):
    item: CallHierarchyItem


class CallHierarchyOutgoingCall(TypedDict):
    to: CallHierarchyItem
    fromRanges: List[Range]


class SemanticTokenTypes(Enum):
    namespace = 'namespace'
    type = 'type'
    class_ = 'class'
    enum = 'enum'
    interface = 'interface'
    struct = 'struct'
    typeParameter = 'typeParameter'
    parameter = 'parameter'
    variable = 'variable'
    property = 'property'
    enumMember = 'enumMember'
    event = 'event'
    function = 'function'
    method = 'method'
    macro = 'macro'
    keyword = 'keyword'
    modifier = 'modifier'
    comment = 'comment'
    string = 'string'
    number = 'number'
    regexp = 'regexp'
    operator = 'operator'


class SemanticTokenModifiers(Enum):
    declaration = 'declaration'
    definition = 'definition'
    readonly = 'readonly'
    static = 'static'
    deprecated = 'deprecated'
    abstract = 'abstract'
    async_ = 'async'
    modification = 'modification'
    documentation = 'documentation'
    defaultLibrary = 'defaultLibrary'


class TokenFormat(Enum):
    Relative = 'relative'


class SemanticTokensLegend(TypedDict):
    tokenTypes: List[str]
    tokenModifiers: List[str]


class SemanticTokensClientCapabilities(TypedDict):
    class Requests_(TypedDict):
        class Range_1(TypedDict):
            pass
        class Full_1(TypedDict):
            delta: NotRequired[bool]
        range: NotRequired[Union[bool, Range_1]]
        full: NotRequired[Union[bool, Full_1]]
    dynamicRegistration: NotRequired[bool]
    requests: Requests_
    tokenTypes: List[str]
    tokenModifiers: List[str]
    formats: List[TokenFormat]
    overlappingTokenSupport: NotRequired[bool]
    multilineTokenSupport: NotRequired[bool]


class SemanticTokensOptions(WorkDoneProgressOptions, TypedDict):
    class Range_1(TypedDict):
        pass
    class Full_1(TypedDict):
        delta: NotRequired[bool]
    legend: SemanticTokensLegend
    range: NotRequired[Union[bool, Range_1]]
    full: NotRequired[Union[bool, Full_1]]


class SemanticTokensRegistrationOptions(TextDocumentRegistrationOptions, SemanticTokensOptions, StaticRegistrationOptions, TypedDict):
    pass


class SemanticTokensParams(WorkDoneProgressParams, PartialResultParams, TypedDict):
    textDocument: TextDocumentIdentifier


class SemanticTokens(TypedDict):
    resultId: NotRequired[str]
    data: List[int]


class SemanticTokensPartialResult(TypedDict):
    data: List[int]


class SemanticTokensDeltaParams(WorkDoneProgressParams, PartialResultParams, TypedDict):
    textDocument: TextDocumentIdentifier
    previousResultId: str


class SemanticTokensDelta(TypedDict):
    resultId: NotRequired[str]
    edits: List['SemanticTokensEdit']


class SemanticTokensEdit(TypedDict):
    start: int
    deleteCount: int
    data: NotRequired[List[int]]


class SemanticTokensDeltaPartialResult(TypedDict):
    edits: List[SemanticTokensEdit]


class SemanticTokensRangeParams(WorkDoneProgressParams, PartialResultParams, TypedDict):
    textDocument: TextDocumentIdentifier
    range: Range


class SemanticTokensWorkspaceClientCapabilities(TypedDict):
    refreshSupport: NotRequired[bool]


class LinkedEditingRangeClientCapabilities(TypedDict):
    dynamicRegistration: NotRequired[bool]


class LinkedEditingRangeOptions(WorkDoneProgressOptions, TypedDict):
    pass


class LinkedEditingRangeRegistrationOptions(TextDocumentRegistrationOptions, LinkedEditingRangeOptions, StaticRegistrationOptions, TypedDict):
    pass


class LinkedEditingRangeParams(TextDocumentPositionParams, WorkDoneProgressParams, TypedDict):
    pass


class LinkedEditingRanges(TypedDict):
    ranges: List[Range]
    wordPattern: NotRequired[str]


class MonikerClientCapabilities(TypedDict):
    dynamicRegistration: NotRequired[bool]


class MonikerOptions(WorkDoneProgressOptions, TypedDict):
    pass


class MonikerRegistrationOptions(TextDocumentRegistrationOptions, MonikerOptions, TypedDict):
    pass


class MonikerParams(TextDocumentPositionParams, WorkDoneProgressParams, PartialResultParams, TypedDict):
    pass


class UniquenessLevel(Enum):
    document = 'document'
    project = 'project'
    group = 'group'
    scheme = 'scheme'
    global_ = 'global'


class MonikerKind(Enum):
    import_ = 'import'
    export = 'export'
    local = 'local'


class Moniker(TypedDict):
    scheme: str
    identifier: str
    unique: UniquenessLevel
    kind: NotRequired[MonikerKind]


##### END OF LSP SPECS
