# Copyright (c) 2021 AccelByte Inc. All Rights Reserved.
# This is licensed software from AccelByte Inc, for limitations
# and restrictions contact your company contract manager.
#
# Code generated. DO NOT EDIT!

# template file: ags_py_codegen

# pylint: disable=duplicate-code
# pylint: disable=line-too-long
# pylint: disable=missing-function-docstring
# pylint: disable=missing-module-docstring
# pylint: disable=too-many-arguments
# pylint: disable=too-many-branches
# pylint: disable=too-many-instance-attributes
# pylint: disable=too-many-lines
# pylint: disable=too-many-locals
# pylint: disable=too-many-public-methods
# pylint: disable=too-many-return-statements
# pylint: disable=too-many-statements
# pylint: disable=unused-import

# AccelByte Gaming Services Social Service (2.1.0)

from __future__ import annotations
from typing import Any, Dict, List, Optional, Tuple, Union

from .....core import Operation
from .....core import HeaderStr
from .....core import HttpResponse
from .....core import StrEnum

from ...models import StatCyclePagingSlicedResult


class CycleTypeEnum(StrEnum):
    ANNUALLY = "ANNUALLY"
    DAILY = "DAILY"
    MONTHLY = "MONTHLY"
    SEASONAL = "SEASONAL"
    WEEKLY = "WEEKLY"


class StatusEnum(StrEnum):
    ACTIVE = "ACTIVE"
    INIT = "INIT"
    STOPPED = "STOPPED"


class GetStatCycles(Operation):
    """List stat cycles (getStatCycles)

    List stat cycles by pagination.
    Other detail info:

      *  Required permission : resource="ADMIN:NAMESPACE:{namespace}:STAT", action=2 (READ)
      *  Returns : stat cycles

    Required Permission(s):
        - ADMIN:NAMESPACE:{namespace}:STAT [READ]

    Properties:
        url: /social/v1/admin/namespaces/{namespace}/statCycles

        method: GET

        tags: ["StatCycleConfiguration"]

        consumes: []

        produces: ["application/json"]

        securities: [BEARER_AUTH] or [BEARER_AUTH]

        namespace: (namespace) REQUIRED str in path

        cycle_type: (cycleType) OPTIONAL Union[str, CycleTypeEnum] in query

        limit: (limit) OPTIONAL int in query

        name: (name) OPTIONAL str in query

        offset: (offset) OPTIONAL int in query

        sort_by: (sortBy) OPTIONAL str in query

        status: (status) OPTIONAL Union[str, StatusEnum] in query

    Responses:
        200: OK - StatCyclePagingSlicedResult (successful operation)
    """

    # region fields

    _url: str = "/social/v1/admin/namespaces/{namespace}/statCycles"
    _method: str = "GET"
    _consumes: List[str] = []
    _produces: List[str] = ["application/json"]
    _securities: List[List[str]] = [["BEARER_AUTH"], ["BEARER_AUTH"]]
    _location_query: str = None

    namespace: str  # REQUIRED in [path]
    cycle_type: Union[str, CycleTypeEnum]  # OPTIONAL in [query]
    limit: int  # OPTIONAL in [query]
    name: str  # OPTIONAL in [query]
    offset: int  # OPTIONAL in [query]
    sort_by: str  # OPTIONAL in [query]
    status: Union[str, StatusEnum]  # OPTIONAL in [query]

    # endregion fields

    # region properties

    @property
    def url(self) -> str:
        return self._url

    @property
    def method(self) -> str:
        return self._method

    @property
    def consumes(self) -> List[str]:
        return self._consumes

    @property
    def produces(self) -> List[str]:
        return self._produces

    @property
    def securities(self) -> List[List[str]]:
        return self._securities

    @property
    def location_query(self) -> str:
        return self._location_query

    # endregion properties

    # region get methods

    # endregion get methods

    # region get_x_params methods

    def get_all_params(self) -> dict:
        return {
            "path": self.get_path_params(),
            "query": self.get_query_params(),
        }

    def get_path_params(self) -> dict:
        result = {}
        if hasattr(self, "namespace"):
            result["namespace"] = self.namespace
        return result

    def get_query_params(self) -> dict:
        result = {}
        if hasattr(self, "cycle_type"):
            result["cycleType"] = self.cycle_type
        if hasattr(self, "limit"):
            result["limit"] = self.limit
        if hasattr(self, "name"):
            result["name"] = self.name
        if hasattr(self, "offset"):
            result["offset"] = self.offset
        if hasattr(self, "sort_by"):
            result["sortBy"] = self.sort_by
        if hasattr(self, "status"):
            result["status"] = self.status
        return result

    # endregion get_x_params methods

    # region is/has methods

    # endregion is/has methods

    # region with_x methods

    def with_namespace(self, value: str) -> GetStatCycles:
        self.namespace = value
        return self

    def with_cycle_type(self, value: Union[str, CycleTypeEnum]) -> GetStatCycles:
        self.cycle_type = value
        return self

    def with_limit(self, value: int) -> GetStatCycles:
        self.limit = value
        return self

    def with_name(self, value: str) -> GetStatCycles:
        self.name = value
        return self

    def with_offset(self, value: int) -> GetStatCycles:
        self.offset = value
        return self

    def with_sort_by(self, value: str) -> GetStatCycles:
        self.sort_by = value
        return self

    def with_status(self, value: Union[str, StatusEnum]) -> GetStatCycles:
        self.status = value
        return self

    # endregion with_x methods

    # region to methods

    def to_dict(self, include_empty: bool = False) -> dict:
        result: dict = {}
        if hasattr(self, "namespace") and self.namespace:
            result["namespace"] = str(self.namespace)
        elif include_empty:
            result["namespace"] = ""
        if hasattr(self, "cycle_type") and self.cycle_type:
            result["cycleType"] = str(self.cycle_type)
        elif include_empty:
            result["cycleType"] = Union[str, CycleTypeEnum]()
        if hasattr(self, "limit") and self.limit:
            result["limit"] = int(self.limit)
        elif include_empty:
            result["limit"] = 0
        if hasattr(self, "name") and self.name:
            result["name"] = str(self.name)
        elif include_empty:
            result["name"] = ""
        if hasattr(self, "offset") and self.offset:
            result["offset"] = int(self.offset)
        elif include_empty:
            result["offset"] = 0
        if hasattr(self, "sort_by") and self.sort_by:
            result["sortBy"] = str(self.sort_by)
        elif include_empty:
            result["sortBy"] = ""
        if hasattr(self, "status") and self.status:
            result["status"] = str(self.status)
        elif include_empty:
            result["status"] = Union[str, StatusEnum]()
        return result

    # endregion to methods

    # region response methods

    # noinspection PyMethodMayBeStatic
    def parse_response(
        self, code: int, content_type: str, content: Any
    ) -> Tuple[Union[None, StatCyclePagingSlicedResult], Union[None, HttpResponse]]:
        """Parse the given response.

        200: OK - StatCyclePagingSlicedResult (successful operation)

        ---: HttpResponse (Undocumented Response)

        ---: HttpResponse (Unexpected Content-Type Error)

        ---: HttpResponse (Unhandled Error)
        """
        pre_processed_response, error = self.pre_process_response(
            code=code, content_type=content_type, content=content
        )
        if error is not None:
            return None, None if error.is_no_content() else error
        code, content_type, content = pre_processed_response

        if code == 200:
            return StatCyclePagingSlicedResult.create_from_dict(content), None

        return self.handle_undocumented_response(
            code=code, content_type=content_type, content=content
        )

    # endregion response methods

    # region static methods

    @classmethod
    def create(
        cls,
        namespace: str,
        cycle_type: Optional[Union[str, CycleTypeEnum]] = None,
        limit: Optional[int] = None,
        name: Optional[str] = None,
        offset: Optional[int] = None,
        sort_by: Optional[str] = None,
        status: Optional[Union[str, StatusEnum]] = None,
    ) -> GetStatCycles:
        instance = cls()
        instance.namespace = namespace
        if cycle_type is not None:
            instance.cycle_type = cycle_type
        if limit is not None:
            instance.limit = limit
        if name is not None:
            instance.name = name
        if offset is not None:
            instance.offset = offset
        if sort_by is not None:
            instance.sort_by = sort_by
        if status is not None:
            instance.status = status
        return instance

    @classmethod
    def create_from_dict(
        cls, dict_: dict, include_empty: bool = False
    ) -> GetStatCycles:
        instance = cls()
        if "namespace" in dict_ and dict_["namespace"] is not None:
            instance.namespace = str(dict_["namespace"])
        elif include_empty:
            instance.namespace = ""
        if "cycleType" in dict_ and dict_["cycleType"] is not None:
            instance.cycle_type = str(dict_["cycleType"])
        elif include_empty:
            instance.cycle_type = Union[str, CycleTypeEnum]()
        if "limit" in dict_ and dict_["limit"] is not None:
            instance.limit = int(dict_["limit"])
        elif include_empty:
            instance.limit = 0
        if "name" in dict_ and dict_["name"] is not None:
            instance.name = str(dict_["name"])
        elif include_empty:
            instance.name = ""
        if "offset" in dict_ and dict_["offset"] is not None:
            instance.offset = int(dict_["offset"])
        elif include_empty:
            instance.offset = 0
        if "sortBy" in dict_ and dict_["sortBy"] is not None:
            instance.sort_by = str(dict_["sortBy"])
        elif include_empty:
            instance.sort_by = ""
        if "status" in dict_ and dict_["status"] is not None:
            instance.status = str(dict_["status"])
        elif include_empty:
            instance.status = Union[str, StatusEnum]()
        return instance

    @staticmethod
    def get_field_info() -> Dict[str, str]:
        return {
            "namespace": "namespace",
            "cycleType": "cycle_type",
            "limit": "limit",
            "name": "name",
            "offset": "offset",
            "sortBy": "sort_by",
            "status": "status",
        }

    @staticmethod
    def get_required_map() -> Dict[str, bool]:
        return {
            "namespace": True,
            "cycleType": False,
            "limit": False,
            "name": False,
            "offset": False,
            "sortBy": False,
            "status": False,
        }

    @staticmethod
    def get_enum_map() -> Dict[str, List[Any]]:
        return {
            "cycleType": [
                "ANNUALLY",
                "DAILY",
                "MONTHLY",
                "SEASONAL",
                "WEEKLY",
            ],  # in query
            "status": ["ACTIVE", "INIT", "STOPPED"],  # in query
        }

    # endregion static methods
