/*
 * Copyright (c) 1994 Cygnus Support.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that the above copyright notice and this paragraph are
 * duplicated in all such forms and that any documentation,
 * and/or other materials related to such
 * distribution and use acknowledge that the software was developed
 * at Cygnus Support, Inc.  Cygnus Support, Inc. may not be used to
 * endorse or promote products derived from this software without
 * specific prior written permission.
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */
#include "test.h"
 one_line_type atan2f_vec[] = {
{64, 0,123,__LINE__, 0xc002d97c, 0x7f3321d2, 0xbff00000, 0x00000000, 0xbff00000, 0x00000000},	/* -2.35619=f(-1, -1)*/
{40, 0,123,__LINE__, 0xc002a4fc, 0x28121327, 0xbff00000, 0x00000000, 0xbfee6666, 0x66666666},	/* -2.33056=f(-1, -0.95)*/
{39, 0,123,__LINE__, 0xc0026dcb, 0xd25efebb, 0xbff00000, 0x00000000, 0xbfeccccc, 0xcccccccc},	/* -2.30361=f(-1, -0.9)*/
{39, 0,123,__LINE__, 0xc00233cb, 0x74aed8f3, 0xbff00000, 0x00000000, 0xbfeb3333, 0x33333332},	/* -2.27529=f(-1, -0.85)*/
{40, 0,123,__LINE__, 0xc001f6dc, 0x3f5cd2c0, 0xbff00000, 0x00000000, 0xbfe99999, 0x99999998},	/* -2.24554=f(-1, -0.8)*/
{64, 0,123,__LINE__, 0xc001b6e1, 0x92ebbe44, 0xbff00000, 0x00000000, 0xbfe7ffff, 0xfffffffe},	/* -2.2143=f(-1, -0.75)*/
{39, 0,123,__LINE__, 0xc00173c1, 0xf46e257d, 0xbff00000, 0x00000000, 0xbfe66666, 0x66666664},	/* -2.18152=f(-1, -0.7)*/
{38, 0,123,__LINE__, 0xc0012d68, 0x4477830c, 0xbff00000, 0x00000000, 0xbfe4cccc, 0xccccccca},	/* -2.14717=f(-1, -0.65)*/
{38, 0,123,__LINE__, 0xc000e3c5, 0x21fab41e, 0xbff00000, 0x00000000, 0xbfe33333, 0x33333330},	/* -2.11122=f(-1, -0.6)*/
{39, 0,123,__LINE__, 0xc00096d0, 0x54ac2aa5, 0xbff00000, 0x00000000, 0xbfe19999, 0x99999996},	/* -2.07364=f(-1, -0.55)*/
{64, 0,123,__LINE__, 0xc000468a, 0x8ace4df6, 0xbff00000, 0x00000000, 0xbfdfffff, 0xfffffff9},	/* -2.03444=f(-1, -0.5)*/
{38, 0,123,__LINE__, 0xbfffe5fd, 0xcc168c31, 0xbff00000, 0x00000000, 0xbfdccccc, 0xccccccc6},	/* -1.99365=f(-1, -0.45)*/
{39, 0,123,__LINE__, 0xbfff3889, 0x307f2704, 0xbff00000, 0x00000000, 0xbfd99999, 0x99999993},	/* -1.9513=f(-1, -0.4)*/
{39, 0,123,__LINE__, 0xbffe8500, 0x7581b836, 0xbff00000, 0x00000000, 0xbfd66666, 0x66666660},	/* -1.90747=f(-1, -0.35)*/
{38, 0,123,__LINE__, 0xbffdcbc9, 0xf0bb681e, 0xbff00000, 0x00000000, 0xbfd33333, 0x3333332d},	/* -1.86225=f(-1, -0.3)*/
{63, 0,123,__LINE__, 0xbffd0d6a, 0x1369bd34, 0xbff00000, 0x00000000, 0xbfcfffff, 0xfffffff4},	/* -1.81577=f(-1, -0.25)*/
{40, 0,123,__LINE__, 0xbffc4a83, 0x9427fe28, 0xbff00000, 0x00000000, 0xbfc99999, 0x9999998e},	/* -1.76819=f(-1, -0.2)*/
{39, 0,123,__LINE__, 0xbffb83d5, 0xc2cfbcf1, 0xbff00000, 0x00000000, 0xbfc33333, 0x33333328},	/* -1.71969=f(-1, -0.15)*/
{41, 0,123,__LINE__, 0xbffaba39, 0x7cd7bcb7, 0xbff00000, 0x00000000, 0xbfb99999, 0x99999983},	/* -1.67046=f(-1, -0.1)*/
{42, 0,123,__LINE__, 0xbff9ee9c, 0x8133d495, 0xbff00000, 0x00000000, 0xbfa99999, 0x9999996c},	/* -1.62075=f(-1, -0.05)*/
{64, 0,123,__LINE__, 0xbff921fb, 0x54442d17, 0xbff00000, 0x00000000, 0x3cb70000, 0x00000000},	/* -1.5708=f(-1, 3.19189e-16)*/
{42, 0,123,__LINE__, 0xbff8555a, 0x2754859c, 0xbff00000, 0x00000000, 0x3fa99999, 0x999999c8},	/* -1.52084=f(-1, 0.05)*/
{41, 0,123,__LINE__, 0xbff789bd, 0x2bb09d7a, 0xbff00000, 0x00000000, 0x3fb99999, 0x999999b1},	/* -1.47113=f(-1, 0.1)*/
{39, 0,123,__LINE__, 0xbff6c020, 0xe5b89d3f, 0xbff00000, 0x00000000, 0x3fc33333, 0x3333333f},	/* -1.42191=f(-1, 0.15)*/
{40, 0,123,__LINE__, 0xbff5f973, 0x14605c08, 0xbff00000, 0x00000000, 0x3fc99999, 0x999999a6},	/* -1.3734=f(-1, 0.2)*/
{62, 0,123,__LINE__, 0xbff5368c, 0x951e9cfd, 0xbff00000, 0x00000000, 0x3fd00000, 0x00000006},	/* -1.32582=f(-1, 0.25)*/
{38, 0,123,__LINE__, 0xbff4782c, 0xb7ccf213, 0xbff00000, 0x00000000, 0x3fd33333, 0x33333339},	/* -1.27934=f(-1, 0.3)*/
{39, 0,123,__LINE__, 0xbff3bef6, 0x3306a1fb, 0xbff00000, 0x00000000, 0x3fd66666, 0x6666666c},	/* -1.23412=f(-1, 0.35)*/
{39, 0,123,__LINE__, 0xbff30b6d, 0x7809332d, 0xbff00000, 0x00000000, 0x3fd99999, 0x9999999f},	/* -1.19029=f(-1, 0.4)*/
{38, 0,123,__LINE__, 0xbff25df8, 0xdc71cdff, 0xbff00000, 0x00000000, 0x3fdccccc, 0xccccccd2},	/* -1.14794=f(-1, 0.45)*/
{63, 0,123,__LINE__, 0xbff1b6e1, 0x92ebbe44, 0xbff00000, 0x00000000, 0x3fe00000, 0x00000003},	/* -1.10715=f(-1, 0.5)*/
{38, 0,123,__LINE__, 0xbff11655, 0xff3004e7, 0xbff00000, 0x00000000, 0x3fe19999, 0x9999999d},	/* -1.06795=f(-1, 0.55)*/
{37, 0,123,__LINE__, 0xbff07c6c, 0x6492f1f4, 0xbff00000, 0x00000000, 0x3fe33333, 0x33333337},	/* -1.03038=f(-1, 0.6)*/
{36, 0,123,__LINE__, 0xbfefd24c, 0x3f32a830, 0xbff00000, 0x00000000, 0x3fe4cccc, 0xccccccd1},	/* -0.994421=f(-1, 0.65)*/
{37, 0,123,__LINE__, 0xbfeeb8e5, 0x7f581e6d, 0xbff00000, 0x00000000, 0x3fe66666, 0x6666666b},	/* -0.96007=f(-1, 0.7)*/
{62, 0,123,__LINE__, 0xbfedac67, 0x0561bb4f, 0xbff00000, 0x00000000, 0x3fe80000, 0x00000005},	/* -0.927295=f(-1, 0.75)*/
{38, 0,123,__LINE__, 0xbfecac7c, 0x539d6960, 0xbff00000, 0x00000000, 0x3fe99999, 0x9999999f},	/* -0.896055=f(-1, 0.8)*/
{37, 0,123,__LINE__, 0xbfebb8bf, 0x7e555094, 0xbff00000, 0x00000000, 0x3feb3333, 0x33333339},	/* -0.866302=f(-1, 0.85)*/
{37, 0,123,__LINE__, 0xbfead0be, 0x0794b975, 0xbff00000, 0x00000000, 0x3feccccc, 0xccccccd3},	/* -0.837981=f(-1, 0.9)*/
{38, 0,123,__LINE__, 0xbfe9f3fc, 0xb0c867c5, 0xbff00000, 0x00000000, 0x3fee6666, 0x6666666d},	/* -0.811034=f(-1, 0.95)*/
{40, 0,123,__LINE__, 0xc0030dfc, 0xd654307d, 0xbfee6666, 0x66666666, 0xbff00000, 0x00000000},	/* -2.38183=f(-0.95, -1)*/
{64, 0,123,__LINE__, 0xc002d97c, 0x7f3321d2, 0xbfee6666, 0x66666666, 0xbfee6666, 0x66666666},	/* -2.35619=f(-0.95, -0.95)*/
{40, 0,123,__LINE__, 0xc002a225, 0xfef74a14, 0xbfee6666, 0x66666666, 0xbfeccccc, 0xcccccccc},	/* -2.32917=f(-0.95, -0.9)*/
{38, 0,123,__LINE__, 0xc00267d3, 0x4ea03e52, 0xbfee6666, 0x66666666, 0xbfeb3333, 0x33333332},	/* -2.3007=f(-0.95, -0.85)*/
{39, 0,123,__LINE__, 0xc0022a5f, 0x1ac3f85c, 0xbfee6666, 0x66666666, 0xbfe99999, 0x99999998},	/* -2.27069=f(-0.95, -0.8)*/
{40, 0,123,__LINE__, 0xc001e9a5, 0xca64e70e, 0xbfee6666, 0x66666666, 0xbfe7ffff, 0xfffffffe},	/* -2.23909=f(-0.95, -0.75)*/
{41, 0,123,__LINE__, 0xc001a586, 0x8f7d3f64, 0xbfee6666, 0x66666666, 0xbfe66666, 0x66666664},	/* -2.20582=f(-0.95, -0.7)*/
{39, 0,123,__LINE__, 0xc0015de4, 0xc8f3d1de, 0xbfee6666, 0x66666666, 0xbfe4cccc, 0xccccccca},	/* -2.17085=f(-0.95, -0.65)*/
{38, 0,123,__LINE__, 0xc00112a9, 0xa2107b28, 0xbfee6666, 0x66666666, 0xbfe33333, 0x33333330},	/* -2.13411=f(-0.95, -0.6)*/
{39, 0,123,__LINE__, 0xc000c3c5, 0xcc427e74, 0xbfee6666, 0x66666666, 0xbfe19999, 0x99999996},	/* -2.09559=f(-0.95, -0.55)*/
{40, 0,123,__LINE__, 0xc0007133, 0xa1ba9242, 0xbfee6666, 0x66666666, 0xbfdfffff, 0xfffffff9},	/* -2.05527=f(-0.95, -0.5)*/
{40, 0,123,__LINE__, 0xc0001af9, 0x288afa1a, 0xbfee6666, 0x66666666, 0xbfdccccc, 0xccccccc6},	/* -2.01317=f(-0.95, -0.45)*/
{38, 0,123,__LINE__, 0xbfff8254, 0x69548f10, 0xbfee6666, 0x66666666, 0xbfd99999, 0x99999993},	/* -1.96932=f(-0.95, -0.4)*/
{41, 0,123,__LINE__, 0xbffec7d4, 0x939893a3, 0xbfee6666, 0x66666666, 0xbfd66666, 0x66666660},	/* -1.92379=f(-0.95, -0.35)*/
{37, 0,123,__LINE__, 0xbffe06dc, 0x969f7431, 0xbfee6666, 0x66666666, 0xbfd33333, 0x3333332d},	/* -1.87668=f(-0.95, -0.3)*/
{40, 0,123,__LINE__, 0xbffd3ffa, 0xcddcfb20, 0xbfee6666, 0x66666666, 0xbfcfffff, 0xfffffff4},	/* -1.82812=f(-0.95, -0.25)*/
{39, 0,123,__LINE__, 0xbffc73e2, 0xe5e9c35b, 0xbfee6666, 0x66666666, 0xbfc99999, 0x9999998e},	/* -1.77829=f(-0.95, -0.2)*/
{38, 0,123,__LINE__, 0xbffba36c, 0x4eafc4eb, 0xbfee6666, 0x66666666, 0xbfc33333, 0x33333328},	/* -1.7274=f(-0.95, -0.15)*/
{40, 0,123,__LINE__, 0xbffacf8e, 0xc5e7c661, 0xbfee6666, 0x66666666, 0xbfb99999, 0x99999983},	/* -1.67567=f(-0.95, -0.1)*/
{41, 0,123,__LINE__, 0xbff9f95c, 0xaac6432f, 0xbfee6666, 0x66666666, 0xbfa99999, 0x9999996c},	/* -1.62338=f(-0.95, -0.05)*/
{64, 0,123,__LINE__, 0xbff921fb, 0x54442d17, 0xbfee6666, 0x66666666, 0x3cb70000, 0x00000000},	/* -1.5708=f(-0.95, 3.19189e-16)*/
{41, 0,123,__LINE__, 0xbff84a99, 0xfdc21701, 0xbfee6666, 0x66666666, 0x3fa99999, 0x999999c8},	/* -1.51821=f(-0.95, 0.05)*/
{40, 0,123,__LINE__, 0xbff77467, 0xe2a093cf, 0xbfee6666, 0x66666666, 0x3fb99999, 0x999999b1},	/* -1.46592=f(-0.95, 0.1)*/
{38, 0,123,__LINE__, 0xbff6a08a, 0x59d89546, 0xbfee6666, 0x66666666, 0x3fc33333, 0x3333333f},	/* -1.41419=f(-0.95, 0.15)*/
{39, 0,123,__LINE__, 0xbff5d013, 0xc29e96d6, 0xbfee6666, 0x66666666, 0x3fc99999, 0x999999a6},	/* -1.3633=f(-0.95, 0.2)*/
{40, 0,123,__LINE__, 0xbff503fb, 0xdaab5f11, 0xbfee6666, 0x66666666, 0x3fd00000, 0x00000006},	/* -1.31347=f(-0.95, 0.25)*/
{37, 0,123,__LINE__, 0xbff43d1a, 0x11e8e600, 0xbfee6666, 0x66666666, 0x3fd33333, 0x33333339},	/* -1.26492=f(-0.95, 0.3)*/
{41, 0,123,__LINE__, 0xbff37c22, 0x14efc68e, 0xbfee6666, 0x66666666, 0x3fd66666, 0x6666666c},	/* -1.21781=f(-0.95, 0.35)*/
{38, 0,123,__LINE__, 0xbff2c1a2, 0x3f33cb20, 0xbfee6666, 0x66666666, 0x3fd99999, 0x9999999f},	/* -1.17227=f(-0.95, 0.4)*/
{39, 0,123,__LINE__, 0xbff20e04, 0x577265fd, 0xbfee6666, 0x66666666, 0x3fdccccc, 0xccccccd2},	/* -1.12842=f(-0.95, 0.45)*/
{39, 0,123,__LINE__, 0xbff1618f, 0x651335ad, 0xbfee6666, 0x66666666, 0x3fe00000, 0x00000003},	/* -1.08632=f(-0.95, 0.5)*/
{38, 0,123,__LINE__, 0xbff0bc6b, 0x10035d49, 0xbfee6666, 0x66666666, 0x3fe19999, 0x9999999d},	/* -1.046=f(-0.95, 0.55)*/
{37, 0,123,__LINE__, 0xbff01ea3, 0x646763e0, 0xbfee6666, 0x66666666, 0x3fe33333, 0x33333337},	/* -1.00748=f(-0.95, 0.6)*/
{37, 0,123,__LINE__, 0xbfef105a, 0x2d416ce9, 0xbfee6666, 0x66666666, 0x3fe4cccc, 0xccccccd1},	/* -0.970746=f(-0.95, 0.65)*/
{39, 0,123,__LINE__, 0xbfedf1d3, 0x131bb6d2, 0xbfee6666, 0x66666666, 0x3fe66666, 0x6666666b},	/* -0.93577=f(-0.95, 0.7)*/
{38, 0,123,__LINE__, 0xbfece156, 0x277d182b, 0xbfee6666, 0x66666666, 0x3fe80000, 0x00000005},	/* -0.902507=f(-0.95, 0.75)*/
{37, 0,123,__LINE__, 0xbfebde70, 0xe600d2ef, 0xbfee6666, 0x66666666, 0x3fe99999, 0x9999999f},	/* -0.870903=f(-0.95, 0.8)*/
{36, 0,123,__LINE__, 0xbfeae8a0, 0x168fbb1a, 0xbfee6666, 0x66666666, 0x3feb3333, 0x33333339},	/* -0.840897=f(-0.95, 0.85)*/
{38, 0,123,__LINE__, 0xbfe9ff55, 0x55338c10, 0xbfee6666, 0x66666666, 0x3feccccc, 0xccccccd3},	/* -0.812419=f(-0.95, 0.9)*/
{62, 0,123,__LINE__, 0xbfe921fb, 0x54442d18, 0xbfee6666, 0x66666666, 0x3fee6666, 0x6666666d},	/* -0.785398=f(-0.95, 0.95)*/
{39, 0,123,__LINE__, 0xc003452d, 0x2c0744e9, 0xbfeccccc, 0xcccccccc, 0xbff00000, 0x00000000},	/* -2.40878=f(-0.9, -1)*/
{40, 0,123,__LINE__, 0xc00310d2, 0xff6ef990, 0xbfeccccc, 0xcccccccc, 0xbfee6666, 0x66666666},	/* -2.38321=f(-0.9, -0.95)*/
{64, 0,123,__LINE__, 0xc002d97c, 0x7f3321d2, 0xbfeccccc, 0xcccccccc, 0xbfeccccc, 0xcccccccc},	/* -2.35619=f(-0.9, -0.9)*/
{38, 0,123,__LINE__, 0xc0029efc, 0xed986c97, 0xbfeccccc, 0xcccccccc, 0xbfeb3333, 0x33333332},	/* -2.32763=f(-0.9, -0.85)*/
{38, 0,123,__LINE__, 0xc0026127, 0x88ed3aee, 0xbfeccccc, 0xcccccccc, 0xbfe99999, 0x99999998},	/* -2.29744=f(-0.9, -0.8)*/
{39, 0,123,__LINE__, 0xc0021fd0, 0x9cde17a8, 0xbfeccccc, 0xcccccccc, 0xbfe7ffff, 0xfffffffe},	/* -2.26553=f(-0.9, -0.75)*/
{40, 0,123,__LINE__, 0xc001dace, 0xaafb4a30, 0xbfeccccc, 0xcccccccc, 0xbfe66666, 0x66666664},	/* -2.23184=f(-0.9, -0.7)*/
{40, 0,123,__LINE__, 0xc00191fb, 0xf67ba3bd, 0xbfeccccc, 0xcccccccc, 0xbfe4cccc, 0xccccccca},	/* -2.19628=f(-0.9, -0.65)*/
{37, 0,123,__LINE__, 0xc0014538, 0x63bdf116, 0xbfeccccc, 0xcccccccc, 0xbfe33333, 0x33333330},	/* -2.1588=f(-0.9, -0.6)*/
{38, 0,123,__LINE__, 0xc000f46b, 0x8b80920e, 0xbfeccccc, 0xcccccccc, 0xbfe19999, 0x99999996},	/* -2.11935=f(-0.9, -0.55)*/
{39, 0,123,__LINE__, 0xc0009f87, 0x54c63a5d, 0xbfeccccc, 0xcccccccc, 0xbfdfffff, 0xfffffff9},	/* -2.07789=f(-0.9, -0.5)*/
{64, 0,123,__LINE__, 0xc000468a, 0x8ace4df6, 0xbfeccccc, 0xcccccccc, 0xbfdccccc, 0xccccccc6},	/* -2.03444=f(-0.9, -0.45)*/
{37, 0,123,__LINE__, 0xbfffd307, 0x5702cb99, 0xbfeccccc, 0xcccccccc, 0xbfd99999, 0x99999993},	/* -1.98902=f(-0.9, -0.4)*/
{40, 0,123,__LINE__, 0xbfff1127, 0x095cf298, 0xbfeccccc, 0xcccccccc, 0xbfd66666, 0x66666660},	/* -1.94169=f(-0.9, -0.35)*/
{37, 0,123,__LINE__, 0xbffe47df, 0x42632a28, 0xbfeccccc, 0xcccccccc, 0xbfd33333, 0x3333332d},	/* -1.89255=f(-0.9, -0.3)*/
{39, 0,123,__LINE__, 0xbffd77c7, 0xb36c27c3, 0xbfeccccc, 0xcccccccc, 0xbfcfffff, 0xfffffff4},	/* -1.84174=f(-0.9, -0.25)*/
{38, 0,123,__LINE__, 0xbffca1a6, 0x58d1662c, 0xbfeccccc, 0xcccccccc, 0xbfc99999, 0x9999998e},	/* -1.78947=f(-0.9, -0.2)*/
{38, 0,123,__LINE__, 0xbffbc66e, 0x47adc512, 0xbfeccccc, 0xcccccccc, 0xbfc33333, 0x33333328},	/* -1.73595=f(-0.9, -0.15)*/
{39, 0,123,__LINE__, 0xbffae73b, 0xd71c804f, 0xbfeccccc, 0xcccccccc, 0xbfb99999, 0x99999983},	/* -1.68145=f(-0.9, -0.1)*/
{40, 0,123,__LINE__, 0xbffa054d, 0xbb71d497, 0xbfeccccc, 0xcccccccc, 0xbfa99999, 0x9999996c},	/* -1.62629=f(-0.9, -0.05)*/
{64, 0,123,__LINE__, 0xbff921fb, 0x54442d17, 0xbfeccccc, 0xcccccccc, 0x3cb70000, 0x00000000},	/* -1.5708=f(-0.9, 3.19189e-16)*/
{40, 0,123,__LINE__, 0xbff83ea8, 0xed16859a, 0xbfeccccc, 0xcccccccc, 0x3fa99999, 0x999999c8},	/* -1.5153=f(-0.9, 0.05)*/
{39, 0,123,__LINE__, 0xbff75cba, 0xd16bd9e1, 0xbfeccccc, 0xcccccccc, 0x3fb99999, 0x999999b1},	/* -1.46014=f(-0.9, 0.1)*/
{38, 0,123,__LINE__, 0xbff67d88, 0x60da951f, 0xbfeccccc, 0xcccccccc, 0x3fc33333, 0x3333333f},	/* -1.40565=f(-0.9, 0.15)*/
{38, 0,123,__LINE__, 0xbff5a250, 0x4fb6f405, 0xbfeccccc, 0xcccccccc, 0x3fc99999, 0x999999a6},	/* -1.35213=f(-0.9, 0.2)*/
{39, 0,123,__LINE__, 0xbff4cc2e, 0xf51c326e, 0xbfeccccc, 0xcccccccc, 0x3fd00000, 0x00000006},	/* -1.29985=f(-0.9, 0.25)*/
{37, 0,123,__LINE__, 0xbff3fc17, 0x66253009, 0xbfeccccc, 0xcccccccc, 0x3fd33333, 0x33333339},	/* -1.24905=f(-0.9, 0.3)*/
{40, 0,123,__LINE__, 0xbff332cf, 0x9f2b6799, 0xbfeccccc, 0xcccccccc, 0x3fd66666, 0x6666666c},	/* -1.19991=f(-0.9, 0.35)*/
{37, 0,123,__LINE__, 0xbff270ef, 0x51858e97, 0xbfeccccc, 0xcccccccc, 0x3fd99999, 0x9999999f},	/* -1.15257=f(-0.9, 0.4)*/
{63, 0,123,__LINE__, 0xbff1b6e1, 0x92ebbe44, 0xbfeccccc, 0xcccccccc, 0x3fdccccc, 0xccccccd2},	/* -1.10715=f(-0.9, 0.45)*/
{38, 0,123,__LINE__, 0xbff104e7, 0xfefbe577, 0xbfeccccc, 0xcccccccc, 0x3fe00000, 0x00000003},	/* -1.0637=f(-0.9, 0.5)*/
{37, 0,123,__LINE__, 0xbff05b1f, 0x91873616, 0xbfeccccc, 0xcccccccc, 0x3fe19999, 0x9999999d},	/* -1.02225=f(-0.9, 0.55)*/
{35, 0,123,__LINE__, 0xbfef730b, 0xc218f009, 0xbfeccccc, 0xcccccccc, 0x3fe33333, 0x33333337},	/* -0.982794=f(-0.9, 0.6)*/
{38, 0,123,__LINE__, 0xbfee3ffd, 0x7722256d, 0xbfeccccc, 0xcccccccc, 0x3fe4cccc, 0xccccccd1},	/* -0.945311=f(-0.9, 0.65)*/
{38, 0,123,__LINE__, 0xbfed1cb2, 0xa5238ba3, 0xbfeccccc, 0xcccccccc, 0x3fe66666, 0x6666666b},	/* -0.909753=f(-0.9, 0.7)*/
{37, 0,123,__LINE__, 0xbfec08aa, 0xdd9855c3, 0xbfeccccc, 0xcccccccc, 0x3fe80000, 0x00000005},	/* -0.876058=f(-0.9, 0.75)*/
{36, 0,123,__LINE__, 0xbfeb034f, 0x2d5bc8a9, 0xbfeccccc, 0xcccccccc, 0x3fe99999, 0x9999999f},	/* -0.844154=f(-0.9, 0.8)*/
{36, 0,123,__LINE__, 0xbfea0bf9, 0x9aaf0206, 0xbfeccccc, 0xcccccccc, 0x3feb3333, 0x33333339},	/* -0.813962=f(-0.9, 0.85)*/
{61, 0,123,__LINE__, 0xbfe921fb, 0x54442d18, 0xbfeccccc, 0xcccccccc, 0x3feccccc, 0xccccccd3},	/* -0.785398=f(-0.9, 0.9)*/
{38, 0,123,__LINE__, 0xbfe844a1, 0x5354ce20, 0xbfeccccc, 0xcccccccc, 0x3fee6666, 0x6666666d},	/* -0.758378=f(-0.9, 0.95)*/
{39, 0,123,__LINE__, 0xc0037f2d, 0x89b76ab1, 0xbfeb3333, 0x33333332, 0xbff00000, 0x00000000},	/* -2.4371=f(-0.85, -1)*/
{38, 0,123,__LINE__, 0xc0034b25, 0xafc60553, 0xbfeb3333, 0x33333332, 0xbfee6666, 0x66666666},	/* -2.41169=f(-0.85, -0.95)*/
{38, 0,123,__LINE__, 0xc00313fc, 0x10cdd70e, 0xbfeb3333, 0x33333332, 0xbfeccccc, 0xcccccccc},	/* -2.38476=f(-0.85, -0.9)*/
{64, 0,123,__LINE__, 0xc002d97c, 0x7f3321d2, 0xbfeb3333, 0x33333332, 0xbfeb3333, 0x33333332},	/* -2.35619=f(-0.85, -0.85)*/
{40, 0,123,__LINE__, 0xc0029b71, 0xd6b0ac0f, 0xbfeb3333, 0x33333332, 0xbfe99999, 0x99999998},	/* -2.3259=f(-0.85, -0.8)*/
{39, 0,123,__LINE__, 0xc00259a7, 0x0e784bfd, 0xbfeb3333, 0x33333332, 0xbfe7ffff, 0xfffffffe},	/* -2.29378=f(-0.85, -0.75)*/
{38, 0,123,__LINE__, 0xc00213e8, 0x71506718, 0xbfeb3333, 0x33333332, 0xbfe66666, 0x66666664},	/* -2.25972=f(-0.85, -0.7)*/
{37, 0,123,__LINE__, 0xc001ca05, 0x4d7ff400, 0xbfeb3333, 0x33333332, 0xbfe4cccc, 0xccccccca},	/* -2.22364=f(-0.85, -0.65)*/
{40, 0,123,__LINE__, 0xc0017bd2, 0x13c3d3f3, 0xbfeb3333, 0x33333332, 0xbfe33333, 0x33333330},	/* -2.18546=f(-0.85, -0.6)*/
{41, 0,123,__LINE__, 0xc001292a, 0xcb3a7791, 0xbfeb3333, 0x33333332, 0xbfe19999, 0x99999996},	/* -2.1451=f(-0.85, -0.55)*/
{39, 0,123,__LINE__, 0xc000d1f6, 0x34b7e310, 0xbfeb3333, 0x33333332, 0xbfdfffff, 0xfffffff9},	/* -2.10252=f(-0.85, -0.5)*/
{38, 0,123,__LINE__, 0xc0007629, 0x13c3c8d9, 0xbfeb3333, 0x33333332, 0xbfdccccc, 0xccccccc6},	/* -2.0577=f(-0.85, -0.45)*/
{40, 0,123,__LINE__, 0xc00015c9, 0xd998b0f0, 0xbfeb3333, 0x33333332, 0xbfd99999, 0x99999993},	/* -2.01064=f(-0.85, -0.4)*/
{37, 0,123,__LINE__, 0xbfff61e8, 0x7be5d383, 0xbfeb3333, 0x33333332, 0xbfd66666, 0x66666660},	/* -1.9614=f(-0.85, -0.35)*/
{40, 0,123,__LINE__, 0xbffe8fb9, 0x6cede8b6, 0xbfeb3333, 0x33333332, 0xbfd33333, 0x3333332d},	/* -1.91009=f(-0.85, -0.3)*/
{38, 0,123,__LINE__, 0xbffdb5a5, 0xff6cc905, 0xbfeb3333, 0x33333332, 0xbfcfffff, 0xfffffff4},	/* -1.85685=f(-0.85, -0.25)*/
{40, 0,123,__LINE__, 0xbffcd487, 0x741b023a, 0xbfeb3333, 0x33333332, 0xbfc99999, 0x9999998e},	/* -1.80189=f(-0.85, -0.2)*/
{40, 0,123,__LINE__, 0xbffbed70, 0x6831cc6b, 0xbfeb3333, 0x33333332, 0xbfc33333, 0x33333328},	/* -1.74547=f(-0.85, -0.15)*/
{41, 0,123,__LINE__, 0xbffb01a8, 0xbf1b2cae, 0xbfeb3333, 0x33333332, 0xbfb99999, 0x99999983},	/* -1.68791=f(-0.85, -0.1)*/
{42, 0,123,__LINE__, 0xbffa12a5, 0x461f6da4, 0xbfeb3333, 0x33333332, 0xbfa99999, 0x9999996c},	/* -1.62955=f(-0.85, -0.05)*/
{64, 0,123,__LINE__, 0xbff921fb, 0x54442d17, 0xbfeb3333, 0x33333332, 0x3cb70000, 0x00000000},	/* -1.5708=f(-0.85, 3.19189e-16)*/
{42, 0,123,__LINE__, 0xbff83151, 0x6268ec8d, 0xbfeb3333, 0x33333332, 0x3fa99999, 0x999999c8},	/* -1.51204=f(-0.85, 0.05)*/
{41, 0,123,__LINE__, 0xbff7424d, 0xe96d2d82, 0xbfeb3333, 0x33333332, 0x3fb99999, 0x999999b1},	/* -1.45369=f(-0.85, 0.1)*/
{40, 0,123,__LINE__, 0xbff65686, 0x40568dc6, 0xbfeb3333, 0x33333332, 0x3fc33333, 0x3333333f},	/* -1.39612=f(-0.85, 0.15)*/
{40, 0,123,__LINE__, 0xbff56f6f, 0x346d57f6, 0xbfeb3333, 0x33333332, 0x3fc99999, 0x999999a6},	/* -1.33971=f(-0.85, 0.2)*/
{38, 0,123,__LINE__, 0xbff48e50, 0xa91b912b, 0xbfeb3333, 0x33333332, 0x3fd00000, 0x00000006},	/* -1.28474=f(-0.85, 0.25)*/
{40, 0,123,__LINE__, 0xbff3b43d, 0x3b9a717b, 0xbfeb3333, 0x33333332, 0x3fd33333, 0x33333339},	/* -1.2315=f(-0.85, 0.3)*/
{37, 0,123,__LINE__, 0xbff2e20e, 0x2ca286ae, 0xbfeb3333, 0x33333332, 0x3fd66666, 0x6666666c},	/* -1.18019=f(-0.85, 0.35)*/
{39, 0,123,__LINE__, 0xbff21862, 0xf556f851, 0xbfeb3333, 0x33333332, 0x3fd99999, 0x9999999f},	/* -1.13095=f(-0.85, 0.4)*/
{37, 0,123,__LINE__, 0xbff157a4, 0x8100c87f, 0xbfeb3333, 0x33333332, 0x3fdccccc, 0xccccccd2},	/* -1.0839=f(-0.85, 0.45)*/
{38, 0,123,__LINE__, 0xbff0a00a, 0x3f189411, 0xbfeb3333, 0x33333332, 0x3fe00000, 0x00000003},	/* -1.03907=f(-0.85, 0.5)*/
{39, 0,123,__LINE__, 0xbfefe342, 0x2426d61b, 0xbfeb3333, 0x33333332, 0x3fe19999, 0x9999999d},	/* -0.996491=f(-0.85, 0.55)*/
{38, 0,123,__LINE__, 0xbfee98a5, 0x02016495, 0xbfeb3333, 0x33333332, 0x3fe33333, 0x33333337},	/* -0.956133=f(-0.85, 0.6)*/
{35, 0,123,__LINE__, 0xbfed5fd8, 0x1b10e461, 0xbfeb3333, 0x33333332, 0x3fe4cccc, 0xccccccd1},	/* -0.91795=f(-0.85, 0.65)*/
{36, 0,123,__LINE__, 0xbfec384b, 0x8bcf1801, 0xbfeb3333, 0x33333332, 0x3fe66666, 0x6666666b},	/* -0.881872=f(-0.85, 0.7)*/
{37, 0,123,__LINE__, 0xbfeb2151, 0x172f846d, 0xbfeb3333, 0x33333332, 0x3fe80000, 0x00000005},	/* -0.847817=f(-0.85, 0.75)*/
{38, 0,123,__LINE__, 0xbfea1a25, 0xf64e0423, 0xbfeb3333, 0x33333332, 0x3fe99999, 0x9999999f},	/* -0.815692=f(-0.85, 0.8)*/
{61, 0,123,__LINE__, 0xbfe921fb, 0x54442d18, 0xbfeb3333, 0x33333332, 0x3feb3333, 0x33333339},	/* -0.785398=f(-0.85, 0.85)*/
{36, 0,123,__LINE__, 0xbfe837fd, 0x0dd9582a, 0xbfeb3333, 0x33333332, 0x3feccccc, 0xccccccd3},	/* -0.756835=f(-0.85, 0.9)*/
{36, 0,123,__LINE__, 0xbfe75b56, 0x91f89f16, 0xbfeb3333, 0x33333332, 0x3fee6666, 0x6666666d},	/* -0.7299=f(-0.85, 0.95)*/
{40, 0,123,__LINE__, 0xc003bc1c, 0xbf0970e4, 0xbfe99999, 0x99999998, 0xbff00000, 0x00000000},	/* -2.46685=f(-0.8, -1)*/
{39, 0,123,__LINE__, 0xc0038899, 0xe3a24b48, 0xbfe99999, 0x99999998, 0xbfee6666, 0x66666666},	/* -2.4417=f(-0.8, -0.95)*/
{38, 0,123,__LINE__, 0xc00351d1, 0x757908b6, 0xbfe99999, 0x99999998, 0xbfeccccc, 0xcccccccc},	/* -2.41495=f(-0.8, -0.9)*/
{40, 0,123,__LINE__, 0xc0031787, 0x27b59795, 0xbfe99999, 0x99999998, 0xbfeb3333, 0x33333332},	/* -2.38649=f(-0.8, -0.85)*/
{64, 0,123,__LINE__, 0xc002d97c, 0x7f3321d2, 0xbfe99999, 0x99999998, 0xbfe99999, 0x99999998},	/* -2.35619=f(-0.8, -0.8)*/
{40, 0,123,__LINE__, 0xc0029771, 0xd6e8015f, 0xbfe99999, 0x99999998, 0xbfe7ffff, 0xfffffffe},	/* -2.32395=f(-0.8, -0.75)*/
{38, 0,123,__LINE__, 0xc0025127, 0x99607098, 0xbfe99999, 0x99999998, 0xbfe66666, 0x66666664},	/* -2.28963=f(-0.8, -0.7)*/
{38, 0,123,__LINE__, 0xc0020660, 0x088459ee, 0xbfe99999, 0x99999998, 0xbfe4cccc, 0xccccccca},	/* -2.25311=f(-0.8, -0.65)*/
{39, 0,123,__LINE__, 0xc001b6e1, 0x948557dd, 0xbfe99999, 0x99999998, 0xbfe33333, 0x33333330},	/* -2.2143=f(-0.8, -0.6)*/
{41, 0,123,__LINE__, 0xc0016279, 0xb1c24a2b, 0xbfe99999, 0x99999998, 0xbfe19999, 0x99999996},	/* -2.17308=f(-0.8, -0.55)*/
{40, 0,123,__LINE__, 0xc0010900, 0x9433b976, 0xbfe99999, 0x99999998, 0xbfdfffff, 0xfffffff9},	/* -2.1294=f(-0.8, -0.5)*/
{38, 0,123,__LINE__, 0xc000aa5d, 0x4cf92bad, 0xbfe99999, 0x99999998, 0xbfdccccc, 0xccccccc6},	/* -2.08319=f(-0.8, -0.45)*/
{64, 0,123,__LINE__, 0xc000468a, 0x8ace4df6, 0xbfe99999, 0x99999998, 0xbfd99999, 0x99999993},	/* -2.03444=f(-0.8, -0.4)*/
{38, 0,123,__LINE__, 0xbfffbb37, 0x021170d9, 0xbfe99999, 0x99999998, 0xbfd66666, 0x66666660},	/* -1.98321=f(-0.8, -0.35)*/
{38, 0,123,__LINE__, 0xbffedf81, 0xa6ee7d60, 0xbfe99999, 0x99999998, 0xbfd33333, 0x3333332d},	/* -1.92957=f(-0.8, -0.3)*/
{39, 0,123,__LINE__, 0xbffdfa99, 0x20e2a04d, 0xbfe99999, 0x99999998, 0xbfcfffff, 0xfffffff4},	/* -1.87368=f(-0.8, -0.25)*/
{63, 0,123,__LINE__, 0xbffd0d6a, 0x1369bd34, 0xbfe99999, 0x99999998, 0xbfc99999, 0x9999998e},	/* -1.81577=f(-0.8, -0.2)*/
{39, 0,123,__LINE__, 0xbffc192a, 0xbef31a48, 0xbfe99999, 0x99999998, 0xbfc33333, 0x33333328},	/* -1.75614=f(-0.8, -0.15)*/
{63, 0,123,__LINE__, 0xbffb1f56, 0xfdeef00f, 0xbfe99999, 0x99999998, 0xbfb99999, 0x99999983},	/* -1.69515=f(-0.8, -0.1)*/
{62, 0,123,__LINE__, 0xbffa21a6, 0x31fd9508, 0xbfe99999, 0x99999998, 0xbfa99999, 0x9999996c},	/* -1.63322=f(-0.8, -0.05)*/
{64, 0,123,__LINE__, 0xbff921fb, 0x54442d16, 0xbfe99999, 0x99999998, 0x3cb70000, 0x00000000},	/* -1.5708=f(-0.8, 3.19189e-16)*/
{62, 0,123,__LINE__, 0xbff82250, 0x768ac529, 0xbfe99999, 0x99999998, 0x3fa99999, 0x999999c8},	/* -1.50838=f(-0.8, 0.05)*/
{63, 0,123,__LINE__, 0xbff7249f, 0xaa996a21, 0xbfe99999, 0x99999998, 0x3fb99999, 0x999999b1},	/* -1.44644=f(-0.8, 0.1)*/
{39, 0,123,__LINE__, 0xbff62acb, 0xe9953fe9, 0xbfe99999, 0x99999998, 0x3fc33333, 0x3333333f},	/* -1.38545=f(-0.8, 0.15)*/
{62, 0,123,__LINE__, 0xbff5368c, 0x951e9cfd, 0xbfe99999, 0x99999998, 0x3fc99999, 0x999999a6},	/* -1.32582=f(-0.8, 0.2)*/
{39, 0,123,__LINE__, 0xbff4495d, 0x87a5b9e3, 0xbfe99999, 0x99999998, 0x3fd00000, 0x00000006},	/* -1.26791=f(-0.8, 0.25)*/
{38, 0,123,__LINE__, 0xbff36475, 0x0199dcd1, 0xbfe99999, 0x99999998, 0x3fd33333, 0x33333339},	/* -1.21203=f(-0.8, 0.3)*/
{38, 0,123,__LINE__, 0xbff288bf, 0xa676e958, 0xbfe99999, 0x99999998, 0x3fd66666, 0x6666666c},	/* -1.15839=f(-0.8, 0.35)*/
{63, 0,123,__LINE__, 0xbff1b6e1, 0x92ebbe44, 0xbfe99999, 0x99999998, 0x3fd99999, 0x9999999f},	/* -1.10715=f(-0.8, 0.4)*/
{37, 0,123,__LINE__, 0xbff0ef3c, 0x0e9602d6, 0xbfe99999, 0x99999998, 0x3fdccccc, 0xccccccd2},	/* -1.05841=f(-0.8, 0.45)*/
{39, 0,123,__LINE__, 0xbff031f5, 0x8020e745, 0xbfe99999, 0x99999998, 0x3fe00000, 0x00000003},	/* -1.0122=f(-0.8, 0.5)*/
{39, 0,123,__LINE__, 0xbfeefe06, 0x8a078bb6, 0xbfe99999, 0x99999998, 0x3fe19999, 0x9999999d},	/* -0.968509=f(-0.8, 0.55)*/
{37, 0,123,__LINE__, 0xbfedac66, 0xfefb54ec, 0xbfe99999, 0x99999998, 0x3fe33333, 0x33333337},	/* -0.927295=f(-0.8, 0.6)*/
{36, 0,123,__LINE__, 0xbfec6e6d, 0x2eff4ca7, 0xbfe99999, 0x99999998, 0x3fe4cccc, 0xccccccd1},	/* -0.88848=f(-0.8, 0.65)*/
{36, 0,123,__LINE__, 0xbfeb434e, 0xeb8ef201, 0xbfe99999, 0x99999998, 0x3fe66666, 0x6666666b},	/* -0.851966=f(-0.8, 0.7)*/
{38, 0,123,__LINE__, 0xbfea2a25, 0xf570aee4, 0xbfe99999, 0x99999998, 0x3fe80000, 0x00000005},	/* -0.817645=f(-0.8, 0.75)*/
{61, 0,123,__LINE__, 0xbfe921fb, 0x54442d18, 0xbfe99999, 0x99999998, 0x3fe99999, 0x9999999f},	/* -0.785398=f(-0.8, 0.8)*/
{38, 0,123,__LINE__, 0xbfe829d0, 0xb23a560d, 0xbfe99999, 0x99999998, 0x3feb3333, 0x33333339},	/* -0.755104=f(-0.8, 0.85)*/
{36, 0,123,__LINE__, 0xbfe740a7, 0x7b2c9187, 0xbfe99999, 0x99999998, 0x3feccccc, 0xccccccd3},	/* -0.726642=f(-0.8, 0.9)*/
{37, 0,123,__LINE__, 0xbfe66585, 0xc2878741, 0xbfe99999, 0x99999998, 0x3fee6666, 0x6666666d},	/* -0.699893=f(-0.8, 0.95)*/
{64, 0,123,__LINE__, 0xc003fc17, 0x6b7a8560, 0xbfe7ffff, 0xfffffffe, 0xbff00000, 0x00000000},	/* -2.49809=f(-0.75, -1)*/
{40, 0,123,__LINE__, 0xc003c953, 0x34015c97, 0xbfe7ffff, 0xfffffffe, 0xbfee6666, 0x66666666},	/* -2.4733=f(-0.75, -0.95)*/
{39, 0,123,__LINE__, 0xc0039328, 0x61882bfd, 0xbfe7ffff, 0xfffffffe, 0xbfeccccc, 0xcccccccc},	/* -2.44685=f(-0.75, -0.9)*/
{39, 0,123,__LINE__, 0xc0035951, 0xefedf7a7, 0xbfe7ffff, 0xfffffffe, 0xbfeb3333, 0x33333332},	/* -2.41861=f(-0.75, -0.85)*/
{40, 0,123,__LINE__, 0xc0031b87, 0x277e4245, 0xbfe7ffff, 0xfffffffe, 0xbfe99999, 0x99999998},	/* -2.38844=f(-0.75, -0.8)*/
{64, 0,123,__LINE__, 0xc002d97c, 0x7f3321d2, 0xbfe7ffff, 0xfffffffe, 0xbfe7ffff, 0xfffffffe},	/* -2.35619=f(-0.75, -0.75)*/
{39, 0,123,__LINE__, 0xc00292e4, 0xc1a321e3, 0xbfe7ffff, 0xfffffffe, 0xbfe66666, 0x66666664},	/* -2.32173=f(-0.75, -0.7)*/
{38, 0,123,__LINE__, 0xc0024772, 0xd6d9aaf6, 0xbfe7ffff, 0xfffffffe, 0xbfe4cccc, 0xccccccca},	/* -2.28489=f(-0.75, -0.65)*/
{38, 0,123,__LINE__, 0xc001f6dc, 0x40fd155a, 0xbfe7ffff, 0xfffffffe, 0xbfe33333, 0x33333330},	/* -2.24554=f(-0.75, -0.6)*/
{39, 0,123,__LINE__, 0xc001a0dc, 0x4a8c907c, 0xbfe7ffff, 0xfffffffe, 0xbfe19999, 0x99999996},	/* -2.20355=f(-0.75, -0.55)*/
{64, 0,123,__LINE__, 0xc0014538, 0x5fa3af71, 0xbfe7ffff, 0xfffffffe, 0xbfdfffff, 0xfffffff9},	/* -2.1588=f(-0.75, -0.5)*/
{39, 0,123,__LINE__, 0xc000e3c5, 0x1e0ec833, 0xbfe7ffff, 0xfffffffe, 0xbfdccccc, 0xccccccc6},	/* -2.11122=f(-0.75, -0.45)*/
{40, 0,123,__LINE__, 0xc0007c6c, 0x6a1c3f04, 0xbfe7ffff, 0xfffffffe, 0xbfd99999, 0x99999993},	/* -2.06075=f(-0.75, -0.4)*/
{40, 0,123,__LINE__, 0xc0000f34, 0x0aa16924, 0xbfe7ffff, 0xfffffffe, 0xbfd66666, 0x66666660},	/* -2.00742=f(-0.75, -0.35)*/
{38, 0,123,__LINE__, 0xbfff3889, 0x32cba87c, 0xbfe7ffff, 0xfffffffe, 0xbfd33333, 0x3333332d},	/* -1.9513=f(-0.75, -0.3)*/
{63, 0,123,__LINE__, 0xbffe47df, 0x3d0dd4d1, 0xbfe7ffff, 0xfffffffe, 0xbfcfffff, 0xfffffff4},	/* -1.89255=f(-0.75, -0.25)*/
{40, 0,123,__LINE__, 0xbffd4d68, 0xbf20242a, 0xbfe7ffff, 0xfffffffe, 0xbfc99999, 0x9999998e},	/* -1.8314=f(-0.75, -0.2)*/
{38, 0,123,__LINE__, 0xbffc4a83, 0x957032ac, 0xbfe7ffff, 0xfffffffe, 0xbfc33333, 0x33333328},	/* -1.76819=f(-0.75, -0.15)*/
{40, 0,123,__LINE__, 0xbffb40e9, 0xafce4e9c, 0xbfe7ffff, 0xfffffffe, 0xbfb99999, 0x99999983},	/* -1.70335=f(-0.75, -0.1)*/
{41, 0,123,__LINE__, 0xbffa32a5, 0x1bee177b, 0xbfe7ffff, 0xfffffffe, 0xbfa99999, 0x9999996c},	/* -1.63736=f(-0.75, -0.05)*/
{64, 0,123,__LINE__, 0xbff921fb, 0x54442d16, 0xbfe7ffff, 0xfffffffe, 0x3cb70000, 0x00000000},	/* -1.5708=f(-0.75, 3.19189e-16)*/
{41, 0,123,__LINE__, 0xbff81151, 0x8c9a42b6, 0xbfe7ffff, 0xfffffffe, 0x3fa99999, 0x999999c8},	/* -1.50423=f(-0.75, 0.05)*/
{40, 0,123,__LINE__, 0xbff7030c, 0xf8ba0b95, 0xbfe7ffff, 0xfffffffe, 0x3fb99999, 0x999999b1},	/* -1.43824=f(-0.75, 0.1)*/
{38, 0,123,__LINE__, 0xbff5f973, 0x13182785, 0xbfe7ffff, 0xfffffffe, 0x3fc33333, 0x3333333f},	/* -1.3734=f(-0.75, 0.15)*/
{40, 0,123,__LINE__, 0xbff4f68d, 0xe9683606, 0xbfe7ffff, 0xfffffffe, 0x3fc99999, 0x999999a6},	/* -1.31019=f(-0.75, 0.2)*/
{62, 0,123,__LINE__, 0xbff3fc17, 0x6b7a8560, 0xbfe7ffff, 0xfffffffe, 0x3fd00000, 0x00000006},	/* -1.24905=f(-0.75, 0.25)*/
{38, 0,123,__LINE__, 0xbff30b6d, 0x75bcb1b4, 0xbfe7ffff, 0xfffffffe, 0x3fd33333, 0x33333339},	/* -1.19029=f(-0.75, 0.3)*/
{39, 0,123,__LINE__, 0xbff2258e, 0x934587e9, 0xbfe7ffff, 0xfffffffe, 0x3fd66666, 0x6666666c},	/* -1.13417=f(-0.75, 0.35)*/
{39, 0,123,__LINE__, 0xbff14b1d, 0xd44fdc29, 0xbfe7ffff, 0xfffffffe, 0x3fd99999, 0x9999999f},	/* -1.08084=f(-0.75, 0.4)*/
{38, 0,123,__LINE__, 0xbff07c6c, 0x6c6ac9cb, 0xbfe7ffff, 0xfffffffe, 0x3fdccccc, 0xccccccd2},	/* -1.03038=f(-0.75, 0.45)*/
{61, 0,123,__LINE__, 0xbfef730b, 0xd281f69b, 0xbfe7ffff, 0xfffffffe, 0x3fe00000, 0x00000003},	/* -0.982794=f(-0.75, 0.5)*/
{37, 0,123,__LINE__, 0xbfee047c, 0x26de7270, 0xbfe7ffff, 0xfffffffe, 0x3fe19999, 0x9999999d},	/* -0.938047=f(-0.75, 0.55)*/
{36, 0,123,__LINE__, 0xbfecac7c, 0x4d1c5efa, 0xbfe7ffff, 0xfffffffe, 0x3fe33333, 0x33333337},	/* -0.896055=f(-0.75, 0.6)*/
{36, 0,123,__LINE__, 0xbfeb6a21, 0xf5aa088b, 0xbfe7ffff, 0xfffffffe, 0x3fe4cccc, 0xccccccd1},	/* -0.856706=f(-0.75, 0.65)*/
{37, 0,123,__LINE__, 0xbfea3c5a, 0x4a842cd7, 0xbfe7ffff, 0xfffffffe, 0x3fe66666, 0x6666666b},	/* -0.819867=f(-0.75, 0.7)*/
{61, 0,123,__LINE__, 0xbfe921fb, 0x54442d18, 0xbfe7ffff, 0xfffffffe, 0x3fe80000, 0x00000005},	/* -0.785398=f(-0.75, 0.75)*/
{38, 0,123,__LINE__, 0xbfe819d0, 0xb317ab4d, 0xbfe7ffff, 0xfffffffe, 0x3fe99999, 0x9999999f},	/* -0.753151=f(-0.75, 0.8)*/
{37, 0,123,__LINE__, 0xbfe722a5, 0x9158d5c3, 0xbfe7ffff, 0xfffffffe, 0x3feb3333, 0x33333339},	/* -0.722979=f(-0.75, 0.85)*/
{37, 0,123,__LINE__, 0xbfe63b4b, 0xcaf0046e, 0xbfe7ffff, 0xfffffffe, 0x3feccccc, 0xccccccd3},	/* -0.694738=f(-0.75, 0.9)*/
{38, 0,123,__LINE__, 0xbfe562a0, 0x810b4205, 0xbfe7ffff, 0xfffffffe, 0x3fee6666, 0x6666666d},	/* -0.668289=f(-0.75, 0.95)*/
{39, 0,123,__LINE__, 0xc0043f37, 0x09f81e27, 0xbfe66666, 0x66666664, 0xbff00000, 0x00000000},	/* -2.53087=f(-0.7, -1)*/
{41, 0,123,__LINE__, 0xc0040d72, 0x6ee90441, 0xbfe66666, 0x66666664, 0xbfee6666, 0x66666666},	/* -2.50657=f(-0.7, -0.95)*/
{40, 0,123,__LINE__, 0xc003d82a, 0x536af975, 0xbfe66666, 0x66666664, 0xbfeccccc, 0xcccccccc},	/* -2.48055=f(-0.7, -0.9)*/
{38, 0,123,__LINE__, 0xc0039f10, 0x8d15dc8c, 0xbfe66666, 0x66666664, 0xbfeb3333, 0x33333332},	/* -2.45267=f(-0.7, -0.85)*/
{38, 0,123,__LINE__, 0xc00361d1, 0x6505d30c, 0xbfe66666, 0x66666664, 0xbfe99999, 0x99999998},	/* -2.42276=f(-0.7, -0.8)*/
{39, 0,123,__LINE__, 0xc0032014, 0x3cc321c2, 0xbfe66666, 0x66666664, 0xbfe7ffff, 0xfffffffe},	/* -2.39066=f(-0.7, -0.75)*/
{64, 0,123,__LINE__, 0xc002d97c, 0x7f3321d2, 0xbfe66666, 0x66666664, 0xbfe66666, 0x66666664},	/* -2.35619=f(-0.7, -0.7)*/
{39, 0,123,__LINE__, 0xc0028dab, 0x4a0ab17c, 0xbfe66666, 0x66666664, 0xbfe4cccc, 0xccccccca},	/* -2.31917=f(-0.7, -0.65)*/
{38, 0,123,__LINE__, 0xc0023c41, 0xee24d9c7, 0xbfe66666, 0x66666664, 0xbfe33333, 0x33333330},	/* -2.27942=f(-0.7, -0.6)*/
{38, 0,123,__LINE__, 0xc001e4e5, 0x5a9da0a8, 0xbfe66666, 0x66666664, 0xbfe19999, 0x99999996},	/* -2.23677=f(-0.7, -0.55)*/
{39, 0,123,__LINE__, 0xc0018743, 0x080419df, 0xbfe66666, 0x66666664, 0xbfdfffff, 0xfffffff9},	/* -2.19105=f(-0.7, -0.5)*/
{40, 0,123,__LINE__, 0xc0012317, 0x0c052249, 0xbfe66666, 0x66666664, 0xbfdccccc, 0xccccccc6},	/* -2.14213=f(-0.7, -0.45)*/
{39, 0,123,__LINE__, 0xc000b833, 0xbfeefa53, 0xbfe66666, 0x66666664, 0xbfd99999, 0x99999993},	/* -2.08994=f(-0.7, -0.4)*/
{64, 0,123,__LINE__, 0xc000468a, 0x8ace4df6, 0xbfe66666, 0x66666664, 0xbfd66666, 0x66666660},	/* -2.03444=f(-0.7, -0.35)*/
{37, 0,123,__LINE__, 0xbfff9c6b, 0x2910ce24, 0xbfe66666, 0x66666664, 0xbfd33333, 0x3333332d},	/* -1.97569=f(-0.7, -0.3)*/
{39, 0,123,__LINE__, 0xbffe9f02, 0x01947c89, 0xbfe66666, 0x66666664, 0xbfcfffff, 0xfffffff4},	/* -1.91382=f(-0.7, -0.25)*/
{38, 0,123,__LINE__, 0xbffd95e5, 0xae666ff2, 0xbfe66666, 0x66666664, 0xbfc99999, 0x9999998e},	/* -1.8491=f(-0.7, -0.2)*/
{38, 0,123,__LINE__, 0xbffc829e, 0xbe8cebc0, 0xbfe66666, 0x66666664, 0xbfc33333, 0x33333328},	/* -1.78189=f(-0.7, -0.15)*/
{39, 0,123,__LINE__, 0xbffb6731, 0x2e062767, 0xbfe66666, 0x66666664, 0xbfb99999, 0x99999983},	/* -1.71269=f(-0.7, -0.1)*/
{40, 0,123,__LINE__, 0xbffa460e, 0xa0b387f9, 0xbfe66666, 0x66666664, 0xbfa99999, 0x9999996c},	/* -1.6421=f(-0.7, -0.05)*/
{64, 0,123,__LINE__, 0xbff921fb, 0x54442d16, 0xbfe66666, 0x66666664, 0x3cb70000, 0x00000000},	/* -1.5708=f(-0.7, 3.19189e-16)*/
{40, 0,123,__LINE__, 0xbff7fde8, 0x07d4d238, 0xbfe66666, 0x66666664, 0x3fa99999, 0x999999c8},	/* -1.49949=f(-0.7, 0.05)*/
{39, 0,123,__LINE__, 0xbff6dcc5, 0x7a8232c9, 0xbfe66666, 0x66666664, 0x3fb99999, 0x999999b1},	/* -1.4289=f(-0.7, 0.1)*/
{38, 0,123,__LINE__, 0xbff5c157, 0xe9fb6e70, 0xbfe66666, 0x66666664, 0x3fc33333, 0x3333333f},	/* -1.3597=f(-0.7, 0.15)*/
{38, 0,123,__LINE__, 0xbff4ae10, 0xfa21ea3f, 0xbfe66666, 0x66666664, 0x3fc99999, 0x999999a6},	/* -1.2925=f(-0.7, 0.2)*/
{39, 0,123,__LINE__, 0xbff3a4f4, 0xa6f3dda7, 0xbfe66666, 0x66666664, 0x3fd00000, 0x00000006},	/* -1.22777=f(-0.7, 0.25)*/
{37, 0,123,__LINE__, 0xbff2a78b, 0x7f778c0d, 0xbfe66666, 0x66666664, 0x3fd33333, 0x33333339},	/* -1.1659=f(-0.7, 0.3)*/
{62, 0,123,__LINE__, 0xbff1b6e1, 0x92ebbe44, 0xbfe66666, 0x66666664, 0x3fd66666, 0x6666666c},	/* -1.10715=f(-0.7, 0.35)*/
{38, 0,123,__LINE__, 0xbff0d38f, 0x28aa658a, 0xbfe66666, 0x66666664, 0x3fd99999, 0x9999999f},	/* -1.05165=f(-0.7, 0.4)*/
{38, 0,123,__LINE__, 0xbfeffb91, 0x20fc2b3c, 0xbfe66666, 0x66666664, 0x3fdccccc, 0xccccccd2},	/* -0.999459=f(-0.7, 0.45)*/
{37, 0,123,__LINE__, 0xbfee6ae1, 0x31004ce4, 0xbfe66666, 0x66666664, 0x3fe00000, 0x00000003},	/* -0.950547=f(-0.7, 0.5)*/
{36, 0,123,__LINE__, 0xbfecf457, 0xe69a31c2, 0xbfe66666, 0x66666664, 0x3fe19999, 0x9999999d},	/* -0.904827=f(-0.7, 0.55)*/
{36, 0,123,__LINE__, 0xbfeb96e5, 0x987d4d44, 0xbfe66666, 0x66666664, 0x3fe33333, 0x33333337},	/* -0.86217=f(-0.7, 0.6)*/
{37, 0,123,__LINE__, 0xbfea5140, 0x28e5ee73, 0xbfe66666, 0x66666664, 0x3fe4cccc, 0xccccccd1},	/* -0.822418=f(-0.7, 0.65)*/
{61, 0,123,__LINE__, 0xbfe921fb, 0x54442d18, 0xbfe66666, 0x66666664, 0x3fe66666, 0x6666666b},	/* -0.785398=f(-0.7, 0.7)*/
{37, 0,123,__LINE__, 0xbfe8079c, 0x5e042d5a, 0xbfe66666, 0x66666664, 0x3fe80000, 0x00000005},	/* -0.750929=f(-0.7, 0.75)*/
{36, 0,123,__LINE__, 0xbfe700a7, 0xbcf9682f, 0xbfe66666, 0x66666664, 0x3fe99999, 0x9999999f},	/* -0.71883=f(-0.7, 0.8)*/
{36, 0,123,__LINE__, 0xbfe60bab, 0x1cb9422f, 0xbfe66666, 0x66666664, 0x3feb3333, 0x33333339},	/* -0.688924=f(-0.7, 0.85)*/
{38, 0,123,__LINE__, 0xbfe52744, 0x0364ce8e, 0xbfe66666, 0x66666664, 0x3feccccc, 0xccccccd3},	/* -0.661043=f(-0.7, 0.9)*/
{39, 0,123,__LINE__, 0xbfe45223, 0x956ca35f, 0xbfe66666, 0x66666664, 0x3fee6666, 0x6666666d},	/* -0.635027=f(-0.7, 0.95)*/
{38, 0,123,__LINE__, 0xc0048590, 0xb9eec098, 0xbfe4cccc, 0xccccccca, 0xbff00000, 0x00000000},	/* -2.56522=f(-0.65, -1)*/
{39, 0,123,__LINE__, 0xc0045514, 0x357271c6, 0xbfe4cccc, 0xccccccca, 0xbfee6666, 0x66666666},	/* -2.54154=f(-0.65, -0.95)*/
{40, 0,123,__LINE__, 0xc00420fd, 0x07ea9fe7, 0xbfe4cccc, 0xccccccca, 0xbfeccccc, 0xcccccccc},	/* -2.51611=f(-0.65, -0.9)*/
{37, 0,123,__LINE__, 0xc003e8f3, 0xb0e64fa4, 0xbfe4cccc, 0xccccccca, 0xbfeb3333, 0x33333332},	/* -2.48875=f(-0.65, -0.85)*/
{38, 0,123,__LINE__, 0xc003ac98, 0xf5e1e9b6, 0xbfe4cccc, 0xccccccca, 0xbfe99999, 0x99999998},	/* -2.45928=f(-0.65, -0.8)*/
{38, 0,123,__LINE__, 0xc0036b86, 0x278c98af, 0xbfe4cccc, 0xccccccca, 0xbfe7ffff, 0xfffffffe},	/* -2.4275=f(-0.65, -0.75)*/
{39, 0,123,__LINE__, 0xc003254d, 0xb45b9229, 0xbfe4cccc, 0xccccccca, 0xbfe66666, 0x66666664},	/* -2.39321=f(-0.65, -0.7)*/
{64, 0,123,__LINE__, 0xc002d97c, 0x7f3321d2, 0xbfe4cccc, 0xccccccca, 0xbfe4cccc, 0xccccccca},	/* -2.35619=f(-0.65, -0.65)*/
{37, 0,123,__LINE__, 0xc002879c, 0x2bc1e7ec, 0xbfe4cccc, 0xccccccca, 0xbfe33333, 0x33333330},	/* -2.31622=f(-0.65, -0.6)*/
{38, 0,123,__LINE__, 0xc0022f36, 0x8fd08aae, 0xbfe4cccc, 0xccccccca, 0xbfe19999, 0x99999996},	/* -2.27305=f(-0.65, -0.55)*/
{38, 0,123,__LINE__, 0xc001cfdb, 0x05b9dc1d, 0xbfe4cccc, 0xccccccca, 0xbfdfffff, 0xfffffff9},	/* -2.22649=f(-0.65, -0.5)*/
{40, 0,123,__LINE__, 0xc0016925, 0x77b9888e, 0xbfe4cccc, 0xccccccca, 0xbfdccccc, 0xccccccc6},	/* -2.17634=f(-0.65, -0.45)*/
{38, 0,123,__LINE__, 0xc000fac7, 0xc39e3edc, 0xbfe4cccc, 0xccccccca, 0xbfd99999, 0x99999993},	/* -2.12245=f(-0.65, -0.4)*/
{39, 0,123,__LINE__, 0xc0008495, 0x338921ac, 0xbfe4cccc, 0xccccccca, 0xbfd66666, 0x66666660},	/* -2.06474=f(-0.65, -0.35)*/
{38, 0,123,__LINE__, 0xc000068f, 0xe33e014a, 0xbfe4cccc, 0xccccccca, 0xbfd33333, 0x3333332d},	/* -2.0032=f(-0.65, -0.3)*/
{38, 0,123,__LINE__, 0xbfff01ed, 0x0313d9ef, 0xbfe4cccc, 0xccccccca, 0xbfcfffff, 0xfffffff4},	/* -1.93797=f(-0.65, -0.25)*/
{38, 0,123,__LINE__, 0xbffde8a2, 0x28f95b99, 0xbfe4cccc, 0xccccccca, 0xbfc99999, 0x9999998e},	/* -1.8693=f(-0.65, -0.2)*/
{37, 0,123,__LINE__, 0xbffcc2f3, 0x2cf5541f, 0xbfe4cccc, 0xccccccca, 0xbfc33333, 0x33333328},	/* -1.7976=f(-0.65, -0.15)*/
{38, 0,123,__LINE__, 0xbffb933b, 0xc26c5140, 0xbfe4cccc, 0xccccccca, 0xbfb99999, 0x99999983},	/* -1.72345=f(-0.65, -0.1)*/
{39, 0,123,__LINE__, 0xbffa5c70, 0x7ef753c5, 0xbfe4cccc, 0xccccccca, 0xbfa99999, 0x9999996c},	/* -1.64757=f(-0.65, -0.05)*/
{64, 0,123,__LINE__, 0xbff921fb, 0x54442d16, 0xbfe4cccc, 0xccccccca, 0x3cb70000, 0x00000000},	/* -1.5708=f(-0.65, 3.19189e-16)*/
{39, 0,123,__LINE__, 0xbff7e786, 0x2991066c, 0xbfe4cccc, 0xccccccca, 0x3fa99999, 0x999999c8},	/* -1.49402=f(-0.65, 0.05)*/
{38, 0,123,__LINE__, 0xbff6b0ba, 0xe61c08f1, 0xbfe4cccc, 0xccccccca, 0x3fb99999, 0x999999b1},	/* -1.41815=f(-0.65, 0.1)*/
{37, 0,123,__LINE__, 0xbff58103, 0x7b930612, 0xbfe4cccc, 0xccccccca, 0x3fc33333, 0x3333333f},	/* -1.344=f(-0.65, 0.15)*/
{38, 0,123,__LINE__, 0xbff45b54, 0x7f8efe97, 0xbfe4cccc, 0xccccccca, 0x3fc99999, 0x999999a6},	/* -1.2723=f(-0.65, 0.2)*/
{38, 0,123,__LINE__, 0xbff34209, 0xa5748041, 0xbfe4cccc, 0xccccccca, 0x3fd00000, 0x00000006},	/* -1.20362=f(-0.65, 0.25)*/
{37, 0,123,__LINE__, 0xbff236d6, 0xe20c579d, 0xbfe4cccc, 0xccccccca, 0x3fd33333, 0x33333339},	/* -1.13839=f(-0.65, 0.3)*/
{38, 0,123,__LINE__, 0xbff13acc, 0x417616d9, 0xbfe4cccc, 0xccccccca, 0x3fd66666, 0x6666666c},	/* -1.07685=f(-0.65, 0.35)*/
{37, 0,123,__LINE__, 0xbff04e67, 0x214bdc7a, 0xbfe4cccc, 0xccccccca, 0x3fd99999, 0x9999999f},	/* -1.01914=f(-0.65, 0.4)*/
{38, 0,123,__LINE__, 0xbfeee357, 0x722a9227, 0xbfe4cccc, 0xccccccca, 0x3fdccccc, 0xccccccd2},	/* -0.965252=f(-0.65, 0.45)*/
{36, 0,123,__LINE__, 0xbfed4881, 0x3a2943ec, 0xbfe4cccc, 0xccccccca, 0x3fe00000, 0x00000003},	/* -0.915101=f(-0.65, 0.5)*/
{36, 0,123,__LINE__, 0xbfebcb13, 0x11ce89a8, 0xbfe4cccc, 0xccccccca, 0x3fe19999, 0x9999999d},	/* -0.868539=f(-0.65, 0.55)*/
{35, 0,123,__LINE__, 0xbfea697c, 0xa20914b3, 0xbfe4cccc, 0xccccccca, 0x3fe33333, 0x33333337},	/* -0.825377=f(-0.65, 0.6)*/
{61, 0,123,__LINE__, 0xbfe921fb, 0x54442d18, 0xbfe4cccc, 0xccccccca, 0x3fe4cccc, 0xccccccd1},	/* -0.785398=f(-0.65, 0.65)*/
{37, 0,123,__LINE__, 0xbfe7f2b6, 0x7fa26bbe, 0xbfe4cccc, 0xccccccca, 0x3fe66666, 0x6666666b},	/* -0.748378=f(-0.65, 0.7)*/
{36, 0,123,__LINE__, 0xbfe6d9d4, 0xb2de51a6, 0xbfe4cccc, 0xccccccca, 0x3fe80000, 0x00000005},	/* -0.714091=f(-0.65, 0.75)*/
{36, 0,123,__LINE__, 0xbfe5d589, 0x79890d89, 0xbfe4cccc, 0xccccccca, 0x3fe99999, 0x9999999f},	/* -0.682317=f(-0.65, 0.8)*/
{35, 0,123,__LINE__, 0xbfe4e41e, 0x8d7775cf, 0xbfe4cccc, 0xccccccca, 0x3feb3333, 0x33333339},	/* -0.652847=f(-0.65, 0.85)*/
{38, 0,123,__LINE__, 0xbfe403f9, 0x316634c4, 0xbfe4cccc, 0xccccccca, 0x3feccccc, 0xccccccd3},	/* -0.625485=f(-0.65, 0.9)*/
{37, 0,123,__LINE__, 0xbfe3339c, 0x7b46ed47, 0xbfe4cccc, 0xccccccca, 0x3fee6666, 0x6666666d},	/* -0.60005=f(-0.65, 0.95)*/
{38, 0,123,__LINE__, 0xc004cf33, 0xdc6b8f86, 0xbfe33333, 0x33333330, 0xbff00000, 0x00000000},	/* -2.60117=f(-0.6, -1)*/
{38, 0,123,__LINE__, 0xc004a04f, 0x5c55c87c, 0xbfe33333, 0x33333330, 0xbfee6666, 0x66666666},	/* -2.57828=f(-0.6, -0.95)*/
{37, 0,123,__LINE__, 0xc0046dc0, 0x9aa8528e, 0xbfe33333, 0x33333330, 0xbfeccccc, 0xcccccccc},	/* -2.55359=f(-0.6, -0.9)*/
{40, 0,123,__LINE__, 0xc0043726, 0xeaa26fb2, 0xbfe33333, 0x33333330, 0xbfeb3333, 0x33333332},	/* -2.52693=f(-0.6, -0.85)*/
{39, 0,123,__LINE__, 0xc003fc17, 0x69e0ebc7, 0xbfe33333, 0x33333330, 0xbfe99999, 0x99999998},	/* -2.49809=f(-0.6, -0.8)*/
{38, 0,123,__LINE__, 0xc003bc1c, 0xbd692e4b, 0xbfe33333, 0x33333330, 0xbfe7ffff, 0xfffffffe},	/* -2.46685=f(-0.6, -0.75)*/
{38, 0,123,__LINE__, 0xc00376b7, 0x104169dd, 0xbfe33333, 0x33333330, 0xbfe66666, 0x66666664},	/* -2.43297=f(-0.6, -0.7)*/
{37, 0,123,__LINE__, 0xc0032b5c, 0xd2a45bb9, 0xbfe33333, 0x33333330, 0xbfe4cccc, 0xccccccca},	/* -2.39617=f(-0.6, -0.65)*/
{64, 0,123,__LINE__, 0xc002d97c, 0x7f3321d2, 0xbfe33333, 0x33333330, 0xbfe33333, 0x33333330},	/* -2.35619=f(-0.6, -0.6)*/
{39, 0,123,__LINE__, 0xc002807f, 0xb5887de1, 0xbfe33333, 0x33333330, 0xbfe19999, 0x99999996},	/* -2.31274=f(-0.6, -0.55)*/
{38, 0,123,__LINE__, 0xc0021fd0, 0x987ef77b, 0xbfe33333, 0x33333330, 0xbfdfffff, 0xfffffff9},	/* -2.26553=f(-0.6, -0.5)*/
{37, 0,123,__LINE__, 0xc001b6e1, 0x8ea77a01, 0xbfe33333, 0x33333330, 0xbfdccccc, 0xccccccc6},	/* -2.2143=f(-0.6, -0.45)*/
{39, 0,123,__LINE__, 0xc0014538, 0x5e19d6d5, 0xbfe33333, 0x33333330, 0xbfd99999, 0x99999993},	/* -2.1588=f(-0.6, -0.4)*/
{38, 0,123,__LINE__, 0xc000ca7c, 0xbf7fee8b, 0xbfe33333, 0x33333330, 0xbfd66666, 0x66666660},	/* -2.09887=f(-0.6, -0.35)*/
{64, 0,123,__LINE__, 0xc000468a, 0x8ace4df6, 0xbfe33333, 0x33333330, 0xbfd33333, 0x3333332d},	/* -2.03444=f(-0.6, -0.3)*/
{38, 0,123,__LINE__, 0xbfff730b, 0xceb87ef2, 0xbfe33333, 0x33333330, 0xbfcfffff, 0xfffffff4},	/* -1.96559=f(-0.6, -0.25)*/
{39, 0,123,__LINE__, 0xbffe47df, 0x3b0dd4d2, 0xbfe33333, 0x33333330, 0xbfc99999, 0x9999998e},	/* -1.89255=f(-0.6, -0.2)*/
{63, 0,123,__LINE__, 0xbffd0d6a, 0x1369bd34, 0xbfe33333, 0x33333330, 0xbfc33333, 0x33333328},	/* -1.81577=f(-0.6, -0.15)*/
{39, 0,123,__LINE__, 0xbffbc66e, 0x43b6feba, 0xbfe33333, 0x33333330, 0xbfb99999, 0x99999983},	/* -1.73595=f(-0.6, -0.1)*/
{40, 0,123,__LINE__, 0xbffa7687, 0x3a357eb2, 0xbfe33333, 0x33333330, 0xbfa99999, 0x9999996c},	/* -1.65394=f(-0.6, -0.05)*/
{64, 0,123,__LINE__, 0xbff921fb, 0x54442d16, 0xbfe33333, 0x33333330, 0x3cb70000, 0x00000000},	/* -1.5708=f(-0.6, 3.19189e-16)*/
{40, 0,123,__LINE__, 0xbff7cd6f, 0x6e52db7f, 0xbfe33333, 0x33333330, 0x3fa99999, 0x999999c8},	/* -1.48766=f(-0.6, 0.05)*/
{39, 0,123,__LINE__, 0xbff67d88, 0x64d15b77, 0xbfe33333, 0x33333330, 0x3fb99999, 0x999999b1},	/* -1.40565=f(-0.6, 0.1)*/
{62, 0,123,__LINE__, 0xbff5368c, 0x951e9cfd, 0xbfe33333, 0x33333330, 0x3fc33333, 0x3333333f},	/* -1.32582=f(-0.6, 0.15)*/
{38, 0,123,__LINE__, 0xbff3fc17, 0x6d7a855f, 0xbfe33333, 0x33333330, 0x3fc99999, 0x999999a6},	/* -1.24905=f(-0.6, 0.2)*/
{38, 0,123,__LINE__, 0xbff2d0ea, 0xd9cfdb3e, 0xbfe33333, 0x33333330, 0x3fd00000, 0x00000006},	/* -1.17601=f(-0.6, 0.25)*/
{62, 0,123,__LINE__, 0xbff1b6e1, 0x92ebbe44, 0xbfe33333, 0x33333330, 0x3fd33333, 0x33333339},	/* -1.10715=f(-0.6, 0.3)*/
{37, 0,123,__LINE__, 0xbff0aefd, 0x29887d1b, 0xbfe33333, 0x33333330, 0x3fd66666, 0x6666666c},	/* -1.04272=f(-0.6, 0.35)*/
{37, 0,123,__LINE__, 0xbfef730b, 0xd8a9590e, 0xbfe33333, 0x33333330, 0x3fd99999, 0x9999999f},	/* -0.982794=f(-0.6, 0.4)*/
{35, 0,123,__LINE__, 0xbfedac67, 0x1672cc5c, 0xbfe33333, 0x33333330, 0x3fdccccc, 0xccccccd2},	/* -0.927295=f(-0.6, 0.45)*/
{36, 0,123,__LINE__, 0xbfec08aa, 0xef14d674, 0xbfe33333, 0x33333330, 0x3fe00000, 0x00000003},	/* -0.876058=f(-0.6, 0.5)*/
{37, 0,123,__LINE__, 0xbfea85ee, 0x7aeebcde, 0xbfe33333, 0x33333330, 0x3fe19999, 0x9999999d},	/* -0.828849=f(-0.6, 0.55)*/
{61, 0,123,__LINE__, 0xbfe921fb, 0x54442d18, 0xbfe33333, 0x33333330, 0x3fe33333, 0x33333337},	/* -0.785398=f(-0.6, 0.6)*/
{35, 0,123,__LINE__, 0xbfe7da7a, 0x067f457e, 0xbfe33333, 0x33333330, 0x3fe4cccc, 0xccccccd1},	/* -0.74542=f(-0.6, 0.65)*/
{36, 0,123,__LINE__, 0xbfe6ad11, 0x100b0cec, 0xbfe33333, 0x33333330, 0x3fe66666, 0x6666666b},	/* -0.708626=f(-0.6, 0.7)*/
{36, 0,123,__LINE__, 0xbfe5977a, 0x5b6bfb36, 0xbfe33333, 0x33333330, 0x3fe80000, 0x00000005},	/* -0.674741=f(-0.6, 0.75)*/
{37, 0,123,__LINE__, 0xbfe4978f, 0xa98d0545, 0xbfe33333, 0x33333330, 0x3fe99999, 0x9999999f},	/* -0.643501=f(-0.6, 0.8)*/
{38, 0,123,__LINE__, 0xbfe3ab51, 0xa686f59b, 0xbfe33333, 0x33333330, 0x3feb3333, 0x33333339},	/* -0.614663=f(-0.6, 0.85)*/
{35, 0,123,__LINE__, 0xbfe2d0ea, 0xe66f6a28, 0xbfe33333, 0x33333330, 0x3feccccc, 0xccccccd3},	/* -0.588003=f(-0.6, 0.9)*/
{36, 0,123,__LINE__, 0xbfe206af, 0xdfb99270, 0xbfe33333, 0x33333330, 0x3fee6666, 0x6666666d},	/* -0.563316=f(-0.6, 0.95)*/
{39, 0,123,__LINE__, 0xc0051c28, 0xa9ba18ff, 0xbfe19999, 0x99999996, 0xbff00000, 0x00000000},	/* -2.63875=f(-0.55, -1)*/
{39, 0,123,__LINE__, 0xc004ef33, 0x3223c531, 0xbfe19999, 0x99999996, 0xbfee6666, 0x66666666},	/* -2.6168=f(-0.55, -0.95)*/
{38, 0,123,__LINE__, 0xc004be8d, 0x72e5b197, 0xbfe19999, 0x99999996, 0xbfeccccc, 0xcccccccc},	/* -2.59304=f(-0.55, -0.9)*/
{41, 0,123,__LINE__, 0xc00489ce, 0x332bcc13, 0xbfe19999, 0x99999996, 0xbfeb3333, 0x33333332},	/* -2.56729=f(-0.55, -0.85)*/
{41, 0,123,__LINE__, 0xc004507f, 0x4ca3f97a, 0xbfe19999, 0x99999996, 0xbfe99999, 0x99999998},	/* -2.53931=f(-0.55, -0.8)*/
{39, 0,123,__LINE__, 0xc004121c, 0xb3d9b328, 0xbfe19999, 0x99999996, 0xbfe7ffff, 0xfffffffe},	/* -2.50884=f(-0.55, -0.75)*/
{38, 0,123,__LINE__, 0xc003ce13, 0xa3c8a2fd, 0xbfe19999, 0x99999996, 0xbfe66666, 0x66666664},	/* -2.47562=f(-0.55, -0.7)*/
{38, 0,123,__LINE__, 0xc00383c2, 0x6e95b8f6, 0xbfe19999, 0x99999996, 0xbfe4cccc, 0xccccccca},	/* -2.43934=f(-0.55, -0.65)*/
{39, 0,123,__LINE__, 0xc0033279, 0x48ddc5c4, 0xbfe19999, 0x99999996, 0xbfe33333, 0x33333330},	/* -2.39965=f(-0.55, -0.6)*/
{64, 0,123,__LINE__, 0xc002d97c, 0x7f3321d2, 0xbfe19999, 0x99999996, 0xbfe19999, 0x99999996},	/* -2.35619=f(-0.55, -0.55)*/
{39, 0,123,__LINE__, 0xc0027809, 0x3dbd1e64, 0xbfe19999, 0x99999996, 0xbfdfffff, 0xfffffff9},	/* -2.30861=f(-0.55, -0.5)*/
{38, 0,123,__LINE__, 0xc0020d5d, 0x67f0f4a0, 0xbfe19999, 0x99999996, 0xbfdccccc, 0xccccccc6},	/* -2.25653=f(-0.55, -0.45)*/
{41, 0,123,__LINE__, 0xc00198c4, 0x02a363c0, 0xbfe19999, 0x99999996, 0xbfd99999, 0x99999993},	/* -2.19959=f(-0.55, -0.4)*/
{38, 0,123,__LINE__, 0xc00119a6, 0xfbbf581c, 0xbfe19999, 0x99999996, 0xbfd66666, 0x66666660},	/* -2.13753=f(-0.55, -0.35)*/
{39, 0,123,__LINE__, 0xc0008fa7, 0x299ed3dc, 0xbfe19999, 0x99999996, 0xbfd33333, 0x3333332d},	/* -2.07014=f(-0.55, -0.3)*/
{38, 0,123,__LINE__, 0xbffff572, 0xabbbf35d, 0xbfe19999, 0x99999996, 0xbfcfffff, 0xfffffff4},	/* -1.99742=f(-0.55, -0.25)*/
{40, 0,123,__LINE__, 0xbffeb68c, 0x3b11a9ab, 0xbfe19999, 0x99999996, 0xbfc99999, 0x9999998e},	/* -1.91957=f(-0.55, -0.2)*/
{39, 0,123,__LINE__, 0xbffd648c, 0xd7b8cadb, 0xbfe19999, 0x99999996, 0xbfc33333, 0x33333328},	/* -1.83705=f(-0.55, -0.15)*/
{41, 0,123,__LINE__, 0xbffc02a9, 0x642d2230, 0xbfe19999, 0x99999996, 0xbfb99999, 0x99999983},	/* -1.75065=f(-0.55, -0.1)*/
{42, 0,123,__LINE__, 0xbffa9553, 0x1c4396c4, 0xbfe19999, 0x99999996, 0xbfa99999, 0x9999996c},	/* -1.66146=f(-0.55, -0.05)*/
{64, 0,123,__LINE__, 0xbff921fb, 0x54442d16, 0xbfe19999, 0x99999996, 0x3cb70000, 0x00000000},	/* -1.5708=f(-0.55, 3.19189e-16)*/
{42, 0,123,__LINE__, 0xbff7aea3, 0x8c44c36d, 0xbfe19999, 0x99999996, 0x3fa99999, 0x999999c8},	/* -1.48014=f(-0.55, 0.05)*/
{41, 0,123,__LINE__, 0xbff6414d, 0x445b3801, 0xbfe19999, 0x99999996, 0x3fb99999, 0x999999b1},	/* -1.39094=f(-0.55, 0.1)*/
{39, 0,123,__LINE__, 0xbff4df69, 0xd0cf8f55, 0xbfe19999, 0x99999996, 0x3fc33333, 0x3333333f},	/* -1.30454=f(-0.55, 0.15)*/
{40, 0,123,__LINE__, 0xbff38d6a, 0x6d76b085, 0xbfe19999, 0x99999996, 0x3fc99999, 0x999999a6},	/* -1.22203=f(-0.55, 0.2)*/
{38, 0,123,__LINE__, 0xbff24e83, 0xfccc66d4, 0xbfe19999, 0x99999996, 0x3fd00000, 0x00000006},	/* -1.14417=f(-0.55, 0.25)*/
{38, 0,123,__LINE__, 0xbff124a8, 0x554ab279, 0xbfe19999, 0x99999996, 0x3fd33333, 0x33333339},	/* -1.07145=f(-0.55, 0.3)*/
{37, 0,123,__LINE__, 0xbff010a8, 0xb109a9f8, 0xbfe19999, 0x99999996, 0x3fd66666, 0x6666666c},	/* -1.00407=f(-0.55, 0.35)*/
{39, 0,123,__LINE__, 0xbfee24dd, 0x46832562, 0xbfe19999, 0x99999996, 0x3fd99999, 0x9999999f},	/* -0.942=f(-0.55, 0.4)*/
{36, 0,123,__LINE__, 0xbfec5277, 0xb14ce1e1, 0xbfe19999, 0x99999996, 0x3fdccccc, 0xccccccd2},	/* -0.885067=f(-0.55, 0.45)*/
{37, 0,123,__LINE__, 0xbfeaa7c8, 0x5a1c3ad1, 0xbfe19999, 0x99999996, 0x3fe00000, 0x00000003},	/* -0.832981=f(-0.55, 0.5)*/
{61, 0,123,__LINE__, 0xbfe921fb, 0x54442d18, 0xbfe19999, 0x99999996, 0x3fe19999, 0x9999999d},	/* -0.785398=f(-0.55, 0.55)*/
{37, 0,123,__LINE__, 0xbfe7be08, 0x2d999d53, 0xbfe19999, 0x99999996, 0x3fe33333, 0x33333337},	/* -0.741947=f(-0.55, 0.6)*/
{36, 0,123,__LINE__, 0xbfe678e3, 0x96b9d089, 0xbfe19999, 0x99999996, 0x3fe4cccc, 0xccccccd1},	/* -0.702257=f(-0.55, 0.65)*/
{36, 0,123,__LINE__, 0xbfe54f9e, 0xc1ee286f, 0xbfe19999, 0x99999996, 0x3fe66666, 0x6666666b},	/* -0.665969=f(-0.55, 0.7)*/
{37, 0,123,__LINE__, 0xbfe43f7a, 0x81a9e7c0, 0xbfe19999, 0x99999996, 0x3fe80000, 0x00000005},	/* -0.632749=f(-0.55, 0.75)*/
{39, 0,123,__LINE__, 0xbfe345f0, 0x1e80ce7a, 0xbfe19999, 0x99999996, 0x3fe99999, 0x9999999f},	/* -0.602287=f(-0.55, 0.8)*/
{39, 0,123,__LINE__, 0xbfe260b4, 0x84618415, 0xbfe19999, 0x99999996, 0x3feb3333, 0x33333339},	/* -0.574305=f(-0.55, 0.85)*/
{36, 0,123,__LINE__, 0xbfe18db7, 0x8579ee06, 0xbfe19999, 0x99999996, 0x3feccccc, 0xccccccd3},	/* -0.548549=f(-0.55, 0.9)*/
{37, 0,123,__LINE__, 0xbfe0cb20, 0x88819f9f, 0xbfe19999, 0x99999996, 0x3fee6666, 0x6666666d},	/* -0.524796=f(-0.55, 0.95)*/
{63, 0,123,__LINE__, 0xc0056c6e, 0x7397f5ae, 0xbfdfffff, 0xfffffff9, 0xbff00000, 0x00000000},	/* -2.67795=f(-0.5, -1)*/
{40, 0,123,__LINE__, 0xc00541c5, 0x5cabb163, 0xbfdfffff, 0xfffffff9, 0xbfee6666, 0x66666666},	/* -2.65711=f(-0.5, -0.95)*/
{39, 0,123,__LINE__, 0xc0051371, 0xa9a00948, 0xbfdfffff, 0xfffffff9, 0xbfeccccc, 0xcccccccc},	/* -2.63449=f(-0.5, -0.9)*/
{39, 0,123,__LINE__, 0xc004e102, 0xc9ae6095, 0xbfdfffff, 0xfffffff9, 0xbfeb3333, 0x33333332},	/* -2.60987=f(-0.5, -0.85)*/
{40, 0,123,__LINE__, 0xc004a9f8, 0x6a328a2f, 0xbfdfffff, 0xfffffff9, 0xbfe99999, 0x99999998},	/* -2.58299=f(-0.5, -0.8)*/
{63, 0,123,__LINE__, 0xc0046dc0, 0x9ec29433, 0xbfdfffff, 0xfffffff9, 0xbfe7ffff, 0xfffffffe},	/* -2.55359=f(-0.5, -0.75)*/
{39, 0,123,__LINE__, 0xc0042bb5, 0xf66229c5, 0xbfdfffff, 0xfffffff9, 0xbfe66666, 0x66666664},	/* -2.52134=f(-0.5, -0.7)*/
{38, 0,123,__LINE__, 0xc003e31d, 0xf8ac6787, 0xbfdfffff, 0xfffffff9, 0xbfe4cccc, 0xccccccca},	/* -2.4859=f(-0.5, -0.65)*/
{38, 0,123,__LINE__, 0xc0039328, 0x65e74c29, 0xbfdfffff, 0xfffffff9, 0xbfe33333, 0x33333330},	/* -2.44685=f(-0.5, -0.6)*/
{39, 0,123,__LINE__, 0xc0033aef, 0xc0a92540, 0xbfdfffff, 0xfffffff9, 0xbfe19999, 0x99999996},	/* -2.40378=f(-0.5, -0.55)*/
{64, 0,123,__LINE__, 0xc002d97c, 0x7f3321d2, 0xbfdfffff, 0xfffffff9, 0xbfdfffff, 0xfffffff9},	/* -2.35619=f(-0.5, -0.5)*/
{39, 0,123,__LINE__, 0xc0026dcb, 0xd25efebb, 0xbfdfffff, 0xfffffff9, 0xbfdccccc, 0xccccccc6},	/* -2.30361=f(-0.5, -0.45)*/
{40, 0,123,__LINE__, 0xc001f6dc, 0x3f5cd2c0, 0xbfdfffff, 0xfffffff9, 0xbfd99999, 0x99999993},	/* -2.24554=f(-0.5, -0.4)*/
{39, 0,123,__LINE__, 0xc00173c1, 0xf46e257d, 0xbfdfffff, 0xfffffff9, 0xbfd66666, 0x66666660},	/* -2.18152=f(-0.5, -0.35)*/
{38, 0,123,__LINE__, 0xc000e3c5, 0x21fab41e, 0xbfdfffff, 0xfffffff9, 0xbfd33333, 0x3333332d},	/* -2.11122=f(-0.5, -0.3)*/
{64, 0,123,__LINE__, 0xc000468a, 0x8ace4df6, 0xbfdfffff, 0xfffffff9, 0xbfcfffff, 0xfffffff4},	/* -2.03444=f(-0.5, -0.25)*/
{39, 0,123,__LINE__, 0xbfff3889, 0x307f2704, 0xbfdfffff, 0xfffffff9, 0xbfc99999, 0x9999998e},	/* -1.9513=f(-0.5, -0.2)*/
{38, 0,123,__LINE__, 0xbffdcbc9, 0xf0bb681e, 0xbfdfffff, 0xfffffff9, 0xbfc33333, 0x33333328},	/* -1.86225=f(-0.5, -0.15)*/
{40, 0,123,__LINE__, 0xbffc4a83, 0x9427fe28, 0xbfdfffff, 0xfffffff9, 0xbfb99999, 0x99999983},	/* -1.76819=f(-0.5, -0.1)*/
{41, 0,123,__LINE__, 0xbffaba39, 0x7cd7bcb7, 0xbfdfffff, 0xfffffff9, 0xbfa99999, 0x9999996c},	/* -1.67046=f(-0.5, -0.05)*/
{64, 0,123,__LINE__, 0xbff921fb, 0x54442d15, 0xbfdfffff, 0xfffffff9, 0x3cb70000, 0x00000000},	/* -1.5708=f(-0.5, 3.19189e-16)*/
{41, 0,123,__LINE__, 0xbff789bd, 0x2bb09d7a, 0xbfdfffff, 0xfffffff9, 0x3fa99999, 0x999999c8},	/* -1.47113=f(-0.5, 0.05)*/
{40, 0,123,__LINE__, 0xbff5f973, 0x14605c08, 0xbfdfffff, 0xfffffff9, 0x3fb99999, 0x999999b1},	/* -1.3734=f(-0.5, 0.1)*/
{38, 0,123,__LINE__, 0xbff4782c, 0xb7ccf213, 0xbfdfffff, 0xfffffff9, 0x3fc33333, 0x3333333f},	/* -1.27934=f(-0.5, 0.15)*/
{39, 0,123,__LINE__, 0xbff30b6d, 0x7809332d, 0xbfdfffff, 0xfffffff9, 0x3fc99999, 0x999999a6},	/* -1.19029=f(-0.5, 0.2)*/
{62, 0,123,__LINE__, 0xbff1b6e1, 0x92ebbe44, 0xbfdfffff, 0xfffffff9, 0x3fd00000, 0x00000006},	/* -1.10715=f(-0.5, 0.25)*/
{37, 0,123,__LINE__, 0xbff07c6c, 0x6492f1f4, 0xbfdfffff, 0xfffffff9, 0x3fd33333, 0x33333339},	/* -1.03038=f(-0.5, 0.3)*/
{37, 0,123,__LINE__, 0xbfeeb8e5, 0x7f581e6d, 0xbfdfffff, 0xfffffff9, 0x3fd66666, 0x6666666c},	/* -0.96007=f(-0.5, 0.35)*/
{38, 0,123,__LINE__, 0xbfecac7c, 0x539d6960, 0xbfdfffff, 0xfffffff9, 0x3fd99999, 0x9999999f},	/* -0.896055=f(-0.5, 0.4)*/
{37, 0,123,__LINE__, 0xbfead0be, 0x0794b975, 0xbfdfffff, 0xfffffff9, 0x3fdccccc, 0xccccccd2},	/* -0.837981=f(-0.5, 0.45)*/
{61, 0,123,__LINE__, 0xbfe921fb, 0x54442d18, 0xbfdfffff, 0xfffffff9, 0x3fe00000, 0x00000003},	/* -0.785398=f(-0.5, 0.5)*/
{37, 0,123,__LINE__, 0xbfe79c2e, 0x4e6c1f5f, 0xbfdfffff, 0xfffffff9, 0x3fe19999, 0x9999999d},	/* -0.737815=f(-0.5, 0.55)*/
{36, 0,123,__LINE__, 0xbfe63b4b, 0xb97383bd, 0xbfdfffff, 0xfffffff9, 0x3fe33333, 0x33333337},	/* -0.694738=f(-0.5, 0.6)*/
{36, 0,123,__LINE__, 0xbfe4fb75, 0x6e5f1644, 0xbfdfffff, 0xfffffff9, 0x3fe4cccc, 0xccccccd1},	/* -0.655696=f(-0.5, 0.65)*/
{37, 0,123,__LINE__, 0xbfe3d915, 0x77880d4d, 0xbfdfffff, 0xfffffff9, 0x3fe66666, 0x6666666b},	/* -0.620249=f(-0.5, 0.7)*/
{61, 0,123,__LINE__, 0xbfe2d0ea, 0xd6066395, 0xbfdfffff, 0xfffffff9, 0x3fe80000, 0x00000005},	/* -0.588003=f(-0.5, 0.75)*/
{38, 0,123,__LINE__, 0xbfe1e00b, 0xa8468ba6, 0xbfdfffff, 0xfffffff9, 0x3fe99999, 0x9999999f},	/* -0.558599=f(-0.5, 0.8)*/
{37, 0,123,__LINE__, 0xbfe103e2, 0x2a57320f, 0xbfdfffff, 0xfffffff9, 0x3feb3333, 0x33333339},	/* -0.531724=f(-0.5, 0.85)*/
{37, 0,123,__LINE__, 0xbfe03a26, 0xaa908f42, 0xbfdfffff, 0xfffffff9, 0x3feccccc, 0xccccccd3},	/* -0.507099=f(-0.5, 0.9)*/
{37, 0,123,__LINE__, 0xbfdf01af, 0xbcc3ddad, 0xbfdfffff, 0xfffffff9, 0x3fee6666, 0x6666666d},	/* -0.484478=f(-0.5, 0.95)*/
{39, 0,123,__LINE__, 0xc005bffa, 0x185afd8c, 0xbfdccccc, 0xccccccc6, 0xbff00000, 0x00000000},	/* -2.71874=f(-0.45, -1)*/
{40, 0,123,__LINE__, 0xc00597ff, 0xd5db498b, 0xbfdccccc, 0xccccccc6, 0xbfee6666, 0x66666666},	/* -2.69922=f(-0.45, -0.95)*/
{63, 0,123,__LINE__, 0xc0056c6e, 0x7397f5ae, 0xbfdccccc, 0xccccccc6, 0xbfeccccc, 0xcccccccc},	/* -2.67795=f(-0.45, -0.9)*/
{38, 0,123,__LINE__, 0xc0053ccf, 0xeaa27acc, 0xbfdccccc, 0xccccccc6, 0xbfeb3333, 0x33333332},	/* -2.65469=f(-0.45, -0.85)*/
{38, 0,123,__LINE__, 0xc005089b, 0xb16d17f7, 0xbfdccccc, 0xccccccc6, 0xbfe99999, 0x99999998},	/* -2.6292=f(-0.45, -0.8)*/
{39, 0,123,__LINE__, 0xc004cf33, 0xe0577b72, 0xbfdccccc, 0xccccccc6, 0xbfe7ffff, 0xfffffffe},	/* -2.60117=f(-0.45, -0.75)*/
{40, 0,123,__LINE__, 0xc0048fe1, 0xf261215b, 0xbfdccccc, 0xccccccc6, 0xbfe66666, 0x66666664},	/* -2.57026=f(-0.45, -0.7)*/
{40, 0,123,__LINE__, 0xc00449d3, 0x86acbb16, 0xbfdccccc, 0xccccccc6, 0xbfe4cccc, 0xccccccca},	/* -2.53605=f(-0.45, -0.65)*/
{37, 0,123,__LINE__, 0xc003fc17, 0x6fbec9a3, 0xbfdccccc, 0xccccccc6, 0xbfe33333, 0x33333330},	/* -2.49809=f(-0.45, -0.6)*/
{38, 0,123,__LINE__, 0xc003a59b, 0x96754f04, 0xbfdccccc, 0xccccccc6, 0xbfe19999, 0x99999996},	/* -2.45586=f(-0.45, -0.55)*/
{39, 0,123,__LINE__, 0xc003452d, 0x2c0744e9, 0xbfdccccc, 0xccccccc6, 0xbfdfffff, 0xfffffff9},	/* -2.40878=f(-0.45, -0.5)*/
{64, 0,123,__LINE__, 0xc002d97c, 0x7f3321d2, 0xbfdccccc, 0xccccccc6, 0xbfdccccc, 0xccccccc6},	/* -2.35619=f(-0.45, -0.45)*/
{38, 0,123,__LINE__, 0xc0026127, 0x88ed3aee, 0xbfdccccc, 0xccccccc6, 0xbfd99999, 0x99999993},	/* -2.29744=f(-0.45, -0.4)*/
{40, 0,123,__LINE__, 0xc001dace, 0xaafb4a30, 0xbfdccccc, 0xccccccc6, 0xbfd66666, 0x66666660},	/* -2.23184=f(-0.45, -0.35)*/
{37, 0,123,__LINE__, 0xc0014538, 0x63bdf116, 0xbfdccccc, 0xccccccc6, 0xbfd33333, 0x3333332d},	/* -2.1588=f(-0.45, -0.3)*/
{39, 0,123,__LINE__, 0xc0009f87, 0x54c63a5d, 0xbfdccccc, 0xccccccc6, 0xbfcfffff, 0xfffffff4},	/* -2.07789=f(-0.45, -0.25)*/
{37, 0,123,__LINE__, 0xbfffd307, 0x5702cb99, 0xbfdccccc, 0xccccccc6, 0xbfc99999, 0x9999998e},	/* -1.98902=f(-0.45, -0.2)*/
{37, 0,123,__LINE__, 0xbffe47df, 0x42632a28, 0xbfdccccc, 0xccccccc6, 0xbfc33333, 0x33333328},	/* -1.89255=f(-0.45, -0.15)*/
{38, 0,123,__LINE__, 0xbffca1a6, 0x58d1662c, 0xbfdccccc, 0xccccccc6, 0xbfb99999, 0x99999983},	/* -1.78947=f(-0.45, -0.1)*/
{39, 0,123,__LINE__, 0xbffae73b, 0xd71c804f, 0xbfdccccc, 0xccccccc6, 0xbfa99999, 0x9999996c},	/* -1.68145=f(-0.45, -0.05)*/
{64, 0,123,__LINE__, 0xbff921fb, 0x54442d15, 0xbfdccccc, 0xccccccc6, 0x3cb70000, 0x00000000},	/* -1.5708=f(-0.45, 3.19189e-16)*/
{39, 0,123,__LINE__, 0xbff75cba, 0xd16bd9e1, 0xbfdccccc, 0xccccccc6, 0x3fa99999, 0x999999c8},	/* -1.46014=f(-0.45, 0.05)*/
{38, 0,123,__LINE__, 0xbff5a250, 0x4fb6f405, 0xbfdccccc, 0xccccccc6, 0x3fb99999, 0x999999b1},	/* -1.35213=f(-0.45, 0.1)*/
{37, 0,123,__LINE__, 0xbff3fc17, 0x66253009, 0xbfdccccc, 0xccccccc6, 0x3fc33333, 0x3333333f},	/* -1.24905=f(-0.45, 0.15)*/
{37, 0,123,__LINE__, 0xbff270ef, 0x51858e97, 0xbfdccccc, 0xccccccc6, 0x3fc99999, 0x999999a6},	/* -1.15257=f(-0.45, 0.2)*/
{38, 0,123,__LINE__, 0xbff104e7, 0xfefbe577, 0xbfdccccc, 0xccccccc6, 0x3fd00000, 0x00000006},	/* -1.0637=f(-0.45, 0.25)*/
{35, 0,123,__LINE__, 0xbfef730b, 0xc218f009, 0xbfdccccc, 0xccccccc6, 0x3fd33333, 0x33333339},	/* -0.982794=f(-0.45, 0.3)*/
{38, 0,123,__LINE__, 0xbfed1cb2, 0xa5238ba3, 0xbfdccccc, 0xccccccc6, 0x3fd66666, 0x6666666c},	/* -0.909753=f(-0.45, 0.35)*/
{36, 0,123,__LINE__, 0xbfeb034f, 0x2d5bc8a9, 0xbfdccccc, 0xccccccc6, 0x3fd99999, 0x9999999f},	/* -0.844154=f(-0.45, 0.4)*/
{61, 0,123,__LINE__, 0xbfe921fb, 0x54442d18, 0xbfdccccc, 0xccccccc6, 0x3fdccccc, 0xccccccd2},	/* -0.785398=f(-0.45, 0.45)*/
{37, 0,123,__LINE__, 0xbfe77338, 0xa0f3a0bc, 0xbfdccccc, 0xccccccc6, 0x3fe00000, 0x00000003},	/* -0.732815=f(-0.45, 0.5)*/
{36, 0,123,__LINE__, 0xbfe5f17e, 0xf73b7850, 0xbfdccccc, 0xccccccc6, 0x3fe19999, 0x9999999d},	/* -0.685729=f(-0.45, 0.55)*/
{35, 0,123,__LINE__, 0xbfe4978f, 0x92158dd5, 0xbfdccccc, 0xccccccc6, 0x3fe33333, 0x33333337},	/* -0.643501=f(-0.45, 0.6)*/
{38, 0,123,__LINE__, 0xbfe3609f, 0x365dc809, 0xbfdccccc, 0xccccccc6, 0x3fe4cccc, 0xccccccd1},	/* -0.605545=f(-0.45, 0.65)*/
{38, 0,123,__LINE__, 0xbfe24865, 0x878c2ef4, 0xbfdccccc, 0xccccccc6, 0x3fe66666, 0x6666666b},	/* -0.571337=f(-0.45, 0.7)*/
{37, 0,123,__LINE__, 0xbfe14b1d, 0xcfb2c69a, 0xbfdccccc, 0xccccccc6, 0x3fe80000, 0x00000005},	/* -0.540419=f(-0.45, 0.75)*/
{36, 0,123,__LINE__, 0xbfe0657e, 0x8b5c5485, 0xbfdccccc, 0xccccccc6, 0x3fe99999, 0x9999999f},	/* -0.512389=f(-0.45, 0.8)*/
{35, 0,123,__LINE__, 0xbfdf295b, 0x4d0d9264, 0xbfdccccc, 0xccccccc6, 0x3feb3333, 0x33333339},	/* -0.486899=f(-0.45, 0.85)*/
{60, 0,123,__LINE__, 0xbfddac67, 0x0561bb4f, 0xbfdccccc, 0xccccccc6, 0x3feccccc, 0xccccccd3},	/* -0.463648=f(-0.45, 0.9)*/
{37, 0,123,__LINE__, 0xbfdc4fdb, 0xf3471c6d, 0xbfdccccc, 0xccccccc6, 0x3fee6666, 0x6666666d},	/* -0.442374=f(-0.45, 0.95)*/
{40, 0,123,__LINE__, 0xc00616b4, 0x6626b023, 0xbfd99999, 0x99999993, 0xbff00000, 0x00000000},	/* -2.76109=f(-0.4, -1)*/
{39, 0,123,__LINE__, 0xc005f1ce, 0xc9bbfc1c, 0xbfd99999, 0x99999993, 0xbfee6666, 0x66666666},	/* -2.74307=f(-0.4, -0.95)*/
{38, 0,123,__LINE__, 0xc005c975, 0x52e4ddd8, 0xbfd99999, 0x99999993, 0xbfeccccc, 0xcccccccc},	/* -2.72337=f(-0.4, -0.9)*/
{40, 0,123,__LINE__, 0xc0059d2f, 0x24cd92b5, 0xbfd99999, 0x99999993, 0xbfeb3333, 0x33333332},	/* -2.70175=f(-0.4, -0.85)*/
{63, 0,123,__LINE__, 0xc0056c6e, 0x7397f5ae, 0xbfd99999, 0x99999993, 0xbfe99999, 0x99999998},	/* -2.67795=f(-0.4, -0.8)*/
{40, 0,123,__LINE__, 0xc005368c, 0x944a04a1, 0xbfd99999, 0x99999993, 0xbfe7ffff, 0xfffffffe},	/* -2.65164=f(-0.4, -0.75)*/
{39, 0,123,__LINE__, 0xc004fac5, 0x3e774951, 0xbfd99999, 0x99999993, 0xbfe66666, 0x66666664},	/* -2.62245=f(-0.4, -0.7)*/
{38, 0,123,__LINE__, 0xc004b831, 0x3ac804c9, 0xbfd99999, 0x99999993, 0xbfe4cccc, 0xccccccca},	/* -2.58994=f(-0.4, -0.65)*/
{39, 0,123,__LINE__, 0xc0046dc0, 0xa04c6cd0, 0xbfd99999, 0x99999993, 0xbfe33333, 0x33333330},	/* -2.55359=f(-0.4, -0.6)*/
{41, 0,123,__LINE__, 0xc0041a34, 0xfbc2dfe5, 0xbfd99999, 0x99999993, 0xbfe19999, 0x99999996},	/* -2.5128=f(-0.4, -0.55)*/
{40, 0,123,__LINE__, 0xc003bc1c, 0xbf0970e4, 0xbfd99999, 0x99999993, 0xbfdfffff, 0xfffffff9},	/* -2.46685=f(-0.4, -0.5)*/
{38, 0,123,__LINE__, 0xc00351d1, 0x757908b6, 0xbfd99999, 0x99999993, 0xbfdccccc, 0xccccccc6},	/* -2.41495=f(-0.4, -0.45)*/
{64, 0,123,__LINE__, 0xc002d97c, 0x7f3321d2, 0xbfd99999, 0x99999993, 0xbfd99999, 0x99999993},	/* -2.35619=f(-0.4, -0.4)*/
{38, 0,123,__LINE__, 0xc0025127, 0x99607098, 0xbfd99999, 0x99999993, 0xbfd66666, 0x66666660},	/* -2.28963=f(-0.4, -0.35)*/
{39, 0,123,__LINE__, 0xc001b6e1, 0x948557dd, 0xbfd99999, 0x99999993, 0xbfd33333, 0x3333332d},	/* -2.2143=f(-0.4, -0.3)*/
{40, 0,123,__LINE__, 0xc0010900, 0x9433b976, 0xbfd99999, 0x99999993, 0xbfcfffff, 0xfffffff4},	/* -2.1294=f(-0.4, -0.25)*/
{64, 0,123,__LINE__, 0xc000468a, 0x8ace4df6, 0xbfd99999, 0x99999993, 0xbfc99999, 0x9999998e},	/* -2.03444=f(-0.4, -0.2)*/
{38, 0,123,__LINE__, 0xbffedf81, 0xa6ee7d60, 0xbfd99999, 0x99999993, 0xbfc33333, 0x33333328},	/* -1.92957=f(-0.4, -0.15)*/
{62, 0,123,__LINE__, 0xbffd0d6a, 0x1369bd34, 0xbfd99999, 0x99999993, 0xbfb99999, 0x99999983},	/* -1.81577=f(-0.4, -0.1)*/
{62, 0,123,__LINE__, 0xbffb1f56, 0xfdeef00f, 0xbfd99999, 0x99999993, 0xbfa99999, 0x9999996c},	/* -1.69515=f(-0.4, -0.05)*/
{64, 0,123,__LINE__, 0xbff921fb, 0x54442d15, 0xbfd99999, 0x99999993, 0x3cb70000, 0x00000000},	/* -1.5708=f(-0.4, 3.19189e-16)*/
{61, 0,123,__LINE__, 0xbff7249f, 0xaa996a21, 0xbfd99999, 0x99999993, 0x3fa99999, 0x999999c8},	/* -1.44644=f(-0.4, 0.05)*/
{61, 0,123,__LINE__, 0xbff5368c, 0x951e9cfd, 0xbfd99999, 0x99999993, 0x3fb99999, 0x999999b1},	/* -1.32582=f(-0.4, 0.1)*/
{38, 0,123,__LINE__, 0xbff36475, 0x0199dcd1, 0xbfd99999, 0x99999993, 0x3fc33333, 0x3333333f},	/* -1.21203=f(-0.4, 0.15)*/
{61, 0,123,__LINE__, 0xbff1b6e1, 0x92ebbe44, 0xbfd99999, 0x99999993, 0x3fc99999, 0x999999a6},	/* -1.10715=f(-0.4, 0.2)*/
{39, 0,123,__LINE__, 0xbff031f5, 0x8020e745, 0xbfd99999, 0x99999993, 0x3fd00000, 0x00000006},	/* -1.0122=f(-0.4, 0.25)*/
{37, 0,123,__LINE__, 0xbfedac66, 0xfefb54ec, 0xbfd99999, 0x99999993, 0x3fd33333, 0x33333339},	/* -0.927295=f(-0.4, 0.3)*/
{36, 0,123,__LINE__, 0xbfeb434e, 0xeb8ef201, 0xbfd99999, 0x99999993, 0x3fd66666, 0x6666666c},	/* -0.851966=f(-0.4, 0.35)*/
{61, 0,123,__LINE__, 0xbfe921fb, 0x54442d18, 0xbfd99999, 0x99999993, 0x3fd99999, 0x9999999f},	/* -0.785398=f(-0.4, 0.4)*/
{36, 0,123,__LINE__, 0xbfe740a7, 0x7b2c9187, 0xbfd99999, 0x99999993, 0x3fdccccc, 0xccccccd2},	/* -0.726642=f(-0.4, 0.45)*/
{38, 0,123,__LINE__, 0xbfe5977a, 0x54eaf0d0, 0xbfd99999, 0x99999993, 0x3fe00000, 0x00000003},	/* -0.674741=f(-0.4, 0.5)*/
{39, 0,123,__LINE__, 0xbfe41f19, 0x620534ce, 0xbfd99999, 0x99999993, 0x3fe19999, 0x9999999d},	/* -0.628796=f(-0.4, 0.55)*/
{37, 0,123,__LINE__, 0xbfe2d0ea, 0xcfdf0123, 0xbfd99999, 0x99999993, 0x3fe33333, 0x33333337},	/* -0.588003=f(-0.4, 0.6)*/
{36, 0,123,__LINE__, 0xbfe1a728, 0x65f0a13e, 0xbfd99999, 0x99999993, 0x3fe4cccc, 0xccccccd1},	/* -0.551655=f(-0.4, 0.65)*/
{37, 0,123,__LINE__, 0xbfe09cd8, 0x57338f1c, 0xbfd99999, 0x99999993, 0x3fe66666, 0x6666666b},	/* -0.519146=f(-0.4, 0.7)*/
{37, 0,123,__LINE__, 0xbfdf5b75, 0xffd143be, 0xbfd99999, 0x99999993, 0x3fe80000, 0x00000005},	/* -0.489957=f(-0.4, 0.75)*/
{60, 0,123,__LINE__, 0xbfddac67, 0x0561bb4f, 0xbfd99999, 0x99999993, 0x3fe99999, 0x9999999f},	/* -0.463648=f(-0.4, 0.8)*/
{37, 0,123,__LINE__, 0xbfdc2661, 0x7bb4d31c, 0xbfd99999, 0x99999993, 0x3feb3333, 0x33333339},	/* -0.439843=f(-0.4, 0.85)*/
{35, 0,123,__LINE__, 0xbfdac430, 0x0afa7a04, 0xbfd99999, 0x99999993, 0x3feccccc, 0xccccccd3},	/* -0.418224=f(-0.4, 0.9)*/
{36, 0,123,__LINE__, 0xbfd98164, 0x544187e0, 0xbfd99999, 0x99999993, 0x3fee6666, 0x6666666d},	/* -0.398522=f(-0.4, 0.95)*/
{40, 0,123,__LINE__, 0xc0067078, 0xc3a56789, 0xbfd66666, 0x66666660, 0xbff00000, 0x00000000},	/* -2.80492=f(-0.35, -1)*/
{42, 0,123,__LINE__, 0xc0064f0e, 0xb499f9d3, 0xbfd66666, 0x66666660, 0xbfee6666, 0x66666666},	/* -2.7886=f(-0.35, -0.95)*/
{41, 0,123,__LINE__, 0xc0062a65, 0x79b7ca58, 0xbfd66666, 0x66666660, 0xbfeccccc, 0xcccccccc},	/* -2.7707=f(-0.35, -0.9)*/
{38, 0,123,__LINE__, 0xc0060204, 0xc07359e3, 0xbfd66666, 0x66666660, 0xbfeb3333, 0x33333332},	/* -2.75099=f(-0.35, -0.85)*/
{39, 0,123,__LINE__, 0xc005d55d, 0x7d5d8b38, 0xbfd66666, 0x66666660, 0xbfe99999, 0x99999998},	/* -2.72918=f(-0.35, -0.8)*/
{40, 0,123,__LINE__, 0xc005a3c4, 0xf3c4da81, 0xbfd66666, 0x66666660, 0xbfe7ffff, 0xfffffffe},	/* -2.70497=f(-0.35, -0.75)*/
{63, 0,123,__LINE__, 0xc0056c6e, 0x7397f5ae, 0xbfd66666, 0x66666660, 0xbfe66666, 0x66666664},	/* -2.67795=f(-0.35, -0.7)*/
{39, 0,123,__LINE__, 0xc0052e63, 0xcadd21f9, 0xbfd66666, 0x66666660, 0xbfe4cccc, 0xccccccca},	/* -2.64765=f(-0.35, -0.65)*/
{38, 0,123,__LINE__, 0xc004e87c, 0x3ee65519, 0xbfd66666, 0x66666660, 0xbfe33333, 0x33333330},	/* -2.61352=f(-0.35, -0.6)*/
{38, 0,123,__LINE__, 0xc0049952, 0x02a6eb88, 0xbfd66666, 0x66666660, 0xbfe19999, 0x99999996},	/* -2.57486=f(-0.35, -0.55)*/
{39, 0,123,__LINE__, 0xc0043f37, 0x09f81e27, 0xbfd66666, 0x66666660, 0xbfdfffff, 0xfffffff9},	/* -2.53087=f(-0.35, -0.5)*/
{40, 0,123,__LINE__, 0xc003d82a, 0x536af975, 0xbfd66666, 0x66666660, 0xbfdccccc, 0xccccccc6},	/* -2.48055=f(-0.35, -0.45)*/
{38, 0,123,__LINE__, 0xc00361d1, 0x6505d30c, 0xbfd66666, 0x66666660, 0xbfd99999, 0x99999993},	/* -2.42276=f(-0.35, -0.4)*/
{64, 0,123,__LINE__, 0xc002d97c, 0x7f3321d2, 0xbfd66666, 0x66666660, 0xbfd66666, 0x66666660},	/* -2.35619=f(-0.35, -0.35)*/
{38, 0,123,__LINE__, 0xc0023c41, 0xee24d9c7, 0xbfd66666, 0x66666660, 0xbfd33333, 0x3333332d},	/* -2.27942=f(-0.35, -0.3)*/
{39, 0,123,__LINE__, 0xc0018743, 0x080419df, 0xbfd66666, 0x66666660, 0xbfcfffff, 0xfffffff4},	/* -2.19105=f(-0.35, -0.25)*/
{39, 0,123,__LINE__, 0xc000b833, 0xbfeefa53, 0xbfd66666, 0x66666660, 0xbfc99999, 0x9999998e},	/* -2.08994=f(-0.35, -0.2)*/
{37, 0,123,__LINE__, 0xbfff9c6b, 0x2910ce24, 0xbfd66666, 0x66666660, 0xbfc33333, 0x33333328},	/* -1.97569=f(-0.35, -0.15)*/
{38, 0,123,__LINE__, 0xbffd95e5, 0xae666ff2, 0xbfd66666, 0x66666660, 0xbfb99999, 0x99999983},	/* -1.8491=f(-0.35, -0.1)*/
{39, 0,123,__LINE__, 0xbffb6731, 0x2e062767, 0xbfd66666, 0x66666660, 0xbfa99999, 0x9999996c},	/* -1.71269=f(-0.35, -0.05)*/
{64, 0,123,__LINE__, 0xbff921fb, 0x54442d14, 0xbfd66666, 0x66666660, 0x3cb70000, 0x00000000},	/* -1.5708=f(-0.35, 3.19189e-16)*/
{39, 0,123,__LINE__, 0xbff6dcc5, 0x7a8232c9, 0xbfd66666, 0x66666660, 0x3fa99999, 0x999999c8},	/* -1.4289=f(-0.35, 0.05)*/
{38, 0,123,__LINE__, 0xbff4ae10, 0xfa21ea3f, 0xbfd66666, 0x66666660, 0x3fb99999, 0x999999b1},	/* -1.2925=f(-0.35, 0.1)*/
{37, 0,123,__LINE__, 0xbff2a78b, 0x7f778c0d, 0xbfd66666, 0x66666660, 0x3fc33333, 0x3333333f},	/* -1.1659=f(-0.35, 0.15)*/
{38, 0,123,__LINE__, 0xbff0d38f, 0x28aa658a, 0xbfd66666, 0x66666660, 0x3fc99999, 0x999999a6},	/* -1.05165=f(-0.35, 0.2)*/
{37, 0,123,__LINE__, 0xbfee6ae1, 0x31004ce4, 0xbfd66666, 0x66666660, 0x3fd00000, 0x00000006},	/* -0.950547=f(-0.35, 0.25)*/
{36, 0,123,__LINE__, 0xbfeb96e5, 0x987d4d44, 0xbfd66666, 0x66666660, 0x3fd33333, 0x33333339},	/* -0.86217=f(-0.35, 0.3)*/
{60, 0,123,__LINE__, 0xbfe921fb, 0x54442d18, 0xbfd66666, 0x66666660, 0x3fd66666, 0x6666666c},	/* -0.785398=f(-0.35, 0.35)*/
{36, 0,123,__LINE__, 0xbfe700a7, 0xbcf9682f, 0xbfd66666, 0x66666660, 0x3fd99999, 0x9999999f},	/* -0.71883=f(-0.35, 0.4)*/
{38, 0,123,__LINE__, 0xbfe52744, 0x0364ce8e, 0xbfd66666, 0x66666660, 0x3fdccccc, 0xccccccd2},	/* -0.661043=f(-0.35, 0.45)*/
{37, 0,123,__LINE__, 0xbfe38b11, 0x29303bc3, 0xbfd66666, 0x66666660, 0x3fe00000, 0x00000003},	/* -0.610726=f(-0.35, 0.5)*/
{36, 0,123,__LINE__, 0xbfe222a5, 0x46750640, 0xbfd66666, 0x66666660, 0x3fe19999, 0x9999999d},	/* -0.566729=f(-0.35, 0.55)*/
{36, 0,123,__LINE__, 0xbfe0e5fc, 0x55775ffb, 0xbfd66666, 0x66666660, 0x3fe33333, 0x33333337},	/* -0.528074=f(-0.35, 0.6)*/
{36, 0,123,__LINE__, 0xbfdf9cbc, 0x4b3858fc, 0xbfd66666, 0x66666660, 0x3fe4cccc, 0xccccccd1},	/* -0.493941=f(-0.35, 0.65)*/
{60, 0,123,__LINE__, 0xbfddac67, 0x0561bb4f, 0xbfd66666, 0x66666660, 0x3fe66666, 0x6666666b},	/* -0.463648=f(-0.35, 0.7)*/
{37, 0,123,__LINE__, 0xbfdbf1b3, 0x03fa94bd, 0xbfd66666, 0x66666660, 0x3fe80000, 0x00000005},	/* -0.436627=f(-0.35, 0.75)*/
{36, 0,123,__LINE__, 0xbfda64ee, 0xb7350f03, 0xbfd66666, 0x66666660, 0x3fe99999, 0x9999999f},	/* -0.41241=f(-0.35, 0.8)*/
{35, 0,123,__LINE__, 0xbfd8ffb4, 0x9e8699a9, 0xbfd66666, 0x66666660, 0x3feb3333, 0x33333339},	/* -0.390607=f(-0.35, 0.85)*/
{38, 0,123,__LINE__, 0xbfd7bcae, 0xd46315ff, 0xbfd66666, 0x66666660, 0x3feccccc, 0xccccccd3},	/* -0.370891=f(-0.35, 0.9)*/
{39, 0,123,__LINE__, 0xbfd69764, 0xfd519a2a, 0xbfd66666, 0x66666660, 0x3fee6666, 0x6666666d},	/* -0.35299=f(-0.35, 0.95)*/
{39, 0,123,__LINE__, 0xc006cd14, 0x06088f96, 0xbfd33333, 0x3333332d, 0xbff00000, 0x00000000},	/* -2.85014=f(-0.3, -1)*/
{38, 0,123,__LINE__, 0xc006af8a, 0xb316898c, 0xbfd33333, 0x3333332d, 0xbfee6666, 0x66666666},	/* -2.83571=f(-0.3, -0.95)*/
{38, 0,123,__LINE__, 0xc0068f09, 0x5d34ae91, 0xbfd33333, 0x3333332d, 0xbfeccccc, 0xcccccccc},	/* -2.81984=f(-0.3, -0.9)*/
{41, 0,123,__LINE__, 0xc0066b1c, 0x47ef4f4a, 0xbfd33333, 0x3333332d, 0xbfeb3333, 0x33333332},	/* -2.8023=f(-0.3, -0.85)*/
{39, 0,123,__LINE__, 0xc0064338, 0x2aef04f4, 0xbfd33333, 0x3333332d, 0xbfe99999, 0x99999998},	/* -2.78282=f(-0.3, -0.8)*/
{39, 0,123,__LINE__, 0xc00616b4, 0x65006f66, 0xbfd33333, 0x3333332d, 0xbfe7ffff, 0xfffffffe},	/* -2.76109=f(-0.3, -0.75)*/
{38, 0,123,__LINE__, 0xc005e4c3, 0x69dddc93, 0xbfd33333, 0x3333332d, 0xbfe66666, 0x66666664},	/* -2.7367=f(-0.3, -0.7)*/
{38, 0,123,__LINE__, 0xc005ac69, 0x1b28425b, 0xbfd33333, 0x3333332d, 0xbfe4cccc, 0xccccccca},	/* -2.70918=f(-0.3, -0.65)*/
{63, 0,123,__LINE__, 0xc0056c6e, 0x7397f5ae, 0xbfd33333, 0x3333332d, 0xbfe33333, 0x33333330},	/* -2.67795=f(-0.3, -0.6)*/
{39, 0,123,__LINE__, 0xc0052351, 0xd4c76fc9, 0xbfd33333, 0x3333332d, 0xbfe19999, 0x99999996},	/* -2.64225=f(-0.3, -0.55)*/
{38, 0,123,__LINE__, 0xc004cf33, 0xdc6b8f86, 0xbfd33333, 0x3333332d, 0xbfdfffff, 0xfffffff9},	/* -2.60117=f(-0.3, -0.5)*/
{37, 0,123,__LINE__, 0xc0046dc0, 0x9aa8528e, 0xbfd33333, 0x3333332d, 0xbfdccccc, 0xccccccc6},	/* -2.55359=f(-0.3, -0.45)*/
{39, 0,123,__LINE__, 0xc003fc17, 0x69e0ebc7, 0xbfd33333, 0x3333332d, 0xbfd99999, 0x99999993},	/* -2.49809=f(-0.3, -0.4)*/
{38, 0,123,__LINE__, 0xc00376b7, 0x104169dd, 0xbfd33333, 0x3333332d, 0xbfd66666, 0x66666660},	/* -2.43297=f(-0.3, -0.35)*/
{64, 0,123,__LINE__, 0xc002d97c, 0x7f3321d2, 0xbfd33333, 0x3333332d, 0xbfd33333, 0x3333332d},	/* -2.35619=f(-0.3, -0.3)*/
{38, 0,123,__LINE__, 0xc0021fd0, 0x987ef77b, 0xbfd33333, 0x3333332d, 0xbfcfffff, 0xfffffff4},	/* -2.26553=f(-0.3, -0.25)*/
{39, 0,123,__LINE__, 0xc0014538, 0x5e19d6d5, 0xbfd33333, 0x3333332d, 0xbfc99999, 0x9999998e},	/* -2.1588=f(-0.3, -0.2)*/
{64, 0,123,__LINE__, 0xc000468a, 0x8ace4df6, 0xbfd33333, 0x3333332d, 0xbfc33333, 0x33333328},	/* -2.03444=f(-0.3, -0.15)*/
{39, 0,123,__LINE__, 0xbffe47df, 0x3b0dd4d2, 0xbfd33333, 0x3333332d, 0xbfb99999, 0x99999983},	/* -1.89255=f(-0.3, -0.1)*/
{39, 0,123,__LINE__, 0xbffbc66e, 0x43b6feba, 0xbfd33333, 0x3333332d, 0xbfa99999, 0x9999996c},	/* -1.73595=f(-0.3, -0.05)*/
{64, 0,123,__LINE__, 0xbff921fb, 0x54442d13, 0xbfd33333, 0x3333332d, 0x3cb70000, 0x00000000},	/* -1.5708=f(-0.3, 3.19189e-16)*/
{39, 0,123,__LINE__, 0xbff67d88, 0x64d15b77, 0xbfd33333, 0x3333332d, 0x3fa99999, 0x999999c8},	/* -1.40565=f(-0.3, 0.05)*/
{38, 0,123,__LINE__, 0xbff3fc17, 0x6d7a855f, 0xbfd33333, 0x3333332d, 0x3fb99999, 0x999999b1},	/* -1.24905=f(-0.3, 0.1)*/
{61, 0,123,__LINE__, 0xbff1b6e1, 0x92ebbe44, 0xbfd33333, 0x3333332d, 0x3fc33333, 0x3333333f},	/* -1.10715=f(-0.3, 0.15)*/
{37, 0,123,__LINE__, 0xbfef730b, 0xd8a9590e, 0xbfd33333, 0x3333332d, 0x3fc99999, 0x999999a6},	/* -0.982794=f(-0.3, 0.2)*/
{36, 0,123,__LINE__, 0xbfec08aa, 0xef14d674, 0xbfd33333, 0x3333332d, 0x3fd00000, 0x00000006},	/* -0.876058=f(-0.3, 0.25)*/
{60, 0,123,__LINE__, 0xbfe921fb, 0x54442d18, 0xbfd33333, 0x3333332d, 0x3fd33333, 0x33333339},	/* -0.785398=f(-0.3, 0.3)*/
{36, 0,123,__LINE__, 0xbfe6ad11, 0x100b0cec, 0xbfd33333, 0x3333332d, 0x3fd66666, 0x6666666c},	/* -0.708626=f(-0.3, 0.35)*/
{37, 0,123,__LINE__, 0xbfe4978f, 0xa98d0545, 0xbfd33333, 0x3333332d, 0x3fd99999, 0x9999999f},	/* -0.643501=f(-0.3, 0.4)*/
{35, 0,123,__LINE__, 0xbfe2d0ea, 0xe66f6a28, 0xbfd33333, 0x3333332d, 0x3fdccccc, 0xccccccd2},	/* -0.588003=f(-0.3, 0.45)*/
{36, 0,123,__LINE__, 0xbfe14b1d, 0xdf627649, 0xbfd33333, 0x3333332d, 0x3fe00000, 0x00000003},	/* -0.54042=f(-0.3, 0.5)*/
{36, 0,123,__LINE__, 0xbfdff54b, 0xfbe5ea7d, 0xbfd33333, 0x3333332d, 0x3fe19999, 0x9999999d},	/* -0.499347=f(-0.3, 0.55)*/
{60, 0,123,__LINE__, 0xbfddac67, 0x0561bb4f, 0xbfd33333, 0x3333332d, 0x3fe33333, 0x33333337},	/* -0.463648=f(-0.3, 0.6)*/
{35, 0,123,__LINE__, 0xbfdbac91, 0xc8df55ed, 0xbfd33333, 0x3333332d, 0x3fe4cccc, 0xccccccd1},	/* -0.432408=f(-0.3, 0.65)*/
{35, 0,123,__LINE__, 0xbfd9e9bf, 0x5332842d, 0xbfd33333, 0x3333332d, 0x3fe66666, 0x6666666b},	/* -0.404892=f(-0.3, 0.7)*/
{36, 0,123,__LINE__, 0xbfd85a37, 0x7a1ded8f, 0xbfd33333, 0x3333332d, 0x3fe80000, 0x00000005},	/* -0.380506=f(-0.3, 0.75)*/
{36, 0,123,__LINE__, 0xbfd6f619, 0x4aa9411f, 0xbfd33333, 0x3333332d, 0x3fe99999, 0x9999999f},	/* -0.358771=f(-0.3, 0.8)*/
{38, 0,123,__LINE__, 0xbfd5b6f8, 0x62a6ee76, 0xbfd33333, 0x3333332d, 0x3feb3333, 0x33333339},	/* -0.339293=f(-0.3, 0.85)*/
{35, 0,123,__LINE__, 0xbfd4978f, 0xb87bf43e, 0xbfd33333, 0x3333332d, 0x3feccccc, 0xccccccd3},	/* -0.321751=f(-0.3, 0.9)*/
{35, 0,123,__LINE__, 0xbfd39385, 0x096d1c62, 0xbfd33333, 0x3333332d, 0x3fee6666, 0x6666666d},	/* -0.305879=f(-0.3, 0.95)*/
{63, 0,123,__LINE__, 0xc0072c43, 0xf4b1650a, 0xbfcfffff, 0xfffffff4, 0xbff00000, 0x00000000},	/* -2.89661=f(-0.25, -1)*/
{41, 0,123,__LINE__, 0xc00712fb, 0x9777c615, 0xbfcfffff, 0xfffffff4, 0xbfee6666, 0x66666666},	/* -2.88427=f(-0.25, -0.95)*/
{40, 0,123,__LINE__, 0xc006f715, 0x24b02fc3, 0xbfcfffff, 0xfffffff4, 0xbfeccccc, 0xcccccccc},	/* -2.87065=f(-0.25, -0.9)*/
{39, 0,123,__LINE__, 0xc006d825, 0xfeafdf22, 0xbfcfffff, 0xfffffff4, 0xbfeb3333, 0x33333332},	/* -2.85554=f(-0.25, -0.85)*/
{40, 0,123,__LINE__, 0xc006b5ac, 0x6df4f37e, 0xbfcfffff, 0xfffffff4, 0xbfe99999, 0x99999998},	/* -2.83871=f(-0.25, -0.8)*/
{63, 0,123,__LINE__, 0xc0068f09, 0x5fdf593c, 0xbfcfffff, 0xfffffff4, 0xbfe7ffff, 0xfffffffe},	/* -2.81984=f(-0.25, -0.75)*/
{40, 0,123,__LINE__, 0xc0066377, 0xfd9c0560, 0xbfcfffff, 0xfffffff4, 0xbfe66666, 0x66666664},	/* -2.79857=f(-0.25, -0.7)*/
{39, 0,123,__LINE__, 0xc0063202, 0x7cdc56ad, 0xbfcfffff, 0xfffffff4, 0xbfe4cccc, 0xccccccca},	/* -2.77442=f(-0.25, -0.65)*/
{39, 0,123,__LINE__, 0xc005f973, 0x170a042b, 0xbfcfffff, 0xfffffff4, 0xbfe33333, 0x33333330},	/* -2.7468=f(-0.25, -0.6)*/
{39, 0,123,__LINE__, 0xc005b83f, 0xa88849f6, 0xbfcfffff, 0xfffffff4, 0xbfe19999, 0x99999996},	/* -2.71497=f(-0.25, -0.55)*/
{63, 0,123,__LINE__, 0xc0056c6e, 0x7397f5ae, 0xbfcfffff, 0xfffffff4, 0xbfdfffff, 0xfffffff9},	/* -2.67795=f(-0.25, -0.5)*/
{39, 0,123,__LINE__, 0xc0051371, 0xa9a00948, 0xbfcfffff, 0xfffffff4, 0xbfdccccc, 0xccccccc6},	/* -2.63449=f(-0.25, -0.45)*/
{40, 0,123,__LINE__, 0xc004a9f8, 0x6a328a2f, 0xbfcfffff, 0xfffffff4, 0xbfd99999, 0x99999993},	/* -2.58299=f(-0.25, -0.4)*/
{39, 0,123,__LINE__, 0xc0042bb5, 0xf66229c5, 0xbfcfffff, 0xfffffff4, 0xbfd66666, 0x66666660},	/* -2.52134=f(-0.25, -0.35)*/
{38, 0,123,__LINE__, 0xc0039328, 0x65e74c29, 0xbfcfffff, 0xfffffff4, 0xbfd33333, 0x3333332d},	/* -2.44685=f(-0.25, -0.3)*/
{64, 0,123,__LINE__, 0xc002d97c, 0x7f3321d2, 0xbfcfffff, 0xfffffff4, 0xbfcfffff, 0xfffffff4},	/* -2.35619=f(-0.25, -0.25)*/
{40, 0,123,__LINE__, 0xc001f6dc, 0x3f5cd2c0, 0xbfcfffff, 0xfffffff4, 0xbfc99999, 0x9999998e},	/* -2.24554=f(-0.25, -0.2)*/
{38, 0,123,__LINE__, 0xc000e3c5, 0x21fab41e, 0xbfcfffff, 0xfffffff4, 0xbfc33333, 0x33333328},	/* -2.11122=f(-0.25, -0.15)*/
{39, 0,123,__LINE__, 0xbfff3889, 0x307f2704, 0xbfcfffff, 0xfffffff4, 0xbfb99999, 0x99999983},	/* -1.9513=f(-0.25, -0.1)*/
{40, 0,123,__LINE__, 0xbffc4a83, 0x9427fe28, 0xbfcfffff, 0xfffffff4, 0xbfa99999, 0x9999996c},	/* -1.76819=f(-0.25, -0.05)*/
{64, 0,123,__LINE__, 0xbff921fb, 0x54442d13, 0xbfcfffff, 0xfffffff4, 0x3cb70000, 0x00000000},	/* -1.5708=f(-0.25, 3.19189e-16)*/
{40, 0,123,__LINE__, 0xbff5f973, 0x14605c08, 0xbfcfffff, 0xfffffff4, 0x3fa99999, 0x999999c8},	/* -1.3734=f(-0.25, 0.05)*/
{39, 0,123,__LINE__, 0xbff30b6d, 0x7809332d, 0xbfcfffff, 0xfffffff4, 0x3fb99999, 0x999999b1},	/* -1.19029=f(-0.25, 0.1)*/
{37, 0,123,__LINE__, 0xbff07c6c, 0x6492f1f4, 0xbfcfffff, 0xfffffff4, 0x3fc33333, 0x3333333f},	/* -1.03038=f(-0.25, 0.15)*/
{38, 0,123,__LINE__, 0xbfecac7c, 0x539d6960, 0xbfcfffff, 0xfffffff4, 0x3fc99999, 0x999999a6},	/* -0.896055=f(-0.25, 0.2)*/
{60, 0,123,__LINE__, 0xbfe921fb, 0x54442d18, 0xbfcfffff, 0xfffffff4, 0x3fd00000, 0x00000006},	/* -0.785398=f(-0.25, 0.25)*/
{36, 0,123,__LINE__, 0xbfe63b4b, 0xb97383bd, 0xbfcfffff, 0xfffffff4, 0x3fd33333, 0x33333339},	/* -0.694738=f(-0.25, 0.3)*/
{37, 0,123,__LINE__, 0xbfe3d915, 0x77880d4d, 0xbfcfffff, 0xfffffff4, 0x3fd66666, 0x6666666c},	/* -0.620249=f(-0.25, 0.35)*/
{38, 0,123,__LINE__, 0xbfe1e00b, 0xa8468ba6, 0xbfcfffff, 0xfffffff4, 0x3fd99999, 0x9999999f},	/* -0.558599=f(-0.25, 0.4)*/
{37, 0,123,__LINE__, 0xbfe03a26, 0xaa908f42, 0xbfcfffff, 0xfffffff4, 0x3fdccccc, 0xccccccd2},	/* -0.507099=f(-0.25, 0.45)*/
{60, 0,123,__LINE__, 0xbfddac67, 0x0561bb4f, 0xbfcfffff, 0xfffffff4, 0x3fe00000, 0x00000003},	/* -0.463648=f(-0.25, 0.5)*/
{36, 0,123,__LINE__, 0xbfdb4ddd, 0x5ddf1912, 0xbfcfffff, 0xfffffff4, 0x3fe19999, 0x9999999d},	/* -0.426627=f(-0.25, 0.55)*/
{36, 0,123,__LINE__, 0xbfd94441, 0xe9d14767, 0xbfcfffff, 0xfffffff4, 0x3fe33333, 0x33333337},	/* -0.394791=f(-0.25, 0.6)*/
{36, 0,123,__LINE__, 0xbfd77fc6, 0xbb3eb35c, 0xbfcfffff, 0xfffffff4, 0x3fe4cccc, 0xccccccd1},	/* -0.367174=f(-0.25, 0.65)*/
{37, 0,123,__LINE__, 0xbfd5f41a, 0xb5413dc3, 0xbfcfffff, 0xfffffff4, 0x3fe66666, 0x6666666b},	/* -0.343024=f(-0.25, 0.7)*/
{60, 0,123,__LINE__, 0xbfd4978f, 0xa3269ee1, 0xbfcfffff, 0xfffffff4, 0x3fe80000, 0x00000005},	/* -0.321751=f(-0.25, 0.75)*/
{37, 0,123,__LINE__, 0xbfd36277, 0x3279ccd3, 0xbfcfffff, 0xfffffff4, 0x3fe99999, 0x9999999f},	/* -0.302885=f(-0.25, 0.8)*/
{36, 0,123,__LINE__, 0xbfd24eaa, 0xaca26fb4, 0xbfcfffff, 0xfffffff4, 0x3feb3333, 0x33333339},	/* -0.286051=f(-0.25, 0.85)*/
{37, 0,123,__LINE__, 0xbfd15731, 0x7c9feaaa, 0xbfcfffff, 0xfffffff4, 0x3feccccc, 0xccccccd3},	/* -0.270947=f(-0.25, 0.9)*/
{38, 0,123,__LINE__, 0xbfd077fd, 0xe663381e, 0xbfcfffff, 0xfffffff4, 0x3fee6666, 0x6666666d},	/* -0.257324=f(-0.25, 0.95)*/
{41, 0,123,__LINE__, 0xc0078db7, 0x34524490, 0xbfc99999, 0x9999998e, 0xbff00000, 0x00000000},	/* -2.9442=f(-0.2, -1)*/
{40, 0,123,__LINE__, 0xc0077907, 0x8b7161f7, 0xbfc99999, 0x9999998e, 0xbfee6666, 0x66666666},	/* -2.9341=f(-0.2, -0.95)*/
{39, 0,123,__LINE__, 0xc0076225, 0xd1fd908f, 0xbfc99999, 0x9999998e, 0xbfeccccc, 0xcccccccc},	/* -2.92292=f(-0.2, -0.9)*/
{41, 0,123,__LINE__, 0xc00748b5, 0x4458c287, 0xbfc99999, 0x9999998e, 0xbfeb3333, 0x33333332},	/* -2.9105=f(-0.2, -0.85)*/
{63, 0,123,__LINE__, 0xc0072c43, 0xf4b1650a, 0xbfc99999, 0x9999998e, 0xbfe99999, 0x99999998},	/* -2.89661=f(-0.2, -0.8)*/
{41, 0,123,__LINE__, 0xc0070c44, 0x9ed6318f, 0xbfc99999, 0x9999998e, 0xbfe7ffff, 0xfffffffe},	/* -2.88099=f(-0.2, -0.75)*/
{39, 0,123,__LINE__, 0xc006e806, 0x27330bab, 0xbfc99999, 0x9999998e, 0xbfe66666, 0x66666664},	/* -2.86329=f(-0.2, -0.7)*/
{39, 0,123,__LINE__, 0xc006bea7, 0xe9e995d8, 0xbfc99999, 0x9999998e, 0xbfe4cccc, 0xccccccca},	/* -2.84309=f(-0.2, -0.65)*/
{40, 0,123,__LINE__, 0xc0068f09, 0x60df593c, 0xbfc99999, 0x9999998e, 0xbfe33333, 0x33333330},	/* -2.81984=f(-0.2, -0.6)*/
{41, 0,123,__LINE__, 0xc00657b2, 0xe0dd6ecf, 0xbfc99999, 0x9999998e, 0xbfe19999, 0x99999996},	/* -2.79282=f(-0.2, -0.55)*/
{40, 0,123,__LINE__, 0xc00616b4, 0x6626b023, 0xbfc99999, 0x9999998e, 0xbfdfffff, 0xfffffff9},	/* -2.76109=f(-0.2, -0.5)*/
{38, 0,123,__LINE__, 0xc005c975, 0x52e4ddd8, 0xbfc99999, 0x9999998e, 0xbfdccccc, 0xccccccc6},	/* -2.72337=f(-0.2, -0.45)*/
{63, 0,123,__LINE__, 0xc0056c6e, 0x7397f5ae, 0xbfc99999, 0x9999998e, 0xbfd99999, 0x99999993},	/* -2.67795=f(-0.2, -0.4)*/
{39, 0,123,__LINE__, 0xc004fac5, 0x3e774951, 0xbfc99999, 0x9999998e, 0xbfd66666, 0x66666660},	/* -2.62245=f(-0.2, -0.35)*/
{39, 0,123,__LINE__, 0xc0046dc0, 0xa04c6cd0, 0xbfc99999, 0x9999998e, 0xbfd33333, 0x3333332d},	/* -2.55359=f(-0.2, -0.3)*/
{40, 0,123,__LINE__, 0xc003bc1c, 0xbf0970e4, 0xbfc99999, 0x9999998e, 0xbfcfffff, 0xfffffff4},	/* -2.46685=f(-0.2, -0.25)*/
{64, 0,123,__LINE__, 0xc002d97c, 0x7f3321d2, 0xbfc99999, 0x9999998e, 0xbfc99999, 0x9999998e},	/* -2.35619=f(-0.2, -0.2)*/
{39, 0,123,__LINE__, 0xc001b6e1, 0x948557dd, 0xbfc99999, 0x9999998e, 0xbfc33333, 0x33333328},	/* -2.2143=f(-0.2, -0.15)*/
{63, 0,123,__LINE__, 0xc000468a, 0x8ace4df6, 0xbfc99999, 0x9999998e, 0xbfb99999, 0x99999983},	/* -2.03444=f(-0.2, -0.1)*/
{61, 0,123,__LINE__, 0xbffd0d6a, 0x1369bd34, 0xbfc99999, 0x9999998e, 0xbfa99999, 0x9999996c},	/* -1.81577=f(-0.2, -0.05)*/
{64, 0,123,__LINE__, 0xbff921fb, 0x54442d11, 0xbfc99999, 0x9999998e, 0x3cb70000, 0x00000000},	/* -1.5708=f(-0.2, 3.19189e-16)*/
{60, 0,123,__LINE__, 0xbff5368c, 0x951e9cfd, 0xbfc99999, 0x9999998e, 0x3fa99999, 0x999999c8},	/* -1.32582=f(-0.2, 0.05)*/
{60, 0,123,__LINE__, 0xbff1b6e1, 0x92ebbe44, 0xbfc99999, 0x9999998e, 0x3fb99999, 0x999999b1},	/* -1.10715=f(-0.2, 0.1)*/
{37, 0,123,__LINE__, 0xbfedac66, 0xfefb54ec, 0xbfc99999, 0x9999998e, 0x3fc33333, 0x3333333f},	/* -0.927295=f(-0.2, 0.15)*/
{60, 0,123,__LINE__, 0xbfe921fb, 0x54442d18, 0xbfc99999, 0x9999998e, 0x3fc99999, 0x999999a6},	/* -0.785398=f(-0.2, 0.2)*/
{38, 0,123,__LINE__, 0xbfe5977a, 0x54eaf0d0, 0xbfc99999, 0x9999998e, 0x3fd00000, 0x00000006},	/* -0.674741=f(-0.2, 0.25)*/
{37, 0,123,__LINE__, 0xbfe2d0ea, 0xcfdf0123, 0xbfc99999, 0x9999998e, 0x3fd33333, 0x33333339},	/* -0.588003=f(-0.2, 0.3)*/
{37, 0,123,__LINE__, 0xbfe09cd8, 0x57338f1c, 0xbfc99999, 0x9999998e, 0x3fd66666, 0x6666666c},	/* -0.519146=f(-0.2, 0.35)*/
{59, 0,123,__LINE__, 0xbfddac67, 0x0561bb4f, 0xbfc99999, 0x9999998e, 0x3fd99999, 0x9999999f},	/* -0.463648=f(-0.2, 0.4)*/
{35, 0,123,__LINE__, 0xbfdac430, 0x0afa7a04, 0xbfc99999, 0x9999998e, 0x3fdccccc, 0xccccccd2},	/* -0.418224=f(-0.2, 0.45)*/
{37, 0,123,__LINE__, 0xbfd85a37, 0x70ebe7ae, 0xbfc99999, 0x9999998e, 0x3fe00000, 0x00000003},	/* -0.380506=f(-0.2, 0.5)*/
{38, 0,123,__LINE__, 0xbfd65243, 0x9b35f24d, 0xbfc99999, 0x9999998e, 0x3fe19999, 0x9999999d},	/* -0.348771=f(-0.2, 0.55)*/
{37, 0,123,__LINE__, 0xbfd4978f, 0x9b269ee6, 0xbfc99999, 0x9999998e, 0x3fe33333, 0x33333337},	/* -0.321751=f(-0.2, 0.6)*/
{36, 0,123,__LINE__, 0xbfd31a9b, 0x52d4ba05, 0xbfc99999, 0x9999998e, 0x3fe4cccc, 0xccccccd1},	/* -0.298499=f(-0.2, 0.65)*/
{36, 0,123,__LINE__, 0xbfd1cfa9, 0x68890b66, 0xbfc99999, 0x9999998e, 0x3fe66666, 0x6666666b},	/* -0.2783=f(-0.2, 0.7)*/
{38, 0,123,__LINE__, 0xbfd0adb5, 0xab6fdc47, 0xbfc99999, 0x9999998e, 0x3fe80000, 0x00000005},	/* -0.260602=f(-0.2, 0.75)*/
{59, 0,123,__LINE__, 0xbfcf5b75, 0xf92c80dd, 0xbfc99999, 0x9999998e, 0x3fe99999, 0x9999999f},	/* -0.244979=f(-0.2, 0.8)*/
{37, 0,123,__LINE__, 0xbfcd9460, 0xfeb6a910, 0xbfc99999, 0x9999998e, 0x3feb3333, 0x33333339},	/* -0.231091=f(-0.2, 0.85)*/
{35, 0,123,__LINE__, 0xbfcbfd58, 0x2469c89c, 0xbfc99999, 0x9999998e, 0x3feccccc, 0xccccccd3},	/* -0.218669=f(-0.2, 0.9)*/
{36, 0,123,__LINE__, 0xbfca8f3c, 0x8d2cb215, 0xbfc99999, 0x9999998e, 0x3fee6666, 0x6666666d},	/* -0.207496=f(-0.2, 0.95)*/
{40, 0,123,__LINE__, 0xc007f10e, 0x1cfe652c, 0xbfc33333, 0x33333328, 0xbff00000, 0x00000000},	/* -2.9927=f(-0.15, -1)*/
{39, 0,123,__LINE__, 0xc007e142, 0xd70e612f, 0xbfc33333, 0x33333328, 0xbfee6666, 0x66666666},	/* -2.98499=f(-0.15, -0.95)*/
{39, 0,123,__LINE__, 0xc007cfc1, 0xda8f611b, 0xbfc33333, 0x33333328, 0xbfeccccc, 0xcccccccc},	/* -2.97644=f(-0.15, -0.9)*/
{41, 0,123,__LINE__, 0xc007bc40, 0xca4d5d6f, 0xbfc33333, 0x33333328, 0xbfeb3333, 0x33333332},	/* -2.96692=f(-0.15, -0.85)*/
{40, 0,123,__LINE__, 0xc007a663, 0x9eecb680, 0xbfc33333, 0x33333328, 0xbfe99999, 0x99999998},	/* -2.95624=f(-0.15, -0.8)*/
{39, 0,123,__LINE__, 0xc0078db7, 0x33ae2a4f, 0xbfc33333, 0x33333328, 0xbfe7ffff, 0xfffffffe},	/* -2.9442=f(-0.15, -0.75)*/
{39, 0,123,__LINE__, 0xc00771a9, 0x9f1fcdc4, 0xbfc33333, 0x33333328, 0xbfe66666, 0x66666664},	/* -2.9305=f(-0.15, -0.7)*/
{38, 0,123,__LINE__, 0xc007517f, 0x67eb9995, 0xbfc33333, 0x33333328, 0xbfe4cccc, 0xccccccca},	/* -2.91479=f(-0.15, -0.65)*/
{63, 0,123,__LINE__, 0xc0072c43, 0xf4b1650a, 0xbfc33333, 0x33333328, 0xbfe33333, 0x33333330},	/* -2.89661=f(-0.15, -0.6)*/
{40, 0,123,__LINE__, 0xc00700b2, 0x9289de37, 0xbfc33333, 0x33333328, 0xbfe19999, 0x99999996},	/* -2.87534=f(-0.15, -0.55)*/
{39, 0,123,__LINE__, 0xc006cd14, 0x06088f96, 0xbfc33333, 0x33333328, 0xbfdfffff, 0xfffffff9},	/* -2.85014=f(-0.15, -0.5)*/
{38, 0,123,__LINE__, 0xc0068f09, 0x5d34ae91, 0xbfc33333, 0x33333328, 0xbfdccccc, 0xccccccc6},	/* -2.81984=f(-0.15, -0.45)*/
{39, 0,123,__LINE__, 0xc0064338, 0x2aef04f4, 0xbfc33333, 0x33333328, 0xbfd99999, 0x99999993},	/* -2.78282=f(-0.15, -0.4)*/
{38, 0,123,__LINE__, 0xc005e4c3, 0x69dddc93, 0xbfc33333, 0x33333328, 0xbfd66666, 0x66666660},	/* -2.7367=f(-0.15, -0.35)*/
{63, 0,123,__LINE__, 0xc0056c6e, 0x7397f5ae, 0xbfc33333, 0x33333328, 0xbfd33333, 0x3333332d},	/* -2.67795=f(-0.15, -0.3)*/
{38, 0,123,__LINE__, 0xc004cf33, 0xdc6b8f86, 0xbfc33333, 0x33333328, 0xbfcfffff, 0xfffffff4},	/* -2.60117=f(-0.15, -0.25)*/
{39, 0,123,__LINE__, 0xc003fc17, 0x69e0ebc7, 0xbfc33333, 0x33333328, 0xbfc99999, 0x9999998e},	/* -2.49809=f(-0.15, -0.2)*/
{64, 0,123,__LINE__, 0xc002d97c, 0x7f3321d2, 0xbfc33333, 0x33333328, 0xbfc33333, 0x33333328},	/* -2.35619=f(-0.15, -0.15)*/
{39, 0,123,__LINE__, 0xc0014538, 0x5e19d6d5, 0xbfc33333, 0x33333328, 0xbfb99999, 0x99999983},	/* -2.1588=f(-0.15, -0.1)*/
{39, 0,123,__LINE__, 0xbffe47df, 0x3b0dd4d2, 0xbfc33333, 0x33333328, 0xbfa99999, 0x9999996c},	/* -1.89255=f(-0.15, -0.05)*/
{64, 0,123,__LINE__, 0xbff921fb, 0x54442d0f, 0xbfc33333, 0x33333328, 0x3cb70000, 0x00000000},	/* -1.5708=f(-0.15, 3.19189e-16)*/
{38, 0,123,__LINE__, 0xbff3fc17, 0x6d7a855f, 0xbfc33333, 0x33333328, 0x3fa99999, 0x999999c8},	/* -1.24905=f(-0.15, 0.05)*/
{37, 0,123,__LINE__, 0xbfef730b, 0xd8a9590e, 0xbfc33333, 0x33333328, 0x3fb99999, 0x999999b1},	/* -0.982794=f(-0.15, 0.1)*/
{59, 0,123,__LINE__, 0xbfe921fb, 0x54442d18, 0xbfc33333, 0x33333328, 0x3fc33333, 0x3333333f},	/* -0.785398=f(-0.15, 0.15)*/
{37, 0,123,__LINE__, 0xbfe4978f, 0xa98d0545, 0xbfc33333, 0x33333328, 0x3fc99999, 0x999999a6},	/* -0.643501=f(-0.15, 0.2)*/
{36, 0,123,__LINE__, 0xbfe14b1d, 0xdf627649, 0xbfc33333, 0x33333328, 0x3fd00000, 0x00000006},	/* -0.54042=f(-0.15, 0.25)*/
{59, 0,123,__LINE__, 0xbfddac67, 0x0561bb4f, 0xbfc33333, 0x33333328, 0x3fd33333, 0x33333339},	/* -0.463648=f(-0.15, 0.3)*/
{35, 0,123,__LINE__, 0xbfd9e9bf, 0x5332842d, 0xbfc33333, 0x33333328, 0x3fd66666, 0x6666666c},	/* -0.404892=f(-0.15, 0.35)*/
{36, 0,123,__LINE__, 0xbfd6f619, 0x4aa9411f, 0xbfc33333, 0x33333328, 0x3fd99999, 0x9999999f},	/* -0.358771=f(-0.15, 0.4)*/
{35, 0,123,__LINE__, 0xbfd4978f, 0xb87bf43e, 0xbfc33333, 0x33333328, 0x3fdccccc, 0xccccccd2},	/* -0.321751=f(-0.15, 0.45)*/
{36, 0,123,__LINE__, 0xbfd2a73a, 0x71dcec16, 0xbfc33333, 0x33333328, 0x3fe00000, 0x00000003},	/* -0.291457=f(-0.15, 0.5)*/
{37, 0,123,__LINE__, 0xbfd10a46, 0x0dd2770d, 0xbfc33333, 0x33333328, 0x3fe19999, 0x9999999d},	/* -0.266252=f(-0.15, 0.55)*/
{59, 0,123,__LINE__, 0xbfcf5b75, 0xf92c80dd, 0xbfc33333, 0x33333328, 0x3fe33333, 0x33333337},	/* -0.244979=f(-0.15, 0.6)*/
{34, 0,123,__LINE__, 0xbfcd07be, 0xc5893835, 0xbfc33333, 0x33333328, 0x3fe4cccc, 0xccccccd1},	/* -0.226799=f(-0.15, 0.65)*/
{35, 0,123,__LINE__, 0xbfcb051b, 0x5245f540, 0xbfc33333, 0x33333328, 0x3fe66666, 0x6666666b},	/* -0.211093=f(-0.15, 0.7)*/
{35, 0,123,__LINE__, 0xbfc94442, 0x09602c9b, 0xbfc33333, 0x33333328, 0x3fe80000, 0x00000005},	/* -0.197396=f(-0.15, 0.75)*/
{36, 0,123,__LINE__, 0xbfc7b97b, 0x5577697d, 0xbfc33333, 0x33333328, 0x3fe99999, 0x9999999f},	/* -0.185348=f(-0.15, 0.8)*/
{37, 0,123,__LINE__, 0xbfc65ba8, 0x9f6cfa93, 0xbfc33333, 0x33333328, 0x3feb3333, 0x33333339},	/* -0.174672=f(-0.15, 0.85)*/
{35, 0,123,__LINE__, 0xbfc52397, 0x9b4cbfce, 0xbfc33333, 0x33333328, 0x3feccccc, 0xccccccd3},	/* -0.165149=f(-0.15, 0.9)*/
{35, 0,123,__LINE__, 0xbfc40b87, 0xd35cbe95, 0xbfc33333, 0x33333328, 0x3fee6666, 0x6666666d},	/* -0.156602=f(-0.15, 0.95)*/
{42, 0,123,__LINE__, 0xc00855dc, 0x3ffa6549, 0xbfb99999, 0x99999983, 0xbff00000, 0x00000000},	/* -3.04192=f(-0.1, -1)*/
{41, 0,123,__LINE__, 0xc0084b31, 0x9b726074, 0xbfb99999, 0x99999983, 0xbfee6666, 0x66666666},	/* -3.03672=f(-0.1, -0.95)*/
{40, 0,123,__LINE__, 0xc0083f5b, 0x12d8037d, 0xbfb99999, 0x99999983, 0xbfeccccc, 0xcccccccc},	/* -3.03094=f(-0.1, -0.9)*/
{42, 0,123,__LINE__, 0xc0083224, 0x9ed8ad4d, 0xbfb99999, 0x99999983, 0xbfeb3333, 0x33333332},	/* -3.02448=f(-0.1, -0.85)*/
{63, 0,123,__LINE__, 0xc008234d, 0x7f6ecb9d, 0xbfb99999, 0x99999983, 0xbfe99999, 0x99999998},	/* -3.01724=f(-0.1, -0.8)*/
{41, 0,123,__LINE__, 0xc0081284, 0x267f1c56, 0xbfb99999, 0x99999983, 0xbfe7ffff, 0xfffffffe},	/* -3.00904=f(-0.1, -0.75)*/
{40, 0,123,__LINE__, 0xc007ff60, 0x67632ff1, 0xbfb99999, 0x99999983, 0xbfe66666, 0x66666664},	/* -2.9997=f(-0.1, -0.7)*/
{39, 0,123,__LINE__, 0xc007e95b, 0x1d301b04, 0xbfb99999, 0x99999983, 0xbfe4cccc, 0xccccccca},	/* -2.98894=f(-0.1, -0.65)*/
{40, 0,123,__LINE__, 0xc007cfc1, 0xdc8ac447, 0xbfb99999, 0x99999983, 0xbfe33333, 0x33333330},	/* -2.97644=f(-0.1, -0.6)*/
{42, 0,123,__LINE__, 0xc007b1a4, 0x4c4fb28c, 0xbfb99999, 0x99999983, 0xbfe19999, 0x99999996},	/* -2.96174=f(-0.1, -0.55)*/
{41, 0,123,__LINE__, 0xc0078db7, 0x34524490, 0xbfb99999, 0x99999983, 0xbfdfffff, 0xfffffff9},	/* -2.9442=f(-0.1, -0.5)*/
{39, 0,123,__LINE__, 0xc0076225, 0xd1fd908f, 0xbfb99999, 0x99999983, 0xbfdccccc, 0xccccccc6},	/* -2.92292=f(-0.1, -0.45)*/
{62, 0,123,__LINE__, 0xc0072c43, 0xf4b1650a, 0xbfb99999, 0x99999983, 0xbfd99999, 0x99999993},	/* -2.89661=f(-0.1, -0.4)*/
{39, 0,123,__LINE__, 0xc006e806, 0x27330bab, 0xbfb99999, 0x99999983, 0xbfd66666, 0x66666660},	/* -2.86329=f(-0.1, -0.35)*/
{40, 0,123,__LINE__, 0xc0068f09, 0x60df593c, 0xbfb99999, 0x99999983, 0xbfd33333, 0x3333332d},	/* -2.81984=f(-0.1, -0.3)*/
{40, 0,123,__LINE__, 0xc00616b4, 0x6626b023, 0xbfb99999, 0x99999983, 0xbfcfffff, 0xfffffff4},	/* -2.76109=f(-0.1, -0.25)*/
{62, 0,123,__LINE__, 0xc0056c6e, 0x7397f5ae, 0xbfb99999, 0x99999983, 0xbfc99999, 0x9999998e},	/* -2.67795=f(-0.1, -0.2)*/
{39, 0,123,__LINE__, 0xc0046dc0, 0xa04c6cd0, 0xbfb99999, 0x99999983, 0xbfc33333, 0x33333328},	/* -2.55359=f(-0.1, -0.15)*/
{64, 0,123,__LINE__, 0xc002d97c, 0x7f3321d2, 0xbfb99999, 0x99999983, 0xbfb99999, 0x99999983},	/* -2.35619=f(-0.1, -0.1)*/
{62, 0,123,__LINE__, 0xc000468a, 0x8ace4df6, 0xbfb99999, 0x99999983, 0xbfa99999, 0x9999996c},	/* -2.03444=f(-0.1, -0.05)*/
{64, 0,123,__LINE__, 0xbff921fb, 0x54442d0a, 0xbfb99999, 0x99999983, 0x3cb70000, 0x00000000},	/* -1.5708=f(-0.1, 3.19189e-16)*/
{59, 0,123,__LINE__, 0xbff1b6e1, 0x92ebbe44, 0xbfb99999, 0x99999983, 0x3fa99999, 0x999999c8},	/* -1.10715=f(-0.1, 0.05)*/
{59, 0,123,__LINE__, 0xbfe921fb, 0x54442d18, 0xbfb99999, 0x99999983, 0x3fb99999, 0x999999b1},	/* -0.785398=f(-0.1, 0.1)*/
{37, 0,123,__LINE__, 0xbfe2d0ea, 0xcfdf0123, 0xbfb99999, 0x99999983, 0x3fc33333, 0x3333333f},	/* -0.588003=f(-0.1, 0.15)*/
{58, 0,123,__LINE__, 0xbfddac67, 0x0561bb4f, 0xbfb99999, 0x99999983, 0x3fc99999, 0x999999a6},	/* -0.463648=f(-0.1, 0.2)*/
{37, 0,123,__LINE__, 0xbfd85a37, 0x70ebe7ae, 0xbfb99999, 0x99999983, 0x3fd00000, 0x00000006},	/* -0.380506=f(-0.1, 0.25)*/
{37, 0,123,__LINE__, 0xbfd4978f, 0x9b269ee6, 0xbfb99999, 0x99999983, 0x3fd33333, 0x33333339},	/* -0.321751=f(-0.1, 0.3)*/
{36, 0,123,__LINE__, 0xbfd1cfa9, 0x68890b66, 0xbfb99999, 0x99999983, 0x3fd66666, 0x6666666c},	/* -0.2783=f(-0.1, 0.35)*/
{58, 0,123,__LINE__, 0xbfcf5b75, 0xf92c80dd, 0xbfb99999, 0x99999983, 0x3fd99999, 0x9999999f},	/* -0.244979=f(-0.1, 0.4)*/
{35, 0,123,__LINE__, 0xbfcbfd58, 0x2469c89c, 0xbfb99999, 0x99999983, 0x3fdccccc, 0xccccccd2},	/* -0.218669=f(-0.1, 0.45)*/
{37, 0,123,__LINE__, 0xbfc94441, 0xff1e8881, 0xbfb99999, 0x99999983, 0x3fe00000, 0x00000003},	/* -0.197396=f(-0.1, 0.5)*/
{38, 0,123,__LINE__, 0xbfc70570, 0x7f47a8be, 0xbfb99999, 0x99999983, 0x3fe19999, 0x9999999d},	/* -0.179853=f(-0.1, 0.55)*/
{36, 0,123,__LINE__, 0xbfc52397, 0x7b968d0d, 0xbfb99999, 0x99999983, 0x3fe33333, 0x33333337},	/* -0.165149=f(-0.1, 0.6)*/
{35, 0,123,__LINE__, 0xbfc38a03, 0x7141213d, 0xbfb99999, 0x99999983, 0x3fe4cccc, 0xccccccd1},	/* -0.152649=f(-0.1, 0.65)*/
{36, 0,123,__LINE__, 0xbfc229ae, 0xce0fd279, 0xbfb99999, 0x99999983, 0x3fe66666, 0x6666666b},	/* -0.141897=f(-0.1, 0.7)*/
{37, 0,123,__LINE__, 0xbfc0f772, 0xdc510c1d, 0xbfb99999, 0x99999983, 0x3fe80000, 0x00000005},	/* -0.132552=f(-0.1, 0.75)*/
{58, 0,123,__LINE__, 0xbfbfd5ba, 0x9aac2f6e, 0xbfb99999, 0x99999983, 0x3fe99999, 0x9999999f},	/* -0.124355=f(-0.1, 0.8)*/
{37, 0,123,__LINE__, 0xbfbdfad6, 0xad6ff960, 0xbfb99999, 0x99999983, 0x3feb3333, 0x33333339},	/* -0.117109=f(-0.1, 0.85)*/
{35, 0,123,__LINE__, 0xbfbc5408, 0x2d853371, 0xbfb99999, 0x99999983, 0x3feccccc, 0xccccccd3},	/* -0.110657=f(-0.1, 0.9)*/
{36, 0,123,__LINE__, 0xbfbad937, 0x1a39948f, 0xbfb99999, 0x99999983, 0x3fee6666, 0x6666666d},	/* -0.104877=f(-0.1, 0.95)*/
{43, 0,123,__LINE__, 0xc008bbaa, 0xbdcc595a, 0xbfa99999, 0x9999996c, 0xbff00000, 0x00000000},	/* -3.09163=f(-0.05, -1)*/
{42, 0,123,__LINE__, 0xc008b64a, 0xa903220d, 0xbfa99999, 0x9999996c, 0xbfee6666, 0x66666666},	/* -3.08901=f(-0.05, -0.95)*/
{41, 0,123,__LINE__, 0xc008b052, 0x20ad5959, 0xbfa99999, 0x9999996c, 0xbfeccccc, 0xcccccccc},	/* -3.08609=f(-0.05, -0.9)*/
{43, 0,123,__LINE__, 0xc008a9a6, 0x5b568cd2, 0xbfa99999, 0x9999996c, 0xbfeb3333, 0x33333332},	/* -3.08284=f(-0.05, -0.85)*/
{64, 0,123,__LINE__, 0xc008a225, 0xe5677921, 0xbfa99999, 0x9999996c, 0xbfe99999, 0x99999998},	/* -3.07917=f(-0.05, -0.8)*/
{42, 0,123,__LINE__, 0xc00899a6, 0x706f37e7, 0xbfa99999, 0x9999996c, 0xbfe7ffff, 0xfffffffe},	/* -3.07502=f(-0.05, -0.75)*/
{41, 0,123,__LINE__, 0xc0088ff1, 0xae0c7fa8, 0xbfa99999, 0x9999996c, 0xbfe66666, 0x66666664},	/* -3.07029=f(-0.05, -0.7)*/
{40, 0,123,__LINE__, 0xc00884c0, 0xbeea99c2, 0xbfa99999, 0x9999996c, 0xbfe4cccc, 0xccccccca},	/* -3.06482=f(-0.05, -0.65)*/
{41, 0,123,__LINE__, 0xc00877b5, 0x614b844c, 0xbfa99999, 0x9999996c, 0xbfe33333, 0x33333330},	/* -3.05845=f(-0.05, -0.6)*/
{43, 0,123,__LINE__, 0xc008684f, 0x70447842, 0xbfa99999, 0x9999996c, 0xbfe19999, 0x99999996},	/* -3.05093=f(-0.05, -0.55)*/
{42, 0,123,__LINE__, 0xc00855dc, 0x3ffa6549, 0xbfa99999, 0x9999996c, 0xbfdfffff, 0xfffffff9},	/* -3.04192=f(-0.05, -0.5)*/
{40, 0,123,__LINE__, 0xc0083f5b, 0x12d8037d, 0xbfa99999, 0x9999996c, 0xbfdccccc, 0xccccccc6},	/* -3.03094=f(-0.05, -0.45)*/
{63, 0,123,__LINE__, 0xc008234d, 0x7f6ecb9d, 0xbfa99999, 0x9999996c, 0xbfd99999, 0x99999993},	/* -3.01724=f(-0.05, -0.4)*/
{40, 0,123,__LINE__, 0xc007ff60, 0x67632ff1, 0xbfa99999, 0x9999996c, 0xbfd66666, 0x66666660},	/* -2.9997=f(-0.05, -0.35)*/
{40, 0,123,__LINE__, 0xc007cfc1, 0xdc8ac447, 0xbfa99999, 0x9999996c, 0xbfd33333, 0x3333332d},	/* -2.97644=f(-0.05, -0.3)*/
{41, 0,123,__LINE__, 0xc0078db7, 0x34524490, 0xbfa99999, 0x9999996c, 0xbfcfffff, 0xfffffff4},	/* -2.9442=f(-0.05, -0.25)*/
{62, 0,123,__LINE__, 0xc0072c43, 0xf4b1650a, 0xbfa99999, 0x9999996c, 0xbfc99999, 0x9999998e},	/* -2.89661=f(-0.05, -0.2)*/
{40, 0,123,__LINE__, 0xc0068f09, 0x60df593c, 0xbfa99999, 0x9999996c, 0xbfc33333, 0x33333328},	/* -2.81984=f(-0.05, -0.15)*/
{62, 0,123,__LINE__, 0xc0056c6e, 0x7397f5ae, 0xbfa99999, 0x9999996c, 0xbfb99999, 0x99999983},	/* -2.67795=f(-0.05, -0.1)*/
{64, 0,123,__LINE__, 0xc002d97c, 0x7f3321d2, 0xbfa99999, 0x9999996c, 0xbfa99999, 0x9999996c},	/* -2.35619=f(-0.05, -0.05)*/
{64, 0,123,__LINE__, 0xbff921fb, 0x54442cfc, 0xbfa99999, 0x9999996c, 0x3cb70000, 0x00000000},	/* -1.5708=f(-0.05, 3.19189e-16)*/
{58, 0,123,__LINE__, 0xbfe921fb, 0x54442d18, 0xbfa99999, 0x9999996c, 0x3fa99999, 0x999999c8},	/* -0.785398=f(-0.05, 0.05)*/
{57, 0,123,__LINE__, 0xbfddac67, 0x0561bb4f, 0xbfa99999, 0x9999996c, 0x3fb99999, 0x999999b1},	/* -0.463648=f(-0.05, 0.1)*/
{37, 0,123,__LINE__, 0xbfd4978f, 0x9b269ee6, 0xbfa99999, 0x9999996c, 0x3fc33333, 0x3333333f},	/* -0.321751=f(-0.05, 0.15)*/
{57, 0,123,__LINE__, 0xbfcf5b75, 0xf92c80dd, 0xbfa99999, 0x9999996c, 0x3fc99999, 0x999999a6},	/* -0.244979=f(-0.05, 0.2)*/
{37, 0,123,__LINE__, 0xbfc94441, 0xff1e8881, 0xbfa99999, 0x9999996c, 0x3fd00000, 0x00000006},	/* -0.197396=f(-0.05, 0.25)*/
{36, 0,123,__LINE__, 0xbfc52397, 0x7b968d0d, 0xbfa99999, 0x9999996c, 0x3fd33333, 0x33333339},	/* -0.165149=f(-0.05, 0.3)*/
{36, 0,123,__LINE__, 0xbfc229ae, 0xce0fd279, 0xbfa99999, 0x9999996c, 0x3fd66666, 0x6666666c},	/* -0.141897=f(-0.05, 0.35)*/
{58, 0,123,__LINE__, 0xbfbfd5ba, 0x9aac2f6e, 0xbfa99999, 0x9999996c, 0x3fd99999, 0x9999999f},	/* -0.124355=f(-0.05, 0.4)*/
{35, 0,123,__LINE__, 0xbfbc5408, 0x2d853371, 0xbfa99999, 0x9999996c, 0x3fdccccc, 0xccccccd2},	/* -0.110657=f(-0.05, 0.45)*/
{37, 0,123,__LINE__, 0xbfb983e2, 0x8938f9ec, 0xbfa99999, 0x9999996c, 0x3fe00000, 0x00000003},	/* -0.0996687=f(-0.05, 0.5)*/
{38, 0,123,__LINE__, 0xbfb7357c, 0x7ff69abb, 0xbfa99999, 0x9999996c, 0x3fe19999, 0x9999999d},	/* -0.0906599=f(-0.05, 0.55)*/
{36, 0,123,__LINE__, 0xbfb548be, 0x5f151994, 0xbfa99999, 0x9999996c, 0x3fe33333, 0x33333337},	/* -0.0831412=f(-0.05, 0.6)*/
{35, 0,123,__LINE__, 0xbfb3a752, 0xab326ac5, 0xbfa99999, 0x9999996c, 0x3fe4cccc, 0xccccccd1},	/* -0.0767719=f(-0.05, 0.65)*/
{36, 0,123,__LINE__, 0xbfb24134, 0xc6f5ae07, 0xbfa99999, 0x9999996c, 0x3fe66666, 0x6666666b},	/* -0.0713075=f(-0.05, 0.7)*/
{37, 0,123,__LINE__, 0xbfb10a9c, 0x7a9ea626, 0xbfa99999, 0x9999996c, 0x3fe80000, 0x00000005},	/* -0.0665682=f(-0.05, 0.75)*/
{57, 0,123,__LINE__, 0xbfaff55b, 0xb72cfdea, 0xbfa99999, 0x9999996c, 0x3fe99999, 0x9999999f},	/* -0.0624188=f(-0.05, 0.8)*/
{37, 0,123,__LINE__, 0xbfae153e, 0x3b681173, 0xbfa99999, 0x9999996c, 0x3feb3333, 0x33333339},	/* -0.0587558=f(-0.05, 0.85)*/
{35, 0,123,__LINE__, 0xbfac6a4c, 0xe5b4efd8, 0xbfa99999, 0x9999996c, 0x3feccccc, 0xccccccd3},	/* -0.0554985=f(-0.05, 0.9)*/
{36, 0,123,__LINE__, 0xbfaaec2a, 0xd042c2e4, 0xbfa99999, 0x9999996c, 0x3fee6666, 0x6666666d},	/* -0.0525831=f(-0.05, 0.95)*/
{64, 0,123,__LINE__, 0x400921fb, 0x54442d18, 0x3cb70000, 0x00000000, 0xbff00000, 0x00000000},	/* 3.14159=f(3.19189e-16, -1)*/
{64, 0,123,__LINE__, 0x400921fb, 0x54442d18, 0x3cb70000, 0x00000000, 0xbfee6666, 0x66666666},	/* 3.14159=f(3.19189e-16, -0.95)*/
{64, 0,123,__LINE__, 0x400921fb, 0x54442d17, 0x3cb70000, 0x00000000, 0xbfeccccc, 0xcccccccc},	/* 3.14159=f(3.19189e-16, -0.9)*/
{64, 0,123,__LINE__, 0x400921fb, 0x54442d17, 0x3cb70000, 0x00000000, 0xbfeb3333, 0x33333332},	/* 3.14159=f(3.19189e-16, -0.85)*/
{64, 0,123,__LINE__, 0x400921fb, 0x54442d17, 0x3cb70000, 0x00000000, 0xbfe99999, 0x99999998},	/* 3.14159=f(3.19189e-16, -0.8)*/
{64, 0,123,__LINE__, 0x400921fb, 0x54442d17, 0x3cb70000, 0x00000000, 0xbfe7ffff, 0xfffffffe},	/* 3.14159=f(3.19189e-16, -0.75)*/
{64, 0,123,__LINE__, 0x400921fb, 0x54442d17, 0x3cb70000, 0x00000000, 0xbfe66666, 0x66666664},	/* 3.14159=f(3.19189e-16, -0.7)*/
{64, 0,123,__LINE__, 0x400921fb, 0x54442d17, 0x3cb70000, 0x00000000, 0xbfe4cccc, 0xccccccca},	/* 3.14159=f(3.19189e-16, -0.65)*/
{64, 0,123,__LINE__, 0x400921fb, 0x54442d17, 0x3cb70000, 0x00000000, 0xbfe33333, 0x33333330},	/* 3.14159=f(3.19189e-16, -0.6)*/
{64, 0,123,__LINE__, 0x400921fb, 0x54442d17, 0x3cb70000, 0x00000000, 0xbfe19999, 0x99999996},	/* 3.14159=f(3.19189e-16, -0.55)*/
{64, 0,123,__LINE__, 0x400921fb, 0x54442d17, 0x3cb70000, 0x00000000, 0xbfdfffff, 0xfffffff9},	/* 3.14159=f(3.19189e-16, -0.5)*/
{64, 0,123,__LINE__, 0x400921fb, 0x54442d17, 0x3cb70000, 0x00000000, 0xbfdccccc, 0xccccccc6},	/* 3.14159=f(3.19189e-16, -0.45)*/
{64, 0,123,__LINE__, 0x400921fb, 0x54442d16, 0x3cb70000, 0x00000000, 0xbfd99999, 0x99999993},	/* 3.14159=f(3.19189e-16, -0.4)*/
{64, 0,123,__LINE__, 0x400921fb, 0x54442d16, 0x3cb70000, 0x00000000, 0xbfd66666, 0x66666660},	/* 3.14159=f(3.19189e-16, -0.35)*/
{64, 0,123,__LINE__, 0x400921fb, 0x54442d16, 0x3cb70000, 0x00000000, 0xbfd33333, 0x3333332d},	/* 3.14159=f(3.19189e-16, -0.3)*/
{64, 0,123,__LINE__, 0x400921fb, 0x54442d15, 0x3cb70000, 0x00000000, 0xbfcfffff, 0xfffffff4},	/* 3.14159=f(3.19189e-16, -0.25)*/
{64, 0,123,__LINE__, 0x400921fb, 0x54442d15, 0x3cb70000, 0x00000000, 0xbfc99999, 0x9999998e},	/* 3.14159=f(3.19189e-16, -0.2)*/
{64, 0,123,__LINE__, 0x400921fb, 0x54442d13, 0x3cb70000, 0x00000000, 0xbfc33333, 0x33333328},	/* 3.14159=f(3.19189e-16, -0.15)*/
{64, 0,123,__LINE__, 0x400921fb, 0x54442d11, 0x3cb70000, 0x00000000, 0xbfb99999, 0x99999983},	/* 3.14159=f(3.19189e-16, -0.1)*/
{64, 0,123,__LINE__, 0x400921fb, 0x54442d0a, 0x3cb70000, 0x00000000, 0xbfa99999, 0x9999996c},	/* 3.14159=f(3.19189e-16, -0.05)*/
{64, 0,123,__LINE__, 0x3fe921fb, 0x54442d18, 0x3cb70000, 0x00000000, 0x3cb70000, 0x00000000},	/* 0.785398=f(3.19189e-16, 3.19189e-16)*/
{37, 0,123,__LINE__, 0x3cfcbfff, 0xf8d00002, 0x3cb70000, 0x00000000, 0x3fa99999, 0x999999c8},	/* 6.38378e-15=f(3.19189e-16, 0.05)*/
{37, 0,123,__LINE__, 0x3cecbfff, 0xf8d00002, 0x3cb70000, 0x00000000, 0x3fb99999, 0x999999b1},	/* 3.19189e-15=f(3.19189e-16, 0.1)*/
{36, 0,123,__LINE__, 0x3ce32aaa, 0x9de38e41, 0x3cb70000, 0x00000000, 0x3fc33333, 0x3333333f},	/* 2.12793e-15=f(3.19189e-16, 0.15)*/
{37, 0,123,__LINE__, 0x3cdcbfff, 0xf8d00002, 0x3cb70000, 0x00000000, 0x3fc99999, 0x999999a6},	/* 1.59595e-15=f(3.19189e-16, 0.2)*/
{60, 0,123,__LINE__, 0x3cd70000, 0x00000000, 0x3cb70000, 0x00000000, 0x3fd00000, 0x00000006},	/* 1.27676e-15=f(3.19189e-16, 0.25)*/
{36, 0,123,__LINE__, 0x3cd32aaa, 0x9de38e41, 0x3cb70000, 0x00000000, 0x3fd33333, 0x33333339},	/* 1.06396e-15=f(3.19189e-16, 0.3)*/
{37, 0,123,__LINE__, 0x3cd06db6, 0xe01f58d2, 0x3cb70000, 0x00000000, 0x3fd66666, 0x6666666c},	/* 9.11969e-16=f(3.19189e-16, 0.35)*/
{37, 0,123,__LINE__, 0x3cccbfff, 0xf8d00002, 0x3cb70000, 0x00000000, 0x3fd99999, 0x9999999f},	/* 7.97973e-16=f(3.19189e-16, 0.4)*/
{36, 0,123,__LINE__, 0x3cc98e38, 0xeee9e06a, 0x3cb70000, 0x00000000, 0x3fdccccc, 0xccccccd2},	/* 7.09309e-16=f(3.19189e-16, 0.45)*/
{61, 0,123,__LINE__, 0x3cc70000, 0x00000000, 0x3cb70000, 0x00000000, 0x3fe00000, 0x00000003},	/* 6.38378e-16=f(3.19189e-16, 0.5)*/
{37, 0,123,__LINE__, 0x3cc4e8ba, 0x26f130ac, 0x3cb70000, 0x00000000, 0x3fe19999, 0x9999999d},	/* 5.80344e-16=f(3.19189e-16, 0.55)*/
{36, 0,123,__LINE__, 0x3cc32aaa, 0x9de38e41, 0x3cb70000, 0x00000000, 0x3fe33333, 0x33333337},	/* 5.31982e-16=f(3.19189e-16, 0.6)*/
{36, 0,123,__LINE__, 0x3cc1b13b, 0x1e947327, 0x3cb70000, 0x00000000, 0x3fe4cccc, 0xccccccd1},	/* 4.9106e-16=f(3.19189e-16, 0.65)*/
{37, 0,123,__LINE__, 0x3cc06db6, 0xe01f58d2, 0x3cb70000, 0x00000000, 0x3fe66666, 0x6666666b},	/* 4.55984e-16=f(3.19189e-16, 0.7)*/
{61, 0,123,__LINE__, 0x3cbeaaaa, 0xaaaaaaab, 0x3cb70000, 0x00000000, 0x3fe80000, 0x00000005},	/* 4.25585e-16=f(3.19189e-16, 0.75)*/
{37, 0,123,__LINE__, 0x3cbcbfff, 0xf8d00002, 0x3cb70000, 0x00000000, 0x3fe99999, 0x9999999f},	/* 3.98986e-16=f(3.19189e-16, 0.8)*/
{36, 0,123,__LINE__, 0x3cbb0f0f, 0x0253443b, 0x3cb70000, 0x00000000, 0x3feb3333, 0x33333339},	/* 3.75517e-16=f(3.19189e-16, 0.85)*/
{36, 0,123,__LINE__, 0x3cb98e38, 0xeee9e06a, 0x3cb70000, 0x00000000, 0x3feccccc, 0xccccccd3},	/* 3.54655e-16=f(3.19189e-16, 0.9)*/
{37, 0,123,__LINE__, 0x3cb835e5, 0x12921547, 0x3cb70000, 0x00000000, 0x3fee6666, 0x6666666d},	/* 3.35989e-16=f(3.19189e-16, 0.95)*/
{43, 0,123,__LINE__, 0x4008bbaa, 0xbdcc595a, 0x3fa99999, 0x999999c8, 0xbff00000, 0x00000000},	/* 3.09163=f(0.05, -1)*/
{42, 0,123,__LINE__, 0x4008b64a, 0xa903220d, 0x3fa99999, 0x999999c8, 0xbfee6666, 0x66666666},	/* 3.08901=f(0.05, -0.95)*/
{41, 0,123,__LINE__, 0x4008b052, 0x20ad5959, 0x3fa99999, 0x999999c8, 0xbfeccccc, 0xcccccccc},	/* 3.08609=f(0.05, -0.9)*/
{43, 0,123,__LINE__, 0x4008a9a6, 0x5b568cd2, 0x3fa99999, 0x999999c8, 0xbfeb3333, 0x33333332},	/* 3.08284=f(0.05, -0.85)*/
{63, 0,123,__LINE__, 0x4008a225, 0xe5677921, 0x3fa99999, 0x999999c8, 0xbfe99999, 0x99999998},	/* 3.07917=f(0.05, -0.8)*/
{42, 0,123,__LINE__, 0x400899a6, 0x706f37e7, 0x3fa99999, 0x999999c8, 0xbfe7ffff, 0xfffffffe},	/* 3.07502=f(0.05, -0.75)*/
{41, 0,123,__LINE__, 0x40088ff1, 0xae0c7fa8, 0x3fa99999, 0x999999c8, 0xbfe66666, 0x66666664},	/* 3.07029=f(0.05, -0.7)*/
{40, 0,123,__LINE__, 0x400884c0, 0xbeea99c2, 0x3fa99999, 0x999999c8, 0xbfe4cccc, 0xccccccca},	/* 3.06482=f(0.05, -0.65)*/
{41, 0,123,__LINE__, 0x400877b5, 0x614b844c, 0x3fa99999, 0x999999c8, 0xbfe33333, 0x33333330},	/* 3.05845=f(0.05, -0.6)*/
{43, 0,123,__LINE__, 0x4008684f, 0x70447842, 0x3fa99999, 0x999999c8, 0xbfe19999, 0x99999996},	/* 3.05093=f(0.05, -0.55)*/
{42, 0,123,__LINE__, 0x400855dc, 0x3ffa6549, 0x3fa99999, 0x999999c8, 0xbfdfffff, 0xfffffff9},	/* 3.04192=f(0.05, -0.5)*/
{40, 0,123,__LINE__, 0x40083f5b, 0x12d8037d, 0x3fa99999, 0x999999c8, 0xbfdccccc, 0xccccccc6},	/* 3.03094=f(0.05, -0.45)*/
{62, 0,123,__LINE__, 0x4008234d, 0x7f6ecb9d, 0x3fa99999, 0x999999c8, 0xbfd99999, 0x99999993},	/* 3.01724=f(0.05, -0.4)*/
{40, 0,123,__LINE__, 0x4007ff60, 0x67632ff1, 0x3fa99999, 0x999999c8, 0xbfd66666, 0x66666660},	/* 2.9997=f(0.05, -0.35)*/
{40, 0,123,__LINE__, 0x4007cfc1, 0xdc8ac447, 0x3fa99999, 0x999999c8, 0xbfd33333, 0x3333332d},	/* 2.97644=f(0.05, -0.3)*/
{41, 0,123,__LINE__, 0x40078db7, 0x34524490, 0x3fa99999, 0x999999c8, 0xbfcfffff, 0xfffffff4},	/* 2.9442=f(0.05, -0.25)*/
{61, 0,123,__LINE__, 0x40072c43, 0xf4b1650a, 0x3fa99999, 0x999999c8, 0xbfc99999, 0x9999998e},	/* 2.89661=f(0.05, -0.2)*/
{39, 0,123,__LINE__, 0x40068f09, 0x60df593c, 0x3fa99999, 0x999999c8, 0xbfc33333, 0x33333328},	/* 2.81984=f(0.05, -0.15)*/
{60, 0,123,__LINE__, 0x40056c6e, 0x7397f5ae, 0x3fa99999, 0x999999c8, 0xbfb99999, 0x99999983},	/* 2.67795=f(0.05, -0.1)*/
{60, 0,123,__LINE__, 0x4002d97c, 0x7f3321d2, 0x3fa99999, 0x999999c8, 0xbfa99999, 0x9999996c},	/* 2.35619=f(0.05, -0.05)*/
{64, 0,123,__LINE__, 0x3ff921fb, 0x54442cfc, 0x3fa99999, 0x999999c8, 0x3cb70000, 0x00000000},	/* 1.5708=f(0.05, 3.19189e-16)*/
{64, 0,123,__LINE__, 0x3fe921fb, 0x54442d18, 0x3fa99999, 0x999999c8, 0x3fa99999, 0x999999c8},	/* 0.785398=f(0.05, 0.05)*/
{59, 0,123,__LINE__, 0x3fddac67, 0x0561bb4f, 0x3fa99999, 0x999999c8, 0x3fb99999, 0x999999b1},	/* 0.463648=f(0.05, 0.1)*/
{36, 0,123,__LINE__, 0x3fd4978f, 0x9b269ee6, 0x3fa99999, 0x999999c8, 0x3fc33333, 0x3333333f},	/* 0.321751=f(0.05, 0.15)*/
{58, 0,123,__LINE__, 0x3fcf5b75, 0xf92c80dd, 0x3fa99999, 0x999999c8, 0x3fc99999, 0x999999a6},	/* 0.244979=f(0.05, 0.2)*/
{37, 0,123,__LINE__, 0x3fc94441, 0xff1e8881, 0x3fa99999, 0x999999c8, 0x3fd00000, 0x00000006},	/* 0.197396=f(0.05, 0.25)*/
{36, 0,123,__LINE__, 0x3fc52397, 0x7b968d0d, 0x3fa99999, 0x999999c8, 0x3fd33333, 0x33333339},	/* 0.165149=f(0.05, 0.3)*/
{36, 0,123,__LINE__, 0x3fc229ae, 0xce0fd279, 0x3fa99999, 0x999999c8, 0x3fd66666, 0x6666666c},	/* 0.141897=f(0.05, 0.35)*/
{58, 0,123,__LINE__, 0x3fbfd5ba, 0x9aac2f6e, 0x3fa99999, 0x999999c8, 0x3fd99999, 0x9999999f},	/* 0.124355=f(0.05, 0.4)*/
{35, 0,123,__LINE__, 0x3fbc5408, 0x2d853371, 0x3fa99999, 0x999999c8, 0x3fdccccc, 0xccccccd2},	/* 0.110657=f(0.05, 0.45)*/
{37, 0,123,__LINE__, 0x3fb983e2, 0x8938f9ec, 0x3fa99999, 0x999999c8, 0x3fe00000, 0x00000003},	/* 0.0996687=f(0.05, 0.5)*/
{38, 0,123,__LINE__, 0x3fb7357c, 0x7ff69abb, 0x3fa99999, 0x999999c8, 0x3fe19999, 0x9999999d},	/* 0.0906599=f(0.05, 0.55)*/
{36, 0,123,__LINE__, 0x3fb548be, 0x5f151994, 0x3fa99999, 0x999999c8, 0x3fe33333, 0x33333337},	/* 0.0831412=f(0.05, 0.6)*/
{35, 0,123,__LINE__, 0x3fb3a752, 0xab326ac5, 0x3fa99999, 0x999999c8, 0x3fe4cccc, 0xccccccd1},	/* 0.0767719=f(0.05, 0.65)*/
{36, 0,123,__LINE__, 0x3fb24134, 0xc6f5ae07, 0x3fa99999, 0x999999c8, 0x3fe66666, 0x6666666b},	/* 0.0713075=f(0.05, 0.7)*/
{37, 0,123,__LINE__, 0x3fb10a9c, 0x7a9ea626, 0x3fa99999, 0x999999c8, 0x3fe80000, 0x00000005},	/* 0.0665682=f(0.05, 0.75)*/
{58, 0,123,__LINE__, 0x3faff55b, 0xb72cfdea, 0x3fa99999, 0x999999c8, 0x3fe99999, 0x9999999f},	/* 0.0624188=f(0.05, 0.8)*/
{37, 0,123,__LINE__, 0x3fae153e, 0x3b681173, 0x3fa99999, 0x999999c8, 0x3feb3333, 0x33333339},	/* 0.0587558=f(0.05, 0.85)*/
{35, 0,123,__LINE__, 0x3fac6a4c, 0xe5b4efd8, 0x3fa99999, 0x999999c8, 0x3feccccc, 0xccccccd3},	/* 0.0554985=f(0.05, 0.9)*/
{36, 0,123,__LINE__, 0x3faaec2a, 0xd042c2e4, 0x3fa99999, 0x999999c8, 0x3fee6666, 0x6666666d},	/* 0.0525831=f(0.05, 0.95)*/
{42, 0,123,__LINE__, 0x400855dc, 0x3ffa6549, 0x3fb99999, 0x999999b1, 0xbff00000, 0x00000000},	/* 3.04192=f(0.1, -1)*/
{41, 0,123,__LINE__, 0x40084b31, 0x9b726074, 0x3fb99999, 0x999999b1, 0xbfee6666, 0x66666666},	/* 3.03672=f(0.1, -0.95)*/
{40, 0,123,__LINE__, 0x40083f5b, 0x12d8037d, 0x3fb99999, 0x999999b1, 0xbfeccccc, 0xcccccccc},	/* 3.03094=f(0.1, -0.9)*/
{42, 0,123,__LINE__, 0x40083224, 0x9ed8ad4d, 0x3fb99999, 0x999999b1, 0xbfeb3333, 0x33333332},	/* 3.02448=f(0.1, -0.85)*/
{63, 0,123,__LINE__, 0x4008234d, 0x7f6ecb9d, 0x3fb99999, 0x999999b1, 0xbfe99999, 0x99999998},	/* 3.01724=f(0.1, -0.8)*/
{41, 0,123,__LINE__, 0x40081284, 0x267f1c56, 0x3fb99999, 0x999999b1, 0xbfe7ffff, 0xfffffffe},	/* 3.00904=f(0.1, -0.75)*/
{40, 0,123,__LINE__, 0x4007ff60, 0x67632ff1, 0x3fb99999, 0x999999b1, 0xbfe66666, 0x66666664},	/* 2.9997=f(0.1, -0.7)*/
{39, 0,123,__LINE__, 0x4007e95b, 0x1d301b04, 0x3fb99999, 0x999999b1, 0xbfe4cccc, 0xccccccca},	/* 2.98894=f(0.1, -0.65)*/
{40, 0,123,__LINE__, 0x4007cfc1, 0xdc8ac447, 0x3fb99999, 0x999999b1, 0xbfe33333, 0x33333330},	/* 2.97644=f(0.1, -0.6)*/
{42, 0,123,__LINE__, 0x4007b1a4, 0x4c4fb28c, 0x3fb99999, 0x999999b1, 0xbfe19999, 0x99999996},	/* 2.96174=f(0.1, -0.55)*/
{41, 0,123,__LINE__, 0x40078db7, 0x34524490, 0x3fb99999, 0x999999b1, 0xbfdfffff, 0xfffffff9},	/* 2.9442=f(0.1, -0.5)*/
{39, 0,123,__LINE__, 0x40076225, 0xd1fd908f, 0x3fb99999, 0x999999b1, 0xbfdccccc, 0xccccccc6},	/* 2.92292=f(0.1, -0.45)*/
{62, 0,123,__LINE__, 0x40072c43, 0xf4b1650a, 0x3fb99999, 0x999999b1, 0xbfd99999, 0x99999993},	/* 2.89661=f(0.1, -0.4)*/
{39, 0,123,__LINE__, 0x4006e806, 0x27330bab, 0x3fb99999, 0x999999b1, 0xbfd66666, 0x66666660},	/* 2.86329=f(0.1, -0.35)*/
{39, 0,123,__LINE__, 0x40068f09, 0x60df593c, 0x3fb99999, 0x999999b1, 0xbfd33333, 0x3333332d},	/* 2.81984=f(0.1, -0.3)*/
{40, 0,123,__LINE__, 0x400616b4, 0x6626b023, 0x3fb99999, 0x999999b1, 0xbfcfffff, 0xfffffff4},	/* 2.76109=f(0.1, -0.25)*/
{61, 0,123,__LINE__, 0x40056c6e, 0x7397f5ae, 0x3fb99999, 0x999999b1, 0xbfc99999, 0x9999998e},	/* 2.67795=f(0.1, -0.2)*/
{39, 0,123,__LINE__, 0x40046dc0, 0xa04c6cd0, 0x3fb99999, 0x999999b1, 0xbfc33333, 0x33333328},	/* 2.55359=f(0.1, -0.15)*/
{61, 0,123,__LINE__, 0x4002d97c, 0x7f3321d2, 0x3fb99999, 0x999999b1, 0xbfb99999, 0x99999983},	/* 2.35619=f(0.1, -0.1)*/
{60, 0,123,__LINE__, 0x4000468a, 0x8ace4df6, 0x3fb99999, 0x999999b1, 0xbfa99999, 0x9999996c},	/* 2.03444=f(0.1, -0.05)*/
{64, 0,123,__LINE__, 0x3ff921fb, 0x54442d0a, 0x3fb99999, 0x999999b1, 0x3cb70000, 0x00000000},	/* 1.5708=f(0.1, 3.19189e-16)*/
{61, 0,123,__LINE__, 0x3ff1b6e1, 0x92ebbe44, 0x3fb99999, 0x999999b1, 0x3fa99999, 0x999999c8},	/* 1.10715=f(0.1, 0.05)*/
{64, 0,123,__LINE__, 0x3fe921fb, 0x54442d18, 0x3fb99999, 0x999999b1, 0x3fb99999, 0x999999b1},	/* 0.785398=f(0.1, 0.1)*/
{37, 0,123,__LINE__, 0x3fe2d0ea, 0xcfdf0123, 0x3fb99999, 0x999999b1, 0x3fc33333, 0x3333333f},	/* 0.588003=f(0.1, 0.15)*/
{60, 0,123,__LINE__, 0x3fddac67, 0x0561bb4f, 0x3fb99999, 0x999999b1, 0x3fc99999, 0x999999a6},	/* 0.463648=f(0.1, 0.2)*/
{37, 0,123,__LINE__, 0x3fd85a37, 0x70ebe7ae, 0x3fb99999, 0x999999b1, 0x3fd00000, 0x00000006},	/* 0.380506=f(0.1, 0.25)*/
{36, 0,123,__LINE__, 0x3fd4978f, 0x9b269ee6, 0x3fb99999, 0x999999b1, 0x3fd33333, 0x33333339},	/* 0.321751=f(0.1, 0.3)*/
{36, 0,123,__LINE__, 0x3fd1cfa9, 0x68890b66, 0x3fb99999, 0x999999b1, 0x3fd66666, 0x6666666c},	/* 0.2783=f(0.1, 0.35)*/
{59, 0,123,__LINE__, 0x3fcf5b75, 0xf92c80dd, 0x3fb99999, 0x999999b1, 0x3fd99999, 0x9999999f},	/* 0.244979=f(0.1, 0.4)*/
{35, 0,123,__LINE__, 0x3fcbfd58, 0x2469c89c, 0x3fb99999, 0x999999b1, 0x3fdccccc, 0xccccccd2},	/* 0.218669=f(0.1, 0.45)*/
{37, 0,123,__LINE__, 0x3fc94441, 0xff1e8881, 0x3fb99999, 0x999999b1, 0x3fe00000, 0x00000003},	/* 0.197396=f(0.1, 0.5)*/
{38, 0,123,__LINE__, 0x3fc70570, 0x7f47a8be, 0x3fb99999, 0x999999b1, 0x3fe19999, 0x9999999d},	/* 0.179853=f(0.1, 0.55)*/
{36, 0,123,__LINE__, 0x3fc52397, 0x7b968d0d, 0x3fb99999, 0x999999b1, 0x3fe33333, 0x33333337},	/* 0.165149=f(0.1, 0.6)*/
{35, 0,123,__LINE__, 0x3fc38a03, 0x7141213d, 0x3fb99999, 0x999999b1, 0x3fe4cccc, 0xccccccd1},	/* 0.152649=f(0.1, 0.65)*/
{36, 0,123,__LINE__, 0x3fc229ae, 0xce0fd279, 0x3fb99999, 0x999999b1, 0x3fe66666, 0x6666666b},	/* 0.141897=f(0.1, 0.7)*/
{37, 0,123,__LINE__, 0x3fc0f772, 0xdc510c1d, 0x3fb99999, 0x999999b1, 0x3fe80000, 0x00000005},	/* 0.132552=f(0.1, 0.75)*/
{59, 0,123,__LINE__, 0x3fbfd5ba, 0x9aac2f6e, 0x3fb99999, 0x999999b1, 0x3fe99999, 0x9999999f},	/* 0.124355=f(0.1, 0.8)*/
{37, 0,123,__LINE__, 0x3fbdfad6, 0xad6ff960, 0x3fb99999, 0x999999b1, 0x3feb3333, 0x33333339},	/* 0.117109=f(0.1, 0.85)*/
{35, 0,123,__LINE__, 0x3fbc5408, 0x2d853371, 0x3fb99999, 0x999999b1, 0x3feccccc, 0xccccccd3},	/* 0.110657=f(0.1, 0.9)*/
{36, 0,123,__LINE__, 0x3fbad937, 0x1a39948f, 0x3fb99999, 0x999999b1, 0x3fee6666, 0x6666666d},	/* 0.104877=f(0.1, 0.95)*/
{40, 0,123,__LINE__, 0x4007f10e, 0x1cfe652c, 0x3fc33333, 0x3333333f, 0xbff00000, 0x00000000},	/* 2.9927=f(0.15, -1)*/
{39, 0,123,__LINE__, 0x4007e142, 0xd70e612f, 0x3fc33333, 0x3333333f, 0xbfee6666, 0x66666666},	/* 2.98499=f(0.15, -0.95)*/
{39, 0,123,__LINE__, 0x4007cfc1, 0xda8f611b, 0x3fc33333, 0x3333333f, 0xbfeccccc, 0xcccccccc},	/* 2.97644=f(0.15, -0.9)*/
{41, 0,123,__LINE__, 0x4007bc40, 0xca4d5d6f, 0x3fc33333, 0x3333333f, 0xbfeb3333, 0x33333332},	/* 2.96692=f(0.15, -0.85)*/
{40, 0,123,__LINE__, 0x4007a663, 0x9eecb680, 0x3fc33333, 0x3333333f, 0xbfe99999, 0x99999998},	/* 2.95624=f(0.15, -0.8)*/
{39, 0,123,__LINE__, 0x40078db7, 0x33ae2a4f, 0x3fc33333, 0x3333333f, 0xbfe7ffff, 0xfffffffe},	/* 2.9442=f(0.15, -0.75)*/
{39, 0,123,__LINE__, 0x400771a9, 0x9f1fcdc4, 0x3fc33333, 0x3333333f, 0xbfe66666, 0x66666664},	/* 2.9305=f(0.15, -0.7)*/
{38, 0,123,__LINE__, 0x4007517f, 0x67eb9995, 0x3fc33333, 0x3333333f, 0xbfe4cccc, 0xccccccca},	/* 2.91479=f(0.15, -0.65)*/
{63, 0,123,__LINE__, 0x40072c43, 0xf4b1650a, 0x3fc33333, 0x3333333f, 0xbfe33333, 0x33333330},	/* 2.89661=f(0.15, -0.6)*/
{40, 0,123,__LINE__, 0x400700b2, 0x9289de37, 0x3fc33333, 0x3333333f, 0xbfe19999, 0x99999996},	/* 2.87534=f(0.15, -0.55)*/
{39, 0,123,__LINE__, 0x4006cd14, 0x06088f96, 0x3fc33333, 0x3333333f, 0xbfdfffff, 0xfffffff9},	/* 2.85014=f(0.15, -0.5)*/
{38, 0,123,__LINE__, 0x40068f09, 0x5d34ae91, 0x3fc33333, 0x3333333f, 0xbfdccccc, 0xccccccc6},	/* 2.81984=f(0.15, -0.45)*/
{39, 0,123,__LINE__, 0x40064338, 0x2aef04f4, 0x3fc33333, 0x3333333f, 0xbfd99999, 0x99999993},	/* 2.78282=f(0.15, -0.4)*/
{38, 0,123,__LINE__, 0x4005e4c3, 0x69dddc93, 0x3fc33333, 0x3333333f, 0xbfd66666, 0x66666660},	/* 2.7367=f(0.15, -0.35)*/
{62, 0,123,__LINE__, 0x40056c6e, 0x7397f5ae, 0x3fc33333, 0x3333333f, 0xbfd33333, 0x3333332d},	/* 2.67795=f(0.15, -0.3)*/
{38, 0,123,__LINE__, 0x4004cf33, 0xdc6b8f86, 0x3fc33333, 0x3333333f, 0xbfcfffff, 0xfffffff4},	/* 2.60117=f(0.15, -0.25)*/
{39, 0,123,__LINE__, 0x4003fc17, 0x69e0ebc7, 0x3fc33333, 0x3333333f, 0xbfc99999, 0x9999998e},	/* 2.49809=f(0.15, -0.2)*/
{61, 0,123,__LINE__, 0x4002d97c, 0x7f3321d2, 0x3fc33333, 0x3333333f, 0xbfc33333, 0x33333328},	/* 2.35619=f(0.15, -0.15)*/
{39, 0,123,__LINE__, 0x40014538, 0x5e19d6d5, 0x3fc33333, 0x3333333f, 0xbfb99999, 0x99999983},	/* 2.1588=f(0.15, -0.1)*/
{39, 0,123,__LINE__, 0x3ffe47df, 0x3b0dd4d2, 0x3fc33333, 0x3333333f, 0xbfa99999, 0x9999996c},	/* 1.89255=f(0.15, -0.05)*/
{64, 0,123,__LINE__, 0x3ff921fb, 0x54442d0f, 0x3fc33333, 0x3333333f, 0x3cb70000, 0x00000000},	/* 1.5708=f(0.15, 3.19189e-16)*/
{38, 0,123,__LINE__, 0x3ff3fc17, 0x6d7a855f, 0x3fc33333, 0x3333333f, 0x3fa99999, 0x999999c8},	/* 1.24905=f(0.15, 0.05)*/
{37, 0,123,__LINE__, 0x3fef730b, 0xd8a9590e, 0x3fc33333, 0x3333333f, 0x3fb99999, 0x999999b1},	/* 0.982794=f(0.15, 0.1)*/
{64, 0,123,__LINE__, 0x3fe921fb, 0x54442d18, 0x3fc33333, 0x3333333f, 0x3fc33333, 0x3333333f},	/* 0.785398=f(0.15, 0.15)*/
{37, 0,123,__LINE__, 0x3fe4978f, 0xa98d0545, 0x3fc33333, 0x3333333f, 0x3fc99999, 0x999999a6},	/* 0.643501=f(0.15, 0.2)*/
{36, 0,123,__LINE__, 0x3fe14b1d, 0xdf627649, 0x3fc33333, 0x3333333f, 0x3fd00000, 0x00000006},	/* 0.54042=f(0.15, 0.25)*/
{60, 0,123,__LINE__, 0x3fddac67, 0x0561bb4f, 0x3fc33333, 0x3333333f, 0x3fd33333, 0x33333339},	/* 0.463648=f(0.15, 0.3)*/
{35, 0,123,__LINE__, 0x3fd9e9bf, 0x5332842d, 0x3fc33333, 0x3333333f, 0x3fd66666, 0x6666666c},	/* 0.404892=f(0.15, 0.35)*/
{36, 0,123,__LINE__, 0x3fd6f619, 0x4aa9411f, 0x3fc33333, 0x3333333f, 0x3fd99999, 0x9999999f},	/* 0.358771=f(0.15, 0.4)*/
{35, 0,123,__LINE__, 0x3fd4978f, 0xb87bf43e, 0x3fc33333, 0x3333333f, 0x3fdccccc, 0xccccccd2},	/* 0.321751=f(0.15, 0.45)*/
{36, 0,123,__LINE__, 0x3fd2a73a, 0x71dcec16, 0x3fc33333, 0x3333333f, 0x3fe00000, 0x00000003},	/* 0.291457=f(0.15, 0.5)*/
{37, 0,123,__LINE__, 0x3fd10a46, 0x0dd2770d, 0x3fc33333, 0x3333333f, 0x3fe19999, 0x9999999d},	/* 0.266252=f(0.15, 0.55)*/
{60, 0,123,__LINE__, 0x3fcf5b75, 0xf92c80dd, 0x3fc33333, 0x3333333f, 0x3fe33333, 0x33333337},	/* 0.244979=f(0.15, 0.6)*/
{34, 0,123,__LINE__, 0x3fcd07be, 0xc5893835, 0x3fc33333, 0x3333333f, 0x3fe4cccc, 0xccccccd1},	/* 0.226799=f(0.15, 0.65)*/
{35, 0,123,__LINE__, 0x3fcb051b, 0x5245f540, 0x3fc33333, 0x3333333f, 0x3fe66666, 0x6666666b},	/* 0.211093=f(0.15, 0.7)*/
{35, 0,123,__LINE__, 0x3fc94442, 0x09602c9b, 0x3fc33333, 0x3333333f, 0x3fe80000, 0x00000005},	/* 0.197396=f(0.15, 0.75)*/
{36, 0,123,__LINE__, 0x3fc7b97b, 0x5577697d, 0x3fc33333, 0x3333333f, 0x3fe99999, 0x9999999f},	/* 0.185348=f(0.15, 0.8)*/
{37, 0,123,__LINE__, 0x3fc65ba8, 0x9f6cfa93, 0x3fc33333, 0x3333333f, 0x3feb3333, 0x33333339},	/* 0.174672=f(0.15, 0.85)*/
{35, 0,123,__LINE__, 0x3fc52397, 0x9b4cbfce, 0x3fc33333, 0x3333333f, 0x3feccccc, 0xccccccd3},	/* 0.165149=f(0.15, 0.9)*/
{35, 0,123,__LINE__, 0x3fc40b87, 0xd35cbe95, 0x3fc33333, 0x3333333f, 0x3fee6666, 0x6666666d},	/* 0.156602=f(0.15, 0.95)*/
{41, 0,123,__LINE__, 0x40078db7, 0x34524490, 0x3fc99999, 0x999999a6, 0xbff00000, 0x00000000},	/* 2.9442=f(0.2, -1)*/
{40, 0,123,__LINE__, 0x40077907, 0x8b7161f7, 0x3fc99999, 0x999999a6, 0xbfee6666, 0x66666666},	/* 2.9341=f(0.2, -0.95)*/
{39, 0,123,__LINE__, 0x40076225, 0xd1fd908f, 0x3fc99999, 0x999999a6, 0xbfeccccc, 0xcccccccc},	/* 2.92292=f(0.2, -0.9)*/
{41, 0,123,__LINE__, 0x400748b5, 0x4458c287, 0x3fc99999, 0x999999a6, 0xbfeb3333, 0x33333332},	/* 2.9105=f(0.2, -0.85)*/
{63, 0,123,__LINE__, 0x40072c43, 0xf4b1650a, 0x3fc99999, 0x999999a6, 0xbfe99999, 0x99999998},	/* 2.89661=f(0.2, -0.8)*/
{41, 0,123,__LINE__, 0x40070c44, 0x9ed6318f, 0x3fc99999, 0x999999a6, 0xbfe7ffff, 0xfffffffe},	/* 2.88099=f(0.2, -0.75)*/
{39, 0,123,__LINE__, 0x4006e806, 0x27330bab, 0x3fc99999, 0x999999a6, 0xbfe66666, 0x66666664},	/* 2.86329=f(0.2, -0.7)*/
{39, 0,123,__LINE__, 0x4006bea7, 0xe9e995d8, 0x3fc99999, 0x999999a6, 0xbfe4cccc, 0xccccccca},	/* 2.84309=f(0.2, -0.65)*/
{39, 0,123,__LINE__, 0x40068f09, 0x60df593c, 0x3fc99999, 0x999999a6, 0xbfe33333, 0x33333330},	/* 2.81984=f(0.2, -0.6)*/
{41, 0,123,__LINE__, 0x400657b2, 0xe0dd6ecf, 0x3fc99999, 0x999999a6, 0xbfe19999, 0x99999996},	/* 2.79282=f(0.2, -0.55)*/
{40, 0,123,__LINE__, 0x400616b4, 0x6626b023, 0x3fc99999, 0x999999a6, 0xbfdfffff, 0xfffffff9},	/* 2.76109=f(0.2, -0.5)*/
{38, 0,123,__LINE__, 0x4005c975, 0x52e4ddd8, 0x3fc99999, 0x999999a6, 0xbfdccccc, 0xccccccc6},	/* 2.72337=f(0.2, -0.45)*/
{62, 0,123,__LINE__, 0x40056c6e, 0x7397f5ae, 0x3fc99999, 0x999999a6, 0xbfd99999, 0x99999993},	/* 2.67795=f(0.2, -0.4)*/
{39, 0,123,__LINE__, 0x4004fac5, 0x3e774951, 0x3fc99999, 0x999999a6, 0xbfd66666, 0x66666660},	/* 2.62245=f(0.2, -0.35)*/
{39, 0,123,__LINE__, 0x40046dc0, 0xa04c6cd0, 0x3fc99999, 0x999999a6, 0xbfd33333, 0x3333332d},	/* 2.55359=f(0.2, -0.3)*/
{40, 0,123,__LINE__, 0x4003bc1c, 0xbf0970e4, 0x3fc99999, 0x999999a6, 0xbfcfffff, 0xfffffff4},	/* 2.46685=f(0.2, -0.25)*/
{61, 0,123,__LINE__, 0x4002d97c, 0x7f3321d2, 0x3fc99999, 0x999999a6, 0xbfc99999, 0x9999998e},	/* 2.35619=f(0.2, -0.2)*/
{39, 0,123,__LINE__, 0x4001b6e1, 0x948557dd, 0x3fc99999, 0x999999a6, 0xbfc33333, 0x33333328},	/* 2.2143=f(0.2, -0.15)*/
{61, 0,123,__LINE__, 0x4000468a, 0x8ace4df6, 0x3fc99999, 0x999999a6, 0xbfb99999, 0x99999983},	/* 2.03444=f(0.2, -0.1)*/
{60, 0,123,__LINE__, 0x3ffd0d6a, 0x1369bd34, 0x3fc99999, 0x999999a6, 0xbfa99999, 0x9999996c},	/* 1.81577=f(0.2, -0.05)*/
{64, 0,123,__LINE__, 0x3ff921fb, 0x54442d11, 0x3fc99999, 0x999999a6, 0x3cb70000, 0x00000000},	/* 1.5708=f(0.2, 3.19189e-16)*/
{61, 0,123,__LINE__, 0x3ff5368c, 0x951e9cfd, 0x3fc99999, 0x999999a6, 0x3fa99999, 0x999999c8},	/* 1.32582=f(0.2, 0.05)*/
{62, 0,123,__LINE__, 0x3ff1b6e1, 0x92ebbe44, 0x3fc99999, 0x999999a6, 0x3fb99999, 0x999999b1},	/* 1.10715=f(0.2, 0.1)*/
{37, 0,123,__LINE__, 0x3fedac66, 0xfefb54ec, 0x3fc99999, 0x999999a6, 0x3fc33333, 0x3333333f},	/* 0.927295=f(0.2, 0.15)*/
{64, 0,123,__LINE__, 0x3fe921fb, 0x54442d18, 0x3fc99999, 0x999999a6, 0x3fc99999, 0x999999a6},	/* 0.785398=f(0.2, 0.2)*/
{38, 0,123,__LINE__, 0x3fe5977a, 0x54eaf0d0, 0x3fc99999, 0x999999a6, 0x3fd00000, 0x00000006},	/* 0.674741=f(0.2, 0.25)*/
{37, 0,123,__LINE__, 0x3fe2d0ea, 0xcfdf0123, 0x3fc99999, 0x999999a6, 0x3fd33333, 0x33333339},	/* 0.588003=f(0.2, 0.3)*/
{37, 0,123,__LINE__, 0x3fe09cd8, 0x57338f1c, 0x3fc99999, 0x999999a6, 0x3fd66666, 0x6666666c},	/* 0.519146=f(0.2, 0.35)*/
{61, 0,123,__LINE__, 0x3fddac67, 0x0561bb4f, 0x3fc99999, 0x999999a6, 0x3fd99999, 0x9999999f},	/* 0.463648=f(0.2, 0.4)*/
{35, 0,123,__LINE__, 0x3fdac430, 0x0afa7a04, 0x3fc99999, 0x999999a6, 0x3fdccccc, 0xccccccd2},	/* 0.418224=f(0.2, 0.45)*/
{37, 0,123,__LINE__, 0x3fd85a37, 0x70ebe7ae, 0x3fc99999, 0x999999a6, 0x3fe00000, 0x00000003},	/* 0.380506=f(0.2, 0.5)*/
{38, 0,123,__LINE__, 0x3fd65243, 0x9b35f24d, 0x3fc99999, 0x999999a6, 0x3fe19999, 0x9999999d},	/* 0.348771=f(0.2, 0.55)*/
{36, 0,123,__LINE__, 0x3fd4978f, 0x9b269ee6, 0x3fc99999, 0x999999a6, 0x3fe33333, 0x33333337},	/* 0.321751=f(0.2, 0.6)*/
{36, 0,123,__LINE__, 0x3fd31a9b, 0x52d4ba05, 0x3fc99999, 0x999999a6, 0x3fe4cccc, 0xccccccd1},	/* 0.298499=f(0.2, 0.65)*/
{36, 0,123,__LINE__, 0x3fd1cfa9, 0x68890b66, 0x3fc99999, 0x999999a6, 0x3fe66666, 0x6666666b},	/* 0.2783=f(0.2, 0.7)*/
{38, 0,123,__LINE__, 0x3fd0adb5, 0xab6fdc47, 0x3fc99999, 0x999999a6, 0x3fe80000, 0x00000005},	/* 0.260602=f(0.2, 0.75)*/
{60, 0,123,__LINE__, 0x3fcf5b75, 0xf92c80dd, 0x3fc99999, 0x999999a6, 0x3fe99999, 0x9999999f},	/* 0.244979=f(0.2, 0.8)*/
{37, 0,123,__LINE__, 0x3fcd9460, 0xfeb6a910, 0x3fc99999, 0x999999a6, 0x3feb3333, 0x33333339},	/* 0.231091=f(0.2, 0.85)*/
{35, 0,123,__LINE__, 0x3fcbfd58, 0x2469c89c, 0x3fc99999, 0x999999a6, 0x3feccccc, 0xccccccd3},	/* 0.218669=f(0.2, 0.9)*/
{36, 0,123,__LINE__, 0x3fca8f3c, 0x8d2cb215, 0x3fc99999, 0x999999a6, 0x3fee6666, 0x6666666d},	/* 0.207496=f(0.2, 0.95)*/
{64, 0,123,__LINE__, 0x40072c43, 0xf4b1650a, 0x3fd00000, 0x00000006, 0xbff00000, 0x00000000},	/* 2.89661=f(0.25, -1)*/
{41, 0,123,__LINE__, 0x400712fb, 0x9777c615, 0x3fd00000, 0x00000006, 0xbfee6666, 0x66666666},	/* 2.88427=f(0.25, -0.95)*/
{40, 0,123,__LINE__, 0x4006f715, 0x24b02fc3, 0x3fd00000, 0x00000006, 0xbfeccccc, 0xcccccccc},	/* 2.87065=f(0.25, -0.9)*/
{39, 0,123,__LINE__, 0x4006d825, 0xfeafdf22, 0x3fd00000, 0x00000006, 0xbfeb3333, 0x33333332},	/* 2.85554=f(0.25, -0.85)*/
{40, 0,123,__LINE__, 0x4006b5ac, 0x6df4f37e, 0x3fd00000, 0x00000006, 0xbfe99999, 0x99999998},	/* 2.83871=f(0.25, -0.8)*/
{63, 0,123,__LINE__, 0x40068f09, 0x5fdf593c, 0x3fd00000, 0x00000006, 0xbfe7ffff, 0xfffffffe},	/* 2.81984=f(0.25, -0.75)*/
{40, 0,123,__LINE__, 0x40066377, 0xfd9c0560, 0x3fd00000, 0x00000006, 0xbfe66666, 0x66666664},	/* 2.79857=f(0.25, -0.7)*/
{39, 0,123,__LINE__, 0x40063202, 0x7cdc56ad, 0x3fd00000, 0x00000006, 0xbfe4cccc, 0xccccccca},	/* 2.77442=f(0.25, -0.65)*/
{39, 0,123,__LINE__, 0x4005f973, 0x170a042b, 0x3fd00000, 0x00000006, 0xbfe33333, 0x33333330},	/* 2.7468=f(0.25, -0.6)*/
{39, 0,123,__LINE__, 0x4005b83f, 0xa88849f6, 0x3fd00000, 0x00000006, 0xbfe19999, 0x99999996},	/* 2.71497=f(0.25, -0.55)*/
{62, 0,123,__LINE__, 0x40056c6e, 0x7397f5ae, 0x3fd00000, 0x00000006, 0xbfdfffff, 0xfffffff9},	/* 2.67795=f(0.25, -0.5)*/
{39, 0,123,__LINE__, 0x40051371, 0xa9a00948, 0x3fd00000, 0x00000006, 0xbfdccccc, 0xccccccc6},	/* 2.63449=f(0.25, -0.45)*/
{40, 0,123,__LINE__, 0x4004a9f8, 0x6a328a2f, 0x3fd00000, 0x00000006, 0xbfd99999, 0x99999993},	/* 2.58299=f(0.25, -0.4)*/
{39, 0,123,__LINE__, 0x40042bb5, 0xf66229c5, 0x3fd00000, 0x00000006, 0xbfd66666, 0x66666660},	/* 2.52134=f(0.25, -0.35)*/
{38, 0,123,__LINE__, 0x40039328, 0x65e74c29, 0x3fd00000, 0x00000006, 0xbfd33333, 0x3333332d},	/* 2.44685=f(0.25, -0.3)*/
{62, 0,123,__LINE__, 0x4002d97c, 0x7f3321d2, 0x3fd00000, 0x00000006, 0xbfcfffff, 0xfffffff4},	/* 2.35619=f(0.25, -0.25)*/
{40, 0,123,__LINE__, 0x4001f6dc, 0x3f5cd2c0, 0x3fd00000, 0x00000006, 0xbfc99999, 0x9999998e},	/* 2.24554=f(0.25, -0.2)*/
{38, 0,123,__LINE__, 0x4000e3c5, 0x21fab41e, 0x3fd00000, 0x00000006, 0xbfc33333, 0x33333328},	/* 2.11122=f(0.25, -0.15)*/
{39, 0,123,__LINE__, 0x3fff3889, 0x307f2704, 0x3fd00000, 0x00000006, 0xbfb99999, 0x99999983},	/* 1.9513=f(0.25, -0.1)*/
{40, 0,123,__LINE__, 0x3ffc4a83, 0x9427fe28, 0x3fd00000, 0x00000006, 0xbfa99999, 0x9999996c},	/* 1.76819=f(0.25, -0.05)*/
{64, 0,123,__LINE__, 0x3ff921fb, 0x54442d13, 0x3fd00000, 0x00000006, 0x3cb70000, 0x00000000},	/* 1.5708=f(0.25, 3.19189e-16)*/
{40, 0,123,__LINE__, 0x3ff5f973, 0x14605c08, 0x3fd00000, 0x00000006, 0x3fa99999, 0x999999c8},	/* 1.3734=f(0.25, 0.05)*/
{39, 0,123,__LINE__, 0x3ff30b6d, 0x7809332d, 0x3fd00000, 0x00000006, 0x3fb99999, 0x999999b1},	/* 1.19029=f(0.25, 0.1)*/
{37, 0,123,__LINE__, 0x3ff07c6c, 0x6492f1f4, 0x3fd00000, 0x00000006, 0x3fc33333, 0x3333333f},	/* 1.03038=f(0.25, 0.15)*/
{38, 0,123,__LINE__, 0x3fecac7c, 0x539d6960, 0x3fd00000, 0x00000006, 0x3fc99999, 0x999999a6},	/* 0.896055=f(0.25, 0.2)*/
{64, 0,123,__LINE__, 0x3fe921fb, 0x54442d18, 0x3fd00000, 0x00000006, 0x3fd00000, 0x00000006},	/* 0.785398=f(0.25, 0.25)*/
{36, 0,123,__LINE__, 0x3fe63b4b, 0xb97383bd, 0x3fd00000, 0x00000006, 0x3fd33333, 0x33333339},	/* 0.694738=f(0.25, 0.3)*/
{37, 0,123,__LINE__, 0x3fe3d915, 0x77880d4d, 0x3fd00000, 0x00000006, 0x3fd66666, 0x6666666c},	/* 0.620249=f(0.25, 0.35)*/
{38, 0,123,__LINE__, 0x3fe1e00b, 0xa8468ba6, 0x3fd00000, 0x00000006, 0x3fd99999, 0x9999999f},	/* 0.558599=f(0.25, 0.4)*/
{37, 0,123,__LINE__, 0x3fe03a26, 0xaa908f42, 0x3fd00000, 0x00000006, 0x3fdccccc, 0xccccccd2},	/* 0.507099=f(0.25, 0.45)*/
{61, 0,123,__LINE__, 0x3fddac67, 0x0561bb4f, 0x3fd00000, 0x00000006, 0x3fe00000, 0x00000003},	/* 0.463648=f(0.25, 0.5)*/
{36, 0,123,__LINE__, 0x3fdb4ddd, 0x5ddf1912, 0x3fd00000, 0x00000006, 0x3fe19999, 0x9999999d},	/* 0.426627=f(0.25, 0.55)*/
{36, 0,123,__LINE__, 0x3fd94441, 0xe9d14767, 0x3fd00000, 0x00000006, 0x3fe33333, 0x33333337},	/* 0.394791=f(0.25, 0.6)*/
{36, 0,123,__LINE__, 0x3fd77fc6, 0xbb3eb35c, 0x3fd00000, 0x00000006, 0x3fe4cccc, 0xccccccd1},	/* 0.367174=f(0.25, 0.65)*/
{37, 0,123,__LINE__, 0x3fd5f41a, 0xb5413dc3, 0x3fd00000, 0x00000006, 0x3fe66666, 0x6666666b},	/* 0.343024=f(0.25, 0.7)*/
{62, 0,123,__LINE__, 0x3fd4978f, 0xa3269ee1, 0x3fd00000, 0x00000006, 0x3fe80000, 0x00000005},	/* 0.321751=f(0.25, 0.75)*/
{37, 0,123,__LINE__, 0x3fd36277, 0x3279ccd3, 0x3fd00000, 0x00000006, 0x3fe99999, 0x9999999f},	/* 0.302885=f(0.25, 0.8)*/
{36, 0,123,__LINE__, 0x3fd24eaa, 0xaca26fb4, 0x3fd00000, 0x00000006, 0x3feb3333, 0x33333339},	/* 0.286051=f(0.25, 0.85)*/
{37, 0,123,__LINE__, 0x3fd15731, 0x7c9feaaa, 0x3fd00000, 0x00000006, 0x3feccccc, 0xccccccd3},	/* 0.270947=f(0.25, 0.9)*/
{38, 0,123,__LINE__, 0x3fd077fd, 0xe663381e, 0x3fd00000, 0x00000006, 0x3fee6666, 0x6666666d},	/* 0.257324=f(0.25, 0.95)*/
{39, 0,123,__LINE__, 0x4006cd14, 0x06088f96, 0x3fd33333, 0x33333339, 0xbff00000, 0x00000000},	/* 2.85014=f(0.3, -1)*/
{38, 0,123,__LINE__, 0x4006af8a, 0xb316898c, 0x3fd33333, 0x33333339, 0xbfee6666, 0x66666666},	/* 2.83571=f(0.3, -0.95)*/
{38, 0,123,__LINE__, 0x40068f09, 0x5d34ae91, 0x3fd33333, 0x33333339, 0xbfeccccc, 0xcccccccc},	/* 2.81984=f(0.3, -0.9)*/
{41, 0,123,__LINE__, 0x40066b1c, 0x47ef4f4a, 0x3fd33333, 0x33333339, 0xbfeb3333, 0x33333332},	/* 2.8023=f(0.3, -0.85)*/
{39, 0,123,__LINE__, 0x40064338, 0x2aef04f4, 0x3fd33333, 0x33333339, 0xbfe99999, 0x99999998},	/* 2.78282=f(0.3, -0.8)*/
{39, 0,123,__LINE__, 0x400616b4, 0x65006f66, 0x3fd33333, 0x33333339, 0xbfe7ffff, 0xfffffffe},	/* 2.76109=f(0.3, -0.75)*/
{38, 0,123,__LINE__, 0x4005e4c3, 0x69dddc93, 0x3fd33333, 0x33333339, 0xbfe66666, 0x66666664},	/* 2.7367=f(0.3, -0.7)*/
{38, 0,123,__LINE__, 0x4005ac69, 0x1b28425b, 0x3fd33333, 0x33333339, 0xbfe4cccc, 0xccccccca},	/* 2.70918=f(0.3, -0.65)*/
{63, 0,123,__LINE__, 0x40056c6e, 0x7397f5ae, 0x3fd33333, 0x33333339, 0xbfe33333, 0x33333330},	/* 2.67795=f(0.3, -0.6)*/
{39, 0,123,__LINE__, 0x40052351, 0xd4c76fc9, 0x3fd33333, 0x33333339, 0xbfe19999, 0x99999996},	/* 2.64225=f(0.3, -0.55)*/
{38, 0,123,__LINE__, 0x4004cf33, 0xdc6b8f86, 0x3fd33333, 0x33333339, 0xbfdfffff, 0xfffffff9},	/* 2.60117=f(0.3, -0.5)*/
{37, 0,123,__LINE__, 0x40046dc0, 0x9aa8528e, 0x3fd33333, 0x33333339, 0xbfdccccc, 0xccccccc6},	/* 2.55359=f(0.3, -0.45)*/
{39, 0,123,__LINE__, 0x4003fc17, 0x69e0ebc7, 0x3fd33333, 0x33333339, 0xbfd99999, 0x99999993},	/* 2.49809=f(0.3, -0.4)*/
{38, 0,123,__LINE__, 0x400376b7, 0x104169dd, 0x3fd33333, 0x33333339, 0xbfd66666, 0x66666660},	/* 2.43297=f(0.3, -0.35)*/
{62, 0,123,__LINE__, 0x4002d97c, 0x7f3321d2, 0x3fd33333, 0x33333339, 0xbfd33333, 0x3333332d},	/* 2.35619=f(0.3, -0.3)*/
{38, 0,123,__LINE__, 0x40021fd0, 0x987ef77b, 0x3fd33333, 0x33333339, 0xbfcfffff, 0xfffffff4},	/* 2.26553=f(0.3, -0.25)*/
{39, 0,123,__LINE__, 0x40014538, 0x5e19d6d5, 0x3fd33333, 0x33333339, 0xbfc99999, 0x9999998e},	/* 2.1588=f(0.3, -0.2)*/
{62, 0,123,__LINE__, 0x4000468a, 0x8ace4df6, 0x3fd33333, 0x33333339, 0xbfc33333, 0x33333328},	/* 2.03444=f(0.3, -0.15)*/
{39, 0,123,__LINE__, 0x3ffe47df, 0x3b0dd4d2, 0x3fd33333, 0x33333339, 0xbfb99999, 0x99999983},	/* 1.89255=f(0.3, -0.1)*/
{39, 0,123,__LINE__, 0x3ffbc66e, 0x43b6feba, 0x3fd33333, 0x33333339, 0xbfa99999, 0x9999996c},	/* 1.73595=f(0.3, -0.05)*/
{64, 0,123,__LINE__, 0x3ff921fb, 0x54442d13, 0x3fd33333, 0x33333339, 0x3cb70000, 0x00000000},	/* 1.5708=f(0.3, 3.19189e-16)*/
{39, 0,123,__LINE__, 0x3ff67d88, 0x64d15b77, 0x3fd33333, 0x33333339, 0x3fa99999, 0x999999c8},	/* 1.40565=f(0.3, 0.05)*/
{38, 0,123,__LINE__, 0x3ff3fc17, 0x6d7a855f, 0x3fd33333, 0x33333339, 0x3fb99999, 0x999999b1},	/* 1.24905=f(0.3, 0.1)*/
{62, 0,123,__LINE__, 0x3ff1b6e1, 0x92ebbe44, 0x3fd33333, 0x33333339, 0x3fc33333, 0x3333333f},	/* 1.10715=f(0.3, 0.15)*/
{37, 0,123,__LINE__, 0x3fef730b, 0xd8a9590e, 0x3fd33333, 0x33333339, 0x3fc99999, 0x999999a6},	/* 0.982794=f(0.3, 0.2)*/
{36, 0,123,__LINE__, 0x3fec08aa, 0xef14d674, 0x3fd33333, 0x33333339, 0x3fd00000, 0x00000006},	/* 0.876058=f(0.3, 0.25)*/
{64, 0,123,__LINE__, 0x3fe921fb, 0x54442d18, 0x3fd33333, 0x33333339, 0x3fd33333, 0x33333339},	/* 0.785398=f(0.3, 0.3)*/
{36, 0,123,__LINE__, 0x3fe6ad11, 0x100b0cec, 0x3fd33333, 0x33333339, 0x3fd66666, 0x6666666c},	/* 0.708626=f(0.3, 0.35)*/
{37, 0,123,__LINE__, 0x3fe4978f, 0xa98d0545, 0x3fd33333, 0x33333339, 0x3fd99999, 0x9999999f},	/* 0.643501=f(0.3, 0.4)*/
{35, 0,123,__LINE__, 0x3fe2d0ea, 0xe66f6a28, 0x3fd33333, 0x33333339, 0x3fdccccc, 0xccccccd2},	/* 0.588003=f(0.3, 0.45)*/
{36, 0,123,__LINE__, 0x3fe14b1d, 0xdf627649, 0x3fd33333, 0x33333339, 0x3fe00000, 0x00000003},	/* 0.54042=f(0.3, 0.5)*/
{36, 0,123,__LINE__, 0x3fdff54b, 0xfbe5ea7d, 0x3fd33333, 0x33333339, 0x3fe19999, 0x9999999d},	/* 0.499347=f(0.3, 0.55)*/
{61, 0,123,__LINE__, 0x3fddac67, 0x0561bb4f, 0x3fd33333, 0x33333339, 0x3fe33333, 0x33333337},	/* 0.463648=f(0.3, 0.6)*/
{35, 0,123,__LINE__, 0x3fdbac91, 0xc8df55ed, 0x3fd33333, 0x33333339, 0x3fe4cccc, 0xccccccd1},	/* 0.432408=f(0.3, 0.65)*/
{35, 0,123,__LINE__, 0x3fd9e9bf, 0x5332842d, 0x3fd33333, 0x33333339, 0x3fe66666, 0x6666666b},	/* 0.404892=f(0.3, 0.7)*/
{36, 0,123,__LINE__, 0x3fd85a37, 0x7a1ded8f, 0x3fd33333, 0x33333339, 0x3fe80000, 0x00000005},	/* 0.380506=f(0.3, 0.75)*/
{36, 0,123,__LINE__, 0x3fd6f619, 0x4aa9411f, 0x3fd33333, 0x33333339, 0x3fe99999, 0x9999999f},	/* 0.358771=f(0.3, 0.8)*/
{38, 0,123,__LINE__, 0x3fd5b6f8, 0x62a6ee76, 0x3fd33333, 0x33333339, 0x3feb3333, 0x33333339},	/* 0.339293=f(0.3, 0.85)*/
{35, 0,123,__LINE__, 0x3fd4978f, 0xb87bf43e, 0x3fd33333, 0x33333339, 0x3feccccc, 0xccccccd3},	/* 0.321751=f(0.3, 0.9)*/
{35, 0,123,__LINE__, 0x3fd39385, 0x096d1c62, 0x3fd33333, 0x33333339, 0x3fee6666, 0x6666666d},	/* 0.305879=f(0.3, 0.95)*/
{40, 0,123,__LINE__, 0x40067078, 0xc3a56789, 0x3fd66666, 0x6666666c, 0xbff00000, 0x00000000},	/* 2.80492=f(0.35, -1)*/
{42, 0,123,__LINE__, 0x40064f0e, 0xb499f9d3, 0x3fd66666, 0x6666666c, 0xbfee6666, 0x66666666},	/* 2.7886=f(0.35, -0.95)*/
{41, 0,123,__LINE__, 0x40062a65, 0x79b7ca58, 0x3fd66666, 0x6666666c, 0xbfeccccc, 0xcccccccc},	/* 2.7707=f(0.35, -0.9)*/
{38, 0,123,__LINE__, 0x40060204, 0xc07359e3, 0x3fd66666, 0x6666666c, 0xbfeb3333, 0x33333332},	/* 2.75099=f(0.35, -0.85)*/
{39, 0,123,__LINE__, 0x4005d55d, 0x7d5d8b38, 0x3fd66666, 0x6666666c, 0xbfe99999, 0x99999998},	/* 2.72918=f(0.35, -0.8)*/
{40, 0,123,__LINE__, 0x4005a3c4, 0xf3c4da81, 0x3fd66666, 0x6666666c, 0xbfe7ffff, 0xfffffffe},	/* 2.70497=f(0.35, -0.75)*/
{63, 0,123,__LINE__, 0x40056c6e, 0x7397f5ae, 0x3fd66666, 0x6666666c, 0xbfe66666, 0x66666664},	/* 2.67795=f(0.35, -0.7)*/
{39, 0,123,__LINE__, 0x40052e63, 0xcadd21f9, 0x3fd66666, 0x6666666c, 0xbfe4cccc, 0xccccccca},	/* 2.64765=f(0.35, -0.65)*/
{38, 0,123,__LINE__, 0x4004e87c, 0x3ee65519, 0x3fd66666, 0x6666666c, 0xbfe33333, 0x33333330},	/* 2.61352=f(0.35, -0.6)*/
{38, 0,123,__LINE__, 0x40049952, 0x02a6eb88, 0x3fd66666, 0x6666666c, 0xbfe19999, 0x99999996},	/* 2.57486=f(0.35, -0.55)*/
{39, 0,123,__LINE__, 0x40043f37, 0x09f81e27, 0x3fd66666, 0x6666666c, 0xbfdfffff, 0xfffffff9},	/* 2.53087=f(0.35, -0.5)*/
{40, 0,123,__LINE__, 0x4003d82a, 0x536af975, 0x3fd66666, 0x6666666c, 0xbfdccccc, 0xccccccc6},	/* 2.48055=f(0.35, -0.45)*/
{38, 0,123,__LINE__, 0x400361d1, 0x6505d30c, 0x3fd66666, 0x6666666c, 0xbfd99999, 0x99999993},	/* 2.42276=f(0.35, -0.4)*/
{62, 0,123,__LINE__, 0x4002d97c, 0x7f3321d2, 0x3fd66666, 0x6666666c, 0xbfd66666, 0x66666660},	/* 2.35619=f(0.35, -0.35)*/
{38, 0,123,__LINE__, 0x40023c41, 0xee24d9c7, 0x3fd66666, 0x6666666c, 0xbfd33333, 0x3333332d},	/* 2.27942=f(0.35, -0.3)*/
{39, 0,123,__LINE__, 0x40018743, 0x080419df, 0x3fd66666, 0x6666666c, 0xbfcfffff, 0xfffffff4},	/* 2.19105=f(0.35, -0.25)*/
{39, 0,123,__LINE__, 0x4000b833, 0xbfeefa53, 0x3fd66666, 0x6666666c, 0xbfc99999, 0x9999998e},	/* 2.08994=f(0.35, -0.2)*/
{37, 0,123,__LINE__, 0x3fff9c6b, 0x2910ce24, 0x3fd66666, 0x6666666c, 0xbfc33333, 0x33333328},	/* 1.97569=f(0.35, -0.15)*/
{38, 0,123,__LINE__, 0x3ffd95e5, 0xae666ff2, 0x3fd66666, 0x6666666c, 0xbfb99999, 0x99999983},	/* 1.8491=f(0.35, -0.1)*/
{39, 0,123,__LINE__, 0x3ffb6731, 0x2e062767, 0x3fd66666, 0x6666666c, 0xbfa99999, 0x9999996c},	/* 1.71269=f(0.35, -0.05)*/
{64, 0,123,__LINE__, 0x3ff921fb, 0x54442d14, 0x3fd66666, 0x6666666c, 0x3cb70000, 0x00000000},	/* 1.5708=f(0.35, 3.19189e-16)*/
{39, 0,123,__LINE__, 0x3ff6dcc5, 0x7a8232c9, 0x3fd66666, 0x6666666c, 0x3fa99999, 0x999999c8},	/* 1.4289=f(0.35, 0.05)*/
{38, 0,123,__LINE__, 0x3ff4ae10, 0xfa21ea3f, 0x3fd66666, 0x6666666c, 0x3fb99999, 0x999999b1},	/* 1.2925=f(0.35, 0.1)*/
{37, 0,123,__LINE__, 0x3ff2a78b, 0x7f778c0d, 0x3fd66666, 0x6666666c, 0x3fc33333, 0x3333333f},	/* 1.1659=f(0.35, 0.15)*/
{38, 0,123,__LINE__, 0x3ff0d38f, 0x28aa658a, 0x3fd66666, 0x6666666c, 0x3fc99999, 0x999999a6},	/* 1.05165=f(0.35, 0.2)*/
{37, 0,123,__LINE__, 0x3fee6ae1, 0x31004ce4, 0x3fd66666, 0x6666666c, 0x3fd00000, 0x00000006},	/* 0.950547=f(0.35, 0.25)*/
{36, 0,123,__LINE__, 0x3feb96e5, 0x987d4d44, 0x3fd66666, 0x6666666c, 0x3fd33333, 0x33333339},	/* 0.86217=f(0.35, 0.3)*/
{64, 0,123,__LINE__, 0x3fe921fb, 0x54442d18, 0x3fd66666, 0x6666666c, 0x3fd66666, 0x6666666c},	/* 0.785398=f(0.35, 0.35)*/
{36, 0,123,__LINE__, 0x3fe700a7, 0xbcf9682f, 0x3fd66666, 0x6666666c, 0x3fd99999, 0x9999999f},	/* 0.71883=f(0.35, 0.4)*/
{38, 0,123,__LINE__, 0x3fe52744, 0x0364ce8e, 0x3fd66666, 0x6666666c, 0x3fdccccc, 0xccccccd2},	/* 0.661043=f(0.35, 0.45)*/
{37, 0,123,__LINE__, 0x3fe38b11, 0x29303bc3, 0x3fd66666, 0x6666666c, 0x3fe00000, 0x00000003},	/* 0.610726=f(0.35, 0.5)*/
{36, 0,123,__LINE__, 0x3fe222a5, 0x46750640, 0x3fd66666, 0x6666666c, 0x3fe19999, 0x9999999d},	/* 0.566729=f(0.35, 0.55)*/
{36, 0,123,__LINE__, 0x3fe0e5fc, 0x55775ffb, 0x3fd66666, 0x6666666c, 0x3fe33333, 0x33333337},	/* 0.528074=f(0.35, 0.6)*/
{36, 0,123,__LINE__, 0x3fdf9cbc, 0x4b3858fc, 0x3fd66666, 0x6666666c, 0x3fe4cccc, 0xccccccd1},	/* 0.493941=f(0.35, 0.65)*/
{62, 0,123,__LINE__, 0x3fddac67, 0x0561bb4f, 0x3fd66666, 0x6666666c, 0x3fe66666, 0x6666666b},	/* 0.463648=f(0.35, 0.7)*/
{37, 0,123,__LINE__, 0x3fdbf1b3, 0x03fa94bd, 0x3fd66666, 0x6666666c, 0x3fe80000, 0x00000005},	/* 0.436627=f(0.35, 0.75)*/
{36, 0,123,__LINE__, 0x3fda64ee, 0xb7350f03, 0x3fd66666, 0x6666666c, 0x3fe99999, 0x9999999f},	/* 0.41241=f(0.35, 0.8)*/
{35, 0,123,__LINE__, 0x3fd8ffb4, 0x9e8699a9, 0x3fd66666, 0x6666666c, 0x3feb3333, 0x33333339},	/* 0.390607=f(0.35, 0.85)*/
{38, 0,123,__LINE__, 0x3fd7bcae, 0xd46315ff, 0x3fd66666, 0x6666666c, 0x3feccccc, 0xccccccd3},	/* 0.370891=f(0.35, 0.9)*/
{39, 0,123,__LINE__, 0x3fd69764, 0xfd519a2a, 0x3fd66666, 0x6666666c, 0x3fee6666, 0x6666666d},	/* 0.35299=f(0.35, 0.95)*/
{40, 0,123,__LINE__, 0x400616b4, 0x6626b023, 0x3fd99999, 0x9999999f, 0xbff00000, 0x00000000},	/* 2.76109=f(0.4, -1)*/
{39, 0,123,__LINE__, 0x4005f1ce, 0xc9bbfc1c, 0x3fd99999, 0x9999999f, 0xbfee6666, 0x66666666},	/* 2.74307=f(0.4, -0.95)*/
{38, 0,123,__LINE__, 0x4005c975, 0x52e4ddd8, 0x3fd99999, 0x9999999f, 0xbfeccccc, 0xcccccccc},	/* 2.72337=f(0.4, -0.9)*/
{40, 0,123,__LINE__, 0x40059d2f, 0x24cd92b5, 0x3fd99999, 0x9999999f, 0xbfeb3333, 0x33333332},	/* 2.70175=f(0.4, -0.85)*/
{64, 0,123,__LINE__, 0x40056c6e, 0x7397f5ae, 0x3fd99999, 0x9999999f, 0xbfe99999, 0x99999998},	/* 2.67795=f(0.4, -0.8)*/
{40, 0,123,__LINE__, 0x4005368c, 0x944a04a1, 0x3fd99999, 0x9999999f, 0xbfe7ffff, 0xfffffffe},	/* 2.65164=f(0.4, -0.75)*/
{39, 0,123,__LINE__, 0x4004fac5, 0x3e774951, 0x3fd99999, 0x9999999f, 0xbfe66666, 0x66666664},	/* 2.62245=f(0.4, -0.7)*/
{38, 0,123,__LINE__, 0x4004b831, 0x3ac804c9, 0x3fd99999, 0x9999999f, 0xbfe4cccc, 0xccccccca},	/* 2.58994=f(0.4, -0.65)*/
{39, 0,123,__LINE__, 0x40046dc0, 0xa04c6cd0, 0x3fd99999, 0x9999999f, 0xbfe33333, 0x33333330},	/* 2.55359=f(0.4, -0.6)*/
{41, 0,123,__LINE__, 0x40041a34, 0xfbc2dfe5, 0x3fd99999, 0x9999999f, 0xbfe19999, 0x99999996},	/* 2.5128=f(0.4, -0.55)*/
{40, 0,123,__LINE__, 0x4003bc1c, 0xbf0970e4, 0x3fd99999, 0x9999999f, 0xbfdfffff, 0xfffffff9},	/* 2.46685=f(0.4, -0.5)*/
{38, 0,123,__LINE__, 0x400351d1, 0x757908b6, 0x3fd99999, 0x9999999f, 0xbfdccccc, 0xccccccc6},	/* 2.41495=f(0.4, -0.45)*/
{62, 0,123,__LINE__, 0x4002d97c, 0x7f3321d2, 0x3fd99999, 0x9999999f, 0xbfd99999, 0x99999993},	/* 2.35619=f(0.4, -0.4)*/
{38, 0,123,__LINE__, 0x40025127, 0x99607098, 0x3fd99999, 0x9999999f, 0xbfd66666, 0x66666660},	/* 2.28963=f(0.4, -0.35)*/
{39, 0,123,__LINE__, 0x4001b6e1, 0x948557dd, 0x3fd99999, 0x9999999f, 0xbfd33333, 0x3333332d},	/* 2.2143=f(0.4, -0.3)*/
{40, 0,123,__LINE__, 0x40010900, 0x9433b976, 0x3fd99999, 0x9999999f, 0xbfcfffff, 0xfffffff4},	/* 2.1294=f(0.4, -0.25)*/
{62, 0,123,__LINE__, 0x4000468a, 0x8ace4df6, 0x3fd99999, 0x9999999f, 0xbfc99999, 0x9999998e},	/* 2.03444=f(0.4, -0.2)*/
{38, 0,123,__LINE__, 0x3ffedf81, 0xa6ee7d60, 0x3fd99999, 0x9999999f, 0xbfc33333, 0x33333328},	/* 1.92957=f(0.4, -0.15)*/
{61, 0,123,__LINE__, 0x3ffd0d6a, 0x1369bd34, 0x3fd99999, 0x9999999f, 0xbfb99999, 0x99999983},	/* 1.81577=f(0.4, -0.1)*/
{62, 0,123,__LINE__, 0x3ffb1f56, 0xfdeef00f, 0x3fd99999, 0x9999999f, 0xbfa99999, 0x9999996c},	/* 1.69515=f(0.4, -0.05)*/
{64, 0,123,__LINE__, 0x3ff921fb, 0x54442d15, 0x3fd99999, 0x9999999f, 0x3cb70000, 0x00000000},	/* 1.5708=f(0.4, 3.19189e-16)*/
{62, 0,123,__LINE__, 0x3ff7249f, 0xaa996a21, 0x3fd99999, 0x9999999f, 0x3fa99999, 0x999999c8},	/* 1.44644=f(0.4, 0.05)*/
{62, 0,123,__LINE__, 0x3ff5368c, 0x951e9cfd, 0x3fd99999, 0x9999999f, 0x3fb99999, 0x999999b1},	/* 1.32582=f(0.4, 0.1)*/
{38, 0,123,__LINE__, 0x3ff36475, 0x0199dcd1, 0x3fd99999, 0x9999999f, 0x3fc33333, 0x3333333f},	/* 1.21203=f(0.4, 0.15)*/
{63, 0,123,__LINE__, 0x3ff1b6e1, 0x92ebbe44, 0x3fd99999, 0x9999999f, 0x3fc99999, 0x999999a6},	/* 1.10715=f(0.4, 0.2)*/
{39, 0,123,__LINE__, 0x3ff031f5, 0x8020e745, 0x3fd99999, 0x9999999f, 0x3fd00000, 0x00000006},	/* 1.0122=f(0.4, 0.25)*/
{37, 0,123,__LINE__, 0x3fedac66, 0xfefb54ec, 0x3fd99999, 0x9999999f, 0x3fd33333, 0x33333339},	/* 0.927295=f(0.4, 0.3)*/
{36, 0,123,__LINE__, 0x3feb434e, 0xeb8ef201, 0x3fd99999, 0x9999999f, 0x3fd66666, 0x6666666c},	/* 0.851966=f(0.4, 0.35)*/
{64, 0,123,__LINE__, 0x3fe921fb, 0x54442d18, 0x3fd99999, 0x9999999f, 0x3fd99999, 0x9999999f},	/* 0.785398=f(0.4, 0.4)*/
{36, 0,123,__LINE__, 0x3fe740a7, 0x7b2c9187, 0x3fd99999, 0x9999999f, 0x3fdccccc, 0xccccccd2},	/* 0.726642=f(0.4, 0.45)*/
{38, 0,123,__LINE__, 0x3fe5977a, 0x54eaf0d0, 0x3fd99999, 0x9999999f, 0x3fe00000, 0x00000003},	/* 0.674741=f(0.4, 0.5)*/
{39, 0,123,__LINE__, 0x3fe41f19, 0x620534ce, 0x3fd99999, 0x9999999f, 0x3fe19999, 0x9999999d},	/* 0.628796=f(0.4, 0.55)*/
{37, 0,123,__LINE__, 0x3fe2d0ea, 0xcfdf0123, 0x3fd99999, 0x9999999f, 0x3fe33333, 0x33333337},	/* 0.588003=f(0.4, 0.6)*/
{36, 0,123,__LINE__, 0x3fe1a728, 0x65f0a13e, 0x3fd99999, 0x9999999f, 0x3fe4cccc, 0xccccccd1},	/* 0.551655=f(0.4, 0.65)*/
{37, 0,123,__LINE__, 0x3fe09cd8, 0x57338f1c, 0x3fd99999, 0x9999999f, 0x3fe66666, 0x6666666b},	/* 0.519146=f(0.4, 0.7)*/
{37, 0,123,__LINE__, 0x3fdf5b75, 0xffd143be, 0x3fd99999, 0x9999999f, 0x3fe80000, 0x00000005},	/* 0.489957=f(0.4, 0.75)*/
{64, 0,123,__LINE__, 0x3fddac67, 0x0561bb4f, 0x3fd99999, 0x9999999f, 0x3fe99999, 0x9999999f},	/* 0.463648=f(0.4, 0.8)*/
{37, 0,123,__LINE__, 0x3fdc2661, 0x7bb4d31c, 0x3fd99999, 0x9999999f, 0x3feb3333, 0x33333339},	/* 0.439843=f(0.4, 0.85)*/
{35, 0,123,__LINE__, 0x3fdac430, 0x0afa7a04, 0x3fd99999, 0x9999999f, 0x3feccccc, 0xccccccd3},	/* 0.418224=f(0.4, 0.9)*/
{36, 0,123,__LINE__, 0x3fd98164, 0x544187e0, 0x3fd99999, 0x9999999f, 0x3fee6666, 0x6666666d},	/* 0.398522=f(0.4, 0.95)*/
{39, 0,123,__LINE__, 0x4005bffa, 0x185afd8c, 0x3fdccccc, 0xccccccd2, 0xbff00000, 0x00000000},	/* 2.71874=f(0.45, -1)*/
{40, 0,123,__LINE__, 0x400597ff, 0xd5db498b, 0x3fdccccc, 0xccccccd2, 0xbfee6666, 0x66666666},	/* 2.69922=f(0.45, -0.95)*/
{64, 0,123,__LINE__, 0x40056c6e, 0x7397f5ae, 0x3fdccccc, 0xccccccd2, 0xbfeccccc, 0xcccccccc},	/* 2.67795=f(0.45, -0.9)*/
{38, 0,123,__LINE__, 0x40053ccf, 0xeaa27acc, 0x3fdccccc, 0xccccccd2, 0xbfeb3333, 0x33333332},	/* 2.65469=f(0.45, -0.85)*/
{38, 0,123,__LINE__, 0x4005089b, 0xb16d17f7, 0x3fdccccc, 0xccccccd2, 0xbfe99999, 0x99999998},	/* 2.6292=f(0.45, -0.8)*/
{39, 0,123,__LINE__, 0x4004cf33, 0xe0577b72, 0x3fdccccc, 0xccccccd2, 0xbfe7ffff, 0xfffffffe},	/* 2.60117=f(0.45, -0.75)*/
{40, 0,123,__LINE__, 0x40048fe1, 0xf261215b, 0x3fdccccc, 0xccccccd2, 0xbfe66666, 0x66666664},	/* 2.57026=f(0.45, -0.7)*/
{40, 0,123,__LINE__, 0x400449d3, 0x86acbb16, 0x3fdccccc, 0xccccccd2, 0xbfe4cccc, 0xccccccca},	/* 2.53605=f(0.45, -0.65)*/
{37, 0,123,__LINE__, 0x4003fc17, 0x6fbec9a3, 0x3fdccccc, 0xccccccd2, 0xbfe33333, 0x33333330},	/* 2.49809=f(0.45, -0.6)*/
{38, 0,123,__LINE__, 0x4003a59b, 0x96754f04, 0x3fdccccc, 0xccccccd2, 0xbfe19999, 0x99999996},	/* 2.45586=f(0.45, -0.55)*/
{39, 0,123,__LINE__, 0x4003452d, 0x2c0744e9, 0x3fdccccc, 0xccccccd2, 0xbfdfffff, 0xfffffff9},	/* 2.40878=f(0.45, -0.5)*/
{62, 0,123,__LINE__, 0x4002d97c, 0x7f3321d2, 0x3fdccccc, 0xccccccd2, 0xbfdccccc, 0xccccccc6},	/* 2.35619=f(0.45, -0.45)*/
{38, 0,123,__LINE__, 0x40026127, 0x88ed3aee, 0x3fdccccc, 0xccccccd2, 0xbfd99999, 0x99999993},	/* 2.29744=f(0.45, -0.4)*/
{40, 0,123,__LINE__, 0x4001dace, 0xaafb4a30, 0x3fdccccc, 0xccccccd2, 0xbfd66666, 0x66666660},	/* 2.23184=f(0.45, -0.35)*/
{37, 0,123,__LINE__, 0x40014538, 0x63bdf116, 0x3fdccccc, 0xccccccd2, 0xbfd33333, 0x3333332d},	/* 2.1588=f(0.45, -0.3)*/
{39, 0,123,__LINE__, 0x40009f87, 0x54c63a5d, 0x3fdccccc, 0xccccccd2, 0xbfcfffff, 0xfffffff4},	/* 2.07789=f(0.45, -0.25)*/
{37, 0,123,__LINE__, 0x3fffd307, 0x5702cb99, 0x3fdccccc, 0xccccccd2, 0xbfc99999, 0x9999998e},	/* 1.98902=f(0.45, -0.2)*/
{37, 0,123,__LINE__, 0x3ffe47df, 0x42632a28, 0x3fdccccc, 0xccccccd2, 0xbfc33333, 0x33333328},	/* 1.89255=f(0.45, -0.15)*/
{38, 0,123,__LINE__, 0x3ffca1a6, 0x58d1662c, 0x3fdccccc, 0xccccccd2, 0xbfb99999, 0x99999983},	/* 1.78947=f(0.45, -0.1)*/
{39, 0,123,__LINE__, 0x3ffae73b, 0xd71c804f, 0x3fdccccc, 0xccccccd2, 0xbfa99999, 0x9999996c},	/* 1.68145=f(0.45, -0.05)*/
{64, 0,123,__LINE__, 0x3ff921fb, 0x54442d15, 0x3fdccccc, 0xccccccd2, 0x3cb70000, 0x00000000},	/* 1.5708=f(0.45, 3.19189e-16)*/
{39, 0,123,__LINE__, 0x3ff75cba, 0xd16bd9e1, 0x3fdccccc, 0xccccccd2, 0x3fa99999, 0x999999c8},	/* 1.46014=f(0.45, 0.05)*/
{38, 0,123,__LINE__, 0x3ff5a250, 0x4fb6f405, 0x3fdccccc, 0xccccccd2, 0x3fb99999, 0x999999b1},	/* 1.35213=f(0.45, 0.1)*/
{37, 0,123,__LINE__, 0x3ff3fc17, 0x66253009, 0x3fdccccc, 0xccccccd2, 0x3fc33333, 0x3333333f},	/* 1.24905=f(0.45, 0.15)*/
{37, 0,123,__LINE__, 0x3ff270ef, 0x51858e97, 0x3fdccccc, 0xccccccd2, 0x3fc99999, 0x999999a6},	/* 1.15257=f(0.45, 0.2)*/
{38, 0,123,__LINE__, 0x3ff104e7, 0xfefbe577, 0x3fdccccc, 0xccccccd2, 0x3fd00000, 0x00000006},	/* 1.0637=f(0.45, 0.25)*/
{35, 0,123,__LINE__, 0x3fef730b, 0xc218f009, 0x3fdccccc, 0xccccccd2, 0x3fd33333, 0x33333339},	/* 0.982794=f(0.45, 0.3)*/
{38, 0,123,__LINE__, 0x3fed1cb2, 0xa5238ba3, 0x3fdccccc, 0xccccccd2, 0x3fd66666, 0x6666666c},	/* 0.909753=f(0.45, 0.35)*/
{36, 0,123,__LINE__, 0x3feb034f, 0x2d5bc8a9, 0x3fdccccc, 0xccccccd2, 0x3fd99999, 0x9999999f},	/* 0.844154=f(0.45, 0.4)*/
{64, 0,123,__LINE__, 0x3fe921fb, 0x54442d18, 0x3fdccccc, 0xccccccd2, 0x3fdccccc, 0xccccccd2},	/* 0.785398=f(0.45, 0.45)*/
{37, 0,123,__LINE__, 0x3fe77338, 0xa0f3a0bc, 0x3fdccccc, 0xccccccd2, 0x3fe00000, 0x00000003},	/* 0.732815=f(0.45, 0.5)*/
{36, 0,123,__LINE__, 0x3fe5f17e, 0xf73b7850, 0x3fdccccc, 0xccccccd2, 0x3fe19999, 0x9999999d},	/* 0.685729=f(0.45, 0.55)*/
{35, 0,123,__LINE__, 0x3fe4978f, 0x92158dd5, 0x3fdccccc, 0xccccccd2, 0x3fe33333, 0x33333337},	/* 0.643501=f(0.45, 0.6)*/
{38, 0,123,__LINE__, 0x3fe3609f, 0x365dc809, 0x3fdccccc, 0xccccccd2, 0x3fe4cccc, 0xccccccd1},	/* 0.605545=f(0.45, 0.65)*/
{38, 0,123,__LINE__, 0x3fe24865, 0x878c2ef4, 0x3fdccccc, 0xccccccd2, 0x3fe66666, 0x6666666b},	/* 0.571337=f(0.45, 0.7)*/
{37, 0,123,__LINE__, 0x3fe14b1d, 0xcfb2c69a, 0x3fdccccc, 0xccccccd2, 0x3fe80000, 0x00000005},	/* 0.540419=f(0.45, 0.75)*/
{36, 0,123,__LINE__, 0x3fe0657e, 0x8b5c5485, 0x3fdccccc, 0xccccccd2, 0x3fe99999, 0x9999999f},	/* 0.512389=f(0.45, 0.8)*/
{35, 0,123,__LINE__, 0x3fdf295b, 0x4d0d9264, 0x3fdccccc, 0xccccccd2, 0x3feb3333, 0x33333339},	/* 0.486899=f(0.45, 0.85)*/
{64, 0,123,__LINE__, 0x3fddac67, 0x0561bb4f, 0x3fdccccc, 0xccccccd2, 0x3feccccc, 0xccccccd3},	/* 0.463648=f(0.45, 0.9)*/
{37, 0,123,__LINE__, 0x3fdc4fdb, 0xf3471c6d, 0x3fdccccc, 0xccccccd2, 0x3fee6666, 0x6666666d},	/* 0.442374=f(0.45, 0.95)*/
{64, 0,123,__LINE__, 0x40056c6e, 0x7397f5ae, 0x3fe00000, 0x00000003, 0xbff00000, 0x00000000},	/* 2.67795=f(0.5, -1)*/
{40, 0,123,__LINE__, 0x400541c5, 0x5cabb163, 0x3fe00000, 0x00000003, 0xbfee6666, 0x66666666},	/* 2.65711=f(0.5, -0.95)*/
{39, 0,123,__LINE__, 0x40051371, 0xa9a00948, 0x3fe00000, 0x00000003, 0xbfeccccc, 0xcccccccc},	/* 2.63449=f(0.5, -0.9)*/
{39, 0,123,__LINE__, 0x4004e102, 0xc9ae6095, 0x3fe00000, 0x00000003, 0xbfeb3333, 0x33333332},	/* 2.60987=f(0.5, -0.85)*/
{40, 0,123,__LINE__, 0x4004a9f8, 0x6a328a2f, 0x3fe00000, 0x00000003, 0xbfe99999, 0x99999998},	/* 2.58299=f(0.5, -0.8)*/
{63, 0,123,__LINE__, 0x40046dc0, 0x9ec29433, 0x3fe00000, 0x00000003, 0xbfe7ffff, 0xfffffffe},	/* 2.55359=f(0.5, -0.75)*/
{39, 0,123,__LINE__, 0x40042bb5, 0xf66229c5, 0x3fe00000, 0x00000003, 0xbfe66666, 0x66666664},	/* 2.52134=f(0.5, -0.7)*/
{38, 0,123,__LINE__, 0x4003e31d, 0xf8ac6787, 0x3fe00000, 0x00000003, 0xbfe4cccc, 0xccccccca},	/* 2.4859=f(0.5, -0.65)*/
{38, 0,123,__LINE__, 0x40039328, 0x65e74c29, 0x3fe00000, 0x00000003, 0xbfe33333, 0x33333330},	/* 2.44685=f(0.5, -0.6)*/
{39, 0,123,__LINE__, 0x40033aef, 0xc0a92540, 0x3fe00000, 0x00000003, 0xbfe19999, 0x99999996},	/* 2.40378=f(0.5, -0.55)*/
{62, 0,123,__LINE__, 0x4002d97c, 0x7f3321d2, 0x3fe00000, 0x00000003, 0xbfdfffff, 0xfffffff9},	/* 2.35619=f(0.5, -0.5)*/
{39, 0,123,__LINE__, 0x40026dcb, 0xd25efebb, 0x3fe00000, 0x00000003, 0xbfdccccc, 0xccccccc6},	/* 2.30361=f(0.5, -0.45)*/
{40, 0,123,__LINE__, 0x4001f6dc, 0x3f5cd2c0, 0x3fe00000, 0x00000003, 0xbfd99999, 0x99999993},	/* 2.24554=f(0.5, -0.4)*/
{39, 0,123,__LINE__, 0x400173c1, 0xf46e257d, 0x3fe00000, 0x00000003, 0xbfd66666, 0x66666660},	/* 2.18152=f(0.5, -0.35)*/
{38, 0,123,__LINE__, 0x4000e3c5, 0x21fab41e, 0x3fe00000, 0x00000003, 0xbfd33333, 0x3333332d},	/* 2.11122=f(0.5, -0.3)*/
{62, 0,123,__LINE__, 0x4000468a, 0x8ace4df6, 0x3fe00000, 0x00000003, 0xbfcfffff, 0xfffffff4},	/* 2.03444=f(0.5, -0.25)*/
{39, 0,123,__LINE__, 0x3fff3889, 0x307f2704, 0x3fe00000, 0x00000003, 0xbfc99999, 0x9999998e},	/* 1.9513=f(0.5, -0.2)*/
{38, 0,123,__LINE__, 0x3ffdcbc9, 0xf0bb681e, 0x3fe00000, 0x00000003, 0xbfc33333, 0x33333328},	/* 1.86225=f(0.5, -0.15)*/
{40, 0,123,__LINE__, 0x3ffc4a83, 0x9427fe28, 0x3fe00000, 0x00000003, 0xbfb99999, 0x99999983},	/* 1.76819=f(0.5, -0.1)*/
{41, 0,123,__LINE__, 0x3ffaba39, 0x7cd7bcb7, 0x3fe00000, 0x00000003, 0xbfa99999, 0x9999996c},	/* 1.67046=f(0.5, -0.05)*/
{64, 0,123,__LINE__, 0x3ff921fb, 0x54442d15, 0x3fe00000, 0x00000003, 0x3cb70000, 0x00000000},	/* 1.5708=f(0.5, 3.19189e-16)*/
{41, 0,123,__LINE__, 0x3ff789bd, 0x2bb09d7a, 0x3fe00000, 0x00000003, 0x3fa99999, 0x999999c8},	/* 1.47113=f(0.5, 0.05)*/
{40, 0,123,__LINE__, 0x3ff5f973, 0x14605c08, 0x3fe00000, 0x00000003, 0x3fb99999, 0x999999b1},	/* 1.3734=f(0.5, 0.1)*/
{38, 0,123,__LINE__, 0x3ff4782c, 0xb7ccf213, 0x3fe00000, 0x00000003, 0x3fc33333, 0x3333333f},	/* 1.27934=f(0.5, 0.15)*/
{39, 0,123,__LINE__, 0x3ff30b6d, 0x7809332d, 0x3fe00000, 0x00000003, 0x3fc99999, 0x999999a6},	/* 1.19029=f(0.5, 0.2)*/
{63, 0,123,__LINE__, 0x3ff1b6e1, 0x92ebbe44, 0x3fe00000, 0x00000003, 0x3fd00000, 0x00000006},	/* 1.10715=f(0.5, 0.25)*/
{37, 0,123,__LINE__, 0x3ff07c6c, 0x6492f1f4, 0x3fe00000, 0x00000003, 0x3fd33333, 0x33333339},	/* 1.03038=f(0.5, 0.3)*/
{37, 0,123,__LINE__, 0x3feeb8e5, 0x7f581e6d, 0x3fe00000, 0x00000003, 0x3fd66666, 0x6666666c},	/* 0.96007=f(0.5, 0.35)*/
{38, 0,123,__LINE__, 0x3fecac7c, 0x539d6960, 0x3fe00000, 0x00000003, 0x3fd99999, 0x9999999f},	/* 0.896055=f(0.5, 0.4)*/
{37, 0,123,__LINE__, 0x3fead0be, 0x0794b975, 0x3fe00000, 0x00000003, 0x3fdccccc, 0xccccccd2},	/* 0.837981=f(0.5, 0.45)*/
{64, 0,123,__LINE__, 0x3fe921fb, 0x54442d18, 0x3fe00000, 0x00000003, 0x3fe00000, 0x00000003},	/* 0.785398=f(0.5, 0.5)*/
{37, 0,123,__LINE__, 0x3fe79c2e, 0x4e6c1f5f, 0x3fe00000, 0x00000003, 0x3fe19999, 0x9999999d},	/* 0.737815=f(0.5, 0.55)*/
{36, 0,123,__LINE__, 0x3fe63b4b, 0xb97383bd, 0x3fe00000, 0x00000003, 0x3fe33333, 0x33333337},	/* 0.694738=f(0.5, 0.6)*/
{36, 0,123,__LINE__, 0x3fe4fb75, 0x6e5f1644, 0x3fe00000, 0x00000003, 0x3fe4cccc, 0xccccccd1},	/* 0.655696=f(0.5, 0.65)*/
{37, 0,123,__LINE__, 0x3fe3d915, 0x77880d4d, 0x3fe00000, 0x00000003, 0x3fe66666, 0x6666666b},	/* 0.620249=f(0.5, 0.7)*/
{64, 0,123,__LINE__, 0x3fe2d0ea, 0xd6066395, 0x3fe00000, 0x00000003, 0x3fe80000, 0x00000005},	/* 0.588003=f(0.5, 0.75)*/
{38, 0,123,__LINE__, 0x3fe1e00b, 0xa8468ba6, 0x3fe00000, 0x00000003, 0x3fe99999, 0x9999999f},	/* 0.558599=f(0.5, 0.8)*/
{37, 0,123,__LINE__, 0x3fe103e2, 0x2a57320f, 0x3fe00000, 0x00000003, 0x3feb3333, 0x33333339},	/* 0.531724=f(0.5, 0.85)*/
{37, 0,123,__LINE__, 0x3fe03a26, 0xaa908f42, 0x3fe00000, 0x00000003, 0x3feccccc, 0xccccccd3},	/* 0.507099=f(0.5, 0.9)*/
{37, 0,123,__LINE__, 0x3fdf01af, 0xbcc3ddad, 0x3fe00000, 0x00000003, 0x3fee6666, 0x6666666d},	/* 0.484478=f(0.5, 0.95)*/
{39, 0,123,__LINE__, 0x40051c28, 0xa9ba18ff, 0x3fe19999, 0x9999999d, 0xbff00000, 0x00000000},	/* 2.63875=f(0.55, -1)*/
{39, 0,123,__LINE__, 0x4004ef33, 0x3223c531, 0x3fe19999, 0x9999999d, 0xbfee6666, 0x66666666},	/* 2.6168=f(0.55, -0.95)*/
{38, 0,123,__LINE__, 0x4004be8d, 0x72e5b197, 0x3fe19999, 0x9999999d, 0xbfeccccc, 0xcccccccc},	/* 2.59304=f(0.55, -0.9)*/
{41, 0,123,__LINE__, 0x400489ce, 0x332bcc13, 0x3fe19999, 0x9999999d, 0xbfeb3333, 0x33333332},	/* 2.56729=f(0.55, -0.85)*/
{41, 0,123,__LINE__, 0x4004507f, 0x4ca3f97a, 0x3fe19999, 0x9999999d, 0xbfe99999, 0x99999998},	/* 2.53931=f(0.55, -0.8)*/
{39, 0,123,__LINE__, 0x4004121c, 0xb3d9b328, 0x3fe19999, 0x9999999d, 0xbfe7ffff, 0xfffffffe},	/* 2.50884=f(0.55, -0.75)*/
{38, 0,123,__LINE__, 0x4003ce13, 0xa3c8a2fd, 0x3fe19999, 0x9999999d, 0xbfe66666, 0x66666664},	/* 2.47562=f(0.55, -0.7)*/
{38, 0,123,__LINE__, 0x400383c2, 0x6e95b8f6, 0x3fe19999, 0x9999999d, 0xbfe4cccc, 0xccccccca},	/* 2.43934=f(0.55, -0.65)*/
{39, 0,123,__LINE__, 0x40033279, 0x48ddc5c4, 0x3fe19999, 0x9999999d, 0xbfe33333, 0x33333330},	/* 2.39965=f(0.55, -0.6)*/
{63, 0,123,__LINE__, 0x4002d97c, 0x7f3321d2, 0x3fe19999, 0x9999999d, 0xbfe19999, 0x99999996},	/* 2.35619=f(0.55, -0.55)*/
{39, 0,123,__LINE__, 0x40027809, 0x3dbd1e64, 0x3fe19999, 0x9999999d, 0xbfdfffff, 0xfffffff9},	/* 2.30861=f(0.55, -0.5)*/
{38, 0,123,__LINE__, 0x40020d5d, 0x67f0f4a0, 0x3fe19999, 0x9999999d, 0xbfdccccc, 0xccccccc6},	/* 2.25653=f(0.55, -0.45)*/
{41, 0,123,__LINE__, 0x400198c4, 0x02a363c0, 0x3fe19999, 0x9999999d, 0xbfd99999, 0x99999993},	/* 2.19959=f(0.55, -0.4)*/
{38, 0,123,__LINE__, 0x400119a6, 0xfbbf581c, 0x3fe19999, 0x9999999d, 0xbfd66666, 0x66666660},	/* 2.13753=f(0.55, -0.35)*/
{39, 0,123,__LINE__, 0x40008fa7, 0x299ed3dc, 0x3fe19999, 0x9999999d, 0xbfd33333, 0x3333332d},	/* 2.07014=f(0.55, -0.3)*/
{38, 0,123,__LINE__, 0x3ffff572, 0xabbbf35d, 0x3fe19999, 0x9999999d, 0xbfcfffff, 0xfffffff4},	/* 1.99742=f(0.55, -0.25)*/
{40, 0,123,__LINE__, 0x3ffeb68c, 0x3b11a9ab, 0x3fe19999, 0x9999999d, 0xbfc99999, 0x9999998e},	/* 1.91957=f(0.55, -0.2)*/
{39, 0,123,__LINE__, 0x3ffd648c, 0xd7b8cadb, 0x3fe19999, 0x9999999d, 0xbfc33333, 0x33333328},	/* 1.83705=f(0.55, -0.15)*/
{41, 0,123,__LINE__, 0x3ffc02a9, 0x642d2230, 0x3fe19999, 0x9999999d, 0xbfb99999, 0x99999983},	/* 1.75065=f(0.55, -0.1)*/
{42, 0,123,__LINE__, 0x3ffa9553, 0x1c4396c4, 0x3fe19999, 0x9999999d, 0xbfa99999, 0x9999996c},	/* 1.66146=f(0.55, -0.05)*/
{64, 0,123,__LINE__, 0x3ff921fb, 0x54442d16, 0x3fe19999, 0x9999999d, 0x3cb70000, 0x00000000},	/* 1.5708=f(0.55, 3.19189e-16)*/
{42, 0,123,__LINE__, 0x3ff7aea3, 0x8c44c36d, 0x3fe19999, 0x9999999d, 0x3fa99999, 0x999999c8},	/* 1.48014=f(0.55, 0.05)*/
{41, 0,123,__LINE__, 0x3ff6414d, 0x445b3801, 0x3fe19999, 0x9999999d, 0x3fb99999, 0x999999b1},	/* 1.39094=f(0.55, 0.1)*/
{39, 0,123,__LINE__, 0x3ff4df69, 0xd0cf8f55, 0x3fe19999, 0x9999999d, 0x3fc33333, 0x3333333f},	/* 1.30454=f(0.55, 0.15)*/
{40, 0,123,__LINE__, 0x3ff38d6a, 0x6d76b085, 0x3fe19999, 0x9999999d, 0x3fc99999, 0x999999a6},	/* 1.22203=f(0.55, 0.2)*/
{38, 0,123,__LINE__, 0x3ff24e83, 0xfccc66d4, 0x3fe19999, 0x9999999d, 0x3fd00000, 0x00000006},	/* 1.14417=f(0.55, 0.25)*/
{38, 0,123,__LINE__, 0x3ff124a8, 0x554ab279, 0x3fe19999, 0x9999999d, 0x3fd33333, 0x33333339},	/* 1.07145=f(0.55, 0.3)*/
{37, 0,123,__LINE__, 0x3ff010a8, 0xb109a9f8, 0x3fe19999, 0x9999999d, 0x3fd66666, 0x6666666c},	/* 1.00407=f(0.55, 0.35)*/
{39, 0,123,__LINE__, 0x3fee24dd, 0x46832562, 0x3fe19999, 0x9999999d, 0x3fd99999, 0x9999999f},	/* 0.942=f(0.55, 0.4)*/
{36, 0,123,__LINE__, 0x3fec5277, 0xb14ce1e1, 0x3fe19999, 0x9999999d, 0x3fdccccc, 0xccccccd2},	/* 0.885067=f(0.55, 0.45)*/
{37, 0,123,__LINE__, 0x3feaa7c8, 0x5a1c3ad1, 0x3fe19999, 0x9999999d, 0x3fe00000, 0x00000003},	/* 0.832981=f(0.55, 0.5)*/
{64, 0,123,__LINE__, 0x3fe921fb, 0x54442d18, 0x3fe19999, 0x9999999d, 0x3fe19999, 0x9999999d},	/* 0.785398=f(0.55, 0.55)*/
{37, 0,123,__LINE__, 0x3fe7be08, 0x2d999d53, 0x3fe19999, 0x9999999d, 0x3fe33333, 0x33333337},	/* 0.741947=f(0.55, 0.6)*/
{36, 0,123,__LINE__, 0x3fe678e3, 0x96b9d089, 0x3fe19999, 0x9999999d, 0x3fe4cccc, 0xccccccd1},	/* 0.702257=f(0.55, 0.65)*/
{36, 0,123,__LINE__, 0x3fe54f9e, 0xc1ee286f, 0x3fe19999, 0x9999999d, 0x3fe66666, 0x6666666b},	/* 0.665969=f(0.55, 0.7)*/
{37, 0,123,__LINE__, 0x3fe43f7a, 0x81a9e7c0, 0x3fe19999, 0x9999999d, 0x3fe80000, 0x00000005},	/* 0.632749=f(0.55, 0.75)*/
{39, 0,123,__LINE__, 0x3fe345f0, 0x1e80ce7a, 0x3fe19999, 0x9999999d, 0x3fe99999, 0x9999999f},	/* 0.602287=f(0.55, 0.8)*/
{39, 0,123,__LINE__, 0x3fe260b4, 0x84618415, 0x3fe19999, 0x9999999d, 0x3feb3333, 0x33333339},	/* 0.574305=f(0.55, 0.85)*/
{36, 0,123,__LINE__, 0x3fe18db7, 0x8579ee06, 0x3fe19999, 0x9999999d, 0x3feccccc, 0xccccccd3},	/* 0.548549=f(0.55, 0.9)*/
{37, 0,123,__LINE__, 0x3fe0cb20, 0x88819f9f, 0x3fe19999, 0x9999999d, 0x3fee6666, 0x6666666d},	/* 0.524796=f(0.55, 0.95)*/
{38, 0,123,__LINE__, 0x4004cf33, 0xdc6b8f86, 0x3fe33333, 0x33333337, 0xbff00000, 0x00000000},	/* 2.60117=f(0.6, -1)*/
{38, 0,123,__LINE__, 0x4004a04f, 0x5c55c87c, 0x3fe33333, 0x33333337, 0xbfee6666, 0x66666666},	/* 2.57828=f(0.6, -0.95)*/
{37, 0,123,__LINE__, 0x40046dc0, 0x9aa8528e, 0x3fe33333, 0x33333337, 0xbfeccccc, 0xcccccccc},	/* 2.55359=f(0.6, -0.9)*/
{40, 0,123,__LINE__, 0x40043726, 0xeaa26fb2, 0x3fe33333, 0x33333337, 0xbfeb3333, 0x33333332},	/* 2.52693=f(0.6, -0.85)*/
{39, 0,123,__LINE__, 0x4003fc17, 0x69e0ebc7, 0x3fe33333, 0x33333337, 0xbfe99999, 0x99999998},	/* 2.49809=f(0.6, -0.8)*/
{38, 0,123,__LINE__, 0x4003bc1c, 0xbd692e4b, 0x3fe33333, 0x33333337, 0xbfe7ffff, 0xfffffffe},	/* 2.46685=f(0.6, -0.75)*/
{38, 0,123,__LINE__, 0x400376b7, 0x104169dd, 0x3fe33333, 0x33333337, 0xbfe66666, 0x66666664},	/* 2.43297=f(0.6, -0.7)*/
{37, 0,123,__LINE__, 0x40032b5c, 0xd2a45bb9, 0x3fe33333, 0x33333337, 0xbfe4cccc, 0xccccccca},	/* 2.39617=f(0.6, -0.65)*/
{63, 0,123,__LINE__, 0x4002d97c, 0x7f3321d2, 0x3fe33333, 0x33333337, 0xbfe33333, 0x33333330},	/* 2.35619=f(0.6, -0.6)*/
{39, 0,123,__LINE__, 0x4002807f, 0xb5887de1, 0x3fe33333, 0x33333337, 0xbfe19999, 0x99999996},	/* 2.31274=f(0.6, -0.55)*/
{38, 0,123,__LINE__, 0x40021fd0, 0x987ef77b, 0x3fe33333, 0x33333337, 0xbfdfffff, 0xfffffff9},	/* 2.26553=f(0.6, -0.5)*/
{37, 0,123,__LINE__, 0x4001b6e1, 0x8ea77a01, 0x3fe33333, 0x33333337, 0xbfdccccc, 0xccccccc6},	/* 2.2143=f(0.6, -0.45)*/
{39, 0,123,__LINE__, 0x40014538, 0x5e19d6d5, 0x3fe33333, 0x33333337, 0xbfd99999, 0x99999993},	/* 2.1588=f(0.6, -0.4)*/
{38, 0,123,__LINE__, 0x4000ca7c, 0xbf7fee8b, 0x3fe33333, 0x33333337, 0xbfd66666, 0x66666660},	/* 2.09887=f(0.6, -0.35)*/
{62, 0,123,__LINE__, 0x4000468a, 0x8ace4df6, 0x3fe33333, 0x33333337, 0xbfd33333, 0x3333332d},	/* 2.03444=f(0.6, -0.3)*/
{38, 0,123,__LINE__, 0x3fff730b, 0xceb87ef2, 0x3fe33333, 0x33333337, 0xbfcfffff, 0xfffffff4},	/* 1.96559=f(0.6, -0.25)*/
{39, 0,123,__LINE__, 0x3ffe47df, 0x3b0dd4d2, 0x3fe33333, 0x33333337, 0xbfc99999, 0x9999998e},	/* 1.89255=f(0.6, -0.2)*/
{62, 0,123,__LINE__, 0x3ffd0d6a, 0x1369bd34, 0x3fe33333, 0x33333337, 0xbfc33333, 0x33333328},	/* 1.81577=f(0.6, -0.15)*/
{39, 0,123,__LINE__, 0x3ffbc66e, 0x43b6feba, 0x3fe33333, 0x33333337, 0xbfb99999, 0x99999983},	/* 1.73595=f(0.6, -0.1)*/
{40, 0,123,__LINE__, 0x3ffa7687, 0x3a357eb2, 0x3fe33333, 0x33333337, 0xbfa99999, 0x9999996c},	/* 1.65394=f(0.6, -0.05)*/
{64, 0,123,__LINE__, 0x3ff921fb, 0x54442d16, 0x3fe33333, 0x33333337, 0x3cb70000, 0x00000000},	/* 1.5708=f(0.6, 3.19189e-16)*/
{40, 0,123,__LINE__, 0x3ff7cd6f, 0x6e52db7f, 0x3fe33333, 0x33333337, 0x3fa99999, 0x999999c8},	/* 1.48766=f(0.6, 0.05)*/
{39, 0,123,__LINE__, 0x3ff67d88, 0x64d15b77, 0x3fe33333, 0x33333337, 0x3fb99999, 0x999999b1},	/* 1.40565=f(0.6, 0.1)*/
{62, 0,123,__LINE__, 0x3ff5368c, 0x951e9cfd, 0x3fe33333, 0x33333337, 0x3fc33333, 0x3333333f},	/* 1.32582=f(0.6, 0.15)*/
{38, 0,123,__LINE__, 0x3ff3fc17, 0x6d7a855f, 0x3fe33333, 0x33333337, 0x3fc99999, 0x999999a6},	/* 1.24905=f(0.6, 0.2)*/
{38, 0,123,__LINE__, 0x3ff2d0ea, 0xd9cfdb3e, 0x3fe33333, 0x33333337, 0x3fd00000, 0x00000006},	/* 1.17601=f(0.6, 0.25)*/
{64, 0,123,__LINE__, 0x3ff1b6e1, 0x92ebbe44, 0x3fe33333, 0x33333337, 0x3fd33333, 0x33333339},	/* 1.10715=f(0.6, 0.3)*/
{37, 0,123,__LINE__, 0x3ff0aefd, 0x29887d1b, 0x3fe33333, 0x33333337, 0x3fd66666, 0x6666666c},	/* 1.04272=f(0.6, 0.35)*/
{37, 0,123,__LINE__, 0x3fef730b, 0xd8a9590e, 0x3fe33333, 0x33333337, 0x3fd99999, 0x9999999f},	/* 0.982794=f(0.6, 0.4)*/
{35, 0,123,__LINE__, 0x3fedac67, 0x1672cc5c, 0x3fe33333, 0x33333337, 0x3fdccccc, 0xccccccd2},	/* 0.927295=f(0.6, 0.45)*/
{36, 0,123,__LINE__, 0x3fec08aa, 0xef14d674, 0x3fe33333, 0x33333337, 0x3fe00000, 0x00000003},	/* 0.876058=f(0.6, 0.5)*/
{37, 0,123,__LINE__, 0x3fea85ee, 0x7aeebcde, 0x3fe33333, 0x33333337, 0x3fe19999, 0x9999999d},	/* 0.828849=f(0.6, 0.55)*/
{64, 0,123,__LINE__, 0x3fe921fb, 0x54442d18, 0x3fe33333, 0x33333337, 0x3fe33333, 0x33333337},	/* 0.785398=f(0.6, 0.6)*/
{35, 0,123,__LINE__, 0x3fe7da7a, 0x067f457e, 0x3fe33333, 0x33333337, 0x3fe4cccc, 0xccccccd1},	/* 0.74542=f(0.6, 0.65)*/
{36, 0,123,__LINE__, 0x3fe6ad11, 0x100b0cec, 0x3fe33333, 0x33333337, 0x3fe66666, 0x6666666b},	/* 0.708626=f(0.6, 0.7)*/
{36, 0,123,__LINE__, 0x3fe5977a, 0x5b6bfb36, 0x3fe33333, 0x33333337, 0x3fe80000, 0x00000005},	/* 0.674741=f(0.6, 0.75)*/
{37, 0,123,__LINE__, 0x3fe4978f, 0xa98d0545, 0x3fe33333, 0x33333337, 0x3fe99999, 0x9999999f},	/* 0.643501=f(0.6, 0.8)*/
{38, 0,123,__LINE__, 0x3fe3ab51, 0xa686f59b, 0x3fe33333, 0x33333337, 0x3feb3333, 0x33333339},	/* 0.614663=f(0.6, 0.85)*/
{35, 0,123,__LINE__, 0x3fe2d0ea, 0xe66f6a28, 0x3fe33333, 0x33333337, 0x3feccccc, 0xccccccd3},	/* 0.588003=f(0.6, 0.9)*/
{36, 0,123,__LINE__, 0x3fe206af, 0xdfb99270, 0x3fe33333, 0x33333337, 0x3fee6666, 0x6666666d},	/* 0.563316=f(0.6, 0.95)*/
{38, 0,123,__LINE__, 0x40048590, 0xb9eec098, 0x3fe4cccc, 0xccccccd1, 0xbff00000, 0x00000000},	/* 2.56522=f(0.65, -1)*/
{39, 0,123,__LINE__, 0x40045514, 0x357271c6, 0x3fe4cccc, 0xccccccd1, 0xbfee6666, 0x66666666},	/* 2.54154=f(0.65, -0.95)*/
{40, 0,123,__LINE__, 0x400420fd, 0x07ea9fe7, 0x3fe4cccc, 0xccccccd1, 0xbfeccccc, 0xcccccccc},	/* 2.51611=f(0.65, -0.9)*/
{37, 0,123,__LINE__, 0x4003e8f3, 0xb0e64fa4, 0x3fe4cccc, 0xccccccd1, 0xbfeb3333, 0x33333332},	/* 2.48875=f(0.65, -0.85)*/
{38, 0,123,__LINE__, 0x4003ac98, 0xf5e1e9b6, 0x3fe4cccc, 0xccccccd1, 0xbfe99999, 0x99999998},	/* 2.45928=f(0.65, -0.8)*/
{38, 0,123,__LINE__, 0x40036b86, 0x278c98af, 0x3fe4cccc, 0xccccccd1, 0xbfe7ffff, 0xfffffffe},	/* 2.4275=f(0.65, -0.75)*/
{39, 0,123,__LINE__, 0x4003254d, 0xb45b9229, 0x3fe4cccc, 0xccccccd1, 0xbfe66666, 0x66666664},	/* 2.39321=f(0.65, -0.7)*/
{63, 0,123,__LINE__, 0x4002d97c, 0x7f3321d2, 0x3fe4cccc, 0xccccccd1, 0xbfe4cccc, 0xccccccca},	/* 2.35619=f(0.65, -0.65)*/
{37, 0,123,__LINE__, 0x4002879c, 0x2bc1e7ec, 0x3fe4cccc, 0xccccccd1, 0xbfe33333, 0x33333330},	/* 2.31622=f(0.65, -0.6)*/
{38, 0,123,__LINE__, 0x40022f36, 0x8fd08aae, 0x3fe4cccc, 0xccccccd1, 0xbfe19999, 0x99999996},	/* 2.27305=f(0.65, -0.55)*/
{38, 0,123,__LINE__, 0x4001cfdb, 0x05b9dc1d, 0x3fe4cccc, 0xccccccd1, 0xbfdfffff, 0xfffffff9},	/* 2.22649=f(0.65, -0.5)*/
{40, 0,123,__LINE__, 0x40016925, 0x77b9888e, 0x3fe4cccc, 0xccccccd1, 0xbfdccccc, 0xccccccc6},	/* 2.17634=f(0.65, -0.45)*/
{38, 0,123,__LINE__, 0x4000fac7, 0xc39e3edc, 0x3fe4cccc, 0xccccccd1, 0xbfd99999, 0x99999993},	/* 2.12245=f(0.65, -0.4)*/
{39, 0,123,__LINE__, 0x40008495, 0x338921ac, 0x3fe4cccc, 0xccccccd1, 0xbfd66666, 0x66666660},	/* 2.06474=f(0.65, -0.35)*/
{38, 0,123,__LINE__, 0x4000068f, 0xe33e014a, 0x3fe4cccc, 0xccccccd1, 0xbfd33333, 0x3333332d},	/* 2.0032=f(0.65, -0.3)*/
{38, 0,123,__LINE__, 0x3fff01ed, 0x0313d9ef, 0x3fe4cccc, 0xccccccd1, 0xbfcfffff, 0xfffffff4},	/* 1.93797=f(0.65, -0.25)*/
{38, 0,123,__LINE__, 0x3ffde8a2, 0x28f95b99, 0x3fe4cccc, 0xccccccd1, 0xbfc99999, 0x9999998e},	/* 1.8693=f(0.65, -0.2)*/
{37, 0,123,__LINE__, 0x3ffcc2f3, 0x2cf5541f, 0x3fe4cccc, 0xccccccd1, 0xbfc33333, 0x33333328},	/* 1.7976=f(0.65, -0.15)*/
{38, 0,123,__LINE__, 0x3ffb933b, 0xc26c5140, 0x3fe4cccc, 0xccccccd1, 0xbfb99999, 0x99999983},	/* 1.72345=f(0.65, -0.1)*/
{39, 0,123,__LINE__, 0x3ffa5c70, 0x7ef753c5, 0x3fe4cccc, 0xccccccd1, 0xbfa99999, 0x9999996c},	/* 1.64757=f(0.65, -0.05)*/
{64, 0,123,__LINE__, 0x3ff921fb, 0x54442d16, 0x3fe4cccc, 0xccccccd1, 0x3cb70000, 0x00000000},	/* 1.5708=f(0.65, 3.19189e-16)*/
{39, 0,123,__LINE__, 0x3ff7e786, 0x2991066c, 0x3fe4cccc, 0xccccccd1, 0x3fa99999, 0x999999c8},	/* 1.49402=f(0.65, 0.05)*/
{38, 0,123,__LINE__, 0x3ff6b0ba, 0xe61c08f1, 0x3fe4cccc, 0xccccccd1, 0x3fb99999, 0x999999b1},	/* 1.41815=f(0.65, 0.1)*/
{37, 0,123,__LINE__, 0x3ff58103, 0x7b930612, 0x3fe4cccc, 0xccccccd1, 0x3fc33333, 0x3333333f},	/* 1.344=f(0.65, 0.15)*/
{38, 0,123,__LINE__, 0x3ff45b54, 0x7f8efe97, 0x3fe4cccc, 0xccccccd1, 0x3fc99999, 0x999999a6},	/* 1.2723=f(0.65, 0.2)*/
{38, 0,123,__LINE__, 0x3ff34209, 0xa5748041, 0x3fe4cccc, 0xccccccd1, 0x3fd00000, 0x00000006},	/* 1.20362=f(0.65, 0.25)*/
{37, 0,123,__LINE__, 0x3ff236d6, 0xe20c579d, 0x3fe4cccc, 0xccccccd1, 0x3fd33333, 0x33333339},	/* 1.13839=f(0.65, 0.3)*/
{38, 0,123,__LINE__, 0x3ff13acc, 0x417616d9, 0x3fe4cccc, 0xccccccd1, 0x3fd66666, 0x6666666c},	/* 1.07685=f(0.65, 0.35)*/
{37, 0,123,__LINE__, 0x3ff04e67, 0x214bdc7a, 0x3fe4cccc, 0xccccccd1, 0x3fd99999, 0x9999999f},	/* 1.01914=f(0.65, 0.4)*/
{38, 0,123,__LINE__, 0x3feee357, 0x722a9227, 0x3fe4cccc, 0xccccccd1, 0x3fdccccc, 0xccccccd2},	/* 0.965252=f(0.65, 0.45)*/
{36, 0,123,__LINE__, 0x3fed4881, 0x3a2943ec, 0x3fe4cccc, 0xccccccd1, 0x3fe00000, 0x00000003},	/* 0.915101=f(0.65, 0.5)*/
{36, 0,123,__LINE__, 0x3febcb13, 0x11ce89a8, 0x3fe4cccc, 0xccccccd1, 0x3fe19999, 0x9999999d},	/* 0.868539=f(0.65, 0.55)*/
{35, 0,123,__LINE__, 0x3fea697c, 0xa20914b3, 0x3fe4cccc, 0xccccccd1, 0x3fe33333, 0x33333337},	/* 0.825377=f(0.65, 0.6)*/
{64, 0,123,__LINE__, 0x3fe921fb, 0x54442d18, 0x3fe4cccc, 0xccccccd1, 0x3fe4cccc, 0xccccccd1},	/* 0.785398=f(0.65, 0.65)*/
{37, 0,123,__LINE__, 0x3fe7f2b6, 0x7fa26bbe, 0x3fe4cccc, 0xccccccd1, 0x3fe66666, 0x6666666b},	/* 0.748378=f(0.65, 0.7)*/
{36, 0,123,__LINE__, 0x3fe6d9d4, 0xb2de51a6, 0x3fe4cccc, 0xccccccd1, 0x3fe80000, 0x00000005},	/* 0.714091=f(0.65, 0.75)*/
{36, 0,123,__LINE__, 0x3fe5d589, 0x79890d89, 0x3fe4cccc, 0xccccccd1, 0x3fe99999, 0x9999999f},	/* 0.682317=f(0.65, 0.8)*/
{35, 0,123,__LINE__, 0x3fe4e41e, 0x8d7775cf, 0x3fe4cccc, 0xccccccd1, 0x3feb3333, 0x33333339},	/* 0.652847=f(0.65, 0.85)*/
{38, 0,123,__LINE__, 0x3fe403f9, 0x316634c4, 0x3fe4cccc, 0xccccccd1, 0x3feccccc, 0xccccccd3},	/* 0.625485=f(0.65, 0.9)*/
{37, 0,123,__LINE__, 0x3fe3339c, 0x7b46ed47, 0x3fe4cccc, 0xccccccd1, 0x3fee6666, 0x6666666d},	/* 0.60005=f(0.65, 0.95)*/
{39, 0,123,__LINE__, 0x40043f37, 0x09f81e27, 0x3fe66666, 0x6666666b, 0xbff00000, 0x00000000},	/* 2.53087=f(0.7, -1)*/
{41, 0,123,__LINE__, 0x40040d72, 0x6ee90441, 0x3fe66666, 0x6666666b, 0xbfee6666, 0x66666666},	/* 2.50657=f(0.7, -0.95)*/
{40, 0,123,__LINE__, 0x4003d82a, 0x536af975, 0x3fe66666, 0x6666666b, 0xbfeccccc, 0xcccccccc},	/* 2.48055=f(0.7, -0.9)*/
{38, 0,123,__LINE__, 0x40039f10, 0x8d15dc8c, 0x3fe66666, 0x6666666b, 0xbfeb3333, 0x33333332},	/* 2.45267=f(0.7, -0.85)*/
{38, 0,123,__LINE__, 0x400361d1, 0x6505d30c, 0x3fe66666, 0x6666666b, 0xbfe99999, 0x99999998},	/* 2.42276=f(0.7, -0.8)*/
{39, 0,123,__LINE__, 0x40032014, 0x3cc321c2, 0x3fe66666, 0x6666666b, 0xbfe7ffff, 0xfffffffe},	/* 2.39066=f(0.7, -0.75)*/
{63, 0,123,__LINE__, 0x4002d97c, 0x7f3321d2, 0x3fe66666, 0x6666666b, 0xbfe66666, 0x66666664},	/* 2.35619=f(0.7, -0.7)*/
{39, 0,123,__LINE__, 0x40028dab, 0x4a0ab17c, 0x3fe66666, 0x6666666b, 0xbfe4cccc, 0xccccccca},	/* 2.31917=f(0.7, -0.65)*/
{38, 0,123,__LINE__, 0x40023c41, 0xee24d9c7, 0x3fe66666, 0x6666666b, 0xbfe33333, 0x33333330},	/* 2.27942=f(0.7, -0.6)*/
{38, 0,123,__LINE__, 0x4001e4e5, 0x5a9da0a8, 0x3fe66666, 0x6666666b, 0xbfe19999, 0x99999996},	/* 2.23677=f(0.7, -0.55)*/
{39, 0,123,__LINE__, 0x40018743, 0x080419df, 0x3fe66666, 0x6666666b, 0xbfdfffff, 0xfffffff9},	/* 2.19105=f(0.7, -0.5)*/
{40, 0,123,__LINE__, 0x40012317, 0x0c052249, 0x3fe66666, 0x6666666b, 0xbfdccccc, 0xccccccc6},	/* 2.14213=f(0.7, -0.45)*/
{39, 0,123,__LINE__, 0x4000b833, 0xbfeefa53, 0x3fe66666, 0x6666666b, 0xbfd99999, 0x99999993},	/* 2.08994=f(0.7, -0.4)*/
{62, 0,123,__LINE__, 0x4000468a, 0x8ace4df6, 0x3fe66666, 0x6666666b, 0xbfd66666, 0x66666660},	/* 2.03444=f(0.7, -0.35)*/
{37, 0,123,__LINE__, 0x3fff9c6b, 0x2910ce24, 0x3fe66666, 0x6666666b, 0xbfd33333, 0x3333332d},	/* 1.97569=f(0.7, -0.3)*/
{39, 0,123,__LINE__, 0x3ffe9f02, 0x01947c89, 0x3fe66666, 0x6666666b, 0xbfcfffff, 0xfffffff4},	/* 1.91382=f(0.7, -0.25)*/
{38, 0,123,__LINE__, 0x3ffd95e5, 0xae666ff2, 0x3fe66666, 0x6666666b, 0xbfc99999, 0x9999998e},	/* 1.8491=f(0.7, -0.2)*/
{38, 0,123,__LINE__, 0x3ffc829e, 0xbe8cebc0, 0x3fe66666, 0x6666666b, 0xbfc33333, 0x33333328},	/* 1.78189=f(0.7, -0.15)*/
{39, 0,123,__LINE__, 0x3ffb6731, 0x2e062767, 0x3fe66666, 0x6666666b, 0xbfb99999, 0x99999983},	/* 1.71269=f(0.7, -0.1)*/
{40, 0,123,__LINE__, 0x3ffa460e, 0xa0b387f9, 0x3fe66666, 0x6666666b, 0xbfa99999, 0x9999996c},	/* 1.6421=f(0.7, -0.05)*/
{64, 0,123,__LINE__, 0x3ff921fb, 0x54442d16, 0x3fe66666, 0x6666666b, 0x3cb70000, 0x00000000},	/* 1.5708=f(0.7, 3.19189e-16)*/
{40, 0,123,__LINE__, 0x3ff7fde8, 0x07d4d238, 0x3fe66666, 0x6666666b, 0x3fa99999, 0x999999c8},	/* 1.49949=f(0.7, 0.05)*/
{39, 0,123,__LINE__, 0x3ff6dcc5, 0x7a8232c9, 0x3fe66666, 0x6666666b, 0x3fb99999, 0x999999b1},	/* 1.4289=f(0.7, 0.1)*/
{38, 0,123,__LINE__, 0x3ff5c157, 0xe9fb6e70, 0x3fe66666, 0x6666666b, 0x3fc33333, 0x3333333f},	/* 1.3597=f(0.7, 0.15)*/
{38, 0,123,__LINE__, 0x3ff4ae10, 0xfa21ea3f, 0x3fe66666, 0x6666666b, 0x3fc99999, 0x999999a6},	/* 1.2925=f(0.7, 0.2)*/
{39, 0,123,__LINE__, 0x3ff3a4f4, 0xa6f3dda7, 0x3fe66666, 0x6666666b, 0x3fd00000, 0x00000006},	/* 1.22777=f(0.7, 0.25)*/
{37, 0,123,__LINE__, 0x3ff2a78b, 0x7f778c0d, 0x3fe66666, 0x6666666b, 0x3fd33333, 0x33333339},	/* 1.1659=f(0.7, 0.3)*/
{64, 0,123,__LINE__, 0x3ff1b6e1, 0x92ebbe44, 0x3fe66666, 0x6666666b, 0x3fd66666, 0x6666666c},	/* 1.10715=f(0.7, 0.35)*/
{38, 0,123,__LINE__, 0x3ff0d38f, 0x28aa658a, 0x3fe66666, 0x6666666b, 0x3fd99999, 0x9999999f},	/* 1.05165=f(0.7, 0.4)*/
{38, 0,123,__LINE__, 0x3feffb91, 0x20fc2b3c, 0x3fe66666, 0x6666666b, 0x3fdccccc, 0xccccccd2},	/* 0.999459=f(0.7, 0.45)*/
{37, 0,123,__LINE__, 0x3fee6ae1, 0x31004ce4, 0x3fe66666, 0x6666666b, 0x3fe00000, 0x00000003},	/* 0.950547=f(0.7, 0.5)*/
{36, 0,123,__LINE__, 0x3fecf457, 0xe69a31c2, 0x3fe66666, 0x6666666b, 0x3fe19999, 0x9999999d},	/* 0.904827=f(0.7, 0.55)*/
{36, 0,123,__LINE__, 0x3feb96e5, 0x987d4d44, 0x3fe66666, 0x6666666b, 0x3fe33333, 0x33333337},	/* 0.86217=f(0.7, 0.6)*/
{37, 0,123,__LINE__, 0x3fea5140, 0x28e5ee73, 0x3fe66666, 0x6666666b, 0x3fe4cccc, 0xccccccd1},	/* 0.822418=f(0.7, 0.65)*/
{64, 0,123,__LINE__, 0x3fe921fb, 0x54442d18, 0x3fe66666, 0x6666666b, 0x3fe66666, 0x6666666b},	/* 0.785398=f(0.7, 0.7)*/
{37, 0,123,__LINE__, 0x3fe8079c, 0x5e042d5a, 0x3fe66666, 0x6666666b, 0x3fe80000, 0x00000005},	/* 0.750929=f(0.7, 0.75)*/
{36, 0,123,__LINE__, 0x3fe700a7, 0xbcf9682f, 0x3fe66666, 0x6666666b, 0x3fe99999, 0x9999999f},	/* 0.71883=f(0.7, 0.8)*/
{36, 0,123,__LINE__, 0x3fe60bab, 0x1cb9422f, 0x3fe66666, 0x6666666b, 0x3feb3333, 0x33333339},	/* 0.688924=f(0.7, 0.85)*/
{38, 0,123,__LINE__, 0x3fe52744, 0x0364ce8e, 0x3fe66666, 0x6666666b, 0x3feccccc, 0xccccccd3},	/* 0.661043=f(0.7, 0.9)*/
{39, 0,123,__LINE__, 0x3fe45223, 0x956ca35f, 0x3fe66666, 0x6666666b, 0x3fee6666, 0x6666666d},	/* 0.635027=f(0.7, 0.95)*/
{63, 0,123,__LINE__, 0x4003fc17, 0x6b7a8560, 0x3fe80000, 0x00000005, 0xbff00000, 0x00000000},	/* 2.49809=f(0.75, -1)*/
{40, 0,123,__LINE__, 0x4003c953, 0x34015c97, 0x3fe80000, 0x00000005, 0xbfee6666, 0x66666666},	/* 2.4733=f(0.75, -0.95)*/
{39, 0,123,__LINE__, 0x40039328, 0x61882bfd, 0x3fe80000, 0x00000005, 0xbfeccccc, 0xcccccccc},	/* 2.44685=f(0.75, -0.9)*/
{39, 0,123,__LINE__, 0x40035951, 0xefedf7a7, 0x3fe80000, 0x00000005, 0xbfeb3333, 0x33333332},	/* 2.41861=f(0.75, -0.85)*/
{40, 0,123,__LINE__, 0x40031b87, 0x277e4245, 0x3fe80000, 0x00000005, 0xbfe99999, 0x99999998},	/* 2.38844=f(0.75, -0.8)*/
{63, 0,123,__LINE__, 0x4002d97c, 0x7f3321d2, 0x3fe80000, 0x00000005, 0xbfe7ffff, 0xfffffffe},	/* 2.35619=f(0.75, -0.75)*/
{39, 0,123,__LINE__, 0x400292e4, 0xc1a321e3, 0x3fe80000, 0x00000005, 0xbfe66666, 0x66666664},	/* 2.32173=f(0.75, -0.7)*/
{38, 0,123,__LINE__, 0x40024772, 0xd6d9aaf6, 0x3fe80000, 0x00000005, 0xbfe4cccc, 0xccccccca},	/* 2.28489=f(0.75, -0.65)*/
{38, 0,123,__LINE__, 0x4001f6dc, 0x40fd155a, 0x3fe80000, 0x00000005, 0xbfe33333, 0x33333330},	/* 2.24554=f(0.75, -0.6)*/
{39, 0,123,__LINE__, 0x4001a0dc, 0x4a8c907c, 0x3fe80000, 0x00000005, 0xbfe19999, 0x99999996},	/* 2.20355=f(0.75, -0.55)*/
{63, 0,123,__LINE__, 0x40014538, 0x5fa3af71, 0x3fe80000, 0x00000005, 0xbfdfffff, 0xfffffff9},	/* 2.1588=f(0.75, -0.5)*/
{39, 0,123,__LINE__, 0x4000e3c5, 0x1e0ec833, 0x3fe80000, 0x00000005, 0xbfdccccc, 0xccccccc6},	/* 2.11122=f(0.75, -0.45)*/
{40, 0,123,__LINE__, 0x40007c6c, 0x6a1c3f04, 0x3fe80000, 0x00000005, 0xbfd99999, 0x99999993},	/* 2.06075=f(0.75, -0.4)*/
{40, 0,123,__LINE__, 0x40000f34, 0x0aa16924, 0x3fe80000, 0x00000005, 0xbfd66666, 0x66666660},	/* 2.00742=f(0.75, -0.35)*/
{38, 0,123,__LINE__, 0x3fff3889, 0x32cba87c, 0x3fe80000, 0x00000005, 0xbfd33333, 0x3333332d},	/* 1.9513=f(0.75, -0.3)*/
{62, 0,123,__LINE__, 0x3ffe47df, 0x3d0dd4d1, 0x3fe80000, 0x00000005, 0xbfcfffff, 0xfffffff4},	/* 1.89255=f(0.75, -0.25)*/
{40, 0,123,__LINE__, 0x3ffd4d68, 0xbf20242a, 0x3fe80000, 0x00000005, 0xbfc99999, 0x9999998e},	/* 1.8314=f(0.75, -0.2)*/
{38, 0,123,__LINE__, 0x3ffc4a83, 0x957032ac, 0x3fe80000, 0x00000005, 0xbfc33333, 0x33333328},	/* 1.76819=f(0.75, -0.15)*/
{40, 0,123,__LINE__, 0x3ffb40e9, 0xafce4e9c, 0x3fe80000, 0x00000005, 0xbfb99999, 0x99999983},	/* 1.70335=f(0.75, -0.1)*/
{41, 0,123,__LINE__, 0x3ffa32a5, 0x1bee177b, 0x3fe80000, 0x00000005, 0xbfa99999, 0x9999996c},	/* 1.63736=f(0.75, -0.05)*/
{64, 0,123,__LINE__, 0x3ff921fb, 0x54442d16, 0x3fe80000, 0x00000005, 0x3cb70000, 0x00000000},	/* 1.5708=f(0.75, 3.19189e-16)*/
{41, 0,123,__LINE__, 0x3ff81151, 0x8c9a42b6, 0x3fe80000, 0x00000005, 0x3fa99999, 0x999999c8},	/* 1.50423=f(0.75, 0.05)*/
{40, 0,123,__LINE__, 0x3ff7030c, 0xf8ba0b95, 0x3fe80000, 0x00000005, 0x3fb99999, 0x999999b1},	/* 1.43824=f(0.75, 0.1)*/
{38, 0,123,__LINE__, 0x3ff5f973, 0x13182785, 0x3fe80000, 0x00000005, 0x3fc33333, 0x3333333f},	/* 1.3734=f(0.75, 0.15)*/
{40, 0,123,__LINE__, 0x3ff4f68d, 0xe9683606, 0x3fe80000, 0x00000005, 0x3fc99999, 0x999999a6},	/* 1.31019=f(0.75, 0.2)*/
{63, 0,123,__LINE__, 0x3ff3fc17, 0x6b7a8560, 0x3fe80000, 0x00000005, 0x3fd00000, 0x00000006},	/* 1.24905=f(0.75, 0.25)*/
{38, 0,123,__LINE__, 0x3ff30b6d, 0x75bcb1b4, 0x3fe80000, 0x00000005, 0x3fd33333, 0x33333339},	/* 1.19029=f(0.75, 0.3)*/
{39, 0,123,__LINE__, 0x3ff2258e, 0x934587e9, 0x3fe80000, 0x00000005, 0x3fd66666, 0x6666666c},	/* 1.13417=f(0.75, 0.35)*/
{39, 0,123,__LINE__, 0x3ff14b1d, 0xd44fdc29, 0x3fe80000, 0x00000005, 0x3fd99999, 0x9999999f},	/* 1.08084=f(0.75, 0.4)*/
{38, 0,123,__LINE__, 0x3ff07c6c, 0x6c6ac9cb, 0x3fe80000, 0x00000005, 0x3fdccccc, 0xccccccd2},	/* 1.03038=f(0.75, 0.45)*/
{64, 0,123,__LINE__, 0x3fef730b, 0xd281f69b, 0x3fe80000, 0x00000005, 0x3fe00000, 0x00000003},	/* 0.982794=f(0.75, 0.5)*/
{37, 0,123,__LINE__, 0x3fee047c, 0x26de7270, 0x3fe80000, 0x00000005, 0x3fe19999, 0x9999999d},	/* 0.938047=f(0.75, 0.55)*/
{36, 0,123,__LINE__, 0x3fecac7c, 0x4d1c5efa, 0x3fe80000, 0x00000005, 0x3fe33333, 0x33333337},	/* 0.896055=f(0.75, 0.6)*/
{36, 0,123,__LINE__, 0x3feb6a21, 0xf5aa088b, 0x3fe80000, 0x00000005, 0x3fe4cccc, 0xccccccd1},	/* 0.856706=f(0.75, 0.65)*/
{37, 0,123,__LINE__, 0x3fea3c5a, 0x4a842cd7, 0x3fe80000, 0x00000005, 0x3fe66666, 0x6666666b},	/* 0.819867=f(0.75, 0.7)*/
{64, 0,123,__LINE__, 0x3fe921fb, 0x54442d18, 0x3fe80000, 0x00000005, 0x3fe80000, 0x00000005},	/* 0.785398=f(0.75, 0.75)*/
{38, 0,123,__LINE__, 0x3fe819d0, 0xb317ab4d, 0x3fe80000, 0x00000005, 0x3fe99999, 0x9999999f},	/* 0.753151=f(0.75, 0.8)*/
{37, 0,123,__LINE__, 0x3fe722a5, 0x9158d5c3, 0x3fe80000, 0x00000005, 0x3feb3333, 0x33333339},	/* 0.722979=f(0.75, 0.85)*/
{37, 0,123,__LINE__, 0x3fe63b4b, 0xcaf0046e, 0x3fe80000, 0x00000005, 0x3feccccc, 0xccccccd3},	/* 0.694738=f(0.75, 0.9)*/
{38, 0,123,__LINE__, 0x3fe562a0, 0x810b4205, 0x3fe80000, 0x00000005, 0x3fee6666, 0x6666666d},	/* 0.668289=f(0.75, 0.95)*/
{40, 0,123,__LINE__, 0x4003bc1c, 0xbf0970e4, 0x3fe99999, 0x9999999f, 0xbff00000, 0x00000000},	/* 2.46685=f(0.8, -1)*/
{39, 0,123,__LINE__, 0x40038899, 0xe3a24b48, 0x3fe99999, 0x9999999f, 0xbfee6666, 0x66666666},	/* 2.4417=f(0.8, -0.95)*/
{38, 0,123,__LINE__, 0x400351d1, 0x757908b6, 0x3fe99999, 0x9999999f, 0xbfeccccc, 0xcccccccc},	/* 2.41495=f(0.8, -0.9)*/
{40, 0,123,__LINE__, 0x40031787, 0x27b59795, 0x3fe99999, 0x9999999f, 0xbfeb3333, 0x33333332},	/* 2.38649=f(0.8, -0.85)*/
{63, 0,123,__LINE__, 0x4002d97c, 0x7f3321d2, 0x3fe99999, 0x9999999f, 0xbfe99999, 0x99999998},	/* 2.35619=f(0.8, -0.8)*/
{40, 0,123,__LINE__, 0x40029771, 0xd6e8015f, 0x3fe99999, 0x9999999f, 0xbfe7ffff, 0xfffffffe},	/* 2.32395=f(0.8, -0.75)*/
{38, 0,123,__LINE__, 0x40025127, 0x99607098, 0x3fe99999, 0x9999999f, 0xbfe66666, 0x66666664},	/* 2.28963=f(0.8, -0.7)*/
{38, 0,123,__LINE__, 0x40020660, 0x088459ee, 0x3fe99999, 0x9999999f, 0xbfe4cccc, 0xccccccca},	/* 2.25311=f(0.8, -0.65)*/
{39, 0,123,__LINE__, 0x4001b6e1, 0x948557dd, 0x3fe99999, 0x9999999f, 0xbfe33333, 0x33333330},	/* 2.2143=f(0.8, -0.6)*/
{41, 0,123,__LINE__, 0x40016279, 0xb1c24a2b, 0x3fe99999, 0x9999999f, 0xbfe19999, 0x99999996},	/* 2.17308=f(0.8, -0.55)*/
{40, 0,123,__LINE__, 0x40010900, 0x9433b976, 0x3fe99999, 0x9999999f, 0xbfdfffff, 0xfffffff9},	/* 2.1294=f(0.8, -0.5)*/
{38, 0,123,__LINE__, 0x4000aa5d, 0x4cf92bad, 0x3fe99999, 0x9999999f, 0xbfdccccc, 0xccccccc6},	/* 2.08319=f(0.8, -0.45)*/
{62, 0,123,__LINE__, 0x4000468a, 0x8ace4df6, 0x3fe99999, 0x9999999f, 0xbfd99999, 0x99999993},	/* 2.03444=f(0.8, -0.4)*/
{38, 0,123,__LINE__, 0x3fffbb37, 0x021170d9, 0x3fe99999, 0x9999999f, 0xbfd66666, 0x66666660},	/* 1.98321=f(0.8, -0.35)*/
{38, 0,123,__LINE__, 0x3ffedf81, 0xa6ee7d60, 0x3fe99999, 0x9999999f, 0xbfd33333, 0x3333332d},	/* 1.92957=f(0.8, -0.3)*/
{39, 0,123,__LINE__, 0x3ffdfa99, 0x20e2a04d, 0x3fe99999, 0x9999999f, 0xbfcfffff, 0xfffffff4},	/* 1.87368=f(0.8, -0.25)*/
{62, 0,123,__LINE__, 0x3ffd0d6a, 0x1369bd34, 0x3fe99999, 0x9999999f, 0xbfc99999, 0x9999998e},	/* 1.81577=f(0.8, -0.2)*/
{39, 0,123,__LINE__, 0x3ffc192a, 0xbef31a48, 0x3fe99999, 0x9999999f, 0xbfc33333, 0x33333328},	/* 1.75614=f(0.8, -0.15)*/
{62, 0,123,__LINE__, 0x3ffb1f56, 0xfdeef00f, 0x3fe99999, 0x9999999f, 0xbfb99999, 0x99999983},	/* 1.69515=f(0.8, -0.1)*/
{62, 0,123,__LINE__, 0x3ffa21a6, 0x31fd9508, 0x3fe99999, 0x9999999f, 0xbfa99999, 0x9999996c},	/* 1.63322=f(0.8, -0.05)*/
{64, 0,123,__LINE__, 0x3ff921fb, 0x54442d16, 0x3fe99999, 0x9999999f, 0x3cb70000, 0x00000000},	/* 1.5708=f(0.8, 3.19189e-16)*/
{62, 0,123,__LINE__, 0x3ff82250, 0x768ac529, 0x3fe99999, 0x9999999f, 0x3fa99999, 0x999999c8},	/* 1.50838=f(0.8, 0.05)*/
{63, 0,123,__LINE__, 0x3ff7249f, 0xaa996a21, 0x3fe99999, 0x9999999f, 0x3fb99999, 0x999999b1},	/* 1.44644=f(0.8, 0.1)*/
{39, 0,123,__LINE__, 0x3ff62acb, 0xe9953fe9, 0x3fe99999, 0x9999999f, 0x3fc33333, 0x3333333f},	/* 1.38545=f(0.8, 0.15)*/
{63, 0,123,__LINE__, 0x3ff5368c, 0x951e9cfd, 0x3fe99999, 0x9999999f, 0x3fc99999, 0x999999a6},	/* 1.32582=f(0.8, 0.2)*/
{39, 0,123,__LINE__, 0x3ff4495d, 0x87a5b9e3, 0x3fe99999, 0x9999999f, 0x3fd00000, 0x00000006},	/* 1.26791=f(0.8, 0.25)*/
{38, 0,123,__LINE__, 0x3ff36475, 0x0199dcd1, 0x3fe99999, 0x9999999f, 0x3fd33333, 0x33333339},	/* 1.21203=f(0.8, 0.3)*/
{38, 0,123,__LINE__, 0x3ff288bf, 0xa676e958, 0x3fe99999, 0x9999999f, 0x3fd66666, 0x6666666c},	/* 1.15839=f(0.8, 0.35)*/
{64, 0,123,__LINE__, 0x3ff1b6e1, 0x92ebbe44, 0x3fe99999, 0x9999999f, 0x3fd99999, 0x9999999f},	/* 1.10715=f(0.8, 0.4)*/
{37, 0,123,__LINE__, 0x3ff0ef3c, 0x0e9602d6, 0x3fe99999, 0x9999999f, 0x3fdccccc, 0xccccccd2},	/* 1.05841=f(0.8, 0.45)*/
{39, 0,123,__LINE__, 0x3ff031f5, 0x8020e745, 0x3fe99999, 0x9999999f, 0x3fe00000, 0x00000003},	/* 1.0122=f(0.8, 0.5)*/
{39, 0,123,__LINE__, 0x3feefe06, 0x8a078bb6, 0x3fe99999, 0x9999999f, 0x3fe19999, 0x9999999d},	/* 0.968509=f(0.8, 0.55)*/
{37, 0,123,__LINE__, 0x3fedac66, 0xfefb54ec, 0x3fe99999, 0x9999999f, 0x3fe33333, 0x33333337},	/* 0.927295=f(0.8, 0.6)*/
{36, 0,123,__LINE__, 0x3fec6e6d, 0x2eff4ca7, 0x3fe99999, 0x9999999f, 0x3fe4cccc, 0xccccccd1},	/* 0.88848=f(0.8, 0.65)*/
{36, 0,123,__LINE__, 0x3feb434e, 0xeb8ef201, 0x3fe99999, 0x9999999f, 0x3fe66666, 0x6666666b},	/* 0.851966=f(0.8, 0.7)*/
{38, 0,123,__LINE__, 0x3fea2a25, 0xf570aee4, 0x3fe99999, 0x9999999f, 0x3fe80000, 0x00000005},	/* 0.817645=f(0.8, 0.75)*/
{64, 0,123,__LINE__, 0x3fe921fb, 0x54442d18, 0x3fe99999, 0x9999999f, 0x3fe99999, 0x9999999f},	/* 0.785398=f(0.8, 0.8)*/
{38, 0,123,__LINE__, 0x3fe829d0, 0xb23a560d, 0x3fe99999, 0x9999999f, 0x3feb3333, 0x33333339},	/* 0.755104=f(0.8, 0.85)*/
{36, 0,123,__LINE__, 0x3fe740a7, 0x7b2c9187, 0x3fe99999, 0x9999999f, 0x3feccccc, 0xccccccd3},	/* 0.726642=f(0.8, 0.9)*/
{37, 0,123,__LINE__, 0x3fe66585, 0xc2878741, 0x3fe99999, 0x9999999f, 0x3fee6666, 0x6666666d},	/* 0.699893=f(0.8, 0.95)*/
{39, 0,123,__LINE__, 0x40037f2d, 0x89b76ab1, 0x3feb3333, 0x33333339, 0xbff00000, 0x00000000},	/* 2.4371=f(0.85, -1)*/
{38, 0,123,__LINE__, 0x40034b25, 0xafc60553, 0x3feb3333, 0x33333339, 0xbfee6666, 0x66666666},	/* 2.41169=f(0.85, -0.95)*/
{38, 0,123,__LINE__, 0x400313fc, 0x10cdd70e, 0x3feb3333, 0x33333339, 0xbfeccccc, 0xcccccccc},	/* 2.38476=f(0.85, -0.9)*/
{63, 0,123,__LINE__, 0x4002d97c, 0x7f3321d2, 0x3feb3333, 0x33333339, 0xbfeb3333, 0x33333332},	/* 2.35619=f(0.85, -0.85)*/
{40, 0,123,__LINE__, 0x40029b71, 0xd6b0ac0f, 0x3feb3333, 0x33333339, 0xbfe99999, 0x99999998},	/* 2.3259=f(0.85, -0.8)*/
{39, 0,123,__LINE__, 0x400259a7, 0x0e784bfd, 0x3feb3333, 0x33333339, 0xbfe7ffff, 0xfffffffe},	/* 2.29378=f(0.85, -0.75)*/
{38, 0,123,__LINE__, 0x400213e8, 0x71506718, 0x3feb3333, 0x33333339, 0xbfe66666, 0x66666664},	/* 2.25972=f(0.85, -0.7)*/
{37, 0,123,__LINE__, 0x4001ca05, 0x4d7ff400, 0x3feb3333, 0x33333339, 0xbfe4cccc, 0xccccccca},	/* 2.22364=f(0.85, -0.65)*/
{40, 0,123,__LINE__, 0x40017bd2, 0x13c3d3f3, 0x3feb3333, 0x33333339, 0xbfe33333, 0x33333330},	/* 2.18546=f(0.85, -0.6)*/
{41, 0,123,__LINE__, 0x4001292a, 0xcb3a7791, 0x3feb3333, 0x33333339, 0xbfe19999, 0x99999996},	/* 2.1451=f(0.85, -0.55)*/
{39, 0,123,__LINE__, 0x4000d1f6, 0x34b7e310, 0x3feb3333, 0x33333339, 0xbfdfffff, 0xfffffff9},	/* 2.10252=f(0.85, -0.5)*/
{38, 0,123,__LINE__, 0x40007629, 0x13c3c8d9, 0x3feb3333, 0x33333339, 0xbfdccccc, 0xccccccc6},	/* 2.0577=f(0.85, -0.45)*/
{40, 0,123,__LINE__, 0x400015c9, 0xd998b0f0, 0x3feb3333, 0x33333339, 0xbfd99999, 0x99999993},	/* 2.01064=f(0.85, -0.4)*/
{37, 0,123,__LINE__, 0x3fff61e8, 0x7be5d383, 0x3feb3333, 0x33333339, 0xbfd66666, 0x66666660},	/* 1.9614=f(0.85, -0.35)*/
{40, 0,123,__LINE__, 0x3ffe8fb9, 0x6cede8b6, 0x3feb3333, 0x33333339, 0xbfd33333, 0x3333332d},	/* 1.91009=f(0.85, -0.3)*/
{38, 0,123,__LINE__, 0x3ffdb5a5, 0xff6cc905, 0x3feb3333, 0x33333339, 0xbfcfffff, 0xfffffff4},	/* 1.85685=f(0.85, -0.25)*/
{40, 0,123,__LINE__, 0x3ffcd487, 0x741b023a, 0x3feb3333, 0x33333339, 0xbfc99999, 0x9999998e},	/* 1.80189=f(0.85, -0.2)*/
{40, 0,123,__LINE__, 0x3ffbed70, 0x6831cc6b, 0x3feb3333, 0x33333339, 0xbfc33333, 0x33333328},	/* 1.74547=f(0.85, -0.15)*/
{41, 0,123,__LINE__, 0x3ffb01a8, 0xbf1b2cae, 0x3feb3333, 0x33333339, 0xbfb99999, 0x99999983},	/* 1.68791=f(0.85, -0.1)*/
{42, 0,123,__LINE__, 0x3ffa12a5, 0x461f6da4, 0x3feb3333, 0x33333339, 0xbfa99999, 0x9999996c},	/* 1.62955=f(0.85, -0.05)*/
{64, 0,123,__LINE__, 0x3ff921fb, 0x54442d17, 0x3feb3333, 0x33333339, 0x3cb70000, 0x00000000},	/* 1.5708=f(0.85, 3.19189e-16)*/
{42, 0,123,__LINE__, 0x3ff83151, 0x6268ec8d, 0x3feb3333, 0x33333339, 0x3fa99999, 0x999999c8},	/* 1.51204=f(0.85, 0.05)*/
{41, 0,123,__LINE__, 0x3ff7424d, 0xe96d2d82, 0x3feb3333, 0x33333339, 0x3fb99999, 0x999999b1},	/* 1.45369=f(0.85, 0.1)*/
{40, 0,123,__LINE__, 0x3ff65686, 0x40568dc6, 0x3feb3333, 0x33333339, 0x3fc33333, 0x3333333f},	/* 1.39612=f(0.85, 0.15)*/
{40, 0,123,__LINE__, 0x3ff56f6f, 0x346d57f6, 0x3feb3333, 0x33333339, 0x3fc99999, 0x999999a6},	/* 1.33971=f(0.85, 0.2)*/
{38, 0,123,__LINE__, 0x3ff48e50, 0xa91b912b, 0x3feb3333, 0x33333339, 0x3fd00000, 0x00000006},	/* 1.28474=f(0.85, 0.25)*/
{40, 0,123,__LINE__, 0x3ff3b43d, 0x3b9a717b, 0x3feb3333, 0x33333339, 0x3fd33333, 0x33333339},	/* 1.2315=f(0.85, 0.3)*/
{37, 0,123,__LINE__, 0x3ff2e20e, 0x2ca286ae, 0x3feb3333, 0x33333339, 0x3fd66666, 0x6666666c},	/* 1.18019=f(0.85, 0.35)*/
{39, 0,123,__LINE__, 0x3ff21862, 0xf556f851, 0x3feb3333, 0x33333339, 0x3fd99999, 0x9999999f},	/* 1.13095=f(0.85, 0.4)*/
{37, 0,123,__LINE__, 0x3ff157a4, 0x8100c87f, 0x3feb3333, 0x33333339, 0x3fdccccc, 0xccccccd2},	/* 1.0839=f(0.85, 0.45)*/
{38, 0,123,__LINE__, 0x3ff0a00a, 0x3f189411, 0x3feb3333, 0x33333339, 0x3fe00000, 0x00000003},	/* 1.03907=f(0.85, 0.5)*/
{39, 0,123,__LINE__, 0x3fefe342, 0x2426d61b, 0x3feb3333, 0x33333339, 0x3fe19999, 0x9999999d},	/* 0.996491=f(0.85, 0.55)*/
{38, 0,123,__LINE__, 0x3fee98a5, 0x02016495, 0x3feb3333, 0x33333339, 0x3fe33333, 0x33333337},	/* 0.956133=f(0.85, 0.6)*/
{35, 0,123,__LINE__, 0x3fed5fd8, 0x1b10e461, 0x3feb3333, 0x33333339, 0x3fe4cccc, 0xccccccd1},	/* 0.91795=f(0.85, 0.65)*/
{36, 0,123,__LINE__, 0x3fec384b, 0x8bcf1801, 0x3feb3333, 0x33333339, 0x3fe66666, 0x6666666b},	/* 0.881872=f(0.85, 0.7)*/
{37, 0,123,__LINE__, 0x3feb2151, 0x172f846d, 0x3feb3333, 0x33333339, 0x3fe80000, 0x00000005},	/* 0.847817=f(0.85, 0.75)*/
{38, 0,123,__LINE__, 0x3fea1a25, 0xf64e0423, 0x3feb3333, 0x33333339, 0x3fe99999, 0x9999999f},	/* 0.815692=f(0.85, 0.8)*/
{64, 0,123,__LINE__, 0x3fe921fb, 0x54442d18, 0x3feb3333, 0x33333339, 0x3feb3333, 0x33333339},	/* 0.785398=f(0.85, 0.85)*/
{36, 0,123,__LINE__, 0x3fe837fd, 0x0dd9582a, 0x3feb3333, 0x33333339, 0x3feccccc, 0xccccccd3},	/* 0.756835=f(0.85, 0.9)*/
{36, 0,123,__LINE__, 0x3fe75b56, 0x91f89f16, 0x3feb3333, 0x33333339, 0x3fee6666, 0x6666666d},	/* 0.7299=f(0.85, 0.95)*/
{39, 0,123,__LINE__, 0x4003452d, 0x2c0744e9, 0x3feccccc, 0xccccccd3, 0xbff00000, 0x00000000},	/* 2.40878=f(0.9, -1)*/
{40, 0,123,__LINE__, 0x400310d2, 0xff6ef990, 0x3feccccc, 0xccccccd3, 0xbfee6666, 0x66666666},	/* 2.38321=f(0.9, -0.95)*/
{63, 0,123,__LINE__, 0x4002d97c, 0x7f3321d2, 0x3feccccc, 0xccccccd3, 0xbfeccccc, 0xcccccccc},	/* 2.35619=f(0.9, -0.9)*/
{38, 0,123,__LINE__, 0x40029efc, 0xed986c97, 0x3feccccc, 0xccccccd3, 0xbfeb3333, 0x33333332},	/* 2.32763=f(0.9, -0.85)*/
{38, 0,123,__LINE__, 0x40026127, 0x88ed3aee, 0x3feccccc, 0xccccccd3, 0xbfe99999, 0x99999998},	/* 2.29744=f(0.9, -0.8)*/
{39, 0,123,__LINE__, 0x40021fd0, 0x9cde17a8, 0x3feccccc, 0xccccccd3, 0xbfe7ffff, 0xfffffffe},	/* 2.26553=f(0.9, -0.75)*/
{40, 0,123,__LINE__, 0x4001dace, 0xaafb4a30, 0x3feccccc, 0xccccccd3, 0xbfe66666, 0x66666664},	/* 2.23184=f(0.9, -0.7)*/
{40, 0,123,__LINE__, 0x400191fb, 0xf67ba3bd, 0x3feccccc, 0xccccccd3, 0xbfe4cccc, 0xccccccca},	/* 2.19628=f(0.9, -0.65)*/
{37, 0,123,__LINE__, 0x40014538, 0x63bdf116, 0x3feccccc, 0xccccccd3, 0xbfe33333, 0x33333330},	/* 2.1588=f(0.9, -0.6)*/
{38, 0,123,__LINE__, 0x4000f46b, 0x8b80920e, 0x3feccccc, 0xccccccd3, 0xbfe19999, 0x99999996},	/* 2.11935=f(0.9, -0.55)*/
{39, 0,123,__LINE__, 0x40009f87, 0x54c63a5d, 0x3feccccc, 0xccccccd3, 0xbfdfffff, 0xfffffff9},	/* 2.07789=f(0.9, -0.5)*/
{63, 0,123,__LINE__, 0x4000468a, 0x8ace4df6, 0x3feccccc, 0xccccccd3, 0xbfdccccc, 0xccccccc6},	/* 2.03444=f(0.9, -0.45)*/
{37, 0,123,__LINE__, 0x3fffd307, 0x5702cb99, 0x3feccccc, 0xccccccd3, 0xbfd99999, 0x99999993},	/* 1.98902=f(0.9, -0.4)*/
{40, 0,123,__LINE__, 0x3fff1127, 0x095cf298, 0x3feccccc, 0xccccccd3, 0xbfd66666, 0x66666660},	/* 1.94169=f(0.9, -0.35)*/
{37, 0,123,__LINE__, 0x3ffe47df, 0x42632a28, 0x3feccccc, 0xccccccd3, 0xbfd33333, 0x3333332d},	/* 1.89255=f(0.9, -0.3)*/
{39, 0,123,__LINE__, 0x3ffd77c7, 0xb36c27c3, 0x3feccccc, 0xccccccd3, 0xbfcfffff, 0xfffffff4},	/* 1.84174=f(0.9, -0.25)*/
{38, 0,123,__LINE__, 0x3ffca1a6, 0x58d1662c, 0x3feccccc, 0xccccccd3, 0xbfc99999, 0x9999998e},	/* 1.78947=f(0.9, -0.2)*/
{38, 0,123,__LINE__, 0x3ffbc66e, 0x47adc512, 0x3feccccc, 0xccccccd3, 0xbfc33333, 0x33333328},	/* 1.73595=f(0.9, -0.15)*/
{39, 0,123,__LINE__, 0x3ffae73b, 0xd71c804f, 0x3feccccc, 0xccccccd3, 0xbfb99999, 0x99999983},	/* 1.68145=f(0.9, -0.1)*/
{40, 0,123,__LINE__, 0x3ffa054d, 0xbb71d497, 0x3feccccc, 0xccccccd3, 0xbfa99999, 0x9999996c},	/* 1.62629=f(0.9, -0.05)*/
{64, 0,123,__LINE__, 0x3ff921fb, 0x54442d17, 0x3feccccc, 0xccccccd3, 0x3cb70000, 0x00000000},	/* 1.5708=f(0.9, 3.19189e-16)*/
{40, 0,123,__LINE__, 0x3ff83ea8, 0xed16859a, 0x3feccccc, 0xccccccd3, 0x3fa99999, 0x999999c8},	/* 1.5153=f(0.9, 0.05)*/
{39, 0,123,__LINE__, 0x3ff75cba, 0xd16bd9e1, 0x3feccccc, 0xccccccd3, 0x3fb99999, 0x999999b1},	/* 1.46014=f(0.9, 0.1)*/
{38, 0,123,__LINE__, 0x3ff67d88, 0x60da951f, 0x3feccccc, 0xccccccd3, 0x3fc33333, 0x3333333f},	/* 1.40565=f(0.9, 0.15)*/
{38, 0,123,__LINE__, 0x3ff5a250, 0x4fb6f405, 0x3feccccc, 0xccccccd3, 0x3fc99999, 0x999999a6},	/* 1.35213=f(0.9, 0.2)*/
{39, 0,123,__LINE__, 0x3ff4cc2e, 0xf51c326e, 0x3feccccc, 0xccccccd3, 0x3fd00000, 0x00000006},	/* 1.29985=f(0.9, 0.25)*/
{37, 0,123,__LINE__, 0x3ff3fc17, 0x66253009, 0x3feccccc, 0xccccccd3, 0x3fd33333, 0x33333339},	/* 1.24905=f(0.9, 0.3)*/
{40, 0,123,__LINE__, 0x3ff332cf, 0x9f2b6799, 0x3feccccc, 0xccccccd3, 0x3fd66666, 0x6666666c},	/* 1.19991=f(0.9, 0.35)*/
{37, 0,123,__LINE__, 0x3ff270ef, 0x51858e97, 0x3feccccc, 0xccccccd3, 0x3fd99999, 0x9999999f},	/* 1.15257=f(0.9, 0.4)*/
{63, 0,123,__LINE__, 0x3ff1b6e1, 0x92ebbe44, 0x3feccccc, 0xccccccd3, 0x3fdccccc, 0xccccccd2},	/* 1.10715=f(0.9, 0.45)*/
{38, 0,123,__LINE__, 0x3ff104e7, 0xfefbe577, 0x3feccccc, 0xccccccd3, 0x3fe00000, 0x00000003},	/* 1.0637=f(0.9, 0.5)*/
{37, 0,123,__LINE__, 0x3ff05b1f, 0x91873616, 0x3feccccc, 0xccccccd3, 0x3fe19999, 0x9999999d},	/* 1.02225=f(0.9, 0.55)*/
{35, 0,123,__LINE__, 0x3fef730b, 0xc218f009, 0x3feccccc, 0xccccccd3, 0x3fe33333, 0x33333337},	/* 0.982794=f(0.9, 0.6)*/
{38, 0,123,__LINE__, 0x3fee3ffd, 0x7722256d, 0x3feccccc, 0xccccccd3, 0x3fe4cccc, 0xccccccd1},	/* 0.945311=f(0.9, 0.65)*/
{38, 0,123,__LINE__, 0x3fed1cb2, 0xa5238ba3, 0x3feccccc, 0xccccccd3, 0x3fe66666, 0x6666666b},	/* 0.909753=f(0.9, 0.7)*/
{37, 0,123,__LINE__, 0x3fec08aa, 0xdd9855c3, 0x3feccccc, 0xccccccd3, 0x3fe80000, 0x00000005},	/* 0.876058=f(0.9, 0.75)*/
{36, 0,123,__LINE__, 0x3feb034f, 0x2d5bc8a9, 0x3feccccc, 0xccccccd3, 0x3fe99999, 0x9999999f},	/* 0.844154=f(0.9, 0.8)*/
{36, 0,123,__LINE__, 0x3fea0bf9, 0x9aaf0206, 0x3feccccc, 0xccccccd3, 0x3feb3333, 0x33333339},	/* 0.813962=f(0.9, 0.85)*/
{64, 0,123,__LINE__, 0x3fe921fb, 0x54442d18, 0x3feccccc, 0xccccccd3, 0x3feccccc, 0xccccccd3},	/* 0.785398=f(0.9, 0.9)*/
{38, 0,123,__LINE__, 0x3fe844a1, 0x5354ce20, 0x3feccccc, 0xccccccd3, 0x3fee6666, 0x6666666d},	/* 0.758378=f(0.9, 0.95)*/
{40, 0,123,__LINE__, 0x40030dfc, 0xd654307d, 0x3fee6666, 0x6666666d, 0xbff00000, 0x00000000},	/* 2.38183=f(0.95, -1)*/
{63, 0,123,__LINE__, 0x4002d97c, 0x7f3321d2, 0x3fee6666, 0x6666666d, 0xbfee6666, 0x66666666},	/* 2.35619=f(0.95, -0.95)*/
{40, 0,123,__LINE__, 0x4002a225, 0xfef74a14, 0x3fee6666, 0x6666666d, 0xbfeccccc, 0xcccccccc},	/* 2.32917=f(0.95, -0.9)*/
{38, 0,123,__LINE__, 0x400267d3, 0x4ea03e52, 0x3fee6666, 0x6666666d, 0xbfeb3333, 0x33333332},	/* 2.3007=f(0.95, -0.85)*/
{39, 0,123,__LINE__, 0x40022a5f, 0x1ac3f85c, 0x3fee6666, 0x6666666d, 0xbfe99999, 0x99999998},	/* 2.27069=f(0.95, -0.8)*/
{40, 0,123,__LINE__, 0x4001e9a5, 0xca64e70e, 0x3fee6666, 0x6666666d, 0xbfe7ffff, 0xfffffffe},	/* 2.23909=f(0.95, -0.75)*/
{41, 0,123,__LINE__, 0x4001a586, 0x8f7d3f64, 0x3fee6666, 0x6666666d, 0xbfe66666, 0x66666664},	/* 2.20582=f(0.95, -0.7)*/
{39, 0,123,__LINE__, 0x40015de4, 0xc8f3d1de, 0x3fee6666, 0x6666666d, 0xbfe4cccc, 0xccccccca},	/* 2.17085=f(0.95, -0.65)*/
{38, 0,123,__LINE__, 0x400112a9, 0xa2107b28, 0x3fee6666, 0x6666666d, 0xbfe33333, 0x33333330},	/* 2.13411=f(0.95, -0.6)*/
{39, 0,123,__LINE__, 0x4000c3c5, 0xcc427e74, 0x3fee6666, 0x6666666d, 0xbfe19999, 0x99999996},	/* 2.09559=f(0.95, -0.55)*/
{40, 0,123,__LINE__, 0x40007133, 0xa1ba9242, 0x3fee6666, 0x6666666d, 0xbfdfffff, 0xfffffff9},	/* 2.05527=f(0.95, -0.5)*/
{40, 0,123,__LINE__, 0x40001af9, 0x288afa1a, 0x3fee6666, 0x6666666d, 0xbfdccccc, 0xccccccc6},	/* 2.01317=f(0.95, -0.45)*/
{38, 0,123,__LINE__, 0x3fff8254, 0x69548f10, 0x3fee6666, 0x6666666d, 0xbfd99999, 0x99999993},	/* 1.96932=f(0.95, -0.4)*/
{41, 0,123,__LINE__, 0x3ffec7d4, 0x939893a3, 0x3fee6666, 0x6666666d, 0xbfd66666, 0x66666660},	/* 1.92379=f(0.95, -0.35)*/
{37, 0,123,__LINE__, 0x3ffe06dc, 0x969f7431, 0x3fee6666, 0x6666666d, 0xbfd33333, 0x3333332d},	/* 1.87668=f(0.95, -0.3)*/
{40, 0,123,__LINE__, 0x3ffd3ffa, 0xcddcfb20, 0x3fee6666, 0x6666666d, 0xbfcfffff, 0xfffffff4},	/* 1.82812=f(0.95, -0.25)*/
{39, 0,123,__LINE__, 0x3ffc73e2, 0xe5e9c35b, 0x3fee6666, 0x6666666d, 0xbfc99999, 0x9999998e},	/* 1.77829=f(0.95, -0.2)*/
{38, 0,123,__LINE__, 0x3ffba36c, 0x4eafc4eb, 0x3fee6666, 0x6666666d, 0xbfc33333, 0x33333328},	/* 1.7274=f(0.95, -0.15)*/
{40, 0,123,__LINE__, 0x3ffacf8e, 0xc5e7c661, 0x3fee6666, 0x6666666d, 0xbfb99999, 0x99999983},	/* 1.67567=f(0.95, -0.1)*/
{41, 0,123,__LINE__, 0x3ff9f95c, 0xaac6432f, 0x3fee6666, 0x6666666d, 0xbfa99999, 0x9999996c},	/* 1.62338=f(0.95, -0.05)*/
{64, 0,123,__LINE__, 0x3ff921fb, 0x54442d17, 0x3fee6666, 0x6666666d, 0x3cb70000, 0x00000000},	/* 1.5708=f(0.95, 3.19189e-16)*/
{41, 0,123,__LINE__, 0x3ff84a99, 0xfdc21701, 0x3fee6666, 0x6666666d, 0x3fa99999, 0x999999c8},	/* 1.51821=f(0.95, 0.05)*/
{40, 0,123,__LINE__, 0x3ff77467, 0xe2a093cf, 0x3fee6666, 0x6666666d, 0x3fb99999, 0x999999b1},	/* 1.46592=f(0.95, 0.1)*/
{38, 0,123,__LINE__, 0x3ff6a08a, 0x59d89546, 0x3fee6666, 0x6666666d, 0x3fc33333, 0x3333333f},	/* 1.41419=f(0.95, 0.15)*/
{39, 0,123,__LINE__, 0x3ff5d013, 0xc29e96d6, 0x3fee6666, 0x6666666d, 0x3fc99999, 0x999999a6},	/* 1.3633=f(0.95, 0.2)*/
{40, 0,123,__LINE__, 0x3ff503fb, 0xdaab5f11, 0x3fee6666, 0x6666666d, 0x3fd00000, 0x00000006},	/* 1.31347=f(0.95, 0.25)*/
{37, 0,123,__LINE__, 0x3ff43d1a, 0x11e8e600, 0x3fee6666, 0x6666666d, 0x3fd33333, 0x33333339},	/* 1.26492=f(0.95, 0.3)*/
{41, 0,123,__LINE__, 0x3ff37c22, 0x14efc68e, 0x3fee6666, 0x6666666d, 0x3fd66666, 0x6666666c},	/* 1.21781=f(0.95, 0.35)*/
{38, 0,123,__LINE__, 0x3ff2c1a2, 0x3f33cb20, 0x3fee6666, 0x6666666d, 0x3fd99999, 0x9999999f},	/* 1.17227=f(0.95, 0.4)*/
{39, 0,123,__LINE__, 0x3ff20e04, 0x577265fd, 0x3fee6666, 0x6666666d, 0x3fdccccc, 0xccccccd2},	/* 1.12842=f(0.95, 0.45)*/
{39, 0,123,__LINE__, 0x3ff1618f, 0x651335ad, 0x3fee6666, 0x6666666d, 0x3fe00000, 0x00000003},	/* 1.08632=f(0.95, 0.5)*/
{38, 0,123,__LINE__, 0x3ff0bc6b, 0x10035d49, 0x3fee6666, 0x6666666d, 0x3fe19999, 0x9999999d},	/* 1.046=f(0.95, 0.55)*/
{37, 0,123,__LINE__, 0x3ff01ea3, 0x646763e0, 0x3fee6666, 0x6666666d, 0x3fe33333, 0x33333337},	/* 1.00748=f(0.95, 0.6)*/
{37, 0,123,__LINE__, 0x3fef105a, 0x2d416ce9, 0x3fee6666, 0x6666666d, 0x3fe4cccc, 0xccccccd1},	/* 0.970746=f(0.95, 0.65)*/
{39, 0,123,__LINE__, 0x3fedf1d3, 0x131bb6d2, 0x3fee6666, 0x6666666d, 0x3fe66666, 0x6666666b},	/* 0.93577=f(0.95, 0.7)*/
{38, 0,123,__LINE__, 0x3fece156, 0x277d182b, 0x3fee6666, 0x6666666d, 0x3fe80000, 0x00000005},	/* 0.902507=f(0.95, 0.75)*/
{37, 0,123,__LINE__, 0x3febde70, 0xe600d2ef, 0x3fee6666, 0x6666666d, 0x3fe99999, 0x9999999f},	/* 0.870903=f(0.95, 0.8)*/
{36, 0,123,__LINE__, 0x3feae8a0, 0x168fbb1a, 0x3fee6666, 0x6666666d, 0x3feb3333, 0x33333339},	/* 0.840897=f(0.95, 0.85)*/
{38, 0,123,__LINE__, 0x3fe9ff55, 0x55338c10, 0x3fee6666, 0x6666666d, 0x3feccccc, 0xccccccd3},	/* 0.812419=f(0.95, 0.9)*/
{64, 0,123,__LINE__, 0x3fe921fb, 0x54442d18, 0x3fee6666, 0x6666666d, 0x3fee6666, 0x6666666d},	/* 0.785398=f(0.95, 0.95)*/
{0}
};
void test_atan2f(m)   {run_vector_1(m,atan2f_vec,(char *)(atan2f),"atan2f","fff");   }	
