# `async-extensions`

[![License][License Badge]][License]
[![Version][Version Badge]][Package]
[![Downloads][Downloads Badge]][Package]
[![Discord][Discord Badge]][Discord]
[![Check][Check Badge]][Actions]

> *Asynchronous extensions.*

## Installing

**Python 3.7 or above is required.**

### pip

Installing the library with `pip` is quite simple:

```console
$ pip install async-extensions
```

Alternatively, the library can be installed from source:

```console
$ git clone https://github.com/nekitdev/async-extensions.git
$ cd async-extensions
$ python -m pip install .
```

### poetry

You can add `async-extensions` as a dependency with the following command:

```console
$ poetry add async-extensions
```

Or by directly specifying it in the configuration like so:

```toml
[tool.poetry.dependencies]
async-extensions = "^1.2.2"
```

Alternatively, you can add it directly from the source:

```toml
[tool.poetry.dependencies.async-extensions]
git = "https://github.com/nekitdev/async-extensions.git"
```

## Support

If you need support with the library, you can send an [email][Email]
or refer to the official [Discord server][Discord].

## Changelog

You can find the changelog [here][Changelog].

## Security Policy

You can find the Security Policy of `async-extensions` [here][Security].

## Contributing

If you are interested in contributing to `async-extensions`, make sure to take a look at the
[Contributing Guide][Contributing Guide], as well as the [Code of Conduct][Code of Conduct].

## License

`async-extensions` is licensed under the MIT License terms. See [License][License] for details.

[Email]: mailto:support@nekit.dev

[Discord]: https://nekit.dev/discord

[Actions]: https://github.com/nekitdev/async-extensions/actions

[Changelog]: https://github.com/nekitdev/async-extensions/blob/main/CHANGELOG.md
[Code of Conduct]: https://github.com/nekitdev/async-extensions/blob/main/CODE_OF_CONDUCT.md
[Contributing Guide]: https://github.com/nekitdev/async-extensions/blob/main/CONTRIBUTING.md
[Security]: https://github.com/nekitdev/async-extensions/blob/main/SECURITY.md

[License]: https://github.com/nekitdev/async-extensions/blob/main/LICENSE

[Package]: https://pypi.org/project/async-extensions

[Discord Badge]: https://img.shields.io/badge/chat-discord-5865f2
[License Badge]: https://img.shields.io/pypi/l/async-extensions
[Version Badge]: https://img.shields.io/pypi/v/async-extensions
[Downloads Badge]: https://img.shields.io/pypi/dm/async-extensions
[Check Badge]: https://github.com/nekitdev/async-extensions/workflows/check/badge.svg
