﻿"""invariant / constants.
"""
#Copyright (c) LiveAction, Inc. 2022. All rights reserved.
#Copyright (c) Savvius, Inc. 2013-2019. All rights reserved.
#Copyright (c) WildPackets, Inc. 2013-2014. All rights reserved.

from enum import IntEnum, unique


"""Adapter Types"""
ADAPTER_TYPE_UNKNOWN = 0
ADAPTER_TYPE_NIC = 1
ADAPTER_TYPE_FILE = 2
ADAPTER_TYPE_PLUGIN = 3

"""Authentication Values"""
AUTH_DEFAULT = "Defualt"
AUTH_THIRD_PARTY = "Thrid Party"
AUTH = [AUTH_DEFAULT, AUTH_THIRD_PARTY]
AUTH_CODE_DEFAULT = 0
AUTH_CODE_THRID_PARTY = 1

"""Capture Status Flags"""
CAPTURE_STATUS_IDLE = 0x0000
CAPTURE_STATUS_CAPTURING = 0x0001
CAPTURE_STATUS_START_ACTIVE = 0x0100
CAPTURE_STATUS_STOP_ACTIVE = 0x2000
CAPTURE_STATUS_WAIT_START = \
    CAPTURE_STATUS_START_ACTIVE & CAPTURE_STATUS_CAPTURING
CAPTURE_STATUS_CAPTURING_STOP_ACTIVE = \
    CAPTURE_STATUS_STOP_ACTIVE & CAPTURE_STATUS_CAPTURING
CAPTURE_STATUS_CAPTURING_START_STOP_ACTIVE = \
    CAPTURE_STATUS_START_ACTIVE & CAPTURE_STATUS_STOP_ACTIVE & \
    CAPTURE_STATUS_CAPTURING
CAPTURE_STATUS_IDLE_START_STOP_ACTIVE = \
    CAPTURE_STATUS_START_ACTIVE & CAPTURE_STATUS_STOP_ACTIVE

"""Capture Template Alarm Comparison Types """
ALARM_COMPARISON_TYPE_UNDEFINED = 0
ALARM_COMPARISON_TYPE_LESS_THAN = 1
ALARM_COMPARISON_TYPE_LESS_THAN_OR_EQAUL = 2
ALARM_COMPARISON_TYPE_GREATER_THAN = 3
ALARM_COMPARISON_TYPE_GREATER_THAN_OR_EQUAL = 4
ALARM_COMPARISON_TYPE_EQUAL = 5
ALARM_COMPARISON_TYPE_NOT_EQUAL = 6

"""CaptureTemplate Alaram Condition Types"""
ALARM_CONDITION_TYPE_UNDEFINED = 0
ALARM_CONDITION_TYPE_SUSPECT = 1
ALARM_CONDITION_TYPE_PROBLEM = 2
ALARM_CONDITION_TYPE_RESOLVE = 3

"""CaptureTemplate Alarm Track Types"""
ALARM_TRACK_TYPE_UNDEFINED = 0
ALARM_TRACK_TYPE_TOTAL = 1
ALARM_TRACK_TYPE_DIFFERENCE = 2
ALARM_TRACK_TYPE_DIFFERENCE_PER_SECOND = 3

"""OmniAddress Address Types"""
ADDRESS_TYPE_UNDEFINED = 0
ADDRESS_TYPE_ETHERNET = 10
ADDRESS_TYPE_TOKEN_RING = 11
ADDRESS_TYPE_LAP = 12
ADDRESS_TYPE_WIRELESS = 13
ADDRESS_TYPE_APPLETALK = 20
ADDRESS_TYPE_IP = 21
ADDRESS_TYPE_IPV4 = 21
ADDRESS_TYPE_DECNET = 22
ADDRESS_TYPE_OTHER = 23
ADDRESS_TYPE_IPV6 = 24
ADDRESS_TYPE_IPX = 25

"""Engine Kinds"""
ENGINE_KIND_UNKNOWN = 0
ENGINE_KIND_CAPTURE = 1
ENGINE_KIND_VIGIL = 2
ENGINE_KIND_INSIGHT = 3

"""Engine Issue Command Operations"""
@unique
class EngineOperation(IntEnum):
    GET = 0
    POST = 1
    PUT = 2
    DELETE = 3

"""Engine Issue Command Data Format"""
@unique
class EngineDataFormat(IntEnum):
    JSON = 0
    PLAIN = 1
    HTML = 2
    TAG_STREAM = 3

"""Database Operations"""
@unique
class DatabaseOperation(IntEnum):
    SYNC = 0
    INDEX = 1
    MAINTENANCE = 2

"""Capture Session Data Types"""
@unique
class SessionDataType(IntEnum):
    UTILIZATION_MBPS = 0
    PACKETS = 1
    MULTICAST = 2
    PACKET_SIZES = 3
    VLAN_MPLS = 4
    PROTOCOLS_MBPS = 5
    PROTOCOLS_PPS = 6
    CALL_QUALITY = 7
    CALL_UTILIZATION = 8
    WIRELESS_PACKETS = 9
    WIRELESS_RETRIES = 10
    APPLICATIONS_MBPS = 11
    APPLICATIONS_PPS = 12

"""Capture Session Statistics Types"""
@unique
class SessionStatisticsType(IntEnum):
    TOP_APPLICATIONS = 0
    TOP_IPV4_NODES = 1
    TOP_IPV6_NODES = 2
    TOP_PHYSICAL_NODES = 3
    TOP_PROTOCOLS = 4

"""Capture Packet Decode Format"""
DECODE_PLAIN_TEXT = 0
DECODE_HTML = 1
DECODE_TAG_STREAM = 2

"""Diagnostics Commands"""
@unique
class Diagnostics(IntEnum):
    DEFAULT = 0
    DRIVES = 1
    PROCESSES = 2
    RAID = 3
    SYSTEM_LOG = 4

"""Direction Labels"""
DIRECTION_TO_LEFT = 0
DIRECTION_TO_RIGHT = 1
DIRECTION_BOTH = 2

"""CaptureTemplate Filtering Modes"""
FILTER_MODE_ACCEPT_MATCHING_ANY = 1
FILTER_MODE_REJECT_MATCHING = 3
FILTER_MODE_ACCEPT_MATCHING_ALL = 4

"""FileInformation Flags"""
FILE_FLAGS_READONLY = 0x00000001  
FILE_FLAGS_HIDDEN = 0x00000002  
FILE_FLAGS_SYSTEM = 0x00000004  
FILE_FLAGS_DIRECTORY = 0x00000010  
FILE_FLAGS_ARCHIVE = 0x00000020  
FILE_FLAGS_DEVICE = 0x00000040  
FILE_FLAGS_NORMAL = 0x00000080  
FILE_FLAGS_TEMPORARY = 0x00000100  
FILE_FLAGS_SPARSE_FILE = 0x00000200  
FILE_FLAGS_REPARSE_POINT = 0x00000400  
FILE_FLAGS_COMPRESSED = 0x00000800  
FILE_FLAGS_OFFLINE = 0x00001000  
FILE_FLAGS_NOT_CONTENT_INDEXED = 0x00002000  
FILE_FLAGS_ENCRYPTED = 0x00004000  
FILE_FLAGS_VIRTUAL = 0x00010000  

"""ForensicSearch Status"""
FORENSIC_CLOSED = 0
FORENSIC_OPENING = 1
FORENSIC_COMPLETE = 2

"""OmniId formating flags"""
ID_FLAG_NONE = 0x00
ID_FLAG_NO_BRACES = 0x00
ID_FLAG_BRACES = 0x01
ID_FLAG_LOWERCASE = 0x02
ID_FLAG_UPPERCASE = 0x00

"""Statistic Limit Types"""
LIMIT_TYPE_NONE = 0
LIMIT_TYPE_PACKETS = 1
LIMIT_TYPE_BYTES = 2
LIMIT_TYPE_BUFFER = 3

"""MediaSpec Media Class"""
MEDIA_CLASS_NONE = 0
MEDIA_CLASS_PROTOCOL = 1
MEDIA_CLASS_ADDRESS = 2
MEDIA_CLASS_PORT = 3

"""MediaSpec Wireless Media Domains"""
MEDIA_DOMAIN_NONE = 0
MEDIA_DOMAIN_FCC = 1
MEDIA_DOMAIN_MKK = 2
MEDIA_DOMAIN_ETSU = 3

"""MediaSpec Media Specifications"""
MEDIA_SPEC_NULL = 0
MEDIA_SPEC_ETHERNET_PROTOCOL = 1
MEDIA_SPEC_LSAP = 2
MEDIA_SPEC_SNAP = 3
MEDIA_SPEC_LAP = 4
MEDIA_SPEC_DDP = 5
MEDIA_SPEC_MAC_CONTROL = 6
MEDIA_SPEC_PROTOSPEC_HIERARCHY = 7
MEDIA_SPEC_APPLICATION_ID = 8
MEDIA_SPEC_PROTO_SPEC = 9
MEDIA_SPEC_ETHERNET_ADDRESS = 10
MEDIA_SPEC_TOKENRING_ADDRESS = 11
MEDIA_SPEC_LAP_ADDRESS = 12
MEDIA_SPEC_WIRELESS_ADDRESS = 13
MEDIA_SPEC_APPLETALK_ADDRESS = 20
MEDIA_SPEC_IP_ADDRESS = 21
MEDIA_SPEC_DECNET_ADDRESS = 22
MEDIA_SPEC_OTHER_ADDRESS = 23
MEDIA_SPEC_IPV6_ADDRESS = 24
MEDIA_SPEC_IPX_ADDRESS = 25
MEDIA_SPEC_ERROR = 32
MEDIA_SPEC_AT_PORT = 33
MEDIA_SPEC_IP_PORT = 34
MEDIA_SPEC_NETWARE_PORT = 35
MEDIA_SPEC_TCP_PORT_PAIR = 36
MEDIA_SPEC_WAN_PPP_PROTOCOL = 37
MEDIA_SPEC_WAN_FRAMERELAY_PROTOCOL = 38
MEDIA_SPEC_WAN_X25_PROTOCOL = 39
MEDIA_SPEC_WAN_X25E_PROTOCOL = 40
MEDIA_SPEC_WAN_IPARS_PROTOCOL = 41
MEDIA_SPEC_WAN_U200_PROTOCOL = 42
MEDIA_SPEC_WAN_DLCI_ADDRESS = 43
MEDIA_SPEC_WAN_Q931_PROTOCOL = 44

MAX_PROTOSPEC_DEPTY = 32

"""MediaSpec Media Types"""
MEDIA_TYPE_802_3 = 0                # Ethernet (802.3)
MEDIA_TYPE_802_5 = 1                # Token Ring (802.5)
MEDIA_TYPE_FDDI = 2                 # FDDI
MEDIA_TYPE_WAN = 3                  # WAN
MEDIA_TYPE_LOCALTALK = 4            # LocalTalk
MEDIA_TYPE_DIX = 5                  # DEC/Intel/Xerox (DIX) Ethernet
MEDIA_TYPE_ARCNET_RAW = 6           # ARCNET (raw)
MEDIA_TYPE_ARCNET_878_2 = 7         # ARCNET (878.2)
MEDIA_TYPE_ATM = 8                  # ATM
MEDIA_TYPE_WIRELESS_WAN = 9         # Various wireless media
MEDIA_TYPE_IRDA = 10                # Infrared (IrDA)
MEDIA_TYPE_BPC = 11                 # Broadcast Architecture
MEDIA_TYPE_CO_WAN = 12              # Connection-oriented WAN
MEDIA_TYPE_1394 = 13                # IEEE 1394 (FireWire)
MEDIA_TYPE_MAX = 14                 # Defined the upper-bound, not a real type.

MEDIA_TYPE_NAMES = [
    'Ethernet',                     # MEDIA_TYPE_802_3
    'Token Ring',                   # MEDIA_TYPE_802_5
    'FDDI',                         # MEDIA_TYPE_FDDI
    'WAN',                          # MEDIA_TYPE_WAN
    'LocalTalk',                    # MEDIA_TYPE_LOCALTALK
    'DIX Ethernet',                 # MEDIA_TYPE_DIX
    'ARCNET Raw',                   # MEDIA_TYPE_ARCNET_RAW
    'ARCNET',                       # MEDIA_TYPE_ARCNET_878_2
    'ATM',                          # MEDIA_TYPE_ATM
    'Wireless WAN',                 # MEDIA_TYPE_WIRELESS_WAN
    'IrDA',                         # MEDIA_TYPE_IRDA
    'Broadcast Architecture',       # MEDIA_TYPE_BPC
    'Connection-oriented WAN',      # MEDIA_TYPE_CO_WAN
    'IEEE 1394 (FireWire)',         # MEDIA_TYPE_1394
    'Invalid Value'                 # MEDIA_TYPE_MAX
]

"""MediaSpec Media Sub-Types"""
MEDIA_SUB_TYPE_NATIVE = 0           # Native media specified by the media type.
MEDIA_SUB_TYPE_802_11_B = 1         # Wireless LAN network using 802.11b.
MEDIA_SUB_TYPE_802_11_A = 2         # Wireless LAN network using 802.11a.
MEDIA_SUB_TYPE_802_11_GENERAL = 3   # All possible 802.11 types: a b g combos
MEDIA_SUB_TYPE_WAN_PPP = 4          # PPP over a T1 or an E1
MEDIA_SUB_TYPE_WAN_FRAMERELAY = 5   # Frame Relay
MEDIA_SUB_TYPE_WAN_X25 = 6          # X.25
MEDIA_SUB_TYPE_WAN_X25E = 7         # X.25mod128
MEDIA_SUB_TYPE_WAN_IPARS = 8        # IPARS
MEDIA_SUB_TYPE_WAN_U200 = 9         # U200
MEDIA_SUB_TYPE_WAN_Q931 = 10        # Q.931
MEDIA_SUB_TYPE_MAX = 11             # Defined the upper-bound, not a real type.

MEDIA_SUB_TYPE_NAMES = [
    'Native',                       # MEDIA_SUB_TYPE_NATIVE
    '802.11b',                      # MEDIA_SUB_TYPE_802_11_B
    '802.11a',                      # MEDIA_SUB_TYPE_802_11_A
    '802.11',                       # MEDIA_SUB_TYPE_802_11_GENERAL
    'PPP',                          # MEDIA_SUB_TYPE_WAN_PPP
    'Frame Relay',                  # MEDIA_SUB_TYPE_WAN_FRAMERELAY
    'X.25',                         # MEDIA_SUB_TYPE_WAN_X25
    'X.25mod128',                   # MEDIA_SUB_TYPE_WAN_X25E
    'IPARS',                        # MEDIA_SUB_TYPE_WAN_IPARS
    'U200',                         # MEDIA_SUB_TYPE_WAN_U200
    'Q.931',                        # MEDIA_SUB_TYPE_WAN_Q931
    'Invalid Value'                 # MEDIA_SUB_TYPE_MAX
]

"""ForensicTemplate Filter Modes"""
MODE_ACCEPT_ALL = 0
MODE_ACCEPT_ANY_MATCHING = 1
MODE_REJECT_ALL = 2
MODE_REJECT_ANY_MATCHING = 3
MODE_ACCEPT_ALL_MATCHING = 4
MODE_REJECT_ALL_MATCHING = 5

"""NodeStatistic Column Indexes"""
NODE_COLUMN_BYTES_SENT = 0
NODE_COLUMN_BYTES_RECEIVED = 1
NODE_COLUMN_PACKETS_SENT = 2
NODE_COLUMN_PACKETS_RECEIVED = 3
NODE_COLUMN_BROADCAST_PACKETS = 4
NODE_COLUMN_BROADCAST_BYTES = 5
NODE_COLUMN_MULTICAST_PACKETS = 6
NODE_COLUMN_MULTICAST_BYTES = 7
NODE_COLUMN_MIN_SIZE_SENT = 8
NODE_COLUMN_MAX_SIZE_SENT = 9
NODE_COLUMN_MIN_SIZE_RECEIVED = 10
NODE_COLUMN_MAX_SIZE_RECEIVED = 11
NODE_COLUMN_FIRST_TIME_SENT = 12
NODE_COLUMN_LAST_TIME_SENT = 13
NODE_COLUMN_FIRST_TIME_RECEIVED = 14
NODE_COLUMN_LAST_TIME_RECEIVED = 15

"""Numeric Constants"""
BYTES_PER_KILOBYTE = 1024
BYTES_PER_MEGABYTE = 1024 * 1024
BYTES_PER_GIGABYTE = 1024 * 1024 * 1024
BYTES_PER_TERABYTE = 1024 * 1024 * 1024 * 1024
KILOBYTES_PER_MEGABYTE = 1024
KILOBYTES_PER_GIGABYTE = 1024 * 1024
KILOBYTES_PER_TERABYTE = 1024 * 1024 * 1024
MEGABYTES_PER_GAIGABYTE = 1024
MEGABYTES_PER_TERABYTE = 1024 * 1024

"""Time Constants"""
NANOSECONDS_PER_SECOND = 1000000000
MICROSECONDS_PER_SECOND = 1000000
MILLISECONDS_PER_SECOND = 1000
SECONDS_PER_MINUTE = 60
MINUTES_PER_HOUR = 60
SECONDS_PER_HOUR = SECONDS_PER_MINUTE * MINUTES_PER_HOUR
HOURS_PER_DAY = 24
MINUTES_PER_DAY = MINUTES_PER_HOUR * HOURS_PER_DAY
SECONDS_PER_DAY = SECONDS_PER_HOUR * HOURS_PER_DAY

"""OmniAPI Command Ids"""
OMNI_CONNECT = 1
OMNI_DISCONNECT = 2
OMNI_IS_CONNECTED = 3
OMNI_GET_STATS_CONTEXT = 4

"""OmniEngine Command Ids"""
OMNI_GET_VERSION = 100
OMNI_GET_STATUS = 110
OMNI_GET_CAPABILITIES = 111
OMNI_GET_LOG_MSGS = 112
OMNI_GET_ADAPTER_LIST = 113
OMNI_GET_CAPTURE_LIST = 114
OMNI_GET_CAPTURE_PROPS = 115
OMNI_CREATE_CAPTURE = 116
OMNI_DELETE_CAPTURES = 117
OMNI_GET_CAPTURE_OPTIONS = 118
OMNI_SET_CAPTURE_OPTIONS = 119
OMNI_START_CAPTURES = 120
OMNI_STOP_CAPTURES = 121
OMNI_CLEAR_CAPTURES = 122
OMNI_GET_STATS = 123
OMNI_TAKE_SNAPSHOT = 124
OMNI_GET_FILTERS = 125
OMNI_SET_FILTERS = 126
OMNI_GET_FILTER_CONFIG = 127
OMNI_SET_FILTER_CONFIG = 128
OMNI_GET_NOTIFICATIONS = 129
OMNI_SET_NOTIFICATIONS = 130
OMNI_GET_PACKETS = 131
OMNI_SELECT_RELATED = 132
OMNI_CLEAR_LOG = 133
OMNI_GET_FILE_LIST = 137
OMNI_GET_FILE = 138
OMNI_DELETE_FILES = 139
OMNI_SAVE_CAPTURE_FILE = 140
OMNI_GET_ALARMS = 141
OMNI_GET_HARDWARE_OPTIONS = 155
OMNI_SET_HARDWARE_OPTIONS = 156
OMNI_GET_ADAPTER_CONFIG = 157
OMNI_SET_ADAPTER_CONFIG = 158
OMNI_GET_GRAPH_TEMPLATES = 160
OMNI_MODIFY_FILTERS = 173
OMNI_EXPERT_EXECUTE_QUERY = 178
OMNI_PLUGIN_MESSAGE = 179
OMNI_GET_PACKETFILE_TABLE = 184
OMNI_CREATE_FILE_VIEW = 185
OMNI_DELETE_FILE_VIEW = 186
OMNI_DELETE_CAPTURE_SESSION = 187
OMNI_SYNC_DATABASE = 199
OMNI_GET_CAPTURE_SESSIONS = 201
OMNI_DELETE_ALL_CAPTURE_SESSIONS = 203
OMNI_GET_FILE_VIEW_LIST = 210
OMNI_SET_FILE = 213
OMNI_SET_ADAPTER_NAME = 216
OMNI_DELETE_ADAPTERS = 219
OMNI_RESTART_ENGINE = 508
OMNI_GET_ACL = 515
OMNI_SET_ACL = 516
OMNI_GET_INSTALLED_PLUGINS = 523
OMNI_GET_AUDIT_LOG = 710
OMNI_CLEAR_AUDIT_LOG = 711
OMNI_QUERY_AUDIT_LOG = 712
OMNI_GET_DIAGNOSTICS_INFO = 720
OMNI_DEBUG_COMMAND = 730

"""OmniScript Flags"""
OMNI_FLAG_NO_HTTPS_WARNINGS = 0x0001

"""Operating Systems"""
OPERATING_SYSTEM_UNKNOWN = None
OPERATING_SYSTEM_WINDOWS = "Windows"
OPERATING_SYSTEM_LINUX = "Linux"
OPERATING_SYSTEM_MAC = "Macintosh"

"""Forensic Search Options"""
OPTION_PACKETS = 0
OPTION_EXPERT = 1
OPTION_WEB = 2
OPTION_VOICE = 3
OPTION_BREAK_OUT_STATS = 4
OPTION_NETWORK_STATS = 5
OPTION_ERROR_STATS = 6
OPTION_NODE_STATS = 7
OPTION_PROTOCOL_STATS = 8
OPTION_CONVERSATION_STATS = 9
OPTION_SIZE_STATS = 10
OPTION_SUMMARY_STATS = 11
OPTION_TOP_TALKER_STATS = 12
OPTION_HISTORY_STATS = 13
OPTION_WIRELESS_CHANNEL_STATS = 14
OPTION_WIRELESS_NODE_STATS = 15

"""PatternNode Pattern Types"""
PATTERN_TYPE_ASCII = 0
PATTERN_TYPE_UNICODE = 1
PATTERN_TYPE_RAWDATA = 2    #Hex Data
PATTERN_TYPE_EBCDIC = 3
PATTERN_TYPE_REGEX = 4

"""OmniPort Port Types"""
PORT_TYPE_UNDEFINED = 0
PORT_TYPE_APPLETALK = 33
PORT_TYPE_IP = 34
PORT_TYPE_NETWARE = 35
PORT_TYPE_TCP_PAIR = 36

"""Property Bag"""
PROP_BAG_TRUE = '1'
PROP_BAG_FALSE = '0'

"""OmniEngine default port"""
DEFAULT_PORT = 443

"""Select Related Types"""
SELECT_BY_SOURCE = 0
SELECT_BY_DESTINATION = 1
SELECT_BY_SOURCE_DESTINATION = 2
SELECT_BY_PROTOCOL = 3
SELECT_BY_PORT = 4
SELECT_BY_CONVERSATION = 5
SELECT_BY_VLAN = 6
SELECT_BY_APPLICATION = 7

"""Notification Severity Types"""
SEVERITY_INFORMATIONAL = 0
SEVERITY_MINOR = 1
SEVERITY_MAJOR = 2
SEVERITY_SEVERE = 3

"""ForensicSearch Completion Status"""
STATUS_LOADING = 0
STATUS_PROCESSING = 1
STATUS_COMPLETE = 2

"""SummaryStatistic Data Types"""
SUMMARY_TYPE_NULL = 0
SUMMARY_TYPE_DATE = 1
SUMMARY_TYPE_TIME = 2
SUMMARY_TYPE_DURATION = 3
SUMMARY_TYPE_PACKETS = 4
SUMMARY_TYPE_BYTES = 5
SUMMARY_TYPE_PAIR = 6
SUMMARY_TYPE_INT = 7
SUMMARY_TYPE_DOUBLE = 8

"""Tap Timestamp Types"""
TAP_TIMESTAMPS_DEFAULT = 0
TAP_TIMESTAMPS_APCON = 1
TAP_TIMESTAMPS_IXIA_ANUE = 2
TAP_TIMESTAMPS_IXIA_NETOPTICS = 3
TAP_TIMESTAMPS_GIGAMON = 4

"""PeekTime Flags"""
TIME_FLAGS_NONE = 0x00
TIME_FLAGS_NANOSECONDS = 0x01

"""ValueNode Flags"""
VALUE_FLAG_NETWORK_BYTE_ORDER = 0x01
VALUE_FLAG_SIGNED = 0x02
VALUE_FLAG_HEX = 0x04
VALUE_FLAG_BINARY = 0x08

"""ValueNode Operators"""
VALUE_OPERATOR_EQUAL = 0x01
VALUE_OPERATOR_GREATER = 0x02
VALUE_OPERATOR_LESS = 0x04
VALUE_OPERATOR_NOT_EQUAL = VALUE_OPERATOR_GREATER | VALUE_OPERATOR_LESS
VALUE_OPERATOR_GREATER_EQUAL = VALUE_OPERATOR_EQUAL | VALUE_OPERATOR_GREATER
VALUE_OPERATOR_LESS_EQUAL = VALUE_OPERATOR_EQUAL | VALUE_OPERATOR_LESS

"""ValueNode Value Types"""
VALUE_TYPE_UNSIGNED_BYTE = 0
VALUE_TYPE_SIGNED_BYTE = 1
VALUE_TYPE_UNSIGNED_SHORT = 2
VALUE_TYPE_SIGNED_SHORT = 3
VALUE_TYPE_UNSIGNED_WORD = 4
VALUE_TYPE_SIGNED_WORD = 5
VALUE_TYPE_UNSIGNED_LONG = 6
VALUE_TYPE_SIGNED_LONG = 7

"""WanDirectionNode Directions"""
WAN_DIRECTION_UNDEFINED = 0
WAN_DIRECTION_TO_DTE = 1
WAN_DIRECTION_TO_DCE = 2

"""Wireless Hardware Options"""
WIRELESS_CONFIGURATION_SINGLE_CHANNEL = 0
WIRELESS_CONFIGURATION_CHANNEL_SCANNING = 3

"""WirelessNode Wireless Bands"""
WIRELESS_BAND_ALL = 0
WIRELESS_BAND_GENERIC = 1
WIRELESS_BAND_B = 2
WIRELESS_BAND_A = 3
WIRELESS_BAND_G = 4
WIRELESS_BAND_BG = WIRELESS_BAND_G
WIRELESS_BAND_N = 6
WIRELESS_BAND_TURBOA = 7
WIRELESS_BAND_TURBOG = 8
WIRELESS_BAND_SUPERG = 9
WIRELESS_BAND_LICENSEDA1MHZ = 100
WIRELESS_BAND_LICENSEDA5MHZ = 101
WIRELESS_BAND_LICENSEDA10MHZ = 102
WIRELESS_BAND_LICENSEDA15MHZ = 103
WIRELESS_BAND_LICENSEDA20MHZ = 104
WIRELESS_BAND_PRIMARYAC0 = 201
WIRELESS_BAND_PRIMARYAC1 = 202
WIRELESS_BAND_PRIMARYAC2 = 203
WIRELESS_BAND_PRIMARYAC3 = 204
WIRELESS_BAND_UNKNOWN5 = 205
WIRELESS_BAND_UNKNOWN6 = 206
WIRELESS_BAND_UNKNOWN7 = 207
WIRELESS_BAND_UNKNOWN8 = 208
WIRELESS_BAND_UNKNOWN9 = 209
WIRELESS_BAND_N20MHZ = 300
WIRELESS_BAND_N40MHZ = 301
WIRELESS_BAND_N40MHZLOW = 302
WIRELESS_BAND_N40MHZHIGH = 303

"""WirelessNode Wireless Data Masks"""
WIRELESS_DATA_MASK_CHANNEL = 0x00001
WIRELESS_DATA_MASK_DATA_RATE = 0x00002
WIRELESS_DATA_MASK_SIGNAL = 0x00004
WIRELESS_DATA_MASK_SIGNAL_DBM = 0x00008
WIRELESS_DATA_MASK_NOISE = 0x00010
WIRELESS_DATA_MASK_NOISE_DBM = 0x00020
WIRELESS_DATA_MASK_ENCRYPTION = 0x00040
WIRELESS_DATA_MASK_DECRYPTION_ERROR = 0x00080
WIRELESS_DATA_MASK_BSSID = 0x00100
WIRELESS_DATA_MASK_SIGNAL_DBM_1 = 0x00200
WIRELESS_DATA_MASK_SIGNAL_DBM_2 = 0x00400
WIRELESS_DATA_MASK_SIGNAL_DBM_3 = 0x00800
WIRELESS_DATA_MASK_NOISE_DBM_1 = 0x01000
WIRELESS_DATA_MASK_NOISE_DBM_2 = 0x02000
WIRELESS_DATA_MASK_NOISE_DBM_3 = 0x04000
WIRELESS_DATA_MASK_FLAGS = 0x08000

"""WirelessNode bit flags"""
WIRELESS_FLAG_20MHZ_LOWER = 0x00000001
WIRELESS_FLAG_20MHZ_UPPER = 0x00000002
WIRELESS_FLAG_40MHZ = 0x00000004
WIRELESS_FLAG_HALF_GI = 0x00000008
WIRELESS_FLAG_FULL_GI = 0x00000010
WIRELESS_FLAG_AMPDU = 0x00000020
WIRELESS_FLAG_VHT = 0x00000040
WIRELESS_FLAG_HTGREENFIELD = 0x00000080
WIRELESS_FLAG_MCS = 0x00000100
WIRELESS_FLAG_80MHZ = 0x00000200
WIRELESS_FLAG_160MHZ = 0x00000400
WIRELESS_FLAG_NSS = 0x00000800
WIRELESS_FLAG_MODE_2X2 = 0x00001000
WIRELESS_FLAG_MODE_2X3 = 0x00002000
WIRELESS_FLAG_CISCO_AC_2 = 0x00004000
WIRELESS_FLAG_CISCO_AC_3 = 0x00008000
