## REST API using Flask and Python [Air connections search]

### Project consist of:
* images - folder with images sources
* tests - folder with UnitTests, Pytest 
* app.py - main application resource
* db.py - resource for creation and for fill the database
* requirements.txt - file for install packages 
* list.csv - list of flights for database
* pytest.ini - pytest file
* config.cfg - file with config, flake8
### For using application you need to do:
1. Install Python 3.6 or higher
2. Install requirements
    * pip install -r requirements.txt
3. Create database for application
    * python db.py
```
$ python db.py

20 Record Transferred
```
4. There are 3 environments to choose from with different databases, choose one:
* testing - for local testing,
* dev - need to be configured manually
* prod - need to be configured manually

5. Run application
* python app.py testing
```
$ python app.py
 * Serving Flask app "app" (lazy loading)
 * Environment: production
 * Debug mode: on
 * Restarting with stat
 * Debugger is active!
 * Debugger PIN: 231-078-686
 * Running on http://127.0.0.1:5000/ (Press CTRL+C to quit)
```
5. Follow the link http://127.0.0.1:5000/

### Endpoints

|Endpoint |Request |Description |
|---------|--------|------------|
| /flight | GET | Get All Flights | 
| /flight/id | GET | Get Single Flight | 
| /flight | POST | Create a Flight | 
| /flight/id | PUT | Update a Flight | 
| /flight/id | DELETE | Delete Flight | 
| /flight/search | GET | Flight search between 2 cities | 


### Start Using:

##### 1. Get All Flights

```bash 
curl -X GET http://127.0.0.1:5000/flight

```
##### 2. Get Single Flight

```bash
curl -X GET http://127.0.0.1:5000/flight/10
```

##### 3. Create a Flight

```bash
curl -X POST -H "Content-Type: application/json" -d '{"source": "Barcelona", "destination": "Palma de Mallorca", "flight_company": "Vueling", "flight_number": "FR3745", "flight_time": "55m", "free_seats": "5", "price": "50$"}' http://127.0.0.1:5000/flight
```

##### 4. Update a Flight

```bash
curl -X PUT -H "Content-Type: application/json" -d '{"source": "Barcelona", "destination": "Palma de Mallorca", "flight_company": "Ryanair", "flight_number": "FR3785", "flight_time": "50m", "free_seats": "8", "price": "150$"}' http://127.0.0.1:5000/flight/11
```

##### 5. Delete Flight

```bash
curl -X DELETE http://127.0.0.1:5000/flight/11
```

##### 6. Flight search between 2 cities

```bash
http://127.0.0.1:5000/flight/search?c1=Milan&c2=Barcelona
```
### UnitTests:

 Download the project:
 * Follow the [link](http://gitlab-1914910442.us-west-2.elb.amazonaws.com/vverkholyak/python_app.git) 
 * Choose branche (feature/jdobc-255) 

#### - Using Linter

1. Install packages
```
pip install flake8
```
2. Run flake8
```
flake8
```
```
$ flake8
0
```
#### - Using PyTest

1. Install pytest from pip
```
pip install pytest
```
2. Run pytest
```
pytest -v
```
<img src = "images/img_1.png" width = 800>

#### - Coverage by PyTest:
1. Install packages
```
pip install pytest-cov
```
2. Run command
```
pytest --cov=. --cov-config='.coveragerc' -c='pytest.ini'
```

<img src = "images/img_2.png" width = 800>

### GitLab CI Multi-project:
* Flake8
* Pytest
* Coverage
* Build artifact
* Upload artifact to s3
* Deploy terraform code

<img src = "images/img_3.jpg" width = 1200>

### Logging for AWS CloudWatch
1.  How to run the application locally in the test environment ?
    * run applicatin: 
    ```
    python app.py testing
    ```
    * Log output file "air-connection-app.log" will be created automatically
2. То see the streaming of application logs in AWS you need to deploy the application in AWS using [terraform template](http://gitlab-1914910442.us-west-2.elb.amazonaws.com/vverkholyak/terraform-flight-app) and go to [CloudWatch logs](https://console.aws.amazon.com/cloudwatch/home?region=us-east-1#logsV2:log-groups/log-group/air-connection-app-log)