/*
 * Copyright © 2018 Eric Matthews,  Lesley Shannon
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Initial code developed under the supervision of Dr. Lesley Shannon,
 * Reconfigurable Computing Lab, Simon Fraser University.
 *
 * Author(s):
 *             Eric Matthews <ematthew@sfu.ca>
 */


interface local_memory_interface;
    logic[29:0] addr;
    logic en;
    logic[3:0] be;
    logic[31:0] data_in;
    logic[31:0] data_out;

    modport slave (input addr, en, be, data_in, output data_out);
    modport master (output addr, en, be, data_in, input data_out);

`ifdef __CVA5_FORMAL__
    modport formal (input addr, en, be, data_in, data_out);
`endif

endinterface



