"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
const cdk_nag_1 = require("cdk-nag");
const fs = require("fs-extra");
const Mustache = require("mustache");
const aws_prototyping_rules_1 = require("../src/packs/aws-prototyping-rules");
const renderedMarkdown = Mustache.render(fs
    .readFileSync(`${__dirname}/templates/markdown/awsprototypingrules-readme.mustache`)
    .toString(), {
    packName: aws_prototyping_rules_1.PackName,
    sections: [
        {
            sectionTitle: "Errors",
            rules: aws_prototyping_rules_1.RuleMetadata.filter((r) => r.level === cdk_nag_1.NagMessageLevel.ERROR),
        },
        {
            sectionTitle: "Warnings",
            rules: aws_prototyping_rules_1.RuleMetadata.filter((r) => r.level === cdk_nag_1.NagMessageLevel.WARN),
        },
    ],
});
fs.writeFileSync(`${__dirname}/../src/packs/README.md`, renderedMarkdown);
//# sourceMappingURL=data:application/json;base64,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