"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.RuleMetadata = exports.PackName = void 0;
/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
const cdk_nag_1 = require("cdk-nag");
/**
 * Pack name
 *
 */
exports.PackName = "AwsPrototyping";
/**
 * Rule metadata
 *
 */
exports.RuleMetadata = [
    {
        info: "The S3 bucket does not prohibit public access through bucket level settings.",
        explanation: "Keep sensitive data safe from unauthorized remote users by preventing public access at the bucket level.",
        level: cdk_nag_1.NagMessageLevel.ERROR,
        rule: cdk_nag_1.rules.s3.S3BucketLevelPublicAccessProhibited,
    },
    {
        info: "The S3 Bucket does not have object lock enabled.",
        explanation: "Because sensitive data can exist at rest in S3 buckets, enforce object locks at rest to help protect that data.",
        level: cdk_nag_1.NagMessageLevel.WARN,
        rule: cdk_nag_1.rules.s3.S3BucketDefaultLockEnabled,
    },
    {
        info: "The Lambda Function URL allows for public, unauthenticated access.",
        explanation: "AWS Lambda Function URLs allow you to invoke your function via a HTTPS end-point, setting the authentication to NONE allows anyone on the internet to invoke your function.",
        level: cdk_nag_1.NagMessageLevel.ERROR,
        rule: cdk_nag_1.rules.lambda.LambdaFunctionUrlAuth,
    },
];
//# sourceMappingURL=data:application/json;base64,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