"use strict";
/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
Object.defineProperty(exports, "__esModule", { value: true });
const assert_1 = require("@aws-cdk/assert");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const cdk_nag_1 = require("cdk-nag");
const aws_prototyping_1 = require("../src/packs/aws-prototyping");
const expectedWarnings = ["AwsPrototyping-S3BucketDefaultLockEnabled"];
const expectedErrors = [
    "AwsPrototyping-S3BucketLevelPublicAccessProhibited",
    "AwsPrototyping-LambdaFunctionUrlAuth",
];
describe("Check NagPack Details", () => {
    describe("AwsPrototyping-CDK", () => {
        class AwsPrototypingChecksExtended extends aws_prototyping_1.AwsPrototypingChecks {
            constructor() {
                super(...arguments);
                this.actualWarnings = new Array();
                this.actualErrors = new Array();
            }
            applyRule(params) {
                const ruleSuffix = params.ruleSuffixOverride
                    ? params.ruleSuffixOverride
                    : params.rule.name;
                const ruleId = `${pack.readPackName}-${ruleSuffix}`;
                if (params.level === cdk_nag_1.NagMessageLevel.WARN) {
                    this.actualWarnings.push(ruleId);
                }
                else {
                    this.actualErrors.push(ruleId);
                }
            }
        }
        const pack = new AwsPrototypingChecksExtended();
        test("Pack Name is correct", () => {
            expect(pack.readPackName).toStrictEqual("AwsPrototyping");
        });
        test("Pack contains expected warning and error rules", () => {
            jest.spyOn(pack, "applyRule");
            const stack = new aws_cdk_lib_1.Stack();
            aws_cdk_lib_1.Aspects.of(stack).add(pack);
            new aws_cdk_lib_1.CfnResource(stack, "rTestResource", { type: "foo" });
            assert_1.SynthUtils.synthesize(stack).messages;
            expect(pack.actualWarnings.sort()).toEqual(expectedWarnings.sort());
            expect(pack.actualErrors.sort()).toEqual(expectedErrors.sort());
        });
    });
});
//# sourceMappingURL=data:application/json;base64,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