/**
 * Utility module to work with strings.
 *
 * @module string
 */
export const fromCharCode: (...codes: number[]) => string;
export const fromCodePoint: (...codePoints: number[]) => string;
export function trimLeft(s: string): string;
export function fromCamelCase(s: string, separator: string): string;
export function utf8ByteLength(str: string): number;
export function _encodeUtf8Polyfill(str: string): Uint8Array;
export const utf8TextEncoder: TextEncoder;
export function _encodeUtf8Native(str: string): Uint8Array;
export function encodeUtf8(str: string): Uint8Array;
export function _decodeUtf8Polyfill(buf: Uint8Array): string;
export let utf8TextDecoder: TextDecoder | null;
export function _decodeUtf8Native(buf: Uint8Array): string;
export function decodeUtf8(buf: Uint8Array): string;
export function splice(str: string, index: number, remove: number, insert?: string): string;
//# sourceMappingURL=string.d.ts.map