"""
This type stub file was generated by pyright.
"""

import typing as t
from jsonschema.exceptions import ValidationError
from starlette.exceptions import HTTPException

"""
This module defines Exception classes used by Connexion to generate a proper response.
"""
class ConnexionException(Exception):
    """Base class for any exception thrown by the Connexion framework."""
    ...


class ResolverError(LookupError, ConnexionException):
    """Error raised at startup when the resolver cannot find a view function for an endpoint in
    your specification, and no ``resolver_error`` is configured."""
    ...


class InvalidSpecification(ValidationError, ConnexionException):
    """Error raised at startup when the provided specification cannot be validated."""
    ...


class MissingMiddleware(ConnexionException):
    """Error raised when you're leveraging behavior that depends on a specific middleware,
    and that middleware is not part of your middleware stack."""
    ...


class ProblemException(HTTPException, ConnexionException):
    """
    This exception holds arguments that are going to be passed to the
    `connexion.problem` function to generate a proper response.
    """
    def __init__(self, *, status=..., title=..., detail=..., type=..., instance=..., headers=..., ext=...) -> None:
        ...
    
    def to_problem(self): # -> ConnexionResponse:
        ...
    


class ClientProblem(ProblemException):
    """Base exception for any 4XX error. Returns 400 by default, however
    :class:`BadRequestProblem` should be preferred for 400 errors."""
    def __init__(self, status: int = ..., title: str = ..., *, detail: str = ...) -> None:
        ...
    


class BadRequestProblem(ClientProblem):
    """Problem class for 400 Bad Request errors."""
    def __init__(self, detail=...) -> None:
        ...
    


class ExtraParameterProblem(BadRequestProblem):
    """Problem class for 400 Bad Request errors raised when extra query or form parameters are
    detected and ``strict_validation`` is enabled."""
    def __init__(self, *, param_type: str, extra_params: t.Iterable[str]) -> None:
        ...
    


class TypeValidationError(BadRequestProblem):
    """Problem class for 400 Bad Request errors raised when path, query or form parameters with
    an incorrect type are detected."""
    def __init__(self, schema_type: str, parameter_type: str, parameter_name: str) -> None:
        ...
    


class Unauthorized(ClientProblem):
    """Problem class for 401 Unauthorized errors."""
    description = ...
    def __init__(self, detail: str = ...) -> None:
        ...
    


class OAuthProblem(Unauthorized):
    """Problem class for 401 Unauthorized errors raised when there is an issue with the received
    OAuth headers."""
    ...


class OAuthResponseProblem(OAuthProblem):
    """Problem class for 401 Unauthorized errors raised when improper OAuth credentials are
    retrieved from your OAuth server."""
    ...


class Forbidden(HTTPException):
    """Problem class for 403 Unauthorized errors."""
    def __init__(self, detail: t.Optional[str] = ...) -> None:
        ...
    


class OAuthScopeProblem(Forbidden):
    """Problem class for 403 Unauthorized errors raised because of OAuth scope validation errors."""
    def __init__(self, token_scopes: list, required_scopes: list) -> None:
        ...
    


class UnsupportedMediaTypeProblem(ClientProblem):
    """Problem class for 415 Unsupported Media Type errors which are raised when Connexion
    receives a request with an unsupported media type header."""
    def __init__(self, detail: t.Optional[str] = ...) -> None:
        ...
    


class ServerError(ProblemException):
    """Base exception for any 5XX error. Returns 500 by default, however
    :class:`InternalServerError` should be preferred for 500 errors."""
    def __init__(self, status: int = ..., title: t.Optional[str] = ..., *, detail: t.Optional[str] = ...) -> None:
        ...
    


class InternalServerError(ServerError):
    """Problem class for 500 Internal Server errors."""
    def __init__(self, detail: t.Optional[str] = ...) -> None:
        ...
    


class NonConformingResponse(InternalServerError):
    """Problem class for 500 Internal Server errors raised because of a returned response not
    matching the specification if response validation is enabled."""
    def __init__(self, detail: t.Optional[str] = ...) -> None:
        ...
    


class NonConformingResponseBody(NonConformingResponse):
    """Problem class for 500 Internal Server errors raised because of a returned response body not
    matching the specification if response validation is enabled."""
    def __init__(self, detail: t.Optional[str] = ...) -> None:
        ...
    


class NonConformingResponseHeaders(NonConformingResponse):
    """Problem class for 500 Internal Server errors raised because of a returned response headers
    not matching the specification if response validation is enabled."""
    def __init__(self, detail: t.Optional[str] = ...) -> None:
        ...
    


class ResolverProblem(ServerError):
    """Problem class for 501 Not Implemented errors raised when the resolver cannot find a view
    function to handle the incoming request."""
    def __init__(self, status: int = ..., *, detail: t.Optional[str] = ...) -> None:
        ...
    


