"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.HttpApi = exports.CorsHttpMethod = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const apigatewayv2_generated_1 = require("../apigatewayv2.generated");
const base_1 = require("../common/base");
const route_1 = require("./route");
const stage_1 = require("./stage");
const vpc_link_1 = require("./vpc-link");
/**
 * Supported CORS HTTP methods
 */
var CorsHttpMethod;
(function (CorsHttpMethod) {
    /** HTTP ANY */
    CorsHttpMethod["ANY"] = "*";
    /** HTTP DELETE */
    CorsHttpMethod["DELETE"] = "DELETE";
    /** HTTP GET */
    CorsHttpMethod["GET"] = "GET";
    /** HTTP HEAD */
    CorsHttpMethod["HEAD"] = "HEAD";
    /** HTTP OPTIONS */
    CorsHttpMethod["OPTIONS"] = "OPTIONS";
    /** HTTP PATCH */
    CorsHttpMethod["PATCH"] = "PATCH";
    /** HTTP POST */
    CorsHttpMethod["POST"] = "POST";
    /** HTTP PUT */
    CorsHttpMethod["PUT"] = "PUT";
})(CorsHttpMethod = exports.CorsHttpMethod || (exports.CorsHttpMethod = {}));
class HttpApiBase extends base_1.ApiBase {
    constructor() {
        super(...arguments);
        this.vpcLinks = {};
    }
    metricClientError(props) {
        return this.metric('4xx', { statistic: 'Sum', ...props });
    }
    metricServerError(props) {
        return this.metric('5xx', { statistic: 'Sum', ...props });
    }
    metricDataProcessed(props) {
        return this.metric('DataProcessed', { statistic: 'Sum', ...props });
    }
    metricCount(props) {
        return this.metric('Count', { statistic: 'SampleCount', ...props });
    }
    metricIntegrationLatency(props) {
        return this.metric('IntegrationLatency', props);
    }
    metricLatency(props) {
        return this.metric('Latency', props);
    }
    addVpcLink(options) {
        const { vpcId } = options.vpc;
        if (vpcId in this.vpcLinks) {
            return this.vpcLinks[vpcId];
        }
        const count = Object.keys(this.vpcLinks).length + 1;
        const vpcLink = new vpc_link_1.VpcLink(this, `VpcLink-${count}`, options);
        this.vpcLinks[vpcId] = vpcLink;
        return vpcLink;
    }
}
/**
 * Create a new API Gateway HTTP API endpoint.
 * @resource AWS::ApiGatewayV2::Api
 */
class HttpApi extends HttpApiBase {
    constructor(scope, id, props) {
        super(scope, id);
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apigatewayv2_HttpApiProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, HttpApi);
            }
            throw error;
        }
        this.httpApiName = props?.apiName ?? id;
        this.disableExecuteApiEndpoint = props?.disableExecuteApiEndpoint;
        let corsConfiguration;
        if (props?.corsPreflight) {
            const cors = props.corsPreflight;
            if (cors.allowOrigins && cors.allowOrigins.includes('*') && cors.allowCredentials) {
                throw new Error("CORS preflight - allowCredentials is not supported when allowOrigin is '*'");
            }
            const { allowCredentials, allowHeaders, allowMethods, allowOrigins, exposeHeaders, maxAge, } = props.corsPreflight;
            corsConfiguration = {
                allowCredentials,
                allowHeaders,
                allowMethods,
                allowOrigins,
                exposeHeaders,
                maxAge: maxAge?.toSeconds(),
            };
        }
        const apiProps = {
            name: this.httpApiName,
            protocolType: 'HTTP',
            corsConfiguration,
            description: props?.description,
            disableExecuteApiEndpoint: this.disableExecuteApiEndpoint,
        };
        const resource = new apigatewayv2_generated_1.CfnApi(this, 'Resource', apiProps);
        this.apiId = resource.ref;
        this.httpApiId = resource.ref;
        this._apiEndpoint = resource.attrApiEndpoint;
        this.defaultAuthorizer = props?.defaultAuthorizer;
        this.defaultAuthorizationScopes = props?.defaultAuthorizationScopes;
        if (props?.defaultIntegration) {
            new route_1.HttpRoute(this, 'DefaultRoute', {
                httpApi: this,
                routeKey: route_1.HttpRouteKey.DEFAULT,
                integration: props.defaultIntegration,
                authorizer: props.defaultAuthorizer,
                authorizationScopes: props.defaultAuthorizationScopes,
            });
        }
        if (props?.createDefaultStage === undefined || props.createDefaultStage === true) {
            this.defaultStage = new stage_1.HttpStage(this, 'DefaultStage', {
                httpApi: this,
                autoDeploy: true,
                domainMapping: props?.defaultDomainMapping,
            });
            // to ensure the domain is ready before creating the default stage
            if (props?.defaultDomainMapping) {
                this.defaultStage.node.addDependency(props.defaultDomainMapping.domainName);
            }
        }
        if (props?.createDefaultStage === false && props.defaultDomainMapping) {
            throw new Error('defaultDomainMapping not supported with createDefaultStage disabled');
        }
    }
    /**
     * Import an existing HTTP API into this CDK app.
     */
    static fromHttpApiAttributes(scope, id, attrs) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apigatewayv2_HttpApiAttributes(attrs);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.fromHttpApiAttributes);
            }
            throw error;
        }
        class Import extends HttpApiBase {
            constructor() {
                super(...arguments);
                this.apiId = attrs.httpApiId;
                this.httpApiId = attrs.httpApiId;
                this._apiEndpoint = attrs.apiEndpoint;
            }
            get apiEndpoint() {
                if (!this._apiEndpoint) {
                    throw new Error('apiEndpoint is not configured on the imported HttpApi.');
                }
                return this._apiEndpoint;
            }
        }
        return new Import(scope, id);
    }
    /**
     * Get the default endpoint for this API.
     */
    get apiEndpoint() {
        if (this.disableExecuteApiEndpoint) {
            throw new Error('apiEndpoint is not accessible when disableExecuteApiEndpoint is set to true.');
        }
        return this._apiEndpoint;
    }
    /**
     * Get the URL to the default stage of this API.
     * Returns `undefined` if `createDefaultStage` is unset.
     */
    get url() {
        return this.defaultStage ? this.defaultStage.url : undefined;
    }
    /**
     * Add a new stage.
     */
    addStage(id, options) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apigatewayv2_HttpStageOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.addStage);
            }
            throw error;
        }
        const stage = new stage_1.HttpStage(this, id, {
            httpApi: this,
            ...options,
        });
        return stage;
    }
    /**
     * Add multiple routes that uses the same configuration. The routes all go to the same path, but for different
     * methods.
     */
    addRoutes(options) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apigatewayv2_AddRoutesOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.addRoutes);
            }
            throw error;
        }
        const methods = options.methods ?? [route_1.HttpMethod.ANY];
        return methods.map((method) => {
            const authorizationScopes = options.authorizationScopes ?? this.defaultAuthorizationScopes;
            return new route_1.HttpRoute(this, `${method}${options.path}`, {
                httpApi: this,
                routeKey: route_1.HttpRouteKey.with(options.path, method),
                integration: options.integration,
                authorizer: options.authorizer ?? this.defaultAuthorizer,
                authorizationScopes,
            });
        });
    }
}
exports.HttpApi = HttpApi;
_a = JSII_RTTI_SYMBOL_1;
HttpApi[_a] = { fqn: "@aws-cdk/aws-apigatewayv2.HttpApi", version: "1.183.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiYXBpLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiYXBpLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7OztBQUdBLHNFQUFnRTtBQUVoRSx5Q0FBeUM7QUFJekMsbUNBQXFGO0FBQ3JGLG1DQUFrRTtBQUNsRSx5Q0FBbUQ7QUFrSW5EOztHQUVHO0FBQ0gsSUFBWSxjQWlCWDtBQWpCRCxXQUFZLGNBQWM7SUFDeEIsZUFBZTtJQUNmLDJCQUFTLENBQUE7SUFDVCxrQkFBa0I7SUFDbEIsbUNBQWlCLENBQUE7SUFDakIsZUFBZTtJQUNmLDZCQUFXLENBQUE7SUFDWCxnQkFBZ0I7SUFDaEIsK0JBQWEsQ0FBQTtJQUNiLG1CQUFtQjtJQUNuQixxQ0FBbUIsQ0FBQTtJQUNuQixpQkFBaUI7SUFDakIsaUNBQWUsQ0FBQTtJQUNmLGdCQUFnQjtJQUNoQiwrQkFBYSxDQUFBO0lBQ2IsZUFBZTtJQUNmLDZCQUFXLENBQUE7QUFDYixDQUFDLEVBakJXLGNBQWMsR0FBZCxzQkFBYyxLQUFkLHNCQUFjLFFBaUJ6QjtBQThFRCxNQUFlLFdBQVksU0FBUSxjQUFPO0lBQTFDOztRQUtVLGFBQVEsR0FBNEIsRUFBRSxDQUFDO0lBc0NqRCxDQUFDO0lBcENRLGlCQUFpQixDQUFDLEtBQXFCO1FBQzVDLE9BQU8sSUFBSSxDQUFDLE1BQU0sQ0FBQyxLQUFLLEVBQUUsRUFBRSxTQUFTLEVBQUUsS0FBSyxFQUFFLEdBQUcsS0FBSyxFQUFFLENBQUMsQ0FBQztLQUMzRDtJQUVNLGlCQUFpQixDQUFDLEtBQXFCO1FBQzVDLE9BQU8sSUFBSSxDQUFDLE1BQU0sQ0FBQyxLQUFLLEVBQUUsRUFBRSxTQUFTLEVBQUUsS0FBSyxFQUFFLEdBQUcsS0FBSyxFQUFFLENBQUMsQ0FBQztLQUMzRDtJQUVNLG1CQUFtQixDQUFDLEtBQXFCO1FBQzlDLE9BQU8sSUFBSSxDQUFDLE1BQU0sQ0FBQyxlQUFlLEVBQUUsRUFBRSxTQUFTLEVBQUUsS0FBSyxFQUFFLEdBQUcsS0FBSyxFQUFFLENBQUMsQ0FBQztLQUNyRTtJQUVNLFdBQVcsQ0FBQyxLQUFxQjtRQUN0QyxPQUFPLElBQUksQ0FBQyxNQUFNLENBQUMsT0FBTyxFQUFFLEVBQUUsU0FBUyxFQUFFLGFBQWEsRUFBRSxHQUFHLEtBQUssRUFBRSxDQUFDLENBQUM7S0FDckU7SUFFTSx3QkFBd0IsQ0FBQyxLQUFxQjtRQUNuRCxPQUFPLElBQUksQ0FBQyxNQUFNLENBQUMsb0JBQW9CLEVBQUUsS0FBSyxDQUFDLENBQUM7S0FDakQ7SUFFTSxhQUFhLENBQUMsS0FBcUI7UUFDeEMsT0FBTyxJQUFJLENBQUMsTUFBTSxDQUFDLFNBQVMsRUFBRSxLQUFLLENBQUMsQ0FBQztLQUN0QztJQUVNLFVBQVUsQ0FBQyxPQUFxQjtRQUNyQyxNQUFNLEVBQUUsS0FBSyxFQUFFLEdBQUcsT0FBTyxDQUFDLEdBQUcsQ0FBQztRQUM5QixJQUFJLEtBQUssSUFBSSxJQUFJLENBQUMsUUFBUSxFQUFFO1lBQzFCLE9BQU8sSUFBSSxDQUFDLFFBQVEsQ0FBQyxLQUFLLENBQUMsQ0FBQztTQUM3QjtRQUVELE1BQU0sS0FBSyxHQUFHLE1BQU0sQ0FBQyxJQUFJLENBQUMsSUFBSSxDQUFDLFFBQVEsQ0FBQyxDQUFDLE1BQU0sR0FBRyxDQUFDLENBQUM7UUFDcEQsTUFBTSxPQUFPLEdBQUcsSUFBSSxrQkFBTyxDQUFDLElBQUksRUFBRSxXQUFXLEtBQUssRUFBRSxFQUFFLE9BQU8sQ0FBQyxDQUFDO1FBQy9ELElBQUksQ0FBQyxRQUFRLENBQUMsS0FBSyxDQUFDLEdBQUcsT0FBTyxDQUFDO1FBRS9CLE9BQU8sT0FBTyxDQUFDO0tBQ2hCO0NBQ0Y7QUFpQkQ7OztHQUdHO0FBQ0gsTUFBYSxPQUFRLFNBQVEsV0FBVztJQTBDdEMsWUFBWSxLQUFnQixFQUFFLEVBQVUsRUFBRSxLQUFvQjtRQUM1RCxLQUFLLENBQUMsS0FBSyxFQUFFLEVBQUUsQ0FBQyxDQUFDOzs7Ozs7K0NBM0NSLE9BQU87Ozs7UUE2Q2hCLElBQUksQ0FBQyxXQUFXLEdBQUcsS0FBSyxFQUFFLE9BQU8sSUFBSSxFQUFFLENBQUM7UUFDeEMsSUFBSSxDQUFDLHlCQUF5QixHQUFHLEtBQUssRUFBRSx5QkFBeUIsQ0FBQztRQUVsRSxJQUFJLGlCQUFrRCxDQUFDO1FBQ3ZELElBQUksS0FBSyxFQUFFLGFBQWEsRUFBRTtZQUN4QixNQUFNLElBQUksR0FBRyxLQUFLLENBQUMsYUFBYSxDQUFDO1lBQ2pDLElBQUksSUFBSSxDQUFDLFlBQVksSUFBSSxJQUFJLENBQUMsWUFBWSxDQUFDLFFBQVEsQ0FBQyxHQUFHLENBQUMsSUFBSSxJQUFJLENBQUMsZ0JBQWdCLEVBQUU7Z0JBQ2pGLE1BQU0sSUFBSSxLQUFLLENBQUMsNEVBQTRFLENBQUMsQ0FBQzthQUMvRjtZQUNELE1BQU0sRUFDSixnQkFBZ0IsRUFDaEIsWUFBWSxFQUNaLFlBQVksRUFDWixZQUFZLEVBQ1osYUFBYSxFQUNiLE1BQU0sR0FDUCxHQUFHLEtBQUssQ0FBQyxhQUFhLENBQUM7WUFDeEIsaUJBQWlCLEdBQUc7Z0JBQ2xCLGdCQUFnQjtnQkFDaEIsWUFBWTtnQkFDWixZQUFZO2dCQUNaLFlBQVk7Z0JBQ1osYUFBYTtnQkFDYixNQUFNLEVBQUUsTUFBTSxFQUFFLFNBQVMsRUFBRTthQUM1QixDQUFDO1NBQ0g7UUFFRCxNQUFNLFFBQVEsR0FBZ0I7WUFDNUIsSUFBSSxFQUFFLElBQUksQ0FBQyxXQUFXO1lBQ3RCLFlBQVksRUFBRSxNQUFNO1lBQ3BCLGlCQUFpQjtZQUNqQixXQUFXLEVBQUUsS0FBSyxFQUFFLFdBQVc7WUFDL0IseUJBQXlCLEVBQUUsSUFBSSxDQUFDLHlCQUF5QjtTQUMxRCxDQUFDO1FBRUYsTUFBTSxRQUFRLEdBQUcsSUFBSSwrQkFBTSxDQUFDLElBQUksRUFBRSxVQUFVLEVBQUUsUUFBUSxDQUFDLENBQUM7UUFDeEQsSUFBSSxDQUFDLEtBQUssR0FBRyxRQUFRLENBQUMsR0FBRyxDQUFDO1FBQzFCLElBQUksQ0FBQyxTQUFTLEdBQUcsUUFBUSxDQUFDLEdBQUcsQ0FBQztRQUM5QixJQUFJLENBQUMsWUFBWSxHQUFHLFFBQVEsQ0FBQyxlQUFlLENBQUM7UUFDN0MsSUFBSSxDQUFDLGlCQUFpQixHQUFHLEtBQUssRUFBRSxpQkFBaUIsQ0FBQztRQUNsRCxJQUFJLENBQUMsMEJBQTBCLEdBQUcsS0FBSyxFQUFFLDBCQUEwQixDQUFDO1FBRXBFLElBQUksS0FBSyxFQUFFLGtCQUFrQixFQUFFO1lBQzdCLElBQUksaUJBQVMsQ0FBQyxJQUFJLEVBQUUsY0FBYyxFQUFFO2dCQUNsQyxPQUFPLEVBQUUsSUFBSTtnQkFDYixRQUFRLEVBQUUsb0JBQVksQ0FBQyxPQUFPO2dCQUM5QixXQUFXLEVBQUUsS0FBSyxDQUFDLGtCQUFrQjtnQkFDckMsVUFBVSxFQUFFLEtBQUssQ0FBQyxpQkFBaUI7Z0JBQ25DLG1CQUFtQixFQUFFLEtBQUssQ0FBQywwQkFBMEI7YUFDdEQsQ0FBQyxDQUFDO1NBQ0o7UUFFRCxJQUFJLEtBQUssRUFBRSxrQkFBa0IsS0FBSyxTQUFTLElBQUksS0FBSyxDQUFDLGtCQUFrQixLQUFLLElBQUksRUFBRTtZQUNoRixJQUFJLENBQUMsWUFBWSxHQUFHLElBQUksaUJBQVMsQ0FBQyxJQUFJLEVBQUUsY0FBYyxFQUFFO2dCQUN0RCxPQUFPLEVBQUUsSUFBSTtnQkFDYixVQUFVLEVBQUUsSUFBSTtnQkFDaEIsYUFBYSxFQUFFLEtBQUssRUFBRSxvQkFBb0I7YUFDM0MsQ0FBQyxDQUFDO1lBRUgsa0VBQWtFO1lBQ2xFLElBQUksS0FBSyxFQUFFLG9CQUFvQixFQUFFO2dCQUMvQixJQUFJLENBQUMsWUFBWSxDQUFDLElBQUksQ0FBQyxhQUFhLENBQUMsS0FBSyxDQUFDLG9CQUFvQixDQUFDLFVBQVUsQ0FBQyxDQUFDO2FBQzdFO1NBQ0Y7UUFFRCxJQUFJLEtBQUssRUFBRSxrQkFBa0IsS0FBSyxLQUFLLElBQUksS0FBSyxDQUFDLG9CQUFvQixFQUFFO1lBQ3JFLE1BQU0sSUFBSSxLQUFLLENBQUMscUVBQXFFLENBQ3BGLENBQUM7U0FDSDtLQUNGO0lBakhEOztPQUVHO0lBQ0ksTUFBTSxDQUFDLHFCQUFxQixDQUFDLEtBQWdCLEVBQUUsRUFBVSxFQUFFLEtBQXdCOzs7Ozs7Ozs7O1FBQ3hGLE1BQU0sTUFBTyxTQUFRLFdBQVc7WUFBaEM7O2dCQUNrQixVQUFLLEdBQUcsS0FBSyxDQUFDLFNBQVMsQ0FBQztnQkFDeEIsY0FBUyxHQUFHLEtBQUssQ0FBQyxTQUFTLENBQUM7Z0JBQzNCLGlCQUFZLEdBQUcsS0FBSyxDQUFDLFdBQVcsQ0FBQztZQVFwRCxDQUFDO1lBTkMsSUFBVyxXQUFXO2dCQUNwQixJQUFJLENBQUMsSUFBSSxDQUFDLFlBQVksRUFBRTtvQkFDdEIsTUFBTSxJQUFJLEtBQUssQ0FBQyx3REFBd0QsQ0FBQyxDQUFDO2lCQUMzRTtnQkFDRCxPQUFPLElBQUksQ0FBQyxZQUFZLENBQUM7WUFDM0IsQ0FBQztTQUNGO1FBQ0QsT0FBTyxJQUFJLE1BQU0sQ0FBQyxLQUFLLEVBQUUsRUFBRSxDQUFDLENBQUM7S0FDOUI7SUFrR0Q7O09BRUc7SUFDSCxJQUFXLFdBQVc7UUFDcEIsSUFBSSxJQUFJLENBQUMseUJBQXlCLEVBQUU7WUFDbEMsTUFBTSxJQUFJLEtBQUssQ0FBQyw4RUFBOEUsQ0FBQyxDQUFDO1NBQ2pHO1FBQ0QsT0FBTyxJQUFJLENBQUMsWUFBWSxDQUFDO0tBQzFCO0lBRUQ7OztPQUdHO0lBQ0gsSUFBVyxHQUFHO1FBQ1osT0FBTyxJQUFJLENBQUMsWUFBWSxDQUFDLENBQUMsQ0FBQyxJQUFJLENBQUMsWUFBWSxDQUFDLEdBQUcsQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDO0tBQzlEO0lBRUQ7O09BRUc7SUFDSSxRQUFRLENBQUMsRUFBVSxFQUFFLE9BQXlCOzs7Ozs7Ozs7O1FBQ25ELE1BQU0sS0FBSyxHQUFHLElBQUksaUJBQVMsQ0FBQyxJQUFJLEVBQUUsRUFBRSxFQUFFO1lBQ3BDLE9BQU8sRUFBRSxJQUFJO1lBQ2IsR0FBRyxPQUFPO1NBQ1gsQ0FBQyxDQUFDO1FBQ0gsT0FBTyxLQUFLLENBQUM7S0FDZDtJQUVEOzs7T0FHRztJQUNJLFNBQVMsQ0FBQyxPQUF5Qjs7Ozs7Ozs7OztRQUN4QyxNQUFNLE9BQU8sR0FBRyxPQUFPLENBQUMsT0FBTyxJQUFJLENBQUMsa0JBQVUsQ0FBQyxHQUFHLENBQUMsQ0FBQztRQUNwRCxPQUFPLE9BQU8sQ0FBQyxHQUFHLENBQUMsQ0FBQyxNQUFNLEVBQUUsRUFBRTtZQUM1QixNQUFNLG1CQUFtQixHQUFHLE9BQU8sQ0FBQyxtQkFBbUIsSUFBSSxJQUFJLENBQUMsMEJBQTBCLENBQUM7WUFFM0YsT0FBTyxJQUFJLGlCQUFTLENBQUMsSUFBSSxFQUFFLEdBQUcsTUFBTSxHQUFHLE9BQU8sQ0FBQyxJQUFJLEVBQUUsRUFBRTtnQkFDckQsT0FBTyxFQUFFLElBQUk7Z0JBQ2IsUUFBUSxFQUFFLG9CQUFZLENBQUMsSUFBSSxDQUFDLE9BQU8sQ0FBQyxJQUFJLEVBQUUsTUFBTSxDQUFDO2dCQUNqRCxXQUFXLEVBQUUsT0FBTyxDQUFDLFdBQVc7Z0JBQ2hDLFVBQVUsRUFBRSxPQUFPLENBQUMsVUFBVSxJQUFJLElBQUksQ0FBQyxpQkFBaUI7Z0JBQ3hELG1CQUFtQjthQUNwQixDQUFDLENBQUM7UUFDTCxDQUFDLENBQUMsQ0FBQztLQUNKOztBQWxLSCwwQkFtS0MiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBNZXRyaWMsIE1ldHJpY09wdGlvbnMgfSBmcm9tICdAYXdzLWNkay9hd3MtY2xvdWR3YXRjaCc7XG5pbXBvcnQgeyBEdXJhdGlvbiB9IGZyb20gJ0Bhd3MtY2RrL2NvcmUnO1xuaW1wb3J0IHsgQ29uc3RydWN0IH0gZnJvbSAnY29uc3RydWN0cyc7XG5pbXBvcnQgeyBDZm5BcGksIENmbkFwaVByb3BzIH0gZnJvbSAnLi4vYXBpZ2F0ZXdheXYyLmdlbmVyYXRlZCc7XG5pbXBvcnQgeyBJQXBpIH0gZnJvbSAnLi4vY29tbW9uL2FwaSc7XG5pbXBvcnQgeyBBcGlCYXNlIH0gZnJvbSAnLi4vY29tbW9uL2Jhc2UnO1xuaW1wb3J0IHsgRG9tYWluTWFwcGluZ09wdGlvbnMgfSBmcm9tICcuLi9jb21tb24vc3RhZ2UnO1xuaW1wb3J0IHsgSUh0dHBSb3V0ZUF1dGhvcml6ZXIgfSBmcm9tICcuL2F1dGhvcml6ZXInO1xuaW1wb3J0IHsgSHR0cFJvdXRlSW50ZWdyYXRpb24gfSBmcm9tICcuL2ludGVncmF0aW9uJztcbmltcG9ydCB7IEJhdGNoSHR0cFJvdXRlT3B0aW9ucywgSHR0cE1ldGhvZCwgSHR0cFJvdXRlLCBIdHRwUm91dGVLZXkgfSBmcm9tICcuL3JvdXRlJztcbmltcG9ydCB7IElIdHRwU3RhZ2UsIEh0dHBTdGFnZSwgSHR0cFN0YWdlT3B0aW9ucyB9IGZyb20gJy4vc3RhZ2UnO1xuaW1wb3J0IHsgVnBjTGluaywgVnBjTGlua1Byb3BzIH0gZnJvbSAnLi92cGMtbGluayc7XG5cbi8qKlxuICogUmVwcmVzZW50cyBhbiBIVFRQIEFQSVxuICovXG5leHBvcnQgaW50ZXJmYWNlIElIdHRwQXBpIGV4dGVuZHMgSUFwaSB7XG4gIC8qKlxuICAgKiBUaGUgaWRlbnRpZmllciBvZiB0aGlzIEFQSSBHYXRld2F5IEhUVFAgQVBJLlxuICAgKiBAYXR0cmlidXRlXG4gICAqIEBkZXByZWNhdGVkIC0gdXNlIGFwaUlkIGluc3RlYWRcbiAgICovXG4gIHJlYWRvbmx5IGh0dHBBcGlJZDogc3RyaW5nO1xuXG4gIC8qKlxuICAgKiBNZXRyaWMgZm9yIHRoZSBudW1iZXIgb2YgY2xpZW50LXNpZGUgZXJyb3JzIGNhcHR1cmVkIGluIGEgZ2l2ZW4gcGVyaW9kLlxuICAgKlxuICAgKiBAZGVmYXVsdCAtIHN1bSBvdmVyIDUgbWludXRlc1xuICAgKi9cbiAgbWV0cmljQ2xpZW50RXJyb3IocHJvcHM/OiBNZXRyaWNPcHRpb25zKTogTWV0cmljO1xuXG4gIC8qKlxuICAgKiBNZXRyaWMgZm9yIHRoZSBudW1iZXIgb2Ygc2VydmVyLXNpZGUgZXJyb3JzIGNhcHR1cmVkIGluIGEgZ2l2ZW4gcGVyaW9kLlxuICAgKlxuICAgKiBAZGVmYXVsdCAtIHN1bSBvdmVyIDUgbWludXRlc1xuICAgKi9cbiAgbWV0cmljU2VydmVyRXJyb3IocHJvcHM/OiBNZXRyaWNPcHRpb25zKTogTWV0cmljO1xuXG4gIC8qKlxuICAgKiBNZXRyaWMgZm9yIHRoZSBhbW91bnQgb2YgZGF0YSBwcm9jZXNzZWQgaW4gYnl0ZXMuXG4gICAqXG4gICAqIEBkZWZhdWx0IC0gc3VtIG92ZXIgNSBtaW51dGVzXG4gICAqL1xuICBtZXRyaWNEYXRhUHJvY2Vzc2VkKHByb3BzPzogTWV0cmljT3B0aW9ucyk6IE1ldHJpYztcblxuICAvKipcbiAgICogTWV0cmljIGZvciB0aGUgdG90YWwgbnVtYmVyIEFQSSByZXF1ZXN0cyBpbiBhIGdpdmVuIHBlcmlvZC5cbiAgICpcbiAgICogQGRlZmF1bHQgLSBTYW1wbGVDb3VudCBvdmVyIDUgbWludXRlc1xuICAgKi9cbiAgbWV0cmljQ291bnQocHJvcHM/OiBNZXRyaWNPcHRpb25zKTogTWV0cmljO1xuXG4gIC8qKlxuICAgKiBNZXRyaWMgZm9yIHRoZSB0aW1lIGJldHdlZW4gd2hlbiBBUEkgR2F0ZXdheSByZWxheXMgYSByZXF1ZXN0IHRvIHRoZSBiYWNrZW5kXG4gICAqIGFuZCB3aGVuIGl0IHJlY2VpdmVzIGEgcmVzcG9uc2UgZnJvbSB0aGUgYmFja2VuZC5cbiAgICpcbiAgICogQGRlZmF1bHQgLSBubyBzdGF0aXN0aWNcbiAgICovXG4gIG1ldHJpY0ludGVncmF0aW9uTGF0ZW5jeShwcm9wcz86IE1ldHJpY09wdGlvbnMpOiBNZXRyaWM7XG5cbiAgLyoqXG4gICAqIFRoZSB0aW1lIGJldHdlZW4gd2hlbiBBUEkgR2F0ZXdheSByZWNlaXZlcyBhIHJlcXVlc3QgZnJvbSBhIGNsaWVudFxuICAgKiBhbmQgd2hlbiBpdCByZXR1cm5zIGEgcmVzcG9uc2UgdG8gdGhlIGNsaWVudC5cbiAgICogVGhlIGxhdGVuY3kgaW5jbHVkZXMgdGhlIGludGVncmF0aW9uIGxhdGVuY3kgYW5kIG90aGVyIEFQSSBHYXRld2F5IG92ZXJoZWFkLlxuICAgKlxuICAgKiBAZGVmYXVsdCAtIG5vIHN0YXRpc3RpY1xuICAgKi9cbiAgbWV0cmljTGF0ZW5jeShwcm9wcz86IE1ldHJpY09wdGlvbnMpOiBNZXRyaWM7XG5cbiAgLyoqXG4gICAqIEFkZCBhIG5ldyBWcGNMaW5rXG4gICAqL1xuICBhZGRWcGNMaW5rKG9wdGlvbnM6IFZwY0xpbmtQcm9wcyk6IFZwY0xpbmtcbn1cblxuLyoqXG4gKiBQcm9wZXJ0aWVzIHRvIGluaXRpYWxpemUgYW4gaW5zdGFuY2Ugb2YgYEh0dHBBcGlgLlxuICovXG5leHBvcnQgaW50ZXJmYWNlIEh0dHBBcGlQcm9wcyB7XG4gIC8qKlxuICAgKiBOYW1lIGZvciB0aGUgSFRUUCBBUEkgcmVzb3VyY2VcbiAgICogQGRlZmF1bHQgLSBpZCBvZiB0aGUgSHR0cEFwaSBjb25zdHJ1Y3QuXG4gICAqL1xuICByZWFkb25seSBhcGlOYW1lPzogc3RyaW5nO1xuXG4gIC8qKlxuICAgKiBUaGUgZGVzY3JpcHRpb24gb2YgdGhlIEFQSS5cbiAgICogQGRlZmF1bHQgLSBub25lXG4gICAqL1xuICByZWFkb25seSBkZXNjcmlwdGlvbj86IHN0cmluZztcblxuICAvKipcbiAgICogQW4gaW50ZWdyYXRpb24gdGhhdCB3aWxsIGJlIGNvbmZpZ3VyZWQgb24gdGhlIGNhdGNoLWFsbCByb3V0ZSAoJGRlZmF1bHQpLlxuICAgKiBAZGVmYXVsdCAtIG5vbmVcbiAgICovXG4gIHJlYWRvbmx5IGRlZmF1bHRJbnRlZ3JhdGlvbj86IEh0dHBSb3V0ZUludGVncmF0aW9uO1xuXG4gIC8qKlxuICAgKiBXaGV0aGVyIGEgZGVmYXVsdCBzdGFnZSBhbmQgZGVwbG95bWVudCBzaG91bGQgYmUgYXV0b21hdGljYWxseSBjcmVhdGVkLlxuICAgKiBAZGVmYXVsdCB0cnVlXG4gICAqL1xuICByZWFkb25seSBjcmVhdGVEZWZhdWx0U3RhZ2U/OiBib29sZWFuO1xuXG4gIC8qKlxuICAgKiBTcGVjaWZpZXMgYSBDT1JTIGNvbmZpZ3VyYXRpb24gZm9yIGFuIEFQSS5cbiAgICogQHNlZSBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vYXBpZ2F0ZXdheS9sYXRlc3QvZGV2ZWxvcGVyZ3VpZGUvaHR0cC1hcGktY29ycy5odG1sXG4gICAqIEBkZWZhdWx0IC0gQ09SUyBkaXNhYmxlZC5cbiAgICovXG4gIHJlYWRvbmx5IGNvcnNQcmVmbGlnaHQ/OiBDb3JzUHJlZmxpZ2h0T3B0aW9ucztcblxuICAvKipcbiAgICogQ29uZmlndXJlIGEgY3VzdG9tIGRvbWFpbiB3aXRoIHRoZSBBUEkgbWFwcGluZyByZXNvdXJjZSB0byB0aGUgSFRUUCBBUElcbiAgICpcbiAgICogQGRlZmF1bHQgLSBubyBkZWZhdWx0IGRvbWFpbiBtYXBwaW5nIGNvbmZpZ3VyZWQuIG1lYW5pbmdsZXNzIGlmIGBjcmVhdGVEZWZhdWx0U3RhZ2VgIGlzIGBmYWxzZWAuXG4gICAqL1xuICByZWFkb25seSBkZWZhdWx0RG9tYWluTWFwcGluZz86IERvbWFpbk1hcHBpbmdPcHRpb25zO1xuXG4gIC8qKlxuICAgKiBTcGVjaWZpZXMgd2hldGhlciBjbGllbnRzIGNhbiBpbnZva2UgeW91ciBBUEkgdXNpbmcgdGhlIGRlZmF1bHQgZW5kcG9pbnQuXG4gICAqIEJ5IGRlZmF1bHQsIGNsaWVudHMgY2FuIGludm9rZSB5b3VyIEFQSSB3aXRoIHRoZSBkZWZhdWx0XG4gICAqIGBodHRwczovL3thcGlfaWR9LmV4ZWN1dGUtYXBpLntyZWdpb259LmFtYXpvbmF3cy5jb21gIGVuZHBvaW50LiBFbmFibGVcbiAgICogdGhpcyBpZiB5b3Ugd291bGQgbGlrZSBjbGllbnRzIHRvIHVzZSB5b3VyIGN1c3RvbSBkb21haW4gbmFtZS5cbiAgICogQGRlZmF1bHQgZmFsc2UgZXhlY3V0ZS1hcGkgZW5kcG9pbnQgZW5hYmxlZC5cbiAgICovXG4gIHJlYWRvbmx5IGRpc2FibGVFeGVjdXRlQXBpRW5kcG9pbnQ/OiBib29sZWFuO1xuXG4gIC8qKlxuICAgKiBEZWZhdWx0IEF1dGhvcml6ZXIgdG8gYXBwbGllZCB0byBhbGwgcm91dGVzIGluIHRoZSBnYXRld2F5XG4gICAqXG4gICAqIEBkZWZhdWx0IC0gTm8gYXV0aG9yaXplclxuICAgKi9cbiAgcmVhZG9ubHkgZGVmYXVsdEF1dGhvcml6ZXI/OiBJSHR0cFJvdXRlQXV0aG9yaXplcjtcblxuICAvKipcbiAgICogRGVmYXVsdCBPSURDIHNjb3BlcyBhdHRhY2hlZCB0byBhbGwgcm91dGVzIGluIHRoZSBnYXRld2F5LCB1bmxlc3MgZXhwbGljaXRseSBjb25maWd1cmVkIG9uIHRoZSByb3V0ZS5cbiAgICpcbiAgICogQGRlZmF1bHQgLSBubyBkZWZhdWx0IGF1dGhvcml6YXRpb24gc2NvcGVzXG4gICAqL1xuICByZWFkb25seSBkZWZhdWx0QXV0aG9yaXphdGlvblNjb3Blcz86IHN0cmluZ1tdO1xufVxuXG4vKipcbiAqIFN1cHBvcnRlZCBDT1JTIEhUVFAgbWV0aG9kc1xuICovXG5leHBvcnQgZW51bSBDb3JzSHR0cE1ldGhvZHtcbiAgLyoqIEhUVFAgQU5ZICovXG4gIEFOWSA9ICcqJyxcbiAgLyoqIEhUVFAgREVMRVRFICovXG4gIERFTEVURSA9ICdERUxFVEUnLFxuICAvKiogSFRUUCBHRVQgKi9cbiAgR0VUID0gJ0dFVCcsXG4gIC8qKiBIVFRQIEhFQUQgKi9cbiAgSEVBRCA9ICdIRUFEJyxcbiAgLyoqIEhUVFAgT1BUSU9OUyAqL1xuICBPUFRJT05TID0gJ09QVElPTlMnLFxuICAvKiogSFRUUCBQQVRDSCAqL1xuICBQQVRDSCA9ICdQQVRDSCcsXG4gIC8qKiBIVFRQIFBPU1QgKi9cbiAgUE9TVCA9ICdQT1NUJyxcbiAgLyoqIEhUVFAgUFVUICovXG4gIFBVVCA9ICdQVVQnLFxufVxuXG4vKipcbiAqIE9wdGlvbnMgZm9yIHRoZSBDT1JTIENvbmZpZ3VyYXRpb25cbiAqL1xuZXhwb3J0IGludGVyZmFjZSBDb3JzUHJlZmxpZ2h0T3B0aW9ucyB7XG4gIC8qKlxuICAgKiBTcGVjaWZpZXMgd2hldGhlciBjcmVkZW50aWFscyBhcmUgaW5jbHVkZWQgaW4gdGhlIENPUlMgcmVxdWVzdC5cbiAgICogQGRlZmF1bHQgZmFsc2VcbiAgICovXG4gIHJlYWRvbmx5IGFsbG93Q3JlZGVudGlhbHM/OiBib29sZWFuO1xuXG4gIC8qKlxuICAgKiBSZXByZXNlbnRzIGEgY29sbGVjdGlvbiBvZiBhbGxvd2VkIGhlYWRlcnMuXG4gICAqIEBkZWZhdWx0IC0gTm8gSGVhZGVycyBhcmUgYWxsb3dlZC5cbiAgICovXG4gIHJlYWRvbmx5IGFsbG93SGVhZGVycz86IHN0cmluZ1tdO1xuXG4gIC8qKlxuICAgKiBSZXByZXNlbnRzIGEgY29sbGVjdGlvbiBvZiBhbGxvd2VkIEhUVFAgbWV0aG9kcy5cbiAgICogQGRlZmF1bHQgLSBObyBNZXRob2RzIGFyZSBhbGxvd2VkLlxuICAgKi9cbiAgcmVhZG9ubHkgYWxsb3dNZXRob2RzPzogQ29yc0h0dHBNZXRob2RbXTtcblxuICAvKipcbiAgICogUmVwcmVzZW50cyBhIGNvbGxlY3Rpb24gb2YgYWxsb3dlZCBvcmlnaW5zLlxuICAgKiBAZGVmYXVsdCAtIE5vIE9yaWdpbnMgYXJlIGFsbG93ZWQuXG4gICAqL1xuICByZWFkb25seSBhbGxvd09yaWdpbnM/OiBzdHJpbmdbXTtcblxuICAvKipcbiAgICogUmVwcmVzZW50cyBhIGNvbGxlY3Rpb24gb2YgZXhwb3NlZCBoZWFkZXJzLlxuICAgKiBAZGVmYXVsdCAtIE5vIEV4cG9zZSBIZWFkZXJzIGFyZSBhbGxvd2VkLlxuICAgKi9cbiAgcmVhZG9ubHkgZXhwb3NlSGVhZGVycz86IHN0cmluZ1tdO1xuXG4gIC8qKlxuICAgKiBUaGUgZHVyYXRpb24gdGhhdCB0aGUgYnJvd3NlciBzaG91bGQgY2FjaGUgcHJlZmxpZ2h0IHJlcXVlc3QgcmVzdWx0cy5cbiAgICogQGRlZmF1bHQgRHVyYXRpb24uc2Vjb25kcygwKVxuICAgKi9cbiAgcmVhZG9ubHkgbWF4QWdlPzogRHVyYXRpb247XG59XG5cbi8qKlxuICogT3B0aW9ucyBmb3IgdGhlIFJvdXRlIHdpdGggSW50ZWdyYXRpb24gcmVzb3VyY2VcbiAqL1xuZXhwb3J0IGludGVyZmFjZSBBZGRSb3V0ZXNPcHRpb25zIGV4dGVuZHMgQmF0Y2hIdHRwUm91dGVPcHRpb25zIHtcbiAgLyoqXG4gICAqIFRoZSBwYXRoIGF0IHdoaWNoIGFsbCBvZiB0aGVzZSByb3V0ZXMgYXJlIGNvbmZpZ3VyZWQuXG4gICAqL1xuICByZWFkb25seSBwYXRoOiBzdHJpbmc7XG5cbiAgLyoqXG4gICAqIFRoZSBIVFRQIG1ldGhvZHMgdG8gYmUgY29uZmlndXJlZFxuICAgKiBAZGVmYXVsdCBIdHRwTWV0aG9kLkFOWVxuICAgKi9cbiAgcmVhZG9ubHkgbWV0aG9kcz86IEh0dHBNZXRob2RbXTtcblxuICAvKipcbiAgICogQXV0aG9yaXplciB0byBiZSBhc3NvY2lhdGVkIHRvIHRoZXNlIHJvdXRlcy5cbiAgICpcbiAgICogVXNlIE5vbmVBdXRob3JpemVyIHRvIHJlbW92ZSB0aGUgZGVmYXVsdCBhdXRob3JpemVyIGZvciB0aGUgYXBpXG4gICAqXG4gICAqIEBkZWZhdWx0IC0gdXNlcyB0aGUgZGVmYXVsdCBhdXRob3JpemVyIGlmIG9uZSBpcyBzcGVjaWZpZWQgb24gdGhlIEh0dHBBcGlcbiAgICovXG4gIHJlYWRvbmx5IGF1dGhvcml6ZXI/OiBJSHR0cFJvdXRlQXV0aG9yaXplcjtcblxuICAvKipcbiAgICogVGhlIGxpc3Qgb2YgT0lEQyBzY29wZXMgdG8gaW5jbHVkZSBpbiB0aGUgYXV0aG9yaXphdGlvbi5cbiAgICpcbiAgICogVGhlc2Ugc2NvcGVzIHdpbGwgb3ZlcnJpZGUgdGhlIGRlZmF1bHQgYXV0aG9yaXphdGlvbiBzY29wZXMgb24gdGhlIGdhdGV3YXkuXG4gICAqIFNldCB0byBbXSB0byByZW1vdmUgZGVmYXVsdCBzY29wZXNcbiAgICpcbiAgICogQGRlZmF1bHQgLSB1c2VzIGRlZmF1bHRBdXRob3JpemF0aW9uU2NvcGVzIGlmIGNvbmZpZ3VyZWQgb24gdGhlIEFQSSwgb3RoZXJ3aXNlIG5vbmUuXG4gICAqL1xuICByZWFkb25seSBhdXRob3JpemF0aW9uU2NvcGVzPzogc3RyaW5nW107XG59XG5cbmFic3RyYWN0IGNsYXNzIEh0dHBBcGlCYXNlIGV4dGVuZHMgQXBpQmFzZSBpbXBsZW1lbnRzIElIdHRwQXBpIHsgLy8gbm90ZSB0aGF0IHRoaXMgaXMgbm90IGV4cG9ydGVkXG5cbiAgcHVibGljIGFic3RyYWN0IHJlYWRvbmx5IGFwaUlkOiBzdHJpbmc7XG4gIHB1YmxpYyBhYnN0cmFjdCByZWFkb25seSBodHRwQXBpSWQ6IHN0cmluZztcbiAgcHVibGljIGFic3RyYWN0IHJlYWRvbmx5IGFwaUVuZHBvaW50OiBzdHJpbmc7XG4gIHByaXZhdGUgdnBjTGlua3M6IFJlY29yZDxzdHJpbmcsIFZwY0xpbms+ID0ge307XG5cbiAgcHVibGljIG1ldHJpY0NsaWVudEVycm9yKHByb3BzPzogTWV0cmljT3B0aW9ucyk6IE1ldHJpYyB7XG4gICAgcmV0dXJuIHRoaXMubWV0cmljKCc0eHgnLCB7IHN0YXRpc3RpYzogJ1N1bScsIC4uLnByb3BzIH0pO1xuICB9XG5cbiAgcHVibGljIG1ldHJpY1NlcnZlckVycm9yKHByb3BzPzogTWV0cmljT3B0aW9ucyk6IE1ldHJpYyB7XG4gICAgcmV0dXJuIHRoaXMubWV0cmljKCc1eHgnLCB7IHN0YXRpc3RpYzogJ1N1bScsIC4uLnByb3BzIH0pO1xuICB9XG5cbiAgcHVibGljIG1ldHJpY0RhdGFQcm9jZXNzZWQocHJvcHM/OiBNZXRyaWNPcHRpb25zKTogTWV0cmljIHtcbiAgICByZXR1cm4gdGhpcy5tZXRyaWMoJ0RhdGFQcm9jZXNzZWQnLCB7IHN0YXRpc3RpYzogJ1N1bScsIC4uLnByb3BzIH0pO1xuICB9XG5cbiAgcHVibGljIG1ldHJpY0NvdW50KHByb3BzPzogTWV0cmljT3B0aW9ucyk6IE1ldHJpYyB7XG4gICAgcmV0dXJuIHRoaXMubWV0cmljKCdDb3VudCcsIHsgc3RhdGlzdGljOiAnU2FtcGxlQ291bnQnLCAuLi5wcm9wcyB9KTtcbiAgfVxuXG4gIHB1YmxpYyBtZXRyaWNJbnRlZ3JhdGlvbkxhdGVuY3kocHJvcHM/OiBNZXRyaWNPcHRpb25zKTogTWV0cmljIHtcbiAgICByZXR1cm4gdGhpcy5tZXRyaWMoJ0ludGVncmF0aW9uTGF0ZW5jeScsIHByb3BzKTtcbiAgfVxuXG4gIHB1YmxpYyBtZXRyaWNMYXRlbmN5KHByb3BzPzogTWV0cmljT3B0aW9ucyk6IE1ldHJpYyB7XG4gICAgcmV0dXJuIHRoaXMubWV0cmljKCdMYXRlbmN5JywgcHJvcHMpO1xuICB9XG5cbiAgcHVibGljIGFkZFZwY0xpbmsob3B0aW9uczogVnBjTGlua1Byb3BzKTogVnBjTGluayB7XG4gICAgY29uc3QgeyB2cGNJZCB9ID0gb3B0aW9ucy52cGM7XG4gICAgaWYgKHZwY0lkIGluIHRoaXMudnBjTGlua3MpIHtcbiAgICAgIHJldHVybiB0aGlzLnZwY0xpbmtzW3ZwY0lkXTtcbiAgICB9XG5cbiAgICBjb25zdCBjb3VudCA9IE9iamVjdC5rZXlzKHRoaXMudnBjTGlua3MpLmxlbmd0aCArIDE7XG4gICAgY29uc3QgdnBjTGluayA9IG5ldyBWcGNMaW5rKHRoaXMsIGBWcGNMaW5rLSR7Y291bnR9YCwgb3B0aW9ucyk7XG4gICAgdGhpcy52cGNMaW5rc1t2cGNJZF0gPSB2cGNMaW5rO1xuXG4gICAgcmV0dXJuIHZwY0xpbms7XG4gIH1cbn1cblxuLyoqXG4gKiBBdHRyaWJ1dGVzIGZvciBpbXBvcnRpbmcgYW4gSHR0cEFwaSBpbnRvIHRoZSBDREtcbiAqL1xuZXhwb3J0IGludGVyZmFjZSBIdHRwQXBpQXR0cmlidXRlcyB7XG4gIC8qKlxuICAgKiBUaGUgaWRlbnRpZmllciBvZiB0aGUgSHR0cEFwaVxuICAgKi9cbiAgcmVhZG9ubHkgaHR0cEFwaUlkOiBzdHJpbmc7XG4gIC8qKlxuICAgKiBUaGUgZW5kcG9pbnQgVVJMIG9mIHRoZSBIdHRwQXBpXG4gICAqIEBkZWZhdWx0IC0gdGhyb3dzIGFuIGVycm9yIGlmIGFwaUVuZHBvaW50IGlzIGFjY2Vzc2VkLlxuICAgKi9cbiAgcmVhZG9ubHkgYXBpRW5kcG9pbnQ/OiBzdHJpbmc7XG59XG5cbi8qKlxuICogQ3JlYXRlIGEgbmV3IEFQSSBHYXRld2F5IEhUVFAgQVBJIGVuZHBvaW50LlxuICogQHJlc291cmNlIEFXUzo6QXBpR2F0ZXdheVYyOjpBcGlcbiAqL1xuZXhwb3J0IGNsYXNzIEh0dHBBcGkgZXh0ZW5kcyBIdHRwQXBpQmFzZSB7XG4gIC8qKlxuICAgKiBJbXBvcnQgYW4gZXhpc3RpbmcgSFRUUCBBUEkgaW50byB0aGlzIENESyBhcHAuXG4gICAqL1xuICBwdWJsaWMgc3RhdGljIGZyb21IdHRwQXBpQXR0cmlidXRlcyhzY29wZTogQ29uc3RydWN0LCBpZDogc3RyaW5nLCBhdHRyczogSHR0cEFwaUF0dHJpYnV0ZXMpOiBJSHR0cEFwaSB7XG4gICAgY2xhc3MgSW1wb3J0IGV4dGVuZHMgSHR0cEFwaUJhc2Uge1xuICAgICAgcHVibGljIHJlYWRvbmx5IGFwaUlkID0gYXR0cnMuaHR0cEFwaUlkO1xuICAgICAgcHVibGljIHJlYWRvbmx5IGh0dHBBcGlJZCA9IGF0dHJzLmh0dHBBcGlJZDtcbiAgICAgIHByaXZhdGUgcmVhZG9ubHkgX2FwaUVuZHBvaW50ID0gYXR0cnMuYXBpRW5kcG9pbnQ7XG5cbiAgICAgIHB1YmxpYyBnZXQgYXBpRW5kcG9pbnQoKTogc3RyaW5nIHtcbiAgICAgICAgaWYgKCF0aGlzLl9hcGlFbmRwb2ludCkge1xuICAgICAgICAgIHRocm93IG5ldyBFcnJvcignYXBpRW5kcG9pbnQgaXMgbm90IGNvbmZpZ3VyZWQgb24gdGhlIGltcG9ydGVkIEh0dHBBcGkuJyk7XG4gICAgICAgIH1cbiAgICAgICAgcmV0dXJuIHRoaXMuX2FwaUVuZHBvaW50O1xuICAgICAgfVxuICAgIH1cbiAgICByZXR1cm4gbmV3IEltcG9ydChzY29wZSwgaWQpO1xuICB9XG5cbiAgLyoqXG4gICAqIEEgaHVtYW4gZnJpZW5kbHkgbmFtZSBmb3IgdGhpcyBIVFRQIEFQSS4gTm90ZSB0aGF0IHRoaXMgaXMgZGlmZmVyZW50IGZyb20gYGh0dHBBcGlJZGAuXG4gICAqL1xuICBwdWJsaWMgcmVhZG9ubHkgaHR0cEFwaU5hbWU/OiBzdHJpbmc7XG4gIHB1YmxpYyByZWFkb25seSBhcGlJZDogc3RyaW5nO1xuICBwdWJsaWMgcmVhZG9ubHkgaHR0cEFwaUlkOiBzdHJpbmc7XG5cbiAgLyoqXG4gICAqIFNwZWNpZmllcyB3aGV0aGVyIGNsaWVudHMgY2FuIGludm9rZSB0aGlzIEhUVFAgQVBJIGJ5IHVzaW5nIHRoZSBkZWZhdWx0IGV4ZWN1dGUtYXBpIGVuZHBvaW50LlxuICAgKi9cbiAgcHVibGljIHJlYWRvbmx5IGRpc2FibGVFeGVjdXRlQXBpRW5kcG9pbnQ/OiBib29sZWFuO1xuXG4gIC8qKlxuICAgKiBUaGUgZGVmYXVsdCBzdGFnZSBvZiB0aGlzIEFQSVxuICAgKi9cbiAgcHVibGljIHJlYWRvbmx5IGRlZmF1bHRTdGFnZTogSUh0dHBTdGFnZSB8IHVuZGVmaW5lZDtcblxuICBwcml2YXRlIHJlYWRvbmx5IF9hcGlFbmRwb2ludDogc3RyaW5nO1xuXG4gIHByaXZhdGUgcmVhZG9ubHkgZGVmYXVsdEF1dGhvcml6ZXI/OiBJSHR0cFJvdXRlQXV0aG9yaXplcjtcbiAgcHJpdmF0ZSByZWFkb25seSBkZWZhdWx0QXV0aG9yaXphdGlvblNjb3Blcz86IHN0cmluZ1tdO1xuXG4gIGNvbnN0cnVjdG9yKHNjb3BlOiBDb25zdHJ1Y3QsIGlkOiBzdHJpbmcsIHByb3BzPzogSHR0cEFwaVByb3BzKSB7XG4gICAgc3VwZXIoc2NvcGUsIGlkKTtcblxuICAgIHRoaXMuaHR0cEFwaU5hbWUgPSBwcm9wcz8uYXBpTmFtZSA/PyBpZDtcbiAgICB0aGlzLmRpc2FibGVFeGVjdXRlQXBpRW5kcG9pbnQgPSBwcm9wcz8uZGlzYWJsZUV4ZWN1dGVBcGlFbmRwb2ludDtcblxuICAgIGxldCBjb3JzQ29uZmlndXJhdGlvbjogQ2ZuQXBpLkNvcnNQcm9wZXJ0eSB8IHVuZGVmaW5lZDtcbiAgICBpZiAocHJvcHM/LmNvcnNQcmVmbGlnaHQpIHtcbiAgICAgIGNvbnN0IGNvcnMgPSBwcm9wcy5jb3JzUHJlZmxpZ2h0O1xuICAgICAgaWYgKGNvcnMuYWxsb3dPcmlnaW5zICYmIGNvcnMuYWxsb3dPcmlnaW5zLmluY2x1ZGVzKCcqJykgJiYgY29ycy5hbGxvd0NyZWRlbnRpYWxzKSB7XG4gICAgICAgIHRocm93IG5ldyBFcnJvcihcIkNPUlMgcHJlZmxpZ2h0IC0gYWxsb3dDcmVkZW50aWFscyBpcyBub3Qgc3VwcG9ydGVkIHdoZW4gYWxsb3dPcmlnaW4gaXMgJyonXCIpO1xuICAgICAgfVxuICAgICAgY29uc3Qge1xuICAgICAgICBhbGxvd0NyZWRlbnRpYWxzLFxuICAgICAgICBhbGxvd0hlYWRlcnMsXG4gICAgICAgIGFsbG93TWV0aG9kcyxcbiAgICAgICAgYWxsb3dPcmlnaW5zLFxuICAgICAgICBleHBvc2VIZWFkZXJzLFxuICAgICAgICBtYXhBZ2UsXG4gICAgICB9ID0gcHJvcHMuY29yc1ByZWZsaWdodDtcbiAgICAgIGNvcnNDb25maWd1cmF0aW9uID0ge1xuICAgICAgICBhbGxvd0NyZWRlbnRpYWxzLFxuICAgICAgICBhbGxvd0hlYWRlcnMsXG4gICAgICAgIGFsbG93TWV0aG9kcyxcbiAgICAgICAgYWxsb3dPcmlnaW5zLFxuICAgICAgICBleHBvc2VIZWFkZXJzLFxuICAgICAgICBtYXhBZ2U6IG1heEFnZT8udG9TZWNvbmRzKCksXG4gICAgICB9O1xuICAgIH1cblxuICAgIGNvbnN0IGFwaVByb3BzOiBDZm5BcGlQcm9wcyA9IHtcbiAgICAgIG5hbWU6IHRoaXMuaHR0cEFwaU5hbWUsXG4gICAgICBwcm90b2NvbFR5cGU6ICdIVFRQJyxcbiAgICAgIGNvcnNDb25maWd1cmF0aW9uLFxuICAgICAgZGVzY3JpcHRpb246IHByb3BzPy5kZXNjcmlwdGlvbixcbiAgICAgIGRpc2FibGVFeGVjdXRlQXBpRW5kcG9pbnQ6IHRoaXMuZGlzYWJsZUV4ZWN1dGVBcGlFbmRwb2ludCxcbiAgICB9O1xuXG4gICAgY29uc3QgcmVzb3VyY2UgPSBuZXcgQ2ZuQXBpKHRoaXMsICdSZXNvdXJjZScsIGFwaVByb3BzKTtcbiAgICB0aGlzLmFwaUlkID0gcmVzb3VyY2UucmVmO1xuICAgIHRoaXMuaHR0cEFwaUlkID0gcmVzb3VyY2UucmVmO1xuICAgIHRoaXMuX2FwaUVuZHBvaW50ID0gcmVzb3VyY2UuYXR0ckFwaUVuZHBvaW50O1xuICAgIHRoaXMuZGVmYXVsdEF1dGhvcml6ZXIgPSBwcm9wcz8uZGVmYXVsdEF1dGhvcml6ZXI7XG4gICAgdGhpcy5kZWZhdWx0QXV0aG9yaXphdGlvblNjb3BlcyA9IHByb3BzPy5kZWZhdWx0QXV0aG9yaXphdGlvblNjb3BlcztcblxuICAgIGlmIChwcm9wcz8uZGVmYXVsdEludGVncmF0aW9uKSB7XG4gICAgICBuZXcgSHR0cFJvdXRlKHRoaXMsICdEZWZhdWx0Um91dGUnLCB7XG4gICAgICAgIGh0dHBBcGk6IHRoaXMsXG4gICAgICAgIHJvdXRlS2V5OiBIdHRwUm91dGVLZXkuREVGQVVMVCxcbiAgICAgICAgaW50ZWdyYXRpb246IHByb3BzLmRlZmF1bHRJbnRlZ3JhdGlvbixcbiAgICAgICAgYXV0aG9yaXplcjogcHJvcHMuZGVmYXVsdEF1dGhvcml6ZXIsXG4gICAgICAgIGF1dGhvcml6YXRpb25TY29wZXM6IHByb3BzLmRlZmF1bHRBdXRob3JpemF0aW9uU2NvcGVzLFxuICAgICAgfSk7XG4gICAgfVxuXG4gICAgaWYgKHByb3BzPy5jcmVhdGVEZWZhdWx0U3RhZ2UgPT09IHVuZGVmaW5lZCB8fCBwcm9wcy5jcmVhdGVEZWZhdWx0U3RhZ2UgPT09IHRydWUpIHtcbiAgICAgIHRoaXMuZGVmYXVsdFN0YWdlID0gbmV3IEh0dHBTdGFnZSh0aGlzLCAnRGVmYXVsdFN0YWdlJywge1xuICAgICAgICBodHRwQXBpOiB0aGlzLFxuICAgICAgICBhdXRvRGVwbG95OiB0cnVlLFxuICAgICAgICBkb21haW5NYXBwaW5nOiBwcm9wcz8uZGVmYXVsdERvbWFpbk1hcHBpbmcsXG4gICAgICB9KTtcblxuICAgICAgLy8gdG8gZW5zdXJlIHRoZSBkb21haW4gaXMgcmVhZHkgYmVmb3JlIGNyZWF0aW5nIHRoZSBkZWZhdWx0IHN0YWdlXG4gICAgICBpZiAocHJvcHM/LmRlZmF1bHREb21haW5NYXBwaW5nKSB7XG4gICAgICAgIHRoaXMuZGVmYXVsdFN0YWdlLm5vZGUuYWRkRGVwZW5kZW5jeShwcm9wcy5kZWZhdWx0RG9tYWluTWFwcGluZy5kb21haW5OYW1lKTtcbiAgICAgIH1cbiAgICB9XG5cbiAgICBpZiAocHJvcHM/LmNyZWF0ZURlZmF1bHRTdGFnZSA9PT0gZmFsc2UgJiYgcHJvcHMuZGVmYXVsdERvbWFpbk1hcHBpbmcpIHtcbiAgICAgIHRocm93IG5ldyBFcnJvcignZGVmYXVsdERvbWFpbk1hcHBpbmcgbm90IHN1cHBvcnRlZCB3aXRoIGNyZWF0ZURlZmF1bHRTdGFnZSBkaXNhYmxlZCcsXG4gICAgICApO1xuICAgIH1cbiAgfVxuXG4gIC8qKlxuICAgKiBHZXQgdGhlIGRlZmF1bHQgZW5kcG9pbnQgZm9yIHRoaXMgQVBJLlxuICAgKi9cbiAgcHVibGljIGdldCBhcGlFbmRwb2ludCgpOiBzdHJpbmcge1xuICAgIGlmICh0aGlzLmRpc2FibGVFeGVjdXRlQXBpRW5kcG9pbnQpIHtcbiAgICAgIHRocm93IG5ldyBFcnJvcignYXBpRW5kcG9pbnQgaXMgbm90IGFjY2Vzc2libGUgd2hlbiBkaXNhYmxlRXhlY3V0ZUFwaUVuZHBvaW50IGlzIHNldCB0byB0cnVlLicpO1xuICAgIH1cbiAgICByZXR1cm4gdGhpcy5fYXBpRW5kcG9pbnQ7XG4gIH1cblxuICAvKipcbiAgICogR2V0IHRoZSBVUkwgdG8gdGhlIGRlZmF1bHQgc3RhZ2Ugb2YgdGhpcyBBUEkuXG4gICAqIFJldHVybnMgYHVuZGVmaW5lZGAgaWYgYGNyZWF0ZURlZmF1bHRTdGFnZWAgaXMgdW5zZXQuXG4gICAqL1xuICBwdWJsaWMgZ2V0IHVybCgpOiBzdHJpbmcgfCB1bmRlZmluZWQge1xuICAgIHJldHVybiB0aGlzLmRlZmF1bHRTdGFnZSA/IHRoaXMuZGVmYXVsdFN0YWdlLnVybCA6IHVuZGVmaW5lZDtcbiAgfVxuXG4gIC8qKlxuICAgKiBBZGQgYSBuZXcgc3RhZ2UuXG4gICAqL1xuICBwdWJsaWMgYWRkU3RhZ2UoaWQ6IHN0cmluZywgb3B0aW9uczogSHR0cFN0YWdlT3B0aW9ucyk6IEh0dHBTdGFnZSB7XG4gICAgY29uc3Qgc3RhZ2UgPSBuZXcgSHR0cFN0YWdlKHRoaXMsIGlkLCB7XG4gICAgICBodHRwQXBpOiB0aGlzLFxuICAgICAgLi4ub3B0aW9ucyxcbiAgICB9KTtcbiAgICByZXR1cm4gc3RhZ2U7XG4gIH1cblxuICAvKipcbiAgICogQWRkIG11bHRpcGxlIHJvdXRlcyB0aGF0IHVzZXMgdGhlIHNhbWUgY29uZmlndXJhdGlvbi4gVGhlIHJvdXRlcyBhbGwgZ28gdG8gdGhlIHNhbWUgcGF0aCwgYnV0IGZvciBkaWZmZXJlbnRcbiAgICogbWV0aG9kcy5cbiAgICovXG4gIHB1YmxpYyBhZGRSb3V0ZXMob3B0aW9uczogQWRkUm91dGVzT3B0aW9ucyk6IEh0dHBSb3V0ZVtdIHtcbiAgICBjb25zdCBtZXRob2RzID0gb3B0aW9ucy5tZXRob2RzID8/IFtIdHRwTWV0aG9kLkFOWV07XG4gICAgcmV0dXJuIG1ldGhvZHMubWFwKChtZXRob2QpID0+IHtcbiAgICAgIGNvbnN0IGF1dGhvcml6YXRpb25TY29wZXMgPSBvcHRpb25zLmF1dGhvcml6YXRpb25TY29wZXMgPz8gdGhpcy5kZWZhdWx0QXV0aG9yaXphdGlvblNjb3BlcztcblxuICAgICAgcmV0dXJuIG5ldyBIdHRwUm91dGUodGhpcywgYCR7bWV0aG9kfSR7b3B0aW9ucy5wYXRofWAsIHtcbiAgICAgICAgaHR0cEFwaTogdGhpcyxcbiAgICAgICAgcm91dGVLZXk6IEh0dHBSb3V0ZUtleS53aXRoKG9wdGlvbnMucGF0aCwgbWV0aG9kKSxcbiAgICAgICAgaW50ZWdyYXRpb246IG9wdGlvbnMuaW50ZWdyYXRpb24sXG4gICAgICAgIGF1dGhvcml6ZXI6IG9wdGlvbnMuYXV0aG9yaXplciA/PyB0aGlzLmRlZmF1bHRBdXRob3JpemVyLFxuICAgICAgICBhdXRob3JpemF0aW9uU2NvcGVzLFxuICAgICAgfSk7XG4gICAgfSk7XG4gIH1cbn1cbiJdfQ==