import { Resource } from '@aws-cdk/core';
import { Construct } from 'constructs';
import { IIntegration } from '../common';
import { IWebSocketApi } from './api';
import { IWebSocketRoute } from './route';
import { Construct as CoreConstruct } from '@aws-cdk/core';
/**
 * Represents an Integration for an WebSocket API.
 */
export interface IWebSocketIntegration extends IIntegration {
    /** The WebSocket API associated with this integration */
    readonly webSocketApi: IWebSocketApi;
}
/**
 * WebSocket Integration Types
 */
export declare enum WebSocketIntegrationType {
    /**
     * AWS Proxy Integration Type
     */
    AWS_PROXY = "AWS_PROXY",
    /**
     * Mock Integration Type
     */
    MOCK = "MOCK"
}
/**
 * The integration properties
 */
export interface WebSocketIntegrationProps {
    /**
     * The WebSocket API to which this integration should be bound.
     */
    readonly webSocketApi: IWebSocketApi;
    /**
     * Integration type
     */
    readonly integrationType: WebSocketIntegrationType;
    /**
     * Integration URI.
     */
    readonly integrationUri: string;
}
/**
 * The integration for an API route.
 * @resource AWS::ApiGatewayV2::Integration
 */
export declare class WebSocketIntegration extends Resource implements IWebSocketIntegration {
    readonly integrationId: string;
    readonly webSocketApi: IWebSocketApi;
    constructor(scope: Construct, id: string, props: WebSocketIntegrationProps);
}
/**
 * Options to the WebSocketRouteIntegration during its bind operation.
 */
export interface WebSocketRouteIntegrationBindOptions {
    /**
     * The route to which this is being bound.
     */
    readonly route: IWebSocketRoute;
    /**
     * The current scope in which the bind is occurring.
     * If the `WebSocketRouteIntegration` being bound creates additional constructs,
     * this will be used as their parent scope.
     */
    readonly scope: CoreConstruct;
}
/**
 * The interface that various route integration classes will inherit.
 */
export declare abstract class WebSocketRouteIntegration {
    private readonly id;
    private integration?;
    /**
     * Initialize an integration for a route on websocket api.
     * @param id id of the underlying `WebSocketIntegration` construct.
     */
    constructor(id: string);
    /**
     * Internal method called when binding this integration to the route.
     * @internal
     */
    _bindToRoute(options: WebSocketRouteIntegrationBindOptions): {
        readonly integrationId: string;
    };
    /**
     * Bind this integration to the route.
     */
    abstract bind(options: WebSocketRouteIntegrationBindOptions): WebSocketRouteIntegrationConfig;
}
/**
 * Config returned back as a result of the bind.
 */
export interface WebSocketRouteIntegrationConfig {
    /**
     * Integration type.
     */
    readonly type: WebSocketIntegrationType;
    /**
     * Integration URI
     */
    readonly uri: string;
}
