"use strict";
/*********************************************************************************************************************
 Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.

 Licensed under the Apache License, Version 2.0 (the "License").
 You may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 ******************************************************************************************************************** */
Object.defineProperty(exports, "__esModule", { value: true });
const render_options_1 = require("projen/lib/javascript/render-options");
const synth_1 = require("projen/lib/util/synth");
const src_1 = require("../src");
describe("PDK Pipeline Py Unit Tests", () => {
    it("Defaults", () => {
        const project = new src_1.PDKPipelinePyProject({
            authorEmail: "test@test.com",
            authorName: "test",
            moduleName: "defaults",
            version: "0.0.0",
            cdkVersion: "2.0.0",
            name: "Defaults",
        });
        expect(sanitizeOutput(synth_1.synthSnapshot(project))).toMatchSnapshot();
    });
    it("projenrc synth correctly", () => {
        const project = new src_1.PDKPipelinePyProject(render_options_1.renderProjenInitOptions("@aws-prototyping-sdk/pipeline.PDKPipelinePyProject", {
            authorEmail: "test@test.com",
            authorName: "test",
            moduleName: "defaults",
            version: "0.0.0",
            cdkVersion: "2.0.0",
            name: "ProjenRc",
        }));
        expect(synth_1.synthSnapshot(project)[".projenrc.py"]).toMatchSnapshot();
    });
    it("With Context", () => {
        const project = new src_1.PDKPipelinePyProject({
            authorEmail: "test@test.com",
            authorName: "test",
            moduleName: "with_context",
            version: "0.0.0",
            cdkVersion: "2.0.0",
            name: "WithContext",
            context: {
                sonarqubeScannerConfig: {
                    sonarqubeEndpoint: "https://my.endpoint",
                    sonarqubeAuthorizedGroup: "group",
                    sonarqubeDefaultProfileOrGateName: "default",
                    sonarqubeSpecificProfileOrGateName: "specific",
                    sonarqubeProjectName: "WithContext",
                    sonarqubeTags: ["sample"],
                    preArchiveCommands: ["echo here"],
                },
            },
        });
        expect(sanitizeOutput(synth_1.synthSnapshot(project))).toMatchSnapshot();
    });
    it("Custom AppEntrypoint", () => {
        const project = new src_1.PDKPipelinePyProject({
            authorEmail: "test@test.com",
            authorName: "test",
            moduleName: "custom_app_entrypoint",
            version: "0.0.0",
            cdkVersion: "2.0.0",
            name: "CustomAppEntrypoint",
            appEntrypoint: "updated.py",
        });
        expect(sanitizeOutput(synth_1.synthSnapshot(project))).toMatchSnapshot();
    });
});
function sanitizeOutput(output) {
    Object.keys(output)
        .filter((k) => k.includes("__pycache__"))
        .forEach((k) => delete output[k]);
    return output;
}
//# sourceMappingURL=data:application/json;base64,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