"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AwsPrototypingChecks = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
const aws_cdk_lib_1 = require("aws-cdk-lib");
const cdk_nag_1 = require("cdk-nag");
const aws_prototyping_rules_1 = require("./aws-prototyping-rules");
/**
 * Check best practices for prototypes
 *
 */
class AwsPrototypingChecks extends cdk_nag_1.NagPack {
    constructor(props) {
        super(props);
        this.packName = aws_prototyping_rules_1.PackName;
    }
    /**
     * Check if CfnResource and apply rules
     */
    visit(node) {
        if (node instanceof aws_cdk_lib_1.CfnResource) {
            aws_prototyping_rules_1.RuleMetadata.forEach((rule) => {
                this.applyRule({
                    ...rule,
                    node,
                });
            });
        }
    }
}
exports.AwsPrototypingChecks = AwsPrototypingChecks;
_a = JSII_RTTI_SYMBOL_1;
AwsPrototypingChecks[_a] = { fqn: "aws-prototyping-sdk.pdk_nag.AwsPrototypingChecks", version: "0.12.27" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiYXdzLXByb3RvdHlwaW5nLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiYXdzLXByb3RvdHlwaW5nLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7O0FBQUE7c0NBQ3NDO0FBRXRDLDZDQUEwQztBQUMxQyxxQ0FBZ0Q7QUFFaEQsbUVBQWlFO0FBRWpFOzs7R0FHRztBQUNILE1BQWEsb0JBQXFCLFNBQVEsaUJBQU87SUFDL0MsWUFBWSxLQUFvQjtRQUM5QixLQUFLLENBQUMsS0FBSyxDQUFDLENBQUM7UUFDYixJQUFJLENBQUMsUUFBUSxHQUFHLGdDQUFRLENBQUM7SUFDM0IsQ0FBQztJQUNEOztPQUVHO0lBQ0ksS0FBSyxDQUFDLElBQWdCO1FBQzNCLElBQUksSUFBSSxZQUFZLHlCQUFXLEVBQUU7WUFDL0Isb0NBQVksQ0FBQyxPQUFPLENBQUMsQ0FBQyxJQUFJLEVBQUUsRUFBRTtnQkFDNUIsSUFBSSxDQUFDLFNBQVMsQ0FBQztvQkFDYixHQUFHLElBQUk7b0JBQ1AsSUFBSTtpQkFDTCxDQUFDLENBQUM7WUFDTCxDQUFDLENBQUMsQ0FBQztTQUNKO0lBQ0gsQ0FBQzs7QUFqQkgsb0RBa0JDIiwic291cmNlc0NvbnRlbnQiOlsiLyohIENvcHlyaWdodCBbQW1hem9uLmNvbV0oaHR0cDovL2FtYXpvbi5jb20vKSwgSW5jLiBvciBpdHMgYWZmaWxpYXRlcy4gQWxsIFJpZ2h0cyBSZXNlcnZlZC5cblNQRFgtTGljZW5zZS1JZGVudGlmaWVyOiBBcGFjaGUtMi4wICovXG5cbmltcG9ydCB7IENmblJlc291cmNlIH0gZnJvbSBcImF3cy1jZGstbGliXCI7XG5pbXBvcnQgeyBOYWdQYWNrLCBOYWdQYWNrUHJvcHMgfSBmcm9tIFwiY2RrLW5hZ1wiO1xuaW1wb3J0IHsgSUNvbnN0cnVjdCB9IGZyb20gXCJjb25zdHJ1Y3RzXCI7XG5pbXBvcnQgeyBQYWNrTmFtZSwgUnVsZU1ldGFkYXRhIH0gZnJvbSBcIi4vYXdzLXByb3RvdHlwaW5nLXJ1bGVzXCI7XG5cbi8qKlxuICogQ2hlY2sgYmVzdCBwcmFjdGljZXMgZm9yIHByb3RvdHlwZXNcbiAqXG4gKi9cbmV4cG9ydCBjbGFzcyBBd3NQcm90b3R5cGluZ0NoZWNrcyBleHRlbmRzIE5hZ1BhY2sge1xuICBjb25zdHJ1Y3Rvcihwcm9wcz86IE5hZ1BhY2tQcm9wcykge1xuICAgIHN1cGVyKHByb3BzKTtcbiAgICB0aGlzLnBhY2tOYW1lID0gUGFja05hbWU7XG4gIH1cbiAgLyoqXG4gICAqIENoZWNrIGlmIENmblJlc291cmNlIGFuZCBhcHBseSBydWxlc1xuICAgKi9cbiAgcHVibGljIHZpc2l0KG5vZGU6IElDb25zdHJ1Y3QpOiB2b2lkIHtcbiAgICBpZiAobm9kZSBpbnN0YW5jZW9mIENmblJlc291cmNlKSB7XG4gICAgICBSdWxlTWV0YWRhdGEuZm9yRWFjaCgocnVsZSkgPT4ge1xuICAgICAgICB0aGlzLmFwcGx5UnVsZSh7XG4gICAgICAgICAgLi4ucnVsZSxcbiAgICAgICAgICBub2RlLFxuICAgICAgICB9KTtcbiAgICAgIH0pO1xuICAgIH1cbiAgfVxufVxuIl19