# Settings

You can customize the `django-rest-xauth` default behaviour by providing `XAUTH` setting in your django project's
`settings.py` file like below.

| Setting                                   | Default                                                                                                                                           | Description                                                                                                                             |
|-------------------------------------------|---------------------------------------------------------------------------------------------------------------------------------------------------|-----------------------------------------------------------------------------------------------------------------------------------------|
| `XAUTH_ENFORCE_ACCOUNT_VERIFICATION`      | `True`                                                                                                                                            | Checks if user account is verified before returning access token otherwise account verification token is returned.                      |
| `XAUTH_PASSWORD_RESET_REQUEST_SUBJECT`    | `"Password Reset Request"`                                                                                                                        | Used as a subject for email of OTP (temporary password) email sent by `xauth` from email referenced by `XAUTH_SENDER_ADDRESS` setting.  |
| `XAUTH_VERIFICATION_REQUEST_SUBJECT`      | `"Account Verification"`                                                                                                                          | Used as a subject for email of OTP (verification code) email sent by `xauth` from email referenced by `XAUTH_SENDER_ADDRESS` setting.   |
| `XAUTH_TOKEN_EXPIRY`                      | `{"access": timedelta(days=1),"activation": timedelta(minutes=30),"verification": timedelta(minutes=30),"password-reset": timedelta(minutes=30)}` | Duration after which a JWT token with the subject (specified as the `dict` key) should be considered expired.                           |
| `XAUTH_REPLY_TO_ACCOUNTS_EMAIL_ADDRESSES` | `None`                                                                                                                                            | Email(s) to which replies of `xauth`-related emails should go.                                                                          |
| `XAUTH_VERIFY_ENCRYPTED_TOKEN`            | `True`                                                                                                                                            | Verify bearer token from `Authorization` header as an encrypted JWT token.                                                              |
| `XAUTH_AUTH_APP_LABEL`                    | `accounts`                                                                                                                                        | Which app(-label) should the dependant classes be associated with. This eases overriding of classes within modules in `xauth.accounts`. |
| `XAUTH_KEYS_DIR`                          | `.secrets folder at repo root`                                                                                                                    | Folder to store the keys generated to sign and verify JWT token.                                                                        |
| `XAUTH_JWT_SIG_ALG`                       | `RS256`                                                                                                                                           | Signing algorithm for JWT token.                                                                                                        |
| `XAUTH_MAKE_KEY_DIRS`                     | `True`                                                                                                                                            | Whether to automatically create `KEYS_DIR` if they don't already exist.                                                                 |