import * as ec2 from '@aws-cdk/aws-ec2';
import * as ecs from '@aws-cdk/aws-ecs';
import * as s3 from '@aws-cdk/aws-s3';
import * as cdk from '@aws-cdk/core';
/**
 * Options to configure a Django ECS project.
 *
 * @stability stable
 */
export interface DjangoEcsProps {
    /**
     * Domain name for backend (including sub-domain).
     *
     * @stability stable
     */
    readonly domainName?: string;
    /**
     * Certificate ARN.
     *
     * @stability stable
     */
    readonly certificateArn?: string;
    /**
     * Name of existing bucket to use for media files.
     *
     * This name will be auto-generated if not specified
     *
     * @stability stable
     */
    readonly bucketName?: string;
    /**
     * The VPC to use for the application. It must contain PUBLIC, PRIVATE and ISOLATED subnets.
     *
     * A VPC will be created if this is not specified
     *
     * @stability stable
     */
    readonly vpc?: ec2.IVpc;
    /**
     * The location of the Dockerfile used to create the main application image.
     *
     * This is also the context used for building the image.
     *
     * TODO: set image and context path separately.
     *
     * @stability stable
     */
    readonly imageDirectory: string;
    /**
     * The command used to run the API web service.
     *
     * @stability stable
     */
    readonly webCommand?: string[];
    /**
     * Used to enable the celery beat service.
     *
     * @default false
     * @stability stable
     */
    readonly useCeleryBeat?: boolean;
}
/**
 * Configures a Django project using ECS Fargate.
 *
 * @stability stable
 */
export declare class DjangoEcs extends cdk.Construct {
    /**
     * @stability stable
     */
    staticFileBucket: s3.Bucket;
    /**
     * @stability stable
     */
    vpc: ec2.IVpc;
    /**
     * @stability stable
     */
    cluster: ecs.Cluster;
    /**
     * @stability stable
     */
    image: ecs.ContainerImage;
    /**
     * @stability stable
     */
    constructor(scope: cdk.Construct, id: string, props: DjangoEcsProps);
}
