"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CeleryBeat = void 0;
const ecs = require("@aws-cdk/aws-ecs");
const logs = require("@aws-cdk/aws-logs");
const cdk = require("@aws-cdk/core");
class CeleryBeat extends cdk.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const taskDefinition = new ecs.TaskDefinition(scope, `TaskDefinitionFor${id}`, {
            compatibility: ecs.Compatibility.FARGATE,
            cpu: '256',
            memoryMiB: '512',
        });
        props.dbSecret.grantRead(taskDefinition.taskRole);
        taskDefinition.addContainer(`TaskContainerFor${id}`, {
            image: props.image,
            // TODO: figure out what the best practice is here
            // running as the `app` user results in permissions error
            user: 'root',
            command: props.command,
            environment: props.environment,
            logging: ecs.LogDriver.awsLogs({
                logRetention: logs.RetentionDays.ONE_DAY,
                streamPrefix: `${id}Container`,
            }),
        });
        new ecs.FargateService(scope, `FargateService${id}`, {
            cluster: props.cluster,
            taskDefinition,
            // only run one instance of celery beat
            desiredCount: 1,
            securityGroups: props.securityGroups,
        });
    }
}
exports.CeleryBeat = CeleryBeat;
//# sourceMappingURL=data:application/json;base64,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