"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const cdk = require("@aws-cdk/core");
const index_1 = require("../index");
const env = {
    region: process.env.AWS_DEFAULT_REGION || 'us-east-1',
    account: process.env.AWS_ACCOUNT_ID,
};
const app = new cdk.App();
const stack = new cdk.Stack(app, 'DjangoEksStack', { env });
const construct = new index_1.DjangoEks(stack, 'DjangoEksSample', {
    imageDirectory: './test/django-step-by-step/backend',
    webCommand: [
        './scripts/start_prod.sh',
    ],
    domainName: process.env.DOMAIN_NAME,
    certificateArn: process.env.CERTIFICATE_ARN,
});
/**
 * Add tagging for this construct and all child constructs
 */
cdk.Tags.of(construct).add('stack', 'DjangoEksStack');
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW50ZWcuZGphbmdvLWVrcy5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uL3NyYy9pbnRlZy9pbnRlZy5kamFuZ28tZWtzLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7O0FBQUEscUNBQXFDO0FBQ3JDLG9DQUFxQztBQUVyQyxNQUFNLEdBQUcsR0FBRztJQUNWLE1BQU0sRUFBRSxPQUFPLENBQUMsR0FBRyxDQUFDLGtCQUFrQixJQUFJLFdBQVc7SUFDckQsT0FBTyxFQUFFLE9BQU8sQ0FBQyxHQUFHLENBQUMsY0FBYztDQUNwQyxDQUFDO0FBRUYsTUFBTSxHQUFHLEdBQUcsSUFBSSxHQUFHLENBQUMsR0FBRyxFQUFFLENBQUM7QUFDMUIsTUFBTSxLQUFLLEdBQUcsSUFBSSxHQUFHLENBQUMsS0FBSyxDQUFDLEdBQUcsRUFBRSxnQkFBZ0IsRUFBRSxFQUFFLEdBQUcsRUFBRSxDQUFDLENBQUM7QUFFNUQsTUFBTSxTQUFTLEdBQUcsSUFBSSxpQkFBUyxDQUFDLEtBQUssRUFBRSxpQkFBaUIsRUFBRTtJQUN4RCxjQUFjLEVBQUUsb0NBQW9DO0lBQ3BELFVBQVUsRUFBRTtRQUNWLHlCQUF5QjtLQUMxQjtJQUNELFVBQVUsRUFBRSxPQUFPLENBQUMsR0FBRyxDQUFDLFdBQVc7SUFDbkMsY0FBYyxFQUFFLE9BQU8sQ0FBQyxHQUFHLENBQUMsZUFBZTtDQUM1QyxDQUFDLENBQUM7QUFFSDs7R0FFRztBQUNILEdBQUcsQ0FBQyxJQUFJLENBQUMsRUFBRSxDQUFDLFNBQVMsQ0FBQyxDQUFDLEdBQUcsQ0FBQyxPQUFPLEVBQUUsZ0JBQWdCLENBQUMsQ0FBQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCAqIGFzIGNkayBmcm9tICdAYXdzLWNkay9jb3JlJztcbmltcG9ydCB7IERqYW5nb0VrcyB9IGZyb20gJy4uL2luZGV4JztcblxuY29uc3QgZW52ID0ge1xuICByZWdpb246IHByb2Nlc3MuZW52LkFXU19ERUZBVUxUX1JFR0lPTiB8fCAndXMtZWFzdC0xJyxcbiAgYWNjb3VudDogcHJvY2Vzcy5lbnYuQVdTX0FDQ09VTlRfSUQsXG59O1xuXG5jb25zdCBhcHAgPSBuZXcgY2RrLkFwcCgpO1xuY29uc3Qgc3RhY2sgPSBuZXcgY2RrLlN0YWNrKGFwcCwgJ0RqYW5nb0Vrc1N0YWNrJywgeyBlbnYgfSk7XG5cbmNvbnN0IGNvbnN0cnVjdCA9IG5ldyBEamFuZ29Fa3Moc3RhY2ssICdEamFuZ29Fa3NTYW1wbGUnLCB7XG4gIGltYWdlRGlyZWN0b3J5OiAnLi90ZXN0L2RqYW5nby1zdGVwLWJ5LXN0ZXAvYmFja2VuZCcsXG4gIHdlYkNvbW1hbmQ6IFtcbiAgICAnLi9zY3JpcHRzL3N0YXJ0X3Byb2Quc2gnLFxuICBdLFxuICBkb21haW5OYW1lOiBwcm9jZXNzLmVudi5ET01BSU5fTkFNRSxcbiAgY2VydGlmaWNhdGVBcm46IHByb2Nlc3MuZW52LkNFUlRJRklDQVRFX0FSTixcbn0pO1xuXG4vKipcbiAqIEFkZCB0YWdnaW5nIGZvciB0aGlzIGNvbnN0cnVjdCBhbmQgYWxsIGNoaWxkIGNvbnN0cnVjdHNcbiAqL1xuY2RrLlRhZ3Mub2YoY29uc3RydWN0KS5hZGQoJ3N0YWNrJywgJ0RqYW5nb0Vrc1N0YWNrJyk7XG5cbiJdfQ==