# generated by datamodel-codegen:
#   filename:  admin-api.json
#   timestamp: 2023-03-08T10:03:44+00:00

from __future__ import annotations

from typing import List, Optional

from pydantic import BaseModel, Field


class TenantToken(BaseModel):
    token: str = Field(
        ...,
        example="eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJzdWIiOiIxMjM0NTY3ODkwIiwibmFtZSI6IkpvaG4gRG9lIiwiaWF0IjoxNTE2MjM5MDIyfQ.SflKxwRJSMeKKF2QT4fwpMeJf36POk6yJV_adQssw5c",
    )


class TenantTokenRequest(BaseModel):
    lifeTimeSeconds: int = Field(..., example=7776000)


class TenantList(BaseModel):
    tenants: List[str] = Field(..., example=["tenant1", "tenant2"])


class TopicMapping(BaseModel):
    logicalTopicName: str = Field(..., example="logicalTopicName")
    physicalTopicName: str = Field(..., example="realTopic")
    readOnly: bool = Field(..., example=True)


class TopicMappingRequest(BaseModel):
    physicalTopicName: str = Field(..., example="realTopic")
    readOnly: bool = Field(..., example=True)


class TopicMappingRes(BaseModel):
    topics: Optional[List[TopicMapping]] = Field(
        None,
        example=[
            {
                "logicalTopicName": "topic1",
                "physicalTopicName": "realTopic",
                "readOnly": True,
            },
            {
                "logicalTopicName": "topic2",
                "physicalTopicName": "realTopic2",
                "readOnly": False,
            },
        ],
    )
