# -*- coding: utf-8 -*-
# Generated by Django 1.11.13 on 2018-05-12 12:00
from __future__ import unicode_literals

import django.contrib.postgres.fields.jsonb
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = []

    operations = [
        migrations.CreateModel(
            name='Dependency',
            fields=[
                (
                    'id',
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name='ID',
                    ),
                ),
                ('table', models.CharField(max_length=100)),
            ],
        ),
        migrations.CreateModel(
            name='Item',
            fields=[
                (
                    'id',
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name='ID',
                    ),
                ),
                ('primary_key', models.CharField(max_length=200)),
                ('order', models.IntegerField()),
                ('data', django.contrib.postgres.fields.jsonb.JSONField()),
            ],
            options={'ordering': ('observer', 'order')},
        ),
        migrations.CreateModel(
            name='Observer',
            fields=[
                (
                    'id',
                    models.CharField(max_length=64, primary_key=True, serialize=False),
                ),
                (
                    'status',
                    models.CharField(
                        choices=[
                            ('new', 'New'),
                            ('observing', 'Observing'),
                            ('stopped', 'Stopped'),
                        ],
                        default='new',
                        max_length=15,
                    ),
                ),
                ('request', models.BinaryField()),
                ('last_evaluation', models.DateTimeField(auto_now_add=True)),
                ('poll_interval', models.IntegerField(null=True)),
            ],
        ),
        migrations.CreateModel(
            name='Subscriber',
            fields=[
                (
                    'session_id',
                    models.CharField(max_length=100, primary_key=True, serialize=False),
                ),
                ('created', models.DateTimeField(auto_now_add=True)),
            ],
        ),
        migrations.AddField(
            model_name='observer',
            name='subscribers',
            field=models.ManyToManyField(to='rest_framework_reactive.Subscriber'),
        ),
        migrations.AddField(
            model_name='item',
            name='observer',
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name='items',
                to='rest_framework_reactive.Observer',
            ),
        ),
        migrations.AddField(
            model_name='dependency',
            name='observer',
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name='dependencies',
                to='rest_framework_reactive.Observer',
            ),
        ),
        migrations.AlterUniqueTogether(
            name='item',
            unique_together=set([('observer', 'primary_key'), ('observer', 'order')]),
        ),
        migrations.AlterUniqueTogether(
            name='dependency', unique_together=set([('observer', 'table')])
        ),
    ]
