"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.PDKPipelineJavaProject = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
const path = require("path");
const projen_1 = require("projen");
const awscdk_1 = require("projen/lib/awscdk");
/**
 * Synthesizes a Java Project with a CI/CD pipeline.
 *
 * @pjid pdk-pipeline-java
 */
class PDKPipelineJavaProject extends awscdk_1.AwsCdkJavaApp {
    constructor(options) {
        super({
            sample: false,
            junit: false,
            ...options,
            mainClass: options.mainClass !== "org.acme.MyApp"
                ? options.mainClass
                : 'software.aws.Pipeline -Dexec.classpathScope="test"',
        });
        this.addDependency("software.aws.awsprototypingsdk/aws-prototyping-sdk@^0");
        this.addDependency("io.github.cdklabs/cdknag@^2");
        this.testTask.exec("mvn test");
        this.addTestDependency("org.junit.jupiter/junit-jupiter-api@5.7.0");
        this.addTestDependency("org.junit.jupiter/junit-jupiter-engine@5.7.0");
        const mainPackage = this.mainClass
            .split(" ")[0]
            .split(".")
            .slice(0, -1)
            .join(".");
        new projen_1.SampleDir(this, path.join("src", "main", "java", ...mainPackage.split(".")), {
            sourceDir: path.join(__dirname, "..", "samples", "java", "src", "main", "java", "software", "aws"),
        });
        new projen_1.SampleDir(this, path.join("src", "test", "java", ...mainPackage.split(".")), {
            sourceDir: path.join(__dirname, "..", "samples", "java", "src", "test", "java", "software", "aws"),
        });
    }
}
exports.PDKPipelineJavaProject = PDKPipelineJavaProject;
_a = JSII_RTTI_SYMBOL_1;
PDKPipelineJavaProject[_a] = { fqn: "aws-prototyping-sdk.pipeline.PDKPipelineJavaProject", version: "0.12.28" };
//# sourceMappingURL=data:application/json;base64,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