"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Transliterator = void 0;
const aws_lambda_event_sources_1 = require("@aws-cdk/aws-lambda-event-sources");
const aws_s3_1 = require("@aws-cdk/aws-s3");
const core_1 = require("@aws-cdk/core");
const transliterator_1 = require("./transliterator");
class Transliterator extends core_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const lambda = new transliterator_1.Transliterator(this, 'Default', {
            deadLetterQueueEnabled: true,
            memorySize: 10240,
            retryAttempts: 2,
            timeout: core_1.Duration.minutes(15),
        });
        // The handler reads & writes to this bucket.
        props.sourceBucket.grantReadWrite(lambda);
        // Creating the event chaining
        lambda.addEventSource(new aws_lambda_event_sources_1.S3EventSource(props.sourceBucket, {
            events: [aws_s3_1.EventType.OBJECT_CREATED],
            filters: [{ prefix: 'packages/', suffix: '/package.tgz' }],
        }));
    }
}
exports.Transliterator = Transliterator;
//# sourceMappingURL=data:application/json;base64,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