"use strict";
/**
 *  Copyright 2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.DefaultCfnDomainProps = void 0;
const iam = require("aws-cdk-lib/aws-iam");
const cdk = require("aws-cdk-lib");
function DefaultCfnDomainProps(domainName, cognitoKibanaConfigureRole, props) {
    const roleARNs = [];
    roleARNs.push(new iam.ArnPrincipal(props.cognitoAuthorizedRoleARN));
    if (props.serviceRoleARN) {
        roleARNs.push(new iam.ArnPrincipal(props.serviceRoleARN));
    }
    return {
        domainName,
        elasticsearchVersion: '6.3',
        encryptionAtRestOptions: {
            enabled: true
        },
        nodeToNodeEncryptionOptions: {
            enabled: true
        },
        snapshotOptions: {
            automatedSnapshotStartHour: 1
        },
        ebsOptions: {
            ebsEnabled: true,
            volumeSize: 10
        },
        cognitoOptions: {
            enabled: true,
            identityPoolId: props.identitypool.ref,
            userPoolId: props.userpool.userPoolId,
            roleArn: cognitoKibanaConfigureRole.roleArn
        },
        accessPolicies: new iam.PolicyDocument({
            statements: [
                new iam.PolicyStatement({
                    principals: roleARNs,
                    actions: [
                        'es:ESHttp*'
                    ],
                    resources: [
                        `arn:aws:es:${cdk.Aws.REGION}:${cdk.Aws.ACCOUNT_ID}:domain/${domainName}/*`
                    ]
                })
            ]
        })
    };
}
exports.DefaultCfnDomainProps = DefaultCfnDomainProps;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZWxhc3RpY3NlYXJjaC1kZWZhdWx0cy5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbImVsYXN0aWNzZWFyY2gtZGVmYXVsdHMudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IjtBQUFBOzs7Ozs7Ozs7OztHQVdHOzs7QUFHSCwyQ0FBMkM7QUFDM0MsbUNBQW1DO0FBR25DLFNBQWdCLHFCQUFxQixDQUFDLFVBQWtCLEVBQUUsMEJBQW9DLEVBQUUsS0FBOEI7SUFFNUgsTUFBTSxRQUFRLEdBQXFCLEVBQUUsQ0FBQztJQUV0QyxRQUFRLENBQUMsSUFBSSxDQUFDLElBQUksR0FBRyxDQUFDLFlBQVksQ0FBQyxLQUFLLENBQUMsd0JBQXdCLENBQUMsQ0FBQyxDQUFDO0lBRXBFLElBQUksS0FBSyxDQUFDLGNBQWMsRUFBRTtRQUN4QixRQUFRLENBQUMsSUFBSSxDQUFDLElBQUksR0FBRyxDQUFDLFlBQVksQ0FBQyxLQUFLLENBQUMsY0FBYyxDQUFDLENBQUMsQ0FBQztLQUMzRDtJQUVELE9BQU87UUFDTCxVQUFVO1FBQ1Ysb0JBQW9CLEVBQUUsS0FBSztRQUMzQix1QkFBdUIsRUFBRTtZQUN2QixPQUFPLEVBQUUsSUFBSTtTQUNkO1FBQ0QsMkJBQTJCLEVBQUU7WUFDM0IsT0FBTyxFQUFFLElBQUk7U0FDZDtRQUNELGVBQWUsRUFBRTtZQUNmLDBCQUEwQixFQUFFLENBQUM7U0FDOUI7UUFDRCxVQUFVLEVBQUU7WUFDVixVQUFVLEVBQUUsSUFBSTtZQUNoQixVQUFVLEVBQUUsRUFBRTtTQUNmO1FBQ0QsY0FBYyxFQUFFO1lBQ2QsT0FBTyxFQUFFLElBQUk7WUFDYixjQUFjLEVBQUUsS0FBSyxDQUFDLFlBQVksQ0FBQyxHQUFHO1lBQ3RDLFVBQVUsRUFBRSxLQUFLLENBQUMsUUFBUSxDQUFDLFVBQVU7WUFDckMsT0FBTyxFQUFFLDBCQUEwQixDQUFDLE9BQU87U0FDNUM7UUFDRCxjQUFjLEVBQUUsSUFBSSxHQUFHLENBQUMsY0FBYyxDQUFDO1lBQ3JDLFVBQVUsRUFBRTtnQkFDVixJQUFJLEdBQUcsQ0FBQyxlQUFlLENBQUM7b0JBQ3RCLFVBQVUsRUFBRSxRQUFRO29CQUNwQixPQUFPLEVBQUU7d0JBQ1AsWUFBWTtxQkFDYjtvQkFDRCxTQUFTLEVBQUU7d0JBQ1QsY0FBYyxHQUFHLENBQUMsR0FBRyxDQUFDLE1BQU0sSUFBSSxHQUFHLENBQUMsR0FBRyxDQUFDLFVBQVUsV0FBVyxVQUFVLElBQUk7cUJBQzVFO2lCQUNGLENBQUM7YUFDSDtTQUNGLENBQUM7S0FDNkIsQ0FBQztBQUNwQyxDQUFDO0FBOUNELHNEQThDQyIsInNvdXJjZXNDb250ZW50IjpbIi8qKlxuICogIENvcHlyaWdodCAyMDIyIEFtYXpvbi5jb20sIEluYy4gb3IgaXRzIGFmZmlsaWF0ZXMuIEFsbCBSaWdodHMgUmVzZXJ2ZWQuXG4gKlxuICogIExpY2Vuc2VkIHVuZGVyIHRoZSBBcGFjaGUgTGljZW5zZSwgVmVyc2lvbiAyLjAgKHRoZSBcIkxpY2Vuc2VcIikuIFlvdSBtYXkgbm90IHVzZSB0aGlzIGZpbGUgZXhjZXB0IGluIGNvbXBsaWFuY2VcbiAqICB3aXRoIHRoZSBMaWNlbnNlLiBBIGNvcHkgb2YgdGhlIExpY2Vuc2UgaXMgbG9jYXRlZCBhdFxuICpcbiAqICAgICAgaHR0cDovL3d3dy5hcGFjaGUub3JnL2xpY2Vuc2VzL0xJQ0VOU0UtMi4wXG4gKlxuICogIG9yIGluIHRoZSAnbGljZW5zZScgZmlsZSBhY2NvbXBhbnlpbmcgdGhpcyBmaWxlLiBUaGlzIGZpbGUgaXMgZGlzdHJpYnV0ZWQgb24gYW4gJ0FTIElTJyBCQVNJUywgV0lUSE9VVCBXQVJSQU5USUVTXG4gKiAgT1IgQ09ORElUSU9OUyBPRiBBTlkgS0lORCwgZXhwcmVzcyBvciBpbXBsaWVkLiBTZWUgdGhlIExpY2Vuc2UgZm9yIHRoZSBzcGVjaWZpYyBsYW5ndWFnZSBnb3Zlcm5pbmcgcGVybWlzc2lvbnNcbiAqICBhbmQgbGltaXRhdGlvbnMgdW5kZXIgdGhlIExpY2Vuc2UuXG4gKi9cblxuaW1wb3J0ICogYXMgZWxhc3RpY3NlYXJjaCBmcm9tICdhd3MtY2RrLWxpYi9hd3MtZWxhc3RpY3NlYXJjaCc7XG5pbXBvcnQgKiBhcyBpYW0gZnJvbSAnYXdzLWNkay1saWIvYXdzLWlhbSc7XG5pbXBvcnQgKiBhcyBjZGsgZnJvbSAnYXdzLWNkay1saWInO1xuaW1wb3J0IHsgQnVpbGRFbGFzdGljU2VhcmNoUHJvcHMgfSBmcm9tICcuL2VsYXN0aWNzZWFyY2gtaGVscGVyJztcblxuZXhwb3J0IGZ1bmN0aW9uIERlZmF1bHRDZm5Eb21haW5Qcm9wcyhkb21haW5OYW1lOiBzdHJpbmcsIGNvZ25pdG9LaWJhbmFDb25maWd1cmVSb2xlOiBpYW0uUm9sZSwgcHJvcHM6IEJ1aWxkRWxhc3RpY1NlYXJjaFByb3BzKTpcbiAgZWxhc3RpY3NlYXJjaC5DZm5Eb21haW5Qcm9wcyB7XG4gIGNvbnN0IHJvbGVBUk5zOiBpYW0uSVByaW5jaXBhbFtdID0gW107XG5cbiAgcm9sZUFSTnMucHVzaChuZXcgaWFtLkFyblByaW5jaXBhbChwcm9wcy5jb2duaXRvQXV0aG9yaXplZFJvbGVBUk4pKTtcblxuICBpZiAocHJvcHMuc2VydmljZVJvbGVBUk4pIHtcbiAgICByb2xlQVJOcy5wdXNoKG5ldyBpYW0uQXJuUHJpbmNpcGFsKHByb3BzLnNlcnZpY2VSb2xlQVJOKSk7XG4gIH1cblxuICByZXR1cm4ge1xuICAgIGRvbWFpbk5hbWUsXG4gICAgZWxhc3RpY3NlYXJjaFZlcnNpb246ICc2LjMnLFxuICAgIGVuY3J5cHRpb25BdFJlc3RPcHRpb25zOiB7XG4gICAgICBlbmFibGVkOiB0cnVlXG4gICAgfSxcbiAgICBub2RlVG9Ob2RlRW5jcnlwdGlvbk9wdGlvbnM6IHtcbiAgICAgIGVuYWJsZWQ6IHRydWVcbiAgICB9LFxuICAgIHNuYXBzaG90T3B0aW9uczoge1xuICAgICAgYXV0b21hdGVkU25hcHNob3RTdGFydEhvdXI6IDFcbiAgICB9LFxuICAgIGVic09wdGlvbnM6IHtcbiAgICAgIGVic0VuYWJsZWQ6IHRydWUsXG4gICAgICB2b2x1bWVTaXplOiAxMFxuICAgIH0sXG4gICAgY29nbml0b09wdGlvbnM6IHtcbiAgICAgIGVuYWJsZWQ6IHRydWUsXG4gICAgICBpZGVudGl0eVBvb2xJZDogcHJvcHMuaWRlbnRpdHlwb29sLnJlZixcbiAgICAgIHVzZXJQb29sSWQ6IHByb3BzLnVzZXJwb29sLnVzZXJQb29sSWQsXG4gICAgICByb2xlQXJuOiBjb2duaXRvS2liYW5hQ29uZmlndXJlUm9sZS5yb2xlQXJuXG4gICAgfSxcbiAgICBhY2Nlc3NQb2xpY2llczogbmV3IGlhbS5Qb2xpY3lEb2N1bWVudCh7XG4gICAgICBzdGF0ZW1lbnRzOiBbXG4gICAgICAgIG5ldyBpYW0uUG9saWN5U3RhdGVtZW50KHtcbiAgICAgICAgICBwcmluY2lwYWxzOiByb2xlQVJOcyxcbiAgICAgICAgICBhY3Rpb25zOiBbXG4gICAgICAgICAgICAnZXM6RVNIdHRwKidcbiAgICAgICAgICBdLFxuICAgICAgICAgIHJlc291cmNlczogW1xuICAgICAgICAgICAgYGFybjphd3M6ZXM6JHtjZGsuQXdzLlJFR0lPTn06JHtjZGsuQXdzLkFDQ09VTlRfSUR9OmRvbWFpbi8ke2RvbWFpbk5hbWV9LypgXG4gICAgICAgICAgXVxuICAgICAgICB9KVxuICAgICAgXVxuICAgIH0pXG4gIH0gYXMgZWxhc3RpY3NlYXJjaC5DZm5Eb21haW5Qcm9wcztcbn0iXX0=