/**
 *  Copyright 2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
import * as elasticsearch from 'aws-cdk-lib/aws-elasticsearch';
import * as iam from 'aws-cdk-lib/aws-iam';
import * as cloudwatch from 'aws-cdk-lib/aws-cloudwatch';
import * as cognito from 'aws-cdk-lib/aws-cognito';
import * as ec2 from 'aws-cdk-lib/aws-ec2';
import { Construct } from 'constructs';
export interface BuildElasticSearchProps {
    readonly identitypool: cognito.CfnIdentityPool;
    readonly userpool: cognito.UserPool;
    readonly cognitoAuthorizedRoleARN: string;
    readonly serviceRoleARN?: string;
    readonly vpc?: ec2.IVpc;
    readonly domainName: string;
    readonly clientDomainProps?: elasticsearch.CfnDomainProps;
    readonly securityGroupIds?: string[];
}
export declare function buildElasticSearch(scope: Construct, props: BuildElasticSearchProps): [elasticsearch.CfnDomain, iam.Role];
export declare function buildElasticSearchCWAlarms(scope: Construct): cloudwatch.Alarm[];
