/**
 *  Copyright 2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
import * as ec2 from "aws-cdk-lib/aws-ec2";
import * as ecs from "aws-cdk-lib/aws-ecs";
import * as elb from "aws-cdk-lib/aws-elasticloadbalancingv2";
export declare function DefaultClusterProps(): {};
export declare function DefaultFargateServiceProps(): {
    assignPublicIp: boolean;
    desiredCount: number;
    maxHealthyPercent: number;
    minHealthyPercent: number;
    platformVersion: ecs.FargatePlatformVersion;
};
export declare function DefaultFargateTaskDefinitionProps(): ecs.FargateTaskDefinitionProps;
export declare function DefaultApplicationTargetGroupProps(vpc: ec2.IVpc): elb.ApplicationTargetGroupProps;
export declare function DefaultContainerDefinitionProps(): ecs.ContainerDefinitionOptions | any;
