"use strict";
/**
 *  Copyright 2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.DefaultGlueJobProps = void 0;
function DefaultGlueJobProps(jobRole, userProvidedGlueJobProps, glueSecurityConfigName, defaultArguments, etlCodeAsset) {
    const glueVersion = userProvidedGlueJobProps.glueVersion;
    // setting default to 2 to reduce cost
    const maxCapacity = glueVersion === "1.0" && !(userProvidedGlueJobProps.workerType
        || userProvidedGlueJobProps.numberOfWorkers) ? 2 : undefined;
    if (etlCodeAsset) {
        userProvidedGlueJobProps.command.scriptLocation = etlCodeAsset.s3ObjectUrl;
    }
    const defaultGlueJobProps = {
        command: userProvidedGlueJobProps.command,
        role: jobRole.roleArn,
        securityConfiguration: glueSecurityConfigName,
        defaultArguments,
        maxCapacity,
        numberOfWorkers: (!glueVersion || glueVersion === "2.0") ? 2 : undefined,
        workerType: (!glueVersion || glueVersion === "2.0") ? 'G.1X' : undefined,
        // glue version though optional is required for streaming etl jobs otherwise it throws an error that 'command not found'
        glueVersion: glueVersion ? glueVersion : '2.0'
    };
    return defaultGlueJobProps;
}
exports.DefaultGlueJobProps = DefaultGlueJobProps;
//# sourceMappingURL=data:application/json;base64,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