"use strict";
/**
 *  Copyright 2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
require("@aws-cdk/assert/jest");
const elasticache_defaults_1 = require("../lib/elasticache-defaults");
test("Test GetDefaultCachePort()", () => {
    const defaultPort = elasticache_defaults_1.GetDefaultCachePort();
    expect(defaultPort).toEqual(11222);
});
test("Test GetMemcachedDefaults()", () => {
    const testPort = 22222;
    const testId = 'test';
    const props = elasticache_defaults_1.GetMemcachedDefaults(testId, testPort);
    expect(props.port).toEqual(testPort);
    expect(props.clusterName).toEqual(`${testId}-cdk-cluster`);
    expect(props.engine).toEqual("memcached");
    expect(props.cacheNodeType).toEqual("cache.t3.medium");
    expect(props.numCacheNodes).toEqual(2);
    expect(props.azMode).toEqual('cross-az');
});
//# sourceMappingURL=data:application/json;base64,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