"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.RepositoryVisibility = exports.GitHubRepository = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk = require("aws-cdk-lib");
const codestar = require("aws-cdk-lib/aws-codestar");
/**
 * The GitHubRepository resource
 */
class GitHubRepository extends cdk.Resource {
    constructor(scope, id, props) {
        super(scope, id);
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_codestar_alpha_GitHubRepositoryProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, GitHubRepository);
            }
            throw error;
        }
        const resource = new codestar.CfnGitHubRepository(this, 'Resource', {
            repositoryOwner: props.owner,
            repositoryName: props.repositoryName,
            repositoryAccessToken: props.accessToken.unsafeUnwrap(),
            code: {
                s3: {
                    bucket: props.contentsBucket.bucketName,
                    key: props.contentsKey,
                    objectVersion: props.contentsS3Version,
                },
            },
            enableIssues: props.enableIssues ?? true,
            isPrivate: props.visibility === RepositoryVisibility.PRIVATE ? true : false,
            repositoryDescription: props.description,
        });
        this.owner = cdk.Fn.select(0, cdk.Fn.split('/', resource.ref));
        this.repo = cdk.Fn.select(1, cdk.Fn.split('/', resource.ref));
    }
}
exports.GitHubRepository = GitHubRepository;
_a = JSII_RTTI_SYMBOL_1;
GitHubRepository[_a] = { fqn: "@aws-cdk/aws-codestar-alpha.GitHubRepository", version: "2.56.0-alpha.0" };
/**
 * Visibility of the GitHubRepository
 */
var RepositoryVisibility;
(function (RepositoryVisibility) {
    /**
     * private repository
     */
    RepositoryVisibility[RepositoryVisibility["PRIVATE"] = 0] = "PRIVATE";
    /**
     * public repository
     */
    RepositoryVisibility[RepositoryVisibility["PUBLIC"] = 1] = "PUBLIC";
})(RepositoryVisibility = exports.RepositoryVisibility || (exports.RepositoryVisibility = {}));
//# sourceMappingURL=data:application/json;base64,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