"use strict";
/*********************************************************************************************************************
 Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.

 Licensed under the Apache License, Version 2.0 (the "License").
 You may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 ******************************************************************************************************************** */
Object.defineProperty(exports, "__esModule", { value: true });
const render_options_1 = require("projen/lib/javascript/render-options");
const synth_1 = require("projen/lib/util/synth");
const src_1 = require("../src");
describe("PDK Pipeline Java Unit Tests", () => {
    it("Defaults", () => {
        const project = new src_1.PDKPipelineJavaProject({
            artifactId: "test",
            cdkVersion: "2.0.0",
            groupId: "test",
            mainClass: "software.aws.Pipeline",
            version: "0.0.0",
            name: "Defaults",
        });
        expect(synth_1.synthSnapshot(project)).toMatchSnapshot();
    });
    it("projenrc synth correctly", () => {
        const project = new src_1.PDKPipelineJavaProject(render_options_1.renderProjenInitOptions("@aws-prototyping-sdk/pipeline.PDKPipelineJavaProject", {
            artifactId: "test",
            cdkVersion: "2.0.0",
            groupId: "test",
            mainClass: "software.aws.Pipeline",
            version: "0.0.0",
            name: "ProjenRc",
        }));
        expect(synth_1.synthSnapshot(project)["src/test/java/projenrc.java"]).toMatchSnapshot();
    });
    it("With Context", () => {
        const project = new src_1.PDKPipelineJavaProject({
            artifactId: "test",
            cdkVersion: "2.0.0",
            groupId: "test",
            mainClass: "software.aws.Pipeline",
            version: "0.0.0",
            name: "WithContext",
            context: {
                sonarqubeScannerConfig: {
                    sonarqubeEndpoint: "https://my.endpoint",
                    sonarqubeAuthorizedGroup: "group",
                    sonarqubeDefaultProfileOrGateName: "default",
                    sonarqubeSpecificProfileOrGateName: "specific",
                    sonarqubeProjectName: "WithContext",
                    sonarqubeTags: ["sample"],
                    preArchiveCommands: ["echo here"],
                },
            },
        });
        expect(synth_1.synthSnapshot(project)).toMatchSnapshot();
    });
});
//# sourceMappingURL=data:application/json;base64,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